<?php
@header("Content-type: text/html; charset=utf-8");
require_once(dirname(__FILE__) . '/../common/db.class.php');
require_once(dirname(__FILE__) . '/../common/function.php');
require_once(dirname(__FILE__) .DIRECTORY_SEPARATOR.'..'.DIRECTORY_SEPARATOR.'common'.DIRECTORY_SEPARATOR.'CacheFactory.php');
// require_once(dirname(__FILE__) .DIRECTORY_SEPARATOR.'..'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'pashu_model.php');
require_once('../common/session_helper.php');
$action=$_GET['action'];
switch ($action){
	case 'getconfig':
		getconfig();
		break;
	case 'saveconfig':
		saveconfig();
		break;
	case 'delitem':
		delitem();
		break;
	case 'clearpashu':
		clearpashu();
		break;
}
function delitem(){
	$id=isset($_POST['id'])?intval($_POST['id']):0;
	if($id<=0){
		$returndata=array('code'=>-1,'message'=>"无数据");
		echo json_encode($returndata);
		return;
	}
	$load=Loader::getInstance();
	$load->model('Pashu_model');
	$load->pashu_model->deletePashu($id);
	
	$returndata=array('code'=>1,'message'=>"删除成功");
	echo json_encode($returndata);
}

function clearpashu(){
	$id=isset($_POST['id'])?intval($_POST['id']):0;
	if($id<=0){
		$returndata=array('code'=>-1,'message'=>"无数据");
		echo json_encode($returndata);
		return;
	}

	$load=Loader::getInstance();
	$load->model('Pashu_model');
	$load->pashu_model->resetPashu($id);

	$returndata=array('code'=>1,'message'=>"重置成功");
	echo json_encode($returndata);
}

function getconfig(){
	$id=isset($_POST['id'])?intval($_POST['id']):0;
	if($id<=0){
		$returndata=array('code'=>-1,'message'=>"无数据");
		echo json_encode($returndata);
		return;
	}
	$load=Loader::getInstance();
	$load->model('Pashu_model');
	$pashu_config=$load->pashu_model->getConfig($id);
	$returndata=array('code'=>1,"message"=>"","data"=>$pashu_config);
	echo json_encode($returndata);
	return;
}

function saveconfig(){
	$id=isset($_POST['id'])?intval($_POST['id']):0;

	$times=isset($_POST['times'])?intval($_POST['times']):30;
	$toprank=isset($_POST['toprank'])?intval($_POST['toprank']):3;
	$status=isset($_POST['status'])?intval($_POST['status']):1;
	$winningagain=isset($_POST['winningagain'])?intval($_POST['winningagain']):1;
	$showstyle=isset($_POST['showstyle'])?intval($_POST['showstyle']):1;

	if($times<=0){
		$returndata=array('code'=>-2,'message'=>"持续时间必须大于0");
		echo json_encode($returndata);
		return;
	}

	if($toprank<=0){
		$returndata=array('code'=>-2,'message'=>"前几名设置必须大于0");
		echo json_encode($returndata);
		return;
	}
	if($toprank>100){
		$returndata=array('code'=>-6,'message'=>"前几名设置必须大于100");
		echo json_encode($returndata);
		return;
	}
	if($status<=0){
		$returndata=array('code'=>-3,'message'=>"状态错误");
		echo json_encode($returndata);
		return;
	}

	if($showstyle<=0){
		$returndata=array('code'=>-5,'message'=>"显示类型错误");
		echo json_encode($returndata);
		return;
	}
	$load=Loader::getInstance();
	$load->model('Pashu_model');
	if($id>0){
		$pashu_config['id']=$id;
		$code=2;
		$message='修改';
	}else{
		$code=1;
		$message='添加';
	}
	$pashu_config['times']=$times;
	$pashu_config['toprank']=$toprank;
	$pashu_config['status']=$status;
	$pashu_config['winningagain']=$winningagain;
	$pashu_config['showstyle']=$showstyle;
	$result=$load->pashu_model->setConfig($pashu_config);
	if($result){
		echo returnmsg($code,$message.'成功');
		return;
	}
	echo returnmsg($code,$message.'失败');
	return;

}