<?php
@header("Content-type: text/html; charset=utf-8");
require_once(dirname(__FILE__) . '/../common/db.class.php');
require_once(dirname(__FILE__) . '/../common/function.php');
require_once(dirname(__FILE__) . '/../common/CacheFactory.php');
require_once('../common/session_helper.php');
$action=$_GET['action'];
switch ($action){
    case 'getconfig':
        getconfig();
        break;
    case 'saveconfig':
        saveconfig();
        break;
    case 'delitem':
        delitem();
        break;
    case 'clearshake':
        clearshake();
        break;
}

//
function getconfig(){
    $id=isset($_POST['id'])?intval($_POST['id']):0;
    if($id<=0){
        $returndata=array('code'=>-1,'message'=>"无数据");
        echo json_encode($returndata);
        return;
    }
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $shake_config=$load->shake_model->getConfig($id);
    $returndata=array('code'=>1,"message"=>"","data"=>$shake_config);
    echo json_encode($returndata);
    return;
}

function delitem(){
    $id=isset($_POST['id'])?intval($_POST['id']):0;
    if($id<=0){
        $returndata=array('code'=>-1,'message'=>"无数据");
        echo json_encode($returndata);
        return;
    }
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $load->shake_model->deleteShake($id);
    
    $returndata=array('code'=>1,'message'=>"删除成功");
    echo json_encode($returndata);
}

function clearshake(){
    $id=isset($_POST['id'])?intval($_POST['id']):0;
    if($id<=0){
        $returndata=array('code'=>-1,'message'=>"无数据");
        echo json_encode($returndata);
        return;
    }

    $load=Loader::getInstance();
    $load->model('Shake_model');
    $load->shake_model->resetShake($id);

    $returndata=array('code'=>1,'message'=>"重置成功");
    echo json_encode($returndata);
}

//保存配置文件
function saveconfig(){
    $id=isset($_POST['id'])?intval($_POST['id']):0;
    $durationtype=isset($_POST['durationtype'])?intval($_POST['durationtype']):1;
    $duration=isset($_POST['duration'])?intval($_POST['duration']):30;
    $toprank=isset($_POST['toprank'])?intval($_POST['toprank']):3;
    $status=isset($_POST['status'])?intval($_POST['status']):1;
    $winningagain=isset($_POST['winningagain'])?intval($_POST['winningagain']):1;
    $showstyle=isset($_POST['showstyle'])?intval($_POST['showstyle']):1;
    $themeid=isset($_POST['themeid'])?intval($_POST['themeid']):1;

    $durationtype=$durationtype==1?1:2;

    if($duration<=0){
        $returndata=array('code'=>-2,'message'=>"持续时间必须大于0");
        echo json_encode($returndata);
        return;
    }

    if($toprank<=0){
        $returndata=array('code'=>-2,'message'=>"前几名设置必须大于0");
        echo json_encode($returndata);
        return;
    }
    if($toprank>100){
        $returndata=array('code'=>-6,'message'=>"前几名设置必须大于100");
        echo json_encode($returndata);
        return;
    }
    if($status<=0){
        $returndata=array('code'=>-3,'message'=>"状态错误");
        echo json_encode($returndata);
        return;
    }

    if($showstyle<=0){
        $returndata=array('code'=>-5,'message'=>"显示类型错误");
        echo json_encode($returndata);
        return;
    }

    if($themeid<=0){
        $returndata=array('code'=>-7,'message'=>"主题错误");
        echo json_encode($returndata);
        return;
    }

    $load=Loader::getInstance();
    $load->model('Shake_model');
    if($id>0){
        $shake_config['id']=$id;
        $code=2;
        $message='修改';
    }else{
        $code=1;
        $message='添加';
    }

    $shake_config['durationtype']=$durationtype;
    $shake_config['duration']=$duration;
    $shake_config['toprank']=$toprank;
    $shake_config['status']=$status;
    $shake_config['winningagain']=$winningagain;
    $shake_config['showstyle']=$showstyle;
    $shake_config['themeid']=$themeid;
    $result=$load->shake_model->setConfig($shake_config);

    if($result){
        echo returnmsg($code,$message.'成功');
        return;
    }
    echo returnmsg($code,$message.'失败');
    return;

}