<?php
/**
 * 现场活动大屏幕系统设置主题
 * PHP version 5.4+
 * 
 * @category Myadmin
 * 
 * @package Shake
 * 
 * @author fy <jhfangying@qq.com>
 * 
 * @license Copyright (c) 2017 金华迪加网络科技有限公司 版权所有
 * Copyright (c) 2017 金华迪加网络科技有限公司 版权所有
 * 未经许可，任何单位及个人不得做营利性使用
 * 
 * @link link('演示地址','http://xc.taobaodpm.com');
 * */
@header("Content-type: text/html; charset=utf-8");
require_once dirname(__FILE__) . '/../common/db.class.php';
require_once dirname(__FILE__) . '/../common/CacheFactory.php';
require_once '../common/session_helper.php';
$action=$_GET['action'];
switch ($action){
case 'themename':
    setthemename();
    break;
case 'horizontal':
    sethorizontal();
    break;
case 'tips':
    settips();
    break;
case 'avatar':
    setavatar();
    break;
case 'startline':
    setstartline();
    break;
case 'endline':
    setendline();
    break;
case 'trackodd':
    settrackodd();
    break;
case 'trackeven':
    settrackeven();
    break;
case 'bg':
    setbg();
    break;
case 'mobileimg':
    setmobileimg();
    break;
}
/**
 * 设置手机图片
 * 
 * @return text 返回结果的json数据
 */
function setmobileimg()
{
    $id=isset($_POST['id'])?intval($_POST['id']):0;
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $themeinfo=array();
    if ($id>0) {
        $themeinfo=$load->shake_model->getThemeById($id);
    }
    $file=$_FILES['mobileimg'];
    $attachmentid=uploadfile($file);
    $themeinfo['themedata']['mobileimg']=$attachmentid;
    $data=$load->shake_model->saveTheme($themeinfo);
    if ($data['id']>0) {
        $returndata=array('code'=>1,'msg'=>"保存成功",'data'=>$data);
        echo json_encode($returndata);
        return;
    } else {
        $returndata=array('code'=>-1,'msg'=>"保存失败");
        echo json_encode($returndata);
        return;
    }
}
/**
 * 设置主题背景
 * 
 * @return text 返回结果的json数据
 */
function setbg()
{
    $id=isset($_POST['themeid'])?intval($_POST['themeid']):0;
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $themeinfo=array();
    if ($id>0) {
        $themeinfo=$load->shake_model->getThemeById($id);
    }
    $file=$_FILES['file'];
    $allowtypes='image/jpg,image/jpeg,image/png,video/mp4';
    $attachmentid=uploadfile($file, $allowtypes);
    $themeinfo['themedata']['bg']=$attachmentid;
    $data=$load->shake_model->saveTheme($themeinfo);
    if ($data['id']>0) {
        $returndata=array('code'=>1,'msg'=>"保存成功",'data'=>$data);
        echo json_encode($returndata);
        return;
    } else {
        $returndata=array('code'=>-1,'msg'=>"保存失败");
        echo json_encode($returndata);
        return;
    }
}

/**
 * 设置起点线
 * 
 * @return text 返回结果的json数据
 */
function setstartline()
{
    $id=isset($_POST['id'])?intval($_POST['id']):0;
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $themeinfo=array();
    if ($id>0) {
        $themeinfo=$load->shake_model->getThemeById($id);
    }
    $file=$_FILES['startline'];
    $attachmentid=uploadfile($file);

    $themeinfo['themedata']['startline']=$attachmentid;
    $data=$load->shake_model->saveTheme($themeinfo);
    if ($data['id']>0) {
        $returndata=array('code'=>1,'msg'=>"保存成功",'data'=>$data);
        echo json_encode($returndata);
        return;
    } else {
        $returndata=array('code'=>-1,'msg'=>"保存失败");
        echo json_encode($returndata);
        return;
    }
}
/**
 * 设置终点线
 * 
 * @return text 返回结果的json数据
 */
function setendline()
{
    $id=isset($_POST['id'])?intval($_POST['id']):0;
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $themeinfo=array();
    if ($id>0) {
        $themeinfo=$load->shake_model->getThemeById($id);
    }
    $file=$_FILES['endline'];
    $attachmentid=uploadfile($file);
    $themeinfo['themedata']['endline']=$attachmentid;
    $data=$load->shake_model->saveTheme($themeinfo);
    if ($data['id']>0) {
        $returndata=array('code'=>1,'msg'=>"保存成功",'data'=>$data);
        echo json_encode($returndata);
        return;
    } else {
        $returndata=array('code'=>-1,'msg'=>"保存失败");
        echo json_encode($returndata);
        return;
    }
}
/**
 * 设置奇数跑道图
 * 
 * @return text 返回结果的json数据
 */
function settrackodd()
{
    $id=isset($_POST['id'])?intval($_POST['id']):0;
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $themeinfo=array();
    if ($id>0) {
        $themeinfo=$load->shake_model->getThemeById($id);
    }
    $file=$_FILES['trackodd'];
    $attachmentid=uploadfile($file);
    $themeinfo['themedata']['trackodd']=$attachmentid;
    $data=$load->shake_model->saveTheme($themeinfo);
    if ($data['id']>0) {
        $returndata=array('code'=>1,'msg'=>"保存成功",'data'=>$data);
        echo json_encode($returndata);
        return;
    } else {
        $returndata=array('code'=>-1,'msg'=>"保存失败");
        echo json_encode($returndata);
        return;
    }
}
/**
 * 设置偶数跑道图
 * 
 * @return text 返回结果的json数据
 */
function settrackeven()
{
    $id=isset($_POST['id'])?intval($_POST['id']):0;
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $themeinfo=array();
    if ($id>0) {
        $themeinfo=$load->shake_model->getThemeById($id);
    }
    $file=$_FILES['trackeven'];
    $attachmentid=uploadfile($file);
    $themeinfo['themedata']['trackeven']=$attachmentid;
    $data=$load->shake_model->saveTheme($themeinfo);
    if ($data['id']>0) {
        $returndata=array('code'=>1,'msg'=>"保存成功",'data'=>$data);
        echo json_encode($returndata);
        return;
    } else {
        $returndata=array('code'=>-1,'msg'=>"保存失败");
        echo json_encode($returndata);
        return;
    }
}

/**
 * 设置人物图
 * 
 * @return text 返回结果的json数据
 */
function setavatar()
{
    $id=isset($_POST['id'])?intval($_POST['id']):0;
    $avatar_index=isset($_POST['avatar_index'])?strval($_POST['avatar_index']):'';
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $themeinfo=array();
    if ($id>0) {
        $themeinfo=$load->shake_model->getThemeById($id);
    }
    $file=$_FILES[$avatar_index];
    $attachmentid=uploadfile($file);
    $themeinfo['themedata'][$avatar_index]=$attachmentid;
    $data=$load->shake_model->saveTheme($themeinfo);
    if ($data['id']>0) {
        $returndata=array('code'=>1,'msg'=>"保存成功",'data'=>$data);
        echo json_encode($returndata);
        return;
    } else {
        $returndata=array('code'=>-1,'msg'=>"保存失败");
        echo json_encode($returndata);
        return;
    }
}


/**
 * 上传文件
 * 
 * @param file $file       上传的文件
 * @param text $allowtypes 可以上传的文件的mimetype类型
 * 
 * @return mixed 失败返回false，成功返回id
 */
function uploadfile($file,$allowtypes='image/jpg,image/jpeg,image/png,image/gif')
{
    if (!empty($file['type'])) {
        //上传的文件
        $load=Loader::getInstance();
        $load->model('Attachment_model');
        $savedfile=$load->attachment_model->saveFormFile($file, $allowtypes);
        if ($savedfile) {
            return $savedfile['id'];
        }
    }
    return 0;
}



/**
 * 设置页面上的提示
 * 
 * @return text 返回结果的json数据
 */
function settips()
{
    $id=isset($_POST['id'])?intval($_POST['id']):0;
    $tips=isset($_POST['tips'])?strval($_POST['tips']):'';
    $tips_arr=array();
    if (!empty($tips)) {
        $tips_arr=explode("\n", $tips);
    }

    foreach ($tips_arr as $k=>$v) {
        $tips_arr[$k]=trim($v);
    }

    $load=Loader::getInstance();
    $load->model('Shake_model');
    $themeinfo=array();
    if ($id>0) {
        $themeinfo=$load->shake_model->getThemeById($id);
    }
    $themeinfo['themedata']['tips']=$tips_arr;
    $data=$load->shake_model->saveTheme($themeinfo);
    if ($data['id']>0) {
        $returndata=array('code'=>1,'msg'=>"保存成功",'data'=>$data);
        echo json_encode($returndata);
        return;
    } else {
        $returndata=array('code'=>-1,'msg'=>"保存失败");
        echo json_encode($returndata);
        return;
    }

}
/**
 * 设置摇一摇是横向还是纵向
 * 
 * @return text 返回结果的json数据
 */
function sethorizontal()
{
    $id=isset($_POST['id'])?intval($_POST['id']):0;
    $ishorizontal=isset($_POST['ishorizontal'])?strval($_POST['ishorizontal']):'';
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $themeinfo=array();
    if ($id>0) {
        $themeinfo=$load->shake_model->getThemeById($id);
    }
    $themeinfo['themedata']['ishorizontal']=$ishorizontal;
    $data=$load->shake_model->saveTheme($themeinfo);
    if ($data['id']>0) {
        $returndata=array('code'=>1,'msg'=>"保存成功",'data'=>$data);
        echo json_encode($returndata);
        return;
    } else {
        $returndata=array('code'=>-1,'msg'=>"保存失败");
        echo json_encode($returndata);
        return;
    }
}

/**
 * 设置主题名称
 * 
 * @return text 返回结果的json数据
 */
function setthemename()
{
    $id=isset($_POST['id'])?intval($_POST['id']):0;
    $themename=isset($_POST['themename'])?strval($_POST['themename']):'';
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $themeinfo=array();
    if ($id>0) {
        $themeinfo=$load->shake_model->getThemeById($id);
    }
    $themeinfo['themename']=$themename;
    $data=$load->shake_model->saveTheme($themeinfo);
    if ($data['id']>0) {
        $returndata=array('code'=>1,'msg'=>"保存成功",'data'=>$data);
        echo json_encode($returndata);
        return;
    } else {
        $returndata=array('code'=>-1,'msg'=>"保存失败");
        echo json_encode($returndata);
        return;
    }
}


