<?php
@header("Content-type: text/html; charset=utf-8");
require_once(dirname(__FILE__) . '/../common/db.class.php');
require_once(dirname(__FILE__) .DIRECTORY_SEPARATOR.'..'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'shuqian_model.php');
require_once('../common/session_helper.php');
$action=$_GET['action'];
switch ($action){
	case 'getconfig':
		getconfig();
		break;
	case 'saveconfig':
		saveconfig();
		break;
	case 'delitem':
		delitem();
		break;
	case 'clearshuqian':
		clearshuqian();
		break;
}
function delitem(){
	$id=isset($_POST['id'])?intval($_POST['id']):0;
	if($id<=0){
		$returndata=array('code'=>-1,'message'=>"无数据");
		echo json_encode($returndata);
		return;
	}
	$shuqian_model=new Shuqian_model();
	$shuqian_model->deleteShuqian($id);
	
	$returndata=array('code'=>1,'message'=>"删除成功");
	echo json_encode($returndata);
}

function clearshuqian(){
	$id=isset($_POST['id'])?intval($_POST['id']):0;
	if($id<=0){
		$returndata=array('code'=>-1,'message'=>"无数据");
		echo json_encode($returndata);
		return;
	}

	$shuqian_model=new Shuqian_model();
	$shuqian_model->resetShuqian($id);

	$returndata=array('code'=>1,'message'=>"重置成功");
	echo json_encode($returndata);
}

function getconfig(){
	$id=isset($_POST['id'])?intval($_POST['id']):0;
	if($id<=0){
		$returndata=array('code'=>-1,'message'=>"无数据");
		echo json_encode($returndata);
		return;
	}
	$shuqian_model=new Shuqian_model();
	$shuqian_config=$shuqian_model->getConfig($id);
	$returndata=array('code'=>1,"message"=>"","data"=>$shuqian_config);
	echo json_encode($returndata);
	return;
}

function saveconfig(){
	$id=isset($_POST['id'])?intval($_POST['id']):0;

	$duration=isset($_POST['duration'])?intval($_POST['duration']):30;
	$toprank=isset($_POST['toprank'])?intval($_POST['toprank']):3;
	$status=isset($_POST['status'])?intval($_POST['status']):1;
	$winningagain=isset($_POST['winningagain'])?intval($_POST['winningagain']):1;
	$showstyle=isset($_POST['showstyle'])?intval($_POST['showstyle']):1;

	if($duration<=0){
		$returndata=array('code'=>-2,'message'=>"持续时间必须大于0");
		echo json_encode($returndata);
		return;
	}

	if($toprank<=0){
		$returndata=array('code'=>-2,'message'=>"前几名设置必须大于0");
		echo json_encode($returndata);
		return;
	}
	if($toprank>100){
		$returndata=array('code'=>-6,'message'=>"前几名设置必须大于100");
		echo json_encode($returndata);
		return;
	}
	if($status<=0){
		$returndata=array('code'=>-3,'message'=>"状态错误");
		echo json_encode($returndata);
		return;
	}

	if($showstyle<=0){
		$returndata=array('code'=>-5,'message'=>"显示类型错误");
		echo json_encode($returndata);
		return;
	}

	$shuqian_config_m=new M('shuqian_config');
	if($id>0){
		$shuqian_config=$shuqian_config_m->find('id='.$id);
		$shuqian_config['duration']=$duration;
		$shuqian_config['toprank']=$toprank;
		$shuqian_config['status']=$status;
	
		$shuqian_config['winningagain']=$winningagain;
		$shuqian_config['showstyle']=$showstyle;
		unset($shuqian_config['id']);
		$shuqian_config_m->update('id='.$id,$shuqian_config);
		$returndata=array('code'=>2,'message'=>"修改成功");
		echo json_encode($returndata);
		return;
	}else{
		$vote_config=array();
		$shuqian_config['duration']=$duration;
		$shuqian_config['toprank']=$toprank;
		$shuqian_config['status']=$status;
	
		$shuqian_config['winningagain']=$winningagain;
		$shuqian_config['showstyle']=$showstyle;
		$return=$shuqian_config_m->add($shuqian_config);
		$returndata=array('code'=>1,'message'=>"添加成功");
		echo json_encode($returndata);
		return;
	}
}