<?php
require_once(dirname(__FILE__) . '/../common/db.class.php');
require_once(dirname(__FILE__) . '/../common/CacheFactory.php');
// require_once(dirname(__FILE__) . '/../common/http_helper.php');
include('biaoqing.php');
$action = $_GET['action'];
$load->model('Wall_model');
$wall_config=$load->wall_model->getConfig();

switch($action){
	case 'reset':
		gamereset();
		break;
	case 'ready':
		gameready();
		break;
	case 'ok':
		gameok();
		break;
}
function gamereset(){
	$awardid=isset($_POST['awardid'])?intval($_POST['awardid']):0;
	$from=isset($_POST['from'])?strval($_POST['from']):'';
	if($awardid==0){
		$returndata=array('ret'=>-2,"message"=>'奖品信息错误');
		echo json_encode($returndata);
		return;
	}
	if($from!=''){
		$from_where=" and fromplug='".$from."'";
	}
	$load=Loader::getInstance();
	$load->model('Lottery_model');
	$load->lottery_model->deleteZjrecord($from,$awardid);
	$returndata=array('ret'=>1,"message"=>'获奖信息重置成功');
	echo json_encode($returndata);
	return;
}

function gameready(){
	$awardid=isset($_GET['awardid'])?intval($_GET['awardid']):0;
	$from=isset($_GET['from'])?strval($_GET['from']):'cj';
	if($awardid<=0){
		$returndata=array('ret'=>-1,"message"=>'请选择一个奖品再进行抽奖');
		echo json_encode($returndata);
		return;
	}
	$pagesize=100;
	$load=Loader::getInstance();
	$load->model('Lottery_model');
	//参与抽奖的人数
	//参与滚动的用户看列表
	$view_cjpersonlist=$load->lottery_model->getCjUserlist();

	$flagcount=$load->lottery_model->getUserCount($from,$awardid);

	//获取昵称显示方式
	$load->model('System_Config_model');
	$showtype_array=array('cj'=>'cjshowtype','cjx'=>'cjxshowtype','zjd'=>'zjdshowtype','threedimensionallottery'=>'threedimensionallotteryshowtype');
	$showtype=$load->system_config_model->get($showtype_array[$from]);

	foreach($view_cjpersonlist as $row1){
		$nickname=processNickname($row1,$showtype['configvalue']);
		$arr[] = array(
				'openid' => $row1['openid'],
				'avatar' => $row1['avatar'],
				'nick_name' => $nickname,
		);
	}

	//当前抽奖类型下奖项的中奖名单
	$view_zjlist=$load->lottery_model->getZjUserlist($from,$awardid); 
	foreach($view_zjlist as $row1){
		$nickname=processNickname($row1,$showtype['configvalue']);
		$zjlistarr[] = array(
				'openid'=>$row1['openid'],
				'avatar' => $row1['avatar'],
				'nick_name' => $nickname,
		);
	}
	$result_arr=array('count'=>$flagcount,'data'=>$arr,'luckuser'=>$zjlistarr,'ret'=>0);
	echo json_encode($result_arr);
	exit();
}

//得奖人
function gameok(){
	$awardid=isset($_POST['awardid'])?intval($_POST['awardid']):0;
	$from=isset($_POST['from'])?strval($_POST['from']):'cj';
	if($awardid<=0){
		$returndata=array('ret'=>-2,"message"=>'奖品信息错误');
		echo json_encode($returndata);
		return;
	}
	$load=Loader::getInstance();
	$load->model('Lottery_model');
	//随机取一个openid
	$zjuseropenid=$load->lottery_model->getRandZjUserOpenid($from,$awardid);
	//设置这个openid对应的用户为中奖用户
	$load->lottery_model->setZjUser($zjuseropenid,$from,$awardid);
	//读取中奖用户信息
	$zjuserinfo=$load->lottery_model->getZjUser($zjuseropenid,$from,$awardid);
	//当前抽奖类型的用户信息显示方式
	$showtype_array=array('cj'=>'cjshowtype','cjx'=>'cjxshowtype','zjd'=>'zjdshowtype','threedimensionallottery'=>'threedimensionallotteryshowtype');
	$load->model('System_Config_model');
	$showtype=$load->system_config_model->get($showtype_array[$from]);
	$zjuserinfo['nick_name']=processNickname($zjuserinfo,$showtype['configvalue']);

	if($zjuserinfo){
		$returndata=array("ret"=>1,"message"=>"抽奖操作成功","data"=>$zjuserinfo);
		echo json_encode($returndata);
		return;
	}else{
		$returndata=array("ret"=>-3,"message"=>"抽奖过程出现错误");
		echo json_encode($returndata);
		return;
	}
	
}

//处理昵称
function processNickname($userinfo,$showtype){
	$userinfo['nick_name']=pack('H*', $userinfo['nickname']);
	if($showtype==2 && !empty($userinfo['signname'])){
		//显示姓名
		$userinfo['nick_name']=$userinfo['signname'];
	}
	if($showtype==3 && !empty($userinfo['phone'])){
		//显示电话
		$userinfo['nick_name']=substr_replace($userinfo['phone'],'****',3,4);
	}
	if($showtype==1 || empty($userinfo['nick_name'])){
		$userinfo['nick_name'] = emoji_unified_to_html(emoji_softbank_to_unified(pack('H*', $userinfo['nickname'])));
	}
	return $userinfo['nick_name'];
}