<?php 
require_once(dirname(__FILE__) . '/../common/function.php');
require_once(dirname(__FILE__) . '/../common/http_helper.php');
include(dirname(__FILE__) . '/../common/db.class.php');
require_once(dirname(__FILE__) . '/../common/session_helper.php');
require_once(dirname(__FILE__) . '/../common/CacheFactory.php');
require_once(dirname(__FILE__) .DIRECTORY_SEPARATOR.'..'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'pashu_model.php');
include('biaoqing.php');
if (!isset($_SESSION['views']) || $_SESSION['views'] != true) {
	$_SESSION['views'] = false;
	echo '{"errno":-100,"message":"登录活动"}';
}
$action = $_GET['action'];
switch ($action){
	case 'pashu_joinuser':
		pashu_joinuser();
		break;
	case 'pashu_stop':
		pashu_stop();
		break;
	case 'working':
		workingdata();
		break;
	case 'pashu_reset':
		pashu_reset();
		break;
	case 'pashu_start':
		pashu_start();
		break;
	case 'end':
		pashu_end();
		break;
	case 'changeconfig':
		changeconfig();
		break;
}
function changeconfig(){
	$id=isset($_GET['id'])?intval($_GET['id']):0;
	if(!$id){
		$returndata=array('code'=>-1);
		echo json_encode($returndata);
		return;
	}
	$load=Loader::getInstance();
	$load->model('Pashu_model');
	$pashu_config=$load->pashu_model->setCurrentConfig($id);
	$returndata=array('code'=>1);
	echo json_encode($returndata);
	return;
}
//开始数钱游戏
function pashu_start(){
	$load=Loader::getInstance();
	$load->model('Pashu_model');
	$pashu_config=$load->pashu_model->getCurrentConfig();
	$currentplayers=isset($pashu_config['currentplayers'])?intval($pashu_config['currentplayers']):0;
	if($currentplayers<=0){
		$returndata=array('code'=>-2,'message'=>"当前轮数无人参与、无法开始!");
		echo json_encode($returndata);
		return;
	}
	if($pashu_config['status']==3){
		$returndata=array('code'=>-1,'message'=>"当前活动已经结束!");
		echo json_encode($returndata);
		return;
	}
	$load->pashu_model->startgame();
	$returndata=array('code'=>1,'message'=>"开始游戏!");
	echo json_encode($returndata);
	return;
}
//游戏停止
function pashu_stop(){
	//$pashu_model=new Shuqian_model();
	$load=Loader::getInstance();
	$load->model('Pashu_model');
	$pashu_config=$load->pashu_model->stopGame();
	$returndata=array('code'=>1);
	echo json_encode($returndata);
	return;
}

//游戏结束
function pashu_end(){
	//$pashu_model=new Shuqian_model();
	$load=Loader::getInstance();
	$load->model('Pashu_model');
	$winners=$load->pashu_model->getWinner();
	foreach($winners as $k=>$v){
		$winners[$k]['client_name']=$v['nickname'];
		$winners[$k]['client_avatar']=$v['avatar'];
		$winners[$k]['score']=$v['point'];
		// $formatdata[$k]['']=$v[''];
	}
	$returndata=array('code'=>1,'data'=>$winners);
	echo json_encode($returndata);
	return;
}

function pashu_reset(){
	//$pashu_model=new Shuqian_model();
	$load=Loader::getInstance();
	$load->model('Pashu_model');
	$pashu_config=$load->pashu_model->getCurrentConfig();
	$load->pashu_model->resetPashu($pashu_config['id']);
	$returndata=array('code'=>1,'message'=>"重置成功");
	echo json_encode($returndata);
}

//游戏中的数据
function workingdata(){
	//$pashu_model=new Shuqian_model();
	$load=Loader::getInstance();
	$load->model('Pashu_model');
	$data=$load->pashu_model->getTopN(10);
	$formatdata=array();
	foreach($data as $k=>$v){
		$formatdata[$k]['client_name']=$v['nickname'];
		$formatdata[$k]['client_avatar']=$v['avatar'];
		$formatdata[$k]['score']=$v['point'];
	}
	$config=$load->pashu_model->getCurrentConfig();
	// echo var_export($config);
	if($config['status']==3){
		// pashu_end();
		$winners=$load->pashu_model->getWinner();
		echo returnmsg(3,'游戏结束',$formatdata);
	}else{
		echo returnmsg(2,'',$formatdata);
	}
	// $returndata=array('code'=>1,'data'=>$formatdata);
	// echo json_encode($returndata);
	return;
}
//获取数钱用户信息
function pashu_joinuser(){
	$load=Loader::getInstance();
	$load->model('Pashu_model');
	$pashu_config=$load->pashu_model->getCurrentConfig();
	// echo var_export($pashu_config);
	$players=$load->pashu_model->shiftRecentPlayers(5);
	$num=isset($pashu_config['currentplayers'])?intval($pashu_config['currentplayers']):0;
	echo returnmsg(1,'活动参与人数',array('num'=>$num,'players'=>$players));
	// $returndata=array('message'=>$num);
	// echo json_encode($returndata);
	return;
}