<?php 
/**
 * 摇一摇请求数据功能
 * PHP version 5.4+
 * 
 * @category Wall
 * 
 * @package Shake
 * 
 * @author fy <jhfangying@qq.com>
 * 
 * @license Copyright (c) 2017 金华迪加网络科技有限公司 版权所有
 * Copyright (c) 2017 金华迪加网络科技有限公司 版权所有
 * 未经许可，任何单位及个人不得做营利性使用
 * 
 * @link link('演示地址','http://xc.taobaodpm.com');
 * */
require_once dirname(__FILE__) . '/../common/function.php';
require_once dirname(__FILE__) . '/../common/http_helper.php';
require_once dirname(__FILE__) . '/../common/db.class.php';
require_once dirname(__FILE__) . '/../common/session_helper.php';
require_once 'biaoqing.php';
if (!isset($_SESSION['views']) || $_SESSION['views'] != true) {
    $_SESSION['views'] = false;
    echo '{"errno":-100,"message":"登录活动"}';
}
$action = $_GET['action'];
switch ($action) {
case 'start':
    startgame();
    break;
case 'working':
    workingdata();
    break;
case 'reset':
    resetgame();
    break;
case 'joinuser':
    joinuser();
    break;
case 'result':
    getresult();
    break;
}
/**
 * 获取游戏结果
 * 
 * @return text 游戏结果的json数据
 */
function getresult()
{
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $data=$load->shake_model->getTopN(10);
    $shake_config=$load->shake_model->getCurrentConfig();
    $maxpoint=0;
    if ($shake_config['durationtype']==1) {
        $maxpoint=$data[0]['point'];
    } else {
        $maxpoint=$shake_config['duration'];
    }
    $formatdata=formatdata($data, $maxpoint, 1);
    $returnmsg=array('code'=>1,'status'=>3,'data'=>$formatdata);
    echo json_encode($returnmsg);
    return;
}
/**
 * 获取游戏加入的人的数据
 * 
 * @return text 游戏加入的人的json数据
 */
function joinuser()
{
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $shake_config=$load->shake_model->getCurrentConfig();
    $players = $load->shake_model->shiftRecentPlayers(5);
    $num = isset($shake_config['currentplayers'])
        ?intval($shake_config['currentplayers']):0;
    echo returnmsg(1, '活动参与人数', array('num'=>$num,'players'=>$players));
    return;
};
/**
 * 开始游戏
 * 
 * @return text 开始游戏请求结果的json数据
 */
function startgame()
{
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $shake_config=$load->shake_model->getCurrentConfig();
    $currentplayers = isset($shake_config['currentplayers'])
        ?intval($shake_config['currentplayers']):0;
    if ($currentplayers<=0) {
        $returndata=array('code'=>-2,'message'=>"当前轮数无人参与、无法开始!");
        echo json_encode($returndata);
        return;
    }
    if ($shake_config['status']==3) {
        $returndata=array('code'=>-1,'message'=>"当前活动已经结束!");
        echo json_encode($returndata);
        return;
    }
    $load->shake_model->startgame();
    $returndata=array('code'=>1,'message'=>"开始游戏!");
    echo json_encode($returndata);
    return;
}
/**
 * 游戏进行中的数据
 * 
 * @return text 游戏进行中定期返回的结果的json数据
 */
function workingdata()
{
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $data=$load->shake_model->getTopN(10);
    $config=$load->shake_model->getCurrentConfig();
    $start_at=$config['start_at'];
    if ($config['durationtype']==1) {
        //1表示按时间
        $totaltime=$config['duration'];
        $now=time();
        $time=$now-$start_at;
        $timepercent=$time/$totaltime;
        $timepercent=$timepercent<=0?0.01:$timepercent;
        $maxpoint=$data[0]['point'];
        //检查游戏是否已经结束
        if ($time>=$totaltime) {
            $config=$load->shake_model->stopGame();
        }
    } else {
        //2表示按次数
        $maxpoint=$config['duration'];
        $timepercent=1;
        if ($config['status']==2) {
            if ($config['duration']<=$data[0]['point']) {
                $config=$load->shake_model->stopGame();
            }
        }
    }

    $formatdata=formatdata($data, $maxpoint, $timepercent);
    if ($config['status']==3) {
        $winners=$load->shake_model->getWinner();
    }
    $returnmsg=array('code'=>1,'status'=>$config['status'],'data'=>$formatdata);
    echo json_encode($returnmsg);
    return;
}
/**
 * 格式化请求返回的人员成绩数据
 * 
 * @param array $data        传入人员成绩数据数组
 * @param int   $maxpoint    最大成绩
 * @param float $basepercent 传入的时间比例
 * 
 * @return text 游戏进行中定期返回的结果的json数据
 */
function formatdata($data,$maxpoint,$basepercent=1)
{
    $formatdata=array();
    foreach ($data as $k=>$v) {
        $formatdata[$k]['nickname']=$v['nickname'];
        $formatdata[$k]['avatar']=$v['avatar'];
        $formatdata[$k]['progress']=floor($v['point']/$maxpoint*$basepercent*100);
        $formatdata[$k]['progress']
            =($formatdata[$k]['progress']==0 && $v['point']>0)?
            1:$formatdata[$k]['progress'];
        $formatdata[$k]['progress']
            =$formatdata[$k]['progress']>100?100:$formatdata[$k]['progress'];
    }
    return $formatdata;
}
/**
 * 重新开始游戏请求
 * 
 * @return text 返回重新开始游戏请求的结果
 */
function resetgame()
{
    $load=Loader::getInstance();
    $load->model("Shake_model");
    $shake_config=$load->shake_model->getCurrentConfig();
    $load->shake_model->resetShake($shake_config['id']);
    $returnmsg=array('code'=>1,"message"=>"重置游戏成功");
    echo json_encode($returnmsg);
    return;
}