<?php 
require_once(dirname(__FILE__) . '/../common/function.php');
require_once(dirname(__FILE__) . '/../common/http_helper.php');
include(dirname(__FILE__) . '/../common/db.class.php');
require_once(dirname(__FILE__) . '/../common/session_helper.php');
require_once(dirname(__FILE__) . '/../common/CacheFactory.php');
require_once(dirname(__FILE__) .DIRECTORY_SEPARATOR.'..'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'shuqian_model.php');
include('biaoqing.php');
if (!isset($_SESSION['views']) || $_SESSION['views'] != true) {
	$_SESSION['views'] = false;
	echo '{"errno":-100,"message":"登录活动"}';
}
$action = $_GET['action'];
switch ($action){
	case 'shuqian_joinuser':
		shuqian_joinuser();
		break;
	case 'shuqian_stop':
		shuqian_stop();
		break;
	case 'working':
		workingdata();
		break;
	case 'shuqian_reset':
		shuqian_reset();
		break;
	case 'shuqian_start':
		shuqian_start();
		break;
	case 'end':
		shuqian_end();
		break;
	case 'changeconfig':
		changeconfig();
		break;
}
function changeconfig(){
	$id=isset($_GET['id'])?intval($_GET['id']):0;
	if(!$id){
		$returndata=array('code'=>-1);
		echo json_encode($returndata);
		return;
	}

	$shuqian_model=new Shuqian_model();
	$shuqian_config=$shuqian_model->setCurrentConfig($id);
	// echo var_export($shuqian_config);
	$returndata=array('code'=>1);
	echo json_encode($returndata);
	return;
}
//开始数钱游戏
function shuqian_start(){
	$shuqian_model=new Shuqian_model();
	$shuqian_config=$shuqian_model->getCurrentConfig();
	$currentplayers=isset($shuqian_config['currentplayers'])?intval($shuqian_config['currentplayers']):0;
	if($currentplayers<=0){
		$returndata=array('code'=>-2,'msg'=>"当前轮数无人参与、无法开始!");
		echo json_encode($returndata);
		return;
	}
	if($shuqian_config['status']==3){
		$returndata=array('code'=>-1,'msg'=>"当前活动已经结束!");
		echo json_encode($returndata);
		return;
	}
	$shuqian_model->startgame();
	$returndata=array('code'=>1,'msg'=>"开始游戏!");
	echo json_encode($returndata);
	return;
}
//游戏停止
function shuqian_stop(){
	$shuqian_model=new Shuqian_model();
	$shuqian_config=$shuqian_model->stopgame();
	$returndata=array('code'=>1);
	echo json_encode($returndata);
	return;
}

//游戏结束
function shuqian_end(){
	$shuqian_model=new Shuqian_model();
	$winners=$shuqian_model->getWinner();
	foreach($winners as $k=>$v){
		$winners[$k]['client_name']=$v['nickname'];
		$winners[$k]['client_avatar']=$v['avatar'];
		$winners[$k]['score']=$v['point'];
		// $formatdata[$k]['']=$v[''];
	}
	$returndata=array('code'=>1,'data'=>$winners);
	echo json_encode($returndata);
	return;
}

function shuqian_reset(){
	$shuqian_model=new Shuqian_model();
	$shuqian_config=$shuqian_model->getCurrentConfig();
	$shuqian_model->resetShuqian($shuqian_config['id']);
	$returndata=array('code'=>1,'message'=>"重置成功");
	echo json_encode($returndata);
}

//游戏中的数据
function workingdata(){
	$shuqian_model=new Shuqian_model();
	$data=$shuqian_model->getTopN(10);
	$formatdata=array();
	foreach($data as $k=>$v){
		$formatdata[$k]['client_name']=$v['nickname'];
		$formatdata[$k]['client_avatar']=$v['avatar'];
		$formatdata[$k]['score']=$v['point'];
	}
	$returndata=array('code'=>1,'data'=>$formatdata);
	echo json_encode($returndata);
	return;
}
//获取数钱用户信息
function shuqian_joinuser(){
	$shuqian_model=new Shuqian_model();
	$shuqian_config=$shuqian_model->getCurrentConfig();
	// echo var_export($shuqian_config);
	$num=isset($shuqian_config['currentplayers'])?intval($shuqian_config['currentplayers']):0;
	$returndata=array('message'=>$num);
	echo json_encode($returndata);
}