
-- --------------------------------------------------------

--
-- 表的结构 `gxl_admin`
--

CREATE TABLE IF NOT EXISTS `gxl_admin` (
  `admin_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `admin_name` varchar(50) NOT NULL,
  `admin_pwd` char(255) NOT NULL,
  `admin_count` smallint(6) NOT NULL,
  `admin_ok` varchar(50) NOT NULL,
  `admin_del` bigint(1) NOT NULL,
  `admin_ip` varchar(40) NOT NULL,
  `admin_email` varchar(40) NOT NULL,
  `admin_logintime` int(11) NOT NULL,
  PRIMARY KEY (`admin_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- 转存表中的数据 `gxl_admin`
--

INSERT INTO `gxl_admin` (`admin_id`, `admin_name`, `admin_pwd`, `admin_count`, `admin_ok`, `admin_del`, `admin_ip`, `admin_email`, `admin_logintime`) VALUES
(1, 'admin', '21232f297a57a5a743894a0e4a801fc3', 985, '1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1', 0, '127.0.0.1', 'admin@qq.com', 1492353748);

-- --------------------------------------------------------

--
-- 表的结构 `gxl_ads`
--

CREATE TABLE IF NOT EXISTS `gxl_ads` (
  `ads_id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `ads_name` varchar(50) NOT NULL,
  `ads_content` text NOT NULL,
  PRIMARY KEY (`ads_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=39 ;

--
-- 转存表中的数据 `gxl_ads`
--

INSERT INTO `gxl_ads` (`ads_id`, `ads_name`, `ads_content`) VALUES
(38, 'ddd', '');

-- --------------------------------------------------------

--
-- 表的结构 `gxl_cm`
--

CREATE TABLE IF NOT EXISTS `gxl_cm` (
  `cm_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cm_cid` mediumint(9) NOT NULL,
  `cm_sid` tinyint(1) NOT NULL DEFAULT '1',
  `cm_uid` mediumint(9) NOT NULL DEFAULT '1',
  `cm_content` text NOT NULL,
  `cm_up` mediumint(9) NOT NULL DEFAULT '0',
  `cm_down` mediumint(9) NOT NULL DEFAULT '0',
  `cm_ip` varchar(20) NOT NULL,
  `cm_addtime` int(11) NOT NULL,
  `cm_status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cm_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `gxl_collect`
--

CREATE TABLE IF NOT EXISTS `gxl_collect` (
  `collect_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `collect_title` varchar(50) NOT NULL,
  `collect_encoding` varchar(10) NOT NULL,
  `collect_player` varchar(50) NOT NULL,
  `collect_savepic` tinyint(4) NOT NULL,
  `collect_order` tinyint(4) NOT NULL,
  `collect_pagetype` tinyint(4) NOT NULL,
  `collect_liststr` text NOT NULL,
  `collect_pagestr` text NOT NULL,
  `collect_pagesid` smallint(6) unsigned NOT NULL,
  `collect_pageeid` smallint(6) unsigned NOT NULL,
  `collect_listurlstr` text NOT NULL,
  `collect_listlink` text NOT NULL,
  `collect_listpicstr` text NOT NULL,
  `collect_cid` text NOT NULL,
  `collect_listname` text NOT NULL,
  `collect_keywords` text NOT NULL,
  `collect_name` text NOT NULL,
  `collect_titlee` text NOT NULL,
  `collect_actor` text NOT NULL,
  `collect_director` text NOT NULL,
  `collect_content` text NOT NULL,
  `collect_pic` text NOT NULL,
  `collect_area` text NOT NULL,
  `collect_language` text NOT NULL,
  `collect_year` text NOT NULL,
  `collect_continu` text NOT NULL,
  `collect_urlstr` text NOT NULL,
  `collect_urlname` text NOT NULL,
  `collect_urllink` text NOT NULL,
  `collect_url` text NOT NULL,
  `collect_replace` text NOT NULL,
  PRIMARY KEY (`collect_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `gxl_comment`
--

CREATE TABLE IF NOT EXISTS `gxl_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ting_id` int(10) DEFAULT NULL,
  `userid` int(10) DEFAULT NULL,
  `username` varchar(100) DEFAULT NULL,
  `creat_at` int(11) DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0' COMMENT '评论状态{0:未审核,-1:未通过审核,1:通过审核}',
  `content` varchar(255) DEFAULT NULL,
  `support` mediumint(8) DEFAULT '0' COMMENT '支持数',
  `reply` tinyint(1) DEFAULT '0' COMMENT '是否为回复',
  `oppose` mediumint(8) DEFAULT '0' COMMENT '反对数',
  `pid` int(10) DEFAULT NULL,
  `ispass` int(1) DEFAULT '0' COMMENT '1 通过 0 不通过',
  `rcid` int(10) NOT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `vod_id` (`ting_id`),
  KEY `userid` (`userid`),
  KEY `status` (`status`),
  KEY `ispass` (`ispass`),
  KEY `pid` (`pid`),
  KEY `ip` (`ip`),
  KEY `creat_at` (`creat_at`),
  KEY `rcid` (`rcid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `gxl_comment_opinion`
--

CREATE TABLE IF NOT EXISTS `gxl_comment_opinion` (
  `opinion_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` int(10) DEFAULT NULL,
  `opinion` int(1) DEFAULT NULL COMMENT '0 反对 1同意',
  `creat_date` int(11) DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`opinion_id`),
  KEY `comment_id` (`comment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `gxl_gb`
--

CREATE TABLE IF NOT EXISTS `gxl_gb` (
  `gb_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gb_cid` mediumint(8) NOT NULL DEFAULT '0',
  `gb_uid` mediumint(9) NOT NULL DEFAULT '1',
  `gb_content` text NOT NULL,
  `gb_intro` text NOT NULL,
  `gb_addtime` int(11) NOT NULL,
  `gb_ip` varchar(20) NOT NULL,
  `gb_oid` tinyint(1) NOT NULL DEFAULT '0',
  `gb_status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gb_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `gxl_guestbook`
--

CREATE TABLE IF NOT EXISTS `gxl_guestbook` (
  `gb_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gb_cid` mediumint(8) NOT NULL DEFAULT '0',
  `gb_uid` mediumint(9) NOT NULL DEFAULT '1',
  `nickname` varchar(20) NOT NULL,
  `gb_title` varchar(200) NOT NULL COMMENT '标题',
  `gb_content` text NOT NULL,
  `gb_intro` text NOT NULL,
  `gb_addtime` int(11) NOT NULL,
  `gb_ip` varchar(20) NOT NULL,
  `gb_oid` tinyint(1) NOT NULL DEFAULT '0',
  `gb_status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gb_id`),
  KEY `gb_uid` (`gb_uid`),
  KEY `gb_cid` (`gb_cid`),
  KEY `nickname` (`nickname`),
  KEY `gb_addtime` (`gb_addtime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `gxl_link`
--

CREATE TABLE IF NOT EXISTS `gxl_link` (
  `link_id` tinyint(4) unsigned NOT NULL AUTO_INCREMENT,
  `link_name` varchar(255) NOT NULL,
  `link_logo` varchar(255) NOT NULL,
  `link_url` varchar(255) NOT NULL,
  `link_order` tinyint(4) NOT NULL,
  `link_type` tinyint(1) NOT NULL,
  PRIMARY KEY (`link_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- 转存表中的数据 `gxl_link`
--

INSERT INTO `gxl_link` (`link_id`, `link_name`, `link_logo`, `link_url`, `link_order`, `link_type`) VALUES
(1, 'gxlcms', '', 'http://www.gxlcms.com', 1, 1);

-- --------------------------------------------------------

--
-- 表的结构 `gxl_list`
--

CREATE TABLE IF NOT EXISTS `gxl_list` (
  `list_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `list_pid` smallint(3) NOT NULL,
  `list_oid` smallint(3) NOT NULL,
  `list_sid` tinyint(1) NOT NULL,
  `list_name` char(20) NOT NULL,
  `list_skin` char(20) NOT NULL,
  `list_skin_detail` varchar(20) NOT NULL DEFAULT 'gxl_ting',
  `list_skin_play` varchar(20) NOT NULL DEFAULT 'gxl_play',
  `list_skin_type` varchar(20) NOT NULL DEFAULT 'gxl_tingtype',
  `list_dir` varchar(90) NOT NULL,
  `list_status` tinyint(1) NOT NULL DEFAULT '1',
  `list_keywords` varchar(255) NOT NULL,
  `list_title` varchar(50) NOT NULL,
  `list_description` varchar(255) NOT NULL,
  `list_jumpurl` varchar(150) NOT NULL,
  PRIMARY KEY (`list_id`),
  KEY `list_oid` (`list_oid`),
  KEY `list_name` (`list_name`),
  KEY `list_dir` (`list_dir`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=49 ;

--
-- 转存表中的数据 `gxl_list`
--

INSERT INTO `gxl_list` (`list_id`, `list_pid`, `list_oid`, `list_sid`, `list_name`, `list_skin`, `list_skin_detail`, `list_skin_play`, `list_skin_type`, `list_dir`, `list_status`, `list_keywords`, `list_title`, `list_description`, `list_jumpurl`) VALUES
(2, 0, 1, 1, '有声小说', 'gxl_letter', 'gxl_ting', 'gxl_play', 'gxl_tingtype', 'tingbook', 1, '', '', '', 'http://'),
(15, 2, 1, 1, '恐怖惊悚', 'gxl_letter', 'gxl_ting', 'gxl_play', 'gxl_tingtype', 'kongbu', 1, '', '', '', 'http://'),
(17, 2, 6, 1, '都市传说', 'gxl_letter', 'gxl_ting', 'gxl_play', 'gxl_tingtype', 'dushi', 1, '', '', '', 'http://'),
(23, 2, 3, 1, ' 玄幻奇幻', 'gxl_letter', 'gxl_ting', 'gxl_play', 'gxl_tingtype', 'xuanhuan', 1, '', '', '', 'http://'),
(24, 2, 4, 1, '历史军事', 'gxl_letter', 'gxl_ting', 'gxl_play', 'gxl_tingtype', 'lishi', 1, '', '', '', 'http://'),
(25, 2, 7, 1, ' 网游科幻', 'gxl_letter', 'gxl_ting', 'gxl_play', 'gxl_tingtype', 'wangyou', 1, '', '', '', 'http://');

-- --------------------------------------------------------

--
-- 表的结构 `gxl_news`
--

CREATE TABLE IF NOT EXISTS `gxl_news` (
  `news_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `news_cid` smallint(6) NOT NULL DEFAULT '0',
  `news_name` varchar(255) NOT NULL,
  `news_keywords` varchar(255) NOT NULL,
  `news_color` char(8) NOT NULL,
  `news_pic` varchar(255) NOT NULL,
  `news_inputer` varchar(50) NOT NULL,
  `news_reurl` varchar(255) NOT NULL,
  `news_remark` text NOT NULL,
  `news_content` text NOT NULL,
  `news_hits` mediumint(8) NOT NULL,
  `news_hits_day` mediumint(8) NOT NULL,
  `news_hits_week` mediumint(8) NOT NULL,
  `news_hits_month` mediumint(8) NOT NULL,
  `news_hits_lasttime` int(11) NOT NULL,
  `news_stars` tinyint(1) NOT NULL,
  `news_status` tinyint(1) NOT NULL DEFAULT '1',
  `news_up` mediumint(8) NOT NULL,
  `news_down` mediumint(8) NOT NULL,
  `news_jumpurl` varchar(255) NOT NULL,
  `news_letter` char(2) NOT NULL,
  `news_addtime` int(8) NOT NULL,
  `news_skin` varchar(30) NOT NULL,
  `news_gold` decimal(3,1) NOT NULL,
  `news_golder` smallint(6) NOT NULL,
  PRIMARY KEY (`news_id`),
  KEY `news_cid` (`news_cid`),
  KEY `news_up` (`news_up`),
  KEY `news_down` (`news_down`),
  KEY `news_gold` (`news_gold`),
  KEY `news_hits` (`news_hits`,`news_cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `gxl_slide`
--

CREATE TABLE IF NOT EXISTS `gxl_slide` (
  `slide_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `slide_oid` tinyint(3) NOT NULL,
  `slide_cid` tinyint(3) NOT NULL DEFAULT '1',
  `slide_name` varchar(255) NOT NULL,
  `slide_logo` varchar(255) NOT NULL,
  `slide_pic` varchar(255) NOT NULL,
  `slide_url` varchar(255) NOT NULL,
  `slide_content` varchar(255) NOT NULL,
  `slide_status` tinyint(1) NOT NULL,
  `slide_vid` mediumint(8) NOT NULL,
  PRIMARY KEY (`slide_id`),
  KEY `slide_status` (`slide_status`),
  KEY `slide_oid` (`slide_oid`),
  KEY `slide_cid` (`slide_cid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=29 ;

-- --------------------------------------------------------

--
-- 表的结构 `gxl_special`
--

CREATE TABLE IF NOT EXISTS `gxl_special` (
  `special_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `special_banner` varchar(150) NOT NULL,
  `special_logo` varchar(150) NOT NULL,
  `special_name` varchar(150) NOT NULL,
  `special_keywords` varchar(150) NOT NULL,
  `special_description` varchar(255) NOT NULL,
  `special_color` char(8) NOT NULL,
  `special_skin` varchar(50) NOT NULL,
  `special_addtime` int(11) NOT NULL,
  `special_hits` mediumint(8) NOT NULL,
  `special_hits_day` mediumint(8) NOT NULL,
  `special_hits_week` mediumint(8) NOT NULL,
  `special_hits_month` mediumint(8) NOT NULL,
  `special_hits_lasttime` int(11) NOT NULL,
  `special_stars` tinyint(1) NOT NULL DEFAULT '1',
  `special_status` tinyint(1) NOT NULL,
  `special_content` text NOT NULL,
  `special_up` mediumint(8) NOT NULL,
  `special_down` mediumint(8) NOT NULL,
  `special_gold` decimal(3,1) NOT NULL,
  `special_golder` smallint(6) NOT NULL,
  `special_letters` varchar(255) DEFAULT NULL,
  `special_mx` varchar(155) NOT NULL,
  PRIMARY KEY (`special_id`),
  UNIQUE KEY `special_letters` (`special_letters`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=28 ;

-- --------------------------------------------------------

--
-- 表的结构 `gxl_tag`
--

CREATE TABLE IF NOT EXISTS `gxl_tag` (
  `tag_id` mediumint(8) NOT NULL,
  `tag_sid` tinyint(1) NOT NULL,
  `tag_name` varchar(50) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `gxl_tag`
--

INSERT INTO `gxl_tag` (`tag_id`, `tag_sid`, `tag_name`) VALUES
(0, 1, '未知'),
(55, 1, '未知'),
(54, 1, '未知'),
(53, 1, '未知'),
(52, 1, '未知'),
(51, 1, '未知'),
(50, 1, '未知'),
(49, 1, '未知'),
(48, 1, '未知'),
(47, 1, '未知'),
(56, 1, '未知'),
(57, 1, '未知'),
(58, 1, '未知'),
(59, 1, '未知'),
(60, 1, '未知'),
(61, 1, '未知'),
(62, 1, '未知'),
(63, 1, '未知'),
(64, 1, '未知'),
(65, 1, '未知'),
(66, 1, '未知'),
(161, 1, '未知'),
(158, 1, '未知'),
(159, 1, '未知'),
(160, 1, '未知'),
(157, 1, '未知'),
(127, 1, '未知'),
(128, 1, '未知'),
(129, 1, '未知'),
(130, 1, '未知'),
(131, 1, '未知'),
(132, 1, '未知'),
(133, 1, '未知'),
(134, 1, '未知'),
(135, 1, '未知'),
(136, 1, '未知'),
(137, 1, '未知'),
(138, 1, '未知'),
(139, 1, '未知'),
(140, 1, '未知'),
(141, 1, '未知'),
(142, 1, '未知'),
(143, 1, '未知'),
(144, 1, '未知'),
(145, 1, '未知'),
(146, 1, '未知'),
(147, 1, '未知'),
(148, 1, '未知'),
(149, 1, '未知'),
(150, 1, '未知'),
(151, 1, '未知'),
(152, 1, '未知'),
(153, 1, '未知'),
(154, 1, '未知'),
(155, 1, '未知'),
(156, 1, '未知'),
(162, 1, '未知'),
(163, 1, '未知'),
(164, 1, '未知'),
(165, 1, '未知'),
(166, 1, '未知'),
(167, 1, '未知'),
(168, 1, '未知'),
(169, 1, '未知'),
(170, 1, '未知'),
(171, 1, '未知'),
(172, 1, '未知'),
(173, 1, '未知'),
(174, 1, '未知'),
(175, 1, '未知'),
(176, 1, '未知'),
(177, 1, '未知'),
(178, 1, '未知'),
(179, 1, '未知'),
(180, 1, '未知'),
(181, 1, '未知'),
(182, 1, '未知'),
(183, 1, '未知'),
(184, 1, '未知'),
(185, 1, '未知'),
(186, 1, '未知');

-- --------------------------------------------------------

--
-- 表的结构 `gxl_ting`
--

CREATE TABLE IF NOT EXISTS `gxl_ting` (
  `ting_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '作品id',
  `ting_cid` smallint(5) NOT NULL DEFAULT '0' COMMENT '作品栏目cid',
  `ting_name` varchar(255) NOT NULL DEFAULT '' COMMENT '作品名称',
  `ting_title` varchar(255) NOT NULL DEFAULT '' COMMENT '作品备注',
  `ting_keywords` varchar(255) NOT NULL,
  `ting_color` char(8) NOT NULL DEFAULT '' COMMENT '标题颜色',
  `ting_anchor` varchar(255) NOT NULL COMMENT '主播',
  `ting_author` varchar(255) NOT NULL COMMENT '作者',
  `ting_content` text NOT NULL COMMENT '作品描述',
  `ting_pic` varchar(255) NOT NULL DEFAULT '' COMMENT '作品图片',
  `ting_language` char(10) NOT NULL DEFAULT '' COMMENT '作品语言',
  `ting_addtime` int(11) NOT NULL DEFAULT '0' COMMENT '作品时间',
  `ting_hits` mediumint(8) NOT NULL DEFAULT '0' COMMENT '总点击',
  `ting_hits_day` mediumint(8) NOT NULL DEFAULT '0' COMMENT '日点击',
  `ting_hits_week` mediumint(8) NOT NULL DEFAULT '0' COMMENT '周点击',
  `ting_hits_month` mediumint(8) NOT NULL DEFAULT '0' COMMENT '月点击',
  `ting_hits_lasttime` int(11) NOT NULL,
  `ting_stars` tinyint(1) NOT NULL DEFAULT '0',
  `ting_status` tinyint(1) NOT NULL DEFAULT '1',
  `ting_up` mediumint(8) NOT NULL DEFAULT '0' COMMENT '顶',
  `ting_down` mediumint(8) NOT NULL DEFAULT '0' COMMENT '踩',
  `ting_play` varchar(255) NOT NULL,
  `ting_server` varchar(255) NOT NULL,
  `ting_url` longtext NOT NULL COMMENT '播放地址',
  `ting_inputer` varchar(30) NOT NULL,
  `ting_reurl` varchar(255) NOT NULL,
  `ting_jumpurl` varchar(150) NOT NULL,
  `ting_letter` char(2) NOT NULL,
  `ting_skin` varchar(30) NOT NULL,
  `ting_gold` decimal(3,1) NOT NULL,
  `ting_golder` smallint(6) NOT NULL,
  `ting_length` smallint(3) NOT NULL,
  `reid` int(10) NOT NULL DEFAULT '0',
  `HasGetComment` smallint(10) NOT NULL DEFAULT '0',
  `ting_letters` varchar(255) DEFAULT '0' COMMENT '首字母',
  `ting_total` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ting_id`),
  KEY `ting_letters` (`ting_letters`),
  KEY `ting_actor` (`ting_anchor`),
  KEY `ting_director` (`ting_author`),
  KEY `ting_up` (`ting_up`),
  KEY `ting_down` (`ting_down`),
  KEY `ting_gold` (`ting_gold`),
  KEY `ting_addtime` (`ting_addtime`,`ting_cid`),
  KEY `ting_hits` (`ting_hits`,`ting_cid`),
  KEY `ting_hits_month` (`ting_hits_month`,`ting_cid`),
  KEY `ting_filmtime` (`ting_cid`),
  KEY `ting_cid` (`ting_cid`,`ting_status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='听数据' AUTO_INCREMENT=187 ;

--
-- 转存表中的数据 `gxl_ting`
--

INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(127, 24, '公益朗读', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group41/M00/E3/F1/wKgJ8lrhXvCiORDKAAFqMxQeuC8085.jpg', '', 1530072223, 6, 0, 0, 0, 0, 1, 1, 8, 8, 'ting', '', '一棵开花的树$http://audio.xmcdn.com/group41/M02/8A/49/wKgJ8lrcnPGCn2C0AArI8izpUwY384.m4a\r\n第一一四夜：关于时间$http://audio.xmcdn.com/group40/M03/32/20/wKgJT1rbO-CSpQdjAA_zUYtZKB0155.m4a\r\n第一一三夜：关于独处$http://audio.xmcdn.com/group41/M01/6A/D9/wKgJ8VrbOdqSUsJcAA4RKqb2xGA685.m4a\r\n第一一五夜：关于记忆$http://audio.xmcdn.com/group41/M01/EC/9D/wKgJ8lrHb-Gh-XaLAAyzaT-rRIQ194.m4a\r\n第一一二夜：你好，很高兴认识你$http://audio.xmcdn.com/group40/M0A/97/FD/wKgJT1rGJf6ArpyQAA29MhLTp1s658.m4a', 'xml_8023', '2698', '', 'G', '', '1.0', 9, 0, 0, 0, 'gongyilangdu', ''),
(128, 24, '旺发小队-声律启蒙-打卡', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group41/M0A/C6/4C/wKgJ8VqbT9jQceMEAAGk5PBUMtE403.jpg', '', 1530072223, 2, 0, 0, 0, 0, 1, 1, 4, 6, 'ting', '', '十一点$http://audio.xmcdn.com/group42/M02/90/B3/wKgJ9FrdF57RaFRaABEGc5azaGM819.m4a\r\n阳庚青$http://audio.xmcdn.com/group41/M05/8E/FD/wKgJ8VrdF7fz9jYNANCfQSMoAiE531.m4a\r\n先萧肴$http://audio.xmcdn.com/group41/M06/72/9B/wKgJ8lrbw2ayw3coAFVyGZYajDc172.m4a\r\n四豪$http://audio.xmcdn.com/group40/M0B/3A/32/wKgJVFrbw16TaxFDAD5M9M9DsMw311.m4a\r\n五歌$http://audio.xmcdn.com/group40/M0B/39/7A/wKgJT1rbw1uzhaazAFDc0bJTeq8532.m4a\r\n六麻$http://audio.xmcdn.com/group40/M0B/3A/30/wKgJVFrbw1TQdH9EAEaT65ySbe4636.m4a\r\n十五删$http://audio.xmcdn.com/group41/M06/58/27/wKgJ8Vracdrwcr5IACPVmrlCFaA814.m4a\r\n十四寒，较慢$http://audio.xmcdn.com/group41/M09/58/18/wKgJ8VracIiSmiLTACgHB0pjjBM750.m4a\r\n文元（快）$http://audio.xmcdn.com/group40/M0A/1F/A7/wKgJVFrabxCBcRVgACTyeXAObPA534.m4a\r\n支微鱼$http://audio.xmcdn.com/group40/M06/08/F8/wKgJT1rZI2yT_HKdAETOvq1Of3c842.m4a\r\n虞齐佳$http://audio.xmcdn.com/group40/M06/08/F8/wKgJT1rZI2vyqeqvADd9718LhpQ471.m4a\r\n灰，一快一慢$http://audio.xmcdn.com/group40/M06/08/F8/wKgJT1rZI22A_9JDAFpj4h5qBP4557.m4a\r\n十一真$http://audio.xmcdn.com/group42/M08/3F/09/wKgJ81rZI12ReRkjAGBVZt1SePs444.m4a\r\n三，江$http://audio.xmcdn.com/group41/M03/2A/78/wKgJ8lrX243Bcm0lAEIHcCQbkM4267.m4a\r\n东冬$http://audio.xmcdn.com/group40/M04/F1/24/wKgJT1rX24iTouaJAGuOJ3YZJfw386.m4a\r\n下，十五，咸$http://audio.xmcdn.com/group42/M05/27/28/wKgJ81rX23aBvvQeACKPnfKf6BA112.m4a\r\n下，十四，盐$http://audio.xmcdn.com/group41/M04/10/A4/wKgJ8lrWgIHyorV7AEwaBUWiBWA464.m4a\r\n下，十三，覃$http://audio.xmcdn.com/group41/M04/10/A1/wKgJ8lrWgHOA7ZN9AGFBm5x5Ct8439.m4a\r\n蒸尤侵$http://audio.xmcdn.com/group41/M04/10/58/wKgJ8VrWgHCAd0HVAGFDEhunX6o857.m4a\r\n下，九，青$http://audio.xmcdn.com/group41/M0B/F5/FC/wKgJ8VrVKsfTPRkzAGE12-saM78722.m4a\r\n下，八，庚$http://audio.xmcdn.com/group41/M0B/F6/3B/wKgJ8lrVKrfz7KQaAGttIhZeknQ054.m4a\r\n下，七，阳$http://audio.xmcdn.com/group41/M0B/F6/39/wKgJ8lrVKqvCPs60AE6nhwSGWv8493.m4a\r\n比较稳定的。$http://audio.xmcdn.com/group42/M02/D8/F8/wKgJ81rT53PhXl9DAFsS5fa95e0335.m4a\r\n第一个，逐渐找状态$http://audio.xmcdn.com/group41/M0B/DC/7A/wKgJ8lrT51-yINrrADwzuhWnbcI051.m4a\r\n慢$http://audio.xmcdn.com/group40/M08/A2/C6/wKgJT1rT50ThGyZNAGA9sNu-l6c271.m4a\r\n快$http://audio.xmcdn.com/group40/M08/A2/C5/wKgJT1rT5zfyaC9OADX2weVsIAA683.m4a\r\n很慢，字较清，明日继续$http://audio.xmcdn.com/group41/M0A/BF/E8/wKgJ8VrSjh-A1QMLAEVTy_NJSiI010.m4a\r\n0415很慢，字不清$http://audio.xmcdn.com/group40/M05/86/37/wKgJT1rSjf7z7tJ9AEMkU9ljZJE380.m4a\r\n0415慢$http://audio.xmcdn.com/group41/M0A/BF/E5/wKgJ8VrSjeagUTLcADpwL-CahwY542.m4a\r\n0415中$http://audio.xmcdn.com/group41/M0A/BF/E5/wKgJ8VrSjebjvVkDAGiJFVnX_Rc407.m4a\r\n0414中$http://audio.xmcdn.com/group41/M04/A5/9E/wKgJ8VrRTsmj05_QAHUNLOcZ4sE599.m4a\r\n0414快$http://audio.xmcdn.com/group42/M05/A2/70/wKgJ81rRTq_SHj8nACtJXhqjoho298.m4a\r\n0414慢$http://audio.xmcdn.com/group42/M00/A7/57/wKgJ9FrRTqiB10HkADxrTlWgc04917.m4a\r\n0413$http://audio.xmcdn.com/group41/M09/8B/E0/wKgJ8VrP8W3A5DiyACOiYIGkKRQ984.m4a\r\n0413$http://audio.xmcdn.com/group42/M00/8D/93/wKgJ9FrP8XiAksj0AJxMP-y2HOQ128.m4a\r\n0412$http://audio.xmcdn.com/group41/M07/82/5E/wKgJ8VrPXX6SYluaAC9BhRNnPFs040.m4a\r\n0412$http://audio.xmcdn.com/group41/M07/82/60/wKgJ8VrPXYKyYyhhAGuiAdIR3N4292.m4a\r\n0412$http://audio.xmcdn.com/group40/M04/48/48/wKgJT1rPXXORIF1RAGAmMKk3UCI318.m4a\r\n20180411$http://audio.xmcdn.com/group42/M06/54/6D/wKgJ81rNR0fDrdQDAFbLLAS7V1A613.m4a\r\n20180411$http://audio.xmcdn.com/group42/M06/54/69/wKgJ81rNRzTignojAB3lOgbQgwI370.m4a\r\n20180410$http://audio.xmcdn.com/group40/M09/04/F8/wKgJVFrL99CDS_tNAEtbHm_3QeU521.m4a\r\n20180409$http://audio.xmcdn.com/group41/M0A/24/66/wKgJ8VrKpj-QX5hKAH_RaabWuuk846.m4a\r\n20180409$http://audio.xmcdn.com/group42/M0A/22/AF/wKgJ81rKpifwQy0qAC9NAcaDC6Y770.m4a\r\n20180409$http://audio.xmcdn.com/group42/M0A/22/AD/wKgJ81rKphrTyWTcACXZPFHJRdg858.m4a\r\n20180409$http://audio.xmcdn.com/group42/M07/27/89/wKgJ9FrKphXz5aL7ADfdYNSf0ZM132.m4a\r\n20180408$http://audio.xmcdn.com/group41/M01/0B/F1/wKgJ8VrJVl6C2QJ7AHI5OXDQmV0306.m4a\r\n20180407$http://audio.xmcdn.com/group41/M03/F2/E6/wKgJ8VrIDr-ha-HPAH0wAF5Aas0895.m4a\r\n20180407$http://audio.xmcdn.com/group41/M0A/F2/50/wKgJ8VrIA-vhzs9aAClqY5ZLytc985.m4a\r\n20180406$http://audio.xmcdn.com/group40/M00/A2/24/wKgJT1rG2Y2zcVYkACPwQKrNOws509.m4a\r\n20180406$http://audio.xmcdn.com/group40/M00/A2/D4/wKgJVFrG2YaRetBKACy-SvR_pco065.m4a\r\n20180405$http://audio.xmcdn.com/group41/M0A/C6/C7/wKgJ8lrFrz_Tn4YaAGLW4sL-zqE374.m4a\r\n0404$http://audio.xmcdn.com/group41/M09/B3/1A/wKgJ8lrEoIDz519tAH6l3OAstK4247.m4a\r\n0403$http://audio.xmcdn.com/group41/M09/B3/18/wKgJ8lrEoHjS8bDJAIWoSAI-hzo370.m4a\r\n4.2$http://audio.xmcdn.com/group41/M03/76/36/wKgJ8lrBdrWx5OKWAHLAVTF80Qc224.m4a\r\n4.1$http://audio.xmcdn.com/group41/M04/66/5A/wKgJ8lrAi0OD_pnNAEohk_zbtG0735.m4a\r\n3.31$http://audio.xmcdn.com/group41/M07/45/0F/wKgJ8Vq-3WSxQWjUAFxFif-UO_o176.m4a\r\n3.30$http://audio.xmcdn.com/group40/M04/F8/A9/wKgJVFq9oC2jhnXlALP7XrpbDv8472.m4a\r\n3.29$http://audio.xmcdn.com/group41/M01/26/51/wKgJ8lq81T_xsJvcAHDLmO2H_aE395.m4a\r\n3.28$http://audio.xmcdn.com/group40/M08/EB/DE/wKgJVFq808qzXHVjAKbIl4Nc-5w149.m4a\r\n3.26虞齐佳灰真文$http://audio.xmcdn.com/group41/M0A/25/D6/wKgJ8lq80j-SbJ7TAKsjC1BelhA105.m4a\r\n3.27元寒删$http://audio.xmcdn.com/group40/M03/E6/CA/wKgJVFq8nG2BF2dhAFeaOFubRsg367.m4a\r\n3.25鱼$http://audio.xmcdn.com/group42/M08/C3/DC/wKgJ81q24d6B0zLJABeTjkoG7Yg104.m4a\r\n3.25支微鱼$http://audio.xmcdn.com/group40/M03/8B/65/wKgJVFq24Z_wSRKQADcrsgL2r1g967.m4a\r\n3.24先萧肴$http://audio.xmcdn.com/group40/M08/83/FA/wKgJVFq2SAzjo9JXAFf5rWOu93Q672.m4a\r\n3.23灰真文元寒删$http://audio.xmcdn.com/group41/M05/A4/FF/wKgJ8Vq04U7iFMcjAMjH57_Gg_A590.m4a\r\n3.22虞齐佳$http://audio.xmcdn.com/group41/M0B/87/ED/wKgJ8lqy9sTBRJS_AF6Iw_Nkejc639.m4a\r\n3.21支微鱼$http://audio.xmcdn.com/group42/M07/6F/25/wKgJ81qxoQLD2fDhAG-M8SVOpIY061.m4a\r\n3.20东冬江$http://audio.xmcdn.com/group41/M06/56/0F/wKgJ8VqwSbuSRnJZAH-SRg32KYE697.m4a\r\n3.19覃盐咸$http://audio.xmcdn.com/group42/M0B/3F/09/wKgJ81qu-nrSKRJGAIUFSbA2grU405.m4a\r\n青蒸尤侵$http://audio.xmcdn.com/group40/M03/23/BA/wKgJVFqhyKaDTOo9AH4FzDQVE-g960.m4a\r\n3.8阳庚$http://audio.xmcdn.com/group41/M03/4C/D0/wKgJ8lqgvdGggurbAD6NyT8eHs0927.m4a\r\n3.7豪歌麻$http://audio.xmcdn.com/group41/M0A/2D/0D/wKgJ8lqfMsLTkz8ZAEcTqXsqHFI727.m4a\r\n3.6先萧肴$http://audio.xmcdn.com/group41/M03/06/78/wKgJ8Vqd1pfR3z8GAF6JxQ85dzE353.m4a\r\n3.5元寒删$http://audio.xmcdn.com/group42/M03/E8/08/wKgJ81qcg6mwM2RlAFSgGWvYjN0035.m4a\r\n3.4灰真文$http://audio.xmcdn.com/group42/M06/C7/CF/wKgJ81qbT5KDYFLeAFncyoamN6k268.m4a\r\n3.3虞齐佳$http://audio.xmcdn.com/group42/M01/AB/3D/wKgJ81qaD_jyf9ZQAGZd4L_wxWk180.m4a\r\n3.2支微鱼$http://audio.xmcdn.com/group41/M02/88/C5/wKgJ8VqYjIOTOV9IAFtsNBBgTnY226.m4a\r\n3.1东冬江$http://audio.xmcdn.com/group41/M03/66/8D/wKgJ8lqXOpbSPCdQAFmTXsw97FI805.m4a', 'xml_8023', '2788', '', 'W', '', '1.0', 8, 0, 0, 0, 'wangfaxiaoduishenglvqimengdaka', ''),
(129, 24, '智慧之光', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group40/M07/76/91/wKgJT1rRw_Lz3Py1AAEo1UcFIVU859.jpg', '', 1530072223, 10, 0, 0, 0, 0, 1, 1, 8, 10, 'ting', '', '金色比丘尼的因果故事$http://audio.xmcdn.com/group42/M03/86/FF/wKgJ81rcnfDwsFyFACaKsxl2wUk806.m4a', 'xml_8023', '2787', '', 'Z', '', '1.0', 3, 0, 0, 0, 'zhihuizhiguang', ''),
(130, 24, '故乡天下黄花[刘震云]', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group39/M03/63/11/wKgJnlpv_-OgvxJBAAM5Ep6wb_w468.jpg', '', 1530072223, 2, 0, 0, 0, 0, 1, 1, 3, 1, 'ting', '', '附记$http://audio.xmcdn.com/group40/M05/55/D8/wKgJT1rdGRnTYCQ1AGs8rg0-7qk082.m4a\r\n第四章 六$http://audio.xmcdn.com/group42/M05/9F/93/wKgJ9FrDhIvQzY5EAFpODws7wxo415.m4a\r\n第四章 五$http://audio.xmcdn.com/group42/M04/0F/47/wKgJ9Fq7hCTzIyHMAE_0zR29UPE440.m4a\r\n第四章 四$http://audio.xmcdn.com/group42/M01/0E/E7/wKgJ9Fq7gVSy3hmjAFCwwzMJU-I746.m4a\r\n第四章 文化1966到1968 四$http://audio.xmcdn.com/group42/M06/D7/72/wKgJ9FqpFA2zNe63ADsd-zHAwuM748.m4a\r\n第四章 文化1966到1968 三$http://audio.xmcdn.com/group40/M08/9D/2B/wKgJT1qpEBayKR7iAG12bFTOToU727.m4a\r\n第四章 文化1966到1968 三$http://audio.xmcdn.com/group40/M05/70/90/wKgJVFqmZSHTXRtOAEhbIo1A-XE184.m4a\r\n第四章 文化1966到1968 二$http://audio.xmcdn.com/group40/M0B/43/4E/wKgJVFqjwhrTx15jAKT3ABDZEPc699.m4a\r\n第四章 文化1966到1968 一$http://audio.xmcdn.com/group40/M00/41/FC/wKgJT1qju9HSXXFEAEvDYLPmn48876.m4a\r\n前言四$http://audio.xmcdn.com/group40/M04/2D/DB/wKgJT1qieIWwUGylACl9eNZHOis859.m4a\r\n第四章 文化1966到1968 前言四 上$http://audio.xmcdn.com/group42/M00/63/9F/wKgJ9FqiUqLQWPx8AJFgTmL1vng534.m4a\r\n第四章 文化1966到1968 前言三下$http://audio.xmcdn.com/group40/M03/2B/33/wKgJVFqiTHWAz3gIADsbDH3MYb0070.m4a\r\n第四章 文化1966到1968 前言三$http://audio.xmcdn.com/group40/M02/09/85/wKgJVFqf9tWDSU52AJBkIIFaPwo828.m4a\r\n第四章 文化1966到1968 前言二$http://audio.xmcdn.com/group41/M03/F9/D4/wKgJ8lqdLFOxFw_cAJXsxZamMC4919.m4a\r\n第四章 文化1966到1968 前言$http://audio.xmcdn.com/group41/M0B/F4/D3/wKgJ8VqdIPzgNl7-AEgENVOsJbk679.m4a\r\n附记$http://audio.xmcdn.com/group41/M06/F4/69/wKgJ8VqdHg6zYh9wAD3Lu9r6HPc163.m4a\r\n第三部分 翻身 九$http://audio.xmcdn.com/group42/M03/BD/FF/wKgJ81qaqj_SbcMtAIAoDUO6bmM114.m4a\r\n第三部分 翻身 八$http://audio.xmcdn.com/group42/M09/B9/6C/wKgJ9FqalZmx22w1AFbv5NmPgMo071.m4a\r\n第三部分 翻身 七$http://audio.xmcdn.com/group42/M00/B9/6B/wKgJ81qajuSDHI5BAMjWlo1gdzE789.m4a\r\n第三部分 翻身 六$http://audio.xmcdn.com/group42/M02/9E/C5/wKgJ81qZWh-DHOOzAIWiajG0iik480.m4a\r\n第三部分 翻身 五$http://audio.xmcdn.com/group41/M00/5C/CC/wKgJ8lqWwVaT76tqAIdKy0itt3k511.m4a\r\n第三部分 翻身 四$http://audio.xmcdn.com/group41/M01/0F/F9/wKgJ8VqT_0bh7Y89AHdlw0QYSeI506.m4a\r\n第三部分 翻身 三$http://audio.xmcdn.com/group42/M0B/0E/18/wKgJ9FqT9r6A5coVAGL4q3WtKmI757.m4a\r\n第三部分 翻身二$http://audio.xmcdn.com/group31/M03/CC/BF/wKgJSVqM5Eywc_zeAGd9yDgIKw4743.m4a\r\n第三部分 翻身 一$http://audio.xmcdn.com/group38/M05/A3/D2/wKgJo1qJLiGDjIZFAGFsMQ2ZtCk715.m4a\r\n第三部分 前言三$http://audio.xmcdn.com/group38/M03/A1/B8/wKgJo1qJDg7RR2udAElZKjVK2wI561.m4a\r\n第三部分 翻身 前言二$http://audio.xmcdn.com/group38/M00/A0/F6/wKgJolqJCKrxi1eMAGlCENX72es974.m4a\r\n第三部分 翻身 前言一$http://audio.xmcdn.com/group39/M01/A2/86/wKgJnlqJBHLBdfGwAEooN0kUTC8345.m4a\r\n第二部分 九（下）$http://audio.xmcdn.com/group38/M0A/A0/85/wKgJolqJAZ2SF1oVAFTB4mhCv-E910.m4a\r\n第二部分 九（上）$http://audio.xmcdn.com/group39/M0A/95/17/wKgJnlqIHbrzc1zqAIaAJYua1SM802.m4a\r\n第二部分 鬼子来了 八$http://audio.xmcdn.com/group39/M08/F7/51/wKgJnlp_8ouR2geBAMSE3Cpo3Ss571.m4a\r\n第二部分 鬼子来了 七$http://audio.xmcdn.com/group38/M01/D8/7A/wKgJolp-yqzQjCvfAFJyGEDpKgc472.m4a\r\n第二部分 鬼子来了 六$http://audio.xmcdn.com/group38/M01/D8/30/wKgJo1p-xbDCEySEAJdOqVjOPFo682.m4a\r\n第二部分 鬼子来了 五$http://audio.xmcdn.com/group38/M0B/D7/70/wKgJo1p-vvTTnC3KAGe5_fvpEaY565.m4a\r\n第二部分 鬼子来了 四$http://audio.xmcdn.com/group38/M09/AE/02/wKgJolp9JTigcsc0AJEDyJKbKxg418.m4a\r\n第二部分 鬼子来了 三$http://audio.xmcdn.com/group39/M02/AE/9B/wKgJn1p9JNjCQG03AHTLFdBX87E906.m4a\r\n第二部分 鬼子来了 二（下）$http://audio.xmcdn.com/group39/M09/AF/1E/wKgJnlp9JHnBkRMRAIBJ1j2SmNs411.m4a\r\n第二部分 鬼子来了 二（上）$http://audio.xmcdn.com/group38/M0B/AD/DB/wKgJolp9JA_TNV4sAIMQk75oQPE639.m4a\r\n第二部分 鬼子来了 一$http://audio.xmcdn.com/group39/M08/63/AC/wKgJnlp6ObeROX-UAJ6OwaH0zH8648.m4a\r\n故乡天下黄花 第一章九$http://audio.xmcdn.com/group39/M0B/05/97/wKgJnlp2nDCi7GA8ANjb76f0bhw235.m4a\r\n故乡天下黄花 第一章八$http://audio.xmcdn.com/group38/M06/E9/15/wKgJolp1fxLQ1Y3zAJ8o83shsxs444.m4a\r\n故乡天下黄花 第一章 七$http://audio.xmcdn.com/group39/M02/A2/E5/wKgJnlpyndKjKxinAJwO49UEL6g329.m4a\r\n故乡天下黄花 第一章 六$http://audio.xmcdn.com/group38/M09/7B/E6/wKgJolpxBB3RPwepAHwbdRdrukY623.m4a\r\n故乡天下黄花 第一章 五$http://audio.xmcdn.com/group38/M05/6F/3F/wKgJo1pwaXvSbe8mAIwlFK9oH3k114.m4a\r\n故乡天下黄花 第一章 四$http://audio.xmcdn.com/group39/M05/64/C8/wKgJn1pwEgSyZfiVAHYFV4inP20399.m4a\r\n故乡天下黄花 第一章 三$http://audio.xmcdn.com/group38/M06/63/9D/wKgJo1pwCwHTQ9euAORO7Gby4b4319.m4a\r\n故乡天下黄花 第一章 二$http://audio.xmcdn.com/group39/M02/62/D6/wKgJn1pwAIWCYIo9AIkWaQJEj8M574.m4a\r\n故乡天下黄花 第一章 一$http://audio.xmcdn.com/group39/M03/63/1A/wKgJnlpwABOQRoEeAHsdTEnLhQw976.m4a', 'xml_8023', '2786', '', 'G', '', '1.0', 4, 0, 0, 0, 'guxiangtianxiahuanghualiuzhenyun', ''),
(131, 24, '少儿版三国演义', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group37/M05/AB/53/wKgJoVpN_93jLKKPAAF1FIgZvNA774.jpg', '', 1530072223, 5, 0, 0, 0, 0, 1, 1, 7, 8, 'ting', '', '第五十一回，分久必合三国归晋（下）本书已完结$http://audio.xmcdn.com/group42/M02/90/E9/wKgJ9FrdGwPB_Jr2AC4FiZG-0p8415.m4a\r\n第五十一回，分久必合三国归晋（上）$http://audio.xmcdn.com/group42/M01/75/20/wKgJ9Frbz_iTq36DACo1M0DToH4852.m4a\r\n第五十回，死诸葛吓走活司马（下）$http://audio.xmcdn.com/group41/M07/58/CC/wKgJ8lraehiztKcnACuy00TYaGI647.m4a\r\n第五十回，死诸葛吓走活司马（上）$http://audio.xmcdn.com/group40/M05/09/FF/wKgJVFrZJgKwTlqMACdSaoiZEy4051.m4a\r\n第四十九回，五丈原诸葛亮归天（下）$http://audio.xmcdn.com/group42/M06/26/B6/wKgJ81rX05aQThgaAC_J0S6VW3g717.m4a\r\n第四十九回，五丈原诸葛亮归天（上）$http://audio.xmcdn.com/group42/M02/12/1D/wKgJ9FrWgjzRFrxCACje5CyYK_8077.m4a\r\n第四十八回，六出祁山蜀魏大战（下）$http://audio.xmcdn.com/group42/M05/F3/66/wKgJ81rVMS-Brt3aAClw9jkpWcI174.m4a\r\n第四十八回，六出祁山蜀魏大战（上）$http://audio.xmcdn.com/group41/M0B/DC/42/wKgJ8VrT50-wpWf5ACjTJOstR9Y130.m4a\r\n第四十七回，孔明二次出师伐魏（下）$http://audio.xmcdn.com/group42/M07/CA/E8/wKgJ81rTLqSxO0jcAC5U1wOD9LU122.m4a\r\n第四十七回，孔明二次出师伐魏（上）$http://audio.xmcdn.com/group42/M09/A8/C8/wKgJ9FrRXubTqB2lACVgncguizI886.m4a\r\n第四十六回，失街亭空城退司马（下）$http://audio.xmcdn.com/group41/M09/8B/A2/wKgJ8VrP7QCzJsxYACxr22IXL6E782.m4a\r\n第四十六回，失街亭空城退司马（上）$http://audio.xmcdn.com/group40/M01/37/BA/wKgJVFrOmfPSbRrBACYryWJQbH8482.m4a\r\n第四十五回，诸葛亮亲征伐中原（下）$http://audio.xmcdn.com/group42/M08/54/36/wKgJ81rNRFHC5b25AC_3VlSsCG8384.m4a\r\n第四十五回，诸葛亮亲征伐中原（上）$http://audio.xmcdn.com/group41/M01/3F/4E/wKgJ8lrL8qLheDuzAClBehKe2gc440.m4a\r\n第四十四回，七擒七纵降服孟获（下）$http://audio.xmcdn.com/group41/M06/24/47/wKgJ8VrKpB2xJphHACurelTMK3w915.m4a\r\n第四十四回，七擒七纵降服孟获（上）$http://audio.xmcdn.com/group42/M02/0E/BF/wKgJ9FrJTsui-wg0AC14k_DfjqY089.m4a\r\n第四十三回，孔明蜀中运筹帷幄（下）$http://audio.xmcdn.com/group42/M00/F1/0A/wKgJ81rIClGyvJd2ACxBRbHE9sE420.m4a\r\n第四十三回，孔明蜀中运筹帷幄（上）$http://audio.xmcdn.com/group41/M09/DA/76/wKgJ8lrGtxiyJ0DrACotWauXy44683.m4a\r\n第四十二回，刘玄德托孤白帝城（下）$http://audio.xmcdn.com/group41/M02/C6/AE/wKgJ8lrFrleBdQwYAC1AxVhbmV4682.m4a\r\n第四十二回，刘玄德托孤白帝城（上）$http://audio.xmcdn.com/group41/M0A/A4/C2/wKgJ8VrEDgrSj_gIADBysRFDeo8358.m4a\r\n第四十一回，曹操寿终曹丕称帝（下）$http://audio.xmcdn.com/group40/M05/51/18/wKgJT1rCsfTyJV86AC_13rOy7D8172.m4a\r\n第四十一回，曹操寿终曹丕称帝（上）$http://audio.xmcdn.com/group41/M05/73/05/wKgJ8VrBan_Te_5mAC2r9gpLqBo244.m4a\r\n第四十回，关云长大意失荆州（下）$http://audio.xmcdn.com/group42/M06/5A/95/wKgJ81rAJTyBVHz-ADJ4pZiHbK4171.m4a\r\n第四十回，关云长大意失荆州（上）$http://audio.xmcdn.com/group42/M09/47/16/wKgJ9Fq-zf3QoqNgACm6ASMUmlA383.m4a\r\n第三十九回，曹操刘备先后称王（下）$http://audio.xmcdn.com/group40/M03/F5/7D/wKgJT1q9c97hGTUKACx5DtOHG0s405.m4a\r\n第三十九回，曹操刘备先后称王（上）$http://audio.xmcdn.com/group42/M08/18/9C/wKgJ9Fq8H06xSlMOAC5ARcWttaQ378.m4a\r\n第三十八回，单刀会关公不让地（下）$http://audio.xmcdn.com/group41/M06/03/C1/wKgJ8Vq61E_wOimfAC_MwETTYwc848.m4a\r\n第三十八回，单刀会关公不让地（上）$http://audio.xmcdn.com/group41/M00/F1/B2/wKgJ8lq5gF-hBw6_ACnbVGOGlRs251.m4a\r\n第三十七回，玄德入川当益州牧（下）$http://audio.xmcdn.com/group42/M01/D9/EF/wKgJ9Fq4LQiR1ebuACwib9bzQwg191.m4a\r\n第三十七回，玄德入川当益州牧（上）$http://audio.xmcdn.com/group40/M00/8F/CA/wKgJT1q3LpmzLQZxADDfkBefTVc605.m4a\r\n第三十六回，曹操马超大战渭水（下）$http://audio.xmcdn.com/group40/M05/76/BA/wKgJT1q1mLyTmLEfACz40Sq_tnQ752.m4a\r\n第三十六回，曹操马超大战渭水（上）$http://audio.xmcdn.com/group42/M0B/9B/EC/wKgJ81q0PFLh3T0BADNFraejI3c410.m4a\r\n第三十五回，三气周瑜孔明吊孝（下）$http://audio.xmcdn.com/group41/M02/87/81/wKgJ8lqy7PfSQwG3ADBii78Xn18635.m4a\r\n第三十五回，三气周瑜孔明吊孝（上）$http://audio.xmcdn.com/group40/M0B/35/F2/wKgJVFqxmafBJzitADIYEddRKgQ451.m4a\r\n第三十四回，甘露寺刘皇叔招亲（下）$http://audio.xmcdn.com/group42/M06/56/D9/wKgJ81qwRDSiX2pdADKB4urFV1M635.m4a\r\n第三十四回，甘露寺刘皇叔招亲（上）$http://audio.xmcdn.com/group42/M04/3E/93/wKgJ9Fqu9jfhfnr2ADKX4aRVhOU643.m4a\r\n第三十三回，刘备收取长沙四郡（下）$http://audio.xmcdn.com/group41/M09/27/2B/wKgJ8Vqt1lfR4w60ADKsldd--xA102.m4a\r\n第三十三回，刘备收取长沙四郡（上）$http://audio.xmcdn.com/group41/M09/0D/DE/wKgJ8VqsZ3CwpiOWACsehGp2RTI951.m4a\r\n第三十二回，智取三城一气周瑜（下）$http://audio.xmcdn.com/group40/M04/BF/72/wKgJT1qrAWSRaXMJACvkv-IMerw447.m4a\r\n第三十二回，智取三城一气周瑜（上）$http://audio.xmcdn.com/group41/M00/E3/0C/wKgJ8lqprYuCdJA1ACrWj2GRMWI834.m4a\r\n第三十一回，华容道关公放曹操（下）$http://audio.xmcdn.com/group40/M06/91/DC/wKgJVFqoXPbQ7np_ACiW8LmCbPU748.m4a\r\n第三十一回，华容道关公放曹操（上）$http://audio.xmcdn.com/group41/M00/B3/FA/wKgJ8VqnDoOx6KQfAC8hKlcYYcs848.m4a\r\n第三十回，巧借东风火烧赤壁（下）$http://audio.xmcdn.com/group42/M04/9E/42/wKgJ81qluviwcDYLACoElGzJaR4411.m4a\r\n第三十回，巧借东风火烧赤壁（上）$http://audio.xmcdn.com/group42/M0B/87/E2/wKgJ81qkghagRYjNACpbOE1o2EE684.m4a\r\n第二十九回，草船借箭曹操中计（下）$http://audio.xmcdn.com/group42/M0B/70/19/wKgJ9FqjIc6Q20KwAC3Nvx7yWik143.m4a\r\n第二十九回，草船借箭曹操中计（上）$http://audio.xmcdn.com/group41/M05/5E/38/wKgJ8lqhx3HCZkBjACyx_4GGxjo777.m4a\r\n第二十八回，群英会上蒋干盗书（下）$http://audio.xmcdn.com/group40/M08/0D/AD/wKgJT1qgdOrzIVSgACuJ6821fso775.m4a\r\n第二十八回，群英会上蒋干盗书（上）$http://audio.xmcdn.com/group41/M08/2B/F2/wKgJ8lqfJD7T0MV4ADK-EcnWtQM768.m4a\r\n第二十七回，智激周瑜孙刘联合（下）$http://audio.xmcdn.com/group42/M06/07/53/wKgJ81qd0RDxJZ26ADLXBSjYC6w696.m4a\r\n第二十七回，智激周瑜孙刘联合（上）$http://audio.xmcdn.com/group41/M07/E9/44/wKgJ8lqcfgKD_AteACzrmcCnf5Y857.m4a\r\n第二十六回，孔明江东舌战群儒（下）$http://audio.xmcdn.com/group41/M0B/C6/A3/wKgJ8lqbJjGjwL4mACzxe45Y8C0577.m4a\r\n第二十六回，孔明江东舌战群儒（上）$http://audio.xmcdn.com/group41/M06/89/CE/wKgJ8lqYmAXCgH-wAC3pB603zoc127.m4a\r\n第二十五回，长坂坡赵云勇救主（下）$http://audio.xmcdn.com/group42/M04/6B/6A/wKgJ9FqXcUyR5iR-ADP3DdE0Pe8890.m4a\r\n第二十五回，长坂坡赵云勇救主（上）$http://audio.xmcdn.com/group41/M08/40/98/wKgJ8lqV_DXhUgsvADBIG9yOfZE987.m4a\r\n第二十四回，博望坡孔明露锋芒（下）$http://audio.xmcdn.com/group42/M04/1D/0B/wKgJ81qUpnKBNYR7ADEaFrfdjzk659.m4a\r\n第二十四回，博望坡孔明露锋芒（上）$http://audio.xmcdn.com/group32/M03/B4/E0/wKgJS1qTWKCht3GHADBTsglqzr8674.m4a\r\n第二十三回，三顾茅庐孔明出山（下）$http://audio.xmcdn.com/group20/M02/08/17/wKgJJ1qSAgDgg89bABcu-5EXBhg781.m4a\r\n第二十三回，三顾茅庐孔明出山（上）$http://audio.xmcdn.com/group18/M02/04/07/wKgJJVqQtD6QqtyvACpLDX1344A427.m4a\r\n第二十二回，刘备投刘表得徐庶（下）$http://audio.xmcdn.com/group2/M00/48/B4/wKgJRVqPZlrQyaWyACpBO-Wmc1Y228.m4a\r\n第二十二回，刘备投刘表得徐庶（上）$http://audio.xmcdn.com/group27/M0B/23/FB/wKgJR1qOEknjYNgxACZSHnXryVo698.m4a\r\n第二十一回，官渡之战袁绍被灭（下）$http://audio.xmcdn.com/group26/M04/25/E4/wKgJWFqMyMKiHj2VAC1_6FcAULY589.m4a\r\n第二十一回，官渡之战袁绍被灭（上）$http://audio.xmcdn.com/group35/M0B/4A/01/wKgJnFqLgJOwHfDkADLixTyA1BI095.m4a\r\n第二十回，古城会三兄弟重逢（下）$http://audio.xmcdn.com/group39/M05/9E/A4/wKgJnlqI0fKw0J_zAB4idAJb1_A207.m4a\r\n第二十回，古城会三兄弟重逢（上）$http://audio.xmcdn.com/group38/M02/8E/8F/wKgJolqH4YqyTVZqACh7EZ0YGGA587.m4a\r\n第十九回，关羽过五关斩六将（下）$http://audio.xmcdn.com/group38/M05/73/C9/wKgJolqGKxaSGP7_ACyNoK38EYE365.m4a\r\n第十九回，关羽过五关斩六将（上）$http://audio.xmcdn.com/group39/M04/2F/50/wKgJn1qCVTPQWyOPACz_3yBFxgw001.m4a\r\n第十八回，屯土山关公约三事（下）$http://audio.xmcdn.com/group38/M03/0C/EF/wKgJolqA6I3x64W6ADAyEgkIrC8865.m4a\r\n第十八回，屯土山关公约三事（上）$http://audio.xmcdn.com/group39/M09/0D/BD/wKgJn1qA5VvAcy-1ACjNQlfoLgA465.m4a\r\n第十七回，祢衡恃才击鼓骂曹（下）$http://audio.xmcdn.com/group39/M01/CB/12/wKgJnlp-QcXAAJBKACqb00SDwuo343.m4a\r\n第十七回，祢衡恃才击鼓骂曹（上）$http://audio.xmcdn.com/group39/M08/A7/DE/wKgJn1p87SfyUhXlACgzFazEFsY911.m4a\r\n第十六回，曹孟德煮酒论英雄（下）$http://audio.xmcdn.com/group38/M06/85/A6/wKgJolp7mUijNeurACX33GSb7oA471.m4a\r\n第十六回，曹孟德煮酒论英雄（上）$http://audio.xmcdn.com/group39/M09/64/99/wKgJnlp6SAHQoS1CACPM0Qn36ow266.m4a\r\n第十五回，国舅董承得衣带诏（下）$http://audio.xmcdn.com/group38/M04/41/88/wKgJolp48mvz1TZWACXmdGv3T4w521.m4a\r\n第十五回，国舅董承得衣带诏（上）$http://audio.xmcdn.com/group39/M0B/31/11/wKgJnlp4ODbRyv83ADEt8is-qOA575.m4a\r\n第十四回，白门楼吕布丢性命（下）$http://audio.xmcdn.com/group38/M09/0F/5E/wKgJo1p28nvhgbbHABw7Ujj2_nA720.m4a\r\n第十四回，白门楼吕布丢性命（上）$http://audio.xmcdn.com/group39/M0B/EC/D8/wKgJnlp1llexjPBuADIf861ik44045.m4a\r\n第十三回，袁术寿春称帝梦破（下）$http://audio.xmcdn.com/group39/M0A/CB/F9/wKgJn1p0SFOB9W3mACiMpyiID-4503.m4a\r\n第十三回，袁术寿春称帝梦破（上）$http://audio.xmcdn.com/group39/M0A/AC/8B/wKgJn1py-aahluH_ADrjPmxzme8062.m4a\r\n第十二回，战宛城曹操险丧命（下）$http://audio.xmcdn.com/group38/M0A/7C/49/wKgJo1pxBvOQDQTQAC4bkefvbsk323.m4a\r\n第十二回，战宛城曹操险丧命（上）$http://audio.xmcdn.com/group38/M0B/5B/0C/wKgJolpvsA7SC--zACx6d3vdIC4547.m4a\r\n第十一回，吕布小沛辕门射戟（下）$http://audio.xmcdn.com/group38/M0A/48/2C/wKgJo1pu73SCxYjTAClGVnIgq08346.m4a\r\n第十一回，吕布小沛辕门射戟（上）$http://audio.xmcdn.com/group39/M0A/13/74/wKgJn1ptDrLgrYmPACj_MvxUeKM838.m4a\r\n第十回，曹操挟天子以令诸侯（下）$http://audio.xmcdn.com/group39/M05/F4/9C/wKgJn1prv7mySThcACyml-g2ZMg399.m4a\r\n第十回，曹操挟天子以令诸侯（上）$http://audio.xmcdn.com/group38/M06/E7/47/wKgJo1prDhKQhCFLADK1QFKuFW0534.m4a\r\n第九回，为救民三次让徐州（下）$http://audio.xmcdn.com/group39/M07/C9/D8/wKgJnlppx0Dg0PXbACtNgPxij0A067.m4a\r\n第九回，为救民三次让徐州（上）$http://audio.xmcdn.com/group39/M02/98/E8/wKgJnlpn1tvyS4whAC1N_elPO2Q563.m4a\r\n第八回，报父仇曹操大兴兵（下）$http://audio.xmcdn.com/group39/M0B/73/E9/wKgJnlpmdweBBJyhAC-B3COUGC4201.m4a\r\n第八回，报父仇曹操大兴兵（上）$http://audio.xmcdn.com/group39/M08/1B/26/wKgJn1pivbGAdoniAC22yRgPj8Q275.m4a\r\n第七回，连环计吕布戏貂蝉（下）$http://audio.xmcdn.com/group27/M05/1B/C6/wKgJW1phKojB0XeFACjBAd9X_Gw548.m4a\r\n第七回，连环计吕布戏貂蝉（上）$http://audio.xmcdn.com/group31/M08/C3/D7/wKgJSVpf1u3w6tDYACbFfZilT9M030.m4a\r\n第六回，十八路诸侯自争斗（下）$http://audio.xmcdn.com/group36/M06/E1/0D/wKgJTVpeh33zE6AaAC54E9KP4ow399.m4a\r\n第六回，十八路诸侯自争斗（上）$http://audio.xmcdn.com/group19/M05/EE/40/wKgJJlpdNBGg38cnAC81gTivF9o104.m4a\r\n第五回，虎牢关三英战吕布（下）$http://audio.xmcdn.com/group28/M07/8A/1F/wKgJXFpb4uXxyKGIACq2QlxDJWI465.m4a\r\n第五回，虎牢关三英战吕布（上）$http://audio.xmcdn.com/group26/M0A/12/74/wKgJWFpaqH7DZXeUACRNdlkgpwE073.m4a\r\n第四回，关云长温酒斩华雄（下）$http://audio.xmcdn.com/group27/M08/0C/AA/wKgJR1pZ1QWiEGgoACnwA33AEJc683.m4a\r\n第四回，关云长温酒斩华雄（上）$http://audio.xmcdn.com/group23/M06/06/64/wKgJL1pX7H2SwZCMAB2zp84t_qg173.m4a\r\n第三回，捉放曹错杀吕伯奢（下）$http://audio.xmcdn.com/group23/M06/03/8A/wKgJNFpWnMmiTemPACWlnkMw6Kg633.m4a\r\n第三回，捉放曹错杀吕伯奢（上）$http://audio.xmcdn.com/group23/M08/00/E6/wKgJNFpVTpzzvfDRACmuaQiowA8763.m4a\r\n第二回，刺董卓曹操假献刀（下）$http://audio.xmcdn.com/group37/M03/34/6E/wKgJoFpT9WzSjBIeACSsxIH4Z7I175.m4a\r\n第二回，刺董卓曹操假献刀（上）$http://audio.xmcdn.com/group36/M06/98/73/wKgJTVpSp0nC0102AC_H8FgWvFc763.m4a\r\n第一回，宴桃园豪杰三结义（下）$http://audio.xmcdn.com/group37/M05/F6/71/wKgJoFpRYjiyDZiBAC0Xpnl6v18853.m4a\r\n第一回，宴桃园豪杰三结义（上）$http://audio.xmcdn.com/group36/M04/0C/EB/wKgJUlpQGbqiYBMSADptxa6GcG8960.m4a', 'xml_8023', '2784', '', 'S', '', '1.0', 5, 0, 0, 0, 'shaoerbansanguoyanyi', ''),
(132, 24, '我今天试着录了几段童话故事', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group41/M03/8A/25/wKgJ8VrcnWSzMxHQAAIGJfB_2MY628.jpg', '', 1530072223, 9, 0, 0, 0, 0, 1, 1, 10, 10, 'ting', '', '【直播回听】聊天、PIA戏、扯犊子！$http://audio.xmcdn.com/group40/M02/51/80/wKgJT1rcoVLRtHavAsU1jfnw6Zg430.m4a', 'xml_8023', '2785', '', 'W', '', '1.0', 2, 0, 0, 0, 'wojintianshizhoululiaojiduantonghuagushi', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(133, 24, '庆余年', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group32/M06/D0/43/wKgJnFmkM7jTwjT5AAGFsLsxneQ247.jpg', '', 1530072223, 5, 0, 0, 0, 0, 1, 1, 5, 2, 'ting', '', '庆余年楔子$http://audio.xmcdn.com/group28/M04/07/A9/wKgJXFlRGYTRuimRAK3ZnMYYzpE025.m4a\r\n庆余年1故事会$http://audio.xmcdn.com/group28/M09/06/40/wKgJSFlRHI-DE749AE4072LejqI909.m4a\r\n庆余年2无名黄书$http://audio.xmcdn.com/group29/M06/10/39/wKgJWVlSAUqDfGxWAFCZQwPLkCg556.m4a\r\n庆余年3练功与读书$http://audio.xmcdn.com/group29/M06/19/DB/wKgJXVlSfMfi-QvHAEn6sv1O1YM264.m4a\r\n庆余年4深夜来客$http://audio.xmcdn.com/group28/M06/22/D3/wKgJSFlTK7LxotrwAEmeMK9pUOs566.m4a\r\n庆余年5闷枕$http://audio.xmcdn.com/group28/M02/24/F3/wKgJXFlTNCuxditjAEVp0NBcjbY659.m4a\r\n庆余年6来者是客$http://audio.xmcdn.com/group29/M06/21/A2/wKgJXVlTNw2BBIY8AEqByTHDWHE098.m4a\r\n庆余年7坟场$http://audio.xmcdn.com/group29/M09/26/8D/wKgJWVlTh2uQbk0_AFNi7Rt9ieQ601.m4a\r\n庆余年8年龄不是问题$http://audio.xmcdn.com/group29/M07/26/7C/wKgJXVlTjAKSzBdzADVHIXXzIM4985.m4a\r\n庆余年9不耻而问$http://audio.xmcdn.com/group29/M02/31/E1/wKgJWVlUhcriX5zIAFDMqg-HW3k814.m4a\r\n庆余年10五大宗师？$http://audio.xmcdn.com/group29/M0B/31/E3/wKgJXVlUjE_D-6GfAFlBIbSM-a4916.m4a\r\n庆余年11霸道之气$http://audio.xmcdn.com/group28/M06/3E/4A/wKgJSFlVIbeAGki2ADU4dgTe7KY839.m4a\r\n庆余年12简单粗暴的解释$http://audio.xmcdn.com/group29/M0B/56/FF/wKgJXVlXb5CAH-A3ADObZiJQ78I130.m4a\r\n庆余年13谁是贩盐的老辛$http://audio.xmcdn.com/group29/M04/5D/C6/wKgJXVlXyNPwOKPgAEr5ierUgvM153.m4a\r\n庆余年14暂别费介$http://audio.xmcdn.com/group28/M09/60/28/wKgJSFlXzKWylHsoACUSApZdcOw027.m4a\r\n庆余年15京都来信$http://audio.xmcdn.com/group29/M08/63/99/wKgJWVlYbWfSfm4mAEd-3j-y6jc136.m4a\r\n庆余年16我把菜刀献给你$http://audio.xmcdn.com/group28/M01/67/4C/wKgJXFlYcpHSpcxwACWeT358mII832.m4a\r\n庆余年17血泪的继续$http://audio.xmcdn.com/group29/M03/63/CC/wKgJXVlYd37RhdSfAEb8LCrmRCA165.m4a\r\n庆余年18脸面问题$http://audio.xmcdn.com/group29/M01/64/59/wKgJWVlYezySAbkQAFIVlryYLRY639.m4a\r\n庆余年19站在高岗上$http://audio.xmcdn.com/group29/M00/64/82/wKgJWVlYfjng69y-AE8f4o3OL2U037.m4a\r\n庆余年20痛$http://audio.xmcdn.com/group29/M01/74/83/wKgJXVlZxcGQWyCoAC9B5MaTMPI573.m4a\r\n庆余年21骚客$http://audio.xmcdn.com/group28/M03/76/C4/wKgJSFlZxqqA9ra8AEa0OIdbgDs414.m4a\r\n庆余年22猫扣子$http://audio.xmcdn.com/group29/M06/75/19/wKgJWVlZyZjhuuMmAEvMMeovWpk693.m4a\r\n庆余年23刺客$http://audio.xmcdn.com/group28/M07/78/C5/wKgJXFlZzUbRr0neAEja4Mbmc5Y062.m4a\r\n庆余年24豆腐如玉$http://audio.xmcdn.com/group28/M00/8B/27/wKgJXFlbGSTyyVDIAEfPnxfQuac801.m4a\r\n庆余年25盖羊毛毯的老人$http://audio.xmcdn.com/group28/M01/8B/5B/wKgJXFlbHGzDNfebACz9PBrBxTw474.m4a\r\n庆余年26监察院$http://audio.xmcdn.com/group28/M0B/8B/CD/wKgJXFlbI_mREpKgAGdHdqULXAs728.m4a\r\n庆余年27红袖添香夜抄书$http://audio.xmcdn.com/group29/M08/9B/20/wKgJXVlcbRbTWMrAAEoz99s9o5c015.m4a\r\n庆余年28书贼$http://audio.xmcdn.com/group29/M09/9B/B8/wKgJWVlccY_zy_d7ACzCL64-N18413.m4a\r\n庆余年29往事$http://audio.xmcdn.com/group29/M09/9C/25/wKgJWVlceAiBIIEkAFUc7FE261s874.m4a\r\n庆余年30有歌者来$http://audio.xmcdn.com/group29/M02/AE/B9/wKgJXVldvw7hZFAeAC8dWPCJFEE936.m4a\r\n庆余年31倾船$http://audio.xmcdn.com/group28/M0B/B2/8B/wKgJXFldwhPz0sdPAElk62XdUL8575.m4a\r\n庆余年32闲年$http://audio.xmcdn.com/group29/M07/AF/73/wKgJWVldxqCQjECSAEy9Al6_wH4318.m4a\r\n庆余年33竹帅$http://audio.xmcdn.com/group28/M02/C5/77/wKgJXFlfDa3R0kkmAC3kfbpRxUU583.m4a\r\n庆余年34雨夜回忆$http://audio.xmcdn.com/group29/M03/C1/D6/wKgJXVlfEUfTEO7BAE7mneo72J8336.m4a\r\n庆余年35庆历四年春$http://audio.xmcdn.com/group29/M01/C2/48/wKgJWVlfFXHyU0eUAEwIZeU53E8101.m4a\r\n庆余年36去京都？$http://audio.xmcdn.com/group29/M01/C2/80/wKgJWVlfGPCxN1onAC5yg35qqKg189.m4a\r\n庆余年37前夜$http://audio.xmcdn.com/group29/M05/D6/15/wKgJWVlghZejCg2QAEw7ydwdkbs560.m4a\r\n庆余年38离开澹州$http://audio.xmcdn.com/group28/M0A/D8/6A/wKgJSFlgiHmCynbBAC41PlU4wdM786.m4a\r\n庆余年39望京$http://audio.xmcdn.com/group29/M01/D6/89/wKgJXVlgkJyw9NzEAEzV-iLOp4U779.m4a\r\n关于猫腻的庆余年 犯贱之喜欢$http://audio.xmcdn.com/group28/M00/F2/EE/wKgJXFliNqaAHFblAEy-emkDmfc608.m4a\r\n庆余年2卷1章$http://audio.xmcdn.com/group29/M04/EF/7D/wKgJXVliOsChNMM9AEwORNF4Ooc539.m4a\r\n庆余年2卷2章$http://audio.xmcdn.com/group28/M08/F3/CD/wKgJXFliPk3j2soVACgLSdrEdOo152.m4a\r\n庆余年2卷3章$http://audio.xmcdn.com/group28/M0A/F2/A9/wKgJSFliQZPDCPeYAC51IoI5uHM559.m4a\r\n庆余年2卷4父子$http://audio.xmcdn.com/group28/M05/F3/08/wKgJSFliRYzBa17HACzkpMtRV6E237.m4a\r\n庆余年2卷5京中密辛$http://audio.xmcdn.com/group28/M02/FB/C0/wKgJXFljBKLCDrGqAEvpkFjhT9c082.m4a\r\n庆余年2卷6他乡遇故知$http://audio.xmcdn.com/group28/M06/FA/85/wKgJSFljCMXAkbwdAE62JZcX0QE214.m4a\r\n庆余年2卷7红宝书$http://audio.xmcdn.com/group29/M02/F8/79/wKgJXVljDGTRPJhYAEw16yAFZYM870.m4a\r\n庆余年2卷8地摊文学$http://audio.xmcdn.com/group29/M01/03/99/wKgJXVljmA2CB7nzAFQQNOHlkek855.m4a\r\n庆余年2卷9在酒楼上$http://audio.xmcdn.com/group28/M01/07/E2/wKgJXFljngCRDpnYADFqN37up9A490.m4a\r\n庆余年2卷10什么叫风骨$http://audio.xmcdn.com/group29/M08/0B/5A/wKgJWVlkWvuQ9EA2AEezuOiUrUM880.m4a\r\n庆余年2卷11靖王世子$http://audio.xmcdn.com/group29/M01/0B/8C/wKgJWVlkXkPi_seNADHS_3TVOHs476.m4a\r\n庆余年2卷12马车上$http://audio.xmcdn.com/group29/M05/12/28/wKgJWVlkvSGQe69cAFF1h8gd3O0395.m4a\r\n庆余年2卷13独行$http://audio.xmcdn.com/group28/M07/1F/FC/wKgJSFllq4ODsVhrAEr7qU_kXOg694.m4a\r\n庆余年2卷14监察院内外$http://audio.xmcdn.com/group29/M02/1E/4A/wKgJWVllr1mxbGpLACnTOJwPGmI612.m4a\r\n庆余年2卷15糖葫芦与庆庙$http://audio.xmcdn.com/group28/M0A/24/A8/wKgJSFll9XuhGk-BAEg8SOySL6Y883.m4a\r\n庆余年2卷16贵人$http://audio.xmcdn.com/group29/M01/22/B7/wKgJXVll-oSAH7CSAEwXFQTUgj0849.m4a\r\n庆余年2卷17心动$http://audio.xmcdn.com/group28/M00/41/25/wKgJSFlniCySW7t6AExGETA8VZM802.m4a\r\n庆余年2卷18缘来是她$http://audio.xmcdn.com/group29/M01/3F/D5/wKgJWVlnjFCjjptVACzWvg_4_uY402.m4a\r\n庆余年2卷19算账少年$http://audio.xmcdn.com/group28/M03/42/18/wKgJSFlnjyKyeIkrAEv1TCqjMco447.m4a\r\n庆余年2卷20兄妹闲叙$http://audio.xmcdn.com/group29/M01/49/CF/wKgJXVloRpfDJ55ZACorktClFnc334.m4a\r\n庆余年2卷21计划书$http://audio.xmcdn.com/group28/M03/4C/4F/wKgJSFloSc6QnEeuACxrqDo0SyE868.m4a\r\n庆余年2卷22早夏$http://audio.xmcdn.com/group29/M07/4A/9B/wKgJWVloTLTxfjqcAEakEboTMWQ305.m4a\r\n庆余年2卷23简单的理由$http://audio.xmcdn.com/group26/M08/EE/E4/wKgJRllq4hbi61pMACwqdPJilSI061.m4a\r\n庆余年2卷24初吟$http://audio.xmcdn.com/group29/M08/61/25/wKgJXVlq5aGSSCXBAEP8LEi_fuo185.m4a\r\n庆余年2卷25王府$http://audio.xmcdn.com/group26/M08/F2/CE/wKgJWFlrWeqhyj0lAEiYzXJpKmA290.m4a\r\n庆余年2卷26又遇郭保坤$http://audio.xmcdn.com/group2/M02/10/D7/wKgJRFlrXS3xj49BAConbz1vGgo524.m4a\r\n庆余年2卷27湖那边$http://audio.xmcdn.com/group2/M00/10/F6/wKgJRVlrX52j9eIzACpTP_MXFqc818.m4a\r\n庆余年2卷28出诗打人第一记$http://audio.xmcdn.com/group27/M03/EF/3F/wKgJR1lrY5Lz28_hADD5XK1HCsY440.m4a\r\n庆余年2卷29抛诗砸人$http://audio.xmcdn.com/group29/M09/65/1C/wKgJWVlrZq6T2smbADHoU-4PTjk232.m4a\r\n庆余年2卷30靖王发话$http://audio.xmcdn.com/group27/M03/EF/94/wKgJR1lra6bRJFBKAC-BU0FYIbU375.m4a\r\n庆余年2卷31司理理$http://audio.xmcdn.com/group27/M09/F4/E4/wKgJR1ltjp6wQI_cAEbY7LSQBrk381.m4a\r\n庆余年2卷32如兰$http://audio.xmcdn.com/group19/M06/CF/B8/wKgJK1ltkWiwN946ACwL0gKPbvA722.m4a\r\n庆余年2卷33麻袋之痛$http://audio.xmcdn.com/group19/M05/CF/9D/wKgJJlltlGqiOvFeAEsNTPCFxmU604.m4a\r\n庆余年2卷34官司临头$http://audio.xmcdn.com/group30/M06/26/5E/wKgJXllu6VLwhfUAAD8OZrwwAFU700.m4a\r\n大官人2卷35公堂内外的相声$http://audio.xmcdn.com/group30/M09/26/CC/wKgJXllu7T6TSPLaAGg20OtlClM988.m4a\r\n庆余年2卷36讼$http://audio.xmcdn.com/group31/M05/28/50/wKgJX1lwL2jQHQu3AHJ-Po_jwkU288.m4a\r\n庆余年2卷37宫中$http://audio.xmcdn.com/group30/M06/4E/3B/wKgJXllwNJnwFnt-AHdCg7hepmA016.m4a\r\n庆余年2卷38耳光$http://audio.xmcdn.com/group31/M08/29/1B/wKgJSVlwOXnRUmZbAEka7YmjFB0130.m4a\r\n庆余年2卷39太后圣明$http://audio.xmcdn.com/group31/M09/3A/D2/wKgJX1lxe8zR7EHNAHdMy9SS6lE027.m4a\r\n庆余年2卷40探未婚妻去$http://audio.xmcdn.com/group31/M01/56/07/wKgJSVlzWE_hFgJMAEGdZD4aYoo799.m4a\r\n庆余年2卷41登堂$http://audio.xmcdn.com/group31/M03/56/73/wKgJSVlzXGWzlzItAEyJXF3u1VM825.m4a\r\n庆余年2卷42入室$http://audio.xmcdn.com/group30/M02/AA/FA/wKgJXllzZwmATShIAIH8Mf9ouS4156.m4a\r\n庆余年2卷43破窗$http://audio.xmcdn.com/group31/M01/62/23/wKgJX1l0U2SC6_8IAGVXIJBZz-g034.m4a\r\n庆余年2卷44交错时光的爱恋$http://audio.xmcdn.com/group31/M0A/6B/CD/wKgJSVl0x1bCkRtWAIpvgO7Om8I061.m4a\r\n庆余年2卷45族学$http://audio.xmcdn.com/group30/M04/DF/26/wKgJXll1c97iBvtXAH8ir1HFrP0302.m4a\r\n庆余年2卷46庆余堂的掌柜$http://audio.xmcdn.com/group31/M04/71/F3/wKgJX1l1eb-ynqZSAESpNym6ZeI347.m4a\r\n庆余年2卷47夫妻夜话$http://audio.xmcdn.com/group31/M02/72/5A/wKgJSVl1fpSxxOqBADrVExXBkDg214.m4a\r\n庆余年2卷48蚂蚁上树？$http://audio.xmcdn.com/group31/M07/78/AF/wKgJX1l13V3ApVCHAGNVLZfl43A601.m4a\r\n庆余年2卷49牛栏街少年杀人事件$http://audio.xmcdn.com/group30/M0A/EE/3A/wKgJXll143DS1tqCAGSWwxRr3_U492.m4a\r\n庆余年2卷50调查$http://audio.xmcdn.com/group30/M0A/08/17/wKgJXll20OvA7gBHAEj3QasDTZ8456.m4a\r\n庆余年2卷51范闲在行动$http://audio.xmcdn.com/group30/M0A/3C/64/wKgJXll4d6_wT3vHAGw160z9BQQ747.m4a\r\n庆余年2卷52王启年的人生$http://audio.xmcdn.com/group31/M04/A0/A2/wKgJX1l4fP3Q5onoAI_fkKRKU-M005.m4a\r\n庆余年2卷53沧州城外话京都$http://audio.xmcdn.com/group30/M03/3E/BE/wKgJXll4hYTCu-mtAE9ByQEWEa0565.m4a\r\n庆余年2卷54协律郎独占花魁$http://audio.xmcdn.com/group31/M0B/B7/0B/wKgJSVl55HXAqs2fAD7CvcMEbkk378.m4a\r\n庆余年2卷55偷香不误卖书功$http://audio.xmcdn.com/group31/M05/B7/9F/wKgJSVl56d2QqmCNAERlWsn4Iqc845.m4a\r\n庆余年2卷56澹泊书局$http://audio.xmcdn.com/group30/M02/6B/63/wKgJXll57YiSu4Q0AGSZsqY154o884.m4a\r\n庆余年2卷57参将自杀$http://audio.xmcdn.com/group30/M07/7F/B3/wKgJXll6zNXQFHelAHAG0T0W0fQ044.m4a\r\n庆余年2卷58天牢欺弱女$http://audio.xmcdn.com/group30/M01/80/51/wKgJXll60SahdfeUAG0eUcRU6I8762.m4a\r\n庆余年2卷59言辞若香$http://audio.xmcdn.com/group31/M07/CC/06/wKgJX1l7TAbgBiw3AKHGjHWgLEk467.m4a\r\n庆余年2卷60葡萄架倒了$http://audio.xmcdn.com/group31/M04/D6/AF/wKgJX1l8MxXwahgmAHEDYrEc66Y834.m4a\r\n庆余年2卷61$http://audio.xmcdn.com/group31/M09/D7/14/wKgJX1l8OLPjcKUfAEQlMcZbRGg159.m4a\r\n庆余年2卷62御前栽赃$http://audio.xmcdn.com/group31/M0B/D7/8B/wKgJX1l8P7HgNrJaAFPzERkyjMQ673.m4a\r\n庆余年2卷63破题$http://audio.xmcdn.com/group31/M0A/E3/FA/wKgJX1l9SSDRKFusAIHHoXGUs_s748.m4a\r\n庆余年2卷64那个女人$http://audio.xmcdn.com/group31/M04/E4/49/wKgJSVl9TWyzyMzoAHfZxTQc6n0534.m4a\r\n庆余年2卷65夏至$http://audio.xmcdn.com/group30/M09/C4/C9/wKgJXll9Ueaxaj2DAEVRaNhK01Q496.m4a\r\n庆余年3卷1田庄$http://audio.xmcdn.com/group31/M08/F8/3C/wKgJSVl-vNbSDO_LAGRUrWJ5A0Y089.m4a\r\n庆余年3卷2山里的月光$http://audio.xmcdn.com/group30/M01/F6/2A/wKgJXll_BrCAzSmBAGOS2XJawHU708.m4a\r\n庆余年3卷3对河一拜$http://audio.xmcdn.com/group31/M07/FD/83/wKgJSVl_CpqjkAqtAD9ZaakhaBc744.m4a\r\n庆余年3卷4故人相见不相识$http://audio.xmcdn.com/group31/M00/16/30/wKgJX1mAmgHBmcbxAHLgovP5wLY357.m4a\r\n庆余年3卷5庆余堂里说来年$http://audio.xmcdn.com/group30/M0A/28/E1/wKgJXlmAngqRAeZCAD2kz5EXx3E176.m4a\r\n庆余年3卷6点卯$http://audio.xmcdn.com/group30/M04/29/8B/wKgJXlmAotyxtjBqAEVPvqbfB6Y406.m4a\r\n庆余年3卷7风起于萍末$http://audio.xmcdn.com/group31/M01/27/65/wKgJX1mB2EzRniYTAET3YqL556U964.m4a\r\n庆余年3卷8关于黑拳的光荣传统$http://audio.xmcdn.com/group31/M06/28/2C/wKgJSVmB3VSC0d4BAG0G1KgGzd4981.m4a\r\n庆余年3卷9大劈棺与小手段$http://audio.xmcdn.com/group31/M0A/28/A7/wKgJSVmB4fDiMhAqAGrr6V20B-w058.m4a\r\n庆余年3卷10送山送水送翠壶$http://audio.xmcdn.com/group31/M0B/3A/16/wKgJX1mDH7eBya8uAHKzHbmhC4s420.m4a\r\n庆余年3卷11避暑何需时$http://audio.xmcdn.com/group31/M09/3B/10/wKgJSVmDJyzhMqGTAG1yBWy8--Q824.m4a\r\n庆余年3卷12湖畔吹来孜然风$http://audio.xmcdn.com/group30/M09/72/BE/wKgJXlmDKw6jSuogADmNGC0H1LM322.m4a\r\n庆余年3卷13妖精吵架的典故$http://audio.xmcdn.com/group30/M04/84/DA/wKgJXlmD-y7h5XnzAELvf-Hb_Ns213.m4a\r\n庆余年3卷14夏日觅得一枝梅$http://audio.xmcdn.com/group30/M04/85/BC/wKgJXlmD_-7BCTDtAGZWoYL5cFM553.m4a\r\n庆余年3卷15太子驾到$http://audio.xmcdn.com/group31/M01/45/76/wKgJX1mEBXrgegM3AEkLDx3RnaY316.m4a\r\n庆余年3卷16升官还是倒霉$http://audio.xmcdn.com/group31/M04/5C/83/wKgJSVmFlbOxHr38AGHDwO6uM3g585.m4a\r\n庆余年3卷17箱子毒针杀杀人$http://audio.xmcdn.com/group30/M04/B6/BF/wKgJXlmFpjbhRlckAOoOY-NEXb0977.m4a\r\n庆余年3卷18北齐来使$http://audio.xmcdn.com/group31/M05/5E/11/wKgJX1mFrRWDxs1-AGlCENzvcgM068.m4a\r\n庆余年3卷19谈判无艺术$http://audio.xmcdn.com/group30/M06/B8/98/wKgJXlmFtMeQAHN0AGbgrHokYIE092.m4a\r\n庆余年3卷20老辣辛少卿$http://audio.xmcdn.com/group31/M02/61/8D/wKgJSVmF1zyRC5e6AGoAR0FAN34941.m4a\r\n庆余年3卷21东宫之中堪贤愚$http://audio.xmcdn.com/group30/M00/DF/AF/wKgJXlmHGnDiRWbPAH2hPyEtwUQ069.m4a\r\n庆余年3卷22这世上没有值得相信的人$http://audio.xmcdn.com/group31/M06/72/B9/wKgJSVmHHxGBz8CfAG09pZTbgPA146.m4a\r\n庆余年3卷23那座凉沁沁的皇宫$http://audio.xmcdn.com/group31/M01/73/91/wKgJSVmHJyLTcaJvAG8mJg1ai-8559.m4a\r\n庆余年3卷24娘娘们$http://audio.xmcdn.com/group30/M07/02/02/wKgJXlmIXW7TaeswAG7bQ8VNpSM363.m4a\r\n庆余年3卷25穿过你的黑发的我的手$http://audio.xmcdn.com/group30/M0B/03/14/wKgJXlmIYsjhWzLzAG9DhdMYSdA257.m4a\r\n庆余年3卷26匆匆回府$http://audio.xmcdn.com/group31/M04/84/74/wKgJX1mIZ4OS4WzmAGkUIaX9t1g142.m4a\r\n庆余年3卷27惊闻北国言君事$http://audio.xmcdn.com/group31/M02/84/D5/wKgJSVmIa9XADbzlAG3u2JVWh2I867.m4a\r\n庆余年3卷28污水下的协议$http://audio.xmcdn.com/group30/M03/2E/22/wKgJXlmJz-uCLocTAIEzUjaJbrA046.m4a\r\n庆余年3卷29夜宴$http://audio.xmcdn.com/group31/M09/A0/CF/wKgJSVmJ2zmDP8fXAQqhiCzpjKc518.m4a\r\n庆余年3卷30千古风流$http://audio.xmcdn.com/group30/M0B/31/24/wKgJXlmJ5KyxPi_1AOJgl-_jiW0684.m4a\r\n庆余年3卷31醉中早有入宫意$http://audio.xmcdn.com/group30/M02/4B/B3/wKgJXlmLAGWw87_TAEUlhReOhrA088.m4a\r\n庆余年3卷32洪公公$http://audio.xmcdn.com/group30/M0B/4C/E1/wKgJXlmLBbOCBMQPAFKfHfeANLI390.m4a\r\n庆余年3卷33每个人心中都有一把钥匙$http://audio.xmcdn.com/group31/M09/BE/C9/wKgJSVmLCfywNJwaAEtKhmZMMOE309.m4a\r\n庆余年3卷34广信宫$http://audio.xmcdn.com/group30/M01/92/C6/wKgJXlmNb7ThDBXGAEL3Se3DVv0993.m4a\r\n庆余年3卷35谁是刺客$http://audio.xmcdn.com/group31/M0A/04/74/wKgJSVmNdQ_wCroDAER6FRooEsU957.m4a\r\n庆余年3卷36箱子的秘密一$http://audio.xmcdn.com/group31/M07/05/2E/wKgJSVmNeYiysoNaAEOuoeXkZ08587.m4a\r\n庆余年3卷37箱子的秘密二$http://audio.xmcdn.com/group31/M02/30/91/wKgJSVmO_NizW6AhAGfmCknc8V8751.m4a\r\n庆余年3卷38秋雨后的晴朗$http://audio.xmcdn.com/group31/M08/31/4F/wKgJSVmPAPeDcyhhAD5M6Sru38A839.m4a\r\n庆余年3卷39传单如雪$http://audio.xmcdn.com/group31/M05/32/4B/wKgJSVmPBZyhMrCsAHFIaGruiRE355.m4a\r\n庆余年3卷40算术$http://audio.xmcdn.com/group30/M0B/C3/0F/wKgJXlmPDxHA260sAHu9W62dL4k725.m4a\r\n庆余年3卷41诗集与言纸$http://audio.xmcdn.com/group31/M02/34/DA/wKgJSVmPE0WBq1YsAG4PJk_WKZA590.m4a\r\n庆余年3卷42大婚一$http://audio.xmcdn.com/group31/M02/35/A0/wKgJSVmPGA3RGjpqAGxyhfZ-RDA641.m4a\r\n庆余年3卷43大婚二$http://audio.xmcdn.com/group30/M00/E2/12/wKgJXlmQTXPjfuB6AGg27N3zcNQ360.m4a\r\n庆余年3卷44礼物$http://audio.xmcdn.com/group30/M07/E2/DB/wKgJXlmQUZHynUYxAGwUiA5ogu0907.m4a\r\n庆余年3卷44礼物二$http://audio.xmcdn.com/group31/M0B/55/02/wKgJSVmQVgnCVYOJAESFK-KOC2Y370.m4a\r\n庆余年3卷45$http://audio.xmcdn.com/group31/M01/8F/19/wKgJSVmRl0Cx9ib5AExgmEB1apc123.m4a\r\n庆余年3卷46$http://audio.xmcdn.com/group31/M08/95/EF/wKgJSVmRp6vgoi56AEKpzM2v4_k976.m4a\r\n庆余年3卷47$http://audio.xmcdn.com/group31/M07/97/C6/wKgJSVmRq0rgS3bKADxyxwKpvMg511.m4a\r\n庆余年3卷48$http://audio.xmcdn.com/group17/M04/D0/D2/wKgJKVmUSAjRubd3AEB-FquctDc229.m4a\r\n庆余年3卷49$http://audio.xmcdn.com/group20/M09/CE/A1/wKgJLFmUTBmzxPt6AGsNrsxYfD4374.m4a\r\n庆余年4卷1朝议一$http://audio.xmcdn.com/group26/M06/F9/2E/wKgJRlmUUNiC_qTkAHMbX5WtKMQ540.m4a\r\n庆余年4卷2朝议二$http://audio.xmcdn.com/group33/M09/04/9B/wKgJnVmVoeqRGEHlAHyDmka0M4U372.m4a\r\n庆余年4卷3$http://audio.xmcdn.com/group33/M04/05/63/wKgJTFmVpvfgLO7KAED-_WRpFkw849.m4a\r\n庆余年4卷4回京$http://audio.xmcdn.com/group32/M08/05/CB/wKgJnFmVqxazqeK6AGsplb4qM2g666.m4a\r\n庆余年4卷5二皇子$http://audio.xmcdn.com/group32/M08/17/F6/wKgJS1mW7pKQaSEzAHObIZ4kkfU017.m4a\r\n庆余年4卷6河畔新丝令人倦$http://audio.xmcdn.com/group33/M08/18/60/wKgJnVmW8tfD8QTWAEhmmEB1j5o787.m4a\r\n庆余年4卷7狗日的会试$http://audio.xmcdn.com/group32/M0B/18/D7/wKgJS1mW90DhqRFCAEWAjUS_zF4591.m4a\r\n庆余年4卷8考官其实是有趣的工种$http://audio.xmcdn.com/group32/M07/1A/54/wKgJnFmXBZbCDBpjAGVRPqhY9OI610.m4a\r\n庆余年4卷9春风化雨入春闱$http://audio.xmcdn.com/group33/M06/29/25/wKgJnVmYPVuR9IjhAGgMOsGk38w406.m4a\r\n庆余年4卷10你糊我糊大家糊$http://audio.xmcdn.com/group32/M02/29/9A/wKgJS1mYQhbzr3sFAEtJbwqEGeM984.m4a\r\n庆余年4卷11惊雷$http://audio.xmcdn.com/group33/M0B/2A/20/wKgJnVmYR2qSXWd6AEuk2gr59Lk998.m4a\r\n庆余年4卷12科场弊案$http://audio.xmcdn.com/group33/M04/3E/B4/wKgJnVmZt5fz9zgvAEq9c3WXdZo425.m4a\r\n庆余年4卷13雨中访友$http://audio.xmcdn.com/group33/M02/52/34/wKgJnVmbCCfiofZJAHKYrqwc1a0798.m4a\r\n庆余年4卷14雨中访友二$http://audio.xmcdn.com/group33/M05/52/71/wKgJTFmbDC-C1GmhAETfvyNyE5c750.m4a\r\n庆余年4卷15闪亮的日子$http://audio.xmcdn.com/group33/M07/5A/1D/wKgJnVmbvC6yfIlkAEruJoKrgpA583.m4a\r\n庆余年4卷16皇榜$http://audio.xmcdn.com/group33/M03/60/1B/wKgJnVmcE_Tw0pXhAECxgCnhVo4601.m4a\r\n庆余年4卷17权臣刚刚上路$http://audio.xmcdn.com/group33/M09/60/74/wKgJnVmcGF2h33uUAGxCDZPOizw649.m4a\r\n庆余年4卷18京官的反击$http://audio.xmcdn.com/group33/M0B/60/DD/wKgJTFmcHSbgz42hAEJdaPDL_8I016.m4a\r\n庆余年4卷19辩$http://audio.xmcdn.com/group32/M05/79/1F/wKgJS1mdprLBVv5VAHVuFMPItDs849.m4a\r\n庆余年4卷20大闹刑部$http://audio.xmcdn.com/group33/M01/79/C9/wKgJnVmdrN6hfEgIAFoo0-55-mQ425.m4a\r\n庆余年4卷21提司！提司！$http://audio.xmcdn.com/group32/M03/79/AF/wKgJS1mdsjOASX0nAEoFzu29rnw202.m4a\r\n庆余年4卷22初登门$http://audio.xmcdn.com/group33/M03/86/FA/wKgJTFmevPrTlqSvAGgGXNsJTU4016.m4a\r\n庆余年4卷23告诉你一个真正的监察院$http://audio.xmcdn.com/group32/M00/87/68/wKgJnFmewazyYI_PAG9H648sI34091.m4a\r\n庆余年4卷24人世间的影子$http://audio.xmcdn.com/group33/M09/87/C3/wKgJTFmexsGA7SEkAHoKth8-dQs657.m4a\r\n庆余年4卷25小花$http://audio.xmcdn.com/group33/M00/9B/3A/wKgJTFmgIP7hhfZfAHRtHJEauMQ194.m4a\r\n庆余年4卷26阴寒的装备$http://audio.xmcdn.com/group33/M02/9B/AC/wKgJTFmgJXyi3ruGAGVwGELG0zc871.m4a\r\n庆余年4卷27亵渎$http://audio.xmcdn.com/group32/M09/9C/1E/wKgJnFmgKj-w13-_AEUZC4kGrNE320.m4a\r\n庆余年4卷28夜夜夜夜$http://audio.xmcdn.com/group33/M09/AF/CD/wKgJTFmhj6XQrJyiAEGB_-E8X8U727.m4a\r\n庆余年4卷29肖恩出狱$http://audio.xmcdn.com/group33/M05/B0/2F/wKgJnVmhlE_j5EdUAHxEd5A-jQM889.m4a\r\n庆余年4卷30京外$http://audio.xmcdn.com/group32/M04/BC/82/wKgJnFmihIiQVCQeAFNdnmnKF6E617.m4a\r\n庆余年4卷31毫无美感的下毒$http://audio.xmcdn.com/group32/M02/BC/44/wKgJS1miiRujvmm6AD-zp1F_IjQ227.m4a\r\n庆余年4卷32马车春色$http://audio.xmcdn.com/group33/M03/BD/8B/wKgJTFmije2iio_KADaAIM_QzAA924.m4a\r\n庆余年4卷33白袖招$http://audio.xmcdn.com/group33/M08/BF/25/wKgJnVmiphaTgs0LAETRYJJ_Jug272.m4a\r\n庆余年4卷34向肖恩学习$http://audio.xmcdn.com/group32/M06/BF/09/wKgJnFmiqpTBtrBMAEjLPMILYCk142.m4a\r\n4卷35京中杀人细无声$http://audio.xmcdn.com/group33/M09/D0/E4/wKgJTFmkNs7yFj1xAGxPREDgneI320.m4a\r\n4卷36油伞骨中一柄剑$http://audio.xmcdn.com/group30/M07/15/03/wKgJXlmkvPDBtej7AETLoGKtuLc516.m4a\r\n4卷37白鸟在湖人在心$http://audio.xmcdn.com/group33/M0A/D3/43/wKgJnVmkvRvwecS9AHHkEXOfO2I590.m4a\r\n庆余年4卷38司理理的秘密$http://audio.xmcdn.com/group33/M02/DB/73/wKgJnVmlawCxXieDAEeGHQzPzF4584.m4a\r\n庆余年4卷39长公主的愿景$http://audio.xmcdn.com/group32/M05/DB/49/wKgJnFmlb_PA2Mq7AHzLj9JwZRw801.m4a\r\n庆余年4卷40出柙$http://audio.xmcdn.com/group30/M06/26/85/wKgJXlmldFPQ3fA3AG_jlLl8bKA581.m4a\r\n庆余年4卷41开门 放狗$http://audio.xmcdn.com/group30/M0B/3D/0D/wKgJXlmmt6_id_vqAGoPpW3pqQw753.m4a\r\n庆余年4卷42你死 我活$http://audio.xmcdn.com/group33/M09/E7/BC/wKgJnVmmvXyjprm5AGjp9SrrhfE716.m4a\r\n庆余年4卷43草甸惊变$http://audio.xmcdn.com/group30/M04/3E/B3/wKgJXlmmwwbiie48AE727A7qqus443.m4a\r\n庆余年4卷44海棠朵朵$http://audio.xmcdn.com/group30/M02/40/0B/wKgJXlmmy5-jNJkUAG6n3DAIg0w903.m4a\r\n庆余年4卷45以无耻入有德$http://audio.xmcdn.com/group32/M09/00/B9/wKgJnFmphMzDUvSUAEn_tI0f23A101.m4a\r\n庆余年4卷46无题$http://audio.xmcdn.com/group30/M05/70/E1/wKgJXlmpilWjX79KAITWTWwzqYA864.m4a\r\n庆余年4卷47海棠春$http://audio.xmcdn.com/group32/M01/0B/01/wKgJnFmquFHCe_nQAHG94eBWOaM694.m4a\r\n庆余年4卷48心战前传$http://audio.xmcdn.com/group30/M0A/86/12/wKgJXlmqvkXwCIyCAEjWFmvPK98431.m4a\r\n庆余年4卷49一字记之曰心$http://audio.xmcdn.com/group33/M03/0C/86/wKgJTFmqxhrTTUUNAEhK-Nxh_cg866.m4a\r\n庆余年4卷50雾渡河$http://audio.xmcdn.com/group30/M06/9F/60/wKgJXlmsIy_hYs12AHMnH2IYNSo266.m4a\r\n庆余年4卷51官道上$http://audio.xmcdn.com/group30/M09/9F/94/wKgJXlmsJyHT3VIkAG8hwJW5Wlk477.m4a\r\n庆余年4卷52上京城$http://audio.xmcdn.com/group32/M00/1F/EE/wKgJnFmtPv6AJIIPAEnXfsqHKks077.m4a\r\n庆余年4卷53斑驳城墙夜色重$http://audio.xmcdn.com/group32/M09/20/72/wKgJnFmtRQjSKhThAHKaJT8M_kY368.m4a\r\n庆余年4卷54使团入宫$http://audio.xmcdn.com/group31/M0B/9F/A3/wKgJX1mtSVyQJDLPAGXBUsGaW4U631.m4a\r\n庆余年4卷55与皇帝聊天$http://audio.xmcdn.com/group33/M04/30/26/wKgJTFmurwaTjZFkAEe49G_DxsE198.m4a\r\n庆余年4卷56姓范的牛人很多$http://audio.xmcdn.com/group32/M09/30/10/wKgJnFmutFixcl8sAEUkIbotb84029.m4a\r\n庆余年4卷57丫就是一村姑$http://audio.xmcdn.com/group33/M0B/30/ED/wKgJnVmuuVWxAEpTAD-SQ1UQdko468.m4a\r\n庆余年4卷58摇啊摇$http://audio.xmcdn.com/group32/M06/3D/22/wKgJnFmwBwjChXIUADd8VnxIlR8700.m4a\r\n庆余年4卷59使团就是打架团$http://audio.xmcdn.com/group32/M06/3C/E9/wKgJS1mwC1ST5EJLAGh0ewTvDiY160.m4a\r\n庆余年4卷60谭武不弄文$http://audio.xmcdn.com/group31/M00/55/DD/wKgJSVmwD8SxRVqZAGoZ7UmM1Wo050.m4a\r\n庆余年4卷61秀水街的老铺$http://audio.xmcdn.com/group33/M05/49/92/wKgJTFmxT5KS5UsgAEFdaZw0tjY433.m4a\r\n庆余年4卷62皇商的近况$http://audio.xmcdn.com/group33/M07/49/F6/wKgJTFmxVLXz3TrZAG-wLSW9Nms305.m4a\r\n庆余年4卷63长宁侯府$http://audio.xmcdn.com/group32/M01/49/70/wKgJS1mxWaOygY5QADile3rj6U0079.m4a\r\n庆余年4卷64您想发财吗$http://audio.xmcdn.com/group31/M06/D3/C1/wKgJX1myoQWhI--FAGzsZURRXlE673.m4a\r\n庆余年4卷65关范卿何事$http://audio.xmcdn.com/group33/M08/56/3C/wKgJTFmypRnx3EN-AEGjc_IwqTs732.m4a\r\n庆余年4卷66初见言冰云$http://audio.xmcdn.com/group33/M0B/56/A0/wKgJnVmyqc_xctuYAG03SABWMt8197.m4a\r\n庆余年4卷67撕白袍$http://audio.xmcdn.com/group32/M04/62/3B/wKgJnFmz7SqAzITkAGL6tcjFO2Q598.m4a\r\n庆余年4卷68理想主义者$http://audio.xmcdn.com/group33/M01/63/02/wKgJnVmz8W6ge7BBAGmuveNyV34903.m4a\r\n庆余年4卷69雨夜见沈重$http://audio.xmcdn.com/group33/M01/63/5E/wKgJTFmz9hvyerRtAFpOQHSHR84382.m4a\r\n庆余年4卷70小言脱身$http://audio.xmcdn.com/group31/M01/85/DF/wKgJSVm1NqTSTpqtAGceVy3bN2o818.m4a\r\n庆余年4卷71事情不是想象的那样$http://audio.xmcdn.com/group31/M00/86/3B/wKgJSVm1O0fgwKfnAEJsM69rwd4310.m4a\r\n庆余年4卷72谋划$http://audio.xmcdn.com/group33/M07/6F/AC/wKgJTFm1QBvw5i0iAGX0PzE1fTo477.m4a\r\n庆余年4卷73怜子如何不丈夫$http://audio.xmcdn.com/group32/M07/7D/BC/wKgJnFm2pbmAUpulADk6cUp7pN8975.m4a\r\n庆余年4卷74巷中杀人$http://audio.xmcdn.com/group32/M05/7E/04/wKgJnFm2qmeSTIocADWWNcVLl14811.m4a\r\n庆余年4卷75上京暗哨$http://audio.xmcdn.com/group33/M09/7E/D7/wKgJnVm2rrqDoK9eADVYF7kRvYg404.m4a\r\n庆余年4卷76有喜$http://audio.xmcdn.com/group32/M0A/8A/60/wKgJnFm38pXTg6EMADyVtIRi61E264.m4a\r\n庆余年4卷77若若要嫁人了$http://audio.xmcdn.com/group33/M09/8B/24/wKgJTFm39qjCDe5nAEckjrbxdrg916.m4a\r\n庆余年4卷78多多益善$http://audio.xmcdn.com/group33/M0A/8B/69/wKgJTFm3-wGicMdVAGlAQ9j39l8924.m4a\r\n庆余年4卷79俯瞰越狱事$http://audio.xmcdn.com/group31/M00/AD/B7/wKgJSVm5OJzAKaMDAFJjXs9Cdh8444.m4a\r\n庆余年4卷80埋伏$http://audio.xmcdn.com/group32/M07/96/85/wKgJnFm5PWXQbq-FAFrueACSxqA133.m4a\r\n庆余年4卷81事败$http://audio.xmcdn.com/group33/M04/97/6A/wKgJTFm5QcOxFBJsAGwe0Aluv_E717.m4a\r\n庆余年4卷82范闲也尾行$http://audio.xmcdn.com/group31/M01/1F/13/wKgJX1m6dpXBq5n6AD6dYoouhVA050.m4a\r\n庆余年4卷83湿柴与黑拳$http://audio.xmcdn.com/group33/M0B/A2/05/wKgJnVm6ex-h1y9pAGygCqipbyQ978.m4a\r\n庆余年4卷84范闲跳崖$http://audio.xmcdn.com/group32/M06/A1/7E/wKgJS1m6fzvCCOmZAG3HMdL2slE472.m4a\r\n庆余年4卷85世间游客$http://audio.xmcdn.com/group33/M08/B0/28/wKgJTFm76PaCZ1oNAHfbPQq-1Fg443.m4a\r\n庆余年4卷86永夜之庙$http://audio.xmcdn.com/group33/M07/B0/6F/wKgJTFm77eTy0u2pAHzbti6k2XI430.m4a\r\n庆余年4卷87逃出神庙的小姑娘$http://audio.xmcdn.com/group32/M02/AF/FE/wKgJnFm78e-Rfj6oAGuZdEG166c307.m4a\r\n庆余年4卷88$http://audio.xmcdn.com/group30/M05/B7/9F/wKgJXlm9HqGDA7EUAH0AaS0pfN4152.m4a\r\n庆余年4卷89闭眼从此闲$http://audio.xmcdn.com/group30/M02/B8/9B/wKgJXlm9I7GD8eEDAHKNf-txXOA039.m4a\r\n庆余年4卷90怎么又白了？91章又跑到最前面了$http://audio.xmcdn.com/group30/M09/B9/90/wKgJXlm9KFbQ7fXHADcjR46F_yU634.m4a\r\n庆余年4卷91何来意闲闲$http://audio.xmcdn.com/group32/M09/C6/BD/wKgJnFm-hdDTwmSUAFEgnwYVEz8777.m4a\r\n庆余年4卷 92走的便是女道士那一派$http://audio.xmcdn.com/group32/M0A/C6/A8/wKgJS1m-jBCDOOinAGy2t0Pqxks669.m4a\r\n庆余年4卷93种田喝酒聊天便定了这天下二十年$http://audio.xmcdn.com/group32/M06/C7/19/wKgJS1m-k8GS7J6ZAIByO9gh7lM943.m4a\r\n庆余年4卷94这世道 这女人！$http://audio.xmcdn.com/group31/M01/4E/ED/wKgJX1m_wueCGRsVAIRdypVwero627.m4a\r\n庆余年4卷95关于殿前比试的假打与打假$http://audio.xmcdn.com/group33/M05/D2/E4/wKgJTFm_zQzCAEKKAKKSE_u8epw935.m4a\r\n庆余年4卷96一俯一仰一场笑$http://audio.xmcdn.com/group32/M03/D2/AF/wKgJnFm_0SGzOsOGADz7j9rDg6w380.m4a\r\n庆余年4卷97皇帝也八卦$http://audio.xmcdn.com/group32/M02/DF/6E/wKgJnFnBHUjjHP0vAEiqhJ1Hsug706.m4a\r\n庆余年4卷98接班$http://audio.xmcdn.com/group31/M02/F8/09/wKgJSVnBKabR0G18ANoh7JKEo5s733.m4a\r\n庆余年4卷99长亭古道丢手绢$http://audio.xmcdn.com/group33/M09/E1/BB/wKgJTFnBNQuiILVtAH8E8KxMZPM758.m4a\r\n庆余年5卷1初秋的收割$http://audio.xmcdn.com/group32/M02/EC/7B/wKgJnFnCdcOipbpyAE2Z7Sh8RK0315.m4a\r\n庆余年5卷2争道$http://audio.xmcdn.com/group32/M02/EC/7E/wKgJnFnCdc-zhtvgALV_B6lxG8o693.m4a\r\n庆余年5卷3家务事$http://audio.xmcdn.com/group33/M03/F7/D9/wKgJnVnDtgjjMQ9bAGkYtFUFAFU312.m4a\r\n庆余年5卷4这次第 怎一个忙字了得$http://audio.xmcdn.com/group32/M03/F6/EB/wKgJS1nDtl_xVdraAMirv0SHUy0080.m4a\r\n庆余年5卷5后宅荒唐事$http://audio.xmcdn.com/group32/M0A/03/28/wKgJnFnE_qXgPOuLAHmaAa2NvP8397.m4a\r\n庆余年5卷6九月里$http://audio.xmcdn.com/group32/M09/03/D4/wKgJnFnFCG3x-3kaAICokTWj6i8014.m4a\r\n庆余年5卷7马车上的天下 皇宫中的豆苗$http://audio.xmcdn.com/group31/M0B/90/1D/wKgJX1nGd2XgL05qAHG2UFSwmj4408.m4a\r\n庆余年5卷8出宫做爷去$http://audio.xmcdn.com/group33/M00/12/FA/wKgJnVnGd5PRMLvQAH1dMZYdS5M445.m4a\r\n庆余年5卷9独一处$http://audio.xmcdn.com/group31/M0B/90/21/wKgJX1nGd3yxLk6cAGrdOqro6Dk027.m4a\r\n庆余年5卷10处里来了位年轻人$http://audio.xmcdn.com/group32/M00/1E/70/wKgJS1nHtxigevK3AGl27S9ZizI913.m4a\r\n庆余年5卷11整风$http://audio.xmcdn.com/group31/M04/9C/97/wKgJX1nHtzfBYnWSAIdVVqeviRg844.m4a\r\n庆余年5卷12新风馆$http://audio.xmcdn.com/group31/M0A/3F/7F/wKgJSVnJBvLTiOFgAEdjaCIy3ag890.m4a\r\n庆余年5卷13她自重了 你变态了$http://audio.xmcdn.com/group32/M04/27/CA/wKgJnFnJB0aznjZaANWhdKdh_1g814.m4a\r\n庆余年5卷14戴公公的英明决定$http://audio.xmcdn.com/group30/M08/F6/6C/wKgJXlnKXXORGLCKAMKb7arLoSs838.m4a\r\n庆余年5卷15黑与白的间奏$http://audio.xmcdn.com/group30/M08/F6/6B/wKgJXlnKXW6Ak6oFAHfODINhJTM426.m4a\r\n庆余年5卷16圣人$http://audio.xmcdn.com/group30/M01/1B/53/wKgJXlnLqNeADHmRAHIVSsMFR7Q722.m4a\r\n庆余年5卷17宫中奏章惊风雨$http://audio.xmcdn.com/group30/M06/40/1D/wKgJWlnLqOLzAXucAH55zmVnyd0233.m4a\r\n庆余年5卷18安之$http://audio.xmcdn.com/group30/M08/3B/E1/wKgJXlnM4DSyLTjWAGWO_4P1SCo190.m4a\r\n庆余年5卷19宫中对峙$http://audio.xmcdn.com/group30/M09/3B/E3/wKgJXlnM4D6g4N45AE7LkUNa7Gg970.m4a\r\n庆余年5卷20朝堂激辩$http://audio.xmcdn.com/group30/M06/69/D5/wKgJXlnOW22x_EzFAHDXVWX43EE987.m4a\r\n庆余年5卷21杖责与人品$http://audio.xmcdn.com/group30/M08/8E/B2/wKgJWlnOW3LyTj2jAEVg4jnALYI041.m4a\r\n庆余年5卷22黑夜里的明拳$http://audio.xmcdn.com/group30/M04/81/EB/wKgJXlnPid2j_6rDANwPU8XK6II171.m4a\r\n庆余年5卷23宫里宫外的青春$http://audio.xmcdn.com/group30/M00/A6/C7/wKgJWlnPienSVIMFAGcA1Ch7lnI156.m4a\r\n庆余年5卷24靖王寿宴$http://audio.xmcdn.com/group30/M00/A6/CE/wKgJWlnPigyTcKRPALExs-SkBBI389.m4a\r\n庆余年5卷25出国留学好不好？$http://audio.xmcdn.com/group30/M0A/CD/BC/wKgJWlnQ-4TASfHPAJAmDViAWL4041.m4a\r\n庆余年5卷26新绣的手帕要不要$http://audio.xmcdn.com/group34/M0A/90/BD/wKgJYVnaJDqjqXFeAIQRiU-PAFE340.m4a\r\n庆余年5卷27抱月楼$http://audio.xmcdn.com/group34/M0A/90/C1/wKgJYVnaJELQEyHNAF93uxwzVNo299.m4a\r\n庆余年5卷28桑文$http://audio.xmcdn.com/group34/M0A/90/C0/wKgJYVnaJEDxywD3ADwRhtv2BRQ060.m4a\r\n庆余年5卷29范一掌$http://audio.xmcdn.com/group34/M01/D3/53/wKgJYVnbiVCjGowSAFUoQ-eKoX8717.m4a\r\n庆余年5卷30斗狠$http://audio.xmcdn.com/group34/M04/5F/00/wKgJYFnbiV7wBj8aAFiphjUoYxQ279.m4a\r\n庆余年5卷31拦街$http://audio.xmcdn.com/group34/M04/5F/03/wKgJYFnbiWzyhHMxAHtGan5E5e8519.m4a\r\n庆余年5卷32挡在马车前的昆虫小胳膊$http://audio.xmcdn.com/group34/M01/FE/3A/wKgJYVnc83Gh9PlfAE0MKuErBXI373.m4a\r\n庆余年5卷33子有忧$http://audio.xmcdn.com/group34/M02/FE/3C/wKgJYVnc84CDx77vAIHvRN7CjNQ436.m4a\r\n庆余年5卷34自古龟公出少年$http://audio.xmcdn.com/group34/M04/89/AF/wKgJYFnc85DjgdX0AFl4ZfD3ox4313.m4a\r\n庆余年5卷35跟我回家$http://audio.xmcdn.com/group34/M07/B3/E6/wKgJYFneSyuASvVkAIme-Hs7moY455.m4a\r\n庆余年5卷36抄楼$http://audio.xmcdn.com/group34/M08/B3/E7/wKgJYFneSz_B2B21AGqkyR7GznE691.m4a\r\n庆余年5卷37兄弟$http://audio.xmcdn.com/group34/M08/B3/E7/wKgJYFneS0uiX6EQAHOcZx26V-k687.m4a\r\n庆余年5卷38家法$http://audio.xmcdn.com/group34/M00/D9/C7/wKgJYFnfjuaDjGCGAIFHm-1L0o0864.m4a\r\n庆余年5卷39老范与小范$http://audio.xmcdn.com/group34/M00/D9/CA/wKgJYFnfjvPQtxYsAIm9zvPWc5I202.m4a\r\n庆余年5卷40流放$http://audio.xmcdn.com/group34/M07/4E/9D/wKgJYVnfjvyiu90pAH0FM6GRnp4358.m4a\r\n庆余年5卷41已经勾引彼同行$http://audio.xmcdn.com/group34/M02/FD/09/wKgJYFng7-3j9BKBAL38Tzbw3jc093.m4a\r\n庆余年5卷42京都外的夜$http://audio.xmcdn.com/group34/M07/71/D5/wKgJYVng7-aCVJ6WAFoFCO5hTrM191.m4a\r\n庆余年5卷43收楼$http://audio.xmcdn.com/group34/M00/71/D7/wKgJYVng7__x-2RpAKiPt5Xgqhc530.m4a\r\n庆余年5卷44妓女 路人以及一场雨天的暗杀$http://audio.xmcdn.com/group34/M06/1E/91/wKgJYFniIMaC1PQjAVKMxce3MEQ563.m4a\r\n庆余年5卷45京都府外谢必安$http://audio.xmcdn.com/group34/M01/93/B4/wKgJYVniIgLT4eGxAQdqm2oBXKA877.m4a\r\n庆余年5卷46小恙无妨观落叶$http://audio.xmcdn.com/group34/M08/1E/D9/wKgJYFniIhuzNg3DAIH85-KeX6E443.m4a\r\n庆余年5卷47药$http://audio.xmcdn.com/group34/M0B/BF/0B/wKgJYVnjeYzilEwcAIkyT66eZLk064.m4a\r\n庆余年5卷48墙里秋千墙外道$http://audio.xmcdn.com/group34/M0B/BF/0C/wKgJYVnjeZPwxqrkAIYtYVS_ks4088.m4a\r\n庆余年5卷49陈园有客$http://audio.xmcdn.com/group34/M01/BF/16/wKgJYVnjedbwzypjAMgPl5Kc8XY378.m4a\r\n庆余年5卷50秋林 私语 结果$http://audio.xmcdn.com/group34/M02/73/20/wKgJYFnk4lmylfuoAVHMaEqo964660.m4a\r\n庆余年5卷51菊花 古剑和酒一$http://audio.xmcdn.com/group34/M06/E7/FA/wKgJYVnk4k-wgWHvAKzf-ZuEWLs333.m4a\r\n庆余年5卷52菊花 古剑 和酒二$http://audio.xmcdn.com/group34/M05/0D/81/wKgJYVnmJZ_TuskxATds38TGaSU979.m4a\r\n庆余年5卷53匕首，又见匕首！$http://audio.xmcdn.com/group34/M04/BE/41/wKgJYFnnfKnBa8-bAQm4ECsnqAg331.m4a\r\n庆余年5卷54伤者在宫中$http://audio.xmcdn.com/group34/M04/BE/42/wKgJYFnnfLGQQ0BkANFuTlLg5ks511.m4a\r\n庆余年5卷55烛光下的手术$http://audio.xmcdn.com/group34/M04/56/06/wKgJYVnoySnCh9G2AK-mseUshPY505.m4a\r\n庆余年5卷56梅园病人$http://audio.xmcdn.com/group34/M04/56/06/wKgJYVnoyS2TDm0iAM3dasjweG0795.m4a\r\n庆余年5卷57神仙局背后的神仙$http://audio.xmcdn.com/group34/M06/77/64/wKgJYVnqJUGBljPTANcefxPv0Rg745.m4a\r\n庆余年5卷58大皇子来访$http://audio.xmcdn.com/group34/M06/77/64/wKgJYVnqJUCTQqbqALlY0z1jvHo991.m4a\r\n庆余年5卷59封赏与对话$http://audio.xmcdn.com/group34/M07/BC/83/wKgJYVnsq8rDSqCiAH0LjbUs74Q804.m4a\r\n庆余年5卷60情书$http://audio.xmcdn.com/group34/M02/47/D8/wKgJYFnsq9rjAWFIAIVdZZHuPvU874.m4a\r\n庆余年5卷61游园惊梦 上$http://audio.xmcdn.com/group34/M07/BC/88/wKgJYVnsq-HxffsuAIJ8PgLwQf4265.m4a\r\n庆余年5卷62游园惊梦 中$http://audio.xmcdn.com/group34/M08/E4/66/wKgJYVnuGIXDRyKRANTGaRwK5gI408.m4a\r\n庆余年5卷63游园惊梦 下$http://audio.xmcdn.com/group34/M01/6F/C3/wKgJYFnuGIvDnOOkANLqoXj3-nI597.m4a\r\n庆余年5卷64上京城的雪$http://audio.xmcdn.com/group34/M08/E4/65/wKgJYVnuGH6iGcuXAIn1nGV_eU0005.m4a\r\n庆余年5卷65大宗师 黑布 谜语$http://audio.xmcdn.com/group34/M09/06/C4/wKgJYVnvZ7zyo4UjAH03Lhr9iSY150.m4a\r\n庆余年5卷66谁能杀死范提司$http://audio.xmcdn.com/group34/M03/92/34/wKgJYFnvZ9Kg5uQxALo9JyLKD8M892.m4a\r\n庆余年5卷67山居笔记$http://audio.xmcdn.com/group34/M00/06/C7/wKgJYVnvZ9qz112LAJc-Xc82U6Q625.m4a\r\n庆余年5卷68最好的时机$http://audio.xmcdn.com/group34/M08/29/F2/wKgJYVnwvTrD9F9aAGQ95HS_pBU290.m4a\r\n庆余年5卷69知母莫若知父$http://audio.xmcdn.com/group34/M08/29/F6/wKgJYVnwvWmwr-_qAOcXHvwWRSU181.m4a\r\n庆余年5卷70庆国人民关于叶家的集体回忆$http://audio.xmcdn.com/group34/M00/B5/52/wKgJYFnwvW2zJ8XsANVyNS5YXTo495.m4a\r\n庆余年5卷71猜出花来也就是那样$http://audio.xmcdn.com/group34/M09/D8/70/wKgJYFnyCGDyNrPjANjb7wrzwbI064.m4a\r\n庆余年5卷72布衣宗师的宗师战$http://audio.xmcdn.com/group34/M03/4D/26/wKgJYVnyCH-hFKv7ANQGMeMWq14219.m4a\r\n庆余年5卷73范府的变化$http://audio.xmcdn.com/group34/M0A/F7/6B/wKgJYFnzUx-RxvdaAHJwP3fYRuY200.m4a\r\n庆余年5卷74宫中小楼隐风动$http://audio.xmcdn.com/group34/M0A/F7/6F/wKgJYFnzUzmQIrM1AKbt3WX4q7Q955.m4a\r\n庆余年5卷75俱往矣$http://audio.xmcdn.com/group34/M09/6C/0F/wKgJYVnzU0izQe-qAINkseHAiEg166.m4a\r\n庆余年5卷76祝您飞黄腾达$http://audio.xmcdn.com/group32/M04/64/BD/wKgJS1n0si6wFXJ2AKvR01wI9G4904.m4a\r\n庆余年5卷77离前骚 上$http://audio.xmcdn.com/group32/M05/1C/CC/wKgJUFn0skGRzXIBAIuDjdQbG5s922.m4a\r\n庆余年5卷78离前骚 下$http://audio.xmcdn.com/group32/M05/3F/40/wKgJUFn18-vAr3vDARMH3ri7DAY094.m4a\r\n庆余年5卷79夜泊颍州有贼来$http://audio.xmcdn.com/group32/M04/87/22/wKgJS1n18-WBq7RxAJFLvQU7-iU900.m4a\r\n庆余年5卷80庆国最大的一艘贼船$http://audio.xmcdn.com/group32/M09/AB/13/wKgJS1n3ToWyY-UUAM1BSJmwFgw892.m4a\r\n庆余年5卷81有情况$http://audio.xmcdn.com/group32/M09/AB/13/wKgJS1n3ToTQfVLsAHeHTVFZ_kQ470.m4a\r\n庆余年5卷82你们已经被包围了$http://audio.xmcdn.com/group32/M02/CD/7C/wKgJS1n4moLRu56_ATW80wk3DYs519.m4a\r\n庆余年5卷83我拿什么供奉你？$http://audio.xmcdn.com/group32/M05/85/6E/wKgJUFn4moqzrsrSAIrjkE1gTuA909.m4a\r\n庆余年5卷84投名状以及范闲的正面和影子$http://audio.xmcdn.com/group32/M0A/EF/65/wKgJS1n54EaA8VXBAPe3yBNdXak634.m4a\r\n庆余年5卷85一路银江收礼忙$http://audio.xmcdn.com/group32/M0A/EF/68/wKgJS1n54FWzPzP1AI1QpnFwcxo473.m4a\r\n庆余年5卷86楼上楼 人外人$http://audio.xmcdn.com/group32/M06/A9/5F/wKgJUFn57bGhjnDVARJnRYw9x64110.m4a\r\n庆余年5卷87卖花姑娘与无耻官员$http://audio.xmcdn.com/group32/M06/CB/D2/wKgJUFn7N16hoxk4ASbipdZ5GlE393.m4a\r\n庆余年5卷88恰同学少年$http://audio.xmcdn.com/group32/M06/CB/D2/wKgJUFn7N1-i0yJgAMYSzs-ZFnc820.m4a\r\n庆余年5卷89天降祥瑞$http://audio.xmcdn.com/group32/M02/36/7D/wKgJS1n8kA3QcwdgAK-QLP-zjTE224.m4a\r\n庆余年5卷90端起碗喝粥 放下筷子骂娘$http://audio.xmcdn.com/group32/M07/36/99/wKgJS1n8kOfzfEG1AH2prmCCizI370.m4a\r\n庆余年5卷91龙抬头$http://audio.xmcdn.com/group33/M03/1E/97/wKgJUVn95FSw0pVzAVxjJBuXF3A948.m4a\r\n庆余年5卷92钱庄与青楼$http://audio.xmcdn.com/group33/M08/8E/45/wKgJTFn_KXKydhX7AKuo8cIizHU771.m4a\r\n庆余年5卷93君子取财有道$http://audio.xmcdn.com/group33/M06/44/C8/wKgJUVn_KYmwnymbAM68126zkgs074.m4a\r\n庆余年5卷94顺德到了$http://audio.xmcdn.com/group33/M02/8E/4A/wKgJTFn_KZejcxZGAMOMsWdxEfs232.m4a\r\n庆余年5卷95霸得蛮 耐不得烦$http://audio.xmcdn.com/group33/M05/6A/07/wKgJUVoAeuehytv1AMlHor57CEk283.m4a\r\n庆余年5卷96内库罢工$http://audio.xmcdn.com/group33/M00/D8/84/wKgJTFoB0mqTdz4uAI2RlCx71nY992.m4a\r\n庆余年5卷97钦差大人因何发怒$http://audio.xmcdn.com/group33/M0A/8E/D9/wKgJUVoB0nbgVGgzAG0ZuROwiuo593.m4a\r\n庆余年5卷98老掌柜$http://audio.xmcdn.com/group33/M0A/8E/DA/wKgJUVoB0nuRStFjAEw83fv3MMM579.m4a\r\n庆余年5卷99有自主意识的磨刀石$http://audio.xmcdn.com/group33/M0A/FD/95/wKgJTFoDK0Cyrwy3AIbihXBSgdk436.m4a\r\n庆余年5卷100有些事做得说不得$http://audio.xmcdn.com/group33/M00/FD/98/wKgJTFoDK1uB6ZdmANJ2n70Rnc0468.m4a\r\n庆余年5卷101春之道$http://audio.xmcdn.com/group33/M02/B3/ED/wKgJUVoDK2rDD_9bAMhIKCzQUeE407.m4a\r\n庆余年5卷102借你的手 握北齐皇帝的手$http://audio.xmcdn.com/group33/M08/D8/24/wKgJUVoEf3Gji11tAIXNQCed2DQ626.m4a\r\n庆余年5卷103明家眼中的鹅卵石$http://audio.xmcdn.com/group33/M08/D8/25/wKgJUVoEf3yC8anMAJBTkt1xLRI937.m4a\r\n庆余年5卷104扼住命运的咽喉$http://audio.xmcdn.com/group33/M08/D8/28/wKgJUVoEf5HjqZP-AHyfPB6QDeE025.m4a\r\n庆余年5卷105洗岛$http://audio.xmcdn.com/group34/M00/76/DE/wKgJYVoFyX3joiUwAG3zP3I6UsQ206.m4a\r\n庆余年5卷106明家母子$http://audio.xmcdn.com/group34/M00/76/E0/wKgJYVoFyYqj8-AdAFgdSaW7te8490.m4a\r\n庆余年5卷107身在苏州心在天下的年轻人$http://audio.xmcdn.com/group32/M05/F8/10/wKgJUFoFybmR9H8YAQRCM2rd4ds265.m4a\r\n大官人447真面目$http://audio.xmcdn.com/group32/M0B/40/05/wKgJS1oFybWRCKkxAD2U-Zz9aPs637.m4a\r\n庆余年5卷108内库门$http://audio.xmcdn.com/group32/M00/FE/55/wKgJUFoHDW3i8KNSAIXuIij5fOE481.m4a\r\n庆余年5卷109乙四房的强盗$http://audio.xmcdn.com/group32/M00/FE/59/wKgJUFoHDYOT71WQALSZCYmPCcQ098.m4a\r\n庆余年5卷110大哥 好久不见$http://audio.xmcdn.com/group31/M02/D2/05/wKgJX1oHDY2j1xjxAI1DGdRFDpI030.m4a\r\n庆余年5卷111牵一发$http://audio.xmcdn.com/group32/M08/4E/84/wKgJS1oIY9mS6i9GAMz07XqW52g789.m4a\r\n庆余年5卷112翘一指$http://audio.xmcdn.com/group32/M09/06/97/wKgJUFoIY-XTw1gYAJ6if7OmtEA321.m4a\r\n庆余年5卷113天女散花$http://audio.xmcdn.com/group31/M05/74/1C/wKgJSVoIZCuxR_fTANDOPmEx4lE632.m4a\r\n庆余年5卷114天晓不因钟鼓动$http://audio.xmcdn.com/group35/M00/3E/25/wKgJnVoLEcKA61ZTAO-9hh1rODQ893.m4a\r\n庆余年5卷115膝下并无黄金重$http://audio.xmcdn.com/group35/M05/88/2C/wKgJnFoLEc3Dcl2OANK7pR6_X8w252.m4a\r\n庆余年5卷116月明非为夜行人$http://audio.xmcdn.com/group35/M05/88/2E/wKgJnFoLEd_AR-AIANKbV3OGMgA971.m4a\r\n庆余年5卷117夏明记$http://audio.xmcdn.com/group35/M07/AF/4A/wKgJnFoMZ0qTYePJALKZdTWYliw642.m4a\r\n庆余年5卷118刑房与遗书$http://audio.xmcdn.com/group35/M04/65/65/wKgJnVoMZ26BZvOTAMjGb7oc9dk709.m4a\r\n庆余年5卷119家产官司$http://audio.xmcdn.com/group35/M09/AF/4F/wKgJnFoMZ3uAtW42AIW5171nIpM566.m4a\r\n庆余年5卷120和谐无比的那张纸$http://audio.xmcdn.com/group35/M07/D5/DA/wKgJnFoNtUOhY7b8ANK1xr3XtXo446.m4a\r\n庆余年5卷121$http://audio.xmcdn.com/group35/M07/8B/FC/wKgJnVoNtYPxz2FTAOKOzYWK8L0030.m4a\r\n庆余年5卷122开楼杀人夜$http://audio.xmcdn.com/group35/M08/F8/D3/wKgJnFoO_36BSe96APRL05bRnmk572.m4a\r\n庆余年5卷123杀袁惊梦换血$http://audio.xmcdn.com/group35/M08/F8/D5/wKgJnFoO_4zyjjgYAG9hk3aGqLs282.m4a\r\n庆余年5卷124钓鱼$http://audio.xmcdn.com/group35/M08/AE/DB/wKgJnVoO_5Wh0UfYAJ88qBo0-5E107.m4a\r\n庆余年5卷125明家悲情的背后$http://audio.xmcdn.com/group35/M06/1E/09/wKgJnFoQVNDhfFSEAJs7UOg0k1U885.m4a\r\n庆余年5卷126谁的水师$http://audio.xmcdn.com/group35/M06/D4/21/wKgJnVoQVNiSKMsaAIYQis7NK6g747.m4a\r\n庆余年5卷127不甘撒手$http://audio.xmcdn.com/group35/M02/1E/11/wKgJnFoQVQ2Bhow8APIwiM21LAk091.m4a\r\n庆余年5卷128宫与朝$http://audio.xmcdn.com/group35/M0B/FE/57/wKgJnVoRpdbRo9FpANkTvcu-WcM191.m4a\r\n庆余年5卷129殿上挖角$http://audio.xmcdn.com/group35/M06/48/56/wKgJnFoRpePT2Yx8AJD1taQI8DQ651.m4a\r\n庆余年5卷130户部之事上$http://audio.xmcdn.com/group35/M0B/FE/5A/wKgJnVoRpe3QJvxYAI05JlcgA8E049.m4a\r\n庆余年5卷131户部之事$http://audio.xmcdn.com/group35/M07/75/6B/wKgJnFoS9zCDpPeKAOlVR1_jN30527.m4a\r\n庆余年5卷132清查与艺术家的作品$http://audio.xmcdn.com/group35/M07/75/6B/wKgJnFoS9zSiKHROAFQ-O_h4nFE722.m4a\r\n庆余年5卷133范建的剑$http://audio.xmcdn.com/group35/M0A/2B/A3/wKgJnVoS9ziB_kySAHLM6COOWc0722.m4a\r\n庆余年5卷134搬起一团大雪球$http://audio.xmcdn.com/group35/M04/5D/85/wKgJnVoUREjS3jjcAKxFyJRr-TI540.m4a\r\n庆余年5卷135有理与天威$http://audio.xmcdn.com/group35/M00/A7/17/wKgJnFoURFyDrLDEAHQPhtlUL2Q288.m4a\r\n庆余年5卷136深春之京$http://audio.xmcdn.com/group35/M08/5D/8D/wKgJnVoURGTwDQflAIWzDXxIai8191.m4a\r\n庆余年5卷137春和$http://audio.xmcdn.com/group35/M0B/13/B6/wKgJnFoW7nqQe6l2AK6CeDkmTBY386.m4a\r\n庆余年5卷138景明$http://audio.xmcdn.com/group35/M04/CA/03/wKgJnVoW7nPQUj2EAJ8RcoxWQ7s888.m4a\r\n庆余年5卷139波澜起$http://audio.xmcdn.com/group35/M04/CA/04/wKgJnVoW7nfB1mQiAHyAq6aEFP4823.m4a\r\n庆余年5卷140谁不惊？$http://audio.xmcdn.com/group35/M0A/55/74/wKgJnFoYSInzGVALAIlx-DnN658731.m4a\r\n庆余年5卷141满城白霜下黑泥$http://audio.xmcdn.com/group35/M01/88/22/wKgJnFoZiSDiOYaFAMZ4xVtAYLI448.m4a\r\n庆余年5卷142我于楼上观民心$http://audio.xmcdn.com/group35/M01/88/24/wKgJnFoZiS7A_jdeAJkS0pDL35c595.m4a\r\n庆余年5卷143你在园外闹 我在园内笑$http://audio.xmcdn.com/group35/M02/3E/5D/wKgJnVoZiVDCCr9PAMyPKj-v4r4254.m4a\r\n庆余年5卷144苏州城来了位异客$http://audio.xmcdn.com/group35/M0A/71/99/wKgJnVoa7l3Rqf9YAGtyX61OhSI830.m4a\r\n庆余年5卷145你怎么敢杀我$http://audio.xmcdn.com/group35/M0A/71/9D/wKgJnVoa7ojAJrC0AMXbAH8pedw862.m4a\r\n庆余年5卷146一剑倾人楼$http://audio.xmcdn.com/group35/M08/71/A0/wKgJnVoa7qbRMhhBAPzQyAJoUnM965.m4a\r\n庆余年5卷147华园里的头脑风暴$http://audio.xmcdn.com/group35/M05/E8/04/wKgJnFocLXLDxvUfAJHFnVep9Mg365.m4a\r\n庆余年5卷148那些月儿$http://audio.xmcdn.com/group35/M05/E8/07/wKgJnFocLYLzjyEGAJ2NyRWdWrY656.m4a\r\n庆余年5卷149被子保佑天下黎民$http://audio.xmcdn.com/group35/M05/E8/0B/wKgJnFocLZSztaIQAHm8SK9GjiQ251.m4a\r\n庆余年5卷150弃儿们的聚会$http://audio.xmcdn.com/group33/M00/FC/C7/wKgJUVodgiyTLSPnALZ4eAXl3Wg726.m4a\r\n庆余年5卷151剑与旨$http://audio.xmcdn.com/group33/M00/46/66/wKgJTFodgjygvkKIAL5CzNRMTpE936.m4a\r\n庆余年5卷152此事不关风月$http://audio.xmcdn.com/group34/M0B/96/ED/wKgJYVoeyjmDMvJTAK0k_3oSRhM909.m4a\r\n庆余年5卷153孩子气$http://audio.xmcdn.com/group35/M07/BB/96/wKgJnVoeyj7CoMWwAIbYQWlhdyU123.m4a\r\n庆余年5卷154一样的星空$http://audio.xmcdn.com/group31/M06/8D/C7/wKgJSVogIBfToP58AUteSqtn4Uk881.m4a\r\n庆余年6卷1梧州姑爷$http://audio.xmcdn.com/group35/M01/CD/56/wKgJnVohdobiBNFRAL2Z8CO5I5g424.m4a\r\n庆余年6卷2与娘家人的谈判$http://audio.xmcdn.com/group32/M0A/71/86/wKgJS1ohdpzCOVXNAJjFsPny7A8657.m4a\r\n庆余年6卷3老丈人笑谈君山会$http://audio.xmcdn.com/group32/M0A/71/8F/wKgJS1ohdrnSRbmrAPvSCXhQ0Ks523.m4a\r\n庆余年6卷4出山$http://audio.xmcdn.com/group28/M08/70/B7/wKgJXFoixACiaj3AAHuxn4LYO24577.m4a\r\n庆余年6卷5近城$http://audio.xmcdn.com/group28/M08/70/BA/wKgJXFoixAri-FtyAHPxwWee98w479.m4a\r\n庆余年6卷 6胶州有人开寿宴$http://audio.xmcdn.com/group28/M03/6F/56/wKgJSFoixBPjN1XjAHdosrmjxcA091.m4a\r\n庆余年6卷7茅房有人玩暗杀$http://audio.xmcdn.com/group2/M02/1C/B5/wKgJRVokCseSTRjgAJn6FlCdfWo580.m4a\r\n庆余年6卷8再闯府$http://audio.xmcdn.com/group35/M0A/DB/D1/wKgJnVokCtmDUmyLAIWWqs9Tqa8622.m4a\r\n庆余年6卷9提督府内一场戏$http://audio.xmcdn.com/group33/M01/24/68/wKgJUVokCuOxd-oNAHDGU7rffwY182.m4a\r\n庆余年6卷10书房宣口谕$http://audio.xmcdn.com/group30/M0B/1D/96/wKgJXlolYZDRRx16AJHS9LYKVk8176.m4a\r\n庆余年6卷11迷死人不偿命的一夜$http://audio.xmcdn.com/group30/M0B/1D/9D/wKgJXlolYaOTxa4LAKnFjWa_1AI884.m4a\r\n庆余年6卷12谁是谁的人$http://audio.xmcdn.com/group30/M0B/42/62/wKgJWlolYbXQ4SOLAMI8ayu1okI563.m4a\r\n庆余年6卷13我从远方赶来赴约$http://audio.xmcdn.com/group22/M05/FC/BA/wKgJM1oms77xRasRAI3APo_jZcU860.m4a\r\n庆余年6卷14入羊群$http://audio.xmcdn.com/group22/M05/FC/E4/wKgJLloms9zxmEUdAHc0xmdb3UI467.m4a\r\n庆余年6卷15略带腥味的海风$http://audio.xmcdn.com/group22/M05/FC/E5/wKgJLloms9_zEwZQAKS-NpB92H4439.m4a\r\n庆余年6卷17君臣有心$http://audio.xmcdn.com/group36/M04/41/CB/wKgJUlooDlmx5MPEALDguMd5U0Y393.m4a\r\n庆余年6卷16大事可为$http://audio.xmcdn.com/group36/M06/41/CC/wKgJUlooDlzwefIpAM9BxPOiC5A027.m4a\r\n庆余年6卷18天子有疾$http://audio.xmcdn.com/group36/M00/BC/4E/wKgJUlopXQ2yW9IDAJfFmmOCqBY043.m4a\r\n庆余年6卷19海风有信$http://audio.xmcdn.com/group36/M00/BC/55/wKgJUlopXRzR5khwALZCV-1cOM4132.m4a\r\n庆余年6卷20荣归一$http://audio.xmcdn.com/group36/M00/BC/56/wKgJUlopXR2R6_AYAIYAYwaBwiY741.m4a\r\n庆余年6卷21荣归二$http://audio.xmcdn.com/group36/M01/29/D4/wKgJUloqpR-DtZL0AITdorK4GxE078.m4a\r\n庆余年6卷22祖孙 弟妹 夫妻 唉……$http://audio.xmcdn.com/group36/M01/29/D7/wKgJUloqpSWR7EkYAKdMC-Cc_2k848.m4a\r\n庆余年6卷23慈悲与闷骚是一对儿$http://audio.xmcdn.com/group36/M03/29/E6/wKgJUloqpUGCSU74AMFr5wnEW0U116.m4a\r\n庆余年6卷24澹州今日无豆腐$http://audio.xmcdn.com/group36/M04/A2/7E/wKgJUlosA0OC66gAAJSpjKrAv0Y893.m4a\r\n庆余年6卷25只论亲疏$http://audio.xmcdn.com/group36/M0A/A2/9B/wKgJUlosA4zRgC5lAKALFdXfEFI315.m4a\r\n庆余年6卷26离开澹州前的日子$http://audio.xmcdn.com/group36/M01/A2/A0/wKgJUlosA5jxOQwWAJ2H58Li4TE529.m4a\r\n庆余年6卷27雪夜遇青幡$http://audio.xmcdn.com/group36/M0B/13/E1/wKgJUlotTkiTvpCaAI49EVE9SrA594.m4a\r\n庆余年6卷28王十三郎$http://audio.xmcdn.com/group36/M0B/13/E7/wKgJUlotTlHSwKAVAIf8aaSgoBw227.m4a\r\n庆余年6卷29山谷有雪$http://audio.xmcdn.com/group36/M0B/13/EF/wKgJUlotTmTQlqwvAItqmZv1EgU764.m4a\r\n庆余年6卷30白雪 红林 黑发$http://audio.xmcdn.com/group36/M03/80/D3/wKgJUlounx_iMKxoANtHnBadoTM952.m4a\r\n庆余年6卷31京都别来无恙？$http://audio.xmcdn.com/group36/M0A/80/DC/wKgJUlounzCRKDImAL25K69-LVg179.m4a\r\n庆余年6卷32枢密院前 大好头颅$http://audio.xmcdn.com/group36/M0A/80/F3/wKgJUloun13DVegiAJdTiH-dhCE557.m4a\r\n庆余年6卷33何以报？$http://audio.xmcdn.com/group36/M05/D1/9D/wKgJUlov8cbBuESuAKnz3OfD9KI841.m4a\r\n庆余年6卷34种白菜的老爷子$http://audio.xmcdn.com/group37/M0B/0E/2B/wKgJoVov8d2DQ1knAOuMGWyOQu8039.m4a\r\n庆余年6卷35谁能敌？$http://audio.xmcdn.com/group37/M07/0E/24/wKgJoFov8dmwKa7oAKGGQhLsB7o931.m4a\r\n庆余年6卷36天下有狗 谁人赶之$http://audio.xmcdn.com/group36/M04/0E/2C/wKgJUloxT3bSJL9oAKe32kxv9H4796.m4a\r\n庆余年6卷37人在庙堂身不由己$http://audio.xmcdn.com/group36/M09/0E/31/wKgJUloxT4LBsjC4AKGtmJr5Uwo891.m4a\r\n庆余年6卷38旧轮椅 新轮椅$http://audio.xmcdn.com/group36/M03/45/DA/wKgJUloyjXyDVGeEAKkQlBUL1IY054.m4a\r\n庆余年6卷39三人三思$http://audio.xmcdn.com/group36/M03/45/E2/wKgJUloyjYfyT-PqAHT9n8BogHY571.m4a\r\n庆余年6卷40画中人 画外音$http://audio.xmcdn.com/group36/M03/45/ED/wKgJUloyjZnhM0t5AJeRhtB5wCs477.m4a\r\n庆余年6卷41大哥别说二哥$http://audio.xmcdn.com/group37/M06/63/EA/wKgJoVoz2g2xipVvAIWDlPLHrMs577.m4a\r\n庆余年6卷42我的人 他们的人$http://audio.xmcdn.com/group37/M06/63/EF/wKgJoVoz2hyjvJBeAIT4MhwPhlw308.m4a\r\n庆余年6卷43楼外有雪 北方有思$http://audio.xmcdn.com/group36/M07/7C/5E/wKgJUloz2jGSHBtuAKtjpvwfcMI091.m4a\r\n庆余年6卷44洗手做羹汤$http://audio.xmcdn.com/group36/M07/B8/28/wKgJUlo1O9qwyhHJAOoDDsZi3IQ988.m4a\r\n庆余年6卷45心血如一$http://audio.xmcdn.com/group36/M07/B8/26/wKgJUlo1O9bwsYthAJA0020Gl8w923.m4a\r\n庆余年6卷46御书房内忆当年$http://audio.xmcdn.com/group37/M02/81/EF/wKgJoFo1O-XyjA4GAKoQcfN8-Gs395.m4a\r\n庆余年6卷47抱月楼前笑兄弟$http://audio.xmcdn.com/group37/M0B/A0/07/wKgJoFo2jcmxgM52AKarIRCs1vo137.m4a\r\n庆余年6卷48鸿门宴上道春秋一$http://audio.xmcdn.com/group37/M09/A0/15/wKgJoVo2jc6TyVgEAHUR8jhdeZs275.m4a\r\n庆余年6卷49鸿门宴上道春秋二$http://audio.xmcdn.com/group37/M0B/A0/09/wKgJoFo2jdajFj11AHwSh6n5h9s225.m4a\r\n庆余年6卷50鸿门宴上道春秋三$http://audio.xmcdn.com/group37/M06/BC/F0/wKgJoFo31Q3BoLqMAIQpBuw4Ac4612.m4a\r\n庆余年6卷51鸿门宴上道春秋四$http://audio.xmcdn.com/group37/M06/BC/F8/wKgJoFo31STzn-BwANMGiCvLjTw257.m4a\r\n庆余年6卷52雾$http://audio.xmcdn.com/group37/M06/BC/F9/wKgJoFo31Sej_dIWAJpu81pOgjI731.m4a\r\n庆余年6卷53黎明前的雪花豆花$http://audio.xmcdn.com/group37/M07/DF/1D/wKgJoVo5MOGCGeDWAKuzoTU6MG4260.m4a\r\n庆余年6卷54大朝会$http://audio.xmcdn.com/group37/M07/DE/D8/wKgJoFo5MOfi11oUAGVHgiIwbDk552.m4a\r\n庆余年6卷55澹泊公$http://audio.xmcdn.com/group37/M09/DF/21/wKgJoVo5MPTi0AJpAG6diQ1hAiM042.m4a\r\n庆余年6卷56天下有敌$http://audio.xmcdn.com/group36/M0B/B0/E1/wKgJUlo6fEaRZSOzAKjGCe7rS-U035.m4a\r\n庆余年6卷57关卿鸟事$http://audio.xmcdn.com/group36/M0B/B0/F7/wKgJUlo6fG6RZOpNAIVdZYG5I9s077.m4a\r\n庆余年6卷58归宗$http://audio.xmcdn.com/group36/M0B/B0/EF/wKgJUlo6fGHSaRIaAKbXLxDM6qs789.m4a\r\n庆余年6卷59君臣之间无暧昧$http://audio.xmcdn.com/group37/M09/1E/67/wKgJoFo71C_At1YOAJ_dkMfwmOo314.m4a\r\n庆余年6卷60记得当时年纪小$http://audio.xmcdn.com/group36/M09/F0/EA/wKgJUlo71EWzY1y0ALE7_O3RJYE265.m4a\r\n庆余年6卷61靴子里的小$http://audio.xmcdn.com/group36/M09/F0/ED/wKgJUlo71FCDPcxqAImDERJWNCI688.m4a\r\n庆余年6卷62宫里那些破事儿$http://audio.xmcdn.com/group37/M01/57/91/wKgJoVo-bX-R5l48AKRcZfP5Mis428.m4a\r\n庆余年6卷63再见长公主$http://audio.xmcdn.com/group37/M01/57/93/wKgJoVo-bYTTBQt3AJR_IBeGs6U891.m4a\r\n庆余年6卷64夜宫里的寂寞$http://audio.xmcdn.com/group37/M01/57/98/wKgJoVo-bZXwwhIoAJy40nMNL88746.m4a\r\n庆余年6卷65噢，眼泪$http://audio.xmcdn.com/group36/M03/A4/99/wKgJUlo_vpDBClFuAFsYtL31XVY354.m4a\r\n庆余年6卷66稻草的根在哪儿$http://audio.xmcdn.com/group36/M03/A4/A3/wKgJUlo_vqTQrQHMAKNpDyw3DxI769.m4a\r\n庆余年6卷67万物有法$http://audio.xmcdn.com/group36/M03/A4/AB/wKgJUlo_vrOCS9erAKAefS2LCA8981.m4a\r\n庆余年6卷68不速则达$http://audio.xmcdn.com/group37/M05/94/B1/wKgJoVpBEGXCS60CAJ13weq8wn8325.m4a\r\n庆余年6卷69破冰如玉$http://audio.xmcdn.com/group36/M09/15/8E/wKgJTVpBEGjRsWSZAHuP1jYuKD4231.m4a\r\n庆余年6卷70皇族中的另类$http://audio.xmcdn.com/group37/M00/94/B0/wKgJoFpBEHrTlUvzAIqKdIFT9uk734.m4a\r\n庆余年6卷71生命不能承受之……香$http://audio.xmcdn.com/group37/M08/B0/CE/wKgJoVpCXWSR4XaIALqetBl6r3U362.m4a\r\n庆余年6卷72我知道你去年夏天干了什么$http://audio.xmcdn.com/group36/M09/31/CB/wKgJTVpCXeXSOruvALlbS2qUntc286.m4a\r\n庆余年6卷73太监也可以改变天下$http://audio.xmcdn.com/group37/M07/B0/F4/wKgJoVpCXkzzhv0FAJ-qHUQ_cik912.m4a\r\n庆余年6卷74范三宝的由来$http://audio.xmcdn.com/group37/M04/D1/C4/wKgJoVpDxICzdxn3AJeVJrKh5gg043.m4a\r\n庆余年6卷75为人父母者$http://audio.xmcdn.com/group36/M07/05/37/wKgJUlpDxJ-w-6nWALh8RiCZP58317.m4a\r\n庆余年6卷76第三代$http://audio.xmcdn.com/group36/M07/05/38/wKgJUlpDxKTCYPAOAJHzS1lDE-o725.m4a\r\n庆余年6卷77态度决定一切$http://audio.xmcdn.com/group37/M0B/EC/FF/wKgJoFpFDovje0bcAOIJ1QXpJq4045.m4a\r\n庆余年6卷78招商钱庄$http://audio.xmcdn.com/group37/M0B/ED/04/wKgJoVpFDpGiib_uAKh1SJ1xKVU554.m4a\r\n庆余年6卷79一个宫女的死亡$http://audio.xmcdn.com/group37/M0B/ED/03/wKgJoFpFDpzzN8glAMQla7mJs-8116.m4a\r\n庆余年6卷80大石压车谁能阻$http://audio.xmcdn.com/group36/M07/88/27/wKgJTVpGW-SBxZOlALx7lbsetxQ008.m4a\r\n庆余年6卷81这是一个阴谋$http://audio.xmcdn.com/group37/M06/06/C5/wKgJoFpGW_uTbtaHAK20JRcdETg298.m4a\r\n庆余年6卷82大人物们$http://audio.xmcdn.com/group37/M06/06/C9/wKgJoFpGXAqSewlkAL_Dhq3CG1s125.m4a\r\n庆余年6卷83明园里的笑声$http://audio.xmcdn.com/group36/M05/A1/F7/wKgJTVpHqeXyB8PXAHmlVZW09Yk992.m4a\r\n庆余年6卷84子系中山狼上$http://audio.xmcdn.com/group36/M07/54/2F/wKgJUlpHqfjiAwfuAGBxuQmWaDw184.m4a\r\n庆余年6卷85子系中山狼下$http://audio.xmcdn.com/group36/M07/54/34/wKgJUlpHqg6hOFpgAHjMDu0MA0c292.m4a\r\n庆余年6卷86宫里的三个夜$http://audio.xmcdn.com/group36/M05/6F/C0/wKgJUlpI9e7Cz060AKjEkhyoSac048.m4a\r\n庆余年6卷87半个时辰$http://audio.xmcdn.com/group36/M05/6F/BF/wKgJUlpI9erwO22BAKYPeBrYCNU041.m4a\r\n庆余年6卷88皇宫里的血与黄土$http://audio.xmcdn.com/group36/M09/BD/7B/wKgJTVpI9fPy0ICaAIVh4LVkFnQ503.m4a\r\n庆余年6卷89雷雨 上$http://audio.xmcdn.com/group36/M02/DF/99/wKgJTVpKTN7Tfi26AGYAHGBESsQ046.m4a\r\n庆余年6卷90雷雨 下$http://audio.xmcdn.com/group37/M05/5E/09/wKgJoVpKTPjDgwibAIhc05Cm3rk370.m4a\r\n庆余年6卷92寡人$http://audio.xmcdn.com/group37/M05/5E/0A/wKgJoVpKTPnQOQ4aAGfRdPtDJMI829.m4a\r\n庆余年6卷92幽$http://audio.xmcdn.com/group37/M08/7A/ED/wKgJoFpLm6zAfzZCAH9ubJ4Cw6M025.m4a\r\n庆余年6卷93流$http://audio.xmcdn.com/group37/M08/7A/EC/wKgJoFpLm6qCqsYlADP4ccnMmDc810.m4a\r\n庆余年6卷94叹$http://audio.xmcdn.com/group36/M09/FC/94/wKgJTVpLm_3hYU0_AHqxP8A7Ods238.m4a\r\n庆余年6卷95坑$http://audio.xmcdn.com/group37/M00/98/FD/wKgJoVpM9grjSDA0AH-SRqVjRL4547.m4a\r\n庆余年6卷96新一代的小怪物$http://audio.xmcdn.com/group36/M00/1A/CB/wKgJTVpM9h2y-uf-AIMB7w1ELD4852.m4a\r\n庆余年6卷97山中的范府小姐与书信$http://audio.xmcdn.com/group36/M00/CD/11/wKgJUlpM9iziRuCTAJj-eN0S8hU412.m4a\r\n庆余年6卷98如果你来投奔我$http://audio.xmcdn.com/group36/M03/E9/E4/wKgJUlpOQV3Sg3iAAH9jSnNo7t4087.m4a\r\n庆余年6卷99归一$http://audio.xmcdn.com/group37/M0B/B6/1D/wKgJoFpOQYGh3AvJAKZjfCBAIPc676.m4a\r\n庆余年6卷100愈沉默愈快乐$http://audio.xmcdn.com/group37/M03/B6/24/wKgJoVpOQYHCWjDbAHWxoocTerU332.m4a\r\n庆余年6卷101清茶 烈酒 草纸 大势$http://audio.xmcdn.com/group36/M04/53/C9/wKgJTVpPlTnxG9XSAHEaOtIW-4M083.m4a\r\n庆余年6卷102荒唐言$http://audio.xmcdn.com/group36/M04/53/CF/wKgJTVpPlU3C1TPFAKDtO9rq9-I175.m4a\r\n庆余年6卷103辛酸泪$http://audio.xmcdn.com/group37/M09/D2/16/wKgJoVpPlV6QON_lAF7a5WMGcfw584.m4a\r\n庆余年6卷104君之贱 上$http://audio.xmcdn.com/group37/M07/F1/DA/wKgJoVpQ8_yRaX6OAJ017rAKObU356.m4a\r\n庆余年6卷105君之贱 下$http://audio.xmcdn.com/group37/M07/F1/DA/wKgJoVpQ8_-hQJ7CAHtRQhMp5ws508.m4a\r\n庆余年6卷106君临东海$http://audio.xmcdn.com/group37/M07/F1/DF/wKgJoVpQ9BXC1OGOALFFV4aGCSw346.m4a\r\n庆余年6卷107浪花自悬崖上生$http://audio.xmcdn.com/group37/M05/11/1F/wKgJoFpSOJ3gluhZAHlb9xHNfk4724.m4a\r\n庆余年6卷108白云自高山上起$http://audio.xmcdn.com/group37/M06/11/23/wKgJoFpSOLLyZioaAHMmaf9C2ZE985.m4a\r\n庆余年6卷109庙中人$http://audio.xmcdn.com/group37/M06/11/28/wKgJoFpSOL6RusuCAHk5dN3f8Go354.m4a\r\n庆余年6卷110心中言$http://audio.xmcdn.com/group36/M0B/61/49/wKgJUlpTfoKCTg8fAIoN42YmmPk794.m4a\r\n庆余年6卷111月儿弯弯照东山$http://audio.xmcdn.com/group37/M02/2D/6C/wKgJoFpTfqTjEDLmAMu_FkSp4hw489.m4a\r\n庆余年6卷112长弓封夜山$http://audio.xmcdn.com/group37/M05/2D/6E/wKgJoFpTfrHQl-I2AJ4GMnBYN7M579.m4a\r\n庆余年6卷113遮月$http://audio.xmcdn.com/group36/M0A/CD/77/wKgJTVpU2h-S8we0ANpFKYbWOGo682.m4a\r\n庆余年6卷114投奔怒海$http://audio.xmcdn.com/group37/M0B/4C/54/wKgJoVpU2jLjNn93AHt3g6u-owA704.m4a\r\n庆余年6卷115海上的那颗心$http://audio.xmcdn.com/group36/M03/CD/7B/wKgJTVpU2j_SFvnrAJynPZrjv_0565.m4a\r\n庆余年6卷116追捕 上$http://audio.xmcdn.com/group24/M00/FF/C8/wKgJNVpWNznzE3NDAHWus3gOQSg652.m4a\r\n庆余年6卷117追捕 中$http://audio.xmcdn.com/group24/M00/FF/74/wKgJMFpWN0Sj8ApKAHbY52s7fLQ066.m4a\r\n庆余年6卷118追捕 下$http://audio.xmcdn.com/group22/M01/01/4E/wKgJM1pWN1DjzM_8AG08j74w2vQ329.m4a\r\n庆余年6卷119惊艳一枪$http://audio.xmcdn.com/group35/M09/33/26/wKgJnFpXeHmBm1ZvALV3sRNojUU942.m4a\r\n庆余年6卷120伤心小箭$http://audio.xmcdn.com/group35/M09/33/26/wKgJnFpXeHmjCt-NAJDR2jciyqw747.m4a\r\n庆余年6卷121大宗师$http://audio.xmcdn.com/group35/M09/E9/7A/wKgJnVpXeISA2NspAG8_HgoCQIk954.m4a\r\n庆余年6卷122人世间$http://audio.xmcdn.com/group32/M06/48/11/wKgJUFpY0tuxbLkfAGNrMv7Ij7A398.m4a\r\n庆余年6卷123会东山$http://audio.xmcdn.com/group2/M02/2C/FB/wKgJRFpY0wPhowHNALyIzXksEq4022.m4a\r\n庆余年6卷124大行$http://audio.xmcdn.com/group36/M03/88/10/wKgJUlpY0xTBld3zAJWSx8-Ww3E532.m4a\r\n庆余年6卷125京都的蝉鸣$http://audio.xmcdn.com/group25/M06/13/BD/wKgJNlpaHpOAlGKvAJf9ufka0x0022.m4a\r\n庆余年6卷126每个人的心上都有一层皮$http://audio.xmcdn.com/group25/M06/13/BE/wKgJNlpaHpiTFGZxAKNuaN3d-UE902.m4a\r\n庆余年6卷127秋意初起$http://audio.xmcdn.com/group25/M06/FD/F0/wKgJMVpaHpuAx5b1AF9jZe5uMAI071.m4a\r\n庆余年6卷128借先生骨头一用$http://audio.xmcdn.com/group25/M05/00/C0/wKgJMVpbg3WxIZoeAJ7fh01kbaQ601.m4a\r\n庆余年6卷129悲声$http://audio.xmcdn.com/group25/M05/00/C5/wKgJMVpbg5CzUt9GAI8WZh9fyZs597.m4a\r\n庆余年6卷130他其实一直都在$http://audio.xmcdn.com/group33/M00/3A/11/wKgJUVpbg6iiVSReAJNSFzw1FWs143.m4a\r\n庆余年6卷131洋葱巷中的秘会$http://audio.xmcdn.com/group19/M05/ED/95/wKgJK1pcu5CjNpohAFPwIBv20zg307.m4a\r\n庆余年6卷132谁能长有澹泊意$http://audio.xmcdn.com/group36/M00/DD/84/wKgJTVpcvIOgvfoMAQAAc3eh56s403.m4a\r\n庆余年6卷133有子逾墙$http://audio.xmcdn.com/group18/M01/EF/EC/wKgJJVpeILvSdGvOAKlQUfSaYYk129.m4a\r\n庆余年6卷134谁家府上$http://audio.xmcdn.com/group36/M07/E0/9C/wKgJTVpeINPDg2HAANfHt-RcJ4w018.m4a\r\n庆余年6卷135杀人从来不亮剑$http://audio.xmcdn.com/group27/M05/18/A1/wKgJW1pfcoDTXmj9ALWcZdwIeVc927.m4a\r\n庆余年6卷136第一次拔出靴中的匕首$http://audio.xmcdn.com/group33/M01/42/2A/wKgJUVpfcpfA-trLAJ1NOxT3nL4079.m4a\r\n庆余年6卷137那一夜$http://audio.xmcdn.com/group29/M02/8E/6B/wKgJWVpfcsvQI_TwAPlL7dygs_8082.m4a\r\n庆余年6卷138闲推月下门及暴烈突进$http://audio.xmcdn.com/group33/M03/44/F5/wKgJUVpgw1GjFDiyAOVCsJr-wXA678.m4a\r\n庆余年6卷139强悍，因为决心$http://audio.xmcdn.com/group2/M00/3D/EE/wKgJRVphX2_gsBXRAJbapxCJnhA249.m4a\r\n庆余年6卷140皇城内外尽杀声$http://audio.xmcdn.com/group38/M01/30/AB/wKgJo1pjbKqj2J_1AO8nu_68VMI550.m4a\r\n庆余年6卷141数枝箭$http://audio.xmcdn.com/group39/M06/4E/E6/wKgJn1pkrArBNDGtAH-ycXcMb3Q923.m4a\r\n情绪庆余年6卷142多情太监无情箭$http://audio.xmcdn.com/group38/M04/4E/70/wKgJolpkrC7xfrWyAMxu9SpLYnk338.m4a\r\n庆余年6卷143狠手 上$http://audio.xmcdn.com/group39/M06/4E/EF/wKgJn1pkrCijhreMAHXgnzzwlu4786.m4a\r\n庆余年6卷144狠手 下$http://audio.xmcdn.com/group39/M0A/6E/C2/wKgJn1pmBZPS8y_4AKEmgKSg76U826.m4a\r\n庆余年6卷145逃难中的陈萍萍的影子及孩子$http://audio.xmcdn.com/group38/M0B/6E/6A/wKgJolpmBavQdfZFAOs_btcytEs747.m4a\r\n庆余年6卷146请君入瓮$http://audio.xmcdn.com/group38/M0B/6E/6A/wKgJolpmBaiDM-xCAHuRTh7Mdc8983.m4a\r\n庆余年6卷147正阳门前的伏击$http://audio.xmcdn.com/group38/M00/90/EB/wKgJo1pnU0DBv7fIAJF6uQOKTXg742.m4a\r\n庆余年6卷148光荣$http://audio.xmcdn.com/group38/M00/90/F2/wKgJo1pnU1fhvi7EAMlyjpdq6Rs419.m4a\r\n庆余年6卷149夺旗 夺势 夺心$http://audio.xmcdn.com/group38/M00/90/F3/wKgJo1pnU13xwSZCAJR1mlk2smQ005.m4a\r\n庆余年6卷150城头祭出神主牌$http://audio.xmcdn.com/group39/M09/B1/47/wKgJn1poqz7AIMDUAK0yNsdcR78109.m4a\r\n庆余年6卷151箕坐于城不得安$http://audio.xmcdn.com/group39/M09/B1/4C/wKgJn1poq1Oyos7aAHWl4n5I3o0119.m4a\r\n庆余年6卷152谁将君心拟火海$http://audio.xmcdn.com/group38/M00/B1/58/wKgJolpoq36TL0MaAIf3IP0BpGo041.m4a\r\n庆余年6卷153且以黑骑开序幕$http://audio.xmcdn.com/group39/M03/D2/2D/wKgJnlpp-gzBmbZmAMN-AnsQ1Xc395.m4a\r\n庆余年6卷154荆戈刺秦$http://audio.xmcdn.com/group38/M01/EF/BB/wKgJolprSLTC1f6KAKaRKJVqCdc429.m4a\r\n庆余年6卷155杀秦$http://audio.xmcdn.com/group38/M01/EF/C1/wKgJolprSMrhMqVMAMFGIz3wXc8445.m4a\r\n庆余年6卷156一眼瞬间之无间$http://audio.xmcdn.com/group39/M02/F0/1A/wKgJnlprSNqAhMTXAIA7DDop_II689.m4a\r\n庆余年6卷157定州军的定$http://audio.xmcdn.com/group39/M0A/0D/56/wKgJnlpslyDRfLrxAF3iSNilphU038.m4a\r\n庆余年6卷158太平别院$http://audio.xmcdn.com/group39/M0A/0D/59/wKgJnlpsly3yaSHRAH7HoND2l-w448.m4a\r\n庆余年6卷159花一树 琴千声 人一个$http://audio.xmcdn.com/group38/M07/0C/F3/wKgJolpsl1KhP-WuAPlO3Gc1G2o672.m4a\r\n庆余年6卷160云无心以出袖 剑有意不知还$http://audio.xmcdn.com/group39/M0B/30/15/wKgJnlpt7_LCBPBIAH_xu9jyYRQ597.m4a\r\n庆余年6卷161王道$http://audio.xmcdn.com/group39/M03/56/09/wKgJnlpvP_ygYe-vAMfotLVagY4145.m4a\r\n庆余年6卷162如瀑入海 如山临日$http://audio.xmcdn.com/group39/M03/55/BF/wKgJn1pvQAnzSg_4AJri23GngJQ001.m4a\r\n庆余年6卷163大东山上的因果$http://audio.xmcdn.com/group39/M03/55/C5/wKgJn1pvQB2xntsIAK72erL2L2I370.m4a\r\n庆余年6卷164纸入湖而鱼动 袖开帷而人殁$http://audio.xmcdn.com/group39/M04/77/A9/wKgJnlpwlCyiSocoAM8i7jfMEdQ724.m4a\r\n庆余年6卷165青花辞$http://audio.xmcdn.com/group38/M08/76/B7/wKgJolpwlE6wGWC-AKGQOd36tEk658.m4a\r\n庆余年6卷166有尊严的生存或死亡$http://audio.xmcdn.com/group38/M08/95/59/wKgJolpx2cazhK0UALNohuDR3hU148.m4a\r\n庆余年6卷167老姜渐渐淡去$http://audio.xmcdn.com/group39/M06/96/32/wKgJnlpx2b7wSYyHAH6DOeVpPOk209.m4a\r\n庆余年6卷168愤怒的葡萄$http://audio.xmcdn.com/group38/M03/95/63/wKgJolpx2efBBZQ8ANicyN5chDY149.m4a\r\n庆余年6卷168麦田守望者$http://audio.xmcdn.com/group39/M06/B6/C8/wKgJn1pzNRPCHoAAADIEpCOjXYU092.m4a\r\n庆余年6卷170父与子的下半卷$http://audio.xmcdn.com/group39/M08/D3/10/wKgJn1p0cnGyNhsSACWaVe9yXhY782.m4a\r\n庆余年6卷171聆钟$http://audio.xmcdn.com/group39/M09/D3/16/wKgJn1p0corSqOVOAJTxq5ajznM871.m4a\r\n庆余年6卷172百年孤独$http://audio.xmcdn.com/group39/M09/D3/74/wKgJnlp0cp6T2cO-AKWZMQKdfJI432.m4a\r\n庆余年 6卷173你是我的小棉袄$http://audio.xmcdn.com/group39/M01/F7/CF/wKgJnlp1112Byp9KAKWzSXslg5s465.m4a\r\n庆余年6卷174入楼出楼渐温柔$http://audio.xmcdn.com/group38/M01/F6/ED/wKgJolp114XAgyFqAKrcwsWqNlY468.m4a\r\n庆余年6卷175皇帝的心意$http://audio.xmcdn.com/group38/M01/F7/21/wKgJo1p116LBk0mWAMXcezy6S50504.m4a\r\n庆余年6卷176送战友$http://audio.xmcdn.com/group38/M0B/3C/13/wKgJolp4fcGAKRLsAKf0bR3KKzs307.m4a\r\n庆余年6卷177青山遮不住$http://audio.xmcdn.com/group38/M0B/3C/19/wKgJolp4fdqCTGkLAQRSQaU_sHE075.m4a\r\n庆余年6卷178我们的不满的冬天$http://audio.xmcdn.com/group38/M0B/3C/1B/wKgJolp4feOzeIiwAOutGZ--Z8Q029.m4a\r\n庆余年7卷1流年里的官司$http://audio.xmcdn.com/group39/M04/5F/2C/wKgJnlp5zL7BChPaALme1XFa7Xw009.m4a\r\n庆余年7卷2定州城内的胡歌$http://audio.xmcdn.com/group39/M04/5F/2E/wKgJnlp5zMvQV1gvAL3Qys4qTuM057.m4a\r\n庆余年7卷3大将军府$http://audio.xmcdn.com/group39/M04/5F/31/wKgJnlp5zNeRsWB5ALNv26mtlHA755.m4a\r\n大官人666钦差驾到$http://audio.xmcdn.com/group38/M0B/5E/39/wKgJo1p5zNvRxhisAGOEKTZSS9A826.m4a\r\n庆余年7卷4烈酒暖人心$http://audio.xmcdn.com/group39/M06/7A/99/wKgJnlp6-hmw1dhXAMd8ksxhwsg961.m4a\r\n庆余年7卷5断刀$http://audio.xmcdn.com/group38/M0B/9F/F6/wKgJolp8ZtGzYbJFAK5AZknEVWM535.m4a\r\n庆余年7卷6边城故人$http://audio.xmcdn.com/group38/M0B/9F/F7/wKgJolp8ZtSTEY9EAId_pjPXKz4712.m4a\r\n庆余年7卷7王帐里走出来的年轻人$http://audio.xmcdn.com/group38/M0B/A0/1E/wKgJo1p8ZvPz1-JAAI9eWhWe3YE197.m4a\r\n庆余年7卷单于$http://audio.xmcdn.com/group39/M02/C3/6B/wKgJn1p9tuvjedqeAJXLAL2t6WQ764.m4a\r\n庆余年7卷9两年$http://audio.xmcdn.com/group38/M06/C2/B7/wKgJolp9ttWxtXwiAFjbz1PBVeI044.m4a\r\n庆余年7卷10湖畔的海棠花$http://audio.xmcdn.com/group39/M02/C3/EF/wKgJnlp9tuijBiyGAI7LQc23mu8341.m4a\r\n庆余年7卷11三天$http://audio.xmcdn.com/group38/M06/E0/99/wKgJo1p-_kHQAGHDAM7nKiX1JwU070.m4a\r\n庆余年7卷12心战后传$http://audio.xmcdn.com/group39/M02/E2/09/wKgJnlp-_l2yJHPyAJi93x7V3w4095.m4a\r\n庆余年7卷13秋原 朝阳 黑骑$http://audio.xmcdn.com/group39/M02/E1/8D/wKgJn1p-_m2QvfiMAIUTVUE9TzA603.m4a\r\n庆余年7卷14归来$http://audio.xmcdn.com/group38/M00/06/1D/wKgJolqAXzKgWENJAJKOy4dpNiI369.m4a\r\n庆余年7卷15窗外$http://audio.xmcdn.com/group39/M09/07/38/wKgJn1qAX0SzaO-CAIV4sTJG2hU908.m4a\r\n庆余年7卷16把那风景都看透$http://audio.xmcdn.com/group38/M01/42/44/wKgJolqDCObhkY1aAJXyo9UpRHo645.m4a\r\n庆余年7卷17在城门上目光注视中回京$http://audio.xmcdn.com/group39/M05/43/31/wKgJn1qDCQuAp6CZAJ3l5fyjP7c812.m4a\r\n庆余年7卷18城南旧事非故人$http://audio.xmcdn.com/group38/M08/83/58/wKgJolqG_qiA6BaNAJ5Yb45bn4c241.m4a\r\n庆余年7卷19王家小姐$http://audio.xmcdn.com/group39/M03/84/7E/wKgJn1qG_svAOJEXAK0BuQC9CJ4087.m4a\r\n庆余年7卷20收不收，这不是一个问题$http://audio.xmcdn.com/group39/M03/99/4B/wKgJn1qISTuSiMNCAIS_gy3h6Jc102.m4a\r\n庆余年7卷21算盘$http://audio.xmcdn.com/group39/M03/99/BA/wKgJnlqISVfyrjF_AIIX7VceTso930.m4a\r\n庆余年7卷22天子之雷及范闲遗失之牌$http://audio.xmcdn.com/group39/M03/99/B9/wKgJnlqISVXw3fCgACg_zWLRxdY712.m4a\r\n庆余年7卷23一样的月光$http://audio.xmcdn.com/group37/M08/66/2F/wKgJoVqJnlnRcoAvAJVdxTxf8yo013.m4a\r\n庆余年7卷24医者何心$http://audio.xmcdn.com/group33/M05/46/3A/wKgJUVqJnm3QQVENAK8FKrXwg6U928.m4a\r\n庆余年7卷25夜半歌声$http://audio.xmcdn.com/group33/M05/46/3D/wKgJUVqJnn3jWBShALdwdhthv0o649.m4a\r\n庆余年7卷26两院间的渠$http://audio.xmcdn.com/group31/M03/C9/AE/wKgJSVqK79myizq-AIpZ_uXhGV8788.m4a\r\n庆余年7卷27东风吹$http://audio.xmcdn.com/group31/M03/C9/B0/wKgJSVqK7-PRR9bMAC1ZjRQRsCU923.m4a\r\n庆余年7卷28戏至冬日$http://audio.xmcdn.com/group19/M02/F9/B9/wKgJJlqK8A7ijsWGALKybZhJcYo515.m4a\r\n庆余年7卷29春来我去也$http://audio.xmcdn.com/group33/M01/4A/95/wKgJUVqMQ6SCF-8cAJ6BijsDEkM124.m4a\r\n庆余年7卷30同一条路$http://audio.xmcdn.com/group38/M06/AF/01/wKgJo1qMQ7eAccssAJu8pjR6J-k935.m4a\r\n庆余年7卷31周公为师$http://audio.xmcdn.com/group38/M06/AF/03/wKgJo1qMQ8DAVv42AJKvR0iMnqI983.m4a\r\n庆余年7卷32闲来斩梅$http://audio.xmcdn.com/group36/M00/A3/7E/wKgJUlqO3f3AV9jLAJ5UBG5Q5lI250.m4a\r\n庆余年7卷33影随我身$http://audio.xmcdn.com/group36/M00/A3/82/wKgJUlqO3gfiZWuwAKRRIsuIQEk270.m4a\r\n庆余年7卷34人生何处不相逢$http://audio.xmcdn.com/group22/M02/21/7B/wKgJLlqO3iLBDBo-AODy56feV_0045.m4a\r\n庆余年7卷36山居中的女子与帝心$http://audio.xmcdn.com/group33/M05/9C/A0/wKgJTFqQKRfilHJNALbchDBDzz4301.m4a\r\n庆余年7卷36断杨入庐$http://audio.xmcdn.com/group33/M0B/52/DB/wKgJUVqQKR6QXDXdAIYMPOsKmbc518.m4a\r\n庆余年7卷37庐中客$http://audio.xmcdn.com/group24/M06/22/A5/wKgJMFqQKSrwzybPAJrdF9ZfKDE916.m4a\r\n庆余年7卷38暮色中的秘密$http://audio.xmcdn.com/group23/M08/29/ED/wKgJL1qRgvyhuNvSAGIngLOvY7o380.m4a\r\n庆余年7卷39真正的殿前欢$http://audio.xmcdn.com/group26/M0A/30/1F/wKgJRlqRgx_yg-rjAKe3MFDDTgM112.m4a\r\n庆余年7卷40一朝天子一朝臣$http://audio.xmcdn.com/group26/M0A/30/23/wKgJRlqRgynAidLLAEq_CTa_4-Y362.m4a\r\n庆余年7卷41梳头$http://audio.xmcdn.com/group34/M00/77/35/wKgJYFqS0HyCoxWoAJy1kpG0bh8271.m4a\r\n庆余年7卷42剑庐里的坑$http://audio.xmcdn.com/group26/M07/33/BB/wKgJWFqS0KDSlteuALPj3QKQmow173.m4a\r\n庆余年7卷43老家伙$http://audio.xmcdn.com/group2/M02/51/63/wKgJRVqS0LPj8YeMAJOou843i8I316.m4a\r\n庆余年7卷44好大一棵树$http://audio.xmcdn.com/group41/M01/16/1B/wKgJ8VqUIuiCGARBALeootAxFPM420.m4a\r\n庆余年7卷45一眼瞬间$http://audio.xmcdn.com/group42/M08/16/4C/wKgJ9FqUJ9_zdyZRAHWhRBm3jAU860.m4a\r\n庆余年7卷46三人行$http://audio.xmcdn.com/group41/M04/17/67/wKgJ8lqULbXw2NmeAJBAfK9eRYo212.m4a\r\n庆余年7卷47拔剑四顾心茫然$http://audio.xmcdn.com/group42/M08/37/EC/wKgJ9FqVfD3yEYpHAJ09BE03G_w304.m4a\r\n庆余年7卷48非圣人不能用之$http://audio.xmcdn.com/group42/M07/65/8A/wKgJ9FqXO6nzgdIkANfAhDVdxTU770.m4a\r\n庆余年7卷49种毒$http://audio.xmcdn.com/group41/M00/66/A3/wKgJ8lqXO7ySQuNwAOJkeEsmS1w388.m4a\r\n庆余年7卷50我们都是颜色不一样的海$http://audio.xmcdn.com/group42/M01/66/A0/wKgJ81qXO9Lyiqn1AM07ajiDsAs498.m4a\r\n庆余年7卷51浪花退去$http://audio.xmcdn.com/group42/M04/A1/63/wKgJ9FqZc7byw3mTAK10SXpr4WE588.m4a\r\n庆余年7卷52回京求官去$http://audio.xmcdn.com/group41/M0A/A3/EF/wKgJ8lqZc9PwWu93AKAZxHNR2VM581.m4a\r\n庆余年7卷53议亲议功$http://audio.xmcdn.com/group42/M07/C0/70/wKgJ9Fqawy-zjNPWAPDterY9oqg238.m4a\r\n庆余年7卷54抢院夺权$http://audio.xmcdn.com/group41/M08/C0/1D/wKgJ8Vqaw0nxJhY2AKU9faVIf6Y294.m4a\r\n庆余年7卷55一夜长大$http://audio.xmcdn.com/group41/M00/C3/5C/wKgJ8lqaw4DSikpRAOmmCKhjkGA952.m4a\r\n庆余年7卷56别院之间苦心思$http://audio.xmcdn.com/group42/M04/E2/4A/wKgJ81qcEiySxRFeAH1XDejlYNU230.m4a\r\n庆余年7卷57坟$http://audio.xmcdn.com/group41/M01/E3/E2/wKgJ8lqcEj-R-6CBAI8Ht2I-Enc975.m4a\r\n庆余年7卷58分手擂台$http://audio.xmcdn.com/group41/M01/E3/EB/wKgJ8lqcEmeBfv9nALO6v-6Ctnw530.m4a\r\n庆余年7卷59一杯淡茶知冷暖$http://audio.xmcdn.com/group41/M0B/02/C3/wKgJ8lqdVD-SXZ3vALSRW15dNBw037.m4a\r\n庆余年7卷60席中假孟浪$http://audio.xmcdn.com/group42/M0B/00/12/wKgJ9FqdVFbhUmGfALcwOT33nGY988.m4a\r\n庆余年7卷61太学里的黑伞及鼻梁上的光明$http://audio.xmcdn.com/group41/M0B/FF/D3/wKgJ8VqdVHLTBVRmALGl65QYjqY946.m4a\r\n庆余年7卷62春园乱$http://audio.xmcdn.com/group42/M04/23/C0/wKgJ81qet-fwRT19AK6UG7jxy8w368.m4a\r\n庆余年7卷63口子$http://audio.xmcdn.com/group42/M08/22/A4/wKgJ9Fqet_zCO7ObALpDS8cKYWI091.m4a\r\n庆余年7卷64犯错$http://audio.xmcdn.com/group42/M08/22/A9/wKgJ9FqeuAzyDZlFAH8s89FS3n4103.m4a\r\n庆余年7卷65鱼肠$http://audio.xmcdn.com/group40/M01/0B/2C/wKgJVFqgBvbgrjR3AHylX53DOv4107.m4a\r\n庆余年7卷55农夫 山庄 有点田$http://audio.xmcdn.com/group40/M01/0B/2C/wKgJVFqgBvfgwvZEAHXDdhgoAr4520.m4a\r\n庆余年7卷67十家村$http://audio.xmcdn.com/group40/M01/0A/5E/wKgJT1qgBxKjpJmYALXdBPrErTM033.m4a\r\n庆余年7卷68天之公道$http://audio.xmcdn.com/group40/M04/1F/D8/wKgJT1qhWpjg3_owAIGOZr612wA618.m4a\r\n庆余年7卷69洒落人间的星光$http://audio.xmcdn.com/group41/M0A/58/69/wKgJ8VqhWrjS2s2nAMMekZ5B9Ao026.m4a\r\n庆余年7卷70意志，即是王道$http://audio.xmcdn.com/group41/M07/6F/68/wKgJ8lqiqjCiDmKFAKj8XzXZVE0424.m4a\r\n庆余年7卷71庙 蚂蚁 册子$http://audio.xmcdn.com/group42/M08/90/CC/wKgJ81qk9BbD5CvqAI2wF5BunZ4616.m4a\r\n庆余年7卷72满身风雨 我从海上来$http://audio.xmcdn.com/group42/M0A/90/CF/wKgJ81qk9CfSG4zAAIcV7MQlKHU348.m4a\r\n庆余年7卷73满身风雨 我从海上来二$http://audio.xmcdn.com/group42/M0A/90/D5/wKgJ81qk9Dex67vIAIPT2aUcqwg415.m4a\r\n庆余年7卷74满身风雨我从海上来三$http://audio.xmcdn.com/group41/M0A/9C/C6/wKgJ8lqlTwSQocQfAJPiAAgaen4146.m4a\r\n庆余年7卷75空有一物 剑有一手$http://audio.xmcdn.com/group41/M0A/99/FB/wKgJ8VqlTw7gmtqZAHdKEp-3yKo078.m4a\r\n庆余年7卷76天下银根 必杀！$http://audio.xmcdn.com/group40/M09/79/4A/wKgJVFqmnzOQgpsYAKVrAsvmHEc138.m4a\r\n庆余年7卷77开庐$http://audio.xmcdn.com/group40/M09/79/4C/wKgJVFqmnz7C-1U5AHtfYqLz4UY428.m4a\r\n庆余年7卷78应作如是想$http://audio.xmcdn.com/group41/M01/B0/DC/wKgJ8Vqmn06RoQyLAILdKgJ8n38978.m4a\r\n庆余年7卷79简单的征服$http://audio.xmcdn.com/group42/M03/C7/65/wKgJ81qn55DBwXkUAKOK00vsM44611.m4a\r\n庆余年7卷80平乱之心$http://audio.xmcdn.com/group42/M03/C7/68/wKgJ81qn55qy0B0HAHmVPFlf8Ck357.m4a\r\n庆余年7卷81归路有血$http://audio.xmcdn.com/group41/M01/C8/C8/wKgJ8lqn59fTaLdvAJKF_rmgbGU965.m4a\r\n庆余年7卷82风起$http://audio.xmcdn.com/group42/M00/DE/52/wKgJ9FqpQ5jDW3uPALXi6MYwvng626.m4a\r\n庆余年7卷83娘子$http://audio.xmcdn.com/group40/M0B/BB/BC/wKgJT1qqkQCjt84AAHfhG1JI0aM284.m4a\r\n庆余年7卷84都是京都来的人$http://audio.xmcdn.com/group40/M0B/BC/B4/wKgJVFqqkSeQcYtJAH523-Ug2cA435.m4a\r\n庆余年7卷85拼$http://audio.xmcdn.com/group40/M0B/BC/B4/wKgJVFqqkSXgzd6uAIs44CRHy_0197.m4a\r\n庆余年7卷86天生一对$http://audio.xmcdn.com/group42/M04/0B/02/wKgJ81qr6E7hmlUMAL1cQPVR_jg584.m4a\r\n庆余年7卷87朕要那条老狗活着$http://audio.xmcdn.com/group42/M04/0B/04/wKgJ81qr6FaTfrWOAJmtHtMO8LM267.m4a\r\n庆余年7卷88君子 伙伴 后路$http://audio.xmcdn.com/group40/M01/D2/39/wKgJVFqr6HWCjommAOZbKMZtPuQ144.m4a\r\n庆余年7卷89夜风中的轮椅$http://audio.xmcdn.com/group40/M06/E9/16/wKgJVFqtQmfya-gLAOAgbidYPws222.m4a\r\n庆余年7卷90两个人的战争之序幕$http://audio.xmcdn.com/group41/M03/23/9E/wKgJ8lqtQoyxXEKaAPjHxOP6gYY172.m4a\r\n庆余年7卷91一辆车的孤单之入城$http://audio.xmcdn.com/group41/M03/20/F8/wKgJ8VqtQpfAF7G1AKuxeBE1mSc074.m4a\r\n大官人745庄夫子$http://audio.xmcdn.com/group42/M00/21/C7/wKgJ9FqtQrmQWt78AF56340-OGA262.m4a\r\n庆余年7卷92数十年的往事之愤怒$http://audio.xmcdn.com/group40/M0A/01/2C/wKgJT1quhlmwNYw0AMNpdZNJdyQ527.m4a\r\n庆余年7卷93那又如何$http://audio.xmcdn.com/group40/M0A/02/25/wKgJVFquhmWj2XEGALvkV7gCYv0203.m4a\r\n庆余年7卷94监天察地不肯退$http://audio.xmcdn.com/group42/M0B/53/C1/wKgJ81qv2CHS8oQeAQpSPk-S7Xo533.m4a\r\n庆余年7卷95陈萍萍的复仇$http://audio.xmcdn.com/group40/M07/19/F2/wKgJT1qv2DnBmrbHARKyXqJh3gQ392.m4a\r\n庆余年7卷96御书房内竹开花$http://audio.xmcdn.com/group40/M07/19/F3/wKgJT1qv2DyCUulrANDwB70uZjo950.m4a\r\n庆余年7卷97一根手指与监察院的臣服$http://audio.xmcdn.com/group40/M0B/32/D4/wKgJVFqxLz2DsbwyAQsugipwxqQ856.m4a\r\n庆余年7卷京都乱 红烛摇$http://audio.xmcdn.com/group40/M0B/31/DB/wKgJT1qxL0bj3uOkAQAMR4A0JNw254.m4a\r\n庆余年7卷99笑看英雄不等闲1$http://audio.xmcdn.com/group40/M06/4A/91/wKgJVFqyhoHxMYeOAIGYoND2BWU999.m4a\r\n庆余年7卷10笑看英雄不等闲2$http://audio.xmcdn.com/group40/M06/49/BB/wKgJT1qyhqKw_zbjAN6tIrJ-kaM322.m4a\r\n庆余年7卷101笑看英雄不等闲3$http://audio.xmcdn.com/group41/M09/85/26/wKgJ8lqyhtmAwD1GAQUhUdBPye8509.m4a\r\n庆余年7卷102雨中送陈萍萍$http://audio.xmcdn.com/group41/M04/9A/46/wKgJ8lqzy6XTRhMMAKDEHOZt_kk745.m4a\r\n庆余年7卷103$http://audio.xmcdn.com/group41/M04/97/96/wKgJ8Vqzy8XQbLezAN_7ulCX1uk770.m4a\r\n庆余年7卷104长睡范府不愿醒$http://audio.xmcdn.com/group42/M0B/AD/59/wKgJ81q1HmLQ_keqALfajUb5nUY771.m4a\r\n庆余年7卷105梦中雪山 盆中血水$http://audio.xmcdn.com/group42/M0B/AD/58/wKgJ81q1HmDC8IFIAJhPoVcxfPM830.m4a\r\n庆余年7卷106洗手除官$http://audio.xmcdn.com/group40/M06/74/B1/wKgJVFq1HoGBTEaGAN1-pZ8pesk501.m4a\r\n庆余年7卷107七日$http://audio.xmcdn.com/group41/M05/D6/A4/wKgJ8Vq3xlaQ_NyaAKuJ1RVMkDY146.m4a\r\n庆余年7卷108启年小组踏上各自的路$http://audio.xmcdn.com/group41/M05/D9/2C/wKgJ8lq3xmDx7oFBALSM9H5_jgc781.m4a\r\n庆余年7卷409庆庙有雨$http://audio.xmcdn.com/group40/M01/9E/F6/wKgJVFq3xm7D3ifqAL_rLdwq-AY106.m4a\r\n庆余年7卷110庙的名 人的影$http://audio.xmcdn.com/group42/M09/ED/39/wKgJ81q5DeiQ1fvIASemWNNNIzs776.m4a\r\n庆余年7卷111准备着$http://audio.xmcdn.com/group41/M00/EC/45/wKgJ8Vq5DfGCQMjIAMIyJsGKotA943.m4a\r\n庆余年7卷112宫中的范家小姐$http://audio.xmcdn.com/group41/M00/EC/49/wKgJ8Vq5Df_S-gBZALV3sfPjiL0361.m4a\r\n庆余年7卷113君臣相见可能安？$http://audio.xmcdn.com/group40/M00/C8/6B/wKgJVFq6WR2Q7ZSPALbyjb8edbo127.m4a\r\n庆余年7卷114是 陛下$http://audio.xmcdn.com/group40/M00/C7/86/wKgJT1q6WR-hzO6jAJjm47MzmWs386.m4a\r\n庆余年7卷115献芹$http://audio.xmcdn.com/group40/M00/C8/6E/wKgJVFq6WSfBfepFAHU1Be88BSw794.m4a\r\n庆余年7卷116看，上去很美$http://audio.xmcdn.com/group40/M03/DD/F9/wKgJVFq7uhbRDcruAJIAWnDaMjU788.m4a\r\n庆余年7卷117京都闲人$http://audio.xmcdn.com/group42/M0B/16/C6/wKgJ81q7ujnj13ESAQTscgYf_SM249.m4a\r\n庆余年7卷118北方有变$http://audio.xmcdn.com/group42/M06/2C/52/wKgJ9Fq9CefwaAK7AMl8h2DHqjA035.m4a\r\n庆余年7卷119雪花背后的真相$http://audio.xmcdn.com/group42/M06/2C/89/wKgJ81q9CfjjISBQAME4uq1D8W4771.m4a\r\n庆余年7卷120冬又至$http://audio.xmcdn.com/group41/M0B/42/F3/wKgJ8lq-XRbTUP_qAL4vduy-IZw180.m4a\r\n庆余年7卷121一败之西胡悲歌$http://audio.xmcdn.com/group41/M0B/42/F3/wKgJ8lq-XRbRT7eQAMF-_UJhTqs987.m4a\r\n庆余年7卷122定西凉$http://audio.xmcdn.com/group41/M09/5A/DE/wKgJ8lq_rtvgC5UVALkZNdv4eBc523.m4a\r\n庆余年7卷123乱江南$http://audio.xmcdn.com/group40/M02/20/79/wKgJVFq_rwPjO8U9AL8cIZ8wNck449.m4a\r\n庆余年7卷124京华江南皆有血$http://audio.xmcdn.com/group40/M02/20/7A/wKgJVFq_rwjRMOiKAPAi2NXPJ-M106.m4a\r\n庆余年7卷125谁在京都杀四方$http://audio.xmcdn.com/group40/M0B/38/31/wKgJT1rBBt7QsbpbAOfF3f1Mk-s787.m4a\r\n庆余年7卷126殿前尽欢需断肠$http://audio.xmcdn.com/group40/M0B/39/18/wKgJVFrBBuPAtwcaAM5OBF1t8NY673.m4a\r\n庆余年7卷127布衣单剑朝天子$http://audio.xmcdn.com/group42/M0B/89/8E/wKgJ9FrCRbjAis7-AJ8gIu5bR3I178.m4a\r\n庆余年7卷128布衣单剑朝天子2$http://audio.xmcdn.com/group40/M01/4E/8F/wKgJVFrCRcTD4rGLAKfITX2t48Q067.m4a\r\n庆余年7卷129布衣单剑朝天子3$http://audio.xmcdn.com/group40/M01/4E/98/wKgJVFrCRdzgUvqzAMeoGVg6Kq0348.m4a\r\n庆余年7卷130布衣单剑朝天子4$http://audio.xmcdn.com/group42/M0B/A3/2A/wKgJ9FrDoGCgtsEzAMResAvh1z4240.m4a\r\n庆余年7卷131布衣单剑朝天子5$http://audio.xmcdn.com/group40/M07/67/8A/wKgJT1rDoP7iSC7cAOLXA0vWZBI631.m4a\r\n庆余年7卷132苍山有雪剑有霜$http://audio.xmcdn.com/group42/M00/BD/E0/wKgJ9FrE9W7jPMpgAL2SlmKpcnU853.m4a\r\n庆余年7卷133苍山有雪剑有霜2$http://audio.xmcdn.com/group40/M08/B7/A3/wKgJVFrHnBHjUdAAAVz9UgBOYA8819.m4a\r\n庆余年7卷134苍山有雪剑有霜3$http://audio.xmcdn.com/group42/M00/F2/E0/wKgJ9FrHnFix7W-gASuwIecvx9I868.m4a\r\n庆余年7卷135苍山有雪剑有霜4$http://audio.xmcdn.com/group40/M04/CF/48/wKgJT1rI2-2ydsyYAS0fPWyBF-o566.m4a\r\n庆余年7卷136假山$http://audio.xmcdn.com/group41/M01/21/7C/wKgJ8VrKOmXgmqu5AJwSAZzfMso446.m4a\r\n庆余年7卷137人心向北$http://audio.xmcdn.com/group40/M06/E9/77/wKgJVFrKOqfRC21TAT0BUc3P1XY184.m4a\r\n庆余年7卷138人在旅途$http://audio.xmcdn.com/group40/M06/E9/78/wKgJVFrKOqqRA7tsAPnx_njZMOQ641.m4a\r\n庆余年7卷139寒雪勿乱$http://audio.xmcdn.com/group41/M0B/3C/31/wKgJ8lrLiCHSCN1OAKL8ZmZgbeo098.m4a\r\n庆余年7卷140一夜北风紧$http://audio.xmcdn.com/group41/M0B/3C/35/wKgJ8lrLiDGDZKXjALfL3tputoE072.m4a\r\n庆余年7卷141从前有座山$http://audio.xmcdn.com/group40/M05/19/EE/wKgJT1rM2CDiOO18AHF-vqJQrMo681.m4a\r\n庆余年7卷142山里有座庙$http://audio.xmcdn.com/group41/M05/52/C8/wKgJ8VrM2IygJu6WANNzQZ2D234316.m4a\r\n庆余年7卷143庙里有个人$http://audio.xmcdn.com/group42/M03/84/5D/wKgJ81rPgT_y7wWKAMXH6jL3xjQ730.m4a\r\n庆余年7卷144庙里有个人 2$http://audio.xmcdn.com/group41/M03/87/94/wKgJ8VrPgVXyWLNVAIHBuW8FFjs427.m4a\r\n庆余年7卷145庙里有个人 3$http://audio.xmcdn.com/group42/M02/89/47/wKgJ9FrPgZ7y1kBvAMAboTv7L7Y876.m4a\r\n庆余年7卷146那个人讲了一个故事$http://audio.xmcdn.com/group42/M07/A3/01/wKgJ9FrQ1CmyWMCiAMa0VetgA6k832.m4a\r\n庆余年7卷147辐射风情画及传奇$http://audio.xmcdn.com/group42/M00/A3/07/wKgJ9FrQ1ESza2lHANhqmpwUu0o076.m4a\r\n庆余年7卷148一个人的孤单$http://audio.xmcdn.com/group40/M04/83/A6/wKgJT1rSLbKBYkcbAJnUxVThq0Y967.m4a\r\n庆余年7卷149最强 人的名$http://audio.xmcdn.com/group42/M06/BE/D2/wKgJ9FrSLd3T_cc6AWDN1i_VB1Q956.m4a\r\n庆余年7卷150田园将芜胡不归 上$http://audio.xmcdn.com/group41/M03/F2/82/wKgJ8VrUvMujuFxcAF4J0AwZtC0125.m4a\r\n庆余年7卷151田园将芜胡不归 下$http://audio.xmcdn.com/group41/M03/F2/8A/wKgJ8VrUvOKgAhEwALEzKxuBNLY701.m4a\r\n庆余年7卷152暮$http://audio.xmcdn.com/group42/M05/0F/20/wKgJ9FrWGgTBzp-dAOQzBbMaTdE958.m4a\r\n庆余年7卷153枯$http://audio.xmcdn.com/group40/M08/D4/4F/wKgJT1rWGgGzBodxAJ4NtHSuK4U685.m4a\r\n庆余年7卷154午 上$http://audio.xmcdn.com/group42/M00/29/81/wKgJ9FrXeH6yFH9AAGiFOugq5bM506.m4a\r\n庆余年7卷155午 下$http://audio.xmcdn.com/group40/M05/EF/B5/wKgJVFrXeJOjNqJwAJ-16awDdpw096.m4a\r\n庆余年7卷156玻璃花$http://audio.xmcdn.com/group40/M04/07/A9/wKgJVFrYvGKwnA78ALLnTAo77M8890.m4a\r\n庆余年7卷157皇城前 下雨天$http://audio.xmcdn.com/group42/M02/3C/DA/wKgJ81rYvQfBOctxANp4kCL8wao776.m4a\r\n庆余年7卷158宫前行走谁折腰$http://audio.xmcdn.com/group40/M08/1D/5D/wKgJT1raG1ixYsAhAMRXV5HhlRc655.m4a\r\n庆余年7卷159南庆十二年的彩虹一$http://audio.xmcdn.com/group42/M0A/53/7B/wKgJ81raG3PxhaJpAPlGDwSlyMg251.m4a\r\n庆余年7卷160南庆十二年的彩虹二$http://audio.xmcdn.com/group42/M08/72/4E/wKgJ9FrbZJWQvhx1AKjXqzuLkZY352.m4a\r\n庆余年7卷161南庆十二年的彩虹三$http://audio.xmcdn.com/group42/M0A/72/51/wKgJ9FrbZNfTdpzNAbCO8pLaxFs006.m4a\r\n庆余年7卷末章 后来$http://audio.xmcdn.com/group41/M03/8A/E4/wKgJ8Vrcol-i8ZxgATC2eP-GE4I313.m4a', 'xml_8023', '2783', '', 'Q', '', '1.0', 2, 0, 0, 0, 'qingyunian', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(134, 24, '神话版三国', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group34/M09/70/99/wKgJYFnkzOzj9BD9AABCo4tR0vY766.jpg', '', 1530072223, 5, 0, 0, 0, 0, 1, 1, 4, 3, 'ting', '', '简介$http://audio.xmcdn.com/group34/M00/DF/6D/wKgJYFnovWqicIxtAAj9VLqCTus048.m4a\r\n第1章:陨石导致的历史变化$http://audio.xmcdn.com/group34/M03/E5/7C/wKgJYVnkzRTxlKZTAEtYL-RnoXY782.m4a\r\n第2章:划分$http://audio.xmcdn.com/group34/M00/0A/9F/wKgJYVnmFRmQfaeNAEbdV7Ai7Vo899.m4a\r\n第3章:离开之前$http://audio.xmcdn.com/group34/M0B/19/84/wKgJYVnm3-XQUhLEAEsZCLeCQiQ860.m4a\r\n第4章:路遇$http://audio.xmcdn.com/group34/M01/55/3B/wKgJYVnow2PxMr2zAEYrpfBdiXg314.m4a\r\n第5章:去见见这天下各路诸侯$http://audio.xmcdn.com/group34/M06/F4/83/wKgJYFnzQjHAlvSnAE1kaP_8_9I698.m4a\r\n第6章:投奔我大哥吧$http://audio.xmcdn.com/group34/M0B/F5/60/wKgJYFnzRnbggZJeAEYnPlZPIDs107.m4a\r\n第7章:长于大势的陈子川$http://audio.xmcdn.com/group34/M0B/F6/49/wKgJYFnzS5Hh-OM6AEZ5ezhJiQ0596.m4a\r\n第8章:还可以这样混进去～$http://audio.xmcdn.com/group32/M0A/EB/AA/wKgJS1n5z12zbNttAFShlSkRsUg364.m4a\r\n第9章:这个时期的袁绍和董卓$http://audio.xmcdn.com/group33/M06/63/58/wKgJTFn9yczjBGNKAEpEHpPvDzI411.m4a\r\n第10章:我们要做的事情$http://audio.xmcdn.com/group33/M08/64/5C/wKgJTFn9zk3Tw8lrAEfISrPdIrw921.m4a\r\n第11章：我的大斧已经难耐了……$http://audio.xmcdn.com/group35/M02/63/B9/wKgJnVoMW92iCVrpAEQ-QlwAIN4224.m4a\r\n第12章：杀了你我就能升级第13章关二爷的三刀$http://audio.xmcdn.com/group35/M05/4E/AC/wKgJnFoYKh-TOC9FAHg2JHuQcO0044.m4a\r\n第14章：袁绍发飙了$http://audio.xmcdn.com/group35/M00/85/E2/wKgJnFoZf3Sg6H37AEOnTaN9ES8224.m4a\r\n第15章：董卓的战争潜力$http://audio.xmcdn.com/group35/M0A/87/2D/wKgJnFoZhI6Tu89AAECqNxbCWoI504.m4a\r\n第16章：公孙瓒和刘虞$http://audio.xmcdn.com/group35/M07/B8/3C/wKgJnFoa1uXBKheKAD6N9F2VnXk374.m4a\r\n第17章：用拳头来感化你$http://audio.xmcdn.com/group35/M05/C2/74/wKgJnFobcZyDhXieAD3bn2FaJYE201.m4a\r\n第18章：李儒的心思$http://audio.xmcdn.com/group35/M04/79/49/wKgJnVobdc_j_jwrAD1yQlF1XS4963.m4a\r\n第19章：吕布来了$http://audio.xmcdn.com/group35/M09/7A/EB/wKgJnVobgfTiYcITAEDvadiXEMA542.m4a\r\n第20章：跨越极限的信念$http://audio.xmcdn.com/group35/M0B/C5/25/wKgJnFobhfuBSyzhAD26Tgfy6ko863.m4a\r\n第21章：逆天的吕布$http://audio.xmcdn.com/group35/M0B/CC/BC/wKgJnFobwkqgUedgADwEhhRUYI0079.m4a\r\n第22章：其实我算卦很好的…$http://audio.xmcdn.com/group36/M07/09/1A/wKgJUloqci_w8srKAD0BE5Yq1Jk211.m4a\r\n第23章：这个世界高手很多的$http://audio.xmcdn.com/group36/M05/0B/89/wKgJUloqdv_jBlRKADujXrEwMVM698.m4a\r\n第24章：研究一下怎么收拾对面$http://audio.xmcdn.com/group36/M05/6E/E5/wKgJUloro6-Tx6hkAEA_pQqBfmM729.m4a\r\n第25章：你什么都没有啊$http://audio.xmcdn.com/group36/M0B/70/52/wKgJUlorpyqCwP-NAEEjLdbD8s0062.m4a\r\n第26章：之后的路$http://audio.xmcdn.com/group36/M07/BD/49/wKgJUlosn_qzL0VsABFbldOuvmk049.m4a\r\n第27章：四世三公的袁家啊！$http://audio.xmcdn.com/group36/M07/BF/E4/wKgJUlospiDwS96aAFGHUiMK0lc057.m4a\r\n第28章：开屏箭$http://audio.xmcdn.com/group36/M08/C1/23/wKgJUlosqReCJWvvAC0DFmao56g914.m4a\r\n第29章：虎牢关下$http://audio.xmcdn.com/group36/M01/C2/31/wKgJUlosq7HQ3auTAD0x90px89U924.m4a\r\n第30章：真就不是人！$http://audio.xmcdn.com/group36/M01/C3/2C/wKgJUlosriSQ1f7yADpDE3O64pI370.m4a\r\n第31章绝学与弊端$http://audio.xmcdn.com/group37/M0B/F9/65/wKgJoFo6YYqCKnfDADomVHSNgkI742.m4a\r\n第32章，子龙也得上$http://audio.xmcdn.com/group36/M09/27/E5/wKgJUlo9HCvim5T1ADy7kpISjL4352.m4a\r\n第33章：迫于无奈，只能装装样子了$http://audio.xmcdn.com/group36/M06/60/ED/wKgJUlo-ZkaQo7W3AD0yP4Ei5So509.m4a\r\n第34章：董卓和李儒$http://audio.xmcdn.com/group36/M09/11/24/wKgJTVpA92rjD5oxADzNcyHZ0Eo580.m4a\r\n第35章，我们需要招贤纳士$http://audio.xmcdn.com/group36/M04/11/F0/wKgJTVpA-5GRzzISAD1t9qCpli8354.m4a\r\n第36章：感情我是丧门钉啊$http://audio.xmcdn.com/group37/M00/E7/D6/wKgJoFpE7NrR806JADwLV6KOhOo740.m4a\r\n第37章：全梦幻阵营$http://audio.xmcdn.com/group37/M03/A3/89/wKgJoVpNq3fSRS1sADgngSbupGQ632.m4a\r\n第38章，火焰之下的，洛阳。$http://audio.xmcdn.com/group37/M02/EF/C5/wKgJoFpQ5CzB4K9KADpjW73LCf4273.m4a\r\n第39章:万卷书$http://audio.xmcdn.com/group36/M09/77/29/wKgJUlpUpqbACsAoADjGv2VxkmQ357.m4a\r\n第40章：千年积累的智慧$http://audio.xmcdn.com/group21/M02/FE/15/wKgJKFpV_NOgodsOADbW2__74Y8655.m4a\r\n第41章 最初的愿望$http://audio.xmcdn.com/group38/M07/ED/A4/wKgJolprOZ-hVmPrADiUobloCTI969.m4a\r\n第42章 有兵的将领才是将领$http://audio.xmcdn.com/group40/M0B/57/B2/wKgJT1rdOZ7xGSYRAECUgoSq9xM594.m4a', 'xml_8023', '2782', '', 'S', '', '1.0', 8, 0, 0, 0, 'shenhuabansanguo', ''),
(135, 24, '母亲的爱', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group41/M02/91/09/wKgJ8VrdO8SQY6EvAAEeQUAf-dM659.jpg', '', 1530072223, 2, 0, 0, 0, 0, 1, 1, 6, 4, 'ting', '', '皮囊-母亲的房子（6）$http://audio.xmcdn.com/group41/M02/91/13/wKgJ8lrdO9TT5daiAChDTWpyN8Q035.m4a', 'xml_8023', '2780', '', 'M', '', '1.0', 7, 0, 0, 0, 'muqindeai', ''),
(136, 24, '王若谷', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group42/M08/18/B0/wKgJ81rKDMujSwKQAAQwHsa9yTk873.jpg', '', 1530072223, 2, 0, 0, 0, 0, 1, 1, 10, 7, 'ting', '', '美文$http://audio.xmcdn.com/group40/M00/51/B4/wKgJT1rcozDDC2pCABn5kK2-31c381.m4a\r\n兰亭集序$http://audio.xmcdn.com/group40/M0A/E4/81/wKgJT1rXL9uCjcHXABZDSGagdSk711.m4a\r\n记承天寺夜游$http://audio.xmcdn.com/group41/M05/07/7C/wKgJ8lrV7vzC4EC6AAapI0qlee8624.m4a\r\n爱莲说$http://audio.xmcdn.com/group40/M0A/B3/ED/wKgJT1rUnvzhfa5HAAeJ4SpTmLY459.m4a\r\n那一天，那一月，那一年，那一世$http://audio.xmcdn.com/group42/M0B/B7/F7/wKgJ9FrR-gaAxrKJAAUPcbzjwXM760.m4a\r\n人物描写一组$http://audio.xmcdn.com/group40/M06/43/48/wKgJT1rPQcnz7uUsAEPeuruRth4198.m4a\r\n月光曲$http://audio.xmcdn.com/group40/M08/2D/5C/wKgJVFrOAFbjNNnFACSztwtJs-I006.m4a\r\n桥$http://audio.xmcdn.com/group42/M0B/1A/41/wKgJ81rKFNOSAoL6ABg7XKeRanw283.m4a\r\n不来梅的音乐家$http://audio.xmcdn.com/group42/M06/1D/8F/wKgJ9FrKDNyBZI_aABPZjkpQ_vA941.m4a', 'xml_8023', '2781', '', 'W', '', '1.0', 10, 0, 0, 0, 'wangruogu', ''),
(137, 24, '聊聊 道教', '', '未知', '', '', '', '', 'http://s1.xmcdn.com/css/img/common/album_180.jpg', '', 1530072223, 6, 0, 0, 0, 0, 1, 1, 5, 1, 'ting', '', '全_01老子西出函谷关$http://audio.xmcdn.com/group41/M02/24/3D/wKgJ8VqttInjP_vTAFprRNW6q6Y419.m4a\r\n老子，何许人也$http://audio.xmcdn.com/group40/M0A/EB/79/wKgJT1qttQTA7yLmAHkPqG8IWlk761.m4a\r\n从老子到太上老君$http://audio.xmcdn.com/group41/M00/24/43/wKgJ8VqttTHQH_z5AIhJFvOzNeg398.m4a\r\n尹喜的传说$http://audio.xmcdn.com/group41/M01/26/F6/wKgJ8lqttWbTUtWzADG6Mhvj_d8892.m4a\r\n孔子问礼$http://audio.xmcdn.com/group40/M08/EE/BC/wKgJT1qt2kiCfBEPADtaO8FpkCA408.m4a\r\n三清四御$http://audio.xmcdn.com/group40/M01/EF/EE/wKgJVFqt3Hfw45IiAFokyxTIcmc174.m4a\r\n后土娘娘$http://audio.xmcdn.com/group42/M08/28/EA/wKgJ81qt3PuDjSTRADay_m-0ZrQ169.m4a\r\n玉皇大帝$http://audio.xmcdn.com/group40/M0A/EF/F4/wKgJVFqt3QrT0aUAACgi7i_dmBs523.m4a\r\n东王公与西王母$http://audio.xmcdn.com/group40/M0A/EF/F7/wKgJVFqt3RfwnijJACRcvsuC6cQ614.m4a\r\n三元大帝$http://audio.xmcdn.com/group40/M0A/EF/FB/wKgJVFqt3SOyKVUMABsU0BvJ8Zk793.m4a\r\n盘古开天辟地$http://audio.xmcdn.com/group41/M05/27/D9/wKgJ8Vqt3YCxMs-KADLi0abuhWM269.m4a\r\n黄帝成仙$http://audio.xmcdn.com/group40/M0B/EF/07/wKgJT1qt3dOBH6JxADe0Td96sf0003.m4a\r\n庄子其人$http://audio.xmcdn.com/group42/M01/28/FF/wKgJ81qt3ffw9LdwAH-Wue6DP0g311.m4a\r\n邹衍与阴阳五行说$http://audio.xmcdn.com/group42/M01/28/B2/wKgJ9Fqt3gSDGmUxAGG0LUcLiew690.m4a\r\n秦始皇的长生不老之梦$http://audio.xmcdn.com/group42/M05/29/0C/wKgJ81qt3iTBHiONAIkNox7kft4446.m4a\r\n徐福究竟去了哪里？日本？$http://audio.xmcdn.com/group40/M00/EF/0F/wKgJT1qt3i7yJkaUADnljEJMMMM034.m4a\r\n汉武帝求仙梦$http://audio.xmcdn.com/group40/M00/EF/15/wKgJT1qt3kThW3z6AGL6h83t9Y8534.m4a\r\n一人得道鸡犬升天$http://audio.xmcdn.com/group40/M00/F0/13/wKgJVFqt3kiD6s_4ACe5QDnDHQ0777.m4a\r\n《太平经》的故事，你知道吗？$http://audio.xmcdn.com/group40/M00/F0/13/wKgJVFqt3kuQ-tp7AByhVfPQhSo857.m4a\r\n丹祖金丹验人心，求仙问道心怎轻改$http://audio.xmcdn.com/group40/M00/EF/1A/wKgJT1qt3lSi_7bOAC0ANmSbQRg764.m4a\r\n茅山老祖登仙记$http://audio.xmcdn.com/group40/M00/EF/1C/wKgJT1qt3l2zRPxYADKxG1c0XTY029.m4a\r\n张道陵成仙记（一）辞官修道$http://audio.xmcdn.com/group41/M04/27/F0/wKgJ8Vqt3mWzuwwlADUuMW7EzHc032.m4a\r\n张道陵成仙记（二）龙虎山炼金丹$http://audio.xmcdn.com/group41/M04/27/F2/wKgJ8Vqt3nGTTbzSADH33r20HvI712.m4a\r\n张道陵成仙记（三）神威服众魔，人间幽冥两相隔$http://audio.xmcdn.com/group42/M00/29/0F/wKgJ81qt3n2zS3fFADPoM_MESIA464.m4a\r\n张道陵成仙记（四）万众归心，道教立教$http://audio.xmcdn.com/group42/M00/28/C0/wKgJ9Fqt3oSCHovpACtEu8Csb8c071.m4a\r\n黄巾大起义，张角太平道$http://audio.xmcdn.com/group42/M00/28/C5/wKgJ9Fqt3peip_hKAEv6Ca5xFg8856.m4a\r\n张鲁降曹操，五斗米道北迁$http://audio.xmcdn.com/group42/M00/29/17/wKgJ81qt3p7Acb7oAD7oqZMu_RY370.m4a\r\n左慈戏曹操的传说$http://audio.xmcdn.com/group41/M07/2A/A7/wKgJ8lqt3qnDA2VdAEInyS6SJAY947.m4a\r\n葛玄与孙权的传说$http://audio.xmcdn.com/group41/M07/27/F8/wKgJ8Vqt3qzRZd4UADtjCbtS9eI863.m4a\r\n司马昭举刀，嵇康得道$http://audio.xmcdn.com/group41/M07/2A/AA/wKgJ8lqt3rCAxvaQADnlPeVW2SA679.m4a\r\n全_31葛洪成仙记，著《抱朴子》等书$http://audio.xmcdn.com/group40/M08/EF/2B/wKgJT1qt32myCwptAFhyIXrK8_0287.m4a\r\n上清派第一代宗师：魏华存$http://audio.xmcdn.com/group40/M08/EF/30/wKgJT1qt33yQW4nwAFjr9SIOpwE171.m4a\r\n道教走入庙堂之路，寇谦之的道教改革$http://audio.xmcdn.com/group41/M06/28/0C/wKgJ8Vqt35ix4tW9AKR6MV-lf-U989.m4a\r\n全_34灵宝派的宗师陆修静$http://audio.xmcdn.com/group41/M06/28/0E/wKgJ8Vqt353gXFRMAFIYha4G54U091.m4a\r\n全_35“山中宰相”陶弘景$http://audio.xmcdn.com/group42/M0A/28/DA/wKgJ9Fqt37XDwu1JAIRcbe3VfCo874.m4a\r\n隋文帝隋炀帝的夺权统治与道教的故事$http://audio.xmcdn.com/group42/M0A/29/2D/wKgJ81qt377C-ooDAIb0JzuHqvU422.m4a\r\n全_37李渊建唐，道教居功$http://audio.xmcdn.com/group42/M0A/28/DF/wKgJ9Fqt38rAwv2-AHpnNwmycJg244.m4a\r\n唐太宗与道佛二教$http://audio.xmcdn.com/group42/M0A/28/DF/wKgJ9Fqt38mifHYHADwgak6FVy0127.m4a\r\n全_39唐高宗崇道、武则天崇佛，为哪般$http://audio.xmcdn.com/group41/M0B/28/14/wKgJ8Vqt39iBMDLYAGcD6H4HCzA613.m4a\r\n全_40唐玄宗智启姚崇、宋璟$http://audio.xmcdn.com/group41/M0B/2A/C3/wKgJ8lqt39GRxSVuACpGp6SHm1Q760.m4a\r\n道士皇帝唐玄宗$http://audio.xmcdn.com/group41/M0B/28/15/wKgJ8Vqt39ziRecLADpEpmC-fgc578.m4a\r\n唐玄宗崇道怠政，安史之乱，郁郁而终$http://audio.xmcdn.com/group40/M04/EF/34/wKgJT1qt3-Phyu_JADJ3lImueBQ186.m4a\r\n吴道子作画戏玄宗$http://audio.xmcdn.com/group40/M04/F0/33/wKgJVFqt3-SCYgoTACZl__pV0Ws823.m4a\r\n会昌法难，唐武宗灭佛$http://audio.xmcdn.com/group40/M04/F0/3A/wKgJVFqt3_zDny15AFP3PR2EMy8048.m4a\r\n隋唐修炼方术大发展$http://audio.xmcdn.com/group40/M04/EF/3A/wKgJT1qt3_bQHMRTAC8lWs-1E-o307.m4a\r\n苏玄朗与内丹修炼$http://audio.xmcdn.com/group40/M04/F0/39/wKgJVFqt3_iAybF4AC2HQtcvv6A078.m4a\r\n妙应真人孙思邈$http://audio.xmcdn.com/group40/M04/F0/3C/wKgJVFqt4AKzcB4gADs-SbSIDNI880.m4a\r\n杜光庭，道教理论的集大成者$http://audio.xmcdn.com/group42/M02/28/E1/wKgJ9Fqt4AjBYaDWADlSWpwWtqQ555.m4a\r\n八仙过海，各显神通$http://audio.xmcdn.com/group42/M02/28/E4/wKgJ9Fqt4BKTfj9QAEUtnHIoHk8996.m4a\r\n八仙之一铁拐李的传说$http://audio.xmcdn.com/group42/M02/28/E4/wKgJ9Fqt4BOyNFoPAC4u3UU_wic686.m4a\r\n八仙之二钟离权$http://audio.xmcdn.com/group41/M06/2C/C6/wKgJ8lqt94KSjWoOAC1PdIsBKHg587.m4a\r\n八仙之三张果老$http://audio.xmcdn.com/group41/M06/2C/C8/wKgJ8lqt94zx06SNADP_qK5bYNo698.m4a\r\n八仙之四吕洞宾$http://audio.xmcdn.com/group42/M06/2B/35/wKgJ81qt95OhdLHAADfthqx5vIg974.m4a\r\n八仙之五何仙姑$http://audio.xmcdn.com/group42/M06/2B/35/wKgJ81qt95SzwsRfACXqpHyxO3c495.m4a\r\n八仙之六韩湘子$http://audio.xmcdn.com/group42/M0A/2A/E9/wKgJ9Fqt95rQkelEACSu76_7h4A579.m4a\r\n八仙之七蓝采和$http://audio.xmcdn.com/group42/M06/2B/37/wKgJ81qt95-Q3zaFACj5UHCbdaA520.m4a\r\n八仙之八曹国舅$http://audio.xmcdn.com/group42/M0A/2A/EC/wKgJ9Fqt96LTmZaaACSBaqrpEd4179.m4a\r\n混沌道士与宋太祖赵匡胤$http://audio.xmcdn.com/group42/M0A/2A/EF/wKgJ9Fqt97KRgXcHAEprJNeebcc770.m4a\r\n睡仙陈抟的传说，五叟传法$http://audio.xmcdn.com/group40/M08/F1/33/wKgJT1qt97Xz7zWsADlkQ_wM7Oc918.m4a\r\n睡仙陈抟的传说，拒官归野$http://audio.xmcdn.com/group40/M08/F1/34/wKgJT1qt97mi-M4XACi9fYp40aM899.m4a\r\n睡仙陈抟的传说，与赵氏兄弟（宋太祖、太宗）相交的故事$http://audio.xmcdn.com/group40/M08/F2/31/wKgJVFqt98HS-t_QAD0ByOCEVTc593.m4a\r\n刘海戏金蟾$http://audio.xmcdn.com/group40/M08/F2/33/wKgJVFqt98mj5HOmADtddNJHWbs910.m4a\r\n宋真宗的崇道闹剧$http://audio.xmcdn.com/group40/M08/F2/39/wKgJVFqt9-TSDo6BAGX9DqOgniE312.m4a\r\n宋徽宗天神降临的把戏$http://audio.xmcdn.com/group40/M08/F1/3D/wKgJT1qt997hCLEqAEdLxBPYpOE893.m4a\r\n至死不悟的宋徽宗，靖康之耻$http://audio.xmcdn.com/group40/M08/F2/3B/wKgJVFqt9-qzXQ2_AFZtMtss9VA759.m4a\r\n全真教鼻祖王重阳的传说，遇仙得道$http://audio.xmcdn.com/group42/M0B/2B/41/wKgJ81qt9_7CHiKXAGBMX5p8bPQ322.m4a\r\n全真教鼻祖王重阳的传说，收徒“七子”$http://audio.xmcdn.com/group41/M00/2A/21/wKgJ8Vqt-AvjkS2KAD4urTKGmE4030.m4a\r\n全真七子的传说，丹阳子马钰$http://audio.xmcdn.com/group41/M00/2A/28/wKgJ8Vqt-COgFu0-AF1ssLGdEGk680.m4a\r\n全真七子的传说，长真子谭处端$http://audio.xmcdn.com/group41/M00/2A/27/wKgJ8Vqt-CDhrgyGAEVKX5izpbs552.m4a\r\n全真七子的传说，长生子刘处玄$http://audio.xmcdn.com/group41/M09/2C/D3/wKgJ8lqt-CfB_7LKADTwea2vUXI178.m4a\r\n全真七子的传说，玉阳子王处一$http://audio.xmcdn.com/group41/M09/2C/D3/wKgJ8lqt-CfT3jNxADAsNJ3D3ww944.m4a\r\n全真七子的传说，恬然子郝大通$http://audio.xmcdn.com/group41/M09/2C/D5/wKgJ8lqt-C_xpw0TADE-DIo1eLc550.m4a\r\n全真七子的传说，清净散人孙不二$http://audio.xmcdn.com/group41/M00/2A/2D/wKgJ8Vqt-DawybndADisbCg4X14393.m4a\r\n全真七子的传说，长春子丘处机（一）$http://audio.xmcdn.com/group40/M04/F2/3C/wKgJVFqt-EXxcDgTAFfYV0ZmnzM975.m4a\r\n全真七子的传说，长春子丘处机（二）$http://audio.xmcdn.com/group40/M04/F2/44/wKgJVFqt-GKDg8J_AIwYHVg1qY8392.m4a\r\n真大道教的兴衰$http://audio.xmcdn.com/group42/M01/2B/46/wKgJ81qt-G3TCg9OAHW027G6iXI674.m4a\r\n三山归一”是怎么回事呢$http://audio.xmcdn.com/group42/M01/2A/FB/wKgJ9Fqt-HTA9YW7AEd_O24_j68269.m4a\r\n明太祖朱元璋对道教的“两手”政策$http://audio.xmcdn.com/group42/M01/2A/FD/wKgJ9Fqt-H6TvKbjAFqQqae-zhk164.m4a\r\n邋遢神仙张三丰的传说（一）$http://audio.xmcdn.com/group42/M09/2B/52/wKgJ81qt-JmBRX5zAG3JXcKkqDs110.m4a\r\n邋遢神仙张三丰的传说（二）$http://audio.xmcdn.com/group42/M01/2B/01/wKgJ9Fqt-IriGGaSADdJRrxrQmE031.m4a\r\n邋遢神仙张三丰的传说（三）$http://audio.xmcdn.com/group41/M03/2A/30/wKgJ8Vqt-KbhzD5AADozCFu2pkg975.m4a\r\n嘉靖皇帝的崇道故事（一）$http://audio.xmcdn.com/group40/M0B/F2/47/wKgJVFqt-MHx4NikAG6L9UN5_ag755.m4a\r\n嘉靖皇帝的崇道故事（二）$http://audio.xmcdn.com/group40/M0B/F2/46/wKgJVFqt-L2xpf_SADp_oFqz1t4517.m4a\r\n嘉靖皇帝的崇道故事（三）$http://audio.xmcdn.com/group40/M0B/F2/48/wKgJVFqt-MXzOALRADdoHBdT7us925.m4a\r\n清朝的道教$http://audio.xmcdn.com/group40/M0B/F1/51/wKgJT1qt-NSBTI-bAFZXKvnzuVY128.m4a\r\n入仕》下部_001$http://audio.xmcdn.com/group40/M07/0F/42/wKgJVFqviF2BCUO8ABzopyJejkk940.m4a\r\n00000$http://audio.xmcdn.com/group40/M0A/52/25/wKgJT1rcpuqC1Q-aAAITXK3x_6E327.m4a', 'xml_8023', '2779', '', 'L', '', '1.0', 8, 0, 0, 0, 'liaoliaodaojiao', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(138, 24, '新明史', '', '未知', '', '', '', '本书由语音合成，解放您的双眼，对声音没要求的亲们欢迎收听，因为是语音合成，所以更新会比较快，每天有几十上百张，一本书完本欢迎大家推荐新书。-----------------------------------------------------------------------------------------------------------------------一个失落的大学毕业生，在这个不属于他的世界里创下了不世功勋，成就一代霸业，他，就是明武帝！    《新明史：本纪，武帝朱祁钰》    北灭蒙元，饮马极北，尽纳草原儿女……    开印度洋为帝国水师之内湖，为红颜之情倾……    灭战国各诸侯，扬国威于扶桑……    西寇红夷，玩教皇于股掌，情迷万国公主……    ……    力挽狂澜，励精图治', 'http://imagev2.xmcdn.com/group41/M05/F0/0E/wKgJ8lrHhlTSi2ezAAPYg-GH1fs390.jpg', '', 1530072223, 1, 0, 0, 0, 0, 1, 1, 8, 1, 'ting', '', '序 崩$http://audio.xmcdn.com/group40/M09/B5/33/wKgJT1rHh-vg2ctKAFZxmQXA0fE626.m4a\r\n第一节 错乱的时空$http://audio.xmcdn.com/group42/M0A/F1/0F/wKgJ9FrHh9GDHP7HAEw167AyUBM027.m4a\r\n第二节 责任$http://audio.xmcdn.com/group41/M06/ED/BC/wKgJ8VrHhz2SB81yAE1nkQE3dBQ364.m4a\r\n第三节 誓死抵抗$http://audio.xmcdn.com/group41/M03/F0/34/wKgJ8lrHh4PDjkWgAExzloh4cIA511.m4a\r\n第四节 坏事的皇后$http://audio.xmcdn.com/group40/M07/B5/CD/wKgJVFrHh6Sxvv6FAEukiuKstIU894.m4a\r\n第五节 对策$http://audio.xmcdn.com/group41/M04/F0/3E/wKgJ8lrHh7mDNMd7AEqQeRnWqJo780.m4a\r\n第六节 匠人胡彬$http://audio.xmcdn.com/group42/M03/EC/1E/wKgJ81rHh1rDPg8wAEhZpiH4COk118.m4a\r\n第七节 廷乱$http://audio.xmcdn.com/group42/M0B/F1/03/wKgJ9FrHh2vDNdCQAEwD-2j44ac123.m4a\r\n第八节 缓兵之计$http://audio.xmcdn.com/group40/M08/B5/22/wKgJT1rHhzPhB_6rAElHjCGJvFc453.m4a\r\n第九节 枪$http://audio.xmcdn.com/group41/M06/F0/31/wKgJ8lrHh0uhF2IoAEl676QxicI186.m4a\r\n第十节 大将石亨$http://audio.xmcdn.com/group41/M04/ED/CA/wKgJ8VrHh5HDr74kAEr3Q_Oz0-w032.m4a\r\n第十一节 敌军寇边$http://audio.xmcdn.com/group41/M02/FF/D5/wKgJ8lrIhu6QXpAkAErxZbv5TR4283.m4a\r\n第十二节 登基称帝$http://audio.xmcdn.com/group42/M05/FB/EB/wKgJ81rIh1CAHM_dAEswiNcJqS4751.m4a\r\n第十三节 逼战$http://audio.xmcdn.com/group40/M04/C4/AB/wKgJT1rIhwihj_S3AEyW0y0Hik0877.m4a\r\n第十四节 兵临城下$http://audio.xmcdn.com/group41/M02/FF/DA/wKgJ8lrIhwGxHjU9AErnHPP9-vM743.m4a\r\n第十五节 愤怒的也先$http://audio.xmcdn.com/group41/M02/FF/D9/wKgJ8lrIhvrwdqeQAE0-PDgehJ4868.m4a\r\n第十六节 神机复仇$http://audio.xmcdn.com/group40/M04/C4/B0/wKgJT1rIhx_CNl3QAEx67LGK4t0387.m4a\r\n第十七节 莽将$http://audio.xmcdn.com/group40/M04/C5/56/wKgJVFrIhxGQUPTcAEyuU4R7F4o477.m4a\r\n第十八节 血战西直门$http://audio.xmcdn.com/group41/M06/FD/7A/wKgJ8VrIh3CwU1N7AEqawSnBFtQ330.m4a\r\n第十九节 横扫千军$http://audio.xmcdn.com/group42/M05/FB/E3/wKgJ81rIhzXh-QJTAE1UQQTB4Zo427.m4a\r\n第二十节 人质危机$http://audio.xmcdn.com/group42/M0A/FC/03/wKgJ81rIiGGSbutQAEldkRRJMzM254.m4a\r\n第二十一节 宦官坏事$http://audio.xmcdn.com/group42/M01/00/C9/wKgJ9FrIh6ewHIy5AEt7bH9Klsk582.m4a\r\n第二十二节 土城歼敌$http://audio.xmcdn.com/group40/M00/C5/77/wKgJVFrIiHjDmsCkAE2DPTzXtqQ680.m4a\r\n第二十三节 生力军$http://audio.xmcdn.com/group41/M04/FF/F0/wKgJ8lrIh_OTlBXeAErlpaRxseg628.m4a\r\n第二十四节 神火天降$http://audio.xmcdn.com/group41/M04/FD/80/wKgJ8VrIh9fwU1cXAE4mdneEizU556.m4a\r\n第二十五节 掩杀$http://audio.xmcdn.com/group42/M01/00/CF/wKgJ9FrIh7ziKju1AEtoVrEFaA8832.m4a\r\n第二十六节 大获全胜$http://audio.xmcdn.com/group41/M0A/FD/8C/wKgJ8VrIiCjBAQmQAEszrTQkTP4761.m4a\r\n第二十七节 论功行赏$http://audio.xmcdn.com/group40/M06/C4/C4/wKgJT1rIiA-gHAlhAE6HKKPD5UQ287.m4a\r\n第二十八节 兴学$http://audio.xmcdn.com/group41/M08/FF/FA/wKgJ8lrIiJPjx3mkAE4mQAAG1y0842.m4a\r\n第二十九节 立威$http://audio.xmcdn.com/group40/M08/C4/C8/wKgJT1rIiEjSAW7OAE4DAHyrmHI056.m4a\r\n第三十节 大学$http://audio.xmcdn.com/group40/M02/C5/5E/wKgJVFrIh4XCnZmzAEsWGZlMH7k850.m4a\r\n第三十一节 意料之外的难题$http://audio.xmcdn.com/group40/M07/C6/DB/wKgJVFrIlxexjJ29AE993KftGmQ526.m4a\r\n第三十二节 奇遇$http://audio.xmcdn.com/group42/M04/FD/57/wKgJ81rIls7zaebtAEnu8VDUFZo434.m4a\r\n第三十三节 天下大事$http://audio.xmcdn.com/group41/M09/01/5B/wKgJ8lrIlvHQ0gLZAEqJIyUBdIg781.m4a\r\n第三十四节 皇帝开店$http://audio.xmcdn.com/group40/M07/C6/27/wKgJT1rIlvrATIOZAEtAr7dvVxo103.m4a\r\n第三十五节 重商$http://audio.xmcdn.com/group40/M07/C6/D4/wKgJVFrIlwKiHvkrAEpEHt0RBAw714.m4a\r\n第三十六节 收买$http://audio.xmcdn.com/group40/M0B/C6/26/wKgJT1rIlt6iz-PwAEsOw2O59pI574.m4a\r\n第三十七节 拍卖大会$http://audio.xmcdn.com/group41/M09/FE/ED/wKgJ8VrIlumgUIFkAFDIPxO3UMo982.m4a\r\n第三十八节 皇帝的恩赐$http://audio.xmcdn.com/group42/M04/FD/55/wKgJ81rIlsTia3fQAEolSHaFQcU723.m4a\r\n第三十九节 忠臣$http://audio.xmcdn.com/group40/M0B/C6/CF/wKgJVFrIltXhFRw1AEnOpKaKcBY148.m4a\r\n第四十节 天下第一店$http://audio.xmcdn.com/group41/M03/01/6E/wKgJ8lrIl23jO-IuAFUxelb3SYA993.m4a\r\n第四十一节 妥协$http://audio.xmcdn.com/group42/M0B/FD/73/wKgJ81rImCmCjq49AEtIPtfs0Pc089.m4a\r\n第四十二节 御试$http://audio.xmcdn.com/group41/M03/FE/FA/wKgJ8VrIl0yAAbD-AE4XkRL1ijQ976.m4a\r\n第四十三节 帝国学子$http://audio.xmcdn.com/group41/M00/FF/08/wKgJ8VrIl9-h8E2CAE4b90xcFAw811.m4a\r\n第四十四节 大汗的礼物$http://audio.xmcdn.com/group40/M0B/C6/F0/wKgJVFrIl_aRgedqAEyQ9RKefIo339.m4a\r\n第四十五节 贩卖战争$http://audio.xmcdn.com/group42/M07/02/4E/wKgJ9FrImA_SWW3vAEteDSNjrlo668.m4a\r\n第四十六节 众人拾柴$http://audio.xmcdn.com/group42/M01/FD/65/wKgJ81rIl6bwoJKSAEuV28m-jCg426.m4a\r\n第四十七节 震撼$http://audio.xmcdn.com/group40/M0A/C6/E8/wKgJVFrIl8HicwwRAEtQ1q2jepM831.m4a\r\n第四十八节 战争筹资$http://audio.xmcdn.com/group41/M0B/FE/F8/wKgJ8VrIlzLjlwELAEudMRtYXx4346.m4a\r\n第四十九节 开学$http://audio.xmcdn.com/group40/M03/C6/E6/wKgJVFrIl4zimhPzAFTCGB2tnn0421.m4a\r\n第五十节 飞来横祸$http://audio.xmcdn.com/group42/M0B/FD/7A/wKgJ81rImGvzcXcdAEyfpKLujxg558.m4a\r\n第五十一节 雷霆手段$http://audio.xmcdn.com/group40/M00/C6/4C/wKgJT1rImHnR0gxjAEznzhSTRKI133.m4a\r\n第五十二节 御驾亲征$http://audio.xmcdn.com/group41/M08/FF/10/wKgJ8VrImESxky3xAE5MbKasAcw420.m4a\r\n第一节 军纪$http://audio.xmcdn.com/group42/M06/15/11/wKgJ81rJ9HmzOx9SAEqpcLoHvP8094.m4a\r\n第二节 作战计划$http://audio.xmcdn.com/group42/M04/19/DA/wKgJ9FrJ9DSi0mPTAExHid_BgWo814.m4a\r\n第三节 惑敌$http://audio.xmcdn.com/group41/M02/19/47/wKgJ8lrJ9Fej-4hSAE2TaILVIH4144.m4a\r\n第四节 示弱$http://audio.xmcdn.com/group41/M02/19/4C/wKgJ8lrJ9GbAGu3_AEiCxaUUSrw024.m4a\r\n第五节 怯敌$http://audio.xmcdn.com/group42/M06/19/E3/wKgJ9FrJ9HTiTAKOAEo-O5ro4So797.m4a\r\n第六节 叫阵$http://audio.xmcdn.com/group41/M02/19/41/wKgJ8lrJ9ESxbQwOAEsBi4yvjYA016.m4a\r\n第七节 临阵立威$http://audio.xmcdn.com/group41/M02/16/BB/wKgJ8VrJ9E2Ava6_AEvGT6x71eA004.m4a\r\n第八节 战争主宰$http://audio.xmcdn.com/group41/M00/19/3F/wKgJ8lrJ9CrCyEjpAEoJl2NyO7U683.m4a\r\n第九节 整军再战$http://audio.xmcdn.com/group41/M02/16/B9/wKgJ8VrJ9EjDQcSIAEu--V2BVeY198.m4a\r\n第十节 归降$http://audio.xmcdn.com/group41/M02/16/C0/wKgJ8VrJ9F-QOmZzAErv7bk4Bo4490.m4a\r\n第十一节 迷雾$http://audio.xmcdn.com/group42/M06/36/FE/wKgJ9FrLZG7idYKEAEi0tAcFUpc020.m4a\r\n第十二节 火速救援$http://audio.xmcdn.com/group42/M0A/36/DA/wKgJ9FrLY7GBHwt6AEtbHuF-svY613.m4a\r\n第十三节 尚书的烦恼$http://audio.xmcdn.com/group42/M04/32/1B/wKgJ81rLZBWAkuHEAE-m-s0doLo482.m4a\r\n第十四节 滔天阴谋$http://audio.xmcdn.com/group40/M01/FB/EA/wKgJVFrLZDLxrWkmAEgtmKB-0Vg272.m4a\r\n第十五节 英宗复辟$http://audio.xmcdn.com/group42/M06/32/22/wKgJ81rLZFCiMwnOAElXsyLXtvU555.m4a\r\n第十六节 护国大臣$http://audio.xmcdn.com/group41/M05/33/CF/wKgJ8VrLY9LANu4bAEtymtMw6Ng732.m4a\r\n第十七节 惊讯$http://audio.xmcdn.com/group40/M09/FB/D1/wKgJVFrLY--xtp9-AE7X7q8akfk885.m4a\r\n第十八节 暴乱$http://audio.xmcdn.com/group42/M0A/32/04/wKgJ81rLY32AU4s4AE1eidJQUT4543.m4a\r\n第十九节 智取龙门$http://audio.xmcdn.com/group42/M0A/32/0C/wKgJ81rLY7GxyYVPAErOJC2ck5U715.m4a\r\n第二十节 说降$http://audio.xmcdn.com/group42/M0B/31/F5/wKgJ81rLY2OyF7UBAEtfhT5wxGA769.m4a\r\n第二十一节 兵逼宣府$http://audio.xmcdn.com/group42/M09/46/C6/wKgJ9FrMX66ROsK5AFLexNNlIPQ354.m4a\r\n第二十二节 杨洪的选择$http://audio.xmcdn.com/group42/M05/46/BC/wKgJ9FrMXvexDuI1AE6NCu2b0-Y366.m4a\r\n第二十三节 快刀斩乱麻$http://audio.xmcdn.com/group41/M04/46/51/wKgJ8lrMX1yRZBFKAE2R7WLEwqY225.m4a\r\n第二十四节 人心$http://audio.xmcdn.com/group42/M08/41/F5/wKgJ81rMX3XC9ZEGAE53AllM8NY381.m4a\r\n第二十五节 一败石彪$http://audio.xmcdn.com/group41/M0B/43/D2/wKgJ8VrMX5Kyot0MAE-Q8cVN99o003.m4a\r\n第二十六节 二败石彪$http://audio.xmcdn.com/group41/M00/43/C8/wKgJ8VrMXyfzH5vpAFCgnM6Vu9g147.m4a\r\n第二十七节 速夺居庸关$http://audio.xmcdn.com/group40/M06/0B/B5/wKgJVFrMX0KBBTuzAE6P-Rz2A6Q008.m4a\r\n第二十八节 永安解围$http://audio.xmcdn.com/group42/M05/46/B8/wKgJ9FrMXuLTuCSQAEuwgDySqtU314.m4a\r\n第二十九节 商人的礼物$http://audio.xmcdn.com/group40/M0A/0B/AF/wKgJVFrMXxKTCFI_AFBJ-cYdbI8660.m4a\r\n第三十节 围困顺义$http://audio.xmcdn.com/group40/M00/0A/E0/wKgJT1rMX8PB42IrAErbXDsX6Q4577.m4a\r\n第三十一节 巧取通州$http://audio.xmcdn.com/group41/M0B/68/A5/wKgJ8lrOCt_CAa8kAEzr_9Gb3jU184.m4a\r\n第三十二节 截击石亨$http://audio.xmcdn.com/group41/M06/68/95/wKgJ8lrOCqGSp6YAAE4Rr84Eqn8996.m4a\r\n第三十三节 扫荡$http://audio.xmcdn.com/group40/M03/2E/99/wKgJT1rOCsSxlw5DAEw7yXUoBQI521.m4a\r\n第三十四节 王骥勤王$http://audio.xmcdn.com/group40/M03/2E/9E/wKgJT1rOCs2BZ4DiAEqpcKfczIo417.m4a\r\n第三十五节 只身赴会$http://audio.xmcdn.com/group41/M0B/68/A0/wKgJ8lrOCtbA0zwZAFBEF9QB-WU156.m4a\r\n第三十六节 大败石亨$http://audio.xmcdn.com/group42/M05/65/82/wKgJ81rOCrKQcHl2AE4NSMf3YiE637.m4a\r\n第三十七节 要挟$http://audio.xmcdn.com/group42/M05/65/87/wKgJ81rOCrqAl50hAEsL0D3bImY875.m4a\r\n第三十八节 大军围城$http://audio.xmcdn.com/group42/M02/6A/50/wKgJ9FrOCpjAjkTPAE-3IXijAsM818.m4a\r\n第三十九节 血染京城$http://audio.xmcdn.com/group41/M06/68/99/wKgJ8lrOCqiT5jf7AEvWrIsLDsc765.m4a\r\n第四十节 定乱$http://audio.xmcdn.com/group40/M04/2E/A0/wKgJT1rOCuiQ23DmAEu8Bqq-29w885.m4a\r\n第一节 皇宫改制$http://audio.xmcdn.com/group41/M04/83/3F/wKgJ8lrPYbuwZDKHAEkzMf7kROI589.m4a\r\n第二节 妥当安置$http://audio.xmcdn.com/group42/M04/7F/E0/wKgJ81rPYPCCubQgAEod7pFrGWM322.m4a\r\n第三节 科学萌芽$http://audio.xmcdn.com/group40/M06/49/1A/wKgJT1rPYVzw8snXAFE5UrldqIE143.m4a\r\n第四节 柴汇的重任$http://audio.xmcdn.com/group41/M03/83/2D/wKgJ8lrPYYazmuv9AE498vkUCUs208.m4a\r\n第五节 御用镖局$http://audio.xmcdn.com/group42/M08/80/03/wKgJ81rPYaGAjkdlAEm9BsOLK90341.m4a\r\n第六节 新朝$http://audio.xmcdn.com/group40/M04/49/E9/wKgJVFrPYSGBqvgYAE5TxSnZBcg518.m4a\r\n第七节 皇权$http://audio.xmcdn.com/group41/M07/83/19/wKgJ8VrPYT3SBGSQAE6P-R8EeKI172.m4a\r\n第八节 太祖诞辰$http://audio.xmcdn.com/group42/M04/7F/D9/wKgJ81rPYOSxfvp_AE1CozstoXQ977.m4a\r\n第九节 削番$http://audio.xmcdn.com/group42/M07/84/D0/wKgJ9FrPYQeTjlWiAEububHfhY0275.m4a\r\n第十节 朝廷改制$http://audio.xmcdn.com/group42/M05/84/D7/wKgJ9FrPYXvgMIF5AFFK8UBBUsk133.m4a\r\n第十一节 新政风潮$http://audio.xmcdn.com/group40/M00/60/E6/wKgJT1rQprjC8-EVAE-s2AH0J50703.m4a\r\n第十二节 经济大臣$http://audio.xmcdn.com/group40/M06/60/C9/wKgJT1rQpgvhENfSAEqDd1uwaUw814.m4a\r\n第十三节 粮食问题$http://audio.xmcdn.com/group42/M00/97/9C/wKgJ81rQpnSAt7r1AFC9-7JAuWw949.m4a\r\n第十四节 郑梦秋的发明$http://audio.xmcdn.com/group42/M00/97/A3/wKgJ81rQpoDgNIwhAEixwQCGlYs920.m4a\r\n第十五节 国家收购$http://audio.xmcdn.com/group41/M00/9A/E4/wKgJ8lrQppnisrqEAEl1EbV3l2E078.m4a\r\n第十六节 柴美娇的不满$http://audio.xmcdn.com/group40/M08/60/D5/wKgJT1rQpkDxltHfAFcC-baT7zs072.m4a\r\n第十七节 保险公司$http://audio.xmcdn.com/group41/M05/9A/C9/wKgJ8VrQpljDmCPOAEheEWPuwSg579.m4a\r\n第十八节 争风吃醋$http://audio.xmcdn.com/group42/M04/9C/86/wKgJ9FrQpfuBY_saAEnIwkNcdjA560.m4a\r\n第十九节 皇帝的烦恼$http://audio.xmcdn.com/group42/M09/9C/90/wKgJ9FrQph-TJe50AE5oUleipOI710.m4a\r\n第二十节 对策$http://audio.xmcdn.com/group42/M04/97/84/wKgJ81rQpfCQrd5KAEpaIga0UP0289.m4a\r\n第二十一节 工业的动力$http://audio.xmcdn.com/group41/M09/D3/DC/wKgJ8lrTUu3w3Gd0AE0z85Jzqpc703.m4a\r\n第二十二节 洪水无情$http://audio.xmcdn.com/group41/M02/D3/94/wKgJ8VrTUq6gLn10AEqR8Ggp6sY978.m4a\r\n第二十三节 感动天下$http://audio.xmcdn.com/group42/M02/D0/61/wKgJ81rTUs_zkOndAEbkrHQkFtU882.m4a\r\n第二十四节 情致$http://audio.xmcdn.com/group41/M09/D3/A5/wKgJ8VrTUuKznU3lAEweal9wL60678.m4a\r\n第二十五节 赈灾$http://audio.xmcdn.com/group41/M09/D3/A9/wKgJ8VrTUuijg7qLAEsgYboPPwY043.m4a\r\n第二十六节 千秋功臣$http://audio.xmcdn.com/group41/M02/D3/9D/wKgJ8VrTUsCDZ1jaAEsjUATRyRk249.m4a\r\n第二十七节 大工业$http://audio.xmcdn.com/group42/M02/D0/5F/wKgJ81rTUsnxjn-lAEpBLiqicGQ894.m4a\r\n第二十八节 上皇音讯$http://audio.xmcdn.com/group41/M02/D3/8F/wKgJ8VrTUqWTA0FtAEtYZTyU5OI013.m4a\r\n第二十九节 大洋风情$http://audio.xmcdn.com/group41/M02/D3/98/wKgJ8VrTUreD3YNOAEm_9QL5_4s313.m4a\r\n第三十节 于谦的担忧$http://audio.xmcdn.com/group41/M09/D3/E2/wKgJ8lrTUvbyOagWAErfw_HuAvw934.m4a\r\n第三十一节 启蒙教材$http://audio.xmcdn.com/group40/M09/B0/0A/wKgJT1rUi6niv1gAAFH4OHlWg3s407.m4a\r\n第三十二节 整军励马$http://audio.xmcdn.com/group40/M08/B0/DC/wKgJVFrUiwyR7CtJAEwJ3aCvqJM839.m4a\r\n第三十三节 秘密警察头子$http://audio.xmcdn.com/group40/M01/B0/E7/wKgJVFrUi1SwnocCAEvAcYGfPao199.m4a\r\n第三十四节 现代医学$http://audio.xmcdn.com/group41/M01/E9/5A/wKgJ8VrUi27SFfexAEqmgVnbQGE236.m4a\r\n第三十五节 段灵的麻烦$http://audio.xmcdn.com/group40/M03/B0/01/wKgJT1rUi4qzKivNAE21LcIau20108.m4a\r\n第三十六节 商业联盟$http://audio.xmcdn.com/group41/M00/E9/46/wKgJ8VrUiyCi3oSEAEznmCrFBEE105.m4a\r\n第三十七节 新年礼物$http://audio.xmcdn.com/group42/M0B/EB/00/wKgJ9FrUizrAj3HzAE22peXweuo429.m4a\r\n第三十八节 远洋战舰$http://audio.xmcdn.com/group40/M05/AF/EC/wKgJT1rUiwPjQqZ3AEldkas3ycE013.m4a\r\n第三十九节 日本使臣$http://audio.xmcdn.com/group40/M05/AF/F3/wKgJT1rUixXB7_TnAEr0VLNYpH4076.m4a\r\n第四十节 天皇的野心$http://audio.xmcdn.com/group41/M06/E9/AF/wKgJ8lrUi97ynrdCAEu8Bn8WZiI666.m4a\r\n第四十一节 嫉妒$http://audio.xmcdn.com/group42/M09/EB/21/wKgJ9FrUi_rTE0oGAElsQASr0oo970.m4a\r\n第四十二节 北征$http://audio.xmcdn.com/group40/M09/B0/FF/wKgJVFrUi8PAmINaAEpHDW3k-ns529.m4a\r\n第一节 宣府振兵（一）$http://audio.xmcdn.com/group41/M0A/E9/74/wKgJ8VrUjFOhEL0bAGRsLU3UYUA226.m4a\r\n第一节 宣府振兵（二）$http://audio.xmcdn.com/group40/M02/B1/06/wKgJVFrUjDjS9Fj-AJVMtSnxqS4706.m4a\r\n第二节 大明铁骑（一）$http://audio.xmcdn.com/group42/M0B/EC/0C/wKgJ9FrUkS_CNoBkAHVvjKerzZM992.m4a\r\n第二节 大明铁骑（二）$http://audio.xmcdn.com/group42/M0A/EB/FD/wKgJ9FrUkRWyo6znAG7-f0dB6rI299.m4a\r\n第三节 大军北上（一）$http://audio.xmcdn.com/group40/M05/B2/14/wKgJVFrUkeWjxAQAAHJK25vOSnI592.m4a\r\n第三节 大军北上（二）$http://audio.xmcdn.com/group42/M09/E7/69/wKgJ81rUkdCgf1HMAGy2D2S-uvA999.m4a\r\n第四节 小将邓茂$http://audio.xmcdn.com/group40/M00/B2/60/wKgJVFrUk0ji2KHtAGls3JW9s1w015.m4a\r\n第五节 子龙再生$http://audio.xmcdn.com/group41/M01/EB/08/wKgJ8lrUk1eShdKEAGWAP6b6Kh0895.m4a\r\n第六节 囤军枭儿岭$http://audio.xmcdn.com/group42/M08/EC/20/wKgJ9FrUkZqTfxlcADpWeq7tdQI321.m4a\r\n第六节 囤军枭儿岭2$http://audio.xmcdn.com/group40/M09/B2/0A/wKgJVFrUkafRmVUzAEOxSA2nYEg292.m4a\r\n第七节 给也先的礼物$http://audio.xmcdn.com/group41/M05/EA/6C/wKgJ8VrUkbqCcvFQAGbpedpo4Kk267.m4a\r\n第八节 邀战$http://audio.xmcdn.com/group41/M0B/EA/49/wKgJ8VrUkP6DkGYNAGRI7dXxTdM940.m4a\r\n第九节 也先的选择$http://audio.xmcdn.com/group42/M08/E7/60/wKgJ81rUkZqQ1kcTAGGGnNjA6Ps083.m4a\r\n第十节 偏锋奇兵$http://audio.xmcdn.com/group41/M02/EA/95/wKgJ8VrUkqXiLF3oAGUE452W6mU298.m4a\r\n第十一节 请君入瓮$http://audio.xmcdn.com/group42/M06/E7/B3/wKgJ81rUkzvxcnXcAGU7OiKfzU0646.m4a\r\n第十二节 背水一战$http://audio.xmcdn.com/group42/M00/EC/53/wKgJ9FrUkoXDcpC5AGPygyTsnaw180.m4a\r\n第十三节 关门打狗$http://audio.xmcdn.com/group40/M05/B1/69/wKgJT1rUkw2yngXtAGNbC3C_PAw109.m4a\r\n第十四节 痛歼强敌$http://audio.xmcdn.com/group42/M08/EC/BD/wKgJ9FrUlNDiIFilAGcCcd0EZnU508.m4a\r\n第十五节 命不该绝$http://audio.xmcdn.com/group41/M06/EB/02/wKgJ8lrUky2QWAGAAGHdQGKov1Y126.m4a\r\n第十六节 决战大草原$http://audio.xmcdn.com/group42/M03/E7/98/wKgJ81rUktjzcXpfAGX0QeuNNLk020.m4a\r\n第十七节 临阵倒戈$http://audio.xmcdn.com/group41/M04/EA/F2/wKgJ8lrUku7QyDj8AGUB9KDUHGY100.m4a\r\n第十八节 惊迅$http://audio.xmcdn.com/group40/M04/B1/C4/wKgJT1rUlLGAfzCIAGE9MOMPyMA343.m4a\r\n第十九节 坚持$http://audio.xmcdn.com/group40/M02/B2/45/wKgJVFrUksGxfSs5AGM5RmcaOA4945.m4a\r\n第二十节 战略行动$http://audio.xmcdn.com/group40/M07/B1/F0/wKgJVFrUkU2jojYeAGidmg3A_D8423.m4a\r\n第二十一节 胜利会师$http://audio.xmcdn.com/group42/M08/EC/1B/wKgJ9FrUkZKgac2fAGXA2oJtH0Q681.m4a\r\n第二十二节 篝火晚会$http://audio.xmcdn.com/group42/M0B/E7/C4/wKgJ81rUk4zgQRKhAGgMOotiKRA784.m4a\r\n第二十三节 突袭温失泉$http://audio.xmcdn.com/group40/M09/B2/72/wKgJVFrUk6XiHYH7AGV45TyqyI0949.m4a\r\n第二十四节 极地大救援$http://audio.xmcdn.com/group40/M09/B2/81/wKgJVFrUk7-QK36qAGEbofCbmBY049.m4a\r\n第二十五节 皇帝的烦恼$http://audio.xmcdn.com/group40/M04/B1/B7/wKgJT1rUlJywgJCoAGBxSR9YqYU589.m4a\r\n第二十六节 双虎$http://audio.xmcdn.com/group40/M09/B1/80/wKgJT1rUk53xPUvJAGZ54Veq1X8682.m4a\r\n第二十七节 草原攻略$http://audio.xmcdn.com/group41/M01/EB/CF/wKgJ8VrUmLDybGh-AGPdvN4NX7M245.m4a\r\n第二十八节 商会的礼物$http://audio.xmcdn.com/group42/M09/E8/C6/wKgJ81rUmI6x3Vd2AGbcQWiAAzk040.m4a\r\n第二十九节 贸易的力量$http://audio.xmcdn.com/group42/M05/ED/8C/wKgJ9FrUmJexmmtSAGisSZwzH5I078.m4a\r\n第三十节 亲临前线$http://audio.xmcdn.com/group41/M06/EB/E2/wKgJ8VrUmPSQMQzbAGaUTaQuXyo483.m4a\r\n第三十一节 决战瓦剌城堡$http://audio.xmcdn.com/group41/M05/EC/58/wKgJ8lrUmbXDN-AqAGCuw0RcCSY586.m4a\r\n第三十二节 将计就计$http://audio.xmcdn.com/group42/M0B/E8/D5/wKgJ81rUmNCT0W7JAGS4iIeGmA8649.m4a\r\n第三十三节 坚城攻略$http://audio.xmcdn.com/group42/M07/E8/F1/wKgJ81rUmU7QL89lAGUz4ORAzLw946.m4a\r\n第三十四节 逼降$http://audio.xmcdn.com/group41/M03/EC/44/wKgJ8lrUmXKS3Mj1AGISHny9QdE792.m4a\r\n第三十五节 疯狂的也先$http://audio.xmcdn.com/group40/M08/B2/C8/wKgJT1rUmZayhsDhAGI20mVGjiY482.m4a\r\n第三十六节 凯旋1$http://audio.xmcdn.com/group41/M06/EC/38/wKgJ8lrUmQXTvHfVAD38M8Lqc5k646.m4a\r\n第三十六节 凯旋2$http://audio.xmcdn.com/group40/M04/B2/B0/wKgJT1rUmSnwjvooAFb4sVRIBok216.m4a\r\n第一节 怒海狂涛$http://audio.xmcdn.com/group40/M06/B3/98/wKgJT1rUnVnRWUCVAGVEC2oFOxg253.m4a\r\n第二节 国栋$http://audio.xmcdn.com/group42/M07/E9/79/wKgJ81rUm92Sm1CJAGITltv9xMc233.m4a\r\n第三节 兵分三路$http://audio.xmcdn.com/group42/M09/E9/89/wKgJ81rUnB2CpRmZAGeQ4gP5VI0755.m4a\r\n第四节 疯狗加藤清正$http://audio.xmcdn.com/group42/M07/E9/C9/wKgJ81rUnRGSx2nVAGdnw2dPmCw579.m4a\r\n第五节 血战安州$http://audio.xmcdn.com/group41/M00/EC/DA/wKgJ8VrUnTmji0a4AGO2FbhgcWk248.m4a\r\n第六节 力挫第三兵团$http://audio.xmcdn.com/group41/M07/EC/8E/wKgJ8VrUnAThMPHeAGQ-qPW_MQU416.m4a\r\n第七节 狡猾的小西行长$http://audio.xmcdn.com/group41/M07/EC/E1/wKgJ8lrUnBGSr4NyAGQFYz6yESM964.m4a\r\n第八节 围城血战$http://audio.xmcdn.com/group41/M07/EC/CF/wKgJ8lrUm_fh37POAGWaqvuniGU317.m4a\r\n第九节 决死之战$http://audio.xmcdn.com/group41/M07/EC/86/wKgJ8VrUm_bTIWEqAGUJTpyKHTQ591.m4a\r\n第十节 反击$http://audio.xmcdn.com/group41/M0A/EC/A2/wKgJ8VrUnEGACP0sAGej-HQRMYE174.m4a\r\n第十一节 神将$http://audio.xmcdn.com/group41/M06/ED/08/wKgJ8lrUnPywlKFEAGW96y6wtmo984.m4a\r\n第十二节 和谈$http://audio.xmcdn.com/group40/M0A/B3/54/wKgJT1rUnDWSrX3KAGWBt0RpMgM969.m4a\r\n第十三节 忠臣良将$http://audio.xmcdn.com/group40/M07/B3/74/wKgJT1rUnKDSRoyXAGpEhFxNC-8872.m4a\r\n第十四节 朝鲜战略$http://audio.xmcdn.com/group40/M07/B3/7A/wKgJT1rUnKmAsW2AAGY5Qsg84x0156.m4a\r\n第十五节 皇帝的婚礼$http://audio.xmcdn.com/group42/M06/E9/A7/wKgJ81rUnMjSd8T8AGqxLDoJAyM591.m4a\r\n第十六节 闹宴$http://audio.xmcdn.com/group42/M09/EE/56/wKgJ9FrUnFuyPu82AGOFoakTFiQ246.m4a\r\n第十七节 水陆并进$http://audio.xmcdn.com/group40/M0B/B3/56/wKgJT1rUnGaSWIdrAGG88kpM4EM689.m4a\r\n第十八节 战争的基础$http://audio.xmcdn.com/group40/M0A/B4/32/wKgJVFrUnCixrIlLAGfEe0Atge0834.m4a\r\n第十九节 大明水师$http://audio.xmcdn.com/group42/M09/EE/50/wKgJ9FrUnFKBhNLrAGe5_e4EOtk142.m4a\r\n第二十节 千里救援$http://audio.xmcdn.com/group42/M00/EE/41/wKgJ9FrUm-vgzTA5AGST1NeYliQ556.m4a\r\n第二十一节 玉浦海大海战$http://audio.xmcdn.com/group40/M08/B4/25/wKgJT1rUn-_AE1wfAGRXnDy3ybw179.m4a\r\n第二十二节 战列线$http://audio.xmcdn.com/group41/M06/ED/59/wKgJ8VrUn5XQEysxAGUX_c1lXYQ227.m4a\r\n第二十三节 收获$http://audio.xmcdn.com/group40/M01/B4/20/wKgJT1rUn7qQqXM9ADxp1ooayic685.m4a\r\n第二十三节 收获1$http://audio.xmcdn.com/group41/M0B/ED/A7/wKgJ8lrUn8OwbLqXAECuXTNHsAg604.m4a\r\n第二十四节 汶山大捷$http://audio.xmcdn.com/group42/M01/EA/5A/wKgJ81rUn9WReFo_AGT61dcuvks189.m4a\r\n第二十五节 汉城光复$http://audio.xmcdn.com/group42/M01/EA/5C/wKgJ81rUn9fiIAAeAEREIMboiT4850.m4a\r\n第二十五节 汉城光复1$http://audio.xmcdn.com/group40/M08/B5/0C/wKgJVFrUn-rRCM4AADtBOAo1Fwk094.m4a\r\n第二十六节 偏路奇兵$http://audio.xmcdn.com/group40/M01/B4/18/wKgJT1rUn63AmAyEAGXRAeet0KI584.m4a\r\n第二十七节 炮击对马岛$http://audio.xmcdn.com/group40/M01/B4/20/wKgJT1rUn7mAzdToAGXuXyUKCTo680.m4a\r\n第二十八节 釜山登陆战$http://audio.xmcdn.com/group42/M04/EF/15/wKgJ9FrUn4jha5DOAGQUEr9X5nw230.m4a\r\n第二十九节 全面反击$http://audio.xmcdn.com/group40/M01/B4/F9/wKgJVFrUn6GQ-1XIAGVVqegfYwU715.m4a\r\n第三十节 一溃千里$http://audio.xmcdn.com/group42/M08/EA/6C/wKgJ81rUoBbDNv75AGZcgzhbdcg939.m4a\r\n第三十一节 海上歼灭战$http://audio.xmcdn.com/group40/M0A/B4/45/wKgJT1rUoGbzmBOuAGW4CcqsG1Q122.m4a\r\n第三十二节 疯狗的下场$http://audio.xmcdn.com/group41/M04/ED/79/wKgJ8VrUoAnDpkWQAGj-huf6SfM252.m4a\r\n第三十三节 朝鲜王国$http://audio.xmcdn.com/group42/M08/EA/77/wKgJ81rUoDXBQCKoACTuEzc9PJI476.m4a\r\n第三十三节 朝鲜王国(1)$http://audio.xmcdn.com/group42/M08/EA/7C/wKgJ81rUoD2Ah-UzAFgYgl1VeOk458.m4a\r\n第三十四节 公主$http://audio.xmcdn.com/group40/M0A/B4/35/wKgJT1rUoE2wS1vfAGJtKVdK6Ig462.m4a\r\n第三十五节 军制改革$http://audio.xmcdn.com/group40/M0A/B5/26/wKgJVFrUoFiCQRAbAGWDLmcsJKM001.m4a\r\n第三十六节 帝国宪法$http://audio.xmcdn.com/group42/M08/EF/2F/wKgJ9FrUoBzyV0SXADGEBjYlXxA323.m4a\r\n第三十六节 帝国宪法(1)$http://audio.xmcdn.com/group42/M08/EA/6F/wKgJ81rUoBqh5N6sAEm40WOEfVg324.m4a\r\n第三十七节 点将$http://audio.xmcdn.com/group40/M09/B4/33/wKgJT1rUoDHhIBP7AGab3JDyoBI619.m4a\r\n第一节 天皇的野心$http://audio.xmcdn.com/group41/M07/FA/84/wKgJ8VrVb-fjs1fIAGOS2UFcVFU228.m4a\r\n第二节 攻日战略$http://audio.xmcdn.com/group42/M06/FC/27/wKgJ9FrVbvjQqsQPAGZYGLtG2iE215.m4a\r\n第三节 登陆日本$http://audio.xmcdn.com/group41/M0B/FA/71/wKgJ8VrVby3w7x2FAGRUrWc_ViE937.m4a\r\n第四节 夜袭江户$http://audio.xmcdn.com/group41/M07/FA/C2/wKgJ8lrVb7XiEWbvAGdL3am7gKw327.m4a\r\n第五节 挫敌$http://audio.xmcdn.com/group41/M07/FA/80/wKgJ8VrVb8LC1U3BAGOxrlkEFQ8303.m4a\r\n第六节 日寇夜袭$http://audio.xmcdn.com/group42/M06/FC/2D/wKgJ9FrVbxSjFVk2AGUfU97xo20407.m4a\r\n第七节 胜利者$http://audio.xmcdn.com/group40/M09/C2/1A/wKgJVFrVbyGgADIzAGTeuBI4sxY527.m4a\r\n第八节 海上战神$http://audio.xmcdn.com/group40/M06/C2/18/wKgJVFrVburh9n6nAFVjaTQmNL8293.m4a\r\n第八节 海上战神(1)$http://audio.xmcdn.com/group40/M06/C2/17/wKgJVFrVbuTAIAWNAHKVvkmTRc0728.m4a\r\n第十节 日本王$http://audio.xmcdn.com/group40/M09/C1/42/wKgJT1rVb1TRo0rPAGdKZdpZlo8120.m4a\r\n第十一节 对马岛登陆战$http://audio.xmcdn.com/group42/M04/F7/83/wKgJ81rVb6mAF2sFAGQZ8L5buus080.m4a\r\n第十二节 骗取壹歧岛$http://audio.xmcdn.com/group40/M09/C1/40/wKgJT1rVb0uAp_kzAGQ9MRV7FJw688.m4a\r\n第十三节 匪军$http://audio.xmcdn.com/group42/M04/FC/30/wKgJ9FrVb4nRWfbzAGSyqo_-Csw249.m4a\r\n第十四节 霹雳战神$http://audio.xmcdn.com/group40/M05/C2/23/wKgJVFrVb5DxnF1cAGal75kxCmY233.m4a\r\n第十五节 马关血战$http://audio.xmcdn.com/group40/M05/C2/27/wKgJVFrVb52hOTQZAGePao1Ai7w493.m4a\r\n第十六节 尾张大傻瓜$http://audio.xmcdn.com/group41/M0B/FA/BC/wKgJ8lrVb2zDtQP7AGRzg2tVfcE648.m4a\r\n第十七节 大魔王$http://audio.xmcdn.com/group41/M0B/FA/7A/wKgJ8VrVb3ejzog7AGVf7tmYkZE459.m4a\r\n第十八节 血肉之城$http://audio.xmcdn.com/group41/M0B/FA/B7/wKgJ8lrVbzngqpHQAGQuuBcsex4996.m4a\r\n第十九节 天降奇兵$http://audio.xmcdn.com/group40/M09/C1/45/wKgJT1rVb1-SFDFhAGOdIVoETWw319.m4a\r\n第二十节 霹雳之火$http://audio.xmcdn.com/group42/M02/F7/78/wKgJ81rVbwHgKIY-AC7b7lSbusA839.m4a\r\n第二十节 霹雳之火(1)$http://audio.xmcdn.com/group42/M02/F7/79/wKgJ81rVbwHxXmi6AFJBpEgugjU288.m4a\r\n第二十一节 陷阱$http://audio.xmcdn.com/group40/M01/C1/E6/wKgJT1rVeKDg67XsAGTHOF_hKtM465.m4a\r\n第二十二节 出海蛟龙$http://audio.xmcdn.com/group41/M0B/FB/6D/wKgJ8lrVeE3Bs6CQAGYpHGfKXlg468.m4a\r\n第二十三节 海盗王$http://audio.xmcdn.com/group42/M07/FC/DD/wKgJ9FrVeHySsZLYAGNpuqyA-ZM226.m4a\r\n第二十四节 尔虞我诈$http://audio.xmcdn.com/group42/M05/F8/2C/wKgJ81rVeIiAv6P6AGOuv2BiJoQ458.m4a\r\n第二十五节 围追堵截$http://audio.xmcdn.com/group42/M07/FC/E2/wKgJ9FrVeJPQrkLjAGWma92harU308.m4a\r\n第二十六节 北上$http://audio.xmcdn.com/group42/M05/FC/D9/wKgJ9FrVeGuiM8quAGRF_oUewTM904.m4a\r\n第二十七节 骑兵渡江$http://audio.xmcdn.com/group42/M05/F8/26/wKgJ81rVeHChJeySAGHQCPrvluI743.m4a\r\n第二十八节 吸血鬼$http://audio.xmcdn.com/group40/M03/C2/BB/wKgJVFrVeEHiwCtyAGVXINJXUlA157.m4a\r\n第二十九节 疯狂的近卫军$http://audio.xmcdn.com/group41/M0B/FB/70/wKgJ8lrVeF7T5H5KAGN54Q_PUmk339.m4a\r\n第三十节 日寇夜袭$http://audio.xmcdn.com/group41/M01/FB/29/wKgJ8VrVeMmDgbCoAGVLYI1EoXI718.m4a\r\n第三十一节 毒誓$http://audio.xmcdn.com/group42/M0B/FC/ED/wKgJ9FrVeVbSjI2TAGREhgseCrU451.m4a\r\n第三十二节 生死之战$http://audio.xmcdn.com/group40/M01/C2/C7/wKgJVFrVeLfz8fxeAGLZ0RTyu0Y001.m4a\r\n第三十三节 越后之龙$http://audio.xmcdn.com/group41/M02/FB/80/wKgJ8lrVeROzu9jHAGVkWBsvuBU197.m4a\r\n第三十四节 军神真面目$http://audio.xmcdn.com/group40/M02/C2/CE/wKgJVFrVeSrjptBiAGQCdJKj1Mc959.m4a\r\n第三十五节 阵前博弈$http://audio.xmcdn.com/group42/M0B/FC/E9/wKgJ9FrVeUazU5yqADumivg_1Sg377.m4a\r\n第三十五节 阵前博弈(1)$http://audio.xmcdn.com/group40/M02/C1/F7/wKgJT1rVeTuh6tcqAEDnosO5o6c236.m4a\r\n第三十六节 紧缩防线$http://audio.xmcdn.com/group41/M02/FB/7D/wKgJ8lrVeQeRpAveAGR2rGK-arc002.m4a\r\n第三十七节 台风$http://audio.xmcdn.com/group40/M00/C2/0A/wKgJT1rVemHgyAisAGY8MQdBkX8509.m4a\r\n第三十八节 重生$http://audio.xmcdn.com/group40/M01/C2/C5/wKgJVFrVeKyy675cAGbNkiuJ4sE753.m4a\r\n第三十九节 活埋津山$http://audio.xmcdn.com/group42/M03/FC/E5/wKgJ9FrVeOayQMmrAGPMHs4gyS0056.m4a\r\n第四十节 日寇防线$http://audio.xmcdn.com/group42/M0B/F8/3D/wKgJ81rVeXvhZzaOAGOr0FNucu4320.m4a\r\n第四十一节 神户恶战$http://audio.xmcdn.com/group41/M03/FB/89/wKgJ8lrVef7QbFb0AGT6n_CSUKY576.m4a\r\n第四十二节 樱花武士$http://audio.xmcdn.com/group41/M09/FB/81/wKgJ8lrVeYWxmOK2AGgDaHjTcCM907.m4a\r\n第四十三节 水淹千军$http://audio.xmcdn.com/group40/M07/C2/00/wKgJT1rVedeRMtKcAGbduZSSSTg605.m4a\r\n第四十四节 英勇的帝国骑兵$http://audio.xmcdn.com/group40/M07/C2/E0/wKgJVFrVeefwR4DvAGNQxrqHECQ047.m4a\r\n第四十五节 血拼神户$http://audio.xmcdn.com/group42/M09/FC/FA/wKgJ9FrVefWjACn4AGdnwytPuH0242.m4a\r\n第四十六节 重拳出击$http://audio.xmcdn.com/group42/M04/F8/3F/wKgJ81rVeZOx_7TXAGYk6_sxjWc167.m4a\r\n第四十七节 日本的雪$http://audio.xmcdn.com/group41/M0B/FB/39/wKgJ8VrVebeyWlp2AGQ6Pq5xA3k044.m4a\r\n第四十八节 甲斐之虎$http://audio.xmcdn.com/group42/M0B/F8/3B/wKgJ81rVeWPSAmX6AGYx7W7BzrA482.m4a\r\n第四十九节 相模原$http://audio.xmcdn.com/group41/M09/FB/83/wKgJ8lrVeY6gecUCAGZK4Rbkus0576.m4a\r\n第五十节 勇击猛狮$http://audio.xmcdn.com/group42/M09/FC/FC/wKgJ9FrVeguAKm5jAGq_24ApGPc118.m4a\r\n第五十一节 继续南进$http://audio.xmcdn.com/group41/M07/FB/8F/wKgJ8lrVei2CX7SWAGTS-MJSQQo843.m4a\r\n第五十二节 守株待兔$http://audio.xmcdn.com/group40/M09/C2/E6/wKgJVFrVemvCtg2PAGSCMvHRIho080.m4a\r\n第五十三节 后院失火$http://audio.xmcdn.com/group40/M09/C2/EB/wKgJVFrVeoDhjqLmAGK2lVi7oWs107.m4a\r\n第五十四节 猛虎三击$http://audio.xmcdn.com/group42/M09/FD/00/wKgJ9FrVehbTB2kSAGZ1d3zl4Ro514.m4a\r\n第五十五节 重挫甲斐之虎$http://audio.xmcdn.com/group41/M07/FB/8C/wKgJ8lrVeiLgjDs1AGRZGN_1aHc983.m4a\r\n第五十六节 偷袭青梅城$http://audio.xmcdn.com/group42/M09/FE/59/wKgJ9FrVi0XC5b3hAGV9TK6Qyqg618.m4a\r\n第五十七节 影虎$http://audio.xmcdn.com/group41/M06/FC/AC/wKgJ8VrVi4Hygg6qAGQLQZNaONU158.m4a\r\n第五十八节 山林之虎$http://audio.xmcdn.com/group42/M07/F9/A4/wKgJ81rVi0nieUgGAGgKwn5WVjs237.m4a\r\n第五十九节 甲府之战$http://audio.xmcdn.com/group41/M0B/FC/E5/wKgJ8lrVi12g6_0lAGRe9tgABeg353.m4a\r\n第六十节 神火$http://audio.xmcdn.com/group41/M00/FC/92/wKgJ8VrVim3Bqu1bAGU_oB5pBAo188.m4a\r\n第六十一节 战略转变$http://audio.xmcdn.com/group42/M05/FE/50/wKgJ9FrVitWBq2d6AGH8FoWGWFQ163.m4a\r\n第六十二节 惊喜$http://audio.xmcdn.com/group41/M00/FC/D4/wKgJ8lrVilyjxl01AEG_ewCIIng802.m4a\r\n第六十二节 惊喜(1)$http://audio.xmcdn.com/group41/M00/FC/D3/wKgJ8lrVilbzrL8UADsDjGtwQog059.m4a\r\n第六十三节 殖民方针$http://audio.xmcdn.com/group42/M04/F9/98/wKgJ81rVirvQEdtgAGXFQJyFPq8935.m4a\r\n第六十四节 天皇的尴尬$http://audio.xmcdn.com/group42/M04/F9/97/wKgJ81rVirfjiiRlAGOkdwFEBvw924.m4a\r\n第六十五节 绝代美女$http://audio.xmcdn.com/group40/M0B/C3/47/wKgJT1rVisWCVf6sAGHmEVyh0oY082.m4a\r\n第六十六节 毒计$http://audio.xmcdn.com/group40/M08/C3/46/wKgJT1rVipLzMzeaAGSomBYRauM507.m4a\r\n第六十七节 谦信之恋$http://audio.xmcdn.com/group41/M08/FC/96/wKgJ8VrVip7gPEs7AGOTD0UAXMo147.m4a\r\n第六十八节 上京$http://audio.xmcdn.com/group41/M00/FC/D2/wKgJ8lrVilOi7w2jAGPoBVQrT18156.m4a\r\n第六十九节 日本第一妓$http://audio.xmcdn.com/group40/M08/C3/41/wKgJT1rVin-TfopdAGMTFldiT3g148.m4a\r\n第七十节 落种$http://audio.xmcdn.com/group41/M09/FC/DF/wKgJ8lrVixOBukbsAGNd-m7Z3Qc795.m4a\r\n第七十一节 断根$http://audio.xmcdn.com/group42/M07/F9/A2/wKgJ81rViz3QSg5uAGLuYtGNavw498.m4a\r\n第七十二节 明日马关停战条约$http://audio.xmcdn.com/group40/M00/C3/4D/wKgJT1rViu6Q3r85AGRmS5nAeNI110.m4a\r\n第一节 将军请辞$http://audio.xmcdn.com/group40/M02/DE/7D/wKgJVFrW4O2TzTBnAGZN1A_Iu6M655.m4a\r\n第二节 帝国之矛$http://audio.xmcdn.com/group40/M09/DE/57/wKgJVFrW3wOhFQT3AGP5o4u-4GM685.m4a\r\n第三节 两大问题$http://audio.xmcdn.com/group40/M06/DD/6E/wKgJT1rW34bAOBd5AGKarv3cU38381.m4a\r\n第四节 亲政$http://audio.xmcdn.com/group40/M02/DE/79/wKgJVFrW4NbRrZLJAGNYHA-wx-4872.m4a\r\n第五节 西征军报$http://audio.xmcdn.com/group40/M02/DE/7B/wKgJVFrW4OHxG5XJAGNd-oJTvvc559.m4a\r\n第六节 皇室有后$http://audio.xmcdn.com/group42/M0B/13/A9/wKgJ81rW31uCysyVAGI1W_u09So589.m4a\r\n第七节 皇帝的无奈$http://audio.xmcdn.com/group42/M0B/18/4C/wKgJ9FrW32aC8JoqAGYgT_FuRgQ528.m4a\r\n第八节 琉球使者$http://audio.xmcdn.com/group40/M09/DE/55/wKgJVFrW3vqCEo45AGVCj9MrqLQ109.m4a\r\n第九节 琉球王$http://audio.xmcdn.com/group42/M0B/18/46/wKgJ9FrW306xy0-QAGLxUSiW3i4533.m4a\r\n第十节 官员节操$http://audio.xmcdn.com/group40/M05/DE/64/wKgJVFrW3-qweCiIAGOS2VSAWTg242.m4a\r\n第十一节 引导$http://audio.xmcdn.com/group40/M02/DE/78/wKgJVFrW4MqD_OU4AGQMuRGM0BI199.m4a\r\n第十二节 帝国科学院$http://audio.xmcdn.com/group42/M07/13/B2/wKgJ81rW387DmXSMAGSvt8VnSM0704.m4a\r\n第十三节 遍地星火$http://audio.xmcdn.com/group40/M04/DD/81/wKgJT1rW4Hqz3c2eAGONMFgA6iM302.m4a\r\n第十四节 疯狂的商人$http://audio.xmcdn.com/group42/M04/18/5A/wKgJ9FrW4J_i4A2LAGLJqos_svU571.m4a\r\n第十五节 银行$http://audio.xmcdn.com/group40/M0A/DD/85/wKgJT1rW4L6h3e9rAGYzZA4mX-8120.m4a\r\n第十六节 信誉$http://audio.xmcdn.com/group41/M02/16/B4/wKgJ8VrW4DKCl4z-AGMvM51dBzw892.m4a\r\n第十七节 开拓者$http://audio.xmcdn.com/group41/M02/16/FB/wKgJ8lrW4FeTE3nwAGNPS7eQywM468.m4a\r\n第十八节 南洋来讯$http://audio.xmcdn.com/group41/M04/16/AB/wKgJ8VrW36OQ9TueAGW-IcnQkOE128.m4a\r\n第十九节 南洋舰队$http://audio.xmcdn.com/group40/M05/DE/6D/wKgJVFrW4A-RjLpKAGQc3zZWtOY299.m4a\r\n第二十节 皇家千金$http://audio.xmcdn.com/group40/M09/DD/6A/wKgJT1rW3xyy7hV5AGbB1vMrrKE887.m4a\r\n第二十一节 探险船队$http://audio.xmcdn.com/group42/M0B/13/A6/wKgJ81rW302wbJ0WAGHQCM7GWt4548.m4a\r\n第二十二节 私生子$http://audio.xmcdn.com/group40/M09/DE/58/wKgJVFrW3w6xAGCJAGPiI2MsOAc327.m4a\r\n第二十三节 皇子$http://audio.xmcdn.com/group41/M06/16/A2/wKgJ8VrW3yjgZ-XhAGN_w-xzHls105.m4a\r\n第二十四节 西线无战事$http://audio.xmcdn.com/group42/M0B/18/44/wKgJ9FrW30SwfKoYAGSPahsv0xM231.m4a\r\n第一节 情系南洋$http://audio.xmcdn.com/group41/M04/17/2D/wKgJ8lrW5CKAAPwCAGWNd4FBXEA201.m4a\r\n第二节 海盗$http://audio.xmcdn.com/group40/M00/DE/83/wKgJVFrW4ZmgEzsFAGXyxiz_hQE240.m4a\r\n第三节 海盗老巢$http://audio.xmcdn.com/group42/M00/13/D2/wKgJ81rW4lLhgEz7AGLMnX-I5kY851.m4a\r\n第四节 文莱攻略$http://audio.xmcdn.com/group40/M06/DE/A6/wKgJVFrW49nDKdq1AGKGIXGodic942.m4a\r\n第五节 红夷舰队$http://audio.xmcdn.com/group40/M06/DD/BE/wKgJT1rW5ASwFFPsAGSvt4Z31kQ221.m4a\r\n第六节 重创红夷$http://audio.xmcdn.com/group40/M0B/DD/97/wKgJT1rW4g2jiWTEAGSN8ibPxEI708.m4a\r\n第七节 封锁旧港$http://audio.xmcdn.com/group40/M0B/DE/8D/wKgJVFrW4iiC4QSbAGO9b2d5Th8354.m4a\r\n第八节 联合舰队$http://audio.xmcdn.com/group42/M05/18/66/wKgJ9FrW4XOBRC_HAGIfVg6R4Xs707.m4a\r\n第九节 装模作样$http://audio.xmcdn.com/group42/M0A/18/6C/wKgJ9FrW4eSAmiMtAGG1neY368I431.m4a\r\n第十节 诱敌深入$http://audio.xmcdn.com/group41/M0B/16/D7/wKgJ8VrW4r6iCpQ6AGPHt2s1sIg419.m4a\r\n第十一节 火攻$http://audio.xmcdn.com/group42/M0A/18/89/wKgJ9FrW47jRJIQQAGWR3f5PGTg491.m4a\r\n第十二节 海上肉搏战$http://audio.xmcdn.com/group40/M07/DE/93/wKgJVFrW4pSRDvS1AGGSXCybkU4206.m4a\r\n第十三节 退敌$http://audio.xmcdn.com/group40/M08/DE/9F/wKgJVFrW40ixoIEyAGSWww-E2TQ459.m4a\r\n第十四节 救援狮城$http://audio.xmcdn.com/group42/M08/18/83/wKgJ9FrW43LxGQIFAGOo4Z8Tayc767.m4a\r\n第十五节 旧港登陆战$http://audio.xmcdn.com/group41/M09/17/26/wKgJ8lrW45KixF8SAGUmrFA8Kus715.m4a\r\n第十六节 夜袭$http://audio.xmcdn.com/group42/M09/13/DC/wKgJ81rW4v_RUJGXAGFL305Lj_o398.m4a\r\n第十七节 偷袭$http://audio.xmcdn.com/group42/M05/18/7F/wKgJ9FrW4yTTEg0PAGHu3hLkNcE815.m4a\r\n第十八节 强攻旧港$http://audio.xmcdn.com/group42/M06/18/79/wKgJ9FrW4nDit7g2AGSLA4DyMyE395.m4a\r\n第十九节 最后的堡垒$http://audio.xmcdn.com/group41/M0B/16/DB/wKgJ8VrW4uKyS2BIAGNbCy8Shi4887.m4a\r\n第二十节 血战狮城$http://audio.xmcdn.com/group41/M07/16/C9/wKgJ8VrW4b2TnIzfAGRwlNE8wWs755.m4a\r\n第二十一节 钢铁阵地$http://audio.xmcdn.com/group40/M01/DE/DE/wKgJVFrW5w3zyfKOAGTNFuRou18739.m4a\r\n第二十二节 怒涛袭岸$http://audio.xmcdn.com/group41/M01/17/4D/wKgJ8lrW5fXzDeruAGT8FvHhZyM771.m4a\r\n第二十三节 华侨堡垒$http://audio.xmcdn.com/group42/M04/18/B9/wKgJ9FrW5pbhq9f9AGP8kmSan2o056.m4a\r\n第二十四节 夜间决战$http://audio.xmcdn.com/group41/M04/17/19/wKgJ8VrW5ruQc4Q8AGM8NZJWyuE970.m4a\r\n第二十五节 横扫南洋$http://audio.xmcdn.com/group41/M04/17/1D/wKgJ8VrW5uPjv-CdAGYBdU4FAfg070.m4a\r\n第二十六节 海上远征$http://audio.xmcdn.com/group40/M09/DD/DE/wKgJT1rW5jazevsYAGM9rGJQeDU157.m4a\r\n第二十七节 特殊的海盗$http://audio.xmcdn.com/group41/M00/17/12/wKgJ8VrW5mWA3oX2AGQXAfFzaBU262.m4a\r\n第二十八节 华侨航海家$http://audio.xmcdn.com/group41/M01/17/0B/wKgJ8VrW5e7xbhNwAGMthhlIloo868.m4a\r\n第二十九节 探险先驱$http://audio.xmcdn.com/group42/M09/18/AE/wKgJ9FrW5gfw9K1oAGHu3ow3d_s044.m4a\r\n第三十节 助手$http://audio.xmcdn.com/group40/M08/DE/E9/wKgJVFrW54PSVtJwAGFBm77uRD0250.m4a\r\n第三十一节 华人共和国$http://audio.xmcdn.com/group42/M09/18/DF/wKgJ9FrW6KPCmxbvAGHet4dkHfw691.m4a\r\n第三十二节 逆我者亡$http://audio.xmcdn.com/group41/M03/17/22/wKgJ8VrW51zxajHUAGTXXiM_eic205.m4a\r\n第三十三节 百王大会$http://audio.xmcdn.com/group42/M02/14/37/wKgJ81rW6C-gqeDbAGU_oP2bhHI262.m4a\r\n第三十四节 舰队西进$http://audio.xmcdn.com/group41/M08/17/34/wKgJ8VrW6FPD5V3AAGM3zu3V5ME078.m4a\r\n第三十五节 天威$http://audio.xmcdn.com/group40/M0A/DE/FB/wKgJVFrW6H3De__BAGS3ES_-Fnc182.m4a\r\n第三十六节 亭可马里$http://audio.xmcdn.com/group41/M0B/17/6D/wKgJ8lrW592CAxuqAGVunTW1UaA264.m4a\r\n第三十七节 突袭白古$http://audio.xmcdn.com/group41/M06/17/70/wKgJ8lrW6AjzRv6iAGUJTmZPvko232.m4a\r\n第三十九节 迂回包抄$http://audio.xmcdn.com/group42/M03/18/CE/wKgJ9FrW57SgkbUGAGUoJIwKJl0890.m4a\r\n第三十八节 白古女王$http://audio.xmcdn.com/group42/M08/14/2A/wKgJ81rW5zPTpBgtAGPQhFojB9M038.m4a\r\n第四十节 狭路相逢$http://audio.xmcdn.com/group41/M09/17/7E/wKgJ8lrW6Mqi5mAuAGSGnbNupu0904.m4a\r\n第四十一节 围攻红夷堡垒$http://audio.xmcdn.com/group40/M08/DD/F1/wKgJT1rW52-QBnqcAGLGu59nV4Q490.m4a\r\n第四十二节 全面进攻$http://audio.xmcdn.com/group40/M09/DE/D3/wKgJVFrW5kqTGRXdAGK97rF8xsA302.m4a\r\n第四十三节 锡兰王室$http://audio.xmcdn.com/group41/M05/17/60/wKgJ8lrW5vKyKOziAGHdQH2Mhxo526.m4a\r\n第四十四节 吉大港攻略$http://audio.xmcdn.com/group42/M05/14/24/wKgJ81rW5xqj6eIqAGOP6m_ONH4817.m4a\r\n第四十五节 速破敌垒$http://audio.xmcdn.com/group40/M05/DD/EE/wKgJT1rW50aRV2fnAGdtoUabtgA325.m4a\r\n第四十六节 胡志的奇迹$http://audio.xmcdn.com/group42/M01/14/1C/wKgJ81rW5p2y8T44AGUB9AUWHVI789.m4a\r\n第四十七节 围追堵截$http://audio.xmcdn.com/group40/M00/DD/E8/wKgJT1rW5s2jYWqdAGO0naFodm4624.m4a\r\n第四十八节 红夷贵族$http://audio.xmcdn.com/group40/M01/DE/CE/wKgJVFrW5iOwhOUJAGDgriZ9DxQ869.m4a\r\n第四十九节 阶段性胜利$http://audio.xmcdn.com/group41/M00/17/14/wKgJ8VrW5nHiyyDkAGPGQDbUVd0261.m4a\r\n第五十节 不完全的胜利$http://audio.xmcdn.com/group40/M07/DD/FF/wKgJT1rW5_ThPgQqAGO6gJRb0Hc660.m4a\r\n第五十一节 白古亲王$http://audio.xmcdn.com/group41/M01/17/80/wKgJ8lrW6QWTeHcvAGUiQpmpNao881.m4a\r\n第五十二节 次大陆情报$http://audio.xmcdn.com/group42/M03/14/32/wKgJ81rW583BlJrSAGcnW5P3Cwc586.m4a\r\n第五十三节 远方来信$http://audio.xmcdn.com/group41/M02/17/39/wKgJ8VrW6JKR82PrAGWGHf4WjD0174.m4a\r\n第五十四节 大海战$http://audio.xmcdn.com/group42/M09/14/42/wKgJ81rW6MLzOZppAGeIESTLo4Y037.m4a\r\n第五十五节 果阿四日之战$http://audio.xmcdn.com/group40/M01/DF/02/wKgJVFrW6OORyKAoAGW6_Nc1s4c372.m4a\r\n第五十六节 迷雾重重$http://audio.xmcdn.com/group42/M00/18/DA/wKgJ9FrW6EaAYBjrAGHaUdnb-VU854.m4a\r\n第五十七节 血染海港$http://audio.xmcdn.com/group40/M0A/DE/F8/wKgJVFrW6Gnwbn2TAF_kHS-9JBY953.m4a\r\n第五十八节 围困$http://audio.xmcdn.com/group41/M0B/17/2A/wKgJ8VrW56OTVObLAGS873pd1aM567.m4a\r\n第五十九节 救兵$http://audio.xmcdn.com/group41/M06/17/74/wKgJ8lrW6B7QtZNrAGFmT3xb5GM559.m4a\r\n第六十节 帝国骑兵$http://audio.xmcdn.com/group42/M0B/14/13/wKgJ81rW5hXwK74TAGQMudYtRGE435.m4a\r\n第六十一节 港口解围$http://audio.xmcdn.com/group40/M08/DD/F6/wKgJT1rW54PxjQbAAGCaKsPlsak958.m4a\r\n第六十二节 帝国使者$http://audio.xmcdn.com/group41/M00/17/13/wKgJ8VrW5mrDc2BEAGSbKivsDT4127.m4a\r\n第六十三节 美酒与棍棒$http://audio.xmcdn.com/group40/M01/DE/DE/wKgJVFrW5w7hXUhhAGUJTkNPISY215.m4a\r\n第六十四节 秘密武器$http://audio.xmcdn.com/group42/M06/18/C9/wKgJ9FrW5ziRKeu-AGbq8B3NBr0306.m4a\r\n第六十五节 风驰电掣$http://audio.xmcdn.com/group41/M03/17/23/wKgJ8VrW516SmnFHAGPoBbhcCRQ031.m4a\r\n第六十六节 野战立威$http://audio.xmcdn.com/group41/M04/17/5A/wKgJ8lrW5r3RmSuQAGQ7uQoMhoo026.m4a\r\n第六十七节 真正的实力$http://audio.xmcdn.com/group41/M05/17/5F/wKgJ8lrW5uuiSIzFAGPoBSFmF1g848.m4a\r\n第六十八节 以战促和$http://audio.xmcdn.com/group40/M09/DD/E0/wKgJT1rW5kazJhFoAGG7sSAT7Lo426.m4a\r\n第六十九节 推动战争$http://audio.xmcdn.com/group42/M04/18/B8/wKgJ9FrW5pLyJRdAAGTsJn-tDJ8838.m4a\r\n第七十节 皇帝的较量$http://audio.xmcdn.com/group41/M0B/17/6D/wKgJ8lrW59mzgg-iAGJUMcxNf2Y679.m4a\r\n第七十一节 看不见的防线$http://audio.xmcdn.com/group40/M0B/DE/0B/wKgJT1rW6LTQfREUAGEugaIMp0M862.m4a\r\n第七十二节 无间配合$http://audio.xmcdn.com/group42/M03/18/CD/wKgJ9FrW57KRs86eAGXin8hjP8o202.m4a\r\n第七十三节 虎贲将军$http://audio.xmcdn.com/group42/M02/14/37/wKgJ81rW6C2Sk8_jAGf8E2cZTns032.m4a\r\n第七十四节 两皇对阵$http://audio.xmcdn.com/group40/M0A/DE/F6/wKgJVFrW6F3A11qGADhema-0zwg519.m4a\r\n第七十四节 两皇对阵(1)$http://audio.xmcdn.com/group41/M08/17/34/wKgJ8VrW6FPT1MUWAF2tSxxGA2M329.m4a\r\n第七十五节 经济战$http://audio.xmcdn.com/group41/M02/17/7B/wKgJ8lrW6JGRWDF8AGLxUW5oDCM390.m4a\r\n第七十六节 噩耗$http://audio.xmcdn.com/group41/M06/17/73/wKgJ8lrW6BbB1m2AAGPZVf3s6BY284.m4a\r\n第一节 混乱$http://audio.xmcdn.com/group41/M04/2E/28/wKgJ8VrYFMbShJQxAC8stMr5KrI843.m4a\r\n第一节 混乱(1)$http://audio.xmcdn.com/group41/M06/2E/5E/wKgJ8lrYFMayPfsHAEzjMtFnspA521.m4a\r\n第二节 混沌战局$http://audio.xmcdn.com/group42/M02/2F/8F/wKgJ9FrYEuCiYPabAGMdX5togng338.m4a\r\n第三节 长崎解围$http://audio.xmcdn.com/group41/M00/2E/0C/wKgJ8VrYEx-DnUcuAGMDJuxB0Sw341.m4a\r\n第四节 秋风扫落叶$http://audio.xmcdn.com/group41/M04/2E/22/wKgJ8VrYFKGjn9c7AGaXQL4UakA919.m4a\r\n第五节 血战同萌关$http://audio.xmcdn.com/group41/M04/2E/24/wKgJ8VrYFLXTVv3OAGc3T3hunLc198.m4a\r\n第六节 绝地大反击$http://audio.xmcdn.com/group41/M01/2E/40/wKgJ8lrYEwmTl8nnAGQlsGAoWa8005.m4a\r\n第七节 浑水摸鱼$http://audio.xmcdn.com/group41/M00/2E/0A/wKgJ8VrYExPCt-_BAGOCspKrhjM467.m4a\r\n第八节 反思$http://audio.xmcdn.com/group42/M03/2A/DB/wKgJ81rYEtWiM2E-AGXogQgi61I234.m4a\r\n第九节 平叛战略$http://audio.xmcdn.com/group41/M06/2E/3B/wKgJ8lrYEvLxN79EACeRjZsfCnk149.m4a\r\n第九节 平叛战略(1)$http://audio.xmcdn.com/group41/M06/2E/03/wKgJ8VrYEvTh80JgAFX8H1Lqq-s167.m4a\r\n第十节 第一混成军(1)$http://audio.xmcdn.com/group40/M06/F5/CC/wKgJVFrYE3WweHpWAFB2BkfBUts972.m4a\r\n第十节 第一混成军$http://audio.xmcdn.com/group40/M06/F4/EE/wKgJT1rYE4XBHc4sAC7x99coLMU391.m4a\r\n第十一节 血海中的江户城$http://audio.xmcdn.com/group41/M0A/2E/57/wKgJ8lrYFJKySpZgAGZvmWj9opA669.m4a\r\n第十二节 围堵$http://audio.xmcdn.com/group42/M0A/2F/95/wKgJ9FrYE1fh3_pDAGOemTOv7t8320.m4a\r\n第十三节 围歼真田兵团$http://audio.xmcdn.com/group40/M0A/F5/00/wKgJT1rYFELCGYqHAGbPCU44avc937.m4a\r\n第十四节 日寇第一兵$http://audio.xmcdn.com/group41/M0A/2E/54/wKgJ8lrYFFOwRKUZAGidmuoCtHw327.m4a\r\n第十五节 火烧日野$http://audio.xmcdn.com/group42/M07/2A/F2/wKgJ81rYFHXifwjGAGSFW8q1Uno579.m4a\r\n第十六节 立川鏖战$http://audio.xmcdn.com/group40/M05/F4/F3/wKgJT1rYE_TjBPaCAGQ-qPnldCU682.m4a\r\n第十七节 抱头鼠窜$http://audio.xmcdn.com/group40/M0A/F4/FE/wKgJT1rYFDXQH0-ZAGY6uujGWEk433.m4a\r\n第十八节 北逐$http://audio.xmcdn.com/group41/M00/2E/10/wKgJ8VrYEzDSCUzIAGg5v6zN5LA239.m4a\r\n第十九节 东军的态度$http://audio.xmcdn.com/group42/M05/2F/9F/wKgJ9FrYE7uwa4qkAGO9peG2JoA394.m4a\r\n第二十节 军神非神$http://audio.xmcdn.com/group41/M06/2E/3A/wKgJ8lrYEuyRwXVSAGTKXXbys08503.m4a\r\n第二十一节 伪皇$http://audio.xmcdn.com/group40/M0A/F5/E1/wKgJVFrYFEOAeUalAGSG05wP-Cg544.m4a\r\n第二十二节 全面叛乱$http://audio.xmcdn.com/group42/M09/2A/E5/wKgJ81rYE1yipICKAGS3EbXAMYg575.m4a\r\n第二十三节 死守浦和$http://audio.xmcdn.com/group42/M05/2F/9C/wKgJ9FrYE62zy1gMAGMdX1WCgeI894.m4a\r\n第二十四节 夜袭敌营$http://audio.xmcdn.com/group41/M05/2E/50/wKgJ8lrYE-LzkeHTAGF37ZVguQs345.m4a\r\n第二十五节 阵前倒戈$http://audio.xmcdn.com/group40/M0A/F5/DA/wKgJVFrYFBfQUTzWAGjljryx2wM944.m4a\r\n第二十六节 分化敌人$http://audio.xmcdn.com/group40/M06/F5/CD/wKgJVFrYE3vxm7y8AGSihL0nX6I342.m4a\r\n第二十七节 最终策略$http://audio.xmcdn.com/group40/M06/F4/EF/wKgJT1rYE4rw2tZQAGQqF9GyJSM450.m4a\r\n第二十八节 救援行动$http://audio.xmcdn.com/group40/M04/F4/E4/wKgJT1rYE0jRO7gaAGbfNHR7rtE954.m4a\r\n第二十九节 全面反击$http://audio.xmcdn.com/group40/M06/F4/E8/wKgJT1rYE2nTgy5NAGXA2ue-6Jg445.m4a\r\n第三十节 幕府将军$http://audio.xmcdn.com/group40/M07/F5/05/wKgJT1rYFOyTg61CAD1BtIVNoRg421.m4a\r\n第三十节 幕府将军(1)$http://audio.xmcdn.com/group40/M07/F5/E3/wKgJVFrYFODzCaoWAEMlyjXrmMM057.m4a\r\n第三十一节 定都$http://audio.xmcdn.com/group40/M08/F5/EE/wKgJVFrYFV-CqIByACgXLqtTU0s606.m4a\r\n第三十一节 定都(1)$http://audio.xmcdn.com/group40/M08/F5/0D/wKgJT1rYFV7Cd2zaAFR57rhgz44875.m4a\r\n第三十二节 撞门$http://audio.xmcdn.com/group41/M04/2E/29/wKgJ8VrYFM3inBubAGZN1C-gOEU423.m4a\r\n第三十三节 炮轰宇都宫$http://audio.xmcdn.com/group41/M07/2E/2C/wKgJ8VrYFTejD7tXAGVaEJiuz_8940.m4a\r\n第三十四节 虎皮做旗$http://audio.xmcdn.com/group41/M07/2E/64/wKgJ8lrYFUWTVL7wAGSoYrPTg_Y329.m4a\r\n第三十五节 黑矶城外的战斗$http://audio.xmcdn.com/group40/M08/F5/EC/wKgJVFrYFVaykceiAGV0fzOaj_o899.m4a\r\n第三十六节 歼敌$http://audio.xmcdn.com/group42/M04/2F/AC/wKgJ9FrYFQ7zD8aWADdtxMbyFO0191.m4a\r\n第三十六节 歼敌(1)$http://audio.xmcdn.com/group42/M04/2F/AB/wKgJ9FrYFQeQhdD0AEbUhRHu8rU095.m4a\r\n第三十七节 越后之战$http://audio.xmcdn.com/group40/M08/F5/07/wKgJT1rYFSTwgUIpAGnd77VfHc4572.m4a\r\n第三十八节 帝国使者$http://audio.xmcdn.com/group41/M0A/2E/56/wKgJ8lrYFJCCXeX-AERIi3mNlA4699.m4a\r\n第三十八节 帝国使者(1)$http://audio.xmcdn.com/group42/M0B/2F/A1/wKgJ9FrYFHHCqPIDAG2K_VSS_Ec785.m4a\r\n第三十九节 侠客$http://audio.xmcdn.com/group42/M04/2F/AA/wKgJ9FrYFQHTrfOfAGLCVVwVpnE089.m4a\r\n第四十节 围攻郡山$http://audio.xmcdn.com/group42/M02/2F/B2/wKgJ9FrYFXjAeUb1AGE4yo39kHo310.m4a\r\n第四十一节 越后大捷$http://audio.xmcdn.com/group40/M04/F5/11/wKgJT1rYFaHAJp0-AGTY1uM6mJQ786.m4a\r\n第四十二节 叛军重臣$http://audio.xmcdn.com/group41/M0A/2E/55/wKgJ8lrYFFyD5azhAGo11EYRHkQ190.m4a\r\n第四十三节 影子家臣$http://audio.xmcdn.com/group42/M04/2F/AF/wKgJ9FrYFSHC3Dq4AGQy6MkM_Y8165.m4a\r\n第四十四节 军人的荣誉$http://audio.xmcdn.com/group40/M08/F5/EC/wKgJVFrYFVaTReuJAGXGuKepSXc524.m4a\r\n第四十五节 帝国第五军$http://audio.xmcdn.com/group41/M08/2E/66/wKgJ8lrYFX7x3ysIAGYhxn4VD6g975.m4a\r\n第四十六节 上野泥潭$http://audio.xmcdn.com/group41/M04/2E/28/wKgJ8VrYFMnQDrFLAGP4K_PetNI543.m4a\r\n第四十七节 整装待发$http://audio.xmcdn.com/group40/M07/F5/E5/wKgJVFrYFPCy7KonAGKEqSK3o1I656.m4a\r\n第四十八节 齐头并进$http://audio.xmcdn.com/group40/M0A/F4/FC/wKgJT1rYFCqwncR6AGPt4y6Jgyo436.m4a\r\n第四十九节 大展神威$http://audio.xmcdn.com/group41/M0A/2E/56/wKgJ8lrYFI2juKbkADSohJF_kyk776.m4a\r\n第四十九节 大展神威(1)$http://audio.xmcdn.com/group42/M0B/2F/A2/wKgJ9FrYFHTge3hUAEi2LEnvsCQ059.m4a\r\n第五十节 富山之战$http://audio.xmcdn.com/group42/M00/2F/B9/wKgJ9FrYFeySPjJRAGbrJpzdWLA790.m4a\r\n第五十一节 野蛮攻城法$http://audio.xmcdn.com/group41/M02/2E/41/wKgJ8VrYFnPz7hdmAGYHVy4QQ5Q677.m4a\r\n第五十二节 建议$http://audio.xmcdn.com/group40/M04/F5/F6/wKgJVFrYFebzHttKAGebJ8UyUHY644.m4a\r\n第五十三节 烧津鏖战$http://audio.xmcdn.com/group42/M0A/2F/BC/wKgJ9FrYFirRFgM6AGc77Hft2ms294.m4a\r\n第五十四节 狼王杨天奉$http://audio.xmcdn.com/group41/M02/2E/73/wKgJ8lrYFlbCGdvrAGXPidOBPVY034.m4a\r\n第五十五节 风卷残云$http://audio.xmcdn.com/group41/M02/2E/76/wKgJ8lrYFmbDw3a-AGRcB2wMD_s327.m4a\r\n第五十六节 摧枯拉朽$http://audio.xmcdn.com/group40/M00/F5/15/wKgJT1rYFgPjpZGWAGRBlzR_5Rg239.m4a\r\n第五十七节 围困尾张$http://audio.xmcdn.com/group40/M00/F5/17/wKgJT1rYFg_wn5zTAGYQJI1M61c147.m4a\r\n第五十八节 围攻名古屋$http://audio.xmcdn.com/group42/M00/2B/07/wKgJ81rYFcvgGSWJAGSFJTBWAaE753.m4a\r\n第五十九节 万炮齐鸣$http://audio.xmcdn.com/group41/M0B/2E/37/wKgJ8VrYFfrD8lWJAGTRgHImMxk056.m4a\r\n第六十节 叛徒的下场$http://audio.xmcdn.com/group41/M05/2E/4C/wKgJ8lrYE8fwedANAGQYeZyyiuo519.m4a\r\n第六十一节 往事前因$http://audio.xmcdn.com/group40/M0A/F5/D9/wKgJVFrYFA6A5O2PAGn2rbvFBM8719.m4a\r\n第六十二节 阴谋策划$http://audio.xmcdn.com/group42/M05/2F/9D/wKgJ9FrYE7KC_UOkAGfQBVjdDL8481.m4a\r\n第六十三节 本能寺之变$http://audio.xmcdn.com/group41/M05/2E/17/wKgJ8VrYE9qDlqd2AGR0-_FbLZs417.m4a\r\n第六十四节 日本善后$http://audio.xmcdn.com/group40/M05/F5/D2/wKgJVFrYE-3RwWzvADq6ID5xgjI762.m4a\r\n第六十四节 日本善后(1)$http://audio.xmcdn.com/group41/M05/2E/1A/wKgJ8VrYE-Wjn1fMAEiKHtE1oEA292.m4a\r\n第一节 凯旋回京$http://audio.xmcdn.com/group40/M04/0F/F2/wKgJT1rZmfCBc50RAGVCxTfAXPA787.m4a\r\n第二节 天下事$http://audio.xmcdn.com/group41/M0A/48/FB/wKgJ8VrZmKvgA83jAEDb4qJb5uI948.m4a\r\n第二节 天下事(1)$http://audio.xmcdn.com/group41/M0A/48/FB/wKgJ8VrZmKmy8Mw4AGslLjGZYDE076.m4a\r\n第三节 东方来迅$http://audio.xmcdn.com/group41/M05/49/2E/wKgJ8lrZmRujIcKlAE6XTzBB8XU424.m4a\r\n第三节 东方来迅(1)$http://audio.xmcdn.com/group40/M06/0F/E3/wKgJT1rZmQeTKIcWAEeiGqe1OZk560.m4a\r\n第四节 西洋报告$http://audio.xmcdn.com/group40/M04/0F/ED/wKgJT1rZmdiwGcXuAGIVDpckK6k510.m4a\r\n第五节 卫广复出$http://audio.xmcdn.com/group40/M04/10/C6/wKgJVFrZmeLgBpBwAGIZdA8U24o519.m4a\r\n第六节 大军归营$http://audio.xmcdn.com/group40/M09/0F/DA/wKgJT1rZmNaAvB5OAGgpmO4no1A306.m4a\r\n第七节 苗人叛乱$http://audio.xmcdn.com/group40/M06/0F/DE/wKgJT1rZmPHyPgiaAGXrcL_w_po108.m4a\r\n第八节 西征准备$http://audio.xmcdn.com/group40/M07/0F/D7/wKgJT1rZmJvD60UaAGCVy6nmgkA017.m4a\r\n第九节 大军出发$http://audio.xmcdn.com/group42/M01/46/24/wKgJ81rZmMmTaTr7AGUMPQVB6TU286.m4a\r\n第十节 蒙古军团$http://audio.xmcdn.com/group42/M06/46/2D/wKgJ81rZmVDB8Hk0AGoIhdvR9Vo778.m4a\r\n第十一节 天可汗$http://audio.xmcdn.com/group42/M00/46/38/wKgJ81rZmdTymusPAGZd-nOo3YQ103.m4a\r\n第十二节 西北军团$http://audio.xmcdn.com/group42/M06/46/2E/wKgJ81rZmVKh0mZ9AGQIUp3IkzM033.m4a\r\n第十三节 大战略$http://audio.xmcdn.com/group41/M07/49/09/wKgJ8VrZmZCCqAUuAEFjMBrvMhs432.m4a\r\n第十三节 大战略(1)$http://audio.xmcdn.com/group40/M05/10/BD/wKgJVFrZmYSCAS74ADrEaGJX3Fo466.m4a\r\n第十四节 万里大突击$http://audio.xmcdn.com/group41/M07/49/3F/wKgJ8lrZmaPRDs9RAGKpXc9xjVo414.m4a\r\n第十五节 西面歼敌战$http://audio.xmcdn.com/group42/M00/46/35/wKgJ81rZmbahkkfYAGUSGzkIM-c428.m4a\r\n第十六节 无障碍进攻$http://audio.xmcdn.com/group41/M06/49/37/wKgJ8lrZmXKy0RQ1AGPdvE04__g432.m4a\r\n第十七节 中路突破$http://audio.xmcdn.com/group40/M05/10/BC/wKgJVFrZmYDjUQ0CAGPNlT-wBCM523.m4a\r\n第十八节 神秘宝藏$http://audio.xmcdn.com/group42/M06/4A/E5/wKgJ9FrZmTaQVX2sAGLbTV2rsPQ080.m4a\r\n第十九节 围困哈烈$http://audio.xmcdn.com/group41/M06/49/36/wKgJ8lrZmW3x_Yx_AGPX3nj6AsU749.m4a\r\n第二十节 围而不攻$http://audio.xmcdn.com/group42/M01/46/21/wKgJ81rZmLvQcMt5AGQG22VW5R8905.m4a\r\n第二十一节 暴动$http://audio.xmcdn.com/group41/M02/49/16/wKgJ8VrZmj-jfPj5AGJown2p_4o107.m4a\r\n第二十二节 诱敌出战$http://audio.xmcdn.com/group40/M06/0F/E5/wKgJT1rZmQ-S7SUBAGXOEkhAZMc638.m4a\r\n第二十三节 红色的阿木河$http://audio.xmcdn.com/group42/M00/46/37/wKgJ81rZmc7wZcYdAGMC8EW3q5Y901.m4a\r\n第二十四节 牺牲的价值$http://audio.xmcdn.com/group40/M04/10/CC/wKgJVFrZmf6jGsrzAGQ6PlwsLw4708.m4a\r\n第二十五节 刺刀见红$http://audio.xmcdn.com/group41/M00/49/12/wKgJ8VrZmh2z2yziAGQqF17p3Wg436.m4a\r\n第二十六节 全歼强敌$http://audio.xmcdn.com/group41/M07/49/06/wKgJ8VrZmXCjDkxeAGSuQLOY6w8329.m4a\r\n第二十七节 火舞之城$http://audio.xmcdn.com/group41/M07/49/0D/wKgJ8VrZmaCgNLXmAGP26lGV2dU258.m4a\r\n第二十八节 帖木尔的宝藏$http://audio.xmcdn.com/group40/M06/0F/DF/wKgJT1rZmPKBc45bAGSD4HEq7ng098.m4a\r\n第二十九节 镇压暴乱$http://audio.xmcdn.com/group42/M06/46/29/wKgJ81rZmTzhiqn3AGG4jPxbiRU634.m4a\r\n第三十节 血色沙漠$http://audio.xmcdn.com/group42/M0A/4B/01/wKgJ9FrZmobxNqO4AGFAI2-5nis238.m4a\r\n第三十一节 惊世宝藏$http://audio.xmcdn.com/group41/M04/49/51/wKgJ8lrZms3z-8-jACWbWvT-8rQ952.m4a\r\n第三十二节　全面进攻$http://audio.xmcdn.com/group42/M04/4A/FD/wKgJ9FrZmmOwqL0oAGXfsNImQ-0589.m4a\r\n第三十三节 新领土$http://audio.xmcdn.com/group41/M04/49/51/wKgJ8lrZms7jkB6oAGT0vWPUrGQ197.m4a\r\n第一节 帝国大动脉$http://audio.xmcdn.com/group41/M04/4A/F0/wKgJ8lrZr9SACGv2AEnEW_sLLzE228.m4a\r\n第一节 帝国大动脉(1)$http://audio.xmcdn.com/group42/M09/4C/A0/wKgJ9FrZr7aSdiDaAE9jbPsHYxE575.m4a\r\n第二节 狡猾的阿巴克$http://audio.xmcdn.com/group42/M0A/47/B1/wKgJ81rZrWKjzVRKAGLnCfQXNZg773.m4a\r\n第三节 南方战事$http://audio.xmcdn.com/group40/M03/11/7E/wKgJT1rZrZ3Be3TGAC2IuUztuZY363.m4a\r\n第三节 南方战事(1)$http://audio.xmcdn.com/group40/M03/12/4F/wKgJVFrZrZnyKJL7AE_NJt-6epQ132.m4a\r\n第四节 陈懋来报$http://audio.xmcdn.com/group41/M08/4A/BF/wKgJ8VrZr3GCBfm_AGTnhRNORPQ064.m4a\r\n第五节 亦力巴里$http://audio.xmcdn.com/group42/M09/4C/9E/wKgJ9FrZr57zJrkwAGZj2Q1PxB0031.m4a\r\n第六节 南征北伐$http://audio.xmcdn.com/group42/M0A/47/B9/wKgJ81rZrYbzJBApAGPZVcmyCM0279.m4a\r\n第七节 西洋舰队$http://audio.xmcdn.com/group40/M03/11/7C/wKgJT1rZrZKTq49QAGTjVMNZuxg182.m4a\r\n第八节 谦虚将领$http://audio.xmcdn.com/group41/M0A/4A/C4/wKgJ8lrZrVPTeHJtAGV9goOn9A4113.m4a\r\n第九节 勇猛第三军$http://audio.xmcdn.com/group42/M0A/47/B7/wKgJ81rZrXyDmH0BAGZH8qQuFNw477.m4a\r\n第十节 果阿解围$http://audio.xmcdn.com/group42/M02/4C/7F/wKgJ9FrZrjLSFVBrAGKGIfqLTcA058.m4a\r\n第十一节 歼灭战$http://audio.xmcdn.com/group42/M06/47/D6/wKgJ81rZr0my4DrFAGNxFFbVT9g794.m4a\r\n第十二节 第五军的狂奔$http://audio.xmcdn.com/group41/M07/4A/AB/wKgJ8VrZrgfA1EQqAGOzJsTeT8g311.m4a\r\n第十三节 卫广之怒$http://audio.xmcdn.com/group40/M02/11/94/wKgJT1rZrtzgl7gvAGQkOVs_iCk011.m4a\r\n第十四节 铁壁$http://audio.xmcdn.com/group40/M06/11/99/wKgJT1rZrvuQDQwCAGNfq-2Mo1M308.m4a\r\n第十五节 再战孟买$http://audio.xmcdn.com/group41/M00/4A/E3/wKgJ8lrZryPyuZ6FAGMql0dOQR4462.m4a\r\n第十六节 从苏拉特出发$http://audio.xmcdn.com/group42/M0B/47/C9/wKgJ81rZrojSIxovAGOl7jOleFc775.m4a\r\n第十七节 西洋政策$http://audio.xmcdn.com/group41/M05/4A/B2/wKgJ8VrZrqqw8RYyAGN4aeWL8wM207.m4a\r\n第十八节 杨天奉来报$http://audio.xmcdn.com/group41/M07/4A/A4/wKgJ8VrZreiSMX77AGbGPJvPT08197.m4a\r\n第十九节 恶战阿杰梅尔$http://audio.xmcdn.com/group40/M0A/12/5F/wKgJVFrZrlnz0brXAGPTc8V_xMU172.m4a\r\n第二十节 火攻$http://audio.xmcdn.com/group42/M0B/4C/72/wKgJ9FrZrW-wbpUhAGKKh-C7hVw697.m4a\r\n第二十一节 蒙古军团的转变$http://audio.xmcdn.com/group40/M02/12/65/wKgJVFrZrt6DHoTnAGWfFcLsUv4096.m4a\r\n第二十二节 骑兵对撼$http://audio.xmcdn.com/group42/M06/4C/77/wKgJ9FrZrdLijZ4lAGGvu-y6P9o728.m4a\r\n第二十三节 重装骑兵$http://audio.xmcdn.com/group40/M0A/12/61/wKgJVFrZrmKinTVQAGRsLQja_tY165.m4a\r\n第二十四节 烽火焚城$http://audio.xmcdn.com/group42/M09/4C/85/wKgJ9FrZrory4piIAGN-Sxyd30k236.m4a\r\n第二十五节 北线进攻$http://audio.xmcdn.com/group41/M05/4A/E0/wKgJ8lrZrreiIiX0AGTaTX-YlGc092.m4a\r\n第二十六节 野外鏖战$http://audio.xmcdn.com/group41/M07/4A/D5/wKgJ8lrZrgyQbEBnAGdsKvk0AYg737.m4a\r\n第二十七节 决战$http://audio.xmcdn.com/group42/M08/47/C4/wKgJ81rZrjuSNlz4AGW1Gq8CY0M381.m4a\r\n第二十八节 大跃进$http://audio.xmcdn.com/group41/M04/4A/9D/wKgJ8VrZrbzytrCXAGipWmlF8fY977.m4a\r\n第二十九节 向德里进军$http://audio.xmcdn.com/group42/M06/47/BC/wKgJ81rZrdngbee8AGL1uNBiOzU791.m4a\r\n第三十节 次大陆之乱$http://audio.xmcdn.com/group42/M07/4C/95/wKgJ9FrZr1ORfkM_AGMthjdUSTo698.m4a\r\n第三十一节 国内来报$http://audio.xmcdn.com/group41/M09/4A/D5/wKgJ8VrZsGCiaa59ACM0ExP2vw0748.m4a\r\n第三十一节 国内来报(1)$http://audio.xmcdn.com/group41/M09/4A/D3/wKgJ8VrZsFmjoloDAFgOOn2yJCo881.m4a\r\n第三十二节 家事，国事$http://audio.xmcdn.com/group41/M00/4A/E6/wKgJ8lrZrzLBiDzPAGRKaLM7zro957.m4a\r\n第三十三节 顾成林的战果$http://audio.xmcdn.com/group40/M0B/12/7A/wKgJVFrZr_XTD12cAGY03CmnmW0686.m4a\r\n第三十四节 出使白羊王国$http://audio.xmcdn.com/group42/M01/4C/A5/wKgJ9FrZsBjiOzjmAGaKCGpp49g439.m4a\r\n第三十五节 重拳出击$http://audio.xmcdn.com/group41/M09/4A/F6/wKgJ8lrZsDyD0CrJAGOqWX0920Y855.m4a\r\n第三十六节 围攻德里$http://audio.xmcdn.com/group42/M08/47/E1/wKgJ81rZr6HRyk-gAGMb53Fd2aQ187.m4a\r\n第三十七节 最后的战斗$http://audio.xmcdn.com/group40/M0B/11/A9/wKgJT1rZr8-hbGEGAGRnx4mbU80840.m4a\r\n第三十八节 阿巴克的最后选择$http://audio.xmcdn.com/group40/M06/12/6A/wKgJVFrZrwTSYNHCAGJdAoS1zEI671.m4a\r\n第三十九节 收尾$http://audio.xmcdn.com/group41/M08/4A/EA/wKgJ8lrZr3jDHKsfAGR2dsuSu54348.m4a\r\n第四十节 波利加妃子$http://audio.xmcdn.com/group42/M0A/4C/AD/wKgJ9FrZsJDSLkQzAGYfCSiStLg205.m4a\r\n第四十一节 南方新大陆$http://audio.xmcdn.com/group42/M06/47/D6/wKgJ81rZr0jRSxNyAGSp2eax91w615.m4a\r\n第四十二节 万国佳丽$http://audio.xmcdn.com/group41/M07/4A/AC/wKgJ8VrZrguRlBsPAC66KdvJ-oA602.m4a\r\n第四十二节 万国佳丽(1)$http://audio.xmcdn.com/group41/M07/4A/D4/wKgJ8lrZrgbjSFerAFH7J4OX83U101.m4a\r\n第四十三节 和亲与人质$http://audio.xmcdn.com/group41/M05/4A/B3/wKgJ8VrZrq2xs9zcAC1uSqf5GlI164.m4a\r\n第四十三节 和亲与人质(1)$http://audio.xmcdn.com/group41/M05/4A/D9/wKgJ8lrZrpyhLRUbAFBS_Ap0kp4925.m4a\r\n第四十四节 白羊王朝$http://audio.xmcdn.com/group40/M02/12/66/wKgJVFrZruLw_VfnAGTNFgSOCEE128.m4a\r\n第四十五节 奥斯曼土耳其帝国$http://audio.xmcdn.com/group40/M06/11/9E/wKgJT1rZrxDTPJ6RADnWguyutx0126.m4a\r\n第四十五节 奥斯曼土耳其帝国(1)$http://audio.xmcdn.com/group40/M06/11/99/wKgJT1rZrv7Qhs8kAEP6tPEVkb0239.m4a\r\n第四十六节 帝国长鞭$http://audio.xmcdn.com/group40/M0A/11/91/wKgJT1rZrmigc-h1AGIH1uMBl8U143.m4a\r\n第四十七节 马林迪海战$http://audio.xmcdn.com/group41/M00/4A/AE/wKgJ8VrZroOCSl-kAGWfS2frf64614.m4a\r\n第四十八节 陆战近卫军$http://audio.xmcdn.com/group41/M07/4A/A7/wKgJ8VrZrfjjKaAvAGM9rHa0PZs453.m4a\r\n第四十九节 驰援蒙巴萨$http://audio.xmcdn.com/group42/M02/4C/80/wKgJ9FrZrjWSf7sNAGD1PB5hy_g407.m4a\r\n第五十节 海上决战$http://audio.xmcdn.com/group40/M00/11/A3/wKgJT1rZr4yx5LoVAGTo_a4hhq8385.m4a\r\n第五十一节 南征$http://audio.xmcdn.com/group40/M0B/12/7D/wKgJVFrZsAWzqnpmAGKk9u8ArWY157.m4a\r\n第五十二节 蛮荒大陆$http://audio.xmcdn.com/group41/M08/4A/BE/wKgJ8VrZr2zQPqqLAGHu3ntzVn4101.m4a\r\n第五十三节 帝国远征军$http://audio.xmcdn.com/group40/M0B/12/75/wKgJVFrZr8WjHd1VAGOr0N4U87Q955.m4a\r\n第五十四节 小明国$http://audio.xmcdn.com/group40/M0B/11/AA/wKgJT1rZr--SI3FQAGP7Gnv3cNE024.m4a\r\n第一节 团圆$http://audio.xmcdn.com/group42/M01/60/E5/wKgJ9FraxN-QfJEKAGP4Yeg0JPQ899.m4a\r\n第二节 开发新大陆$http://audio.xmcdn.com/group41/M07/5E/C6/wKgJ8lrawdyRvdOnACNjEDHRvrM092.m4a\r\n第二节 开发新大陆(1)$http://audio.xmcdn.com/group41/M07/5E/9C/wKgJ8VraweOwUutTAFohzNN_0uM255.m4a\r\n第三节 地理大发现$http://audio.xmcdn.com/group40/M09/26/60/wKgJVFrawjmjN3tlACYJsO0mV2k260.m4a\r\n第三节 地理大发现(1)$http://audio.xmcdn.com/group40/M09/25/9D/wKgJT1rawjHSInIIAFTsePj1Uu4546.m4a\r\n第四节 纸币$http://audio.xmcdn.com/group40/M07/26/84/wKgJVFraxHOSQo2zAGb8k0ROg30740.m4a\r\n第五节 商人与钱$http://audio.xmcdn.com/group41/M08/5E/CB/wKgJ8VraxKWipEG-ACk_zWNyf5g376.m4a\r\n第五节 商人与钱(1)$http://audio.xmcdn.com/group40/M07/26/8E/wKgJVFraxJjzplLuAFJ66RoTsdY977.m4a\r\n第六节 工业资本家$http://audio.xmcdn.com/group42/M02/60/A3/wKgJ9FrawhGx08NLAGNZk_dUO-0810.m4a\r\n第七节 资本家联盟$http://audio.xmcdn.com/group40/M09/26/58/wKgJVFrawh2QmsmcAGXs55VCkw8360.m4a\r\n第八节 奥斯曼使者$http://audio.xmcdn.com/group41/M07/5E/99/wKgJ8VrawdjAxbFhAGLSfI90ipo255.m4a\r\n第九节 宣战$http://audio.xmcdn.com/group40/M02/26/54/wKgJVFrawgOgVtPRAD7iuy7fJvQ296.m4a\r\n第九节 宣战(1)$http://audio.xmcdn.com/group40/M02/26/52/wKgJVFrawfvzB9qSAFUqJCgDk4I643.m4a\r\n第十节 军事情报局$http://audio.xmcdn.com/group42/M0A/5B/E9/wKgJ81rawtagMbEWAGLcxCtIutE704.m4a\r\n第十一节 军人保障$http://audio.xmcdn.com/group41/M09/5E/C9/wKgJ8VraxD6w5Lf7AGH6nn5ILJI732.m4a\r\n第十二节 帝国顶梁柱$http://audio.xmcdn.com/group40/M00/25/A7/wKgJT1rawrDRrfKMAGKtxEdlMU4387.m4a\r\n第十三节 豪华宴会$http://audio.xmcdn.com/group40/M06/26/76/wKgJVFraw6HSWPu2AGUSGzgc0fI472.m4a\r\n第十四节 贵族议会$http://audio.xmcdn.com/group42/M09/60/CF/wKgJ9Fraw9HhYBzLAGC7-9Ns2jc483.m4a\r\n第十五节 帝国新势力$http://audio.xmcdn.com/group40/M0B/25/BE/wKgJT1raxAqSFNZ3AGKAPozGLEY376.m4a\r\n第十六节 疑云重重$http://audio.xmcdn.com/group40/M05/25/B1/wKgJT1rawzSiYtqYAGC_IBqpVgc418.m4a\r\n第十七节 柴氏家族$http://audio.xmcdn.com/group41/M01/5E/E6/wKgJ8lraw4CTIKXFAGM3zpPVDEo539.m4a\r\n第十八节 花好月圆$http://audio.xmcdn.com/group41/M04/5E/9E/wKgJ8VrawnaiA4DwAGJzBw6UzjY299.m4a\r\n第十九节 权柄$http://audio.xmcdn.com/group41/M00/5E/B0/wKgJ8VrawwayoRrUAGPyTZBiQzw439.m4a\r\n第二十节 议会风波$http://audio.xmcdn.com/group40/M02/25/91/wKgJT1rawfWjytY8AGVEC37YNPM085.m4a\r\n第二十一节 帝国$http://audio.xmcdn.com/group40/M06/26/76/wKgJVFraw6HRt3beAGT0vYIYILw163.m4a\r\n第二十二节 寡头末日$http://audio.xmcdn.com/group42/M05/60/AB/wKgJ9FrawmKgv4X7AGW96-B2Qtw008.m4a\r\n第二十三节 金元$http://audio.xmcdn.com/group41/M00/5E/DD/wKgJ8lrawwyiBUQEAGMu_Zu6gPQ890.m4a\r\n第二十四节 皇帝的后台$http://audio.xmcdn.com/group42/M04/60/BF/wKgJ9Fraw0XTvag_AGI-Yh9skH0029.m4a\r\n第二十五节 京城之夜$http://audio.xmcdn.com/group41/M01/5E/B5/wKgJ8Vraw2-R_YoaAGLuYgzix10872.m4a\r\n第二十六节 保证金$http://audio.xmcdn.com/group40/M00/26/66/wKgJVFrawqvCYhX4AGKcW9Fh7xc060.m4a\r\n第二十七节 没有硝烟的战斗$http://audio.xmcdn.com/group42/M02/60/B9/wKgJ9Frawt7D_1SRAGRXnFdULYA329.m4a\r\n第二十八节 收购$http://audio.xmcdn.com/group42/M05/60/A6/wKgJ9FrawknwWMc-AGDPEPpjP_o241.m4a\r\n第二十九节 帝国警察$http://audio.xmcdn.com/group41/M04/5E/9F/wKgJ8VrawnfzZuCiAGXs565Yjes024.m4a\r\n第三十节 军队的基础$http://audio.xmcdn.com/group42/M06/60/D1/wKgJ9FraxELBPvYCAGUgyvBsWVM844.m4a\r\n第三十一节 帝国的利刃$http://audio.xmcdn.com/group42/M0A/60/ED/wKgJ9FraxXvga3wUAGRTNksaZHU091.m4a\r\n第三十二节 未来海军$http://audio.xmcdn.com/group40/M0B/26/7F/wKgJVFraxA7j-rD7AGTESWCdxCU218.m4a\r\n第三十三节 外戚$http://audio.xmcdn.com/group40/M08/26/98/wKgJVFraxQmAJHYMAGSp2RNYeBQ672.m4a\r\n第三十四节 赏赐$http://audio.xmcdn.com/group41/M03/5E/DB/wKgJ8VraxTHh-zcvAGJtKViNsjw432.m4a\r\n第三十五节 柴国公$http://audio.xmcdn.com/group41/M05/5F/0A/wKgJ8lraxU_jFk55AGQgCDlhgwo839.m4a\r\n第三十六节 帝国皇室$http://audio.xmcdn.com/group41/M08/5E/D0/wKgJ8VraxLeSo8M8AGZDi2y9XoU790.m4a\r\n第三十七节 股权$http://audio.xmcdn.com/group42/M01/5C/19/wKgJ81raxN3CpOMdAGOVyE0EE4M542.m4a\r\n第三十八节 远航$http://audio.xmcdn.com/group42/M09/5C/03/wKgJ81raw9Hyip5fAGRX0sqcecU320.m4a\r\n第三十九节 工业中心$http://audio.xmcdn.com/group40/M07/25/C6/wKgJT1raxHjBdroVAGW6_G9PTx8356.m4a\r\n第四十节 南京$http://audio.xmcdn.com/group42/M02/5C/27/wKgJ81raxZqCYJ2mAGUoJOBlRlY632.m4a\r\n第四十一节 开明地主$http://audio.xmcdn.com/group41/M09/5E/F5/wKgJ8lraxDqjSEgIAGOBOkvPxxg262.m4a\r\n第四十二节 肃贪$http://audio.xmcdn.com/group42/M03/5B/E6/wKgJ81rawsuw-DNcAGWyK_P-Xv4861.m4a\r\n第四十三节 柴氏家族$http://audio.xmcdn.com/group40/M06/25/B6/wKgJT1raw53DN6uxAGV9TLSdOL0130.m4a\r\n第四十四节 朱文正的报告$http://audio.xmcdn.com/group42/M09/5C/03/wKgJ81raw9KDI_XmAGMu_YxBxgo003.m4a\r\n第四十五节 夜宴$http://audio.xmcdn.com/group41/M02/5E/C0/wKgJ8Vraw_eyx0GhAGNJbR2IFs0777.m4a\r\n第四十六节 赌徒$http://audio.xmcdn.com/group40/M05/25/B1/wKgJT1rawzDDpfxzAGdajDpBir8853.m4a\r\n第四十七节 局$http://audio.xmcdn.com/group41/M01/5E/E1/wKgJ8lraw2rD-UCsAGJXJFVpRZA321.m4a\r\n第四十八节 家乱$http://audio.xmcdn.com/group41/M04/5E/A8/wKgJ8VrawpqztzTyAGMNOLrktQ8449.m4a\r\n第四十九节 强买强卖$http://audio.xmcdn.com/group41/M00/5E/D9/wKgJ8lrawvvD00kxAGaFndygKgQ462.m4a\r\n第五十节 军火案$http://audio.xmcdn.com/group42/M01/5C/18/wKgJ81raxNuTw3FdAGao3hUz7u4603.m4a\r\n第五十一节 皇帝的权柄$http://audio.xmcdn.com/group41/M06/5E/EA/wKgJ8Vraxd6wVCZ7AGQMucR_eDs506.m4a\r\n第五十二节 好色之徒$http://audio.xmcdn.com/group41/M08/5E/CD/wKgJ8VraxKvzJdNjAGa3jdLftQo937.m4a\r\n第五十三节 制罪$http://audio.xmcdn.com/group42/M0A/60/EA/wKgJ9FraxW7wU1wcAGQSm73nOng375.m4a\r\n第五十四节 经济案件$http://audio.xmcdn.com/group42/M0B/60/EF/wKgJ9FraxZHwTpFxAGbw0pPh0ak149.m4a\r\n第五十五节 皇后的选择$http://audio.xmcdn.com/group40/M0A/25/E9/wKgJT1raxbqgeO4iAGHLoqo_VFU993.m4a\r\n第五十六节 柴家的没落$http://audio.xmcdn.com/group41/M03/5E/D8/wKgJ8VraxSaStRLFAGZPSzWf890128.m4a\r\n第五十七节 整合浪潮$http://audio.xmcdn.com/group41/M05/5F/09/wKgJ8lraxUnBrYiyAGG3FCtU1bc813.m4a\r\n第五十八节 国家垄断$http://audio.xmcdn.com/group40/M07/26/84/wKgJVFraxHDQIpjvAGYNNYQ3_rk201.m4a\r\n第五十九节 失去的珍贵$http://audio.xmcdn.com/group40/M08/25/D8/wKgJT1raxQCwTWEHAGEPq6WO4_g544.m4a\r\n第六十节 现代医学之父$http://audio.xmcdn.com/group41/M04/5E/A2/wKgJ8VrawoLAVw_vAGHx0afXM7M765.m4a\r\n第六十一节 后宫风波$http://audio.xmcdn.com/group40/M07/26/84/wKgJVFraxHCSeyrmAGXLI_COels934.m4a\r\n第六十二节 系铃解铃$http://audio.xmcdn.com/group41/M00/5E/D7/wKgJ8lrawvPRW-1bAGTNFo1LMzw551.m4a\r\n第六十三节 和解$http://audio.xmcdn.com/group42/M09/60/CB/wKgJ9Fraw7-zbM9LAGgd2NXBUYI057.m4a\r\n第六十四节 帝国医学院$http://audio.xmcdn.com/group41/M02/5E/BE/wKgJ8Vraw-6SpS57AGU5wh7zgug849.m4a\r\n第六十五节 骚动$http://audio.xmcdn.com/group41/M09/5E/C9/wKgJ8VraxDrzu2vHAGTNFnDrXos059.m4a\r\n第六十六节 算计与被算计$http://audio.xmcdn.com/group42/M03/5B/F6/wKgJ81raw1bhjWdKAGKn5bA007U934.m4a\r\n第六十七节 太子$http://audio.xmcdn.com/group41/M01/5E/BA/wKgJ8Vraw4Lhy6MoAGO793Ry4qI055.m4a\r\n第六十八节 童子军$http://audio.xmcdn.com/group42/M02/60/B1/wKgJ9FrawsKQMA6fAGYWBq8_Q0I006.m4a\r\n第六十九节 顾成林回国$http://audio.xmcdn.com/group40/M05/26/6E/wKgJVFrawyLDdDRdAGPMVAMIaCY942.m4a\r\n第七十节 顾成林的婚事$http://audio.xmcdn.com/group42/M01/60/E2/wKgJ9FraxNWhxK_hAGMdX8BROMw391.m4a\r\n第七十一节 拉郎配$http://audio.xmcdn.com/group40/M08/26/96/wKgJVFraxP3zc9YKAGNGfp93QDM977.m4a\r\n第七十二节 小亚细亚风云$http://audio.xmcdn.com/group41/M08/5E/FB/wKgJ8lraxLHB9F8IAGJOUzJy9Us951.m4a\r\n第一节 第五重骑兵军$http://audio.xmcdn.com/group40/M03/49/33/wKgJT1rccavg_zLDAGKAPs9dQAI849.m4a\r\n第二节 初次交锋$http://audio.xmcdn.com/group41/M04/82/3B/wKgJ8VrccOHgQK09AGGVSyLVw9Q517.m4a\r\n第三节 骑兵立威$http://audio.xmcdn.com/group42/M09/7F/1E/wKgJ81rccRewY9vmAGUa7Po_lwE003.m4a\r\n第四节 马枪的威力$http://audio.xmcdn.com/group41/M03/82/4F/wKgJ8VrccY-SHq3GAD3wc_9YFFo194.m4a\r\n第五节 哈桑的感激$http://audio.xmcdn.com/group41/M03/82/84/wKgJ8lrccaGjPAU5AGM8NX37wiA921.m4a\r\n第六节 封侯进爵$http://audio.xmcdn.com/group40/M01/49/B4/wKgJVFrccQDyZG3tAGYnpFfG5jk670.m4a\r\n第七节 将军情感$http://audio.xmcdn.com/group42/M09/7F/1A/wKgJ81rccRCiG0FlAGYQJCAlvsM235.m4a\r\n第八节 王室斗争$http://audio.xmcdn.com/group41/M04/82/5F/wKgJ8lrccNCzBqwbAGKXvwmb2-U566.m4a\r\n第九节 节外生枝$http://audio.xmcdn.com/group40/M01/49/10/wKgJT1rccPTjaZoXAGHKKhQ-9gY955.m4a\r\n第十节 谁是凶手$http://audio.xmcdn.com/group40/M06/49/1E/wKgJT1rccUCDWeCIAGXeOB0IawM631.m4a\r\n第十一节 三王子的身世$http://audio.xmcdn.com/group41/M03/82/7A/wKgJ8lrccYzxy5Z6AGGPbfJDRAs167.m4a\r\n第十二节 大敌来临$http://audio.xmcdn.com/group42/M05/84/05/wKgJ9FrccS7DL2HmAGJkWJuyIkI642.m4a\r\n第十三节 王子之心$http://audio.xmcdn.com/group41/M00/82/73/wKgJ8lrccWjjwDxOAGbcd_3yC1w322.m4a\r\n第十四节 奥斯曼近卫军$http://audio.xmcdn.com/group40/M0A/49/C3/wKgJVFrccXXyGLs-AGL1uGYRacI177.m4a\r\n第十五节 西域雄师$http://audio.xmcdn.com/group40/M0A/49/2B/wKgJT1rccYCCCvAeAGMKfxNWnEQ922.m4a\r\n第十六节 羊群中的雄狮$http://audio.xmcdn.com/group42/M08/84/0E/wKgJ9FrccVCzuVLRAGRfLDrXgFQ766.m4a\r\n第十七节 雷霆之威$http://audio.xmcdn.com/group41/M00/82/6D/wKgJ8lrccVuRNt6aAGFgcbyR_hE954.m4a\r\n第十八节 杨天奉的老办法$http://audio.xmcdn.com/group42/M04/7F/25/wKgJ81rccSLhg3G-AGUa7LmicQU439.m4a\r\n第十九节 最厉害的军团$http://audio.xmcdn.com/group40/M06/49/C1/wKgJVFrccUqTWF47AGTRgK-zCkk649.m4a\r\n第二十节 沸腾的夜晚$http://audio.xmcdn.com/group41/M04/82/3E/wKgJ8VrccOeDVCk1AGIcZ9hKqwQ885.m4a\r\n第二十一节 紧急驰援$http://audio.xmcdn.com/group42/M0A/7F/6E/wKgJ81rccujQd4HiAGI86_4h4ZU568.m4a\r\n第二十二节 军魂$http://audio.xmcdn.com/group40/M04/49/DE/wKgJVFrcchzR-A_GAGNSPqN83M4854.m4a\r\n第二十三节 天平上的砝码$http://audio.xmcdn.com/group42/M01/7F/5D/wKgJ81rccnuxrvD9AGQ6PquRluc015.m4a\r\n第二十四节 勇追穷寇$http://audio.xmcdn.com/group40/M09/4A/01/wKgJVFrccp-Cdu_pAGLVa0u_0mM759.m4a\r\n第二十五节 敌人崩溃$http://audio.xmcdn.com/group42/M0A/84/43/wKgJ9Frcctjym5rwAGJl05Skq_w699.m4a\r\n第二十五节 敌人崩溃(1)$http://audio.xmcdn.com/group41/M01/82/79/wKgJ8Vrccsaw4vKHAGJl018yzKM281.m4a\r\n第二十六节 荣耀$http://audio.xmcdn.com/group40/M04/49/49/wKgJT1rccjSwnUn-AGMF32jQ_jM058.m4a\r\n第二十七节 王位之争$http://audio.xmcdn.com/group41/M05/82/6D/wKgJ8Vrcck2hkMBSAGXYWrhI4ro109.m4a\r\n第二十八节 最强的竞争者$http://audio.xmcdn.com/group41/M02/82/66/wKgJ8VrcchDiu2X4AGMx7LnFbR4839.m4a\r\n第二十九节 大王子$http://audio.xmcdn.com/group40/M04/49/E6/wKgJVFrcciyBy8jaAGERI700oSA023.m4a\r\n第三十节 皇帝的安排$http://audio.xmcdn.com/group41/M09/82/B9/wKgJ8lrccyXCh8P_AGFXoM_ZoOs741.m4a\r\n第三十一节 国王的选择$http://audio.xmcdn.com/group40/M08/49/80/wKgJT1rcc6TxZ1O2AGOUUD6nsHo884.m4a\r\n第三十二节 愚忠$http://audio.xmcdn.com/group42/M0B/84/57/wKgJ9FrccxmBFUKeAGKZNhmVx9Y319.m4a\r\n第三十三节 理想与欲望$http://audio.xmcdn.com/group42/M07/84/5F/wKgJ9Frcc3OAiBgZAGPoBYOyu14699.m4a\r\n第三十四节 实力说服$http://audio.xmcdn.com/group42/M07/84/67/wKgJ9Frcc4PS8hX1AGMql2mXp9E788.m4a\r\n第三十五节 分权$http://audio.xmcdn.com/group42/M07/84/6E/wKgJ9Frcc5LSlCL8AGRI7ZynDy0635.m4a\r\n第三十六节 王子议事团$http://audio.xmcdn.com/group40/M00/4A/11/wKgJVFrcc1TT29xgAGK1U59KeF4967.m4a\r\n第三十六节 王子议事团(1)$http://audio.xmcdn.com/group41/M09/82/C9/wKgJ8lrcc0WRA8uKAGK1HSiVghU027.m4a\r\n第三十七节 王太子$http://audio.xmcdn.com/group40/M00/4A/17/wKgJVFrcc2PQgQldAGUlMeO_Z7Q954.m4a\r\n第三十八节 敌情$http://audio.xmcdn.com/group41/M06/82/AF/wKgJ8lrccwSBilj4AGT6nyDvgKg591.m4a\r\n第三十九节 大战准备$http://audio.xmcdn.com/group41/M09/82/92/wKgJ8VrcczPzeaavAGQMucT4eA8321.m4a\r\n第四十节 志愿军$http://audio.xmcdn.com/group41/M0B/82/A1/wKgJ8Vrcc7PwWKT0AGQrj9Om5Ys936.m4a\r\n第四十一节 高强度训练$http://audio.xmcdn.com/group41/M09/82/8F/wKgJ8Vrccyyh2if8AGS-Zise4bs132.m4a\r\n第四十二节 军械革命$http://audio.xmcdn.com/group42/M01/7F/5C/wKgJ81rccnmy6JR3AGYUjmgM5II460.m4a\r\n第四十三节 从阅兵场到前线$http://audio.xmcdn.com/group41/M01/82/74/wKgJ8VrccrvhLkMxAGT2NIqw4lU710.m4a\r\n第四十四节 主动迎敌$http://audio.xmcdn.com/group42/M0A/7F/67/wKgJ81rcctejJvyTAGK4DFWVdoI747.m4a\r\n第四十五节 鹰击长空$http://audio.xmcdn.com/group41/M06/82/AC/wKgJ8lrccv-Clgl2AGRZGIKTB5k641.m4a\r\n第四十六节 愤怒的苏丹$http://audio.xmcdn.com/group40/M09/49/5C/wKgJT1rccpSwFohJAGNxFF4DDGA889.m4a\r\n第四十七节 死神在舞蹈$http://audio.xmcdn.com/group40/M09/49/66/wKgJT1rccqyD1ZQGAGPNlQD-2as422.m4a\r\n第四十八节 坟墓$http://audio.xmcdn.com/group42/M00/84/37/wKgJ9FrccmiCHjJkAGfIrEf18cs901.m4a\r\n第四十九节 反击$http://audio.xmcdn.com/group40/M09/49/F4/wKgJVFrccoShzqe-AGO007zhCiQ405.m4a\r\n第五十节 纵火焚城$http://audio.xmcdn.com/group42/M07/84/6A/wKgJ9Frcc4rTPNJNAGYtgmTWLek808.m4a\r\n第五十一节 撤退$http://audio.xmcdn.com/group41/M0B/82/A4/wKgJ8Vrcc7nRICCqAGaCrjNqDZU944.m4a\r\n第五十二节 雄鹰展翅$http://audio.xmcdn.com/group40/M00/49/72/wKgJT1rcc1iwASP_AGMql2z0pTw491.m4a\r\n第一节 捷报连连$http://audio.xmcdn.com/group42/M0B/80/37/wKgJ81rcd4KAEyDAAGg5v_FSL54220.m4a\r\n第二节 龙入大海$http://audio.xmcdn.com/group41/M06/83/16/wKgJ8VrcdhLTBIHRAGSZsvw4ltg884.m4a\r\n第三节 德班解围战$http://audio.xmcdn.com/group41/M01/83/1B/wKgJ8VrcdnvzxsP5AGP8kjhiW6Q659.m4a\r\n第四节 战争警报$http://audio.xmcdn.com/group40/M02/4A/C3/wKgJVFrcd1ziBKixAGDX3T8hXQI701.m4a\r\n第五节 红夷的秘密$http://audio.xmcdn.com/group42/M09/80/31/wKgJ81rcd2yRMSaFAGN0A4h2tks131.m4a\r\n第六节 进军开普敦$http://audio.xmcdn.com/group42/M04/84/DB/wKgJ9Frcdk2T5Jb_AGNYHOqgeRQ559.m4a\r\n第七节 海上存在$http://audio.xmcdn.com/group42/M04/84/E6/wKgJ9FrcdmSAblOOAGRnx51Oyic798.m4a\r\n第八节 海上霸主$http://audio.xmcdn.com/group41/M06/83/3C/wKgJ8lrcdfeBW2AxAGVIcR9PQHw937.m4a\r\n第九节 远征出发点$http://audio.xmcdn.com/group42/M04/84/D9/wKgJ9FrcdknBxkDrAGLYWrM2-9I071.m4a\r\n第十节 红夷殖民地$http://audio.xmcdn.com/group42/M08/84/F2/wKgJ9FrcdtPRav_VAGPt49j4Nm4414.m4a\r\n第十一节 讹诈$http://audio.xmcdn.com/group41/M05/83/75/wKgJ8lrcd0jAZVgkAGHC0H19KXA086.m4a\r\n第十二节 红夷总督$http://audio.xmcdn.com/group40/M07/4A/A8/wKgJVFrcdqajluNUAGF_RxiBnYQ855.m4a\r\n第十三节 黑奴$http://audio.xmcdn.com/group42/M0A/84/FA/wKgJ9FrcdwrhvmNMAGGuQy4EAg8582.m4a\r\n第十四节 连恐带吓$http://audio.xmcdn.com/group40/M0B/4A/14/wKgJT1rcdxvhdycLAGJUZxHUb_Q168.m4a\r\n第十五节 土著的力量$http://audio.xmcdn.com/group42/M07/80/2D/wKgJ81rcdzPBNhrBAGM3zq9x_Bw632.m4a\r\n第十六节 鲸湾捕鲸业$http://audio.xmcdn.com/group40/M04/4A/10/wKgJT1rcduSzbcd8AGMNOIey-o0291.m4a\r\n第十七节 前进据点$http://audio.xmcdn.com/group41/M04/83/2E/wKgJ8VrcdvXSkUERAGOCskuQF0s796.m4a\r\n第十八节 荷兰人的选择$http://audio.xmcdn.com/group40/M07/4A/9E/wKgJVFrcdpCS6v6zAGO3kdfhHHE072.m4a\r\n第十九节 姻盟$http://audio.xmcdn.com/group42/M08/84/F1/wKgJ9Frcds_hHOuLAGKpXRX_o-s911.m4a\r\n第二十节 战略根据地$http://audio.xmcdn.com/group40/M03/4A/89/wKgJVFrcdiWiVJn_AGH6npObDpk445.m4a\r\n第二十一节 血金$http://audio.xmcdn.com/group41/M07/84/34/wKgJ8lrce6yTScCAAGL3MALqq1c516.m4a\r\n第二十二节 了解$http://audio.xmcdn.com/group41/M04/83/DF/wKgJ8VrcesXwTcSNAGS4iMj01as126.m4a\r\n第二十三节 大洋孤岛$http://audio.xmcdn.com/group42/M0B/85/BB/wKgJ9Frce0PgDZgmAGTbxd8_RVw090.m4a\r\n第二十四节 中转站$http://audio.xmcdn.com/group40/M0A/4B/77/wKgJVFrce2aQxFjgAGKyLq3RLQU776.m4a\r\n第二十五节 西行$http://audio.xmcdn.com/group40/M0A/4A/E6/wKgJT1rce4jy08gzAGLrc3xhMgI163.m4a\r\n第二十六节 罗卡斯岛海战$http://audio.xmcdn.com/group41/M08/84/1F/wKgJ8lrcevnQQWjMAGPU72CPQPo006.m4a\r\n第二十七节 纳塔尔围困战$http://audio.xmcdn.com/group41/M0A/83/F1/wKgJ8VrcezThWhlJAGIoI8DBzTc471.m4a\r\n第二十八节 海上掠夺战$http://audio.xmcdn.com/group41/M04/83/DA/wKgJ8VrcerrAe6UsAGQbaP-URGk867.m4a\r\n第二十九节 海上决战$http://audio.xmcdn.com/group40/M04/4A/B9/wKgJT1rcetSAAsUuAGQZ8B2Az54835.m4a\r\n第三十节 强攻布港$http://audio.xmcdn.com/group42/M08/81/09/wKgJ81rcfByh07LlAGW5hEfXvBM508.m4a\r\n第三十一节 海上单挑$http://audio.xmcdn.com/group41/M0A/84/4C/wKgJ8VrcfRjA4WZwAGIgzsV7bAk516.m4a\r\n第三十二节 乘胜追击$http://audio.xmcdn.com/group42/M08/85/D1/wKgJ9Frce_XRnYTMAGWKhLL17GU015.m4a\r\n第三十三节 兵临城下$http://audio.xmcdn.com/group42/M04/86/03/wKgJ9FrcfLHAejvoAGScopUMBxQ730.m4a\r\n第三十四节 不值得的胜利$http://audio.xmcdn.com/group41/M01/84/33/wKgJ8VrcfNCDn1hfAGN-S7p2AG0843.m4a\r\n第三十五节 美洲大陆立足点$http://audio.xmcdn.com/group42/M02/86/0B/wKgJ9FrcfPSSiIdFAGKaroNLejQ837.m4a\r\n第三十六节 探险家的足迹$http://audio.xmcdn.com/group41/M06/84/24/wKgJ8VrcfGTgniRsAGRwlKDTrgI681.m4a\r\n第三十七节 马岛之行$http://audio.xmcdn.com/group40/M03/4B/B7/wKgJVFrcfImRJ7ocAGGuQ5DMA9o122.m4a\r\n第三十八节 非洲战报$http://audio.xmcdn.com/group41/M09/84/3F/wKgJ8lrce9bjdzGLAGFvICQ8Sbo241.m4a\r\n第三十九节 兵发比奥科岛$http://audio.xmcdn.com/group40/M01/4B/9C/wKgJVFrcfD-Cs4hpAGM_WrjrH0g609.m4a\r\n第四十节 防御性海战$http://audio.xmcdn.com/group42/M06/81/3D/wKgJ81rcfV-TNd2ZAGSPaiqATH8301.m4a\r\n第四十一节 联合舰队的覆灭$http://audio.xmcdn.com/group40/M04/4A/AE/wKgJVFrcdt2St93wADf3z3nrcWk642.m4a\r\n第四十一节 联合舰队的覆灭(1)$http://audio.xmcdn.com/group41/M03/83/58/wKgJ8lrcdsDQjvWFAEXKvGagzNE318.m4a\r\n第四十二节 黄金海岸$http://audio.xmcdn.com/group42/M00/7F/E3/wKgJ81rcda6CJxKUAGZN1HzcBis034.m4a\r\n第四十三节 献媚$http://audio.xmcdn.com/group42/M04/84/D3/wKgJ9Frcdj2C8LSIAGISHgdTbRU710.m4a\r\n第四十四节 宝藏之城$http://audio.xmcdn.com/group40/M05/49/F9/wKgJT1rcdnHTATGQAGUyaeN_jqk859.m4a\r\n第四十五节 富裕的土地$http://audio.xmcdn.com/group40/M07/4A/06/wKgJT1rcdqOyzYhsAGUyaavpQ2w929.m4a\r\n第四十六节 北上的分歧$http://audio.xmcdn.com/group41/M05/82/FC/wKgJ8VrcddiQUZOrAGNfdbL6dD8770.m4a\r\n第四十七节 蒙罗维亚的教训$http://audio.xmcdn.com/group41/M06/83/13/wKgJ8VrcdguB8opbAGSCMjWBeB4969.m4a\r\n第四十八节 挺进$http://audio.xmcdn.com/group41/M00/82/F7/wKgJ8VrcdZyyKXQ3AGLDzKMPVho866.m4a\r\n第四十九节 国家意识$http://audio.xmcdn.com/group42/M00/7F/E6/wKgJ81rcdbSxAKw1AGBZlxAav7M423.m4a\r\n第五十节 不一般的盟约$http://audio.xmcdn.com/group41/M05/83/76/wKgJ8lrcd0mAi_AKAGJjFtEIugk721.m4a\r\n第五十一节 攻占佛得角群岛$http://audio.xmcdn.com/group42/M06/80/5F/wKgJ81rceD3Qd1i4AGSnIF459c4771.m4a\r\n第五十二节 岛链战略$http://audio.xmcdn.com/group42/M0A/84/FF/wKgJ9FrcdxbxnvXuAGHdQCtE0Uo204.m4a\r\n第五十三节 横扫诸岛$http://audio.xmcdn.com/group40/M00/4A/2E/wKgJT1rcd86QfrCvAGWHlemGu18977.m4a\r\n第五十四节 增援$http://audio.xmcdn.com/group40/M00/4A/35/wKgJT1rcd_bCQyygAGL9Eoq3QkM462.m4a\r\n第五十五节 英格兰的选则$http://audio.xmcdn.com/group42/M02/80/4B/wKgJ81rceBnwdr3TAGNrMotcHkA631.m4a\r\n第五十六节 荷兰使者$http://audio.xmcdn.com/group42/M0B/80/37/wKgJ81rcd4OQYo4uAGKfSiDqANQ661.m4a\r\n第五十七节 直布罗陀要塞$http://audio.xmcdn.com/group41/M08/83/86/wKgJ8lrcd6-hFLrlAGZN1ABOYd0627.m4a\r\n第一节 政府改革$http://audio.xmcdn.com/group40/M01/58/92/wKgJVFrdO_PBE-TpAGUPLAq5kYw962.m4a\r\n第二节 日不落帝国帝国$http://audio.xmcdn.com/group41/M08/90/E3/wKgJ8VrdOU7TKOt2AGYF38NXsIw377.m4a\r\n第三节 条条大路通京城$http://audio.xmcdn.com/group41/M04/90/F0/wKgJ8lrdOeCgtfxNAE7m08ol080250.m4a\r\n第三节 条条大路通京城(1)$http://audio.xmcdn.com/group41/M03/90/F0/wKgJ8lrdOcmiEGnpAEfZ6LlyB-c631.m4a\r\n第四节 工业帝国$http://audio.xmcdn.com/group42/M0A/8D/DE/wKgJ81rdO6DTzcarAGgw8rOTMt8960.m4a\r\n第五节 皇帝的想法$http://audio.xmcdn.com/group41/M02/91/10/wKgJ8lrdO8uCTW0vAGKWR4P3i8k734.m4a\r\n第六节 鞠躬尽瘁$http://audio.xmcdn.com/group42/M05/8D/B8/wKgJ81rdOXqSTk8bAGPPDfqxF5E546.m4a\r\n第七节 远征方略$http://audio.xmcdn.com/group40/M0B/57/B4/wKgJT1rdOaiANnumAGRTNr1fXw0469.m4a\r\n第八节 义务$http://audio.xmcdn.com/group41/M08/90/E1/wKgJ8VrdOUKBSHHNAGKQZT-0HeI901.m4a\r\n第九节 战争准备$http://audio.xmcdn.com/group40/M08/57/AB/wKgJT1rdOW3iNOnIAGYQJFAjtDc277.m4a\r\n第十节 战时法$http://audio.xmcdn.com/group41/M01/90/F5/wKgJ8VrdOmnz7g0rAGOS2eB3qZM884.m4a\r\n第十一节 大皇子的志向$http://audio.xmcdn.com/group40/M03/58/8B/wKgJVFrdO3rxLQBWAGIvfaGxQbo328.m4a\r\n第十二节 帝国远征军$http://audio.xmcdn.com/group42/M01/92/B6/wKgJ9FrdOjKRjKDOAGBrNZSF0dQ811.m4a\r\n第十三节 战争债券$http://audio.xmcdn.com/group40/M04/58/88/wKgJVFrdOxKhUSc4AGXnCTSE1RA379.m4a\r\n第十四节 全民动力$http://audio.xmcdn.com/group42/M0B/8D/D9/wKgJ81rdOz6gGKSBAGkksnXLHUc324.m4a\r\n第十五节 军官团$http://audio.xmcdn.com/group41/M00/91/0A/wKgJ8lrdO1qBR551AGPB1XLT-cw268.m4a\r\n第十六节 劳动力问题$http://audio.xmcdn.com/group42/M02/8D/CC/wKgJ81rdOqjhvAxZAGUMPU6lZfo765.m4a\r\n第十七节 外籍劳工法$http://audio.xmcdn.com/group41/M03/91/00/wKgJ8lrdOt-wDaYSAGShCIFJ4Pc171.m4a\r\n第十八节 妇女解放运动$http://audio.xmcdn.com/group40/M06/57/B6/wKgJT1rdOgvhnZQJAGVLYG7IJdI026.m4a\r\n第十九节 节外生枝$http://audio.xmcdn.com/group40/M07/58/79/wKgJVFrdOoiCFNVXAGPlFh4kcJA370.m4a\r\n第二十节 出征$http://audio.xmcdn.com/group42/M08/92/AA/wKgJ9FrdOVuhnxuWAGPMHmfSAXo568.m4a\r\n第二十一节 新生的近卫军$http://audio.xmcdn.com/group41/M01/90/FF/wKgJ8lrdOnmSKW3RAGMXgR6v1r0235.m4a\r\n第二十二节 前线$http://audio.xmcdn.com/group40/M0B/57/B0/wKgJT1rdOZmi6UhNAGO2FfyKod0668.m4a\r\n第二十三节 飞鹰神将$http://audio.xmcdn.com/group41/M04/90/F3/wKgJ8lrdOfGBvDyPAGJtKexvDQ8773.m4a\r\n第二十四节 鸿门宴$http://audio.xmcdn.com/group40/M06/57/B8/wKgJT1rdOhXzPqH-AGJwGNHQxSU388.m4a\r\n第二十五节 惊天密闻$http://audio.xmcdn.com/group42/M01/92/B8/wKgJ9FrdOjzBCv60AGJJ7Gb1K74562.m4a\r\n第二十六节 单刀赴会$http://audio.xmcdn.com/group42/M04/92/B0/wKgJ9FrdObjxr-CrAGGlcouvecQ773.m4a\r\n第二十七节 黛姬王后$http://audio.xmcdn.com/group42/M02/8D/BD/wKgJ81rdOdCAKU6vAGF0_m7X-DU234.m4a\r\n第二十八节 秘密侦察$http://audio.xmcdn.com/group41/M08/90/E6/wKgJ8VrdOYnz3xzvAGG3FB1U250372.m4a\r\n第二十九节 阴谋的舞场$http://audio.xmcdn.com/group40/M0B/57/B4/wKgJT1rdOajzZLJpAGOFoY3OUQM039.m4a\r\n第三十节 将计就计$http://audio.xmcdn.com/group40/M04/58/87/wKgJVFrdOw3y-RyzAGI1kawIqQc843.m4a\r\n第三十一节 民族与宗教$http://audio.xmcdn.com/group42/M01/92/BD/wKgJ9FrdOlWxVcUeAGQqF0u0jXU446.m4a\r\n第三十二节 皇帝的战争宣言$http://audio.xmcdn.com/group41/M03/90/F9/wKgJ8VrdOtuRA0hbAGbJK9gNEow675.m4a\r\n第三十三节 王国的继承人$http://audio.xmcdn.com/group40/M01/58/95/wKgJVFrdPAPj62tLAGP8kveLLQ4676.m4a\r\n第三十四节 南征北伐$http://audio.xmcdn.com/group40/M02/58/99/wKgJVFrdPB_CjHE8AGUQpDrjJGQ902.m4a\r\n第三十五节 大沙漠$http://audio.xmcdn.com/group40/M02/57/E2/wKgJT1rdPC-Qv2woAGM3zhdPhkE245.m4a\r\n第三十六节 阿拉伯之毒$http://audio.xmcdn.com/group40/M03/58/8E/wKgJVFrdO4XzDqMfAGEJzVBOp1Q674.m4a\r\n第三十七节 接敌$http://audio.xmcdn.com/group41/M02/91/0F/wKgJ8lrdO8XxYgerAGDJLjEIZDU205.m4a\r\n第三十八节 骑兵火力线$http://audio.xmcdn.com/group42/M02/92/BE/wKgJ9FrdOqKj-6blAGZcgxZMOQk270.m4a\r\n第三十九节 时间差$http://audio.xmcdn.com/group41/M00/91/07/wKgJ8lrdO0rS8urmAGKk9vS0-t0285.m4a\r\n第四十节 进军麦加$http://audio.xmcdn.com/group41/M06/91/11/wKgJ8VrdPEjhDuqLAGOKB1LZniE529.m4a\r\n第四十一节 炮火下的圣城$http://audio.xmcdn.com/group40/M02/58/9B/wKgJVFrdPCuQyDiVAGEXBd543X0229.m4a\r\n第四十二节 粉碎的真主$http://audio.xmcdn.com/group41/M01/90/FF/wKgJ8lrdOnmAk6LLAGJ1-jWfup8675.m4a\r\n第四十三节 阿拉的化身$http://audio.xmcdn.com/group41/M00/91/08/wKgJ8VrdO2zwyxTAAGL1uKujkSo106.m4a\r\n第四十四节 顽固的敌人$http://audio.xmcdn.com/group42/M0A/92/D9/wKgJ9FrdO7mh6WCTAGPgq_r5iQA222.m4a\r\n第四十五节 海陆联合$http://audio.xmcdn.com/group40/M01/57/D9/wKgJT1rdO_jSpNYbAGIgzjw_tT0066.m4a\r\n第四十六节 精心烹制的诱饵$http://audio.xmcdn.com/group41/M03/90/F9/wKgJ8VrdOtvQOiTOAGXLI0tbDDw533.m4a\r\n第四十七节 番号的意义$http://audio.xmcdn.com/group42/M08/8D/D5/wKgJ81rdOx3xKrejAD-XXIu-lso872.m4a\r\n第四十七节 番号的意义(1)$http://audio.xmcdn.com/group40/M04/57/C7/wKgJT1rdOvvSRJjvAD9WvVSkNqI205.m4a\r\n第四十八节 咬钩$http://audio.xmcdn.com/group41/M01/90/F3/wKgJ8VrdOl6wObpeAGISHqmLJIQ065.m4a\r\n第四十九节 最强的组合$http://audio.xmcdn.com/group42/M02/92/BE/wKgJ9FrdOqSBiZG_ADnCK8tmXf8223.m4a\r\n第四十九节 最强的组合(1)$http://audio.xmcdn.com/group41/M05/91/2C/wKgJ8lrdPU2iG7N0AERFmC1oNGY611.m4a\r\n第五十节 赶尽杀绝$http://audio.xmcdn.com/group41/M07/91/18/wKgJ8VrdPJaA7nCVAGVJ6ZtXyXg832.m4a\r\n第五十一节 陆海联合战斗$http://audio.xmcdn.com/group42/M0B/8D/FC/wKgJ81rdPRjiQuIlAGSN8mA3Mvc127.m4a\r\n第五十二节 步兵的攻击力$http://audio.xmcdn.com/group42/M03/8D/EF/wKgJ81rdPHyw4lIfAGRwlA7hlqE135.m4a\r\n第五十三节 战役收尾$http://audio.xmcdn.com/group41/M0A/91/25/wKgJ8lrdPNbiNtfaAGQnKLi5mTw283.m4a\r\n第五十四节 扬帆出海$http://audio.xmcdn.com/group40/M08/57/EC/wKgJT1rdPOTDES0LAGSCMoy7Ghk899.m4a\r\n第五十五节 异姓不王$http://audio.xmcdn.com/group40/M08/57/EE/wKgJT1rdPPKhYi_RAGIfjIecJ7s357.m4a\r\n第五十六节 克里特岛的迷茫$http://audio.xmcdn.com/group40/M00/57/E7/wKgJT1rdPLbS9v9iAGSfkR62dAk720.m4a\r\n第五十七节 雷火之锤$http://audio.xmcdn.com/group41/M0A/91/1E/wKgJ8VrdPMuAG4OhAGBiZBzXIEY237.m4a\r\n第五十八节 扫荡爱琴海$http://audio.xmcdn.com/group41/M06/91/15/wKgJ8VrdPFiDO8QUAGGLB4EUEBY092.m4a\r\n第五十九节 奥斯曼舰队$http://audio.xmcdn.com/group41/M07/91/21/wKgJ8lrdPKSgVoF9AGEXBYeYyhE994.m4a\r\n第六十节 达达尼尔海战$http://audio.xmcdn.com/group42/M00/8D/C7/wKgJ81rdOkmSWpQNAGLogDznKIM270.m4a\r\n第六十一节 希腊火$http://audio.xmcdn.com/group42/M07/92/E8/wKgJ9FrdPImxRJ6uAGG7ex4oxaA689.m4a\r\n第六十二节 海面下的杀手$http://audio.xmcdn.com/group42/M08/92/C8/wKgJ9FrdOxfRQUisAGIfViaRj6Q400.m4a\r\n第六十三节 炮轰伊斯兰堡$http://audio.xmcdn.com/group40/M02/58/97/wKgJVFrdPBjisuRdAGDlFc6dUOI662.m4a\r\n第六十四节 大鼓将军$http://audio.xmcdn.com/group41/M06/91/12/wKgJ8VrdPErj9iMtAGHRtlXEt5U639.m4a\r\n第六十五节 猛虎上岸$http://audio.xmcdn.com/group42/M04/92/E3/wKgJ9FrdPHGQDZKtAGGcpdaNJM8782.m4a\r\n第六十六节 血城$http://audio.xmcdn.com/group42/M03/8D/DC/wKgJ81rdO5iTxH3SAGJCyWftamw357.m4a\r\n第六十七节 肢解$http://audio.xmcdn.com/group41/M02/91/0F/wKgJ8VrdO92B0H59AGDNmbPiWRk895.m4a\r\n第六十八节 血泪运河$http://audio.xmcdn.com/group40/M04/57/C7/wKgJT1rdOvjiEeXIAGN-S-d5Qe8037.m4a\r\n第六十九节 东方归来$http://audio.xmcdn.com/group41/M00/91/07/wKgJ8lrdO0yQtKqRAGDPEFHzPNw008.m4a\r\n第七十节 发兵尼罗河$http://audio.xmcdn.com/group42/M01/8D/F7/wKgJ81rdPQOiGI87AGCaKnDK-Gg196.m4a\r\n第七十一节 攻占亚历山大港$http://audio.xmcdn.com/group40/M0B/58/B3/wKgJVFrdPWnwu1IvAGDMIWlb-G4165.m4a\r\n第七十二节 炮轰狮身人面相$http://audio.xmcdn.com/group41/M0A/91/25/wKgJ8lrdPNXAV76uAGAb63x9b64944.m4a\r\n第七十三节 前进的步伐$http://audio.xmcdn.com/group41/M05/91/27/wKgJ8VrdPUvBeJeMAGED65NUCYc716.m4a\r\n第七十四节 皇子陨落$http://audio.xmcdn.com/group40/M0B/57/F3/wKgJT1rdPVCgeKTyAGFvIDOQrlc975.m4a\r\n第七十六节 进军马德里$http://audio.xmcdn.com/group41/M05/91/20/wKgJ8VrdPTbD086iAGDR_28g95s103.m4a\r\n第七十五节 哀兵$http://audio.xmcdn.com/group40/M0B/58/B1/wKgJVFrdPVuRBrzpAGC-6o3CZ7M503.m4a\r\n第七十七节 消失的马德里$http://audio.xmcdn.com/group41/M05/91/22/wKgJ8VrdPTujI4xMAGJeebz_SYk957.m4a\r\n第七十八节 科尔多瓦战役$http://audio.xmcdn.com/group42/M06/8D/F4/wKgJ81rdPKvAmnXrAGEc49o81GM999.m4a\r\n第七十九节 攻打里斯本$http://audio.xmcdn.com/group42/M0B/8D/FF/wKgJ81rdPSXwNOO8AGKGIefiS6A110.m4a\r\n第八十节 炮轰伦敦塔$http://audio.xmcdn.com/group41/M02/91/16/wKgJ8lrdO-TgkSUaAF8cZ0sWhQM795.m4a\r\n第八十一节 北方来迅$http://audio.xmcdn.com/group40/M02/58/98/wKgJVFrdPB7R_yFdAGKfFHn7RA0533.m4a\r\n第八十二节 噩耗$http://audio.xmcdn.com/group42/M0A/92/D5/wKgJ9FrdO6yTlzX1AGD2t4ORkb4083.m4a\r\n大结局章：大明帝国$http://audio.xmcdn.com/group41/M00/91/07/wKgJ8VrdO2rT9DQOAGWn4ushK9k619.m4a', 'xml_8023', '2778', '', 'X', '', '1.0', 6, 0, 0, 0, 'xinmingshi', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(139, 24, '儿童睡前故事', '', '未知', '', '', '', '儿童睡前故事安利社数字化营销，让更多曾经的安利人回归。现在真是安利轻创时代的开始。一个手机，一台电脑在家运作安利既可成就梦想，自由自在，合适上班的你也合适生意的你也合适宝妈的你，更合适想创业的你。有需要了解安利数字化营销可以扫一扫二维码扫一扫了解更多安利数字化营销', 'http://imagev2.xmcdn.com/group41/M02/BA/89/wKgJ8lrSEZ-jftgBAAGzTCCmk9s326.jpg', '', 1530072223, 3, 0, 0, 0, 0, 1, 1, 8, 9, 'ting', '', '01.小小分享三个乞丐的命运$http://audio.xmcdn.com/group42/M00/B7/36/wKgJ81rSEs6wT2zJABcY4X0Fn-w816.m4a\r\n02.小小分享三只小兔$http://audio.xmcdn.com/group42/M00/BC/10/wKgJ9FrSEs3QN3njAB20GG9OTDQ291.m4a\r\n03.小小分享三头牛和狮子$http://audio.xmcdn.com/group42/M00/B7/36/wKgJ81rSEs2h_SncABRqo8HdTbo482.m4a\r\n04.小小分享不想冬眠的熊$http://audio.xmcdn.com/group42/M00/B7/36/wKgJ81rSEs2hN5ADAAvdmKJ07oY885.m4a\r\n05.小小分享不自量力的公羊$http://audio.xmcdn.com/group41/M06/BA/B4/wKgJ8lrSEtbAkkgaABkxqOSVTKE101.m4a\r\n07.小小分享勇敢的小仇尔卡$http://audio.xmcdn.com/group41/M06/BA/B4/wKgJ8lrSEtfDqCXUAB1LtgmZ74M080.m4a\r\n08.小小分享吹笛人$http://audio.xmcdn.com/group41/M06/BA/A7/wKgJ8VrSEtfBU4_AABciex2f_XE919.m4a\r\n09.小小分享哈哈笑的苦恼$http://audio.xmcdn.com/group41/M06/BA/A8/wKgJ8VrSEtrS-2FPABm5Fa9osGs801.m4a\r\n10.小小分享壮汉的力量$http://audio.xmcdn.com/group42/M06/B7/39/wKgJ81rSEuCgroJOACJ2pWVOU0E891.m4a\r\n11.小小分享学狗叫的小公鸡$http://audio.xmcdn.com/group42/M06/B7/38/wKgJ81rSEt7RguVgAA3vP8ms0OE544.m4a\r\n12.小小分享家狗和狼$http://audio.xmcdn.com/group42/M00/BC/15/wKgJ9FrSEuPzwbqUABBGTJVZudA625.m4a\r\n14.小小分享小乌龟找到了妈妈$http://audio.xmcdn.com/group42/M06/B7/3D/wKgJ81rSEujRNpt4ACNa8k1jcpE177.m4a\r\n15.小小分享小刺猬和小兔$http://audio.xmcdn.com/group42/M00/BC/18/wKgJ9FrSEuvDgf3pAB3UstP4OU8962.m4a\r\n16.小小分享小啄木鸟长大了$http://audio.xmcdn.com/group42/M00/BC/19/wKgJ9FrSEuuDw95kABOqk2eUjsc346.m4a\r\n17.小小分享小熊的请帖$http://audio.xmcdn.com/group42/M06/B7/3F/wKgJ81rSEu3ghCOIABSX-BgaEj4301.m4a\r\n18.小小分享小猪家的摇钱树$http://audio.xmcdn.com/group40/M06/80/F2/wKgJT1rSEvLgNIy3AB7PP7xNnjo423.m4a\r\n19.小小分享小猫花花和狐狸$http://audio.xmcdn.com/group40/M06/80/F2/wKgJT1rSEvDQxjW6AA1WaPveyuo000.m4a\r\n20.小小分享小猫送鱼$http://audio.xmcdn.com/group40/M06/81/CA/wKgJVFrSEvTBqrGvABJjY0D49Rc800.m4a\r\n21.小小分享小红马$http://audio.xmcdn.com/group40/M06/80/F4/wKgJT1rSEvaQI9G2ABQN8VN7iRQ495.m4a\r\n22.小小分享小蝌蚪找妈妈$http://audio.xmcdn.com/group40/M06/81/CD/wKgJVFrSEvqzimPmABuGGIOhH88465.m4a\r\n23.小小分享小鸡和狐狸$http://audio.xmcdn.com/group40/M06/80/F6/wKgJT1rSEvuTNSn6ABTkU-tu3Pw851.m4a\r\n24.小小分享徐文长竿上取物$http://audio.xmcdn.com/group40/M06/80/F7/wKgJT1rSEv2ijzn6ABEpQ9GOmmM449.m4a\r\n25.小小分享我长大了$http://audio.xmcdn.com/group41/M08/BA/B8/wKgJ8lrSEwGh1gbiABaPo7_Pzqk520.m4a\r\n26.小小分享树木在秋天写的信$http://audio.xmcdn.com/group41/M08/BA/B9/wKgJ8lrSEwTh_cRaABuTcp_U7KY516.m4a\r\n27.小小分享桂冠的故事$http://audio.xmcdn.com/group41/M06/BA/B1/wKgJ8VrSEw_iHKjqACCvgE6ABXA027.m4a\r\n28.小小分享毕加索与和平鸽$http://audio.xmcdn.com/group41/M06/BA/AE/wKgJ8VrSEwijWLXWABKNN8yem-Y850.m4a\r\n29.小小分享没牙齿的大老虎$http://audio.xmcdn.com/group41/M08/BA/BE/wKgJ8lrSEw3xONelABoj89JWOHM885.m4a\r\n30.小小分享潘多拉的魔盒$http://audio.xmcdn.com/group41/M06/BA/B0/wKgJ8VrSEw2Qn2rmABSJSIqcqpg527.m4a\r\n31.小小分享牛郎星与织女星$http://audio.xmcdn.com/group41/M08/BA/BF/wKgJ8lrSEw_jkH9ZABLXHqJ1bVM692.m4a\r\n32.小小分享狐狸和仙鹤交朋友$http://audio.xmcdn.com/group41/M08/BA/BF/wKgJ8lrSEw_xagxTAAxeqVsih7E562.m4a\r\n33.小小分享狐狸和小白兔$http://audio.xmcdn.com/group41/M06/BA/B3/wKgJ8VrSExLDn_qdABMZYS_4Xdo503.m4a\r\n34.小小分享狐狸狗熊和狼$http://audio.xmcdn.com/group42/M05/BC/1E/wKgJ9FrSExzz4Vd6ACWFtugiNW4379.m4a\r\n35.小小分享狐狸长角$http://audio.xmcdn.com/group42/M05/BC/1C/wKgJ9FrSExngS3DSABYwMnWViDI287.m4a\r\n36.小小分享狼和他的影子$http://audio.xmcdn.com/group42/M08/B7/41/wKgJ81rSExeSeb7FAAnhYGNwxbU335.m4a\r\n38.小小分享白色的乌龟$http://audio.xmcdn.com/group42/M05/BC/21/wKgJ9FrSEyOBUPIPACsf-37CYrc536.m4a\r\n39.小小分享皇帝的新装$http://audio.xmcdn.com/group42/M08/B7/46/wKgJ81rSEyOQ9jl0AB5tX7NT8R4343.m4a\r\n40.小小分享神奇的小袋子$http://audio.xmcdn.com/group42/M08/B7/48/wKgJ81rSEymRX7lYACcALSwZP4s652.m4a\r\n41.小小分享米开朗基罗的故事$http://audio.xmcdn.com/group42/M05/BC/22/wKgJ9FrSEyWwe6nZABJGujb1s_E664.m4a\r\n42.小小分享老虎同我讲话了$http://audio.xmcdn.com/group42/M08/B7/47/wKgJ81rSEyaS4mgNAA1q0K027f0988.m4a\r\n43.小小分享聪明的乌龟$http://audio.xmcdn.com/group40/M0A/81/CF/wKgJVFrSEyuSzgOYABzUpfwTTrs720.m4a\r\n44.小小分享聪明的小白兔智斗大灰狼$http://audio.xmcdn.com/group42/M05/BC/25/wKgJ9FrSEyrywuNTAA179nsrzxg688.m4a\r\n45.小小分享胖胖熊和他的伙伴们$http://audio.xmcdn.com/group40/M0A/80/F9/wKgJT1rSEy-hUSZ4ABnpNvgwpkw591.m4a\r\n47.小小分享蒙蒙敲门$http://audio.xmcdn.com/group40/M0A/80/FA/wKgJT1rSEzOxYUcGABrRjSF4u18779.m4a\r\n48.小小分享虎大王失鸡$http://audio.xmcdn.com/group40/M0A/81/D2/wKgJVFrSEzLSw7yxAApXbtEOdvQ505.m4a\r\n49.小小分享蚂蚁和大象摔跤$http://audio.xmcdn.com/group40/M0A/81/D4/wKgJVFrSEzaQhVWKABg698jxTbU162.m4a\r\n50.小小分享蜗牛和黄牛$http://audio.xmcdn.com/group40/M0A/81/D5/wKgJVFrSEzqR4d_-AB3cBkFgGOg035.m4a\r\n序$http://audio.xmcdn.com/group42/M04/8D/6A/wKgJ9Frcqt7BaPYSAAO96ngp78s664.m4a', 'xml_8023', '2777', '', 'E', '', '1.0', 8, 0, 0, 0, 'ertongshuiqiangushi', ''),
(140, 24, '阿含经故事选', '', '未知', '', '', '', '听佛陀讲最原味的佛法', 'http://imagev2.xmcdn.com/group42/M01/CA/72/wKgJ9FrF1RaCFezdAAFIxmbcTZM656.jpg', '', 1530072223, 6, 0, 0, 0, 0, 1, 1, 10, 3, 'ting', '', '第一篇 佛 001 怎样才是真正的赞叹佛陀？$http://audio.xmcdn.com/group40/M08/8F/0C/wKgJT1rF1lKSlI-UACbVl3RbKIU422.m4a\r\n第一篇 佛 002佛陀的修学历程$http://audio.xmcdn.com/group40/M00/D7/DC/wKgJT1rWjMOyqZBOALAn6r0xfiM837.m4a\r\n第一篇 佛 003佛陀的初转法*$http://audio.xmcdn.com/group41/M03/11/27/wKgJ8VrWjWjDSmOwAFnXHv-PRyc890.m4a\r\n第一篇 佛 004 拒絕利用神通傳教的佛陀$http://audio.xmcdn.com/group40/M09/53/67/wKgJVFrcrjTS3O85AFg14RV6moM726.m4a\r\n第一篇 佛 005 能成就无量福道教诫的教法$http://audio.xmcdn.com/group41/M02/8C/27/wKgJ8lrcrhGwNq18AGhkVT68F40136.m4a\r\n第一篇 佛 006 如何知道圣者$http://audio.xmcdn.com/group40/M07/1F/74/wKgJT1raeVmS2AamAC9x6w9vKKE265.m4a\r\n第一篇 佛 007 圣者的恬情淡泊性格$http://audio.xmcdn.com/group42/M05/55/A9/wKgJ81raeYLjKRI3AFsLR9poYcY574.m4a', 'xml_8023', '2775', '', 'A', '', '1.0', 9, 0, 0, 0, 'ahanjinggushixuan', ''),
(141, 24, '戴笠全传', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group37/M07/21/CD/wKgJoFpTMXriyPDyAAetb-lw2Zo909.jpg', '', 1530072223, 6, 0, 0, 0, 0, 1, 1, 4, 7, 'ting', '', '戴笠全传25$http://audio.xmcdn.com/group42/M0B/93/AF/wKgJ9FrdR3CDVsbKAMc3Bp6rrzk378.m4a\r\n戴笠全传24$http://audio.xmcdn.com/group41/M08/FD/6C/wKgJ8VrVlraSz4muAKZKxe0GekE136.m4a\r\n戴笠全传23$http://audio.xmcdn.com/group42/M05/74/35/wKgJ81rPAU3CT-7BANWxXYZvAfo915.m4a\r\n戴笠全传22杀害杨杏佛$http://audio.xmcdn.com/group40/M0B/39/61/wKgJVFrOuFmQqWzNANEElIWOJM0323.m4a\r\n戴笠全传21$http://audio.xmcdn.com/group41/M03/A0/B0/wKgJ8Vq0oquAroEUAOQnyc-_qIQ033.m4a\r\n戴笠全传20$http://audio.xmcdn.com/group40/M00/67/1D/wKgJVFq0gyPCnQ5HAKjTQYjMJOI316.m4a\r\n戴笠全传19$http://audio.xmcdn.com/group41/M06/43/0B/wKgJ8lqvKKmTIas0AOJYuCNcXv4547.m4a\r\n戴笠全传18$http://audio.xmcdn.com/group40/M01/C7/16/wKgJVFqrde7BTEBvAOK1VzUYyAI858.m4a\r\n戴笠全传17$http://audio.xmcdn.com/group42/M07/F2/37/wKgJ81qqdyyByLUrAOp1GH2JiQE612.m4a\r\n戴笠全传16$http://audio.xmcdn.com/group40/M03/B7/34/wKgJVFqqa2XTHvh9AQ11e2j1Das634.m4a\r\n戴笠全传15$http://audio.xmcdn.com/group40/M09/B4/92/wKgJVFqqWyjTaNj0ANGXbGQndc0718.m4a\r\n戴笠全传14追捕王亚樵$http://audio.xmcdn.com/group42/M0B/EB/A3/wKgJ81qqSzWxjnRkAPOpCqCqUa0710.m4a\r\n戴笠全传13$http://audio.xmcdn.com/group41/M06/D2/C9/wKgJ8Vqo9L_DhG5DAOoEBfjNDqc441.m4a\r\n戴笠全传12$http://audio.xmcdn.com/group41/M04/34/AA/wKgJ8VqfljHjgKBaANrKyetBRPU177.m4a\r\n戴笠全传11第四章$http://audio.xmcdn.com/group41/M00/2F/D4/wKgJ8VqfahyCg8oTAMMnXt9dDEA466.m4a\r\n戴笠全传10$http://audio.xmcdn.com/group41/M00/2D/BB/wKgJ8VqfVtnDH2_RAKzjS9z6ZMc576.m4a\r\n戴笠全传9$http://audio.xmcdn.com/group41/M0A/13/86/wKgJ8VqecT_xb060AOx9Na0KwS0486.m4a\r\n戴笠全传8$http://audio.xmcdn.com/group41/M09/FD/B8/wKgJ8VqdSnvg_iLTALnMWhCgKBc828.m4a\r\n戴笠全传7$http://audio.xmcdn.com/group41/M04/F6/83/wKgJ8lqdFw3yxMaEAPB69JQT6bw620.m4a\r\n戴笠全传6$http://audio.xmcdn.com/group39/M09/84/D2/wKgJnlpnDSGxKnCwAMnzg5ktjZ8108.m4a\r\n戴笠全传5$http://audio.xmcdn.com/group39/M09/81/38/wKgJnlpm8gGgEfFgAMSQnMmuibA680.m4a\r\n戴笠全传4$http://audio.xmcdn.com/group32/M01/9C/18/wKgJS1pfCmrzEecvAOdWQjiFpwY447.m4a\r\n戴笠全传3$http://audio.xmcdn.com/group36/M0B/B0/65/wKgJTVpTh-OjEFl3ANQgeFZlE70306.m4a\r\n戴笠全传2$http://audio.xmcdn.com/group37/M07/23/16/wKgJoFpTPguRsfB8ALdiJdX6Q2o551.m4a\r\n戴笠全传1$http://audio.xmcdn.com/group36/M03/55/C2/wKgJUlpTMd7zGmcrALsFJFyzYc0422.m4a', 'xml_8023', '2776', '', 'D', '', '1.0', 2, 0, 0, 0, 'dailiquanchuan', ''),
(142, 24, '英语朗读', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group42/M06/30/F4/wKgJ9Fq9mqbxQiw7AAKwVsIDIkQ690.jpg', '', 1530072223, 8, 0, 0, 0, 0, 1, 1, 3, 10, 'ting', '', '小王子第十二章un buveur$http://audio.xmcdn.com/group42/M08/8E/B9/wKgJ81rdSAHDPIXEAAm2WPT8M7A663.m4a\r\n莎士比亚第八章(2)$http://audio.xmcdn.com/group41/M0A/91/AF/wKgJ8VrdRMbgYiMZABPWI6TG4xk118.m4a\r\n莎士比亚第八章 （1）$http://audio.xmcdn.com/group42/M0A/41/96/wKgJ81rZUlizgdOQAAx0QkPoRQY302.m4a\r\n莎士比亚第七章下$http://audio.xmcdn.com/group40/M03/F8/5C/wKgJVFq9msrBV9B2ABDcBa3T2Bk319.m4a', 'xml_8023', '2774', '', 'Y', '', '1.0', 4, 0, 0, 0, 'yingyulangdu', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(143, 24, '重生之红星传奇', '', '未知', '', '', '', '一寸山河一寸血，历史都是血写成！ 国防大学研究生刘一民，在奥运安保值班时，与恐怖分子同归于尽，重生于红军长征的湘江战役新圩阻击战战场。从此，刘一民追随伟大的工农红军，以自己所学，弥补历史缺憾，走出了一条不一样的长征路，率雄狮健儿北上抗日战场，与日寇厮杀，与投降派斗智斗勇，演绎出了雄浑无俦、波澜壮阔的中国人民抗日历史新话剧！ 英雄儿女，爱恨情仇。铁马金戈，先烈大业与日月同辉；柔笛和声，凄美爱情并天地同寿！ 不一样的历史，不一样的英雄，一切尽在红星传奇！', 'http://imagev2.xmcdn.com/group7/M03/2E/F9/wKgDWlb1AazwmSaxAAO7M5CWGpU371.jpg', '', 1530072223, 0, 0, 0, 0, 0, 1, 1, 2, 7, 'ting', '', '重生之红星传奇01(粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M08/40/06/wKgDWlcH3cPwttCMAI92h1TU67M807.m4a\r\n重生之红星传奇02(粉丝QQ群：532909356)$http://audio.xmcdn.com/group10/M01/3A/41/wKgDZ1cH3lHgC6hYAJYwgrMwYUY418.m4a\r\n重生之红星传奇03(粉丝QQ群：532909356)$http://audio.xmcdn.com/group9/M05/3F/6D/wKgDZlcH3uXROiCKAJkf1uEhoJo892.m4a\r\n重生之红星传奇004(粉丝QQ群：532909356)$http://audio.xmcdn.com/group16/M01/40/23/wKgDalcJMdqwEA0tAJfurBqNgwM234.m4a\r\n重生之红星传奇05 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group10/M06/3B/41/wKgDZ1cJMuehPYTkAKKA1SAwAUU050.m4a\r\n重生之红星传奇06(粉丝QQ群：532909356)$http://audio.xmcdn.com/group13/M07/4B/14/wKgDXVcVxduQ7SFoAJRriwr4_iY822.m4a\r\n重生之红星传奇07(粉丝QQ群：532909356)$http://audio.xmcdn.com/group13/M08/4B/06/wKgDXlcVxc2AIoQAAJhSO1kltfk029.m4a\r\n重生之红星传奇08(粉丝QQ群：532909356)$http://audio.xmcdn.com/group14/M08/43/65/wKgDY1cLhNWjh3RNAJwqpTWHiYw127.m4a\r\n重生之红星传奇09(粉丝QQ群：532909356)$http://audio.xmcdn.com/group11/M08/4E/22/wKgDbVcM0xjDp69JAJmsahcwADQ667.m4a\r\n重生之红星传奇10(粉丝QQ群：532909356)$http://audio.xmcdn.com/group12/M08/42/E4/wKgDXFcM043A_z26AKIgEWcfows386.m4a\r\n重生之红星传奇11(粉丝QQ群：532909356)$http://audio.xmcdn.com/group11/M02/35/F6/wKgDa1cN5TOAEpx5AJgktoSdmSo361.m4a\r\n重生之红星传奇12(粉丝QQ群：532909356)$http://audio.xmcdn.com/group14/M09/46/C7/wKgDZFcPd6fSNY9SAJc6Id8f4OM884.m4a\r\n重生之红星传奇13(粉丝QQ群：532909356)$http://audio.xmcdn.com/group12/M08/46/42/wKgDXFcQry7yPmwYAJ1UL-pLs-0868.m4a\r\n重生之红星传奇14(粉丝QQ群：532909356)$http://audio.xmcdn.com/group8/M04/46/50/wKgDYVcQr9HCS0OUAJ_Dp-6-8zY511.m4a\r\n重生之红星传奇15(粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M01/48/35/wKgDaFcUTIKTrOqsAJykHRJClmE464.m4a\r\n重生之红星传奇16(粉丝QQ群：532909356)$http://audio.xmcdn.com/group14/M00/48/EA/wKgDY1cR8mqCboG3AKoDz2zxEXo034.m4a\r\n重生之红星传奇17 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M0B/4B/4F/wKgDX1cVxgSwRxr4AJsvh2NB6SQ897.m4a\r\n重生之红星传奇18(粉丝QQ群：532909356)$http://audio.xmcdn.com/group10/M03/45/EB/wKgDZ1cVxheA7ajVAKBgj1WPlhY532.m4a\r\n重生之红星传奇19(粉丝QQ群：532909356)$http://audio.xmcdn.com/group10/M01/43/7C/wKgDZ1cS_LODX9UFAJyuYvUuZIA502.m4a\r\n重生之红星传奇20(粉丝QQ群：532909356)$http://audio.xmcdn.com/group11/M0B/3C/AA/wKgDa1cVxgLz4LWlAJfraeef6iY252.m4a\r\n重生之红星传奇21(粉丝QQ群：532909356)$http://audio.xmcdn.com/group10/M02/49/22/wKgDaVcVxh-TFSrgAJegvwIwNIA501.m4a\r\n重生之红星传奇22(粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M04/49/A9/wKgDZVcV_X2gG_iGAJm7LYfHfhs480.m4a\r\n重生之红星传奇23(粉丝QQ群：532909356)$http://audio.xmcdn.com/group10/M03/45/EC/wKgDZ1cVxi2RVjhLAJjmewC9wXM700.m4a\r\n重生之红星传奇24(粉丝QQ群：532909356)$http://audio.xmcdn.com/group12/M05/49/4A/wKgDXFcUULviQraCAJj3_aOnJoI648.m4a\r\n重生之红星传奇25(粉丝QQ群：532909356)$http://audio.xmcdn.com/group9/M01/4A/F2/wKgDZlcVmbrApBvGAJj6-M6cZk0593.m4a\r\n重生之红星传奇26(粉丝QQ群：532909356)$http://audio.xmcdn.com/group11/M0A/3D/05/wKgDa1cWFZbDvly9AJjnzlpVSWM309.m4a\r\n重生之红星传奇27(粉丝QQ群：532909356)$http://audio.xmcdn.com/group9/M01/4C/CB/wKgDYlcXpfqSa4zUAJi5Re8-Yjs764.m4a\r\n重生之红星传奇28(粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M05/4C/DB/wKgDaFcZb93SwOzIAJi8BTq4j5E223.m4a\r\n重生之红星传奇29(粉丝QQ群：532909356)$http://audio.xmcdn.com/group8/M02/4E/32/wKgDYVcZmH3A2UlmAJsINIDNcno312.m4a\r\n重生之红星传奇30(粉丝QQ群：532909356)$http://audio.xmcdn.com/group16/M01/4F/FA/wKgDalcbVeaD9d2kAJfPojjGvN4442.m4a\r\n重生之红星传奇31 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M02/50/43/wKgDaFcc_6DAnPc9AJnf8bKPvlI530.m4a\r\n重生之红星传奇32(粉丝QQ群：532909356)$http://audio.xmcdn.com/group12/M0B/52/8C/wKgDXFceuOCzflq0AJg8Rhhknsg264.m4a\r\n重生之红星传奇33(粉丝QQ群：532909356)$http://audio.xmcdn.com/group16/M03/54/79/wKgDalcgRamTzcgcAJkchUtu3JM473.m4a\r\n重生之红星传奇34(粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M0A/54/60/wKgDZVchieexPOGfAJn9CyLNjZE872.m4a\r\n重生之红星传奇35(粉丝QQ群：532909356)$http://audio.xmcdn.com/group13/M04/57/26/wKgDXVcitgaiGN7SAJvIOa1EMX4927.m4a\r\n重生之红星传奇36(粉丝QQ群：532909356)$http://audio.xmcdn.com/group16/M05/58/5D/wKgDbFckOfTCpf-uAJnAz1hWb6M917.m4a\r\n重生之红星传奇37(粉丝QQ群：532909356)$http://audio.xmcdn.com/group16/M02/59/15/wKgDbFck-Syi7kjoAJx1REsb0Bk336.m4a\r\n重生之红星传奇38(粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M01/59/B0/wKgDWlck-Rnwy878AJiImloY7Bo034.m4a\r\n重生之红星传奇39(粉丝QQ群：532909356)$http://audio.xmcdn.com/group13/M06/59/2A/wKgDXVck-jvhjzn8AJqBKJlvneQ594.m4a\r\n重生之红星传奇40(粉丝QQ群：532909356) $http://audio.xmcdn.com/group14/M04/5B/55/wKgDY1cmL1Own9rYAJmpe2D1BKI913.m4a\r\n重生之红星传奇41(粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M05/5B/AE/wKgDX1cnWnPiELZqAJlNEfyGs8I247.m4a\r\n重生之红星传奇42(粉丝QQ群：532909356)$http://audio.xmcdn.com/group10/M06/59/8D/wKgDaVcngviTooLUAJpKymV4ono038.m4a\r\n重生之红星传奇43(粉丝QQ群：532909356)$http://audio.xmcdn.com/group12/M06/5C/43/wKgDXFco1UWD7G12AJsoeJ625GE329.m4a\r\n重生之红星传奇44(粉丝QQ群：532909356)$http://audio.xmcdn.com/group9/M08/5C/B3/wKgDZlco1jjCPRcEAJplSeh3MW0597.m4a\r\n重生之红星传奇45(粉丝QQ群：532909356)$http://audio.xmcdn.com/group10/M02/58/E8/wKgDZ1cqITGxqGBuAJp-RYd6-PA221.m4a\r\n重生之红星传奇46(粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M09/5D/7F/wKgDZVcreeHD_RcjAJlwRnh8wKM168.m4a\r\n重生之红星传奇47(粉丝QQ群：532909356)$http://audio.xmcdn.com/group11/M0B/50/CA/wKgDa1crfCOxQna_AJbjbBPBAxo354.m4a\r\n重生之红星传奇48(粉丝QQ群：532909356)$http://audio.xmcdn.com/group12/M08/60/AC/wKgDW1ct8Y7SPUAMAJffwHGDoPI504.m4a\r\n重生之红星传奇49(粉丝QQ群：532909356)$http://audio.xmcdn.com/group13/M03/60/4B/wKgDXlcszuWzRVe_AJttiieQY8w592.m4a\r\n重生之红星传奇50(粉丝QQ群：532909356)$http://audio.xmcdn.com/group13/M06/61/EC/wKgDXlcuyRLzF69jAJXwJ05x1Ls239.m4a\r\n重生之红星传奇51(粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M05/60/72/wKgDaFcuzs6wP2JTAJedzBL9t2A712.m4a\r\n重生之红星传奇52 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M02/63/4C/wKgDX1cv-MnzfKQLAJnm8zr6ocQ330.m4a\r\n重生之红星传奇53 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group9/M03/62/C3/wKgDYlcv-wPhKwtZAJe8nEv_0b8843.m4a\r\n重生之红星传奇54(粉丝QQ群：532909356)$http://audio.xmcdn.com/group10/M0A/5E/20/wKgDZ1cv_gnDcocrAJjqpbjplqA938.m4a\r\n重生之红星传奇55(粉丝QQ群：532909356)$http://audio.xmcdn.com/group8/M04/63/F9/wKgDYFcxXHTTqRIwAJkvxyTEThQ273.m4a\r\n重生之红星传奇56(粉丝QQ群：532909356)$http://audio.xmcdn.com/group9/M07/64/22/wKgDYlcxX5zh0Sg5AJe2mgUAdV8812.m4a\r\n重生之红星传奇57(粉丝QQ群：532909356)$http://audio.xmcdn.com/group8/M09/63/F7/wKgDYVcxYv-RNTLBAJpSIC9vJgw286.m4a\r\n重生之红星传奇58(粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M02/64/13/wKgDaFcym3uB8VU6AJq-oC-JC2A978.m4a\r\n重生之红星传奇59 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M03/65/57/wKgDaFcz9iKA90meAJd0yJYkG4E211.m4a\r\n重生之红星传奇60 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group16/M06/66/C9/wKgDalcz-M-yrkEZAJjBqxOKvow814.m4a\r\n重生之红星传奇61(粉丝QQ群：532909356)$http://audio.xmcdn.com/group12/M01/67/CD/wKgDW1c1hLryEXdlAJkuK5uBWsQ500.m4a\r\n重生之红星传奇62(粉丝QQ群：532909356)$http://audio.xmcdn.com/group8/M08/69/29/wKgDYFc20XrQmD3eAJ1xku0i_zo161.m4a\r\n重生之红星传奇63(粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M00/68/DC/wKgDZVc332nRfnHVAJjyE34O5tM736.m4a\r\n重生之红星传奇64(粉丝QQ群：532909356)$http://audio.xmcdn.com/group13/M06/6A/F9/wKgDXlc4RH7wH2odAJgqrJD_Muw868.m4a\r\n重生之红星传奇65(粉丝QQ群：532909356)$http://audio.xmcdn.com/group10/M0A/68/4B/wKgDZ1c6dn6DtbphAJwnhtxSKlc966.m4a\r\n重生之红星传奇66(粉丝QQ群：532909356)$http://audio.xmcdn.com/group8/M04/6D/11/wKgDYVc6pOaSjHjPAJujdcNI6Gc799.m4a\r\n重生之红星传奇67(粉丝QQ群：532909356) $http://audio.xmcdn.com/group9/M00/70/76/wKgDZlc9ZJaTfnhRAJfECqFv3VY468.m4a\r\n重生之红星传奇68 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group10/M04/70/18/wKgDaVc-ykjTkIT1AJsDnS98Dh0528.m4a\r\n重生之红星传奇69 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group11/M09/7E/09/wKgDbVc_57Wwdt0QAJnD-lD61uY460.m4a\r\n重生之红星传奇70(粉丝QQ群：532909356)$http://audio.xmcdn.com/group11/M05/67/4E/wKgDa1dByKihH8OHAJtdDKvhKas838.m4a\r\n重生之红星传奇71(粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M0A/76/0E/wKgDX1dCfwuDTC7yAKNxZltDRKo974.m4a\r\n重生之红星传奇72(粉丝QQ群：532909356)$http://audio.xmcdn.com/group10/M0A/76/58/wKgDaVdEWPSzXm2RAJoKP4mQyrw099.m4a\r\n重生之红星传奇73(粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M0A/78/7A/wKgDX1dEZx6BAWgXAJhK2n9mGjI918.m4a\r\n重生之红星传奇74(粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M03/7A/E3/wKgDWldGUhuS0i3FAJesbq_gSjg670.m4a\r\n重生之红星传奇75(粉丝QQ群：532909356)$http://audio.xmcdn.com/group14/M07/7D/1B/wKgDY1dHyunzpu6SAJ3nXHsDk2s924.m4a\r\n重生之红星传奇76(粉丝QQ群：532909356) $http://audio.xmcdn.com/group13/M0A/7D/7F/wKgDXVdIiqnx9eEWAJssYQDcqcI272.m4a\r\n重生之红星传奇77(粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M05/80/5C/wKgDWldK-CbyZhgzAJrM8DlWFzA102.m4a\r\n重生之红星传奇78 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group9/M02/80/01/wKgDZldLFaqgbXoZAJh0WXyXLWQ813.m4a\r\n重生之红星传奇79(粉丝QQ群：532909356)$http://audio.xmcdn.com/group12/M07/81/87/wKgDW1dNJSTTzuD3AJvJgS-LZks200.m4a\r\n重生之红星传奇80(粉丝QQ群：532909356)$http://audio.xmcdn.com/group11/M02/74/D1/wKgDa1dOK76BvMmUAJ8gIp_NgAE906.m4a\r\n重生之红星传奇81(粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M02/81/B7/wKgDaFdOLI-iVVc4AJyuljmF07Q100.m4a\r\n重生之红星传奇82(粉丝QQ群：532909356)$http://audio.xmcdn.com/group12/M07/82/BA/wKgDXFdOL8OjLoL5AJgq7RTGaK4774.m4a\r\n重生之红星传奇83(粉丝QQ群：532909356)$http://audio.xmcdn.com/group16/M0B/83/08/wKgDbFdOMF7x1Hy-AKFPmnOZx7k853.m4a\r\n重生之红星传奇84(粉丝QQ群：532909356)$http://audio.xmcdn.com/group14/M03/85/21/wKgDY1dPEpHxdQ5WAJwBTyp_ri4387.m4a\r\n重生之红星传奇85(粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M01/84/89/wKgDWldPE5vjeXOTAJlQnRENy3g673.m4a\r\n重生之红星传奇86 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group13/M0B/86/96/wKgDXldRsTqwgAlqAJtkPg80G8A143.m4a\r\n重生之红星传奇87(粉丝QQ群：532909356)$http://audio.xmcdn.com/group14/M00/86/6F/wKgDY1dQ0rSSoYI_AJwzO58xqPU868.m4a\r\n重生之红星传奇88(粉丝QQ群：532909356)$http://audio.xmcdn.com/group6/M07/8E/B5/wKgDhFdQ1JWTxMQFAJUU59jZD8w997.m4a\r\n重生之红星传奇89(粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M07/85/2F/wKgDaFdRsQPhkOyYAJmEAMdgoQM671.m4a\r\n重生之红星传奇90(粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M04/84/FB/wKgDZVdRtTrTAyELAJqoOM4tYXY937.m4a\r\n重生之红星传奇91(粉丝QQ群：532909356)$http://audio.xmcdn.com/group16/M03/87/4C/wKgDaldTFOfjd9LUAJo6GMl-zZY373.m4a\r\n重生之红星传奇92(粉丝QQ群：532909356)$http://audio.xmcdn.com/group13/M08/87/89/wKgDXldTFp2A4qqZAJjK_E0wlZY428.m4a\r\n重生之红星传奇93(粉丝QQ群：532909356$http://audio.xmcdn.com/group10/M00/86/A2/wKgDaVdUUfjRR6N2AJquGqc7ZPs436.m4a\r\n重生之红星传奇94(粉丝QQ群：532909356$http://audio.xmcdn.com/group10/M05/86/A5/wKgDaVdUVW3Qw01zAJ7fh5ghtJw538.m4a\r\n重生之红星传奇95(粉丝QQ群：532909356$http://audio.xmcdn.com/group15/M02/87/4E/wKgDaFdUV1Dgml6kAJfl5-DknjI193.m4a\r\n重生之红星传奇96(粉丝QQ群：532909356$http://audio.xmcdn.com/group6/M08/92/FB/wKgDhFdVrxTSaLBGAJvFGwqw1bY527.m4a\r\n重生之红星传奇97(粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M07/8A/31/wKgDWldVsa3hcM3gAJnyJMMwEsE411.m4a\r\n重生之红星传奇98(粉丝QQ群：532909356)$http://audio.xmcdn.com/group12/M01/89/79/wKgDXFdVsmjQL039AJv1o1j1BaU552.m4a\r\n重生之红星传奇99集 高考加油$http://audio.xmcdn.com/group11/M06/7C/D7/wKgDa1dW8CbRA_s1AJs4IQ60Zz8094.m4a\r\n重生之红星传奇100（高考加油）$http://audio.xmcdn.com/group6/M01/94/28/wKgDhFdW9bahUQNNAJqcfGAS_O4126.m4a\r\n重生之红星传奇101（高考加油）$http://audio.xmcdn.com/group6/M01/95/2D/wKgDhFdYOdvxKkd-AJ1V_MTpIbo440.m4a\r\n重生之红星传奇102(端午安康)$http://audio.xmcdn.com/group12/M03/8C/5E/wKgDW1dZgQDh5BH3AJh4v8r_VRY930.m4a\r\n重生之红星传奇103(粉丝QQ群：532909356)$http://audio.xmcdn.com/group6/M08/96/42/wKgDhFdZmjnTcLueAJj4gUnR0tw213.m4a\r\n重生之红星传奇104(粉丝QQ群：532909356)$http://audio.xmcdn.com/group8/M0A/8C/85/wKgDYVdZnZOA9wlsAJvlaMzVy6I343.m4a\r\n重生之红星传奇105(粉丝QQ群：532909356)$http://audio.xmcdn.com/group16/M0B/8C/F3/wKgDaldZn-uxuJPhAJsdsryFsCM534.m4a\r\n重生之红星传奇106(粉丝QQ群：532909356)$http://audio.xmcdn.com/group14/M0B/8F/A5/wKgDY1db1Xuyzfg4AJuh2njML5Q638.m4a\r\n重生之红星传奇107(粉丝QQ群：532909356)$http://audio.xmcdn.com/group16/M0B/8E/A1/wKgDaldb2lDBpqjxAJwS7ZqRk_A011.m4a\r\n重生之红星传奇108(粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M00/8F/0E/wKgDWldb3lnTIfqFAJc0Ohikbp0567.m4a\r\n重生之红星传奇109(粉丝QQ群：532909356)$http://audio.xmcdn.com/group10/M00/8D/F7/wKgDaVddITOgb64AAJmulqml4mo643.m4a\r\n重生之红星传奇110 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group14/M0B/91/71/wKgDY1deDQGj6LDzAJlw6lt9jr0498.m4a\r\n重生之红星传奇111(粉丝QQ群：532909356)$http://audio.xmcdn.com/group12/M02/91/35/wKgDW1dfmbPRX-MaAJiZDagr_Fw941.m4a\r\n重生之红星传奇112(粉丝QQ群：532909356)$http://audio.xmcdn.com/group9/M01/93/2C/wKgDZldhFL_zXIujAJjcm3vKlno606.m4a\r\n重生之红星传奇113(粉丝QQ群：532909356)$http://audio.xmcdn.com/group14/M0A/93/FD/wKgDZFdhF0rjPIn-AJeuGnX2MzQ817.m4a\r\n重生之红星传奇114$http://audio.xmcdn.com/group6/M08/9C/4D/wKgDhFdhITjxglHTAJgaxuPnrFo036.m4a\r\n重生之红星传奇115(粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M05/93/2F/wKgDaFdieGrSDqQuAJlQnTkxvUc039.m4a\r\n重生之红星传奇116(粉丝QQ群：532909356)$http://audio.xmcdn.com/group16/M09/94/40/wKgDaldie4_hwHCyAJs8iFoACFQ369.m4a\r\n重生之红星传奇117(粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M01/94/AF/wKgDWldiiCWxKb5xAJnEnzfWI-w178.m4a\r\n重生之红星传奇118(粉丝QQ群：532909356)$http://audio.xmcdn.com/group11/M05/86/F7/wKgDa1djcQOgUFSFAJrEHyfyQGM949.m4a\r\n重生之红星传奇119(粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M08/95/1D/wKgDX1djiFyAij7eAJXPZkkcbaw007.m4a\r\n重生之红星传奇120 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group6/M05/A2/73/wKgDg1djs3TD9W49AJgWYINSipU955.m4a\r\n重生之红星传奇121 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group16/M05/95/F9/wKgDaldkwSugErkAAJZ5u_J5pU0326.m4a\r\n重生之红星传奇122 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group13/M01/96/75/wKgDXVdk6wziTt_KAJk6lMzL_bc526.m4a\r\n重生之红星传奇123 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group6/M03/9F/5B/wKgDhFdk7mCwbIupAJchJAGj_hA530.m4a\r\n重生之红星传奇124(粉丝QQ群：532909356)$http://audio.xmcdn.com/group9/M01/97/22/wKgDZldmCEbiGfMLAJ4GMtCQ03s060.m4a\r\n重生之红星传奇125(粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M07/96/EF/wKgDX1dmCiPx8KncAJm0eMugX_g789.m4a\r\n重生之红星传奇126(粉丝QQ群：532909356)$http://audio.xmcdn.com/group7/M0A/98/67/wKgDWldnf3jibUerAJlSFKZSsIc760.m4a\r\n重生之红星传奇127(粉丝QQ群：532909356)$http://audio.xmcdn.com/group14/M03/99/02/wKgDZFdngj3CvsWjAJjswY2UaF0505.m4a\r\n重生之红星传奇128 (粉丝QQ群：532909356) $http://audio.xmcdn.com/group15/M05/98/22/wKgDaFdo84SzJRIbAJh4vxcsz_E763.m4a\r\n重生之红星传奇129(粉丝QQ群：532909356)$http://audio.xmcdn.com/group13/M01/9A/D3/wKgDXVdqUu6hEcTHAJeiXYCoMkw252.m4a\r\n重生之红星传奇130 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group10/M00/99/B4/wKgDaVdrnNKx0sxfAJnTTgbHqeE865.m4a\r\n重生之红星传奇131$http://audio.xmcdn.com/group8/M06/9C/56/wKgDYVdtRtihLLxzAJd2UO6SOjI324.m4a\r\n重生之红星传奇132$http://audio.xmcdn.com/group14/M09/9E/7E/wKgDZFduYmOyJw4wAJlSFBJZUjI601.m4a\r\n重生之红星传奇133 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group15/M01/9D/77/wKgDaFdvxemySf7bAJeWnXQd2pI174.m4a\r\n重生之红星传奇134 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group11/M01/AA/B4/wKgDbVdxPEXTMyYEAJdXem_QQQA606.m4a\r\n重生之红星传奇135 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group8/M00/9F/98/wKgDYFdxUy6jp040AJjSUrc_LmU079.m4a\r\n重生之红星传奇136(粉丝QQ群：532909356)$http://audio.xmcdn.com/group16/M0B/A1/00/wKgDbFdyzP-Tq3WwAJgjk9kQx48455.m4a\r\n重生之红星传奇137(粉丝QQ群：532909356)$http://audio.xmcdn.com/group8/M02/A2/64/wKgDYVd1QUCwyr5nAJf0zh-ZZh4215.m4a\r\n重生之红星传奇138(粉丝QQ群：532909356)$http://audio.xmcdn.com/group9/M08/A2/CC/wKgDYld1RbygC5yBAJpOpVzdaxs301.m4a\r\n重生之红星传奇139(粉丝QQ群：532909356)$http://audio.xmcdn.com/group8/M07/A3/76/wKgDYVd2-22yE1M5AJg1NYKYEXs771.m4a\r\n重生之红星传奇140(粉丝QQ群：532909356)$http://audio.xmcdn.com/group11/M06/AF/BE/wKgDbVd36uThncX1AJh3SD_rVlM888.m4a\r\n重生之红星传奇141(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M06/02/22/wKgJJFd6aNjxix-iAJj7cfEKfv0979.m4a\r\n重生之红星传奇142(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M06/02/CB/wKgJJFd6kt7izn5YAJlZblymMxk493.m4a\r\n重生之红星传奇143(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M06/06/68/wKgJK1d730qTtuOzAJnEn49V7tU536.m4a\r\n重生之红星传奇144(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M06/09/4A/wKgJK1d9AOyjWmrXAJiL2SOS-8M785.m4a\r\n重生之红星传奇145$http://audio.xmcdn.com/group20/M07/0D/18/wKgJJ1d-VPvTdXBYAJf7-0uSo-I808.m4a\r\n重生之红星传奇146$http://audio.xmcdn.com/group20/M07/10/FB/wKgJJ1d_vguhw2WUAJaumSDHjyU273.m4a\r\n重生之红星传奇147$http://audio.xmcdn.com/group17/M00/14/02/wKgJJFeBDH2h0Xf5AJgEvfwqIRo767.m4a\r\n重生之红星传奇148$http://audio.xmcdn.com/group17/M03/14/6D/wKgJJFeBK--z7Za6AJhc2ObSCYA205.m4a\r\n重生之红星传奇149(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M04/19/5F/wKgJJleDM4CCcKtOAJnNbGER1YQ667.m4a\r\n重生之红星传奇150(粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M09/1C/9E/wKgJJ1eEX2CjIkDJAJe4YqxJ-ks346.m4a\r\n重生之红星传奇151(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M0B/21/D2/wKgJK1eGAHmChTAaAJrqTzD2y10822.m4a\r\n重生之红星传奇152$http://audio.xmcdn.com/group19/M0B/2E/FF/wKgJK1eK8OaANtf3AJgxMdjC5N8921.m4a\r\n重生之红星传奇153(粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M05/32/45/wKgJLFeMRvni4yDOAJSfbtnduCo983.m4a\r\n重生之红星传奇154$http://audio.xmcdn.com/group18/M00/28/FC/wKgJJVeIhZKRWAQDAJbn3yoVk6A276.m4a\r\n重生之红星传奇155$http://audio.xmcdn.com/group18/M0A/28/D6/wKgJKleIiMjylukXAJcywjp8i_0749.m4a\r\n重生之红星传奇156$http://audio.xmcdn.com/group18/M04/2C/C6/wKgJJVeJ7wvgbgOiAJdKQsPGS3A155.m4a\r\n重生之红星传奇157$http://audio.xmcdn.com/group18/M02/32/27/wKgJKleMR5XR6XlMAJoScVaj8H0739.m4a\r\n重生之红星传奇158$http://audio.xmcdn.com/group20/M06/32/56/wKgJJ1eMRU_Sx9_sAJfhMqAFXss051.m4a\r\n重生之红星传奇159$http://audio.xmcdn.com/group19/M08/36/9A/wKgJK1eNw2Ky9ewbAJcnAlRxTC8639.m4a\r\n重生之红星传奇160$http://audio.xmcdn.com/group18/M0B/3B/01/wKgJJVePNKXyi9afAJcZyonrNYY751.m4a\r\n重生之红星传奇161$http://audio.xmcdn.com/group18/M0A/49/01/wKgJJVeUYMfTZAtBAJhG1Mwj7QI988.m4a\r\n重生之红星传奇162$http://audio.xmcdn.com/group17/M08/42/68/wKgJKVeR2gnxETbFAJWgatpn-rA257.m4a\r\n重生之红星传奇163$http://audio.xmcdn.com/group17/M08/56/44/wKgJKVeZPjmCZV9pAJlSFNh3fv0733.m4a\r\n重生之红星传奇164$http://audio.xmcdn.com/group17/M09/55/F8/wKgJJFeZPl6iEQ0KAJuvEoJeaGY404.m4a\r\n重生之红星传奇165 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M0B/4C/36/wKgJJ1eVqVPS-IvUAJez_CYGzoA191.m4a\r\n重生之红星传奇166(粉丝QQ群：532909356)$http://audio.xmcdn.com/group18/M0A/50/79/wKgJKleXI7WyuVK9AJXuPFDVhL8988.m4a\r\n重生之红星传奇167 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M0B/52/3E/wKgJJFeXj5Gg0K6DAJZz3Ugz-wI116.m4a\r\n重生之红星传奇168$http://audio.xmcdn.com/group17/M05/56/43/wKgJKVeZPbixdpmxAJjvsDPX2LE015.m4a\r\n重生之红星传奇169$http://audio.xmcdn.com/group17/M06/5C/71/wKgJKVebVcHRgFMXAJjbI_oRaMs071.m4a\r\n重生之红星传奇170$http://audio.xmcdn.com/group18/M08/5D/DE/wKgJJVecJqvCgXYkAJXSVfnl--s097.m4a\r\n重生之红星传奇171$http://audio.xmcdn.com/group17/M04/62/7E/wKgJKVed8bTxHcgBAJbBr4JnO3w015.m4a\r\n重生之红星传奇172$http://audio.xmcdn.com/group18/M04/63/57/wKgJJVeehFaz6Y_QAJaumXorBKY775.m4a\r\n重生之红星传奇173$http://audio.xmcdn.com/group18/M05/6D/D5/wKgJKleiEpiSbXiPAJeQu2-Wemk143.m4a\r\n重生之红星传奇174$http://audio.xmcdn.com/group19/M06/6B/19/wKgJJleg0abSAuuOAJhMsqQyvGA151.m4a\r\n重生之红星传奇175$http://audio.xmcdn.com/group17/M02/6E/BE/wKgJKVeiTX3Q6UWqAJZvdmOdFKs543.m4a\r\n重生之红星传奇176$http://audio.xmcdn.com/group19/M02/75/D9/wKgJK1ekrfqhLjAgAJaYlIqCMI4704.m4a\r\n重生之红星传奇177 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M06/75/C3/wKgJJFektY_zqtIRAJYCymIzvKE405.m4a\r\n重生之红星传奇178$http://audio.xmcdn.com/group19/M01/76/0D/wKgJK1ekvkSSB2C8AJcoecPgAuk836.m4a\r\n重生之红星传奇179$http://audio.xmcdn.com/group18/M00/75/CC/wKgJKlelGifwqh79AJXPZnkJOPw444.m4a\r\n重生之红星传奇180$http://audio.xmcdn.com/group18/M07/79/1A/wKgJJVembLyRY2czAJW8UQX7HZo212.m4a\r\n重生之红星传奇181$http://audio.xmcdn.com/group20/M01/78/3E/wKgJLFemcgeRhSd9AJUKnznC2uY140.m4a\r\n重生之红星传奇182$http://audio.xmcdn.com/group19/M01/7C/D0/wKgJJlenwM2gqO6AAJXbJ5jAm-s364.m4a\r\n重生之红星传奇183$http://audio.xmcdn.com/group18/M0A/7F/9E/wKgJJVeoslTAYxtNAJXj9Hk5VLo788.m4a\r\n重生之红星传奇184$http://audio.xmcdn.com/group17/M0B/80/36/wKgJKVepDSuzOCrwAJYEQSN4LUQ407.m4a\r\n重生之红星传奇185$http://audio.xmcdn.com/group19/M02/83/F3/wKgJJleqVY7AhLxpAJRsCwOeRU8118.m4a\r\n重生之红星传奇186$http://audio.xmcdn.com/group17/M05/88/F3/wKgJKVesRC_RKkoMAJf-31JBb8w420.m4a\r\n重生之红星传奇187$http://audio.xmcdn.com/group19/M00/8C/09/wKgJK1etYYSy-sylAJVy5at5q0E940.m4a\r\n重生之红星传奇188$http://audio.xmcdn.com/group19/M08/8F/8D/wKgJJleup2fxKc8iAJdRmNElU4w590.m4a\r\n重生之红星传奇189(粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M06/92/4D/wKgJLFewOAHivV1XAJiI5ih9oR0469.m4a\r\n重生之红星传奇190$http://audio.xmcdn.com/group17/M05/96/35/wKgJJFexjA3ShmfIAJaOTFT9L7Q349.m4a\r\n重生之红星传奇191$http://audio.xmcdn.com/group17/M06/99/60/wKgJJFeyu6qCN_jUAJSQvxrB0MY875.m4a\r\n重生之红星传奇192$http://audio.xmcdn.com/group20/M01/9A/2E/wKgJJ1eyv_WhuWCHAJXp1j5k-VY256.m4a\r\n重生之红星传奇193$http://audio.xmcdn.com/group17/M0A/99/EC/wKgJKVeywdCiEzYlAJmwDYU-AfA154.m4a\r\n重生之红星传奇194$http://audio.xmcdn.com/group17/M03/9D/DA/wKgJKVe0LmGxO8lHAJZ4QyNXN2E910.m4a\r\n重生之红星传奇195(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M00/9D/90/wKgJJFe0NsijT1PMAJX7dOIIqvQ758.m4a\r\n重生之红星传奇196$http://audio.xmcdn.com/group17/M00/9D/9E/wKgJJFe0O0SgJQUfAJhSlJ26sC8502.m4a\r\n重生之红星传奇197$http://audio.xmcdn.com/group18/M03/A1/16/wKgJJVe1lq2T3gC_AJV9KVIUuRQ524.m4a\r\n重生之红星传奇198$http://audio.xmcdn.com/group17/M02/A3/4F/wKgJJFe2ZeOQ1lH4AJXp1tH-tsM172.m4a\r\n重生之红星传奇199$http://audio.xmcdn.com/group19/M02/A3/C8/wKgJK1e2ar2BckfaAJ70FOIFurU784.m4a\r\n重生之红星传奇200$http://audio.xmcdn.com/group17/M0B/A3/A3/wKgJJFe2ewfSBV3rAJZsh_SdFEM111.m4a\r\n重生之红星传奇201$http://audio.xmcdn.com/group18/M07/A7/18/wKgJJVe35xbh7jpTAJWqrrtEP6U831.m4a\r\n重生之红星传奇202$http://audio.xmcdn.com/group17/M00/A7/EB/wKgJKVe363iiize3AJc4oFClmz8472.m4a\r\n重生之红星传奇203$http://audio.xmcdn.com/group20/M0B/AA/86/wKgJLFe5jlbQyls9AJbJCbMEYig592.m4a\r\n重生之红星传奇204$http://audio.xmcdn.com/group20/M00/AC/18/wKgJJ1e5kNqC78p6AJYdOYb7lZ8134.m4a\r\n重生之红星传奇205$http://audio.xmcdn.com/group18/M07/AB/81/wKgJKle5-83y4TYJAJUvV-pD2mE419.m4a\r\n重生之红星传奇206(粉丝QQ群：532909356)$http://audio.xmcdn.com/group18/M09/AB/81/wKgJKle5_EmAmwiGAJazABBW0bI185.m4a\r\n重生之红星传奇207(粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M04/B1/19/wKgJJ1e7s3TwZbKMAJV0XP3Bs9U676.m4a\r\n重生之红星传奇208(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M09/B0/FE/wKgJJle7tTTz7Vc-AJgEvViFXAc839.m4a\r\n重生之红星传奇210(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M0A/B5/A6/wKgJKVe9TbLyzGAxAJX_2vQbqSA137.m4a\r\n重生之红星传奇211(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M08/B5/CF/wKgJJle9TkaxFS9ZAJXAt11LSHY620.m4a\r\n重生之红星传奇212(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M06/B7/D3/wKgJK1e-KAfDWqVsAJdBcTejgK4091.m4a\r\n重生之红星传奇213(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M0B/B8/1F/wKgJJle-LN3ww0bpAJcuW-zLNfM582.m4a\r\n重生之红星传奇209(粉丝QQ群：532909356)$http://audio.xmcdn.com/group18/M04/B7/02/wKgJJVe-LjOCyv4bAJPdmWJQ2HA128.m4a\r\n重生之红星传奇214(粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M00/BC/2B/wKgJJ1e_cvnAWCy_AJac-yEeY1E803.m4a\r\n重生之红星传奇215(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M07/BC/1C/wKgJKVe_fTbzsgHkAJYReXnTanM900.m4a\r\n重生之红星传奇216$http://audio.xmcdn.com/group18/M07/BE/17/wKgJKlfAyFqD2G45AJYzQtTzvQo128.m4a\r\n重生之红星传奇217$http://audio.xmcdn.com/group19/M0A/C4/0B/wKgJK1fCqZPD0EZRAJgU5AO3Qmk026.m4a\r\n重生之红星传奇218$http://audio.xmcdn.com/group20/M09/C8/C1/wKgJJ1fEWlqx4iiGAJTgDTSh9S8861.m4a\r\n重生之红星传奇219$http://audio.xmcdn.com/group17/M09/C8/51/wKgJJFfEZV6TH0X2AJfxqL8iG64724.m4a\r\n重生之红星传奇220$http://audio.xmcdn.com/group20/M01/CD/F1/wKgJJ1fGVcSB2R_BAJloHUzokTc322.m4a\r\n重生之红星传奇221(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M02/CD/C4/wKgJK1fGWdOTLRlKAJbL-GF72ro694.m4a\r\n重生之红星传奇222$http://audio.xmcdn.com/group20/M0B/D3/91/wKgJJ1fISEnSfwInAJRC7Jg6E30604.m4a\r\n重生之红星传奇223$http://audio.xmcdn.com/group20/M05/D3/DF/wKgJJ1fIcDrxxHX-AJgAVxnFMHs748.m4a\r\n重生之红星传奇224$http://audio.xmcdn.com/group18/M0A/D5/E1/wKgJJVfJkFzis7SsAJWsJnbHhiY663.m4a\r\n重生之红星传奇225$http://audio.xmcdn.com/group19/M00/D7/3A/wKgJJlfJsS_T1_z4AJeE_x8Se8U808.m4a\r\n重生之红星传奇226$http://audio.xmcdn.com/group18/M05/D9/A1/wKgJJVfLElzhCKOCAJf-3y-74P4958.m4a\r\n重生之红星传奇227(粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M08/DC/53/wKgJLFfMatDBMFKwAJcywgB4yO8139.m4a\r\n重生之红星传奇228$http://audio.xmcdn.com/group19/M02/DE/01/wKgJJlfMbiXiqksbAJVlrQ60qWI447.m4a\r\n重生之红星传奇229$http://audio.xmcdn.com/group19/M01/E2/32/wKgJK1fN-_3z4HEIAJtA8tfzDNU367.m4a\r\n重生之红星传奇230$http://audio.xmcdn.com/group19/M02/E6/D9/wKgJK1fPpdfSeziLAJXsxWQx5f4332.m4a\r\n重生之红星传奇231(粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M02/E9/EC/wKgJJ1fQn0yjNRjGAJWjWSDQvV8704.m4a\r\n重生之红星传奇232$http://audio.xmcdn.com/group20/M01/EB/77/wKgJLFfRnJWy3wIQAJcSdYwatQg034.m4a\r\n重生之红星传奇233(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M0A/EF/F9/wKgJJFfS7ImDLxZJAJu5Wwa8r_E573.m4a\r\n重生之红星传奇234$http://audio.xmcdn.com/group17/M03/F3/A2/wKgJJFfUPKXQjg7nAJZplKNRR7w320.m4a\r\n重生之红星传奇235(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M09/F8/73/wKgJJFfWMeHC-o63AJZWfugBJbQ729.m4a\r\n重生之红星传奇236(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M01/FD/8D/wKgJK1fXzwuSis2wAJUwzshmNnQ833.m4a\r\n重生之红星传奇237(粉丝QQ群：532909356)$http://audio.xmcdn.com/group18/M07/FF/66/wKgJJVfYt_LgRM-5AJYV49JihHQ958.m4a\r\n重生之红星传奇238大家中秋快乐哦$http://audio.xmcdn.com/group17/M07/05/51/wKgJKVfaWxLyvGInAJZt_mEloTM711.m4a\r\n重生之红星传奇239大家中秋快乐哦$http://audio.xmcdn.com/group19/M04/05/6B/wKgJJlfaXj3y9i4XAJWyCFJmKFQ080.m4a\r\n重生之红星传奇240大家中秋快乐哦$http://audio.xmcdn.com/group19/M06/05/7A/wKgJJlfaYfTRNJOtAJWQQyJYOGo953.m4a\r\n重生之红星传奇241大家中秋快乐哦$http://audio.xmcdn.com/group20/M03/03/D5/wKgJLFfaZGLQ_iGQAJdb4fhc0Kw169.m4a\r\n重生之红星传奇242大家中秋节快乐哦$http://audio.xmcdn.com/group20/M00/05/9C/wKgJJ1faZz6hRIvFAJdaaZzifYQ817.m4a\r\n重生之红星传奇243(粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M08/07/BC/wKgJLFfbrjij0o4qAJTOainrHoc823.m4a\r\n重生之红星传奇244(粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M07/07/C5/wKgJLFfbsLbjQCBXAJe7Ub9pB6M626.m4a\r\n重生之红星传奇245(粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M05/11/CF/wKgJJ1feakWS9LuzAJUX1iW8MJI269.m4a\r\n重生之红星传奇246$http://audio.xmcdn.com/group19/M01/15/CF/wKgJK1ffs22jTTDdAJi35-BBNEg288.m4a\r\n重生之红星传奇247$http://audio.xmcdn.com/group18/M02/17/C6/wKgJKlfgvC2yZc_PAJfHEfR0ALY925.m4a\r\n重生之红星传奇248$http://audio.xmcdn.com/group17/M02/1D/BD/wKgJJFfiCHKDMVifAJjGloAc-EA114.m4a\r\n重生之红星传奇249 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group18/M00/22/88/wKgJKlfjmD_gBy2fAJcT7FzERK0672.m4a\r\n重生之红星传奇250(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M08/28/36/wKgJJlfksXTDHL21AJXxK3nrw_0771.m4a\r\n重生之红星传奇251$http://audio.xmcdn.com/group19/M01/2E/DF/wKgJK1fmk9eCtCymAJO3alz54uM008.m4a\r\n重生之红星传奇252 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group18/M04/31/20/wKgJKlfnyLeRg1ASAJGsqagmBE4161.m4a\r\n重生之红星传奇253(粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M0A/33/FC/wKgJJ1fobsvwbXnBAJQwfNxgAWc752.m4a\r\n重生之红星传奇254(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M04/37/41/wKgJJFfpSwLAaubqAJpkru3VqfU621.m4a\r\n重生之红星传奇255(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M02/3C/1D/wKgJJFfrNqjQyJWEAJmhXgJUfbY651.m4a\r\n重生之红星传奇256(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M09/40/67/wKgJJFfsk32Se6p0AJXuPKdXwrM401.m4a\r\n重生之红星传奇257$http://audio.xmcdn.com/group19/M08/45/1C/wKgJJlfuEzaCpzW6AJdRmNGij34650.m4a\r\n重生之红星传奇258大家国庆国庆快乐$http://audio.xmcdn.com/group19/M09/48/1E/wKgJK1fvQCHQr5mIAJW2b5ssV6o066.m4a\r\n重生之红星传奇259 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group18/M02/4A/9E/wKgJJVfweTuxQ7kQAJjSUvZInwM187.m4a\r\n重生之红星传奇260(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M02/4E/63/wKgJK1fxxTmhZ3QEAJX866ZGIjk974.m4a\r\n重生之红星传奇261 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M09/53/B1/wKgJJ1fzoh-ABEGAAJjTyQR23oU280.m4a\r\n重生之红星传奇262 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group18/M09/56/BD/wKgJJVf0-pqgbSvzAJU-BsDeeBM455.m4a\r\n重生之红星传奇264(粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M04/5B/E9/wKgJJ1f2fP3zgSM4AJcDxYW3gLQ177.m4a\r\n重生之红星传奇263(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M02/5B/4A/wKgJJFf2W4qx7AXPAJaM1DUnzXo481.m4a\r\n重生之红星传奇265(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M0B/65/10/wKgJJlf5q0zTSMO7AJf6eQd9Xkk678.m4a\r\n重生之红星传奇266(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M03/69/BD/wKgJJFf7HASSeIB3AJiQQAClSj4836.m4a\r\n重生之红星传奇267(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M07/6E/EF/wKgJJFf8ta7ANE9rAJVkNZQ8d2s531.m4a\r\n重生之红星传奇268(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M03/71/66/wKgJK1f9no_h8ySTAJXGlbviDyk518.m4a\r\n重生之红星传奇269(粉丝QQ群：532909356)$http://audio.xmcdn.com/group18/M07/74/16/wKgJKlf-58nhYb-HAJUayRzAXJs275.m4a\r\n重生之红星传奇270(粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M02/79/EF/wKgJLFgA7MSQc0pEAJrqT7i9Y_w432.m4a\r\n重生之红星传奇271(粉丝QQ群：532909356)$http://audio.xmcdn.com/group18/M07/7C/09/wKgJKlgBr2nC1lZaAJeH7tes6x4482.m4a\r\n重生之红星传奇272(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M06/83/B3/wKgJK1gDl-TyzSQgAJaG8mscGLQ228.m4a\r\n重生之红星传奇273(粉丝QQ群：532909356)$http://audio.xmcdn.com/group18/M0B/82/F4/wKgJKlgDsO-jdo34AJV9Kfn2WgU013.m4a\r\n重生之红星传奇274(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M06/88/5C/wKgJJFgE-E7DK6wmAJc4oJiijDg140.m4a\r\n重生之红星传奇275(粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M0A/8C/C0/wKgJJ1gGSmmCIwUFAJUdufQ1VNo054.m4a\r\n重生之红星传奇276(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M0A/91/82/wKgJJFgHnYOzj3wXAJS-RGpoxXI378.m4a\r\n重生之红星传奇277 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M00/95/E5/wKgJK1gI7hLBfO31AJTFnUILPc4669.m4a\r\n重生之红星传奇278 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group20/M02/9A/3F/wKgJJ1gKQrriQxHeAJepswRD7RE325.m4a\r\n重生之红星传奇279(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M05/9F/06/wKgJJFgL7FjRzhDUAJOtJVh7080575.m4a\r\n重生之红星传奇280 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M00/A3/04/wKgJJlgNDh3hixidAJgMFy7836Y127.m4a\r\n重生之红星传奇282(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M04/00/28/wKgJNlgQGhaiqdNVAJXbJzRkXuI184.m4a\r\n重生之红星传奇283(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M00/00/5F/wKgJNlgQLxbzqHCAAJbXuCOMG0o720.m4a\r\n重生之红星传奇281(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M0B/00/5B/wKgJMFgQLiaxVDZHAJawERYZmQ8534.m4a\r\n重生之红星传奇284(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M09/03/99/wKgJMFgRaHjD9GyCAJS8zCm1Ajk339.m4a\r\n重生之红星传奇285(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M06/08/23/wKgJMFgTBYrRcPtAAJn2ikOl1ig789.m4a\r\n重生之红星传奇287(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M04/0D/92/wKgJMVgVal7DXSXcAJWwkEWQf-o793.m4a\r\n重生之红星传奇288(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M04/10/1D/wKgJLlgWIhDwf3tHAJmM0cMlzeQ145.m4a\r\n重生之红星传奇289(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M0A/14/2D/wKgJL1gYCEOQsNxUAJAr7yLWG50040.m4a\r\n重生之红星传奇286$http://audio.xmcdn.com/group22/M04/19/E6/wKgJLlgZ9zbyUWAlAJkEQrt4Fdg374.m4a\r\n重生之红星传奇290 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M01/19/54/wKgJM1gZ4LKBcsWiAJQwcULcLwg362.m4a\r\n重生之红星传奇291 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M0B/1A/4F/wKgJLVgaFtKijaJ5AJKnw2-1c58927.m4a\r\n重生之红星传奇292 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M02/1D/D8/wKgJKFgbx7rClWNJAJSJaUGCMcA025.m4a\r\n重生之红星传奇293 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M06/20/82/wKgJLVgckHKTanN8AJXuV_0wr3Y608.m4a\r\n重生之红星传奇294 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M09/21/1B/wKgJKFgcu07DuUeAAJcywmWlPRE930.m4a\r\n重生之红星传奇295 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M03/24/47/wKgJMFgeDqqiNfVxAJZHzz7Ytpg003.m4a\r\n重生之红星传奇296 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M06/2D/CF/wKgJL1ghx0KR2AObAJZHzz-WzdE462.m4a\r\n重生之红星传奇297(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M00/29/42/wKgJMVggQHbS5So_AJn2ikNR4-A021.m4a\r\n重生之红星传奇298$http://audio.xmcdn.com/group22/M01/2D/AE/wKgJM1ghxHrx9fUmAJSd9uQHkzE777.m4a\r\n重生之红星传奇299 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M02/2D/81/wKgJMVghyNaDYAZcAJaaDMUovFM369.m4a\r\n重生之红星传奇300 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M0A/32/DD/wKgJL1gj_XDBZd1UAJcoeRlPyeQ461.m4a\r\n重生之红星传奇301 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M07/32/A6/wKgJKFgkAjfSuR7bAJwND0YIuHs406.m4a\r\n重生之红星传奇302(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M0B/36/54/wKgJMVglpEDT0cTIAJbR1rBMtkc670.m4a\r\n重生之红星传奇303(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M04/36/5B/wKgJMVglpk7hcKxgAJnjddVceqw574.m4a\r\n重生之红星传奇304(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M00/39/C6/wKgJL1gnBu-wC09BAJYTD-W7a1s939.m4a\r\n重生之红星传奇305(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M09/3A/49/wKgJMVgnQhLjprpuAJb4BRrcWT8547.m4a\r\n重生之红星传奇306(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M00/3F/91/wKgJL1gpSoTAH2NJAJdmKTXxuns003.m4a\r\n重生之红星传奇307(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M07/42/24/wKgJNFgqRyLzj5qcAJUTcCR5uJE252.m4a\r\n重生之红星传奇308(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M05/44/C4/wKgJNFgrDl7RUzZfAJhomb7rI64704.m4a\r\n重生之红星传奇309(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M05/48/86/wKgJKFgseK_CmF_3AJbDJ-YVnhI168.m4a\r\n重生之红星传奇310(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M08/4B/7C/wKgJMVgtuRfjGfNNAJb1FkIEu-4746.m4a\r\n重生之红星传奇311(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M00/4B/CA/wKgJM1gtvLLgyyaJAJlX8sOY-1U441.m4a\r\n重生之红星传奇312(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M08/4E/96/wKgJNVgu8SrBUObAAJfKAfNiJfE750.m4a\r\n重生之红星传奇313(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M02/4E/71/wKgJMVgu9yDhNGOzAJZjtremq1M815.m4a\r\n重生之红星传奇314(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M01/4F/E8/wKgJLVgvizWAoL0UAJf6eaXdvOE400.m4a\r\n重生之红星传奇315(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M04/55/E3/wKgJNVgxsNnBvXVQAJbUyd-ztEs926.m4a\r\n重生之红星传奇316(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M09/58/00/wKgJNFgyhQ_RCU8-AJlw6uNob8I679.m4a\r\n重生之红星传奇317(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M0B/57/FE/wKgJM1gyiKeidQ0SAJZKvk6_ud8000.m4a\r\n重生之红星传奇318(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M04/5B/DC/wKgJLlgz1rOS3r9cAJaG8nemWas481.m4a\r\n重生之红星传奇319(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M0A/61/0B/wKgJNFg1l43zn0e5AJZd2D0Bsnk887.m4a\r\n重生之红星传奇320(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M09/62/00/wKgJLVg10CDDE53iAJZmpdCWyc0515.m4a\r\n重生之红星传奇321(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M09/64/5F/wKgJM1g20gDjeHhxAJbQXudtPhw941.m4a\r\n重生之红星传奇322(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M00/65/64/wKgJMFg3FAmgsN2xAJhOKb4l7Yo097.m4a\r\n重生之红星传奇323(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M05/6A/13/wKgJLVg5G5Oyyl-3AJhVgzZfJIo399.m4a\r\n重生之红星传奇324(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M05/6D/90/wKgJMFg6qMmwAAG5AJkxx74EO2A777.m4a\r\n重生之红星传奇325(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M08/74/5E/wKgJM1g8SCWjzBOPAJv_2LDklGs502.m4a\r\n重生之红星传奇326(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M02/7C/A9/wKgJLVg9jzuhbFKEAJZMNQ8oVd8015.m4a\r\n重生之红星传奇327(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M01/7D/DB/wKgJNVg9tUCg9WELAJZiPtfaQzY966.m4a\r\n重生之红星传奇328(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M0B/87/BA/wKgJL1hAKd2RfObRAJZfT1OOJsE644.m4a\r\n重生之红星传奇329(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M04/87/E9/wKgJMFhASlGQXxaQAJQMlnSPPr0781.m4a\r\n重生之红星传奇330$http://audio.xmcdn.com/group23/M0A/8D/0D/wKgJNFhCVRWje6KDAJdIy2tM--8925.m4a\r\n重生之红星传奇331(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M0A/8F/25/wKgJMFhC9L2zjywqAJTkc_dlORE154.m4a\r\n重生之红星传奇332(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M08/96/32/wKgJMFhFd-HwgvZTAJZmpXy9N5c625.m4a\r\n重生之红星传奇333(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M03/96/9F/wKgJMFhFkSLgl4JaAJVhQu5LfxU101.m4a\r\n重生之红星传奇334(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M04/9A/16/wKgJKFhG5HbQveVpAJlrDK5172A969.m4a\r\n重生之红星传奇335(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M03/A2/02/wKgJMFhJecKBi0GqAJn2imc1rT8976.m4a\r\n重生之红星传奇336(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M03/A5/BF/wKgJNlhKpcDhtdUzAJM8EjdRaz4534.m4a\r\n重生之红星传奇337(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M09/AA/82/wKgJMFhLlTLS3a0jAJZSGE8DUiQ970.m4a\r\n重生之红星传奇338$http://audio.xmcdn.com/group25/M07/AD/DD/wKgJNlhMLZeCLpCpAJjSUgP5QTI376.m4a\r\n重生之红星传奇339(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M01/B8/31/wKgJLlhOuyqy5Q0gAJcFPT3mswI770.m4a\r\n重生之红星传奇340(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M00/B9/81/wKgJKFhPoUKjYNPzAJxyYpG-cWc631.m4a\r\n重生之红星传奇341(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M05/BD/40/wKgJLVhQIYXj0y8PAKPXLoryomo867.m4a\r\n重生之红星传奇342(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M07/C8/64/wKgJM1hSmfvxLxSbAJYaSl9mBh4651.m4a\r\n重生之红星传奇343(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M05/C9/79/wKgJLlhSwBeQYqtsAJivFs-neuk638.m4a\r\n重生之红星传奇344$http://audio.xmcdn.com/group21/M0B/CC/18/wKgJKFhUEN2zGuTUAJZmpWSgjA4708.m4a\r\n重生之红星传奇345(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M09/D4/29/wKgJL1hWq6zBIlBmAJcbQjBUs1k237.m4a\r\n重生之红星传奇346(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M06/DD/86/wKgJLVhZMwLxYjkbAJcFPW9kvW8242.m4a\r\n重生之红星传奇347(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M01/DE/79/wKgJL1hZOMqDalI9AJcywvUMVxM077.m4a\r\n重生之红星传奇348(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M06/04/C9/wKgJNlhiCIzzglAGAJfekvBlax0858.m4a\r\n重生之红星传奇349(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M0B/04/99/wKgJMFhiCeHhgT1lAJb69IbadoI532.m4a\r\n重生之红星传奇350(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M0A/04/9B/wKgJMFhiCsOBqRe6AJqMUaL2220644.m4a\r\n重生之红星传奇351(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M03/04/E2/wKgJM1hiC0HAH6pwAJdXenb2bAU950.m4a\r\n重生之红星传奇352(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M09/02/C0/wKgJKFhhPR3yd4_IAJ0GspkXvyw039.m4a\r\n重生之红星传奇353(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M05/06/D1/wKgJMFhijovRu03nAJa3alcL8I4042.m4a\r\n重生之红星传奇354(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M02/0A/70/wKgJMVhj3pniZhpZAJd8LqQnv3Y169.m4a\r\n重生之红星传奇356(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M04/0E/4C/wKgJMVhlEcKAPA-gAJbjeP-kvs8970.m4a\r\n重生之红星传奇355(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M03/0E/FF/wKgJMVhlKbXywu8gAJSE_6uIFic093.m4a\r\n重生之红星传奇357(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M03/19/38/wKgJLVhnvyeSNOoVAJWgaua7EmY350.m4a\r\n重生之红星传奇358(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M08/1E/27/wKgJMVhpFvWx0bP5AJaf6nyiV7Y371.m4a\r\n重生之红星传奇359(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M08/27/FB/wKgJM1hrvonRKl2KAJgAVxIEw7s604.m4a\r\n重生之红星传奇360 236(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M03/22/B1/wKgJNVhqiMrB3Gg6AJfIiSqGLiE261.m4a\r\n重生之红星传奇361(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M07/34/82/wKgJMVhuP3DiLm5iAJh3SBHPOlM045.m4a\r\n重生之红星传奇362(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M0B/3E/5A/wKgJKFhvn0-h03JxAJW_QP73pBo350.m4a\r\n重生之红星传奇363(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M08/4B/84/wKgJM1hxC83ge-7RAJZplLqoiUE109.m4a\r\n重生之红星传奇364$http://audio.xmcdn.com/group23/M01/56/D6/wKgJNFhyV2yxeTQMAJXoXgth4io559.m4a\r\n重生之红星传奇365(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M02/5B/2D/wKgJMFhzAEfD1d3QAJZWfmGXBOY254.m4a\r\n重生之红星传奇366(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M0A/6E/48/wKgJNlh1vymwxYnpAJU-BkftXr4088.m4a\r\n重生之红星传奇367(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M09/7A/B3/wKgJNlh3g8vCd3jvAJakUYXkxDk660.m4a\r\n重生之红星传奇368(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M01/95/09/wKgJNVh7fKejqTvqAJhqEP27_no855.m4a\r\n重生之红星传奇369(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M09/9E/0E/wKgJNlh80OXyCwlLAJw3pX1u3mM812.m4a\r\n重生之红星传奇370(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M09/A7/63/wKgJNlh-LNCyKOqOAJXrTT9sbSQ537.m4a\r\n重生之红星传奇371(粉丝QQ群：532909356$http://audio.xmcdn.com/group25/M0A/B0/2B/wKgJNlh_ej2i4a0AAJVD5NqQ4Po691.m4a\r\n重生之红星传奇372(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M05/B8/17/wKgJMViAnT_hxBp_AJhv8h6AWQk025.m4a\r\n重生之红星传奇373(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M06/C6/DB/wKgJL1iCLu2zi22xAJZHz5sY1XQ770.m4a\r\n重生之红星传奇374(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M01/CF/A6/wKgJLViDVNOBwEueAJeQu7RwWqI305.m4a\r\n重生之红星传奇375(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M06/DE/2E/wKgJNViEuqjiXxncAJh7rm-mio8199.m4a\r\n重生之红星传奇376(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M06/F4/1B/wKgJMFiHaAXxAs6zAJR5QpgPA5c495.m4a\r\n重生之红星传奇377(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M04/F4/BE/wKgJMViHeUiygOkuAITjhPrhXuM296.m4a\r\n重生之红星传奇378(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M03/08/62/wKgJNViKEcyh8aFRAI3gj_rAcp0116.m4a\r\n重生之红星传奇379(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M01/4B/DF/wKgJL1iTUKzC8hK_AIgkIFwQ430899.m4a\r\n重生之红星传奇381(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M09/1C/BB/wKgJMViNPt6gTjfwAHZwh9k4Ec8365.m4a\r\n重生之红星传奇382(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M06/27/A8/wKgJNViO1o6QV8LNAJXuPFhn-Pc726.m4a\r\n重生之红星传奇383(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M06/32/1C/wKgJKFiQWrfi9o_LAJCkV9Tw4Gw547.m4a\r\n重生之红星传奇384(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M00/36/F1/wKgJMViQx5TAN5B7AKJNp3-I4u4470.m4a\r\n重生之红星传奇380(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M00/4A/7E/wKgJNViTUU7ynARqAHZwh8wc39E305.m4a\r\n重生之红星传奇385(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M0B/5B/0F/wKgJL1iV5W2Rkn9DAJWpNyOVHmA348.m4a\r\n重生之红星传奇386(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M04/5A/C7/wKgJM1iV5-yw8eOwAJh-oQbJC-4074.m4a\r\n重生之红星传奇387(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M00/5A/5F/wKgJNViWA_bSS7riAJMkkvV0-wc864.m4a\r\n重生之红星传奇388(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M01/65/B4/wKgJM1iYhEbyvEXnAJfaJ_iJiSA346.m4a\r\n重生之红星传奇389(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M02/67/E8/wKgJNFiZWsuwQNS1AJabhLDso4A478.m4a\r\n重生之红星传奇390(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M09/6C/4A/wKgJNFiaq-mBn-GbAJRe024P0Ls290.m4a\r\n重生之红星传奇391大家元宵节快乐$http://audio.xmcdn.com/group21/M03/79/45/wKgJLVifLpmAG2ZPAJR3xxj37ls646.m4a\r\n重生之红星传奇392$http://audio.xmcdn.com/group25/M0A/86/ED/wKgJMVijBIqQzoClAJYBUrjB10I989.m4a\r\n重生之红星传奇393祝大家情人节快乐，有情人终成眷属$http://audio.xmcdn.com/group23/M09/88/07/wKgJL1ijCJaDYZFrAJnvNccoKAU193.m4a\r\n重生之红星传奇394祝大家情人节快乐，有情人终成眷属$http://audio.xmcdn.com/group21/M03/85/05/wKgJLVijCdDjrw5uAJqWmtfLLrE700.m4a\r\n重生之红星传奇395(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M07/8C/78/wKgJL1ikZYWAkXCKAJo0NjqWYVk479.m4a\r\n重生之红星传奇396(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M06/8E/EA/wKgJMVilmQrB-_X-AJfYsJglqFg565.m4a\r\n重生之红星传奇397(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M09/94/03/wKgJMVinCprCjI_TAJQGuHT5yAQ896.m4a\r\n重生之红星传奇398(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M00/9B/39/wKgJNVipo56hVnvrAJW8UTMKmJw095.m4a\r\n重生之红星传奇400(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M0B/A7/24/wKgJL1iscHKwYhQVAJhy4TaNMuk667.m4a\r\n重生之红星传奇401(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M07/AB/CE/wKgJL1itrV_AjUb8AJZgx0uDvCo811.m4a\r\n重生之红星传奇402(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M00/AF/4A/wKgJMViu9u6zXTYGAJZvdju7pYU635.m4a\r\n重生之红星传奇403(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M06/B1/70/wKgJKFiwP-Gi9akyAJTtQFGtGCs491.m4a\r\n重生之红星传奇399(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M08/B2/D1/wKgJNViwRirgmdQ7AJQhJ6w5XHs034.m4a\r\n重生之红星传奇404(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M0A/B8/34/wKgJNlixli_AHuffAJftQRIeQhg135.m4a\r\n重生之红星传奇405 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M06/BE/07/wKgJL1iy6PjSfLW_AJlX8ocH-z4749.m4a\r\n重生之红星传奇406(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M06/BF/F4/wKgJMFi0PUHTIOtLAJXhBb1FbFY206.m4a\r\n重生之红星传奇407(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M03/C3/6A/wKgJNFi03-qBqSRrAJYKI8lB8P0583.m4a\r\n重生之红星传奇408(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M0A/C4/90/wKgJKFi2J5ziLro0AJG54fQdtSI268.m4a\r\n重生之红星传奇409(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M07/CD/32/wKgJL1i3jW6D3ZcVAJbiAMq2qXM667.m4a\r\n重生之红星传奇410(粉丝QQ群：532909356)$http://audio.xmcdn.com/group18/M06/AD/57/wKgJJVi4QpbCE4ZtAJcILJe7G0c052.m4a\r\n重生之红星传奇411(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M0A/D2/83/wKgJL1i6D_7BagzRAJZyZXe1IbY716.m4a\r\n重生之红星传奇412(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M01/D3/C6/wKgJLVi8EifRpkSQAJTuvJI7i9w823.m4a\r\n重生之红星传奇413(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M0B/D8/D3/wKgJM1i9WoGRteOHAJHUTFHR-TM815.m4a\r\n重生之红星传奇414(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M0A/BA/9C/wKgJJli-mnrDYrq3AJfkcNJgk-0868.m4a\r\n重生之红星传奇415(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M0B/DB/03/wKgJMVi-n36hAXk2AJWZEMQmqxo315.m4a\r\n重生之红星传奇416(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M00/DE/14/wKgJM1i_9aKhuzHjAJXWvPz_mbo720.m4a\r\n重生之红星传奇417(粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M03/DE/D6/wKgJNFi_-G6ixZ_xAJlplPR5PwA595.m4a\r\n重生之红星传奇418(粉丝QQ群：532909356)$http://audio.xmcdn.com/group19/M07/C0/43/wKgJK1jBTU6jRS-1AJYbwVeKIUc516.m4a\r\n重生之红星传奇419(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M02/E4/0E/wKgJM1jCwp2yjXCPAJgWYG04aXY146.m4a\r\n重生之红星传奇420(粉丝QQ群：532909356)$http://audio.xmcdn.com/group25/M00/E6/F7/wKgJNljCzN2DAuolAJT-4812HC8014.m4a\r\n重生之红星传奇421(粉丝QQ群：532909356)$http://audio.xmcdn.com/group22/M01/EA/69/wKgJM1jFbJvDqXaIAJRu-hyEUqk425.m4a\r\n重生之红星传奇422 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group23/M09/E9/48/wKgJNFjGhvjxvSPFAJT6eIV3wbQ984.m4a\r\n重生之红星传奇423(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M08/0C/F3/wKgJRljH45GAv4fhAJdC6Rf12Xg291.m4a\r\n重生之红星传奇424(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M01/16/72/wKgJRljJOFmQIcRTAJa6WZZ6MYY307.m4a\r\n重生之红星传奇425(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M02/15/FE/wKgJW1jJa5CzozlEAJSAmNOsCmw780.m4a\r\n重生之红星传奇426(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M01/2B/6C/wKgJR1jL0vHCYS-hAJiaiOCMw4U886.m4a\r\n重生之红星传奇427(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M08/3C/ED/wKgJR1jNY2ODmfJpAJdC6S8BZAU151.m4a\r\n重生之红星传奇428(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M02/55/92/wKgJW1jP0YexrcIOAJUt35UbTMI848.m4a\r\n重生之红星传奇429(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M04/67/F2/wKgJR1jRT4uhunFOAJO8BwB64yg681.m4a\r\n重生之红星传奇430(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M09/72/82/wKgJW1jScpbS1hBEAJe26_jNA7Y525.m4a\r\n重生之红星传奇431(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M0A/76/A7/wKgJW1jSqHHQcu7qAJX4hdoLv9M445.m4a\r\n重生之红星传奇432(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M08/7A/F4/wKgJRljSqsKhV8e8AJTHFQrw5rs804.m4a\r\n重生之红星传奇433(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M0A/8F/B5/wKgJW1jVLAyjax2AAJYEQWdJ8ro730.m4a\r\n重生之红星传奇434 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M0A/A6/89/wKgJRljXTwPSbjHwAJXTzRLGHiM303.m4a\r\n重生之红星传奇435(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M09/DB/78/wKgJWFjclbPzsc0FAJPNcw_ITI8155.m4a\r\n重生之红星传奇436(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M08/DB/9C/wKgJRljcl5axd4RgAJnaowkwr-k009.m4a\r\n重生之红星传奇437(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M0A/D7/65/wKgJR1jcmOGwGdAyAJdBcWzBPtk379.m4a\r\n重生之红星传奇439(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M04/D7/6E/wKgJR1jcmZTioR6lAJUn_RNpJI0169.m4a\r\n重生之红星传奇439(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M05/D7/28/wKgJR1jcksHCkLM3AJUn_X3eK6k262.m4a\r\n重生之红星传奇440(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M04/EE/6C/wKgJR1jeZrLRFfMjAJJOMMifLr4129.m4a\r\n重生之红星传奇441(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M06/F8/AB/wKgJRljfOlHAOzAoAJRgS2Fsv8A499.m4a\r\n重生之红星传奇442(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M09/08/7A/wKgJR1jhG2jTKAnDAJ_L8ffLlUo702.m4a\r\n重生之红星传奇443(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M09/13/7B/wKgJR1jiW6SyZ-ovAJWL2A8RVyY960.m4a\r\n重生之红星传奇444(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M05/46/82/wKgJW1jngxfCR6OWAJWL2A3wOZs745.m4a\r\n重生之红星传奇445(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M00/46/2F/wKgJR1jngAGhv63IAJVUC39Fnfg399.m4a\r\n重生之红星传奇446(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M05/3D/6C/wKgJRljmMZ-CenPQAJdBcUMwKgM958.m4a\r\n重生之红星传奇447(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M02/4A/DE/wKgJRljnhCageNDnAJhZ6dl6Dmo927.m4a\r\n重生之红星传奇448(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M09/58/89/wKgJWFjo0xCREyfSAJrbnwm37yU174.m4a\r\n重生之红星传奇449(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M0B/64/ED/wKgJR1jqQ_HQi14fAJai2eC_AWE939.m4a\r\n重生之红星传奇450(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M06/6B/7B/wKgJWFjqcA6BC_8dAJVUC2awKsU614.m4a\r\n重生之红星传奇451(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M04/78/59/wKgJR1jsaP-jEsUXAJgcPpsyk0w010.m4a\r\n重生之红星传奇452$http://audio.xmcdn.com/group26/M05/92/F0/wKgJRljuSFmy-vPkAJ45mYrpkEA029.m4a\r\n重生之红星传奇453(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M08/8E/E0/wKgJW1juUUbw75KUAJZX9lwIBD8093.m4a\r\n重生之红星传奇454(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M04/9E/D8/wKgJW1jwPo2xn5zgAJZw7TUUzQ8998.m4a\r\n重生之红星传奇455(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M01/B0/F8/wKgJW1jyJRWQdg1yAJe52u7IJh4454.m4a\r\n重生之红星传奇456重生之红星传奇456$http://audio.xmcdn.com/group26/M02/C4/3E/wKgJWFjzkROhMZVPAJXj9PVHucY442.m4a\r\n重生之红星传奇457(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M03/CD/40/wKgJWFj0tNSSw-t1AJRjOqHv0kE990.m4a\r\n重生之红星传奇458(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M03/E0/69/wKgJWFj2LGfy-u0jAJheUBvTdfo243.m4a\r\n重生之红星传奇459(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M07/F0/59/wKgJR1j3hm3iZb4yAJsaw1H341s867.m4a\r\n重生之红星传奇460(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M06/03/A6/wKgJRlj4tZ6xZV2vAJfS0qw3u-0430.m4a\r\n重生之红星传奇461重生之红星传奇462$http://audio.xmcdn.com/group27/M07/14/64/wKgJR1j6IEORJUDZAJnO5-rUsAQ321.m4a\r\n重生之红星传奇462(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M08/1C/32/wKgJW1j66O6AnN_8AJXAt8WcSmA034.m4a\r\n重生之红星传奇463(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M0A/38/53/wKgJR1j8qnDQuXJmAJgEvRTyR8U463.m4a\r\n重生之红星传奇464$http://audio.xmcdn.com/group26/M00/51/C3/wKgJWFj-COfhn9hdAJr0l2b4YqM793.m4a\r\n重生之红星传奇465(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M00/64/96/wKgJWFj_T_7zqF6CAJbiAHD2-j8918.m4a\r\n重生之红星传奇466$http://audio.xmcdn.com/group26/M02/9B/EC/wKgJRlkDTMeSQw0xAJhkMgDaAEs548.m4a\r\n重生之红星传奇467(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M06/9C/14/wKgJRlkDTl7j6FW_AJicAPhRknQ625.m4a\r\n重生之红星传奇468(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M02/9A/36/wKgJW1kDYyWDm8DAAJa3aiAhXc0005.m4a\r\n重生之红星传奇469(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M07/A9/AA/wKgJR1kEt_XzqW1HAJfo1gN8jBI431.m4a\r\n重生之红星传奇470(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M04/00/96/wKgJR1kLO1TCXl-QAJd9pVuDdeI049.m4a\r\n重生之红星传奇471(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M03/DA/B8/wKgJW1kImqGiaY67AJXZr-5UGBM476.m4a\r\n重生之红星传奇472(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M00/DA/9A/wKgJR1kIm4jzw8fAAJbUyUf2pL8004.m4a\r\n重生之红星传奇473(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M08/E3/89/wKgJR1kJbm_C9bf9AJyIZ44wibg285.m4a\r\n重生之红星传奇474(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M01/03/90/wKgJWFkLMBDD6dKzAJUDSQkmdcI352.m4a\r\n重生之红星传奇475$http://audio.xmcdn.com/group27/M00/12/89/wKgJW1kMjyTDbLz_AJWZEJeY-vM244.m4a\r\n重生之红星传奇476(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M08/25/8B/wKgJW1kN7P7wwlnpAJunvM9m0Rs487.m4a\r\n重生之红星传奇477(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M00/36/F1/wKgJR1kPLPKCtwbOAJvcl2dgKbE160.m4a\r\n重生之红星传奇478(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M00/40/32/wKgJW1kQAr7AwgqqAJZX9vC0aVU466.m4a\r\n重生之红星传奇479(粉丝QQ群：532909356$http://audio.xmcdn.com/group26/M0A/85/16/wKgJRlkUcZHTj7QjAJcfrLegsL0703.m4a\r\n重生之红星传奇480重生之红星传奇480(粉丝QQ群：532909356$http://audio.xmcdn.com/group27/M03/70/62/wKgJR1kTKhuj7WyCAJfwMPP-zkI954.m4a\r\n重生之红星传奇481(粉丝QQ群：532909356$http://audio.xmcdn.com/group26/M07/93/41/wKgJWFkVilvQX0mKAJ6h2xnXitk454.m4a\r\n重生之红星传奇482(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M06/A8/DD/wKgJWFkXFNjzuo8xAJaUKszc4JI110.m4a\r\n重生之红星传奇483(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M08/B7/30/wKgJWFkYQjKjb4-CAJZMNShhz28580.m4a\r\n重生之红星传奇484(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M04/C9/DC/wKgJW1kZus6wQz2lAJkr5UJFiG0020.m4a\r\n重生之红星传奇485(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M07/CC/6B/wKgJR1kZ2emynP9-AJj0G_UQBS4988.m4a\r\n重生之红星传奇486(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M03/16/66/wKgJWVkcbWeQn_WDAJZWflM13DM365.m4a\r\n重生之红星传奇487(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M08/38/7C/wKgJXVkdrrCQjmfeAJWsJqlWicc661.m4a\r\n重生之红星传奇488(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M0A/5C/86/wKgJWVkfCWfDYvYwAJfhgf-vNaE961.m4a\r\n重生之红星传奇489(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M06/7C/AB/wKgJXVkgUlniNaoqAJf0l61iaqM255.m4a\r\n重生之红星传奇490(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M0B/A2/BF/wKgJWVkhqcCz6Yr_AJT-4-Ih3CM654.m4a\r\n重生之红星传奇491(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M00/C8/80/wKgJXVki9QDw8mw3AJi2J-og3Gw973.m4a\r\n重生之红星传奇492(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M04/13/A7/wKgJXFkkMZngqQUdAJa6WSzN6pI058.m4a\r\n重生之红星传奇493(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M09/E7/DF/wKgJXVklgymQlAOWAJjuOZ4mdCw529.m4a\r\n重生之红星传奇494(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M0B/3C/EC/wKgJSFkmuCrhJ7fSAJmulrRKqPM878.m4a\r\n重生之红星传奇495(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M02/68/18/wKgJXFkoGunQHJi7AJjyo4Q49Xs871.m4a\r\n重生之红星传奇496(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M08/91/51/wKgJXFkpm6nhktwkAJa6WYrjidM272.m4a\r\n重生之红星传奇497$http://audio.xmcdn.com/group28/M08/AE/EF/wKgJXFkq4_7gdZKnAJcA1s6hcAk720.m4a\r\n重生之红星传奇498(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M08/D0/5A/wKgJXFksPkTxGwLiAJSE_9JHR0c085.m4a\r\n重生之红星传奇499(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M07/F2/DF/wKgJXFktlAHR5ozpAJf0l6OXt14358.m4a\r\n重生之红星传奇500(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M05/0B/48/wKgJXVkuzy-SA1PvAJiaiOP5Wis644.m4a\r\n重生之红星传奇501(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M05/1E/1F/wKgJSFkwFSKiGmWUAJVJxm221ho011.m4a\r\n重生之红星传奇502(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M05/38/22/wKgJXFkxii-xrgjeAJeVJhNORKw784.m4a\r\n重生之红星传奇503(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M04/48/4F/wKgJXVkyxMqS5y7YAJdC6bnU6Ic046.m4a\r\n重生之红星传奇504重生之红星传奇504$http://audio.xmcdn.com/group28/M03/62/1B/wKgJSFk0KtXSJowUAJR_IKpHnCY043.m4a\r\n重生之红星传奇505(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M06/71/BC/wKgJXVk1Y5XwwvfnAJWXmSrN8IU361.m4a\r\n重生之红星传奇506(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M00/8B/B2/wKgJSFk2v3TRal57AJoyvwZrYhE399.m4a\r\n重生之红星传奇507(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M02/A4/5B/wKgJXFk4ISqCjXK0AJVkNYZbat8224.m4a\r\n重生之红星传奇508(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M05/B5/8C/wKgJXVk5cpfge8xXAJsKnPJIOik911.m4a\r\n重生之红星传奇509(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M06/D9/17/wKgJSFk79o_yv52IAJlz2bF1wVo475.m4a\r\n重生之红星传奇510(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M08/D8/E8/wKgJWVk8CcvSD0IWAJeps84a7N4706.m4a\r\n重生之红星传奇511(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M08/EB/7D/wKgJWVk9ZmygkMRVAJXIDUBcseA779.m4a\r\n重生之红星传奇512(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M01/02/8A/wKgJXFk-uxPSHeDZAJmwDUytYL4263.m4a\r\n重生之红星传奇513(粉Q群：532909356)$http://audio.xmcdn.com/group29/M00/26/30/wKgJXVlBXL6C2PF9AJf0lx1NViU047.m4a\r\n重生之红星传奇514(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M04/38/71/wKgJXVlCjxrhrLQfAJi355tZ_OY100.m4a\r\n重生之红星传奇515(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M0B/40/EB/wKgJXVlDHcjTEKtZAJZ4Q64VSAM319.m4a\r\n重生之红星传奇516(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M02/62/57/wKgJWVlFMLbzsrwTAKe8QE2_3tg568.m4a\r\n重生之红星传奇517(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M0A/76/5E/wKgJWVlGg8mj2MXFAJ8wSBM6Ex0507.m4a\r\n重生之红星传奇518(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M06/87/FE/wKgJSFlH0IXT_B-zAJxHzF80HjE283.m4a\r\n重生之红星传奇519(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M06/9B/C2/wKgJXVlJPVSQabj3AJquGvBD45g146.m4a\r\n重生之红星传奇520(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M0B/B0/25/wKgJXFlKlf2QhGSqAJdu9rFII1c660.m4a\r\n重生之红星传奇521(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M03/BF/17/wKgJWVlL5M_j6GIFAJfRWgjbIUk885.m4a\r\n重生之红星传奇522(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M01/DF/94/wKgJXVlOfUSAKwPKAJYbwUv7ads539.m4a\r\n重生之红星传奇523(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M05/F3/E6/wKgJSFlP3OehLHTjAJynPRfzD2c123.m4a\r\n重生之红星传奇524(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M00/06/70/wKgJWVlRLhODJhQpAJjYNPHqZDA466.m4a\r\n重生之红星传奇525(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M0B/19/CE/wKgJXVlSfC3RH52nAJiEfwgklQw075.m4a\r\n重生之红星传奇526(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M04/2E/0C/wKgJSFlT0eeywzTpAJaRO6lV3gc449.m4a\r\n重生之红星传奇527(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M09/31/D3/wKgJWVlUhMzRrBULAJpb3Xvqpsk360.m4a\r\n重生之红星传奇528(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M01/3D/7A/wKgJWVlVMYryyTkWAJgjk6TfOoc547.m4a\r\n重生之红星传奇529(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M09/A9/A4/wKgJSFldB9-h8T6oAJe1c201f4Q419.m4a\r\n重生之红星传奇530$http://audio.xmcdn.com/group29/M09/A7/9A/wKgJXVldCSKzjRCfAJcQ_QWrPAg845.m4a\r\n重生之红星传奇531(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M04/95/B5/wKgJSFlbty3wtZzYAJvoVx_mn5s924.m4a\r\n重生之红星传奇532(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M06/C1/55/wKgJXVlfCI3DlIkXAJbBr9VnS4k800.m4a\r\n重生之红星传奇533(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M01/CF/2B/wKgJWVlgBWnjWp_WAJfBMw6g_H0826.m4a\r\n重生之红星传奇534(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M01/DF/51/wKgJWVlg_lriise0AJbL-K067YE016.m4a\r\n重生之红星传奇535(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M06/F3/B5/wKgJSFliTljD0DNiAJmwDcVowj4190.m4a\r\n重生之红星传奇536(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M00/09/E7/wKgJXFlj-O3xbzfLAJb4BczO_X4549.m4a\r\n重生之红星传奇537(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M02/17/A1/wKgJWVlk9BzyRi2CAJdTDxZ8vZc381.m4a\r\n重生之红星传奇538(粉丝QQ群：532909356)$http://audio.xmcdn.com/group29/M00/29/FF/wKgJXVlmSY3Ak-v7AJdEYAWAeDk117.m4a\r\n重生之红星传奇539(粉丝QQ群：532909356)$http://audio.xmcdn.com/group28/M01/44/7E/wKgJXFlnmY-DkSTFAJeE_8XSC7s793.m4a\r\n重生之红星传奇540(粉丝QQ群：532909356)$http://audio.xmcdn.com/group2/M00/15/79/wKgJRVlsvdeTMVrWAJku2HsctuU346.m4a\r\n重生之红星传奇541(粉丝QQ群：532909356)$http://audio.xmcdn.com/group26/M00/F7/44/wKgJRlls2Wvif_FcAJlDZetEukc339.m4a\r\n重生之红星传奇542(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M09/0F/99/wKgJX1lumkTTBJkWAJgwy5VzTW4938.m4a\r\n重生之红星传奇543(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M01/60/B0/wKgJXllwsuCQiCCuAJrdFyUkd_M985.m4a\r\n重生之红星传奇544(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M0A/84/2D/wKgJXllx_KzgQ4-LAJeE_09Ua9I076.m4a\r\n重生之红星传奇545(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M06/D2/F3/wKgJXll0wrahddunAJhLOvuCK8s910.m4a\r\n重生之红星传奇546(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M0A/6B/60/wKgJX1l0wtPwxdl3AJaM1C0kX-U038.m4a\r\n重生之红星传奇547(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M02/7D/E9/wKgJSVl2DX7g8SANAJYCyjQ-b2o100.m4a\r\n重生之红星传奇548(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M07/21/F7/wKgJXll3aePAQeCAAJZz3RbCYvY172.m4a\r\n重生之红星传奇549(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M02/47/97/wKgJXll4roXgS5GWAJece0AgSTw833.m4a\r\n重生之红星传奇550(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M00/B8/2C/wKgJXll8nNnRLMAmAJw3pdEkUO0529.m4a\r\n重生之红星传奇551(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M07/EC/FA/wKgJSVl91I2yEFCvAJgcPoEOhDw399.m4a\r\n重生之红星传奇552(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M07/4A/31/wKgJXlmB1cDhONluAJUiH9F7OwI270.m4a\r\n重生之红星传奇553(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M09/4A/43/wKgJXlmB1eeyl6xaAJeQu5VGPd4551.m4a\r\n重生之红星传奇554(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M0A/2A/9D/wKgJX1mB-qGy5xa_AJW5XlM1gdc819.m4a\r\n重生之红星传奇555(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M05/78/C9/wKgJXlmDTKLzx9dTAJrCp0sJOfw224.m4a\r\n重生之红星传奇556(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M04/51/96/wKgJSVmEnK2BAVj4AJe-RJClwfI802.m4a\r\n重生之红星传奇557(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M06/C1/F1/wKgJXlmF7LPBnR4OAJc7k9XKh0w038.m4a\r\n重生之红星传奇558(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M06/7B/4F/wKgJX1mH5wrA6RpLAJidd1RE3as886.m4a\r\n重生之红星传奇559(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M05/8D/4C/wKgJSVmJLv_Rp3Y2AJefap35ZRY540.m4a\r\n重生之红星传奇560(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M04/3A/2D/wKgJXlmKfmyiK2pLAJc_-ltAyXI249.m4a\r\n重生之红星传奇561(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M0A/61/83/wKgJXlmL1qfgWTPVAJq1uUYmL6E553.m4a\r\n重生之红星传奇562(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M01/87/A3/wKgJXlmNH3iwhzbOAJXeFs-qNPU043.m4a\r\n重生之红星传奇563(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M04/2E/74/wKgJSVmO8IGweHFsAJbdlm6timM947.m4a\r\n重生之红星传奇564(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M07/37/EB/wKgJSVmPKuPDyEjmAJbDJ6nODe8094.m4a\r\n重生之红星传奇565(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M02/9E/00/wKgJSVmRuRTwlqeCAJbUyYBoXJ0306.m4a\r\n重生之红星传奇566(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M07/F8/FE/wKgJSVmTEsezdlWGAJYo-SAA0yA601.m4a\r\n重生之红星传奇567(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M06/EE/FD/wKgJKFmUZ3bDWg9wAJZQoBmWZBI923.m4a\r\n重生之红星传奇568(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M0B/0A/36/wKgJnFmWKMvxH6_PAJrtPpHwP6c400.m4a\r\n重生之红星传奇569$http://audio.xmcdn.com/group32/M04/29/C2/wKgJnFmYQUmDRsD6AJY6l2S5FhU380.m4a\r\n重生之红星传奇570(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M02/3A/CE/wKgJTFmZieDR9KpbAJjDo18gpF4717.m4a\r\n重生之红星传奇571(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M0B/8C/77/wKgJnFme9wKCwlOrAJbWQHuNbqs696.m4a\r\n重生之红星传奇572(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M0B/8B/FF/wKgJS1me9xiwy5fhAJbQXgeO1Yg203.m4a\r\n重生之红星传奇573(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M0B/8C/7C/wKgJnFme9yeidLWAAJj7cc9PBdw272.m4a\r\n重生之红星传奇574(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M07/8C/83/wKgJnVme9tLTpwkdAJZHzz5jpYM852.m4a\r\n重生之红星传奇575(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M05/9A/93/wKgJnFmgGsXyq-kKAJZ1VLa7aM4822.m4a\r\n重生之红星传奇576(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M01/AD/06/wKgJS1mhe_TirCpiAJZJRvTDpuY227.m4a\r\n重生之红星传奇577(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M09/C4/AA/wKgJnVmi4UDxwc0uAJhbYSCCmJU901.m4a\r\n重生之红星传奇578(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M0A/CF/DD/wKgJTFmkJiaC1yv7AJcxSo-XcoM140.m4a\r\n重生之红星传奇579(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M09/DD/70/wKgJTFmliXLAwC_EAJxw54COXL0565.m4a\r\n重生之红星传奇580(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M05/E9/5F/wKgJnVmm1SeShoGmAJVfy-Y3-hk696.m4a\r\n重生之红星传奇581(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M05/0B/4B/wKgJnVmqtYnBpfZKAJXJhEMLKbw220.m4a\r\n重生之红星传奇582(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M0A/8F/84/wKgJXlmrcdeAI1a8AJgPBhjN-XE636.m4a\r\n重生之红星传奇583(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M06/0B/5F/wKgJTFmqtXrze9wfAJZ5u_5AmlY232.m4a\r\n重生之红星传奇584(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M0A/10/32/wKgJnFmrcnzgpl2bAJV9KQjqAuw752.m4a\r\n重生之红星传奇586(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M02/45/BF/wKgJSVmulaigB8pEAJYCynFwq2c191.m4a\r\n重生之红星传奇585(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M0B/3C/49/wKgJSVmtcSeBkxeGAJmzAFSEL0s052.m4a\r\n重生之红星传奇587(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M0B/48/37/wKgJUlooIVnDKSxQAJZ5u6SCXk4232.m4a\r\n重生之红星传奇588(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M00/56/BE/wKgJS1mywPKyv184AJd2UGUlnqI617.m4a\r\n重生之红星传奇589(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M05/57/11/wKgJnFmyvEmir0RGAJW9yKBJoK8950.m4a\r\n重生之红星传奇590(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M02/56/AE/wKgJnFmytAvQJftiAJfXOB3_3GI400.m4a\r\n重生之红星传奇591(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M03/78/97/wKgJSVmz2H-gGZvtAJbcHiDTsmM337.m4a\r\n重生之红星传奇592(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M06/92/CF/wKgJS1m5GxOB2FOPAJbWQDvRFgw865.m4a\r\n重生之红星传奇593(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M08/AB/1B/wKgJSVm5G8ySyxmUAJZfT5u0Qms968.m4a\r\n重生之红星传奇594(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M04/AB/31/wKgJSVm5HN6iiOtzAJi35znVfMA239.m4a\r\n重生之红星传奇595(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M01/EE/76/wKgJnVnCjSCSp6IhAJx4QFc8Dwg212.m4a\r\n重生之红星传奇596(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M03/EE/7A/wKgJnVnCjT_CyhV3AJcs5HYvV8g249.m4a\r\n重生之红星传奇597(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M03/EE/80/wKgJnVnCjWjhyooxAJspcovQMco578.m4a\r\n重生之红星传奇598(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M0B/0E/39/wKgJnVnGLefiPL7DAJpte5kD4Ss102.m4a\r\n重生之红星传奇599(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M00/6B/D4/wKgJX1nCkFGhJEaUAJe-RDG20fE452.m4a\r\n重生之红星传奇600(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M07/ED/D1/wKgJS1nClAbx1JUoAJ0Zx4FDDRU862.m4a\r\n重生之红星传奇601(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M00/EE/0D/wKgJTFnChgvTcMwiAJdXevCyk4U667.m4a\r\n重生之红星传奇602(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M00/F8/9B/wKgJTFnDvf6jQZveAJkxx6eemnw950.m4a\r\n重生之红星传奇603(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M03/76/AC/wKgJX1nDxY3gdT45AJZAecWTqUo503.m4a\r\n重生之红星传奇604(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M04/0E/4B/wKgJTFnGLcKjx0i6AJece7v37Qs861.m4a\r\n重生之红星传奇605(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M03/0F/28/wKgJnFnGSyiTSt2CAJXZrxfU4Dk133.m4a\r\n重生之红星传奇606(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M0A/C1/84/wKgJXlnHyzCyIpL2AJc0Ogu0cFM761.m4a\r\n重生之红星传奇607(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M08/28/35/wKgJnFnJC1aDx5ptAJTekQreVc4980.m4a\r\n重生之红星传奇608(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M04/1E/DB/wKgJWlnKblXwt2q2AJfUSe39JxQ868.m4a\r\n重生之红星传奇609(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M08/6E/29/wKgJWlnNG_6CCgB4AJgwy-IMm74458.m4a\r\n重生之红星传奇610(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M01/6E/19/wKgJWlnNG2yiJlzrAJeZjEFP1N4519.m4a\r\n重生之红星传奇611(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M06/6B/B2/wKgJXlnOZyKgLZadAJb_X77EN20780.m4a\r\n重生之红星传奇612祝大家国庆快乐$http://audio.xmcdn.com/group30/M04/A9/B6/wKgJXlnQ_8azLsTPAJc7k8xLIf0038.m4a\r\n重生之红星传奇613大家国庆快乐$http://audio.xmcdn.com/group30/M00/CE/B4/wKgJWlnRARuBvQM6AJfUSfoxkds234.m4a\r\n重生之红星传奇614(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M06/31/D5/wKgJTFnSTjrAtxiVAJlcXVGYy68878.m4a\r\n重生之红星传奇615(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M08/C3/84/wKgJXlnTfliT7Ts0AJn2ipxinEM454.m4a\r\n重生之红星传奇616(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M0A/EF/7B/wKgJWlnUwEChdVlkAJmSr4aDRZ8971.m4a\r\n重生之红星传奇617(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M00/47/04/wKgJnFnWJh_AsiOxAJmebzEB2uI012.m4a\r\n重生之红星传奇618(粉丝QQ群：532909356)$http://audio.xmcdn.com/group34/M01/1D/AB/wKgJYVnXarHick91AJdHTwjZLOI888.m4a\r\n重生之红星传奇619(粉丝QQ群：532909356)$http://audio.xmcdn.com/group34/M08/3B/F8/wKgJYFnYu1GAWSSXAJbQXkm8RfY721.m4a\r\n重生之红星传奇620(粉丝QQ群：532909356)$http://audio.xmcdn.com/group34/M06/86/C0/wKgJYVnaEFvSFN49AJqMUcfyuB4621.m4a\r\n重生之红星传奇622(粉丝QQ群：532909356)$http://audio.xmcdn.com/group34/M05/F5/46/wKgJYVncyMXDMaC7AJaXGYh1FZ0203.m4a\r\n重生之红星传奇621(粉丝QQ群：532909356)$http://audio.xmcdn.com/group34/M04/F5/FC/wKgJYVncyx2yDxTJAJgaxk7fMk4465.m4a\r\n重生之红星传奇623(粉丝QQ群：532909356)$http://audio.xmcdn.com/group34/M04/94/CD/wKgJYFndl9DgLRyGAJcs5F1mTE8188.m4a\r\n重生之红星传奇624(粉丝QQ群：532909356)$http://audio.xmcdn.com/group34/M06/3F/D0/wKgJYVnfU5njVrpwAJuNTVE82Tw451.m4a\r\n重生之红星传奇625(粉丝QQ群：532909356)$http://audio.xmcdn.com/group34/M05/64/54/wKgJYVngpDeiV16wAJhPoQRGiS4701.m4a\r\n重生之红星传奇626(粉丝QQ群：532909356)$http://audio.xmcdn.com/group34/M09/1A/03/wKgJYFniDcHROqDTAJizfNdseHk820.m4a\r\n重生之红星传奇627(粉丝QQ群：532909...$http://audio.xmcdn.com/group34/M0B/C0/79/wKgJYVnjhHvj1mPBAJcYU4GQWNk554.m4a\r\n重生之红星传奇629(粉丝QQ群：532909356)$http://audio.xmcdn.com/group34/M05/03/46/wKgJYVnvTw-BRH-IAJRe0wvHuQw095.m4a\r\n重生之红星传奇628(粉丝QQ群：532909356)$http://audio.xmcdn.com/group34/M09/8E/34/wKgJYFnvTOWQIZwCAJi09KCum6s846.m4a\r\n重生之红星传奇630(粉丝QQ群：532909356)$http://audio.xmcdn.com/group34/M09/26/21/wKgJYVnwofPjj4nyAJgyQqhq5aA828.m4a\r\n重生之红星传奇631(粉丝QQ群：532909356)$http://audio.xmcdn.com/group34/M01/4A/90/wKgJYVnx9U-Ag_hKAJnyJLhTI8o576.m4a\r\n重生之红星传奇632(粉丝QQ群：532909356)$http://audio.xmcdn.com/group34/M09/EC/84/wKgJYFnzHQ-wXCqAAJWh4f4igqE085.m4a\r\n重生之红星传奇633(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M0B/1C/27/wKgJUFn0qZWxNoaLAJbvNGWGPew747.m4a\r\n重生之红星传奇634(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M01/82/87/wKgJS1n12p-BSjRjAJZz3aTlNi4319.m4a\r\n重生之红星传奇635(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M02/CD/FA/wKgJS1n4nvyAlHdRAJh3SL6yVfY039.m4a\r\n重生之红星传奇636(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M01/CE/08/wKgJS1n4n4uhw2rEAJmYkRMuT1o546.m4a\r\n重生之红星传奇637(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M07/A5/89/wKgJUFn511PjwtFTAJdpGA7OFR0558.m4a\r\n重生之红星传奇638(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M08/13/60/wKgJS1n7M7TCepqSAJRNNYjU-1Y423.m4a\r\n重生之红星传奇639(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M03/36/30/wKgJS1n8jeHBu1_4AJb4BRQx_gU985.m4a\r\n重生之红星传奇640$http://audio.xmcdn.com/group33/M0A/1E/25/wKgJUVn94J2zac7fAJB20rcaDNo503.m4a\r\n重生之红星传奇641(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M0A/B5/62/wKgJTFoAiAWCQykOAJkReX_pe5M247.m4a\r\n重生之红星传奇642(粉丝QQ群：532909356)$http://audio.xmcdn.com/group33/M02/B5/11/wKgJTFoAhPCBkArbAJR02P0Vo74198.m4a\r\n重生之红星传奇643(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M05/8A/A0/wKgJUlor3SayXHD6AJXrTULAjNk371.m4a\r\n重生之红星传奇644(粉丝QQ群：532909356)$http://audio.xmcdn.com/group35/M00/5B/B5/wKgJnFoJqhzRyB4WAJX7dC7xgrg546.m4a\r\n重生之红星传奇645(粉丝QQ群：532909356)$http://audio.xmcdn.com/group35/M07/3D/0F/wKgJnVoLCofgLqZ6AJbwsLSS7GA201.m4a\r\n重生之红星传奇646重生之红星传奇646$http://audio.xmcdn.com/group35/M02/87/C3/wKgJnFoLDtnSql1DAJhRHMHOq7Q694.m4a\r\n重生之红星传奇647(粉丝QQ群：532909356)$http://audio.xmcdn.com/group35/M00/AB/A1/wKgJnFoMUYvy-VYgAJZMNT_8nN4289.m4a\r\n重生之红星传奇648(粉丝QQ群：532909356)$http://audio.xmcdn.com/group35/M04/AB/D2/wKgJnFoMUmazQ7eAAJUWX5s5bUI141.m4a\r\n重生之红星传奇649(粉丝QQ群：532909356)$http://audio.xmcdn.com/group32/M08/68/27/wKgJS1ogItijDjT-AJnQXx2ZDkU182.m4a\r\n重生之红星传奇650(粉丝QQ群：532909356)$http://audio.xmcdn.com/group30/M09/27/06/wKgJWlogJsuQdG5sAJZoHKkwB10884.m4a\r\n重生之红星传奇651(粉丝QQ群：532909356)$http://audio.xmcdn.com/group31/M0B/F4/1C/wKgJX1ogKuWTy5FDAJUX1onTeS4111.m4a\r\n重生之红星传奇652(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M05/08/0F/wKgJUlotO4eC9S8CAJaxiGPqzno288.m4a\r\n重生之红星传奇653(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M05/08/2B/wKgJUlotO6vRflOLAJbWQEnAz_8975.m4a\r\n重生之红星传奇654(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M05/09/B2/wKgJUlotPcHhb1DXAJW091psdVQ363.m4a\r\n重生之红星传奇655(粉丝QQ群：532909356)$http://audio.xmcdn.com/group35/M09/8A/B7/wKgJnVoVi3nhzrBNAJLYN7cux2k786.m4a\r\n重生之红星传奇656(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M04/08/91/wKgJUlotPC2xjEUUAJOVpWJc5I8809.m4a\r\n重生之红星传奇657(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M08/08/A0/wKgJUlotPEKSCxptAJX1kvtzZnM974.m4a\r\n重生之红星传奇658(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M08/08/B7/wKgJUlotPGKRP6m9AJa3ahXEimk592.m4a\r\n重生之红星传奇659(粉丝QQ群：532909356)$http://audio.xmcdn.com/group35/M05/C3/ED/wKgJnVogKLHiLBk8AJ4lCBZR-Lo653.m4a\r\n重生之红星传奇660(粉丝QQ群：532909356)$http://audio.xmcdn.com/group24/M01/F9/EC/wKgJMFomhaDA2-roAJf0vpuOmo0239.m4a\r\n重生之红星传奇661(粉丝QQ群：532909356)$http://audio.xmcdn.com/group27/M0B/00/AA/wKgJR1omhemwRSFQAJepxQvnGd4614.m4a\r\n重生之红星传奇662(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M02/DB/50/wKgJJFomhffhtlXpAJzEm-PaFA0891.m4a\r\n重生之红星传奇663(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M07/42/C7/wKgJUlooEGnAFflNAJmCiKfe3pU235.m4a\r\n重生之红星传奇664(粉丝QQ群：532909356$http://audio.xmcdn.com/group36/M0B/BE/03/wKgJUlopYE2jj_q0AJWdd43-lP8056.m4a\r\n重生之红星传奇665 (粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M08/0D/EA/wKgJUloqe1HRBmTFAJkQAg2ydVg620.m4a\r\n重生之红星传奇666(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M00/87/EC/wKgJUlor2QCRCp12AJWZEFizcNQ671.m4a\r\n重生之红星传奇667(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M09/F7/AF/wKgJUlotJi6RmI_9AJhXRdM42Vk536.m4a\r\n重生之红星传奇668(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M01/57/B1/wKgJUlouZ6aTVa1hAJRx6cnfxYc448.m4a\r\n重生之红星传奇669(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M05/C3/5C/wKgJUlovymqRiu2HAJbiADoyuQw561.m4a\r\n重生之红星传奇670(粉丝QQ群：532909356)$http://audio.xmcdn.com/group37/M04/1F/51/wKgJoVoxAnHRrnnSAJiQQJYPzk8112.m4a\r\n重生之红星传奇671(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M0B/88/75/wKgJUlo0Vtng3QJVAJncGwBN0J8368.m4a\r\n重生之红星传奇672(粉丝QQ群：532909356)$http://audio.xmcdn.com/group37/M0A/6A/2F/wKgJoFo0WTfC_48VAJjVRbPTnwM129.m4a\r\n重生之红星传奇673(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M04/E8/94/wKgJUlo2acqTOHv7AJgdtVo_xf8060.m4a\r\n重生之红星传奇674(粉丝QQ群：532909356)$http://audio.xmcdn.com/group37/M03/BF/3A/wKgJoVo35BnCJZ-IAJko9gsMa4c430.m4a\r\n重生之红星传奇675(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M06/6F/9E/wKgJUlo5KaiS3gNcAJsME5IRDvQ354.m4a\r\n重生之红星传奇676(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M01/B3/E6/wKgJUlo6iDKABW1fAJnZLNHyldk954.m4a\r\n重生之红星传奇677(粉丝QQ群：532909356)$http://audio.xmcdn.com/group37/M01/76/75/wKgJoFo_sejzAGFNAKsaOk2Vzn4958.m4a\r\n重生之红星传奇678$http://audio.xmcdn.com/group36/M03/6F/01/wKgJTVpFFS_QVFDDAJahYvAz_OU746.m4a\r\n重生之红星传奇679重生之红星传奇679$http://audio.xmcdn.com/group37/M06/30/A3/wKgJoFpTlR_xBQjhAJaCjNpSl-A892.m4a\r\n重生之红星传奇680(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M02/76/71/wKgJUlpUoQSQcF0tAJbcHsu9w3k813.m4a\r\n重生之红星传奇681(粉丝QQ群：532909356)$http://audio.xmcdn.com/group17/M04/E0/2B/wKgJJFpV_s2QnZ5ZAJftQQH-l24117.m4a\r\n重生之红星传奇682(粉丝QQ群：532909356)$http://audio.xmcdn.com/group21/M03/01/64/wKgJLVpXdprBjRAoAJh-oUoezxo123.m4a\r\n重生之红星传奇683(粉丝QQ群：532909356)$http://audio.xmcdn.com/group36/M0B/D6/13/wKgJTVpZJMXSjb8MAJc_-ieu5bY854.m4a\r\n重生之红星传奇684(粉丝QQ群：532909356)$http://audio.xmcdn.com/group37/M06/59/4E/wKgJoVpbTb3yaYjJAJk9hyeT9x8125.m4a\r\n重生之红星传奇685(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M06/4E/65/wKgJn1pkqMWTSUsPAJc4oF__LtQ576.m4a\r\n重生之红星传奇686(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M02/65/EF/wKgJnlpl0YDiFiy5AJkReZy3aM0339.m4a\r\n重生之红星传奇687(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M00/7C/64/wKgJnlpmy4_hO-emAJ0liNmhcUc467.m4a\r\n重生之红星传奇688(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M09/BE/C2/wKgJnlppaDiBfK4qAJjVRR65OK0904.m4a\r\n重生之红星传奇689(粉丝QQ群：532909356)$http://audio.xmcdn.com/group38/M0A/F0/BB/wKgJo1prUPyAaPXsAJZAeTgZXxM117.m4a\r\n重生之红星传奇690(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M04/26/60/wKgJn1ptuWTj1apgAJqbAL_9iKw146.m4a\r\n重生之红星传奇691(粉丝QQ群：532909356)$http://audio.xmcdn.com/group38/M01/3D/B5/wKgJolpuozKAfWFIAJp6s5DuseY586.m4a\r\n重生之红星传奇692$http://audio.xmcdn.com/group39/M08/5B/DD/wKgJnlpvr6PANiX0AJYEQSO7LPE641.m4a\r\n重生之红星传奇693(粉丝QQ群：532909356)$http://audio.xmcdn.com/group38/M06/7A/E7/wKgJolpw6_6TA3o3AJ9ZZ0Drtlc114.m4a\r\n重生之红星传奇694(粉丝QQ群：532909356)$http://audio.xmcdn.com/group38/M00/90/4B/wKgJolpxu7mCM2VuAJzsQi1G2dk633.m4a\r\n重生之红星传奇695(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M02/90/B3/wKgJn1pxu2ySPwXSAJdtf3EqStw063.m4a\r\n重生之红星传奇696(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M0B/90/C1/wKgJn1pxu97DpFVVAJtv76RLiJk559.m4a\r\n重生之红星传奇697(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M0B/90/D4/wKgJn1pxvBuD-a4hAJdUhyfIrzE612.m4a\r\n重生之红星传奇698(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M0B/91/23/wKgJnlpxu9HSqa41AJfVwYyzLGI701.m4a\r\n重生之红星传奇699(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M0B/90/CB/wKgJn1pxu_mTCJqxAJo4oR0EC24391.m4a\r\n重生之红星传奇700(粉丝QQ群：532909356)$http://audio.xmcdn.com/group38/M05/90/54/wKgJolpxvEHg2LnTAJqNzcn2szM492.m4a\r\n重生之红星传奇701(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M03/91/08/wKgJn1pxvX-RZm6TAJrFlz8UPvE069.m4a\r\n重生之红星传奇702(粉丝QQ群：532909356)$http://audio.xmcdn.com/group38/M09/B5/45/wKgJolpzLLGxVNWxAJi_PPkEQ4s217.m4a\r\n重生之红星传奇703(粉丝QQ群：532909356)$http://audio.xmcdn.com/group38/M03/D5/67/wKgJolp0hnKRlmlUAJqiWtAA-vY083.m4a\r\n重生之红星传奇704$http://audio.xmcdn.com/group38/M08/F7/82/wKgJo1p12z-Tq_5tAJfHEVtZQ7E366.m4a\r\n重生之红星传奇705(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M0A/28/62/wKgJnlp37JKhFHW9AJkqbTYNm3M595.m4a\r\n重生之红星传奇706(粉丝QQ群：532909356)$http://audio.xmcdn.com/group38/M0B/5E/76/wKgJo1p5zwbxMaiTAJgfLfz1Aio704.m4a\r\n重生之红星传奇707(粉丝QQ群：532909356)$http://audio.xmcdn.com/group38/M01/A1/46/wKgJo1p8cITzIAxTAJgMF4LbTTg588.m4a\r\n重生之红星传奇708(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M0B/C2/AA/wKgJn1p9safweCkNAJcYU_Bxx_c765.m4a\r\n重生之红星传奇709(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M06/E4/78/wKgJn1p_EkKCALJVAJWF-vHCbbE051.m4a\r\n重生之红星传奇710(粉丝QQ群：532909356)$http://audio.xmcdn.com/group38/M01/24/3D/wKgJo1qBqIiCsyz2AJa70YpsakA711.m4a\r\n重生之红星传奇711(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M02/33/62/wKgJnlqCeWazZ3OzAJclis96vqk191.m4a\r\n重生之红星传奇712(粉丝QQ群：532909356)$http://audio.xmcdn.com/group39/M04/5F/4D/wKgJnlqEW_PDf5KlAJVA9YZxN0c514.m4a\r\n重生之红星传奇713祝大家新年快乐$http://audio.xmcdn.com/group38/M05/70/26/wKgJo1qFqnjQnprvAJptew_Qoh4863.m4a\r\n重生之红星传奇714大家新年快乐$http://audio.xmcdn.com/group38/M04/77/ED/wKgJolqGcAqBQ913AJeoPHHvbkg904.m4a\r\n重生之红星传奇715(粉丝QQ群：532909356)$http://audio.xmcdn.com/group38/M02/98/37/wKgJolqITZ7jqVoVAJb_X5nPC4g462.m4a\r\n重生之红星传奇716(粉丝QQ群：532909356)$http://audio.xmcdn.com/group37/M01/66/21/wKgJoVqJl1eyHrv0AJez_J70z94220.m4a\r\n重生之红星传奇717多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group33/M05/56/57/wKgJUVqRjOajFl60AJgq7WhJAus054.m4a\r\n重生之红星传奇718重生之红星传奇718$http://audio.xmcdn.com/group41/M05/38/C4/wKgJ8VqVgMPzj3DAAJe-RP1YSpU769.m4a\r\n重生之红星传奇719（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group41/M08/6A/F8/wKgJ8lqXZQziShf8AJbyJ1shq9g340.m4a\r\n重生之红星传奇720（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group42/M02/85/18/wKgJ81qYI53iXtX0AJg1NeJszpM759.m4a\r\n重生之红星传奇721（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group41/M0A/9E/81/wKgJ8lqZTz3jVxVSAJn_WzoFLEw522.m4a\r\n重生之红星传奇722（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group41/M00/C0/7E/wKgJ8lqarvShB4K3AJh9KtPql8U644.m4a\r\n重生之红星传奇723$http://audio.xmcdn.com/group41/M01/02/3E/wKgJ8VqdZc6gHMTlAJXT9au1e3I724.m4a\r\n重生之红星传奇724（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group41/M09/7F/BD/wKgJ8Vqj50Kyb6kPAJKmgfNySyY159.m4a\r\n重生之红星传奇725（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group42/M00/81/0D/wKgJ81qj5zbgitJgAJlcXXOCQlk421.m4a\r\n重生之红星传奇726（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group40/M09/47/18/wKgJT1qj5sWhOnyUAJo3KSDvuDI525.m4a\r\n重生之红星传奇727（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group41/M0B/B0/D9/wKgJ8VqmnyHSTVQqAJcLG1jVNw4865.m4a\r\n重生之红星传奇728（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group40/M05/8C/D1/wKgJT1qn4krCuiecAJkCysf5RF4321.m4a\r\n重生之红星传奇729（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group40/M03/C4/4B/wKgJT1qrVkyzwuRcAJnEn5TSBYU909.m4a\r\n重生之红星传奇730（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group40/M05/E7/A6/wKgJT1qtOrmxHD9yAJc7yWbw6FU943.m4a\r\n重生之红星传奇731（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group42/M03/37/59/wKgJ81quaXyDA4MGAJyPwdnGtnc213.m4a\r\n重生之红星传奇732（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group41/M03/55/C7/wKgJ8lqv3XGgDehMAJLcnat1icQ359.m4a\r\n重生之红星传奇733（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group40/M09/67/2B/wKgJVFrQyEKw5O5nAJdhv6tKJts450.m4a\r\n重生之红星传奇734（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group41/M05/A0/52/wKgJ8lrQyPyAOLAsAJjCK4-cBt4163.m4a\r\n重生之红星传奇735（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group40/M00/67/5E/wKgJVFrQykaDPS_rAJe_vGGmpdQ177.m4a\r\n重生之红星传奇736（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group42/M0B/9D/74/wKgJ81rQzJ-gTWJPAJbvNLjkALw845.m4a\r\n重生之红星传奇737（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group41/M00/A0/AB/wKgJ8VrQzTOBcoKhAJfgCZbXFVE521.m4a\r\n重生之红星传奇738（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group41/M05/A0/BA/wKgJ8VrQzbyhWp8gAJe_vNTGLzA447.m4a\r\n重生之红星传奇739（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group41/M04/BF/DE/wKgJ8VrSjS6QhuO-AJpOpccxRVQ674.m4a\r\n重生之红星传奇740（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group42/M09/F0/0D/wKgJ81rUwgniojTRAJo4oSm8uYc889.m4a\r\n重生之红星传奇741（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group40/M03/D3/E8/wKgJT1rWFXCwzrW1AJm6VtgCwE8840.m4a\r\n重生之红星传奇742（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group40/M05/F1/73/wKgJVFrX0AOjQfmzAJfgCU4efOA536.m4a\r\n重生之红星传奇743（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group42/M00/51/8F/wKgJ9FrZ4PWxgAmKAJ0Pf9VpI6U627.m4a\r\n重生之红星传奇744（多多评论，多多点赞；打赏加更哦；群号：721841900）$http://audio.xmcdn.com/group41/M02/8C/18/wKgJ8VrcrvTDrQHcAJf2RDrCMQE294.m4a', 'xml_8023', '2773', '', 'Z', '', '1.0', 10, 0, 0, 0, 'zhongshengzhihongxingchuanqi', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(52, 23, '浣花洗剑录[读的像屎，慎入]', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group28/M03/DF/AF/wKgJSFlObW_CfblLAAGx80m88ao781.jpg', '', 1530072142, 8, 0, 0, 0, 0, 1, 1, 6, 3, 'ting', '', '1$http://audio.xmcdn.com/group23/M0A/35/2F/wKgJL1gk6uLQPJnjAGx52pjBe5w758.m4a\r\n2$http://audio.xmcdn.com/group21/M07/40/A9/wKgJLVgpqq2SRZqeAHVd7SsLMs4085.m4a\r\n3$http://audio.xmcdn.com/group21/M0A/64/9D/wKgJLVg2157hp5RMAHP2K7gChJg683.m4a\r\n4$http://audio.xmcdn.com/group22/M09/76/1F/wKgJLlg8qJ6AbatlAH0Tg7Sfygk538.m4a\r\n5$http://audio.xmcdn.com/group24/M05/B8/4F/wKgJMFhPI2qzfZ6KAH3lfvqE23I496.m4a\r\n6$http://audio.xmcdn.com/group23/M09/CF/32/wKgJL1hVKI2CyHFSAHQX8G2jEzc107.m4a\r\n7$http://audio.xmcdn.com/group24/M0A/F6/30/wKgJMFhebBqTAcUkAHgQF9flDGw204.m4a\r\n8$http://audio.xmcdn.com/group25/M0A/15/54/wKgJMViMJwuSOy8KAHNBiv109Xg557.m4a\r\n9$http://audio.xmcdn.com/group23/M01/69/B9/wKgJNFiZvoiSV_3NAESX1Y3H8IQ264.m4a\r\n10$http://audio.xmcdn.com/group22/M0B/8F/19/wKgJLlilkHzS_LGLAFxXJ4UkvuM773.m4a\r\n11$http://audio.xmcdn.com/group24/M09/9B/08/wKgJNVipnGfglcLlAFZ48zBlbVc816.m4a\r\n12$http://audio.xmcdn.com/group25/M09/A0/3D/wKgJMViq6o_gZ3YQAFfdxia3P-U523.m4a\r\n13$http://audio.xmcdn.com/group27/M02/16/AE/wKgJR1jJtTDQp8ZmAEA-wSAyfcI127.m4a\r\n14$http://audio.xmcdn.com/group26/M08/89/BF/wKgJWFjUURTwLjTTAD0f79R25Fc053.m4a\r\n15$http://audio.xmcdn.com/group27/M05/11/54/wKgJW1jiPfbi1kIRAFehkY244Z4857.m4a\r\n16$http://audio.xmcdn.com/group26/M03/58/ED/wKgJWFjo2GixfFdbAENwrljrIXY146.m4a\r\n17$http://audio.xmcdn.com/group26/M05/6C/03/wKgJWFjqs0KAriv3AEi9gcfkDl8430.m4a\r\n18$http://audio.xmcdn.com/group26/M07/94/60/wKgJRljupiziAk-_AEr1y2M5pg0333.m4a\r\n19$http://audio.xmcdn.com/group27/M0A/98/A6/wKgJR1jveBrB-4NYAFZwIR7vAmk185.m4a\r\n20$http://audio.xmcdn.com/group26/M08/B5/19/wKgJRljyIB7AOUs0AFGwQ5ZkYB4537.m4a\r\n21$http://audio.xmcdn.com/group27/M08/C8/BB/wKgJW1j0tJ2zroEAAGQYebMSZUE515.m4a\r\n22$http://audio.xmcdn.com/group27/M07/EB/93/wKgJR1j3WtLgoRxBAET-n4L5Qj8146.m4a\r\n23$http://audio.xmcdn.com/group27/M03/11/0B/wKgJW1j6AjbCBp-2AD3WA4qzv1w758.m4a\r\n24$http://audio.xmcdn.com/group27/M00/17/1B/wKgJW1j6inaxj6G7AD6ay4EIs3Q189.m4a\r\n25$http://audio.xmcdn.com/group26/M04/27/51/wKgJRlj7U8rRJqSbAEM3aEpxzz8687.m4a\r\n26$http://audio.xmcdn.com/group27/M04/5D/0D/wKgJW1j_MvChPAPIAHc5tgLOSYE264.m4a\r\n27$http://audio.xmcdn.com/group26/M02/76/37/wKgJRlkAlVzCsewxACp0LPjUtQ0445.m4a\r\n28$http://audio.xmcdn.com/group26/M03/8F/EC/wKgJWFkCcfDSZZRfAE0jzeQq-iU135.m4a\r\n29$http://audio.xmcdn.com/group26/M04/A0/20/wKgJWFkDwR2QlyUZAENGGLMvPLw171.m4a\r\n30$http://audio.xmcdn.com/group27/M0B/AB/63/wKgJR1kFF76hc6sJAEE_vVM8KQw631.m4a\r\n31$http://audio.xmcdn.com/group27/M07/CB/E7/wKgJW1kHvCzT5WbNADorrl5OpvQ125.m4a\r\n32$http://audio.xmcdn.com/group27/M08/D8/2F/wKgJR1kIhw2xivvUAEAc_Jzkspc546.m4a\r\n33$http://audio.xmcdn.com/group27/M06/FC/92/wKgJW1kLF7LRMpQXAFRQz064xUY854.m4a\r\n34$http://audio.xmcdn.com/group27/M02/04/90/wKgJR1kLqqCx_scFAEKmCD6E9j4053.m4a', 'xml_8023', '7544', '', '0', '', '1.0', 5, 0, 0, 0, 'huanhuaxijianlududexiangshishenru', ''),
(53, 23, '素心问仙', '', '未知', '', '', '', '', 'http://s1.xmcdn.com/css/img/common/album_180.jpg', '', 1530072142, 4, 0, 0, 0, 0, 1, 1, 6, 1, 'ting', '', '素心问仙$http://audio.xmcdn.com/group29/M07/6E/EB/wKgJWVkf8NeB4jIpAC4zEhw2TEQ811.m4a', 'xml_8023', '7543', '', 'S', '', '1.0', 4, 0, 0, 0, 'suxinwenxian', ''),
(54, 23, '参选作品总集', '', '未知', '', '', '', '', 'http://s1.xmcdn.com/css/img/common/album_180.jpg', '', 1530072142, 0, 0, 0, 0, 0, 1, 1, 5, 7, 'ting', '', '绝尘逍遥录 片段$http://audio.xmcdn.com/group28/M07/07/B3/wKgJXFkj3oawolheACR_78o9ogY925.m4a', 'xml_8023', '7542', '', 'C', '', '1.0', 8, 0, 0, 0, 'canxuanzuopinzongji', ''),
(55, 23, '欢乐英雄', '', '未知', '', '', '', '年轻时沉迷金庸，武林纷争，江湖儿女豪情壮志，环环紧扣的故事和绝美繁复的招式让人陶醉，深深陷入江湖。人到中年再看古龙的这本欢乐英雄，才知最好的江湖是身处江湖中，心置江湖外。江湖中本没有什么让人留恋的，江湖里让人割舍不下的是朋友。韦小宝闯荡江湖，最后坐拥七美人，金银无数，逍遥通吃岛，令人羡慕却不渴望。郭大路闯出江湖，始终有燕七相伴，身无长物，却有王动和林太平为生死之交，令人向往。目录 欢乐 英雄 上 第一章 郭 大路 与 王 动 第二 章 燕 七 与 蚂蚁 第三 章 林 太平 第四 章 元宝· 女人· 狗 第五 章 剑 和 棍子 第六 章 送 不走 的 瘟神 第七 章 床 底下 的 秘密 第八 章 麦 老 广 和 他的 烧 鸭子 第九 章 菩萨 和 臭虫 第十 章 杀人 与 被杀 第十 一章 来路 不明 的 书生 第十二 章郭大路的拳头第十三 章 男 人和 猫 第十四 章 南宫 丑的 秘密 第十五 章 苦 差 第十六 章 郭 大路 的 秘密 第十七 章 误 会 第十八 章 剥 谁的 皮？ 第十 九章 林 太平 的 秘密 第二十 章 黑暗 的 地狱 第二十 一章 千古 艰难 唯一 死 第二十 二 章 柳暗花明 第二十 三 章 王 动 的 秘密 欢乐 英雄 下 第二十 四 章 心 如 蛇蝎的红娘 子 第二十 五 章 稻草 人的 秘密 第二十 六 章 最后 一击 第二十 七 章 春 到 人间 第二十 八 章 黄金 世界 第二十 九章 生财之道 第三十 章 金子 与 面子 第三十 一章 老 狐狸 与 大醉 侠 第三十 二 章 金 大帅 第三十 三 章 金子 与 教训 第三十 四 章 金 大帅 的 问题 第三十 五 章 鬼 公子 第三十 六 章 神秘 的南宫 丑 第三十 七 章 紫 衣 女 第三十 八 章 冒名 者 死 第三十 九章 春 去 何处？ 第四十 章 同是 天涯 沦落 人 第四十 一章 村 姑 第四十 二 章 盯梢 的 麻子 第四十 三 章 龙王 庙 第四十 四 章 秘 屋 奇人 第四十 五 章 前尘 往事 第四十 六 章 情人？ 仇人？ 第四十 七 章 人就是人', 'http://imagev2.xmcdn.com/group24/M02/1B/E6/wKgJMFqNHfPDbDkmAAapefr0QnM862.png', '', 1530072142, 7, 0, 0, 0, 0, 1, 1, 2, 5, 'ting', '', '欢乐英雄代序$http://audio.xmcdn.com/group19/M02/4A/BC/wKgJK1eU4GSxwUlpABt9BrKjJNc541.m4a\r\n第一章 郭大路与王动（上）$http://audio.xmcdn.com/group20/M01/4A/B9/wKgJJ1eU4NjCe3isAJwBT7mEOJo452.m4a\r\n第一章 郭大路与王动（下）$http://audio.xmcdn.com/group18/M02/4A/91/wKgJKleU4SawsfHGAIYDUimbPNo977.m4a\r\n第二章 燕七与蚂蚁（上）$http://audio.xmcdn.com/group19/M0B/5F/86/wKgJK1ectJCjuox7AKQTZ8aw0aU866.m4a\r\n第二章 燕七与蚂蚁（下）$http://audio.xmcdn.com/group17/M01/5F/9B/wKgJJFecwQPjQtNHAI7emKbG9fQ112.m4a\r\n第三章 林太平（上）$http://audio.xmcdn.com/group19/M08/CC/76/wKgJK1fFmiXBRm91AHwubq40yWc999.m4a\r\n第三章 林太平（下）$http://audio.xmcdn.com/group20/M01/CB/34/wKgJLFfFpBaRZtJ1AIHtzdUiRNM485.m4a\r\n第四章 元宝 女人 狗 （上）$http://audio.xmcdn.com/group20/M04/CE/27/wKgJLFfG3JzBya5zANvEaz9Cru0588.m4a\r\n第四章 元宝 女人 狗 （下）$http://audio.xmcdn.com/group20/M09/DF/3D/wKgJLFfNa5XRLzgGAIrsT3GFytE444.m4a\r\n第五章 剑和棍子（上）$http://audio.xmcdn.com/group20/M00/E1/64/wKgJJ1fNevvCBUaBAIz7elsm_hY448.m4a\r\n第五章 剑和棍子（下）$http://audio.xmcdn.com/group18/M00/E0/05/wKgJKlfNhhfB56sXAH-TvqVPxvI943.m4a\r\n第六章 送不走的瘟神$http://audio.xmcdn.com/group17/M04/E5/86/wKgJKVfO3V2hr0edAJlz2U2fVD0906.m4a\r\n第七章 床底下的秘密$http://audio.xmcdn.com/group17/M00/E5/3D/wKgJJFfO5meTHXONAHAJwMrg2cs943.m4a\r\n第八章 麦老广和他的烧鸭子$http://audio.xmcdn.com/group18/M00/E7/E2/wKgJKlfQO3SB03FWAOqbRLUpKcw938.m4a\r\n第九章 菩萨和臭虫$http://audio.xmcdn.com/group19/M03/13/1D/wKgJK1festHhak6ZARcFWm2dD6s689.m4a\r\n第十章 杀人与被杀$http://audio.xmcdn.com/group20/M02/96/F9/wKgJLFgKADfQ0A3RAPqgmaMsMkQ581.m4a\r\n第十一章 来历不明的书生$http://audio.xmcdn.com/group17/M03/99/7D/wKgJJFgKGmmSZxXJARCBOCfdVG8354.m4a\r\n第十二章 郭大路的拳头$http://audio.xmcdn.com/group17/M08/A3/10/wKgJKVgM0deR28vYAPZQV9uOS18656.m4a\r\n第十三章 男人和猫$http://audio.xmcdn.com/group25/M03/0F/E3/wKgJNlgWCduxTjW6ANruCqBwe_8782.m4a\r\n第十四章 南宫丑的秘密$http://audio.xmcdn.com/group22/M07/10/0A/wKgJLlgWGauBy3AWAMUpUjbStPc242.m4a\r\n第十五章 苦差$http://audio.xmcdn.com/group25/M05/64/B0/wKgJNlg26tqR617wAKCd7cRzfhw851.m4a\r\n第十六章 郭大路的秘密（上）$http://audio.xmcdn.com/group25/M02/65/20/wKgJNlg2_k3QS4rgALg4isWANBE191.m4a\r\n第十六章 郭大路的秘密（下）$http://audio.xmcdn.com/group25/M00/65/5E/wKgJNlg3D6mS5G6LALHI9l-hG3Q263.m4a\r\n第十七章 误会$http://audio.xmcdn.com/group24/M03/82/F8/wKgJMFg-6COxcIJEAL5XWpUnCPw690.m4a\r\n第十八章 剥谁的皮$http://audio.xmcdn.com/group21/M05/83/51/wKgJLVg--fCw9f7GALuPK_6tGBc600.m4a\r\n第十九章 林太平的秘密$http://audio.xmcdn.com/group23/M05/8D/11/wKgJNFh6PV3DEWm7APWLkxED7Z8013.m4a\r\n第二十章 黑暗的地狱$http://audio.xmcdn.com/group25/M03/8D/67/wKgJMVh6TArB_mH9AH9XiUD4hf8048.m4a\r\n第二十一章 千古艰难惟一死$http://audio.xmcdn.com/group22/M02/19/E3/wKgJLliMs2qwMOfgAKtU996ggPQ339.m4a\r\n第二十二章 柳暗花明$http://audio.xmcdn.com/group24/M06/19/5F/wKgJMFiMv3KC2vgjAI8NlbaXGgo485.m4a\r\n第二十三章 王动的秘密（上）$http://audio.xmcdn.com/group24/M08/3E/F6/wKgJMFiR8xqCo7oYAQEC-tJLtro762.m4a\r\n第二十三章 王动的秘密（中）$http://audio.xmcdn.com/group22/M00/40/A3/wKgJLliSAf6D0rlAAL_oPpin-TY659.m4a\r\n第二十三章 王动的秘密（下）$http://audio.xmcdn.com/group24/M01/3F/E3/wKgJMFiSEfvBqh4wANbbc_yuy64808.m4a\r\n第二十四章 心如蛇蝎的红娘子（上）$http://audio.xmcdn.com/group27/M01/01/63/wKgJW1kLQbHjE9F-AOZ4htyVprY845.m4a\r\n第二十四章 心如蛇蝎的红娘子（中）$http://audio.xmcdn.com/group26/M05/07/D1/wKgJWFkLZaORXdspAKr2_a8pZlA942.m4a\r\n第二十四章 心如蛇蝎的红娘子（下）$http://audio.xmcdn.com/group26/M06/07/82/wKgJRlkLbjKQNp3HALQ-6Czysdg048.m4a\r\n第二十五章 稻草人的秘密$http://audio.xmcdn.com/group27/M04/03/DD/wKgJR1kLdMKjtW0XAF9rtQU-GVw853.m4a\r\n第二十六章 最后一击$http://audio.xmcdn.com/group27/M0A/25/4D/wKgJR1kN69fCNWbwANWeQ6E60S4096.m4a', 'xml_8023', '6489', '', 'H', '', '1.0', 2, 0, 0, 0, 'huanleyingxiong', ''),
(56, 23, '仙侠四神剑', '', '未知', '', '', '', '江湖第一奇书仙侠四神剑，记录一段古老的神魔，江湖，武林，皇室政治斗争的奇书，恩怨交错，爱恨情仇，四把神剑究竟落于谁手，世界又会有怎么样的变化？且随我一探究竟！                                                                        ——黑化百晓生', 'http://imagev2.xmcdn.com/group26/M02/CA/E9/wKgJRlkZrXTC3O7WAAYEKzwRlRU997.jpg', '', 1530072142, 0, 0, 0, 0, 0, 1, 1, 9, 1, 'ting', '', '仙侠序章$http://audio.xmcdn.com/group28/M09/2E/C5/wKgJSFklSEjig3pKAIsbSyGWfQY510.m4a', 'xml_8023', '7541', '', 'X', '', '1.0', 3, 0, 0, 0, 'xianxiasishenjian', ''),
(57, 23, '修罗道 云雾版', '', '未知', '', '', '', '在一个名为修罗的小镇上，十二个以传奇人物为名的顶尖刺客，同时接到了来自神秘主人的刺杀命令，那就是杀死其余十一位传奇。最后那一个，将得到自由。在宛如绝境的边城小镇，这些刺客们从未谋面，或冷静、或残忍、或多疑，但无一例外，他们都是最好的刺客，都曾杀人无数。然而这一刻，面对他们的是随时降临的死亡，和与他们同样陷入绝境的同伴。杀掉每一位传奇，可以取得他或者她身上的一枚刺青，刺青上预言了他们的死状。而这些刺青拼起来，将会出现神秘的第十三枚刺青。每位传奇的容貌、衣着、特长都会与唐传奇中的人物冥冥吻合，唯有记载着他们死状的刺青，将惊人的改写传奇的结局。', 'http://imagev2.xmcdn.com/group22/M01/71/49/wKgJM1icNdzQ16meAALqtbGheRU777.jpg', '', 1530072142, 2, 0, 0, 0, 0, 1, 1, 8, 6, 'ting', '', '第一集 裴航$http://audio.xmcdn.com/group24/M03/A9/9F/wKgJMFitxYPBUhuEANOAaLgDWmM921.m4a\r\n第2章 聂隐娘$http://audio.xmcdn.com/group27/M04/27/66/wKgJW1j7eLfzuGLPAP6bszutVGE713.m4a\r\n第3章 柳毅$http://audio.xmcdn.com/group26/M00/2B/80/wKgJWFj7eLvjb2tfAKjwnwcnZsA661.m4a\r\n第4章 王仙客$http://audio.xmcdn.com/group26/M05/2B/4E/wKgJRlj7eT2R2JzpAT_TzlF_UZI026.m4a\r\n第5章 谢小娥$http://audio.xmcdn.com/group27/M03/6C/77/wKgJW1kAQVGhnBY6APBBrul1ckA892.m4a\r\n第6章 红线$http://audio.xmcdn.com/group26/M03/D4/BF/wKgJRlkIJVHgQe-0AM-GydqjQ88038.m4a\r\n第7章 五色桃林$http://audio.xmcdn.com/group27/M08/ED/19/wKgJR1kJ5VyhIPQRANlo5VP8GTM969.m4a\r\n第8章 任氏$http://audio.xmcdn.com/group27/M0A/31/70/wKgJW1kO8Mng8fOTAPW3oYPY6U0672.m4a', 'xml_8023', '7540', '', 'X', '', '1.0', 9, 0, 0, 0, 'xiuluodaoyunwuban', ''),
(58, 23, '大杀手', '', '未知', '', '', '', '凶狠残忍，阴狠狡诈的阴谋，用什么击破？是什么蒙蔽了人们善良的心？权利？欲望？如何去克服？在一个江湖的世界里，感受当代社会缺少的正义与爱。烧三丝工作室所出品的作品内容包括小说、有声书、插画、漫画，此均属烧三丝工作室原创内容，因此敬告诸位，请尊重我们的知识产权，切勿盗版侵权，违者必究。', 'http://imagev2.xmcdn.com/group21/M00/B3/84/wKgJLVhNdkHSCNR8AAKBFOCYtzk066.jpg', '', 1530072142, 5, 0, 0, 0, 0, 1, 1, 5, 7, 'ting', '', '《大杀手》第一集 一位老人$http://audio.xmcdn.com/group25/M01/B2/71/wKgJMVhNTeKhBYmfAH62AlCsLsw457.m4a\r\n《大杀手》第二集 华山女侠$http://audio.xmcdn.com/group24/M03/B3/A6/wKgJNVhNauqgnd5KAIKYJZAsLwQ259.m4a\r\n《大杀手》第三集 镖局命案$http://audio.xmcdn.com/group22/M0A/B3/D7/wKgJM1hNa42AmXdtAHzRbQD6nO8204.m4a\r\n《大杀手》第四集 小鱼其人$http://audio.xmcdn.com/group24/M02/BD/A5/wKgJNVhQHyiAQI8LAIuchdOXKKM032.m4a\r\n《大杀手》第五集 索命幽魂$http://audio.xmcdn.com/group25/M07/CC/0C/wKgJMVhUDT2xcFqgALlZ0KqsBBo967.m4a\r\n《大杀手》第六集 一剑倾心$http://audio.xmcdn.com/group25/M04/D8/A9/wKgJMVhYEY2wqn6EAGRyC0d6RxA396.m4a\r\n《大杀手》第七集 山雨欲来$http://audio.xmcdn.com/group22/M0A/EF/2F/wKgJLlhc3i3TupNtAJcCTrUI9Ms618.m4a\r\n《大杀手》第八集 宵小之徒$http://audio.xmcdn.com/group22/M00/02/36/wKgJLlhg8l_ye52NAKJjrLvP5kE108.m4a\r\n《大杀手》第九集 忘年之交$http://audio.xmcdn.com/group22/M0A/0A/D0/wKgJM1hj6seSid1TAL8UyJRAhsM310.m4a\r\n《大杀手》第十集 英雄际会$http://audio.xmcdn.com/group21/M07/1B/5B/wKgJLVhojaXCRDU5AJEA2a4Sq2g304.m4a\r\n《大杀手》第十一集 辽东战火 上$http://audio.xmcdn.com/group23/M05/2F/2B/wKgJL1htC3SiR2nEAIH1JtQfqpU986.m4a\r\n《大杀手》第十二集 辽东战火 下$http://audio.xmcdn.com/group25/M08/48/A7/wKgJNlhwyCfjHuLyAGcD6MR307I208.m4a\r\n《大杀手》第十三集 蠢蠢欲动$http://audio.xmcdn.com/group22/M03/67/3E/wKgJLlh0nwvwTy9xAIwJLuB2i-I909.m4a\r\n《大杀手》第十四集 血染残阳 上$http://audio.xmcdn.com/group25/M06/81/24/wKgJMVh4hnfgUKJSAG9uG89QvlM179.m4a\r\n《大杀手》第十五回 血染残阳 下$http://audio.xmcdn.com/group22/M01/95/DA/wKgJM1h7n5HC3BfwAGEONEZeYXo807.m4a\r\n《大杀手》第十六集 敲山震虎 上$http://audio.xmcdn.com/group22/M00/B7/94/wKgJLliAjCyzen1tAGI8tZJrtDo630.m4a\r\n《大杀手》第十七集 敲山震虎 下$http://audio.xmcdn.com/group25/M02/DE/D9/wKgJNliE0TPTBAWkAHZgYZAYFQ0903.m4a\r\n《大杀手》第十八集 蛇蝎心肠 上$http://audio.xmcdn.com/group22/M07/06/59/wKgJLliJyVeBcYmoAGi951vDEWs952.m4a\r\n《大杀手》第十九集 蛇蝎心肠 中$http://audio.xmcdn.com/group21/M09/20/91/wKgJKFiN4yjSK-62AF37IcCa6i0131.m4a\r\n《大杀手》第二十集 蛇蝎心肠 下$http://audio.xmcdn.com/group21/M06/3E/BF/wKgJKFiR-rGAR7guAGhunZZlRR8868.m4a\r\n《大杀手》第二十一集 遭遇突袭 上$http://audio.xmcdn.com/group23/M01/61/8D/wKgJNFiXUP-ClNUCAGfzQmJNPwo698.m4a\r\n《大杀手》第二十二集 遭遇突袭 中$http://audio.xmcdn.com/group23/M03/70/8A/wKgJNFib-63jOMMQAGWvPBhMfAc663.m4a\r\n《大杀手》第二十三集 遭遇突袭 下$http://audio.xmcdn.com/group22/M02/81/DE/wKgJM1ihhaOgWVCnAF9aEt_cr6U333.m4a\r\n《大杀手》第二十四集 回忆过去 上$http://audio.xmcdn.com/group22/M02/90/49/wKgJLlilu8qw0XEOAG7Gsr9k1Dw611.m4a\r\n《大杀手》第二十五集 回忆过去 中$http://audio.xmcdn.com/group25/M07/AE/6E/wKgJNliu1pDArq9sAE3v6jB5ifc601.m4a\r\n《大杀手》第二十六集 回忆过去 下$http://audio.xmcdn.com/group23/M02/C5/D1/wKgJNFi1bZahGw6PAFwMQ-3xiQU160.m4a\r\n《大杀手》第二十七集 往事浮现$http://audio.xmcdn.com/group19/M07/B4/97/wKgJK1i7ugzD9T6bAHDmBEON6gw330.m4a\r\n《大杀手》第二十八集 点卯出发 上$http://audio.xmcdn.com/group22/M09/DC/39/wKgJM1i-zlyB_ULLAG19xX0tAlA123.m4a\r\n《大杀手》第二十九集 点卯出发 中$http://audio.xmcdn.com/group25/M09/EB/39/wKgJNljD5kPzArgRAGAac_UuI24778.m4a\r\n《大杀手》第三十集 点卯出发 下$http://audio.xmcdn.com/group26/M00/0F/AD/wKgJRljH8PqSAfXzAErc1Pk7GJ8239.m4a\r\n《大杀手》第三十一集 半路平安 上$http://audio.xmcdn.com/group26/M0A/89/0D/wKgJRljUAoygKPAUAH0MKq5RLDE846.m4a\r\n《大杀手》第三十二集 半路平安 中$http://audio.xmcdn.com/group26/M03/AF/77/wKgJRljX8KLhcW8UAH1qJ2bkvTI592.m4a\r\n《大杀手》第三十三集 半路平安 下$http://audio.xmcdn.com/group26/M06/E3/10/wKgJWFjdDeijYIgbAFrGRoXGIHY469.m4a\r\n《大杀手》第三十四集 心生芥蒂 上$http://audio.xmcdn.com/group27/M01/09/3A/wKgJW1jhMw7iHOWxAH3hGIVcTvQ631.m4a\r\n《大杀手》第三十五集 心生芥蒂 中$http://audio.xmcdn.com/group27/M08/82/0C/wKgJR1jtBSijYPVCAJE1uK5bKEM797.m4a\r\n《大杀手》第三十六集 心生芥蒂 下$http://audio.xmcdn.com/group26/M09/B6/53/wKgJRljyMDmxHei8AIJACuoMQKs394.m4a\r\n《大杀手》第三十七集 真相大白 上$http://audio.xmcdn.com/group27/M00/03/CC/wKgJW1j43OWSjGFZAICQT6Z_JQU366.m4a\r\n《大杀手》第三十八集 真相大白 中$http://audio.xmcdn.com/group26/M01/53/3D/wKgJWFj-F5fTYAS0AKUUX3laBCI515.m4a\r\n《大杀手》第三十九集 真相大白 下 第一部 完$http://audio.xmcdn.com/group29/M07/F1/D9/wKgJWVklsKCDp1vzAJUWX1-jSB8980.m4a', 'xml_8023', '7539', '', 'D', '', '1.0', 10, 0, 0, 0, 'dashashou', ''),
(59, 23, '荆楚争雄记[悼念黄易大师的仙去]', '', '未知', '', '', '', '战国之末，诸雄争王，胜者为王，败者为寇。楚国四大剑手之一的却宛为奸人所害，惨遭灭族之恨。其子却桓度历尽千辛万苦，逃离楚境，机缘巧合下得到名传千古的《孙子兵法》，又化身孙武，借吴人之力，活用兵法，以弱胜强，震惊当世。其中哀怨缠绵的男女之情，与刀光剑影纵横交织；由单打独斗，到千军万马的战争，写下了古战国时代悲壮浪漫的一页史篇。[1]', 'http://imagev2.xmcdn.com/group27/M05/E2/E8/wKgJR1jdmCLCEcNeAABnELIOx_M157.jpg', '', 1530072142, 8, 0, 0, 0, 0, 1, 1, 1, 1, 'ting', '', '01.荆楚争霸悼念黄易大师的仙去 求打赏 求关注$http://audio.xmcdn.com/group21/M03/F2/E7/wKgJKFiHVtjBTXIxAGVBtoKiXGE520.m4a\r\n02.寻秦记前传之荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group22/M09/FC/AF/wKgJM1iIiDixA6O2AGshAMfqVLU099.m4a\r\n03.寻秦记前传之荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group21/M0B/16/77/wKgJKFiMbyTwTNwSAGxMX2EnBck410.m4a\r\n04.寻秦记前传 求打赏 求关注$http://audio.xmcdn.com/group24/M09/1F/C4/wKgJMFiNv4Lj_jvMAGbcftSQ84o923.m4a\r\n05.寻秦记前传 求打赏 求关注$http://audio.xmcdn.com/group25/M03/29/F6/wKgJNliPEVWQZqBJAGmi_E2UcOQ603.m4a\r\n06.寻秦记前传 求打赏 求关注$http://audio.xmcdn.com/group23/M02/35/5F/wKgJL1iQhH7QSP7ZAHHQ99iS-TU694.m4a\r\n07.寻秦记前传 求打赏 求关注$http://audio.xmcdn.com/group25/M05/3F/35/wKgJNliR3uqSp2W5AGDMP42mKt4231.m4a\r\n08.寻秦记前传 求打赏 求关注$http://audio.xmcdn.com/group24/M02/50/D9/wKgJNViUU6GT919RAHCwhKccShA322.m4a\r\n09.寻秦记前传 求打赏 求关注$http://audio.xmcdn.com/group22/M02/58/FD/wKgJLliVnIGiJopqAG-77RWDO24203.m4a\r\n10.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group22/M07/5F/B0/wKgJLliW-p6igCaBAFgUZCS-3TI597.m4a\r\n11.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group23/M08/64/7B/wKgJNFiYRAfCXzm1AGiR2gdDKi8962.m4a\r\n12.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group22/M08/68/E2/wKgJM1iZoEOjSOwGAGiR71KoAas780.m4a\r\n13.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group23/M02/71/E2/wKgJL1icO_XxImfrAFh0BLL9fJQ543.m4a\r\n14.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group26/M0B/C4/4D/wKgJRljaSkWxUi3FAF6-3w8MVSA095.m4a\r\n15.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group26/M08/EF/1A/wKgJRljeREGBLJV_AFcvJ8G5_40655.m4a\r\n16.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group26/M09/FC/99/wKgJRljfkmSg6LaaAFe-1OUY0w8876.m4a\r\n17.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group26/M02/08/33/wKgJRljg0DayfuKPAHa7axKNCgo455.m4a\r\n18.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group27/M03/10/13/wKgJR1jiKhKyM6poAHQmnwgP8Mc421.m4a\r\n19.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group27/M00/1B/EF/wKgJW1jjZozQ4AUdAGRQR8adDtA867.m4a\r\n20.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group27/M01/2A/69/wKgJR1jk1JrjNI0TAG4vcxBHRA4750.m4a\r\n21.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group26/M01/58/66/wKgJWFjo0WLR3W6eAFnHRkxMLuY742.m4a\r\n22.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group26/M08/7E/AC/wKgJRljslPDA5Ym9AGoden5ruZg389.m4a\r\n23.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group26/M08/8C/A8/wKgJRljt9OzBnZ1IAGMacO-e2Ho737.m4a\r\n24.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group26/M02/9C/02/wKgJRljva8awkAxgAGCbqe5WTqg087.m4a\r\n25.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group27/M02/A1/E6/wKgJR1jwk9OTXgdYAFaDN2x3ODQ100.m4a\r\n26.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group26/M03/B2/47/wKgJRljx7TTAW0IdAEJticYte_k975.m4a\r\n27.荆楚争霸 求打赏 求关注$http://audio.xmcdn.com/group27/M07/23/DA/wKgJW1j7VwzhRVhRAGBN100yXZc785.m4a\r\n28.荆楚争霸 求打赏求关注$http://audio.xmcdn.com/group27/M0B/FD/47/wKgJW1kLHkXxA6KtAFE7HbnpjLg669.m4a\r\n29.荆楚争霸全书完结$http://audio.xmcdn.com/group26/M02/36/24/wKgJRlkPCcGT0e1LAC_uqG28Nh0183.m4a', 'xml_8023', '7538', '', 'J', '', '1.0', 5, 0, 0, 0, 'jingchuzhengxiongjidaonianhuangyidashidexianqu', ''),
(60, 23, '白发魔女', '', '未知', '', '', '', '在网上找的书，可能有些错别字的地方，大家多多包涵', 'http://imagev2.xmcdn.com/group23/M08/E4/39/wKgJL1haaoviT3PZAAN5ZJ2EMT0046.jpg', '', 1530072142, 6, 0, 0, 0, 0, 1, 1, 3, 3, 'ting', '', '白发魔女传 01$http://audio.xmcdn.com/group21/M05/E3/4C/wKgJKFhaZorDtW6DAGozzhwLyr0854.m4a\r\n白发魔女传 02$http://audio.xmcdn.com/group24/M06/E7/C5/wKgJNVhbPSqRENJGAFf5rU6okv8631.m4a\r\n白发魔女传 03$http://audio.xmcdn.com/group25/M04/EC/41/wKgJMVhcgHHRnqNEAGXin3QkCac849.m4a\r\n白发魔女传 04$http://audio.xmcdn.com/group25/M07/F3/54/wKgJMVhd4XCiPom_AFpYIs9L2XM176.m4a\r\n白发魔女传 05$http://audio.xmcdn.com/group25/M0A/FE/FA/wKgJNlhgggWhM4skAGFL3-rckDo766.m4a\r\n白发魔女传 06$http://audio.xmcdn.com/group21/M01/A7/62/wKgJLVith4qiR53BAIA5ENnEK9s573.m4a\r\n白发魔女传 07$http://audio.xmcdn.com/group21/M05/B0/FF/wKgJKFiwL_HxOzUPAJPO6vp3WAI194.m4a\r\n白发魔女传 08$http://audio.xmcdn.com/group20/M08/AE/44/wKgJLFi5czXRKOatAHvXy9Fvl5o785.m4a\r\n后宫甄嬛传01（试音）$http://audio.xmcdn.com/group27/M0A/20/14/wKgJR1kNtljwJ0rVAGjs5Mar2X0179.m4a\r\n后宫甄嬛传03$http://audio.xmcdn.com/group27/M06/20/25/wKgJR1kNt2ei2_YWAG2ZrIO2NVw806.m4a\r\n后宫甄嬛传04$http://audio.xmcdn.com/group26/M00/24/2F/wKgJWFkNt8WTxB9nAGwaahAYoLY705.m4a\r\n后宫甄嬛传05$http://audio.xmcdn.com/group27/M04/20/76/wKgJW1kNuI6zxDJ0AINJ0_ZqAJU126.m4a\r\n后宫甄嬛传06$http://audio.xmcdn.com/group26/M08/F2/66/wKgJWFkJ7xuDB0PDAG0hRBUqIC0406.m4a\r\n后宫甄嬛传07$http://audio.xmcdn.com/group27/M04/EE/59/wKgJW1kJ732iZu6HAH6Sxi24R8k874.m4a\r\n后宫甄嬛传08$http://audio.xmcdn.com/group27/M0A/23/02/wKgJW1kN0xSw9aqyAKEAUMdRo-E821.m4a\r\n后宫甄嬛传09$http://audio.xmcdn.com/group27/M02/6E/01/wKgJW1kTFASRl1LNAFSneCE8wHM963.m4a\r\n后宫甄嬛传10$http://audio.xmcdn.com/group27/M0B/70/45/wKgJR1kTKLqyqGGwAJT9a70MFEg106.m4a\r\n后宫甄嬛传11$http://audio.xmcdn.com/group27/M09/91/E6/wKgJR1kVri2AFi7pAGUNtTmTONY807.m4a\r\n后宫甄嬛传12$http://audio.xmcdn.com/group29/M02/7A/0F/wKgJWVkgQ8ewOmXvAGl276fUcOw236.m4a\r\n后宫甄嬛传13$http://audio.xmcdn.com/group28/M08/A9/8C/wKgJXFkqxRGgO2OLAD0BBRtKu14138.m4a', 'xml_8023', '7537', '', 'B', '', '1.0', 7, 0, 0, 0, 'baifamonv', ''),
(61, 23, '千古寻妖', '', '未知', '', '', '', '', 'http://s1.xmcdn.com/css/img/common/album_180.jpg', '', 1530072142, 7, 0, 0, 0, 0, 1, 1, 7, 3, 'ting', '', '千古寻妖 第十一卷$http://audio.xmcdn.com/group27/M06/40/01/wKgJW1kP_3bBZkjxALe3USUSltk400.m4a\r\n千古寻妖 第十卷$http://audio.xmcdn.com/group27/M06/1C/3F/wKgJW1j66cbCBAgwALOTHIkW1VI167.m4a\r\n千古寻妖 第九卷$http://audio.xmcdn.com/group26/M09/1F/CA/wKgJRlj64vfzTCKkALU-_JsBFic042.m4a\r\n千古寻妖 第八卷$http://audio.xmcdn.com/group27/M0B/0A/80/wKgJW1j5mfnCWperALIA7Em7IGI076.m4a\r\n千古寻妖 第七卷$http://audio.xmcdn.com/group26/M00/0E/51/wKgJWFj5k5Wir42QAKDuspPZjWs840.m4a\r\n千古寻妖 第六卷$http://audio.xmcdn.com/group26/M07/FB/CB/wKgJRlj4R5_h1n7UALMZOF9Du30172.m4a\r\n千古寻妖 第五卷$http://audio.xmcdn.com/group27/M06/D2/6E/wKgJW1j1qy-BHHjtAMsDIIwbbhc244.m4a\r\n千古寻妖 第四卷$http://audio.xmcdn.com/group27/M04/D2/0F/wKgJW1j1o7aCCA0FASd15BqbjCQ511.m4a\r\n千古寻妖 第三卷$http://audio.xmcdn.com/group26/M01/B0/25/wKgJRljxtS-xVWqgAULm4JXmGdg011.m4a\r\n第二卷$http://audio.xmcdn.com/group27/M05/A0/1E/wKgJW1jwY-LBf4zYAK9H9AAnCeI896.m4a\r\n第一卷$http://audio.xmcdn.com/group27/M01/9F/B2/wKgJR1jwWYTy-sE6AINiHiMrFJI076.m4a', 'xml_8023', '7536', '', 'Q', '', '1.0', 9, 0, 0, 0, 'qianguxunyao', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(62, 23, '修真老师生活录', '', '未知', '', '', '', '他是一位年轻的大学老师，他还是一位无意中得传上古五帝真经，修炼了大混沌五行心法的修真者。他隐居大学教书育人，他行事作风低调，但不经意间却锋芒夺目……', 'http://imagev2.xmcdn.com/group10/M07/D5/ED/wKgDZ1aE9rHBaMYrAAdQM2L3CTg415.jpg', '', 1530072143, 10, 0, 0, 0, 0, 1, 1, 1, 9, 'ting', '', '长篇玄幻小说《修真老师生活录》开篇的话$http://audio.xmcdn.com/group10/M05/F5/AA/wKgDaVathKfRSB8oABpuvedCE2U779.m4a\r\n《修真老师生活录》01-狠角色$http://audio.xmcdn.com/group12/M0A/FC/36/wKgDW1a0trfhPeB1AITFHIZIrFQ934.m4a\r\n《修真老师生活录》02-戴眼镜的大力士$http://audio.xmcdn.com/group15/M05/FB/64/wKgDZVa0ubjxOKbFAH2qLKqgDHU252.m4a\r\n《修真老师生活录》03-很拽很酷的“大学生”$http://audio.xmcdn.com/group13/M04/FC/FE/wKgDXVa0ulrS-ZxiAH5l7mNeVwA627.m4a\r\n《修真老师生活录》04-误闯女人宿舍$http://audio.xmcdn.com/group16/M03/FC/51/wKgDala0uwPCS-VSAJCOd92h_wU215.m4a\r\n《修真老师生活录》05-寻仇$http://audio.xmcdn.com/group13/M06/FC/EF/wKgDXla0vB_DXOBoAIdml2hJJUc226.m4a\r\n《修真老师生活录》06-中他是中南海保镖？$http://audio.xmcdn.com/group14/M09/FD/BB/wKgDZFa0vMLQS67OAIYSOvdlx-k290.m4a\r\n《修真老师生活录》07-东哥$http://audio.xmcdn.com/group11/M04/EE/FA/wKgDa1a0vVGSFT6qAIu-S-yKd3w719.m4a\r\n《修真老师生活录》08-黑道清洁工$http://audio.xmcdn.com/group14/M0A/FD/BB/wKgDZFa0vgiw3sP9AI2bHh8PUoU703.m4a\r\n《修真老师生活录》09-五帝真经$http://audio.xmcdn.com/group16/M03/0D/48/wKgDalbQXHjB94v6AI8MxejyekE594.m4a\r\n《修真老师生活录》10-冤家路窄$http://audio.xmcdn.com/group10/M03/FB/4D/wKgDaVa0vyCBS9WfAJDU4FPb7Jg919.m4a\r\n《修真老师生活录》11-女人善变$http://audio.xmcdn.com/group7/M03/00/20/wKgDWla7JzaD6PjJAJHOZtqY0Qg818.m4a\r\n《修真老师生活录》12-灭绝师太$http://audio.xmcdn.com/group15/M05/01/BD/wKgDaFbBwe3jIoucAJryJyeDLbc547.m4a\r\n《修真老师生活录》13-姑奶奶我忍！$http://audio.xmcdn.com/group11/M01/F5/20/wKgDa1bBwoTCW933AJj1AiUHdRQ403.m4a\r\n《修真老师生活录》14-张卫东挨宰$http://audio.xmcdn.com/group16/M07/02/76/wKgDbFbBwx_R8bW0AJN05-xYYys336.m4a\r\n《修真老师生活录》14-张卫东挨宰$http://audio.xmcdn.com/group7/M00/07/1E/wKgDWlbGlDnxrP00AJN05-xYYys573.m4a\r\n《修真老师生活录》15-酒桌上的较量$http://audio.xmcdn.com/group14/M05/07/5B/wKgDZFbGlPDhgPXoAJoa44DBp0E628.m4a\r\n《修真老师生活录》16-暴力阿雀$http://audio.xmcdn.com/group10/M03/01/8B/wKgDZ1bGlamBTHJrAKUAcazS8KI201.m4a\r\n《修真老师生活录》17-挡箭牌$http://audio.xmcdn.com/group15/M09/05/04/wKgDaFbGltnRzUtKAJGg4TlXdnI992.m4a\r\n《修真老师生活录》18-霸气外露，再遇铁手$http://audio.xmcdn.com/group14/M08/0E/B9/wKgDY1bQYdbhnMCjAKDOw2h8Bg0792.m4a\r\n《修真老师生活录》19-黑社会老大？$http://audio.xmcdn.com/group12/M09/2F/07/wKgDW1b2Ybaidz-mAJT_ck_RtgA564.m4a\r\n《修真老师生活录》20-醒了$http://audio.xmcdn.com/group16/M02/0C/61/wKgDbFbPI1vSyXwAAJwFyfNMmMg768.m4a\r\n《修真老师生活录》21-叔可忍婶不可忍$http://audio.xmcdn.com/group7/M05/0F/35/wKgDX1bRvu7gjAKLAIzpuDRQT2I625.m4a\r\n《修真老师生活录》22-老校长$http://audio.xmcdn.com/group16/M06/0E/4E/wKgDalbRv5yyxRSxAJfCkm6tvVA865.m4a\r\n《修真老师生活录》23-指点$http://audio.xmcdn.com/group7/M03/11/69/wKgDX1bUWNDDTdkqAKLNQJQQvgs403.m4a\r\n《修真老师生活录》24-忘年交$http://audio.xmcdn.com/group10/M05/0C/00/wKgDZ1bUWZbTzHYaAI4gg3Ketrc244.m4a\r\n《修真老师生活录》25-课题组副组长$http://audio.xmcdn.com/group12/M01/10/F1/wKgDW1bU_qaCY-dZAJPMux4TtuM500.m4a\r\n《修真老师生活录》26-发火$http://audio.xmcdn.com/group13/M00/13/01/wKgDXVbWTXbzwmhZAIdDSit4L8A778.m4a\r\n《修真老师生活录》27-张组长，我犯了错$http://audio.xmcdn.com/group11/M03/1F/A5/wKgDbVbX_SyjIEchAJN2U8ABcoA429.m4a\r\n《修真老师生活录》28-手$http://audio.xmcdn.com/group12/M00/14/2C/wKgDW1bX_jiB8FPcAIwazCM05dg887.m4a\r\n《修真老师生活录》29-张卫东的神指$http://audio.xmcdn.com/group10/M04/16/88/wKgDaVbb_vGAl6MbAJLPGsmOS1c671.m4a\r\n《修真老师生活录》30-张老师，我们以后跟你混了$http://audio.xmcdn.com/group15/M05/16/AD/wKgDaFbb_8njmIfzAJNOuMXsbXI457.m4a\r\n《修真老师生活录》31-忘年交正式结义$http://audio.xmcdn.com/group12/M06/18/03/wKgDW1bcO8TTQhEuAJfxR4RwZbA667.m4a\r\n《修真老师生活录》32-张卫东像鸟一样飞翔$http://audio.xmcdn.com/group14/M03/19/8B/wKgDZFbcPFqRsQGUAI-8s0l4oM8803.m4a\r\n《修真老师生活录》33-谭永谦的隐疾$http://audio.xmcdn.com/group8/M05/1B/14/wKgDYFbgA7HhLxDoAIyAG0YwdNI125.m4a\r\n《修真老师生活录》34-张卫东指到病除$http://audio.xmcdn.com/group7/M04/1C/F8/wKgDWlbg7mmi2TefAJXVqKQi7Zs556.m4a\r\n《修真老师生活录》35-小餐馆的意外之一$http://audio.xmcdn.com/group12/M02/1E/06/wKgDW1bjogLx8l29AJG24j3tlIk329.m4a\r\n《修真老师生活录》36-小餐馆的意外之二$http://audio.xmcdn.com/group8/M04/1E/72/wKgDYFbj9jezJf2HAIep4X6mib4498.m4a\r\n《修真老师生活录》37-去派出所的警车里$http://audio.xmcdn.com/group16/M00/1F/59/wKgDalblCmHixz9tAH-nLXnhM3c324.m4a\r\n《修真老师生活录》38-威胁$http://audio.xmcdn.com/group9/M09/1F/90/wKgDZlblC1fgiaqJAJ-3CgcrV3w517.m4a\r\n《修真老师生活录》39-小叔$http://audio.xmcdn.com/group10/M09/1A/DA/wKgDZ1blDA2y6KfOAH5_YnKirUI178.m4a\r\n《修真老师生活录》40-常委到了派出所$http://audio.xmcdn.com/group9/M07/25/A1/wKgDZlbrtsezUVALAImHHbiA1HI059.m4a\r\n《修真老师生活录》41-发怒$http://audio.xmcdn.com/group10/M00/25/7F/wKgDaVbtRVjxQQgCAI48herM3U0973.m4a\r\n《修真老师生活录》42-大人物$http://audio.xmcdn.com/group7/M05/26/4F/wKgDX1bruXKxjZ2yAJqHBrGRb18644.m4a\r\n《修真老师生活录》43-释放$http://audio.xmcdn.com/group8/M01/25/52/wKgDYVbrucyxpVKCAJrfxEBQ4pM919.m4a\r\n《修真老师生活录》44-宵夜$http://audio.xmcdn.com/group8/M07/26/DF/wKgDYFbtYR-DOMSuAJRp3_StpXY881.m4a\r\n《修真老师生活录》45-狭路又相逢$http://audio.xmcdn.com/group16/M03/26/F8/wKgDbFbtYe-hp7DCAJY5-le-zyA746.m4a\r\n《修真老师生活录》46-回校路上$http://audio.xmcdn.com/group16/M0A/2A/32/wKgDalbw-77DkEwMAI-i8J6xzLE543.m4a\r\n《修真老师生活录》47-启动博士科研经费$http://audio.xmcdn.com/group9/M05/2A/5D/wKgDZlbxCBqQnjCGAIIimaS7zxY726.m4a\r\n《修真老师生活录》48-办公室新来的同事$http://audio.xmcdn.com/group10/M07/29/E8/wKgDZ1b1X_nQexezAILZP3hIZ80035.m4a\r\n《修真老师生活录》49-新学期安排$http://audio.xmcdn.com/group10/M05/2D/B6/wKgDaVb2X5SRThziAH8hsWnQluo114.m4a\r\n《修真老师生活录》50-刘胜男的借口$http://audio.xmcdn.com/group9/M03/2F/22/wKgDYlb2X-yAEFhXAJQiGBY8Tvw542.m4a\r\n《修真老师生活录》51-男人$http://audio.xmcdn.com/group9/M04/2F/87/wKgDYlb2qRCCUmtDAIM3ooDH4Ww006.m4a\r\n《修真老师生活录》52-书呆子$http://audio.xmcdn.com/group15/M05/2E/22/wKgDZVb2qcXD5RMHAItvrclfuGM118.m4a\r\n《修真老师生活录》53-斗酒$http://audio.xmcdn.com/group16/M06/31/D6/wKgDbFb5TiOwxvnIAJWGRq_mHRE339.m4a\r\n《修真老师生活录》54-楚朝晖敬酒$http://audio.xmcdn.com/group8/M0A/34/19/wKgDYFb75T6w1YFuAJToUMUXb18730.m4a\r\n《修真老师生活录》55-小李飞刀$http://audio.xmcdn.com/group12/M03/34/12/wKgDXFb78WfCbf8VAJRg-iLuSrc481.m4a\r\n《修真老师生活录》56-训斥$http://audio.xmcdn.com/group9/M0B/36/6A/wKgDYlb-dyjBnf0kAH0wkO49auo500.m4a\r\n《修真老师生活录》57-生日礼物$http://audio.xmcdn.com/group15/M07/35/29/wKgDZVb-d_2AORvvAJZ7OszusHk938.m4a\r\n《修真老师生活录》58-不准胡思乱想$http://audio.xmcdn.com/group16/M02/37/29/wKgDalb_OAWx6BPcAHutQs-V37c319.m4a\r\n《修真老师生活录》59-长青功$http://audio.xmcdn.com/group11/M0B/48/12/wKgDbVcFvZmT-PS6AIjIC-mtuRQ647.m4a\r\n《修真老师生活录》60-叶峰遭贬$http://audio.xmcdn.com/group12/M02/39/C4/wKgDW1cCVFnynyT4AIW7u0FzbXg666.m4a\r\n《修真老师生活录》61-共撑一把伞$http://audio.xmcdn.com/group14/M03/3B/C3/wKgDY1cCbaiDAIj_AIupwfp8n8U471.m4a\r\n《修真老师生活录》62-聚餐$http://audio.xmcdn.com/group16/M04/3A/4E/wKgDalcCboHw3sLnAIqHutTV3J0245.m4a\r\n《修真老师生活录》63-设计陷害$http://audio.xmcdn.com/group11/M01/45/54/wKgDbVcCb22hi5gvAJsZnrn2mH0490.m4a\r\n《修真老师生活录》64-耍流氓$http://audio.xmcdn.com/group15/M05/3C/CF/wKgDZVcHEo_SDcn2AJHdHQK4BVg365.m4a\r\n《修真老师生活录》65-二进宫$http://audio.xmcdn.com/group16/M04/3E/33/wKgDalcHE2jAixFBAIsVvmvTDhI145.m4a\r\n《修真老师生活录》66-阴谋败露$http://audio.xmcdn.com/group10/M0B/3C/D5/wKgDZ1cLUaySrlCbAI2VTOYM8Eg432.m4a\r\n《修真老师生活录》67-我就知道老师最好！$http://audio.xmcdn.com/group16/M00/41/B2/wKgDalcLUoyjS0tpAJBFT71e1_Q562.m4a\r\n《修真老师生活录》68-凶狠的一面$http://audio.xmcdn.com/group14/M03/47/37/wKgDZFcPv5eg2aYFAJFwyZES8jQ534.m4a\r\n《修真老师生活录》69-再遇刘胜男$http://audio.xmcdn.com/group12/M06/45/9F/wKgDW1cPwBbgB2VmAIVsbdTpOeE215.m4a\r\n《修真老师生活录》70-书符$http://audio.xmcdn.com/group12/M03/45/29/wKgDW1cPboiRMmV9AIPthpXXTks302.m4a\r\n《修真老师生活录》71-草木有情$http://audio.xmcdn.com/group9/M0B/48/9E/wKgDZlcS6lfjVDluAJezt38P3Ik835.m4a\r\n《修真老师生活录》72-失踪案$http://audio.xmcdn.com/group15/M00/45/35/wKgDZVcQ1hHTo05QAJ87JDii4R8856.m4a\r\n《修真老师生活录》73-师叔出手$http://audio.xmcdn.com/group7/M03/49/EB/wKgDWlcTmzDym1QFAJle5_IC5aw873.m4a\r\n《修真老师生活录》74-仙人指路$http://audio.xmcdn.com/group16/M02/49/33/wKgDalcTm8ih57DJAJJm6EjixUs056.m4a\r\n《修真老师生活录》75-别墅救人$http://audio.xmcdn.com/group10/M0A/49/5E/wKgDaVcV_CGg9Va0AIV1IgW3g44382.m4a\r\n《修真老师生活录》76-打小报告$http://audio.xmcdn.com/group9/M03/4C/CE/wKgDZlcXgTDDyg-5AKXSJw5UtUA201.m4a\r\n《修真老师生活录》77-请客$http://audio.xmcdn.com/group15/M08/4B/3D/wKgDaFcXgfqAvJo-AJ1jI2z1pwo843.m4a\r\n《修真老师生活录》78-因祸得福$http://audio.xmcdn.com/group14/M0B/53/E8/wKgDY1ceLBKidgnGAIvl5sJmruY436.m4a\r\n《修真老师生活录》79-突破$http://audio.xmcdn.com/group15/M04/4D/AA/wKgDZVcaOm_ym6LoAIZXomr1liU707.m4a\r\n《修真老师生活录》80-行医$http://audio.xmcdn.com/group7/M0B/4F/91/wKgDX1caOxeyxyaCAJCNTePlBiM665.m4a\r\n《修真老师生活录》81-烦恼$http://audio.xmcdn.com/group10/M00/4F/9D/wKgDaVcc3DOgvSuoAI7FYLZ8NFg823.m4a\r\n《修真老师生活录》82-困境$http://audio.xmcdn.com/group11/M09/5C/45/wKgDbVcc3PahO3HMAKyE4T9_MfY635.m4a\r\n《修真老师生活录》83-第一名有奖金$http://audio.xmcdn.com/group9/M04/52/CE/wKgDZlceLNDhjcoYAJM4nyITw-Q109.m4a\r\n《修真老师生活录》84-张卫东篮球场上小试牛刀$http://audio.xmcdn.com/group15/M0A/55/3E/wKgDaFciHTOAnoXjAJOhN01ZZ1M537.m4a\r\n《修真老师生活录》85-初露锋芒$http://audio.xmcdn.com/group14/M0A/57/D9/wKgDZFciJqqjZaurAI602k-8ACU062.m4a\r\n《修真老师生活录》86-相逢至尊娱乐城$http://audio.xmcdn.com/group10/M09/52/CE/wKgDZ1cjXdzAGsCIAI0ro1OGsuA793.m4a\r\n《修真老师生活录》87-敬酒不吃吃罚酒$http://audio.xmcdn.com/group15/M09/56/4F/wKgDaFcjXrXTHuCeAImiky6uj68343.m4a\r\n《修真老师生活录》88-欺人太甚$http://audio.xmcdn.com/group11/M0B/63/B6/wKgDbVck0XDx6OcAAJG4ccZQWC4265.m4a\r\n《修真老师生活录》89-阴招儿$http://audio.xmcdn.com/group11/M07/4A/A9/wKgDa1ck0f6wDrKhAImikB_Jnmw108.m4a\r\n《修真老师生活录》90-张前辈$http://audio.xmcdn.com/group12/M0B/58/56/wKgDW1ck0raSyo2tAI1k2Yj42LA673.m4a\r\n《修真老师生活录》91-出名了$http://audio.xmcdn.com/group7/M03/5B/CA/wKgDX1cnbAeSNTt4AJfv6P_jgno883.m4a\r\n《修真老师生活录》92-形势不妙$http://audio.xmcdn.com/group14/M02/5F/FF/wKgDZFcrXhzCtqEGAJVtgmsfHO0888.m4a\r\n《修真老师生活录》93-武林大会$http://audio.xmcdn.com/group12/M03/5E/93/wKgDXFcrXvLTtlbhAI3-6sHojjs118.m4a\r\n《修真老师生活录》94-心脏病$http://audio.xmcdn.com/group11/M03/6B/41/wKgDbVctSOuQ61lEAIqDDmeb2Qk742.m4a\r\n《修真老师生活录》95-你也配进去？$http://audio.xmcdn.com/group8/M09/60/12/wKgDYVctU9OjfsvuAKTiB6aa9No409.m4a\r\n《修真老师生活录》96-道歉$http://audio.xmcdn.com/group12/M09/67/D0/wKgDW1c1hlvQedSfAJezw22ouaA915.m4a\r\n《修真老师生活录》97-神手施针$http://audio.xmcdn.com/group11/M09/73/29/wKgDbVc1hwejLcQ5AJQ2iHIGMfk699.m4a\r\n《修真老师生活录》99-我想换秘书$http://audio.xmcdn.com/group12/M06/69/09/wKgDXFc2pnyTb9TrAJNZKE6NKAY125.m4a\r\n《修真老师生活录》98-出院$http://audio.xmcdn.com/group11/M00/5B/29/wKgDa1c2rsrjAc60AIxlhLwUTUQ588.m4a\r\n《修真老师生活录》100-做人不要太嚣张$http://audio.xmcdn.com/group9/M0B/69/79/wKgDYlc29sTw_o3-AJOd1g9JC1o317.m4a\r\n《修真老师生活录》101-面子怎么这么大！$http://audio.xmcdn.com/group15/M0B/68/C0/wKgDaFc3SW2hgVSDAJoV-_yPsGo967.m4a\r\n《修真老师生活录》102-老寒腿$http://audio.xmcdn.com/group15/M00/68/96/wKgDZVc3ShiQRiQrAJoF5bgfSjs134.m4a\r\n《修真老师生活录》103-邀请$http://audio.xmcdn.com/group10/M06/69/77/wKgDaVc4mA7yYFmyAIsRM-TLkgk976.m4a\r\n《修真老师生活录》104-三种人$http://audio.xmcdn.com/group14/M0A/6C/68/wKgDZFc4mL_QaI3hAKKT81yYp54314.m4a\r\n《修真老师生活录》105-谁才是高富帅？$http://audio.xmcdn.com/group7/M0A/6C/6F/wKgDX1c5nibRzlQCAI0PxDnYAww736.m4a\r\n《修真老师生活录》106-下手要趁早$http://audio.xmcdn.com/group12/M02/6C/23/wKgDW1c50GvyN37AAJ-qwwyzU74657.m4a\r\n《修真老师生活录》107-老大的派头$http://audio.xmcdn.com/group11/M02/5E/76/wKgDa1c50RfCC5xVAJSZEYa3Eag184.m4a\r\n《修真老师生活录》108-大家认识的$http://audio.xmcdn.com/group7/M05/70/EE/wKgDX1c9pbCASZDRAKJB5uV3Q7w302.m4a\r\n《修真老师生活录》109-烧烤$http://audio.xmcdn.com/group9/M05/70/EA/wKgDZlc9uLuB4lW5AI_XVwlzVx0142.m4a\r\n《修真老师生活录》110-烧烤$http://audio.xmcdn.com/group9/M0A/73/7E/wKgDZldAOiPCbnwNAIzlIglqtOU062.m4a\r\n《修真老师生活录》111-老大的老大$http://audio.xmcdn.com/group15/M0B/72/34/wKgDaFdAOpPRjbB-AKACogoINwo544.m4a\r\n《修真老师生活录》112-昨晚没睡好觉$http://audio.xmcdn.com/group9/M05/7B/9A/wKgDYldHl8ehAEsaAJd3x92yTAc912.m4a\r\n《修真老师生活录》113-一纸调令$http://audio.xmcdn.com/group8/M01/7C/66/wKgDYVdIRRTzrzAIAIsHCrpWENc037.m4a\r\n《修真老师生活录》114-家$http://audio.xmcdn.com/group10/M06/78/3F/wKgDZ1dIYADDQtBKAJk0trvYYnY217.m4a\r\n《修真老师生活录》115-伐毛洗髓$http://audio.xmcdn.com/group11/M03/88/9A/wKgDbVdJIqaQfHIFAIlUFKgTy-s363.m4a\r\n《修真老师生活录》116-火车巧遇$http://audio.xmcdn.com/group16/M04/7E/05/wKgDbFdJWaWCduIFAJvMusMcwgM068.m4a\r\n《修真老师生活录》117-省委三号车$http://audio.xmcdn.com/group16/M01/82/A2/wKgDaldNqnyCsoXWAJf2Dv77jtU322.m4a\r\n《修真老师生活录》118-试探$http://audio.xmcdn.com/group16/M0B/83/82/wKgDaldOpRbT110EAJHP5di40p4341.m4a\r\n《修真老师生活录》119-证书$http://audio.xmcdn.com/group16/M0A/84/B7/wKgDbFdP6BSCFZeDAJOlzAV7vQY017.m4a\r\n《修真老师生活录》120-车祸$http://audio.xmcdn.com/group15/M06/83/69/wKgDaFdP8KHRlWCvAJEbSRwvE-o223.m4a\r\n《修真老师生活录》121-你有医生执业资格证吗？$http://audio.xmcdn.com/group15/M04/86/3A/wKgDaFdTdPDTl9BQAJqcfBXJ4FU689.m4a\r\n《修真老师生活录》122-领导来了$http://audio.xmcdn.com/group10/M00/82/A9/wKgDZ1dTdZLDlqZcAJn69Tfu660468.m4a\r\n《修真老师生活录》123-如假包换$http://audio.xmcdn.com/group16/M04/87/61/wKgDaldTd47xEWfdAJfwMNejRuU077.m4a\r\n《修真老师生活录》124-陪我喝酒行吗？$http://audio.xmcdn.com/group7/M04/87/B2/wKgDX1dTpNaz9kNIAJPdmaJ6bfM521.m4a\r\n《修真老师生活录》125-心虚$http://audio.xmcdn.com/group6/M0A/99/7D/wKgDg1dY1riT15kYAKaDequcZfM167.m4a\r\n《修真老师生活录》126-又不是第一次！$http://audio.xmcdn.com/group15/M00/8B/1E/wKgDaFdY4-mh4vapAJoCYbMLChY857.m4a\r\n《修真老师生活录》127-很拉风$http://audio.xmcdn.com/group15/M03/8B/AA/wKgDZVdZjaCiuEtZAJWZKnENcU8664.m4a\r\n《修真老师生活录》128-中医科$http://audio.xmcdn.com/group12/M0A/8D/2F/wKgDXFdaZomDHki7AI1w9BC2abA000.m4a\r\n《修真老师生活录》129-专家会诊$http://audio.xmcdn.com/group11/M02/9A/F8/wKgDbVddapWyv90vAJIcQMzVtek066.m4a\r\n《修真老师生活录》130-真材实料$http://audio.xmcdn.com/group11/M08/9C/04/wKgDbVdes6WiiI8jAJh4vz2JFPA467.m4a\r\n《修真老师生活录》131-请教$http://audio.xmcdn.com/group9/M0B/92/1C/wKgDZldf1EGQACO5AJjQ2qW1BEU180.m4a\r\n《修真老师生活录》132-独门手法$http://audio.xmcdn.com/group7/M00/93/C9/wKgDWldhYsGTId1dAJOqMmw6mpI240.m4a\r\n《修真老师生活录》133-保健局$http://audio.xmcdn.com/group6/M0A/9C/B8/wKgDhFdha4iAg2gYAJQSeKJutu4522.m4a\r\n《修真老师生活录》134-保健局局长$http://audio.xmcdn.com/group7/M00/96/44/wKgDWldkqqGwj4wlAJnJBaFM0X4024.m4a\r\n《修真老师生活录》135-求救$http://audio.xmcdn.com/group7/M09/96/58/wKgDWldkxOTBoZvcAJnwrATUp8c095.m4a\r\n《修真老师生活录》136-出了问题我负责$http://audio.xmcdn.com/group16/M01/96/54/wKgDaldlHlaTMV6OAJoraarFJSQ338.m4a\r\n《修真老师生活录》137-拉拉队$http://audio.xmcdn.com/group14/M0B/9A/00/wKgDY1donlbwF_gYAI4PjMVQCdU393.m4a\r\n《修真老师生活录》138-姗姗来迟$http://audio.xmcdn.com/group16/M0B/99/85/wKgDaldpLYGB4jetAJVuegkgdKU057.m4a\r\n《修真老师生活录》139-不带这么欺负人的$http://audio.xmcdn.com/group16/M06/99/91/wKgDaldpNm_Qq23pAI7l7uUeZmo245.m4a\r\n《修真老师生活录》140-我没空$http://audio.xmcdn.com/group5/M0A/8E/D1/wKgDtldsznaD-dAyAJcywum7SRA459.m4a\r\n《修真老师生活录》141-吻一送一$http://audio.xmcdn.com/group13/M09/9E/8B/wKgDXVdvPejT8CnGAJWUxCCYhdM897.m4a\r\n《修真老师生活录》142-要去参加武林大会$http://audio.xmcdn.com/group9/M07/9F/31/wKgDZldwi0bTbCn0AJmnXQVRpoU823.m4a\r\n《修真老师生活录》143-武林高手$http://audio.xmcdn.com/group11/M06/92/02/wKgDa1dx0cyCkPNvAJLj9w9jQPM891.m4a\r\n《修真老师生活录》144-不稀罕听$http://audio.xmcdn.com/group6/M08/AA/2A/wKgDhFdzF3qzScy8AJv59qkd1C4638.m4a\r\n《修真老师生活录》145-做生意跟做人一样$http://audio.xmcdn.com/group16/M08/A2/28/wKgDbFd0f1PDIBpOAJ-uk7pCeXU405.m4a\r\n《修真老师生活录》146-改走清纯路线$http://audio.xmcdn.com/group13/M06/A3/85/wKgDXld10mThsmLxAJcbQnZt2SA796.m4a\r\n《修真老师生活录》147-东哥，上车！$http://audio.xmcdn.com/group5/M05/98/04/wKgDtVd3KnCABCTsAIzDrDcr24A107.m4a\r\n《修真老师生活录》148-着火$http://audio.xmcdn.com/group16/M09/A5/22/wKgDbFd4fi7ybVG1AKGUoPNlJyw922.m4a\r\n《修真老师生活录》149-吴州三杰$http://audio.xmcdn.com/group13/M0B/A6/5F/wKgDXVd5u2WCFQONAJIJK-0Eis8072.m4a\r\n《修真老师生活录》150-暗器高手$http://audio.xmcdn.com/group17/M00/03/7A/wKgJKVd7Eg_QAJyQAJIpeH5E-Rw615.m4a\r\n《修真老师生活录》151-天南省武林同道$http://audio.xmcdn.com/group18/M05/0A/04/wKgJJVd9Kyjyc2JbAJbDJ7i-8Iw448.m4a\r\n《修真老师生活录》152-抵达$http://audio.xmcdn.com/group19/M05/0B/54/wKgJJld92orAVPonAJiF91EMc4A678.m4a\r\n《修真老师生活录》153-两下子$http://audio.xmcdn.com/group20/M07/0F/6D/wKgJJ1d_TKnycJCEAJvxKN5nZ8Y633.m4a\r\n《修真老师生活录》154-上座$http://audio.xmcdn.com/group18/M03/12/31/wKgJJVeAbtTRu8PUAJ5eTRRajUI455.m4a\r\n《修真老师生活录》155-凶狠$http://audio.xmcdn.com/group19/M05/15/6A/wKgJJleBw6KRRtZzAKAJnY9tVpo392.m4a\r\n《修真老师生活录》156-出手$http://audio.xmcdn.com/group17/M08/18/AA/wKgJKVeDBrnBNyV0AJku5O2m6Jw663.m4a\r\n《修真老师生活录》157-私人俱乐部$http://audio.xmcdn.com/group20/M03/1C/A7/wKgJJ1eEYayQYyctAKAblGUtlZc777.m4a\r\n《修真老师生活录》158-收我为徒$http://audio.xmcdn.com/group17/M08/20/E2/wKgJKVeFwo3B33ymAJDaqg7wQLc008.m4a\r\n《修真老师生活录》159-神奇的药水$http://audio.xmcdn.com/group19/M02/24/B2/wKgJK1eHD13xmi9LAIzbLcUP7ik336.m4a\r\n《修真老师生活录》160-谁厉害$http://audio.xmcdn.com/group19/M07/29/3A/wKgJJleIj9-Bk76eAJSvlX0kBhY652.m4a\r\n《修真老师生活录》161-看出端倪$http://audio.xmcdn.com/group19/M0B/2B/92/wKgJK1eJhl7RpOebAJ2g3-JFHTE827.m4a\r\n《修真老师生活录》162-同道中人$http://audio.xmcdn.com/group19/M08/2E/CF/wKgJK1eK4Lqj-um0AI6SPYhCjnw769.m4a\r\n《修真老师生活录》163-回学校$http://audio.xmcdn.com/group20/M02/31/E1/wKgJLFeMKffgnO-tAJ6w34Sz_tI580.m4a\r\n《修真老师生活录》164-把嘴张开$http://audio.xmcdn.com/group19/M08/36/6B/wKgJK1eNtfSyuKHyAKCg3Mnm6HY162.m4a\r\n《修真老师生活录》165-嚣张的学生$http://audio.xmcdn.com/group20/M08/3A/6A/wKgJJ1ePED_CK9TIAKdRD5fKXEg273.m4a\r\n《修真老师生活录》166-我不能知法犯法$http://audio.xmcdn.com/group17/M09/42/AF/wKgJKVeR7LDgQ7VoAJVqFLJ_Bqo479.m4a\r\n《修真老师生活录》167-女朋友？$http://audio.xmcdn.com/group19/M07/42/88/wKgJK1eR7RCAjqlOAJu_TjuiFvw355.m4a\r\n《修真老师生活录》168-误解$http://audio.xmcdn.com/group19/M00/46/47/wKgJJleTMceiR_yLAKZb0_IPDmk373.m4a\r\n《修真老师生活录》169-不准勾引老师$http://audio.xmcdn.com/group20/M01/49/15/wKgJJ1eUc1HB9F_YAKXBpiuUFas315.m4a\r\n《修真老师生活录》170-美男出浴图$http://audio.xmcdn.com/group17/M02/4B/77/wKgJKVeVYJLD-5_JAJ4vUBuWT2I543.m4a\r\n《修真老师生活录》171-事态严重$http://audio.xmcdn.com/group20/M07/50/22/wKgJJ1eW51SwhK-vAKKP-xzcN9A811.m4a\r\n《修真老师生活录》172-好自为之$http://audio.xmcdn.com/group20/M02/54/45/wKgJLFeYtN6AVXdWAI-q8Fsb-A4257.m4a\r\n《修真老师生活录》173-害怕$http://audio.xmcdn.com/group20/M0B/57/3C/wKgJLFeZ2Syg9UyXAJhPoWdadYY716.m4a\r\n《修真老师生活录》174-该怎样就怎样！$http://audio.xmcdn.com/group19/M02/5B/74/wKgJJlebA1vQ3F_MAJbEojaSwZc944.m4a\r\n《修真老师生活录》175-上火$http://audio.xmcdn.com/group18/M01/5D/BA/wKgJJVecG6bDuEaMAJwmAwry95Q063.m4a\r\n《修真老师生活录》176-我是来找张老师的$http://audio.xmcdn.com/group19/M06/60/6B/wKgJK1edUqbDCoOYAJgjk5TM6lo144.m4a\r\n《修真老师生活录》177-坐我边上吧$http://audio.xmcdn.com/group19/M09/63/F5/wKgJK1eewyyDcOm2AItTGbrppMc848.m4a\r\n《修真老师生活录》178-爱看就看吧$http://audio.xmcdn.com/group18/M0B/67/AE/wKgJJVegBLaQAdgDAJXJhG99eiY960.m4a\r\n《修真老师生活录》179-二选一$http://audio.xmcdn.com/group18/M05/6B/45/wKgJKlehZFPBCBUNAJfnX_DhAQU944.m4a\r\n《修真老师生活录》180-亲戚$http://audio.xmcdn.com/group20/M09/6D/D7/wKgJLFeio4STPLuqAJVc3MgTX0k239.m4a\r\n《修真老师生活录》181-前倨后恭$http://audio.xmcdn.com/group17/M04/75/AA/wKgJKVeknDKRsmUIAJdUhybFPt8409.m4a\r\n《修真老师生活录》182-他真的是老师？$http://audio.xmcdn.com/group20/M06/75/6B/wKgJLFelOwPBtTt9AJD5hBNSrCk286.m4a\r\n《修真老师生活录》183-帮忙$http://audio.xmcdn.com/group18/M02/7A/20/wKgJKlem77ayDw1GAJdzXVDH804229.m4a\r\n《修真老师生活录》184-小题大做$http://audio.xmcdn.com/group18/M02/7D/6F/wKgJKleoOamiq7WTAJL7d4N9oIo945.m4a\r\n《修真老师生活录》185-要不要来一场姐弟恋？$http://audio.xmcdn.com/group19/M09/81/BC/wKgJK1epje2jac22AJv1j_5f0TA469.m4a\r\n《修真老师生活录》186-楚朝晖提前升官$http://audio.xmcdn.com/group19/M0A/86/32/wKgJJlerFALA1CjXAJCUMa-i6E8160.m4a\r\n《修真老师生活录》187-冤家路窄$http://audio.xmcdn.com/group17/M03/87/78/wKgJJFer73zgd3tqAJGSOiDbFUE725.m4a\r\n《修真老师生活录》188-这小白脸还真能打$http://audio.xmcdn.com/group20/M08/8B/80/wKgJLFetiZHj4vODAJCxjzs3JJ0608.m4a\r\n《修真老师生活录》189—三只恶虎$http://audio.xmcdn.com/group17/M07/8F/9B/wKgJKVeuxJ6xRM4EAKWlvwnGwi8016.m4a\r\n《修真老师生活录》190-原来是三个大人物$http://audio.xmcdn.com/group18/M02/92/79/wKgJJVewFT6jkPuNAJM3rNcsOsI856.m4a\r\n《修真老师生活录》191-包厢内外$http://audio.xmcdn.com/group18/M06/99/72/wKgJKley-4-QiDQ-AJ5W-IQ3vNw165.m4a\r\n《修真老师生活录》192-谭永谦好郁闷$http://audio.xmcdn.com/group19/M0A/9C/93/wKgJJlezzLfy2GAfAJbzn2v7_VA608.m4a\r\n《修真老师生活录》193-秘书长在哪里上班？$http://audio.xmcdn.com/group18/M02/9E/69/wKgJKle1CdHQaNSPAJssYXDCzJ4955.m4a\r\n《修真老师生活录》194-出发武夷山$http://audio.xmcdn.com/group19/M08/A3/C9/wKgJK1e2avbRyKVRAI2UMHJLwB8001.m4a\r\n《修真老师生活录》195-对上眼了$http://audio.xmcdn.com/group17/M07/A7/33/wKgJJFe3zenzp41HAJrEl-JIoAM743.m4a\r\n《修真老师生活录》196-小鬼头$http://audio.xmcdn.com/group19/M08/AB/42/wKgJJle5VUrgK1KnAI3mbe725DI349.m4a\r\n《修真老师生活录》197-酒桌上的神奇$http://audio.xmcdn.com/group17/M0A/AE/4C/wKgJJFe6wvrhzZgMAI_xMvIKmaE261.m4a\r\n《修真老师生活录》198-做法$http://audio.xmcdn.com/group19/M08/B3/61/wKgJJle8VZ3Don4DAJC6XJFaCF0196.m4a\r\n《修真老师生活录》199-罗大师被揭穿$http://audio.xmcdn.com/group17/M07/B4/94/wKgJKVe9BA2y_TFeAJXJhOFJ29A657.m4a\r\n《修真老师生活录》200-您太神了$http://audio.xmcdn.com/group20/M0A/B7/27/wKgJLFe-ZwaBrmntAJWb_8EGBVw188.m4a\r\n《修真老师生活录》201-奇人行事$http://audio.xmcdn.com/group17/M00/BC/40/wKgJJFe_q2XR5vYjAJIX9_hkdXs209.m4a\r\n《修真老师生活录》202-吃醋了？$http://audio.xmcdn.com/group19/M00/C0/70/wKgJJlfBC5Lg8UoAAKNNKGQ4OYg611.m4a\r\n《修真老师生活录》203-张卫东被误会$http://audio.xmcdn.com/group20/M02/C4/AB/wKgJJ1fC09fDLgl9AKB3wT9qAjg929.m4a\r\n《修真老师生活录》204-我们是大学老师$http://audio.xmcdn.com/group17/M01/C5/7E/wKgJJFfDj1XTRZhjAJtD4Vh3jxg756.m4a\r\n《修真老师生活录》205-真正的杀机$http://audio.xmcdn.com/group20/M05/CA/41/wKgJJ1fE-33RE5k8AJuWHpv3Jfw542.m4a\r\n《修真老师生活录》206-真想拿刀阉了你$http://audio.xmcdn.com/group18/M05/CC/F7/wKgJKlfGirKDLMvbAKNUgZvO8TQ698.m4a\r\n《修真老师生活录》207-非常牛叉的色狼$http://audio.xmcdn.com/group18/M02/D1/F2/wKgJJVfIJP2iilqLAJUgqJ7ClX8606.m4a\r\n《修真老师生活录》208-出了点问题$http://audio.xmcdn.com/group19/M09/D5/9E/wKgJJlfJPXCwRaDCAJg1NZTASII955.m4a\r\n《修真老师生活录》209-不会是吹牛吧$http://audio.xmcdn.com/group19/M04/D9/BC/wKgJJlfKzFbTvMYIAI3QZAic2rg562.m4a\r\n《修真老师生活录》210-笑什么笑？$http://audio.xmcdn.com/group20/M0B/DB/D5/wKgJJ1fLu0jTSk4bAJEp-K03hlk706.m4a\r\n《修真老师生活录》211-李丽的春天到了$http://audio.xmcdn.com/group19/M0B/E2/FB/wKgJK1fOPXyTb_DHAI6AmwBVQGk892.m4a\r\n《修真老师生活录》212-有了媳妇忘了娘$http://audio.xmcdn.com/group20/M04/E5/0B/wKgJJ1fOvNfQFZDzAKgNUDfO3bg176.m4a\r\n《修真老师生活录》213-张卫东成了肥羊$http://audio.xmcdn.com/group17/M0B/E6/FE/wKgJJFfPx9-gkhqvAI5u_YoRlHE934.m4a\r\n《修真老师生活录》214-找你们许院长去$http://audio.xmcdn.com/group17/M08/EA/11/wKgJKVfQy3OgO36XAJi354veMtI796.m4a\r\n《修真老师生活录》215-告状$http://audio.xmcdn.com/group19/M09/EF/87/wKgJJlfSsozSZfxhAJ6OwcT0Ru8607.m4a\r\n《修真老师生活录》216-就诊$http://audio.xmcdn.com/group19/M08/F3/6E/wKgJJlfUGVeBKWFMAJ4DQ85Pc40715.m4a\r\n《修真老师生活录》217-我给你提个醒$http://audio.xmcdn.com/group20/M06/F5/BC/wKgJLFfVaBKygiB_AJlt-xDq-NA907.m4a\r\n《修真老师生活录》218-一语成谶$http://audio.xmcdn.com/group18/M0B/F9/EA/wKgJJVfWpADT4PbLAJp01fXrnxA564.m4a\r\n《修真老师生活录》219-让他马上回来给你看病$http://audio.xmcdn.com/group18/M04/FD/7F/wKgJKlfYC_mQTzVcAKgdLMHkzrE035.m4a\r\n《修真老师生活录》220-我是绝对不会罢休的$http://audio.xmcdn.com/group17/M00/02/67/wKgJKVfZVvbBngPgAJe26zI2MgU424.m4a\r\n《修真老师生活录》221-简直无法无天$http://audio.xmcdn.com/group19/M09/06/92/wKgJJlfapyaQPd8iAKQP96Oh2Hw374.m4a\r\n《修真老师生活录》222-秘书长的杀机$http://audio.xmcdn.com/group19/M0A/09/17/wKgJJlfbnp6gKFqLAKNnl8tLiW4915.m4a\r\n《修真老师生活录》223-刚才都是误会$http://audio.xmcdn.com/group17/M0A/0D/0E/wKgJJFfc_1fyy_M6AJ4HLYR-njw765.m4a\r\n《修真老师生活录》224-县里领导都来了$http://audio.xmcdn.com/group17/M00/12/62/wKgJKVfejCqzjozmAJZTj0wWycE002.m4a\r\n《修真老师生活录》225-向上汇报$http://audio.xmcdn.com/group20/M00/14/13/wKgJLFffoA3B_5VuAKwp5eEHjnY156.m4a\r\n《修真老师生活录》226-态度坚决$http://audio.xmcdn.com/group20/M08/19/8C/wKgJLFfhLhHDR4MnAIrQaDS6Ev8396.m4a\r\n《修真老师生活录》227-甩出两巴掌$http://audio.xmcdn.com/group20/M04/20/EF/wKgJJ1fimF-Dba0MAJlsg_3NxN8459.m4a\r\n《修真老师生活录》228—定身术$http://audio.xmcdn.com/group17/M08/26/34/wKgJKVfkAjaweNxjAKBgQeyH8xs492.m4a\r\n《修真老师生活录》229—你们对我做了什么！$http://audio.xmcdn.com/group17/M04/2A/DA/wKgJJFflTK2yQJSQAJCYl1z4bPw719.m4a\r\n《修真老师生活录》230—色字头上一把刀$http://audio.xmcdn.com/group18/M00/2C/75/wKgJKlfmV_zhOo84AJzn3NewRyw199.m4a\r\n《修真老师生活录》231-官场大变$http://audio.xmcdn.com/group20/M06/33/5A/wKgJJ1fn7HnzpFY4AKA8PyiCwAo372.m4a\r\n《修真老师生活录》232—昨日重现$http://audio.xmcdn.com/group17/M0A/35/D2/wKgJJFfpBkyg4_xcAKOa-mdiO9k931.m4a\r\n《修真老师生活录》233-做实业不容易啊$http://audio.xmcdn.com/group20/M05/38/1B/wKgJLFfqRvHCwgP_AKe06hQlqDs592.m4a\r\n《修真老师生活录》234-火爆脾气的侄子$http://audio.xmcdn.com/group20/M0B/3D/A4/wKgJLFfr59ODgKt8AKE6TEh98NQ685.m4a\r\n《修真老师生活录》235-三进宫$http://audio.xmcdn.com/group17/M08/41/D5/wKgJJFfs8kvAvlO0AKBXcK0DXpU950.m4a\r\n《修真老师生活录》236-书记发飙$http://audio.xmcdn.com/group20/M02/45/19/wKgJJ1fuEvuD4CrOAJ6dcIkzKrU454.m4a\r\n《修真老师生活录》237-明镜湖边$http://audio.xmcdn.com/group18/M00/48/7C/wKgJJVfvjH2iYI3sAJUwznTDEik122.m4a\r\n《修真老师生活录》238-我相信你$http://audio.xmcdn.com/group19/M09/4B/21/wKgJK1fwe0iCuXbyAKU5NM-fOhc059.m4a\r\n《修真老师生活录》239-不要走$http://audio.xmcdn.com/group18/M0B/4D/3F/wKgJKlfxwbqBAOMtAJoMk3QNciw672.m4a\r\n《修真老师生活录》240-尴尬一夜$http://audio.xmcdn.com/group20/M08/54/0B/wKgJLFf0jTqQKVXSAKGcF_ccU8U614.m4a\r\n《修真老师生活录》241-有劳张大侠$http://audio.xmcdn.com/group19/M04/5A/B3/wKgJK1f2Qzqzk1aUAIwiV_A_FzM345.m4a\r\n《修真老师生活录》242-撞鬼了$http://audio.xmcdn.com/group19/M0B/5D/2B/wKgJK1f3LgvAOmpOAJj1kivK_qE747.m4a\r\n《修真老师生活录》243—辟邪符$http://audio.xmcdn.com/group20/M02/5F/90/wKgJLFf4fODB6IWtAKMrY65eMMo974.m4a\r\n《修真老师生活录》244—说钱$http://audio.xmcdn.com/group19/M09/66/7F/wKgJJlf6EGqhm8nAAJSYGJWMhT8070.m4a\r\n《修真老师生活录》245—巧遇导师$http://audio.xmcdn.com/group19/M07/6A/98/wKgJK1f7YBySj6U4AJcoeWXoxms955.m4a\r\n《修真老师生活录》246—原来是普通朋友$http://audio.xmcdn.com/group17/M04/70/33/wKgJJFf88p_AsPOLAJLeqT2dGLM796.m4a\r\n《修真老师生活录》247——喝酒$http://audio.xmcdn.com/group19/M05/72/4D/wKgJK1f957ThCd69AJhYcn6rLuc955.m4a\r\n《修真老师生活录》248—事情变化太快$http://audio.xmcdn.com/group20/M04/78/92/wKgJJ1f_r43zLXuWAKKLU3bH8jY903.m4a\r\n《修真老师生活录》249-原来是张老师$http://audio.xmcdn.com/group19/M02/78/BA/wKgJJlf_v4niv8azAKZ2Q-6zh8M290.m4a\r\n《修真老师生活录》250—辟邪符起作用$http://audio.xmcdn.com/group18/M0B/7C/71/wKgJJVgBnw7BDUqEAJdDNhvRBi4817.m4a\r\n《修真老师生活录》251—高人出马$http://audio.xmcdn.com/group17/M06/80/E6/wKgJJFgC8EDBwQwpAJlz2YsHtT8213.m4a\r\n《修真老师生活录》252—抓鬼$http://audio.xmcdn.com/group20/M01/85/26/wKgJJ1gEUVXhhrRnAJwFw610TYQ897.m4a\r\n《修真老师生活录》253—另一种英雄救美$http://audio.xmcdn.com/group17/M04/8A/62/wKgJKVgFzhmC_dRNAJmIat8SyiA478.m4a\r\n《修真老师生活录》254—冬天里的一把火$http://audio.xmcdn.com/group18/M03/8F/2D/wKgJJVgHZqiDtaBwAKszMjV3Kok076.m4a\r\n《修真老师生活录》255—东哥真牛$http://audio.xmcdn.com/group18/M0B/91/93/wKgJJVgIIeHTE7f2AJ2c1FRhQ8M928.m4a\r\n《修真老师生活录》256—是你？！$http://audio.xmcdn.com/group20/M07/96/97/wKgJJ1gJdAywYwmkAJtqQEpuIaY161.m4a\r\n《修真老师生活录》257—相遇$http://audio.xmcdn.com/group20/M02/9B/01/wKgJJ1gKzSnzkLZsAJtbYVIxWGc064.m4a\r\n《修真老师生活录》258—梦想$http://audio.xmcdn.com/group19/M00/A0/B0/wKgJJlgMeyTRA1QeAJKPhN9Cv28801.m4a\r\n《修真老师生活录》259—你就是我心中的皇帝$http://audio.xmcdn.com/group18/M07/A4/7E/wKgJJVgN0vGwCrE_AKAT5l8xm1k584.m4a\r\n《修真老师生活录》260—她是你的马子？$http://audio.xmcdn.com/group18/M01/A9/C9/wKgJKlgPYsDC46tSAInOChqQ2t0466.m4a\r\n《修真老师生活录》261—神仙哥哥$http://audio.xmcdn.com/group24/M02/00/36/wKgJNVgQHPjiabqNAJFpw75oPWs943.m4a\r\n《修真老师生活录》262—携美回吴州$http://audio.xmcdn.com/group25/M06/03/11/wKgJMVgQ3r3Da6VJAJM0uc7wivU299.m4a\r\n《修真老师生活录》263—邀请卡$http://audio.xmcdn.com/group21/M05/06/FC/wKgJKFgSqz2QKJYZAJAr74ug8G0767.m4a\r\n《修真老师生活录》264—饭店遇熟人$http://audio.xmcdn.com/group21/M09/09/D3/wKgJKFgTgHKTYz_1AJN-JRFzCys722.m4a\r\n《修真老师生活录》265—合作$http://audio.xmcdn.com/group24/M03/0D/C7/wKgJNVgVehXxe7EjAI4IMhXPirc617.m4a\r\n《修真老师生活录》267—肥水不流外人田$http://audio.xmcdn.com/group24/M05/17/66/wKgJMFgZSAqBGJY-AJC0t1EmvZ0067.m4a\r\n《修真老师生活录》266—时来运转$http://audio.xmcdn.com/group23/M06/17/89/wKgJL1gZSRDzA7ktAJPwr5wzCg4748.m4a\r\n《修真老师生活录》268—悔不该$http://audio.xmcdn.com/group25/M05/1C/6A/wKgJNlgbHJyTs0kEAJcfrJ59Pr8576.m4a\r\n《修真老师生活录》269—道别$http://audio.xmcdn.com/group23/M0A/1E/DC/wKgJL1gcE5ChJgaKAJV4JlgI_XY335.m4a\r\n《修真老师生活录》270—突如其来的突破$http://audio.xmcdn.com/group21/M0A/22/62/wKgJKFgdh-Cgv_rGAIWSQ3FWecE113.m4a\r\n《修真老师生活录》271—结丹$http://audio.xmcdn.com/group24/M06/25/F7/wKgJMFge5--yPJBQAJ73N5zst0E926.m4a\r\n《修真老师生活录》272—政绩$http://audio.xmcdn.com/group23/M09/29/6E/wKgJNFggMrCg2rdoAJFnpIzzKq8722.m4a\r\n《修真老师生活录》273—白洁的朋友$http://audio.xmcdn.com/group22/M04/2C/98/wKgJM1ghfJOwYRSDAJbmZ1xE7-U359.m4a\r\n《修真老师生活录》274—这算是秒杀吗？$http://audio.xmcdn.com/group22/M01/2F/4E/wKgJM1giibWiGIOIAJop8ZchB3Y908.m4a\r\n《修真老师生活录》275—疯狂的人们$http://audio.xmcdn.com/group23/M0B/32/8E/wKgJL1gj3OXyq0jKAJsuFgFTca4404.m4a\r\n《修真老师生活录》276—你还知道叫我老师？$http://audio.xmcdn.com/group22/M07/36/86/wKgJLlgljSmCwVxhAJ7tABim7FQ463.m4a\r\n《修真老师生活录》277—较劲$http://audio.xmcdn.com/group25/M01/39/D5/wKgJMVgnIaDhjH0DAJgn_ovUQ3A949.m4a\r\n《修真老师生活录》278—安排$http://audio.xmcdn.com/group25/M07/3B/37/wKgJMVgn5PrQWkFZAJXvtKYHuZo103.m4a\r\n《修真老师生活录》279—差点崩溃$http://audio.xmcdn.com/group23/M07/3F/04/wKgJL1gpFVXjEBzJAJQMlgVPotE554.m4a\r\n《修真老师生活录》280—张老师还是专家$http://audio.xmcdn.com/group21/M07/42/20/wKgJKFgqX5XRBbyUAIsnDPKryvU350.m4a\r\n《修真老师生活录》281—五百万$http://audio.xmcdn.com/group25/M0B/46/21/wKgJNlgrzGuBhnTxAJCkV86iGWk290.m4a\r\n《修真老师生活录》282—比你更嚣张$http://audio.xmcdn.com/group22/M05/4B/35/wKgJM1gtpCfT7rZ9AJRgSxtmTfI872.m4a\r\n《修真老师生活录》283—下次我绝对不敢了$http://audio.xmcdn.com/group24/M02/4C/DD/wKgJNVguZKCSQYfMAImAIki4lfg376.m4a\r\n《修真老师生活录》284—禁制$http://audio.xmcdn.com/group22/M06/51/35/wKgJM1gwGXHSulMSAJb8bJLSwVo450.m4a\r\n《修真老师生活录》285—买房$http://audio.xmcdn.com/group25/M0B/53/02/wKgJMVgxB2rAvqpjAIYU9WJ3RZI704.m4a\r\n《修真老师生活录》286—项目申请下来了$http://audio.xmcdn.com/group25/M05/5A/11/wKgJNlgzBTuQu1IxAJ_3_5Y1qvM944.m4a\r\n《修真老师生活录》287—跟你讲了也没用$http://audio.xmcdn.com/group24/M08/5B/39/wKgJNVgzpCTRCmSaAJVdYGfAi7s407.m4a\r\n《修真老师生活录》288—盐帮$http://audio.xmcdn.com/group24/M09/60/06/wKgJNVg1bCmD3NlsAJfAXabJhTc746.m4a\r\n《修真老师生活录》289—青城山$http://audio.xmcdn.com/group21/M05/63/C6/wKgJLVg2o1PyfgqMAJlB7ZyuTuA167.m4a\r\n《修真老师生活录》290—前辈真人$http://audio.xmcdn.com/group25/M03/67/27/wKgJMVg4EZfDuePvAJug6mgJR_g256.m4a\r\n《修真老师生活录》291—石中火$http://audio.xmcdn.com/group23/M00/73/77/wKgJL1g8Klbw14hxAIeRSF3PP3k644.m4a\r\n《修真老师生活录》292—五行剑$http://audio.xmcdn.com/group23/M08/7C/21/wKgJL1g9fAyT3i64AJ33g9rCNUU390.m4a\r\n《修真老师生活录》293—我不喜欢$http://audio.xmcdn.com/group24/M02/7F/70/wKgJNVg-Rjuzosi7AJqAmWhLPcE548.m4a\r\n《修真老师生活录》294—拍卖$http://audio.xmcdn.com/group22/M0A/87/8E/wKgJM1hALr7y8Wp_AJQ3O4VbDtQ733.m4a\r\n《修真老师生活录》295—原来是个教书的$http://audio.xmcdn.com/group25/M05/89/DB/wKgJMVhBTpiw6BzoAJSScNgmqAs059.m4a\r\n《修真老师生活录》296—是吴州的张卫东先生吗？$http://audio.xmcdn.com/group21/M01/8D/29/wKgJKFhChXiBRRyFAJX0GoRNWwA140.m4a\r\n《修真老师生活录》297—不跟你们小孩子玩$http://audio.xmcdn.com/group23/M02/92/02/wKgJL1hD_Q_BOfdoAJmOSDEf5HQ504.m4a\r\n《修真老师生活录》298—原来这不是一块普通的玉啊！$http://audio.xmcdn.com/group22/M06/97/76/wKgJLlhGEyWwDQDpAKPfLEJ2flc008.m4a\r\n《修真老师生活录》299—东哥，我是小顾啊！$http://audio.xmcdn.com/group22/M05/9B/51/wKgJLlhHb2DDW0MvAKNnl-gohEQ811.m4a\r\n《修真老师生活录》300—我会出马的$http://audio.xmcdn.com/group21/M09/9E/E1/wKgJKFhIuzXB3GKVAJU85BhofiQ141.m4a\r\n《修真老师生活录》301—刘胜男的烦恼$http://audio.xmcdn.com/group23/M01/A5/46/wKgJL1hKigqDUXi0AI05JlhK_YM226.m4a\r\n《修真老师生活录》302—一滴血$http://audio.xmcdn.com/group25/M06/A9/69/wKgJMVhLbXKzNgdaAIBkQVkSd10634.m4a\r\n《修真老师生活录》303—一索马里海盗$http://audio.xmcdn.com/group22/M0A/B7/64/wKgJLlhOmwHhg560AJ6sRGYojis844.m4a\r\n《修真老师生活录》304—一再次误会$http://audio.xmcdn.com/group25/M09/B8/5E/wKgJNlhPT2DBv3MWAJDN86r_UWk447.m4a\r\n《修真老师生活录》305—一唐家$http://audio.xmcdn.com/group24/M04/C8/4D/wKgJNVhSnvjgxbTHAKNUgVpHMPk587.m4a\r\n《修真老师生活录》306—一故友$http://audio.xmcdn.com/group21/M02/C9/59/wKgJLVhTUBuSTJyBAJVD5OsaFyI127.m4a\r\n《修真老师生活录》307-活神仙$http://audio.xmcdn.com/group22/M09/CE/C3/wKgJM1hVGzPwmEo4AJalPr6MpRI187.m4a\r\n《修真老师生活录》308-授业恩师$http://audio.xmcdn.com/group21/M09/D0/51/wKgJKFhV95OwheOYAJRojD_EmqA835.m4a\r\n《修真老师生活录》309-研究敌情$http://audio.xmcdn.com/group23/M09/D8/65/wKgJNFhX6s6zt1vGAJZ2LWM4TFs086.m4a\r\n《修真老师生活录》310-索马里海盗$http://audio.xmcdn.com/group21/M02/D9/5A/wKgJKFhYkPmjcsLAAJxwPNX4bIw099.m4a\r\n《修真老师生活录》311-海盗窝救人质$http://audio.xmcdn.com/group23/M07/E5/A1/wKgJNFham4nDQOXPAKE7DWJvzKk232.m4a\r\n《修真老师生活录》312-我今后就是你的忠实仆人$http://audio.xmcdn.com/group22/M0A/EC/0F/wKgJLlhb9l6xoxMlAJqj0vsG03k038.m4a\r\n《修真老师生活录》313-降服海盗王$http://audio.xmcdn.com/group22/M02/F7/40/wKgJM1hejDjiTdttAJheUBsBqEk595.m4a\r\n《修真老师生活录》314-你不知道我是武林高手啊！$http://audio.xmcdn.com/group21/M00/FC/58/wKgJKFhfziKwnZSYAJ3aJBt43CA078.m4a\r\n《修真老师生活录》315-今天是你的生日？$http://audio.xmcdn.com/group22/M02/06/D0/wKgJM1hifT7RGaeBAJLHEzbd3kk390.m4a\r\n《修真老师生活录》316-深夜庆生$http://audio.xmcdn.com/group23/M07/09/CF/wKgJNFhjsIzBsaOKAJFtgv8Ckdk908.m4a\r\n《修真老师生活录》317-你就是张博士？$http://audio.xmcdn.com/group24/M03/0D/1E/wKgJMFhk6IfxDidvAKMNNhZzidQ198.m4a\r\n《修真老师生活录》318-你究竟托了什么人？$http://audio.xmcdn.com/group25/M08/13/83/wKgJNlhmMtHjhgZtAJrYsB9qobY377.m4a\r\n《修真老师生活录》319-这个张博士有点不懂规矩啊！$http://audio.xmcdn.com/group21/M09/19/4D/wKgJLVhnwznjp_NBAJqygfr80DY483.m4a\r\n《修真老师生活录》320-不给面子$http://audio.xmcdn.com/group25/M04/1C/81/wKgJMVhotXGDx3bBAJeyyuavNtY021.m4a\r\n《修真老师生活录》321-出了事情我承当$http://audio.xmcdn.com/group23/M06/21/3B/wKgJL1hqC9DwT3UvAJj9BhsZl7k162.m4a\r\n《修真老师生活录》322-张博士真有这么牛？$http://audio.xmcdn.com/group25/M02/23/66/wKgJNlhq_0mAnjgnAJUFJX8ymtE894.m4a\r\n《修真老师生活录》323-慌了$http://audio.xmcdn.com/group22/M08/2A/6A/wKgJM1hsV1-jRB7SAJbEogTqd3s925.m4a\r\n《修真老师生活录》324-你怎么会得罪楚朝晖的？$http://audio.xmcdn.com/group21/M0B/31/B0/wKgJLVht52fQGC-2AJnvNbL1638129.m4a\r\n《修真老师生活录》325-求情$http://audio.xmcdn.com/group22/M07/39/CD/wKgJM1hu92riae4XAJ0Qk-a7jBs574.m4a\r\n《修真老师生活录》326-果然是张卫东$http://audio.xmcdn.com/group21/M0B/43/A8/wKgJLVhwU7-Rd6jLAIxXlff__GY159.m4a\r\n《修真老师生活录》327-市委书记出面$http://audio.xmcdn.com/group21/M01/4F/C3/wKgJKFhxrs2j1CepAJT0BAPOv8g068.m4a\r\n《修真老师生活录》328-市委书记的面子也不给$http://audio.xmcdn.com/group24/M03/5F/BD/wKgJMFhzi8aRGjjPAKC-Osii27A160.m4a\r\n《修真老师生活录》329-赶快找张老师$http://audio.xmcdn.com/group23/M00/68/36/wKgJL1h0uzOjdl6iAJfkk4StWtk046.m4a\r\n《修真老师生活录》330-起死回生$http://audio.xmcdn.com/group22/M00/6F/4B/wKgJM1h15FOy9fCkAJ4zt6fxkOs415.m4a\r\n《修真老师生活录》331-来日方长$http://audio.xmcdn.com/group21/M04/77/C8/wKgJKFh3OOPi_lDOAIXl9GfmCi8531.m4a\r\n《修真老师生活录》332-与市委书记争吵起来$http://audio.xmcdn.com/group23/M01/82/6C/wKgJNFh4pZmjqzYrAJKJpYGUYfs368.m4a\r\n《修真老师生活录》333-人事变动$http://audio.xmcdn.com/group24/M01/8A/61/wKgJNVh535XQyNaoAJv3ByfFoFw838.m4a\r\n《修真老师生活录》334-唐老拍桌子$http://audio.xmcdn.com/group21/M02/8F/B7/wKgJKFh64VfDXCfhAJkkj5endpc892.m4a\r\n《修真老师生活录》335-形势急转直下$http://audio.xmcdn.com/group23/M05/99/1D/wKgJNFh8MZqwFvdcAJU-eowgbOA795.m4a\r\n《修真老师生活录》336-你得罪了京城里的人吗？$http://audio.xmcdn.com/group21/M00/A0/98/wKgJLVh9fLPjv-_9AJSu-zoS-kc505.m4a\r\n《修真老师生活录》337-董家$http://audio.xmcdn.com/group23/M09/AA/EB/wKgJL1h-zfSQLHjFAKjwQwa6X-w458.m4a\r\n《修真老师生活录》338-北京饭店$http://audio.xmcdn.com/group21/M03/B2/99/wKgJLViAGiqDJs1iAJRIygVEe3Q746.m4a\r\n《修真老师生活录》339-有的人就是欠揍$http://audio.xmcdn.com/group22/M06/C2/F5/wKgJM1iB0JCiXvBDAJpvvgIrD_A224.m4a\r\n《修真老师生活录》340-唐部长，你好！$http://audio.xmcdn.com/group23/M08/CB/2B/wKgJNFiC08XASF0uAKUyeOuL-Gk594.m4a\r\n《修真老师生活录》341-道歉$http://audio.xmcdn.com/group24/M0B/DC/E2/wKgJNViEnV2xxwPvAJCwLvlCd2A858.m4a\r\n《修真老师生活录》342-急了$http://audio.xmcdn.com/group22/M03/E2/AB/wKgJM1iFX6OjXBirAKezc7uTnCQ600.m4a\r\n《修真老师生活录》343-一错再错$http://audio.xmcdn.com/group24/M03/EF/40/wKgJNViG1OmiiEHfAIP3GiYli9Q258.m4a\r\n《修真老师生活录》344-原谅$http://audio.xmcdn.com/group22/M02/FA/B7/wKgJM1iITb_BZXZLAJdQ6sL9H2Y225.m4a\r\n《修真老师生活录》345-你也认识叶思思？$http://audio.xmcdn.com/group24/M01/04/EA/wKgJMFiJstmi52oDAI-qtY6bEd8811.m4a\r\n《修真老师生活录》346-解禁$http://audio.xmcdn.com/group23/M0A/0D/98/wKgJNFiKzCXAehc5AKP3xB7Fu9E902.m4a\r\n《修真老师生活录》347-人事变动$http://audio.xmcdn.com/group25/M09/16/12/wKgJMViMQ-PRT3_BAJPG1B3BbpY357.m4a\r\n《修真老师生活录》349-坐过去点$http://audio.xmcdn.com/group25/M05/26/D6/wKgJMViOrL3w628AAJf5AfySF_s028.m4a\r\n《修真老师生活录》350-你认识市领导？$http://audio.xmcdn.com/group24/M04/33/3C/wKgJMFiQdy_Dv13wAKAhgkjpAjQ761.m4a\r\n《修真老师生活录》351-张博士有约$http://audio.xmcdn.com/group22/M07/3B/77/wKgJLliRbp3y5bLXAKcMO3JYfBo573.m4a\r\n《修真老师生活录》352-陈跃民$http://audio.xmcdn.com/group23/M0A/4A/7A/wKgJNFiTNJSRoz4dAJJLQerwd_s055.m4a\r\n《修真老师生活录》353-沙滩$http://audio.xmcdn.com/group23/M0A/50/4A/wKgJL1iT7yDgfziBAJLMd-8IdVM104.m4a\r\n《修真老师生活录》354-学生借钱$http://audio.xmcdn.com/group24/M0B/57/41/wKgJMFiVk6ihWM79AKhPGAlRZ_8071.m4a\r\n《修真老师生活录》355-你胆子倒是不小啊$http://audio.xmcdn.com/group21/M03/60/47/wKgJKFiX0Gjgjj2UAJr2hbOjicY487.m4a\r\n《修真老师生活录》356-看不整死你$http://audio.xmcdn.com/group22/M01/67/A5/wKgJM1iZWA-CYqxUAJwC92ShmKo190.m4a\r\n《修真老师生活录》357-解救$http://audio.xmcdn.com/group24/M00/6A/E8/wKgJMFiauD6Q8V0_AJ--uv0D4LA877.m4a\r\n《修真老师生活录》358-把杜威找来$http://audio.xmcdn.com/group25/M02/72/76/wKgJMVicc6jT7Zj0AJxmoqMjMoY817.m4a\r\n《修真老师生活录》359-故地重游$http://audio.xmcdn.com/group23/M04/77/CB/wKgJL1id0rCzooW5AJ-PvUOlKRs203.m4a\r\n《修真老师生活录》360—同学见面$http://audio.xmcdn.com/group24/M03/79/6B/wKgJMFifEJ_hDwKGAKIOgPiQQO0685.m4a\r\n《修真老师生活录》361—这事儿我包了$http://audio.xmcdn.com/group25/M09/7C/67/wKgJNlif2hjB72RTAKNF0hutnOM799.m4a\r\n《修真老师生活录》362—金丹丹主持$http://audio.xmcdn.com/group24/M02/7E/F7/wKgJNVihDAeBFTmQAJH0nZ0nOfU848.m4a\r\n《修真老师生活录》363—别开国际玩笑$http://audio.xmcdn.com/group23/M02/86/D1/wKgJL1ii1sqTUHeQAKQ4dKrFR1Q430.m4a\r\n《修真老师生活录》364—惊喜$http://audio.xmcdn.com/group21/M0B/86/E4/wKgJLVij4P6CaWwLAILV6Y9_tFM405.m4a\r\n《修真老师生活录》365—出场费$http://audio.xmcdn.com/group25/M08/8C/A2/wKgJMVilCFPjBS4wAKHvqiadBDk485.m4a\r\n《修真老师生活录》367—两朵鲜花插在牛粪上$http://audio.xmcdn.com/group25/M0B/96/10/wKgJMVin6MOBzuNrAJAY1VHA2Wc232.m4a\r\n《修真老师生活录》368—是不是搞错了？$http://audio.xmcdn.com/group23/M01/9D/12/wKgJNFipqz3yOJMMAJz1icjSCkk066.m4a\r\n《修真老师生活录》369—你小子牛逼啊！$http://audio.xmcdn.com/group23/M08/9E/60/wKgJL1iqTayDf_tDAIagc1STDMg024.m4a\r\n《修真老师生活录》370—监考$http://audio.xmcdn.com/group23/M03/A4/0F/wKgJL1ir5ffCuPD2AKeUnWAeUqE858.m4a\r\n《修真老师生活录》371—车祸$http://audio.xmcdn.com/group25/M06/A8/55/wKgJMVitTVjyuFRLAJjzBRrO1gE748.m4a\r\n《修真老师生活录》372—姐我对小正太不感兴趣$http://audio.xmcdn.com/group25/M0A/AC/F1/wKgJNliujduCp-sjAKWLUAG9x9Y534.m4a\r\n《修真老师生活录》373—放心，有张师叔在$http://audio.xmcdn.com/group22/M0B/B0/A8/wKgJM1ivjuLBHMglAJr6da7ofwk313.m4a\r\n《修真老师生活录》374—这玉怎么碎了？$http://audio.xmcdn.com/group25/M0A/B6/7F/wKgJNlixTJ_DE7WrAJveD5i85fU127.m4a\r\n《修真老师生活录》375—我不喜欢有人找到学校来$http://audio.xmcdn.com/group22/M0B/B9/A5/wKgJLliyNTqAV8qlAJmRNwuubM0152.m4a\r\n《修真老师生活录》376—千幻$http://audio.xmcdn.com/group22/M04/BE/2A/wKgJM1izjQ6QohYpAILyV8hz_l4018.m4a\r\n《修真老师生活录》377—式神$http://audio.xmcdn.com/group22/M07/C5/92/wKgJM1i1eXSDFOt6AJCNrjyJGJo399.m4a\r\n《修真老师生活录》378—血符$http://audio.xmcdn.com/group23/M05/C7/D9/wKgJNFi2JAyRhY3CAJxgaJ9BbXc954.m4a\r\n《修真老师生活录》379—武士式神$http://audio.xmcdn.com/group21/M07/C9/D6/wKgJLVi3mbSwhecYAJb_Xx89oVU062.m4a\r\n《修真老师生活录》380—收服狼王和九狐$http://audio.xmcdn.com/group22/M06/CF/22/wKgJM1i4yMDRLVN7AI1cZjp5qNA210.m4a\r\n《修真老师生活录》381—打发$http://audio.xmcdn.com/group23/M08/D3/D5/wKgJL1i6nnfiINIpAJg1NQxZKjQ958.m4a\r\n《修真老师生活录》382—旅游计划$http://audio.xmcdn.com/group25/M09/D4/5A/wKgJNli7binTTd4FAJ0Zxzl7Kis259.m4a\r\n《修真老师生活录》383—遇到熟人了$http://audio.xmcdn.com/group19/M00/B6/91/wKgJJli8vuLgV_9GAJs7EIsrQ_E459.m4a\r\n《修真老师生活录》384—年轻高人$http://audio.xmcdn.com/group24/M06/D8/B9/wKgJMFi-WnrDFIDTAKAxRHWkNOA489.m4a\r\n《修真老师生活录》385—话不投机半句多$http://audio.xmcdn.com/group25/M02/DC/88/wKgJMVi_cGqCnl9iAJRgswgdnO4333.m4a\r\n《修真老师生活录》386—欺人太甚$http://audio.xmcdn.com/group22/M06/E0/7B/wKgJM1jBOTXhVj_0AKG5_5qPgww090.m4a\r\n《修真老师生活录》387—怎么，还想动手？$http://audio.xmcdn.com/group18/M00/C0/04/wKgJKljCBu-xNIAyAJTj5cMMH_w900.m4a\r\n《修真老师生活录》388—周副局长，这是怎么回事？$http://audio.xmcdn.com/group17/M06/C4/16/wKgJJFjDX_jAzxZpAJ-aIWVbJno123.m4a\r\n《修真老师生活录》389—这里有你说话的地方吗？$http://audio.xmcdn.com/group20/M09/C5/19/wKgJLFjEsZzRV_LnAI7zJeej9hw640.m4a\r\n《修真老师生活录》390—追悔莫及$http://audio.xmcdn.com/group19/M0A/CA/64/wKgJJljF_q-g4alaAJb94-FqJG8535.m4a\r\n《修真老师生活录》391—肥水不流外人田$http://audio.xmcdn.com/group27/M08/00/6E/wKgJW1jHVjHyHpyXAKSSPijPA58058.m4a\r\n《修真老师生活录》392—约会$http://audio.xmcdn.com/group26/M00/14/10/wKgJRljJGS2xXVFSALNGwX5YDQo315.m4a\r\n《修真老师生活录》393—志宏、丽霞你们过来一下$http://audio.xmcdn.com/group26/M05/1F/21/wKgJRljKOZ6Bq_x_AI9LQJ9Gj4g024.m4a\r\n《修真老师生活录》394—就当我送给你的见面礼$http://audio.xmcdn.com/group27/M09/1D/9E/wKgJR1jKcsfST_HvAJq7Ul2k7gw166.m4a\r\n《修真老师生活录》395—你说的太晚了$http://audio.xmcdn.com/group27/M06/1D/A7/wKgJR1jKc0yCpUdcAJ1NKwhP2T8853.m4a\r\n《修真老师生活录》396—犯病$http://audio.xmcdn.com/group26/M0B/21/D2/wKgJRljKc_HjlJv6AJDJdRiNnZU412.m4a\r\n《修真老师生活录》397-求助$http://audio.xmcdn.com/group27/M07/61/19/wKgJR1jQ-5Hyu4FXAKdwDj6ftJg033.m4a\r\n《修真老师生活录》398-答应$http://audio.xmcdn.com/group27/M04/62/08/wKgJR1jRCkqwmkacAJtkLyIloFQ014.m4a\r\n《修真老师生活录》399—这是什么大学老师啊！$http://audio.xmcdn.com/group26/M0B/86/A7/wKgJWFjT1dCAGqSoAJgvUxzDs_M566.m4a\r\n《修真老师生活录》400—就想跟东哥睡一觉$http://audio.xmcdn.com/group27/M0B/8E/DC/wKgJR1jVIMuyq2gBAKROJAe6yrk693.m4a\r\n《修真老师生活录》401—药炉$http://audio.xmcdn.com/group27/M03/94/94/wKgJR1jV5u-CQVxnAJuuFrVym2E138.m4a\r\n《修真老师生活录》402—你以为还会有下次嘛？$http://audio.xmcdn.com/group26/M09/A5/00/wKgJWFjXLs-wdqbeAIrUzjt2aSk129.m4a\r\n《修真老师生活录》404—秘密武器$http://audio.xmcdn.com/group26/M02/B8/B8/wKgJWFjZDrHzr9WbAJZBS5ni-BU059.m4a\r\n《修真老师生活录》405—绝代双骄$http://audio.xmcdn.com/group27/M03/B4/B9/wKgJR1jZDwXhhN9hAJ7nKpwPx5Q182.m4a\r\n《修真老师生活录》406—他吃得消吗$http://audio.xmcdn.com/group26/M00/E4/A7/wKgJWFjdHvfySLtrAKWGS8AxZH4013.m4a\r\n《修真老师生活录》407—夜香港$http://audio.xmcdn.com/group27/M0A/EB/6F/wKgJW1jeSniiu8XDAJMXWn12ZFQ899.m4a\r\n《修真老师生活录》408—火拼$http://audio.xmcdn.com/group26/M07/F0/EC/wKgJRljeVhqgOaVbAKPLcv3hYcA159.m4a\r\n《修真老师生活录》409—过瘾$http://audio.xmcdn.com/group27/M09/00/2B/wKgJW1jgcEryEwyWAJveDxGSPuo566.m4a\r\n《修真老师生活录》410—小李飞刀$http://audio.xmcdn.com/group27/M07/0B/7D/wKgJR1jhun3AV27RAJX1ko8Lmac623.m4a\r\n《修真老师生活录》411—豁出去了$http://audio.xmcdn.com/group26/M03/14/C1/wKgJWFjiMWOzwlqvAKUiEQ1agiA709.m4a\r\n《修真老师生活录》413—财迷$http://audio.xmcdn.com/group27/M08/1B/1D/wKgJW1jjVtaizuzOAKRA7C7qdK8310.m4a\r\n《修真老师生活录》412—醒来之后$http://audio.xmcdn.com/group27/M09/1B/15/wKgJW1jjVkqDkQXoAJRRm_1LEYs847.m4a\r\n《修真老师生活录》414—豪门夜宴$http://audio.xmcdn.com/group27/M09/40/43/wKgJR1jm_LGBLmv6AI5dp0SdB6s086.m4a\r\n《修真老师生活录》415—吃醋$http://audio.xmcdn.com/group26/M03/5B/4C/wKgJRljo9UCCTxBJAIfmcNNmucM480.m4a\r\n《修真老师生活录》416—老友$http://audio.xmcdn.com/group27/M06/60/1D/wKgJW1jqAznCor1vAJ7vrhKr4Dw349.m4a\r\n《修真老师生活录》418—这比美国总统还牛啊$http://audio.xmcdn.com/group27/M00/8B/EA/wKgJW1juKZbx2ZtFAJehMUjhXtM666.m4a\r\n《修真老师生活录》417—仅仅一个电话$http://audio.xmcdn.com/group26/M0A/99/F5/wKgJWFjvR-XAa5h8AJ_A0SNQXIw434.m4a\r\n《修真老师生活录》419—受辱$http://audio.xmcdn.com/group26/M01/99/F8/wKgJWFjvSBuj_K-sAKmZ6z_psmg492.m4a\r\n《修真老师生活录》420—闭嘴，这里没你说话的地方$http://audio.xmcdn.com/group26/M00/A8/FB/wKgJWFjwxMnxb2umAJh-2SmvVLI956.m4a\r\n《修真老师生活录》421—好大的口气$http://audio.xmcdn.com/group26/M0A/A9/25/wKgJRljwx9LiNvLmAJ-bfQi1qig961.m4a\r\n《修真老师生活录》422—你要小心啊$http://audio.xmcdn.com/group27/M06/AC/BA/wKgJW1jx0pejbHgGAKQJHm8I4RY411.m4a\r\n《修真老师生活录》423—马上就干$http://audio.xmcdn.com/group27/M02/AD/05/wKgJR1jx2qejv5nIAJ5l2OmtJCM756.m4a\r\n《修真老师生活录》424—那人是神仙$http://audio.xmcdn.com/group26/M06/BD/9A/wKgJRljzKfvyb4ugAJpGqoPPUhE541.m4a\r\n《修真老师生活录》425—彻底吓坏了$http://audio.xmcdn.com/group27/M0A/1A/09/wKgJR1j6wbfxjZD_AKdy1KazKno303.m4a\r\n《修真老师生活录》426—你会不会飞？$http://audio.xmcdn.com/group27/M07/1E/56/wKgJW1j7DROD7zqaAJGyh5YqhfQ959.m4a\r\n《修真老师生活录》427—游艇、豪宅$http://audio.xmcdn.com/group27/M0B/A5/D3/wKgJW1kEiXqDE4NQAH9fttCg3GM417.m4a\r\n《修真老师生活录》428—表哥$http://audio.xmcdn.com/group27/M0B/A6/57/wKgJW1kEkCHSkB42AJHkzFMiPYw659.m4a\r\n《修真老师生活录》429—二舅舅的窘境$http://audio.xmcdn.com/group27/M02/B4/F7/wKgJW1kF20KQ7m7AAJHN0dFp4Fg233.m4a\r\n《修真老师生活录》430—舅舅的职务$http://audio.xmcdn.com/group26/M09/B9/D2/wKgJWFkF4dHwPP8fAI19QrCzweY887.m4a\r\n《修真老师生活录》431—稀土矿$http://audio.xmcdn.com/group26/M03/C7/18/wKgJWFkHB9jhb_kwAJRLK8EUexg460.m4a\r\n《修真老师生活录》432—怎么郑书记你害怕了$http://audio.xmcdn.com/group26/M05/DE/EB/wKgJWFkImzOh_-RhAI2cT6saTQY964.m4a\r\n《修真老师生活录》433—认怂了？$http://audio.xmcdn.com/group27/M0B/5C/1D/wKgJR1kRzADz8QUaAJWF-gV6jNw092.m4a\r\n《修真老师生活录》434—唐兴邦$http://audio.xmcdn.com/group26/M06/74/BC/wKgJWFkTMHayf4NlAJ8kjKJFjA4434.m4a\r\n《修真老师生活录》435—震怒$http://audio.xmcdn.com/group27/M04/80/46/wKgJR1kUYsODPhctAJPGGaSJt3U985.m4a\r\n《修真老师生活录》436—这可怎么办？$http://audio.xmcdn.com/group26/M04/94/1B/wKgJRlkVpX2xtIlcAIQKMNSMT7E422.m4a\r\n《修真老师生活录》437—水落石出$http://audio.xmcdn.com/group26/M00/A7/60/wKgJWFkXBZ3jz7l2AJ2Zin51Zow941.m4a\r\n《修真老师生活录》438—新的学年$http://audio.xmcdn.com/group27/M06/B3/BF/wKgJW1kYRDjw86tZAJZfT5gahXo603.m4a\r\n《修真老师生活录》439—漂移$http://audio.xmcdn.com/group26/M01/DF/9F/wKgJRlkbFqPhTXffAJ0jJoDySQ4394.m4a\r\n《修真老师生活录》440—谭永谦秘书长$http://audio.xmcdn.com/group29/M04/44/67/wKgJXVkeTsSR3BYBAKK0clYA3uM721.m4a\r\n《修真老师生活录》398-答应$http://audio.xmcdn.com/group29/M09/D8/C7/wKgJXVklaLXh8bBCAJtkL8eLqrM233.m4a\r\n《修真老师生活录》441—再吹唐人$http://audio.xmcdn.com/group29/M02/FB/C0/wKgJXVkmRUTyN4_HAJfR6HxbaPQ032.m4a\r\n《修真老师生活录》437—shuioluo$http://audio.xmcdn.com/group28/M09/7D/84/wKgJSFkpA3CDOvcbAE_IxckIzJo823.m4a\r\n《修真老师生活录》442—猴急$http://audio.xmcdn.com/group28/M04/1F/99/wKgJSFkwIp2wfGDKAI8N80aoPAs800.m4a\r\n《修真老师生活录》443—突发情况$http://audio.xmcdn.com/group29/M05/1D/D3/wKgJWVkwKF_hLfOAAKIP-EpLZa8039.m4a\r\n《修真老师生活录》444—秦虹教授$http://audio.xmcdn.com/group28/M09/34/46/wKgJXFkxZCaR7VLXAKalPwBrBhs723.m4a\r\n《修真老师生活录》445—大结局（1）$http://audio.xmcdn.com/group28/M09/46/0E/wKgJSFkygzexujoMAKHBK4bNmak667.m4a\r\n《修真老师生活录》446—大结局（2）$http://audio.xmcdn.com/group28/M08/49/C3/wKgJSFkys13hSS0MACnR2Fg7d0U306.m4a', 'xml_8023', '7535', '', 'X', '', '1.0', 8, 0, 0, 0, 'xiuzhenlaoshishenghuolu', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(63, 23, '去说三国', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group27/M09/E6/A4/wKgJR1kJo3CjvVU6AAFIHJlxJaI404.jpg', '', 1530072143, 3, 0, 0, 0, 0, 1, 1, 7, 5, 'ting', '', '去说三国09千里走单骑$http://audio.xmcdn.com/group29/M09/83/86/wKgJWVk2i2azrhzzANV9mdQ9Q-o908.m4a\r\n三锅08煮酒论英雄$http://audio.xmcdn.com/group27/M09/43/5E/wKgJR1kQPlegisfTANuQov285Ew166.m4a\r\n三锅07白门楼$http://audio.xmcdn.com/group26/M06/45/B6/wKgJWFkQIhvA4IM2ALc0vH5NWsQ862.m4a\r\n三锅06李郭交战$http://audio.xmcdn.com/group27/M02/18/AB/wKgJW1kNNGOi_A8UAL79SzDU6Ek376.m4a\r\n三锅05犯长安$http://audio.xmcdn.com/group26/M03/11/BB/wKgJRlkMYmqxpXacAL__REVUDkA665.m4a\r\n三锅04凤仪亭$http://audio.xmcdn.com/group27/M05/07/4C/wKgJW1kL412zYgcDAKkzCLF339c652.m4a\r\n三锅03虎牢关$http://audio.xmcdn.com/group27/M03/FC/7C/wKgJW1kLFtOwpdzqANTd5lz-At0193.m4a\r\n三锅02进京$http://audio.xmcdn.com/group26/M09/EC/A9/wKgJRlkJwX7SXSL0AObGo80jGpQ215.m4a\r\n三锅01结拜$http://audio.xmcdn.com/group26/M04/EA/F5/wKgJWFkJomOTDJpZAIpzXGcoS_A075.m4a', 'xml_8023', '7534', '', 'Q', '', '1.0', 10, 0, 0, 0, 'qushuosanguo', ''),
(64, 23, '少年游——原创有声小说', '', '未知', '', '', '', '遥见鹤云山，高耸入云间。 看现世失意少年独闯异世界，如何夺得自己的方寸之地…… 作者：panDK （微博@panDKnight） CV ：银之契约者（微博@银之契约者Black）', 'http://imagev2.xmcdn.com/group20/M09/16/C6/wKgJJ1ff16rQgK6mAATrxt5QARY255.png', '', 1530072143, 8, 0, 0, 0, 0, 1, 1, 6, 1, 'ting', '', '少年游 第十三章$http://audio.xmcdn.com/group26/M07/61/7A/wKgJWFkR14mABFYyAEyik1kPh38934.m4a\r\n少年游 第十二章$http://audio.xmcdn.com/group26/M0A/8A/00/wKgJRljtrirgFdTJAE6aProiSbM777.m4a\r\n少年游 第十一章$http://audio.xmcdn.com/group27/M03/85/75/wKgJR1jtreTiDY9ZAFU8wuTldqI717.m4a\r\n少年游 第十章$http://audio.xmcdn.com/group21/M0B/E4/A5/wKgJKFjEGkKB4yb4AE7a3U1Tp4k869.m4a\r\n少年游 第九章$http://audio.xmcdn.com/group17/M01/C5/00/wKgJJFjDtbuQwn28AFvknHQCNFc911.m4a\r\n少年游 第八章$http://audio.xmcdn.com/group22/M0A/E5/D5/wKgJLljDtY7SyRXjAFM_Y-hhM_0877.m4a\r\n少年游 第七章$http://audio.xmcdn.com/group22/M08/E5/D5/wKgJLljDtWzgT0VQAFE07A5SUAI569.m4a\r\n少年游 第六章$http://audio.xmcdn.com/group20/M01/C2/FD/wKgJLFjDtULTO11kAFVCS65oPWw090.m4a\r\n少年游 第五章$http://audio.xmcdn.com/group20/M01/C2/FA/wKgJLFjDtR2yW92PAEu0sVsgFYo969.m4a\r\n少年游 第四章$http://audio.xmcdn.com/group17/M09/4C/F1/wKgJJFfw_j_RhL2MAFj2Pj-c7TU776.m4a\r\n少年游 第三章$http://audio.xmcdn.com/group17/M08/3E/E9/wKgJJFfr1MXCIKq2AETD4yYkz64494.m4a\r\n少年游 第二章 $http://audio.xmcdn.com/group17/M05/16/D8/wKgJKVff236DBs0jAE815-LnlDQ574.m4a\r\n少年游 第一章$http://audio.xmcdn.com/group20/M04/16/D4/wKgJJ1ff2YnASvoBAF09s6qmeFw400.m4a', 'xml_8023', '7533', '', '0', '', '1.0', 4, 0, 0, 0, 'shaonianyouyuanchuangyoushengxiaoshuo', ''),
(65, 23, '碧血洗银枪-古龙作品', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group28/M03/84/92/wKgJSFkpSamg-qfpAAFIn41BPb4166.jpg', '', 1530072143, 9, 0, 0, 0, 0, 1, 1, 10, 9, 'ting', '', '前言$http://audio.xmcdn.com/group28/M01/85/8D/wKgJXFkpSaXzjhEPABRdkmwsJHI496.m4a\r\n第一章 四公子（上）$http://audio.xmcdn.com/group28/M0B/AC/60/wKgJXFkq1e7QTkvtAHr1DDOUJ_0440.m4a\r\n第一章 四公子(下)$http://audio.xmcdn.com/group29/M09/6B/53/wKgJWVk1G9bSA8bPAEC75z-qrGs898.m4a', 'xml_8023', '7532', '', 'B', '', '1.0', 7, 0, 0, 0, 'bixuexiyinqianggulongzuopin', ''),
(66, 23, '黄庭仙道——作者：归卧故山[求订阅]', '', '未知', '', '', '', '黄庭存思，道德无为，楞严五蕴，华严十地，诸行无常，诸法无我，寂静涅槃，正觉智慧……这是一杀手修行的故事，是一个求法证道的故事……（求订阅，求关注）', 'http://imagev2.xmcdn.com/group29/M07/AA/7E/wKgJWVk47mHgO3YeAAASB-OHTBg986.jpg', '', 1530072143, 5, 0, 0, 0, 0, 1, 1, 6, 3, 'ting', '', '1风波起，禅杖依天脱红尘$http://audio.xmcdn.com/group28/M00/AE/4A/wKgJXFk47nnQDNTuAGW1nEvRWuU468.m4a\r\n简介$http://audio.xmcdn.com/group29/M07/AA/14/wKgJXVk47mbziqIAAANJst4Nps4287.m4a\r\n2（这本书真心太难读了）$http://audio.xmcdn.com/group29/M01/BF/4A/wKgJXVk6TUuw53S8AFGOf2D1VhI152.m4a', 'xml_8023', '7531', '', '0', '', '1.0', 4, 0, 0, 0, 'huangtingxiandaozuozheguiwogushanqiudingyue', ''),
(49, 23, '夜雨打金荷', '', '未知', '', '', '', '十载披澜唱楚些长河南北天断绝不信此心犹梗梗请看天日昭如揭回眸顾久离别缇骑宁有是非耶满怀冰玉一杯酒猛忆初雪旧年节', 'http://imagev2.xmcdn.com/group27/M0B/E9/2C/wKgJW1jeKOXwk2kAAAGlc0Ri0JU128.jpg', '', 1530072142, 7, 0, 0, 0, 0, 1, 1, 5, 4, 'ting', '', '夜雨打金荷 一$http://audio.xmcdn.com/group26/M03/ED/70/wKgJRljeKX3RKyOrAJ8kjFJRyEg961.m4a\r\n避祸 一$http://audio.xmcdn.com/group27/M0A/E9/40/wKgJR1jeKpqz9EM2ATCnyTCrzaQ066.m4a\r\n避祸 二$http://audio.xmcdn.com/group27/M05/E9/47/wKgJR1jeKw2iDgx1AOIMXTRi_BY761.m4a\r\n短刀 一$http://audio.xmcdn.com/group27/M05/E9/4F/wKgJR1jeK7fRLW6WAOJrzomc0Sg964.m4a\r\n短刀 二$http://audio.xmcdn.com/group27/M08/E9/56/wKgJR1jeLDXgsNxiANl9dkY7Anc461.m4a\r\n雨驿 一$http://audio.xmcdn.com/group26/M04/ED/A0/wKgJWFjeLL2C4rDMANhARqiLKFU979.m4a\r\n雨驿 二$http://audio.xmcdn.com/group27/M0B/25/D3/wKgJR1jkdDvz_bbGAUwHK3GCWNI019.m4a\r\n雨驿 三$http://audio.xmcdn.com/group27/M01/28/AD/wKgJR1jkteCQ-2ShAO5o1eBrskY936.m4a\r\n金荷 一$http://audio.xmcdn.com/group26/M04/A0/15/wKgJRlkWnEqxJAAdALLJ7tZTC7U463.m4a\r\n金荷 二$http://audio.xmcdn.com/group27/M0A/9D/3C/wKgJW1kWnPaiEFVkAJ4AVJE7CUM791.m4a\r\n金荷 三 $http://audio.xmcdn.com/group26/M05/A0/25/wKgJRlkWnVvQH6frAN6IOBS0X9w955.m4a\r\n镖银 一$http://audio.xmcdn.com/group27/M06/9D/48/wKgJW1kWnabw1LuHAMU69ObMCC4850.m4a', 'xml_8023', '7547', '', 'Y', '', '1.0', 9, 0, 0, 0, 'yeyudajinhe', ''),
(50, 23, '杨家将', '', '未知', '', '', '', '', 'http://s1.xmcdn.com/css/img/common/album_180.jpg', '', 1530072142, 2, 0, 0, 0, 0, 1, 1, 4, 10, 'ting', '', '杨家将$http://audio.xmcdn.com/group29/M00/56/BF/wKgJXVke7ozQWg-yAKNKORaxq78756.m4a', 'xml_8023', '7546', '', 'Y', '', '1.0', 8, 0, 0, 0, 'yangjiajiang', ''),
(51, 23, '龙凤宝钗缘[精装版]', '', '未知', '', '', '', '微信 wozhetianxia (敲门暗号：喜马拉雅听友）一对龙凤玉钗，结下一世姻缘。继《大唐游侠传》之后，方程君再度倾情演绎梁羽生先生大唐系列之《龙凤宝钗缘》，求心软打赏！小李飞刀系列1《多情剑客无情剑》因被下架，听众》因被下架，听众可添加微信公众号“慧听经典“ 订阅全集。', 'http://imagev2.xmcdn.com/group24/M04/77/EE/wKgJNVh3JwSTXt8UAAHfN2K5gGU503.jpg', '', 1530072142, 4, 0, 0, 0, 0, 1, 1, 7, 9, 'ting', '', '梁羽生经典武侠小说龙凤宝钗缘001（求赞助订阅）$http://audio.xmcdn.com/group24/M0B/9A/8F/wKgJMFh8Z4XhBefrAIO65vb83kM663.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘002（求赞助订阅）$http://audio.xmcdn.com/group23/M08/9A/A9/wKgJNFh8aGOA6yy4AH648Tx_dmY475.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘003（求赞助订阅）$http://audio.xmcdn.com/group21/M00/99/87/wKgJLVh8aJOzPrB2AH-ZoPH5k_w836.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘004（求赞助订阅）$http://audio.xmcdn.com/group24/M09/9A/D4/wKgJNVh8aMqQOA04AIPyr4pxMhM682.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘005（求赞助订阅）$http://audio.xmcdn.com/group22/M04/9A/59/wKgJM1h8aRTxvWMMAHxC_LCHRNI388.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘006（求赞助订阅）$http://audio.xmcdn.com/group21/M02/99/D7/wKgJKFh8aWrDlIACAIRH2x8fRoU420.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘007（求赞助订阅）$http://audio.xmcdn.com/group25/M05/9A/D0/wKgJNlh8aa-iQGdyAIRH2wc9-hU226.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘008（求赞助订阅）$http://audio.xmcdn.com/group23/M0B/9B/08/wKgJL1h8adjgr36QAH3p5bKuR3M924.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘009（求赞助订阅）$http://audio.xmcdn.com/group21/M04/F0/DF/wKgJKFiHIBiRmj2VAIDLDBtbFJg744.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘010（求赞助订阅）$http://audio.xmcdn.com/group24/M00/F1/9B/wKgJNViHIGCgnr8mAIH1JuxcZEU593.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘011（求赞助订阅）$http://audio.xmcdn.com/group25/M02/F1/84/wKgJNliHINSSqbYIAID3Geo9P2A792.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘012（求赞助订阅）$http://audio.xmcdn.com/group25/M03/11/10/wKgJMViLXufDnthsAHyicAO4WY0921.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘013（求赞助订阅）$http://audio.xmcdn.com/group23/M0A/11/77/wKgJNFiLX5OhdQKjAIOqv0WiiZs013.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘014（求赞助订阅）$http://audio.xmcdn.com/group25/M04/11/2A/wKgJNliLX8Wzc-PRAIdKyyBlx3E483.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘015（求赞助订阅）$http://audio.xmcdn.com/group23/M02/11/79/wKgJNFiLX--hcgV9AIgOFx2kzac380.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘016（求赞助订阅）$http://audio.xmcdn.com/group22/M07/39/FF/wKgJM1iRSVGjTm1eAIjnbALbZyQ156.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘017（求赞助订阅）$http://audio.xmcdn.com/group22/M0B/3B/2B/wKgJM1iRbBWz_zhoAIf5ioL3GZ0077.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘018（求赞助订阅）$http://audio.xmcdn.com/group25/M07/3B/32/wKgJMViRbFqwHjGiAI0Ucsd2sDs193.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘019（求赞助订阅）$http://audio.xmcdn.com/group22/M00/50/E4/wKgJM1iULqqzPz-uAJiTL2DBiU4854.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘020（求赞助订阅）$http://audio.xmcdn.com/group25/M0B/50/AF/wKgJNliULueSnsYhAISP0D-Z0NE147.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘021（求赞助订阅）$http://audio.xmcdn.com/group23/M05/50/FC/wKgJNFiULynjh9leAIzLBqDn4dA479.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘022（求赞助订阅）$http://audio.xmcdn.com/group22/M02/62/70/wKgJM1iXz_CSXGouAH9vCr6aq8Q030.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘023（求赞助订阅）$http://audio.xmcdn.com/group24/M05/61/15/wKgJMFiX0C7ReJJPAIAjpzEsQy0370.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘024（求赞助订阅）$http://audio.xmcdn.com/group21/M08/60/28/wKgJLViX0LSjppH5AIx7uOuyKCg573.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘025（求赞助订阅）$http://audio.xmcdn.com/group21/M08/60/28/wKgJLViX0Lvhu3BgAIcniy5mkkg790.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘026$http://audio.xmcdn.com/group21/M08/60/2B/wKgJLViX0N2hc27lAIqSvFEjars889.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘027$http://audio.xmcdn.com/group23/M08/62/D7/wKgJL1iX0RqBib6-AIoQCzUKwZM856.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘028$http://audio.xmcdn.com/group22/M0B/7D/23/wKgJM1if__rQq9oFAIOO2Ot-7U8351.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘029（求赞助订阅）$http://audio.xmcdn.com/group25/M02/7C/F9/wKgJMVigAEfytx2cAJRjOlIsfM0096.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘030$http://audio.xmcdn.com/group22/M02/7D/61/wKgJLligAHihCDNtAIxZ8yFY2Kc549.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘031$http://audio.xmcdn.com/group25/M06/7C/F7/wKgJNligAKahw9HZAH675J6MOMc429.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘032$http://audio.xmcdn.com/group22/M07/91/53/wKgJM1imZeGBzkqyAIdybqFb5T8495.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘033$http://audio.xmcdn.com/group21/M09/92/DD/wKgJKFinommRHfnjAJNAefsNZpU717.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘034$http://audio.xmcdn.com/group23/M07/95/A7/wKgJNFinoriRUsTYAIJe4IFlSMY735.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘035$http://audio.xmcdn.com/group25/M03/95/01/wKgJNlinovHDXNt_AI1z4_6g0IE634.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘036$http://audio.xmcdn.com/group22/M08/95/2C/wKgJM1inoyPBen8oAIwzxPMNIOI129.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘037$http://audio.xmcdn.com/group24/M00/93/F3/wKgJNVino0GA5YEXAI1jvPXHm6g645.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘038$http://audio.xmcdn.com/group25/M00/95/04/wKgJNlino3uhVS1yAJCtJYBca58882.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘039$http://audio.xmcdn.com/group24/M00/A6/25/wKgJMFitH6mSROWjAIjM_bWksmY842.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘040$http://audio.xmcdn.com/group25/M09/B3/85/wKgJNliwNp-xlayQAIm_Sees_dM767.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘041$http://audio.xmcdn.com/group21/M00/B1/2D/wKgJKFiwNv-xr0dIAIBXDgGFC_I205.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘042$http://audio.xmcdn.com/group21/M06/B1/70/wKgJKFiwP-aTvgq3AI1sjdmgbf0027.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘043$http://audio.xmcdn.com/group22/M07/B3/FF/wKgJLliwQBvB12-BAInJjvk7gO8220.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘044$http://audio.xmcdn.com/group21/M03/C4/85/wKgJKFi2JFODXbe5AJDL-0PvVGI187.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘045$http://audio.xmcdn.com/group21/M06/C4/A1/wKgJLVi2JM2ixfLVAHzgHBY3I5M491.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘046$http://audio.xmcdn.com/group22/M03/C7/39/wKgJM1i2JQWglBt6AIW7YqeOgGY291.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘047$http://audio.xmcdn.com/group23/M07/C8/1E/wKgJL1i2JTahYtpkAH1eZ89y-X4960.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘048$http://audio.xmcdn.com/group21/M07/C4/A2/wKgJLVi2JXvgDRzxAHrPeYzO3eY507.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘049$http://audio.xmcdn.com/group22/M05/C7/71/wKgJLli2JbzC9tolAIIZ2ovWv60088.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘050$http://audio.xmcdn.com/group24/M03/C5/7E/wKgJMFi2JivB_KHQAH4b1aApRug194.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘051$http://audio.xmcdn.com/group24/M09/C5/7F/wKgJMFi2Jk3yj9t_AINZ-aMXhd8348.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘052$http://audio.xmcdn.com/group25/M03/CF/29/wKgJNli42MWDPT9CAHyQ0t8zT6g744.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘053$http://audio.xmcdn.com/group23/M03/CF/DE/wKgJNFi42RjBDrW0AIdB-gH-O-g364.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘054$http://audio.xmcdn.com/group17/M0B/AE/A6/wKgJJFi42U_DNKRqAII9G-fxOuo589.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘055$http://audio.xmcdn.com/group20/M04/AC/BA/wKgJLFi42aOhpn2CAI2M23LHkTE414.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘056$http://audio.xmcdn.com/group21/M06/CC/AA/wKgJLVi42dKzmUBjAIUJsDyYBQM054.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘057$http://audio.xmcdn.com/group18/M05/AD/E0/wKgJJVi42gKwlZ84AIR22EuXgsA703.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘058$http://audio.xmcdn.com/group24/M07/DA/DD/wKgJMFi_YjygroS6AIWj4oVYCBs408.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘059$http://audio.xmcdn.com/group23/M05/DD/82/wKgJNFi_YniwUCYhAH9nsBfOog8501.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘060$http://audio.xmcdn.com/group20/M04/BB/EE/wKgJJ1i_YqCiA_w6AIb1n1BppqQ969.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘061$http://audio.xmcdn.com/group17/M09/BC/1C/wKgJJFi_YtrAvl6RAHzYxm8vhcI187.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘062$http://audio.xmcdn.com/group25/M04/E2/BA/wKgJNljCEvzjWS6ZAIF8vuTH8yk489.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘063$http://audio.xmcdn.com/group19/M03/C1/8E/wKgJK1jCE1mB3cmwAIrO8BXqNhY244.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘064$http://audio.xmcdn.com/group17/M05/C1/BA/wKgJKVjCE3zhm5f4AIjLhdNE0o0634.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘065$http://audio.xmcdn.com/group17/M01/C1/BA/wKgJKVjCE6aznqozAIrdoFJSO6Q778.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘066$http://audio.xmcdn.com/group21/M02/DF/A5/wKgJLVjCE-aAaLk0AHyWsGXFrE0749.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘067$http://audio.xmcdn.com/group24/M02/E0/18/wKgJMFjCFECTHCdyAJKwkNKBk7o607.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘068$http://audio.xmcdn.com/group25/M03/E2/C2/wKgJNljCFG7hpaQGAIVRpE4cUus204.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘069$http://audio.xmcdn.com/group20/M0B/C1/25/wKgJJ1jCFJmAvYxmAIQHQdwH6RA038.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘070$http://audio.xmcdn.com/group20/M0B/BF/7B/wKgJLFjCFLuAaVYnAIrwtVD80nM676.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘071$http://audio.xmcdn.com/group22/M02/E2/1C/wKgJM1jCFOjDZaIAAIp-LyGFzkU347.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘072$http://audio.xmcdn.com/group26/M06/00/8A/wKgJWFjHWZrz76IxAHmTxDjWulg189.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘073$http://audio.xmcdn.com/group27/M04/00/7E/wKgJR1jHWc-TdlBqAIFrG3Ty0kw185.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘074$http://audio.xmcdn.com/group27/M01/00/81/wKgJR1jHWh_iIkKFAIRVE0WWToY970.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘075$http://audio.xmcdn.com/group27/M01/00/92/wKgJW1jHWjrQRWclAIQgOFY0k7Y922.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘076$http://audio.xmcdn.com/group27/M02/1B/59/wKgJW1jKQNrgrpfwAIhgVLXFBuc772.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘077$http://audio.xmcdn.com/group27/M01/1B/5C/wKgJW1jKQTbSSkQdAHmCIhn-uR0745.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘078$http://audio.xmcdn.com/group26/M09/1F/72/wKgJRljKQWexMgQxAISdCLDfNFE822.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘079$http://audio.xmcdn.com/group26/M09/1F/77/wKgJWFjKQZaie8VLAIYcSkszlEs453.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘080$http://audio.xmcdn.com/group27/M0A/1B/4D/wKgJR1jKQd6hohkYAI2LY5XmLS4039.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘081$http://audio.xmcdn.com/group26/M09/40/E6/wKgJWFjNXofTnaCUAIk7IXEmjM4262.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘082$http://audio.xmcdn.com/group27/M0B/1B/66/wKgJW1jKQkCiatGMAIllsxbbCHA851.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘083$http://audio.xmcdn.com/group26/M0B/40/E9/wKgJWFjNXtuhEhpOAH5E70cUqgo850.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘084$http://audio.xmcdn.com/group26/M00/1F/81/wKgJRljKQunxbiKXAH8Vd1dHPe4930.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘085$http://audio.xmcdn.com/group26/M05/40/D0/wKgJRljNXyDxgy9GAIoS-jJNQTw923.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘086$http://audio.xmcdn.com/group26/M04/63/77/wKgJRljQ1fTxmORqAIHglXX5goY914.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘087$http://audio.xmcdn.com/group27/M04/5F/26/wKgJW1jQ1mCSdVV0AIOHfgoqMjU363.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘088$http://audio.xmcdn.com/group26/M02/63/82/wKgJRljQ1tqS3WrmAIRB_bIJLEY399.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘089$http://audio.xmcdn.com/group26/M02/63/82/wKgJRljQ1t6iR6fFAJSxDFHM6Xw290.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘090$http://audio.xmcdn.com/group27/M0B/5F/4D/wKgJR1jQ1xiwSDCmAIamVac9t38873.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘091$http://audio.xmcdn.com/group27/M09/5F/33/wKgJW1jQ10DQ-t6gAIi4b9VPYbg656.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘092$http://audio.xmcdn.com/group26/M06/63/8C/wKgJRljQ15jhJ6nVAH4u6vWd0l0597.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘093$http://audio.xmcdn.com/group26/M06/63/8C/wKgJRljQ152Slc64AHxHZozvYIc407.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘094$http://audio.xmcdn.com/group26/M0A/63/8F/wKgJRljQ1-DTSwgZAIZPsSjbf78508.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘095$http://audio.xmcdn.com/group26/M01/63/90/wKgJRljQ2A_AhFDKAH05rytvfG0447.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘096$http://audio.xmcdn.com/group26/M09/AE/A2/wKgJRljX2ROwowTDAHyoTmqI6Zo901.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘097$http://audio.xmcdn.com/group26/M05/AE/AB/wKgJRljX2cOBCuqVAH4EVE0iY-w729.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘098$http://audio.xmcdn.com/group26/M05/BD/B1/wKgJRljZsc3BlMTgAHoGS2d34KQ064.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘099$http://audio.xmcdn.com/group26/M06/BD/B3/wKgJRljZsgix34wgAHnzNXox_eI769.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘100（求赞助订阅）$http://audio.xmcdn.com/group26/M07/BD/A8/wKgJWFjZsjXB0qu-AID6DCCk7NI465.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘101$http://audio.xmcdn.com/group26/M0A/BD/B6/wKgJRljZsnqCrjy-AHW9YstJg_c163.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘102$http://audio.xmcdn.com/group27/M08/B9/7C/wKgJW1jZspuiiODrAIG6aWr6a60897.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘103$http://audio.xmcdn.com/group27/M09/B9/7D/wKgJW1jZstDj4W3cAHgx4N4d5E4594.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘104$http://audio.xmcdn.com/group27/M04/B9/B2/wKgJR1jZtPKxZXt9AH0ZYfXJIa8857.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘105$http://audio.xmcdn.com/group26/M06/BD/C1/wKgJWFjZtTSTFXbrAHESEZdwycE612.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘106$http://audio.xmcdn.com/group26/M0A/F7/53/wKgJWFjfFj-AVygUAHKYrinpJy4739.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘107$http://audio.xmcdn.com/group26/M02/F7/51/wKgJRljfFn_jUSOUAH4FzMHh-Ag221.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘108$http://audio.xmcdn.com/group27/M03/F3/11/wKgJR1jfFqujYPmVAHsBacT6E_4474.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘109$http://audio.xmcdn.com/group26/M04/F7/5B/wKgJWFjfFvjC9W4SAILhkdz-yIU862.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘110$http://audio.xmcdn.com/group27/M07/F3/7E/wKgJW1jfH06z-8ydAHrbOd8Q97s822.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘111$http://audio.xmcdn.com/group27/M0B/F3/88/wKgJW1jfID6QwQyNAHbRdN3zuXo527.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘112$http://audio.xmcdn.com/group26/M04/F7/BA/wKgJRljfIFyTuNdKAHuOX1YUhTI383.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘113$http://audio.xmcdn.com/group26/M04/F7/BC/wKgJRljfIITg_wbbAHmTxP5ykas961.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘114$http://audio.xmcdn.com/group27/M0A/F3/7F/wKgJR1jfILWwu5ExAH2tscklXTM134.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘115$http://audio.xmcdn.com/group26/M03/F7/CC/wKgJWFjfIRmQgEkkAHdtGU3H9_w937.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘116$http://audio.xmcdn.com/group27/M07/26/95/wKgJW1jkgbCyPxQwAHrbOS2vyHA318.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘117$http://audio.xmcdn.com/group27/M02/26/70/wKgJR1jkgijQtkqCAHnjD_uepd8350.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘118$http://audio.xmcdn.com/group27/M02/26/9A/wKgJW1jkgk7yRPPMAHwlnU7rRf4237.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘119$http://audio.xmcdn.com/group27/M06/26/9C/wKgJW1jkgpXDkNKaAH6nU6tf6aU639.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘120$http://audio.xmcdn.com/group26/M0A/2A/D3/wKgJRljkgrvDCy4BAHzKF3_SMeg960.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘121$http://audio.xmcdn.com/group26/M01/2A/D5/wKgJRljkguPB6CcyAHo1TBH4THU977.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘122$http://audio.xmcdn.com/group27/M09/26/78/wKgJR1jkgxHB3sn8AHfSbKO8Ts8104.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘123$http://audio.xmcdn.com/group27/M0A/26/A5/wKgJW1jkg0PwtNDMAICyGAevW6I094.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘124$http://audio.xmcdn.com/group27/M03/26/7C/wKgJR1jkg4DhXyIhAHhfZZPDqzs758.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘125$http://audio.xmcdn.com/group26/M09/2A/DC/wKgJWFjkg5mxnWbtAH7Xx5uFyI4001.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘126$http://audio.xmcdn.com/group27/M01/76/6F/wKgJR1jsOOfSSKUQAHGsQxa77rk847.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘127$http://audio.xmcdn.com/group26/M00/7B/07/wKgJWFjsORnRmercAHvvS1AuD0k599.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘128$http://audio.xmcdn.com/group26/M02/7B/09/wKgJWFjsOVSSpAroAHyQ0ofnm3s755.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘129$http://audio.xmcdn.com/group27/M08/76/76/wKgJR1jsOXaBvn2IAH-83AaoBn4760.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘130$http://audio.xmcdn.com/group26/M05/7B/0F/wKgJRljsOa_xf8PhAH1XDb2N3Nw249.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘131$http://audio.xmcdn.com/group27/M02/76/8A/wKgJW1jsOeyB9oQGAHXmgdY_C8k048.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘132$http://audio.xmcdn.com/group27/M05/76/7D/wKgJR1jsOhODW44NAHhQtlt7Xpc128.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘133$http://audio.xmcdn.com/group26/M04/7B/13/wKgJRljsOjbA17L6AHTrY_Mfjr8264.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘134$http://audio.xmcdn.com/group26/M07/7B/18/wKgJRljsOm3wWb-MAILP847-O0U077.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘135$http://audio.xmcdn.com/group26/M0B/7B/16/wKgJWFjsOoDTEnjFAH1xfNsQBl4919.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘136$http://audio.xmcdn.com/group27/M08/B5/C4/wKgJR1jy3KHBjt4xAHjGMKD7PHg003.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘137$http://audio.xmcdn.com/group26/M03/BA/58/wKgJRljy3T6yP2VVAHIIxSLiMqM529.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘138$http://audio.xmcdn.com/group26/M07/BB/F6/wKgJRljzAoOzGLYvAHesPCKAWUE206.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘139$http://audio.xmcdn.com/group27/M07/B7/6E/wKgJR1jzAr6TKCiOAHUgQhCbRpM672.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘140$http://audio.xmcdn.com/group26/M09/BC/0D/wKgJWFjzAuugQ5tQAHjXzjruvD4537.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘141$http://audio.xmcdn.com/group26/M09/BB/FB/wKgJRljzAxLCPRI6AHTCSKBE88w282.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘142$http://audio.xmcdn.com/group27/M00/B7/71/wKgJR1jzA0OBrRDOAH2RynzqzqE805.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘143$http://audio.xmcdn.com/group26/M04/BC/14/wKgJWFjzA2nyjMSGAHGEnKBs8D0440.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘144$http://audio.xmcdn.com/group27/M09/B7/75/wKgJR1jzA7rDTMBIAHhg3XvHMnI325.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘145$http://audio.xmcdn.com/group27/M09/B7/76/wKgJR1jzA8iAfpAgAHrocfMeBWM411.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘146$http://audio.xmcdn.com/group27/M03/B7/7E/wKgJW1jzBAnDkCRXAHaclaj21rM542.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘147$http://audio.xmcdn.com/group27/M03/B7/7B/wKgJR1jzBDOgn-I0AHb2KM-RRxs115.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘148$http://audio.xmcdn.com/group26/M0A/1E/09/wKgJRlj6xQjQBI3UAHJQuS5BDFU238.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘149$http://audio.xmcdn.com/group26/M0B/1E/57/wKgJWFj6xTbzEV3QAHNpMT6H5Qk598.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘150$http://audio.xmcdn.com/group26/M02/1E/C0/wKgJRlj60JHgMMXaAHU5OQ9nNo0895.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘151$http://audio.xmcdn.com/group26/M05/1E/C4/wKgJRlj60MyCEQ4eAHciNQPTFic616.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘152$http://audio.xmcdn.com/group26/M0A/3E/5B/wKgJRlj8wInjKKZnAHkc06lNHxA956.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘153$http://audio.xmcdn.com/group27/M0B/3A/CC/wKgJR1j8wMfzeKvoAHr4mLQ6bgg810.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘154$http://audio.xmcdn.com/group26/M09/3E/62/wKgJRlj8wO3QtULwAHg5NlWUNkk934.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘155$http://audio.xmcdn.com/group27/M01/3A/B8/wKgJW1j8wSSyx599AHcHxi2PwDI719.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘156$http://audio.xmcdn.com/group26/M0B/3E/AC/wKgJWFj8wVfyPRieAHZBi4IdGPY196.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘157$http://audio.xmcdn.com/group27/M03/3A/C2/wKgJW1j8wZmhF0w0AHj5k8yRtjI750.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘158$http://audio.xmcdn.com/group26/M03/46/B0/wKgJRlj9ismjVuWdAHUnm5fHOSQ681.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘159（感谢打赏支持）$http://audio.xmcdn.com/group27/M04/43/24/wKgJW1j9iwOCp3NMAHkVelO9ElM655.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘160$http://audio.xmcdn.com/group27/M06/8E/5C/wKgJR1kCqZiwx_CTAHtviRpSLys766.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘161（感谢朋友的打赏支持）$http://audio.xmcdn.com/group26/M06/92/52/wKgJWFkCqdPB4uXDAIKTvr736oA922.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘162$http://audio.xmcdn.com/group26/M02/A1/8E/wKgJRlkD7P7jnTJoAHP9gZ6UQF4058.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘163$http://audio.xmcdn.com/group27/M05/9D/E6/wKgJR1kD7T-xr6yEAHZLz7cYwic930.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘164$http://audio.xmcdn.com/group26/M03/B1/98/wKgJRlkFUMCiaNrWAHiur_Nzf0I724.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘165$http://audio.xmcdn.com/group27/M03/AD/FD/wKgJR1kFUSOQKeZQAG9K2nHLMZ8305.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘166$http://audio.xmcdn.com/group27/M0B/BD/67/wKgJR1kGp53Rf2JdAHeBqpNLyms623.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘167$http://audio.xmcdn.com/group27/M0B/BD/6B/wKgJR1kGp7XzgU-gAHOIB8vsTS0703.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘168$http://audio.xmcdn.com/group26/M0A/D2/73/wKgJRlkH-c-DFTglAHjZRhu29nQ738.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘169（即将完本求打赏）$http://audio.xmcdn.com/group26/M0B/D2/EF/wKgJWFkH-dLgs-B3AHYhPa4Eu6I969.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘170（即将完本求打赏）$http://audio.xmcdn.com/group27/M02/E1/B3/wKgJW1kJSfvRXouFAHQlKCJGvMk325.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘171（即将完本求打赏）$http://audio.xmcdn.com/group27/M02/E1/B4/wKgJW1kJSgOA61UeAHzkg-oa88k198.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘172（即将完本求赞助打赏）$http://audio.xmcdn.com/group26/M03/F9/FE/wKgJRlkKtvmz8nCmAHiOYljP1lI093.m4a\r\n梁羽生经典武侠小说龙凤宝钗缘173大结局（已完本求赞助打赏）$http://audio.xmcdn.com/group27/M00/FB/F9/wKgJR1kLE7eyJ8NhAMEj86wjhMA112.m4a', 'xml_8023', '7545', '', 'L', '', '1.0', 3, 0, 0, 0, 'longfengbaochayuanjingzhuangban', ''),
(46, 23, '黄庭仙道——作者：归卧故山[求订阅]|------------------------------------|未授权采集，可以购买云采集联系QQ:2010409646半年200/元，一年300元', '', '', '', '', '', '故事主要讲述一个灵岳城里的低阶小散修魏索，在交易的时候被人骗了，拿到了一个破损的低级法宝，可是这个不值一文的破损法宝里头，却有一个已经活了几万年的器灵。..而且和几万年前相比，很多原本稀少的东西现在已经很多了，魏索首先发现，价值半颗下品灵石的火符的炼制材料现在就很多，于是全部身家已经只剩下几颗下品灵石的小散修开始发迹了。他首先的目标是，娶天玄大陆修道界中最有名的美女水灵儿做老婆。', '', '', 1530071814, 1, 0, 0, 0, 0, 1, 1, 5, 2, 'ting', '', '黄庭仙道——作者：归卧故山(求订阅）未授权采集，可以购买云采集联系QQ:2010409646半年200/元，一年300元', 'xml_8023', '43.224.44.154', '', 'T', '', '1.0', 9, 0, 0, 0, 'tongtianzhilu', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(47, 23, '通天之路', '', '未知', '', '', '', '故事主要讲述一个灵岳城里的低阶小散修魏索，在交易的时候被人骗了，拿到了一个破损的低级法宝，可是这个不值一文的破损法宝里头，却有一个已经活了几万年的器灵。..而且和几万年前相比，很多原本稀少的东西现在已经很多了，魏索首先发现，价值半颗下品灵石的火符的炼制材料现在就很多，于是全部身家已经只剩下几颗下品灵石的小散修开始发迹了。他首先的目标是，娶天玄大陆修道界中最有名的美美女水灵儿做老婆。', 'http://imagev2.xmcdn.com/group26/M08/A9/AB/wKgJRlkEix6zyV84AABmXhvMfwY588.jpg', '', 1530072142, 9, 0, 0, 0, 0, 1, 1, 6, 9, 'ting', '', '通天之路（1）喜欢的订阅！！$http://audio.xmcdn.com/group27/M08/86/A3/wKgJW1jUfP2BVg0OAHK2DKJ5M6g614.m4a\r\n通天之路 (2)$http://audio.xmcdn.com/group27/M08/86/C1/wKgJR1jUfQKScWWQAHKCpTUJm9M902.m4a\r\n通天之路 (3)$http://audio.xmcdn.com/group26/M01/8A/E6/wKgJRljUfQziRXqUAHUwaIGt5Qo226.m4a\r\n通天之路 (4)$http://audio.xmcdn.com/group26/M01/8A/E7/wKgJRljUfR7RdBxVAHLjkTC4PmQ012.m4a\r\n通天之路 (5)$http://audio.xmcdn.com/group26/M01/8A/DF/wKgJWFjUfR7wP-z8AHKejAogNIQ279.m4a\r\n通天之路 (6)$http://audio.xmcdn.com/group26/M01/8A/E0/wKgJWFjUfSnBvodKAHV7TCZaI6w149.m4a\r\n通天之路 (7)$http://audio.xmcdn.com/group27/M03/86/A5/wKgJW1jUfTbR0hG0AHJ8xxo4-9Y681.m4a\r\n通天之路 (8)$http://audio.xmcdn.com/group27/M03/86/C2/wKgJR1jUfTmBRpBHAHVuFCvmmLM860.m4a\r\n通天之路 (9)$http://audio.xmcdn.com/group27/M03/86/C3/wKgJR1jUfU7TBhdUAHR6VMlpZo8635.m4a\r\n通天之路 (10)$http://audio.xmcdn.com/group27/M06/86/A6/wKgJW1jUfUuwXH6sAHD5HuPOTV4277.m4a\r\n通天之路 (11)$http://audio.xmcdn.com/group27/M06/86/A7/wKgJW1jUfVWCOY3xAHMv7IC0kZ4197.m4a\r\n通天之路 (12)$http://audio.xmcdn.com/group27/M05/86/C4/wKgJR1jUfVzyeTvSAHIHTdp0Qy4443.m4a\r\n通天之路 (13)$http://audio.xmcdn.com/group27/M05/86/C4/wKgJR1jUfWSxsC1HAG-zHG090No565.m4a\r\n通天之路 (14)$http://audio.xmcdn.com/group27/M06/86/A8/wKgJW1jUfXCglZ0wAG-ej_JVErk570.m4a\r\n通天之路 (15)$http://audio.xmcdn.com/group27/M06/86/A9/wKgJW1jUfXfDbMF0AG-ej6C7HrM097.m4a\r\n通天之路 (16)$http://audio.xmcdn.com/group26/M03/8A/E8/wKgJRljUfYHgNwLZAHCK-lTfCeo807.m4a\r\n通天之路 (17)$http://audio.xmcdn.com/group26/M03/8A/E2/wKgJWFjUfZmA8Ej5AG_sYvVIqP0491.m4a\r\n通天之路 (18)$http://audio.xmcdn.com/group26/M03/8A/E2/wKgJWFjUfZPSWTpjAG_KnYdbl_E111.m4a\r\n通天之路 (19)$http://audio.xmcdn.com/group26/M03/8A/EA/wKgJRljUfZyDmeQ9AHAtAIg3kXg920.m4a\r\n通天之路 (20)$http://audio.xmcdn.com/group26/M04/8A/EC/wKgJRljUfbODg9vmAHCrR1DTlcg304.m4a\r\n通天之路 (21)$http://audio.xmcdn.com/group27/M09/86/A9/wKgJW1jUfbbwIYeDAHMGzZngNYA292.m4a\r\n通天之路 (22)$http://audio.xmcdn.com/group27/M05/86/C7/wKgJR1jUfbzz2T54AG-xpQa_qHU329.m4a\r\n通天之路 (23)$http://audio.xmcdn.com/group27/M05/86/C8/wKgJR1jUfcbCQ5T_AHNh3EKMK7c830.m4a\r\n通天之路 (24)$http://audio.xmcdn.com/group26/M05/8A/E5/wKgJWFjUfc6xYmgIAHCcmFY225g643.m4a\r\n通天之路 (25)$http://audio.xmcdn.com/group26/M05/8A/E6/wKgJWFjUfdrT0_BPAHKkbjZ6v5E575.m4a\r\n通天之路 (26)$http://audio.xmcdn.com/group26/M02/8A/E7/wKgJWFjUffaiIQCiAHB607tVoJI690.m4a\r\n通天之路 (27)$http://audio.xmcdn.com/group27/M02/86/C9/wKgJR1jUfenxelZrAHCcmKc_bS8066.m4a\r\n通天之路 (28)$http://audio.xmcdn.com/group26/M02/8A/E7/wKgJWFjUfgHgg1kIAG_NjNnZs0M272.m4a\r\n通天之路 (29)$http://audio.xmcdn.com/group26/M02/8A/F1/wKgJRljUfgmCiQoZAHNQObq03MM801.m4a\r\n通天之路 (30)$http://audio.xmcdn.com/group26/M02/8A/F0/wKgJRljUfgSxgbcHAHEAcyYRlaE433.m4a\r\n通天之路 (31)$http://audio.xmcdn.com/group26/M02/8A/E9/wKgJWFjUfhfyzYYVAG9CDe4Ta20126.m4a\r\n通天之路 (32)$http://audio.xmcdn.com/group26/M02/8A/F2/wKgJRljUfhmzt_iYAG_NjAKpxzI165.m4a\r\n通天之路 (33)$http://audio.xmcdn.com/group27/M04/86/CB/wKgJR1jUfirDPU-9AHJ52LcvzFQ339.m4a\r\n通天之路 (34)$http://audio.xmcdn.com/group27/M04/86/CB/wKgJR1jUfiqAghlgAG97U0i0jgQ426.m4a\r\n通天之路 (35)$http://audio.xmcdn.com/group26/M08/8A/EB/wKgJWFjUflKwgSJyAHIb2qTih6k934.m4a\r\n通天之路 (36)$http://audio.xmcdn.com/group27/M04/86/CC/wKgJR1jUfkDQX_U5AHVyfwfBmHY670.m4a\r\n通天之路 (37)$http://audio.xmcdn.com/group27/M01/86/CE/wKgJR1jUfmzh9HlyAHKRVBbdYnM060.m4a\r\n通天之路 (38)$http://audio.xmcdn.com/group26/M08/8A/F3/wKgJRljUfk7w68nFAHKFmKcCx2U562.m4a\r\n通天之路 (39)$http://audio.xmcdn.com/group26/M08/8A/EB/wKgJWFjUflfz3OsTAHBHcPMlrg0699.m4a\r\n通天之路 (40)$http://audio.xmcdn.com/group27/M01/86/AF/wKgJW1jUfl6ihV9MAHFf6CkPeUg967.m4a\r\n通天之路 (41)$http://audio.xmcdn.com/group27/M01/86/B0/wKgJW1jUfnHh8t__AHGcHP5Bjk4458.m4a\r\n通天之路 (42)$http://audio.xmcdn.com/group27/M01/86/B0/wKgJW1jUfnGQHi9DAHGcHP5Bjk4883.m4a\r\n通天之路 (43)$http://audio.xmcdn.com/group26/M00/8A/F5/wKgJRljUfoSy-mlkAHB2bCAPOOE478.m4a\r\n通天之路 (44)$http://audio.xmcdn.com/group26/M00/8A/F4/wKgJRljUfoLifW7eAHB2bCUV79g867.m4a\r\n通天之路 (45)$http://audio.xmcdn.com/group26/M00/8A/ED/wKgJWFjUfovjk9IgAHAYb2uKaZg077.m4a\r\n通天之路 (46)$http://audio.xmcdn.com/group27/M09/86/CF/wKgJR1jUfpXgjarwAHA1zpO4QvI164.m4a\r\n通天之路 (47)$http://audio.xmcdn.com/group27/M01/86/B3/wKgJW1jUfqbiMsFbAG86tE6948s518.m4a\r\n通天之路 (48)$http://audio.xmcdn.com/group27/M09/86/D1/wKgJR1jUfqeSXQD8AG_iHV8jHxo043.m4a\r\n通天之路 (49)$http://audio.xmcdn.com/group26/M0A/8A/EE/wKgJWFjUfq-R3nv2AG9soyOWzyY162.m4a\r\n通天之路 (50)$http://audio.xmcdn.com/group26/M0A/8A/F0/wKgJWFjUfsnjwGsgAHR9Q8zXIOQ435.m4a\r\n通天之路 (51)$http://audio.xmcdn.com/group26/M00/8B/16/wKgJWFjUgmuAK9mbAG-VvgUAePc305.m4a\r\n通天之路 (52)$http://audio.xmcdn.com/group26/M00/8B/17/wKgJWFjUgnfgoc_5AHJd8cH_OlY967.m4a\r\n通天之路 (53)$http://audio.xmcdn.com/group27/M0B/86/D9/wKgJW1jUgpfwDCABAHMxZAQ9e6Y105.m4a\r\n通天之路 (54)$http://audio.xmcdn.com/group26/M01/8B/19/wKgJWFjUgr3SaFMXAHH1r5vFSKA418.m4a\r\n通天之路 (55)$http://audio.xmcdn.com/group27/M0B/86/DD/wKgJW1jUgtuw_MVJAHAnHvCP-eo643.m4a\r\n通天之路 (56)$http://audio.xmcdn.com/group26/M05/8B/1D/wKgJWFjUgvvynjOpAHKSz4tFR2Q154.m4a\r\n通天之路 (57)$http://audio.xmcdn.com/group27/M03/86/E0/wKgJW1jUgymxtEe8AHLwyaOWDyg530.m4a\r\n通天之路 (58)$http://audio.xmcdn.com/group27/M03/86/E2/wKgJW1jUg0HB7-d4AHKYrpiMcuk868.m4a\r\n通天之路 (59)$http://audio.xmcdn.com/group26/M09/8B/29/wKgJRljUg4iR1WWPAHKRVLFTh2g022.m4a\r\n通天之路 (60)$http://audio.xmcdn.com/group26/M02/8B/29/wKgJRljUg37y2Hh7AHH_-GH0RcA294.m4a\r\n通天之路 (61)$http://audio.xmcdn.com/group27/M09/86/E4/wKgJW1jUg5eS9fFyAHKtO1xaq9Q573.m4a\r\n通天之路 (62)$http://audio.xmcdn.com/group26/M0A/8B/24/wKgJWFjUg7GglB4LAHFecLgLwWI028.m4a\r\n通天之路 (63)$http://audio.xmcdn.com/group27/M0A/87/04/wKgJR1jUg8yQT9ruAHFSsEBxC4k177.m4a\r\n通天之路 (64)$http://audio.xmcdn.com/group26/M0A/8B/25/wKgJWFjUg9mg4Na1AHHbQMDupzM118.m4a\r\n通天之路 (65)$http://audio.xmcdn.com/group26/M0A/8B/2F/wKgJRljUg_PCzMKCAHQgwcHd7vM693.m4a\r\n通天之路 (66)$http://audio.xmcdn.com/group27/M0A/86/E8/wKgJW1jUhAuxZ_m-AHJpsdR9RwU992.m4a\r\n通天之路 (67)$http://audio.xmcdn.com/group27/M08/86/EA/wKgJW1jUhCXgRSkAAHNh3Lir6lU160.m4a\r\n通天之路 (68)$http://audio.xmcdn.com/group27/M08/86/EC/wKgJW1jUhDnScr2_AHDtXVZ_dQI194.m4a\r\n通天之路 (69)$http://audio.xmcdn.com/group26/M08/8B/30/wKgJRljUhFHQo00qAHJd8fZyYVk188.m4a\r\n通天之路 (70)$http://audio.xmcdn.com/group26/M08/8B/32/wKgJRljUhG3BKHnAAHH0N9cBE74340.m4a\r\n通天之路 (71)$http://audio.xmcdn.com/group27/M0A/87/0D/wKgJR1jUhJGQlQyOAHPKHrGA3sA050.m4a\r\n通天之路 (72)$http://audio.xmcdn.com/group26/M0B/8B/36/wKgJRljUhKaR2FD0AHITDdTR4pk966.m4a\r\n通天之路 (73)$http://audio.xmcdn.com/group27/M04/87/0E/wKgJR1jUhLXDz9TaAHLWWS9nAG0500.m4a\r\n通天之路 (74)$http://audio.xmcdn.com/group26/M07/8B/38/wKgJRljUhMzxXwmjAHEZaysVhwg005.m4a\r\n通天之路 (75)$http://audio.xmcdn.com/group27/M06/87/0F/wKgJR1jUhO7SLdURAHMD3ibySBo068.m4a\r\n通天之路 (76)$http://audio.xmcdn.com/group27/M06/87/0F/wKgJR1jUhO3SeccCAHP0tObfDNc225.m4a\r\n通天之路 (77)$http://audio.xmcdn.com/group27/M06/86/F3/wKgJW1jUhP3AGlGhAG8zXhVMYlI035.m4a\r\n通天之路 (78)$http://audio.xmcdn.com/group26/M09/8B/3D/wKgJRljUhR_Rgdt0AHDeruiMD8o148.m4a\r\n通天之路 (79)$http://audio.xmcdn.com/group26/M09/8B/3C/wKgJRljUhRqxOB-hAHJE-VES5ws356.m4a\r\n通天之路 (80)$http://audio.xmcdn.com/group27/M00/86/F4/wKgJW1jUhSuBK6yhAHTuVrPXrH0308.m4a\r\n通天之路 (81)$http://audio.xmcdn.com/group26/M03/8B/3E/wKgJRljUhUSy9w40AHNgZIxg7D8011.m4a\r\n通天之路 (82)$http://audio.xmcdn.com/group26/M03/8B/38/wKgJWFjUhV7xboEfAHA7sEYQaNw809.m4a\r\n通天之路 (83)$http://audio.xmcdn.com/group26/M03/8B/41/wKgJRljUhWCySTtGAHIu9E0qabw239.m4a\r\n通天之路 (84)$http://audio.xmcdn.com/group27/M05/87/15/wKgJR1jUhWyiSVRDAHKSz1vc_4s732.m4a\r\n通天之路 (85)$http://audio.xmcdn.com/group27/M09/86/F9/wKgJW1jUhYCCAGEqAHD3ppXVtpw135.m4a\r\n通天之路 (86)$http://audio.xmcdn.com/group26/M04/8B/3A/wKgJWFjUhZjwEnnMAHXHp-41xxk827.m4a\r\n通天之路 (87)$http://audio.xmcdn.com/group26/M04/8B/39/wKgJWFjUhYeSpffFAHLgorjrsrQ985.m4a\r\n通天之路 (88)$http://audio.xmcdn.com/group26/M04/8B/3A/wKgJWFjUhZiDsgD-AHKdFOLH9oY948.m4a\r\n通天之路 (89)$http://audio.xmcdn.com/group26/M04/8B/43/wKgJRljUhZvRsn-dAHObIZ7qlro055.m4a\r\n通天之路 (90)$http://audio.xmcdn.com/group27/M09/86/FA/wKgJW1jUhaTAiyRXAHIkrET8M34742.m4a\r\n通天之路 (91)$http://audio.xmcdn.com/group27/M07/87/19/wKgJR1jUha7RrIvxAHBgZFP6N00080.m4a\r\n通天之路 (92)$http://audio.xmcdn.com/group26/M01/8B/44/wKgJRljUhbrjloB7AHNZC5QSPLU182.m4a\r\n通天之路 (93)$http://audio.xmcdn.com/group26/M01/8B/3D/wKgJWFjUhcHSdGipAHIu9HaBLdw990.m4a\r\n通天之路 (94)$http://audio.xmcdn.com/group26/M01/8B/46/wKgJRljUhczwGXIqAHQAcB_THNk276.m4a\r\n通天之路 (95)$http://audio.xmcdn.com/group26/M01/8B/46/wKgJRljUhdbQOq4_AHIOp0fET70661.m4a\r\n通天之路 (96)$http://audio.xmcdn.com/group27/M01/86/FC/wKgJW1jUhd_iPVCWAHOCKVoGdYI132.m4a\r\n通天之路 (97)$http://audio.xmcdn.com/group27/M01/87/1B/wKgJR1jUhezRGO3OAHPLlRTNb0Y010.m4a\r\n通天之路 (98)$http://audio.xmcdn.com/group27/M03/86/FD/wKgJW1jUhe6jesqVAHGh-g59NFM326.m4a\r\n通天之路 (99)$http://audio.xmcdn.com/group27/M03/86/FE/wKgJW1jUhfezGIlsAHM4vQTdFuA701.m4a\r\n通天之路 (100)$http://audio.xmcdn.com/group27/M03/86/FF/wKgJW1jUhgTBYO53AHFnPqwFk7w251.m4a\r\n通天之路 (101)$http://audio.xmcdn.com/group26/M04/8B/05/wKgJRljUgB7gVXdHAHNOwg3oFt0104.m4a\r\n通天之路 (102)$http://audio.xmcdn.com/group26/M04/8A/FE/wKgJWFjUgC2yOhKVAHJE-dLdqsI916.m4a\r\n通天之路 (103)$http://audio.xmcdn.com/group27/M05/86/E1/wKgJR1jUgFiRk_CFAHKOZaTokYQ713.m4a\r\n通天之路 (104)$http://audio.xmcdn.com/group27/M05/86/E0/wKgJR1jUgFbwikAhAHGqy8KNAYs052.m4a\r\n通天之路 (105)$http://audio.xmcdn.com/group27/M05/86/C4/wKgJW1jUgHTAI1OzAHNe6RMHTG4153.m4a\r\n通天之路 (106)$http://audio.xmcdn.com/group26/M07/8B/09/wKgJRljUgGXSX5WZAHGn3FK9y4Y880.m4a\r\n通天之路 (107)$http://audio.xmcdn.com/group27/M07/86/C6/wKgJW1jUgIzwV6DTAHHSbuf8RFM838.m4a\r\n通天之路 (108)$http://audio.xmcdn.com/group27/M05/86/C4/wKgJW1jUgH7yBgLZAHIF1qCKYEs555.m4a\r\n通天之路 (109)$http://audio.xmcdn.com/group26/M01/8B/03/wKgJWFjUgKCC5uwxAHEcWltklCU861.m4a\r\n通天之路 (110)$http://audio.xmcdn.com/group26/M01/8B/03/wKgJWFjUgJ2C_2FEAHEpkgcxEWQ779.m4a\r\n通天之路 (111)$http://audio.xmcdn.com/group27/M07/86/C7/wKgJW1jUgLPRKP_NAHF7z66pjcw003.m4a\r\n通天之路 (112)$http://audio.xmcdn.com/group26/M02/8B/0F/wKgJRljUgOPCxVwGAHQw6Nshn_s377.m4a\r\n通天之路 (113)$http://audio.xmcdn.com/group27/M08/86/E7/wKgJR1jUgPvAE4IYAHMJwURmV4w473.m4a\r\n通天之路 (114)$http://audio.xmcdn.com/group26/M00/8B/09/wKgJWFjUgR_ydeX1AHLsYuCYiEY396.m4a\r\n通天之路 (115)$http://audio.xmcdn.com/group26/M00/8B/10/wKgJRljUgRywTguCAHGn3ChDHCk121.m4a\r\n通天之路 (116)$http://audio.xmcdn.com/group26/M03/8B/13/wKgJRljUgVKiHKhfAHT7jref_pU742.m4a\r\n通天之路 (117)$http://audio.xmcdn.com/group26/M03/8B/0A/wKgJWFjUgUux8iWIAHC86SrUGm8146.m4a\r\n通天之路 (118)$http://audio.xmcdn.com/group26/M09/8B/0E/wKgJWFjUgZ_i2NRbAHKSz8Vmuzc926.m4a\r\n通天之路 (119)$http://audio.xmcdn.com/group27/M04/86/EC/wKgJR1jUgX7S-kGOAHIgRRqrpmM432.m4a\r\n通天之路 (120)$http://audio.xmcdn.com/group26/M09/8B/0E/wKgJWFjUgZew4gI0AHKLdi7PPOA157.m4a\r\n通天之路 (121)$http://audio.xmcdn.com/group27/M00/86/EF/wKgJR1jUgayit_VeAHGNbe4Z6fs048.m4a\r\n通天之路 (122)$http://audio.xmcdn.com/group26/M0A/8B/17/wKgJRljUgciwD-O0AHEVBKhpwBA630.m4a\r\n通天之路 (123)$http://audio.xmcdn.com/group27/M02/86/D2/wKgJW1jUgd_TDLajAHH0NyLuNyI748.m4a\r\n通天之路 (124)$http://audio.xmcdn.com/group26/M06/8B/11/wKgJWFjUgfixcLt0AHGcHGhy9bc038.m4a\r\n通天之路 (125)$http://audio.xmcdn.com/group27/M06/86/D4/wKgJW1jUgiDQoZWaAHGDJNNh3XI896.m4a\r\n通天之路 (126)$http://audio.xmcdn.com/group27/M06/86/F6/wKgJR1jUgjzT8NtbAHGn3E86IBc470.m4a\r\n通天之路 (127)$http://audio.xmcdn.com/group27/M0A/86/D7/wKgJW1jUglTiMro7AHDwTAYuGVk649.m4a\r\n通天之路 (128)$http://audio.xmcdn.com/group27/M07/86/F7/wKgJR1jUgmjQYpj_AHLHqot7JGM982.m4a\r\n通天之路 (129)$http://audio.xmcdn.com/group26/M00/8B/18/wKgJWFjUgo2RHm2NAHKkbo0295w075.m4a\r\n通天之路 (130)$http://audio.xmcdn.com/group27/M0B/86/F9/wKgJR1jUgquDJyAiAHOlZpvpzdk384.m4a\r\n通天之路 (131)$http://audio.xmcdn.com/group26/M05/8B/26/wKgJRljUgwLDPe4uAG_8iEVq4WM011.m4a\r\n通天之路 (132)$http://audio.xmcdn.com/group26/M05/8B/1D/wKgJWFjUgvSiC_6IAHGyIULjY8E242.m4a\r\n通天之路 (133)$http://audio.xmcdn.com/group26/M05/8B/26/wKgJRljUgwazJXw_AHI3wan0uIk914.m4a\r\n通天之路 (134)$http://audio.xmcdn.com/group27/M03/86/E0/wKgJW1jUgyWSsxxZAHEoGvSuDS8088.m4a\r\n通天之路 (135)$http://audio.xmcdn.com/group27/M05/87/00/wKgJR1jUg0eDLOzRAG_cO8kkoEM217.m4a\r\n通天之路 (136)$http://audio.xmcdn.com/group26/M02/8B/20/wKgJWFjUg2iAtsuOAG9uGw63GHw477.m4a\r\n通天之路 (137)$http://audio.xmcdn.com/group26/M09/8B/2A/wKgJRljUg4zyuecoAHE2yYBQAOM571.m4a\r\n通天之路 (138)$http://audio.xmcdn.com/group27/M09/86/E5/wKgJW1jUg6HhBhV8AHDwTD3kXBw081.m4a\r\n通天之路 (139)$http://audio.xmcdn.com/group26/M09/8B/2C/wKgJRljUg7ixI9wZAG-LeULaX0Q492.m4a\r\n通天之路 (140)$http://audio.xmcdn.com/group26/M0A/8B/2C/wKgJRljUg9OzBdEWAHAUCWkGulM889.m4a\r\n通天之路 (141)$http://audio.xmcdn.com/group26/M0A/8B/2E/wKgJRljUg-qy_mLAAHB2bNzPLlQ690.m4a\r\n通天之路 (142)$http://audio.xmcdn.com/group27/M07/87/0A/wKgJR1jUhDTSzuEhAHF17dzhmkI624.m4a\r\n通天之路 (143)$http://audio.xmcdn.com/group27/M07/87/09/wKgJR1jUhCOjKQEuAHDqbhj3o08100.m4a\r\n通天之路 (144)$http://audio.xmcdn.com/group27/M07/87/0A/wKgJR1jUhDfQ903vAG-tPg1xKzg390.m4a\r\n通天之路 (145)$http://audio.xmcdn.com/group26/M08/8B/30/wKgJRljUhFGD5RN3AHOCKW1nRqc398.m4a\r\n通天之路 (146)$http://audio.xmcdn.com/group26/M08/8B/33/wKgJRljUhG2i0vGBAHAtAPThGTo892.m4a\r\n通天之路 (147)$http://audio.xmcdn.com/group27/M0A/87/0B/wKgJR1jUhIKj5ASFAG-IirFveZA991.m4a\r\n通天之路 (148)$http://audio.xmcdn.com/group26/M0B/8B/35/wKgJRljUhJ3RNaYqAHWLcskveyk260.m4a\r\n通天之路 (149)$http://audio.xmcdn.com/group27/M04/86/F1/wKgJW1jUhMGTnzs-AG-boDaCFpE501.m4a\r\n通天之路 (150)$http://audio.xmcdn.com/group26/M07/8B/2F/wKgJWFjUhNDxYHsHAHEKvDkmNT4891.m4a\r\n通天之路 (151)$http://audio.xmcdn.com/group27/M07/86/C8/wKgJW1jUgMGz6pxMAHUF0oECp8Y474.m4a\r\n通天之路 (152)$http://audio.xmcdn.com/group26/M02/8B/0D/wKgJRljUgNCAjLUSAHKCpQuoQ-M230.m4a\r\n通天之路 (153)$http://audio.xmcdn.com/group27/M03/86/CA/wKgJW1jUgQWzpo2XAHC86d1VAUA723.m4a\r\n通天之路 (154)$http://audio.xmcdn.com/group27/M08/86/E7/wKgJR1jUgQLy5jQ8AHHbQC-sULQ229.m4a\r\n通天之路 (155)$http://audio.xmcdn.com/group26/M00/8B/09/wKgJWFjUgRyx1hUlAHHbQGQKta8302.m4a\r\n通天之路 (156)$http://audio.xmcdn.com/group27/M03/86/E9/wKgJR1jUgS-CBgInAHHnANGQzGQ765.m4a\r\n通天之路 (157)$http://audio.xmcdn.com/group26/M03/8B/0B/wKgJWFjUgVfC5JsWAG_DRywlf-I449.m4a\r\n通天之路 (158)$http://audio.xmcdn.com/group27/M04/86/EC/wKgJR1jUgXiQTaUSAHE7MMmjgTM437.m4a\r\n通天之路 (159)$http://audio.xmcdn.com/group27/M04/86/EC/wKgJR1jUgXnTlqa6AHOfh0lJbOo655.m4a\r\n通天之路 (160)$http://audio.xmcdn.com/group26/M09/8B/16/wKgJRljUgZHyF74_AHCrR77eEg0232.m4a\r\n通天之路 (161)$http://audio.xmcdn.com/group26/M09/8B/0E/wKgJWFjUgZ_zd0-YAG_1Mw7cZBc461.m4a\r\n通天之路 (162)$http://audio.xmcdn.com/group27/M02/86/D1/wKgJW1jUgbnyeWcpAHAc2oM6WaA647.m4a\r\n通天之路 (163)$http://audio.xmcdn.com/group26/M0A/8B/0F/wKgJWFjUgc-TBhuQAHAYb6arquI898.m4a\r\n通天之路 (164)$http://audio.xmcdn.com/group26/M06/8B/10/wKgJWFjUgfSD8SQRAG9ygTuVQ14658.m4a\r\n通天之路 (165)$http://audio.xmcdn.com/group26/M06/8B/13/wKgJWFjUggqiFZ4hAG91cCcRjjQ060.m4a\r\n通天之路 (166)$http://audio.xmcdn.com/group27/M06/86/F5/wKgJR1jUgjGAsHabAHPP_AjEqcI077.m4a\r\n通天之路 (167)$http://audio.xmcdn.com/group27/M06/86/F5/wKgJR1jUgjryB-UUAG_-BEpvJK0399.m4a\r\n通天之路 (168)$http://audio.xmcdn.com/group27/M07/86/F6/wKgJR1jUgleCWRGQAG-tPubVf-8596.m4a\r\n通天之路 (169)$http://audio.xmcdn.com/group26/M00/8B/1F/wKgJRljUgnzTjL20AHSHjEPwX_k977.m4a\r\n通天之路 (170)$http://audio.xmcdn.com/group27/M0B/86/F9/wKgJR1jUgqmTom6FAG-YsbYfvXk776.m4a\r\n通天之路 (171)$http://audio.xmcdn.com/group26/M01/8B/21/wKgJRljUgr3w7zcLAHBsJEptBkI190.m4a\r\n通天之路 (172)$http://audio.xmcdn.com/group27/M0B/86/DD/wKgJW1jUguDzjL_7AHQZaGd1ENU854.m4a\r\n通天之路 (173)$http://audio.xmcdn.com/group27/M00/86/FB/wKgJR1jUgwjT9VHFAHDaSDBf6R8033.m4a\r\n通天之路 (174)$http://audio.xmcdn.com/group27/M00/86/FD/wKgJR1jUgx-SENNYAHDaSK6bruA103.m4a\r\n通天之路 (175)$http://audio.xmcdn.com/group27/M05/87/00/wKgJR1jUg0awsP8sAHKwLsB0Kw4764.m4a\r\n通天之路 (176)$http://audio.xmcdn.com/group26/M02/8B/1F/wKgJWFjUg2HyVDI5AHMYcMLK-cs878.m4a\r\n通天之路 (177)$http://audio.xmcdn.com/group26/M09/8B/29/wKgJRljUg4OCq48LAHF3ZDv402E624.m4a\r\n通天之路 (178)$http://audio.xmcdn.com/group26/M0A/8B/2D/wKgJRljUg9TTUjL9AHAJwKQ2QYw104.m4a\r\n通天之路 (179)$http://audio.xmcdn.com/group26/M0A/8B/24/wKgJWFjUg7SzoTGgAG_sYhhuC4A856.m4a\r\n通天之路 (180)$http://audio.xmcdn.com/group27/M0A/87/04/wKgJR1jUg8_g2CsLAHITDdL6UwI348.m4a\r\n通天之路 (181)$http://audio.xmcdn.com/group26/M0A/8B/2F/wKgJRljUg_DAiBs2AHZDAhf75cU640.m4a\r\n通天之路 (182)$http://audio.xmcdn.com/group27/M0A/86/E7/wKgJW1jUg_2xNTTAAG-hfm69sGg103.m4a\r\n通天之路 (183)$http://audio.xmcdn.com/group27/M08/86/EA/wKgJW1jUhCTDiKpOAHE7MC7g-3s292.m4a\r\n通天之路 (184)$http://audio.xmcdn.com/group27/M08/86/EC/wKgJW1jUhDfjNpgBAHI_G5d5BrM377.m4a\r\n通天之路 (185)$http://audio.xmcdn.com/group27/M08/86/ED/wKgJW1jUhEOTEiKlAHHJocrMkNs790.m4a\r\n通天之路 (186)$http://audio.xmcdn.com/group26/M08/8B/31/wKgJRljUhF6inximAHDkjDzQC3s047.m4a\r\n通天之路 (187)$http://audio.xmcdn.com/group26/M0B/8B/33/wKgJRljUhHLB7dgBAHPEO0CiDlw519.m4a\r\n通天之路 (188)$http://audio.xmcdn.com/group27/M04/86/ED/wKgJW1jUhIiBA-ZiAHA6ONYJbho527.m4a\r\n通天之路 (189)$http://audio.xmcdn.com/group26/M0B/8B/35/wKgJRljUhJ6QwvZPAHJ-PimtX3A915.m4a\r\n通天之路 (190)$http://audio.xmcdn.com/group27/M04/86/F0/wKgJW1jUhLeyjAkfAHOIBx7IO8g761.m4a\r\n通天之路 (191)$http://audio.xmcdn.com/group26/M07/8B/38/wKgJRljUhNLhm0KEAHSKe12B6uU908.m4a\r\n通天之路 (192)$http://audio.xmcdn.com/group26/M07/8B/3A/wKgJRljUhOKiycYNAHMD3vPcyLI244.m4a\r\n通天之路 (193)$http://audio.xmcdn.com/group27/M06/86/F2/wKgJW1jUhPGRGczaAHAFWRgFBQI742.m4a\r\n通天之路 (194)$http://audio.xmcdn.com/group27/M00/86/F3/wKgJW1jUhQaguXMTAHESEc0NI0g160.m4a\r\n通天之路 (195)$http://audio.xmcdn.com/group26/M09/8B/32/wKgJWFjUhRKQ1pROAHAolvCASS4425.m4a\r\n通天之路 (196)$http://audio.xmcdn.com/group26/M03/8B/40/wKgJRljUhVfx3YjiAHQWedyHapU538.m4a\r\n通天之路 (197)$http://audio.xmcdn.com/group27/M02/87/13/wKgJR1jUhTXyKQijAHJlRprLgUQ837.m4a\r\n通天之路 (198)$http://audio.xmcdn.com/group26/M03/8B/38/wKgJWFjUhVeR4Ug2AHDdNzr6uJw730.m4a\r\n通天之路 (199)$http://audio.xmcdn.com/group26/M03/8B/41/wKgJRljUhVvST2G7AHJd8SyUhEE096.m4a\r\n通天之路 (200)$http://audio.xmcdn.com/group27/M05/87/16/wKgJR1jUhXDjjWxgAG_lDOayj70633.m4a\r\n通天之路 (201)$http://audio.xmcdn.com/group26/M00/8B/4E/wKgJRljUhqfz8vmQAHHnACo16vs432.m4a\r\n通天之路 (202)$http://audio.xmcdn.com/group26/M00/8B/50/wKgJRljUhrmAnuQyAHPP_MzphGk154.m4a\r\n通天之路 (203)$http://audio.xmcdn.com/group27/M07/87/09/wKgJW1jUhu2hEzSvAHF7z3VdjNo407.m4a\r\n通天之路 (204)$http://audio.xmcdn.com/group27/M04/87/24/wKgJR1jUhsmhJ2q4AHDEP0XzxZw701.m4a\r\n通天之路 (205)$http://audio.xmcdn.com/group27/M04/87/08/wKgJW1jUhtai1iPiAHPXVfsCIpY936.m4a\r\n通天之路 (206)$http://audio.xmcdn.com/group27/M07/87/08/wKgJW1jUhuDidjYPAHEDYtIoTyo776.m4a\r\n通天之路 (207)$http://audio.xmcdn.com/group27/M07/87/09/wKgJW1jUhu3AsVRDAHHMkJtko3U060.m4a\r\n通天之路 (208)$http://audio.xmcdn.com/group27/M07/87/27/wKgJR1jUhviCcoTJAHHMkBzywDY184.m4a\r\n通天之路 (209)$http://audio.xmcdn.com/group27/M07/87/29/wKgJR1jUhwvivmSJAG_QewaRNms280.m4a\r\n通天之路 (210)$http://audio.xmcdn.com/group27/M07/87/0C/wKgJW1jUhxGhsAOoAHRPvryxLrM686.m4a\r\n通天之路 (211)$http://audio.xmcdn.com/group26/M02/8B/49/wKgJWFjUhxqxgAAkAHOid-L_tgQ871.m4a\r\n通天之路 (212)$http://audio.xmcdn.com/group26/M02/8B/52/wKgJRljUhybQQiEqAHOJf-Cs8zA214.m4a\r\n通天之路 (213)$http://audio.xmcdn.com/group26/M02/8B/53/wKgJRljUhzKg8Cn9AHINK4e8Rt8418.m4a\r\n通天之路 (214)$http://audio.xmcdn.com/group26/M02/8B/54/wKgJRljUhz-SMZlFAHKXNgcCv9g100.m4a\r\n通天之路 (215)$http://audio.xmcdn.com/group27/M08/87/2A/wKgJR1jUh0fj3j_BAHDwTCR1IAY917.m4a\r\n通天之路 (216)$http://audio.xmcdn.com/group27/M08/87/0E/wKgJW1jUh1XR_jnbAHF6U6fMp5k679.m4a\r\n通天之路 (217)$http://audio.xmcdn.com/group26/M05/8B/55/wKgJRljUh2KzklxBAHVK2OoUKcU980.m4a\r\n通天之路 (218)$http://audio.xmcdn.com/group26/M05/8B/56/wKgJRljUh27CoycDAG-VvqEzbug751.m4a\r\n通天之路 (219)$http://audio.xmcdn.com/group26/M05/8B/4F/wKgJWFjUh3fQKaoCAHI6tK7jyA4143.m4a\r\n通天之路 (220)$http://audio.xmcdn.com/group27/M02/87/2C/wKgJR1jUh4WzSfWeAHMGzTuH9SU156.m4a\r\n通天之路 (221)$http://audio.xmcdn.com/group26/M07/8B/58/wKgJRljUh5uT19xWAHHZyJbNrXM911.m4a\r\n通天之路 (222)$http://audio.xmcdn.com/group26/M07/8B/51/wKgJWFjUh6GQs8PDAHGn3KBiKkI397.m4a\r\n通天之路 (223)$http://audio.xmcdn.com/group26/M07/8B/52/wKgJWFjUh6yA9EUaAHJd8Q7EAJc682.m4a\r\n通天之路 (224)$http://audio.xmcdn.com/group27/M09/87/10/wKgJW1jUh7jxgN_MAHGGEyRrpak458.m4a\r\n通天之路 (225)$http://audio.xmcdn.com/group27/M09/87/11/wKgJW1jUh8bivTLLAHHIKjNUf2g613.m4a\r\n通天之路 (226)$http://audio.xmcdn.com/group27/M0B/87/12/wKgJW1jUh8_jg32nAHOlZmUp7Ig457.m4a\r\n通天之路 (227)$http://audio.xmcdn.com/group26/M08/8B/5B/wKgJRljUh-nhVniFAHA1zj5LXPI594.m4a\r\n通天之路 (228)$http://audio.xmcdn.com/group27/M0A/87/30/wKgJR1jUh_nSr7FqAHDEP-UDZSg959.m4a\r\n通天之路 (229)$http://audio.xmcdn.com/group26/M04/8B/55/wKgJWFjUiAqh6R4iAHWo0b5l50Y574.m4a\r\n通天之路 (230)$http://audio.xmcdn.com/group26/M04/8B/57/wKgJWFjUiCeznKnqAHGn3GBfonQ229.m4a\r\n通天之路 (231)$http://audio.xmcdn.com/group27/M05/87/33/wKgJR1jUiD3T7GnUAHJlRo5m7MA206.m4a\r\n通天之路 (232)$http://audio.xmcdn.com/group26/M0A/8B/58/wKgJWFjUiFXjVImiAG-URlg7TE8314.m4a\r\n通天之路 (233)$http://audio.xmcdn.com/group26/M0A/8B/59/wKgJWFjUiF6DxzXqAHGn3HgqgNc624.m4a\r\n通天之路 (234)$http://audio.xmcdn.com/group26/M0A/8B/61/wKgJRljUiGuCFjBwAHFecDMfXCY356.m4a\r\n通天之路 (235)$http://audio.xmcdn.com/group27/M06/87/36/wKgJR1jUiHqTV20gAHXfJ9UQib4895.m4a\r\n通天之路 (236)$http://audio.xmcdn.com/group27/M01/87/38/wKgJR1jUiK6CmQ59AHO7brh0bec877.m4a\r\n通天之路 (237)$http://audio.xmcdn.com/group27/M01/87/1B/wKgJW1jUiLGAxTViAHPo848P2bo186.m4a\r\n通天之路 (238)$http://audio.xmcdn.com/group27/M01/87/3A/wKgJR1jUiMuw9h72AHFORiChFYQ677.m4a\r\n通天之路 (239)$http://audio.xmcdn.com/group27/M03/87/1C/wKgJW1jUiMviKHdcAHLjkeXy3tQ986.m4a\r\n通天之路 (240)$http://audio.xmcdn.com/group27/M01/87/39/wKgJR1jUiMaT8GASAHRf5XtVuLk264.m4a\r\n通天之路 (241)$http://audio.xmcdn.com/group26/M03/8B/65/wKgJRljUiNjgq0M2AHCGk8S7YPw502.m4a\r\n通天之路 (242)$http://audio.xmcdn.com/group27/M03/87/1D/wKgJW1jUiOeQu50CAHEE2qMmyDk448.m4a\r\n通天之路 (243)$http://audio.xmcdn.com/group26/M09/8B/60/wKgJWFjUiQHzgShuAHJNykv_ePc971.m4a\r\n通天之路 (244)$http://audio.xmcdn.com/group27/M02/87/3F/wKgJR1jUiUuQxW-RAHVcdliy0J4402.m4a\r\n通天之路 (245)$http://audio.xmcdn.com/group26/M09/8B/62/wKgJWFjUiROzDQhxAHXHp6p1gEU010.m4a\r\n通天之路 (246)$http://audio.xmcdn.com/group27/M00/87/1F/wKgJW1jUiSiCOwWIAHP--Pk4IX8098.m4a\r\n通天之路 (247)$http://audio.xmcdn.com/group27/M00/87/3D/wKgJR1jUiTHSF2HJAHCuOqldmmk953.m4a\r\n通天之路 (248)$http://audio.xmcdn.com/group27/M02/87/3F/wKgJR1jUiU6xWNyyAHAMs979sAo602.m4a\r\n通天之路 (249)$http://audio.xmcdn.com/group27/M04/87/22/wKgJW1jUiUnza706AHPFs22W9Mg943.m4a\r\n通天之路 (250)$http://audio.xmcdn.com/group27/M04/87/23/wKgJW1jUiVTQjnt6AHA-n3n6-Y4144.m4a\r\n通天之路 (251)$http://audio.xmcdn.com/group27/M06/87/43/wKgJR1jUibTS-QCuAG_NjLmcNmA687.m4a\r\n通天之路 (252)$http://audio.xmcdn.com/group27/M09/87/28/wKgJW1jUib3w4d-bAG97U-ZMcRU642.m4a\r\n通天之路 (253)$http://audio.xmcdn.com/group27/M0B/87/44/wKgJR1jUicSwTDBiAHNzeixmCZk044.m4a\r\n通天之路 (254)$http://audio.xmcdn.com/group26/M00/8B/68/wKgJWFjUifKScJ82AHJPQsKu2x4369.m4a\r\n通天之路 (255)$http://audio.xmcdn.com/group27/M09/87/2C/wKgJW1jUiePyRDQRAHHnAKJzt9Q905.m4a\r\n通天之路 (256)$http://audio.xmcdn.com/group27/M09/87/2D/wKgJW1jUieiwSstVAHHnAA6xP20657.m4a\r\n通天之路 (257)$http://audio.xmcdn.com/group26/M00/8B/6B/wKgJWFjUihOwEeX8AHBBjqvxGnY418.m4a\r\n通天之路 (258)$http://audio.xmcdn.com/group26/M00/8B/69/wKgJWFjUif6xv0qBAG-tPklNsdc356.m4a\r\n通天之路 (259)$http://audio.xmcdn.com/group26/M08/8B/72/wKgJRljUihmBvEgkAHMs_SNb4zM380.m4a\r\n通天之路 (260)$http://audio.xmcdn.com/group26/M08/8B/73/wKgJRljUih3xLOcjAHMW-BFP82M883.m4a\r\n通天之路 (261)$http://audio.xmcdn.com/group26/M08/8B/72/wKgJRljUihmQEMIlAHMitJp_EAc797.m4a\r\n通天之路 (262)$http://audio.xmcdn.com/group27/M0A/87/2D/wKgJW1jUiiKycvfoAHUNLCtvEOU222.m4a\r\n261$http://audio.xmcdn.com/group26/M04/A7/9C/wKgJWFkEYCvBy6tKAHUBbCWK_GA286.m4a\r\n262$http://audio.xmcdn.com/group27/M04/A3/79/wKgJW1kEYFuwYkcnAHJSMepd2Wc516.m4a\r\n263$http://audio.xmcdn.com/group27/M02/A3/89/wKgJR1kEYHWgOMQDAG9SNDCKOkA558.m4a\r\n264$http://audio.xmcdn.com/group26/M08/A7/9F/wKgJWFkEYJLAUgthAHDCx4cjwsg318.m4a\r\n265$http://audio.xmcdn.com/group26/M08/A7/38/wKgJRlkEYKywshWvAHFPwSjUo1Q177.m4a\r\n266$http://audio.xmcdn.com/group27/M05/A3/7E/wKgJW1kEYMbhukXTAHQcVz3sElk701.m4a\r\n267$http://audio.xmcdn.com/group27/M05/A3/80/wKgJW1kEYNaww_ddAHFc9TQtOlM765.m4a\r\n268$http://audio.xmcdn.com/group26/M00/A7/A3/wKgJWFkEYPiDBCXaAHJ7T3RKcQk241.m4a\r\n269$http://audio.xmcdn.com/group26/M00/A7/A5/wKgJWFkEYQiyCivRAHN8RzIS-7M869.m4a\r\n270$http://audio.xmcdn.com/group26/M00/A7/A8/wKgJWFkEYSGwVAzNAHE8pxp-CL4305.m4a\r\n271$http://audio.xmcdn.com/group27/M03/A3/85/wKgJW1kEYUDzO5ZYAG_Qe5Ej4ds459.m4a\r\n272$http://audio.xmcdn.com/group27/M03/A3/86/wKgJW1kEYVCAB-4qAHJK2wquzQo011.m4a\r\n273$http://audio.xmcdn.com/group27/M03/A3/87/wKgJW1kEYWWDVHxfAHIY6xEoqR0050.m4a\r\n274$http://audio.xmcdn.com/group26/M06/A7/41/wKgJRlkEYYDS7SD1AHU_F08axp4991.m4a\r\n275$http://audio.xmcdn.com/group26/M06/A7/AF/wKgJWFkEYaTQGi9bAHC4f8Wlr30080.m4a\r\n276$http://audio.xmcdn.com/group27/M02/A3/8A/wKgJW1kEYbSDOXIBAHHvzXu8AIU501.m4a\r\n277$http://audio.xmcdn.com/group27/M02/A3/8E/wKgJW1kEYdGCCeg9AHKkbh8K5Ak755.m4a\r\n278$http://audio.xmcdn.com/group26/M0A/A7/45/wKgJRlkEYerQPI_6AHM6NWzzQas278.m4a\r\n279$http://audio.xmcdn.com/group26/M0A/A7/B2/wKgJWFkEYgjgq6NgAHLt2kFotOs528.m4a\r\n280$http://audio.xmcdn.com/group26/M0A/A7/B3/wKgJWFkEYhbQ3QHzAHMy29rXaaI697.m4a\r\n281$http://audio.xmcdn.com/group27/M00/A3/9E/wKgJR1kEYi3yhRtNAG9g455KXqE429.m4a\r\n282$http://audio.xmcdn.com/group26/M0B/A7/4C/wKgJRlkEYkiQVIyEAHNAE0pGTto786.m4a\r\n283$http://audio.xmcdn.com/group27/M01/A3/93/wKgJW1kEYmSAeYlfAHGDJNYGwT4690.m4a\r\n284$http://audio.xmcdn.com/group26/M05/A7/B9/wKgJWFkEYnnSifLkAHCcmEJo2YA005.m4a\r\n285$http://audio.xmcdn.com/group26/M05/A7/51/wKgJRlkEYo7AhYS8AHEvcD-DYdE027.m4a\r\n286$http://audio.xmcdn.com/group27/M09/A3/96/wKgJW1kEYqjAXDI3AHCuOt3NnGc420.m4a\r\n287$http://audio.xmcdn.com/group27/M0A/A3/A7/wKgJR1kEYtCiYFYVAHaeDYxaJ90211.m4a\r\n288$http://audio.xmcdn.com/group26/M03/A7/BD/wKgJWFkEYt2DVD-QAG_n-92su1U507.m4a\r\n289$http://audio.xmcdn.com/group26/M03/A7/BF/wKgJWFkEYvTjnqEyAHJg4MzyWJM964.m4a\r\n290$http://audio.xmcdn.com/group27/M0B/A3/9B/wKgJW1kEYxDBZxjdAHJg4N_rP8E607.m4a\r\n291$http://audio.xmcdn.com/group27/M0B/A3/9B/wKgJW1kEYxLSRJoJAHJg4D3IdGI563.m4a\r\n292$http://audio.xmcdn.com/group27/M08/A3/AA/wKgJR1kEYyORXFr6AHG7ady6G_Y042.m4a\r\n293$http://audio.xmcdn.com/group27/M08/A3/AC/wKgJR1kEYzmjBCD3AHEGzrhQdfI703.m4a\r\n294$http://audio.xmcdn.com/group27/M08/A3/AE/wKgJR1kEY0LwlR92AHJoQVqFGaY379.m4a\r\n295$http://audio.xmcdn.com/group26/M07/A7/C4/wKgJWFkEY2GjYINRAHJoOd5hjrI384.m4a\r\n296$http://audio.xmcdn.com/group26/M07/A7/C6/wKgJWFkEY2_DFHQWAHJ-Pt3ie5o630.m4a\r\n297$http://audio.xmcdn.com/group27/M06/A3/A4/wKgJW1kEY5qTNvDjAHC7h5erRSo213.m4a\r\n298$http://audio.xmcdn.com/group26/M09/A7/C9/wKgJWFkEY8-CPoNJAHFaBuPBQ-w575.m4a\r\n299$http://audio.xmcdn.com/group26/M09/A7/62/wKgJRlkEY96TdmC0AHNSAiUAc4k644.m4a\r\n300$http://audio.xmcdn.com/group27/M0A/A3/B7/wKgJR1kEZAWRoct-AHK3g0FjeEw510.m4a\r\n301$http://audio.xmcdn.com/group27/M04/A3/86/wKgJR1kEYFKxjTqWAHESESO-MNE536.m4a\r\n302$http://audio.xmcdn.com/group27/M02/A3/89/wKgJR1kEYHGD_6FzAG-6dqBYWM0709.m4a\r\n303$http://audio.xmcdn.com/group26/M08/A7/A0/wKgJWFkEYKOi3R1pAHNzx8mkOxA932.m4a\r\n304$http://audio.xmcdn.com/group26/M08/A7/37/wKgJRlkEYKTzuoIsAHGsQ4nTmP8979.m4a\r\n305$http://audio.xmcdn.com/group27/M05/A3/8B/wKgJR1kEYLvTbDVEAHBL1rQSFws669.m4a\r\n306$http://audio.xmcdn.com/group27/M08/A3/8F/wKgJR1kEYODRIb7kAG926G2rspY701.m4a\r\n307$http://audio.xmcdn.com/group27/M08/A3/90/wKgJR1kEYO3SXJG5AHG68joM308242.m4a\r\n308$http://audio.xmcdn.com/group26/M00/A7/3C/wKgJRlkEYRCjb5HPAHBVQP4gtbo813.m4a\r\n309$http://audio.xmcdn.com/group26/M00/A7/3E/wKgJRlkEYR-AKgOqAHEbbXeYwP0633.m4a\r\n310$http://audio.xmcdn.com/group27/M03/A3/92/wKgJR1kEYTugFHWQAHHPfxywE38050.m4a\r\n311$http://audio.xmcdn.com/group27/M03/A3/86/wKgJW1kEYVPS3ILtAHMbX4tlEiA294.m4a\r\n312$http://audio.xmcdn.com/group27/M0A/A3/96/wKgJR1kEYW3g9TENAHIiE6p8Ky0493.m4a\r\n313$http://audio.xmcdn.com/group26/M06/A7/43/wKgJRlkEYZSjEVkwAHSEmI5AMsA039.m4a\r\n314$http://audio.xmcdn.com/group27/M02/A3/96/wKgJR1kEYanxMgCRAG-Oy7uf4MU580.m4a\r\n315$http://audio.xmcdn.com/group27/M02/A3/8C/wKgJW1kEYcTzV9eIAHC7buUgvIY520.m4a\r\n316$http://audio.xmcdn.com/group27/M02/A3/90/wKgJW1kEYeXi22ZzAHQ1TpVE4ws315.m4a\r\n317$http://audio.xmcdn.com/group26/M0A/A7/B0/wKgJWFkEYe6AKCdBAHC-YdFWBpU255.m4a\r\n318$http://audio.xmcdn.com/group26/M0A/A7/48/wKgJRlkEYgiiL59FAHBH7oI_0Co909.m4a\r\n319$http://audio.xmcdn.com/group26/M0A/A7/4B/wKgJRlkEYiHR4HVSAHDmBGE_euA339.m4a\r\n320$http://audio.xmcdn.com/group26/M0B/A7/B4/wKgJWFkEYjeA8KXRAHOynTfhI-k095.m4a\r\n321$http://audio.xmcdn.com/group26/M0B/A7/4D/wKgJRlkEYlGRTe50AHEMM9nWw8s250.m4a\r\n322$http://audio.xmcdn.com/group27/M01/A3/94/wKgJW1kEYmjQ8lcIAHGqy3zk1x8424.m4a\r\n323$http://audio.xmcdn.com/group26/M05/A7/BB/wKgJWFkEYo2i-gUHAHJTqMs2O1g387.m4a\r\n324$http://audio.xmcdn.com/group27/M09/A3/95/wKgJW1kEYpyhQ0jQAHChAu09l9g116.m4a\r\n325$http://audio.xmcdn.com/group27/M09/A3/98/wKgJW1kEYrSAG1-3AHFJ35vxtgw847.m4a\r\n326$http://audio.xmcdn.com/group27/M09/A3/9A/wKgJW1kEYsjAwkR6AHKRVO_8aUo377.m4a\r\n327$http://audio.xmcdn.com/group26/M03/A7/53/wKgJRlkEYuDybP6RAG_fKomwDjs126.m4a\r\n328$http://audio.xmcdn.com/group26/M03/A7/57/wKgJRlkEYwPxB690AHC7bsGhxVY744.m4a\r\n329$http://audio.xmcdn.com/group27/M08/A3/A8/wKgJR1kEYxXgcJ6QAHRNQ0nzTpg099.m4a\r\n330$http://audio.xmcdn.com/group27/M08/A3/9D/wKgJW1kEYyLycrMZAHHYUQK3J6Q412.m4a\r\n331$http://audio.xmcdn.com/group26/M04/A7/59/wKgJRlkEY1OTXUGhAHTeh5NKuUo929.m4a\r\n332$http://audio.xmcdn.com/group27/M08/A3/AD/wKgJR1kEYzrQ8aliAHBcicHbR_o749.m4a\r\n333$http://audio.xmcdn.com/group26/M07/A7/C2/wKgJWFkEY0-itRTBAHCxl9lw8Bg144.m4a\r\n334$http://audio.xmcdn.com/group26/M04/A7/5C/wKgJRlkEY3Chnt5OAHPjVpQplBk968.m4a\r\n335$http://audio.xmcdn.com/group27/M06/A3/B0/wKgJR1kEY42Q_yLBAHBiZeU7WAA097.m4a\r\n336$http://audio.xmcdn.com/group27/M07/A3/B5/wKgJR1kEY7nw12jeAG-VvqvkKC4856.m4a\r\n337$http://audio.xmcdn.com/group26/M09/A7/62/wKgJRlkEY97gZaS7AHH4ngM3UFo606.m4a\r\n338$http://audio.xmcdn.com/group27/M0A/A3/B7/wKgJR1kEZATzZySqAG-hfsrMboE026.m4a\r\n339$http://audio.xmcdn.com/group26/M0B/A7/CF/wKgJWFkEZCeC7kdqAG8z4lijb9U403.m4a\r\n340$http://audio.xmcdn.com/group27/M04/A3/BE/wKgJR1kEZILSYf94AHX1MC9I1-o129.m4a', 'xml_8023', '7548', '', 'T', '', '1.0', 7, 0, 0, 0, 'tongtianzhilu', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(48, 23, '长生不死', '', '未知', '', '', '', '为求长生，图谋天下！    我钟山，要建立无上天朝，收集天下气运，冲刷己身业障，至此迎抗天威，开天辟地，长生不死。    一命二运三风水四积阴德五功名！    为了长生。修功名者，建立天朝收集天下气运！修积阴德者，创立圣地积攒无量功德！修风水者，更是能够沟通阴阳两界，借天地之势！修运者，……………！修命者，………………！七月初七，大昆国，宣城钟府。    钟府今日，大门广开，摆下八百桌桌宴，无论是内部，还是门外，甚至钟府大门所在的那条街，此刻，都摆满了座席，只要来贺之人，无论生熟，皆可入席。    今日，是一个重要的日子，钟府钟老爷子，今天八十大寿。    钟老爷子是个传奇的人物，白手起家，风火五十年，打出了这偌大的家业，他的一生在大昆国都好似一个神话传奇一般。    甚至，大昆国前任皇帝，都和钟老爷子把酒言欢过。    钟老爷子一生，并未入仕，是个商人，但是，在大昆国，地位却是非常超然，五十年中，钟老爷子所赚取的金钱，已经不再以斤两计算了，太多了，多到连皇帝都眼红的地步，多到比那些千年世家积攒的还多。    就连钟老爷子自己，都不清楚自己有多少钱，因为，每天从四方都有大量金钱涌入钟老爷子名下。    也许天意弄人，钟老爷子却没有一个后嗣，无儿无女，虽娶过八房妻妾，却无一人能够生养。也好似上天故意为钟老爷子的风光留下一个天大的遗憾一般。    但是，钟老爷子并未怪责妻妾，而是收了大量的义子，现在，钟老爷子的义子，已经不下于百名了。    众义子被钟老爷子传授了各种知识，维持着这偌大的家业。对于众义子，钟老爷子都非常用心，每个义子，都是练武奇才，好似当初收为义子，就是看在他们的根骨。    义子也有子女，所以，钟老爷子虽没子女，但，却是有着众多后辈。    义子多了，对于钟老爷子这份家业，也个个心中充满了一丝期望。就好像皇帝的子孙一般，谁也不是省油的灯。    今日一早开始，就有大量来贺之人，高朋满座，整个钟府，都洋溢着一种强烈的喜气。    钟府内院，一座五层高的阁楼，在钟府中好似一座宝塔一般，非常显眼。    在阁楼最高一层，一个老者，此刻正从阁楼之上看向四方来贺的宾客。    老者白发苍苍，眉毛胡须须都也发白。双眼炯炯有神，面容不怒自威，看上去充满了威严。这就是钟府的定海神针，钟山。    老者眉头微皱，好似在思量什么一般。    这时，阁楼后面，一个相貌敦厚的中年男子从楼下上来，即便老者背对着他，中年男子也是微微一鞠躬。    “义父，酒宴已经准备好了，等你开席了。”中年男子敦厚的说道。    被这一声打断，钟老爷子也回过神来，调头看向中年男子。', 'http://imagev2.xmcdn.com/group41/M09/B0/C7/wKgJ8VrRyoSCCq_eAAs_C1NMwvI763.jpg', '', 1530072142, 6, 0, 0, 0, 0, 1, 1, 4, 10, 'ting', '', '长生不死1$http://audio.xmcdn.com/group40/M07/78/08/wKgJVFrRy3iBHD7CAJ8gIjqWuqU189.m4a\r\n长生不死2$http://audio.xmcdn.com/group42/M02/B2/7D/wKgJ9FrRy6GAUBh4AHZO-EQg2zw600.m4a\r\n长生不死3$http://audio.xmcdn.com/group40/M05/77/4A/wKgJT1rRy_XDzcIRAI0UcuSPGPU883.m4a\r\n长生不死4$http://audio.xmcdn.com/group41/M00/B0/FA/wKgJ8VrRzE3wQbKIAJBfUgoENsg536.m4a\r\n长生不死5$http://audio.xmcdn.com/group40/M04/78/28/wKgJVFrRzIzx9OhCAHeR0XE1GQQ690.m4a\r\n长生不死6$http://audio.xmcdn.com/group41/M03/B1/01/wKgJ8VrRzMWA8uvYAG8tfPKyt9U037.m4a\r\n长生不死7$http://audio.xmcdn.com/group41/M02/B1/08/wKgJ8VrRzQzyVwgRAGudl_uk1iM555.m4a\r\n长生不死8$http://audio.xmcdn.com/group41/M02/B1/2D/wKgJ8lrRzT3jtEeDAGKark0Q2pU936.m4a\r\n长生不死9$http://audio.xmcdn.com/group42/M01/B2/A3/wKgJ9FrRzW2BikwQAFwH3YkiCfs250.m4a\r\n长生不死10$http://audio.xmcdn.com/group41/M01/B1/2F/wKgJ8lrRzZ6h1Oq3AFqr17eZbfo197.m4a\r\n长生不死11$http://audio.xmcdn.com/group42/M0B/AD/C9/wKgJ81rRzeezMFLkAH-ohdJnhNE209.m4a\r\n长生不死12$http://audio.xmcdn.com/group41/M0B/B1/3E/wKgJ8lrRzhfySwM1AFz0Rymgalw373.m4a\r\n长生不死13$http://audio.xmcdn.com/group42/M09/B2/C1/wKgJ9FrRzn7QS-6YAI8_gMu7Nn4002.m4a\r\n长生不死14$http://audio.xmcdn.com/group41/M08/B1/4B/wKgJ8lrRzqaQPTroAG926MkFeGU469.m4a\r\n长生不死15$http://audio.xmcdn.com/group42/M07/AD/DF/wKgJ81rRztTzUFyhAF0Os1G2meg138.m4a\r\n长生不死16$http://audio.xmcdn.com/group41/M06/B1/57/wKgJ8lrRzxejAZPLAHD0s1933Fg665.m4a\r\n长生不死17$http://audio.xmcdn.com/group42/M02/B2/D1/wKgJ9FrRz1SBHfCXAGbfNKG9RuM585.m4a\r\n长生不死18$http://audio.xmcdn.com/group41/M05/B1/60/wKgJ8lrRz5fSzPQAAH5MSV4EDrU160.m4a\r\n长生不死19$http://audio.xmcdn.com/group42/M05/B2/DF/wKgJ9FrRz9XzvHElAGCl8jObb-I881.m4a\r\n长生不死20$http://audio.xmcdn.com/group41/M03/B1/50/wKgJ8VrR0AfDXsYFAGZg6btlCv0247.m4a\r\n长生不死21$http://audio.xmcdn.com/group41/M04/B1/6D/wKgJ8lrR0DfTfZ6tAGaVyH_-v4I847.m4a\r\n长生不死22$http://audio.xmcdn.com/group40/M0B/77/BD/wKgJT1rR0F_gTY19AGN4aQ-gUj0365.m4a\r\n长生不死23$http://audio.xmcdn.com/group41/M09/B1/7A/wKgJ8lrR0Iai0oVLAFj0xs25qno791.m4a\r\n长生不死24$http://audio.xmcdn.com/group42/M03/AE/0B/wKgJ81rR0KuhklA-AF6bLUzk0do072.m4a\r\n长生不死25$http://audio.xmcdn.com/group42/M0A/B2/FA/wKgJ9FrR0NOiNfkNAG3qbpWIccU172.m4a\r\n长生不死26$http://audio.xmcdn.com/group41/M00/B1/6D/wKgJ8VrR0PmT9-KYAHOD1ziCSoI548.m4a\r\n长生不死27$http://audio.xmcdn.com/group40/M08/78/9E/wKgJVFrR0Rjghhr3AG3afVCkiDE113.m4a\r\n长生不死28$http://audio.xmcdn.com/group40/M09/78/A4/wKgJVFrR0VXSJhdcAGRnx49hfMQ779.m4a\r\n长生不死29$http://audio.xmcdn.com/group41/M0A/B1/92/wKgJ8lrR0XTAFwZdAHG8alSxssI758.m4a\r\n长生不死30$http://audio.xmcdn.com/group40/M02/77/E1/wKgJT1rR0ZbBpU4rAHQCIe9NOpg755.m4a\r\n长生不死31$http://audio.xmcdn.com/group40/M05/77/E6/wKgJT1rR0cCQ2w6ZAGtRcsdLKzs547.m4a\r\n长生不死32$http://audio.xmcdn.com/group42/M08/AE/2D/wKgJ81rR0d_BKl9ZAFx-zlTREm4584.m4a\r\n长生不死33$http://audio.xmcdn.com/group42/M09/AE/36/wKgJ81rR0gDCe0dyAF8JUdnv64E079.m4a\r\n长生不死34$http://audio.xmcdn.com/group41/M08/B1/8A/wKgJ8VrR0iTTkvQWAGai_N0DnVE367.m4a\r\n长生不死35$http://audio.xmcdn.com/group40/M01/77/F5/wKgJT1rR0kbBc7ZXAGykcbpL5V8006.m4a\r\n长生不死36$http://audio.xmcdn.com/group41/M09/B1/92/wKgJ8VrR0mHR6uWWAGS_4lZWFtA231.m4a\r\n长生不死37$http://audio.xmcdn.com/group42/M03/AE/3E/wKgJ81rR0o2TkvUcAGKjf_LoIho221.m4a\r\n长生不死38$http://audio.xmcdn.com/group40/M00/78/C7/wKgJVFrR0qPDnrZHAFyHm1FcBhI349.m4a\r\n长生不死39$http://audio.xmcdn.com/group41/M07/B1/B1/wKgJ8lrR0tThlhPTAFzuZbsbmMA081.m4a\r\n长生不死40$http://audio.xmcdn.com/group41/M07/B1/B3/wKgJ8lrR0tzx4E-rAGU_oH5QN9Q469.m4a\r\n长生不死41$http://audio.xmcdn.com/group42/M0B/B3/2F/wKgJ9FrR0wCDGC0CAHBpNdrxJ1Y202.m4a\r\n长生不死42$http://audio.xmcdn.com/group41/M07/B1/B6/wKgJ8lrR0xayeuH3AFmyNPc6bmo284.m4a\r\n长生不死43$http://audio.xmcdn.com/group41/M01/B1/A3/wKgJ8VrR0zSgyTZZAGGZtghls9E991.m4a\r\n长生不死44$http://audio.xmcdn.com/group40/M04/78/0B/wKgJT1rR01ziamQcAGqN8GbuQ2w267.m4a\r\n长生不死45$http://audio.xmcdn.com/group40/M04/78/12/wKgJT1rR03XA7endAGrFvUx0UsI820.m4a\r\n长生不死46$http://audio.xmcdn.com/group42/M02/B3/3D/wKgJ9FrR05rw3xiHAHUF0mZAFDo796.m4a\r\n长生不死47$http://audio.xmcdn.com/group42/M04/AE/5C/wKgJ81rR06ODxOFwAGdAHMqy2iY844.m4a\r\n长生不死48$http://audio.xmcdn.com/group40/M06/78/16/wKgJT1rR07WxL6RTAGmFnigLd1c869.m4a\r\n长生不死49$http://audio.xmcdn.com/group40/M09/78/20/wKgJT1rR09jR9897AGE12_e_txE023.m4a\r\n长生不死50$http://audio.xmcdn.com/group41/M02/B1/CB/wKgJ8lrR0_uDQ1ReAHW6cw2KtMA086.m4a\r\n长生不死51$http://audio.xmcdn.com/group41/M04/B0/E1/wKgJ8VrRy16gvhmgAHC_2IXcgXQ949.m4a\r\n长生不死52$http://audio.xmcdn.com/group41/M05/B0/E6/wKgJ8VrRy77AcQQzAIB-sd178QU440.m4a\r\n长生不死53$http://audio.xmcdn.com/group40/M05/78/14/wKgJVFrRy_OAxI_dAHbYyb72Fr8780.m4a\r\n长生不死54$http://audio.xmcdn.com/group42/M06/B2/8D/wKgJ9FrRzCHCEGOaAGsDaY3w8Rw022.m4a\r\n长生不死55$http://audio.xmcdn.com/group40/M03/78/1B/wKgJVFrRzF-AVjX4AGima_ByzXQ545.m4a\r\n长生不死56$http://audio.xmcdn.com/group40/M04/77/60/wKgJT1rRzJXA9V5rAGmwNDlgsNw814.m4a\r\n长生不死57$http://audio.xmcdn.com/group41/M03/B1/01/wKgJ8VrRzMXxdBT9AFy5iyYGyt0214.m4a\r\n长生不死58$http://audio.xmcdn.com/group41/M02/B1/07/wKgJ8VrRzQnyQDRaAGoxaoEqouQ419.m4a\r\n长生不死59$http://audio.xmcdn.com/group40/M0A/78/35/wKgJVFrRzUPBMW8XAGyuudQLcOs340.m4a\r\n长生不死60$http://audio.xmcdn.com/group42/M01/B2/A6/wKgJ9FrRzXiypaIQAF1-TrEvrMw257.m4a\r\n长生不死61$http://audio.xmcdn.com/group40/M02/78/44/wKgJVFrRzbqSMramAHB5W_vnxeM905.m4a\r\n长生不死62$http://audio.xmcdn.com/group41/M04/B1/20/wKgJ8VrRzfKzKOmhAGW4CT3MWy8598.m4a\r\n长生不死63$http://audio.xmcdn.com/group40/M06/77/84/wKgJT1rRzjXQfAEGAGxFAC83V3o201.m4a\r\n长生不死64$http://audio.xmcdn.com/group40/M09/78/59/wKgJVFrRzouDR1L8AJLoXv_SJKo681.m4a\r\n长生不死65$http://audio.xmcdn.com/group40/M00/78/62/wKgJVFrRzsTxsA_lAHCvsvJqssQ698.m4a\r\n长生不死66$http://audio.xmcdn.com/group41/M06/B1/38/wKgJ8VrRzv2jURRiAGmgDdXue90904.m4a\r\n长生不死67$http://audio.xmcdn.com/group40/M07/77/A1/wKgJT1rRzzaS3pnxAGuZMIVL2X8987.m4a\r\n长生不死68$http://audio.xmcdn.com/group40/M09/78/71/wKgJVFrRz32wD99PAHeTSO4FNR0550.m4a\r\n长生不死69$http://audio.xmcdn.com/group42/M05/AD/F5/wKgJ81rRz7ySnFBkAHElYe0Qa6g314.m4a\r\n长生不死70$http://audio.xmcdn.com/group41/M03/B1/65/wKgJ8lrRz_2yLHglAHVMT7njftY250.m4a\r\n长生不死71$http://audio.xmcdn.com/group41/M04/B1/53/wKgJ8VrR0DKyemZHAGePajulrOk573.m4a\r\n长生不死72$http://audio.xmcdn.com/group40/M0B/77/BF/wKgJT1rR0GTBxztRAG-RV5U0O6k253.m4a\r\n长生不死73$http://audio.xmcdn.com/group40/M0B/78/8F/wKgJVFrR0JSggoYRAGrkk351s8I063.m4a\r\n长生不死74$http://audio.xmcdn.com/group42/M07/AE/11/wKgJ81rR0L-h-OoEAHClabqz17s567.m4a\r\n长生不死75$http://audio.xmcdn.com/group41/M00/B1/65/wKgJ8VrR0OHzbHagAGs5u9LNIxo057.m4a\r\n长生不死76$http://audio.xmcdn.com/group41/M00/B1/86/wKgJ8lrR0P-wMpQ9AGmEXRfDbTQ645.m4a\r\n长生不死77$http://audio.xmcdn.com/group42/M01/B2/FF/wKgJ9FrR0S6AV2z7AHJuF4HC6TI917.m4a\r\n长生不死78$http://audio.xmcdn.com/group42/M09/AE/22/wKgJ81rR0UrjUyfZAGs8runXy_M051.m4a\r\n长生不死79$http://audio.xmcdn.com/group41/M0A/B1/91/wKgJ8lrR0XHyOBrPAGXogSiC4jo102.m4a\r\n长生不死80$http://audio.xmcdn.com/group40/M02/78/A9/wKgJVFrR0ZOzsrq6AGUB9DpKh_I796.m4a\r\n长生不死81$http://audio.xmcdn.com/group40/M05/78/B1/wKgJVFrR0cmCeVGlAHaj629xhs0582.m4a\r\n长生不死82$http://audio.xmcdn.com/group42/M08/B3/11/wKgJ9FrR0eWQ-W1KAGe4u0kcgz0674.m4a\r\n长生不死83$http://audio.xmcdn.com/group41/M08/B1/84/wKgJ8VrR0g-Cq-h4AG0ITC7ihUw030.m4a\r\n长生不死84$http://audio.xmcdn.com/group40/M01/77/F0/wKgJT1rR0jTBb9ceAGXCUagkdmY650.m4a\r\n长生不死85$http://audio.xmcdn.com/group40/M01/77/F7/wKgJT1rR0kuTdebMAFv8HZcL5eg024.m4a\r\n长生不死86$http://audio.xmcdn.com/group42/M03/B3/1B/wKgJ9FrR0mij6h-VAFY4VIUlits871.m4a\r\n长生不死87$http://audio.xmcdn.com/group42/M05/B3/24/wKgJ9FrR0pORRqC2AGR1MVF5jeY584.m4a\r\n长生不死88$http://audio.xmcdn.com/group40/M00/78/CC/wKgJVFrR0rXSrwviAGY03H4SJxA410.m4a\r\n长生不死89$http://audio.xmcdn.com/group41/M07/B1/98/wKgJ8VrR0tnh-59SAGaM90D6AKY109.m4a\r\n长生不死90$http://audio.xmcdn.com/group42/M0B/B3/2D/wKgJ9FrR0vjQ3KUbAGlbCEo79uI268.m4a\r\n长生不死91$http://audio.xmcdn.com/group41/M01/B1/9E/wKgJ8VrR0yHzNU4PAHYMrJC4Oiw429.m4a\r\n长生不死92$http://audio.xmcdn.com/group41/M01/B1/A2/wKgJ8VrR0zCjeKEoAGm2SHPTVOw732.m4a\r\n长生不死93$http://audio.xmcdn.com/group41/M01/B1/AC/wKgJ8VrR01KTrRrCAGtjEDV335c249.m4a\r\n长生不死94$http://audio.xmcdn.com/group42/M02/B3/3A/wKgJ9FrR05DS3FSMAJnNbDCLGY8443.m4a\r\n长生不死95$http://audio.xmcdn.com/group40/M06/78/DE/wKgJVFrR07Di03R5AHgaYAKguFY373.m4a\r\n长生不死96$http://audio.xmcdn.com/group40/M09/78/19/wKgJT1rR077j9_yBAHt8wHLglm0702.m4a\r\n长生不死97$http://audio.xmcdn.com/group40/M09/78/1F/wKgJT1rR09iy4CbsAHbpJvBKsqc484.m4a\r\n长生不死98$http://audio.xmcdn.com/group41/M02/B1/B0/wKgJ8VrR0_mi_K8kAHigNvn0Tnc541.m4a\r\n长生不死99$http://audio.xmcdn.com/group42/M00/B3/41/wKgJ9FrR1Ayh_aUjAHK4-21YDEE076.m4a\r\n长生不死100$http://audio.xmcdn.com/group42/M00/AE/68/wKgJ81rR1C7TQXtyAHqX4Ws7hdU249.m4a\r\n长生不死101$http://audio.xmcdn.com/group40/M04/79/61/wKgJVFrR2M-zJUzpAH0rAMPn93I526.m4a\r\n长生不死102$http://audio.xmcdn.com/group41/M05/B2/31/wKgJ8VrR2RGTqGZ0AHjU31Oxhzs660.m4a\r\n长生不死103$http://audio.xmcdn.com/group42/M06/AE/E7/wKgJ81rR2V2wo6oiAHWdFRLM4ow894.m4a\r\n长生不死104$http://audio.xmcdn.com/group40/M01/78/AE/wKgJT1rR2cLRHoGeAJoOC9jUP-w860.m4a\r\n长生不死105$http://audio.xmcdn.com/group40/M06/78/B5/wKgJT1rR2gKDFSjEAHPCxP6p1vY528.m4a\r\n长生不死106$http://audio.xmcdn.com/group41/M0B/B2/56/wKgJ8VrR2k-TIaWjAHLTauaobro830.m4a\r\n长生不死107$http://audio.xmcdn.com/group40/M07/78/C9/wKgJT1rR2q2i9XkyAJ-eoiyuqbI775.m4a\r\n长生不死108$http://audio.xmcdn.com/group40/M0B/79/9A/wKgJVFrR2u6zwejvAHJoOeNp2cw942.m4a\r\n长生不死109$http://audio.xmcdn.com/group40/M0B/79/A2/wKgJVFrR2zTSTagDAHHZyHK2_Y4712.m4a\r\n长生不死110$http://audio.xmcdn.com/group40/M0A/79/AE/wKgJVFrR25mRLw3bAJqMUTyAPFw050.m4a\r\n长生不死111$http://audio.xmcdn.com/group42/M00/B4/0C/wKgJ9FrR29qhxZwqAHJDgcdp1I4744.m4a\r\n长生不死112$http://audio.xmcdn.com/group42/M08/B4/16/wKgJ9FrR3Buy0f-sAG8UiFXA_OA250.m4a\r\n长生不死113$http://audio.xmcdn.com/group40/M02/78/F7/wKgJT1rR3FyQ1cR2AG3ND-2E0vo747.m4a\r\n长生不死114$http://audio.xmcdn.com/group42/M01/AF/4A/wKgJ81rR3KrAFZ-0AHQmn4Mr0wU009.m4a\r\n长生不死115$http://audio.xmcdn.com/group41/M0A/B2/9B/wKgJ8VrR3OWjy2wxAGvSdfNcvwI829.m4a\r\n长生不死116$http://audio.xmcdn.com/group42/M07/B4/32/wKgJ9FrR3SbionamAGmYtE8o5i4967.m4a\r\n长生不死117$http://audio.xmcdn.com/group40/M04/79/D4/wKgJVFrR3WyySDhzAHFUKPFGe2g119.m4a\r\n长生不死118$http://audio.xmcdn.com/group40/M08/79/1C/wKgJT1rR3brC3Rg8AHeJAOqiw7c790.m4a\r\n长生不死119$http://audio.xmcdn.com/group41/M05/B2/D2/wKgJ8lrR3fyiVMCuAHVuFNLjrDY349.m4a\r\n长生不死120$http://audio.xmcdn.com/group42/M0B/B4/4A/wKgJ9FrR3kPzA8QVAHO1jH0Bryg572.m4a\r\n长生不死121$http://audio.xmcdn.com/group41/M0B/B2/DF/wKgJ8lrR3pXyGRG5AIJNQRozHj8712.m4a\r\n长生不死122$http://audio.xmcdn.com/group42/M09/AF/7A/wKgJ81rR3uTj_Xg5AHkeS2UIubI414.m4a\r\n长生不死123$http://audio.xmcdn.com/group40/M03/7A/0A/wKgJVFrR3yOjdcSXAHCN6V32b98731.m4a\r\n长生不死124$http://audio.xmcdn.com/group41/M02/B2/F2/wKgJ8lrR32yDNLRSAG7ScoALMas583.m4a\r\n长生不死125$http://audio.xmcdn.com/group42/M08/AF/91/wKgJ81rR37GxUMCCAHPjEaJk6Pc233.m4a\r\n长生不死126$http://audio.xmcdn.com/group41/M08/B2/E8/wKgJ8VrR3-rzhhKfAGdKZb0KJRg537.m4a\r\n长生不死127$http://audio.xmcdn.com/group42/M02/B4/7D/wKgJ9FrR4CqRcKucAGiQYjM7ZaU373.m4a\r\n长生不死128$http://audio.xmcdn.com/group40/M05/79/5E/wKgJT1rR4H3QUmLuAHKkbmpLqAY743.m4a\r\n长生不死129$http://audio.xmcdn.com/group42/M01/B4/91/wKgJ9FrR4MCgj-U0AHfyudLZM-M710.m4a\r\n长生不死130$http://audio.xmcdn.com/group40/M06/79/71/wKgJT1rR4QbgOB0XAHWr-hdfvZU045.m4a\r\n长生不死131$http://audio.xmcdn.com/group41/M0A/B3/12/wKgJ8VrR4VTABHtmAH0AaTYHo34234.m4a\r\n长生不死132$http://audio.xmcdn.com/group42/M08/AF/BF/wKgJ81rR4ZfycSRdAHOeEMrT4VY360.m4a\r\n长生不死133$http://audio.xmcdn.com/group40/M01/7A/58/wKgJVFrR4efDrIGqAHiurzuM9Ps825.m4a\r\n长生不死134$http://audio.xmcdn.com/group41/M04/B3/42/wKgJ8lrR4jizh2k4AHo_kKz5k0o103.m4a\r\n长生不死135$http://audio.xmcdn.com/group42/M0A/B4/BB/wKgJ9FrR4nOS2ZHjAHKUR4ZQ7FA467.m4a\r\n长生不死136$http://audio.xmcdn.com/group41/M01/B3/52/wKgJ8lrR4r2SdMqDAH3Zvv4otlU533.m4a\r\n长生不死137$http://audio.xmcdn.com/group41/M07/B3/40/wKgJ8VrR4wfDQf9VAHRy-vGfyEA255.m4a\r\n长生不死138$http://audio.xmcdn.com/group40/M08/7A/7A/wKgJVFrR406TUnrSAHzaPuA7GcQ453.m4a\r\n长生不死139$http://audio.xmcdn.com/group42/M01/AF/FC/wKgJ81rR45WCKZWoAHruT9MT-DQ075.m4a\r\n长生不死140$http://audio.xmcdn.com/group40/M02/7A/8D/wKgJVFrR493iP5wDAHoB5BDBlzE858.m4a\r\n长生不死141$http://audio.xmcdn.com/group41/M08/B3/63/wKgJ8VrR5Cjh_KPfAHTVXmF0dok770.m4a\r\n长生不死142$http://audio.xmcdn.com/group40/M0B/79/D8/wKgJT1rR5HfQ8PvyAH33HfToAho374.m4a\r\n长生不死143$http://audio.xmcdn.com/group42/M02/B0/14/wKgJ81rR5MDiDLmMAHfxQUkbXTw172.m4a\r\n长生不死144$http://audio.xmcdn.com/group41/M00/B3/7C/wKgJ8VrR5QqR_m9QAHaxIknQAyE396.m4a\r\n长生不死145$http://audio.xmcdn.com/group42/M08/B0/27/wKgJ81rR5VrTXBCMAHaDncmKzJQ881.m4a\r\n长生不死146$http://audio.xmcdn.com/group41/M02/B3/AC/wKgJ8lrR5Z2gOv3-AG1Upxy14vU018.m4a\r\n长生不死147$http://audio.xmcdn.com/group40/M05/7A/C6/wKgJVFrR5eGDCkYgAHFrpDffrvQ839.m4a\r\n长生不死148$http://audio.xmcdn.com/group41/M01/B3/BC/wKgJ8lrR5j_jpxOLAHMkLFJhe_0020.m4a\r\n长生不死149$http://audio.xmcdn.com/group41/M07/B3/AB/wKgJ8VrR5n7RAv46AHcoEwEv2Do642.m4a\r\n长生不死150$http://audio.xmcdn.com/group42/M08/B5/38/wKgJ9FrR5saRgb0GAHHp76ddW6E284.m4a\r\n长生不死151$http://audio.xmcdn.com/group42/M01/AE/DE/wKgJ81rR2PWDN7CwAHWdFUDrVkM553.m4a\r\n长生不死152$http://audio.xmcdn.com/group40/M03/79/67/wKgJVFrR2TewzGaSAHRhXKMJ99g404.m4a\r\n长生不死153$http://audio.xmcdn.com/group42/M07/AE/EC/wKgJ81rR2W2DKFq3AG6w4_NWCIA233.m4a\r\n长生不死154$http://audio.xmcdn.com/group40/M01/78/AB/wKgJT1rR2biQMJUUAHEZaxhH_1Q866.m4a\r\n长生不死155$http://audio.xmcdn.com/group42/M08/AE/F8/wKgJ81rR2faQK6TXAG6O6LcqeEQ653.m4a\r\n长生不死156$http://audio.xmcdn.com/group40/M00/79/8D/wKgJVFrR2kCAdSH6AHMc1hEtZDw304.m4a\r\n长生不死157$http://audio.xmcdn.com/group41/M02/B2/5E/wKgJ8VrR2pnC_XM_AHn9fopbsao792.m4a\r\n长生不死158$http://audio.xmcdn.com/group42/M05/AF/10/wKgJ81rR2uDDDdi1AHlL0NQgbkk916.m4a\r\n长生不死159$http://audio.xmcdn.com/group40/M0B/79/A0/wKgJVFrR2y3xiX4AAH2lGufrXvI874.m4a\r\n长生不死160$http://audio.xmcdn.com/group40/M06/78/DC/wKgJT1rR22-zdVT1AHX_dH6AKKI918.m4a\r\n长生不死161$http://audio.xmcdn.com/group41/M00/B2/95/wKgJ8lrR27rxVR-nAHQKuMMdZc4277.m4a\r\n长生不死162$http://audio.xmcdn.com/group41/M07/B2/83/wKgJ8VrR2_XBTxehAGmuvQ32drA363.m4a\r\n长生不死163$http://audio.xmcdn.com/group40/M02/78/EF/wKgJT1rR3D-QiKXbAHNXk1kiMto964.m4a\r\n长生不死164$http://audio.xmcdn.com/group42/M09/B4/21/wKgJ9FrR3IfjHLa7AHBqrI5KUX4761.m4a\r\n长生不死165$http://audio.xmcdn.com/group40/M05/79/C3/wKgJVFrR3MPzoO97AGx7Up5GOU8641.m4a\r\n长生不死166$http://audio.xmcdn.com/group40/M09/79/CF/wKgJVFrR3QrhhJLsAG9521mck3g527.m4a\r\n长生不死167$http://audio.xmcdn.com/group41/M09/B2/BD/wKgJ8lrR3Uyiy0FJAH4u6gPdW7s759.m4a\r\n长生不死168$http://audio.xmcdn.com/group42/M00/AF/5A/wKgJ81rR3ZXzl0mEAHlF7pXlkUw108.m4a\r\n长生不死169$http://audio.xmcdn.com/group41/M01/B2/CD/wKgJ8lrR3djyD7w4AHzNBmurIGQ634.m4a\r\n长生不死170$http://audio.xmcdn.com/group42/M0B/AF/6B/wKgJ81rR3k-iksa0AIMmlrPNTGE161.m4a\r\n长生不死171$http://audio.xmcdn.com/group42/M02/B4/53/wKgJ9FrR3ouz9U4EAHOWtuay97E680.m4a\r\n长生不死172$http://audio.xmcdn.com/group41/M0B/B2/E6/wKgJ8lrR3rWD58oMAH_5ED15aN0621.m4a\r\n长生不死173$http://audio.xmcdn.com/group42/M09/AF/80/wKgJ81rR3wSBc0c6AIGuqYauqMk939.m4a\r\n长生不死174$http://audio.xmcdn.com/group42/M04/AF/8A/wKgJ81rR31DQKwMiAHvHpOKeugA693.m4a\r\n长生不死175$http://audio.xmcdn.com/group40/M01/7A/0F/wKgJVFrR35bgTYgYAHpqXPsT5qM081.m4a\r\n长生不死176$http://audio.xmcdn.com/group40/M07/7A/17/wKgJVFrR39yhbQ3SAHe2hShbHqY623.m4a\r\n长生不死177$http://audio.xmcdn.com/group42/M02/B4/7B/wKgJ9FrR4CKQuUKsAH9_MC4xcyI661.m4a\r\n长生不死178$http://audio.xmcdn.com/group41/M00/B3/12/wKgJ8lrR4GeBKa6wAHUNLGnCric634.m4a\r\n长生不死179$http://audio.xmcdn.com/group42/M0A/AF/AB/wKgJ81rR4LTCePlYAH-ffuiBwvo299.m4a\r\n长生不死180$http://audio.xmcdn.com/group40/M09/7A/38/wKgJVFrR4QCx2-Q6AH3G30Mty5M927.m4a\r\n长生不死181$http://audio.xmcdn.com/group41/M0A/B3/10/wKgJ8VrR4U6D1rh0AH-ffi_cLMA480.m4a\r\n长生不死182$http://audio.xmcdn.com/group42/M08/AF/BC/wKgJ81rR4Y6g8fDWAHjztRe3N6g928.m4a\r\n长生不死183$http://audio.xmcdn.com/group40/M01/79/8B/wKgJT1rR4dbCN7F-AHTiltk0_Pw097.m4a\r\n长生不死184$http://audio.xmcdn.com/group41/M03/B3/22/wKgJ8VrR4hujyNegAH5iTppg8j8979.m4a\r\n长生不死185$http://audio.xmcdn.com/group42/M07/AF/D7/wKgJ81rR4m2B4q3QAH1rnoPz_24767.m4a\r\n长生不死186$http://audio.xmcdn.com/group40/M0A/79/9D/wKgJT1rR4rKROGUZAH7R6RmVWyU420.m4a\r\n长生不死187$http://audio.xmcdn.com/group42/M03/AF/EB/wKgJ81rR4wCjhP6qAIYX5D-PuBY417.m4a\r\n长生不死188$http://audio.xmcdn.com/group40/M08/79/B3/wKgJT1rR41KTPjWWAIqzCmZV7jw892.m4a\r\n长生不死189$http://audio.xmcdn.com/group41/M06/B3/6C/wKgJ8lrR46TSdA62AIiZmbalBA8938.m4a\r\n长生不死190$http://audio.xmcdn.com/group42/M04/B0/02/wKgJ81rR4_aQ-EuuAIAa1bULjRI779.m4a\r\n长生不死191$http://audio.xmcdn.com/group40/M09/7A/94/wKgJVFrR5Efz_l-bAIUFSW4XbWw338.m4a\r\n长生不死192$http://audio.xmcdn.com/group41/M05/B3/6B/wKgJ8VrR5J2gvzlIAIqzQMTucKU061.m4a\r\n长生不死193$http://audio.xmcdn.com/group41/M00/B3/77/wKgJ8VrR5PGjjSQeAIYEzoAWMsE159.m4a\r\n长生不死194$http://audio.xmcdn.com/group40/M06/7A/B3/wKgJVFrR5Trx2TZ7AJAaTUwr7Jg346.m4a\r\n长生不死195$http://audio.xmcdn.com/group41/M02/B3/AB/wKgJ8lrR5ZmQFu_2AJDdnQaX2-I333.m4a\r\n长生不死196$http://audio.xmcdn.com/group40/M05/7A/05/wKgJT1rR5ffylXtNAJbHkeZDvU0526.m4a\r\n长生不死197$http://audio.xmcdn.com/group41/M01/B3/A2/wKgJ8VrR5kTRsvZIAI23cWHLbb0526.m4a\r\n长生不死198$http://audio.xmcdn.com/group40/M04/7A/0E/wKgJT1rR5pLSXxZIAIhAOdMMlmA555.m4a\r\n长生不死199$http://audio.xmcdn.com/group41/M04/B3/D6/wKgJ8lrR5vyCLIS6AJMNFkv2wOI840.m4a\r\n长生不死200$http://audio.xmcdn.com/group42/M06/B5/4A/wKgJ9FrR50WhQ5ocAIzQ5Oy8XZ0716.m4a\r\n长生不死201$http://audio.xmcdn.com/group42/M01/AE/E2/wKgJ81rR2QDgpzY3AH5DeJh70tA369.m4a\r\n长生不死202$http://audio.xmcdn.com/group40/M03/78/A6/wKgJT1rR2VGDj7TZAIyZj3LWG4U836.m4a\r\n长生不死203$http://audio.xmcdn.com/group40/M01/79/73/wKgJVFrR2a-jXKsoAITvRd43JSA340.m4a\r\n长生不死204$http://audio.xmcdn.com/group40/M06/78/B2/wKgJT1rR2fzDinOpAI-mS0KNTkg596.m4a\r\n长生不死205$http://audio.xmcdn.com/group40/M00/79/8E/wKgJVFrR2kXB5eYlAIv6fhtAry8530.m4a\r\n长生不死206$http://audio.xmcdn.com/group40/M07/78/CB/wKgJT1rR2rKS4_LIAJMu26NOiD8180.m4a\r\n长生不死207$http://audio.xmcdn.com/group41/M01/B2/82/wKgJ8lrR2vqR_nIQAIp21T80PAE598.m4a\r\n长生不死208$http://audio.xmcdn.com/group41/M03/B2/91/wKgJ8lrR206wwc9LAIRvgkbE92Q312.m4a\r\n长生不死209$http://audio.xmcdn.com/group40/M0A/79/B2/wKgJVFrR26WjTpvZAI6j2-sSKEQ272.m4a\r\n长生不死210$http://audio.xmcdn.com/group42/M03/B4/11/wKgJ9FrR3Ayzz0rcAIVUl6dhN4g610.m4a\r\n长生不死211$http://audio.xmcdn.com/group40/M02/78/F2/wKgJT1rR3EqA0B0NAH0GTG33DCE317.m4a\r\n长生不死212$http://audio.xmcdn.com/group42/M01/AF/46/wKgJ81rR3J7R1BgMAIVtiwxUOwI941.m4a\r\n长生不死213$http://audio.xmcdn.com/group41/M0A/B2/9D/wKgJ8VrR3O-wzNWDAI246Gefk_A008.m4a\r\n长生不死214$http://audio.xmcdn.com/group42/M0A/AF/56/wKgJ81rR3T2j3iXLAIseOuYMUVk463.m4a\r\n长生不死215$http://audio.xmcdn.com/group40/M04/79/DA/wKgJVFrR3YHi_4IqAHVmvijeb14030.m4a\r\n长生不死216$http://audio.xmcdn.com/group41/M01/B2/AE/wKgJ8VrR3dXAOUSYAIWJcigTWXI915.m4a\r\n长生不死217$http://audio.xmcdn.com/group42/M0B/B4/47/wKgJ9FrR3imyx3a_AIPWzFzFpTw860.m4a\r\n长生不死218$http://audio.xmcdn.com/group40/M0B/79/31/wKgJT1rR3nWxJ177AIJHX1vVJYY555.m4a\r\n长生不死219$http://audio.xmcdn.com/group41/M0B/B2/E9/wKgJ8lrR3sPABrr_AH-ffj0nmfg728.m4a\r\n长生不死220$http://audio.xmcdn.com/group40/M03/7A/09/wKgJVFrR3yKBTYSHAIhhzHcyWSw578.m4a\r\n长生不死221$http://audio.xmcdn.com/group41/M02/B2/D8/wKgJ8VrR33HAITrVAIXELwU7Law818.m4a\r\n长生不死222$http://audio.xmcdn.com/group42/M00/B4/75/wKgJ9FrR38ay1GGSAIzfycvOVrM996.m4a\r\n长生不死223$http://audio.xmcdn.com/group40/M00/7A/21/wKgJVFrR4Bigp6fdAIacQjQ-SLA174.m4a\r\n长生不死224$http://audio.xmcdn.com/group40/M05/7A/29/wKgJVFrR4IfDXGwRAIIA5iOg3sY973.m4a\r\n长生不死225$http://audio.xmcdn.com/group41/M03/B3/19/wKgJ8lrR4K2C5iukAHoNpUyKgzU977.m4a\r\n长生不死226$http://audio.xmcdn.com/group40/M09/7A/38/wKgJVFrR4P_w285qAIi0BWDiLRA157.m4a\r\n长生不死227$http://audio.xmcdn.com/group41/M0A/B3/30/wKgJ8lrR4Vuwvy8uAJV-odIN6UE819.m4a\r\n长生不死228$http://audio.xmcdn.com/group42/M08/B4/AB/wKgJ9FrR4bXgTCtrAIwR__unpNo694.m4a\r\n长生不死229$http://audio.xmcdn.com/group40/M01/7A/61/wKgJVFrR4gKDp2JNAIYlG3cgC2s059.m4a\r\n长生不死230$http://audio.xmcdn.com/group42/M07/AF/D4/wKgJ81rR4mKTVOD4AINiyo8bH14665.m4a\r\n长生不死231$http://audio.xmcdn.com/group42/M0B/AF/E4/wKgJ81rR4qCz1DzTAIJ9tfb3vOI912.m4a\r\n长生不死232$http://audio.xmcdn.com/group40/M0A/7A/6F/wKgJVFrR4ufyTR9nAIB40xN3EPQ928.m4a\r\n长生不死233$http://audio.xmcdn.com/group41/M09/B3/43/wKgJ8VrR4zWyx419AH_jDJUNWdU356.m4a\r\n长生不死234$http://audio.xmcdn.com/group41/M09/B3/66/wKgJ8lrR43vQFe-sAHtvicu-qPM739.m4a\r\n长生不死235$http://audio.xmcdn.com/group40/M02/7A/8B/wKgJVFrR49iz8QBtAI0LoZn0n18055.m4a\r\n长生不死236$http://audio.xmcdn.com/group41/M08/B3/7F/wKgJ8lrR5CXSolRcAI5b5xG6STM217.m4a\r\n长生不死237$http://audio.xmcdn.com/group40/M0B/7A/A7/wKgJVFrR5InRec6rAJJqF-EXB44025.m4a\r\n长生不死238$http://audio.xmcdn.com/group41/M07/B3/72/wKgJ8VrR5OPxGyC4AJ5xY5-hYb0010.m4a\r\n长生不死239$http://audio.xmcdn.com/group40/M06/7A/B4/wKgJVFrR5T6iekarAJiOyF52N7E495.m4a\r\n长生不死240$http://audio.xmcdn.com/group40/M07/7A/BD/wKgJVFrR5YSyQjolAHxjTac0-BQ029.m4a\r\n长生不死241$http://audio.xmcdn.com/group40/M05/7A/C5/wKgJVFrR5d6xzG0lAIl3VcziRSw770.m4a\r\n长生不死242$http://audio.xmcdn.com/group41/M01/B3/9B/wKgJ8VrR5jGRt4vwAI_lqHC7G8A825.m4a\r\n长生不死243$http://audio.xmcdn.com/group41/M07/B3/CB/wKgJ8lrR5o6yBW1EAJoMkzmEhzE166.m4a\r\n长生不死244$http://audio.xmcdn.com/group41/M04/B3/B9/wKgJ8VrR5vahRXYlAKIOgKq8YfY057.m4a\r\n长生不死245$http://audio.xmcdn.com/group42/M06/B5/46/wKgJ9FrR5zjSE3xLAIDxOyP3URg704.m4a\r\n长生不死246$http://audio.xmcdn.com/group40/M00/7A/28/wKgJT1rR54ujTzVDAIMZXt3T-Pw519.m4a\r\n长生不死247$http://audio.xmcdn.com/group40/M03/7B/00/wKgJVFrR59qC-1RbAIcBXxcqYIA299.m4a\r\n长生不死248$http://audio.xmcdn.com/group41/M03/B3/DC/wKgJ8VrR6C6zG7IoAJL7d_j9NTw727.m4a\r\n长生不死249$http://audio.xmcdn.com/group40/M03/7B/0E/wKgJVFrR6HCget9eAIRd5O3mCc0535.m4a\r\n长生不死250$http://audio.xmcdn.com/group42/M00/B0/8C/wKgJ81rR6KvQgVxTAIdm6Hc99NI025.m4a\r\n长生不死251$http://audio.xmcdn.com/group41/M05/B2/51/wKgJ8lrR2SHQT2dQAIjhikOldGA796.m4a\r\n长生不死252$http://audio.xmcdn.com/group42/M07/AE/EA/wKgJ81rR2Wjzep97AIKYJY1mp38204.m4a\r\n长生不死253$http://audio.xmcdn.com/group40/M01/78/AF/wKgJT1rR2cPxqpfnAJExTYGyeFc720.m4a\r\n长生不死254$http://audio.xmcdn.com/group40/M06/79/81/wKgJVFrR2geBidshAH1Yha1w87Y144.m4a\r\n长生不死255$http://audio.xmcdn.com/group42/M02/AE/FF/wKgJ81rR2mSTdZ4OAInPcG8hbX8949.m4a\r\n长生不死256$http://audio.xmcdn.com/group40/M07/78/CA/wKgJT1rR2q6iBAGTAIZZ9u0F3o4939.m4a\r\n长生不死257$http://audio.xmcdn.com/group41/M01/B2/6A/wKgJ8VrR2wjBTm6uAIekXoGPwWI967.m4a\r\n长生不死258$http://audio.xmcdn.com/group42/M04/AF/1B/wKgJ81rR21HztYEBAIJ_LTtFxnM590.m4a\r\n长生不死259$http://audio.xmcdn.com/group40/M0A/79/B0/wKgJVFrR256x_7rWAIQbzsJwwmk264.m4a\r\n长生不死260$http://audio.xmcdn.com/group41/M07/B2/A1/wKgJ8lrR2_TB6u9eAIgT9YJLu3k821.m4a\r\n长生不死261$http://audio.xmcdn.com/group40/M02/79/B8/wKgJVFrR3EDgJ2YnAIQ9l0Fua_Q754.m4a\r\n长生不死262$http://audio.xmcdn.com/group42/M09/B4/23/wKgJ9FrR3I2hF6rVAH9da9vFUlo584.m4a\r\n长生不死263$http://audio.xmcdn.com/group40/M05/78/FF/wKgJT1rR3NqSGh82AIYzypZY1fk399.m4a\r\n长生不死264$http://audio.xmcdn.com/group42/M07/B4/30/wKgJ9FrR3SKQH7n4AH7n8t6rVlg339.m4a\r\n长生不死265$http://audio.xmcdn.com/group40/M04/79/0C/wKgJT1rR3XORB5HPAI4T8ktZHas300.m4a\r\n长生不死266$http://audio.xmcdn.com/group40/M08/79/E8/wKgJVFrR3cfBeFKqAIk8mC-dKHo860.m4a\r\n长生不死267$http://audio.xmcdn.com/group41/M05/B2/DB/wKgJ8lrR3huCoaxpAIxJzHXHBsU867.m4a\r\n长生不死268$http://audio.xmcdn.com/group40/M0B/79/2E/wKgJT1rR3mqRHhf6AIuoRZOzFRA790.m4a\r\n长生不死269$http://audio.xmcdn.com/group41/M0B/B2/CB/wKgJ8VrR3rqik0HXAIRycrtQ5aA362.m4a\r\n长生不死270$http://audio.xmcdn.com/group40/M03/79/3C/wKgJT1rR3xKDNh1DAIwsbp4QhCY517.m4a\r\n长生不死271$http://audio.xmcdn.com/group41/M02/B2/D4/wKgJ8VrR32bwxJO9AJRBddI4yoQ487.m4a\r\n长生不死272$http://audio.xmcdn.com/group42/M08/AF/90/wKgJ81rR363iIDm_AITO8yi4Z8k084.m4a\r\n长生不死273$http://audio.xmcdn.com/group41/M08/B3/08/wKgJ8lrR3_bREfI6AHvWiTp3MNU339.m4a\r\n长生不死274$http://audio.xmcdn.com/group42/M02/B4/83/wKgJ9FrR4EHxRF3oAH78f3i3tWk684.m4a\r\n长生不死275$http://audio.xmcdn.com/group40/M05/7A/2B/wKgJVFrR4I2i2BolAHrGrGZEK24731.m4a\r\n长生不死276$http://audio.xmcdn.com/group41/M06/B3/1D/wKgJ8lrR4NnC5lZQAHkbWDANR_o142.m4a\r\n长生不死277$http://audio.xmcdn.com/group42/M03/AF/B7/wKgJ81rR4TDyyH3SAIql0h52FFI297.m4a\r\n长生不死278$http://audio.xmcdn.com/group42/M09/AF/C1/wKgJ81rR4Z2RrGHQAIr8dZIa23s042.m4a\r\n长生不死279$http://audio.xmcdn.com/group40/M07/79/85/wKgJT1rR4cbws2Q7AH5Tnk8vwGc062.m4a\r\n长生不死280$http://audio.xmcdn.com/group41/M03/B3/20/wKgJ8VrR4hXim1Y3AIAdyEMxCy4619.m4a\r\n长生不死281$http://audio.xmcdn.com/group42/M07/AF/D7/wKgJ81rR4mvhFxEIAIoeur6jSfI015.m4a\r\n长生不死282$http://audio.xmcdn.com/group41/M01/B3/3A/wKgJ8VrR4sShERLJAIE6p25BHNQ747.m4a\r\n长生不死283$http://audio.xmcdn.com/group42/M06/B4/CC/wKgJ9FrR4wCRrytKAHOIB9JgcBc314.m4a\r\n长生不死284$http://audio.xmcdn.com/group40/M08/79/B4/wKgJT1rR41XxksMFAIohqcdZj44324.m4a\r\n长生不死285$http://audio.xmcdn.com/group41/M06/B3/54/wKgJ8VrR462QTwJuAIboZ1EcuU8736.m4a\r\n长生不死286$http://audio.xmcdn.com/group42/M04/B0/04/wKgJ81rR4_3AxJYRAJFF333vgws104.m4a\r\n长生不死287$http://audio.xmcdn.com/group40/M09/79/CC/wKgJT1rR5EmhK8XtAIMEzaiaB18186.m4a\r\n长生不死288$http://audio.xmcdn.com/group40/M0B/79/E4/wKgJT1rR5JWD44-xAIK2-53S6r0532.m4a\r\n长生不死289$http://audio.xmcdn.com/group42/M02/B0/1E/wKgJ81rR5N7DAynNAHy_z-R2oNA713.m4a\r\n长生不死290$http://audio.xmcdn.com/group40/M06/79/E8/wKgJT1rR5TTxBFAOAIskHXTH1QE530.m4a\r\n长生不死291$http://audio.xmcdn.com/group41/M02/B3/8D/wKgJ8VrR5ZbSudTZAIVY_j_ZAcs768.m4a\r\n长生不死292$http://audio.xmcdn.com/group41/M03/B3/B2/wKgJ8lrR5c7R_IDJAIanzKAJmYY228.m4a\r\n长生不死293$http://audio.xmcdn.com/group41/M01/B3/A4/wKgJ8VrR5kmQfELXALZ1uuPZRxk469.m4a\r\n长生不死294$http://audio.xmcdn.com/group41/M07/B3/CB/wKgJ8lrR5oyxwIqRAH7KlBHHbrQ648.m4a\r\n长生不死295$http://audio.xmcdn.com/group41/M04/B3/CC/wKgJ8lrR5uHAJtdiAIm2eOc3BXY295.m4a\r\n长生不死296$http://audio.xmcdn.com/group42/M06/B5/42/wKgJ9FrR5yzx3uB6AIY_ixUE-5k760.m4a\r\n长生不死297$http://audio.xmcdn.com/group40/M00/7A/F2/wKgJVFrR54bxhiatAJNcYEeGPNk520.m4a\r\n长生不死298$http://audio.xmcdn.com/group42/M02/B5/5C/wKgJ9FrR586gLitSAJcCTlIexdc317.m4a\r\n长生不死299$http://audio.xmcdn.com/group40/M08/7B/0C/wKgJVFrR6Bbh_hnFAItNO-iEuTQ200.m4a\r\n长生不死300$http://audio.xmcdn.com/group41/M0B/B3/E8/wKgJ8VrR6GLCnlEnAIoS-pKqRWk777.m4a\r\n长生不死301$http://audio.xmcdn.com/group42/M04/B5/9D/wKgJ9FrR6h_AFhHUAJTxq--qxec195.m4a\r\n长生不死302$http://audio.xmcdn.com/group42/M04/B5/9D/wKgJ9FrR6iGBBKmRAJYjG8a2ax4622.m4a\r\n长生不死303$http://audio.xmcdn.com/group41/M00/B4/22/wKgJ8VrR6jyw0TT1AJRksXAOpvs583.m4a\r\n长生不死304$http://audio.xmcdn.com/group40/M01/7A/80/wKgJT1rR6mGR_nNGAIopA4dMawg972.m4a\r\n长生不死305$http://audio.xmcdn.com/group42/M0A/B0/C5/wKgJ81rR6omD41sMAIxLRKXKPII354.m4a\r\n长生不死306$http://audio.xmcdn.com/group41/M07/B4/31/wKgJ8VrR6sCTGc4-AJGfcVjTV2A038.m4a\r\n长生不死307$http://audio.xmcdn.com/group42/M02/B0/D1/wKgJ81rR6wrSgNV3AJFpG6A5vQM016.m4a\r\n长生不死308$http://audio.xmcdn.com/group40/M05/7B/68/wKgJVFrR60zy9HNrAIWVaBK0F-c141.m4a\r\n长生不死309$http://audio.xmcdn.com/group41/M04/B4/62/wKgJ8lrR662gvAdwAIMQjfz9AJw953.m4a\r\n长生不死310$http://audio.xmcdn.com/group41/M02/B4/5B/wKgJ8VrR7CngvS7vAJEeOOMFEUM865.m4a\r\n长生不死311$http://audio.xmcdn.com/group41/M05/B4/80/wKgJ8lrR7J_zNeQjAJdkrkZExZ0841.m4a\r\n长生不死312$http://audio.xmcdn.com/group40/M06/7A/E0/wKgJT1rR7SDQ34PWAJRhwqBqHes215.m4a\r\n长生不死313$http://audio.xmcdn.com/group41/M0A/B4/A5/wKgJ8lrR7ZuyuPDLAJCJ6D8k4Qs470.m4a\r\n长生不死314$http://audio.xmcdn.com/group40/M0B/7B/C7/wKgJVFrR7hbRgGjgAJc_-lbPU6I274.m4a\r\n长生不死315$http://audio.xmcdn.com/group40/M03/7B/D8/wKgJVFrR7pWyoC_ZAJlCI8zKNr0976.m4a\r\n长生不死316$http://audio.xmcdn.com/group40/M04/7B/E9/wKgJVFrR7xmhpwZfAJ6b-VzDGLw142.m4a\r\n长生不死317$http://audio.xmcdn.com/group40/M01/7C/01/wKgJVFrR75jizDQtAJjPY634Jjo975.m4a\r\n长生不死318$http://audio.xmcdn.com/group40/M05/7B/42/wKgJT1rR8CqwBHR4AKIneKFPhuM645.m4a\r\n长生不死319$http://audio.xmcdn.com/group41/M05/B4/F3/wKgJ8VrR8JrCtYb4AI7wNriv12o902.m4a\r\n长生不死320$http://audio.xmcdn.com/group42/M07/B1/A9/wKgJ81rR8R2jF5BUAJAqcwwISUI844.m4a\r\n长生不死321$http://audio.xmcdn.com/group41/M04/B5/33/wKgJ8lrR8bCBUMiFAI9kOKHZanA570.m4a\r\n长生不死322$http://audio.xmcdn.com/group40/M09/7C/55/wKgJVFrR8hLAs_TKAJKEglo0t10245.m4a\r\n长生不死323$http://audio.xmcdn.com/group41/M06/B5/56/wKgJ8lrR8ojzZWMcAI2G-cfM4dg748.m4a\r\n长生不死324$http://audio.xmcdn.com/group42/M06/B1/FA/wKgJ81rR8w7A__6jAJdx5SOYrSw785.m4a\r\n长生不死325$http://audio.xmcdn.com/group42/M04/B2/06/wKgJ81rR83aTr_WpAHrFMAkJsSs828.m4a\r\n长生不死326$http://audio.xmcdn.com/group42/M00/B2/19/wKgJ81rR8-mAXVkLAIjuwo4fM4k981.m4a\r\n长生不死327$http://audio.xmcdn.com/group42/M02/B2/24/wKgJ81rR9GfxbVjVAJnAOFxMja8908.m4a\r\n长生不死328$http://audio.xmcdn.com/group41/M02/B5/92/wKgJ8VrR9MWBVGb2AHdYwaSrqLI347.m4a\r\n长生不死329$http://audio.xmcdn.com/group42/M04/B2/4D/wKgJ81rR9SaA6tDmAHjHp8T33mY024.m4a\r\n长生不死330$http://audio.xmcdn.com/group40/M03/7C/19/wKgJT1rR9diykLEVAJjMdMYGXfw913.m4a\r\n长生不死331$http://audio.xmcdn.com/group42/M03/B7/50/wKgJ9FrR9gmi0j4HAHSvL8n0h4Q538.m4a\r\n长生不死332$http://audio.xmcdn.com/group41/M08/B5/F0/wKgJ8lrR9mzh3pjcAH1XDQe0Yg0765.m4a\r\n长生不死333$http://audio.xmcdn.com/group42/M09/B7/80/wKgJ9FrR9zmwILDpANXpJjfCYGo260.m4a\r\n长生不死334$http://audio.xmcdn.com/group41/M0B/B6/07/wKgJ8VrR95Th_3AWAIW__jzkYsA180.m4a\r\n长生不死335$http://audio.xmcdn.com/group40/M04/7C/6E/wKgJT1rR-AKwd75AAIJ6xgW_7MI845.m4a\r\n长生不死336$http://audio.xmcdn.com/group40/M07/7D/5F/wKgJVFrR-H3id5lkAIBFawVOOdw499.m4a\r\n长生不死337$http://audio.xmcdn.com/group42/M02/B2/EB/wKgJ81rR-OeSmPVSAINzJ_WA9Rc761.m4a\r\n长生不死338$http://audio.xmcdn.com/group41/M01/B6/53/wKgJ8VrR-WqAB_vOAJ6NSlk4o24853.m4a\r\n长生不死339$http://audio.xmcdn.com/group42/M0B/B3/18/wKgJ81rR-gHwtkhaALN6JHD9Dro197.m4a\r\n长生不死340$http://audio.xmcdn.com/group41/M00/B6/A3/wKgJ8lrR-qqQpMGdAMRtX2OgTk8341.m4a\r\n长生不死341$http://audio.xmcdn.com/group40/M00/7C/FF/wKgJT1rR-w_TDojEAI7LgiKDG9o003.m4a\r\n长生不死342$http://audio.xmcdn.com/group42/M09/B8/2B/wKgJ9FrR-3vDW7nmAIwQh-mqWfw961.m4a\r\n长生不死343$http://audio.xmcdn.com/group41/M02/B6/BD/wKgJ8VrR-9LiC7pzAJD6-1t805M841.m4a\r\n长生不死344$http://audio.xmcdn.com/group42/M08/B8/44/wKgJ9FrR_CKihoQcAIf8eYDIB8A959.m4a\r\n长生不死345$http://audio.xmcdn.com/group40/M0A/7E/04/wKgJVFrR_I3g_HudAJiaiDtRq2s954.m4a\r\n长生不死346$http://audio.xmcdn.com/group42/M00/B3/87/wKgJ81rR_N-Sm9P3AIFAhaD-J_M441.m4a\r\n长生不死347$http://audio.xmcdn.com/group41/M03/B7/1D/wKgJ8lrR_TSylPb0AIz0IerYd6U684.m4a\r\n长生不死348$http://audio.xmcdn.com/group42/M05/B8/7D/wKgJ9FrR_YGzapwsAIwE_bjz2uk098.m4a\r\n长生不死349$http://audio.xmcdn.com/group41/M07/B7/24/wKgJ8VrR_fygmj_aAI_eGK0DcgU803.m4a\r\n长生不死350$http://audio.xmcdn.com/group40/M09/7E/3F/wKgJVFrR_gWxbIWsAI0tZhoGNbA799.m4a\r\n长生不死351$http://audio.xmcdn.com/group41/M00/B4/22/wKgJ8VrR6jzRCbjeAIwvXS_OVuw548.m4a\r\n长生不死352$http://audio.xmcdn.com/group40/M01/7B/4C/wKgJVFrR6mLR8CxLAIV05Qfxp0A080.m4a\r\n长生不死353$http://audio.xmcdn.com/group42/M08/B5/A9/wKgJ9FrR6oqgddbkAI1pms3G_VU717.m4a\r\n长生不死354$http://audio.xmcdn.com/group41/M07/B4/2C/wKgJ8VrR6rTiOaPkAIk4Ljz1XIQ261.m4a\r\n长生不死355$http://audio.xmcdn.com/group40/M00/7A/97/wKgJT1rR6uXShEl-AHlNfilbg7A256.m4a\r\n长生不死356$http://audio.xmcdn.com/group42/M05/B5/C0/wKgJ9FrR6yuRCd-oAH2geZrzfjI201.m4a\r\n长生不死357$http://audio.xmcdn.com/group42/M00/B0/E9/wKgJ81rR64_Ciw_aAJFHVpkj0DI066.m4a\r\n长生不死358$http://audio.xmcdn.com/group41/M01/B4/58/wKgJ8VrR6_DBqc6iAIOTdXwoH4Y644.m4a\r\n长生不死359$http://audio.xmcdn.com/group41/M02/B4/66/wKgJ8VrR7Gaw1JifAH5SJ7Qkwio805.m4a\r\n长生不死360$http://audio.xmcdn.com/group41/M07/B4/86/wKgJ8lrR7MChfVS5AHRc9YnNuxU366.m4a\r\n长生不死361$http://audio.xmcdn.com/group40/M06/7B/AC/wKgJVFrR7Svia1GHAH_I0n1akKI419.m4a\r\n长生不死362$http://audio.xmcdn.com/group40/M02/7B/B6/wKgJVFrR7aWzeAxSAIZJz_qEYyk166.m4a\r\n长生不死363$http://audio.xmcdn.com/group41/M05/B4/9D/wKgJ8VrR7g2Sz6bXAHh50RuUoco726.m4a\r\n长生不死364$http://audio.xmcdn.com/group41/M01/B4/AB/wKgJ8VrR7oOC5XsbAIhdYRQEpHA205.m4a\r\n长生不死365$http://audio.xmcdn.com/group40/M04/7B/17/wKgJT1rR7wPBanyjAIiPUSbLPqo216.m4a\r\n长生不死366$http://audio.xmcdn.com/group42/M06/B1/6F/wKgJ81rR76HC-OkBAJNrD4nWUag618.m4a\r\n长生不死367$http://audio.xmcdn.com/group40/M00/7B/3A/wKgJT1rR8ArjMkO1AKwysp0Ko8k260.m4a\r\n长生不死368$http://audio.xmcdn.com/group42/M02/B1/8D/wKgJ81rR8HPTbsL1AISJ8gNeudA971.m4a\r\n长生不死369$http://audio.xmcdn.com/group40/M0A/7B/5A/wKgJT1rR8PLC5fyiAIY2ua5ifO8189.m4a\r\n长生不死370$http://audio.xmcdn.com/group40/M02/7B/67/wKgJT1rR8U-RxwRkAH4HQyJOJq8860.m4a\r\n长生不死371$http://audio.xmcdn.com/group41/M04/B5/2B/wKgJ8VrR8cXCrV43AIf8eb01dSo098.m4a\r\n长生不死372$http://audio.xmcdn.com/group40/M09/7B/95/wKgJT1rR8iqSIOeuAHxC_FqV6Ao260.m4a\r\n长生不死373$http://audio.xmcdn.com/group42/M09/B1/E7/wKgJ81rR8pDBDKrSAHesPOP6XtQ830.m4a\r\n长生不死374$http://audio.xmcdn.com/group41/M0B/B5/66/wKgJ8lrR8vWDpMnUAHtviQLYh2Y248.m4a\r\n长生不死375$http://audio.xmcdn.com/group42/M01/B6/E7/wKgJ9FrR83iTvpBNAICjafBRBlA221.m4a\r\n长生不死376$http://audio.xmcdn.com/group42/M0B/B2/10/wKgJ81rR89eztYptAH5z8IC5zJA787.m4a\r\n长生不死377$http://audio.xmcdn.com/group40/M0A/7B/E4/wKgJT1rR9EfQl7hdAI_N8uLjXB0137.m4a\r\n长生不死378$http://audio.xmcdn.com/group41/M02/B5/AE/wKgJ8lrR9NbRn-cFAKTzMCuyGnI138.m4a\r\n长生不死379$http://audio.xmcdn.com/group40/M00/7C/00/wKgJT1rR9TfzgIMsAIeJ7la41iE292.m4a\r\n长生不死380$http://audio.xmcdn.com/group41/M00/B5/C0/wKgJ8VrR9b3T7_t9AJDEpTNWFbk777.m4a\r\n长生不死381$http://audio.xmcdn.com/group40/M05/7C/F2/wKgJVFrR9h-DMQQlAIiOD8D6KVw983.m4a\r\n长生不死382$http://audio.xmcdn.com/group40/M0A/7D/07/wKgJVFrR9pHhyhe3AIU4scnxnys741.m4a\r\n长生不死383$http://audio.xmcdn.com/group40/M08/7C/46/wKgJT1rR9v6B3FvgAIZ4zKQb8AI315.m4a\r\n长生不死384$http://audio.xmcdn.com/group40/M02/7D/2B/wKgJVFrR93iBF9iRAI9y567kwN0152.m4a\r\n长生不死385$http://audio.xmcdn.com/group41/M02/B6/18/wKgJ8VrR-A_yXpNrAJdTD-MCi4k271.m4a\r\n长生不死386$http://audio.xmcdn.com/group40/M07/7D/51/wKgJVFrR-GDAALSYAI4W4cKydYc319.m4a\r\n长生不死387$http://audio.xmcdn.com/group41/M06/B6/3B/wKgJ8VrR-MjjQS5hAIB6Sp8hV5Y340.m4a\r\n长生不死388$http://audio.xmcdn.com/group42/M06/B7/CF/wKgJ9FrR-UOiVCJdAIUll0aSdQU501.m4a\r\n长生不死389$http://audio.xmcdn.com/group40/M06/7C/B5/wKgJT1rR-Z2QM86tAH3Sacejs4w746.m4a\r\n长生不死390$http://audio.xmcdn.com/group42/M0B/B3/1F/wKgJ81rR-g6z37q5AIOEj44YUmg257.m4a\r\n长生不死391$http://audio.xmcdn.com/group42/M03/B8/01/wKgJ9FrR-n3zyCqyAHyVOQPsVM4969.m4a\r\n长生不死392$http://audio.xmcdn.com/group40/M00/7C/EC/wKgJT1rR-urghQY2AIqOVrdwAgU522.m4a\r\n长生不死393$http://audio.xmcdn.com/group41/M0B/B6/AC/wKgJ8VrR-1HRd9rPAH9vCqPZFK0875.m4a\r\n长生不死394$http://audio.xmcdn.com/group40/M03/7D/14/wKgJT1rR-73Cnbc8AH1f3n5Eu0o975.m4a\r\n长生不死395$http://audio.xmcdn.com/group42/M08/B8/44/wKgJ9FrR_CLjPhvKAHxWFUGGOyE796.m4a\r\n长生不死396$http://audio.xmcdn.com/group40/M0A/7D/31/wKgJT1rR_IaxC516AHrrYL0v0qc092.m4a\r\n长生不死397$http://audio.xmcdn.com/group41/M09/B7/03/wKgJ8lrR_O6CKXZ1AHwokO9y-Jo308.m4a\r\n长生不死398$http://audio.xmcdn.com/group40/M05/7D/55/wKgJT1rR_V-wMAMIAIENWKInFLc181.m4a\r\n长生不死399$http://audio.xmcdn.com/group41/M04/B7/15/wKgJ8VrR_b3imjmLAH0z0TI10Ds042.m4a\r\n长生不死400$http://audio.xmcdn.com/group40/M09/7D/73/wKgJT1rR_g-ALqqyAHXEuHOHmFo434.m4a\r\n长生不死401$http://audio.xmcdn.com/group40/M01/7A/7E/wKgJT1rR6lqgs57yAITglZAKbUY440.m4a\r\n长生不死402$http://audio.xmcdn.com/group40/M01/7A/82/wKgJT1rR6mbgQpY3AHwIP8tr5yU986.m4a\r\n长生不死403$http://audio.xmcdn.com/group42/M08/B5/A8/wKgJ9FrR6oiABZK3AHwIP0nngVA775.m4a\r\n长生不死404$http://audio.xmcdn.com/group41/M07/B4/45/wKgJ8lrR6rvCDgP4AI53zp7in3w384.m4a\r\n长生不死405$http://audio.xmcdn.com/group41/M08/B4/4A/wKgJ8lrR6uyBK_A1AHn-9eD4Bow302.m4a\r\n长生不死406$http://audio.xmcdn.com/group42/M05/B5/C3/wKgJ9FrR6zKC5votAID0Kvq5PRs593.m4a\r\n长生不死407$http://audio.xmcdn.com/group42/M00/B5/CA/wKgJ9FrR64vzTPSaAIEgOO8yXMI240.m4a\r\n长生不死408$http://audio.xmcdn.com/group42/M0B/B5/D4/wKgJ9FrR6_qTZAoiAI5znazoSRg242.m4a\r\n长生不死409$http://audio.xmcdn.com/group40/M09/7B/94/wKgJVFrR7HPSGrK_AI-RvQpCyPM245.m4a\r\n长生不死410$http://audio.xmcdn.com/group42/M09/B1/11/wKgJ81rR7OjBYYJrAJMERBH-vAo804.m4a\r\n长生不死411$http://audio.xmcdn.com/group41/M04/B4/86/wKgJ8VrR7Vng7M5XAIg7nGU1oXM411.m4a\r\n长生不死412$http://audio.xmcdn.com/group41/M03/B4/AD/wKgJ8lrR7cjgzqywAH05r-9ScF4020.m4a\r\n长生不死413$http://audio.xmcdn.com/group40/M0B/7B/06/wKgJT1rR7ivDf_j2AHaYLnEHDpQ168.m4a\r\n长生不死414$http://audio.xmcdn.com/group40/M03/7B/14/wKgJT1rR7qXz2c6bAIXNANHDWew247.m4a\r\n长生不死415$http://audio.xmcdn.com/group40/M04/7B/18/wKgJT1rR7waBiBN7AHqzkkc2_vk627.m4a\r\n长生不死416$http://audio.xmcdn.com/group40/M01/7B/F9/wKgJVFrR74fQSntIAIW7YpfIXT8853.m4a\r\n长生不死417$http://audio.xmcdn.com/group41/M08/B4/E2/wKgJ8VrR7-Kjl71nAH-vpZzwrGw059.m4a\r\n长生不死418$http://audio.xmcdn.com/group41/M02/B4/F0/wKgJ8VrR8GDAcHeGAIKK7Qvgnbw986.m4a\r\n长生不死419$http://audio.xmcdn.com/group41/M05/B5/1E/wKgJ8lrR8M2idBI2AIJC-erJwiE723.m4a\r\n长生不死420$http://audio.xmcdn.com/group40/M0B/7B/66/wKgJT1rR8T6SaHF8AHx_NC6Iw6A953.m4a\r\n长生不死421$http://audio.xmcdn.com/group41/M04/B5/1D/wKgJ8VrR8arS9XoQAIUyz92KoYk777.m4a\r\n长生不死422$http://audio.xmcdn.com/group40/M09/7B/8F/wKgJT1rR8hzSm7FqAIcRhsP6v3Q971.m4a\r\n长生不死423$http://audio.xmcdn.com/group41/M0B/B5/40/wKgJ8VrR8obw2_U7AHzENVMqczQ017.m4a\r\n长生不死424$http://audio.xmcdn.com/group42/M05/B1/EC/wKgJ81rR8ueAid69AH_Oer8XReQ899.m4a\r\n长生不死425$http://audio.xmcdn.com/group42/M01/B6/DB/wKgJ9FrR812A-qnEAIKFD3J19Ww352.m4a\r\n长生不死426$http://audio.xmcdn.com/group42/M00/B6/F1/wKgJ9FrR89miccpAAI5znSdy8a0851.m4a\r\n长生不死427$http://audio.xmcdn.com/group41/M09/B5/83/wKgJ8VrR9EzTs49OAIZOOoOP1gw062.m4a\r\n长生不死428$http://audio.xmcdn.com/group40/M04/7C/B6/wKgJVFrR9K7To-AhAH4Y4pkx-8E244.m4a\r\n长生不死429$http://audio.xmcdn.com/group42/M04/B7/26/wKgJ9FrR9RqQRfwLAIVHlnjZSS8130.m4a\r\n长生不死430$http://audio.xmcdn.com/group42/M07/B2/5A/wKgJ81rR9YvhT0OSAIA1RcCCVx0989.m4a\r\n长生不死431$http://audio.xmcdn.com/group42/M03/B2/68/wKgJ81rR9fSyhljXAHZUoZIiZPs248.m4a\r\n长生不死432$http://audio.xmcdn.com/group41/M08/B5/DA/wKgJ8VrR9mjCehDkAIMU9Ch9Eqo011.m4a\r\n长生不死433$http://audio.xmcdn.com/group41/M0A/B5/E9/wKgJ8VrR9tTACHnHAIfdo3b2ioU916.m4a\r\n长生不死434$http://audio.xmcdn.com/group42/M09/B7/7E/wKgJ9FrR9zXxK6LNAHkxYZm8A8g188.m4a\r\n长生不死435$http://audio.xmcdn.com/group41/M0B/B6/0A/wKgJ8VrR95zh4FDzAH3_7jpveEs737.m4a\r\n长生不死436$http://audio.xmcdn.com/group40/M04/7C/70/wKgJT1rR-AbCYEpSAIEjJxrVF0k010.m4a\r\n长生不死437$http://audio.xmcdn.com/group40/M07/7C/89/wKgJT1rR-GqxYIT8AH-JeS8xVHk218.m4a\r\n长生不死438$http://audio.xmcdn.com/group42/M01/B7/C0/wKgJ9FrR-NrRLfnrAIvM-ezuRXI980.m4a\r\n长生不死439$http://audio.xmcdn.com/group42/M08/B2/F9/wKgJ81rR-U7SIKByAI4A3UX6D7Q418.m4a\r\n长生不死440$http://audio.xmcdn.com/group41/M05/B6/79/wKgJ8lrR-bGxtLpaAHc8pQCgJK8931.m4a\r\n长生不死441$http://audio.xmcdn.com/group40/M04/7C/C8/wKgJT1rR-iHwN6IVAIcNHy4bQJE870.m4a\r\n长生不死442$http://audio.xmcdn.com/group40/M01/7D/AD/wKgJVFrR-pGjqQ6pAIwmjKrS-ws939.m4a\r\n长生不死443$http://audio.xmcdn.com/group40/M00/7C/EF/wKgJT1rR-u_xZ2MWAH7HoJzG2tQ119.m4a\r\n长生不死444$http://audio.xmcdn.com/group42/M02/B8/34/wKgJ9FrR-4zxi1dnAIbp31LxR9I861.m4a\r\n长生不死445$http://audio.xmcdn.com/group41/M02/B6/BC/wKgJ8VrR-9CiZGgxAIRjwmoTG38149.m4a\r\n长生不死446$http://audio.xmcdn.com/group42/M08/B3/6A/wKgJ81rR_CrgbR5sAG0tAE_jvvs538.m4a\r\n长生不死447$http://audio.xmcdn.com/group40/M0A/7E/01/wKgJVFrR_Imx_d0XAHTSbzpQfmc917.m4a\r\n长生不死448$http://audio.xmcdn.com/group42/M00/B3/8B/wKgJ81rR_OWxQVEuAHN08VQoGBI400.m4a\r\n长生不死449$http://audio.xmcdn.com/group41/M03/B7/13/wKgJ8VrR_U3gcFkKAH9gWub3SDA362.m4a\r\n长生不死450$http://audio.xmcdn.com/group40/M08/7E/3B/wKgJVFrR_eOyqW0YAI_LAxFE5jI507.m4a\r\n长生不死451$http://audio.xmcdn.com/group41/M00/B4/3D/wKgJ8lrR6kbRGl0oAH2NY6g1QeM923.m4a\r\n长生不死452$http://audio.xmcdn.com/group40/M01/7A/81/wKgJT1rR6mTRE1_MAH9kwXpdNzQ055.m4a\r\n长生不死453$http://audio.xmcdn.com/group42/M0A/B0/C6/wKgJ81rR6ovRIIsSAIDPrJcicR4053.m4a\r\n长生不死454$http://audio.xmcdn.com/group41/M07/B4/31/wKgJ8VrR6sChlwrHAIDJlPDddWo868.m4a\r\n长生不死455$http://audio.xmcdn.com/group41/M08/B4/4C/wKgJ8lrR6vDhp7VqAHu0jmA_oJM524.m4a\r\n长生不死456$http://audio.xmcdn.com/group41/M0B/B4/54/wKgJ8lrR6zbgotOrAH2L7B526oY559.m4a\r\n长生不死457$http://audio.xmcdn.com/group42/M09/B5/D0/wKgJ9FrR66jDUXB-AHg0z5b4fsM726.m4a\r\n长生不死458$http://audio.xmcdn.com/group41/M01/B4/52/wKgJ8VrR6-OT2jqIAHhrIs8puV8291.m4a\r\n长生不死459$http://audio.xmcdn.com/group40/M08/7A/C1/wKgJT1rR7EWjr8RHAHy_z7nBwxw783.m4a\r\n长生不死460$http://audio.xmcdn.com/group42/M07/B1/0A/wKgJ81rR7K6CXp6uAHct9adBBho227.m4a\r\n长生不死461$http://audio.xmcdn.com/group42/M09/B1/1A/wKgJ81rR7RHiHt8vAHAiuGQRZeQ877.m4a\r\n长生不死462$http://audio.xmcdn.com/group42/M03/B1/27/wKgJ81rR7XeC3DoEAHDne9XY-Is820.m4a\r\n长生不死463$http://audio.xmcdn.com/group42/M0A/B6/15/wKgJ9FrR7d6BX7g2AHzNBsHIENE887.m4a\r\n长生不死464$http://audio.xmcdn.com/group42/M04/B1/4F/wKgJ81rR7neCAHZ1AJRsC9b5Ap8742.m4a\r\n长生不死465$http://audio.xmcdn.com/group42/M08/B6/35/wKgJ9FrR7svCNEMWAH7Ng3WIM3g770.m4a\r\n长生不死466$http://audio.xmcdn.com/group42/M01/B6/44/wKgJ9FrR7z3TfrMtAIPyr9gkC30589.m4a\r\n长生不死467$http://audio.xmcdn.com/group41/M0A/B4/D3/wKgJ8VrR76rSiJCsAH5jyeX24So511.m4a\r\n长生不死468$http://audio.xmcdn.com/group42/M08/B6/65/wKgJ9FrR8B-gS6kXAIW__vLHfXg351.m4a\r\n长生不死469$http://audio.xmcdn.com/group42/M0B/B6/7B/wKgJ9FrR8JPzaUOHAILkgAzvLeg418.m4a\r\n长生不死470$http://audio.xmcdn.com/group40/M0A/7B/5F/wKgJT1rR8P6QU3YaAINnMWG3KX4290.m4a\r\n长生不死471$http://audio.xmcdn.com/group40/M02/7C/42/wKgJVFrR8W_CI3XdAH96yqrpLLE630.m4a\r\n长生不死472$http://audio.xmcdn.com/group42/M0A/B6/A2/wKgJ9FrR8dbD-Y5WAIELqwOgUno478.m4a\r\n长生不死473$http://audio.xmcdn.com/group41/M03/B5/4A/wKgJ8lrR8j-ivJtNAH8czZjYnrA598.m4a\r\n长生不死474$http://audio.xmcdn.com/group41/M0B/B5/60/wKgJ8lrR8riAfCZnAIa64jrjzsM742.m4a\r\n长生不死475$http://audio.xmcdn.com/group40/M00/7B/B0/wKgJT1rR8xizzlSpAHp9QHq1Vas282.m4a\r\n长生不死476$http://audio.xmcdn.com/group41/M07/B5/6E/wKgJ8VrR85mwG2NeAIMq_TwDB1k571.m4a\r\n长生不死477$http://audio.xmcdn.com/group42/M00/B6/FE/wKgJ9FrR8_Xxf9SzAH9970lmd8Y304.m4a\r\n长生不死478$http://audio.xmcdn.com/group42/M02/B7/06/wKgJ9FrR9GqSsJFUAIG0h-eJiAU609.m4a\r\n长生不死479$http://audio.xmcdn.com/group41/M02/B5/AC/wKgJ8lrR9NOTsjKXAISHOY6vmpo778.m4a\r\n长生不死480$http://audio.xmcdn.com/group41/M06/B5/C2/wKgJ8lrR9UuBg_l8AHjdrOTQVIY172.m4a\r\n长生不死481$http://audio.xmcdn.com/group42/M07/B2/63/wKgJ81rR9Z_h3SLyAHtyeJ1Dj3w798.m4a\r\n长生不死482$http://audio.xmcdn.com/group42/M03/B7/54/wKgJ9FrR9hCiIoRTAIRWi9FBWfw143.m4a\r\n长生不死483$http://audio.xmcdn.com/group40/M0A/7C/FE/wKgJVFrR9n_zzjDiAILdKse-VlA900.m4a\r\n长生不死484$http://audio.xmcdn.com/group41/M0A/B5/FE/wKgJ8lrR9tqQdneIAHTxe5hOzkY141.m4a\r\n长生不死485$http://audio.xmcdn.com/group40/M0B/7C/56/wKgJT1rR90yg1m7VAIBCfCNbNhM860.m4a\r\n长生不死486$http://audio.xmcdn.com/group42/M04/B2/B5/wKgJ81rR98DwbQeDAIb3FsgtYGc347.m4a\r\n长生不死487$http://audio.xmcdn.com/group40/M05/7C/78/wKgJT1rR-C-R0IRqAIU4sfxf5K0377.m4a\r\n长生不死488$http://audio.xmcdn.com/group42/M00/B7/AF/wKgJ9FrR-JGw3rWhAH-Dl43gzmU914.m4a\r\n长生不死489$http://audio.xmcdn.com/group41/M09/B6/48/wKgJ8VrR-QOh4Dj-AIA2vHgJ4oA805.m4a\r\n长生不死490$http://audio.xmcdn.com/group41/M01/B6/54/wKgJ8VrR-WuD3bKoAH6kZDM36OA018.m4a\r\n长生不死491$http://audio.xmcdn.com/group42/M05/B7/E2/wKgJ9FrR-dCDSkVkAH1G5h3hwWE062.m4a\r\n长生不死492$http://audio.xmcdn.com/group40/M04/7D/9E/wKgJVFrR-kPB_3NhAIZeYEjsAxk306.m4a\r\n长生不死493$http://audio.xmcdn.com/group41/M00/B6/A1/wKgJ8lrR-qbigmzRAH4NJoQ8eUc736.m4a\r\n长生不死494$http://audio.xmcdn.com/group41/M04/B6/AB/wKgJ8lrR-xjz_A6XAIfq27TVRnI194.m4a\r\n长生不死495$http://audio.xmcdn.com/group42/M09/B3/55/wKgJ81rR-4nxW4jBAILTGFL9rn4454.m4a\r\n长生不死496$http://audio.xmcdn.com/group40/M0B/7D/1E/wKgJT1rR-_fDUV3VAICGCo-41HM698.m4a\r\n长生不死497$http://audio.xmcdn.com/group40/M02/7D/25/wKgJT1rR_HDzqNOaAIRg0wUaohg690.m4a\r\n长生不死498$http://audio.xmcdn.com/group41/M05/B6/FF/wKgJ8lrR_NLhNZkNAHfJmvTa1P4492.m4a\r\n长生不死499$http://audio.xmcdn.com/group41/M03/B7/0B/wKgJ8VrR_Tuw_Ty1AHY7qawkM2c064.m4a\r\n长生不死500$http://audio.xmcdn.com/group40/M07/7D/63/wKgJT1rR_aij9rX-AH4OnRK7yss472.m4a\r\n长生不死501$http://audio.xmcdn.com/group42/M08/B5/9F/wKgJ9FrR6nLCu3WQAHuM554696g699.m4a\r\n长生不死502$http://audio.xmcdn.com/group42/M08/B5/AE/wKgJ9FrR6pfRnlHTAH38__Fk2KM573.m4a\r\n长生不死503$http://audio.xmcdn.com/group40/M00/7B/5B/wKgJVFrR6tTwxbEfAHmGjXk_aT8879.m4a\r\n长生不死504$http://audio.xmcdn.com/group41/M08/B4/52/wKgJ8lrR6wKzB7I2AIGnUAMCrXM056.m4a\r\n长生不死505$http://audio.xmcdn.com/group40/M05/7B/6A/wKgJVFrR61DT3ji8AISzEO9xkjY442.m4a\r\n长生不死506$http://audio.xmcdn.com/group42/M00/B0/EE/wKgJ81rR66qQKWNiAI25HqsKPsU110.m4a\r\n长生不死507$http://audio.xmcdn.com/group42/M0B/B5/DB/wKgJ9FrR7A2QwOx3AILHV1Nfhtw358.m4a\r\n长生不死508$http://audio.xmcdn.com/group40/M09/7B/93/wKgJVFrR7HGSiFNpAHsUfyE-Xno387.m4a\r\n长生不死509$http://audio.xmcdn.com/group42/M04/B5/F3/wKgJ9FrR7OXxChQ1AIGEE0ZZuT4117.m4a\r\n长生不死510$http://audio.xmcdn.com/group41/M04/B4/94/wKgJ8lrR7UWjOIHxAHV51CI4OBg927.m4a\r\n长生不死511$http://audio.xmcdn.com/group40/M02/7B/BB/wKgJVFrR7bDQTUREAH1FbzhUqAQ652.m4a\r\n长生不死512$http://audio.xmcdn.com/group40/M0B/7B/05/wKgJT1rR7ijhZq6kAIpWiHcJfIo481.m4a\r\n长生不死513$http://audio.xmcdn.com/group40/M03/7B/11/wKgJT1rR7pujDD7qAIN-5yJmjPQ772.m4a\r\n长生不死514$http://audio.xmcdn.com/group40/M04/7B/EA/wKgJVFrR7xnQubD3AIOnzM1y2UQ946.m4a\r\n长生不死515$http://audio.xmcdn.com/group40/M01/7B/34/wKgJT1rR75TR__TiAIFE8JPiklM085.m4a\r\n长生不死516$http://audio.xmcdn.com/group42/M07/B6/5D/wKgJ9FrR7_mBPe3DAHjgm4SlMm8316.m4a\r\n长生不死517$http://audio.xmcdn.com/group41/M02/B4/EE/wKgJ8VrR8FyhFIcsAHZ2nFrWQFA771.m4a\r\n长生不死518$http://audio.xmcdn.com/group41/M05/B5/1E/wKgJ8lrR8M-j9manAIXo5-_YmsY830.m4a\r\n长生不死519$http://audio.xmcdn.com/group40/M02/7B/6C/wKgJT1rR8VmRzuA1AJQ__aeK3Ow252.m4a\r\n长生不死520$http://audio.xmcdn.com/group41/M04/B5/36/wKgJ8lrR8bSDGVNyAHqfBW6Zlm0394.m4a\r\n长生不死521$http://audio.xmcdn.com/group40/M09/7B/8D/wKgJT1rR8hfSkLEaAHZpLnKknLE053.m4a\r\n长生不死522$http://audio.xmcdn.com/group41/M06/B5/3D/wKgJ8VrR8n6xCFAjAHsV9oktPLI876.m4a\r\n长生不死523$http://audio.xmcdn.com/group42/M05/B6/CC/wKgJ9FrR8uexVRBTAHOMcs3sWPc280.m4a\r\n长生不死524$http://audio.xmcdn.com/group42/M01/B1/FF/wKgJ81rR82XD2gzcAI6OCB4UyAI068.m4a\r\n长生不死525$http://audio.xmcdn.com/group40/M06/7B/C6/wKgJT1rR88bxLn42AHN08VJJjuE891.m4a\r\n长生不死526$http://audio.xmcdn.com/group40/M08/7C/A1/wKgJVFrR9Cija4TWAHmfgYNihAU407.m4a\r\n长生不死527$http://audio.xmcdn.com/group42/M02/B2/38/wKgJ81rR9I6zYP63AHovanA9as0319.m4a\r\n长生不死528$http://audio.xmcdn.com/group40/M0B/7C/C2/wKgJVFrR9PbjCATkAIK82X7oUrc456.m4a\r\n长生不死529$http://audio.xmcdn.com/group40/M01/7C/D6/wKgJVFrR9Wii59_bAIQbztw3hv0641.m4a\r\n长生不死530$http://audio.xmcdn.com/group40/M03/7C/1B/wKgJT1rR9d2CeKV7AIYNm6L2u2I772.m4a\r\n长生不死531$http://audio.xmcdn.com/group40/M00/7C/FA/wKgJVFrR9l2QjJYLAHtpqxxFREc941.m4a\r\n长生不死532$http://audio.xmcdn.com/group41/M0A/B6/00/wKgJ8lrR9t6A9CWeAIAGSFEFzqM582.m4a\r\n长生不死533$http://audio.xmcdn.com/group40/M08/7D/1D/wKgJVFrR9xODymhlAHkSi69PyRc783.m4a\r\n长生不死534$http://audio.xmcdn.com/group40/M02/7C/61/wKgJT1rR933iJEddAHn-9SOalvw833.m4a\r\n长生不死535$http://audio.xmcdn.com/group41/M01/B6/25/wKgJ8lrR99_B0pl8AHdXFGv8NF8830.m4a\r\n长生不死536$http://audio.xmcdn.com/group41/M07/B6/28/wKgJ8VrR-FLjEVK4AHskpTvqYp0164.m4a\r\n长生不死537$http://audio.xmcdn.com/group41/M06/B6/47/wKgJ8lrR-LqASxCEAIlA_-TWXDQ016.m4a\r\n长生不死538$http://audio.xmcdn.com/group40/M09/7C/A9/wKgJT1rR-S-jQGEIAISzEKgR94I690.m4a\r\n长生不死539$http://audio.xmcdn.com/group40/M06/7D/7F/wKgJVFrR-ZPjLDc5AIBXDmw8BuI894.m4a\r\n长生不死540$http://audio.xmcdn.com/group42/M05/B3/12/wKgJ81rR-fTgMck3AHlx_DtEbYA752.m4a\r\n长生不死541$http://audio.xmcdn.com/group40/M04/7C/D8/wKgJT1rR-lrB_MwQAIE9lnzrtIU296.m4a\r\n长生不死542$http://audio.xmcdn.com/group42/M0A/B8/14/wKgJ9FrR-snRouAmAIB3Wz6veNo029.m4a\r\n长生不死543$http://audio.xmcdn.com/group41/M04/B6/A0/wKgJ8VrR-yax5RvQAHZBwY4lICo429.m4a\r\n长生不死544$http://audio.xmcdn.com/group40/M03/7D/07/wKgJT1rR-6Szk9RNAIB6SnW8o2I741.m4a\r\n长生不死545$http://audio.xmcdn.com/group40/M0B/7D/1F/wKgJT1rR-_rCPp0_AH_uyNpdce0638.m4a\r\n长生不死546$http://audio.xmcdn.com/group42/M04/B3/71/wKgJ81rR_FzjgGvvAHiVuAQdlbs223.m4a\r\n长生不死547$http://audio.xmcdn.com/group40/M0A/7D/4A/wKgJT1rR_LmhJhAqAHkCZOZJfGI922.m4a\r\n长生不死548$http://audio.xmcdn.com/group42/M03/B3/94/wKgJ81rR_SDi4LwxAH-N4Anf_7o655.m4a\r\n长生不死549$http://audio.xmcdn.com/group42/M05/B8/82/wKgJ9FrR_Yyz5yQcAIF0IuGoaLQ389.m4a\r\n长生不死550$http://audio.xmcdn.com/group41/M07/B7/18/wKgJ8VrR_ebBLpGjAHh-O5B6Tf4224.m4a\r\n长生不死551$http://audio.xmcdn.com/group42/M08/B5/A3/wKgJ9FrR6nuQ70-nAHp0bz1qPxY444.m4a\r\n长生不死552$http://audio.xmcdn.com/group42/M08/B5/B0/wKgJ9FrR6p7j_VbGAHtDewk1uGk284.m4a\r\n长生不死553$http://audio.xmcdn.com/group40/M00/7B/5A/wKgJVFrR6tGTUXJ8AHcTht6wT-s477.m4a\r\n长生不死554$http://audio.xmcdn.com/group42/M05/B5/BA/wKgJ9FrR6xySJzmrAIANov3cB-Q657.m4a\r\n长生不死555$http://audio.xmcdn.com/group41/M03/B4/46/wKgJ8VrR626AClh5AIRfXCw8Hn0483.m4a\r\n长生不死556$http://audio.xmcdn.com/group40/M0A/7B/7D/wKgJVFrR68qCcw8KAHiIgIKGL4U086.m4a\r\n长生不死557$http://audio.xmcdn.com/group40/M08/7A/C1/wKgJT1rR7EawQCW4AIDYQ1tsV-0270.m4a\r\n长生不死558$http://audio.xmcdn.com/group41/M05/B4/6B/wKgJ8VrR7KWRVGNXAH5z8CSTce0558.m4a\r\n长生不死559$http://audio.xmcdn.com/group40/M06/7B/A4/wKgJVFrR7ReSwlToAIVQLZqyF2s844.m4a\r\n长生不死560$http://audio.xmcdn.com/group42/M03/B1/2A/wKgJ81rR7X7Q4Qj-AHlsHaagClQ007.m4a\r\n长生不死561$http://audio.xmcdn.com/group40/M07/7A/F9/wKgJT1rR7fCAOct6AIO2ewRn-xc178.m4a\r\n长生不死562$http://audio.xmcdn.com/group42/M04/B1/43/wKgJ81rR7lqiRuCEAH36DK12sKE229.m4a\r\n长生不死563$http://audio.xmcdn.com/group42/M08/B1/55/wKgJ81rR7szh7Y1VAH6l3GpmzOA459.m4a\r\n长生不死564$http://audio.xmcdn.com/group42/M0B/B1/5C/wKgJ81rR7yjjH9ueAHe_VpzSmuM468.m4a\r\n长生不死565$http://audio.xmcdn.com/group40/M01/7B/FD/wKgJVFrR75GSCyQtAH22gopaNNs481.m4a\r\n长生不死566$http://audio.xmcdn.com/group40/M00/7C/05/wKgJVFrR8Argz6fBAIS9VeTC7uo871.m4a\r\n长生不死567$http://audio.xmcdn.com/group42/M0B/B6/68/wKgJ9FrR8GuAayo_AH1ujcn-sPI376.m4a\r\n长生不死568$http://audio.xmcdn.com/group41/M05/B5/09/wKgJ8VrR8M6DQ4JjAHbu0iABMjY587.m4a\r\n长生不死569$http://audio.xmcdn.com/group40/M0B/7B/65/wKgJT1rR8Tzj479XAHpc72pOomY791.m4a\r\n长生不死570$http://audio.xmcdn.com/group41/M04/B5/28/wKgJ8VrR8cGC0x6EAJALnWxsuhE780.m4a\r\n长生不死571$http://audio.xmcdn.com/group40/M09/7C/5F/wKgJVFrR8ijxoXT9AHwJusJTSIY987.m4a\r\n长生不死572$http://audio.xmcdn.com/group42/M08/B6/C8/wKgJ9FrR8pOAMmnGAHvZQvmgWwk022.m4a\r\n长生不死573$http://audio.xmcdn.com/group42/M05/B6/D1/wKgJ9FrR8vzBnd6hAHz2JW1-0hY732.m4a\r\n长生不死574$http://audio.xmcdn.com/group42/M04/B2/0A/wKgJ81rR83_Bh1tGAIgGwsmhVi0846.m4a\r\n长生不死575$http://audio.xmcdn.com/group42/M00/B2/15/wKgJ81rR8-Ly2uNDAH_zMtp24-Q239.m4a\r\n长生不死576$http://audio.xmcdn.com/group40/M08/7C/AC/wKgJVFrR9EPjXQQXAHw6Lm5s1Sk531.m4a\r\n长生不死577$http://audio.xmcdn.com/group40/M04/7B/E8/wKgJT1rR9KXA5hvIAHujJuVwDRk528.m4a\r\n长生不死578$http://audio.xmcdn.com/group41/M01/B5/A8/wKgJ8VrR9RbiRzaWAIV_KhpxGPc587.m4a\r\n长生不死579$http://audio.xmcdn.com/group42/M06/B2/50/wKgJ81rR9XfgDW2IAHhCB1LFomo085.m4a\r\n长生不死580$http://audio.xmcdn.com/group40/M03/7C/20/wKgJT1rR9ebAIoJxAHvO_dwQDZM997.m4a\r\n长生不死581$http://audio.xmcdn.com/group41/M03/B5/E8/wKgJ8lrR9kahACdFAH6-0169pMo979.m4a\r\n长生不死582$http://audio.xmcdn.com/group42/M0A/B7/5F/wKgJ9FrR9qiCzhP3AHy58YIMUP8293.m4a\r\n长生不死583$http://audio.xmcdn.com/group42/M0B/B2/A1/wKgJ81rR9zGjfAG_AJJ9LTvJ750925.m4a\r\n长生不死584$http://audio.xmcdn.com/group41/M0B/B6/1C/wKgJ8lrR95nDa4iCAIONYawyaqo316.m4a\r\n长生不死585$http://audio.xmcdn.com/group42/M07/B2/CC/wKgJ81rR9_nQX3b4AHqO3sxx4Nw345.m4a\r\n长生不死586$http://audio.xmcdn.com/group40/M07/7C/88/wKgJT1rR-GqgTIA2AISHA8CAnco790.m4a\r\n长生不死587$http://audio.xmcdn.com/group41/M06/B6/43/wKgJ8VrR-NfhAyrnAIHMCMT7ihk437.m4a\r\n长生不死588$http://audio.xmcdn.com/group42/M06/B2/F2/wKgJ81rR-T_zlO_eAIULLKZprAs246.m4a\r\n长生不死589$http://audio.xmcdn.com/group41/M05/B6/66/wKgJ8VrR-bWgCwG4AIlLR9fgAp4962.m4a\r\n长生不死590$http://audio.xmcdn.com/group40/M04/7D/9C/wKgJVFrR-iXA9uvAAIgSfo8OY0g569.m4a\r\n长生不死591$http://audio.xmcdn.com/group42/M03/B3/2A/wKgJ81rR-oeDkFMtAHqNZwEk-_c778.m4a\r\n长生不死592$http://audio.xmcdn.com/group40/M00/7C/ED/wKgJT1rR-uzgPb-_AHszVFSUNJA828.m4a\r\n长生不死593$http://audio.xmcdn.com/group41/M0B/B6/B5/wKgJ8VrR-2KQ-gXLAIbPb_D7ACE300.m4a\r\n长生不死594$http://audio.xmcdn.com/group41/M07/B6/C9/wKgJ8VrR--3h-WQcAI8MHSIqKBE339.m4a\r\n长生不死595$http://audio.xmcdn.com/group41/M0A/B6/E6/wKgJ8lrR_DnDE5tOAH9QNM5AACE480.m4a\r\n长生不死596$http://audio.xmcdn.com/group40/M0A/7D/3D/wKgJT1rR_J7x-OheAIA28pmzTJg776.m4a\r\n长生不死597$http://audio.xmcdn.com/group42/M03/B8/6B/wKgJ9FrR_RKxHcItAIBLTrahGUQ613.m4a\r\n长生不死598$http://audio.xmcdn.com/group42/M05/B8/75/wKgJ9FrR_XKQAIeMAHy_zwNPlEQ537.m4a\r\n长生不死599$http://audio.xmcdn.com/group42/M07/B8/95/wKgJ9FrR_cnwC1EfAHNZC5ACxhk165.m4a\r\n长生不死600$http://audio.xmcdn.com/group40/M09/7E/4F/wKgJVFrR_iHCKE0IAIC-Du3pnpo973.m4a\r\n长生不死601$http://audio.xmcdn.com/group42/M08/B0/C0/wKgJ81rR6nvw-EPrAH23-TE-pK8650.m4a\r\n长生不死602$http://audio.xmcdn.com/group40/M04/7A/88/wKgJT1rR6qaSb4wuAIZCeqxNw94878.m4a\r\n长生不死603$http://audio.xmcdn.com/group40/M00/7A/95/wKgJT1rR6uDTelGlAH3Zvggdy5k799.m4a\r\n长生不死604$http://audio.xmcdn.com/group42/M05/B5/BD/wKgJ9FrR6yTDkhGpAIMmljJCHPs760.m4a\r\n长生不死605$http://audio.xmcdn.com/group41/M03/B4/5D/wKgJ8lrR63CxdJ-rAIE2QSK-DTs145.m4a\r\n长生不死606$http://audio.xmcdn.com/group41/M01/B4/50/wKgJ8VrR697QVQLoAIIMoszELFc384.m4a\r\n长生不死607$http://audio.xmcdn.com/group40/M08/7A/BC/wKgJT1rR7Diwmf-uAH_LizKRSlk934.m4a\r\n长生不死608$http://audio.xmcdn.com/group40/M04/7A/D6/wKgJT1rR7PuQFldOANUl2mW6lEA711.m4a\r\n长生不死609$http://audio.xmcdn.com/group42/M03/B6/01/wKgJ9FrR7WCTsVDkAIPcq2MarZw763.m4a\r\n长生不死610$http://audio.xmcdn.com/group42/M0A/B1/31/wKgJ81rR7dOS-n2WAH5-NRKQZg4586.m4a\r\n长生不死611$http://audio.xmcdn.com/group40/M0B/7B/D0/wKgJVFrR7i6hLFmTAHqyG_hWqZ0732.m4a\r\n长生不死612$http://audio.xmcdn.com/group40/M03/7B/0F/wKgJT1rR7pbCK_F4AG4t_KtzCvU940.m4a\r\n长生不死613$http://audio.xmcdn.com/group41/M00/B4/C6/wKgJ8VrR7vnyPnaoAHpRMh5DzYo643.m4a\r\n长生不死614$http://audio.xmcdn.com/group41/M09/B4/CA/wKgJ8VrR72KgQi_eAHe3_N4d4EM994.m4a\r\n长生不死615$http://audio.xmcdn.com/group41/M08/B4/D8/wKgJ8VrR78zjdb89AHqdw7HdG9o119.m4a\r\n长生不死616$http://audio.xmcdn.com/group40/M05/7B/4C/wKgJT1rR8EGgglz0AINl7_rw7-s998.m4a\r\n长生不死617$http://audio.xmcdn.com/group41/M05/B5/13/wKgJ8lrR8LPgb_wHAHX4H8D1pJ8639.m4a\r\n长生不死618$http://audio.xmcdn.com/group42/M07/B1/A4/wKgJ81rR8RLxdjrQAHoX7fPn_kU574.m4a\r\n长生不死619$http://audio.xmcdn.com/group40/M02/7B/7A/wKgJT1rR8XmDg5BVAHjDc6ga2-8153.m4a\r\n长生不死620$http://audio.xmcdn.com/group42/M00/B6/AA/wKgJ9FrR8faBSPaqAIMyUgI_im8692.m4a\r\n长生不死621$http://audio.xmcdn.com/group42/M08/B1/D5/wKgJ81rR8lWyLLLXAHkD3IgmvJ4152.m4a\r\n长生不死622$http://audio.xmcdn.com/group41/M0B/B5/4D/wKgJ8VrR8rmAWyekAHWwKrbVPEs625.m4a\r\n长生不死623$http://audio.xmcdn.com/group41/M0A/B5/69/wKgJ8lrR8x-RAqoeAH7Agf2kGZg888.m4a\r\n长生不死624$http://audio.xmcdn.com/group42/M04/B2/0C/wKgJ81rR84TiM_8qAH_hlA3l6Cs658.m4a\r\n长生不死625$http://audio.xmcdn.com/group42/M00/B2/17/wKgJ81rR8-eg7UQrAHs_S21ZJeQ276.m4a\r\n长生不死626$http://audio.xmcdn.com/group41/M09/B5/96/wKgJ8lrR9E3xa0H7AH5MSYhP8H4120.m4a\r\n长生不死627$http://audio.xmcdn.com/group40/M04/7C/B8/wKgJVFrR9LPgAJ6jAHh4WRN2vDY347.m4a\r\n长生不死628$http://audio.xmcdn.com/group42/M04/B2/4D/wKgJ81rR9SfjcLPBAILUWTUUR1M844.m4a\r\n长生不死629$http://audio.xmcdn.com/group42/M07/B2/60/wKgJ81rR9Ziw1XPQAIG-0KcEzn4759.m4a\r\n长生不死630$http://audio.xmcdn.com/group41/M03/B5/C9/wKgJ8VrR9i6BuyFJAHyg-SkXn8U612.m4a\r\n长生不死631$http://audio.xmcdn.com/group41/M08/B5/F6/wKgJ8lrR9nrwrRCuAIO1BBohcaw399.m4a\r\n长生不死632$http://audio.xmcdn.com/group41/M0A/B5/EC/wKgJ8VrR9tuxDLVzAHByAm6tJuY780.m4a\r\n长生不死633$http://audio.xmcdn.com/group42/M0B/B2/AB/wKgJ81rR90eh4JUiAIKvoXCk2i0563.m4a\r\n长生不死634$http://audio.xmcdn.com/group42/M07/B7/97/wKgJ9FrR98vDGLtvAJ4dsp4oGCk602.m4a\r\n长生不死635$http://audio.xmcdn.com/group41/M07/B6/2A/wKgJ8VrR-FSgpl4MAIMdxXfDuo4784.m4a\r\n长生不死636$http://audio.xmcdn.com/group42/M00/B7/B3/wKgJ9FrR-JiA5tqtAHMCZ1wyNAk065.m4a\r\n长生不死637$http://audio.xmcdn.com/group41/M09/B6/58/wKgJ8lrR-P-B7kUOAHZQOvZud7g724.m4a\r\n长生不死638$http://audio.xmcdn.com/group41/M01/B6/51/wKgJ8VrR-WewGlZ5AHysuTa6uek974.m4a\r\n长生不死639$http://audio.xmcdn.com/group42/M05/B7/E1/wKgJ9FrR-c7AmbW7AHmrQWWRq3M212.m4a\r\n长生不死640$http://audio.xmcdn.com/group41/M03/B6/74/wKgJ8VrR-jDRaPxkAHBEfWXFyT8276.m4a\r\n长生不死641$http://audio.xmcdn.com/group41/M00/B6/A8/wKgJ8lrR-rSwAL6pAJugY3iUJno184.m4a\r\n长生不死642$http://audio.xmcdn.com/group40/M00/7D/00/wKgJT1rR-xCSZnHaAHldbsG_iuE516.m4a\r\n长生不死643$http://audio.xmcdn.com/group42/M09/B8/29/wKgJ9FrR-3TCVlM-AHgEV4Ohks8571.m4a\r\n长生不死644$http://audio.xmcdn.com/group40/M0B/7D/F3/wKgJVFrR_ALw-sqwAH01SA4tg0w443.m4a\r\n长生不死645$http://audio.xmcdn.com/group41/M0A/B6/DB/wKgJ8VrR_EbTqHEXAH0_kSuP_MM872.m4a\r\n长生不死646$http://audio.xmcdn.com/group40/M0A/7E/19/wKgJVFrR_LKR9ZdcAHnzNUhvxTM420.m4a\r\n长生不死647$http://audio.xmcdn.com/group41/M03/B7/16/wKgJ8lrR_SbzjO0AAIIJs7UdLjg078.m4a\r\n长生不死648$http://audio.xmcdn.com/group42/M07/B8/91/wKgJ9FrR_bfx3ixnAKgYxlflF9I332.m4a\r\n长生不死649$http://audio.xmcdn.com/group40/M09/7D/71/wKgJT1rR_grzilykAH34lAdXQvs140.m4a\r\n长生不死650$http://audio.xmcdn.com/group42/M04/B8/A0/wKgJ9FrR_kGDAvgRAH7iELvLnRg326.m4a\r\n长生不死651$http://audio.xmcdn.com/group42/M0A/B0/CB/wKgJ81rR6pWDsxUIAHu75Ey6Ouc320.m4a\r\n长生不死652$http://audio.xmcdn.com/group41/M07/B4/30/wKgJ8VrR6r7iqKlUAHkMqYrUyZU039.m4a\r\n长生不死653$http://audio.xmcdn.com/group41/M08/B4/38/wKgJ8VrR6vbgD1uKAHqAL9aTfUU365.m4a\r\n长生不死654$http://audio.xmcdn.com/group40/M05/7B/65/wKgJVFrR60TAGEWzAIC1BzdxM0c104.m4a\r\n长生不死655$http://audio.xmcdn.com/group40/M07/7A/A8/wKgJT1rR65WTEicOAHY4utC5sZU592.m4a\r\n长生不死656$http://audio.xmcdn.com/group42/M06/B0/F0/wKgJ81rR6_bjO_YGAH1BCO-1_cA476.m4a\r\n长生不死657$http://audio.xmcdn.com/group41/M02/B4/63/wKgJ8VrR7F7RSXXQAHPNDbcDbAg961.m4a\r\n长生不死658$http://audio.xmcdn.com/group41/M07/B4/8A/wKgJ8lrR7MujhjhyAH6EF5brfqg750.m4a\r\n长生不死659$http://audio.xmcdn.com/group40/M06/7B/AD/wKgJVFrR7S_RW1D4AH81xC81ImU286.m4a\r\n长生不死660$http://audio.xmcdn.com/group41/M0A/B4/A5/wKgJ8lrR7ZyQjQFbAH-ylKTQAiA563.m4a\r\n长生不死661$http://audio.xmcdn.com/group42/M0A/B6/1D/wKgJ9FrR7gTwfDnaAH_5EDk0Zw0809.m4a\r\n长生不死662$http://audio.xmcdn.com/group42/M04/B1/4B/wKgJ81rR7mzz1i6vAHnqaJUOdRY785.m4a\r\n长生不死663$http://audio.xmcdn.com/group41/M00/B4/D1/wKgJ8lrR7trQg88vAHpbd8Gkkik304.m4a\r\n长生不死664$http://audio.xmcdn.com/group42/M00/B1/64/wKgJ81rR7zqRQHzTAHZ2nHzHSnM305.m4a\r\n长生不死665$http://audio.xmcdn.com/group42/M06/B6/58/wKgJ9FrR78OQcQPpAHj4G-awy2c846.m4a\r\n长生不死666$http://audio.xmcdn.com/group42/M05/B1/86/wKgJ81rR8BywO5NjAHPhmnY8hlk161.m4a\r\n长生不死667$http://audio.xmcdn.com/group42/M02/B1/8F/wKgJ81rR8Hihs262AHU3wuV3O08107.m4a\r\n长生不死668$http://audio.xmcdn.com/group40/M0A/7B/54/wKgJT1rR8OXisI6YAHvpnyYY1pI400.m4a\r\n长生不死669$http://audio.xmcdn.com/group40/M02/7B/68/wKgJT1rR8VCTNLvBAH2O24zfRMY277.m4a\r\n长生不死670$http://audio.xmcdn.com/group41/M04/B5/23/wKgJ8VrR8bbgKOHOAHplwJLS3tg491.m4a\r\n长生不死671$http://audio.xmcdn.com/group42/M08/B6/B7/wKgJ9FrR8lijrdprAIVx9umJ7lo937.m4a\r\n长生不死672$http://audio.xmcdn.com/group40/M07/7C/65/wKgJVFrR8p_g6lDyAIcOl4FqwF8253.m4a\r\n长生不死673$http://audio.xmcdn.com/group42/M06/B1/F9/wKgJ81rR8w2DWDFNAHu3faXdZYM486.m4a\r\n长生不死674$http://audio.xmcdn.com/group42/M01/B6/E2/wKgJ9FrR82yzLXaZAHfbPQb2kwI512.m4a\r\n长生不死675$http://audio.xmcdn.com/group42/M00/B6/F7/wKgJ9FrR8-eB5HPnAINrztlToTU391.m4a\r\n长生不死676$http://audio.xmcdn.com/group41/M09/B5/84/wKgJ8VrR9E3SgToaAH3Pdrvv6BI440.m4a\r\n长生不死677$http://audio.xmcdn.com/group40/M04/7C/B8/wKgJVFrR9LKDJhpUAHsTB5ZlG-c252.m4a\r\n长生不死678$http://audio.xmcdn.com/group41/M01/B5/A3/wKgJ8VrR9QzRBb0lAHLWWSvW00A383.m4a\r\n长生不死679$http://audio.xmcdn.com/group40/M01/7C/10/wKgJT1rR9XLTAcFyAHrSaC7w91o267.m4a\r\n长生不死680$http://audio.xmcdn.com/group40/M03/7C/15/wKgJT1rR9dLgfUC5AHmidHTWHlk519.m4a\r\n长生不死681$http://audio.xmcdn.com/group41/M03/B5/CC/wKgJ8VrR9jbCUBomAHUteW-dhIo378.m4a\r\n长生不死682$http://audio.xmcdn.com/group42/M01/B2/88/wKgJ81rR9rGTGJ6EAIQqfRvdFAQ370.m4a\r\n长生不死683$http://audio.xmcdn.com/group42/M09/B7/76/wKgJ9FrR9yOAkHCaAIIeRasKlj8072.m4a\r\n长生不死684$http://audio.xmcdn.com/group40/M02/7C/6A/wKgJT1rR95DjlL6IAIJ_Lab0-nk301.m4a\r\n长生不死685$http://audio.xmcdn.com/group40/M04/7C/6E/wKgJT1rR-AHD-nm4AILo5pYqERY265.m4a\r\n长生不死686$http://audio.xmcdn.com/group42/M01/B2/D7/wKgJ81rR-JehdICTAIPGotv0A4E954.m4a\r\n长生不死687$http://audio.xmcdn.com/group42/M01/B7/C2/wKgJ9FrR-N6z9b8fAIMdxYRp_jM753.m4a\r\n长生不死688$http://audio.xmcdn.com/group42/M06/B7/D0/wKgJ9FrR-USACbifAHYucXMWNbc279.m4a\r\n长生不死689$http://audio.xmcdn.com/group40/M06/7C/AF/wKgJT1rR-ZKBCnigAG8wb_NcCY0423.m4a\r\n长生不死690$http://audio.xmcdn.com/group42/M0B/B7/F3/wKgJ9FrR-f-SHssnAHqjbE8EXO0880.m4a\r\n长生不死691$http://audio.xmcdn.com/group40/M04/7C/D7/wKgJT1rR-lixLQ_RAHVz9oT_lsI493.m4a\r\n长生不死692$http://audio.xmcdn.com/group40/M00/7C/EC/wKgJT1rR-unwsqvBAH36DPlmoQY357.m4a\r\n长生不死693$http://audio.xmcdn.com/group42/M09/B3/47/wKgJ81rR-0Hhq68JAJgDRpVxTqY805.m4a\r\n长生不死694$http://audio.xmcdn.com/group42/M09/B3/5F/wKgJ81rR-56zK-cPAHlpLuVRQ7c197.m4a\r\n长生不死695$http://audio.xmcdn.com/group42/M08/B8/3E/wKgJ9FrR_AiTUX8KAH7Xx8FAYuQ871.m4a\r\n长生不死696$http://audio.xmcdn.com/group42/M08/B8/56/wKgJ9FrR_GviOxRDAHbCxaqxX34257.m4a\r\n长生不死697$http://audio.xmcdn.com/group42/M00/B3/84/wKgJ81rR_Nehz4j4AHhfZf-wRrg765.m4a\r\n长生不死698$http://audio.xmcdn.com/group41/M03/B7/21/wKgJ8lrR_T2zd2bzAHRD_p7dzRM054.m4a\r\n长生不死699$http://audio.xmcdn.com/group42/M05/B8/83/wKgJ9FrR_Y6AdAgrAHOj7qv5Cng415.m4a\r\n长生不死700$http://audio.xmcdn.com/group40/M08/7D/68/wKgJT1rR_eDj36doAG2JhtKU4HY790.m4a\r\n长生不死701$http://audio.xmcdn.com/group41/M07/B4/44/wKgJ8lrR6rjCh7y8AHUtec7LpaE037.m4a\r\n长生不死702$http://audio.xmcdn.com/group40/M00/7B/59/wKgJVFrR6s7TKMz1AHzwQ1nQ588663.m4a\r\n长生不死703$http://audio.xmcdn.com/group42/M02/B5/B4/wKgJ9FrR6wvAoJT3AHXcOI0nuRQ986.m4a\r\n长生不死704$http://audio.xmcdn.com/group40/M05/7B/6A/wKgJVFrR60-RyTdaAH7dqfF_SSs634.m4a\r\n长生不死705$http://audio.xmcdn.com/group40/M07/7B/75/wKgJVFrR65yBPPnDAHFG8Eph5DQ223.m4a\r\n长生不死706$http://audio.xmcdn.com/group42/M0B/B5/D5/wKgJ9FrR6_3jfw6oAHTT5xJS4ps145.m4a\r\n长生不死707$http://audio.xmcdn.com/group41/M02/B4/67/wKgJ8VrR7GfR1M5OAH7NgzS5gcE405.m4a\r\n长生不死708$http://audio.xmcdn.com/group41/M07/B4/77/wKgJ8VrR7NfR1YAQAH-Wrd31kT8071.m4a\r\n长生不死709$http://audio.xmcdn.com/group41/M04/B4/99/wKgJ8lrR7VHSAhcZAHyZn-ZLEJI780.m4a\r\n长生不死710$http://audio.xmcdn.com/group40/M02/7A/EF/wKgJT1rR7avQXnFnAHrrYIGjKfA608.m4a\r\n长生不死711$http://audio.xmcdn.com/group41/M05/B4/B5/wKgJ8lrR7g2ykFltAHRYi-1fJHM519.m4a\r\n长生不死712$http://audio.xmcdn.com/group42/M04/B1/4D/wKgJ81rR7nHh7Mm2AGvp8hlhfhM185.m4a\r\n长生不死713$http://audio.xmcdn.com/group42/M08/B6/37/wKgJ9FrR7tKzqmGmAHXU3koO1ic029.m4a\r\n长生不死714$http://audio.xmcdn.com/group42/M01/B6/44/wKgJ9FrR7z2QOlGpAHBzfUTWA-Y909.m4a\r\n长生不死715$http://audio.xmcdn.com/group42/M06/B6/52/wKgJ9FrR76jjayWhAHIHTfSwQxg893.m4a\r\n长生不死716$http://audio.xmcdn.com/group40/M00/7B/3D/wKgJT1rR8BCxmhmjAHuhdCi8Fyo645.m4a\r\n长生不死717$http://audio.xmcdn.com/group42/M02/B1/8E/wKgJ81rR8HeTTtWcAHEmo8Rav0I238.m4a\r\n长生不死718$http://audio.xmcdn.com/group40/M0A/7B/57/wKgJT1rR8O3g3uS9AIDGpfcntD8921.m4a\r\n长生不死719$http://audio.xmcdn.com/group40/M02/7B/69/wKgJT1rR8VSj3KD9AH10bAkvLGQ351.m4a\r\n长生不死720$http://audio.xmcdn.com/group41/M04/B5/24/wKgJ8VrR8bnzMbVSAHBBjsg-y6A988.m4a\r\n长生不死721$http://audio.xmcdn.com/group40/M09/7B/92/wKgJT1rR8iOBGWRDAHm4eMCIowo679.m4a\r\n长生不死722$http://audio.xmcdn.com/group41/M0B/B5/3F/wKgJ8VrR8oOzCAtyAHF43CPvT-I450.m4a\r\n长生不死723$http://audio.xmcdn.com/group42/M05/B1/EF/wKgJ81rR8u3DEs5BAHag_IS9exs283.m4a\r\n长生不死724$http://audio.xmcdn.com/group42/M01/B6/E2/wKgJ9FrR82yC4iBgAH0QkNpRydU127.m4a\r\n长生不死725$http://audio.xmcdn.com/group40/M06/7B/BD/wKgJT1rR87KSiBKKAHJiV402fx4174.m4a\r\n长生不死726$http://audio.xmcdn.com/group41/M09/B5/80/wKgJ8VrR9CKTxY3mAHVsnZ8UeXQ425.m4a\r\n长生不死727$http://audio.xmcdn.com/group42/M02/B2/30/wKgJ81rR9H6j0vXSAG5EAH6Zjhg688.m4a\r\n长生不死728$http://audio.xmcdn.com/group42/M0B/B2/3D/wKgJ81rR9ODyqpZRAHkJ8Ir7uX4837.m4a\r\n长生不死729$http://audio.xmcdn.com/group41/M06/B5/BE/wKgJ8lrR9ULDMEE2AHoTuZs6cFA158.m4a\r\n长生不死730$http://audio.xmcdn.com/group41/M00/B5/C9/wKgJ8lrR9aiAjOYHAHV25YQ40zE592.m4a\r\n长生不死731$http://audio.xmcdn.com/group42/M05/B2/74/wKgJ81rR9gmxUxAzAHQVAbr5Hvk668.m4a\r\n长生不死732$http://audio.xmcdn.com/group40/M00/7C/FA/wKgJVFrR9l3R4ciJAG88K9B-yNM719.m4a\r\n长生不死733$http://audio.xmcdn.com/group41/M0A/B5/F9/wKgJ8lrR9tHA7y3AAItY94Cnu_A752.m4a\r\n长生不死734$http://audio.xmcdn.com/group42/M09/B7/76/wKgJ9FrR9ySSc9sAAG5o7o25Wb4197.m4a\r\n长生不死735$http://audio.xmcdn.com/group40/M02/7D/2D/wKgJVFrR93vBwcVCAG1TL713Org685.m4a\r\n长生不死736$http://audio.xmcdn.com/group41/M01/B6/26/wKgJ8lrR9-GCF0JTAHWFlBJre2E868.m4a\r\n长生不死737$http://audio.xmcdn.com/group40/M05/7C/81/wKgJT1rR-EODYYVBAHNyAh8DwkM358.m4a\r\n长生不死738$http://audio.xmcdn.com/group42/M01/B2/E2/wKgJ81rR-K_R2dLKAHXPAOIHxXk750.m4a\r\n长生不死739$http://audio.xmcdn.com/group40/M09/7D/71/wKgJVFrR-SKBUtsOAIX9dDbQQWM260.m4a\r\n长生不死740$http://audio.xmcdn.com/group41/M05/B6/68/wKgJ8VrR-bnw8yk1AIADWQ-A3q4946.m4a\r\n长生不死741$http://audio.xmcdn.com/group42/M0B/B7/E9/wKgJ9FrR-erAyVcDAHBpNZdv6UI894.m4a\r\n长生不死742$http://audio.xmcdn.com/group40/M04/7C/D3/wKgJT1rR-lDAMHxwAHmJfDstAMI324.m4a\r\n长生不死743$http://audio.xmcdn.com/group41/M00/B6/A9/wKgJ8lrR-rfieBl_AHS-FFcSqIw022.m4a\r\n长生不死744$http://audio.xmcdn.com/group40/M00/7D/00/wKgJT1rR-w6wUHykAG1cADG0PW0736.m4a\r\n长生不死745$http://audio.xmcdn.com/group42/M09/B8/28/wKgJ9FrR-3PxWP_8AHhvjEaXJ6k258.m4a\r\n长生不死746$http://audio.xmcdn.com/group41/M02/B6/D8/wKgJ8lrR--OwRSTXAH4RjIUxmPE266.m4a\r\n长生不死747$http://audio.xmcdn.com/group41/M0A/B6/DB/wKgJ8VrR_EaCgNm4AHfCRYQYHdY627.m4a\r\n长生不死748$http://audio.xmcdn.com/group40/M0A/7E/16/wKgJVFrR_K3w_TjcAHtZhCSSNog460.m4a\r\n长生不死749$http://audio.xmcdn.com/group42/M03/B8/6E/wKgJ9FrR_RmxEn6UAHX2p7nQ8p4316.m4a\r\n长生不死750$http://audio.xmcdn.com/group42/M07/B3/9D/wKgJ81rR_X7wwlg7AHRqLQqdVFM935.m4a\r\n长生不死751$http://audio.xmcdn.com/group41/M07/B4/43/wKgJ8lrR6rORv3h6AHJg4FMnzIY492.m4a\r\n长生不死752$http://audio.xmcdn.com/group40/M00/7A/94/wKgJT1rR6t_SqDHjAHkisW4416I385.m4a\r\n长生不死753$http://audio.xmcdn.com/group42/M05/B5/BB/wKgJ9FrR6yDgNBlEAHvycHsrda8960.m4a\r\n长生不死754$http://audio.xmcdn.com/group41/M03/B4/59/wKgJ8lrR62ezlvrgAHs9ne-5BCA836.m4a\r\n长生不死755$http://audio.xmcdn.com/group40/M0A/7A/AE/wKgJT1rR67-ydMW9AHPRc3LKxBc292.m4a\r\n长生不死756$http://audio.xmcdn.com/group42/M0B/B5/E4/wKgJ9FrR7CTxAqEsAHLjkf_44fw751.m4a\r\n长生不死757$http://audio.xmcdn.com/group40/M09/7B/98/wKgJVFrR7H_RUAtTAHbCxUGWjOY358.m4a\r\n长生不死758$http://audio.xmcdn.com/group41/M07/B4/79/wKgJ8VrR7NzCo60CAG-qTxPGWlo881.m4a\r\n长生不死759$http://audio.xmcdn.com/group41/M04/B4/7D/wKgJ8VrR7USSO_rPAHFIaInrLsA507.m4a\r\n长生不死760$http://audio.xmcdn.com/group40/M02/7B/BD/wKgJVFrR7beywDW9AHQDY-DM634522.m4a\r\n长生不死761$http://audio.xmcdn.com/group40/M0B/7B/C9/wKgJVFrR7hrwf3cYAG9iW5PyQvY456.m4a\r\n长生不死762$http://audio.xmcdn.com/group42/M04/B1/4C/wKgJ81rR7m-jE4xBAG9g4yuMjmA466.m4a\r\n长生不死763$http://audio.xmcdn.com/group42/M08/B6/39/wKgJ9FrR7tfh2LG4AHgY6VERhek625.m4a\r\n长生不死764$http://audio.xmcdn.com/group42/M00/B1/67/wKgJ81rR70GgVVY_AHdhWXW6VX0871.m4a\r\n长生不死765$http://audio.xmcdn.com/group41/M0A/B4/EB/wKgJ8lrR76zQfAwSAHUjMSnb240282.m4a\r\n长生不死766$http://audio.xmcdn.com/group42/M05/B1/83/wKgJ81rR8BWhYfC1AHcsfuqvpj4546.m4a\r\n长生不死767$http://audio.xmcdn.com/group42/M0B/B6/6F/wKgJ9FrR8HqSxefYAHiaIrsphqE229.m4a\r\n长生不死768$http://audio.xmcdn.com/group40/M0A/7B/5D/wKgJT1rR8PnACPtkAHLyQDp9tLk348.m4a\r\n长生不死769$http://audio.xmcdn.com/group42/M07/B6/92/wKgJ9FrR8UGzc5RXAHHs3uIyTL0753.m4a\r\n长生不死770$http://audio.xmcdn.com/group41/M04/B5/32/wKgJ8lrR8a3SpwYTAHqfBUBSuEU977.m4a\r\n长生不死771$http://audio.xmcdn.com/group40/M09/7B/8A/wKgJT1rR8hDxIiUpAG3jGJJyZlc182.m4a\r\n长生不死772$http://audio.xmcdn.com/group41/M06/B5/4E/wKgJ8lrR8nijz0VYAHPkjQjtRsQ054.m4a\r\n长生不死773$http://audio.xmcdn.com/group42/M05/B6/CD/wKgJ9FrR8ujjEb1VAG7MlCukHA4231.m4a\r\n长生不死774$http://audio.xmcdn.com/group41/M0A/B5/76/wKgJ8lrR8zyQzvcrAHikZ7c4RNQ067.m4a\r\n长生不死775$http://audio.xmcdn.com/group41/M07/B5/6C/wKgJ8VrR85WB8jGRAGzNj-eK23U254.m4a\r\n长生不死776$http://audio.xmcdn.com/group40/M08/7B/D0/wKgJT1rR9AiAIk6JAHCm4LXjahs377.m4a\r\n长生不死777$http://audio.xmcdn.com/group42/M02/B7/07/wKgJ9FrR9Gvjpg73AHHJodmxeYY220.m4a\r\n长生不死778$http://audio.xmcdn.com/group41/M02/B5/A9/wKgJ8lrR9Mvhbs4_AHVg3F9dP5o179.m4a\r\n长生不死779$http://audio.xmcdn.com/group41/M06/B5/BB/wKgJ8lrR9TyggOjxAHHQ9_otU5k401.m4a\r\n长生不死780$http://audio.xmcdn.com/group42/M06/B7/3A/wKgJ9FrR9ZGTzxRwAHXU3qVUUDk039.m4a\r\n长生不死781$http://audio.xmcdn.com/group42/M03/B2/68/wKgJ81rR9fSCElmCAHFFeW1VM2M119.m4a\r\n长生不死782$http://audio.xmcdn.com/group40/M00/7C/F7/wKgJVFrR9liiIUf9AHEVBL-5ZX8033.m4a\r\n长生不死783$http://audio.xmcdn.com/group42/M01/B2/8C/wKgJ81rR9rqTZ6tVAHVDfmfRCZQ110.m4a\r\n长生不死784$http://audio.xmcdn.com/group42/M09/B2/99/wKgJ81rR9yCzl9PuAHrW08sVAXs156.m4a\r\n长生不死785$http://audio.xmcdn.com/group40/M02/7C/5D/wKgJT1rR93Xx_0ykAG-FlxuunBw839.m4a\r\n长生不死786$http://audio.xmcdn.com/group42/M04/B2/C2/wKgJ81rR99uxNapyAHSwpqv7kl8898.m4a\r\n长生不死787$http://audio.xmcdn.com/group40/M05/7C/83/wKgJT1rR-EbzQYoZAHH-fEcxs7Y502.m4a\r\n长生不死788$http://audio.xmcdn.com/group42/M00/B7/B4/wKgJ9FrR-Jjymdo3AG2oW9OGV-s504.m4a\r\n长生不死789$http://audio.xmcdn.com/group41/M09/B6/58/wKgJ8lrR-P_BkBfYAHfPfV48d4o977.m4a\r\n长生不死790$http://audio.xmcdn.com/group42/M06/B7/D5/wKgJ9FrR-U-wjHzwAGzKoISL7EI474.m4a\r\n长生不死791$http://audio.xmcdn.com/group41/M05/B6/66/wKgJ8VrR-bbQRhCBAHOMcs3uX8w572.m4a\r\n长生不死792$http://audio.xmcdn.com/group41/M03/B6/7B/wKgJ8VrR-j3DtyjJAG21k-9fK0Y840.m4a\r\n长生不死793$http://audio.xmcdn.com/group41/M08/B6/87/wKgJ8VrR-nmQ75idAHO0FXRWna8173.m4a\r\n长生不死794$http://audio.xmcdn.com/group42/M0A/B3/38/wKgJ81rR-trA9zYMAHLmtj5tRX8812.m4a\r\n长生不死795$http://audio.xmcdn.com/group42/M09/B3/42/wKgJ81rR-zWRaGAHAG3V4cgy4rE182.m4a\r\n长生不死796$http://audio.xmcdn.com/group42/M02/B8/38/wKgJ9FrR-5TDUh_aAHNh3EcPM1U929.m4a\r\n长生不死797$http://audio.xmcdn.com/group40/M0B/7D/20/wKgJT1rR-_uS1px-AHLDRNKwvr8738.m4a\r\n长生不死798$http://audio.xmcdn.com/group42/M04/B3/73/wKgJ81rR_GLjB49pAHkYaZVr9rQ779.m4a\r\n长生不死799$http://audio.xmcdn.com/group41/M05/B6/EA/wKgJ8VrR_NGALigeAHL1L_EbSy4727.m4a\r\n长生不死800$http://audio.xmcdn.com/group41/M03/B7/21/wKgJ8lrR_Tyy3uooAHW4-DoQzNg694.m4a\r\n长生不死801$http://audio.xmcdn.com/group41/M07/B4/44/wKgJ8lrR6rjQDvGVAHHxSDKiocs328.m4a\r\n长生不死802$http://audio.xmcdn.com/group41/M08/B4/37/wKgJ8VrR6vPQDr7tAHbhmjecGVQ625.m4a\r\n长生不死803$http://audio.xmcdn.com/group42/M05/B5/C2/wKgJ9FrR6y_yrvW2AH9b8GO3YEw457.m4a\r\n长生不死804$http://audio.xmcdn.com/group41/M03/B4/48/wKgJ8VrR63SzX-MGAHXAUdKB0P4704.m4a\r\n长生不死805$http://audio.xmcdn.com/group41/M01/B4/58/wKgJ8VrR6_HxHyv5AIEKM-Deyh0903.m4a\r\n长生不死806$http://audio.xmcdn.com/group40/M08/7B/8B/wKgJVFrR7EXTitK9AH_wQzh5fuE218.m4a\r\n长生不死807$http://audio.xmcdn.com/group41/M05/B4/6C/wKgJ8VrR7KbzPwIRAHRebV_cNJU051.m4a\r\n长生不死808$http://audio.xmcdn.com/group40/M06/7B/A5/wKgJVFrR7RrR5gcEAHFlxocrXpQ140.m4a\r\n长生不死809$http://audio.xmcdn.com/group42/M03/B1/29/wKgJ81rR7XrRzPMOAHkPnDT2c2A429.m4a\r\n长生不死810$http://audio.xmcdn.com/group42/M0A/B6/13/wKgJ9FrR7dnRqxBsAG_yRKKtnX8115.m4a\r\n长生不死811$http://audio.xmcdn.com/group41/M0B/B4/BD/wKgJ8lrR7kGCns2QAHabHddRUM4451.m4a\r\n长生不死812$http://audio.xmcdn.com/group40/M03/7B/15/wKgJT1rR7qnAO3guAHd-tz_4Q9I128.m4a\r\n长生不死813$http://audio.xmcdn.com/group40/M04/7B/1B/wKgJT1rR7w7BvgGeAG-xpYGb2AQ341.m4a\r\n长生不死814$http://audio.xmcdn.com/group40/M01/7B/29/wKgJT1rR73rxz4TIAHvgnEqjNHg007.m4a\r\n长生不死815$http://audio.xmcdn.com/group41/M08/B4/FA/wKgJ8lrR7-LyZcHrAHbUY43_1ZQ761.m4a\r\n长生不死816$http://audio.xmcdn.com/group40/M05/7B/51/wKgJT1rR8E2gG9z6AHNcMDinxFM488.m4a\r\n长生不死817$http://audio.xmcdn.com/group41/M05/B4/FC/wKgJ8VrR8LDQXi4rAHCyoV7rWkw679.m4a\r\n长生不死818$http://audio.xmcdn.com/group42/M03/B6/87/wKgJ9FrR8RiAxWemAHFhXwuBt1Y579.m4a\r\n长生不死819$http://audio.xmcdn.com/group41/M01/B5/15/wKgJ8VrR8YOzqH6sAHjO_Qy1MFE250.m4a\r\n长生不死820$http://audio.xmcdn.com/group40/M08/7B/7C/wKgJT1rR8efhTvsPAHJK22tcEIA184.m4a\r\n长生不死821$http://audio.xmcdn.com/group40/M09/7C/5C/wKgJVFrR8iKxiUdpAEhZppFW6Gk495.m4a\r\n长生不死822$http://audio.xmcdn.com/group42/M08/B6/C8/wKgJ9FrR8pOhZLtpAHSjciNFN-4699.m4a\r\n长生不死823$http://audio.xmcdn.com/group42/M06/B1/F1/wKgJ81rR8v2jvAGFAHoTg1hoXc8641.m4a\r\n长生不死824$http://audio.xmcdn.com/group42/M01/B6/DE/wKgJ9FrR82TxAF_cAHR3ZQJ9GzY124.m4a\r\n长生不死825$http://audio.xmcdn.com/group40/M06/7B/C5/wKgJT1rR88SStpXkAHFXF_NRspE117.m4a\r\n长生不死826$http://audio.xmcdn.com/group40/M08/7C/A3/wKgJVFrR9C2BwkxtAG6ghpB-IEI899.m4a\r\n长生不死827$http://audio.xmcdn.com/group42/M09/B7/15/wKgJ9FrR9IfB1_eoAHZAEyMYsCQ095.m4a\r\n长生不死828$http://audio.xmcdn.com/group42/M0B/B7/22/wKgJ9FrR9OqiitvGAH9QNJNZwKU358.m4a\r\n长生不死829$http://audio.xmcdn.com/group41/M06/B5/B2/wKgJ8VrR9VGCYZjoAH8W76tcM9U533.m4a\r\n长生不死830$http://audio.xmcdn.com/group41/M00/B5/D0/wKgJ8lrR9beDiVhEAH4O0xmG3I0342.m4a\r\n长生不死831$http://audio.xmcdn.com/group42/M03/B7/58/wKgJ9FrR9hqwln7qAHnUXysZklU829.m4a\r\n长生不死832$http://audio.xmcdn.com/group40/M0A/7C/36/wKgJT1rR9orioWNmAIlMv-b6j4k023.m4a\r\n长生不死833$http://audio.xmcdn.com/group41/M0A/B5/F5/wKgJ8VrR9u3gRkVbAHhZg9b4NII920.m4a\r\n长生不死834$http://audio.xmcdn.com/group40/M0B/7C/58/wKgJT1rR91KiiO-iAH7sjqTl3YA395.m4a\r\n长生不死835$http://audio.xmcdn.com/group42/M04/B7/8D/wKgJ9FrR97rRZ6KKAHq8YxNUOHM557.m4a\r\n长生不死836$http://audio.xmcdn.com/group41/M02/B6/1E/wKgJ8VrR-ByQnY0vAHhsnSENa_s940.m4a\r\n长生不死837$http://audio.xmcdn.com/group41/M06/B6/45/wKgJ8lrR-LaRAHX4AKLZJujT04M249.m4a\r\n长生不死838$http://audio.xmcdn.com/group41/M09/B6/5F/wKgJ8lrR-QzCILxsAHxHZg827OQ525.m4a\r\n长生不死839$http://audio.xmcdn.com/group40/M06/7C/B1/wKgJT1rR-ZbC0uWqAH7GKQJgfuk237.m4a\r\n长生不死840$http://audio.xmcdn.com/group42/M0B/B7/E9/wKgJ9FrR-eqya5ekAIKSQyf2QJY713.m4a\r\n长生不死841$http://audio.xmcdn.com/group40/M04/7C/CE/wKgJT1rR-kWDbnhRAH83cnk5cgM260.m4a\r\n长生不死842$http://audio.xmcdn.com/group42/M0A/B3/36/wKgJ81rR-siDVEL_AH0JO-jH-iU829.m4a\r\n长生不死843$http://audio.xmcdn.com/group40/M00/7D/CB/wKgJVFrR-wezF_SlAH0SQsbILxI351.m4a\r\n长生不死844$http://audio.xmcdn.com/group42/M09/B3/4E/wKgJ81rR-3jyeAl8AIOKbe63A5Y601.m4a\r\n长生不死845$http://audio.xmcdn.com/group41/M02/B6/D4/wKgJ8lrR-9uRJTcrAH37uW1kLVk788.m4a\r\n长生不死846$http://audio.xmcdn.com/group41/M0A/B6/ED/wKgJ8lrR_EThK3drAHzepT9IO2o830.m4a\r\n长生不死847$http://audio.xmcdn.com/group40/M0A/7E/14/wKgJVFrR_KqxwQb2AHnOgaDIWwQ045.m4a\r\n长生不死848$http://audio.xmcdn.com/group40/M05/7E/20/wKgJVFrR_VLA-eikAIwTdqWBt4g331.m4a\r\n长生不死849$http://audio.xmcdn.com/group42/M05/B8/83/wKgJ9FrR_Y6BWyiOAIJx9XpEYN8704.m4a\r\n长生不死850$http://audio.xmcdn.com/group41/M07/B7/2D/wKgJ8lrR_eaQKOaaAHfvyuSlaK4388.m4a\r\n长生不死851$http://audio.xmcdn.com/group40/M00/7A/8C/wKgJT1rR6smTantHAHVSLQOP_Y0513.m4a\r\n长生不死852$http://audio.xmcdn.com/group42/M02/B0/CF/wKgJ81rR6wORrHGcAHfGq1HrSlU068.m4a\r\n长生不死853$http://audio.xmcdn.com/group40/M05/7B/6A/wKgJVFrR61GjckAQAIFoLCHgaus080.m4a\r\n长生不死854$http://audio.xmcdn.com/group42/M00/B0/EB/wKgJ81rR66OgIC7LAHqqxWAH3Ro163.m4a\r\n长生不死855$http://audio.xmcdn.com/group42/M0B/B5/D7/wKgJ9FrR7AGRUB41AH4XatqTiLM614.m4a\r\n长生不死856$http://audio.xmcdn.com/group40/M09/7B/97/wKgJVFrR7H2TiZrkAIP_57JCUJQ813.m4a\r\n长生不死857$http://audio.xmcdn.com/group42/M09/B1/19/wKgJ81rR7Q2ggHJJALBPkZDmnps572.m4a\r\n长生不死858$http://audio.xmcdn.com/group42/M03/B1/25/wKgJ81rR7XOxW_G2AIDeWxh3PAg338.m4a\r\n长生不死859$http://audio.xmcdn.com/group42/M0A/B6/18/wKgJ9FrR7eai5uG7AIHiQjAtP6E898.m4a\r\n长生不死860$http://audio.xmcdn.com/group41/M0B/B4/A8/wKgJ8VrR7kuSekkzAH9qn2z494Y769.m4a\r\n长生不死861$http://audio.xmcdn.com/group41/M06/B4/B7/wKgJ8VrR7sLAbbbrAIWRAh1xwdE846.m4a\r\n长生不死862$http://audio.xmcdn.com/group42/M00/B1/66/wKgJ81rR70Dyh4peAID-c-Sy8Nc017.m4a\r\n长生不死863$http://audio.xmcdn.com/group41/M0A/B4/ED/wKgJ8lrR77HwzMYwAIOKbR4muQw785.m4a\r\n长生不死864$http://audio.xmcdn.com/group40/M05/7B/47/wKgJT1rR8DWTnj18AIVUlyYkflk736.m4a\r\n长生不死865$http://audio.xmcdn.com/group41/M05/B5/0B/wKgJ8lrR8J2wm78DAIDWzEmginU822.m4a\r\n长生不死866$http://audio.xmcdn.com/group42/M03/B1/9D/wKgJ81rR8QKBjQbNAHnBSpLTxcU702.m4a\r\n长生不死867$http://audio.xmcdn.com/group40/M02/7B/76/wKgJT1rR8XDBfNdlAHi2CdwdqGU647.m4a\r\n长生不死868$http://audio.xmcdn.com/group42/M0A/B1/C1/wKgJ81rR8dWS4-gNAH9I2lfTP1k972.m4a\r\n长生不死869$http://audio.xmcdn.com/group41/M03/B5/4D/wKgJ8lrR8kXhf-esAIMWa9WR5DY302.m4a\r\n长生不死870$http://audio.xmcdn.com/group41/M0B/B5/4B/wKgJ8VrR8rWjaHk6AH6LbOqlWgE620.m4a\r\n长生不死871$http://audio.xmcdn.com/group40/M00/7C/7B/wKgJVFrR8xqQKKenAHwc0F4PJf8742.m4a\r\n长生不死872$http://audio.xmcdn.com/group41/M07/B5/73/wKgJ8VrR86bjHMCtAHunVgABJ1s434.m4a\r\n长生不死873$http://audio.xmcdn.com/group42/M00/B2/1A/wKgJ81rR8-zS4CqrAHuYp0ulSIM668.m4a\r\n长生不死874$http://audio.xmcdn.com/group41/M09/B5/A0/wKgJ8lrR9GKxCZXuAIBCfAMMUIg690.m4a\r\n长生不死875$http://audio.xmcdn.com/group41/M02/B5/9A/wKgJ8VrR9NWA0fcPAIWeA57Qa7Y481.m4a\r\n长生不死876$http://audio.xmcdn.com/group41/M06/B5/A9/wKgJ8VrR9T2R1NJrAH38_0u8URk045.m4a\r\n长生不死877$http://audio.xmcdn.com/group41/M00/B5/C9/wKgJ8lrR9arTeOA8AHlHZdJ74u8291.m4a\r\n长生不死878$http://audio.xmcdn.com/group42/M03/B7/52/wKgJ9FrR9g2x7a1DAHooFJqAKWU627.m4a\r\n长生不死879$http://audio.xmcdn.com/group40/M0A/7C/36/wKgJT1rR9oqRhoIkAInQ6G3jYI4790.m4a\r\n长生不死880$http://audio.xmcdn.com/group41/M0A/B5/F7/wKgJ8VrR9vHyH53hAIgPjzNoue0916.m4a\r\n长生不死881$http://audio.xmcdn.com/group40/M0B/7D/22/wKgJVFrR90vD9nTMAHk7qfUafJY004.m4a\r\n长生不死882$http://audio.xmcdn.com/group42/M04/B2/B7/wKgJ81rR98XxM1lZAIHWUAi0f6Y087.m4a\r\n长生不死883$http://audio.xmcdn.com/group40/M05/7C/7A/wKgJT1rR-DPQdUIrAIb_6DRALh8783.m4a\r\n长生不死884$http://audio.xmcdn.com/group42/M00/B7/BA/wKgJ9FrR-Kaj2cqkAIOKbYnE90E700.m4a\r\n长生不死885$http://audio.xmcdn.com/group41/M09/B6/4C/wKgJ8VrR-Q6wOgFjAINFbDduOTc164.m4a\r\n长生不死886$http://audio.xmcdn.com/group42/M06/B7/D3/wKgJ9FrR-UqDFKCvAFhjZsThKzY772.m4a\r\n长生不死887$http://audio.xmcdn.com/group41/M05/B6/6E/wKgJ8VrR-cXw4w45AIfSGRf6cSg532.m4a\r\n长生不死888$http://audio.xmcdn.com/group41/M03/B6/8D/wKgJ8lrR-jqgxrR2AIacDEvrF2c280.m4a\r\n长生不死889$http://audio.xmcdn.com/group41/M00/B6/90/wKgJ8VrR-qrxW2zuAIHGKnsICAI980.m4a\r\n长生不死890$http://audio.xmcdn.com/group41/M04/B6/99/wKgJ8VrR-xmDtQ6kAIh30cgGblM352.m4a\r\n长生不死891$http://audio.xmcdn.com/group40/M03/7D/E0/wKgJVFrR-7Sj5WIWAIeaFZOSieE658.m4a\r\n长生不死892$http://audio.xmcdn.com/group40/M0B/7D/1E/wKgJT1rR-_jAsLodAIM7I13styQ727.m4a\r\n长生不死893$http://audio.xmcdn.com/group42/M08/B8/56/wKgJ9FrR_GvzZ4_FAIfXwf_QkV4694.m4a\r\n长生不死894$http://audio.xmcdn.com/group41/M05/B6/FF/wKgJ8lrR_NPQ_NdjAHwlncCbKj0758.m4a\r\n长生不死895$http://audio.xmcdn.com/group40/M05/7E/1E/wKgJVFrR_U6S8K90AIZqHUoAQsM820.m4a\r\n长生不死896$http://audio.xmcdn.com/group42/M07/B3/9F/wKgJ81rR_YGSNIGaAFYrHCvqCLM924.m4a\r\n长生不死897$http://audio.xmcdn.com/group41/M07/B7/1C/wKgJ8VrR_e7TCZWfAIUGwZGAwp0226.m4a\r\n长生不死898$http://audio.xmcdn.com/group42/M04/B3/C6/wKgJ81rR_k6gY9qxAKlBZc1tyB4722.m4a\r\n长生不死899$http://audio.xmcdn.com/group41/M06/B7/39/wKgJ8VrR_pyygc4MAIODGOmg7Ow492.m4a\r\n长生不死900$http://audio.xmcdn.com/group41/M06/B7/3A/wKgJ8VrR_p_gqz1eAH95TqAqRGk853.m4a\r\n长生不死901$http://audio.xmcdn.com/group40/M00/7B/63/wKgJVFrR6urA5aIsAIWQzC7LNu0829.m4a\r\n长生不死902$http://audio.xmcdn.com/group42/M02/B0/DC/wKgJ81rR6yjRPu-LAIIYY-f1Hxs166.m4a\r\n长生不死903$http://audio.xmcdn.com/group41/M03/B4/5F/wKgJ8lrR63fB6JiKAHrOAor61mk931.m4a\r\n长生不死904$http://audio.xmcdn.com/group40/M0A/7B/82/wKgJVFrR69jC-uy_AIn_5CwdVk4170.m4a\r\n长生不死905$http://audio.xmcdn.com/group40/M08/7A/C3/wKgJT1rR7Ejh_VuyAIjjBdNjj5U508.m4a\r\n长生不死906$http://audio.xmcdn.com/group41/M07/B4/6E/wKgJ8VrR7MCSLQPbAI0V6mSP0qI360.m4a\r\n长生不死907$http://audio.xmcdn.com/group40/M06/7A/E7/wKgJT1rR7TSCNtntAI00vyMUjT4715.m4a\r\n长生不死908$http://audio.xmcdn.com/group41/M0A/B4/A4/wKgJ8lrR7ZmyY1V9AH1izeRXxJg547.m4a\r\n长生不死909$http://audio.xmcdn.com/group42/M0A/B1/3C/wKgJ81rR7f_wwUdmAHf9AhuOqiI908.m4a\r\n长生不死910$http://audio.xmcdn.com/group42/M07/B6/29/wKgJ9FrR7mnCk3hwAHzCvn6bX5M254.m4a\r\n长生不死911$http://audio.xmcdn.com/group42/M08/B1/58/wKgJ81rR7tThRRNIAH6zE_pHZd4234.m4a\r\n长生不死912$http://audio.xmcdn.com/group42/M00/B1/67/wKgJ81rR70Gio7OPAH_aO0BXeCM920.m4a\r\n长生不死913$http://audio.xmcdn.com/group41/M0A/B4/D6/wKgJ8VrR77HibVVpAIjr0xXmGvs074.m4a\r\n长生不死914$http://audio.xmcdn.com/group40/M05/7B/40/wKgJT1rR8CWRh5m7AIT2mhyMx_s630.m4a\r\n长生不死915$http://audio.xmcdn.com/group41/M05/B5/0A/wKgJ8lrR8JryQMoLAIoeuuEAkIg580.m4a\r\n长生不死916$http://audio.xmcdn.com/group40/M0A/7B/5D/wKgJT1rR8PvRtlUcAHWtOx0W7lw867.m4a\r\n长生不死917$http://audio.xmcdn.com/group40/M02/7B/6F/wKgJT1rR8WDTT8PXAHtTotcVIK0783.m4a\r\n长生不死918$http://audio.xmcdn.com/group41/M04/B5/3F/wKgJ8lrR8cjwrJCIAHp9QG9IL5w906.m4a\r\n长生不死919$http://audio.xmcdn.com/group40/M09/7C/61/wKgJVFrR8izykWsjAHPLlYOcMCI353.m4a\r\n长生不死920$http://audio.xmcdn.com/group40/M07/7C/67/wKgJVFrR8qbC45kiAIZXB0vFDH4577.m4a\r\n长生不死921$http://audio.xmcdn.com/group40/M00/7C/78/wKgJVFrR8xKA76laAH8hM85aHv0748.m4a\r\n长生不死922$http://audio.xmcdn.com/group42/M04/B2/0D/wKgJ81rR84SQsLndAIPufzIIFRw184.m4a\r\n长生不死923$http://audio.xmcdn.com/group42/M00/B2/1A/wKgJ81rR8-yAWitlAH63elh6t6I722.m4a\r\n长生不死924$http://audio.xmcdn.com/group40/M08/7C/A5/wKgJVFrR9DHSYF6pAFiZvDMj8DE726.m4a\r\n长生不死925$http://audio.xmcdn.com/group40/M04/7B/EB/wKgJT1rR9Kuj4s0tAIVkvnvwJgk903.m4a\r\n长生不死926$http://audio.xmcdn.com/group41/M01/B5/A3/wKgJ8VrR9QzjDAh_AHta-yJZhEs105.m4a\r\n长生不死927$http://audio.xmcdn.com/group40/M01/7C/DB/wKgJVFrR9XOh-zHYAHvwwjF38kE453.m4a\r\n长生不死928$http://audio.xmcdn.com/group40/M03/7C/E5/wKgJVFrR9dvzB3qlAH36DJSk1eU596.m4a\r\n长生不死929$http://audio.xmcdn.com/group41/M03/B5/E4/wKgJ8lrR9j3yi53TAHkxYZqxxsk620.m4a\r\n长生不死930$http://audio.xmcdn.com/group42/M0A/B7/5E/wKgJ9FrR9qThqs3wAHVpraHEpTs784.m4a\r\n长生不死931$http://audio.xmcdn.com/group40/M08/7C/4A/wKgJT1rR9waxkel-AH7gmPpIGWA930.m4a\r\n长生不死932$http://audio.xmcdn.com/group41/M04/B6/16/wKgJ8lrR92ig7Nm8AHdIZV36__k102.m4a\r\n长生不死933$http://audio.xmcdn.com/group42/M07/B7/98/wKgJ9FrR983SISknAHovajF77oc754.m4a\r\n长生不死934$http://audio.xmcdn.com/group41/M07/B6/37/wKgJ8lrR-EqCguUDAHv8g4eFE3k219.m4a\r\n长生不死935$http://audio.xmcdn.com/group42/M01/B2/D5/wKgJ81rR-JPyHyUhAHM7rGtSjmI223.m4a\r\n长生不死936$http://audio.xmcdn.com/group41/M09/B6/45/wKgJ8VrR-P2gw0CxAH1D93_eYB0887.m4a\r\n长生不死937$http://audio.xmcdn.com/group41/M01/B6/51/wKgJ8VrR-WbBz8JiAHsBaSsOcVs893.m4a\r\n长生不死938$http://audio.xmcdn.com/group42/M05/B3/05/wKgJ81rR-c6DuWmHAHjcNQzG8wI721.m4a\r\n长生不死939$http://audio.xmcdn.com/group41/M03/B6/85/wKgJ8lrR-irgSMNcAHNWUrMQoBU853.m4a\r\n长生不死940$http://audio.xmcdn.com/group41/M00/B6/9E/wKgJ8lrR-qHh31TrAITk_OnbcFE265.m4a\r\n长生不死941$http://audio.xmcdn.com/group40/M00/7C/FD/wKgJT1rR-wjTeOQVAH_V1OhhNZc875.m4a\r\n长生不死942$http://audio.xmcdn.com/group42/M02/B8/39/wKgJ9FrR-5fg6oXAAHwPmDrf2G4701.m4a\r\n长生不死943$http://audio.xmcdn.com/group41/M02/B6/D2/wKgJ8lrR-9aia07_AHmDnqijv9I203.m4a\r\n长生不死944$http://audio.xmcdn.com/group41/M0A/B6/DA/wKgJ8VrR_EXBcra_AH7998Npo4U356.m4a\r\n长生不死945$http://audio.xmcdn.com/group40/M0A/7D/42/wKgJT1rR_KnycFVuAHfW0gef3X0990.m4a\r\n长生不死946$http://audio.xmcdn.com/group42/M03/B8/6D/wKgJ9FrR_RmRorAkAIHMCARqyQc601.m4a\r\n长生不死947$http://audio.xmcdn.com/group42/M05/B3/9C/wKgJ81rR_XrxBONWAHy-V7Mtndw874.m4a\r\n长生不死948$http://audio.xmcdn.com/group42/M02/B3/B9/wKgJ81rR_dDhGz3CAHdosrocngE581.m4a\r\n长生不死949$http://audio.xmcdn.com/group40/M09/7E/4D/wKgJVFrR_h3y8LF2AHgwZacEzo4975.m4a\r\n长生不死950$http://audio.xmcdn.com/group40/M06/7E/55/wKgJVFrR_lnQj-GUAHy58V1NWUo195.m4a\r\n长生不死951$http://audio.xmcdn.com/group41/M08/B4/39/wKgJ8VrR6vjhAqMrAH3CQvVlZZA658.m4a\r\n长生不死952$http://audio.xmcdn.com/group42/M02/B0/D6/wKgJ81rR6xaSl-H3AG4HzDC38no064.m4a\r\n长生不死953$http://audio.xmcdn.com/group41/M03/B4/5B/wKgJ8lrR62uDqO8tAHqDHqbhl2E026.m4a\r\n长生不死954$http://audio.xmcdn.com/group40/M0A/7B/78/wKgJVFrR676zo5kuAH6xnAX_2P8351.m4a\r\n长生不死955$http://audio.xmcdn.com/group40/M08/7A/BF/wKgJT1rR7EDjfqOzAHl6zWOQgtU927.m4a\r\n长生不死956$http://audio.xmcdn.com/group42/M01/B1/03/wKgJ81rR7JLThHQ-AH-g9U83c0I840.m4a\r\n长生不死957$http://audio.xmcdn.com/group40/M04/7A/D9/wKgJT1rR7QGTaRlyAHTVXnJhn90080.m4a\r\n长生不死958$http://audio.xmcdn.com/group41/M04/B4/9E/wKgJ8lrR7VvQidgSAHUqik6EMKQ898.m4a\r\n长生不死959$http://audio.xmcdn.com/group41/M03/B4/A9/wKgJ8lrR7cHgXqXXAHWo0T6nIfY299.m4a\r\n长生不死960$http://audio.xmcdn.com/group40/M0B/7B/07/wKgJT1rR7iyhc87eAHh4WW4OM5Q011.m4a\r\n长生不死961$http://audio.xmcdn.com/group40/M03/7B/10/wKgJT1rR7pfziWYeAH-stT3yGtA197.m4a\r\n长生不死962$http://audio.xmcdn.com/group40/M04/7B/17/wKgJT1rR7wOiBnnfAH-0C9a-V1Y758.m4a\r\n长生不死963$http://audio.xmcdn.com/group41/M09/B4/E5/wKgJ8lrR72yjSe3QAH9x-Y12HHY947.m4a\r\n长生不死964$http://audio.xmcdn.com/group41/M08/B4/DC/wKgJ8VrR79TTfbs_AHrkCsytDeE938.m4a\r\n长生不死965$http://audio.xmcdn.com/group41/M05/B4/F9/wKgJ8VrR8KmDgqRwAO_E26B2mDE607.m4a\r\n长生不死966$http://audio.xmcdn.com/group42/M03/B6/88/wKgJ9FrR8RqS8xzLAJ6kyoyK-Q8636.m4a\r\n长生不死967$http://audio.xmcdn.com/group41/M01/B5/25/wKgJ8lrR8XyxBWtiAHt_rwCRZyA736.m4a\r\n长生不死968$http://audio.xmcdn.com/group41/M03/B5/35/wKgJ8VrR8jzwpgbbAMgHigqesYM863.m4a\r\n长生不死969$http://audio.xmcdn.com/group41/M06/B5/57/wKgJ8lrR8ouSjR46AH5p3a7YwWk809.m4a\r\n长生不死970$http://audio.xmcdn.com/group42/M01/B1/FB/wKgJ81rR81viiLMVANxYv4Yd5bw545.m4a\r\n长生不死971$http://audio.xmcdn.com/group40/M06/7C/89/wKgJVFrR87GyhxRJAHu2BmKKHjU221.m4a\r\n长生不死972$http://audio.xmcdn.com/group41/M09/B5/81/wKgJ8VrR9CPxpSzZAIEXa6vGQSQ971.m4a\r\n长生不死973$http://audio.xmcdn.com/group41/M09/B5/87/wKgJ8VrR9FazzUW2AE8or_QFjvM551.m4a\r\n长生不死974$http://audio.xmcdn.com/group40/M04/7B/E7/wKgJT1rR9KPwC-3gAFVL6W77VLI114.m4a\r\n长生不死975$http://audio.xmcdn.com/group41/M01/B5/A2/wKgJ8VrR9QvCQ27BAHb8PG6ldFk803.m4a\r\n长生不死976$http://audio.xmcdn.com/group40/M01/7C/03/wKgJT1rR9Vegc_piAFz9FPxiQlc352.m4a\r\n长生不死977$http://audio.xmcdn.com/group41/M00/B5/BE/wKgJ8VrR9bmjhVNYAHhSLhoqW78187.m4a\r\n长生不死978$http://audio.xmcdn.com/group42/M03/B2/67/wKgJ81rR9fGD0GbbAEx_V9PAQzY551.m4a\r\n长生不死979$http://audio.xmcdn.com/group40/M00/7C/2C/wKgJT1rR9lvy9vOmAH3PdhKELPQ541.m4a\r\n长生不死980$http://audio.xmcdn.com/group42/M0A/B7/67/wKgJ9FrR9rnCRxhqAHUUge_DYDQ297.m4a\r\n长生不死981$http://audio.xmcdn.com/group42/M09/B2/98/wKgJ81rR9x_AiyYVAHT-fcZkt7s273.m4a\r\n长生不死982$http://audio.xmcdn.com/group40/M02/7D/32/wKgJVFrR94TjRF06AHgwmzL06pA865.m4a\r\n长生不死983$http://audio.xmcdn.com/group42/M07/B2/C3/wKgJ81rR9-fShwcdAH0Anw4loxA024.m4a\r\n长生不死984$http://audio.xmcdn.com/group41/M07/B6/2E/wKgJ8VrR-F6xTDs_AIBG48y7N3k303.m4a\r\n长生不死985$http://audio.xmcdn.com/group42/M02/B2/E3/wKgJ81rR-NmyvO-xAHp-uHA4Bg4210.m4a\r\n长生不死986$http://audio.xmcdn.com/group42/M06/B7/CC/wKgJ9FrR-TnBsxsVAIGdC0Y7D_k903.m4a\r\n长生不死987$http://audio.xmcdn.com/group40/M06/7D/83/wKgJVFrR-ZqAZdRaAHdqKkAj4QY136.m4a\r\n长生不死988$http://audio.xmcdn.com/group42/M0B/B7/F4/wKgJ9FrR-gHRIrU8AHhuFYF4s-U778.m4a\r\n长生不死989$http://audio.xmcdn.com/group41/M08/B6/92/wKgJ8lrR-mayMArDAH_0qm5bGP0918.m4a\r\n长生不死990$http://audio.xmcdn.com/group40/M01/7C/E4/wKgJT1rR-svxO8ycAHcfRjJilno831.m4a\r\n长生不死991$http://audio.xmcdn.com/group42/M09/B8/1E/wKgJ9FrR-zKhiJRrAHqzkpACJXE484.m4a\r\n长生不死992$http://audio.xmcdn.com/group42/M09/B3/5B/wKgJ81rR-5mSD1kNAH66n0KthN0275.m4a\r\n长生不死993$http://audio.xmcdn.com/group41/M02/B6/C2/wKgJ8VrR-92BSpF7AFQtk1HSdj8199.m4a\r\n长生不死994$http://audio.xmcdn.com/group40/M02/7D/F6/wKgJVFrR_HKxSr3XAHW0kQF2BL0455.m4a\r\n长生不死995$http://audio.xmcdn.com/group40/M0A/7D/38/wKgJT1rR_JWiBBePAFFWsZbnA9I040.m4a\r\n长生不死996$http://audio.xmcdn.com/group41/M05/B6/F0/wKgJ8VrR_PCyBqVeAGvlixbm7G4482.m4a\r\n长生不死997$http://audio.xmcdn.com/group40/M05/7E/22/wKgJVFrR_VWBXCBTAHcgvsRwG_w196.m4a\r\n长生不死998$http://audio.xmcdn.com/group42/M07/B3/B2/wKgJ81rR_baCeOkpAHm3AVAXQv4162.m4a\r\n长生不死999$http://audio.xmcdn.com/group40/M09/7E/3F/wKgJVFrR_gXxAHQyAHqEzK6NEd0826.m4a\r\n长生不死1000$http://audio.xmcdn.com/group42/M04/B3/C3/wKgJ81rR_kaC1MWKAIKFD39h-Nw757.m4a\r\n长生不死1001$http://audio.xmcdn.com/group41/M08/B4/3B/wKgJ8VrR6v7Cz-woAHhmu1__moE604.m4a\r\n长生不死1002$http://audio.xmcdn.com/group40/M05/7B/64/wKgJVFrR60GTcL-FAHp41Qg49RY786.m4a\r\n长生不死1003$http://audio.xmcdn.com/group40/M07/7B/75/wKgJVFrR65rxwjxrAICtrb8OLGk179.m4a\r\n长生不死1004$http://audio.xmcdn.com/group42/M06/B0/F0/wKgJ81rR6_XCu_MYAHj7CjArdOM300.m4a\r\n长生不死1005$http://audio.xmcdn.com/group41/M02/B4/60/wKgJ8VrR7FmR9EeZAHeNZjgBG9U580.m4a\r\n长生不死1006$http://audio.xmcdn.com/group41/M07/B4/86/wKgJ8lrR7MHDmcfTAHL7ETP8TVQ017.m4a\r\n长生不死1007$http://audio.xmcdn.com/group40/M06/7B/AD/wKgJVFrR7S3yL89_AHZUoTuRzho026.m4a\r\n长生不死1008$http://audio.xmcdn.com/group41/M0A/B4/8A/wKgJ8VrR7ZTAkdOVAHPNQ47nJpI714.m4a\r\n长生不死1009$http://audio.xmcdn.com/group42/M0A/B6/19/wKgJ9FrR7fmBG4tDAHEMM4Kc5wI528.m4a\r\n长生不死1010$http://audio.xmcdn.com/group42/M07/B6/28/wKgJ9FrR7mfw5ALxAHjBxc81cFQ016.m4a\r\n长生不死1011$http://audio.xmcdn.com/group42/M08/B1/57/wKgJ81rR7tLQOShrAHt24h0usHE375.m4a\r\n长生不死1012$http://audio.xmcdn.com/group42/M00/B1/67/wKgJ81rR70LTsAPlAHMfxQ0bvqk325.m4a\r\n长生不死1013$http://audio.xmcdn.com/group42/M06/B6/58/wKgJ9FrR78ODvGu8AH1ujbeWXvw651.m4a\r\n长生不死1014$http://audio.xmcdn.com/group40/M00/7C/07/wKgJVFrR8A_jB0zXAHigADDGopE331.m4a\r\n长生不死1015$http://audio.xmcdn.com/group42/M0B/B6/70/wKgJ9FrR8HvgpMXgAHwnGZkDIxs158.m4a\r\n长生不死1016$http://audio.xmcdn.com/group40/M0A/7C/20/wKgJVFrR8OaCoaRBAG5OSfF2JZ0093.m4a\r\n长生不死1017$http://audio.xmcdn.com/group40/M0B/7C/31/wKgJVFrR8Tyyzt8UAHrQ8dL0Tog143.m4a\r\n长生不死1018$http://audio.xmcdn.com/group42/M09/B1/BB/wKgJ81rR8aGRKHUXAHDS7jg5nA8275.m4a\r\n长生不死1019$http://audio.xmcdn.com/group40/M09/7B/88/wKgJT1rR8g3yWhhzAH_RadUIBDM497.m4a\r\n长生不死1020$http://audio.xmcdn.com/group41/M06/B5/3C/wKgJ8VrR8nyiOeIJAHaQ1QWxqJE435.m4a\r\n长生不死1021$http://audio.xmcdn.com/group40/M07/7B/A3/wKgJT1rR8s2j6X-MAGwwbhfwsHk612.m4a\r\n长生不死1022$http://audio.xmcdn.com/group41/M0A/B5/65/wKgJ8VrR80Ky-69PAHWdFVCXtgw606.m4a\r\n长生不死1023$http://audio.xmcdn.com/group41/M07/B5/70/wKgJ8VrR85-y0iKVAHUqinMgmjA513.m4a\r\n长生不死1024$http://audio.xmcdn.com/group40/M08/7B/D1/wKgJT1rR9ArDQyzEAHSBqQQqX-E452.m4a\r\n长生不死1025$http://audio.xmcdn.com/group42/M09/B7/0E/wKgJ9FrR9HjjV6R7AHneqK2zuEg992.m4a\r\n长生不死1026$http://audio.xmcdn.com/group41/M02/B5/99/wKgJ8VrR9NOBNcknAHshtpasLIc380.m4a\r\n长生不死1027$http://audio.xmcdn.com/group40/M00/7C/CB/wKgJVFrR9TfBQBwpAHzCvtY-jNI667.m4a\r\n长生不死1028$http://audio.xmcdn.com/group41/M08/B5/DD/wKgJ8VrR9m2iBzrGAPTqDO2mL-c593.m4a\r\n长生不死1029$http://audio.xmcdn.com/group40/M00/7C/FB/wKgJVFrR9mHiAHcoAHt_rxKl3Vc513.m4a\r\n长生不死1030$http://audio.xmcdn.com/group41/M0A/B5/E9/wKgJ8VrR9tXgFFHBAIij3lCEFws168.m4a\r\n长生不死1031$http://audio.xmcdn.com/group42/M0B/B2/A2/wKgJ81rR9zPwHpdeAHpf4s__wiQ262.m4a\r\n长生不死1032$http://audio.xmcdn.com/group41/M02/B6/17/wKgJ8VrR-AzgquvwAM7uE2z8Zvs750.m4a\r\n长生不死1033$http://audio.xmcdn.com/group41/M02/B6/31/wKgJ8lrR-ByA8LlBAFc6x_A7Z7k742.m4a\r\n长生不死1034$http://audio.xmcdn.com/group41/M06/B6/46/wKgJ8lrR-LiBDj46AKOMSwpCcs8222.m4a\r\n长生不死1035$http://audio.xmcdn.com/group40/M09/7D/6D/wKgJVFrR-RrQHx_HAHlvDZCx8GQ635.m4a\r\n长生不死1036$http://audio.xmcdn.com/group41/M01/B6/60/wKgJ8VrR-YaSBP6qAIUllyqxtek399.m4a\r\n长生不死1037$http://audio.xmcdn.com/group42/M05/B7/DF/wKgJ9FrR-crQEVJBAFHJcUg9eBk980.m4a\r\n长生不死1038$http://audio.xmcdn.com/group41/M03/B6/78/wKgJ8VrR-jbT8xZUAHfuUiZoyDY103.m4a\r\n长生不死1039$http://audio.xmcdn.com/group40/M01/7D/B4/wKgJVFrR-p7hSM7JAH98QYa7m7Q500.m4a\r\n长生不死1040$http://audio.xmcdn.com/group40/M00/7D/C7/wKgJVFrR-v-iYPuLAHEfSV_9MtQ483.m4a\r\n长生不死1041$http://audio.xmcdn.com/group41/M0B/B6/C9/wKgJ8lrR-2bwmqKKAHa1jbMeGbs177.m4a\r\n长生不死1042$http://audio.xmcdn.com/group42/M08/B8/4B/wKgJ9FrR_DDwfrO9AM_qpQ00_cM113.m4a\r\n长生不死1043$http://audio.xmcdn.com/group40/M02/7D/F9/wKgJVFrR_HeR674kAHaoVUwa6eQ602.m4a\r\n长生不死1044$http://audio.xmcdn.com/group42/M00/B3/86/wKgJ81rR_NuisPJWAHMolgEMEiU596.m4a\r\n长生不死1045$http://audio.xmcdn.com/group40/M05/7D/57/wKgJT1rR_WKioDX9AHwJus33snI956.m4a\r\n长生不死1046$http://audio.xmcdn.com/group40/M07/7E/34/wKgJVFrR_aeRGLFgAHQAcMnkNe4635.m4a\r\n长生不死1047$http://audio.xmcdn.com/group41/M07/B7/39/wKgJ8lrR_f7TVNU4AHaJfxrJdxo933.m4a\r\n长生不死1048$http://audio.xmcdn.com/group41/M08/B7/43/wKgJ8lrR_jORN8doAG6WPqi5q5Y376.m4a\r\n长生不死1049$http://audio.xmcdn.com/group42/M04/B3/CB/wKgJ81rR_mazJNr5AHidR2EGpS8445.m4a\r\n长生不死1050$http://audio.xmcdn.com/group42/M06/B3/D7/wKgJ81rR_omRs19FAHjQqvFr6tY821.m4a\r\n长生不死1051$http://audio.xmcdn.com/group42/M02/B5/B3/wKgJ9FrR6wrxS1ItAHDKHf7dHvM222.m4a\r\n长生不死1052$http://audio.xmcdn.com/group40/M05/7A/A0/wKgJT1rR61TCdpH1AIAPGWYDWHs572.m4a\r\n长生不死1053$http://audio.xmcdn.com/group42/M00/B0/ED/wKgJ81rR66eBFZDpAHZe6VY_xMY651.m4a\r\n长生不死1054$http://audio.xmcdn.com/group42/M06/B0/F8/wKgJ81rR7AuiyQmCAHtZupu-rQI014.m4a\r\n长生不死1055$http://audio.xmcdn.com/group40/M09/7A/CB/wKgJT1rR7HPSAjHuAHaj685a2TQ334.m4a\r\n长生不死1056$http://audio.xmcdn.com/group41/M07/B4/90/wKgJ8lrR7NzBcUPuAHhz82FkuUQ129.m4a\r\n长生不死1057$http://audio.xmcdn.com/group40/M06/7B/B5/wKgJVFrR7UDQrjVsAHg_FOk3VcY521.m4a\r\n长生不死1058$http://audio.xmcdn.com/group40/M02/7A/EF/wKgJT1rR7ayzeVpTAHPzPP5Qe-8410.m4a\r\n长生不死1059$http://audio.xmcdn.com/group41/M05/B4/9E/wKgJ8VrR7g_RLJPBAHx32rNjdkU208.m4a\r\n长生不死1060$http://audio.xmcdn.com/group42/M07/B6/31/wKgJ9FrR7nzy_CefAHq2gSWxxiE521.m4a\r\n长生不死1061$http://audio.xmcdn.com/group41/M00/B4/D2/wKgJ8lrR7tzh6bggAHalZkOmQEg169.m4a\r\n长生不死1062$http://audio.xmcdn.com/group42/M01/B6/48/wKgJ9FrR70XAIUG0AHVz9vpAV2Q409.m4a\r\n长生不死1063$http://audio.xmcdn.com/group42/M06/B6/53/wKgJ9FrR77XgVgH_AHfVW8c41v0028.m4a\r\n长生不死1064$http://audio.xmcdn.com/group42/M05/B1/86/wKgJ81rR8B2SnGnDAHtlQNqbnuk674.m4a\r\n长生不死1065$http://audio.xmcdn.com/group42/M0B/B6/71/wKgJ9FrR8H7iTKdHAHSL8kc6D80492.m4a\r\n长生不死1066$http://audio.xmcdn.com/group40/M0A/7B/53/wKgJT1rR8OOTxioVAHACas249Zo050.m4a\r\n长生不死1067$http://audio.xmcdn.com/group40/M02/7C/33/wKgJVFrR8U-QCtSOAHcJPaHsi7Q377.m4a\r\n长生不死1068$http://audio.xmcdn.com/group41/M04/B5/35/wKgJ8lrR8bWAt7epAHmQ0Vh-OMI634.m4a\r\n长生不死1069$http://audio.xmcdn.com/group40/M09/7B/8E/wKgJT1rR8hnxURjpAHSsQEl8c0M999.m4a\r\n长生不死1070$http://audio.xmcdn.com/group41/M06/B5/54/wKgJ8lrR8oWiuTKLAHtAjKvgAiY313.m4a\r\n长生不死1071$http://audio.xmcdn.com/group42/M05/B6/D0/wKgJ9FrR8vCysCxhAHIKPMURFhs797.m4a\r\n长生不死1072$http://audio.xmcdn.com/group40/M03/7C/82/wKgJVFrR806yEKpiAHAeUeKiuRw157.m4a\r\n长生不死1073$http://audio.xmcdn.com/group40/M06/7C/8B/wKgJVFrR87WgjlrlAHIgRWFb0z0830.m4a\r\n长生不死1074$http://audio.xmcdn.com/group40/M08/7C/AE/wKgJVFrR9EnQYCRFAHvR7bLRux8002.m4a\r\n长生不死1075$http://audio.xmcdn.com/group42/M09/B7/1A/wKgJ9FrR9JPxMgk9AHryuuz6Q0g711.m4a\r\n长生不死1076$http://audio.xmcdn.com/group40/M0B/7C/C0/wKgJVFrR9POCq3VgAHYfwoWlkKc968.m4a\r\n长生不死1077$http://audio.xmcdn.com/group40/M01/7C/CD/wKgJVFrR9VTAW-aCAG9AlhbHsEo451.m4a\r\n长生不死1078$http://audio.xmcdn.com/group41/M00/B5/B7/wKgJ8VrR9azDCX67AG5BEUZSPnI525.m4a\r\n长生不死1079$http://audio.xmcdn.com/group42/M03/B7/52/wKgJ9FrR9g3TnXb9AHaoVZ5AVfk462.m4a\r\n长生不死1080$http://audio.xmcdn.com/group41/M08/B5/F4/wKgJ8lrR9nXAc63AAHCfi0JDgEc866.m4a\r\n长生不死1081$http://audio.xmcdn.com/group41/M0A/B5/FE/wKgJ8lrR9trAYqpuAHaJf_dTJos791.m4a\r\n长生不死1082$http://audio.xmcdn.com/group42/M09/B7/74/wKgJ9FrR9x_wL5-dAFBUQWezXCI152.m4a\r\n长生不死1083$http://audio.xmcdn.com/group40/M02/7D/36/wKgJVFrR94yRi0msAHmIBKt5hG4949.m4a\r\n长生不死1084$http://audio.xmcdn.com/group42/M07/B7/A2/wKgJ9FrR9-2AF3agAHI_G3WVQZk634.m4a\r\n长生不死1085$http://audio.xmcdn.com/group41/M07/B6/23/wKgJ8VrR-EnjXpeXAG6k7fhg0lk862.m4a\r\n长生不死1086$http://audio.xmcdn.com/group42/M01/B2/E0/wKgJ81rR-KyAARfhAHNpMUmfRFg895.m4a\r\n长生不死1087$http://audio.xmcdn.com/group40/M09/7C/9C/wKgJT1rR-RagiL_wAHY6MXNuRDc488.m4a\r\n长生不死1088$http://audio.xmcdn.com/group40/M06/7D/83/wKgJVFrR-ZzAAVMMAH4u6pt7TvU539.m4a\r\n长生不死1089$http://audio.xmcdn.com/group40/M0B/7D/8F/wKgJVFrR-eChfmPLAHdy-91luQQ845.m4a\r\n长生不死1090$http://audio.xmcdn.com/group40/M04/7D/9E/wKgJVFrR-kXCKjqiAHIRlkZh5is490.m4a\r\n长生不死1091$http://audio.xmcdn.com/group41/M00/B6/9E/wKgJ8lrR-qCRuNiyAG8hwCaFVgE876.m4a\r\n长生不死1092$http://audio.xmcdn.com/group40/M00/7C/F8/wKgJT1rR-wGjRQ9QAHRkS9NSxJA151.m4a\r\n长生不死1093$http://audio.xmcdn.com/group41/M0B/B6/C5/wKgJ8lrR-12gWc2xAG_HrhPQ2vI027.m4a\r\n长生不死1094$http://audio.xmcdn.com/group40/M03/7D/16/wKgJT1rR-8CyQ8CNAHcsfkFe7zM164.m4a\r\n长生不死1095$http://audio.xmcdn.com/group42/M08/B3/68/wKgJ81rR_CWyc2fwAHCDpM_UyOs580.m4a\r\n长生不死1096$http://audio.xmcdn.com/group40/M0A/7D/FD/wKgJVFrR_H_yo-jqAGq1k_x4Hb0984.m4a\r\n长生不死1097$http://audio.xmcdn.com/group42/M00/B3/8A/wKgJ81rR_OTTOZEmAHEmo_3wEpM671.m4a\r\n长生不死1098$http://audio.xmcdn.com/group40/M05/7E/1E/wKgJVFrR_U6R6yvyAHTIJvFZd0g747.m4a\r\n长生不死1099$http://audio.xmcdn.com/group42/M07/B3/AD/wKgJ81rR_a3wsABvAHjMRMvuYS8584.m4a\r\n长生不死1100$http://audio.xmcdn.com/group40/M09/7E/3F/wKgJVFrR_gTjxEq0AHewp4CK1xk852.m4a\r\n长生不死1101$http://audio.xmcdn.com/group42/M02/B0/DD/wKgJ81rR6yugGxoxAHDtXUiRCS8385.m4a\r\n长生不死1102$http://audio.xmcdn.com/group41/M03/B4/60/wKgJ8lrR63iwKFkDAHyxHws72J8816.m4a\r\n长生不死1103$http://audio.xmcdn.com/group40/M0A/7B/81/wKgJVFrR69bAnDHdAH21Cm3Niwg398.m4a\r\n长生不死1104$http://audio.xmcdn.com/group41/M02/B4/5E/wKgJ8VrR7FLyhNlpAIHvRGJ9HZc582.m4a\r\n长生不死1105$http://audio.xmcdn.com/group42/M07/B1/0D/wKgJ81rR7LaS1GUzAHs9nUNSYik147.m4a\r\n长生不死1106$http://audio.xmcdn.com/group42/M09/B1/1C/wKgJ81rR7RTwkQKdAHxqo7rq3Pk487.m4a\r\n长生不死1107$http://audio.xmcdn.com/group42/M03/B1/2A/wKgJ81rR7X6ypR4RAHXHp4-EsTc877.m4a\r\n长生不死1108$http://audio.xmcdn.com/group42/M0A/B6/18/wKgJ9FrR7eayNElUAHrbOdIGV1U598.m4a\r\n长生不死1109$http://audio.xmcdn.com/group42/M04/B6/22/wKgJ9FrR7laxCyyZAHorA4pNs0g438.m4a\r\n长生不死1110$http://audio.xmcdn.com/group42/M08/B6/34/wKgJ9FrR7srQkN83AHtz7_XuAis139.m4a\r\n长生不死1111$http://audio.xmcdn.com/group42/M01/B6/3D/wKgJ9FrR7yzSGXV-AHjjjhVyOr4681.m4a\r\n长生不死1112$http://audio.xmcdn.com/group40/M01/7B/33/wKgJT1rR75LB60EaAH5z8A-43jw868.m4a\r\n长生不死1113$http://audio.xmcdn.com/group42/M07/B6/5D/wKgJ9FrR7_nj_-w5AHbHK0hyag8547.m4a\r\n长生不死1114$http://audio.xmcdn.com/group42/M02/B1/8A/wKgJ81rR8G3DAq_gAHu49c7lUWk463.m4a\r\n长生不死1115$http://audio.xmcdn.com/group41/M05/B5/1C/wKgJ8lrR8MqRBtmwAHYYbOOYIUM933.m4a\r\n长生不死1116$http://audio.xmcdn.com/group42/M07/B1/B1/wKgJ81rR8UGCHVXNAIW82XBpQ88142.m4a\r\n长生不死1117$http://audio.xmcdn.com/group41/M04/B5/2F/wKgJ8lrR8aex1FEjAHcJPYzAc4U990.m4a\r\n长生不死1118$http://audio.xmcdn.com/group40/M09/7B/8B/wKgJT1rR8hPj8OPXAHc1S0KgUaI134.m4a\r\n长生不死1119$http://audio.xmcdn.com/group41/M06/B5/4E/wKgJ8lrR8njivyYJAH0oR2457m0606.m4a\r\n长生不死1120$http://audio.xmcdn.com/group40/M07/7B/A8/wKgJT1rR8tuzu7IgAHLJIu-_QvE927.m4a\r\n长生不死1121$http://audio.xmcdn.com/group41/M0A/B5/75/wKgJ8lrR8zng3Z0SAG1gZyfxmBs687.m4a\r\n长生不死1122$http://audio.xmcdn.com/group41/M07/B5/81/wKgJ8lrR852T-V16AHT9BXfmGU8427.m4a\r\n长生不死1123$http://audio.xmcdn.com/group40/M08/7C/A3/wKgJVFrR9C3DBZ-rAHR-ul-1LIw010.m4a\r\n长生不死1124$http://audio.xmcdn.com/group42/M02/B7/05/wKgJ9FrR9GiC26qeAHPYzVyUHjo472.m4a\r\n长生不死1125$http://audio.xmcdn.com/group41/M02/B5/A8/wKgJ8lrR9Muj_s2LAG_MFL8IvrY624.m4a\r\n长生不死1126$http://audio.xmcdn.com/group42/M04/B2/4E/wKgJ81rR9SqBo-tsAHVWmFWvTHk067.m4a\r\n长生不死1127$http://audio.xmcdn.com/group42/M07/B2/60/wKgJ81rR9ZjSL1RCAHtMTNpwNqo005.m4a\r\n长生不死1128$http://audio.xmcdn.com/group42/M03/B7/48/wKgJ9FrR9fnAE0SSAHFotWSUFdY948.m4a\r\n长生不死1129$http://audio.xmcdn.com/group40/M00/7C/2E/wKgJT1rR9l_idkigAHG94TZeFr0633.m4a\r\n长生不死1130$http://audio.xmcdn.com/group42/M0A/B7/6A/wKgJ9FrR9sGw9zm7AHn-9S92jUU004.m4a\r\n长生不死1131$http://audio.xmcdn.com/group42/M09/B7/73/wKgJ9FrR9x2hIT5cAHLn-Kl2bIo689.m4a\r\n长生不死1132$http://audio.xmcdn.com/group40/M02/7C/62/wKgJT1rR936iAe9_AHT1q4R7LOA473.m4a\r\n长生不死1133$http://audio.xmcdn.com/group42/M07/B7/A0/wKgJ9FrR9-mCmO_jAHbEPAMjwGw447.m4a\r\n长生不死1134$http://audio.xmcdn.com/group41/M07/B6/24/wKgJ8VrR-EuhvmS_AHpaAB6YKzA366.m4a\r\n长生不死1135$http://audio.xmcdn.com/group41/M06/B6/44/wKgJ8lrR-LSDBrfbAHinWtSG_tQ170.m4a\r\n长生不死1136$http://audio.xmcdn.com/group40/M09/7D/6B/wKgJVFrR-ReBNqREAHUgQkIFhbw158.m4a\r\n长生不死1137$http://audio.xmcdn.com/group41/M01/B6/6C/wKgJ8lrR-XajqK4EAHN34E7KL7w349.m4a\r\n长生不死1138$http://audio.xmcdn.com/group42/M0B/B7/EB/wKgJ9FrR-e-D6p6kAHOJf_QDH6w577.m4a\r\n长生不死1139$http://audio.xmcdn.com/group41/M03/B6/8F/wKgJ8lrR-j6A4UFLAHKP3C9KIyM200.m4a\r\n长生不死1140$http://audio.xmcdn.com/group41/M00/B6/8D/wKgJ8VrR-qbxH34iAHR3ZakDkUY662.m4a\r\n长生不死1141$http://audio.xmcdn.com/group40/M00/7C/FC/wKgJT1rR-wizIA7PAHHod1bE1Bo150.m4a\r\n长生不死1142$http://audio.xmcdn.com/group41/M0B/B6/B7/wKgJ8VrR-2bSSSRxAHUEW6DVACA502.m4a\r\n长生不死1143$http://audio.xmcdn.com/group41/M02/B6/CE/wKgJ8lrR-8_BFyk9AHb3n4ZG3I0873.m4a\r\n长生不死1144$http://audio.xmcdn.com/group42/M08/B3/6E/wKgJ81rR_C-xU6BXAHwokPDVZjE339.m4a\r\n长生不死1145$http://audio.xmcdn.com/group40/M0A/7E/0A/wKgJVFrR_JiwH-fmAHwv5kGZLyk941.m4a\r\n长生不死1146$http://audio.xmcdn.com/group41/M09/B7/09/wKgJ8lrR_PnzhXmYAHRPvh09fLI291.m4a\r\n长生不死1147$http://audio.xmcdn.com/group40/M05/7D/56/wKgJT1rR_WHQo3xfAHWIg-uKw-c419.m4a\r\n长生不死1148$http://audio.xmcdn.com/group42/M07/B8/94/wKgJ9FrR_cex-cpCAHdIZcFeHfg080.m4a\r\n长生不死1149$http://audio.xmcdn.com/group40/M09/7E/46/wKgJVFrR_hGQG_1ZAHUx4KK1AcM444.m4a\r\n长生不死1150$http://audio.xmcdn.com/group42/M04/B8/A4/wKgJ9FrR_kqRzY-tAHu75F47MIE229.m4a\r\n长生不死1151$http://audio.xmcdn.com/group42/M05/B5/C0/wKgJ9FrR6yrDJ_F1AHGNbfMTda0279.m4a\r\n长生不死1152$http://audio.xmcdn.com/group42/M00/B0/EC/wKgJ81rR66WS7tg_AHcAcEICw9w851.m4a\r\n长生不死1153$http://audio.xmcdn.com/group40/M0A/7A/B8/wKgJT1rR69mBMHj3AHl_M2zahUQ949.m4a\r\n长生不死1154$http://audio.xmcdn.com/group40/M08/7A/BE/wKgJT1rR7D2R3xwVAHqanhrsqFc382.m4a\r\n长生不死1155$http://audio.xmcdn.com/group42/M01/B5/EA/wKgJ9FrR7KihdVL8AH0U-2dsMPs107.m4a\r\n长生不死1156$http://audio.xmcdn.com/group42/M09/B1/11/wKgJ81rR7Onh_7j4AFQ8QtiG1i8853.m4a\r\n长生不死1157$http://audio.xmcdn.com/group41/M04/B4/84/wKgJ8VrR7VSBQiDqAG-Fl7C5-cw232.m4a\r\n长生不死1158$http://audio.xmcdn.com/group40/M02/7A/F2/wKgJT1rR7bLRkOvGAHT4m8qNV_E000.m4a\r\n长生不死1159$http://audio.xmcdn.com/group40/M0B/7B/C9/wKgJVFrR7huRBZwGAHWLqP3ITyA884.m4a\r\n长生不死1160$http://audio.xmcdn.com/group40/M03/7B/0E/wKgJT1rR7pOivwuEAH0GTI9pVSk336.m4a\r\n长生不死1161$http://audio.xmcdn.com/group41/M00/B4/C3/wKgJ8VrR7vHz06TqAHSKew2zNOE981.m4a\r\n长生不死1162$http://audio.xmcdn.com/group40/M07/7B/F0/wKgJVFrR71nAvtGfAHlWFawWRDU676.m4a\r\n长生不死1163$http://audio.xmcdn.com/group42/M09/B1/75/wKgJ81rR77mx5Q08AHJbAt_FS7g776.m4a\r\n长生不死1164$http://audio.xmcdn.com/group42/M08/B6/67/wKgJ9FrR8CCDiBR0AHGcHP7FLJs381.m4a\r\n长生不死1165$http://audio.xmcdn.com/group42/M0B/B6/76/wKgJ9FrR8IiypKOPAHc8pT1OFjk160.m4a\r\n长生不死1166$http://audio.xmcdn.com/group40/M0A/7C/27/wKgJVFrR8PjAQMXHAHNI5FUcXXo646.m4a\r\n长生不死1167$http://audio.xmcdn.com/group40/M02/7B/6B/wKgJT1rR8VeCeV4GAHTvzZOQukk561.m4a\r\n长生不死1168$http://audio.xmcdn.com/group41/M04/B5/3A/wKgJ8lrR8b_CmUz7AHU0z5pti7M296.m4a\r\n长生不死1169$http://audio.xmcdn.com/group40/M09/7C/5E/wKgJVFrR8ibCWIjJAGudl_skOM8120.m4a\r\n长生不死1170$http://audio.xmcdn.com/group41/M06/B5/54/wKgJ8lrR8oWhyfHyAHhVHbKbrlU676.m4a\r\n长生不死1171$http://audio.xmcdn.com/group42/M05/B1/EF/wKgJ81rR8u2QxPv5AHhrIiECaXY581.m4a\r\n长生不死1172$http://audio.xmcdn.com/group40/M03/7B/BA/wKgJT1rR81fy_wqNAH_hlJVMgKk438.m4a\r\n长生不死1173$http://audio.xmcdn.com/group40/M06/7B/C2/wKgJT1rR87zxkWG4AHRORqsMYio150.m4a\r\n长生不死1174$http://audio.xmcdn.com/group41/M09/B5/82/wKgJ8VrR9CWCvhY8AHTOBKkrGQQ043.m4a\r\n长生不死1175$http://audio.xmcdn.com/group42/M02/B2/38/wKgJ81rR9I6RlVdNAHZwh8boGCs686.m4a\r\n长生不死1176$http://audio.xmcdn.com/group40/M0B/7B/F5/wKgJT1rR9PSQY2IsAHW9Ytgkwls824.m4a\r\n长生不死1177$http://audio.xmcdn.com/group40/M01/7C/CD/wKgJVFrR9VSS5NOeAHXztLqnt7w724.m4a\r\n长生不死1178$http://audio.xmcdn.com/group41/M00/B5/C9/wKgJ8lrR9arjwr2UAG4fTIrC-GU839.m4a\r\n长生不死1179$http://audio.xmcdn.com/group42/M03/B7/51/wKgJ9FrR9gqgwRRWAG59RjdiPBk347.m4a\r\n长生不死1180$http://audio.xmcdn.com/group40/M00/7C/FC/wKgJVFrR9mODScYnAG8TEffzXjQ565.m4a\r\n长生不死1181$http://audio.xmcdn.com/group42/M0A/B7/70/wKgJ9FrR9s2BP_tVAHVz9saRhsU426.m4a\r\n长生不死1182$http://audio.xmcdn.com/group42/M09/B7/7A/wKgJ9FrR9yzgSl0IAHGR1A36As8828.m4a\r\n长生不死1183$http://audio.xmcdn.com/group40/M02/7C/66/wKgJT1rR94bTw7ilAG4-IuigZiY886.m4a\r\n长生不死1184$http://audio.xmcdn.com/group42/M07/B2/C5/wKgJ81rR9-yBgu76AHFUKBD9Abs181.m4a\r\n长生不死1185$http://audio.xmcdn.com/group40/M07/7C/8A/wKgJT1rR-G6SY1nKAJBiQauKidA999.m4a\r\n长生不死1186$http://audio.xmcdn.com/group41/M06/B6/38/wKgJ8VrR-MGwUFNKAG8nnu0Rsq8441.m4a\r\n长生不死1187$http://audio.xmcdn.com/group40/M09/7C/9C/wKgJT1rR-RbDosGNAGjVaMoQvlA084.m4a\r\n长生不死1188$http://audio.xmcdn.com/group41/M01/B6/69/wKgJ8lrR-XGgFu3ZAGpL2WI8a6Y026.m4a\r\n长生不死1189$http://audio.xmcdn.com/group42/M0B/B3/17/wKgJ81rR-f6TeFpvAHFSsOpDFHc495.m4a\r\n长生不死1190$http://audio.xmcdn.com/group40/M04/7C/CF/wKgJT1rR-kiTHdNrAIXr1m9OYZs619.m4a\r\n长生不死1191$http://audio.xmcdn.com/group41/M00/B6/A6/wKgJ8lrR-rDSg3hrAHaxIpEkx0g394.m4a\r\n长生不死1192$http://audio.xmcdn.com/group40/M00/7D/CA/wKgJVFrR-wXS66AFAGVhaeYUBYY875.m4a\r\n长生不死1193$http://audio.xmcdn.com/group41/M0B/B6/B2/wKgJ8VrR-13CNJIWAHMZ5wog8QA897.m4a\r\n长生不死1194$http://audio.xmcdn.com/group40/M03/7D/17/wKgJT1rR-8ODnJNIAHLjkbfDww0504.m4a\r\n长生不死1195$http://audio.xmcdn.com/group41/M07/B6/CE/wKgJ8VrR_BqjfVUeAG1Hbwsq_l4499.m4a\r\n长生不死1196$http://audio.xmcdn.com/group40/M02/7D/FA/wKgJVFrR_HniWN7NAHHbQMz-NZY731.m4a\r\n长生不死1197$http://audio.xmcdn.com/group42/M01/B8/66/wKgJ9FrR_OHQRaOrAHc1S1n3Ock429.m4a\r\n长生不死1198$http://audio.xmcdn.com/group41/M03/B7/10/wKgJ8VrR_UTzLWdpAHF17Xk2ZCo560.m4a\r\n长生不死1199$http://audio.xmcdn.com/group40/M07/7D/5E/wKgJT1rR_Z7ze05yAHI_G4CKkEQ154.m4a\r\n长生不死1200$http://audio.xmcdn.com/group41/M07/B7/19/wKgJ8VrR_emh-5j5AGpRu6bD3bY062.m4a\r\n长生不死1201$http://audio.xmcdn.com/group40/M05/7A/9E/wKgJT1rR607hRZ3VAH2Hu5wlP4I117.m4a\r\n长生不死1202$http://audio.xmcdn.com/group40/M07/7A/A7/wKgJT1rR65KhATeNAG-6dtPev7w516.m4a\r\n长生不死1203$http://audio.xmcdn.com/group40/M0A/7B/7B/wKgJVFrR68eRGenoAExcFkwe224158.m4a\r\n长生不死1204$http://audio.xmcdn.com/group41/M02/B4/74/wKgJ8lrR7C2yaWX6AHPwSRA6IFQ498.m4a\r\n长生不死1205$http://audio.xmcdn.com/group42/M01/B1/05/wKgJ81rR7JfS-QU8AHTeL28mRd4795.m4a\r\n长生不死1206$http://audio.xmcdn.com/group40/M06/7A/DE/wKgJT1rR7RuAcqRcAHbgIzl0k7k390.m4a\r\n长生不死1207$http://audio.xmcdn.com/group42/M03/B6/05/wKgJ9FrR7Wzzz7NbAHR9Q-nA7xI316.m4a\r\n长生不死1208$http://audio.xmcdn.com/group41/M03/B4/AD/wKgJ8lrR7cexlrToAHAueDsaaOw978.m4a\r\n长生不死1209$http://audio.xmcdn.com/group40/M0B/7B/09/wKgJT1rR7jHh9B_FAHHbQIRewPY565.m4a\r\n长生不死1210$http://audio.xmcdn.com/group40/M03/7B/D9/wKgJVFrR7pmwYaJ9AHFROV5SD6A640.m4a\r\n长生不死1211$http://audio.xmcdn.com/group40/M04/7B/1C/wKgJT1rR7xDBHlBtAH-4dq6BVhY250.m4a\r\n长生不死1212$http://audio.xmcdn.com/group41/M09/B4/EA/wKgJ8lrR73egRPuyAHFbfeXqS8A025.m4a\r\n长生不死1213$http://audio.xmcdn.com/group41/M08/B4/E1/wKgJ8VrR792xNj42AHOYLg79b_A919.m4a\r\n长生不死1214$http://audio.xmcdn.com/group40/M05/7B/4F/wKgJT1rR8EnRXVVSAHqk4_5sgnU206.m4a\r\n长生不死1215$http://audio.xmcdn.com/group41/M05/B4/FC/wKgJ8VrR8LGABa5tAHGNbTxZeNE898.m4a\r\n长生不死1216$http://audio.xmcdn.com/group42/M07/B1/A7/wKgJ81rR8RmyYPDIAHHkEcAiiPY673.m4a\r\n长生不死1217$http://audio.xmcdn.com/group41/M01/B5/13/wKgJ8VrR8X_hW2azAHxh1Q9iHKs948.m4a\r\n长生不死1218$http://audio.xmcdn.com/group40/M08/7C/49/wKgJVFrR8emytKRnAH4AJGQncl8331.m4a\r\n长生不死1219$http://audio.xmcdn.com/group42/M08/B6/B8/wKgJ9FrR8lrSkwZwAHV1bvhI8Hs835.m4a\r\n长生不死1220$http://audio.xmcdn.com/group40/M07/7B/9E/wKgJT1rR8sOCJDiVAIA8njr6Q3A217.m4a\r\n长生不死1221$http://audio.xmcdn.com/group41/M0A/B5/5D/wKgJ8VrR8y2idUPcAHoz1JTYyAQ094.m4a\r\n长生不死1222$http://audio.xmcdn.com/group41/M07/B5/82/wKgJ8lrR853BLQCWAIMDVhao6G0498.m4a\r\n长生不死1223$http://audio.xmcdn.com/group41/M09/B5/7D/wKgJ8VrR9Bvxck-lAHp0b4thiXo728.m4a\r\n长生不死1224$http://audio.xmcdn.com/group42/M02/B2/2E/wKgJ81rR9HqwxBMMAHm0EqeD5tU951.m4a\r\n长生不死1225$http://audio.xmcdn.com/group41/M02/B5/96/wKgJ8VrR9MyxxHZgAHQZaHcnFJ0296.m4a\r\n长生不死1226$http://audio.xmcdn.com/group40/M00/7B/FB/wKgJT1rR9S2RDa9iAHj7Cpqjawk756.m4a\r\n长生不死1227$http://audio.xmcdn.com/group42/M07/B2/65/wKgJ81rR9aPxNRwwAHSGFGbHzJ8304.m4a\r\n长生不死1228$http://audio.xmcdn.com/group42/M05/B2/7B/wKgJ81rR9hew_ptoAJ-MzhiaNWE005.m4a\r\n长生不死1229$http://audio.xmcdn.com/group41/M08/B5/E0/wKgJ8VrR9nSDoUYVAH7BwgBdPEA498.m4a\r\n长生不死1230$http://audio.xmcdn.com/group41/M0A/B5/FA/wKgJ8lrR9tOzMdZPAHUEW-sMY-I134.m4a\r\n长生不死1231$http://audio.xmcdn.com/group42/M0B/B2/A2/wKgJ81rR9zXzpjlKAHaJf7Q8fYk796.m4a\r\n长生不死1232$http://audio.xmcdn.com/group41/M0B/B6/0A/wKgJ8VrR95qTuISeAHcThngt-SQ084.m4a\r\n长生不死1233$http://audio.xmcdn.com/group40/M04/7C/6D/wKgJT1rR9_-SPZauAHF43BKKXgY876.m4a\r\n长生不死1234$http://audio.xmcdn.com/group40/M07/7D/52/wKgJVFrR-GSR2bFYAHyg-WCOTi0860.m4a\r\n长生不死1235$http://audio.xmcdn.com/group41/M06/B6/3D/wKgJ8VrR-MyyO4YBAHvpaafA_NE384.m4a\r\n长生不死1236$http://audio.xmcdn.com/group42/M06/B7/CA/wKgJ9FrR-Taj5dh-AHfG4SE21Qo157.m4a\r\n长生不死1237$http://audio.xmcdn.com/group40/M06/7C/B4/wKgJT1rR-ZvCpiAgAHs5aX0qB_M803.m4a\r\n长生不死1238$http://audio.xmcdn.com/group40/M04/7D/96/wKgJVFrR-hqxuIK4AHXwxRZa85Y480.m4a\r\n长生不死1239$http://audio.xmcdn.com/group41/M08/B6/7C/wKgJ8VrR-mOCJcmgAHJmwtLfYeQ093.m4a\r\n长生不死1240$http://audio.xmcdn.com/group42/M0A/B8/12/wKgJ9FrR-seSZEYKAHOcmNjymiQ630.m4a\r\n长生不死1241$http://audio.xmcdn.com/group41/M04/B6/A0/wKgJ8VrR-ybTLlnPAHDYzNBqjtA089.m4a\r\n长生不死1242$http://audio.xmcdn.com/group42/M09/B3/57/wKgJ81rR-43B0a15AHr_7UIv4hs952.m4a\r\n长生不死1243$http://audio.xmcdn.com/group40/M0B/7D/1C/wKgJT1rR-_Pz4eoiAHks-l-PT8k523.m4a\r\n长生不死1244$http://audio.xmcdn.com/group41/M0A/B6/F0/wKgJ8lrR_EjAjjHXAGvILWTcL48632.m4a\r\n长生不死1245$http://audio.xmcdn.com/group40/M0A/7E/16/wKgJVFrR_K2gkJKTAHhrIk3wTTQ129.m4a\r\n长生不死1246$http://audio.xmcdn.com/group42/M03/B3/8F/wKgJ81rR_RXiQOGEAHWwKiGAFlM690.m4a\r\n长生不死1247$http://audio.xmcdn.com/group42/M05/B3/9C/wKgJ81rR_Xyy5q9mAH6f_bqd4X8105.m4a\r\n长生不死1248$http://audio.xmcdn.com/group42/M02/B3/BD/wKgJ81rR_deTRg5dAH78f1jBWdc465.m4a\r\n长生不死1249$http://audio.xmcdn.com/group40/M09/7D/75/wKgJT1rR_hKCAfQhAG5tH4JHtD4752.m4a\r\n长生不死1250$http://audio.xmcdn.com/group42/M04/B3/C5/wKgJ81rR_k2jb2pxAHRebcWJZrw702.m4a\r\n长生不死1251$http://audio.xmcdn.com/group40/M05/7B/6C/wKgJVFrR61biOF1zAHNUpJLDXjo307.m4a\r\n长生不死1252$http://audio.xmcdn.com/group42/M00/B0/EC/wKgJ81rR66WTLIXeAGpgatTwpeY623.m4a\r\n长生不死1253$http://audio.xmcdn.com/group42/M06/B0/F6/wKgJ81rR7AWgUTv9AHN34JrtI88314.m4a\r\n长生不死1254$http://audio.xmcdn.com/group40/M09/7B/92/wKgJVFrR7G2wT5w9AHXWVr_OqP0944.m4a\r\n长生不死1255$http://audio.xmcdn.com/group41/M07/B4/92/wKgJ8lrR7OCDfchCAHYOJEulH9U203.m4a\r\n长生不死1256$http://audio.xmcdn.com/group40/M06/7B/AD/wKgJVFrR7S6ThgQnAGoCbXJaDvY243.m4a\r\n长生不死1257$http://audio.xmcdn.com/group40/M02/7B/B8/wKgJVFrR7arhz_xQAG4SFTxRekg578.m4a\r\n长生不死1258$http://audio.xmcdn.com/group40/M07/7A/F5/wKgJT1rR7eihI_HNAG8pFayFTQs160.m4a\r\n长生不死1259$http://audio.xmcdn.com/group42/M04/B6/1E/wKgJ9FrR7kyjziOnAG8pFee53lM947.m4a\r\n长生不死1260$http://audio.xmcdn.com/group41/M06/B4/AF/wKgJ8VrR7rKz_cr8AHX_dMLnlNA895.m4a\r\n长生不死1261$http://audio.xmcdn.com/group40/M04/7B/E8/wKgJVFrR7xSxoeLQAHFy_ibmuqo446.m4a\r\n长生不死1262$http://audio.xmcdn.com/group41/M09/B4/E7/wKgJ8lrR73GSWixPAGa01NcTkZQ777.m4a\r\n长生不死1263$http://audio.xmcdn.com/group41/M08/B4/F5/wKgJ8lrR79iDwU2pAHd42cZv_a4517.m4a\r\n长生不死1264$http://audio.xmcdn.com/group40/M05/7C/18/wKgJVFrR8ELQ0PgzAHhGpI3ikL8446.m4a\r\n长生不死1265$http://audio.xmcdn.com/group41/M05/B4/F9/wKgJ8VrR8KjhrlCJAHTJnkq4G0A004.m4a\r\n长生不死1266$http://audio.xmcdn.com/group42/M03/B1/9F/wKgJ81rR8Qfw3YQtAG7imQDgq0M536.m4a\r\n长生不死1267$http://audio.xmcdn.com/group40/M02/7B/79/wKgJT1rR8XbQY8CrAHQiOc718yc021.m4a\r\n长生不死1268$http://audio.xmcdn.com/group42/M0A/B1/C3/wKgJ81rR8djxFASmAHQFED1sH0I963.m4a\r\n长生不死1269$http://audio.xmcdn.com/group41/M03/B5/49/wKgJ8lrR8j3Bjn-VAHGEnISz5IE538.m4a\r\n长生不死1270$http://audio.xmcdn.com/group40/M07/7B/9B/wKgJT1rR8qPDj12OAHa0Fd2ZQBc907.m4a\r\n长生不死1271$http://audio.xmcdn.com/group40/M00/7C/7C/wKgJVFrR8x2RXkXIAHH9BF_CLww055.m4a\r\n长生不死1272$http://audio.xmcdn.com/group42/M01/B6/DE/wKgJ9FrR82TA0b3VAG5M0pSR7Yo390.m4a\r\n长生不死1273$http://audio.xmcdn.com/group40/M06/7B/C7/wKgJT1rR88iRDb1uAG8nnjWrZLo651.m4a\r\n长生不死1274$http://audio.xmcdn.com/group41/M09/B5/93/wKgJ8lrR9CLTsN6bAHQ1TiZA5dY916.m4a\r\n长生不死1275$http://audio.xmcdn.com/group42/M02/B2/37/wKgJ81rR9Izze_9sAHropwSKrwU902.m4a\r\n长生不死1276$http://audio.xmcdn.com/group40/M0B/7B/FA/wKgJT1rR9PyhrarVAHqzkrGsnZw338.m4a\r\n长生不死1277$http://audio.xmcdn.com/group40/M01/7C/CF/wKgJVFrR9Vix55FuAHwirn33Hp0177.m4a\r\n长生不死1278$http://audio.xmcdn.com/group40/M03/7C/16/wKgJT1rR9dOAEXj-AHGUwxP-Xcw778.m4a\r\n长生不死1279$http://audio.xmcdn.com/group42/M03/B7/53/wKgJ9FrR9hDTXSSPAHAVgEqdk-w027.m4a\r\n长生不死1280$http://audio.xmcdn.com/group41/M08/B5/F5/wKgJ8lrR9njBvbIjAHiLc3RaHd4738.m4a\r\n长生不死1281$http://audio.xmcdn.com/group41/M0A/B5/FC/wKgJ8lrR9tjCXwJmAH4UeyH2h7A223.m4a\r\n长生不死1282$http://audio.xmcdn.com/group42/M0B/B2/A5/wKgJ81rR9zyxSgucAHewp-SWoVw037.m4a\r\n长生不死1283$http://audio.xmcdn.com/group41/M0B/B6/1F/wKgJ8lrR96HgQ1diAHWM6q6X0f0894.m4a\r\n长生不死1284$http://audio.xmcdn.com/group40/M04/7C/71/wKgJT1rR-AjjIzFMAH9EdI9M_FY726.m4a\r\n长生不死1285$http://audio.xmcdn.com/group40/M07/7D/56/wKgJVFrR-Gvja6PRAHOPYV8ZZa0713.m4a\r\n长生不死1286$http://audio.xmcdn.com/group41/M06/B6/55/wKgJ8lrR-NaD3gUnAH3-rPpECtw081.m4a\r\n长生不死1287$http://audio.xmcdn.com/group42/M06/B2/F3/wKgJ81rR-UKDNP5lAHMudD1YIzQ597.m4a\r\n长生不死1288$http://audio.xmcdn.com/group40/M06/7D/8A/wKgJVFrR-aiDhfALAHbBSTp8esQ534.m4a\r\n长生不死1289$http://audio.xmcdn.com/group42/M0B/B3/1C/wKgJ81rR-giwEjShAHbHK2t8ygE067.m4a\r\n长生不死1290$http://audio.xmcdn.com/group41/M08/B6/94/wKgJ8lrR-mrwJhluAHbxwfj689E130.m4a\r\n长生不死1291$http://audio.xmcdn.com/group40/M01/7C/E5/wKgJT1rR-s_QkLNhAH1gFJi7f8g696.m4a\r\n长生不死1292$http://audio.xmcdn.com/group41/M0B/B6/BB/wKgJ8lrR-0zy5Z7ZAIsGvpnrHHY257.m4a\r\n长生不死1293$http://audio.xmcdn.com/group40/M03/7D/14/wKgJT1rR-7zCPAqSAIJRqL1YQJM469.m4a\r\n长生不死1294$http://audio.xmcdn.com/group41/M0A/B6/D3/wKgJ8VrR_DjgjUM_AIDbNrzmM0E686.m4a\r\n长生不死1295$http://audio.xmcdn.com/group40/M0A/7E/11/wKgJVFrR_KXAc_heAIMoDgrdFfs340.m4a\r\n长生不死1296$http://audio.xmcdn.com/group42/M03/B8/71/wKgJ9FrR_SDCvm4dAIJKUhl2KCU749.m4a\r\n长生不死1297$http://audio.xmcdn.com/group42/M05/B8/81/wKgJ9FrR_Yih3RBOAIeEEJawNe8408.m4a\r\n长生不死1298$http://audio.xmcdn.com/group40/M08/7D/69/wKgJT1rR_eGDU3XaAHrp6Cnw8Wo546.m4a\r\n长生不死1299$http://audio.xmcdn.com/group41/M08/B7/40/wKgJ8lrR_i7RGPjdAITGJhF-WSI557.m4a\r\n长生不死1300$http://audio.xmcdn.com/group42/M04/B3/C8/wKgJ81rR_mCjtr11AHiIgAvDZ7E232.m4a\r\n长生不死1301$http://audio.xmcdn.com/group41/M03/B4/5C/wKgJ8lrR62-gyCbMAH3PdpDy420744.m4a\r\n长生不死1302$http://audio.xmcdn.com/group40/M0A/7A/B2/wKgJT1rR68nAFLC1AHrDuX9YIR0895.m4a\r\n长生不死1303$http://audio.xmcdn.com/group40/M08/7B/88/wKgJVFrR7DyRG-NCAHo4O3D4X7U945.m4a\r\n长生不死1304$http://audio.xmcdn.com/group42/M07/B1/09/wKgJ81rR7KmiHc19AIGwIW-JYyA303.m4a\r\n长生不死1305$http://audio.xmcdn.com/group42/M09/B5/FA/wKgJ9FrR7Qmxo6yFAHlaf5p5RuI004.m4a\r\n长生不死1306$http://audio.xmcdn.com/group42/M03/B6/04/wKgJ9FrR7WviAcs3AHjlBuK-dIY201.m4a\r\n长生不死1307$http://audio.xmcdn.com/group42/M0A/B6/13/wKgJ9FrR7dfS9QsnAHvcMdaL-BY985.m4a\r\n长生不死1308$http://audio.xmcdn.com/group42/M04/B6/24/wKgJ9FrR7lvRrXNEAHa589r79bY815.m4a\r\n长生不死1309$http://audio.xmcdn.com/group41/M06/B4/CA/wKgJ8lrR7rfhVkCLAIQ3tbGn_r4553.m4a\r\n长生不死1310$http://audio.xmcdn.com/group41/M00/B4/E0/wKgJ8lrR7v6SqaKcAFXOmrrUhzE752.m4a\r\n长生不死1311$http://audio.xmcdn.com/group41/M09/B4/CD/wKgJ8VrR72zycNq9AH7fIQpz_9w470.m4a\r\n长生不死1312$http://audio.xmcdn.com/group41/M08/B4/F8/wKgJ8lrR792jJm2NAHszVNpOo-s371.m4a\r\n长生不死1313$http://audio.xmcdn.com/group40/M05/7B/4F/wKgJT1rR8EiASC_JAHlaf9LqJto100.m4a\r\n长生不死1314$http://audio.xmcdn.com/group42/M02/B1/98/wKgJ81rR8I_wmIULAFKkCAgar4k064.m4a\r\n长生不死1315$http://audio.xmcdn.com/group42/M03/B6/7E/wKgJ9FrR8QPi_yTDAH1beOREm1M897.m4a\r\n长生不死1316$http://audio.xmcdn.com/group41/M01/B5/28/wKgJ8lrR8YGjALhcAI3GIJh_ErQ060.m4a\r\n长生不死1317$http://audio.xmcdn.com/group42/M0A/B6/A7/wKgJ9FrR8eDBjH2AAHlkxDmPOuk242.m4a\r\n长生不死1318$http://audio.xmcdn.com/group41/M03/B5/4D/wKgJ8lrR8kXxMOTmAH2GCpxLNxU423.m4a\r\n长生不死1319$http://audio.xmcdn.com/group41/M06/B5/54/wKgJ8lrR8oXwmhhqAFD0TbIULSA112.m4a\r\n长生不死1320$http://audio.xmcdn.com/group40/M00/7C/77/wKgJVFrR8w-i_bDoAI2XI4Ier7g716.m4a\r\n长生不死1321$http://audio.xmcdn.com/group42/M01/B6/E6/wKgJ9FrR83Xx6FEZAIEx1oPGzzU226.m4a\r\n长生不死1322$http://audio.xmcdn.com/group42/M00/B2/18/wKgJ81rR8-fAH97SAIZLR-T-MZ8054.m4a\r\n长生不死1323$http://audio.xmcdn.com/group41/M09/B5/98/wKgJ8lrR9FCRVG69AH8fvM3KWdU380.m4a\r\n长生不死1324$http://audio.xmcdn.com/group40/M04/7C/BA/wKgJVFrR9LjDW-qHAH66aYc-V44822.m4a\r\n长生不死1325$http://audio.xmcdn.com/group42/M04/B7/25/wKgJ9FrR9RnRrxLxAHqTRfyl5o4666.m4a\r\n长生不死1326$http://audio.xmcdn.com/group42/M06/B7/32/wKgJ9FrR9YCx17edAH6rukwzSiY204.m4a\r\n长生不死1327$http://audio.xmcdn.com/group40/M03/7C/EE/wKgJVFrR9evTvLM4AH7AS835Sww802.m4a\r\n长生不死1328$http://audio.xmcdn.com/group41/M03/B5/E7/wKgJ8lrR9kTxdqJ7AHiLc50FcTw127.m4a\r\n长生不死1329$http://audio.xmcdn.com/group42/M0A/B2/84/wKgJ81rR9qjDrrcgAHv2oRTN-kE947.m4a\r\n长生不死1330$http://audio.xmcdn.com/group42/M0B/B2/A5/wKgJ81rR9zuAc-_rAIGLbce-CG0749.m4a\r\n长生不死1331$http://audio.xmcdn.com/group40/M02/7D/35/wKgJVFrR94rBgIh3AIgkIPwOnP4603.m4a\r\n长生不死1332$http://audio.xmcdn.com/group42/M07/B7/A2/wKgJ9FrR9-_y1P_zAHjTZ3ekoYo383.m4a\r\n长生不死1333$http://audio.xmcdn.com/group40/M07/7C/86/wKgJT1rR-GWTUN6sAIqRRbRDQKE706.m4a\r\n长生不死1334$http://audio.xmcdn.com/group41/M06/B6/39/wKgJ8VrR-MLiAv31AHoGS5p9hZk513.m4a\r\n长生不死1335$http://audio.xmcdn.com/group40/M09/7C/A4/wKgJT1rR-STw7wlxAH9NQWwmHMc223.m4a\r\n长生不死1336$http://audio.xmcdn.com/group40/M06/7C/AE/wKgJT1rR-Y-CtDnsAHvvS1gKj9c986.m4a\r\n长生不死1337$http://audio.xmcdn.com/group42/M05/B3/12/wKgJ81rR-fTgBUNCAH2XrHeQHdY960.m4a\r\n长生不死1338$http://audio.xmcdn.com/group40/M04/7C/D7/wKgJT1rR-ljhRuPGAHqNZ6Qdrlk683.m4a\r\n长生不死1339$http://audio.xmcdn.com/group42/M02/B8/1C/wKgJ9FrR-umz3_MYAHukZ5R82bU904.m4a\r\n长生不死1340$http://audio.xmcdn.com/group42/M09/B8/21/wKgJ9FrR-zuibX4cAI1VDYwLv8I963.m4a\r\n长生不死1341$http://audio.xmcdn.com/group42/M09/B3/5D/wKgJ81rR-5yxs2PrAHUAKhsAhbQ890.m4a\r\n长生不死1342$http://audio.xmcdn.com/group40/M0B/7D/F0/wKgJVFrR-_3Bx6x-AHyK8P4qLiY653.m4a\r\n长生不死1343$http://audio.xmcdn.com/group42/M04/B3/7A/wKgJ81rR_G-CpO5JAIGl2FyjA5U392.m4a\r\n长生不死1344$http://audio.xmcdn.com/group42/M01/B8/67/wKgJ9FrR_OOj-LNzAIaI95BzfP8374.m4a\r\n长生不死1345$http://audio.xmcdn.com/group40/M05/7D/4D/wKgJT1rR_U_TGUVaAIIShbkPuOc386.m4a\r\n长生不死1346$http://audio.xmcdn.com/group42/M07/B3/AE/wKgJ81rR_a6jtAtlAHkloe4aN6w819.m4a\r\n长生不死1347$http://audio.xmcdn.com/group40/M09/7E/3D/wKgJVFrR_gCSD_2tAHZOwkCxZWQ774.m4a\r\n长生不死1348$http://audio.xmcdn.com/group42/M04/B8/9D/wKgJ9FrR_j3RZlWLAHkl17fybds326.m4a\r\n长生不死1349$http://audio.xmcdn.com/group42/M04/B3/CD/wKgJ81rR_mzDvXczAHtZhHN_q4s954.m4a\r\n长生不死1350$http://audio.xmcdn.com/group40/M06/7D/89/wKgJT1rR_pOD18tPAHf0MW0QZvc781.m4a\r\n长生不死1351$http://audio.xmcdn.com/group40/M07/7B/71/wKgJVFrR65LBd1Y5AHs9nbdG53U099.m4a\r\n长生不死1352$http://audio.xmcdn.com/group41/M01/B4/53/wKgJ8VrR6-bzo0dqAHcvbS2_Q0c662.m4a\r\n长生不死1353$http://audio.xmcdn.com/group41/M02/B4/5E/wKgJ8VrR7FOTewFiAHoX7evOn_8191.m4a\r\n长生不死1354$http://audio.xmcdn.com/group42/M07/B1/0C/wKgJ81rR7LSgoRHqAHxUnmzUhXo315.m4a\r\n长生不死1355$http://audio.xmcdn.com/group40/M06/7B/AA/wKgJVFrR7SbzUO5rAIFTn1fqbXg751.m4a\r\n长生不死1356$http://audio.xmcdn.com/group41/M0A/B4/A1/wKgJ8lrR7ZPh9xpDAHuhdBUXVl4884.m4a\r\n长生不死1357$http://audio.xmcdn.com/group41/M05/B4/9B/wKgJ8VrR7gqQrlPpAIDYQ77k1aI293.m4a\r\n长生不死1358$http://audio.xmcdn.com/group41/M01/B4/A9/wKgJ8VrR7n_B0IbxAIWykeM1UX0623.m4a\r\n长生不死1359$http://audio.xmcdn.com/group41/M00/B4/DC/wKgJ8lrR7vSjukjqAIZCsB8fwNU308.m4a\r\n长生不死1360$http://audio.xmcdn.com/group40/M07/7B/EF/wKgJVFrR71bxi2snAHxgWi-_Nck332.m4a\r\n长生不死1361$http://audio.xmcdn.com/group42/M06/B6/59/wKgJ9FrR78bzStikAItQKmGefOM237.m4a\r\n长生不死1362$http://audio.xmcdn.com/group40/M05/7C/14/wKgJVFrR8DnSm3P3AHwy1cRf1I4531.m4a\r\n长生不死1363$http://audio.xmcdn.com/group41/M05/B5/13/wKgJ8lrR8LPAlKs-AIJx9Utde9Y023.m4a\r\n长生不死1364$http://audio.xmcdn.com/group40/M0B/7B/60/wKgJT1rR8TDTrLvfAII0SVaHsJE117.m4a\r\n长生不死1365$http://audio.xmcdn.com/group41/M04/B5/27/wKgJ8VrR8b7j4D7lAISSvxr88Ek058.m4a\r\n长生不死1366$http://audio.xmcdn.com/group40/M09/7B/83/wKgJT1rR8gKAm8NWAHb6jrebCsg682.m4a\r\n长生不死1367$http://audio.xmcdn.com/group42/M08/B1/DD/wKgJ81rR8mfRIm90AHf9AmoOEnc755.m4a\r\n长生不死1368$http://audio.xmcdn.com/group40/M07/7B/A3/wKgJT1rR8s_BLrwwAHtSYKc_7AY722.m4a\r\n长生不死1369$http://audio.xmcdn.com/group41/M0A/B5/65/wKgJ8VrR80PBJSnZAHjWVkArvpI813.m4a\r\n长生不死1370$http://audio.xmcdn.com/group41/M07/B5/87/wKgJ8lrR86fjrMd5AHzP9VLEcM4153.m4a\r\n长生不死1371$http://audio.xmcdn.com/group40/M08/7C/99/wKgJVFrR9AKRj_IYAG0OKoNKgHM956.m4a\r\n长生不死1372$http://audio.xmcdn.com/group42/M02/B7/09/wKgJ9FrR9G_xNOkcAH5lQVVPdso751.m4a\r\n长生不死1373$http://audio.xmcdn.com/group41/M02/B5/99/wKgJ8VrR9NLihzvaAHyK8Iw3-ss098.m4a\r\n长生不死1374$http://audio.xmcdn.com/group41/M06/B5/BF/wKgJ8lrR9UTx4LuIAIboZx33sfM980.m4a\r\n长生不死1375$http://audio.xmcdn.com/group41/M00/B5/BC/wKgJ8VrR9bXQDEaNAIELqxXMh20264.m4a\r\n长生不死1376$http://audio.xmcdn.com/group42/M05/B2/7D/wKgJ81rR9huyFp56AHmTxFyIdCs366.m4a\r\n长生不死1377$http://audio.xmcdn.com/group41/M08/B5/F8/wKgJ8lrR9n-hVouqAHy84GhDC8g772.m4a\r\n长生不死1378$http://audio.xmcdn.com/group42/M01/B2/8D/wKgJ81rR9r7gQyq4AFS5EYaI1zE645.m4a\r\n长生不死1379$http://audio.xmcdn.com/group42/M09/B7/76/wKgJ9FrR9ySzgs9-AHbNCb6UkRM592.m4a\r\n长生不死1380$http://audio.xmcdn.com/group41/M0B/B6/08/wKgJ8VrR95aAGaotAIJTH69ZN2k196.m4a\r\n长生不死1381$http://audio.xmcdn.com/group42/M07/B7/A8/wKgJ9FrR9_nyrUOoAHgnmMNuaXk134.m4a\r\n长生不死1382$http://audio.xmcdn.com/group40/M07/7D/56/wKgJVFrR-GrziQouAIN3WMJkjjE918.m4a\r\n长生不死1383$http://audio.xmcdn.com/group41/M06/B6/51/wKgJ8lrR-M_BlQ9-AHUOo4IRFCU193.m4a\r\n长生不死1384$http://audio.xmcdn.com/group40/M09/7D/79/wKgJVFrR-THhd1BXAHZafxUx15Y510.m4a\r\n长生不死1385$http://audio.xmcdn.com/group40/M06/7D/80/wKgJVFrR-ZWw5OjLAHZQcFYAg64531.m4a\r\n长生不死1386$http://audio.xmcdn.com/group42/M0B/B3/14/wKgJ81rR-fmAu2YVAHm4eLedwqA774.m4a\r\n长生不死1387$http://audio.xmcdn.com/group40/M04/7D/AB/wKgJVFrR-l7TvNkiAHZ_N1iCEUw763.m4a\r\n长生不死1388$http://audio.xmcdn.com/group40/M01/7D/B7/wKgJVFrR-tKgKCdtAIk7Vzim1QE425.m4a\r\n长生不死1389$http://audio.xmcdn.com/group42/M09/B3/44/wKgJ81rR-zuyO4l6AHsqg6h_ckc443.m4a\r\n长生不死1390$http://audio.xmcdn.com/group40/M03/7D/0C/wKgJT1rR-67Ae0NnAHz9eu1nV8c773.m4a\r\n长生不死1391$http://audio.xmcdn.com/group42/M08/B3/60/wKgJ81rR_AfCcGMsAHRc9WQFqcU347.m4a\r\n长生不死1392$http://audio.xmcdn.com/group40/M02/7D/F6/wKgJVFrR_HKhTSojAHmPWkOq0ds826.m4a\r\n长生不死1393$http://audio.xmcdn.com/group42/M00/B3/8A/wKgJ81rR_OOji32NAHa-WmXY_hM385.m4a\r\n长生不死1394$http://audio.xmcdn.com/group41/M03/B7/26/wKgJ8lrR_UmDAEJVAHTGr49bVWs871.m4a\r\n长生不死1395$http://audio.xmcdn.com/group40/M07/7E/35/wKgJVFrR_arRfUp1AHK9YvyacYg492.m4a\r\n长生不死1396$http://audio.xmcdn.com/group41/M07/B7/39/wKgJ8lrR_f7Sjb9VAH0vahGD3UI317.m4a\r\n长生不死1397$http://audio.xmcdn.com/group42/M04/B3/BE/wKgJ81rR_jvAmcQBAHMbXx8OFQI140.m4a\r\n长生不死1398$http://audio.xmcdn.com/group42/M04/B3/CC/wKgJ81rR_muwykpQAHKdSnKD0F4339.m4a\r\n长生不死1399$http://audio.xmcdn.com/group40/M06/7D/87/wKgJT1rR_o-RV2AuAHTs3oHwdoQ224.m4a\r\n长生不死1400$http://audio.xmcdn.com/group41/M06/B7/43/wKgJ8VrR_rLRsZTCAHRXSazharg429.m4a\r\n长生不死1401$http://audio.xmcdn.com/group41/M04/B4/4B/wKgJ8VrR662grJMgAII9G-yoDM4954.m4a\r\n长生不死1402$http://audio.xmcdn.com/group42/M0B/B5/DB/wKgJ9FrR7AzRLZ7SAHpnN__icmU607.m4a\r\n长生不死1403$http://audio.xmcdn.com/group41/M02/B4/7B/wKgJ8lrR7GLgZntgAG94YO_5TEk232.m4a\r\n长生不死1404$http://audio.xmcdn.com/group41/M07/B4/8F/wKgJ8lrR7NaRd1dAAHqWNKO34p8622.m4a\r\n长生不死1405$http://audio.xmcdn.com/group40/M06/7A/E2/wKgJT1rR7SfyNOIRAG7VYUv60rs274.m4a\r\n长生不死1406$http://audio.xmcdn.com/group41/M0A/B4/8A/wKgJ8VrR7ZSRQA6BAHbgI3wtNxY676.m4a\r\n长生不死1407$http://audio.xmcdn.com/group40/M07/7B/C3/wKgJVFrR7fKjcQGSAHbmASr50oc273.m4a\r\n长生不死1408$http://audio.xmcdn.com/group42/M04/B6/24/wKgJ9FrR7lzww3RTAHSGFG3-YNw978.m4a\r\n长生不死1409$http://audio.xmcdn.com/group41/M06/B4/B8/wKgJ8VrR7sKCYoLjAHOZpWmFZOM582.m4a\r\n长生不死1410$http://audio.xmcdn.com/group42/M00/B1/67/wKgJ81rR70GxSq9uAINxeiZsiU8078.m4a\r\n长生不死1411$http://audio.xmcdn.com/group41/M0A/B4/EC/wKgJ8lrR76-AG8nYAIBxeWlKl3k123.m4a\r\n长生不死1412$http://audio.xmcdn.com/group40/M05/7C/0A/wKgJVFrR8CSSJpnwAIHErkjkvjQ802.m4a\r\n长生不死1413$http://audio.xmcdn.com/group42/M02/B1/93/wKgJ81rR8ITA8vVsAHtyeCenGCI205.m4a\r\n长生不死1414$http://audio.xmcdn.com/group40/M0A/7B/57/wKgJT1rR8OyQYHF2AH3T4ISPDHY973.m4a\r\n长生不死1415$http://audio.xmcdn.com/group40/M02/7B/68/wKgJT1rR8VDzPNa1AHa-WrIAh10580.m4a\r\n长生不死1416$http://audio.xmcdn.com/group41/M04/B5/42/wKgJ8lrR8c3CkBG2AHQpjlouXPo672.m4a\r\n长生不死1417$http://audio.xmcdn.com/group41/M03/B5/31/wKgJ8VrR8jLw4TupAIG3el8yHo8583.m4a\r\n长生不死1418$http://audio.xmcdn.com/group41/M0B/B5/45/wKgJ8VrR8qaSXwM5AIGwIUg6VvI891.m4a\r\n长生不死1419$http://audio.xmcdn.com/group40/M00/7B/B0/wKgJT1rR8xrg6GaZAIhqmT3tBK0336.m4a\r\n长生不死1420$http://audio.xmcdn.com/group42/M01/B6/EB/wKgJ9FrR84PwYYDkAHylXwIa8-k894.m4a\r\n长生不死1421$http://audio.xmcdn.com/group42/M00/B2/1C/wKgJ81rR8-_h0wKzAHItfZKe1VA202.m4a\r\n长生不死1422$http://audio.xmcdn.com/group41/M09/B5/9C/wKgJ8lrR9FmThn5CAIPJlbAkSz4947.m4a\r\n长生不死1423$http://audio.xmcdn.com/group40/M04/7B/F1/wKgJT1rR9LygDQq6AHYMrD5GF5A505.m4a\r\n长生不死1424$http://audio.xmcdn.com/group40/M00/7B/FB/wKgJT1rR9SzDwBTCAIMPFpRU80Q956.m4a\r\n长生不死1425$http://audio.xmcdn.com/group42/M07/B2/60/wKgJ81rR9Zigro8VAH30LnxX-cg603.m4a\r\n长生不死1426$http://audio.xmcdn.com/group42/M03/B7/4D/wKgJ9FrR9gOj26WnAH4x2XPf8xI897.m4a\r\n长生不死1427$http://audio.xmcdn.com/group41/M08/B5/ED/wKgJ8lrR9mfDVsjcAHW0kYG61Sk468.m4a\r\n长生不死1428$http://audio.xmcdn.com/group42/M0A/B7/6C/wKgJ9FrR9sTDLnbkAHiOYtXv8UI966.m4a\r\n长生不死1429$http://audio.xmcdn.com/group42/M09/B7/7F/wKgJ9FrR9zbxJCcnAIA_jZI8g3Q392.m4a\r\n长生不死1430$http://audio.xmcdn.com/group41/M0B/B6/0A/wKgJ8VrR95qA2xoVAH33HQRSRNg516.m4a\r\n长生不死1431$http://audio.xmcdn.com/group40/M04/7C/70/wKgJT1rR-AfSLnabAHHSbjPcwAw639.m4a\r\n长生不死1432$http://audio.xmcdn.com/group40/M07/7C/88/wKgJT1rR-GrzcLj_AH6RTvM5BNY470.m4a\r\n长生不死1433$http://audio.xmcdn.com/group41/M06/B6/3B/wKgJ8VrR-Mfjz4ETAHnqaFf6CQo155.m4a\r\n长生不死1434$http://audio.xmcdn.com/group40/M09/7D/75/wKgJVFrR-SmiYzaOAH89GlVjLDA711.m4a\r\n长生不死1435$http://audio.xmcdn.com/group41/M01/B6/62/wKgJ8VrR-YmDBCUnAHq67F_Wx80077.m4a\r\n长生不死1436$http://audio.xmcdn.com/group42/M0B/B7/EA/wKgJ9FrR-eyC_EYwAHSsQIWtM7c611.m4a\r\n长生不死1437$http://audio.xmcdn.com/group40/M04/7C/D8/wKgJT1rR-luTAF4lAIEV87PUuw0245.m4a\r\n长生不死1438$http://audio.xmcdn.com/group42/M0A/B3/32/wKgJ81rR-r-gKb9XAHkOJDP2NxU497.m4a\r\n长生不死1439$http://audio.xmcdn.com/group41/M04/B6/9D/wKgJ8VrR-yLgjzwmAHfMjiO85gU716.m4a\r\n长生不死1440$http://audio.xmcdn.com/group42/M09/B3/55/wKgJ81rR-4nTqVifAHgzWEg_6Xw850.m4a\r\n长生不死1441$http://audio.xmcdn.com/group40/M0B/7D/F0/wKgJVFrR-_uAow3gAIEmGjAZY9U926.m4a\r\n长生不死1442$http://audio.xmcdn.com/group42/M08/B8/54/wKgJ9FrR_GnyoFzZAIEF_78Y268137.m4a\r\n长生不死1443$http://audio.xmcdn.com/group41/M05/B6/FC/wKgJ8lrR_MyzliyvAHxXjaR3DnA939.m4a\r\n长生不死1444$http://audio.xmcdn.com/group41/M03/B7/1D/wKgJ8lrR_TTR55nNAHyYKHxa0lE317.m4a\r\n长生不死1445$http://audio.xmcdn.com/group42/M07/B3/A8/wKgJ81rR_ZTyjB-cAHZzrMjOHXw489.m4a\r\n长生不死1446$http://audio.xmcdn.com/group41/M07/B7/37/wKgJ8lrR_fuCZS6lAIFsk0T3fOU326.m4a\r\n长生不死1447$http://audio.xmcdn.com/group42/M04/B3/C0/wKgJ81rR_kHQHhnfAHw-laX7Bs8543.m4a\r\n长生不死1448$http://audio.xmcdn.com/group41/M06/B7/4C/wKgJ8lrR_nazLHbDAJAQCJURS0Q817.m4a\r\n长生不死1449$http://audio.xmcdn.com/group40/M01/7D/99/wKgJT1rR_suANZ-QAIVadvZQXBY377.m4a\r\n长生不死1450$http://audio.xmcdn.com/group40/M01/7D/97/wKgJT1rR_sbRbmloAH2qwm6TqOQ054.m4a\r\n长生不死1451$http://audio.xmcdn.com/group41/M04/B4/4E/wKgJ8VrR67TTT_rDAHhjzFCP7Ss334.m4a\r\n长生不死1452$http://audio.xmcdn.com/group41/M02/B4/72/wKgJ8lrR7Cmg6eGgAIJb8BbmhXA396.m4a\r\n长生不死1453$http://audio.xmcdn.com/group41/M02/B4/62/wKgJ8VrR7F3BPYcZAE4QNx8ZAgE977.m4a\r\n长生不死1454$http://audio.xmcdn.com/group41/M07/B4/71/wKgJ8VrR7MaSAMkfAHEHzXdnPwg628.m4a\r\n长生不死1455$http://audio.xmcdn.com/group40/M06/7B/AD/wKgJVFrR7Szw7rjaAHdLVEtRtc0456.m4a\r\n长生不死1456$http://audio.xmcdn.com/group41/M0A/B4/A4/wKgJ8lrR7ZiDBAaYAH28YIlbJAY549.m4a\r\n长生不死1457$http://audio.xmcdn.com/group40/M0B/7B/C5/wKgJVFrR7hCyf3tcAHz9ehET-_E895.m4a\r\n长生不死1458$http://audio.xmcdn.com/group42/M04/B1/48/wKgJ81rR7meQULqKAHfm-YfW3Mo549.m4a\r\n长生不死1459$http://audio.xmcdn.com/group41/M00/B4/D2/wKgJ8lrR7tvDxxucAIC39m__QnE734.m4a\r\n长生不死1460$http://audio.xmcdn.com/group42/M01/B6/46/wKgJ9FrR70Hhn3bfAH5MSZ8gYXI941.m4a\r\n长生不死1461$http://audio.xmcdn.com/group41/M0A/B4/D6/wKgJ8VrR77HjIqTfAICnzxdpe3E396.m4a\r\n长生不死1462$http://audio.xmcdn.com/group42/M08/B6/65/wKgJ9FrR8B7QhYjKAHa3BPWMNK4925.m4a\r\n长生不死1463$http://audio.xmcdn.com/group42/M0B/B6/71/wKgJ9FrR8H_x8R_qAHnV1_Kg8GA975.m4a\r\n长生不死1464$http://audio.xmcdn.com/group40/M0A/7B/55/wKgJT1rR8OazfAiPAHxh1ehYevk157.m4a\r\n长生不死1465$http://audio.xmcdn.com/group42/M07/B1/B6/wKgJ81rR8UnTn8FrAHbu0hn8fkE827.m4a\r\n长生不死1466$http://audio.xmcdn.com/group41/M04/B5/36/wKgJ8lrR8bWB15PQAHXU3lRwBgg521.m4a\r\n长生不死1467$http://audio.xmcdn.com/group41/M03/B5/46/wKgJ8lrR8jXQbY0HAIoUcd6OHYU247.m4a\r\n长生不死1468$http://audio.xmcdn.com/group40/M07/7C/67/wKgJVFrR8qSRvbLsAIBVkqVvbIU439.m4a\r\n长生不死1469$http://audio.xmcdn.com/group42/M06/B1/F9/wKgJ81rR8wzzcpXTAITARN5-eKc270.m4a\r\n长生不死1470$http://audio.xmcdn.com/group41/M07/B5/89/wKgJ8lrR86qxi-s8AIZhUNka4Cw923.m4a\r\n长生不死1471$http://audio.xmcdn.com/group41/M09/B5/8C/wKgJ8lrR9A-BcdR0AHxF7_VYwU8424.m4a\r\n长生不死1472$http://audio.xmcdn.com/group41/M09/B5/85/wKgJ8VrR9E-ABv3CAHdVnFgqKA4589.m4a\r\n长生不死1473$http://audio.xmcdn.com/group40/M04/7C/B9/wKgJVFrR9LWTOiXiAHDtXZPASqw900.m4a\r\n长生不死1474$http://audio.xmcdn.com/group42/M04/B7/25/wKgJ9FrR9ReBpA5cAHJAkpVdnko441.m4a\r\n长生不死1475$http://audio.xmcdn.com/group42/M06/B2/54/wKgJ81rR9X-RXM_YAH10bMJEBYs805.m4a\r\n长生不死1476$http://audio.xmcdn.com/group40/M03/7C/20/wKgJT1rR9efi5ohPAH5NwM6hMi0302.m4a\r\n长生不死1477$http://audio.xmcdn.com/group40/M00/7C/FB/wKgJVFrR9mGxv5UkAIE_Do_p41M711.m4a\r\n长生不死1478$http://audio.xmcdn.com/group42/M01/B2/8B/wKgJ81rR9rnDb_5PAHVa_nbNDg4196.m4a\r\n长生不死1479$http://audio.xmcdn.com/group42/M09/B2/9C/wKgJ81rR9ybRgOFMAHjgm7La6NY088.m4a\r\n长生不死1480$http://audio.xmcdn.com/group40/M02/7C/62/wKgJT1rR93-hOexiAHRXSanhrrA586.m4a\r\n长生不死1481$http://audio.xmcdn.com/group42/M07/B2/C3/wKgJ81rR9-ixohHlAHsIvkZ3cMA024.m4a\r\n长生不死1482$http://audio.xmcdn.com/group41/M07/B6/24/wKgJ8VrR-Euxua66AHTxRaLBpSU755.m4a\r\n长生不死1483$http://audio.xmcdn.com/group42/M00/B7/BD/wKgJ9FrR-KyBRe6GAHegtoCvqA4739.m4a\r\n长生不死1484$http://audio.xmcdn.com/group40/M09/7C/9E/wKgJT1rR-RmB7qyWAIFPNPdj-8I842.m4a\r\n长生不死1485$http://audio.xmcdn.com/group41/M01/B6/5D/wKgJ8VrR-YDzaYHeAH1UHpeInqs181.m4a\r\n长生不死1486$http://audio.xmcdn.com/group42/M05/B3/10/wKgJ81rR-e_CEJAqAIKDlM_y-pE651.m4a\r\n长生不死1487$http://audio.xmcdn.com/group40/M04/7D/A6/wKgJVFrR-lOC_pbSAHlnt0PfYw4673.m4a\r\n长生不死1488$http://audio.xmcdn.com/group42/M0A/B3/2F/wKgJ81rR-rjySZYBAHrAynhktxI022.m4a\r\n长生不死1489$http://audio.xmcdn.com/group41/M04/B6/AC/wKgJ8lrR-xrSEQ66AHS5d4SAfjI605.m4a\r\n长生不死1490$http://audio.xmcdn.com/group42/M02/B8/2F/wKgJ9FrR-4DQZBdEAHHp73UzJAs357.m4a\r\n长生不死1491$http://audio.xmcdn.com/group41/M07/B6/C8/wKgJ8VrR--vTOAavAHQrBqhg_eI677.m4a\r\n长生不死1492$http://audio.xmcdn.com/group41/M0A/B6/DC/wKgJ8VrR_EiyOJp0AHQiOa6iuqw327.m4a\r\n长生不死1493$http://audio.xmcdn.com/group40/M0A/7E/17/wKgJVFrR_LCjvgmMAHvaui1PlCM844.m4a\r\n长生不死1494$http://audio.xmcdn.com/group41/M03/B7/1B/wKgJ8lrR_S_hB2YFAIqrtHT0MYM983.m4a\r\n长生不死1495$http://audio.xmcdn.com/group42/M07/B3/A0/wKgJ81rR_YWQueMIAHhZg1TpPII297.m4a\r\n长生不死1496$http://audio.xmcdn.com/group40/M08/7E/3C/wKgJVFrR_ebgHso4AIFE8NEkjs0888.m4a\r\n长生不死1497$http://audio.xmcdn.com/group41/M08/B7/3D/wKgJ8lrR_imjn4SYAHX8u08a4gM907.m4a\r\n长生不死1498$http://audio.xmcdn.com/group42/M04/B3/CA/wKgJ81rR_mWRzBeuAIFlPYHOGR4051.m4a\r\n长生不死1499$http://audio.xmcdn.com/group42/M06/B3/D5/wKgJ81rR_oWQWa6SAHg_FGOtHd8619.m4a\r\n长生不死1500$http://audio.xmcdn.com/group41/M06/B7/3D/wKgJ8VrR_qWwbvDjAHUY7CyZmGI856.m4a\r\n长生不死1501$http://audio.xmcdn.com/group40/M0A/7A/B7/wKgJT1rR69XDgiMVAHuCnnT1gVA360.m4a\r\n长生不死1502$http://audio.xmcdn.com/group40/M08/7B/85/wKgJVFrR7DShlwqxAHJ_tuBubeA768.m4a\r\n长生不死1503$http://audio.xmcdn.com/group40/M09/7B/98/wKgJVFrR7H_wbjUnAFV_UBe0mfM602.m4a\r\n长生不死1504$http://audio.xmcdn.com/group42/M09/B1/11/wKgJ81rR7OrQaIOeAHil3g1x624622.m4a\r\n长生不死1505$http://audio.xmcdn.com/group41/M04/B4/9C/wKgJ8lrR7VfzlkScAH5MSUJNTUE897.m4a\r\n长生不死1506$http://audio.xmcdn.com/group41/M03/B4/A8/wKgJ8lrR7b6QJ96tAHKLdtVvYRY209.m4a\r\n长生不死1507$http://audio.xmcdn.com/group40/M0B/7B/C9/wKgJVFrR7hqCmJcZAHBXlnIRRUw163.m4a\r\n长生不死1508$http://audio.xmcdn.com/group41/M01/B4/C5/wKgJ8lrR7oazWDnWAHcJPQboFI0174.m4a\r\n长生不死1509$http://audio.xmcdn.com/group41/M00/B4/BF/wKgJ8VrR7unQFrEeAHc7LWrHF58186.m4a\r\n长生不死1510$http://audio.xmcdn.com/group40/M07/7B/26/wKgJT1rR71nhsANbAHQz1zaDtv4097.m4a\r\n长生不死1511$http://audio.xmcdn.com/group42/M09/B1/73/wKgJ81rR77bR46Z2AHA0VvhXNsE994.m4a\r\n长生不死1512$http://audio.xmcdn.com/group40/M05/7B/48/wKgJT1rR8Dfz99KvAHdy-yA4j40935.m4a\r\n长生不死1513$http://audio.xmcdn.com/group42/M02/B1/93/wKgJ81rR8IKw2JOqAHf3JNBlfp4360.m4a\r\n长生不死1514$http://audio.xmcdn.com/group40/M0A/7B/60/wKgJT1rR8QGyla0NAHtrIj4ZE4I742.m4a\r\n长生不死1515$http://audio.xmcdn.com/group42/M07/B1/B6/wKgJ81rR8Uriin_-AHuehWBRau8673.m4a\r\n长生不死1516$http://audio.xmcdn.com/group42/M09/B1/BD/wKgJ81rR8aXwG4djAG9sowuJtMM893.m4a\r\n长生不死1517$http://audio.xmcdn.com/group40/M09/7B/8E/wKgJT1rR8hmzqSVkAIh6wGFHNCA008.m4a\r\n长生不死1518$http://audio.xmcdn.com/group41/M06/B5/54/wKgJ8lrR8oTzaRp0AHTT55ZbipA955.m4a\r\n长生不死1519$http://audio.xmcdn.com/group42/M05/B6/CC/wKgJ9FrR8ufi7pjJAHlBh_0ooZM332.m4a\r\n长生不死1520$http://audio.xmcdn.com/group42/M04/B2/0C/wKgJ81rR84KgXfUkAKeTJnqQ7xg393.m4a\r\n长生不死1521$http://audio.xmcdn.com/group42/M00/B6/F8/wKgJ9FrR8-fi0ZEnAH-YKAJj7F0385.m4a\r\n长生不死1522$http://audio.xmcdn.com/group41/M09/B5/88/wKgJ8VrR9FbzT7vuAII19_V2bnw088.m4a\r\n长生不死1523$http://audio.xmcdn.com/group41/M02/B5/91/wKgJ8VrR9MOTaS77AIH4FadK6fA908.m4a\r\n长生不死1524$http://audio.xmcdn.com/group41/M06/B5/BB/wKgJ8lrR9TvCSF7kAIJWDr21BLg910.m4a\r\n长生不死1525$http://audio.xmcdn.com/group41/M00/B5/B4/wKgJ8VrR9aaREcGoAIdH3EP49Bc060.m4a\r\n长生不死1526$http://audio.xmcdn.com/group42/M05/B2/77/wKgJ81rR9g7girL3AHrs2J8Jt30121.m4a\r\n长生不死1527$http://audio.xmcdn.com/group41/M08/B5/DD/wKgJ8VrR9m2ixLM3AHb5Fyezczs021.m4a\r\n长生不死1528$http://audio.xmcdn.com/group42/M01/B2/94/wKgJ81rR9s2C2xUmAHX8hZZSUVg992.m4a\r\n长生不死1529$http://audio.xmcdn.com/group40/M0B/7D/23/wKgJVFrR90zxXIynAIKWrcV1HgA043.m4a\r\n长生不死1530$http://audio.xmcdn.com/group42/M07/B7/94/wKgJ9FrR98axLmB1AJZZbQ_c8BU786.m4a\r\n长生不死1531$http://audio.xmcdn.com/group40/M05/7C/79/wKgJT1rR-DLBXPosAISRpcs9Do0850.m4a\r\n长生不死1532$http://audio.xmcdn.com/group42/M01/B2/DD/wKgJ81rR-KSBzSypAIt6wMDvfQo058.m4a\r\n长生不死1533$http://audio.xmcdn.com/group40/M09/7C/9B/wKgJT1rR-RSBnLECAIL0pnxlGrw424.m4a\r\n长生不死1534$http://audio.xmcdn.com/group41/M01/B6/73/wKgJ8lrR-YKj2cRSAIiDkSFu_Kw430.m4a\r\n长生不死1535$http://audio.xmcdn.com/group40/M0B/7D/8F/wKgJVFrR-d-zWMoFAHT_9G_ykeI292.m4a\r\n长生不死1536$http://audio.xmcdn.com/group40/M04/7D/9E/wKgJVFrR-kPhFg3NAHcZZOxMwnQ566.m4a\r\n长生不死1537$http://audio.xmcdn.com/group42/M0A/B8/14/wKgJ9FrR-szwlB-zAHCsv1teC3I238.m4a\r\n长生不死1538$http://audio.xmcdn.com/group40/M00/7D/CB/wKgJVFrR-wjB7m7oAHBKX9oNCW0391.m4a\r\n长生不死1539$http://audio.xmcdn.com/group41/M0B/B6/CB/wKgJ8lrR-2iyIbp6AHL_ePeGOzE575.m4a\r\n长生不死1540$http://audio.xmcdn.com/group41/M02/B6/BB/wKgJ8VrR-82itdykAHZDArbLU9Q378.m4a\r\n长生不死1541$http://audio.xmcdn.com/group41/M0A/B6/EE/wKgJ8lrR_EbzWw58AICWMS2iNlo051.m4a\r\n长生不死1542$http://audio.xmcdn.com/group40/M0A/7D/3E/wKgJT1rR_KDD19MeAGu2jjDU7Ic675.m4a\r\n长生不死1543$http://audio.xmcdn.com/group42/M00/B3/8A/wKgJ81rR_OSxia33AFNSxnvUl38357.m4a\r\n长生不死1544$http://audio.xmcdn.com/group42/M05/B8/79/wKgJ9FrR_XmgFnKwAKRIQZZo3q0152.m4a\r\n长生不死1545$http://audio.xmcdn.com/group40/M08/7E/36/wKgJVFrR_dqS6PvjAIOjZcakNJ8229.m4a\r\n长生不死1546$http://audio.xmcdn.com/group41/M08/B7/2C/wKgJ8VrR_i-D_0H3AIKTvgDKYco621.m4a\r\n长生不死1547$http://audio.xmcdn.com/group42/M04/B8/A3/wKgJ9FrR_kiiScE2AFzbT59Juow810.m4a\r\n长生不死1548$http://audio.xmcdn.com/group41/M06/B7/4C/wKgJ8lrR_nXR267UAHe2hUiYj8M309.m4a\r\n长生不死1549$http://audio.xmcdn.com/group41/M06/B7/38/wKgJ8VrR_prSv1P2AH95Tv5776Q545.m4a\r\n长生不死1550$http://audio.xmcdn.com/group40/M01/7E/63/wKgJVFrR_ruww054AHr0MeNXTtQ347.m4a\r\n长生不死1551$http://audio.xmcdn.com/group41/M01/B4/6B/wKgJ8lrR6-iT8hS8AHKP3Bw_Q6A345.m4a\r\n长生不死1552$http://audio.xmcdn.com/group40/M08/7A/C7/wKgJT1rR7FHAnp_fAHlUnYZP2x8166.m4a\r\n长生不死1553$http://audio.xmcdn.com/group41/M07/B4/88/wKgJ8lrR7MfQ6UMyAIel1eXTx_w583.m4a\r\n长生不死1554$http://audio.xmcdn.com/group40/M06/7B/AB/wKgJVFrR7SjxreKZAHRMz9ym7KA951.m4a\r\n长生不死1555$http://audio.xmcdn.com/group40/M02/7B/B8/wKgJVFrR7auA1kOAAIig78pu4B4749.m4a\r\n长生不死1556$http://audio.xmcdn.com/group41/M05/B4/9D/wKgJ8VrR7g_w6nkPAH02wHc5UFI933.m4a\r\n长生不死1557$http://audio.xmcdn.com/group41/M01/B4/C1/wKgJ8lrR7n2zYBxpAHnkhtxkWcw739.m4a\r\n长生不死1558$http://audio.xmcdn.com/group41/M00/B4/BC/wKgJ8VrR7uKTRLzTAHkfwrd_jTc528.m4a\r\n长生不死1559$http://audio.xmcdn.com/group42/M00/B1/6C/wKgJ81rR707wHMzpAH0mmfVbi2g988.m4a\r\n长生不死1560$http://audio.xmcdn.com/group40/M01/7C/01/wKgJVFrR75eyMxtxAFRoUA-XM40148.m4a\r\n长生不死1561$http://audio.xmcdn.com/group40/M05/7C/10/wKgJVFrR8C-BaQs0AK-QrGqPWTw520.m4a\r\n长生不死1562$http://audio.xmcdn.com/group42/M0B/B6/7A/wKgJ9FrR8JHxX3dEAH3Mhw9LiOQ979.m4a\r\n长生不死1563$http://audio.xmcdn.com/group41/M05/B5/22/wKgJ8lrR8NnjQemEAE0jzSeD9fk535.m4a\r\n长生不死1564$http://audio.xmcdn.com/group40/M02/7B/67/wKgJT1rR8U3wvWXVAIhHXFeFBr4667.m4a\r\n长生不死1565$http://audio.xmcdn.com/group41/M04/B5/2C/wKgJ8VrR8ceyRzHJAILqXpuDyMI484.m4a\r\n长生不死1566$http://audio.xmcdn.com/group40/M09/7C/50/wKgJVFrR8gbxy3ZBAF10BRZ-RqM040.m4a\r\n长生不死1567$http://audio.xmcdn.com/group41/M06/B5/3E/wKgJ8VrR8n-xrdcrAID4y-lB6Is718.m4a\r\n长生不死1568$http://audio.xmcdn.com/group41/M0B/B5/53/wKgJ8VrR8vjRsZQ7AIfatN2Hoxw632.m4a\r\n长生不死1569$http://audio.xmcdn.com/group41/M0A/B5/76/wKgJ8lrR8zyi_z3YAFbZ2zVO-P0620.m4a\r\n长生不死1570$http://audio.xmcdn.com/group40/M06/7C/96/wKgJVFrR883i0KAJAJ5v63xNx7Q290.m4a\r\n长生不死1571$http://audio.xmcdn.com/group40/M08/7C/A1/wKgJVFrR9CnRQPWFAHr8_lvBUSA952.m4a\r\n长生不死1572$http://audio.xmcdn.com/group42/M02/B2/38/wKgJ81rR9I2zXqeEAHgwZWDtE9o130.m4a\r\n长生不死1573$http://audio.xmcdn.com/group40/M0B/7C/C1/wKgJVFrR9PSBHicgAHhvjPmdVzI586.m4a\r\n长生不死1574$http://audio.xmcdn.com/group40/M01/7C/CE/wKgJVFrR9Vbh27R_AHp0bwYKSr0724.m4a\r\n长生不死1575$http://audio.xmcdn.com/group41/M00/B5/B6/wKgJ8VrR9anT-A4XAG-qTwEgOkM904.m4a\r\n长生不死1576$http://audio.xmcdn.com/group42/M03/B7/53/wKgJ9FrR9g6zdBWuAHbFtDmtyI8982.m4a\r\n长生不死1577$http://audio.xmcdn.com/group41/M08/B5/F3/wKgJ8lrR9nKRPNPrAHTp673TU5Y707.m4a\r\n长生不死1578$http://audio.xmcdn.com/group41/M0A/B6/05/wKgJ8lrR9uniBVvUAIAyVvG5fGQ312.m4a\r\n长生不死1579$http://audio.xmcdn.com/group40/M0B/7D/24/wKgJVFrR91Dgv7wwAHUkqPkHudc866.m4a\r\n长生不死1580$http://audio.xmcdn.com/group41/M0B/B6/0E/wKgJ8VrR96SQgdXGAGsB8gY22XM081.m4a\r\n长生不死1581$http://audio.xmcdn.com/group41/M02/B6/2B/wKgJ8lrR-BLDHcpCAHwirsQZRBw554.m4a\r\n长生不死1582$http://audio.xmcdn.com/group40/M07/7C/8B/wKgJT1rR-HCzERXCAHQjsHM_CEQ999.m4a\r\n长生不死1583$http://audio.xmcdn.com/group42/M02/B2/EA/wKgJ81rR-OaQ6-baAIOdh5ss5BY294.m4a\r\n长生不死1584$http://audio.xmcdn.com/group42/M06/B2/F4/wKgJ81rR-USBw1IzAHyrQRgnK0U088.m4a\r\n长生不死1585$http://audio.xmcdn.com/group42/M05/B7/E5/wKgJ9FrR-dXzHdVyAJqg406RdQM332.m4a\r\n长生不死1586$http://audio.xmcdn.com/group40/M04/7C/C8/wKgJT1rR-iHDGRJfAG86tKzB0lc462.m4a\r\n长生不死1587$http://audio.xmcdn.com/group42/M03/B3/26/wKgJ81rR-oCSIADXAHgwm-Kt87Q776.m4a\r\n长生不死1588$http://audio.xmcdn.com/group42/M0A/B3/34/wKgJ81rR-sTwEXxJAFFGit89mmM580.m4a\r\n长生不死1589$http://audio.xmcdn.com/group41/M04/B6/B4/wKgJ8lrR-yvh8NefAHF0deX5FHo694.m4a\r\n长生不死1590$http://audio.xmcdn.com/group42/M09/B3/5E/wKgJ81rR-5uCTozMAHikZ79uhL0021.m4a\r\n长生不死1591$http://audio.xmcdn.com/group42/M08/B8/3D/wKgJ9FrR_AaDzg1iAIN14N8q8TI249.m4a\r\n长生不死1592$http://audio.xmcdn.com/group42/M04/B3/75/wKgJ81rR_GWS6EDUAHV4XVFx3ks566.m4a\r\n长生不死1593$http://audio.xmcdn.com/group41/M05/B6/FC/wKgJ8lrR_MygrKQXAHnLxMQzQe8546.m4a\r\n长生不死1594$http://audio.xmcdn.com/group42/M03/B8/71/wKgJ9FrR_SHDmvr2AG_5mSjp5Uo021.m4a\r\n长生不死1595$http://audio.xmcdn.com/group42/M07/B3/9E/wKgJ81rR_YDAIokuAHlb97U7KXs318.m4a\r\n长生不死1596$http://audio.xmcdn.com/group40/M08/7E/37/wKgJVFrR_dujjYE9AH36QhtdsEs673.m4a\r\n长生不死1597$http://audio.xmcdn.com/group40/M09/7D/70/wKgJT1rR_gmBoME3AFFck518Vzg638.m4a\r\n长生不死1598$http://audio.xmcdn.com/group42/M04/B3/C5/wKgJ81rR_kuwQPeHAHVxB_OMLF4528.m4a\r\n长生不死1599$http://audio.xmcdn.com/group42/M04/B3/C8/wKgJ81rR_mHz1UE6AE72xM8mxJo574.m4a\r\n长生不死1600$http://audio.xmcdn.com/group42/M06/B8/B0/wKgJ9FrR_nyCM2yIAE4e5oCjoVI028.m4a\r\n长生不死1601$http://audio.xmcdn.com/group42/M06/B0/F2/wKgJ81rR6_2jin-IAHR0chttYFM475.m4a\r\n长生不死1602$http://audio.xmcdn.com/group40/M08/7B/8A/wKgJVFrR7ELzq95NAFZf-5GmMkA864.m4a\r\n长生不死1603$http://audio.xmcdn.com/group42/M01/B5/EB/wKgJ9FrR7KyyOwUhAHBEfV2U4qk113.m4a\r\n长生不死1604$http://audio.xmcdn.com/group42/M09/B1/19/wKgJ81rR7QyhZQsjAHR2H8jF6Uk830.m4a\r\n长生不死1605$http://audio.xmcdn.com/group42/M03/B1/27/wKgJ81rR7XfCRMeiAHhCB8rE8x8698.m4a\r\n长生不死1606$http://audio.xmcdn.com/group42/M0A/B1/35/wKgJ81rR7d2QFlQWAHUmIHD5AaY513.m4a\r\n长生不死1607$http://audio.xmcdn.com/group41/M0B/B4/A8/wKgJ8VrR7krDRx4lAHuHCe7TANE309.m4a\r\n长生不死1608$http://audio.xmcdn.com/group40/M03/7B/D6/wKgJVFrR7o_BS67mAF4nL2jIRPA752.m4a\r\n长生不死1609$http://audio.xmcdn.com/group40/M04/7B/16/wKgJT1rR7wCSI2JKAHlTXEb6CJA671.m4a\r\n长生不死1610$http://audio.xmcdn.com/group42/M01/B6/43/wKgJ9FrR7zvy15SuAEv7LjbHAaA949.m4a\r\n长生不死1611$http://audio.xmcdn.com/group41/M0A/B4/EA/wKgJ8lrR76nQKu-JAHe2hYAvLB0378.m4a\r\n长生不死1612$http://audio.xmcdn.com/group42/M08/B6/65/wKgJ9FrR8B6gXCjAAIQtbMbkvNM204.m4a\r\n长生不死1613$http://audio.xmcdn.com/group42/M0B/B6/71/wKgJ9FrR8H2R6MEAAHXlBX-rD_I703.m4a\r\n长生不死1614$http://audio.xmcdn.com/group40/M0A/7C/25/wKgJVFrR8PHjn42wAIIT_CoGyv4951.m4a\r\n长生不死1615$http://audio.xmcdn.com/group40/M02/7B/6A/wKgJT1rR8VWBjo4sAH5oME8STJ0803.m4a\r\n长生不死1616$http://audio.xmcdn.com/group41/M04/B5/3A/wKgJ8lrR8b6yfkh9AHU3wmXufO4672.m4a\r\n长生不死1617$http://audio.xmcdn.com/group40/M09/7B/94/wKgJT1rR8ijxhlcVAHP5GiGyll4798.m4a\r\n长生不死1618$http://audio.xmcdn.com/group41/M0B/B5/41/wKgJ8VrR8ojyVPhRAHFy_qUfqzQ816.m4a\r\n长生不死1619$http://audio.xmcdn.com/group42/M06/B1/F1/wKgJ81rR8vyTEXXvAIA5r7P1kEo558.m4a\r\n长生不死1620$http://audio.xmcdn.com/group42/M01/B1/FF/wKgJ81rR82XDiWREAHXgn1uJaJk281.m4a\r\n长生不死1621$http://audio.xmcdn.com/group40/M06/7B/CA/wKgJT1rR883A9qXbAHvQq20bupc893.m4a\r\n长生不死1622$http://audio.xmcdn.com/group40/M08/7C/A4/wKgJVFrR9C_gFszIAHaDnbiRqrI508.m4a\r\n长生不死1623$http://audio.xmcdn.com/group40/M04/7B/E8/wKgJT1rR9KTRbyCuAIFppNmxrtU723.m4a\r\n长生不死1624$http://audio.xmcdn.com/group42/M0B/B7/20/wKgJ9FrR9ObDCI82AFEdbAU1AL0465.m4a\r\n长生不死1625$http://audio.xmcdn.com/group40/M00/7B/FD/wKgJT1rR9TDg2mBgAFC5kBHBV7E521.m4a\r\n长生不死1626$http://audio.xmcdn.com/group42/M06/B2/53/wKgJ81rR9X3jkZXuAFNM5GV83v8805.m4a\r\n长生不死1627$http://audio.xmcdn.com/group42/M05/B2/7C/wKgJ81rR9hmjkSIrAKnoygC6fMc317.m4a\r\n长生不死1628$http://audio.xmcdn.com/group42/M05/B7/5A/wKgJ9FrR9lHT350oAFFck8PeM9g929.m4a\r\n长生不死1629$http://audio.xmcdn.com/group42/M0A/B7/6D/wKgJ9FrR9seSCrzMAIFMRXb4vBE253.m4a\r\n长生不死1630$http://audio.xmcdn.com/group40/M0B/7D/23/wKgJVFrR903ix5HbAHt_r9sJaAg185.m4a\r\n长生不死1631$http://audio.xmcdn.com/group41/M0B/B6/1C/wKgJ8lrR95iSfag9AG89o2LYytk337.m4a\r\n长生不死1632$http://audio.xmcdn.com/group42/M07/B2/C4/wKgJ81rR9-qyDh8jAH6ehjDFh2E958.m4a\r\n长生不死1633$http://audio.xmcdn.com/group41/M07/B6/24/wKgJ8VrR-EqBjFZxAHe5dM6eOrM796.m4a\r\n长生不死1634$http://audio.xmcdn.com/group42/M00/B7/BE/wKgJ9FrR-LDjixZFAHo2w3_Fc3s404.m4a\r\n长生不死1635$http://audio.xmcdn.com/group40/M09/7C/A7/wKgJT1rR-SqiyfxxAHnRcGplTso617.m4a\r\n长生不死1636$http://audio.xmcdn.com/group41/M01/B6/58/wKgJ8VrR-XWShBt9AHyoTlATebA420.m4a\r\n长生不死1637$http://audio.xmcdn.com/group42/M05/B3/0B/wKgJ81rR-diCr2CJAHcAcBAJK0o777.m4a\r\n长生不死1638$http://audio.xmcdn.com/group40/M04/7D/9E/wKgJVFrR-kWi4muWAHJ52PuqmNY665.m4a\r\n长生不死1639$http://audio.xmcdn.com/group41/M00/B6/92/wKgJ8VrR-q_DhzX9AILqXnWIuOs475.m4a\r\n长生不死1640$http://audio.xmcdn.com/group40/M00/7D/CE/wKgJVFrR-w6QmQfZAHWM6hldJ7I436.m4a\r\n长生不死1641$http://audio.xmcdn.com/group42/M09/B3/4A/wKgJ81rR-3DS1h9UAHjBxUG2XP0073.m4a\r\n长生不死1642$http://audio.xmcdn.com/group40/M0B/7D/1B/wKgJT1rR-_KwWkd4AHWFlGL0k9I757.m4a\r\n长生不死1643$http://audio.xmcdn.com/group41/M0A/B6/E8/wKgJ8lrR_DqTnYh6AHIgRZLtsiw285.m4a\r\n长生不死1644$http://audio.xmcdn.com/group40/M0A/7D/41/wKgJT1rR_KfTEunVAIDp5pXpWeA133.m4a\r\n长生不死1645$http://audio.xmcdn.com/group42/M03/B3/8E/wKgJ81rR_RPyVYpuAHNdcasSBpU629.m4a\r\n长生不死1646$http://audio.xmcdn.com/group40/M05/7D/5A/wKgJT1rR_WmyLi-0AHmpyWl3sJc325.m4a\r\n长生不死1647$http://audio.xmcdn.com/group42/M02/B3/B6/wKgJ81rR_cmz8doZAHUeyqlXvHs918.m4a\r\n长生不死1648$http://audio.xmcdn.com/group40/M09/7D/75/wKgJT1rR_hPAmkT1AHIu9PZZQBI799.m4a\r\n长生不死1649$http://audio.xmcdn.com/group41/M08/B7/46/wKgJ8lrR_jrzk5ukAFRlXYToY7M917.m4a\r\n长生不死1650$http://audio.xmcdn.com/group40/M06/7D/84/wKgJT1rR_luiInO3AEtvq57CkRA966.m4a\r\n长生不死1651$http://audio.xmcdn.com/group42/M06/B0/F2/wKgJ81rR6_uhojZ8AG8IyMd6NXc510.m4a\r\n长生不死1652$http://audio.xmcdn.com/group41/M02/B4/7A/wKgJ8lrR7GCjKiYJAHo4O5kAgUE436.m4a\r\n长生不死1653$http://audio.xmcdn.com/group41/M07/B4/88/wKgJ8lrR7MfAEb_OAHI3wU017WQ643.m4a\r\n长生不死1654$http://audio.xmcdn.com/group40/M06/7A/E5/wKgJT1rR7TDiFGTmAHvg0kdfjyg878.m4a\r\n长生不死1655$http://audio.xmcdn.com/group41/M03/B4/8C/wKgJ8VrR7ZrjIlifAHTPgBZqdAk739.m4a\r\n长生不死1656$http://audio.xmcdn.com/group42/M0A/B6/1C/wKgJ9FrR7gGA21jKAHmvq8VPgUE904.m4a\r\n长生不死1657$http://audio.xmcdn.com/group42/M04/B1/3E/wKgJ81rR7kyT1KwyAFRDmMyJBYA322.m4a\r\n长生不死1658$http://audio.xmcdn.com/group41/M06/B4/B2/wKgJ8VrR7rqhRFvhAHITDe9cpmg753.m4a\r\n长生不死1659$http://audio.xmcdn.com/group41/M00/B4/C5/wKgJ8VrR7vji6XW4AE-ikO83zX0337.m4a\r\n长生不死1660$http://audio.xmcdn.com/group40/M07/7B/F0/wKgJVFrR71mBOlMuAG_gpQwV-r0329.m4a\r\n长生不死1661$http://audio.xmcdn.com/group42/M06/B1/6F/wKgJ81rR76HgVvSjAFFArMdqAwM560.m4a\r\n长生不死1662$http://audio.xmcdn.com/group40/M05/7B/3E/wKgJT1rR8CLSHtjqAIMvYxhkeA0366.m4a\r\n长生不死1663$http://audio.xmcdn.com/group41/M05/B4/F7/wKgJ8VrR8KOQkd6-AJp8K3Y97hQ181.m4a\r\n长生不死1664$http://audio.xmcdn.com/group40/M0B/7B/62/wKgJT1rR8TTjTHcIAKDP3ASZ0YM818.m4a\r\n长生不死1665$http://audio.xmcdn.com/group41/M04/B5/30/wKgJ8lrR8anTeHARAIIGxMSA69c591.m4a\r\n长生不死1666$http://audio.xmcdn.com/group40/M09/7B/8C/wKgJT1rR8hbzaPdEAH83PPTCzyI139.m4a\r\n长生不死1667$http://audio.xmcdn.com/group42/M08/B6/B8/wKgJ9FrR8lry8nWJAFAH4nL4Wuo889.m4a\r\n长生不死1668$http://audio.xmcdn.com/group40/M07/7B/9D/wKgJT1rR8sGCLly8AHYVfexQtUw795.m4a\r\n长生不死1669$http://audio.xmcdn.com/group41/M0A/B5/6F/wKgJ8lrR8y7TFcrsAHuhdLs7ZxM190.m4a\r\n长生不死1670$http://audio.xmcdn.com/group41/M07/B5/6E/wKgJ8VrR85nAqG65AHZjUODQdXs330.m4a\r\n长生不死1671 完结$http://audio.xmcdn.com/group41/M09/B5/8E/wKgJ8lrR9BXjdKLqAHFEAa0OTug545.m4a', 'xml_8023', '6794', '', 'C', '', '1.0', 4, 0, 0, 0, 'changshengbusi', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(144, 24, '朗读', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group42/M03/A0/D7/wKgJ9Frd0eijJemFABDy8MTLmaM157.jpg', '', 1530072223, 2, 0, 0, 0, 0, 1, 1, 3, 6, 'ting', '', '太阳$http://audio.xmcdn.com/group42/M08/01/92/wKgJ81rjGDCgxDE0AAHUuCgGPKY557.m4a\r\n流鼻涕的冬天$http://audio.xmcdn.com/group40/M04/B3/D2/wKgJT1rhxZCzE1uMAAG7wGbthBQ616.m4a\r\n白天与黑夜$http://audio.xmcdn.com/group42/M08/EE/24/wKgJ9FrhxUbCIDLfAAJV8lsiNNk075.m4a\r\n太阳和眼睛$http://audio.xmcdn.com/group42/M08/EE/14/wKgJ9FrhxRCiy7wdAADg9Is-x1s620.m4a\r\n原谅$http://audio.xmcdn.com/group42/M08/E9/4A/wKgJ81rhxQeTHNCoAAMEsX3a7Ng772.m4a\r\n曹孟德割须弃袍$http://audio.xmcdn.com/group41/M05/EC/A7/wKgJ8Vrhw_yz5HAfAE24HBMFK7w731.m4a\r\n回到地面$http://audio.xmcdn.com/group42/M00/D6/90/wKgJ9FrgfDPysDYbAAGf2WkcmlA483.m4a\r\n星月的来由$http://audio.xmcdn.com/group42/M07/D1/B2/wKgJ81rge7WjkKMwAAKGZkHh68k255.m4a\r\n胆小的种子$http://audio.xmcdn.com/group42/M03/D1/A1/wKgJ81rge26js2HmAAMZPg0810o469.m4a\r\n灯$http://audio.xmcdn.com/group40/M09/9C/87/wKgJVFrgexyin3e4AACjkSbJe8g649.m4a\r\n百合花开$http://audio.xmcdn.com/group41/M05/D5/22/wKgJ8lrgeuWxpCVJAALTBET2EJs508.m4a\r\n十诫诗$http://audio.xmcdn.com/group42/M02/D6/28/wKgJ9Frgehzz2YyjAAsSXmPiHGM895.m4a\r\n岁月（节选）$http://audio.xmcdn.com/group40/M03/82/9C/wKgJT1rfKySjzZSbAAnchwZqRJw356.m4a\r\n早与晚$http://audio.xmcdn.com/group42/M04/B8/6D/wKgJ81rfKnfR8vn1AAF3dz-yrts370.m4a\r\n不知来生少年时$http://audio.xmcdn.com/group40/M07/83/22/wKgJVFrfKkLRx2eCAAHzjiakvhQ835.m4a\r\n洁白的仙鹤$http://audio.xmcdn.com/group42/M05/BD/49/wKgJ9FrfKgbBYnnOAAHtsJ2raAE383.m4a\r\n在那东方山顶$http://audio.xmcdn.com/group40/M08/83/06/wKgJVFrfKcLBZl5FAAJprYsvrYQ249.m4a\r\n这般热恋的爱人$http://audio.xmcdn.com/group42/M0A/BD/1F/wKgJ9FrfKU-QKTdFAAHcEoO9rQw729.m4a\r\n有你便好$http://audio.xmcdn.com/group41/M01/BB/83/wKgJ8lrfKQPAQpMXAAKGqvCSqIk861.m4a\r\n亲爱的人$http://audio.xmcdn.com/group40/M05/82/CF/wKgJVFrfKJuwzk3oAAG79oBJikk219.m4a\r\n莫言破晓我归来$http://audio.xmcdn.com/group41/M06/BB/58/wKgJ8lrfKEPie5lFAAJHQ9vS4V4687.m4a\r\n梦寐不忘$http://audio.xmcdn.com/group42/M02/B7/D9/wKgJ81rfJ8GA75oTAAI3HGciHnU430.m4a\r\n爱我的爱人儿$http://audio.xmcdn.com/group40/M06/81/D6/wKgJT1rfJ2TgbGLIAAHqwXepbgk001.m4a\r\n邂逅相遇的情人$http://audio.xmcdn.com/group40/M05/81/CE/wKgJT1rfJzuhRMsgAAI8-ikfb_8542.m4a\r\n我是世间最美的情郎$http://audio.xmcdn.com/group40/M01/82/6C/wKgJVFrfJrfgnj3_AAIMhu3Pr_0922.m4a\r\n三件旧衣服的启示$http://audio.xmcdn.com/group41/M07/9F/29/wKgJ8Vrd0hmjGEVnAEGEv5b8YyU101.m4a\r\n一如既往的夏天$http://audio.xmcdn.com/group40/M0A/CC/BB/wKgJVFrjF8CSV00dAASBBCB9NQg636.m4a\r\n那一天，那一月，那一年，那一世$http://audio.xmcdn.com/group42/M07/D1/2D/wKgJ81rgeUah6XA5AAZLkmOzv9o892.m4a', 'xml_8023', '2657', '', 'L', '', '1.0', 6, 0, 0, 0, 'langdu', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(145, 24, '安利互联网新模式', '', '未知', '', '', '', '互联网安利微营销导师微信：a13037895193感谢您关注订阅专辑，世界在变，直销在变，运作安利的方式也在变，互联网的优势：1.真正的没有开支；2.不用到处找人，让准对象找我们；3.不用东奔西跑，在家里用手机电脑做学习和推广；4.运用互联网工具学习和推广，轻松效率高；5.现在互联网运作，伙伴不易流失，团队倍增快！不但解决了找人倍增快！不但解决了找人难，推荐难，留人难，还解决了学习难，发展难，带动难的瓶颈。真正高姿态运作安利，在轻资产创业的封口浪尖上，兼顾家庭事业的同时，利用零碎时间建立属于自己的财富管道收入，互联网+安利时代来了，您准备好了吗？一样的安利+互联网，不一样的精彩！互联网安利对原有的运作模式做了更强大的提升；利用信息化技术平台做3S工作；独创微营销发展模式100%成功； 一部手机，一台电脑，人在哪里，事业就在哪里！自由自在！适合上班的您，也适合做生意的您，也适合宝妈的您，更适合想创业的...安利提供创业机会，系统帮你实现梦想！FC付后坚周志坚郭洪斌孙东谭志波张磊赵洋陶铭康君陈婉芬雷雨鸣纽崔莱手珍咖啡灌肠成冠纽崔莱雅姿XS饮料丰盛人生创业人生', 'http://imagev2.xmcdn.com/group42/M09/6A/7B/wKgJ81rOLWazHDczAAKriP0MzGs604.jpg', '', 1530072223, 5, 0, 0, 0, 0, 1, 1, 4, 10, 'ting', '', '390.安利高经理讲话小小分享$http://audio.xmcdn.com/group42/M08/8A/AD/wKgJ81rc7gWgbKXTAWS4xmaTdD8126.m4a\r\n389.安利高级总监讲益之源净化器小小分享$http://audio.xmcdn.com/group41/M05/8D/DA/wKgJ8Vrc7RjCF7HfAJz5egwb-aY289.m4a\r\n388.安利领导人培训-陈来发小小分享$http://audio.xmcdn.com/group41/M08/8D/DA/wKgJ8Vrc7TzDTJvUA0bxJPoVLPo844.m4a\r\n387.安利陆永菊FC分享小小分享$http://audio.xmcdn.com/group41/M08/8D/E9/wKgJ8lrc6gzyfFJNASPqZaZStS0669.m4a\r\n386.安利陆永菊FC《观念态度篇》小小分享$http://audio.xmcdn.com/group42/M03/8A/9B/wKgJ81rc6SKDZsg7AWOTFv9JnaE384.m4a\r\n384.安利金惠明FC《行动成就辉煌》小小分享$http://audio.xmcdn.com/group41/M0B/8D/C9/wKgJ8Vrc5_rjJXJLATMFAQ3nPz0943.m4a\r\n383.安利郭洪斌FC：观念与态度小小分享$http://audio.xmcdn.com/group41/M03/8D/C6/wKgJ8Vrc50nCX92QAkNTyiFiL4g639.m4a\r\n382.安利郭洪斌FC传承 创新 整合小小分享$http://audio.xmcdn.com/group40/M05/54/89/wKgJT1rc5XnR2M7-AcNz-sjuo3k323.m4a\r\n381.安利郭洪斌FC《格局决定结局》小小分享$http://audio.xmcdn.com/group42/M08/8A/88/wKgJ81rc5CTDdPxMAdbbsDmmCZg801.m4a\r\n380.安利郭洪斌FC 冠元20载 与君共江湖小小分享$http://audio.xmcdn.com/group40/M04/54/82/wKgJT1rc4s-xpwT_AVlETlJktY4395.m4a\r\n379.安利郭洪伟高级总监分享小小分享$http://audio.xmcdn.com/group41/M09/8D/D0/wKgJ8lrc4Zzi5QFnAPVrRgTaSzQ160.m4a\r\n378.安利郑浩天FC《有志者事竟成》小小分享$http://audio.xmcdn.com/group41/M04/8D/B2/wKgJ8Vrc4POjyAKoAmnGtAyEDm0920.m4a\r\n377.安利郑浩天FC《创业者的态度》小小分享$http://audio.xmcdn.com/group41/M09/8D/C6/wKgJ8lrc3r3AE06XAXGiOHlzPBQ444.m4a\r\n376.安利超凡年会眼界，心界，世界-彭建屏2017.09.13小小分享$http://audio.xmcdn.com/group42/M03/8A/71/wKgJ81rc3WPRm5W5AEbKc71DVaI266.m4a\r\n375.安利超凡年会成功经验分享-钟易宏2017.09.14小小分享$http://audio.xmcdn.com/group42/M01/8F/5D/wKgJ9Frc3XTRrByhAVn73iqcXpg665.m4a\r\n374.安利超凡年会成功经验分享-郑新清、周帆扬2017.09.13小小分享$http://audio.xmcdn.com/group42/M04/8F/56/wKgJ9Frc3E-yRjkAAT7dGvvw1kk075.m4a\r\n372.安利超凡年会成功经验分享-李京诚2017.09.13小小分享$http://audio.xmcdn.com/group41/M02/8D/B9/wKgJ8lrc20GiZCDCAJgsZPTWVtA230.m4a\r\n371.安利超凡年会成功经验分享-吴奕，熊世翔20170914小小分享$http://audio.xmcdn.com/group40/M06/54/65/wKgJT1rc2q_woAgoAKHeDEC0ZDk398.m4a\r\n370.安利超凡年会成功经验分享-刘红2017.09.14小小分享$http://audio.xmcdn.com/group41/M08/8D/98/wKgJ8Vrc2hSiIrLJAJX4hTR_kCE134.m4a\r\n369.安利超凡年会成功经验分享-刘德沛2017.09.14小小分享$http://audio.xmcdn.com/group40/M03/55/11/wKgJVFrc2Y6wNW1kALYJEkoUuH0071.m4a\r\n368.安利超凡年会FC群星分享20170914小小分享$http://audio.xmcdn.com/group41/M00/8D/AF/wKgJ8lrc2MGyrULbAOUxEoTLNZE447.m4a\r\n367.安利袁唯群FC《梦想之夜》小小分享$http://audio.xmcdn.com/group40/M01/54/58/wKgJT1rc186ha79DAHmg_Dtu0qo897.m4a\r\n366.安利藏琪-安利的魅力 B小小分享$http://audio.xmcdn.com/group42/M08/8F/40/wKgJ9Frc15jDwaKrAZPKEzk-RQY956.m4a\r\n365.安利藏琪-安利的魅力 A小小分享$http://audio.xmcdn.com/group40/M0B/54/FE/wKgJVFrc1gKDdLA1Aaw2B63itL0430.m4a\r\n364.安利茹志娟FC《心路历程您也可以做得到》小小分享$http://audio.xmcdn.com/group40/M0A/54/43/wKgJT1rc1EGhlcXiAZb0EuIug-E515.m4a\r\n363.安利胡文莉FC《用享受的心态做目标》小小分享$http://audio.xmcdn.com/group41/M08/8D/78/wKgJ8Vrc0paR5iN9AOnNr4NV10M883.m4a\r\n362.安利胡天鹏FC《行动才能创造奇迹》小小分享$http://audio.xmcdn.com/group40/M05/54/36/wKgJT1rc0cKhmb60ASU2RB42wNk771.m4a\r\n361.安利纽志勤高级总监《我是一切的根源》小小分享$http://audio.xmcdn.com/group42/M0B/8F/16/wKgJ9Frc0I-QFvsMAQjQDKfpL9s188.m4a\r\n360.安利章凡博士FC《你也可以做得到》小小分享$http://audio.xmcdn.com/group41/M00/8D/87/wKgJ8lrcz5ayyOmtAWcgDIJaou0800.m4a\r\n359.安利石法武《成大业者必备的素质》小小分享$http://audio.xmcdn.com/group41/M0B/8D/80/wKgJ8lrczi-BCaOsAPKCxbdmcLI097.m4a\r\n358.安利真正达标的原因2小小分享$http://audio.xmcdn.com/group41/M04/8D/58/wKgJ8VrczUCg0SHFAO2TU5HWajU067.m4a\r\n357.安利真正达标的原因1小小分享$http://audio.xmcdn.com/group41/M07/8D/51/wKgJ8VrczDqCVLnVAO5mm8OstmE592.m4a\r\n356.安利皇冠大使杨辉FC小小分享$http://audio.xmcdn.com/group42/M00/8E/FD/wKgJ9Frcy2vDHj2hAYmvXMW-xO0778.m4a\r\n354.安利的企业文化 小小分享 $http://audio.xmcdn.com/group40/M02/54/09/wKgJT1rcydWwoskfAVxby3YxRu4814.m4a\r\n352.安利现在开始正是时候 郭洪斌FC小小分享$http://audio.xmcdn.com/group41/M06/8D/3F/wKgJ8VrcyUOARUNCBGZ_PWtt1uc559.m4a\r\n351.安利海量推荐 沈强FC小小分享$http://audio.xmcdn.com/group40/M08/54/8C/wKgJVFrcxF-hkkVxAjHsjOe7szY348.m4a\r\n348.安利杜国渊分享小小分享$http://audio.xmcdn.com/group41/M09/8D/30/wKgJ8lrcwryjIQY2A6SrXSuB3oE005.m4a\r\n347.安利是一个公平的事业_陆银方FC小小分享$http://audio.xmcdn.com/group40/M03/54/53/wKgJVFrcvimhSPcpAKeQM8wRnGQ829.m4a\r\n346.安利方向FC分享小小分享$http://audio.xmcdn.com/group41/M09/8C/E3/wKgJ8VrcvbngEqOKAiZ5kKzjfHM522.m4a\r\n345.安利新雅蜜培训小小分享$http://audio.xmcdn.com/group40/M00/54/3B/wKgJVFrcu8bQj9SSAmIFYUrXsy8418.m4a\r\n343.安利文化大讲堂～阿拉斯加小小分享$http://audio.xmcdn.com/group42/M08/8E/61/wKgJ9FrcuF2THb-7ApsT545bjfE646.m4a\r\n342.安利我快乐，所以你快乐 方向FC 小小分享$http://audio.xmcdn.com/group41/M08/8C/79/wKgJ8VrctNbRnjB8BBLRtgNgwQ4292.m4a\r\n718.黄红宁150计划小小分享$http://audio.xmcdn.com/group41/M01/55/BB/wKgJ8lraC3jBJSt_AFS-8-LjRbw465.m4a\r\n717.黃桂珠FC超凡小小分享$http://audio.xmcdn.com/group40/M00/1C/81/wKgJT1raC3KhFXD4AFfDVkC_x4k761.m4a\r\n718.黄红宁150计划小小分享$http://audio.xmcdn.com/group40/M05/1C/66/wKgJT1raCcjhXPd_AFS-8-g_2wk754.m4a\r\n717.黃桂珠FC超凡小小分享$http://audio.xmcdn.com/group40/M05/1D/21/wKgJVFraCcjzMgh4AFfDVo-KHeE199.m4a\r\n323.安利创业正确的心态6$http://audio.xmcdn.com/group40/M0B/F5/CC/wKgJT1rYH_DydYP4AE5fgY1qpA8235.m4a\r\n322.安利创业正确的心态5$http://audio.xmcdn.com/group41/M05/2E/E3/wKgJ8VrYH82x8bgbAE5idKjLbho181.m4a\r\n321.安利创业正确的心态4$http://audio.xmcdn.com/group40/M0B/F5/C4/wKgJT1rYH7LBm8I-AE5idJqcri4452.m4a\r\n320.安利创业正确的心态3$http://audio.xmcdn.com/group41/M05/2E/E1/wKgJ8VrYH6LBqfNzAE5idJzgs9k032.m4a\r\n319.安利创业正确的心态2$http://audio.xmcdn.com/group42/M0A/30/66/wKgJ9FrYH4CCVlwmAE5idEJm-tc775.m4a\r\n318.安利创业成功的钥匙--付后坚四地FC小小分享$http://audio.xmcdn.com/group41/M05/2E/E3/wKgJ8VrYH8_QVttFAoPCtjBe9II668.m4a\r\n317.安利公司高层高晓明先生致辞小小分享$http://audio.xmcdn.com/group41/M0A/2E/FD/wKgJ8lrYHpvBA4D7AHo8oZXVFk8447.m4a\r\n316.安利八大健康指标详解小小分享$http://audio.xmcdn.com/group41/M0A/2F/00/wKgJ8lrYHqeSNhlcAanhsjtxFTo476.m4a\r\n314.安利傅后坚 《颠覆习惯》 小小分享$http://audio.xmcdn.com/group40/M07/F5/AB/wKgJT1rYHlfRTm1lAs14GMX6pk0044.m4a\r\n313.安利众诚南京孙东《如何快速启动新人》$http://audio.xmcdn.com/group41/M01/2E/E1/wKgJ8lrYHZTBbQB-A5jV_f7NSic413.m4a\r\n312.安利付玉萍《如何长远的发展生意》小小分享$http://audio.xmcdn.com/group41/M03/2E/D2/wKgJ8lrYHFaDC0CmAliOdrPqmgo489.m4a\r\n311.安利付后坚：最新OPP小小分享$http://audio.xmcdn.com/group40/M0A/F5/7D/wKgJT1rYG_uTUYHBAoURhEVzg3M937.m4a\r\n310.安利付后坚领导人培训3小小分享$http://audio.xmcdn.com/group41/M05/2E/B7/wKgJ8lrYGtDzksuzAQVLXnTbE9c976.m4a\r\n309.安利付后坚领导人培训2小小分享$http://audio.xmcdn.com/group41/M03/2E/B4/wKgJ8lrYGquT2ej5AQVLfsLLeWM304.m4a\r\n308.安利付后坚领导人培训1小小分享$http://audio.xmcdn.com/group40/M08/F5/5C/wKgJT1rYGm3yoI04AQVLfshLmoo784.m4a\r\n307.安利付后坚2016.1.24于济南省会大剧院小小分享$http://audio.xmcdn.com/group40/M08/F5/65/wKgJT1rYGpHQl96eAeqrqBfrlQk705.m4a\r\n306.安利付后坚 领导人与新4X4小小分享$http://audio.xmcdn.com/group41/M09/2E/AD/wKgJ8lrYGh3w1VUzAsBJoeaQr5o044.m4a\r\n304.安利《基业长青 巅峰共舞》陈来发FC成冠小小分享$http://audio.xmcdn.com/group41/M01/2E/A6/wKgJ8lrYGYXRUE9ZAhDGevTPdpI560.m4a\r\n303.安利《助力青春 引领未来》青岛FC尹建平小小分享$http://audio.xmcdn.com/group41/M06/2E/64/wKgJ8VrYGOvxTvWbApVmJxM5ZA4006.m4a\r\n302.安利‘过五关，找六将“ 金惠明FC小小分享$http://audio.xmcdn.com/group40/M07/F6/1C/wKgJVFrYGD6xfqPSAphhvefL0AA434.m4a\r\n301.安利FC郭志宏分享小小分享$http://audio.xmcdn.com/group42/M02/2B/21/wKgJ81rYF5DSV4efAklZpe-F_Io069.m4a\r\n300.安利FC罗文斌分享小小分享$http://audio.xmcdn.com/group40/M03/F5/21/wKgJT1rYFr2jeXjwALI89BaN4vs172.m4a\r\n299.安利FC宗士杰《敢梦 敢想 敢成功》小小分享$http://audio.xmcdn.com/group42/M06/2B/1B/wKgJ81rYFvvhDMjgAZtrxUjbN3k401.m4a\r\n298.安利FC付后坚 如何失败小小分享$http://audio.xmcdn.com/group40/M02/F5/FF/wKgJVFrYFp3TQwhJAfIfJ_NWsjk328.m4a\r\n297.安利.孙东 顺势而上小小分享$http://audio.xmcdn.com/group41/M0B/2E/72/wKgJ8lrYFj7B5Z0EAqbNYTi9kio672.m4a\r\n296.安利.创办人信念小小分享  $http://audio.xmcdn.com/group42/M04/2F/AC/wKgJ9FrYFRDQdg2CABA5BouRZZo294.m4a\r\n295.安利.为创业者喝彩-颜志荣小小分享$http://audio.xmcdn.com/group41/M07/2E/2D/wKgJ8VrYFUGRrzLsAKjDGg-0RZY744.m4a\r\n293.安利 选择成就未来 小小分享$http://audio.xmcdn.com/group41/M07/2E/2F/wKgJ8VrYFUmgrWE_AhGFYApaDfY951.m4a\r\n292.安利 机车大叔的幸福生活小小分享$http://audio.xmcdn.com/group42/M07/2F/A1/wKgJ9FrYFGvRmYxeAF4oppk956w687.m4a\r\n291.安利 未来的梦想-陆威龙（高级经理）小小分享$http://audio.xmcdn.com/group41/M0A/2E/20/wKgJ8VrYFJXzI9wlAeYQgv-gDNw342.m4a\r\n290.安利 挑战极限 小小分享$http://audio.xmcdn.com/group40/M0A/F5/DF/wKgJVFrYFDfz_jlPAd4qeKZDszQ642.m4a\r\n289.安利 开发区总结 韩姐小小分享$http://audio.xmcdn.com/group40/M06/F5/C9/wKgJVFrYE2iDRXp4Ai1mIoaqTv0643.m4a\r\n288.安利 品牌的敌人 小小分享.m4a$http://audio.xmcdn.com/group40/M09/F4/DB/wKgJT1rYEnjTzquEAVKwBW_tZlo609.m4a\r\n287.安利 呼吸系统与心脑血管疾病-贝春娇小小分享$http://audio.xmcdn.com/group42/M04/2F/7F/wKgJ9FrYEjHC4VlcAo6BFQuhDrg440.m4a\r\n341.安利成冠系统文化助你基业长青_1$http://audio.xmcdn.com/group40/M05/22/4E/wKgJT1ranIeQdYz7AA_-SfXewwk022.m4a\r\n340.安利成冠核心价值观 陈来发FC小小分享$http://audio.xmcdn.com/group40/M09/22/51/wKgJT1ranKTgtA_KAWiz3JeLGMk192.m4a\r\n339.安利成冠年会-陈来发小小分享$http://audio.xmcdn.com/group42/M0A/5D/38/wKgJ9Fram4iB2joZAl1OVHa54iA945.m4a\r\n338.安利成冠年会-方向小小分享$http://audio.xmcdn.com/group42/M07/5D/0E/wKgJ9FramcGC1MR7Ayv-bjPhkC0246.m4a\r\n337.安利成冠A60群星目标小小分享$http://audio.xmcdn.com/group40/M04/22/6F/wKgJVFralbWDEgyqAkZ7bT4Ok4Y014.m4a\r\n335.安利张明德副总裁演讲小小分享$http://audio.xmcdn.com/group41/M03/5A/9D/wKgJ8Vrak7qzu3TZBTSN0MBdgEo803.m4a\r\n334.安利张丽萍总监《下决定的重要性》小小分享$http://audio.xmcdn.com/group41/M08/5A/2F/wKgJ8lrajJ3x1q3dAGdI7rsgFFw034.m4a\r\n333.安利孙东FC《现在开始正是时候》小小分享$http://audio.xmcdn.com/group40/M02/21/A0/wKgJVFrajMawGBfhA5RoWOIRznM482.m4a\r\n332.安利奋斗一辈子 享受一辈子_郑浩天FC小小分享$http://audio.xmcdn.com/group41/M00/59/78/wKgJ8VrahcWhAugPAOcnRQ1AO40988.m4a\r\n331.安利失落的人才3小小分享$http://audio.xmcdn.com/group41/M04/59/67/wKgJ8VrahLLgCtfbANRKnMB82mM591.m4a\r\n330.安利失落的人才2小小分享$http://audio.xmcdn.com/group42/M05/56/65/wKgJ81rag7-Cp68SANRNerzpHSs992.m4a\r\n329.安利失落的人才1小小分享$http://audio.xmcdn.com/group41/M05/59/38/wKgJ8VragnmQOloZANRNej48A3s534.m4a\r\n328.安利四期 韩姐小小分享$http://audio.xmcdn.com/group41/M04/59/49/wKgJ8lragOvyfI9uAMwu6VfGEgo409.m4a\r\n271.孙大哥经理会议小小分享$http://audio.xmcdn.com/group40/M09/F2/FD/wKgJT1rX-M2j_g4zAe97rJjRluI714.m4a\r\n272.孙大哥经理培训小小分享$http://audio.xmcdn.com/group40/M07/F3/F5/wKgJVFrX-WuAIAqgAhMNb0vqF1U102.m4a\r\n273.孙大哥讲决战A60小小分享$http://audio.xmcdn.com/group42/M0A/29/15/wKgJ81rX-kajdcbXAjb7uDJiyi0520.m4a\r\n274.孙大哥超凡文化2小小分享$http://audio.xmcdn.com/group42/M09/29/20/wKgJ81rX-vngdHoaAgjQf2c5cFQ463.m4a\r\n275.孙大哥超凡文化小小分享$http://audio.xmcdn.com/group40/M00/F3/38/wKgJT1rX_BrgryfIApuVHbaE31s975.m4a\r\n276.孙大哥领导人培训小小分享$http://audio.xmcdn.com/group41/M00/2C/5B/wKgJ8VrX_HLj56hMAYAWrG2aaYU144.m4a\r\n277.孙德兵 成功轨迹超凡小小分享$http://audio.xmcdn.com/group41/M01/2C/68/wKgJ8VrX_R6wntP3AaPEVsweGM4938.m4a\r\n278.孙德兵宋春晖 六六大顺超凡小小分享$http://audio.xmcdn.com/group41/M07/2C/70/wKgJ8VrX_Zmw4Ga_Aae_kYZd-PI154.m4a\r\n279.孙德宾老师五度一力超凡小小分享$http://audio.xmcdn.com/group41/M04/2C/B3/wKgJ8lrX_gfyLH5SAdKEFLWJvTQ521.m4a\r\n270.孙大哥点评营养早餐$http://audio.xmcdn.com/group41/M01/28/0F/wKgJ8VrXf8Szd9IgAKn2Al19mmI243.m4a\r\n269.孙大哥总结小小分享$http://audio.xmcdn.com/group40/M05/EF/EE/wKgJVFrXf6nzhZg6AptY6Qrq_xk802.m4a\r\n268.孙大哥团队训练1小小分享$http://audio.xmcdn.com/group41/M04/28/05/wKgJ8VrXfkbyZPI7ApuNyJvTk6o397.m4a\r\n267.孙大哥个人介绍点评小小分享$http://audio.xmcdn.com/group40/M00/EE/E0/wKgJT1rXfRCQ9QaTAY3-K2edUIw921.m4a\r\n266.孙大哥《领导人培训》小小分享$http://audio.xmcdn.com/group41/M05/27/F7/wKgJ8VrXfDOycvm3AT0S9BAdQr8493.m4a\r\n265.孙东FC《现在开始正是时候》$http://audio.xmcdn.com/group40/M04/EE/D6/wKgJT1rXe_zxts3AA5RpzypQThM598.m4a\r\n264.孙《格局布局结局小小分享》$http://audio.xmcdn.com/group40/M00/EF/C4/wKgJVFrXeiqjbke4Apt2R6IG6N8265.m4a\r\n221.华玲《情绪与健康》小小分享$http://audio.xmcdn.com/group40/M08/AA/CA/wKgJVFrUTdCh6AOHAgbl0m01Nqg647.m4a\r\n222.台北-fc们分享小小分享$http://audio.xmcdn.com/group40/M09/A9/F5/wKgJT1rUTlvzkmJIAb4v9O4_Vq8936.m4a\r\n223.台北-刘红小小分享$http://audio.xmcdn.com/group42/M09/E0/5A/wKgJ81rUTwXi6NoWAfDzmUJ3-5U494.m4a\r\n224.台北-彭健屏小小分享$http://audio.xmcdn.com/group42/M03/E0/61/wKgJ81rUT2yBNbisAXvlP6nsPdg848.m4a\r\n225.台北-日本fc分享安利$http://audio.xmcdn.com/group42/M03/E0/65/wKgJ81rUT3zw7kZeAK-QrFnl96o635.m4a\r\n226.台北-暨老师价值小小分享$http://audio.xmcdn.com/group40/M08/AA/FA/wKgJVFrUT_3AY2_6ARCP57wqleQ605.m4a\r\n227.台北-李金成小小分享$http://audio.xmcdn.com/group41/M08/E3/CA/wKgJ8lrUUJCxBNgsAZdn3hca7FI021.m4a\r\n228.台北-泰国fc$http://audio.xmcdn.com/group40/M06/AA/2C/wKgJT1rUUO-D1AI8AUWQPW1307A631.m4a\r\n229.台湾-彭建屏小小分享$http://audio.xmcdn.com/group41/M09/E3/D4/wKgJ8lrUUTnyiViwAQcgUvgx7Xo913.m4a\r\n230.台湾-钟老师小小分享$http://audio.xmcdn.com/group40/M02/AA/36/wKgJT1rUUWWy-pYOALSc5Ta29PQ137.m4a\r\n231.台湾-陈老师小小分享$http://audio.xmcdn.com/group41/M06/E3/AA/wKgJ8VrUUfLwvLGMAT3yJ27zcbA527.m4a\r\n232.台湾DD会议 陈老师小小分享$http://audio.xmcdn.com/group42/M02/E5/65/wKgJ9FrUUnvRebmOAWl_-QFHgcM478.m4a\r\n233.台湾DD会议小小分享$http://audio.xmcdn.com/group42/M01/E5/77/wKgJ9FrUUzewn1afAf9DVvb0bUs497.m4a\r\n234.小小分享$http://audio.xmcdn.com/group42/M00/E0/BE/wKgJ81rUVCrygUvXApsilyuoTu4399.m4a\r\n2小小分享$http://audio.xmcdn.com/group41/M02/E4/13/wKgJ8lrUVEvjkY76ARRk0mUKwLo932.m4a\r\n236成功不是条件是信念超凡小小分享$http://audio.xmcdn.com/group41/M03/E3/E8/wKgJ8VrUVTvBAgaqAkP_mapx3Yw666.m4a\r\n237.周帆扬 成功四步曲超凡小小分享$http://audio.xmcdn.com/group40/M00/AB/79/wKgJVFrUVdfjZTIVAf_UturiKRY303.m4a\r\n238.品优沙龙 柏桐小小分享$http://audio.xmcdn.com/group40/M00/AA/95/wKgJT1rUVdPRrSZyAKsxumF1R2E024.m4a\r\n239.四个坚持 大连 刘德沛  小小分享$http://audio.xmcdn.com/group41/M0B/E3/F7/wKgJ8VrUVivjKiphAOMXnsxzLsM356.m4a\r\n240.四个坚持 大连 刘德沛小小分享$http://audio.xmcdn.com/group42/M03/E0/EC/wKgJ81rUVnWiKTgmAOMXnrychoI952.m4a\r\n241.四重超凡小小分享$http://audio.xmcdn.com/group42/M09/E5/C4/wKgJ9FrUV4PgpnOkAlsAPHa6QG0879.m4a\r\n242.团队建设（4×4的核心和意义）--郭洪斌FC小小分享$http://audio.xmcdn.com/group40/M03/AB/98/wKgJVFrUV6OTtbngARos_VP-Vhc369.m4a\r\n243.团队赢大家赢 姜红小小分享$http://audio.xmcdn.com/group40/M07/AA/BC/wKgJT1rUWDSxIhx4AXaxYNfkrFc729.m4a\r\n244.圆梦千万家 陈老师1  小小分享$http://audio.xmcdn.com/group40/M08/AB/BE/wKgJVFrUWWqhrcxxAo4u3CyFrCE222.m4a\r\n245.圆梦千万家 陈老师1小小分享$http://audio.xmcdn.com/group40/M02/AB/C5/wKgJVFrUWhngwHS7Ao4u3KXhM-M402.m4a\r\n246.圆梦千万家 陈老师2  小小分享$http://audio.xmcdn.com/group41/M04/E4/7B/wKgJ8lrUWbDBXXWrACUpA7lcGLA358.m4a\r\n247.圆梦千万家 陈老师2小小分享$http://audio.xmcdn.com/group41/M07/E4/41/wKgJ8VrUWePR1UfIAG3jTrSnKbE824.m4a\r\n248.坚实的后盾 安利张明德副总裁小小分享$http://audio.xmcdn.com/group42/M01/E6/04/wKgJ9FrUWtyBD17yAeEhp02p4lw122.m4a\r\n249.基业长青 巅峰共舞 安利付后坚FC小小分享$http://audio.xmcdn.com/group42/M0A/E1/48/wKgJ81rUW2-hJaDIAcAHjtFhizc235.m4a\r\n250.大会总结 韩姐小小分享$http://audio.xmcdn.com/group40/M00/AB/F2/wKgJVFrUXDqCeEeRAijpo64fyzs691.m4a\r\n251.大工-如何简单复制-超凡小小分享$http://audio.xmcdn.com/group40/M00/AB/EC/wKgJVFrUXBnibRvVAGuTUuqqeYw382.m4a\r\n252.大连8月6日 冯广敏小小分享$http://audio.xmcdn.com/group42/M05/E6/2D/wKgJ9FrUXNfB-WqRAYW7n_1KDzQ411.m4a\r\n253.她时代互联网安利轻创业——安利时代老师小小分享$http://audio.xmcdn.com/group40/M02/AB/1F/wKgJT1rUXSLS1emMASHOAv4eq20084.m4a\r\n254.好“孕”来袭—安利时代老师小小分享$http://audio.xmcdn.com/group42/M0B/E6/3F/wKgJ9FrUXerRzOfIAeS1851OyS8782.m4a\r\n255.如何上红宝石 王健小小分享$http://audio.xmcdn.com/group40/M07/AB/3A/wKgJT1rUXpyixonqAfNcV1SrkHo156.m4a\r\n257.如何两年上经理三年上高级经理 — 安利时代老师小小分享$http://audio.xmcdn.com/group41/M08/E4/A7/wKgJ8VrUX2CASmFeAiQTwZav7ps349.m4a\r\n258.如何实现心中承诺 韩姐小小分享$http://audio.xmcdn.com/group41/M0A/E4/B4/wKgJ8VrUYCXCk33zAk4TzTMxu5A727.m4a\r\n259.如何实现心中的承诺 — 时代老师小小分享$http://audio.xmcdn.com/group40/M06/AC/49/wKgJVFrUYK7zmrYtAdl5Sd-qKvs280.m4a\r\n260.如何经营会场 王健小小分享$http://audio.xmcdn.com/group41/M04/E4/D0/wKgJ8VrUYXyyxNyYAixZO8ptmzs988.m4a\r\n261.如何讲好安利益之源净水器小小分享$http://audio.xmcdn.com/group41/M0B/E5/13/wKgJ8lrUYefDUHzGAaMbeextwAU909.m4a\r\n263.姜宏杰同业竞争超凡小小分享$http://audio.xmcdn.com/group40/M00/AC/69/wKgJVFrUYrHzOQEbAh6X7JfYBGI032.m4a\r\n220.千年基业2 韩姐小小分享$http://audio.xmcdn.com/group40/M03/A8/35/wKgJT1rUNuXixxHHAMlpbiNXfMk002.m4a\r\n219.千年基业 韩姐小小分享$http://audio.xmcdn.com/group40/M03/A9/1B/wKgJVFrUNuTyIAn_AfWx_BWnAWQ631.m4a\r\n218.千年基业 韩姐小小分享 (2)$http://audio.xmcdn.com/group41/M02/E1/C8/wKgJ8lrUNlnw--l7Apw2pJN-rGM059.m4a\r\n217.千年基业 韩姐 帆扬小小分享$http://audio.xmcdn.com/group40/M00/A8/18/wKgJT1rUNXGgZDCBAjS5Jr73yOk295.m4a\r\n216.千年基业 陈宏佑小小分享$http://audio.xmcdn.com/group42/M02/DE/54/wKgJ81rUNNPSwMckApsbPdQVqlk628.m4a\r\n215.千年基业 陈宏佑  小小分享$http://audio.xmcdn.com/group42/M03/DE/43/wKgJ81rUM_bhC964ApsbPWWlNDs501.m4a\r\n214.千年基业 郑新清小小分享$http://audio.xmcdn.com/group40/M02/A8/CF/wKgJVFrUMx3yScTkAemyHG43RIM089.m4a\r\n213.北美学习感悟--为为小小分享$http://audio.xmcdn.com/group41/M09/E1/36/wKgJ8VrUMg-g7cmHAGGist35jpA478.m4a\r\n212.助教会议怎么做超凡小小分享$http://audio.xmcdn.com/group42/M09/DE/1D/wKgJ81rUMlGQtBBAAmWMdlXCAQA789.m4a\r\n211.劉德沛FC超凡小小分享$http://audio.xmcdn.com/group40/M05/A7/C2/wKgJT1rUMU7RHjEhASclIspSIZc864.m4a\r\n210.创办人解答超凡小小分享$http://audio.xmcdn.com/group41/M00/E1/5B/wKgJ8lrUMRzyTXvMAjMGgPxtqB8261.m4a\r\n209.创办人群英会 悉尼小小分享$http://audio.xmcdn.com/group41/M0A/E1/4E/wKgJ8lrUMHvAH6aUAi8Sze4jJ7c608.m4a\r\n208.创办人三点 大连 韩姐小小分享$http://audio.xmcdn.com/group42/M08/DD/E1/wKgJ81rUL6Kg7YCpAhVtliEbKjA422.m4a\r\n207.创办人三点 大连 韩姐  小小分享$http://audio.xmcdn.com/group42/M09/DD/D2/wKgJ81rULu3yQj2pAhVtYFG9bfM725.m4a\r\n206.创业的正确观念和态度安利时代老师小小分享$http://audio.xmcdn.com/group40/M02/A8/60/wKgJVFrULkHyASFxAh5HK1OHK40591.m4a\r\n205.创业冬天里的一把火 韩石小小分享$http://audio.xmcdn.com/group40/M06/A7/73/wKgJT1rULZPhgvhTAoGiItAAXxE116.m4a\r\n204.创业冬天里的一把火 韩石  小小分享$http://audio.xmcdn.com/group40/M02/A8/3F/wKgJVFrULKWzC4_eAoGh7Ci_14I637.m4a\r\n203.刘红钻石领导人培训小小分享$http://audio.xmcdn.com/group40/M09/A8/2E/wKgJVFrUK67yHE-QAawxeHo96Jc923.m4a\r\n202.刘红老师青州小小分享$http://audio.xmcdn.com/group40/M08/A8/1A/wKgJVFrUKuiDzafVAJhue8VCtr0080.m4a\r\n201.刘红老师机场超凡小小分享$http://audio.xmcdn.com/group40/M06/A8/18/wKgJVFrUKsazRTm8APVlZLGiBj4925.m4a\r\n200.刘红老师小小分享$http://audio.xmcdn.com/group42/M01/DD/72/wKgJ81rUKlLT04g1ALM5iQz82YQ800.m4a\r\n199.刘红晚上总结小小分享$http://audio.xmcdn.com/group42/M04/E2/34/wKgJ9FrUKlWDEgVFAhgN6PSCyZQ422.m4a\r\n198.刘红四个到位超凡小小分享，$http://audio.xmcdn.com/group41/M04/E0/79/wKgJ8VrUKWWQndWQATPm7UoxV3U633.m4a\r\n197.刘红会后会青岛小小分享$http://audio.xmcdn.com/group40/M07/A7/F9/wKgJVFrUKP2BLIEsAUPapABzSFY841.m4a\r\n196.刘红人生舞台时刻精彩超凡小小分享$http://audio.xmcdn.com/group41/M00/E0/70/wKgJ8VrUKLGTighMAeG6XVzMA0s259.m4a\r\n195.刘红-青岛晚小小分享$http://audio.xmcdn.com/group42/M05/E1/FF/wKgJ9FrUJ6iB50xQACXdbJN-jRY018.m4a\r\n194.刘红-目标小小分享$http://audio.xmcdn.com/group42/M03/E2/00/wKgJ9FrUJ_mwifNJAhGLPrChppE606.m4a\r\n193.刘珺 天下第一餐超凡小小分享$http://audio.xmcdn.com/group41/M06/E0/54/wKgJ8VrUJxKS6p06ATPuQ33pQtM941.m4a\r\n192.刘房间，$http://audio.xmcdn.com/group41/M02/E0/7D/wKgJ8lrUJoPTPpceAGcG11Vq3G0732.m4a\r\n191.刘德沛成就自己打造超凡小小分享$http://audio.xmcdn.com/group41/M02/E0/7E/wKgJ8lrUJoeDSZUgATneGY0PdZs350.m4a\r\n190.刘国芳蓝图规划小小分享$http://audio.xmcdn.com/group42/M05/DD/1C/wKgJ81rUJf3TOmFJAJpKP1mgv9c216.m4a\r\n189.刘华玲《0～18孩子心理营养小小分享》$http://audio.xmcdn.com/group42/M00/E1/D8/wKgJ9FrUJb7B6OEcAGKwtxZVaAk881.m4a\r\n188.刘华玲《0～18孩子心理营养》小小分享$http://audio.xmcdn.com/group42/M0A/E1/E1/wKgJ9FrUJgTxXpIYApuGpPrOE74020.m4a\r\n187.刘传仁-青岛小小分享$http://audio.xmcdn.com/group41/M0B/E0/5E/wKgJ8lrUJL3g00KUADg81Ktr3jE048.m4a\r\n186.凝聚 团结 张卫东小小分享$http://audio.xmcdn.com/group41/M0B/E0/27/wKgJ8VrUJOvwjd4WAYCa1Vx0Jxw990.m4a\r\n185.决战A60的具体工作 韩姐小小分享$http://audio.xmcdn.com/group42/M03/E1/C0/wKgJ9FrUJFGy4uy8AQdODImmKRE637.m4a\r\n184.冯老师-如果小小分享$http://audio.xmcdn.com/group42/M03/E1/BD/wKgJ9FrUJECD-tFTAnpvC7otGxM107.m4a\r\n183.冯广敏老师三个如果(2）超凡小小分享$http://audio.xmcdn.com/group41/M02/E0/04/wKgJ8VrUIwvhSILsAJKZFFs638g811.m4a\r\n182.冯广敏 选择决定命运超凡小小分享$http://audio.xmcdn.com/group41/M02/E0/42/wKgJ8lrUIxTCp-4rAdLpZzk4FKI715.m4a\r\n181.冯广敏 仕途商途旅途超凡小小分享$http://audio.xmcdn.com/group42/M00/E1/9C/wKgJ9FrUIm2RTTTGAXgZJjTxQg4033.m4a\r\n180.冀飙小小分享$http://audio.xmcdn.com/group40/M06/A6/91/wKgJT1rUIi2xu8MfAptKOg1xFcg177.m4a\r\n179.公司业务新政超凡小小分享$http://audio.xmcdn.com/group42/M05/DC/BF/wKgJ81rUIPCBp2PcAOm2M7uN5mQ228.m4a\r\n178.健康快乐营 韩姐小小分享$http://audio.xmcdn.com/group40/M05/A6/74/wKgJT1rUIJejZBacAWkL9275pJk291.m4a\r\n177.做直销的领导超凡小小分享$http://audio.xmcdn.com/group41/M09/E0/16/wKgJ8lrUIGKS2na5Apw_dVxM4rA137.m4a\r\n176.做我自己生命的主宰_安利陈克明FC小小分享$http://audio.xmcdn.com/group42/M09/DC/9F/wKgJ81rUHzXyJdzqAPD5OkniBlw787.m4a\r\n175.信念的力量 — 安利时代老师小小分享$http://audio.xmcdn.com/group42/M09/DC/9E/wKgJ81rUHzCiJafWAnNCq8IyF14614.m4a\r\n174.信念是促使成功的最大力量（安利林薇博士）小小分享$http://audio.xmcdn.com/group41/M09/DF/B0/wKgJ8VrUHiCAKx73AVuXBzHM8uU431.m4a\r\n173.信念创造价值-安利周学伟小小分享$http://audio.xmcdn.com/group40/M04/A6/45/wKgJT1rUHcyBioARAfmlvYupBOI663.m4a\r\n171.你必须是领导人1 冯广敏小小分享$http://audio.xmcdn.com/group41/M0B/DF/DF/wKgJ8lrUHTzjH_PbApU0OCr15K0466.m4a\r\n170.你必须是领导人1 冯广敏  小小分享$http://audio.xmcdn.com/group40/M02/9E/17/wKgJT1rTbcaynJO-ApU0OLl7VR0137.m4a\r\n169.你必需是领导人 2 冯广敏小小分享$http://audio.xmcdn.com/group40/M0B/9E/DB/wKgJVFrTbRXCe7tpAIkt6Ul_M4M471.m4a\r\n168.余博士谈安利《城市华庭2405》小小分享$http://audio.xmcdn.com/group40/M0B/9E/D7/wKgJVFrTbQuTtq0qALuuNwbUig4375.m4a\r\n167.余代辅经理培训小小分享$http://audio.xmcdn.com/group40/M0B/9E/E0/wKgJVFrTbSWw2Jx3AcqYYisyxl8025.m4a\r\n166.余代辅演讲济南年会小小分享$http://audio.xmcdn.com/group40/M0B/9E/07/wKgJT1rTbR7h1JglApwyPgV0BXk153.m4a\r\n165.何志国《五色健康》小小分享$http://audio.xmcdn.com/group40/M03/9D/F6/wKgJT1rTbKGAHZxgAZeeRkCNerM853.m4a\r\n164.何养中教授《行动—产品篇护肝片的重要性》$http://audio.xmcdn.com/group42/M02/D4/18/wKgJ81rTbD3QLXv2AMwdVPt8ks0146.m4a\r\n163.会长班总结 韩姐小小分享$http://audio.xmcdn.com/group42/M02/D4/13/wKgJ81rTbDCi_dPGAQb9FVR0Oic220.m4a\r\n162.会议会场 冯广敏小小分享$http://audio.xmcdn.com/group42/M02/D4/16/wKgJ81rTbDfg3wBiAfTRUbZl8Os220.m4a\r\n161.会场经营 稽老师小小分享$http://audio.xmcdn.com/group41/M00/D7/78/wKgJ8lrTa4_heKW6AQI0agpL0wE192.m4a\r\n160.会场经营 稽老师  小小分享$http://audio.xmcdn.com/group40/M00/9E/A7/wKgJVFrTazOgt-oyAQI0alT-AFc872.m4a\r\n159.会场的运作和直销的制度-稽老师超凡小小分享$http://audio.xmcdn.com/group41/M03/D7/34/wKgJ8VrTawigjf3VAX2FBYlfzLU778.m4a\r\n158.会后会时代老师分享安利新商机的核心3$http://audio.xmcdn.com/group41/M09/D7/62/wKgJ8lrTaqnzRlxmAK8Te4nSGao988.m4a\r\n156.会后会时代老师分享安利新商机的核心1$http://audio.xmcdn.com/group42/M00/D3/E8/wKgJ81rTan-T1HV0AK_j1MbIE2Q435.m4a\r\n155.会后会 韩姐小小分享$http://audio.xmcdn.com/group42/M09/D3/DF/wKgJ81rTajngymhwAJeZjLVKas0801.m4a\r\n154.会后会 韩姐  小小分享$http://audio.xmcdn.com/group40/M01/9D/B1/wKgJT1rTagDBEjOOAJeZjJIc_Kg489.m4a\r\n153.优生优育-安利宝贝计划-贝春娇$http://audio.xmcdn.com/group42/M09/D8/B6/wKgJ9FrTaiii4zS9AlHhNkaBN6o265.m4a\r\n152.任英才小小分享$http://audio.xmcdn.com/group42/M0B/D3/BD/wKgJ81rTaQyju3MoAERFmAfmh3I075.m4a\r\n151.价值远景 王成安小小分享$http://audio.xmcdn.com/group41/M05/D7/05/wKgJ8VrTaXjjXESzAqSz7ZR5Eqo992.m4a\r\n150.价值远景 王成安  小小分享$http://audio.xmcdn.com/group42/M04/D3/B8/wKgJ81rTaNOw8z9VAqSz7Qqx9M0948.m4a\r\n149.价值远景 嵇老师小小分享$http://audio.xmcdn.com/group40/M09/9D/70/wKgJT1rTZ4aCPsEBAYy-QuUKRkI237.m4a\r\n148.价值远景 孙德兵小小分享$http://audio.xmcdn.com/group41/M05/D6/F4/wKgJ8lrTZxbDffkMAjv2T3RZVG0371.m4a\r\n147.代洪荣会场小小分享$http://audio.xmcdn.com/group40/M03/9D/3E/wKgJT1rTZhWB-7GkANkvoIHlx5s663.m4a\r\n146.代洪荣临沂小小分享$http://audio.xmcdn.com/group41/M02/D6/9C/wKgJ8VrTZcKAugcYARIvdyuo-VI173.m4a\r\n145.付后坚FC 为什么做安利 OPP的五大要点小小分享$http://audio.xmcdn.com/group42/M00/D3/56/wKgJ81rTZY7yV7h4AoObRTir4Pc856.m4a\r\n144.付出与收获_安利吴彩云付南生FC 小小分享$http://audio.xmcdn.com/group41/M06/D6/74/wKgJ8VrTZJbgbwUzAgUgE5rw6Ds149.m4a\r\n143.人生规划-安利钱俊 小小分享$http://audio.xmcdn.com/group41/M08/D6/5A/wKgJ8VrTY9rA67lQAbglrouV59M670.m4a\r\n142.人生的四个重要决定（安利陈华FC）小小分享$http://audio.xmcdn.com/group42/M0A/D3/11/wKgJ81rTY1SyZoR-AaO7ib3w9m4543.m4a\r\n141.人生定位 安利蒋玉萍小小分享$http://audio.xmcdn.com/group40/M01/9C/CA/wKgJT1rTYszi4AVNAkL4vw-Q0pE642.m4a\r\n140.人生如何赢在转折点 冯广敏小小分享$http://audio.xmcdn.com/group41/M04/D6/50/wKgJ8lrTYgDy_jzzAhodFJmIl0I949.m4a\r\n139.人生三个如果 冯广敏小小分享$http://audio.xmcdn.com/group40/M07/9D/62/wKgJVFrTYPixSpFaAS-kBjSAOlY085.m4a\r\n138.五比四勇 冯广敏小小分享$http://audio.xmcdn.com/group41/M0B/D6/20/wKgJ8lrTYMeCvFifAfZPHHR192k129.m4a\r\n137.五度一力左右手 陈宏佑小小分享$http://audio.xmcdn.com/group40/M00/9C/83/wKgJT1rTYLXBxXJFAjF6BkFkt2Q713.m4a\r\n136.五度一力左右手 陈宏佑  小小分享$http://audio.xmcdn.com/group40/M0A/9C/6D/wKgJT1rTYCmRsKm3AjF6BnADllo612.m4a\r\n135.五度一力 郑新清小小分享$http://audio.xmcdn.com/group41/M00/D5/CC/wKgJ8lrTXqbjHQciAd8kGh5XKLM872.m4a\r\n134.五度一力 郑新清  小小分享$http://audio.xmcdn.com/group40/M04/9C/0F/wKgJT1rTXiDwoKtcAd8kGmOgF7c130.m4a\r\n133.五个好五个一 冯广敏小小分享$http://audio.xmcdn.com/group41/M09/D5/7B/wKgJ8VrTXdXwCvSVAoxe1HJcYfM451.m4a\r\n132.互联网安利轻创业之男神专场安利时代老师小小分享$http://audio.xmcdn.com/group42/M03/D2/35/wKgJ81rTXXLjfi_CAjc5ZGtm3tc820.m4a\r\n131.互联网安利新概念：未来已经来临，只是尚未流行安利时代老师小小分享$http://audio.xmcdn.com/group40/M08/9C/B2/wKgJVFrTXLbS1oPJAVETZDFNhFQ114.m4a\r\n130.互联网安利18个月破千万的打法—安利时代老师小小分享$http://audio.xmcdn.com/group42/M09/D2/07/wKgJ81rTXGfx2h8_AirAHLwgsUo291.m4a\r\n129.互联网加安利-超凡小小分享$http://audio.xmcdn.com/group42/M07/D6/C2/wKgJ9FrTW3-DC9DEAl01XfSakU8006.m4a\r\n128.互联网与社群经济 徐文琰小小分享$http://audio.xmcdn.com/group40/M05/9B/62/wKgJT1rTWiPTPKT_AKALFcwWZs4111.m4a\r\n127.互联网 安利轻创业群英会小小分享$http://audio.xmcdn.com/group41/M05/D4/EE/wKgJ8VrTWkfjN2gcAeJfscUUa98114.m4a\r\n126.互联网 失落的人才—安利时代老师小小分享$http://audio.xmcdn.com/group40/M06/9C/20/wKgJVFrTWZfzwguoAiB_dQDRWUE454.m4a\r\n125.二代人的事业 韩石小小分享$http://audio.xmcdn.com/group41/M09/D4/A8/wKgJ8VrTWJiiIAMFAMiyZ8Fg6pQ313.m4a\r\n124.事在人为_安利袁为群FC 小小分享$http://audio.xmcdn.com/group41/M09/D4/AB/wKgJ8VrTWJ6AGftdAbNSuhdGFiI838.m4a\r\n123.乐纤健康手环小小分享$http://audio.xmcdn.com/group41/M07/D4/BD/wKgJ8lrTV9qA9qxQABjbAtMgZoY837.m4a\r\n小小分享$http://audio.xmcdn.com/group41/M02/D4/88/wKgJ8VrTV9mzG_ckADI1tFnxxJc346.m4a\r\n 小小分享$http://audio.xmcdn.com/group42/M06/D6/2B/wKgJ9FrTV8Gz6kNBADI1foU0WX4374.m4a\r\n小小分享优雅老师分享安利制度_4$http://audio.xmcdn.com/group40/M0A/9C/7E/wKgJT1rTYHvj_BL-AGEmlHpFwyI350.m4a\r\n小小分享优雅老师分享安利制度_3$http://audio.xmcdn.com/group40/M05/9D/30/wKgJVFrTX-nz0bHCAGxvlg0gyAE665.m4a\r\n小小分享优雅老师分享安利制度_2$http://audio.xmcdn.com/group42/M00/D2/8B/wKgJ81rTX7qi5t7uAGxwyxmtbMY012.m4a\r\n小小分享优雅老师分享安利制度_1$http://audio.xmcdn.com/group40/M01/9D/2B/wKgJVFrTX4jRlHWXAGxvljKqfdY989.m4a\r\n小小分享小小分享轻松做家务，安利清洁三剑客$http://audio.xmcdn.com/group40/M01/9D/27/wKgJVFrTX3-yfVvVAMUHjYM4x-c604.m4a\r\n小小分享工程师借助平台成功$http://audio.xmcdn.com/group42/M06/D7/55/wKgJ9FrTXyXhxtOlAERnYUUwMV8147.m4a\r\n小小分享宝姥姥创业实现梦想$http://audio.xmcdn.com/group40/M02/9D/10/wKgJVFrTXwjTzCYUAEwdLT4fhlo783.m4a\r\n076.4050后互联网安利轻创业时代老师小小分享$http://audio.xmcdn.com/group41/M05/D0/C8/wKgJ8lrTQc_z8zhiAa3A4bBxDqU500.m4a\r\n077.IT人士互联网安利轻创业小小分享$http://audio.xmcdn.com/group40/M07/98/0F/wKgJVFrTQr2y-cb4AnIE2RtCJLI887.m4a\r\n078.NDO 任英才 价值远景超凡小小分享$http://audio.xmcdn.com/group41/M04/D0/CA/wKgJ8VrTQy7C2JB5AaTlujZrI6E430.m4a\r\n079.NDO 王健 开发陌生市场超凡小小分享$http://audio.xmcdn.com/group42/M01/D2/89/wKgJ9FrTQ4rwBqAoASZOvMaG7i0363.m4a\r\n080.NDO 陈泓佑 心态超凡小小分享$http://audio.xmcdn.com/group41/M07/D1/3A/wKgJ8lrTRKWQ99qwAiKEV06LH1k735.m4a\r\n081.XS助力计划 安利中国市场部总监小小分享$http://audio.xmcdn.com/group40/M06/98/5C/wKgJVFrTRJCDPnb0ALzCEjvv0QY063.m4a\r\n082.“双枪老太婆”刘殊含经理《安利事业所要具备的心态》小小分享$http://audio.xmcdn.com/group40/M01/97/A6/wKgJT1rTRYTShwvzAhWd1VCnUac872.m4a\r\n083.《美容专业班定位》小小分享$http://audio.xmcdn.com/group40/M01/97/A5/wKgJT1rTRYHTWGUrAO0qMY2ZNGo558.m4a\r\n084.《解码财商》— 安利时代老师小小分享$http://audio.xmcdn.com/group40/M00/97/CC/wKgJT1rTRjjxpvO7AdXGi8JRIMA813.m4a\r\n085.《贵族养生自然疗法》—安利时代老师小小分享$http://audio.xmcdn.com/group41/M09/D1/8E/wKgJ8lrTRo_zlqZ9AbKPbj4EJmg005.m4a\r\n086.【石法武博士】：咖啡灌肠小小分享 (2)$http://audio.xmcdn.com/group40/M01/98/10/wKgJT1rTR9mB3pmOA0J_GbhIbio498.m4a\r\n087.【石法武博士】：咖啡灌肠小小分享 (3)$http://audio.xmcdn.com/group40/M0B/99/1A/wKgJVFrTSLTg9inmA0J_T-WwKio223.m4a\r\n088.【石法武博士】：咖啡灌肠小小分享$http://audio.xmcdn.com/group40/M02/98/6D/wKgJT1rTSbmzU273A0J_TwI9paE045.m4a\r\n089.【石法武博士】：葛森疗法小小分享$http://audio.xmcdn.com/group41/M05/D2/35/wKgJ8VrTS0bDkcHzBF0Z8G7QhJE594.m4a\r\n090.一个成功商人为什么选择安利-朱文群（高级经理）小小分享$http://audio.xmcdn.com/group41/M0B/D2/50/wKgJ8lrTSvajNyflASEDYLSrEPo457.m4a\r\n091.一个选择决定一生（安利胡天鹏FC）小小分享$http://audio.xmcdn.com/group41/M0A/D2/3E/wKgJ8VrTS3-yx1HhAS6l1W6poAA001.m4a\r\n092.一生做对一件事 尹承启（安利高级经理）小小分享$http://audio.xmcdn.com/group41/M04/D2/94/wKgJ8lrTTDTjbJf5AWPj27QIFHY321.m4a\r\n093.一生做对一件事小小分享$http://audio.xmcdn.com/group41/M00/D2/84/wKgJ8VrTTOHASEYtAV3aV6uPgP4805.m4a\r\n094.三个价值 韩姐  小小分享$http://audio.xmcdn.com/group42/M06/D4/42/wKgJ9FrTTPuy3gFwAOUbCcqpmWo422.m4a\r\n095.三个价值 韩姐小小分享$http://audio.xmcdn.com/group42/M00/D4/49/wKgJ9FrTTVKgrAGNAOUbCW1kTMQ458.m4a\r\n096.三信  姜红小小分享$http://audio.xmcdn.com/group41/M06/D2/F3/wKgJ8lrTTk2AoGuDAjTcZhTCCLM833.m4a\r\n097.三信 济南 姜红  小小分享$http://audio.xmcdn.com/group42/M0B/D4/76/wKgJ9FrTTiLCmU6nAIT1NI-nSL0201.m4a\r\n098.三信 济南 姜红小小分享$http://audio.xmcdn.com/group42/M0A/CF/CB/wKgJ81rTTzLTR62tAjTcnMOloOI807.m4a\r\n099.三信 郑新清小小分享$http://audio.xmcdn.com/group40/M02/99/92/wKgJT1rTUBSCZSi2AkGfqDasxEI059.m4a\r\n100.三宝讲座，朱峰超凡小小分享$http://audio.xmcdn.com/group42/M06/D0/26/wKgJ81rTUXegMlsaAm29Y1jx-9I044.m4a\r\n101.三张表一件事 魔术师小小分享$http://audio.xmcdn.com/group41/M07/D3/76/wKgJ8VrTUe-TsnkCAVRPlZuE4Jo096.m4a\r\n102.三张表一件事小小分享$http://audio.xmcdn.com/group40/M04/9A/D6/wKgJVFrTUjywxA6FAVRPlU6zKwo425.m4a\r\n103.三张表一件事（徐州） 魔术师小小分享$http://audio.xmcdn.com/group41/M02/D3/D0/wKgJ8lrTUsSiRE9CAVRPleYd7kU850.m4a\r\n104.三张表一件事（悉尼） 张庆余小小分享$http://audio.xmcdn.com/group41/M09/D3/E0/wKgJ8lrTUvPyVLZSAKlZF5_ahKw623.m4a\r\n105.上海-andy小小分享$http://audio.xmcdn.com/group42/M08/D0/85/wKgJ81rTU46hcm70AVtdwhOkRsM277.m4a\r\n106.上海-凡杨小小分享$http://audio.xmcdn.com/group42/M01/D0/94/wKgJ81rTVBzR92dEAd10Y9EYUlk117.m4a\r\n107.上海-钟舅舅小小分享$http://audio.xmcdn.com/group42/M05/D0/AE/wKgJ81rTVHuBMKawAgy7bxUBv90072.m4a\r\n108.上海-陈老师小小分享$http://audio.xmcdn.com/group42/M04/D5/9E/wKgJ9FrTVN7zqGknAnSoU_2-0IU424.m4a\r\n109.上海-韩世荣-跟随小小分享$http://audio.xmcdn.com/group42/M04/D5/AA/wKgJ9FrTVPSTZLVCAbYjuhtQjro943.m4a\r\n110.上海总结 陈老师小小分享$http://audio.xmcdn.com/group40/M01/9A/80/wKgJT1rTVT2ytBWrAdgjWJjtPWg603.m4a\r\n111.上海晚上会议 晚会  小小分享$http://audio.xmcdn.com/group42/M05/D5/C8/wKgJ9FrTVauAD5uoAkKZSzsKWVc904.m4a\r\n112.上海晚上会议 晚会小小分享$http://audio.xmcdn.com/group40/M00/9A/A7/wKgJT1rTVfTA26zBAkKZS34WObk732.m4a\r\n113.上海誓师大会1小小分享$http://audio.xmcdn.com/group42/M0B/D5/DC/wKgJ9FrTVjmhQsvDAhTcAIeva40712.m4a\r\n114.上海誓师大会2高级经理小小分享$http://audio.xmcdn.com/group41/M03/D4/50/wKgJ8VrTVoWjfTAXAhAsSde4TG0963.m4a\r\n115.上海钻石会议超凡小小分享$http://audio.xmcdn.com/group40/M07/9B/9E/wKgJVFrTVpiS74vuAavX5TLYRHQ874.m4a\r\n116.不要让别人偷走你的梦想_李恩全FC小小分享$http://audio.xmcdn.com/group41/M0B/D4/52/wKgJ8VrTVrqCpMDWAW4-YEvR6mg109.m4a\r\n117.丢失的智慧—安利时代老师小小分享$http://audio.xmcdn.com/group40/M09/9A/ED/wKgJT1rTV1XCIRMUAoh-La271lQ292.m4a\r\n118.两机 两观 韩姐小小分享$http://audio.xmcdn.com/group41/M01/D4/67/wKgJ8VrTVvXAjT9iAIG3ep7BabU548.m4a\r\n119.个个成长2 王成安小小分享$http://audio.xmcdn.com/group40/M09/9B/B4/wKgJVFrTVzODAJ92AP9cEacljdc332.m4a\r\n120.个人成长1 王成安小小分享$http://audio.xmcdn.com/group40/M0B/9B/CD/wKgJVFrTV_HQePfvAoCs5oIESNc954.m4a\r\n075.4050后互联网安利小小分享$http://audio.xmcdn.com/group41/M03/D0/68/wKgJ8VrTQHjzv-B1AV2PySYPfE4561.m4a\r\n074.2016元旦寄语 韩姐小小分享$http://audio.xmcdn.com/group41/M03/D0/58/wKgJ8VrTQEPSCuVJAXFnewcQT_o508.m4a\r\n073.2016元旦寄语 韩姐  小小分享$http://audio.xmcdn.com/group40/M01/96/C3/wKgJT1rTQADjI70YAXFne-7fy3g173.m4a\r\n072.90后互联网安利轻创业小小分享$http://audio.xmcdn.com/group40/M00/97/97/wKgJVFrTP-iTWn_FAjQEiae57-U803.m4a\r\n071.80后互联网安利轻创业小小分享$http://audio.xmcdn.com/group42/M0A/D1/EB/wKgJ9FrTP5aTK95iAyGJew8Srgw896.m4a\r\n070.70后互联网 安利轻创业 — 安利时代老师小小分享$http://audio.xmcdn.com/group41/M09/D0/3C/wKgJ8lrTPnixCG3qATJ6wC77sO8656.m4a\r\n069.60后互联网 安利小小分享$http://audio.xmcdn.com/group41/M09/D0/1B/wKgJ8VrTPpayVX5AApqoEiHI5mY873.m4a\r\n067.030.陈老师悉尼$http://audio.xmcdn.com/group41/M00/D0/29/wKgJ8lrTPbuAwR4UAeOjXfpzFH4227.m4a\r\n066.30分钟OPP.艺文小小分享$http://audio.xmcdn.com/group42/M09/D1/7E/wKgJ9FrTPMXxktDcAQIBw-3O7iI753.m4a\r\n065.029.王付刚$http://audio.xmcdn.com/group40/M05/96/35/wKgJT1rTPCuhKl9XAIlixAjMYIc614.m4a\r\n064.028.新年寄语（年初一）韩姐$http://audio.xmcdn.com/group40/M05/96/36/wKgJT1rTPC7B7DnuAYzwCNt6eeI238.m4a\r\n063.026.销售2 王成安$http://audio.xmcdn.com/group42/M02/D1/4E/wKgJ9FrTO1Hxo5LIAENJB_n3ioY114.m4a\r\n062.025.销售1 王成安$http://audio.xmcdn.com/group41/M05/CF/E1/wKgJ8lrTO_-zS3geApsW12nXARY835.m4a\r\n061.024.营养素与疾病 2017韩旭明$http://audio.xmcdn.com/group41/M03/CF/88/wKgJ8VrTOp-SgR7QAnrpFbO8vBw005.m4a\r\n060.023.销售 艺文$http://audio.xmcdn.com/group40/M01/96/AF/wKgJVFrTOcOwJZFIApsodZjWVlo879.m4a\r\n059.022.会后会 韩姐$http://audio.xmcdn.com/group42/M08/CB/FD/wKgJ81rTOBDwCEKgAJeZjBVH2UQ261.m4a\r\n058.021.潍坊会后会 韩姐$http://audio.xmcdn.com/group41/M00/CF/3B/wKgJ8VrTOEuRu9tWAps6E89Y5t4049.m4a\r\n057.020.三信 济南 姜红$http://audio.xmcdn.com/group42/M04/D0/B9/wKgJ9FrTNuuxMgA2AjTcZgJadvY303.m4a\r\n056.019.三个价值 韩姐$http://audio.xmcdn.com/group42/M09/CB/AE/wKgJ81rTNaTi45tNAOUbCTbQLxE120.m4a\r\n055.018.韩姐总结$http://audio.xmcdn.com/group41/M0A/CE/E6/wKgJ8VrTNWmBhS2KAbZUaOLzqNA643.m4a\r\n054.017.韩姐总结 济南$http://audio.xmcdn.com/group42/M00/D0/6C/wKgJ9FrTNLzSvUIXAa6M_ggMNkk890.m4a\r\n053.016.会场经营 稽老师$http://audio.xmcdn.com/group40/M04/95/FC/wKgJVFrTM_mx4Z79AQI0amUNp8I758.m4a\r\n052.016.成功模型 王成安$http://audio.xmcdn.com/group40/M02/95/E0/wKgJVFrTM53xND_2ANtErf2Pf-Q815.m4a\r\n051.015.五度一力 郑新清$http://audio.xmcdn.com/group41/M04/CE/AD/wKgJ8VrTM4iiYEjrAd8kGm-K5c0360.m4a\r\n050.015.安利四期 韩姐$http://audio.xmcdn.com/group41/M03/AF/34/wKgJ8VrRuJfQFi4MAMwu5UvHTwg731.m4a\r\n049.014.经理会议总结 韩姐$http://audio.xmcdn.com/group41/M03/AF/42/wKgJ8lrRuHmDDve3AYJglEBK9S0635.m4a\r\n048.014.上海晚上会议 晚会$http://audio.xmcdn.com/group41/M0B/AF/39/wKgJ8lrRuB-BwW97AkKZS4xmSrw214.m4a\r\n047.013.陈老师上海1$http://audio.xmcdn.com/group40/M07/76/3D/wKgJVFrRt3rDY8fNApwQeUYJLJQ082.m4a\r\n046.013.千年基业 陈宏佑$http://audio.xmcdn.com/group41/M00/AF/19/wKgJ8lrRtp2i4LsqApsbPVt0fSI318.m4a\r\n045.012.蓝水商道 李胜利$http://audio.xmcdn.com/group41/M02/AF/13/wKgJ8lrRtjLxebFkBJDM73dA-a4993.m4a\r\n044.012.陈宏佑$http://audio.xmcdn.com/group42/M08/B0/65/wKgJ9FrRs4fTunWDABz08_LkGb8027.m4a\r\n043.011.成功密码 韩姐$http://audio.xmcdn.com/group41/M01/AE/C4/wKgJ8VrRs6GwNceDAOlhPWbhnUc612.m4a\r\n042.011.创业冬天里的一把火 韩石$http://audio.xmcdn.com/group41/M01/AE/C4/wKgJ8VrRs6GD9gx5AoGh7A93myM383.m4a\r\n041.010.想法好 赵鸿凤$http://audio.xmcdn.com/group42/M09/AB/6D/wKgJ81rRsvOSUf3xAZupcfz0YPw957.m4a\r\n040.010.开发区总结 韩姐$http://audio.xmcdn.com/group42/M07/AB/5D/wKgJ81rRslHTrBR7Ai1mIn1vO2Q001.m4a\r\n039.009.跟随才能精髓 陈宏佑$http://audio.xmcdn.com/group41/M09/AE/97/wKgJ8VrRsYeDm2NlAiW2ROVncnU885.m4a\r\n038.009.新年贺词 韩姐$http://audio.xmcdn.com/group42/M05/B0/1F/wKgJ9FrRsGfC2jyFARsE2pa-5fQ295.m4a\r\n037.008.总结开发区 韩姐$http://audio.xmcdn.com/group42/M09/B0/19/wKgJ9FrRsALBWQ-8ARPw0KJUkLY962.m4a\r\n036.008.2016元旦寄语 韩姐$http://audio.xmcdn.com/group41/M09/AE/74/wKgJ8VrRr7TTtvr8AXFne-pH9hE792.m4a\r\n035.007.开悟的会后会 韩姐$http://audio.xmcdn.com/group41/M01/AE/82/wKgJ8lrRr2fAAkmYAk8b8kGn6So699.m4a\r\n034.007.为为姐谈学习$http://audio.xmcdn.com/group41/M07/AE/6B/wKgJ8lrRri3zX5ybADI1fltJC5k196.m4a\r\n033.006.五度一力左右手 陈宏佑$http://audio.xmcdn.com/group42/M0A/AB/08/wKgJ81rRrnXQ3gvKAjF6BnFNFLM328.m4a\r\n032.006.成功的要素 稽老师$http://audio.xmcdn.com/group40/M03/74/8E/wKgJT1rRrWnBRyOkAToNFk_h2mA712.m4a\r\n031.005.开发区韩姐$http://audio.xmcdn.com/group42/M05/AA/EC/wKgJ81rRrRTRe4ZbAptwaRYcE-k068.m4a\r\n029.004.圆梦千万家 陈老师2$http://audio.xmcdn.com/group42/M09/AA/CC/wKgJ81rRq6XDAZCQAG3jGLkqb90108.m4a\r\n028.004.创办人三点 大连 韩姐$http://audio.xmcdn.com/group41/M05/AE/3A/wKgJ8lrRq9Di0VrkAhVtYF9sYdY402.m4a\r\n027.003.圆梦千万家 陈老师1$http://audio.xmcdn.com/group41/M01/AE/18/wKgJ8VrRq0OwKhgwAo4u3I_mq-M440.m4a\r\n026.003.价值远景 王成安$http://audio.xmcdn.com/group40/M02/75/18/wKgJVFrRqirQeYpDAqSz7TYVnZM402.m4a\r\n025.002.你必须是领导人1 冯广敏$http://audio.xmcdn.com/group41/M09/AE/0D/wKgJ8lrRqVqC_TfyApU0OFANPuw427.m4a\r\n024.002.带人学习之后的落实 为为$http://audio.xmcdn.com/group40/M08/74/1F/wKgJT1rRp-_SrMjAAaz9lVK-v00356.m4a\r\n023.001.你必需是领导人 2 冯广敏$http://audio.xmcdn.com/group40/M03/74/09/wKgJT1rRpubxBTlLAIkt6aT4a4Y618.m4a\r\n022.001.成功三力2 王成安$http://audio.xmcdn.com/group42/M08/AA/6B/wKgJ81rRpvnyRDT6ApNG1YE-ZwI156.m4a\r\n021..陈老师悉尼小小分享$http://audio.xmcdn.com/group41/M09/AD/9C/wKgJ8VrRpdvAyTvzAeOjXZp_bt0108.m4a\r\n020..陈老师上海1小小分享$http://audio.xmcdn.com/group40/M06/74/B4/wKgJVFrRpUyClpxQApwQeSyNubk776.m4a\r\n019..陈老师上海1  小小分享$http://audio.xmcdn.com/group41/M03/AD/98/wKgJ8lrRpHWBeQgqApwQeUXhNKc996.m4a\r\n018..陈宏佑  小小分享$http://audio.xmcdn.com/group42/M07/AA/19/wKgJ81rRoxOiqvDcABz084zg5SI679.m4a\r\n017..销售2 王成安小小分享$http://audio.xmcdn.com/group42/M07/AA/18/wKgJ81rRoxKB0PQPAENJB-fwb_M585.m4a\r\n016..销售 艺文小小分享$http://audio.xmcdn.com/group40/M0A/74/8A/wKgJVFrRo1uQsHgQAb1ptR9oCDQ854.m4a\r\n015..王付刚小小分享$http://audio.xmcdn.com/group40/M03/74/73/wKgJVFrRom-TmTmaAIlixCVDROk047.m4a\r\n014..来自亚达城的寄语—在行动中让机遇叩响你的大门$http://audio.xmcdn.com/group42/M00/AE/F5/wKgJ9FrRoiyRB1yTAB7m0M0A4iw053.m4a\r\n013..新年贺词 韩姐小小分享$http://audio.xmcdn.com/group41/M0B/AD/6B/wKgJ8lrRoleCYTiSARsE2j3Kajs196.m4a\r\n012..成功的要素 稽老师小小分享$http://audio.xmcdn.com/group40/M05/73/9F/wKgJT1rRofeAc5pIAToNFgf3QOk005.m4a\r\n011..成功三力1 王成安小小分享$http://audio.xmcdn.com/group40/M05/74/64/wKgJVFrRoeXjeIpBApD7diHL26k743.m4a\r\n010..总结开发区 韩姐小小分享$http://audio.xmcdn.com/group41/M05/AD/2E/wKgJ8VrRoRyRaBHzARPw0LDeZz8149.m4a\r\n009..安利四期 韩姐  小小分享$http://audio.xmcdn.com/group40/M0B/73/7E/wKgJT1rRoLfQFF-EAMwu5Z1yMUM454.m4a\r\n008..圆梦千万家 陈老师1小小分享$http://audio.xmcdn.com/group40/M0B/74/4B/wKgJVFrRoMOQFGTaAo4u3CeODC0099.m4a\r\n007..创办人三点 大连 韩姐小小分享$http://audio.xmcdn.com/group40/M01/73/69/wKgJT1rRn9OSZ-lGAhVtYKrhxIQ152.m4a\r\n006..创业冬天里的一把火 韩石小小分享$http://audio.xmcdn.com/group41/M00/AD/20/wKgJ8lrRn4GzkD92AoGh7IqOfnI797.m4a\r\n005..你必需是领导人 2 冯广敏  小小分享$http://audio.xmcdn.com/group40/M00/73/4E/wKgJT1rRnqnjEnQeAIkt6Wc1L4o882.m4a\r\n004..五度一力左右手 陈宏佑小小分享$http://audio.xmcdn.com/group42/M07/AE/AC/wKgJ9FrRnuvAfZTJAjF6BjnxWVg654.m4a\r\n003..五度一力 郑新清小小分享$http://audio.xmcdn.com/group42/M06/AE/A2/wKgJ9FrRnnKC-MBFAd8kGl9G9Bw961.m4a\r\n002学习是动力$http://audio.xmcdn.com/group42/M07/A9/9E/wKgJ81rRnXbBlEG8ADI1fo4svcU722.m4a\r\n001.-CD销售配带小小分享$http://audio.xmcdn.com/group42/M06/AE/8E/wKgJ9FrRna-D84UUATsxTjBOluw424.m4a\r\n小小分享44.《安瓶的神奇效果》$http://audio.xmcdn.com/group40/M05/4D/E2/wKgJT1rPhRXyHsgzAMKQIOV_WhI083.m4a\r\n小小分享43.《安瓶-皮肤的救助站》$http://audio.xmcdn.com/group42/M03/84/AE/wKgJ81rPhMvwlwkEALnPSaEUL-k244.m4a\r\n小小分享40.《安利奖金制度的魅力》$http://audio.xmcdn.com/group42/M02/84/A3/wKgJ81rPhHmDD6z7ANfPaRxlSaE959.m4a\r\n小小分享37.《XS能量饮料》$http://audio.xmcdn.com/group41/M0B/87/D6/wKgJ8lrPhCyx6gY4AMQFGvNUzp4211.m4a\r\n小小分享36.《XS商机无限》$http://audio.xmcdn.com/group42/M04/84/95/wKgJ81rPg-DiFf5TAMIAN2KaE-Q306.m4a\r\n小小分享35.《XS功能饮料的优势》$http://audio.xmcdn.com/group40/M07/4D/C8/wKgJT1rPg56R7hTvAM5kCG_KRo4803.m4a\r\n小小分享34.《100份计划》$http://audio.xmcdn.com/group42/M03/84/8A/wKgJ81rPg1HwumkOAMhJoFOkM4A705.m4a\r\n小小分享33.《100分计划-世界第八大奇迹》$http://audio.xmcdn.com/group42/M0A/89/66/wKgJ9FrPgvjiz_2jAMA5NmDuUwg238.m4a\r\n119.小小分享郭洪斌《解析安利新FAA奖金》 fc6019$http://audio.xmcdn.com/group40/M04/4E/95/wKgJVFrPgr3gCZtZATK0Btg6RCk566.m4a\r\n116.小小分享郭洪斌《梦想目标计划行动》（郭先生最满意演讲） fc6019$http://audio.xmcdn.com/group41/M08/87/AE/wKgJ8lrPgk6yvhu_AsDNyq8j_wk491.m4a\r\n115.小小分享郭洪斌《梦想与行动》下 fc6019$http://audio.xmcdn.com/group42/M05/84/51/wKgJ81rPgMLhs3tWAnD7EEtfUtU179.m4a\r\n114.小小分享郭洪斌《梦想与行动》上 fc6019$http://audio.xmcdn.com/group40/M06/4E/39/wKgJVFrPfxfQgAr8ApsVlSm_HEw828.m4a\r\n113.小小分享郭洪斌《格局决定结局》 fc6019$http://audio.xmcdn.com/group41/M01/87/51/wKgJ8lrPfenhDml4Aq5YYWoS0EU846.m4a\r\n112.小小分享郭洪斌《敢梦敢想敢成功》 fc6019$http://audio.xmcdn.com/group40/M03/4E/08/wKgJVFrPfRzSR5FIBCb22ervZL8897.m4a\r\n110.小小分享郭洪斌《定位与相信》下 fc6019$http://audio.xmcdn.com/group41/M01/87/03/wKgJ8lrPe36iHNKYAGITlhIIbgo577.m4a\r\n100.小小分享郭洪斌《从中国经济看草根创业》 fc6019$http://audio.xmcdn.com/group42/M06/88/C3/wKgJ9FrPe9iDTLtlAn0nh2u9H9w945.m4a\r\n80.小小分享【成冠上海大会】势｜李季五星产业话直销趋势$http://audio.xmcdn.com/group40/M0A/4D/50/wKgJVFrPdnzSGj9gAQcI1XdhHWg101.m4a\r\n79.小小分享【成冠上海大会】势｜余放致辞安利式新机会下【$http://audio.xmcdn.com/group41/M0A/86/66/wKgJ8lrPdgmT-R06ACiVjk-nh44961.m4a\r\n78.小小分享【成冠上海大会】势｜余放致辞安利式新机会上$http://audio.xmcdn.com/group41/M0A/86/6B/wKgJ8lrPdhqjdBaTAIkm60RAwTg963.m4a\r\n62.小小分享《骨骼健康的重要性》$http://audio.xmcdn.com/group42/M08/83/3B/wKgJ81rPdf-S-Uz2ALfZTKaVdFk600.m4a\r\n61.小小分享《精品荟萃》$http://audio.xmcdn.com/group41/M0A/86/6A/wKgJ8lrPdhWjHE6qAeJRoO_ndX0371.m4a\r\n60.小小分享《玻尿酸VC双效精华液的应用》$http://audio.xmcdn.com/group42/M0A/88/0D/wKgJ9FrPdVHjas49ALowNuHisc8636.m4a\r\n59.小小分享《玑因14活颜精华液》$http://audio.xmcdn.com/group41/M09/86/52/wKgJ8lrPdTjAYggrANY0CrYfaOw808.m4a\r\n58.小小分享《猜猜它是谁？给您生活添色彩》$http://audio.xmcdn.com/group41/M05/86/4A/wKgJ8VrPdQDQStmfANKRD0AlSR4758.m4a\r\n57.小小分享《把森林带回家》$http://audio.xmcdn.com/group40/M09/4D/37/wKgJVFrPdbPBuRjWAftuawI7t64708.m4a\r\n55.小小分享《成功之路--知性大姐家有地百亩线上分店无数》$http://audio.xmcdn.com/group40/M02/4D/08/wKgJVFrPdCfhXkOgADj6pFBCepY531.m4a\r\n54.小小分享《成功之路--我的伙伴退休生活不枯燥线上创业添色彩》$http://audio.xmcdn.com/group41/M03/86/2E/wKgJ8VrPdAPyPAk4ADDskbBrTOw808.m4a\r\n53.小小分享《成功之路--山城辣妹目标强家庭事业双丰收》$http://audio.xmcdn.com/group40/M0B/4C/FA/wKgJVFrPc-6zBNLGAEB95VMcz-U761.m4a\r\n52.小小分享《成功之路--90后从毕业到创业收获非凡事业》$http://audio.xmcdn.com/group42/M07/87/D5/wKgJ9FrPc8iQcYF2ADqBdK0vb9U753.m4a\r\n50.小小分享《宝姥姥的冲刺大堡礁之路》$http://audio.xmcdn.com/group40/M04/4C/ED/wKgJVFrPc6DT5IxgADp6_I6ptRU390.m4a\r\n49.小小分享《坚持梦想》$http://audio.xmcdn.com/group40/M04/4C/0F/wKgJT1rPc5-BrvEcALDWqUylZ_E583.m4a\r\n48.小小分享《创办人的新思路解析》$http://audio.xmcdn.com/group40/M04/4C/10/wKgJT1rPc6KSJR2MAWSD53eSmk8751.m4a\r\n47.小小分享《创办人新的成功思路》$http://audio.xmcdn.com/group42/M04/87/C5/wKgJ9FrPc02T26MpATbPbW0WigY413.m4a\r\n46.小小分享《儿童营养大全》$http://audio.xmcdn.com/group40/M08/4C/DB/wKgJVFrPcwTAp0VLAMWx5UTftR0853.m4a\r\n33.小小分享数字化安利&amp;amp;amp;新伙伴如何正确起步$http://audio.xmcdn.com/group40/M00/34/77/wKgJT1rOOpPS-XqCAjNzKOeK82I979.m4a\r\n32.小小分享安利核心干货$http://audio.xmcdn.com/group40/M09/34/70/wKgJT1rOOhSizjiaAKBV-BvyZvw553.m4a\r\n31.小小分享安利奖金制度：《如何又快又稳的建立安利事业-付后坚 》$http://audio.xmcdn.com/group42/M03/6B/46/wKgJ81rOOkfSO9wgAd-Q1iBJGT4129.m4a\r\n30.小小分享互联网安利蓝海商机的核心机密_6$http://audio.xmcdn.com/group42/M05/70/27/wKgJ9FrOOcjjCnR3AE6o_VmNg1s968.m4a\r\n29.小小分享互联网安利蓝海商机的核心机密_5$http://audio.xmcdn.com/group41/M0A/6E/75/wKgJ8VrOObnD5YzKAEq4MCCJvwc294.m4a\r\n28.小小分享互联网安利蓝海商机的核心机密_4$http://audio.xmcdn.com/group41/M0A/6E/74/wKgJ8VrOObGiCtoJAEbC97H2St0444.m4a\r\n27.小小分享互联网安利蓝海商机的核心机密_3$http://audio.xmcdn.com/group40/M08/34/6B/wKgJT1rOOanT-Ac3AESAZaXqr6s172.m4a\r\n26.小小分享互联网安利蓝海商机的核心机密_2$http://audio.xmcdn.com/group40/M08/34/6A/wKgJT1rOOaKy683OAEorbHB1uUU088.m4a\r\n25.小小分享互联网安利蓝海商机的核心机密_1$http://audio.xmcdn.com/group42/M01/6B/3D/wKgJ81rOOZiRpovmADyUfcbByT0901.m4a\r\n24.小小分享互联网安利新概念：未来已经来临，只是尚未流行_5$http://audio.xmcdn.com/group42/M01/6B/3E/wKgJ81rOOZ-w1FVOAEjE61WzLms800.m4a\r\n23.小小分享互联网安利新概念：未来已经来临，只是尚未流行_4$http://audio.xmcdn.com/group42/M0A/70/24/wKgJ9FrOOYviuYRmAD73XQeHJjc228.m4a\r\n22.小小分享互联网安利新概念：未来已经来临，只是尚未流行_3$http://audio.xmcdn.com/group41/M0A/6E/72/wKgJ8VrOOYSSVnlsAD2isG0RCNw679.m4a\r\n21.小小分享互联网安利新概念：未来已经来临，只是尚未流行_2$http://audio.xmcdn.com/group41/M0A/6E/72/wKgJ8VrOOX-juZd2AEWqfwxaLyI180.m4a\r\n20.小小分享互联网安利新概念：未来已经来临，只是尚未流行1$http://audio.xmcdn.com/group41/M0A/6E/71/wKgJ8VrOOXXCa4ZwAD1avF01HZw676.m4a\r\n19.小小分享互联网安利优势与运作$http://audio.xmcdn.com/group41/M0A/6E/77/wKgJ8VrOOcLC5dvOAen-ljuvVII547.m4a\r\n18.小小分享互联网 安利致胜的秘密_6$http://audio.xmcdn.com/group42/M09/6B/3A/wKgJ81rOOT6xSwDeAFKrbQ6rr7k923.m4a\r\n17.小小分享互联网 安利致胜的秘密_5$http://audio.xmcdn.com/group42/M07/70/21/wKgJ9FrOOTSCGiZ4AEQrOVprJHM514.m4a\r\n16.小小分享互联网 安利致胜的秘密_4$http://audio.xmcdn.com/group42/M07/70/21/wKgJ9FrOOTGi4nXuAFTxFTGIoNA071.m4a\r\n15.小小分享互联网 安利致胜的秘密_3$http://audio.xmcdn.com/group42/M07/70/1F/wKgJ9FrOOSfjueapAE5Q4jDFbdA831.m4a\r\n14.小小分享互联网 安利致胜的秘密_2$http://audio.xmcdn.com/group42/M09/70/1E/wKgJ9FrOOSKSIJvwAE5Q4mNQRf0443.m4a\r\n13.小小分享互联网 安利致胜的秘密_1$http://audio.xmcdn.com/group42/M09/70/1D/wKgJ9FrOORuRWWVCAEwkWHDiyKI151.m4a\r\n12.小小分享【精选】马云2017  谈现如今的经济形势$http://audio.xmcdn.com/group41/M09/6E/6F/wKgJ8VrOOQqiwHukAGOgKqKtqBQ503.m4a\r\n11.小小分享【内部讨论】付后坚预测安利未来之路$http://audio.xmcdn.com/group42/M08/70/1B/wKgJ9FrOOOigj8VbAAgfmYpr_vU336.m4a\r\n10.小小分享《轻资产创业是数字化安利最大的优势》$http://audio.xmcdn.com/group41/M09/6E/6A/wKgJ8VrOOO2S_ML6ACTuE4vO7Xg055.m4a\r\n08.小小分享《安利100分计划：年收入变月收入》周志坚_3$http://audio.xmcdn.com/group41/M09/6E/6A/wKgJ8lrOOPSzGgmCAGN3OG4Ua9c571.m4a\r\n07.小小分享《安利100分计划：年收入变月收入》周志坚_2$http://audio.xmcdn.com/group41/M09/6E/6A/wKgJ8VrOOOyivPRCAGqUZrynB_0467.m4a\r\n06.小小分享《安利100分计划：年收入变月收入》周志坚4$http://audio.xmcdn.com/group42/M08/70/1B/wKgJ9FrOOObiaguPAFd_2LVRU3I382.m4a\r\n05.小小分享《安利100分计划：年收入变月收入》周志坚1$http://audio.xmcdn.com/group42/M08/70/1A/wKgJ9FrOONqgZ4qAAFReF7ymHLU280.m4a\r\n04.小小分享《85后宝妈互联网安利成功秘笈》$http://audio.xmcdn.com/group42/M09/6B/33/wKgJ81rOORjRvSmsAby_YAOcKJM519.m4a\r\n03.小小分享《85后的三无人员的互联网安利创业之路》$http://audio.xmcdn.com/group40/M05/35/3D/wKgJVFrOOLGSA_6TAMq7K4NvFbs656.m4a\r\n02.小小分享《60后在互联网安利中的收获》$http://audio.xmcdn.com/group40/M01/34/5A/wKgJT1rOOG7Tqq_4AEBAOVc73HE695.m4a\r\n01.小小分享《 助人的核心意义》$http://audio.xmcdn.com/group40/M01/34/59/wKgJT1rOOGbDJDZaADnPi4qwp8o733.m4a', 'xml_8023', '2772', '', 'A', '', '1.0', 9, 0, 0, 0, 'anlihulianwangxinmoshi', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(146, 24, '帅小子演绎《红楼梦》', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group41/M09/90/18/wKgJ8VrdKzPA3Y6vAASokFJH_WE723.jpg', '', 1530072223, 7, 0, 0, 0, 0, 1, 1, 10, 7, 'ting', '', '【直播回听】卷一 甄士隐梦幻...$http://audio.xmcdn.com/group41/M08/94/D3/wKgJ8lrdbvKxAoZ_AUo-efSCiT0967.m4a', 'xml_8023', '2771', '', 'S', '', '1.0', 8, 0, 0, 0, 'shuaixiaoziyanyihongloumeng', ''),
(147, 17, '你比人生赢家差在哪', '', '未知', '', '', '', '', 'http://api1.gxlcms.com//v999/images/no.jpg', '', 1530072235, 4, 0, 0, 0, 0, 1, 1, 10, 3, 'ting', '', '用想象力和灵感抵御智能时代$http://audio.xmcdn.com/group43/M0B/45/2B/wKgKklryRkGzLZ8rAG0Xb26YTe4321.m4a\r\n最好的教育是放弃教育$http://audio.xmcdn.com/group21/M03/39/8C/wKgJKFrvCnjRVLftAEw3Ct0UnMQ590.m4a\r\n放弃父母的身份，才能做好父母$http://audio.xmcdn.com/group24/M03/30/E5/wKgJNVrqYB7wYlIRAFs26uYJx4k432.m4a\r\n自身缺陷的地心引力$http://audio.xmcdn.com/group1/M01/0F/AA/wKgJTlrqXIrhwHZXADaRDJr9nuw236.m4a\r\n你所谓的懂事，无非是成人世界的套路$http://audio.xmcdn.com/group33/M08/AA/69/wKgJTFrqWiHhVp2nADjcZ25gNyY864.m4a\r\n饭桌就是最好的课桌$http://audio.xmcdn.com/group40/M03/FC/6D/wKgJT1rl4qGTV6JhAELJRJ0Wh0A734.m4a\r\n吵架，就是一场高能解码$http://audio.xmcdn.com/group41/M03/DF/F8/wKgJ8VrhHZnCHGXaAEZlSOdc4cU608.m4a\r\n让婚姻关系在不确定性中趋于稳定$http://audio.xmcdn.com/group41/M06/DF/BE/wKgJ8lrhGsfA_lQhAEdwL7rVN_I302.m4a\r\n好的婚姻，永远追求共同利益最大化$http://audio.xmcdn.com/group40/M04/89/2F/wKgJVFrfTmSTXTf9AFU-FtFDaho831.m4a\r\n你无须把自己活成爆款$http://audio.xmcdn.com/group40/M03/87/B5/wKgJT1rfSIigoizvAEAghplVwm8808.m4a\r\n伴侣难觅，只因为你搞错了它们的关系$http://audio.xmcdn.com/group42/M03/C2/7F/wKgJ9FrfSHTw85ItAEwbr52N2x0016.m4a\r\n活得充实的女人，都美成什么样？$http://audio.xmcdn.com/group40/M00/E3/93/wKgJVFrXIPfxKu72AEM_raZ62zg800.m4a\r\n矜贵的女人，才会被好好对待$http://audio.xmcdn.com/group40/M06/E3/00/wKgJVFrXHAHwlIfSAEgMNQaezXQ552.m4a\r\n情绪不佳时的说话方式，最见一个人的教养$http://audio.xmcdn.com/group40/M05/E1/A5/wKgJT1rXF9TTMbBNADcTurF3J7k258.m4a\r\n你的独立，就是你的底气$http://audio.xmcdn.com/group40/M01/D9/A8/wKgJT1rWqW2RNTA9AD8AGoSSv3E186.m4a\r\n别把太多人请进生命$http://audio.xmcdn.com/group42/M0A/F5/AE/wKgJ9FrUzpSymyGuAEKqpN42QH0469.m4a\r\n以平常心面对无常$http://audio.xmcdn.com/group40/M02/BA/6A/wKgJT1rUygihLwOCAE6OgpgdeZo475.m4a\r\n真正的公主，从来没有公主病$http://audio.xmcdn.com/group40/M06/84/95/wKgJVFrSLz2wsQfJAFTZXzNRCm8682.m4a\r\n你比人生赢家差在哪？$http://audio.xmcdn.com/group40/M07/4C/D1/wKgJVFrPcrvBxLR-AFZru4y-LcM188.m4a\r\n别用养儿防老做风险对冲$http://audio.xmcdn.com/group18/M01/16/13/wKgJJVrtGhLzuTMRAFbkWXmHzTA757.m4a', 'xml_8023', '3748', '', 'N', '', '1.0', 2, 0, 0, 0, 'nibirenshengyingjiachazaina', ''),
(148, 17, '睡前美文', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group38/M0A/5C/BB/wKgJolqEUuGg1l65AAYAIremKbk594.jpg', '', 1530072235, 0, 0, 0, 0, 0, 1, 1, 9, 1, 'ting', '', '第一四八夜：别让房子榨干你的人生$http://audio.xmcdn.com/group43/M05/49/DA/wKgKjVryZV7j3uyeAASYgP7ZdIE830.m4a\r\n第一四七夜：心梦无痕，彼岸花开$http://audio.xmcdn.com/group44/M09/48/D2/wKgKjFryZLvy21-lAAcRm4L1SEA612.m4a\r\n第一四六夜：靠自己，扬眉吐气$http://audio.xmcdn.com/group43/M00/48/01/wKgKklryZCDSjZPbAAV9lQnjMTs572.m4a\r\n第一四五夜：爱情如歌$http://audio.xmcdn.com/group44/M03/48/B3/wKgKjFryY1jgQa2RAAYKiwJzqZU019.m4a\r\n第一四四夜：每个人都要有的战略思想$http://audio.xmcdn.com/group43/M0A/47/EA/wKgKklryYvaBplR9AAWz7NXBpgk451.m4a\r\n第一四三夜：说走就走，随遇而安$http://audio.xmcdn.com/group23/M08/35/F5/wKgJNFrrJmbgRcS_AAaQtq5uaUw818.m4a\r\n第一四二夜：急功，近利$http://audio.xmcdn.com/group39/M01/C8/52/wKgJnlrrJZ6iQgTYAAeAMh99iQg617.m4a\r\n第一四一夜：爱情能邂逅吗？$http://audio.xmcdn.com/group17/M02/13/F7/wKgJJFrrJRiAQsaMAAZJkYaOCU8985.m4a\r\n第一四零夜：弱小不是错$http://audio.xmcdn.com/group21/M0A/31/F8/wKgJLVrrJH_hSlvoAARH9Y_ywWQ015.m4a\r\n第一三九夜：粉碎社交焦虑$http://audio.xmcdn.com/group39/M00/C7/F6/wKgJn1rrJDLQfZoTAAeSnzbJ9EI123.m4a\r\n第一三八夜：粉碎年龄焦虑$http://audio.xmcdn.com/group20/M06/11/DE/wKgJLFrrIqii1tAnAAmRbcD4PT8666.m4a\r\n第一三七夜：粉碎失眠焦虑$http://audio.xmcdn.com/group34/M06/7B/B3/wKgJYFrogqSxCY25AAo3kaiLJ3w627.m4a\r\n第一三六夜：粉碎未来焦虑$http://audio.xmcdn.com/group33/M02/5D/96/wKgJUVrogViwhm9_AAjow4cwZiM921.m4a\r\n第一三五夜：粉碎身材焦虑$http://audio.xmcdn.com/group42/M05/DB/57/wKgJ9Frgl7iSIOr7AAgeIUYcshA340.m4a\r\n第一三四夜：粉碎生活焦虑$http://audio.xmcdn.com/group42/M0A/C2/38/wKgJ9FrfRj2ya_OXAAbT-POcR6Q450.m4a\r\n第一三三夜：粉碎工作焦虑$http://audio.xmcdn.com/group40/M00/88/37/wKgJVFrfRjOAiSIHAAlfG-BLZDw358.m4a\r\n第一三二夜：赢$http://audio.xmcdn.com/group41/M02/55/3C/wKgJ8lraBTeR5yN4AAR4wLIIzNo820.m4a\r\n第一三一夜：宿命的悲$http://audio.xmcdn.com/group41/M03/55/26/wKgJ8lraBHjTLS9kAAUeITCTng8514.m4a\r\n第一三零：樱花树下的少女$http://audio.xmcdn.com/group42/M04/51/EF/wKgJ81raA4qCURqqAAc-6lbjXXM182.m4a\r\n第一二九夜：一生天涯$http://audio.xmcdn.com/group42/M0B/3C/59/wKgJ81rYtjfgomV2AAU0dny_tkA552.m4a\r\n第一二八夜：恋物$http://audio.xmcdn.com/group40/M00/07/2A/wKgJVFrYtbqiJWnZAAbyjxjW6l4065.m4a\r\n第一二七夜：命中注定的过客$http://audio.xmcdn.com/group41/M01/0B/BC/wKgJ8VrWB1LiFOfqAAWA95XClkY765.m4a\r\n第一二六夜：举杯，为了和平$http://audio.xmcdn.com/group40/M01/B9/3B/wKgJVFrUtePD5relAAO8PTS7HzE595.m4a\r\n第一二五夜：幸福右边，荒芜人烟$http://audio.xmcdn.com/group42/M01/D9/84/wKgJ9FrTciPQIRA6AAPg9FGuRoA402.m4a\r\n第一二四夜：只身步步海天涯$http://audio.xmcdn.com/group40/M06/9D/00/wKgJT1rTZGSSlU4aAAR4M3F1s9A195.m4a\r\n第一二三：山河拱手，为君一笑$http://audio.xmcdn.com/group41/M07/A0/68/wKgJ8VrQykLxY0nSAAQcKV-QnDY581.m4a\r\n第一二二夜：一杯清酒，醉了红颜$http://audio.xmcdn.com/group42/M0A/A2/09/wKgJ9FrQyVSD0ZubAAZNdpzTeWQ512.m4a\r\n第一二一夜：明夕何夕，君已陌路$http://audio.xmcdn.com/group41/M09/6C/5F/wKgJ8VrOIUvCd40JAAXI5h5s-jk084.m4a\r\n第一二零夜：万般故事，不过情伤$http://audio.xmcdn.com/group41/M04/6C/44/wKgJ8VrOIGLTpvlQAAXgL5S_7j8645.m4a\r\n第一一九夜：清浅时光，且歌且行$http://audio.xmcdn.com/group41/M08/39/13/wKgJ8VrLgpWiFn_dAAYNkzYeZTI446.m4a\r\n第一一八夜：请不要放弃我$http://audio.xmcdn.com/group41/M08/B7/CA/wKgJ8VrE2iyxtvZrAAdyUdtdCGw020.m4a\r\n第一一七夜：回忆如潮水$http://audio.xmcdn.com/group40/M00/7F/3A/wKgJT1rE2SbhZ5mDAAZKPbiBsyY925.m4a\r\n第一一六：我为什么哭泣$http://audio.xmcdn.com/group42/M05/B5/D0/wKgJ81rE2G6Cmc2PAAim9Vpovr4618.m4a\r\n第一一五夜：关于记忆$http://audio.xmcdn.com/group42/M0A/B5/9E/wKgJ81rE1zvSoKjoAAhX8VzfX0E441.m4a\r\n第一一四夜：关于时间$http://audio.xmcdn.com/group42/M00/B5/7F/wKgJ81rE1nLh98knAAeMwR4dBic852.m4a\r\n第一一三夜：关于独处$http://audio.xmcdn.com/group40/M08/63/B1/wKgJT1rDhGzjUat_AAdykkp-uaQ300.m4a\r\n第一一二夜：你好，很高兴认识你$http://audio.xmcdn.com/group40/M00/3E/DC/wKgJVFrBrx6x053SAAdgszd9omw469.m4a\r\n第六十一夜：跳出舒适圈$http://audio.xmcdn.com/group40/M07/38/63/wKgJVFrA-8az5G2QAAvOVtAfmbA132.m4a\r\n第六十二夜：我是谁$http://audio.xmcdn.com/group42/M01/73/37/wKgJ9FrA-TaBZ4uAAAaoFQ7tMPg379.m4a\r\n第六十三夜：别担心，哭吧$http://audio.xmcdn.com/group40/M00/38/1D/wKgJVFrA-IOzSXPVAAmvQ_nfM0c499.m4a\r\n第五夜：春去秋来，何处为安$http://audio.xmcdn.com/group42/M06/6E/83/wKgJ81rA91OTnsMtAAuJQgu5VJ8595.m4a\r\n第一一一夜：努力，是唯一可复制的成功要素$http://audio.xmcdn.com/group41/M07/40/B5/wKgJ8lq-SAmC8_PzAAbFCtiRO30587.m4a\r\n第一一零夜：奇迹的背后$http://audio.xmcdn.com/group40/M09/05/8B/wKgJT1q-RwyAGYNKAASpQTo9mEs180.m4a\r\n第一零九夜：像个孩子一样笑$http://audio.xmcdn.com/group42/M07/3E/EA/wKgJ9Fq-RovyQYkHAAS08-oqRFU797.m4a\r\n第一零八夜：过路人$http://audio.xmcdn.com/group40/M03/06/19/wKgJVFq-RS_iTlBgAASInhFkf3I671.m4a\r\n第一零七夜：春天的气息$http://audio.xmcdn.com/group40/M01/D7/BD/wKgJT1q7j6vi1Q95AAZIO4CmIfo762.m4a\r\n第一零五夜：领路人$http://audio.xmcdn.com/group41/M0A/12/C7/wKgJ8lq7jwrilxOwAASYgMoowY0786.m4a\r\n第六十四夜：喜欢是放肆，爱是克制$http://audio.xmcdn.com/group40/M04/CC/5E/wKgJVFq63E6w7KBzAAgM7ApmoD8631.m4a\r\n第六十六夜：无法相交那就平行吧$http://audio.xmcdn.com/group41/M09/04/11/wKgJ8Vq625-w-OgIAAULW1zKPpk252.m4a\r\n第六十八夜：谁在追我，时间在追我$http://audio.xmcdn.com/group41/M04/06/95/wKgJ8lq62zmiB-ixAAaYLuE1x5Q352.m4a\r\n第七十五夜：有一种幸福是被唠叨$http://audio.xmcdn.com/group40/M0A/CC/4B/wKgJVFq62s6T1wzVAAa1gUlwJHg609.m4a\r\n第七十六夜：爱有多深，便有多痛$http://audio.xmcdn.com/group42/M00/04/DC/wKgJ9Fq62mXTPAjvAAUV-jXZkNA641.m4a\r\n第七十夜：孤独是各自修行$http://audio.xmcdn.com/group41/M08/03/FB/wKgJ8Vq62WvxES35AAeF8XP9O-4742.m4a\r\n第一零六夜：长大的代价$http://audio.xmcdn.com/group42/M04/01/27/wKgJ81q6WACRoXC8AAZ7nswJ_Yw237.m4a\r\n第七十七夜：姑娘的努力，与虚荣无关$http://audio.xmcdn.com/group40/M05/B2/B1/wKgJT1q5BPewChlYAAfGPBKnRvs088.m4a\r\n第七十八夜：请勇敢的坚持善念$http://audio.xmcdn.com/group41/M07/EB/27/wKgJ8Vq5A8zznSoEAAXtLRj-NkE534.m4a\r\n第四夜：孤独的解药$http://audio.xmcdn.com/group42/M05/D6/5C/wKgJ9Fq3uB6Cl16LAAkpffa_Nes593.m4a\r\n第三夜：这里让爱不流浪$http://audio.xmcdn.com/group41/M08/D5/44/wKgJ8Vq3tYLDib3iAApoccGDcOs392.m4a\r\n第二夜：幸福的真谛$http://audio.xmcdn.com/group41/M08/C0/42/wKgJ8Vq2blvxxRU1AAzSP3TO_PI513.m4a\r\n第一夜：青春易老$http://audio.xmcdn.com/group41/M02/C2/B4/wKgJ8lq2bMmSt8e9AAp6NtfmyAE024.m4a\r\n第一零四夜：素心包裹，埋头向前$http://audio.xmcdn.com/group41/M09/C2/4D/wKgJ8lq2aHzzIEq_AAc3y89MB08560.m4a\r\n第一零三夜：卸下防备，拥抱爱$http://audio.xmcdn.com/group40/M03/87/F7/wKgJVFq2ZqfzoEeGAAeUeToOH3c389.m4a\r\n第一零二夜：为自己过人生$http://audio.xmcdn.com/group40/M05/86/B9/wKgJT1q2ZF6xh8wqAAiltoHkeNY798.m4a\r\n第一零一夜：岁月的勋章$http://audio.xmcdn.com/group40/M0A/5E/86/wKgJVFqzviLD-X--AAcXRz-pO_E529.m4a\r\n第一百夜：奋斗吧女孩！$http://audio.xmcdn.com/group41/M0B/98/C7/wKgJ8lqzvO7DddvDAAVySFffscE569.m4a\r\n第九十九夜：爱情需要理性保驾护航$http://audio.xmcdn.com/group41/M05/83/55/wKgJ8lqycAXDJ61tAAi7Pgg1TmI401.m4a\r\n第九十八夜：断舍离$http://audio.xmcdn.com/group41/M0A/6B/E1/wKgJ8lqxIUnCZ-XSAAdRH0zoTwQ947.m4a\r\n第九十七夜：人生最坏的结果$http://audio.xmcdn.com/group40/M03/1A/70/wKgJVFqv0qeRfqIoAAcwXpBkXWI177.m4a\r\n第九十六夜：再见吧青春$http://audio.xmcdn.com/group42/M09/39/63/wKgJ9FqueguRpPbWAAZJmWx55yU392.m4a\r\n第九十四夜：格物致知$http://audio.xmcdn.com/group42/M08/39/88/wKgJ81queN-ClG5eAAfvZH8Uxrc230.m4a\r\n雨天$http://audio.xmcdn.com/group41/M04/21/3C/wKgJ8lqtJb7wKRu9AAtpAbrRm94526.m4a\r\n第七十二夜：爱情的样子$http://audio.xmcdn.com/group40/M03/A2/EA/wKgJT1qpMlKQcjiXAAfmVPcCdcI955.m4a\r\n第八十一夜：生活才是正事$http://audio.xmcdn.com/group40/M05/A3/48/wKgJVFqpLqCCTQsyAAZb5PNgJ9I252.m4a\r\n第八十二夜：30岁的我想对20岁的你说$http://audio.xmcdn.com/group42/M03/DC/5D/wKgJ81qpLfiD8n0MAAZM3Xzhkc4890.m4a\r\n第八十三夜：爱自由$http://audio.xmcdn.com/group41/M00/C8/E2/wKgJ8lqn6RvxEfbHAAe9NZRJMo8890.m4a\r\n第八十五夜：命中注定的期遇$http://audio.xmcdn.com/group40/M01/8D/51/wKgJT1qn5teSrBYjAAXdp0XfA_g275.m4a\r\n第八十六夜：无需参考别人的人生$http://audio.xmcdn.com/group41/M08/C8/89/wKgJ8lqn5VeB3Cj8AAczvQfG8sI140.m4a\r\n第九十二夜：陪伴是最长情的告白$http://audio.xmcdn.com/group42/M07/C6/70/wKgJ9Fqn49_yk4WVAAYcgc3dnGA468.m4a', 'xml_8023', '3535', '', 'S', '', '1.0', 2, 0, 0, 0, 'shuiqianmeiwen', ''),
(149, 17, '商道之战', '', '未知', '', '', '', '一个商界传奇的飞扬与落寂，以经典的案例演练真实的商道。    商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战商道之战', 'http://imagev2.xmcdn.com/group43/M05/31/A8/wKgKjVrxhueg-MYUAAJguAOr4Vc378.jpg', '', 1530072235, 1, 0, 0, 0, 0, 1, 1, 3, 3, 'ting', '', '商道之战，第一集$http://audio.xmcdn.com/group44/M0B/31/99/wKgKjFrxjGmjW9NNAJhISzXLJ_k197.m4a\r\n商道之战，第二集$http://audio.xmcdn.com/group44/M01/32/31/wKgKjFrxjz_RpUw7AJlWe1uB9xE798.m4a\r\n商道之战，第三集$http://audio.xmcdn.com/group44/M05/33/27/wKgKjFrxkxvB4SDwAJlPJUzRa9s188.m4a\r\n商道之战，第四集$http://audio.xmcdn.com/group44/M06/33/9F/wKgKjFrxlPvQ4Ms7AJT5NxrC8m8752.m4a\r\n商道之战，第五集$http://audio.xmcdn.com/group44/M04/34/0C/wKgKkVrxlTjivPXAAJfSKbfm9Bc215.m4a\r\n商道之战，第六集$http://audio.xmcdn.com/group44/M03/34/86/wKgKjFrxmF2j71KcAJo7kHMo9no862.m4a\r\n商道之战，第七集$http://audio.xmcdn.com/group44/M06/34/8F/wKgKjFrxmI6x5dHrAJqGc0gYZCk043.m4a\r\n商道之战，第八集$http://audio.xmcdn.com/group43/M04/35/B1/wKgKjVrxmLLiqJ22AJddaht06-o427.m4a\r\n商道之战，第九集$http://audio.xmcdn.com/group43/M05/35/BC/wKgKjVrxmN-zUiOOAJfzHzbORNg015.m4a\r\n商道之战，第十集$http://audio.xmcdn.com/group44/M00/35/10/wKgKkVrxmQbhNJXJAJgS0sThM6s442.m4a\r\n商道之战，第十一集$http://audio.xmcdn.com/group44/M08/47/C5/wKgKkVryVtKhm0_FAJhQSCS2GbM934.m4a\r\n商道之战，第十二集$http://audio.xmcdn.com/group43/M07/48/75/wKgKjVryVvSSrMjHAJSAmDhQA6A232.m4a\r\n商道之战，第十三集$http://audio.xmcdn.com/group44/M0A/47/76/wKgKjFryVxmgARipAJsJJNswa6I593.m4a\r\n商道之战，第十四集$http://audio.xmcdn.com/group43/M08/48/7D/wKgKjVryVz3CJ-dsAJt1zY08szY959.m4a\r\n商道之战，第十五集$http://audio.xmcdn.com/group43/M03/48/82/wKgKjVryV2CxIMIhAJfuuFo5RBo048.m4a\r\n商道之战，第十六集$http://audio.xmcdn.com/group44/M04/47/7D/wKgKjFryV4TSDmUBAJq8ydtGBEE066.m4a\r\n商道之战，第十七集$http://audio.xmcdn.com/group44/M09/47/86/wKgKjFryV7qjIn12AJwFtno76eI236.m4a\r\n商道之战，第十八集$http://audio.xmcdn.com/group44/M02/47/8A/wKgKjFryV97hv6X2AJbZLw9VFVo435.m4a\r\n商道之战，第十九集$http://audio.xmcdn.com/group44/M07/47/8C/wKgKjFryWAnDmXHgAJhG1CeqPGA437.m4a\r\n商道之战，第二十集$http://audio.xmcdn.com/group43/M0A/46/D4/wKgKklryWCmhzGDxAJeMVcP2mqo702.m4a\r\n商道之战，第二十一集$http://audio.xmcdn.com/group43/M0A/49/A9/wKgKjVryYvihh5r0AJgKnwz1WYI204.m4a\r\n商道之战，第二十二集$http://audio.xmcdn.com/group44/M08/49/05/wKgKkVryYyWS2npgAJlmoaxt6IY819.m4a\r\n商道之战，第二十三集$http://audio.xmcdn.com/group44/M08/49/09/wKgKkVryYz2C_2W6AJ6iEaIRPuY680.m4a\r\n商道之战，第二十四集$http://audio.xmcdn.com/group44/M08/49/0F/wKgKkVryY17jCpW5AJqAlXsnC-Y475.m4a\r\n商道之战，第二十五集$http://audio.xmcdn.com/group43/M07/47/EE/wKgKklryY3qQfzTFAJxKu7_goPg675.m4a\r\n商道之战，第二十六集$http://audio.xmcdn.com/group44/M0B/48/B8/wKgKjFryY8nwrsVEAJ0od7jqEbo366.m4a\r\n商道之战，第二十七集$http://audio.xmcdn.com/group44/M0B/48/B8/wKgKjFryY8rioY87AJoJpMJ8HMU099.m4a\r\n商道之战，第二十八集$http://audio.xmcdn.com/group44/M0A/49/27/wKgKkVryZH-REP9YAJoe1Xt9P0U025.m4a\r\n商道之战，第二十九集$http://audio.xmcdn.com/group43/M04/49/FB/wKgKjVryZqPDiKeaAJy3ZNbxSU8836.m4a\r\n商道之战，第三十集$http://audio.xmcdn.com/group44/M02/49/5A/wKgKkVryZsaiZYoiAJub_ObyHi4447.m4a\r\n商道之战，第三十一集$http://audio.xmcdn.com/group43/M08/4A/02/wKgKjVryZuXx5uaCAJk3pYt7-rs764.m4a\r\n商道之战，第三十二集$http://audio.xmcdn.com/group44/M06/49/0A/wKgKjFryZwyynoiLAJ376cKMQrc315.m4a\r\n商道之战，第三十三集$http://audio.xmcdn.com/group43/M0A/48/49/wKgKklryZzHid1zVAJxoGmfqCYU059.m4a\r\n商道之战，第三十四集$http://audio.xmcdn.com/group43/M03/4A/11/wKgKjVryZ2qAXO1-AJld1HHO_UU109.m4a\r\n商道之战，第三十五集$http://audio.xmcdn.com/group43/M05/48/54/wKgKklryZ3jwRbQ5AJiNUTCfvbc846.m4a\r\n商道之战，第三十六集$http://audio.xmcdn.com/group44/M09/49/1B/wKgKjFryZ77iZGd7AJz4Aoq0TJY669.m4a\r\n商道之战，第三十七集$http://audio.xmcdn.com/group44/M02/49/24/wKgKjFryaAnTYyXVAJxw59FO9Xo014.m4a\r\n商道之战，第三十八集$http://audio.xmcdn.com/group44/M0B/49/26/wKgKjFryaDHAxjqTAJ2TpwoLbuU163.m4a\r\n商道之战，第三十九集$http://audio.xmcdn.com/group44/M0B/49/2E/wKgKjFryaGmxnCjHAJZK9AEzNmo179.m4a\r\n商道之战，第四十集$http://audio.xmcdn.com/group43/M03/4A/31/wKgKjVryaJTDO_w6AJ2vjqqfzW4071.m4a\r\n商道之战，第四十一集$http://audio.xmcdn.com/group43/M08/48/77/wKgKklryaM3R_qcOAJ2xBhaZqlA955.m4a\r\n商道之战，第四十二集（完）$http://audio.xmcdn.com/group44/M08/49/3D/wKgKjFryaPLB_O_vAJ1aYkNHrvI665.m4a', 'xml_8023', '3746', '', 'S', '', '8.0', 10, 0, 0, 0, 'shangdaozhizhan', ''),
(150, 17, '幸福家庭读书会《为何家会伤人》', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group42/M0B/FB/A2/wKgJ9FrVZtaxXw90AAFidq26nOc995.jpg', '', 1530072235, 6, 0, 0, 0, 0, 1, 1, 7, 6, 'ting', '', '28考试瘾比网瘾更可怕二(张宏伟）$http://audio.xmcdn.com/group44/M08/05/F4/wKgKjFrwBgWQvn5BAHKPnjsM_A8840.m4a\r\n27考试瘾比网瘾更可怕一（董伟）$http://audio.xmcdn.com/group44/M03/06/58/wKgKkVrwBYziKqKLAFZI5ZNA8mc675.m4a\r\n26孩子为何把网络当成“安全岛”一（海燕）$http://audio.xmcdn.com/group32/M00/C3/DA/wKgJS1rul2-QrwhLAGBfq-vuINU098.m4a\r\n25别把焦虑转嫁给孩子二（夏沫）$http://audio.xmcdn.com/group42/M01/45/EB/wKgJ9FrpolfB_62BAH4ExalEkko820.m4a\r\n24别把焦虑转嫁给孩子一（黄艳娜）$http://audio.xmcdn.com/group38/M01/C3/31/wKgJolrpofLRsAbOAHV_tkCTZ14783.m4a\r\n23孩子有问题大人先自醒（姜曼）$http://audio.xmcdn.com/group36/M04/B2/C1/wKgJUlrpkByDu_AuAHWLP0QlrRk686.m4a\r\n22青少年太听话不是好事（阮换欣）$http://audio.xmcdn.com/group36/M06/FF/C0/wKgJTVrpUv2ybmg3AJoehbqVLlw166.m4a\r\n21痛苦的童年为神经症“播种”二（建军）$http://audio.xmcdn.com/group25/M04/3A/D6/wKgJNlrpEs7ibNlKAETiEAKo9b8108.m4a\r\n20痛苦的童年为神经症“播种”一（黄锴）$http://audio.xmcdn.com/group42/M0B/23/DF/wKgJ81rlM6Hw32knAJ-XE1jVyMU871.m4a\r\n19密不透风的“爱”源于自私（赵颖娟）$http://audio.xmcdn.com/group41/M05/FA/5D/wKgJ8lrij8_xE4eKAK1fobTmn70948.m4a\r\n18对物质的追求是对爱的渴望（孔德平)$http://audio.xmcdn.com/group40/M07/C2/18/wKgJVFrijwbCJ2rIAGaM9zUtgK4875.m4a\r\n17溺爱=过度地阻碍（阿艳）$http://audio.xmcdn.com/group40/M05/C2/03/wKgJVFrija-i01M-AIV2XCDe9Zk830.m4a\r\n16宠爱自己——溺爱的心理真相二（段昱红）.$http://audio.xmcdn.com/group42/M03/CC/3B/wKgJ9FrgHJbwJ20uAHWLGQGaJ24524.m4a\r\n15宠爱自己——溺爱的心理真相一（刘军霞）.$http://audio.xmcdn.com/group41/M01/CA/FA/wKgJ8lrgG_yCCjFWAGzsbFRN3Hs986.m4a\r\n14男孩归爸爸，女孩归二（韩晓峰）$http://audio.xmcdn.com/group42/M0B/C9/F8/wKgJ9Frf_gLx0muCAHabIIKd_2w651.m4a\r\n13男孩归爸爸女孩归妈妈一（周尚）$http://audio.xmcdn.com/group41/M09/C8/75/wKgJ8Vrf_KihmVHXAGicMSMAodY820.m4a\r\n12分离是生命永恒的主题二（李晓颖）$http://audio.xmcdn.com/group42/M0A/4D/8D/wKgJ9FrZuzTwqtFEAI5032KMRLI318.m4a\r\n11分离设计生命中永恒的主题一（臧慧茹）$http://audio.xmcdn.com/group40/M00/8D/06/wKgJT1rf2R-R5q8sAHyN4xMspdA493.m4a\r\n10父母不是孩子的答案（黄艳娜）$http://audio.xmcdn.com/group40/M04/FB/EB/wKgJVFrYaNTjPexFAFxxlt_6DPc866.m4a\r\n9妈妈是婴儿的镜子（刘丽媛）$http://audio.xmcdn.com/group41/M09/16/4C/wKgJ8VrW2nihk3Z-AI50379qZTQ994.m4a\r\n8.2孩子不是你的最爱二（付立萍）$http://audio.xmcdn.com/group41/M00/CA/30/wKgJ8VrgE_OSVfmWAEK6-mCRfpM303.m4a\r\n8.1孩子不是你的最爱一（王晓）$http://audio.xmcdn.com/group42/M09/FF/D9/wKgJ9FrVoMHTAEGWAFW0YV_AgsY733.m4a\r\n7不要把权利规则带回家二（高小晴）$http://audio.xmcdn.com/group41/M04/E5/C4/wKgJ8VrUbRaS1LJEAFvOzhKmNb4754.m4a\r\n6不要把权利规则带回家 一（孙婧）$http://audio.xmcdn.com/group41/M04/CD/A0/wKgJ8lrTKDTTeXv-AG4IAl-Unr8352.m4a\r\n5别拿自己的尺子量对方二（立倩）$http://audio.xmcdn.com/group42/M00/B4/75/wKgJ9FrR37fjCcc9AI64nyAGRVk277.m4a\r\n4别拿自己尺子量对方一（艳杰）$http://audio.xmcdn.com/group41/M02/95/FF/wKgJ8VrQfVWx5dnbAG8oxs71Cps604.m4a\r\n3缘分=“娶回”妈妈“嫁给”爸爸二（兔子$http://audio.xmcdn.com/group41/M05/7A/33/wKgJ8VrPJxHwC7NBAHM214uIav8462.m4a\r\n2缘分=“娶回”妈妈“嫁给”爸爸一（立业)$http://audio.xmcdn.com/group41/M04/60/CC/wKgJ8VrN2TOBMF87AGaYt403Vo8870.m4a\r\n1每一次分手都是心灵的修复二（海燕）$http://audio.xmcdn.com/group40/M09/0F/3C/wKgJT1rMlKqiad2WALKt4hION24732.m4a\r\n1每一次分手都是心灵的修复一（海燕）$http://audio.xmcdn.com/group41/M07/2E/20/wKgJ8VrLPiXA6QwcAGtkUe1byyE112.m4a\r\n为何家会伤人~序言（海燕）$http://audio.xmcdn.com/group42/M07/2A/07/wKgJ81rLIoyD0qIJAFoy-m6m6mg355.m4a', 'xml_8023', '3747', '', 'X', '', '1.0', 9, 0, 0, 0, 'xingfujiatingdushuhuiweihejiahuishangren', ''),
(151, 17, '羊皮卷1第二天', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group43/M02/47/B1/wKgKjVryTpii6NpNAACwNXY9W54893.jpg', '', 1530072235, 9, 0, 0, 0, 0, 1, 1, 5, 4, 'ting', '', '羊皮卷1第二天$http://audio.xmcdn.com/group43/M05/45/F6/wKgKklryTs7DWEOGAEQESgtFJ5Y519.m4a', 'xml_8023', '3745', '', 'Y', '', '1.0', 5, 0, 0, 0, 'yangpijuan1diertian', ''),
(152, 17, '中医学基础', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group40/M08/9B/EF/wKgJT1rgfGCD895PAAC1q7bqu0E196.jpg', '', 1530072235, 2, 0, 0, 0, 0, 1, 1, 2, 4, 'ting', '', '三、阴阳学说在中医学中的应用$http://audio.xmcdn.com/group44/M08/49/86/wKgKjFrya_mS734pAEcFMBBUj8g542.m4a\r\n第一节阴阳学说$http://audio.xmcdn.com/group44/M0A/48/CC/wKgKjFryZH_TqoGvACFYlcvs9qw067.m4a\r\n阴阳学说的基本内容$http://audio.xmcdn.com/group44/M00/49/15/wKgKkVryY9KCLwMIAFzy1bNL30g298.m4a\r\n第一章阴阳五行学说$http://audio.xmcdn.com/group43/M00/23/88/wKgKklrxFYbwWxQkABYhmIXCtms147.m4a\r\n中医学的基本特点$http://audio.xmcdn.com/group41/M08/D7/D5/wKgJ8VrgiTPDtwHeAKZhtkoZUnE286.m4a\r\n二、中医学理论体系的形成和发展$http://audio.xmcdn.com/group40/M06/9D/66/wKgJT1rggzjjLjhjAHXmt4KYXKc776.m4a\r\n一、中医学的起源$http://audio.xmcdn.com/group41/M01/D5/B8/wKgJ8lrgffbSir3pACTPPSG608A360.m4a\r\n前言$http://audio.xmcdn.com/group40/M08/9C/DB/wKgJVFrgfHnSbs8NABzuHhDuLvI634.m4a', 'xml_8023', '3744', '', 'Z', '', '1.0', 9, 0, 0, 0, 'zhongyixuejichu', ''),
(153, 17, '边城', '', '未知', '', '', '', '《边城》是沈从文的代表作，写于一九三三年至一九三四年初。这篇作品如沈从文的其他湘西作品，着眼于普通人、善良人的命运变迁，描摹了湘女翠翠阴差阳错的生活悲剧，诚如作者所言：“一切充满了善，然而到处是不凑巧。既然是不凑巧，因之素朴的善终难免产生悲剧。”《边城》写出了一种如梦似幻之美，像摆渡、教子、救人、助人、送葬这些日常小事，在作者来都显得相当理想化，颇有几分“君子田”的气象。当然，矛盾也并非不存在，明眼人一看便知，作者所用的背景材料中便隐伏着社会矛盾的影子。作者亦不曾讳言他的写作意图是支持“民族复兴大业的人”，“给他们一种勇气和信心”。', 'http://imagev2.xmcdn.com/group43/M0A/3E/E3/wKgKjVrxuy6gyWq8AACi3BNpwC4388.jpg', '', 1530072235, 0, 0, 0, 0, 0, 1, 1, 7, 6, 'ting', '', '第01集$http://audio.xmcdn.com/group44/M08/3E/4F/wKgKkVrxvC2BSzztAFYYBh5F_UQ379.m4a\r\n第02集$http://audio.xmcdn.com/group44/M08/3E/4F/wKgKkVrxvCrjh9ikAFURLPJQpFY667.m4a\r\n第03集$http://audio.xmcdn.com/group44/M08/3E/51/wKgKkVrxvDKCYhAlAEego18CFhc107.m4a\r\n第04集$http://audio.xmcdn.com/group44/M08/3E/51/wKgKkVrxvDDw64ZRAD5gDhZlsj4877.m4a\r\n第05集$http://audio.xmcdn.com/group44/M08/3E/58/wKgKkVrxvEKCrMdjAGxfa2kBKP8128.m4a\r\n第06集$http://audio.xmcdn.com/group43/M07/4A/C6/wKgKjVrybreQsXBrADyKKOzf0bQ016.m4a\r\n第07集$http://audio.xmcdn.com/group43/M05/4A/C5/wKgKjVrybrbBkvaUADmESWbR8fs449.m4a\r\n第08集$http://audio.xmcdn.com/group43/M07/4A/C6/wKgKjVrybrzScd8gAES8iRuj0r0348.m4a\r\n第09集$http://audio.xmcdn.com/group44/M06/49/C9/wKgKjFrybsrjCwuBAGSvtwEE5Rs805.m4a\r\n第10集$http://audio.xmcdn.com/group44/M08/4A/24/wKgKkVrybs2gnVWBAFgCsFQuF44401.m4a\r\n第11集$http://audio.xmcdn.com/group44/M06/49/C9/wKgKjFrybs3i-iaXAEi5G94z0XQ354.m4a\r\n第12集$http://audio.xmcdn.com/group44/M06/49/CA/wKgKjFrybtPhqLhVAE6S6Noe-S0640.m4a', 'xml_8023', '3742', '', 'B', '', '1.0', 10, 0, 0, 0, 'biancheng', ''),
(154, 17, '丹姐爱读书', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group40/M08/37/0D/wKgJT1rOncXgJKJlAAHiPnUQtV0440.jpg', '', 1530072235, 4, 0, 0, 0, 0, 1, 1, 4, 7, 'ting', '', '王春燕二经1$http://audio.xmcdn.com/group44/M00/46/EB/wKgKjFryUbGS7HQNAQFlWnFpVOw715.m4a\r\n很多人在为小事烦恼了$http://audio.xmcdn.com/group42/M01/DC/F7/wKgJ9FrT2N-ik0QmAF0DcMvWHu8288.m4a\r\n学会利用自己的缺点$http://audio.xmcdn.com/group40/M08/37/12/wKgJT1rOnemTJQ7TADgpuyoKBNs623.m4a', 'xml_8023', '3743', '', 'D', '', '1.0', 3, 0, 0, 0, 'danjieaidushu', ''),
(155, 17, '《一切都是最好的安排》专辑', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group42/M05/07/3E/wKgJ81rjPZyQHI_OAAGpy3HCQv0632.jpg', '', 1530072235, 0, 0, 0, 0, 0, 1, 1, 1, 3, 'ting', '', '我们该如何与这个世界相处$http://audio.xmcdn.com/group44/M01/47/4E/wKgKjFryVVyzFgV_AFHB4pvV2Oc039.m4a\r\n如何与这个世界去相处$http://audio.xmcdn.com/group43/M08/46/22/wKgKjVryPMDQleWoAKro72SJECE070.m4a\r\n《一切都是最好的安排》之人生经不起太多的耽搁$http://audio.xmcdn.com/group41/M04/CB/C0/wKgJ8VrgKdnSlfRFAG50eZJAo30538.m4a\r\n《一切都是最好的安排》第一章之$http://audio.xmcdn.com/group40/M03/79/C3/wKgJT1re4HrCVc3xAD90HIWLnX0319.m4a\r\n《一切都是最好的安排》第一章之心中有痛也要舍得$http://audio.xmcdn.com/group41/M06/B2/80/wKgJ8Vre2cPB_wY6ADVke6wBh1E463.m4a', 'xml_8023', '3741', '', '0', '', '1.0', 1, 0, 0, 0, 'yiqiedushizuihaodeanpaizhuanji', ''),
(156, 17, '孤寂深渊', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group41/M02/8A/77/wKgJ8lrP1MnBfZ7KAAFvLf-aMII159.jpg', '', 1530072235, 8, 0, 0, 0, 0, 1, 1, 8, 1, 'ting', '', '孤寂深渊1-2-4$http://audio.xmcdn.com/group43/M00/4A/D7/wKgKjVryb5OhRG7gACrydlCeKlQ114.m4a\r\n孤寂深渊1-2-3$http://audio.xmcdn.com/group43/M02/49/14/wKgKklryb1bCKFJYAC8Varj5Qf0779.m4a\r\n孤寂深渊1-2-2$http://audio.xmcdn.com/group30/M0B/79/F0/wKgJWlrpqZ2AOl8wAJVMtU_5Xic420.m4a\r\n孤寂深渊1-2-1$http://audio.xmcdn.com/group41/M0B/39/1E/wKgJ8VrmS_WhfAIJAEFEJFRkulY484.m4a\r\n孤寂深渊1-1-3$http://audio.xmcdn.com/group42/M01/C6/11/wKgJ9Frfu22CeLUWAEBhwnt8Mkw853.m4a\r\n孤寂深渊1-1-2$http://audio.xmcdn.com/group41/M04/C4/D8/wKgJ8lrfu0DDUIqeACNdMrdFcQo759.m4a\r\n孤寂深渊1-1-1$http://audio.xmcdn.com/group42/M09/11/20/wKgJ9FrWa_Wh_fWcAEXDY0Tp6ys581.m4a\r\n孤寂深渊----引子（拉德克拉利·霍尔著）$http://audio.xmcdn.com/group40/M06/50/6C/wKgJT1rP1bHTuIbWAAaagmYeUdo315.m4a', 'xml_8023', '3740', '', 'G', '', '1.0', 10, 0, 0, 0, 'gujishenyuan', ''),
(157, 17, 'Vanity Fair', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group37/M03/56/8F/wKgJoFpKIkWg6VZHAAF5uHAeDZY754.jpg', '', 1530072235, 7, 0, 0, 0, 0, 1, 1, 5, 8, 'ting', '', '34 vanity fair$http://audio.xmcdn.com/group44/M06/4A/3C/wKgKkVryb8LT_zkeAKCSYxyKSs4007.m4a\r\nVanity fair 33$http://audio.xmcdn.com/group39/M09/C9/87/wKgJn1rsL-Og5k3lAFxJ7-oHViI802.m4a\r\nVanity fair 32$http://audio.xmcdn.com/group29/M00/AF/A4/wKgJWVrr7HbCO-kDAKmEPgl1IPM650.m4a\r\nVanity fair 31$http://audio.xmcdn.com/group35/M05/15/BC/wKgJnVrpYLCzoNFtAG4t_Kyd5EY146.m4a\r\nVanity fair 30$http://audio.xmcdn.com/group28/M00/AC/A6/wKgJSFrpN66xmiusAG_HruhBzPc172.m4a\r\nVanity fair 29$http://audio.xmcdn.com/group30/M05/78/FB/wKgJWlrpM3ujVisbAF8uBfr2XGk227.m4a\r\nVanity fair 28$http://audio.xmcdn.com/group40/M09/E1/10/wKgJT1rkXjzy9tjbAIELq3IJxxE225.m4a\r\nVanity fair 27$http://audio.xmcdn.com/group40/M05/E1/92/wKgJVFrkWgSgwPrVAHUjMRz-bl4862.m4a\r\nVanity fair 26$http://audio.xmcdn.com/group41/M01/F9/2B/wKgJ8lrifj-jK1CJAGI4gPhhyMA064.m4a\r\nVanity fair 25$http://audio.xmcdn.com/group40/M0B/92/83/wKgJVFrgHRnCev80AGwBcnfUMSM330.m4a\r\nVanity fair 24$http://audio.xmcdn.com/group40/M06/8E/B7/wKgJT1rf9EvBs3PyAJ6zebY1qEA130.m4a\r\nVanity fair 23$http://audio.xmcdn.com/group40/M09/AA/BA/wKgJT1rHNhOBHQj0ANmU86iNlp0837.m4a\r\nVanity fair 22$http://audio.xmcdn.com/group41/M04/E5/17/wKgJ8lrHLcfQqidOAKOiVLJCS2I778.m4a\r\nVanity fair 21$http://audio.xmcdn.com/group42/M02/CD/D3/wKgJ81rGH4yiZGIGAMqw57VJEO8001.m4a\r\nVanity fair 20$http://audio.xmcdn.com/group42/M01/CF/97/wKgJ9FrGCxzz0KROAMmlpmk38EM111.m4a\r\nVanity fair 19$http://audio.xmcdn.com/group41/M02/CD/79/wKgJ8lrF-3HzfA3XAKrx6c1DGTo428.m4a\r\nVanity fair 18$http://audio.xmcdn.com/group41/M09/C9/D6/wKgJ8lrF08Hha01pAGl8zfSGlsc046.m4a\r\nVanity fair 17$http://audio.xmcdn.com/group42/M07/63/77/wKgJ81rAmX3Ry6nfAL4qlAv9K_I776.m4a\r\nVanity fair 16$http://audio.xmcdn.com/group39/M02/6D/5B/wKgJn1pwXCbwhdePATW-S5j9I9o258.m4a\r\nVanity fair 15$http://audio.xmcdn.com/group38/M05/6A/79/wKgJolpwS6rCbsnhAKa2OJD7xFg395.m4a\r\nVanity fair 14$http://audio.xmcdn.com/group39/M09/51/73/wKgJnlpvJaChGJGGAYMssbBMlnc129.m4a\r\nVanity fair 13$http://audio.xmcdn.com/group39/M04/21/38/wKgJn1ptkUTDbXHyASPuz8qdIwk038.m4a\r\nVanity fair 12$http://audio.xmcdn.com/group38/M05/17/5F/wKgJolptPbjTO_V8AIXP77mtYoc275.m4a\r\nVanity fair 11$http://audio.xmcdn.com/group28/M00/8F/E1/wKgJXFperUzxbNDFAWjM1CXrfW4473.m4a\r\nVanity fair 10$http://audio.xmcdn.com/group28/M05/8D/09/wKgJSFpd9NnD4kYJAMV2SDwNE9s594.m4a\r\nVanity fair 8$http://audio.xmcdn.com/group36/M01/A0/FE/wKgJTVpTF0yToYctAaTUAa2AF2Q597.m4a\r\nVanity fair 7$http://audio.xmcdn.com/group36/M0A/60/5F/wKgJTVpQV6mi591gAYhU0UTGF00031.m4a\r\nVanity fair 6$http://audio.xmcdn.com/group37/M07/DD/74/wKgJoVpQSbrREIwUAopuf_PmxmQ929.m4a\r\nVanity fair 5$http://audio.xmcdn.com/group37/M09/C3/99/wKgJoVpPGtzy64LgAeV3zN1R_zc579.m4a\r\nVanity fair 4$http://audio.xmcdn.com/group37/M09/A3/37/wKgJoFpNp0PQjlI3ASoguLulMqw727.m4a\r\nVanity fair 3$http://audio.xmcdn.com/group37/M07/A2/66/wKgJoFpNnbKREaEqAb7MV0rHBjA733.m4a\r\nVanity fair 2$http://audio.xmcdn.com/group36/M04/99/6F/wKgJUlpK4xyBZO_EAX_gVpYGYPg937.m4a\r\nVanity fair 1$http://audio.xmcdn.com/group36/M0B/D8/5F/wKgJTVpKI1riCsFRATpQpLOsbmQ378.m4a\r\nVanity fair 9$http://audio.xmcdn.com/group18/M02/EA/67/wKgJKlpb-zLyy_zGAOKzwry0RZs023.m4a', 'xml_8023', '3738', '', 'V', '', '1.0', 8, 0, 0, 0, 'VanityFair', ''),
(158, 17, '自闭症儿童公益朗读', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group44/M09/45/E5/wKgKjFryRuLR1hGNAAGmdv1f7LQ408.jpg', '', 1530072235, 5, 0, 0, 0, 0, 1, 1, 7, 8, 'ting', '', '第一一二夜：你好，很高兴认识你$http://audio.xmcdn.com/group43/M06/48/89/wKgKjVryV-ajRDqOAAzN1MWinRM388.m4a', 'xml_8023', '3739', '', 'Z', '', '1.0', 8, 0, 0, 0, 'zibizhengertonggongyilangdu', ''),
(159, 17, '重生之天才商女', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group38/M02/1A/EE/wKgJolpivHqy3gzxAAGy6X1rrMk062.jpg', '', 1530072235, 10, 0, 0, 0, 0, 1, 1, 1, 7, 'ting', '', '57$http://audio.xmcdn.com/group43/M03/47/7F/wKgKklryXrWj-A-DADJdJRam-cI342.m4a\r\n56$http://audio.xmcdn.com/group40/M05/F2/C5/wKgJT1rle4Cyvn5uACffYJ5lrjE924.m4a\r\n55$http://audio.xmcdn.com/group41/M06/0E/3D/wKgJ8lrjpb_zT0GmAC8CHn9wRzk371.m4a\r\n54$http://audio.xmcdn.com/group41/M09/FD/09/wKgJ8VritgmQzbCUACi7pALQgrc713.m4a\r\n53$http://audio.xmcdn.com/group40/M04/8C/4A/wKgJT1rfyxnDbzf7AC0nzUfljtY074.m4a\r\n说明$http://audio.xmcdn.com/group40/M09/F8/67/wKgJVFrYOITCSTVXAAJ6ppttUp0741.m4a\r\n52$http://audio.xmcdn.com/group42/M08/F6/51/wKgJ81q5_JjibjtFAEwFcuvCZaM449.m4a\r\n51$http://audio.xmcdn.com/group41/M01/F5/1E/wKgJ8Vq5-VWTAoOuAFuYQUEieqc378.m4a\r\n50$http://audio.xmcdn.com/group40/M0B/4C/DA/wKgJT1qy_PKx2AO2AGU-KZC70QU271.m4a\r\n49$http://audio.xmcdn.com/group41/M02/85/7D/wKgJ8Vqy-5qhIrYuAE1usDWtuJc095.m4a\r\n我靠，怎么会这样？$http://audio.xmcdn.com/group41/M00/5B/90/wKgJ8lqwf42DNi_kAE2mfsiJPVI741.m4a\r\n48$http://audio.xmcdn.com/group40/M02/20/2F/wKgJT1qwf27hsbBhAExXr3jokkk710.m4a\r\n47$http://audio.xmcdn.com/group40/M02/20/2B/wKgJT1qwf1mjyOIyAEzzWdRUIxM721.m4a\r\n声明一下$http://audio.xmcdn.com/group41/M05/CA/49/wKgJ8VqobQqzCwOfAAQLi3OMgZg343.m4a\r\n46$http://audio.xmcdn.com/group41/M05/CA/4A/wKgJ8VqobQyAEQuDACL5VrtUsGU719.m4a\r\n45$http://audio.xmcdn.com/group40/M05/92/8F/wKgJVFqobPuRDn0MAEuo8fcEO84418.m4a\r\n44$http://audio.xmcdn.com/group42/M01/CB/A3/wKgJ81qobMqikmPEABoWu3gi57k774.m4a\r\n真相$http://audio.xmcdn.com/group42/M02/0E/1B/wKgJ81qeLC-BiM5nAFIFlZ2ORQ0458.m4a\r\n见父母$http://audio.xmcdn.com/group42/M09/0C/BF/wKgJ9FqeKPnzwSUKAEpEdfRb-QA833.m4a\r\n缠绵二$http://audio.xmcdn.com/group41/M03/0C/67/wKgJ8VqeJhHiWJzrAEqt19Ddjc8330.m4a\r\n缠绵一$http://audio.xmcdn.com/group42/M05/0D/3E/wKgJ81qeIpahIRMjAEtGja9BUus323.m4a\r\n亲密无间$http://audio.xmcdn.com/group41/M03/B7/6D/wKgJ8VqajHGxzUUoADQwHOgz1No272.m4a\r\n恢复肉身$http://audio.xmcdn.com/group41/M03/BA/BD/wKgJ8lqajGGzocRnAEugJLFRbQk675.m4a\r\n重生之天才商女$http://audio.xmcdn.com/group41/M03/B7/63/wKgJ8VqajEqhsUVFAEsJUjdrMzU085.m4a\r\n36$http://audio.xmcdn.com/group32/M08/B3/40/wKgJS1qSeNrzsu83AEhNAdpE1RE923.m4a\r\n35$http://audio.xmcdn.com/group37/M0A/73/7D/wKgJoFqQ2LvTnrcUAD-hDDZ53P4545.m4a\r\n34$http://audio.xmcdn.com/group29/M0A/99/BF/wKgJWVqN_8uRrZLaAENbNe-0k4k656.m4a\r\n33$http://audio.xmcdn.com/group31/M0B/33/B5/wKgJX1qNSNLT9fqgAE5wteDy7q0232.m4a\r\n32$http://audio.xmcdn.com/group22/M00/1A/D0/wKgJLlqLjJ-iJ-ZwAFpbLs_CHc4696.m4a\r\n31$http://audio.xmcdn.com/group39/M0A/A1/EB/wKgJnlqI-rbALQrsACkQTdX00lQ033.m4a\r\n31$http://audio.xmcdn.com/group39/M0A/A1/E8/wKgJnlqI-qbAi_EpACYfg2k2eoA233.m4a\r\n30（新年快乐）$http://audio.xmcdn.com/group38/M03/68/15/wKgJo1qFH4uSKoz0AFfqi1tW53k149.m4a\r\n28$http://audio.xmcdn.com/group39/M04/2E/AB/wKgJn1qCT7LBgZLaAFjOS7ENlr4523.m4a\r\n27$http://audio.xmcdn.com/group39/M0B/EB/62/wKgJn1p_meezIbbkAB2jvqUh6oE615.m4a\r\n没想到吧$http://audio.xmcdn.com/group38/M07/8B/23/wKgJo1p7yOPhXprvAASCf4mCmd0440.m4a\r\n26$http://audio.xmcdn.com/group38/M04/8A/F9/wKgJolp7yCGjuxWgADHpI7P0l_k578.m4a\r\n25$http://audio.xmcdn.com/group38/M0B/8B/08/wKgJo1p7yBDgv-e6ABtlb_Ax-3Q292.m4a\r\n24$http://audio.xmcdn.com/group38/M09/68/5F/wKgJolp6dXSgF9bSADSucMvYwSM080.m4a\r\n23$http://audio.xmcdn.com/group38/M02/44/8A/wKgJolp5EcrwajOOAAxi9rvWWlM637.m4a\r\n22$http://audio.xmcdn.com/group38/M08/1E/44/wKgJolp3lLiwrpi1AB-HujgDbjs437.m4a\r\n21$http://audio.xmcdn.com/group39/M08/1E/E1/wKgJn1p3lHjg1xjbACLZ7iR-4W4962.m4a\r\n20$http://audio.xmcdn.com/group38/M01/DB/45/wKgJo1p1AYjT8ghAACj690HGCfI568.m4a\r\n19$http://audio.xmcdn.com/group39/M03/DB/A5/wKgJnlp0-sjxFqLHAC-iLhiu1K8977.m4a\r\n18$http://audio.xmcdn.com/group39/M0A/A5/DB/wKgJn1pyvTeAeG2hAC_7wCubV1E936.m4a\r\n17$http://audio.xmcdn.com/group39/M0A/A5/D8/wKgJn1pyvSaiYHbyABXEngUxNcc263.m4a\r\n17$http://audio.xmcdn.com/group38/M0B/A5/47/wKgJo1pyuhODWh3QABc3FZGVvkw952.m4a\r\n16$http://audio.xmcdn.com/group39/M03/A5/8E/wKgJn1pyugvhRoTRACKmEmeLSiY357.m4a\r\n15$http://audio.xmcdn.com/group38/M05/7B/B1/wKgJo1pw-7CzQa10ABqa5HDklNU092.m4a\r\n14$http://audio.xmcdn.com/group38/M05/7B/76/wKgJolpw-56BiidaABwutJzkyjY082.m4a\r\n13$http://audio.xmcdn.com/group39/M07/7C/62/wKgJnlpw-4SyBUjRABT3j-l7hbk188.m4a\r\n12$http://audio.xmcdn.com/group39/M06/62/76/wKgJn1pv_RzjrtGuAB57wUcCvf4207.m4a\r\n更新说明$http://audio.xmcdn.com/group38/M0B/61/E7/wKgJolpv_QejyRw3AAHX6IHH734473.m4a\r\n11$http://audio.xmcdn.com/group38/M02/45/7A/wKgJo1pu2-ygX9qOACdhGSnugAg129.m4a\r\n10$http://audio.xmcdn.com/group39/M04/12/F5/wKgJn1ptA6uwKLTqACMutTOAVNU907.m4a\r\n10$http://audio.xmcdn.com/group39/M04/12/F3/wKgJn1ptA5mzm1r-ABAFn8KsaV4203.m4a\r\n9$http://audio.xmcdn.com/group38/M03/FE/C2/wKgJo1psLr7SD_jCABVVNYxk9DQ856.m4a\r\n8$http://audio.xmcdn.com/group39/M05/D7/C9/wKgJnlpqbl2Sygp-ACKM5zMlvOA347.m4a\r\n7$http://audio.xmcdn.com/group38/M01/B8/0B/wKgJolppKGLx1SrrADXT6hpn0hQ556.m4a\r\n6$http://audio.xmcdn.com/group38/M05/9C/0E/wKgJolpn-ImBgmBlAC4d8azTTnk458.m4a\r\n5$http://audio.xmcdn.com/group38/M07/74/02/wKgJolpmfeGyUgRvADNHMfWaqes226.m4a\r\n4$http://audio.xmcdn.com/group38/M05/44/7E/wKgJo1pkbiWggP7fACu7SUc-9kc322.m4a\r\n3$http://audio.xmcdn.com/group39/M07/44/CC/wKgJn1pkbgaQr0neAC-K42sPld0829.m4a\r\n2$http://audio.xmcdn.com/group38/M00/1A/F7/wKgJolpivQGBGyWYAC4I9eVKF7E755.m4a\r\n1重生$http://audio.xmcdn.com/group39/M04/1B/0D/wKgJn1pivKCzBKOeACUQ2P1ef5M091.m4a\r\n29$http://audio.xmcdn.com/group39/M02/4F/8B/wKgJn1qD0RvQQ1xmAEtopsvbWYU559.m4a', 'xml_8023', '3737', '', 'Z', '', '1.0', 4, 0, 0, 0, 'zhongshengzhitiancaishangnv', ''),
(160, 17, '西游记', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group42/M04/B5/AD/wKgJ81rfHJ_SiEXiAAIS5yB15VI076.jpg', '', 1530072235, 10, 0, 0, 0, 0, 1, 1, 4, 9, 'ting', '', '偷吃人参果$http://audio.xmcdn.com/group44/M01/55/1D/wKgKkVry0sagFFfLADoOgFKX1xo421.m4a\r\n猪八戒娶亲$http://audio.xmcdn.com/group43/M07/55/45/wKgKjVry0KGRWQ-YAD2cvvCPZ3A850.m4a\r\n沙和尚拜师$http://audio.xmcdn.com/group41/M02/20/3F/wKgJ8VrkjuXQbteXAB4KfIPNZ3U293.m4a\r\n妙手治八戒$http://audio.xmcdn.com/group42/M01/20/2E/wKgJ9FrkhOHTyTtrAC5CuaqYL2c475.m4a\r\n妙手治八戒$http://audio.xmcdn.com/group42/M01/20/28/wKgJ9FrkhNOjCxWWAC5CuZXXHG0193.m4a\r\n黄风洞除魔$http://audio.xmcdn.com/group41/M09/1F/1D/wKgJ8VrkhMXxUHk3AD3e1AgzcAY169.m4a\r\n智灭黑风怪$http://audio.xmcdn.com/group42/M08/15/AA/wKgJ81rkTqXwBFWoACHsnnTbcTA972.m4a\r\n斗宝失袈裟$http://audio.xmcdn.com/group41/M08/EC/D4/wKgJ8lrhxRaSvEqyACyK4ZSZY24310.m4a\r\n降伏白龙马$http://audio.xmcdn.com/group42/M09/ED/C6/wKgJ9Frhw1fg3jgoABuEX8EA_9A050.m4a\r\n从师取真经$http://audio.xmcdn.com/group41/M01/EC/66/wKgJ8VrhwlXDYiW3AFjUwzSc6e0412.m4a\r\n被困五行山$http://audio.xmcdn.com/group40/M09/9A/60/wKgJVFrgb2eTqfcwADMKbTc3CmU612.m4a\r\n大圣闹天宫$http://audio.xmcdn.com/group41/M0A/D2/95/wKgJ8lrgbaGxjJxmADA8W5FJSRY264.m4a\r\n借宝闯龙宫$http://audio.xmcdn.com/group40/M03/98/D7/wKgJT1rga5rBcspKAD4PSPwr64Q043.m4a\r\n学艺拜祖师$http://audio.xmcdn.com/group40/M08/96/75/wKgJVFrgTwOzMeRPAC-pg-DOBv0615.m4a\r\n美猴王出世$http://audio.xmcdn.com/group42/M03/B5/EF/wKgJ81rfHfORxOhuABpHL29u9Fw245.m4a', 'xml_8023', '3707', '', 'X', '', '1.0', 7, 0, 0, 0, 'xiyouji', ''),
(161, 17, '安小愈原创文章', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group44/M01/4C/09/wKgKjFryg-egB1dGAAEJ5r12oUI846.jpg', '', 1530072235, 4, 0, 0, 0, 0, 1, 1, 4, 9, 'ting', '', '请珍惜那个逗你笑的人$http://audio.xmcdn.com/group44/M00/4A/D7/wKgKkVrydpDAX0f3ACAxJKP1_sc191.m4a\r\n谁明寸草心$http://audio.xmcdn.com/group44/M07/49/F7/wKgKkVrybObSvM-_ACPmAxs6ib0433.m4a', 'xml_8023', '3735', '', 'A', '', '1.0', 10, 0, 0, 0, 'anxiaoyuyuanchuangwenzhang', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(162, 17, '全能小农民', '', '未知', '', '', '', '主播个人微信：kandahai114 微信公众平台： 胖天鹅工作室主播个人微信：kandahai114 微信公众平台： 胖天鹅工作室主播个人微信：kandahai114 微信公众平台： 胖天鹅工作室', 'http://imagev2.xmcdn.com/group36/M08/87/B1/wKgJTVpR8M2hZLaJAAEff4c-oWQ147.jpg', '', 1530072235, 0, 0, 0, 0, 0, 1, 1, 1, 2, 'ting', '', '第1章 中奖了$http://audio.xmcdn.com/group28/M09/AF/B6/wKgJSFrq3QKBFUaRAE993GUbjZ8321.m4a\r\n第2章 一碗炝锅面$http://audio.xmcdn.com/group28/M09/AF/BD/wKgJSFrq3RqAAx1GAFBurQFGHaU694.m4a\r\n第3章 接下挑战$http://audio.xmcdn.com/group44/M0A/29/05/wKgKkVrxQbeBeSDGAF5NWuIxBnM132.m4a\r\n第4章 好人好事$http://audio.xmcdn.com/group43/M08/27/EE/wKgKklrxQd7yUW7PAFzeP_FxnT0781.m4a\r\n第5章 武道系统$http://audio.xmcdn.com/group44/M05/28/91/wKgKjFrxQiSzueWtAF8KyDbDUCM598.m4a\r\n第6章 合租$http://audio.xmcdn.com/group44/M05/29/0F/wKgKkVrxQjqRMfksAFneQtdAqzs620.m4a\r\n第7章 哲学问题$http://audio.xmcdn.com/group43/M02/29/B5/wKgKjVrxQlmCw79yAFyTW9oBmA0944.m4a\r\n第8章 看山看水$http://audio.xmcdn.com/group43/M02/27/FF/wKgKklrxQnOQV-xsAF6MfmeGLeU272.m4a\r\n第9章 何为兄弟$http://audio.xmcdn.com/group44/M09/28/99/wKgKjFrxQoOBOCKgAFqXReeL_HY878.m4a\r\n第10章 可怕的刀工$http://audio.xmcdn.com/group44/M09/29/16/wKgKkVrxQpfhKZfWAFl0iXSLWVo035.m4a\r\n第11章 意外$http://audio.xmcdn.com/group43/M0B/2A/6D/wKgKjVrxShOzT_U2AFy1ICBrzSk416.m4a\r\n第12章 不认输$http://audio.xmcdn.com/group43/M0B/28/B6/wKgKklrxSimA7NU7AF4YgL5c5Rg572.m4a\r\n第13章 浴火而生$http://audio.xmcdn.com/group44/M09/29/C7/wKgKkVrxSl7Qr8J0AGCwOv5M4eg337.m4a\r\n第14章 理想是星辰大海$http://audio.xmcdn.com/group44/M09/29/4F/wKgKjFrxSmjRZBRvAF4HE8RUsLE280.m4a\r\n第15章 良俗恶俗$http://audio.xmcdn.com/group43/M08/2A/79/wKgKjVrxSoXQlhh9AFglurDb0f0680.m4a\r\n第16章 捡漏$http://audio.xmcdn.com/group43/M08/28/BF/wKgKklrxSpfh_Y3eAF3ZWIOCd5U304.m4a\r\n第17章 以身相许$http://audio.xmcdn.com/group43/M08/28/C2/wKgKklrxSq2DnKUWAFhq9sxCMvU974.m4a\r\n第18章 买三送一童叟无欺$http://audio.xmcdn.com/group44/M08/29/57/wKgKjFrxSsejWXoaAF7Rg5_KA34324.m4a\r\n第19章 搬家$http://audio.xmcdn.com/group44/M08/29/5C/wKgKjFrxSt7SFOHyAFyDNJNDSpo978.m4a\r\n第20章 新租的房子$http://audio.xmcdn.com/group43/M04/28/C6/wKgKklrxSwGSZbFJAFyfG3cgIeE338.m4a\r\n第21章 谁侵犯谁$http://audio.xmcdn.com/group43/M07/2A/8E/wKgKjVrxS3nR4w2kAFzLKaP-ci4715.m4a\r\n第22章 冰火两重天$http://audio.xmcdn.com/group44/M04/29/EA/wKgKkVrxS6_yIM4_AFz7nYflqtg913.m4a\r\n第23章 不管我的事$http://audio.xmcdn.com/group43/M00/2A/9D/wKgKjVrxS_aiyKhuAFyU09UdyXY233.m4a\r\n第24章 道可道$http://audio.xmcdn.com/group44/M03/29/80/wKgKjFrxTDqTKjOZAFh38xF0ovY128.m4a\r\n第25章 杨柳儿$http://audio.xmcdn.com/group43/M03/2A/A8/wKgKjVrxTGvQAg6-AFuysRd2PDA051.m4a\r\n第26章 罗传水$http://audio.xmcdn.com/group44/M06/29/8A/wKgKjFrxTKrSxk5yAFnlmMLRV5M647.m4a\r\n第27章 互怼$http://audio.xmcdn.com/group43/M02/2A/B4/wKgKjVrxTOOTeoY9AFpbERfI5AE597.m4a\r\n第28章 轻，太轻$http://audio.xmcdn.com/group43/M02/2A/BB/wKgKjVrxTQaCXeYMAFvV7TZc9zk664.m4a\r\n第29章 一环，你比二环少一环$http://audio.xmcdn.com/group43/M0A/28/FE/wKgKklrxTUrR2phPAF413iUtVzQ343.m4a\r\n第30章 飞机与打飞机$http://audio.xmcdn.com/group44/M05/29/9F/wKgKjFrxTYmhmcaBAF6Pp0IcQeY345.m4a\r\n第31章 高明的控弦技$http://audio.xmcdn.com/group43/M0B/29/08/wKgKklrxTcGif6sCAFnGwvT3Lyo198.m4a\r\n第32章 东西还在$http://audio.xmcdn.com/group44/M02/2A/26/wKgKkVrxTgiAa9S2AFygkwS7EVI805.m4a\r\n第33章 钓鱼$http://audio.xmcdn.com/group43/M06/2A/D7/wKgKjVrxTk2RYijPAFyatbKWcUo774.m4a\r\n第34章 佛曰$http://audio.xmcdn.com/group44/M01/29/BA/wKgKjFrxTomj0UCYAF3a0AH8bIE311.m4a\r\n第35章 以血还血$http://audio.xmcdn.com/group43/M05/29/26/wKgKklrxTsXDF63FAF1g8EWwRZ0402.m4a\r\n第36章 姑娘报仇$http://audio.xmcdn.com/group43/M09/29/32/wKgKklrxTwiBni1GAFzZ2PdU3W4407.m4a\r\n第37章 变化$http://audio.xmcdn.com/group44/M00/29/CA/wKgKjFrxT0yBzzFEAGRQRzBHykg077.m4a\r\n第38章 人不可数典忘祖$http://audio.xmcdn.com/group43/M08/2A/FC/wKgKjVrxT5OjdNBYAF9UNEqhlPY751.m4a\r\n第39章 找上门来$http://audio.xmcdn.com/group43/M0B/29/43/wKgKklrxT-CRDf4BAGOwNw_SESk661.m4a\r\n第40章 一个神奇的厨子$http://audio.xmcdn.com/group44/M0B/29/DB/wKgKjFrxUBPTVHY7AF3bBpGntSI914.m4a\r\n第41章 势如破竹$http://audio.xmcdn.com/group43/M07/29/4E/wKgKklrxUGSB8OpuAF4IVcvnqNU573.m4a\r\n第42章 霍佳佳的男朋友$http://audio.xmcdn.com/group44/M0A/2A/65/wKgKkVrxUKOgsMyDAGG3FGxMjLY075.m4a\r\n第43章 为了我不怕，打断你的腿$http://audio.xmcdn.com/group43/M03/29/5A/wKgKklrxUOLgTwXqAF4LSAxzJp4386.m4a\r\n第44章 非分之想$http://audio.xmcdn.com/group44/M09/29/FD/wKgKjFrxUS2QazFJAF7ES4ZZvAM942.m4a\r\n第45章 房产证$http://audio.xmcdn.com/group43/M0B/29/65/wKgKklrxUVTTGWssAF6ihmegEo4553.m4a\r\n第46章 买卖与仁义$http://audio.xmcdn.com/group43/M0B/29/67/wKgKklrxUV7xHmA3AGMmMCIHCKE174.m4a\r\n第47章 天宝斋资深清洁工$http://audio.xmcdn.com/group44/M08/2A/79/wKgKkVrxUXvzmbgtAF_p-wPBugA046.m4a\r\n第48章 御人之道$http://audio.xmcdn.com/group44/M08/2A/7E/wKgKkVrxUZXT8k3ZAGA6waJvLxM498.m4a\r\n第49章 新店员上班班$http://audio.xmcdn.com/group44/M08/2A/81/wKgKkVrxUabgiy4EAGMXgSEduZ0540.m4a\r\n第50章 万八$http://audio.xmcdn.com/group44/M08/2A/0E/wKgKjFrxUbXDzNWdAF2KDl0KIgQ896.m4a\r\n第51章 羊肉串$http://audio.xmcdn.com/group44/M01/2C/18/wKgKjFrxZbuyrDjRAF20pCR0wlI042.m4a\r\n第52章 试试刹车$http://audio.xmcdn.com/group44/M01/2C/1B/wKgKjFrxZczSixDTAFqgFkI-7To841.m4a\r\n第53章 一坑变俩坑$http://audio.xmcdn.com/group44/M04/2C/7D/wKgKkVrxZdux5cX6AFxRScIFElQ058.m4a\r\n第54章 交利息$http://audio.xmcdn.com/group43/M00/2D/2D/wKgKjVrxZeSDuBbfAGORYVFtNBw846.m4a\r\n第55章 如是我闻$http://audio.xmcdn.com/group43/M00/2B/7A/wKgKklrxZgewW2jYAGBFBQF3IeE220.m4a\r\n第56章 惊魂$http://audio.xmcdn.com/group43/M00/2B/7A/wKgKklrxZgvw8SRRAGJJ7M3jCKc347.m4a\r\n第57章 审问$http://audio.xmcdn.com/group43/M00/2D/38/wKgKjVrxZhXjaY_DAF7OyoUM5fA111.m4a\r\n第58章 钱多多的铜钱$http://audio.xmcdn.com/group44/M03/2C/25/wKgKjFrxZijyJOClAFvr9opA-JE077.m4a\r\n第59章 白水城厨艺大赛$http://audio.xmcdn.com/group44/M05/2C/86/wKgKkVrxZjbBgKwMAGJRePkkH4o131.m4a\r\n第60章 酱油二人组$http://audio.xmcdn.com/group43/M03/2B/7F/wKgKklrxZkazKqTPAFmDOC-RtWU770.m4a\r\n第61章 第一轮$http://audio.xmcdn.com/group44/M02/2C/8B/wKgKkVrxZmbwx4dOAF-ZOsdS084284.m4a\r\n第62章 意外？$http://audio.xmcdn.com/group43/M04/2D/41/wKgKjVrxZoezkqDcAGKVBlvWfsU526.m4a\r\n第63章 意外！$http://audio.xmcdn.com/group43/M07/2D/44/wKgKjVrxZpqQG7kqAGI8taBatoE674.m4a\r\n第64章 补天系统与现实$http://audio.xmcdn.com/group44/M07/2C/35/wKgKjFrxZqrjoqNqAFs9baZtMLk268.m4a\r\n第65章 换菜$http://audio.xmcdn.com/group43/M07/2D/45/wKgKjVrxZrmAeSvxAF4VjU4EURE095.m4a\r\n第66章 才怪$http://audio.xmcdn.com/group43/M07/2D/49/wKgKjVrxZsrgjH35AGA_J5HRe78993.m4a\r\n第67章 下注$http://audio.xmcdn.com/group43/M02/2D/4C/wKgKjVrxZtfjEUQXAGAx8JL5VLU743.m4a\r\n第68章 土豆卑微亦有梦想$http://audio.xmcdn.com/group44/M00/2C/3D/wKgKjFrxZvCARMCoAIKbFDNgNQk005.m4a\r\n第69章 冠军感言$http://audio.xmcdn.com/group44/M0A/2C/3F/wKgKjFrxZxXxuRzVAE5FFjNATUk067.m4a\r\n第70章 我会生气呀$http://audio.xmcdn.com/group44/M0A/2C/40/wKgKjFrxZxzCT_QQAGeGmYhKJ9I957.m4a\r\n第71章 周超$http://audio.xmcdn.com/group44/M0A/2C/A4/wKgKkVrxZyqR8DqDAFlHA7STgPc077.m4a\r\n第72章 谓我何求$http://audio.xmcdn.com/group43/M0B/2B/99/wKgKklrxZzjR44TPAF0WDLg_Tpo189.m4a\r\n第73章 初醒$http://audio.xmcdn.com/group43/M01/2B/A0/wKgKklrxZ3HiW4MeAGNg7cWABR4737.m4a\r\n第74章 加注$http://audio.xmcdn.com/group43/M07/2B/AA/wKgKklrxZ7XCvm6BAGPAlGcRSiY732.m4a\r\n第75章 听力太好$http://audio.xmcdn.com/group43/M08/2B/B1/wKgKklrxZ_ChsqXMAFX0ysjCULA134.m4a\r\n第76章 恐怖的三四五$http://audio.xmcdn.com/group43/M09/2B/B7/wKgKklrxaCXD0mUCAFBbl7a4Fbc676.m4a\r\n第77章 震荡加速箭$http://audio.xmcdn.com/group43/M04/2D/7D/wKgKjVrxaG7CV_6jAGRDD7sGqGk459.m4a\r\n第78章 我有一箭$http://audio.xmcdn.com/group44/M04/2C/6E/wKgKjFrxaIaQbPufAEuxwpXuTxM776.m4a\r\n第79章 讨价还价$http://audio.xmcdn.com/group43/M02/2B/C7/wKgKklrxaKvAwWBUAGP1PMYUNLM362.m4a\r\n第80章 大家都很疼$http://audio.xmcdn.com/group44/M03/2C/D4/wKgKkVrxaPGRrcgzAFxCmS4GP4Y936.m4a\r\n第81章 如何谈恋爱$http://audio.xmcdn.com/group43/M03/2B/D8/wKgKklrxaTeyWybVAGGig95PzoM037.m4a\r\n第82章 霍佳佳的鉴宝技$http://audio.xmcdn.com/group44/M07/2C/E9/wKgKkVrxaYPRPvi8AG8F2US7Zec074.m4a\r\n第83章 向日葵$http://audio.xmcdn.com/group43/M01/2D/A4/wKgKjVrxacjycCKwAGld97EspnQ178.m4a\r\n第84章 你若需要$http://audio.xmcdn.com/group43/M07/2B/EE/wKgKklrxagXShcB9AFiLDQJYdJo192.m4a\r\n第85章 纵死无悔$http://audio.xmcdn.com/group43/M00/2B/F9/wKgKklrxalaBCp3bAGK97rd7jvs550.m4a\r\n第86章 迷路$http://audio.xmcdn.com/group44/M02/2D/0D/wKgKkVrxap3xELJ6AGPVJe_ZcQw335.m4a\r\n第87章 收收收$http://audio.xmcdn.com/group43/M0B/2D/C2/wKgKjVrxatHj_XLzAFGFrRlQckM057.m4a\r\n第88章 锅盖$http://audio.xmcdn.com/group44/M04/2D/15/wKgKkVrxaxWhkXqSAF1DkZ19AYA778.m4a\r\n第89章 真的姓花$http://audio.xmcdn.com/group43/M06/2C/16/wKgKklrxa1STxVfwAFDCYUEzW9M783.m4a\r\n第90章 我们的愿望$http://audio.xmcdn.com/group43/M06/2C/1A/wKgKklrxa2ixBKTyAGOEKdUD5tI403.m4a\r\n第91章 需要学习的还很多$http://audio.xmcdn.com/group43/M06/2D/DA/wKgKjVrxa3iSeRGxAFpVM3gEDGo958.m4a\r\n第92章 奇特的圆盖$http://audio.xmcdn.com/group44/M01/2D/20/wKgKkVrxa4eTthr-AFgy8k-WuW4078.m4a\r\n第93章 可怜的姐弟$http://audio.xmcdn.com/group43/M09/2C/21/wKgKklrxa6uS1RyCAFzDz_ZWzMQ885.m4a\r\n第94章 大生意$http://audio.xmcdn.com/group43/M09/2D/DD/wKgKjVrxa6yBf1ECAFq2H0DETKE671.m4a\r\n第95章 看到了不该看的$http://audio.xmcdn.com/group44/M03/2D/28/wKgKkVrxa8DQev7DAF8Nt5tVEm0004.m4a\r\n第96章 一副假画$http://audio.xmcdn.com/group44/M03/2D/2B/wKgKkVrxa9CQZIdwAF_D0Fp9ESY519.m4a\r\n第97章 打折还是打折$http://audio.xmcdn.com/group43/M0B/2C/26/wKgKklrxa-Hik7oOAGlYGd4SDLM338.m4a\r\n第98章 灵魂交流$http://audio.xmcdn.com/group43/M0B/2C/28/wKgKklrxa-ngFxDIAFCji0divJQ535.m4a\r\n第99章 大竹片子$http://audio.xmcdn.com/group44/M00/2C/D5/wKgKjFrxbBuwUHTTAFrzy4ChXrk987.m4a\r\n第100章 卖门票计划$http://audio.xmcdn.com/group43/M07/2C/36/wKgKklrxbGGxp9zsAGNlU72pWbc954.m4a\r\n第101章 奇特的碧玉镯$http://audio.xmcdn.com/group44/M03/2D/8D/wKgKkVrxbyWBjCiiAGKzpmtzcW4047.m4a\r\n第102章 何以致契阔$http://audio.xmcdn.com/group44/M04/2D/93/wKgKkVrxb0HSCTocAFpZmplInRU654.m4a\r\n第103章 舞蹈班$http://audio.xmcdn.com/group43/M01/2C/92/wKgKklrxb2LS53ylAGAfENyKUBU293.m4a\r\n第104章 超越博尔特$http://audio.xmcdn.com/group43/M01/2C/96/wKgKklrxb3CTF_HPAGWvcq68p1U805.m4a\r\n第105章 泰北娱乐$http://audio.xmcdn.com/group43/M01/2C/98/wKgKklrxb3rB_d5FAF1CGmkZ7UE706.m4a\r\n第106章 一个老道$http://audio.xmcdn.com/group44/M02/2D/37/wKgKjFrxb4zALam7AGGm7jwIdzQ090.m4a\r\n第107章 假把式$http://audio.xmcdn.com/group44/M02/2D/38/wKgKjFrxb5DhoCnTAF3vYRoy_DE769.m4a\r\n第108章 一点嫣红暗去无$http://audio.xmcdn.com/group43/M02/2C/9A/wKgKklrxb6SQjNTgAF3vYcpmhss673.m4a\r\n第109章 虎头蛇尾$http://audio.xmcdn.com/group43/M02/2E/59/wKgKjVrxb6jTyCKSAF2hixxcEOQ934.m4a\r\n第110章 栽赃陷害$http://audio.xmcdn.com/group43/M02/2C/9E/wKgKklrxb7PBc-ynAFvHPjEJFW4560.m4a\r\n第111章 人生事，身不由己$http://audio.xmcdn.com/group44/M06/2D/A0/wKgKkVrxb8Ty38WAAF9-ylvq_Xg716.m4a\r\n第112章 十字一用$http://audio.xmcdn.com/group43/M00/2E/5F/wKgKjVrxb-qDdH5sAF4qHjfA3bI975.m4a\r\n第113章 要有梦想$http://audio.xmcdn.com/group43/M00/2E/5D/wKgKjVrxb96BP9AIAFz3bA8tbmM069.m4a\r\n第114章 被坑了$http://audio.xmcdn.com/group43/M00/2C/A2/wKgKklrxb-zyh1V0AFyTWxCPGdQ604.m4a\r\n第115章 风起于青萍之末$http://audio.xmcdn.com/group43/M00/2C/A4/wKgKklrxb_XDyE0NAFh8XmYv2qM786.m4a\r\n第116章 龙尚天之死$http://audio.xmcdn.com/group44/M08/2D/A5/wKgKkVrxcAHh3cvBAFd-UW9_lzw719.m4a\r\n第117章 彪悍的小枚$http://audio.xmcdn.com/group44/M08/2D/4A/wKgKjFrxcA2TCq7sAF7h4B_5JDM497.m4a\r\n第118章 坐镇$http://audio.xmcdn.com/group43/M08/2E/64/wKgKjVrxcBnwaDO2AF4-4TgKX3w223.m4a\r\n第119章 三人行必有一死$http://audio.xmcdn.com/group43/M08/2E/68/wKgKjVrxcCeRSbjMAFsxd2Vr0f0759.m4a\r\n第120章 养狗为患$http://audio.xmcdn.com/group44/M01/2D/4E/wKgKjFrxcDbA67BmAGOdIaQ-zLg657.m4a\r\n第121章 刀来$http://audio.xmcdn.com/group44/M01/2D/4F/wKgKjFrxcD-RGkE2AF60Jb9X2nE657.m4a\r\n第122章 明月山岗$http://audio.xmcdn.com/group44/M01/2D/52/wKgKjFrxcEnAmms1AFL8I12L_EI691.m4a\r\n第123章 箭与命$http://audio.xmcdn.com/group44/M09/2D/56/wKgKjFrxcICCtrFVAFtsNK5kBOU615.m4a\r\n第124章 签字$http://audio.xmcdn.com/group44/M0B/2D/BF/wKgKkVrxcMXQd8AzAGc7ttzpzo4118.m4a\r\n第125章 不是泰迪$http://audio.xmcdn.com/group44/M05/2D/C7/wKgKkVrxcP_DXZr2AFpoSS53aHc826.m4a\r\n第126章 茶叶来二斤$http://audio.xmcdn.com/group43/M03/2C/CD/wKgKklrxcU2DW9yEAGHzSYadfC0979.m4a\r\n第127章 学习要认真$http://audio.xmcdn.com/group43/M08/2E/91/wKgKjVrxcYmi2iDzAGIrFkrchqA285.m4a\r\n第128章 天理何在$http://audio.xmcdn.com/group43/M00/2C/DB/wKgKklrxccKiS_HoAFzipXXePQc342.m4a\r\n第129章 不疯魔不成活$http://audio.xmcdn.com/group44/M00/2D/E2/wKgKkVrxcfThG8lJAF1N2hV_lXY007.m4a\r\n第130章 看着我$http://audio.xmcdn.com/group44/M02/2D/E5/wKgKkVrxciCQiCwfAF0tjaC3-9Q147.m4a\r\n第131章 进去躲躲$http://audio.xmcdn.com/group44/M04/2D/EC/wKgKkVrxclThh4t2AF52eS68Pxg659.m4a\r\n第132章 聊天也是一种力量$http://audio.xmcdn.com/group43/M0B/2E/AF/wKgKjVrxcoOgoJq6AGC7-z4D6J4771.m4a\r\n第133章 三不政策$http://audio.xmcdn.com/group43/M08/2E/B8/wKgKjVrxcsuAb099AF_OFHzkBZM000.m4a\r\n第134章 寸舌退强敌$http://audio.xmcdn.com/group43/M03/2E/BF/wKgKjVrxcwXiyvfOAFkmsgZvxxo239.m4a\r\n第135章 谁向着谁$http://audio.xmcdn.com/group44/M06/2E/0B/wKgKkVrxc0uzlzI8AGI5xvTxWBY545.m4a\r\n第136章 千灯，去休$http://audio.xmcdn.com/group44/M03/2D/B4/wKgKjFrxc5OhTQuFAGKvdVvCYck303.m4a\r\n第137章 少儿不宜$http://audio.xmcdn.com/group43/M00/2E/D1/wKgKjVrxc6jRHpx9AFoY_yjs3k0581.m4a\r\n第138章 治病$http://audio.xmcdn.com/group44/M05/2D/B8/wKgKjFrxc8qRtBmIAGDGP_dD8ZQ505.m4a\r\n第139章 眉来不眼去$http://audio.xmcdn.com/group44/M09/2E/21/wKgKkVrxc__Ru5bnAGdde8wOCYY995.m4a\r\n第140章 如来神掌有没有$http://audio.xmcdn.com/group43/M0A/2E/DC/wKgKjVrxdBXgAirtAFn4sTleE7A855.m4a\r\n第141章 手法不够纯熟$http://audio.xmcdn.com/group43/M0A/2D/25/wKgKklrxdC_gMYwKAGCLgo47EKI611.m4a\r\n第142章 董小姐$http://audio.xmcdn.com/group44/M02/2D/C7/wKgKjFrxdHGB2iSrAF6rWMHEvvw072.m4a\r\n第143章 上好茶$http://audio.xmcdn.com/group43/M03/2D/36/wKgKklrxdK7g9UQPAF-Xwlz5Ua0915.m4a\r\n第144章 今夜请熄灯$http://audio.xmcdn.com/group44/M00/2D/DC/wKgKjFrxdPLzqIPgAGKsTN70BZw405.m4a\r\n第145章 仆从系统$http://audio.xmcdn.com/group43/M01/2F/03/wKgKjVrxdSuD1f81AGL-ia7hFqo914.m4a\r\n第146章 劲桐可为琴$http://audio.xmcdn.com/group44/M0B/2E/4C/wKgKkVrxdWLQkCAyAF9f9AfnnNg425.m4a\r\n第147章 以针为药入指去$http://audio.xmcdn.com/group44/M0B/2D/F5/wKgKjFrxdYrj7aFeAGQiwZKHito591.m4a\r\n第148章 有个傻子在敲门$http://audio.xmcdn.com/group43/M06/2F/0E/wKgKjVrxdZfzRq0NAGXrcOwfLt0050.m4a\r\n第149章 死有伴，不孤单$http://audio.xmcdn.com/group44/M03/45/04/wKgKjFryPF7RB9LlAGMjPewJy14523.m4a\r\n第150章 制乐大师$http://audio.xmcdn.com/group44/M0A/45/57/wKgKkVryPJyh8FWIAGAqmsEPM1s367.m4a\r\n第151章 青草池塘$http://audio.xmcdn.com/group43/M0B/44/5F/wKgKklryPLfCdI7pAGThp-I7CBY887.m4a\r\n第152章 偷偷报销$http://audio.xmcdn.com/group43/M0B/44/61/wKgKklryPMKjudwTAGRBl0Z9kIM825.m4a\r\n第153章 砸的还行$http://audio.xmcdn.com/group43/M09/46/25/wKgKjVryPNPTbh50AGaCrvkxFU4013.m4a\r\n第154章 仿制精钢箭$http://audio.xmcdn.com/group43/M0B/44/65/wKgKklryPNuDFUaQAGc11FVey74704.m4a\r\n第155章 抢盒饭$http://audio.xmcdn.com/group43/M0B/44/66/wKgKklryPOfwQyP2AFycLFbeh4I774.m4a\r\n第156章 立场问题$http://audio.xmcdn.com/group43/M0B/44/69/wKgKklryPPKBwDC6AF90guumSAM790.m4a\r\n第157章 猫捉老鼠$http://audio.xmcdn.com/group43/M09/46/2D/wKgKjVryPQPyQHpoAGJM2wZfRHE014.m4a\r\n第158章 小孩子爱吃的棒棒糖$http://audio.xmcdn.com/group44/M01/45/5C/wKgKkVryPQiC_DkXAFytygzH_xk497.m4a\r\n第159章 飞机晚点$http://audio.xmcdn.com/group44/M01/45/11/wKgKjFryPSixIyXQAF-NetpADHE084.m4a\r\n第160章 剑未出鞘$http://audio.xmcdn.com/group43/M04/44/6F/wKgKklryPVzh6Y7YAFiLDRDivYM406.m4a\r\n第161章 挨板砖也需要资格$http://audio.xmcdn.com/group44/M08/45/1B/wKgKjFryPaGT-j9hAGMQJyJZ8vg471.m4a\r\n第162章 半块板砖大家都蒙$http://audio.xmcdn.com/group43/M0A/44/79/wKgKklryPeSzIGamAGawNHgj-y8420.m4a\r\n第163章 一箭南山$http://audio.xmcdn.com/group43/M08/46/3F/wKgKjVryPieCG_A9AGY_Jc2dcvo838.m4a\r\n第164章 有颗星星掉下来$http://audio.xmcdn.com/group43/M09/44/85/wKgKklryPl-CnchGAFoC9p7A02w015.m4a\r\n第165章 好好歇着$http://audio.xmcdn.com/group44/M06/45/7E/wKgKkVryPqjQ64crAGgQoMo6aNs521.m4a\r\n第166章 牛清秀$http://audio.xmcdn.com/group44/M06/45/80/wKgKkVryPurAcelJAGYLvRwXu-0566.m4a\r\n第167章 甄美丽$http://audio.xmcdn.com/group44/M05/45/33/wKgKjFryPvuBsJ7fAGLDzC61qh8691.m4a\r\n第168章 灵魂总裁$http://audio.xmcdn.com/group44/M06/45/82/wKgKkVryPwGjrFGeAF6cqCBnA0U047.m4a\r\n第169章 五大仆从小聚会$http://audio.xmcdn.com/group43/M07/44/8E/wKgKklryPw_xxdMPAGmM9Dmm0tg451.m4a\r\n第170章 不冤枉好人$http://audio.xmcdn.com/group43/M02/46/52/wKgKjVryPxmg1boFAGIcZ6WQNo8236.m4a\r\n第171章 栽赃$http://audio.xmcdn.com/group44/M0A/45/3A/wKgKjFryP2CSrwyFAFvRhh-eWW8877.m4a\r\n第172章 变化的白色经验$http://audio.xmcdn.com/group44/M03/45/3C/wKgKjFryP2zREZbbAFncyhtauVE746.m4a\r\n第173章 莲叶荷田田$http://audio.xmcdn.com/group44/M03/45/3E/wKgKjFryP3jjTVtHAGQCdGW1ePA125.m4a\r\n第174章 胡舟老刘羊肉串$http://audio.xmcdn.com/group44/M05/45/8F/wKgKkVryP4OwCou0AGABfOS4h-0265.m4a\r\n第175章 开皮子$http://audio.xmcdn.com/group43/M05/46/5B/wKgKjVryP4yQjhleAFqKEiS4fQ8740.m4a\r\n第176章 切切切$http://audio.xmcdn.com/group43/M05/46/5C/wKgKjVryP5jw0mxVAGHe7c80S90816.m4a\r\n第177章 周家来人$http://audio.xmcdn.com/group44/M02/45/91/wKgKkVryP6OCoPtrAGHmEVkfG1k293.m4a\r\n第178章 如切如磋$http://audio.xmcdn.com/group44/M02/45/93/wKgKkVryP7TB-IjaAGr3qdeUgyI275.m4a\r\n第179章 加块把子肉$http://audio.xmcdn.com/group43/M06/46/5D/wKgKjVryP8GgcQB1AGEqGjXotso737.m4a\r\n第180章 我有张良计$http://audio.xmcdn.com/group43/M06/46/5E/wKgKjVryP8uBrZJRAG9g43aSHno784.m4a\r\n第181章 绝交与投靠$http://audio.xmcdn.com/group43/M06/46/60/wKgKjVryP9Sx16zAAGQ0YN8NIww402.m4a\r\n第182章 买我不动手$http://audio.xmcdn.com/group43/M06/44/9E/wKgKklryP97jMv0iAFnMpNdE--I626.m4a\r\n第183章 仓皇的小白兔$http://audio.xmcdn.com/group43/M04/44/9F/wKgKklryP-bSKDCGAFmfH5Q8L1M694.m4a\r\n第184章 正解软妹币$http://audio.xmcdn.com/group43/M02/46/65/wKgKjVryP_ThVai1AF9J7C3GDlU803.m4a\r\n第185章 幻灭的一百万$http://audio.xmcdn.com/group43/M02/46/67/wKgKjVryQAHT6fS3AGKtxM2Ep5k126.m4a\r\n第186章 多买三五块$http://audio.xmcdn.com/group43/M02/46/69/wKgKjVryQA3yD2moAGVFggNP1fY289.m4a\r\n第187章 我有一个聊天室$http://audio.xmcdn.com/group43/M04/44/A4/wKgKklryQAWDFkgEABecX4o5F6g134.m4a\r\n第188章 男人有块表$http://audio.xmcdn.com/group44/M00/45/97/wKgKkVryQB7AUL1sAFX0ytXY37Q483.m4a\r\n第189章 细节问题$http://audio.xmcdn.com/group44/M00/45/99/wKgKkVryQCTDfS4dAFkg1GeLitA637.m4a\r\n第190章 坐下休息$http://audio.xmcdn.com/group44/M04/45/9E/wKgKkVryQEXBVoEwAFzJsRsu32M397.m4a\r\n第191章 反杀$http://audio.xmcdn.com/group44/M00/45/4D/wKgKjFryQD_BNNQZAF8rFoajQyM298.m4a\r\n第192章 风水轮流转$http://audio.xmcdn.com/group44/M00/45/4E/wKgKjFryQEbgTvEcAGJCkyicax8746.m4a\r\n第193章 无限惆怅$http://audio.xmcdn.com/group44/M09/45/50/wKgKjFryQFiiQhbGAGWje_cmKpQ654.m4a\r\n第194章 三好学生$http://audio.xmcdn.com/group44/M09/45/51/wKgKjFryQF7gKwEmAGCLgtgBGX0657.m4a\r\n第195章 旧时王谢堂前燕$http://audio.xmcdn.com/group44/M04/45/A4/wKgKkVryQG7CTMHDAGnU6NabX-o960.m4a\r\n第196章 小师叔$http://audio.xmcdn.com/group44/M09/45/55/wKgKjFryQHLCa7BUAE00KdXjSPs750.m4a\r\n第197章 赴约$http://audio.xmcdn.com/group43/M01/44/A8/wKgKklryQIHyrTOGAFvRhrGrZL8582.m4a\r\n第198章 大骗子$http://audio.xmcdn.com/group43/M03/44/AC/wKgKklryQJaQW2l7AF2dJLG_D-w879.m4a\r\n第199章 一口一两$http://audio.xmcdn.com/group43/M0B/46/71/wKgKjVryQJ6AJ5OVAFIujpbYpGM227.m4a\r\n第200章 入彀$http://audio.xmcdn.com/group43/M0B/46/6F/wKgKjVryQJPAzS23ACFp7RpimPM819.m4a\r\n第201章 袁柏东$http://audio.xmcdn.com/group44/M0B/45/B1/wKgKkVryQUui0ROKAE2avmHj1mQ853.m4a\r\n第202章 抵不过出身$http://audio.xmcdn.com/group44/M08/45/66/wKgKjFryQWTTWFDhAFl9jIPpy9I024.m4a\r\n第203章 幸运数字重现江湖$http://audio.xmcdn.com/group44/M05/45/69/wKgKjFryQY2SabWtAFOpakPCCDQ471.m4a\r\n第204章 二号原石与分手$http://audio.xmcdn.com/group43/M0A/44/C2/wKgKklryQbCjtHlaAFO2ohkz7YU045.m4a\r\n第205章 放一段录音$http://audio.xmcdn.com/group44/M07/45/6E/wKgKjFryQcyQ37CXAFCZQxoZOvs834.m4a\r\n第206章 梦想十三镯$http://audio.xmcdn.com/group43/M09/44/CA/wKgKklryQgKAue5QAE_V9-7_rd4188.m4a\r\n第207章 人生总要朝前$http://audio.xmcdn.com/group44/M02/45/73/wKgKjFryQjqToVWhAE-7h9JNUqE015.m4a\r\n第208章 多行不义$http://audio.xmcdn.com/group43/M01/46/98/wKgKjVryQofhKskcAGCVyxu9UyE648.m4a\r\n第209章 必自毙$http://audio.xmcdn.com/group44/M01/45/D0/wKgKkVryQruy8Xq9AFOcMp85U88002.m4a\r\n第210章 补天系统耍流氓$http://audio.xmcdn.com/group44/M0A/45/D7/wKgKkVryQuyjfTOXAE3xl0d9p3c412.m4a\r\n第211章 变态$http://audio.xmcdn.com/group44/M0B/45/DC/wKgKkVryQyCwwHTCAFY0I2gEWIE986.m4a\r\n第212章 压制$http://audio.xmcdn.com/group43/M06/46/A7/wKgKjVryQ1mBPV4kAFKT4aOW5Jg361.m4a\r\n第213章 不溃则反$http://audio.xmcdn.com/group43/M08/46/AB/wKgKjVryQ5LDWbL-AFDW7ygfZts234.m4a\r\n第214章 左手剑$http://audio.xmcdn.com/group43/M0B/44/EB/wKgKklryQ9CRG5Q1AFReB0plzjc543.m4a\r\n第215章 诺与死$http://audio.xmcdn.com/group43/M02/44/F0/wKgKklryRAnRrK-wAE_9nribR2Q758.m4a\r\n第216章 相请与偶遇$http://audio.xmcdn.com/group43/M07/44/F5/wKgKklryRELxp_VrAE-luQyh77A630.m4a\r\n第217章 垃圾分类投放$http://audio.xmcdn.com/group43/M05/46/C3/wKgKjVryRIrhDC8-AE1bmis3KeA526.m4a\r\n第218章 浮光魅声$http://audio.xmcdn.com/group43/M02/45/01/wKgKklryRLTDbCghAFFck3bhrsM122.m4a\r\n第219章 封坛原将$http://audio.xmcdn.com/group44/M0A/45/BA/wKgKjFryROTQgvhWAEjX8WCDOIs993.m4a\r\n第220章 一路走好$http://audio.xmcdn.com/group44/M0A/46/13/wKgKkVryRRyS365oAE-7vcsnc7Y899.m4a\r\n第221章 世间万般苦$http://audio.xmcdn.com/group44/M03/45/C6/wKgKjFryRVmgOiIcAEwG7qdFRZo128.m4a\r\n第222章 一曲肝肠断$http://audio.xmcdn.com/group44/M05/46/1D/wKgKkVryRYrigYgnAFLQFb9gQaE384.m4a\r\n第223章 啦啦啦之十步杀一人$http://audio.xmcdn.com/group44/M08/46/22/wKgKkVryRcLSrGDbAFFMaNO6i48153.m4a\r\n第224章 出发前夕$http://audio.xmcdn.com/group44/M02/46/29/wKgKkVryRgCxM4fPAFlFiMlYXF4518.m4a\r\n第225章 十三镯出炉$http://audio.xmcdn.com/group43/M0B/45/2A/wKgKklryRjzijk3EAFFMaDRbQn4240.m4a\r\n第226章 原将山儿提前开$http://audio.xmcdn.com/group44/M01/46/30/wKgKkVryRniCwm2IAGNTtdqm4CA488.m4a\r\n第227章 有大汉像砖塔$http://audio.xmcdn.com/group43/M07/45/32/wKgKklryRqzDms_5AFILTkdF4S0984.m4a\r\n第228章 逃命与追命$http://audio.xmcdn.com/group44/M09/46/3A/wKgKkVryRujxIZZcAFVmWLFre24101.m4a\r\n第229章 不跑了$http://audio.xmcdn.com/group44/M0B/46/41/wKgKkVryRyrBoLlMAFJU8CRgrMw201.m4a\r\n第230章 一个小小的请求$http://audio.xmcdn.com/group44/M09/45/F3/wKgKjFryR2azx-yfAFLexCC9aKc779.m4a\r\n第231章 三个选择$http://audio.xmcdn.com/group44/M03/45/FC/wKgKjFryR6ThZqx5AE81577yrnA788.m4a\r\n第232章 三根香肠$http://audio.xmcdn.com/group43/M03/47/18/wKgKjVryR9_iseuCAFKkCF8knnI946.m4a\r\n第233章 一头孤狼$http://audio.xmcdn.com/group44/M05/46/01/wKgKjFrySBWzwa4wAE_u7x2Qnz4927.m4a\r\n第234章 两个少年$http://audio.xmcdn.com/group44/M08/46/5A/wKgKkVrySFSgC4M0AFPMp4RwTpE823.m4a\r\n第235章 三个太阳，亮堂堂$http://audio.xmcdn.com/group44/M0A/46/60/wKgKkVrySIiAcRRrAE2JH7ER-Oo662.m4a\r\n第236章 一群小师侄$http://audio.xmcdn.com/group43/M02/45/68/wKgKklrySMDCqTl7AF6ldXr_KPI420.m4a\r\n第237章 一颗夺宝的心$http://audio.xmcdn.com/group43/M0A/45/69/wKgKklrySOSweE7zAFHAoJS97FE252.m4a\r\n第238章 一柄大宝剑$http://audio.xmcdn.com/group43/M0A/45/73/wKgKklrySS6x0TLUAFYlPsqhpRA461.m4a\r\n第239章 五人来追$http://audio.xmcdn.com/group44/M03/46/24/wKgKjFrySVfRku6kAEvNqWvHomQ938.m4a\r\n第240章 所谓家族$http://audio.xmcdn.com/group44/M07/46/29/wKgKjFrySZPAV-88AFG0rqTw9Y0142.m4a\r\n第241章 所谓上等人$http://audio.xmcdn.com/group43/M00/47/46/wKgKjVrySdSTI0p6AFUqJJJ8aa4928.m4a\r\n第242章 幽暗密林$http://audio.xmcdn.com/group44/M01/46/87/wKgKkVrySguhz7dZAFRN4CUKZXI283.m4a\r\n第243章 大剑飞行$http://audio.xmcdn.com/group44/M02/46/8F/wKgKkVrySkniua7AAFEKVj3mBBk405.m4a\r\n第244章 断腕$http://audio.xmcdn.com/group44/M07/45/70/wKgKjFryQdqh05exAE74O93VfO4258.m4a\r\n第245章 三才者，可养浩然气$http://audio.xmcdn.com/group43/M09/44/CD/wKgKklryQhOQhfjlAFFQ05NGENI389.m4a\r\n第246章 绝处$http://audio.xmcdn.com/group44/M02/45/C5/wKgKkVryQkji71GVAE-uUObgGjo194.m4a\r\n第247章 逢生$http://audio.xmcdn.com/group43/M01/46/97/wKgKjVryQn_gmw96AE5Q0lOB8Mw541.m4a\r\n第248章 谢羔白$http://audio.xmcdn.com/group44/M01/45/7E/wKgKjFryQrbziINOAFJRyzsfAAI501.m4a\r\n第249章 秘境异变$http://audio.xmcdn.com/group44/M0A/45/D8/wKgKkVryQu7Dp0QjAE433uMSzPI616.m4a\r\n第250章 愤怒的小老虎$http://audio.xmcdn.com/group44/M0B/45/8C/wKgKjFryQyORkzWAAE5JfdQxEgA459.m4a\r\n第251章 择处而栖$http://audio.xmcdn.com/group44/M08/45/E5/wKgKkVryQ2OTf7RsAFa8fNG9yaY982.m4a\r\n第252章 恐怖大鱼怪$http://audio.xmcdn.com/group44/M09/45/EB/wKgKkVryQ5fSDbbVAE8G66jKZdU885.m4a\r\n第253章 惊魂时刻$http://audio.xmcdn.com/group43/M0B/46/B1/wKgKjVryQ8_SUsYSAFC_crdmGpI052.m4a\r\n第254章 死而无憾$http://audio.xmcdn.com/group44/M06/45/F6/wKgKkVryRBDDojZOAFkNvgOq8hc740.m4a\r\n第255章 一批火腿引发的血案$http://audio.xmcdn.com/group44/M07/45/FE/wKgKkVryREzwCXs0AFjV8DcvdfU503.m4a\r\n第256章 靠近$http://audio.xmcdn.com/group43/M0A/44/FC/wKgKklryRIHBwJ1-AE6KTSwskvk995.m4a\r\n第257章 有大阵，曰罗天$http://audio.xmcdn.com/group43/M02/45/06/wKgKklryRMrz7TxbAFqr1ydg3iM332.m4a\r\n第258章 有小虫，名破甲$http://audio.xmcdn.com/group44/M0A/46/0F/wKgKkVryRQfAqveNAFP4tFfqZiU243.m4a\r\n第259章 消极怠工袁青城$http://audio.xmcdn.com/group43/M04/45/0E/wKgKklryRTqArcKZAEvKtqLL5WE092.m4a\r\n第260章 剑鞘专供赵无方$http://audio.xmcdn.com/group43/M00/46/D9/wKgKjVryRXOjxHCXAFCvTLu0kZw270.m4a\r\n第261章 水若至清$http://audio.xmcdn.com/group43/M01/45/19/wKgKklryRaejmmuuAE7mnbQO7g8897.m4a\r\n第262章 咚咚$http://audio.xmcdn.com/group43/M02/46/E4/wKgKjVryRd_gKS5HAFAs0JHz2hE115.m4a\r\n第263章 山洞幽深$http://audio.xmcdn.com/group43/M03/46/E9/wKgKjVryRhzyag5UAFKhGS4QMNo499.m4a\r\n第264章 巨石迷宫$http://audio.xmcdn.com/group43/M0B/45/2E/wKgKklryRlXwWanqAFGtVJ1DSik309.m4a\r\n第265章 六取其二$http://audio.xmcdn.com/group44/M04/46/34/wKgKkVryRpGRRsc7AE_BaWIdxlU463.m4a\r\n第266章 你怎么这么不小心$http://audio.xmcdn.com/group43/M07/45/35/wKgKklryRr-hrjkYAE19XzIh8IY524.m4a\r\n第267章 钥匙难开心锁$http://audio.xmcdn.com/group44/M00/45/E8/wKgKjFryRvaju4YhAFMTn5Onrxw965.m4a\r\n第268章 千梁借剑$http://audio.xmcdn.com/group43/M08/47/09/wKgKjVryR1XgxC4YAGkhw5oc6Zs768.m4a\r\n第269章 记错了口诀$http://audio.xmcdn.com/group43/M05/47/0E/wKgKjVryR4TSy4E6AFE8d9R1Bk4879.m4a\r\n第270章 努力工作的破甲虫$http://audio.xmcdn.com/group43/M02/45/4D/wKgKklryR8XD62syAFEx_a1sTgU213.m4a\r\n第271章 三字批文$http://audio.xmcdn.com/group43/M03/45/57/wKgKklryR_3RVt0yAFA1nS1A3To027.m4a\r\n第272章 惹祸小精灵$http://audio.xmcdn.com/group43/M04/47/23/wKgKjVrySD7ghM6UAFPYZwvPfbw910.m4a\r\n第273章 我后悔，你随意$http://audio.xmcdn.com/group43/M01/45/61/wKgKklrySHfQdaqUAFGndkxdsks148.m4a\r\n第274章 刀与图$http://audio.xmcdn.com/group43/M02/45/65/wKgKklrySK2Dtwl0AE1M62-dE8g472.m4a\r\n第275章 解阵之后$http://audio.xmcdn.com/group44/M0B/46/18/wKgKjFrySN7ilIMOAE12Co8nE5Q697.m4a\r\n第276章 倒数五个数$http://audio.xmcdn.com/group43/M0B/47/35/wKgKjVrySSGhQX0uAFOmrUy8R7Q201.m4a\r\n第277章 泼脏水$http://audio.xmcdn.com/group44/M03/46/75/wKgKkVrySVHACE7_AEvvbs9bUvQ098.m4a\r\n第278章 真傻假傻$http://audio.xmcdn.com/group43/M08/47/3F/wKgKjVrySZfjml27AFRlXVjDk2M455.m4a\r\n第279章 一贱五不开$http://audio.xmcdn.com/group44/M00/46/7F/wKgKkVryScvinJS8AE7t84A84NI472.m4a\r\n第280章 青尸蚰蜒$http://audio.xmcdn.com/group44/M01/46/86/wKgKkVrySgSi8WfEAE0SLnv2enI846.m4a\r\n第281章 一丈长，多少级$http://audio.xmcdn.com/group43/M09/47/69/wKgKjVryS12wkO9EAFLtdPvAFqw131.m4a\r\n第282章 死道友不死贫道$http://audio.xmcdn.com/group44/M0B/46/52/wKgKjFryS5HDRRBhAFBFkoyT60g355.m4a\r\n第283章 马克思哲学原理$http://audio.xmcdn.com/group43/M08/45/AF/wKgKklryS9GiCnRBAFB3fu7udiI358.m4a\r\n第284章 你的背影$http://audio.xmcdn.com/group44/M06/46/B3/wKgKkVryTBPTtu_eAFDrtmOKFIY091.m4a\r\n第285章 无忌铜铃可惊梦$http://audio.xmcdn.com/group43/M02/47/7D/wKgKjVryTFDBVxMqAFeLiWwmbkY291.m4a\r\n第286章 明天上班班$http://audio.xmcdn.com/group44/M02/46/6C/wKgKjFryTI7BIqiwAFGkgzYz-2M351.m4a\r\n第287章 自古吃货好对付$http://audio.xmcdn.com/group44/M03/46/C6/wKgKkVryTMDDzgrbAFAa_K9b4no026.m4a\r\n第288章 河的另一边$http://audio.xmcdn.com/group43/M05/47/8C/wKgKjVryTP7zef44AFIkRTtL9EU082.m4a\r\n第289章 十只鸡$http://audio.xmcdn.com/group43/M05/47/91/wKgKjVryTTHATYuNAEyp7S7VtGw002.m4a\r\n第290章黑心与庸俗$http://audio.xmcdn.com/group43/M06/47/96/wKgKjVryTWvSkvfyAE5ym6YxCtI812.m4a\r\n第291章 你情我愿的兑换$http://audio.xmcdn.com/group43/M07/47/9B/wKgKjVryTabyCrR0AE841qHjROI308.m4a\r\n第292章 偷袭$http://audio.xmcdn.com/group44/M07/46/E2/wKgKkVryTc7BfdgYAE0fZoTKGNw518.m4a\r\n第293章 还是偷袭$http://audio.xmcdn.com/group43/M00/47/9F/wKgKjVryTduxu01JAFNtNvgjeak684.m4a\r\n第294章 下来玩玩$http://audio.xmcdn.com/group44/M07/46/8D/wKgKjFryTeuDn_qfAFMd6Mlgf6Y470.m4a\r\n第295章 尿不尿$http://audio.xmcdn.com/group44/M08/46/8E/wKgKjFryTfahNx0oAFF58TPOk60163.m4a\r\n第296章 大河雪橇不用桨$http://audio.xmcdn.com/group44/M08/46/92/wKgKjFryTgKQUt72AE6OgpT5Cz4687.m4a\r\n第297章 学好数理化$http://audio.xmcdn.com/group43/M03/45/E3/wKgKklryThGxF87EAFGgHYrJQI0755.m4a\r\n第298章 顺流而下$http://audio.xmcdn.com/group43/M03/47/A4/wKgKjVryThqAyWJHAE1Co_Ve3gw572.m4a\r\n第299章 挡不挡都是死$http://audio.xmcdn.com/group44/M01/46/95/wKgKjFryTjKzkQoDAFNVtT1d9Ko389.m4a\r\n第300章 有好玩的你来么$http://audio.xmcdn.com/group44/M01/46/ED/wKgKkVryTj2ANV48AExWOEB2wJo930.m4a\r\n第301章 小破不见了$http://audio.xmcdn.com/group43/M0A/45/E8/wKgKklryTkrhZliqAE_LrtZMvgI739.m4a\r\n第302章 西域刀客$http://audio.xmcdn.com/group44/M02/46/EF/wKgKkVryTmDjRtxiAFIMyclNQwI755.m4a\r\n第303章 悲惨世界$http://audio.xmcdn.com/group43/M02/47/AE/wKgKjVryTmiAmpvRAFebr97t6h8927.m4a\r\n第304章 被占有的碧水青莲$http://audio.xmcdn.com/group44/M02/46/9C/wKgKjFryTnLTnjkRAEt59IOQFg4597.m4a\r\n第305章 不打架不吹比$http://audio.xmcdn.com/group43/M02/47/AF/wKgKjVryTo7BvvpMAFowe7v_Ljw657.m4a\r\n第306章 分赃比例$http://audio.xmcdn.com/group43/M02/47/B1/wKgKjVryTpWANAP8AE5Aqy9hc7c904.m4a\r\n第307章 逐个击破$http://audio.xmcdn.com/group43/M02/45/F3/wKgKklryTqOxZ-zRAFPxXxHLASY847.m4a\r\n第308章 三三得九$http://audio.xmcdn.com/group44/M04/46/A2/wKgKjFryTqyCkNY_AE6zNnHlGs8603.m4a\r\n第309章 各赢十局$http://audio.xmcdn.com/group44/M04/46/A5/wKgKjFryTrvS9VKNAE2gnIfx328036.m4a\r\n第310章 小型拍卖$http://audio.xmcdn.com/group43/M05/47/B5/wKgKjVryTsuS99P6AFQdbMdvXWA253.m4a\r\n第311章 蛇王出征$http://audio.xmcdn.com/group44/M0A/46/FB/wKgKkVryTtbRIdRhAEugJOw5b_I795.m4a\r\n第312章 里应外合$http://audio.xmcdn.com/group44/M0A/46/FD/wKgKkVryTuaROfsQAFDhNwzyV9A523.m4a\r\n第313章 被偷袭的周朝七$http://audio.xmcdn.com/group44/M0A/47/00/wKgKkVryTvTgCO85AEw42qLgoN0805.m4a\r\n第314章 箭为梯$http://audio.xmcdn.com/group43/M0B/45/FA/wKgKklryTwHAfsNWAFOWUEZZ2SM060.m4a\r\n第315章 一箭飞仙$http://audio.xmcdn.com/group43/M0B/45/FF/wKgKklryTxzTOdlTAE-foWXQDK4765.m4a\r\n第316章 现代诗$http://audio.xmcdn.com/group43/M0B/47/BF/wKgKjVryTyGDSTfnAFJEkyxB7uc917.m4a\r\n第317章 杂牌军成立$http://audio.xmcdn.com/group43/M0B/47/C3/wKgKjVryTzmxubSfAFBknj5jOis914.m4a\r\n第318章 圣器$http://audio.xmcdn.com/group44/M00/47/02/wKgKkVryT0_jvNsTAFCKlNxMSmk703.m4a\r\n第319章 不给就别说$http://audio.xmcdn.com/group44/M0B/46/B2/wKgKjFryT2aSDL0CAFB75Kwzdso233.m4a\r\n第320章 魔兽有节操$http://audio.xmcdn.com/group44/M0B/46/B5/wKgKjFryT3iSSPslAFGhlBiSuVY007.m4a\r\n第321章 瓮中捉鳖$http://audio.xmcdn.com/group44/M0B/46/B7/wKgKjFryT4Ti4pZSAE_jLj1JGuk744.m4a\r\n第322章 死里求生$http://audio.xmcdn.com/group43/M06/47/C8/wKgKjVryT5PzXqb9AE30UFEit9A437.m4a\r\n第323章 生存的代价$http://audio.xmcdn.com/group43/M06/47/CC/wKgKjVryT6fD02iBAE1M69qAolY273.m4a\r\n第324章 滑翔$http://audio.xmcdn.com/group43/M06/47/CE/wKgKjVryT7bA48ZWAEqX0gDJuYA410.m4a\r\n第325章 没有对比就没有伤害$http://audio.xmcdn.com/group44/M0B/46/B9/wKgKjFryT8qzaIJzAFX6qGBHh84780.m4a\r\n第326章 烂人不如魔兽$http://audio.xmcdn.com/group44/M05/46/BD/wKgKjFryT93S2OFwAE_yFBJt4-o140.m4a\r\n第326章 追击$http://audio.xmcdn.com/group44/M05/46/C2/wKgKjFryT_Oxe_N2AFJL7OvJdxI050.m4a\r\n第327章 多才多艺花极天$http://audio.xmcdn.com/group44/M07/47/1C/wKgKkVryUAeTsJPEAFC9-xW3XkU741.m4a\r\n第329章 反弹鄙视的能力$http://audio.xmcdn.com/group43/M01/47/D6/wKgKjVryUB6hX8CVAEvAccmlo_E828.m4a\r\n第330章 我想飞$http://audio.xmcdn.com/group43/M01/46/1B/wKgKklryUDbgKs2uAFBLcIoqxDI334.m4a\r\n第331章 同杯$http://audio.xmcdn.com/group44/M06/46/DB/wKgKjFryUNHg4hGdAE7-GeOh2JQ744.m4a\r\n第332章 熬鹰之惨烈$http://audio.xmcdn.com/group43/M03/47/E9/wKgKjVryUQbxwBZUAEuXUsOmT1o517.m4a\r\n第333章 对比之伤害$http://audio.xmcdn.com/group44/M04/46/E1/wKgKjFryUUKwGqpiAEqQr2A8UZc407.m4a\r\n第334章 抢兔子$http://audio.xmcdn.com/group43/M0A/47/F7/wKgKjVryUYzjIlt7AFEC_P6Njys536.m4a\r\n第335章 奸诈卑鄙不要脸$http://audio.xmcdn.com/group44/M00/47/45/wKgKkVryUcbyWyw2AE8c71YQz7g086.m4a\r\n第336章 套圈技术哪家强$http://audio.xmcdn.com/group43/M05/46/42/wKgKklryUgOSbDyJAE3kKulgMP0955.m4a\r\n第337章 双生贱组合$http://audio.xmcdn.com/group44/M01/46/FD/wKgKjFryUjqD6vHuAE0PPwcUyp0436.m4a\r\n第338章 日影定位$http://audio.xmcdn.com/group43/M07/48/0B/wKgKjVryUnzDjlt4AEy1qSUilio521.m4a\r\n第339章 双花$http://audio.xmcdn.com/group43/M08/48/11/wKgKjVryUsDTk_mjAFHU-xpHuA0978.m4a\r\n第340章 以剑为箭$http://audio.xmcdn.com/group43/M09/46/59/wKgKklryUv_yaDQjAFD6L0M__cw409.m4a\r\n第341章 飞刀与石柱子$http://audio.xmcdn.com/group43/M06/46/5E/wKgKklryUzvwfBaPAFJALLHASOc878.m4a\r\n第342章 虎落平阳$http://audio.xmcdn.com/group43/M02/48/22/wKgKjVryU3vCVJcRAFEmPRLtPC0419.m4a\r\n第343章 二对三$http://audio.xmcdn.com/group43/M05/46/6D/wKgKklryU7-DfiWoAFEUnqEV_TI291.m4a\r\n第344章 兽已疯狂$http://audio.xmcdn.com/group43/M06/48/2E/wKgKjVryU_bTdns1AFI-tbQmPK0925.m4a\r\n第345章 福兮祸所伏$http://audio.xmcdn.com/group43/M03/46/75/wKgKklryVC7jDnwoAE7fQyqXvng413.m4a\r\n第346章 下棋$http://audio.xmcdn.com/group44/M07/47/34/wKgKjFryVEaDPR4GAFVNYRmUVAA428.m4a\r\n第347章 这一次不用打白条$http://audio.xmcdn.com/group44/M07/47/8B/wKgKkVryVFTh0txSAFBknub7jok337.m4a\r\n第348章 秘境边缘$http://audio.xmcdn.com/group43/M04/48/35/wKgKjVryVGPwqGAPAE_wnA_lPz0253.m4a\r\n第349章 分别$http://audio.xmcdn.com/group43/M00/46/7F/wKgKklryVILB-PypAEz6rlncxlI841.m4a\r\n第350章 归$http://audio.xmcdn.com/group44/M03/47/90/wKgKkVryVMLTjeZOAFH2wICof9w490.m4a\r\n第351章 代二胖$http://audio.xmcdn.com/group43/M08/46/89/wKgKklryVPihGKgeAEqgnyPkECA718.m4a\r\n第352章 仗势$http://audio.xmcdn.com/group44/M0A/47/46/wKgKjFryVSyRyxwLAE2yPpR3SoU954.m4a\r\n第353章 自己人与其他人$http://audio.xmcdn.com/group44/M08/47/A2/wKgKkVryVV-jfewTAEjgwpUcD18632.m4a\r\n第354章 小帅哥与大美女$http://audio.xmcdn.com/group43/M02/48/57/wKgKjVryVZ3CiIOhAFDhN7n8reY868.m4a\r\n第355章 吴凡耍刀$http://audio.xmcdn.com/group43/M0B/46/9E/wKgKklryVdSA8zXvAE_KN3iX1E4500.m4a\r\n第356章 花重锦官城$http://audio.xmcdn.com/group43/M0B/46/A3/wKgKklryVgzQt4apAE5-kfvJIbo027.m4a\r\n第357章 憋屈的花无殇$http://audio.xmcdn.com/group44/M0B/47/5E/wKgKjFryVh2hy29rAFBEF0Bj-Hc125.m4a\r\n第358章 提前开工$http://audio.xmcdn.com/group44/M06/47/B4/wKgKkVryViWx5VAEAE7JP2FbA1E101.m4a\r\n第359章 再别离$http://audio.xmcdn.com/group44/M04/47/62/wKgKjFryVjHwH-1JAE-SaZ4c2wQ116.m4a\r\n第360章 蓝色跑车$http://audio.xmcdn.com/group44/M06/47/B8/wKgKkVryVjjhUTQ8AEkVnXGZphs754.m4a\r\n第361章 最近手抽筋$http://audio.xmcdn.com/group43/M09/46/A7/wKgKklryVkbBfgn3AFRWrcA43Fs880.m4a\r\n第362章 小心被雷劈$http://audio.xmcdn.com/group43/M09/46/A9/wKgKklryVlGTDCghAFFg-dbYohY059.m4a\r\n第363章 一百块$http://audio.xmcdn.com/group43/M09/48/69/wKgKjVryVl3AhI8fAFi3G27vpi8825.m4a\r\n第364章 一万块$http://audio.xmcdn.com/group44/M05/47/65/wKgKjFryVmWSfi5fAEq8hn7jbGs466.m4a\r\n第365章 这辆车像王八$http://audio.xmcdn.com/group44/M05/47/67/wKgKjFryVnGBZ9c5AFDFUCYJoqQ504.m4a\r\n第366章 勤俭持家$http://audio.xmcdn.com/group43/M0A/46/AD/wKgKklryVnzCU32hAE3JujlboWg220.m4a\r\n第367章 追赶$http://audio.xmcdn.com/group43/M0A/46/B0/wKgKklryVo3Ck9ATAFKFMp5hqsc714.m4a\r\n第368章 城门失火殃及赵军$http://audio.xmcdn.com/group44/M05/47/C0/wKgKkVryVp_i0zkdAE2t0zAvznQ314.m4a\r\n第369章 最后关头$http://audio.xmcdn.com/group44/M00/47/6E/wKgKjFryVrWT5C3mAFZaHbi1RXw358.m4a\r\n第370章 舒服吗$http://audio.xmcdn.com/group43/M05/48/74/wKgKjVryVsvgHGlTAFPFUTQttCQ271.m4a\r\n第371章 请允许谈个恋爱先$http://audio.xmcdn.com/group44/M08/47/C8/wKgKkVryVuSAVj6HAEvHx_T4Ef8434.m4a\r\n第372章 赚钱能力大比拼$http://audio.xmcdn.com/group43/M07/48/75/wKgKjVryVvSjyt6HAE6UlhWeC_8052.m4a\r\n第373章 互赠$http://audio.xmcdn.com/group43/M08/48/79/wKgKjVryVw2RG-TAAE83X05N2bg420.m4a\r\n第374章 投缘$http://audio.xmcdn.com/group44/M0A/47/7A/wKgKjFryVyvidDy_AFNJ9XwzOIM680.m4a\r\n第375章 同学聚会$http://audio.xmcdn.com/group44/M0A/47/78/wKgKjFryVySiZR8MAE2O_k5U1R4940.m4a\r\n第376章 各自生长 陌生模样$http://audio.xmcdn.com/group43/M08/48/7B/wKgKjVryVzPB8OUdAFEafMnEO64871.m4a\r\n第377章 假聚会真目的$http://audio.xmcdn.com/group43/M04/46/C3/wKgKklryV1GS3vPHAE0g3gXLOFg626.m4a\r\n第378章 突然出现$http://audio.xmcdn.com/group43/M08/46/C2/wKgKklryV0_gUrQjAEpM6-yAItw563.m4a\r\n第379章 永远免单$http://audio.xmcdn.com/group43/M03/48/81/wKgKjVryV1zymDixAFLV85yGF2Q656.m4a\r\n第380章 人情凉薄古犹今$http://audio.xmcdn.com/group43/M04/46/C6/wKgKklryV2WC_vdVAEosnSLiNPU209.m4a\r\n第381章 财折人腰 色壮人胆$http://audio.xmcdn.com/group43/M01/46/DE/wKgKklryWF7T1gdUAE433p_OUVQ127.m4a\r\n第382章 剑的选择$http://audio.xmcdn.com/group43/M01/48/9D/wKgKjVryWGrjRx96AFACBEVQeug827.m4a\r\n第383章 感情问题$http://audio.xmcdn.com/group44/M0B/47/90/wKgKjFryWHWjLPk4AEmScItwcNU187.m4a\r\n第384章 十年生死两茫茫$http://audio.xmcdn.com/group44/M05/47/E9/wKgKkVryWHqSGiBBAEqiF7-uvNE143.m4a\r\n第385章 灵田和秘境$http://audio.xmcdn.com/group44/M05/47/93/wKgKjFryWIXToWUoAE7g8cItPz0936.m4a\r\n第386章 至交好友不值钱$http://audio.xmcdn.com/group44/M05/47/ED/wKgKkVryWJDAMxvDAFKDusAaV-c758.m4a\r\n第387章 谁的项目$http://audio.xmcdn.com/group44/M05/47/99/wKgKjFryWJzz_gBDAEv-Hdb-ZbM251.m4a\r\n第388章 策神没把握$http://audio.xmcdn.com/group44/M06/47/F1/wKgKkVryWKTSgk8qAE4BiED78Q8725.m4a\r\n第389章 打孔赚电钻$http://audio.xmcdn.com/group44/M05/47/9D/wKgKjFryWLORyheYAFYppP9g46Y550.m4a\r\n第390章 闭上眼睛$http://audio.xmcdn.com/group43/M03/48/A0/wKgKjVryWMCgElZpAFd4cyzcwa0641.m4a\r\n第391章 源木义根$http://audio.xmcdn.com/group43/M03/48/A2/wKgKjVryWMfzHGGgAEzNKXDWtxE535.m4a\r\n第392章 不一样的武道真气$http://audio.xmcdn.com/group43/M05/46/E8/wKgKklryWNOCe0JJAFNLbSbKhDw377.m4a\r\n第393章 烈焰黑埙$http://audio.xmcdn.com/group43/M03/48/A7/wKgKjVryWN3TGQG8AE0T3N0pNoE158.m4a\r\n第394章 舍近求远$http://audio.xmcdn.com/group44/M0B/47/9E/wKgKjFryWOyClR9gAE12CjNuLFc962.m4a\r\n第395章 跳大神$http://audio.xmcdn.com/group44/M0B/47/F8/wKgKkVryWPijFn3KAE_eyOEsIxM442.m4a\r\n第396章 未知真假心已动$http://audio.xmcdn.com/group44/M02/47/A4/wKgKjFryWQvQZAy2AFBM6Dbd-kg774.m4a\r\n第397章 镇魂碑$http://audio.xmcdn.com/group43/M07/48/AC/wKgKjVryWRayMVPwAE8PuBkMwnI137.m4a\r\n第398章 夔龙鼎$http://audio.xmcdn.com/group44/M02/47/A5/wKgKjFryWSby9aBCAE0d7y63rSs831.m4a\r\n第399章 一剑东来$http://audio.xmcdn.com/group44/M03/48/02/wKgKkVryWTyywtqCAE-Q8ayxsjs415.m4a\r\n第400章 并非圣器$http://audio.xmcdn.com/group43/M08/48/B1/wKgKjVryWU3CPD1GAE_eyNZUnKU994.m4a\r\n第401章 仙器有缺 重定归属$http://audio.xmcdn.com/group43/M06/48/D8/wKgKjVryWr2Sjx8HAFAoNM_ntgU083.m4a\r\n第402章 自立门户$http://audio.xmcdn.com/group43/M06/47/1C/wKgKklryWsjCMBb1AE3VetROFZs818.m4a\r\n第403章 强者弱者 规则与服从$http://audio.xmcdn.com/group44/M0B/48/29/wKgKkVryWtWRYPrlAFSqYn7T2J8372.m4a\r\n第404章 再打白条$http://audio.xmcdn.com/group44/M0B/48/2C/wKgKkVryWuKAOedEAFgc6Qg5Cpc576.m4a\r\n第405章 太快了$http://audio.xmcdn.com/group43/M0A/48/DB/wKgKjVryWvLSOfstAFHfQAzFq7g337.m4a\r\n第406章 轻伤下火线$http://audio.xmcdn.com/group43/M0A/47/1E/wKgKklryWvuxKn-mAFQx-YgFEcs813.m4a\r\n第407章 恐怖第九轮$http://audio.xmcdn.com/group43/M0A/48/DE/wKgKjVryWwXSCjYQAFLwY-YtPRs531.m4a\r\n第408章 铜铃三响如梦令$http://audio.xmcdn.com/group43/M0B/48/E2/wKgKjVryWxfjnr8DAFAGa37ZI4o268.m4a\r\n第409章 守护兄弟 轻伤不下火线$http://audio.xmcdn.com/group43/M0B/48/E3/wKgKjVryWx6Ddtu-AFBi8Vv03Qs991.m4a\r\n第410章 残剑飞$http://audio.xmcdn.com/group43/M0B/48/E5/wKgKjVryWyeTpR6SAFEkxRaadBs009.m4a\r\n第411章 以弱胜强$http://audio.xmcdn.com/group43/M0B/48/E7/wKgKjVryWzGB0hSWAFAQs_EBqaM715.m4a\r\n第412章 青莲的诱惑$http://audio.xmcdn.com/group43/M0B/48/E9/wKgKjVryWzvgwDWbAEy3WtCQdH0129.m4a\r\n第413章 忘了什么时候教的$http://audio.xmcdn.com/group44/M02/47/D6/wKgKjFryW0jAnfhQAEy1qYClB4k956.m4a\r\n第414章 只要活着 就有可能$http://audio.xmcdn.com/group44/M02/48/31/wKgKkVryW06CfdIaAEtvq_wR1kI847.m4a\r\n第415章 小福大寿$http://audio.xmcdn.com/group44/M02/47/DA/wKgKjFryW1qxFOS1AFE9ufzeAFM235.m4a\r\n第416章 身世平凡 一无所有$http://audio.xmcdn.com/group44/M02/47/E3/wKgKjFryW4Lh1e-NAFBxoA7QPjU769.m4a\r\n第417章 一换三 八对六$http://audio.xmcdn.com/group43/M08/48/F3/wKgKjVryW8Xjysr1AE1tOajh89w339.m4a\r\n第418章 伤汝身 痛吾心$http://audio.xmcdn.com/group43/M08/48/FB/wKgKjVryW_OzLmx8AFXY41VRJGs589.m4a\r\n第419章 给我开$http://audio.xmcdn.com/group44/M01/47/F3/wKgKjFryXDODV_cnAFPYZzWxTBg732.m4a\r\n第420章 摘玉镯$http://audio.xmcdn.com/group43/M01/49/04/wKgKjVryXGKxDbBwAExwpx7ECKc408.m4a\r\n第421章 糗事与广场舞$http://audio.xmcdn.com/group44/M00/47/FD/wKgKjFryXJehUVqNAEyxQvQXAfk108.m4a\r\n第422章 塞下曲 上古血脉$http://audio.xmcdn.com/group43/M09/47/4D/wKgKklryXMjQWr__AEoz97BpqYE620.m4a\r\n第423章 外国的月亮不一定圆$http://audio.xmcdn.com/group44/M08/48/63/wKgKkVryXQiA6AhMAF17X68yvGM424.m4a\r\n第424章 车轮战$http://audio.xmcdn.com/group43/M06/47/52/wKgKklryXQ-SzcC9AE2jj8do7SU672.m4a\r\n第425章 活下去$http://audio.xmcdn.com/group43/M06/49/14/wKgKjVryXReSqJBzAFF1h4e1AV0300.m4a\r\n第426章 有些境界学不会$http://audio.xmcdn.com/group43/M06/47/54/wKgKklryXRjBEtTMADkdf6qbCjw866.m4a\r\n第427章 死了的族人不是族人$http://audio.xmcdn.com/group44/M07/48/0E/wKgKjFryXTKjUO7XAE8hWg5fYRk425.m4a\r\n第428章 谈笑间 敌胆丧$http://audio.xmcdn.com/group44/M0B/48/15/wKgKjFryXWqxT1W8AFLY4hsreR8326.m4a\r\n第429章 有人变刺猬$http://audio.xmcdn.com/group44/M0B/48/75/wKgKkVryXaGh1WHrAFB75Geep40760.m4a\r\n第430章 死亡丛中 有情话$http://audio.xmcdn.com/group43/M07/47/66/wKgKklryXdmw3MieAE5ym9es4OM708.m4a\r\n第431章 挖天宝斋墙角$http://audio.xmcdn.com/group43/M09/49/31/wKgKjVryXhGwKn_SAE8aANsb3P0625.m4a\r\n第432章 买秘籍$http://audio.xmcdn.com/group44/M06/48/2E/wKgKjFryXkfxSAJ6AEwVnfimr4Q187.m4a\r\n第433章 剪电线$http://audio.xmcdn.com/group43/M06/47/75/wKgKklryXl3TRXADAFQb8SGWfQc627.m4a\r\n第434章 异变$http://audio.xmcdn.com/group43/M06/47/78/wKgKklryXmvx8NDAAFwlO-gATL4426.m4a\r\n第435章 易主$http://audio.xmcdn.com/group43/M06/49/39/wKgKjVryXnSgliA8AE2drdrH1vE767.m4a\r\n第436章 第二只手镯$http://audio.xmcdn.com/group43/M06/47/7B/wKgKklryXn3B01DbAEuP-TygzCo308.m4a\r\n第437章 佳人归$http://audio.xmcdn.com/group44/M07/48/8D/wKgKkVryXoyxAfvJAFs3VUNEdOg392.m4a\r\n第438章 要走$http://audio.xmcdn.com/group44/M07/48/90/wKgKkVryXpSi_byRAEyp7VJiUCU357.m4a\r\n第439章 晓看红湿处$http://audio.xmcdn.com/group44/M09/48/37/wKgKjFryXqPCosp1AFTU-Oq-Rqc067.m4a\r\n第440章 砍竹子$http://audio.xmcdn.com/group44/M07/48/95/wKgKkVryXq6hZX4pAFUUGxrMdg8357.m4a\r\n第441章 砍遍三山竹$http://audio.xmcdn.com/group43/M0A/49/3F/wKgKjVryXrjAV4RSAE0vjVOUr3I021.m4a\r\n第442章 白云三现$http://audio.xmcdn.com/group43/M03/47/81/wKgKklryXsHCme5UAE_NXG8098A481.m4a\r\n第443章 又来人了$http://audio.xmcdn.com/group44/M0A/48/97/wKgKkVryXtSAqGhAAFn7oPPa4ag767.m4a\r\n第444章 盘根错节$http://audio.xmcdn.com/group44/M0A/48/3E/wKgKjFryXuDA1wThAFCsXbdRImM765.m4a\r\n第445章 我不这么认为$http://audio.xmcdn.com/group44/M0A/48/40/wKgKjFryXunhxjPFAFKuUKvgklk822.m4a\r\n第446章 稍加指点 打手出炉$http://audio.xmcdn.com/group43/M00/49/44/wKgKjVryXvWjy9kgAEyvy46jFOM052.m4a\r\n第447章 去讨账$http://audio.xmcdn.com/group43/M04/47/86/wKgKklryXv6DJi73AFMGoQnOlh8087.m4a\r\n第448章 黑丝与小包$http://audio.xmcdn.com/group44/M0A/48/42/wKgKjFryXw3jB0wlAFKfoY_SwZc712.m4a\r\n第449章 生死之间$http://audio.xmcdn.com/group44/M0A/48/44/wKgKjFryXxmCVwKnAFBM6PAj2Zc956.m4a', 'xml_8023', '3736', '', 'Q', '', '1.0', 9, 0, 0, 0, 'quannenxiaonongmin', ''),
(163, 17, '新农人 深夜', '', '未知', '', '', '', '新农人教育最新推出的专辑《新农人•深夜》，让声音陪伴你，孤单远离你。', 'http://imagev2.xmcdn.com/group27/M05/26/F7/wKgJW1qPcQuCC25wAACt0XJYlls825.jpg', '', 1530072235, 4, 0, 0, 0, 0, 1, 1, 3, 1, 'ting', '', '家的味道$http://audio.xmcdn.com/group38/M00/B4/91/wKgJolqPcrGi5m2wAD0440Gu5gA078.m4a\r\n又见春运$http://audio.xmcdn.com/group41/M08/69/16/wKgJ8VqXVy_i6fJQACDy_ASh7Hg371.m4a\r\n孝顺$http://audio.xmcdn.com/group40/M00/24/45/wKgJT1qh41PyppgEADcM3DE5aYg185.m4a\r\n总有一个人，温暖你生命$http://audio.xmcdn.com/group41/M02/D2/51/wKgJ8lqoyhSQsWhOAEZvM8LSwYs399.m4a\r\n这个母亲节，回家陪妈妈$http://audio.xmcdn.com/group44/M01/48/A5/wKgKjFryYw6j7OdEADCUscnxxT4760.m4a', 'xml_8023', '3734', '', 'X', '', '1.0', 2, 0, 0, 0, 'xinnongrenshenye', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(164, 17, 'ZLSC-凯叔城南旧事', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group44/M01/4A/AA/wKgKkVrydKzSO-LpAAQzeVglEJA999.png', '', 1530072235, 1, 0, 0, 0, 0, 1, 1, 2, 5, 'ting', '', '01城南旧事 预告片$http://audio.xmcdn.com/group44/M06/4A/56/wKgKjFrydO6Q34v1ABYjMFTfkzo685.m4a\r\n02城南旧事 序$http://audio.xmcdn.com/group43/M01/4B/5A/wKgKjVrydQaCW5k1AEDdWamlgDo844.m4a\r\n03惠安馆 第1集$http://audio.xmcdn.com/group44/M07/4A/58/wKgKjFrydRWhThqJADu7GALQjO8911.m4a\r\n04惠安馆 第2集$http://audio.xmcdn.com/group44/M07/4A/5B/wKgKjFrydR_R8OUBADzQoX-zHMc673.m4a\r\n05惠安馆 第3集$http://audio.xmcdn.com/group44/M07/4A/5D/wKgKjFrydSnyzIsdADTQYf809DQ014.m4a\r\n06惠安馆 第4集$http://audio.xmcdn.com/group43/M0B/49/A0/wKgKklrydT2zxzkjAEfc13a6YAo476.m4a\r\n07惠安馆 第5集$http://audio.xmcdn.com/group44/M0B/4A/60/wKgKjFrydU_g-2ZPADOqfBVHFgc038.m4a\r\n08惠安馆 第6集$http://audio.xmcdn.com/group44/M0B/4A/61/wKgKjFrydVORJ5ODAD1mbKcSE_E399.m4a\r\n09惠安馆 第7集$http://audio.xmcdn.com/group44/M08/4A/C0/wKgKkVrydWjjFtC-ADi7Gz-mB2w377.m4a\r\n10惠安馆 第8集$http://audio.xmcdn.com/group43/M07/4B/65/wKgKjVrydYCjyN-EAEObRNCVFVk316.m4a\r\n11惠安馆 第9集$http://audio.xmcdn.com/group43/M09/49/A8/wKgKklrydY7Dx8lBAD-EeVMhz9Q346.m4a\r\n12惠安馆 第10集$http://audio.xmcdn.com/group43/M09/4B/6C/wKgKjVrydaGywf-yAEUtnPXWYis143.m4a\r\n13惠安馆 第11集$http://audio.xmcdn.com/group43/M09/4B/6F/wKgKjVrydbPwPr8CAEY-vk44Zvk965.m4a\r\n14惠安馆 第12集$http://audio.xmcdn.com/group44/M0B/4A/66/wKgKjFrydb6AtjzWAEcDgkw09pQ700.m4a\r\n15惠安馆 第13集$http://audio.xmcdn.com/group44/M02/4A/C3/wKgKkVrydcqTOb2TAD53wOoHHSI471.m4a\r\n16惠安馆 第14集$http://audio.xmcdn.com/group44/M02/4A/C6/wKgKkVrydd2wrY2cAERl6ejZ3Oo407.m4a\r\n17惠安馆 第15集$http://audio.xmcdn.com/group44/M02/4A/6C/wKgKjFrydenQW9erADoPyJUjWX8246.m4a\r\n18惠安馆 第16集$http://audio.xmcdn.com/group44/M02/4A/6F/wKgKjFrydffCDh0hAD2p9hpmLYk383.m4a\r\n19惠安馆 第17集$http://audio.xmcdn.com/group44/M09/4A/CF/wKgKkVrydhXgpgwNAE5Zo-umNj4839.m4a\r\n20惠安馆 第18集$http://audio.xmcdn.com/group44/M09/4A/D0/wKgKkVrydheA86lcAD65oac_jrc066.m4a\r\n21惠安馆 第19集$http://audio.xmcdn.com/group43/M02/49/B4/wKgKklrydiqANyREAEi9twSTgMA691.m4a\r\n22我们看海去 第1集$http://audio.xmcdn.com/group43/M02/49/B6/wKgKklrydjewWwG8AD3KQwudR2I786.m4a\r\n23我们看海去 第2集$http://audio.xmcdn.com/group43/M0B/4B/79/wKgKjVrydkXzG50iAEHqEfvEvZs577.m4a\r\n24我们看海去 第3集$http://audio.xmcdn.com/group43/M0B/49/BA/wKgKklrydlGyQX7-ADhP6sIoBcA863.m4a\r\n25我们看海去 第4集$http://audio.xmcdn.com/group43/M0B/49/BE/wKgKklrydmCSvHTvAEBE2ZPE0Y0873.m4a\r\n26我们看海去 第5集$http://audio.xmcdn.com/group43/M0B/4B/81/wKgKjVrydmvSO6lYADoedzDnzu8987.m4a\r\n27我们看海去 第6集$http://audio.xmcdn.com/group44/M00/4A/77/wKgKjFrydn-Ao2NNAELymba-YSI572.m4a\r\n28我们看海去 第7集$http://audio.xmcdn.com/group44/M00/4A/7C/wKgKjFrydpPQkqX5AEkc9pCPxwI665.m4a\r\n29我们看海去 第8集$http://audio.xmcdn.com/group44/M0A/4A/DC/wKgKkVrydqrgsCHBAEc8x5AVqxQ540.m4a\r\n30兰姨娘 第1集$http://audio.xmcdn.com/group44/M0A/4A/DE/wKgKkVrydrCxaclsADzd2BQ3QFk718.m4a\r\n31兰姨娘 第2集$http://audio.xmcdn.com/group44/M0A/4A/DD/wKgKkVrydq7CQtaCABtJrhq8yaQ892.m4a\r\n32兰姨娘 第3集$http://audio.xmcdn.com/group43/M01/4B/86/wKgKjVrydsbwrKznAER3iEk8l8w511.m4a\r\n33兰姨娘 第4集$http://audio.xmcdn.com/group43/M01/4B/89/wKgKjVrydtjhFQQ2ADyu3LjNwGs292.m4a\r\n34兰姨娘 第5集$http://audio.xmcdn.com/group43/M01/4B/8B/wKgKjVryduLjKKM1AEGJX-eB9IY066.m4a\r\n35兰姨娘 第6集$http://audio.xmcdn.com/group44/M0A/4A/E2/wKgKkVrydvixCNZmAEyik_sF7a8803.m4a\r\n36驴打滚儿 第1集$http://audio.xmcdn.com/group44/M0A/4A/E5/wKgKkVrydwPBeV-oADdJEFV8Jig846.m4a\r\n37驴打滚儿 第2集$http://audio.xmcdn.com/group44/M04/4A/8F/wKgKjFrydxKB6pQTADrTGEkY5QY979.m4a\r\n38驴打滚儿 第3集$http://audio.xmcdn.com/group44/M01/4A/EB/wKgKkVrydxrSxbVIADm6nxcn1iY297.m4a\r\n39驴打滚儿 第4集$http://audio.xmcdn.com/group44/M04/4A/95/wKgKjFrydyryxbQwAD48zt_yaHo544.m4a\r\n40驴打滚儿 第5集$http://audio.xmcdn.com/group43/M0A/4B/90/wKgKjVrydzzSAOQIAD_NroiF4Ts702.m4a\r\n41爸爸的花儿落了 第1集$http://audio.xmcdn.com/group43/M0A/4B/93/wKgKjVryd0jhM5QnAEcK3FwR7gE006.m4a\r\n42爸爸的花儿落了 第2集$http://audio.xmcdn.com/group43/M0A/49/D5/wKgKklryd1rRTiLaAEXlLGys22E574.m4a\r\n43冬阳·童年·骆驼队$http://audio.xmcdn.com/group43/M0A/4B/98/wKgKjVryd2GQ2w5BADYKaXTPpa0268.m4a', 'xml_8023', '3733', '', 'Z', '', '1.0', 2, 0, 0, 0, 'ZLSCkaishuchengnanjiushi', ''),
(165, 17, '瞎比比英语', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group44/M00/3E/47/wKgKkVrxu_2CLHrDAASQNORBVWo433.jpg', '', 1530072235, 0, 0, 0, 0, 0, 1, 1, 10, 8, 'ting', '', '20180509微笑日你们微笑了吗？$http://audio.xmcdn.com/group44/M02/47/7C/wKgKkVryU8_TEWhNAC93l9s6sWo201.m4a\r\n20180509I Wandered Lonely As A Cloud by William Wordsworth.$http://audio.xmcdn.com/group44/M09/49/2E/wKgKkVryZOqwPVLYABU2kKaS0s4718.m4a', 'xml_8023', '3732', '', 'X', '', '1.0', 9, 0, 0, 0, 'xiabibiyingyu', ''),
(166, 17, '花都之窃梦偷香[每天更新中]', '', '未知', '', '', '', '蛰心控梦可令美女想入非非，窃取各种商业情报，甚至改造一个人的本性。摄心催眠可让人安然入睡，听从摆布。脚踏两星的刘旭从小被母亲遗弃，在养父母家里也被称为灾星。可在得到《醉梦心经》之后，他的命运彻底改变，成为彻头彻尾的福星。爱情上，各种美女接踵而至，纷纷倒追，淑女、寡妇、萝莉、御姐、女强、校花、警花，无数女明星希望被他潜规则，让他幸福的烦恼。事业上，凭借窃取来的各种情报，披荆斩棘，所向无敌，开创了世界第一工业帝国。。。。。。', 'http://imagev2.xmcdn.com/group34/M05/C2/33/wKgJYFnxhqrCRBItAAJPt3ZvKv8584.jpg', '', 1530072235, 7, 0, 0, 0, 0, 1, 1, 9, 8, 'ting', '', '开篇（万分感谢关注订阅点赞打赏）$http://audio.xmcdn.com/group42/M06/B2/C6/wKgJ9FrexLyxJRg8AA8WRStsJ2g470.m4a\r\n01 眼福（感谢关注订阅）$http://audio.xmcdn.com/group42/M05/AD/DD/wKgJ81rexTSTIUxPAFXaeCTtZQo168.m4a\r\n02 误会大了（感谢关注订阅）$http://audio.xmcdn.com/group40/M09/78/06/wKgJT1rexXSDMHruAFAVIWFR9bI546.m4a\r\n03 灾星（欢迎关注订阅点赞）$http://audio.xmcdn.com/group40/M01/78/AC/wKgJVFrexbnxELMUAFH6LhbdoRk261.m4a\r\n04 死猪不怕开水烫$http://audio.xmcdn.com/group42/M02/B2/DB/wKgJ9Frexe6DEDLrAE6ljebHbTM835.m4a\r\n05 老板娘的愁绪$http://audio.xmcdn.com/group40/M02/5B/69/wKgJT1rdbPbxvctKAE52fcET88E202.m4a\r\n06 张半仙（感谢关注订阅点赞）$http://audio.xmcdn.com/group40/M03/5C/33/wKgJVFrdbTKQCjetAFV5DKi9-Ak353.m4a\r\n07 脚踏两星$http://audio.xmcdn.com/group42/M07/96/7D/wKgJ9FrdbVqBwOn5AFTH9pgnpdY763.m4a\r\n08 发工资（感谢关注订阅点赞）$http://audio.xmcdn.com/group40/M07/5D/1D/wKgJVFrdelHjdfZuAEsAUsM_oOA748.m4a\r\n09 救命稻草（别忘记关注订阅点赞哦）$http://audio.xmcdn.com/group40/M04/89/AF/wKgJVFrfU87RZ02oAFMFqxBKtyM680.m4a\r\n10 抢客户（欢迎关注订阅点赞）$http://audio.xmcdn.com/group41/M06/C2/48/wKgJ8lrfVA7Q2nSjAD0ZtNxDFno129.m4a\r\n11 风水鱼（别忘记关注订阅点赞你哦）$http://audio.xmcdn.com/group41/M05/C9/44/wKgJ8VrgCFyTku34AFXBH5xk_pw367.m4a\r\n12 利诱（欢迎评论点赞）$http://audio.xmcdn.com/group40/M06/90/0F/wKgJT1rgCK2Su1cTAE9PFVQ-NGw140.m4a\r\n13 妙回堂（求推荐支持）$http://audio.xmcdn.com/group40/M01/90/E9/wKgJVFrgCRvDW1cvAFKMmwAhgB4167.m4a\r\n14 没开工资$http://audio.xmcdn.com/group42/M0B/CA/BE/wKgJ9FrgCVXDVFZuAFUVGvdNy7M450.m4a\r\n15 醉梦心经（欢迎评论）$http://audio.xmcdn.com/group40/M07/AA/1B/wKgJT1rhVOzDs21zAFDZ4tkF5YA122.m4a\r\n16 蛰心术（感谢关注订阅点赞）$http://audio.xmcdn.com/group17/M02/15/DC/wKgJJFrsT3_zHE8hAGPKBdiOJ64950.m4a\r\n17 第三颗痣（欢迎关注订阅点赞）$http://audio.xmcdn.com/group21/M06/33/EB/wKgJLVrsT-SSSRBLAFXoXymH_3I225.m4a\r\n18 试探（欢迎关注订阅点赞评论）$http://audio.xmcdn.com/group28/M08/B4/1C/wKgJXFrsUCSgmhWoAFQQNPsUSuM662.m4a\r\n19 观音显圣（欢迎关注订阅点赞评论）$http://audio.xmcdn.com/group42/M0B/46/77/wKgJ81rsUIjQwwl9AGZ2SWBMqmk039.m4a\r\n20 反悔了（求推荐支持）$http://audio.xmcdn.com/group17/M04/15/E1/wKgJJFrsURTwKbZ2AFGS7sMwBpA717.m4a\r\n21 嘉许（求推荐支持）$http://audio.xmcdn.com/group31/M09/E5/A5/wKgJSVrsUWLTvzAoAFOA2sRffLU172.m4a\r\n22 打赌（求推荐转发支持）$http://audio.xmcdn.com/group27/M0B/3F/35/wKgJR1ruyvGSTo-BAFdhDBDrrWw033.m4a\r\n23 请缨（点赞关注订阅）$http://audio.xmcdn.com/group25/M01/2F/FF/wKgJMVruy0LjcZyFAEkCknnc394483.m4a\r\n24 孤立（坚持听下去福利多多）$http://audio.xmcdn.com/group23/M06/3C/FF/wKgJL1ruy62A4iFyAEwIZR1gB7k187.m4a\r\n25 九仙居（欢迎关注订阅点赞评论）$http://audio.xmcdn.com/group31/M08/EA/92/wKgJSVruzF_T7SydAE1RUq4Lm7Q867.m4a\r\n26 拆台（坚持听下去后面福利多多）$http://audio.xmcdn.com/group33/M0A/69/6C/wKgJUVruzNug1bGrAE_EWOLzmk8350.m4a\r\n27 心灵力量（坚持听下去福利多多）$http://audio.xmcdn.com/group30/M00/5F/51/wKgJXlruzWDzBBj-AFcY63f5nWk711.m4a\r\n28 玛莎拉蒂（坚持听下去的后面福利多多）$http://audio.xmcdn.com/group17/M0B/1A/FE/wKgJKVruziWxTLlxAE7w4r1dBW8562.m4a\r\n29 喂狗的女人（别忘记关注订阅点赞）$http://audio.xmcdn.com/group44/M00/03/2F/wKgKjFrv6dmRJunkAFjkQfJC7e8185.m4a\r\n第三十章 胃出血（打赏vx:lan67986）$http://audio.xmcdn.com/group33/M09/19/3F/wKgJUVn9xpeQQWuNADI42X6NaHA752.m4a\r\n第三十一章 保人（万分感谢您的关注和订阅，求上推荐）$http://audio.xmcdn.com/group33/M00/42/98/wKgJUVn_HRqxYJgjACvA-eF-IIs720.m4a\r\n第三十二章 祈求（万分感谢您的订阅和关注，求上推荐）$http://audio.xmcdn.com/group33/M09/8C/46/wKgJTFn_HgCAgF0fAC9fZWTgQ-o273.m4a\r\n第三十三章 咄咄逼人$http://audio.xmcdn.com/group33/M04/42/F9/wKgJUVn_HwPzVgQKAC-HC7Pu6RY015.m4a\r\n第三十四章 伤上加伤（万分感谢您的关注和订阅，求推荐）$http://audio.xmcdn.com/group33/M0A/8C/DF/wKgJTFn_ITbxhpLrAC2EUTU-j0w013.m4a\r\n第三十五章 女儿家的心事$http://audio.xmcdn.com/group33/M02/8D/00/wKgJTFn_Ieai-tMsAC4I7Tv2ls8967.m4a\r\n第三十六章 失效（万分感谢您的关注和订阅，求推荐）$http://audio.xmcdn.com/group33/M03/8D/20/wKgJTFn_IpnAQqmTAC_2MdHRUfQ411.m4a\r\n第三十七章 英雄救美$http://audio.xmcdn.com/group33/M01/8D/35/wKgJTFn_IxqTEQfUACvxoouCYdE587.m4a\r\n第三十八章 蹲便（有了您的订阅关注，相信是一个好故事的诞生）$http://audio.xmcdn.com/group33/M09/8D/7C/wKgJTFn_JKuBJhrNAC1K13Kzafs364.m4a\r\n第三十九章 尿裤子$http://audio.xmcdn.com/group33/M05/44/18/wKgJUVn_JU6BBCLIACRfKSp2tGM331.m4a\r\n第四十章 上网（万分感谢您的订阅和关注，求推荐）$http://audio.xmcdn.com/group33/M0A/8D/D1/wKgJTFn_JqGzaXfvACsjgZi2GWs429.m4a\r\n第四十一章 酆都城（播讲水平越往后越提高，故事越来越精彩）$http://audio.xmcdn.com/group33/M05/B1/53/wKgJTFoAbyjAZSaoADEsISXqV-s206.m4a\r\n第四十二章 原委（万分感谢您的关注和订阅）$http://audio.xmcdn.com/group33/M09/67/E4/wKgJUVoAb86jZfZAADSErZ_0GuY878.m4a\r\n第四十三章 传票（万分感谢您的订阅和关注）$http://audio.xmcdn.com/group33/M03/D6/D0/wKgJTFoBx97iKQT9ADKkJNJnkpE866.m4a\r\n第四十四章 算出来的（播讲水平越往后越好，多多支持）$http://audio.xmcdn.com/group33/M0A/8D/4A/wKgJUVoByJ7yrkD3ADDJx-AVpTs825.m4a\r\n第四十五章 梦里乾坤$http://audio.xmcdn.com/group33/M0B/D7/05/wKgJTFoByPrRVDjFAD81cmUyiCc661.m4a\r\n第四十六章 九日（感谢小青蛙的打赏）$http://audio.xmcdn.com/group33/M00/AF/7C/wKgJUVoDERLR67_eADGAjZC3cAM306.m4a\r\n第四十七章 对质（打赏vx:lan67986）$http://audio.xmcdn.com/group33/M06/F9/5C/wKgJTFoDEfWQGOKEADLh2jw5k-g710.m4a\r\n第四十八章 敲诈（感谢石头哥的打赏）$http://audio.xmcdn.com/group33/M01/D2/BF/wKgJUVoEXx_Bkv0zAC7onTjhwtk624.m4a\r\n第四十九章 自找麻烦 （感谢李大大的打赏赞助）$http://audio.xmcdn.com/group33/M01/1C/C0/wKgJTFoEYCbBgx0nAC-RNGgDM8M719.m4a\r\n第五十章 凶案（播讲水平越来越好，请各位兄弟姐妹多多支持）$http://audio.xmcdn.com/group30/M03/D8/7D/wKgJXloFnT7CPYlpADDtKocywog331.m4a\r\n第五十一章 逼迫$http://audio.xmcdn.com/group30/M06/D8/86/wKgJXloFnfmxkzN_ACwKA4pXHYA410.m4a\r\n第五十二章 怀疑对象（说书不易求订阅求赞助）$http://audio.xmcdn.com/group33/M02/E3/23/wKgJUVoFn6OyR8VcAENgKhHyDw0287.m4a\r\n第五十三章 限期破案 （双11快乐，各位兄弟姐妹每天心情美美哒）$http://audio.xmcdn.com/group34/M04/08/C6/wKgJYFoHEszDz0iQAFAOwXlSg5o499.m4a\r\n第五十四章 头疼$http://audio.xmcdn.com/group33/M08/35/01/wKgJTFoHGi7BgjhTADM3BkgN2X8506.m4a\r\n第五十五章 病情的严重性 （求订阅，求赞助）$http://audio.xmcdn.com/group35/M01/01/AA/wKgJnVoJZeiw_Wj4ADEeGXRqCN4332.m4a\r\n第五十六章 通牒（请各位兄弟姐妹多多支持，打赏是动力）$http://audio.xmcdn.com/group35/M04/4B/9C/wKgJnFoJZknQNUb0AEt0Xt1cJ54136.m4a\r\n第五十七章 洛警官的豪气（感谢领悟的打赏，请大家多多支持）$http://audio.xmcdn.com/group35/M02/4B/AB/wKgJnFoJZq3yfgxlACsuBQeuXCQ245.m4a\r\n第五十八章 等着看笑话（说书不易求赞助求打赏）$http://audio.xmcdn.com/group35/M0B/75/C9/wKgJnFoKwdmRj0BWAFD6L6Jpz_s310.m4a\r\n第五十九章 阎罗天子（谢谢东哥的打赏）$http://audio.xmcdn.com/group35/M0B/75/D1/wKgJnFoKwhfAZRlGAEnhOcQWPjU345.m4a\r\n第六十章 明白人（求赞助订阅关注）$http://audio.xmcdn.com/group35/M0A/A1/DC/wKgJnFoMLsDxMd48AFwh31xyOzY423.m4a\r\n第六十一章 拉拢（谢谢李大叔的打赏）$http://audio.xmcdn.com/group35/M02/A1/FA/wKgJnFoMLymgABpYACm8GyL7Ffg159.m4a\r\n第六十二章 一拍而散（感谢特别笨的打赏）$http://audio.xmcdn.com/group35/M06/C3/FF/wKgJnFoNaemSnHaWACyzjq5PJ9c933.m4a\r\n第六十三章 车到山前必有路（交流群：115663670欢迎加入$http://audio.xmcdn.com/group35/M02/C4/1B/wKgJnFoNapTRFyS2AElBPRkRQIc169.m4a\r\n第六十四章 风水（感谢领悟的打赏）$http://audio.xmcdn.com/group35/M06/A0/FC/wKgJnVoOuUmjrRyFAC1zN-mnRqo631.m4a\r\n第六十五章 财神爷显灵（感冒了，请大家多见谅）$http://audio.xmcdn.com/group35/M09/EA/F1/wKgJnFoOudXBzSDhAFpWq1Cy_Pc506.m4a\r\n第六十六章 赌约升级（说书不易，求订阅关注赞助）$http://audio.xmcdn.com/group35/M04/EB/05/wKgJnFoOum3jj4jTACZO6DvhEaA773.m4a\r\n第六十七章 失灵（四连更，求打赏）$http://audio.xmcdn.com/group35/M08/C7/0B/wKgJnVoQFYyRsOlSAFhW5Lds3hw810.m4a\r\n第六十八章 按摩$http://audio.xmcdn.com/group35/M05/11/10/wKgJnFoQFiHxlvzwAEQOChd78Uc755.m4a\r\n第六十九章 再次显灵$http://audio.xmcdn.com/group35/M02/11/2A/wKgJnFoQFseTQ6HoADMEhoekhSQ579.m4a\r\n第七十章 财神位$http://audio.xmcdn.com/group35/M01/C7/4E/wKgJnVoQFymDvWqlADqaw0JxzYI051.m4a\r\n第七十一章 朱砂痣（感谢朋友们的支持）$http://audio.xmcdn.com/group35/M03/62/17/wKgJnFoSsUPyjEuxACoVC72Cu60028.m4a\r\n72章 扬威$http://audio.xmcdn.com/group35/M0B/18/47/wKgJnVoSsdvhVyZaADAuPobvXwc503.m4a\r\n73章 胜利的果实（交流群:115663670）$http://audio.xmcdn.com/group35/M0A/62/4E/wKgJnFoSsjrgBZlpACthM0vDJKY737.m4a\r\n74章 奖金（求赞助推荐转发）$http://audio.xmcdn.com/group35/M0A/98/98/wKgJnFoUGCTQdC_MACsAFp3dII8949.m4a\r\n75章 反噬$http://audio.xmcdn.com/group35/M05/98/B6/wKgJnFoUGISw3G0nAC5V5_hpcLQ373.m4a\r\n76章 入静之术（打赏vx:lan67986）$http://audio.xmcdn.com/group35/M07/4F/47/wKgJnVoUGQXwoSg-AC6rF7XHsbo529.m4a\r\n77章 欧宠$http://audio.xmcdn.com/group35/M01/ED/8D/wKgJnVoX0PXQCxWPAChvHgcsj8I289.m4a\r\n78章 兽医（求赏求推荐）$http://audio.xmcdn.com/group35/M03/C3/A7/wKgJnFoVVZmh_EUvACrYoaI3NgA902.m4a\r\n79章 单独沟通$http://audio.xmcdn.com/group35/M00/52/03/wKgJnFoYNjvDkLT8AEN8j4Q2hXQ483.m4a\r\n80章 朋友$http://audio.xmcdn.com/group35/M07/53/29/wKgJnFoYO0KDDE8tAEiYNCeoByE553.m4a\r\n81章 赔了夫人又折兵$http://audio.xmcdn.com/group35/M09/B7/CF/wKgJnFoa1Orj36U5AClNJ6OeLpI588.m4a\r\n82章 买衣服$http://audio.xmcdn.com/group35/M02/B8/DB/wKgJnFoa2jviuVDSACbhBMHSszw687.m4a\r\n83章 李在希（交流群:115663670）$http://audio.xmcdn.com/group35/M07/15/7E/wKgJnFoW9w6zDkb1ACsQsvfJCI4717.m4a\r\n84章 同学聚会$http://audio.xmcdn.com/group35/M07/30/2E/wKgJnVoZVZSSl5tyACmneHYSeJw267.m4a\r\n85章 杜教授（说书不易，求赏推荐）$http://audio.xmcdn.com/group35/M02/7A/21/wKgJnFoZVjjSfoWOADD2jHIVjzE114.m4a\r\n86章 aa制$http://audio.xmcdn.com/group35/M08/E1/5C/wKgJnFocFa-SZZMYACqo2AyUKe4358.m4a\r\n87章 寻衅$http://audio.xmcdn.com/group31/M09/78/E7/wKgJSVodIciiUsjIAClQW1ACHBU271.m4a\r\n88章 冯小蝶（求赏赞助）$http://audio.xmcdn.com/group30/M01/F8/76/wKgJXloesCXSTh2wAB4LbtEzeQ8041.m4a\r\n89章 面子$http://audio.xmcdn.com/group33/M08/10/17/wKgJUVog_IDRBB0mACja1-9ezn0612.m4a\r\n90章 失恋了$http://audio.xmcdn.com/group25/M08/EA/22/wKgJMVoj2qjRHPFJACovowacfmY966.m4a\r\n91章 赛狗（求赏赞助）$http://audio.xmcdn.com/group17/M03/D7/CA/wKgJJFolH3PS1PFEACz09dOz1wY597.m4a\r\n92章 传话$http://audio.xmcdn.com/group34/M08/47/A0/wKgJYFomXMqytkKOACyYdEiAUCQ868.m4a\r\n93章 以德抱怨$http://audio.xmcdn.com/group36/M0A/07/C4/wKgJUlonv-SDzOVYACyMpddfxro909.m4a\r\n94章 迁怒（感谢朋友们的支持）$http://audio.xmcdn.com/group36/M08/99/0E/wKgJUlopL4OiiBwYACvASz94WtI848.m4a\r\n95章 离家$http://audio.xmcdn.com/group36/M01/26/4C/wKgJUloqn7LDuEMjADCddFiZ_kc522.m4a\r\n96章 摄心术（打赏vx:lan67986）$http://audio.xmcdn.com/group36/M05/9A/15/wKgJUlor81Gx455MAFhIR-z4NXc436.m4a\r\n97章 楼下邻居$http://audio.xmcdn.com/group36/M00/14/66/wKgJUlotT1ryf5DtAEmQDy1AhAk642.m4a\r\n98章 狗王（后面更精彩哦）$http://audio.xmcdn.com/group36/M08/81/63/wKgJUlouoD3y1349ACySUwOk768540.m4a\r\n99章 针锋相对$http://audio.xmcdn.com/group37/M07/80/9E/wKgJoVo1MejR_IUhAFBjtJZHLDQ024.m4a\r\n100章 先声夺人（打赏vx:lan67986）$http://audio.xmcdn.com/group36/M0B/DE/65/wKgJUlo2SUXhaf-HAFMUXd3iGc4624.m4a\r\n101章 胜负$http://audio.xmcdn.com/group37/M09/41/45/wKgJoVo9q1XDS7o7AEys60WSnIM289.m4a\r\n102章 起落 （感谢朋友们的支持）$http://audio.xmcdn.com/group37/M0A/C1/BD/wKgJoFpDUXaSj1AIADGlzYpLwzw075.m4a\r\n103章 一人一半$http://audio.xmcdn.com/group37/M08/C1/E4/wKgJoVpDUgWhYKNCAEoNfMYa7JU759.m4a\r\n104章 买狗$http://audio.xmcdn.com/group36/M09/12/0A/wKgJUlpEo2-gx37EAEJhGuVrhMc574.m4a\r\n105章 张红辞职$http://audio.xmcdn.com/group36/M08/80/D8/wKgJTVpGJ53x465SABQeU14hJPE620.m4a\r\n106章 难关（感谢星河璀璨赞助）$http://audio.xmcdn.com/group36/M09/5C/07/wKgJUlpITAaDH0lrAE-RG0VCH7c571.m4a\r\n107章 秀色（鼓励的打赏是动力哦）$http://audio.xmcdn.com/group37/M09/4E/0A/wKgJoFpVx4Sg496nAFi1o56kcuA598.m4a\r\n108章 灌酒（万分感谢关注订阅）$http://audio.xmcdn.com/group26/M04/0B/5F/wKgJWFpW_tjyTqJHAE6OgkCHp30292.m4a\r\n109章 巧施援手$http://audio.xmcdn.com/group31/M09/B4/65/wKgJSVpYQKfRULIbAFR1h2r3qpw544.m4a\r\n110章 送老板娘回家（求赏求赞）$http://audio.xmcdn.com/group21/M02/05/E4/wKgJKFpZ7wTg5FJcAE5K9N95sbA029.m4a\r\n111章 走不了$http://audio.xmcdn.com/group19/M04/EB/1A/wKgJJlpba7qxZMA3AE8J6UI0Xe4741.m4a\r\n112章 地上凉$http://audio.xmcdn.com/group18/M03/EA/ED/wKgJKlpcRHvCf9oAADVz2ISD-i8942.m4a\r\n113章 心酸往事（打赏vx:lan67986）$http://audio.xmcdn.com/group32/M08/98/7C/wKgJS1pdU2WyEuUHAEPMlZH7UQQ736.m4a\r\n114章 培养信赖感$http://audio.xmcdn.com/group26/M09/1B/6E/wKgJWFpe-2_wonP-ADb8F8jKk_k329.m4a\r\n115章 相拥而眠（求推荐转发）$http://audio.xmcdn.com/group34/M04/61/76/wKgJYFpgQfHTLQgsADDa2QW6pVo540.m4a\r\n116章 婉拒$http://audio.xmcdn.com/group39/M02/05/80/wKgJnlphvSeS_OoXACx-BGCGERA092.m4a\r\n117章 步覆维艰$http://audio.xmcdn.com/group39/M05/2D/32/wKgJnlpjUSLT5nuCACtiH6NrW8I908.m4a\r\n118章 江彩妮的豪赌$http://audio.xmcdn.com/group38/M05/7F/AF/wKgJo1pm6O-TijzcACwDmqIqzts462.m4a\r\n119章 惨败（感谢星河璀璨赞助）$http://audio.xmcdn.com/group39/M09/9C/7D/wKgJn1pn-yzj0sGJACt4HoXAsJU736.m4a\r\n120章 兴师问罪$http://audio.xmcdn.com/group38/M0A/B8/0F/wKgJolppKITDeqOSACmVpz04Ixo000.m4a\r\n121章 你去给我赌（求推荐支持）$http://audio.xmcdn.com/group38/M05/E1/56/wKgJolpq2BKAAUN-ACqUiPiNz80343.m4a\r\n122章 想死想活$http://audio.xmcdn.com/group38/M09/00/A8/wKgJo1psQK3wG70SACx89_YDUAg256.m4a\r\n123章 慑服$http://audio.xmcdn.com/group38/M0B/21/AE/wKgJolptl_WAtXIIAC-3XeKwXT8939.m4a\r\n124章 揭短（求支持推荐）$http://audio.xmcdn.com/group39/M05/42/1A/wKgJn1puwTbg-GmWACrXO75g-_o147.m4a\r\n125章 重注（感谢关注订阅求赏赞）$http://audio.xmcdn.com/group39/M00/6D/4D/wKgJnlpwWgnSbXwpADRXDmzRHgU428.m4a\r\n126章 刘旭的手笔（欢迎关注订阅打赏）$http://audio.xmcdn.com/group38/M0A/85/86/wKgJo1pxZLmi-HncADB-Rk7lFSA127.m4a\r\n127章 一雪前耻（上）$http://audio.xmcdn.com/group38/M0A/A7/9D/wKgJolpy0YajpNyVADKLFNNY4ko639.m4a\r\n128章 一雪前耻（下）$http://audio.xmcdn.com/group39/M0A/D2/0A/wKgJnlp0av3ydvgFADWAEMbK94k420.m4a\r\n129章 我可不是随便的人$http://audio.xmcdn.com/group39/M09/ED/D2/wKgJnlp1nZagV6MXAC6vG_GvBKQ230.m4a\r\n130章 洗脚（别忘关注订阅打赏哦）$http://audio.xmcdn.com/group38/M01/0D/24/wKgJo1p244qDZRBLAC5s31t9SGc638.m4a\r\n新年快乐，感谢朋友们对小橘的支持$http://audio.xmcdn.com/group39/M09/6F/54/wKgJn1qFhX2AltrPAARmlQDr_5w473.m4a\r\n131章 看房风波$http://audio.xmcdn.com/group18/M09/05/56/wKgJKlqRToSx0HfqADFw4mXP4wE635.m4a\r\n132章 动手打人（求推荐支持）$http://audio.xmcdn.com/group35/M00/59/BA/wKgJnFqSuZ3Czv35ADQVCmtX11A345.m4a\r\n133章 义气$http://audio.xmcdn.com/group41/M08/0F/56/wKgJ8lqT-ynAiVWqADMGvReYCNs120.m4a\r\n134章 王鹏的妒火$http://audio.xmcdn.com/group42/M02/32/FC/wKgJ81qVXQDx25tmAFv5C0wu5jk487.m4a\r\n135章 两全$http://audio.xmcdn.com/group42/M0B/EF/19/wKgJ9Fqc5iiTRXNKAFapwsQ19ms094.m4a\r\n136章 老板娘哭了$http://audio.xmcdn.com/group42/M09/4B/75/wKgJ9Fqgz9OSshb2AFgy8v81gpY022.m4a\r\n137章 脚都给你洗啦，还差穿鞋吗$http://audio.xmcdn.com/group40/M0A/13/52/wKgJVFqg0CayF_Q-AFf1Rl8uELw514.m4a\r\n138章 睡我家$http://audio.xmcdn.com/group42/M06/4C/9F/wKgJ81qg0GTDmarvAFdTIDjtVS8758.m4a\r\n139章 柔美的梦$http://audio.xmcdn.com/group40/M01/C4/B5/wKgJVFqrTuWAzpcvAGLggjWjqBg031.m4a\r\n140 二砸招牌 上$http://audio.xmcdn.com/group41/M0B/43/7B/wKgJ8VqvVaSSxTCaAFC4PTrOyGA531.m4a\r\n141 二招牌砸 中（求赏求推荐）$http://audio.xmcdn.com/group41/M09/46/38/wKgJ8lqvVmnAQ_DCAF38ZnwTQW4353.m4a\r\n142 二砸招牌 下（打赏vx:lan67986）$http://audio.xmcdn.com/group40/M03/0B/BB/wKgJVFqvVeTBLtdeAFVFe4X-PJY125.m4a\r\n143 跟着李诗倩去行医$http://audio.xmcdn.com/group41/M03/48/1A/wKgJ8lqvdGOyPjX4AEI6RK7MPy8046.m4a\r\n144 哪行都有竞争$http://audio.xmcdn.com/group41/M06/59/5D/wKgJ8lqwWZLz5sIYAFOT3BYAa-o907.m4a\r\n145 无屑（求关注订阅推荐）$http://audio.xmcdn.com/group41/M07/56/C7/wKgJ8VqwWdaQGtVJAFM-NYZC6CY419.m4a\r\n146 拿酒来$http://audio.xmcdn.com/group41/M05/56/CB/wKgJ8VqwWhfgjYqVAE7f1MFdSGA724.m4a\r\n147 催眠师（连更求赏）$http://audio.xmcdn.com/group41/M08/59/6A/wKgJ8lqwWlGBLQR0AE_wLbRFnP4513.m4a\r\n148 唐璐瑶$http://audio.xmcdn.com/group40/M02/2E/B0/wKgJT1qxEoiCDa7lAGDw1WrHIvM745.m4a\r\n149 我恨（求赏推荐）$http://audio.xmcdn.com/group41/M01/78/3F/wKgJ8VqyOnLyMOUPAEzlrmwzPp0030.m4a\r\n150 异样的感觉$http://audio.xmcdn.com/group42/M02/78/F4/wKgJ9FqyOrjiNpDcAGBL9jn6Xlk539.m4a\r\n151 夜不能寐的刘韵诗$http://audio.xmcdn.com/group42/M05/8F/A8/wKgJ9FqzjJzBG8iHAF0fKpd4CNQ093.m4a\r\n152 高薪诚聘$http://audio.xmcdn.com/group41/M0B/7B/C4/wKgJ8lrB11eDjaRoAEuV29nyUjc931.m4a\r\n153 救命$http://audio.xmcdn.com/group40/M06/40/5A/wKgJT1rB16OyZw6uAFLC3oN99xk383.m4a\r\n154 阴阳合同$http://audio.xmcdn.com/group40/M02/6D/1F/wKgJT1rEHKKRXveFAE-e4f_8Oyk995.m4a\r\n155 公报私仇$http://audio.xmcdn.com/group41/M07/A5/8E/wKgJ8VrEHNPSyiTtADpcJ9uABqM163.m4a\r\n156 把人给我要出来$http://audio.xmcdn.com/group42/M0A/40/7A/wKgJ81rMSILSdSPBAEmcgY04vSQ419.m4a\r\n157 请神容易送神难$http://audio.xmcdn.com/group40/M02/09/5C/wKgJT1rMSMPDzR8AAEe-SN2YBs8492.m4a\r\n158 想敷衍老子没门$http://audio.xmcdn.com/group41/M02/5A/FF/wKgJ8VrNkt7iAbg8AEhICGUkMR0507.m4a\r\n159 铁板$http://audio.xmcdn.com/group41/M04/5B/04/wKgJ8VrNkxLRPWxrAEbtk4zxgW0891.m4a\r\n160 公道$http://audio.xmcdn.com/group41/M04/77/6E/wKgJ8lrPAMCQOA6PAEVktqBTjJk995.m4a\r\n161 要挟赵主任$http://audio.xmcdn.com/group41/M07/77/71/wKgJ8VrPAP3hzAsCAEykDLHXA7Q770.m4a\r\n162 公平公正$http://audio.xmcdn.com/group40/M08/3D/6F/wKgJT1rPAVrTfmXrAE87ELL-m6c924.m4a\r\n163 康晴的坏脾气$http://audio.xmcdn.com/group40/M06/53/6E/wKgJVFrP_jvSPgUhAE8X75yAX5Q311.m4a\r\n164 方小茹的突然来电$http://audio.xmcdn.com/group41/M06/8C/9E/wKgJ8lrP_oHS7QXkAFIzF2YF2TM465.m4a\r\n165 醉酒的女人$http://audio.xmcdn.com/group42/M01/A6/5C/wKgJ81rReJTDLVywAFl3BfJ7EL4867.m4a\r\n166 明明自有安排$http://audio.xmcdn.com/group41/M03/D0/91/wKgJ8lrTQGnjzdeOAFacU0TFS1Y415.m4a\r\n167 做你的女人（欢迎点赞打赏说书不易）$http://audio.xmcdn.com/group40/M0A/96/E5/wKgJT1rTQLTxMtzvAFJH3Z-XkU0433.m4a\r\n168 大礼$http://audio.xmcdn.com/group42/M04/96/6B/wKgJ9FrdbFmgptHPAE31yL0A80M859.m4a\r\n169 妈（求推荐支持）$http://audio.xmcdn.com/group41/M0B/B1/0F/wKgJ8lrew4OhF2C3AFaTemh0t0Y584.m4a\r\n170 如何解决$http://audio.xmcdn.com/group40/M0A/78/87/wKgJVFrew6nQoEM7AFnijqoVEPw084.m4a\r\n171 梦里人声$http://audio.xmcdn.com/group41/M09/C9/2D/wKgJ8VrgBxaj5R_fAGLTygZKnD0760.m4a\r\n172 接管大阳饭店$http://audio.xmcdn.com/group42/M04/E4/75/wKgJ9FrhVBSBpxAhAE4db2ZKcL0674.m4a\r\n173 合资（求打赏）$http://audio.xmcdn.com/group42/M0A/DF/B4/wKgJ81rhVKvBTsToAEwwSfAwR9s065.m4a\r\n174 贵人（欢迎评论）$http://audio.xmcdn.com/group42/M0A/46/3C/wKgJ81rsOeqCfxAIAE5wHvxHpl4185.m4a\r\n175 大礼（求推荐）$http://audio.xmcdn.com/group26/M00/3E/41/wKgJRlrsUfOgRLRlAFFMaLriboM759.m4a\r\n176 确定关系$http://audio.xmcdn.com/group28/M0A/B7/84/wKgJSFruyqSiVG-IAFZRTArVqnA604.m4a\r\n177 诗梦量贩式ktv$http://audio.xmcdn.com/group43/M03/02/6E/wKgKklrv6SvQ0hlGAFNVwBKUris529.m4a\r\n178 连环计（别忘记打赏赞助）$http://audio.xmcdn.com/group43/M0B/04/2A/wKgKjVrv6Yfge7ADAEgze5VsQW4328.m4a\r\n179 纵犬（说书不易喜欢打赏赞助）$http://audio.xmcdn.com/group44/M05/03/E0/wKgKkVrv7AfCw7bKAEo_9GWPDq8613.m4a\r\n180 还想倒打一耙$http://audio.xmcdn.com/group43/M02/4A/BD/wKgKklryf3fB-4TOAEnUgiMouEQ254.m4a\r\n181 我管你是谁的朋友$http://audio.xmcdn.com/group44/M08/4B/E3/wKgKkVryf66hlG4cAEtu_mmmAq8983.m4a\r\n182 主题音乐节（说书不易喜欢打赏赞助）$http://audio.xmcdn.com/group43/M00/4A/CA/wKgKklryf_mz4tm_AE993ONfgRU342.m4a', 'xml_8023', '3731', '', 'H', '', '1.0', 10, 0, 0, 0, 'huaduzhiqiemengtouxiangmeitiangengxinzhong', ''),
(167, 15, '有声小说&lt;藏海花&gt; 骆驼演播[第一部]', '', '未知', '', '', '', '更多更新动态请关注微信平台：dubber_camel 新浪微博@Big刀', 'http://imagev2.xmcdn.com/group1/M00/05/31/wKgDrlDVtvyTmNghAABGEc0QhqE021.jpg', '', 1530072261, 4, 0, 0, 0, 0, 1, 1, 7, 6, 'ting', '', '骆驼-藏海花001 修正版.mp3$http://audio.xmcdn.com/group13/M04/20/87/wKgDXVV7X7yxMKJhADfJoEljs0A753.m4a\r\n骆驼-藏海花002.mp3$http://audio.xmcdn.com/group15/M0B/1E/08/wKgDaFV5BdfjSjEmADmchlSBXCA614.m4a\r\n骆驼-藏海花003 修正版.mp3$http://audio.xmcdn.com/group11/M07/4E/2D/wKgDa1WyMDOjyfQcAEEoPicpriU808.m4a\r\n骆驼-藏海花004.mp3$http://audio.xmcdn.com/group7/M06/23/AB/wKgDWlV--smzvIqzAECcRCwiy3Q732.m4a\r\n骆驼-藏海花005.mp3$http://audio.xmcdn.com/group8/M04/4D/89/wKgDYFWx0tHyZmYwAFPImzGTsfo790.m4a\r\n骆驼-藏海花006.mp3$http://audio.xmcdn.com/group12/M08/1D/F1/wKgDXFV5OyLS3icOAF-mR8owvx8227.m4a\r\n骆驼-藏海花007.mp3$http://audio.xmcdn.com/group8/M07/3E/75/wKgDYVWfpG6hij-qAGKIn86fE70992.m4a\r\n骆驼-藏海花008.mp3$http://audio.xmcdn.com/group10/M04/4F/47/wKgDZ1WzdrqDApUzAGS70cKPzWk386.m4a\r\n骆驼-藏海花009.mp3$http://audio.xmcdn.com/group13/M05/4A/C8/wKgDXVWuYSjh9GGGAEt8J0ZSX_Q045.m4a\r\n骆驼-藏海花010.mp3$http://audio.xmcdn.com/group14/M05/33/AF/wKgDZFWTRKbzKQlvAFFVElZw8Kk653.m4a\r\n骆驼-藏海花011.mp3$http://audio.xmcdn.com/group15/M0A/23/F9/wKgDZVV_jH-jCi9sADpov6kxPPc071.m4a\r\n骆驼-藏海花012.mp3$http://audio.xmcdn.com/group7/M06/23/AC/wKgDWlV--s3ThDPuAE9Td5OndVY159.m4a\r\n骆驼-藏海花013.mp3$http://audio.xmcdn.com/group8/M00/4A/B6/wKgDYVWuYS_R37ZXAGM9lyQqySM187.m4a\r\n骆驼-藏海花014.mp3$http://audio.xmcdn.com/group13/M00/3B/B4/wKgDXVWcfivx3ip5AEOemsQiFMA324.m4a\r\n骆驼-藏海花015.mp3$http://audio.xmcdn.com/group15/M01/39/F2/wKgDZVWapNmSyTiqAEkaRHpZ_vw207.m4a\r\n骆驼-藏海花016.mp3$http://audio.xmcdn.com/group8/M09/1B/CC/wKgDYFV29AWTSDW5AE4s1HWacxA513.m4a\r\n骆驼-藏海花017.mp3$http://audio.xmcdn.com/group11/M01/2B/7D/wKgDbVWIssjSUIWvAFDsKPDJq5I975.m4a\r\n骆驼-藏海花018.mp3$http://audio.xmcdn.com/group15/M06/33/C1/wKgDaFWTRLKBINyyADztp2BvlCs656.m4a\r\n骆驼-藏海花019.mp3$http://audio.xmcdn.com/group10/M00/4F/B4/wKgDaVWz1-PgqQrbAFvvA6LhAV4267.m4a\r\n骆驼-藏海花020.mp3$http://audio.xmcdn.com/group10/M02/2B/C0/wKgDaVWJAc2j0xyfAFyg7aSVlAA396.m4a\r\n骆驼-藏海花021.mp3$http://audio.xmcdn.com/group10/M01/20/6C/wKgDaVV7X73DZlWCAFdLP91cfVk694.m4a\r\n骆驼-藏海花022.mp3$http://audio.xmcdn.com/group12/M03/1C/76/wKgDXFV3wnrg67DSAG2Im2RbkK8121.m4a\r\n骆驼-藏海花023.mp3$http://audio.xmcdn.com/group13/M04/3A/1F/wKgDXlWa-fPg00PiAFEPFZK7eQg477.m4a\r\n骆驼-藏海花024.mp3$http://audio.xmcdn.com/group12/M08/48/BD/wKgDXFWs1J_y-2dBAFQC-NvoEpA316.m4a\r\n骆驼-藏海花025.mp3$http://audio.xmcdn.com/group12/M09/3C/7B/wKgDW1Wdf3_Q9533AGc92t377Ko705.m4a\r\n骆驼-藏海花026.mp3$http://audio.xmcdn.com/group7/M06/45/EB/wKgDWlWmvSyy0CHpAGF5PD7LUgM555.m4a\r\n骆驼-藏海花027.mp3$http://audio.xmcdn.com/group11/M06/2D/55/wKgDa1WKR_WhafyKAFPf5_kj_7s483.m4a\r\n骆驼-藏海花028.mp3$http://audio.xmcdn.com/group9/M08/34/CF/wKgDYlWUqkijHOowAFazsUE7_T0163.m4a\r\n骆驼-藏海花029.mp3$http://audio.xmcdn.com/group10/M02/2B/C0/wKgDaVWJAc6yFrq2AF2h0F4MM08326.m4a\r\n骆驼-藏海花030.mp3$http://audio.xmcdn.com/group15/M02/1F/4C/wKgDZVV6P5OgBpUVAFvsGCO-U_k833.m4a\r\n骆驼-藏海花031.mp3$http://audio.xmcdn.com/group10/M02/48/A9/wKgDZ1WssqCSuFV9AFr58OI2HhM902.m4a\r\n骆驼-藏海花032.mp3$http://audio.xmcdn.com/group15/M05/47/7A/wKgDaFWoTt-y2EOuAF146lOC53M247.m4a\r\n骆驼-藏海花033.mp3$http://audio.xmcdn.com/group7/M08/20/0E/wKgDX1V6yYeipdTWAFl1sBuwW_o287.m4a\r\n骆驼-藏海花034.mp3$http://audio.xmcdn.com/group11/M04/4B/D8/wKgDbVWvf2TjvI15AHg50azivhw998.m4a\r\n骆驼-藏海花035.mp3$http://audio.xmcdn.com/group7/M09/40/3A/wKgDX1WgaTfSaenoAHm1LNmZnjQ973.m4a\r\n骆驼-藏海花036.mp3$http://audio.xmcdn.com/group13/M04/50/6A/wKgDXVW0NnGBHBzhAH4-qj2sy5s627.m4a\r\n骆驼-藏海花037.mp3$http://audio.xmcdn.com/group16/M00/41/76/wKgDalWiF3KjVFU-AHBDY9OZF1M204.m4a\r\n骆驼-藏海花038.mp3$http://audio.xmcdn.com/group12/M09/1E/33/wKgDXFV5dBaxVV67AJfi81xzzUk460.m4a\r\n骆驼-藏海花039.mp3$http://audio.xmcdn.com/group12/M02/2A/09/wKgDXFWGVEziEpMoAIdqzFQ2_fE470.m4a\r\n骆驼-藏海花040.mp3$http://audio.xmcdn.com/group7/M08/2B/EE/wKgDX1WJAgHQk9gmAHCy68n8yVE895.m4a\r\n骆驼-藏海花041.mp3$http://audio.xmcdn.com/group14/M00/4A/E7/wKgDZFWuYa7wFmwnAIJ0vRV3Y-c279.m4a\r\n骆驼-藏海花042.mp3$http://audio.xmcdn.com/group10/M09/39/16/wKgDaVWaVt3Qb-miAKJG5usTB2E921.m4a\r\n骆驼-藏海花043（第一部结束）.mp3$http://audio.xmcdn.com/group14/M01/49/54/wKgDY1Ws2ITyW1qcAMV3NgG_cIs889.m4a', 'xml_8023', '4741', '', 'Y', '', '1.0', 7, 0, 0, 0, 'youshengxiaoshuoltcanghaihuagtluotuoyanbodiyibu', ''),
(168, 15, '东野圭吾《玫瑰与匕首》[完结][内有两本][豆蔻禾]', '', '未知', '', '', '', '两任不同的妻子。 两个同父异母的姐妹。 一个伴随父亲亲密无间；一个沉默寡言无法融入家庭。 一个严守着肚中孩子父亲的秘密；一个于家中被人残忍刺死！ 这一切，究竟是谁的罪孽？！ 惊天秘密的悲剧！让自我而又深沉的沉的父爱面临崩溃！ 她们，究竟是带刺的玫瑰？还是冰冷的匕首？', 'http://imagev2.xmcdn.com/group25/M09/ED/EC/wKgJNlhcwXfg1oOUAAEGuttStJs600.jpg', '', 1530072261, 2, 0, 0, 0, 0, 1, 1, 3, 2, 'ting', '', '《玫瑰与匕首》第一节（你肚子里的孩子是谁的？！）$http://audio.xmcdn.com/group24/M02/50/93/wKgJMFgv32CQz-Y0ADBm8btBn5k753.m4a\r\n《玫瑰与匕首》第二节（侦探俱乐部的一男一女）$http://audio.xmcdn.com/group24/M08/50/A5/wKgJNVgv4ZiybGN9AD9VRo3o_dY622.m4a\r\n《玫瑰与匕首》第三节（躺在由里子身边的男人）$http://audio.xmcdn.com/group24/M04/50/A7/wKgJMFgv5tzD-x2lABWu-E-_bt4974.m4a\r\n《玫瑰与匕首》第四节 1（父亲的助手们）$http://audio.xmcdn.com/group24/M0A/50/B9/wKgJMFgv7iXyRzH8ACBtWKm_UJ4851.m4a\r\n《玫瑰与匕首》第四节 2（难以融入家庭的姐姐）$http://audio.xmcdn.com/group21/M0B/51/FF/wKgJKFgwVE2xq2IEACvAC3U33Zc425.m4a\r\n《玫瑰与匕首》第五节 1（直子死在了床上）$http://audio.xmcdn.com/group25/M05/52/29/wKgJNlgwXHGAIzD9AB_F87xXce4581.m4a\r\n《玫瑰与匕首》第五节 2（要杀的，是由里子。。。）$http://audio.xmcdn.com/group22/M08/52/63/wKgJLlgwXMKQA9LwAC7Y_wrTmNI692.m4a\r\n《玫瑰与匕首》第五节 3（由里子的男朋友是凶手吗？）$http://audio.xmcdn.com/group21/M03/5B/C2/wKgJKFgz4kWz41-tAEHivKIA4OU330.m4a\r\n《玫瑰与匕首》第六节 1（工于心计的神崎君）$http://audio.xmcdn.com/group23/M00/5B/F3/wKgJNFgz4rSTfjF6ADFjglxd4bw512.m4a\r\n《玫瑰与匕首》第六节 2（神崎，自杀了。。。）$http://audio.xmcdn.com/group23/M05/5B/F7/wKgJL1gz5YrBtVBvACTd7AQMv3k027.m4a\r\n《玫瑰与匕首》第七节（同一把刀子）$http://audio.xmcdn.com/group23/M09/5C/37/wKgJNFgz-wPiqdJnABJyx5YcVYA874.m4a\r\n《玫瑰与匕首》第八节（来找上野的美丽女人）$http://audio.xmcdn.com/group25/M0A/5B/C6/wKgJMVgz_fuS3d7rACf1aXbXubI798.m4a\r\n《玫瑰与匕首》第九节 1（神崎也是被杀的！）$http://audio.xmcdn.com/group24/M03/5C/21/wKgJMFg0AZeB6E3SAC22P2tx5_c802.m4a\r\n《玫瑰与匕首》第九节 2（电话线的窍门）$http://audio.xmcdn.com/group24/M02/67/31/wKgJMFg4BmWwa5sJACP3X89bZyc381.m4a\r\n《玫瑰与匕首》第九节 3（他们，一起杀死了直子）$http://audio.xmcdn.com/group23/M09/67/79/wKgJNFg4BtXCUFhQAB4mY9t-FK0492.m4a\r\n《玫瑰与匕首》第九节 4（她，不是我的女儿。。。）$http://audio.xmcdn.com/group23/M07/68/9B/wKgJL1g4QqnC5veIADP5xtZ4F5M315.m4a\r\n《玫瑰与匕首》第九节 5（最后的电话）（完结）$http://audio.xmcdn.com/group24/M09/68/47/wKgJNVg4Q7DSu1-LABFXXDhS9WQ355.m4a\r\n（Tomorrow）感谢您的聆听与陪伴。$http://audio.xmcdn.com/group22/M06/32/C6/wKgJM1ht9E3DLCFcADTjQXEqCVA720.m4a\r\n一、外站过夜，杀人之夜 第一章 1（怀基基，AB组合）$http://audio.xmcdn.com/group24/M03/77/B4/wKgJNVh3HyLRPMeKADoc_8Liu5s918.m4a\r\n一、外站过夜，杀人之夜 第一章 2（腹痛的银发族熟男）$http://audio.xmcdn.com/group24/M01/77/9A/wKgJMFh3IGqy0CadAEJypfqqVvY118.m4a\r\n一、外站过夜，杀人之夜 第二章 1（银发族熟男的太太死了）$http://audio.xmcdn.com/group25/M02/68/29/wKgJNlh0zYvDmm26ACuRDiht7dA508.m4a\r\n一、外站过夜，杀人之夜 第二章 2（她还穿着高跟鞋呢）$http://audio.xmcdn.com/group21/M05/67/A6/wKgJLVh0zhOwa4mWACi1xnCdAK4439.m4a\r\n一、外站过夜，杀人之夜 第三章 1（记忆力很好的重要证人）$http://audio.xmcdn.com/group25/M08/68/06/wKgJMVh0zoOwaXOWACEwqDZljAw935.m4a\r\n一、外站之夜，杀人之夜 第三章 2（侄子的不在场证明）$http://audio.xmcdn.com/group22/M07/68/AA/wKgJLlh0z1uTspZsADhnZgrW36U138.m4a\r\n一、外站过夜，杀人之夜 第四章 1（就是在怀疑他）$http://audio.xmcdn.com/group25/M03/77/6A/wKgJMVh3II-QnLfqADI1fu_qUnA307.m4a\r\n一、外站过夜，杀人之夜 第四章 2（后槽牙卡着鱼刺的感觉）$http://audio.xmcdn.com/group25/M03/77/6D/wKgJMVh3IKPwayC9ABu6ts6XaLw367.m4a\r\n一、外站过夜，杀人之夜 第五章 1（能不能找到那家面包店？）$http://audio.xmcdn.com/group22/M0A/77/DA/wKgJLlh3IL_hfqg6ACYfg9LPnoA927.m4a\r\n一、外站过夜，杀人之夜 第五章 2（您的班机，在那边。。。）$http://audio.xmcdn.com/group21/M0B/76/D6/wKgJLVh3IM_ymNAYADJOdWrVH98526.m4a\r\n二、请带齐您的随身物品 第一章 1（婴儿旅行团）$http://audio.xmcdn.com/group22/M03/77/DF/wKgJLlh3IRLSZ1FOABr70DVFJro238.m4a\r\n二、请带齐您的随身物品 第一章 2（二十五个小恶魔）$http://audio.xmcdn.com/group23/M03/77/D1/wKgJNFh3IU6jutxWAC28HY70rZA424.m4a\r\n二、请带齐您的随身物品 第一章 3（谁把你落下了？）$http://audio.xmcdn.com/group24/M05/77/C3/wKgJNVh3IWLTFg-jACirfbWCatQ064.m4a\r\n二、请带齐您的随身物品 第二章 1（失物招领处不接收）$http://audio.xmcdn.com/group23/M06/77/D1/wKgJNFh3IWyQFP2MACZHJk6eTuc363.m4a\r\n二、请带齐您的随身物品 第二章 2（唱孤独先生给你听）$http://audio.xmcdn.com/group25/M07/77/A1/wKgJNlh3IZnxU7ONACJTaeKIZF4905.m4a\r\n二、请带齐您的随身物品 第三章（和你一起上电视喽！）$http://audio.xmcdn.com/group22/M08/77/A0/wKgJM1h3IcGyqw_5AC7LyMnZ_wY110.m4a\r\n二、请带齐您的随身物品 第四章 1（粗心的妈妈来了）$http://audio.xmcdn.com/group22/M01/77/E4/wKgJLlh3IcvTEYdCACMZpJDqAx8249.m4a\r\n二、请带齐您的随身物品 第四章 2（可能是抱错的吗？）$http://audio.xmcdn.com/group25/M08/77/82/wKgJMVh3I9XRi-wMACTrJMbdDxQ158.m4a\r\n二、请带齐您的随身物品 第四章 3（完美的掉包）$http://audio.xmcdn.com/group23/M04/77/D6/wKgJNFh3IfrwzZ3qAEOJpSJJaUw595.m4a\r\n二、请带齐您的随身物品 第五章（对一个母亲的最强报复）$http://audio.xmcdn.com/group25/M02/77/79/wKgJMVh3Ij6zk_RQADsoQFMjW1A965.m4a\r\n三、相亲席上的灰姑娘 第一章 1（飞机上的“相亲席”）$http://audio.xmcdn.com/group23/M01/77/D8/wKgJNFh3IouTroLnACxr230KfYU669.m4a\r\n三、相亲席上的灰姑娘 第一章 2（绝世好男人）$http://audio.xmcdn.com/group21/M09/77/21/wKgJKFh3IqHzfdxmABjE_ugOJOw747.m4a\r\n三、相亲席上的灰姑娘 第二章 1（约会哦约会！）$http://audio.xmcdn.com/group23/M0B/78/3C/wKgJL1h3IrSTUaUrABgAkFkZ4Qk302.m4a\r\n三、相亲席上的灰姑娘 第二章 2（跟我结婚吧）$http://audio.xmcdn.com/group22/M09/7F/AB/wKgJM1h4VAzC9-C0AEDtgO5ePVM394.m4a\r\n三、相亲席上的灰姑娘 第二章 3（我要嫁入豪门！）$http://audio.xmcdn.com/group23/M09/80/53/wKgJL1h4VCaig1R-ADpmazLUvtQ422.m4a\r\n三、相亲席上的灰姑娘 第三章 1（各位，介绍下我的未婚妻）$http://audio.xmcdn.com/group24/M05/7F/DD/wKgJNVh4VGWwSebFAEMnQiFTHoE901.m4a\r\n三、相亲席上的灰姑娘 第三章 2（喜欢我未婚夫很久的表妹）$http://audio.xmcdn.com/group24/M05/7F/AD/wKgJMFh4VFbhk_DNACKokXn5vtQ587.m4a\r\n三、相亲席上的灰姑娘 第四章（是假装结婚啦）$http://audio.xmcdn.com/group21/M00/7F/1B/wKgJKFh4VHWCxVMEACO4PJPR7KU426.m4a\r\n三、相亲席上的灰姑娘 第五章（他真正的新娘是。。！）$http://audio.xmcdn.com/group25/M05/7F/E1/wKgJNlh4VImjgVpoADbB-N9yH14853.m4a\r\n四、神秘伴侣之谜 第一章（两个乘客，两段对话）$http://audio.xmcdn.com/group24/M08/80/27/wKgJNVh4X4rSRXDZADJ9cmJjOP8591.m4a\r\n四、神秘旅伴之谜 第二章 1（S酒店的两具尸体）$http://audio.xmcdn.com/group25/M03/80/01/wKgJMVh4X7ry3oAkACLx_ZW5bkg571.m4a\r\n四、神秘旅伴之谜 第二章 2（到底是谁自杀？）$http://audio.xmcdn.com/group25/M03/80/04/wKgJMVh4X8zApGgqACoWMsVvki4486.m4a\r\n四、神秘旅伴之谜 第三章 1（纯属偶然？）$http://audio.xmcdn.com/group21/M05/7F/64/wKgJKFh4X-nyBgKuABzO1OlA1H8800.m4a\r\n四、神秘旅伴之谜 第三章 2（分手演变的情杀？）$http://audio.xmcdn.com/group22/M03/80/3B/wKgJLlh4X_zD7QbTACgUP4OKeGs819.m4a\r\n四、神秘旅伴之谜 第四章 1（选择厕所之地为情自杀？）$http://audio.xmcdn.com/group23/M04/80/53/wKgJNFh4YC2wUzOGACvzbq7reyE204.m4a\r\n四、神秘旅伴之谜 第四章 2（高额人寿保险和富田太太）$http://audio.xmcdn.com/group23/M04/80/56/wKgJNFh4YDzzZa5vADVXQ4zcMoc756.m4a\r\n四、神秘旅伴之谜 第四章 3（富田太太的坚持）$http://audio.xmcdn.com/group21/M09/7F/25/wKgJLVh4YFGQnnk2ADMLAX0U3_w034.m4a\r\n四、神秘旅伴之谜 第四章 4（守口如瓶）$http://audio.xmcdn.com/group21/M09/7F/6B/wKgJKFh4YGeSx4DZADDlPLNrLvI568.m4a\r\n五、重要失物 第一章（遗书乍现）$http://audio.xmcdn.com/group21/M01/7F/2A/wKgJLVh4YROx01xWAAj-zLsS9y8133.m4a\r\n五、重要失物 第二章 1（排排队上卫生间的人）$http://audio.xmcdn.com/group25/M06/80/35/wKgJNlh4YTyzNkDKABrUKdAsCkQ189.m4a\r\n五、重要失物 第二章 2（您要糖果吗？）$http://audio.xmcdn.com/group22/M05/80/46/wKgJLlh4YVTAUo_lADJaNqdpIuQ002.m4a\r\n五、重要失物 第二章 3（根本没署名！）$http://audio.xmcdn.com/group24/M00/80/35/wKgJNVh4YXjSKb1NACTYCi-VL-w359.m4a\r\n五、重要失物 第三章 1（是草鞋的鞋印？）$http://audio.xmcdn.com/group24/M00/80/39/wKgJNVh4YZKjIjILAB33ZqCqepE470.m4a\r\n五、重要失物 第三章 2（老成的女初中生和吵架男女）$http://audio.xmcdn.com/group21/M0A/7F/2F/wKgJLVh4YcCC0LkxAClndN1cITk473.m4a\r\n五、重要失物 第三章 3（遗书。。撕碎。。扔了。。）$http://audio.xmcdn.com/group21/M0A/7F/73/wKgJKFh4YcqCp7WIABqz3ALRyb0588.m4a\r\n五、重要失物 第四章（遗书的真正主人）$http://audio.xmcdn.com/group23/M0A/80/B2/wKgJL1h4YeXxSMkoADOItwPp8h0483.m4a\r\n五、重要失物 第五章（小A的推理和小B的推理）$http://audio.xmcdn.com/group25/M04/80/10/wKgJMVh4YffCvzmZAEyFNTP__3E982.m4a\r\n六、幻影乘客 第一章（打电话来的凶手）$http://audio.xmcdn.com/group21/M01/7F/90/wKgJKFh4ZZKwmBVFACZV1SAxnoo802.m4a\r\n六、幻影乘客 第二章（带血的奢侈女包）$http://audio.xmcdn.com/group22/M0B/80/62/wKgJLlh4ZaOAO5sEADc9UGe-_pk553.m4a\r\n六、幻影乘客 第三章（那，那肯定有隐情！）$http://audio.xmcdn.com/group22/M0B/80/21/wKgJM1h4Za3BrbD3ABGMO9AGG4M388.m4a\r\n六、幻影乘客 第四章 1（你可真爱翻包啊！）$http://audio.xmcdn.com/group23/M0B/80/CF/wKgJL1h4ZcCCDKFyACDLVcj0GuE078.m4a\r\n六、幻影乘客 第四章 2（我看到，让人如沐春风的女子）$http://audio.xmcdn.com/group24/M04/80/51/wKgJNVh4ZdGikdhhAC_kQAEmi6A576.m4a\r\n六、幻影乘客 第五章（口红口红）$http://audio.xmcdn.com/group24/M04/80/25/wKgJMFh4ZengVtjKADCNIbduWsg384.m4a\r\n六、幻影乘客 第六章（自卫的寺西惠小姐）$http://audio.xmcdn.com/group24/M04/80/55/wKgJNVh4Ze3y-7BaADC_DMTn4CY377.m4a\r\n六、幻影乘客 第七章（残忍的结局）$http://audio.xmcdn.com/group23/M0B/80/7D/wKgJNFh4ZhTid1gmAD3qlVtKeJ0738.m4a\r\n七、目标小A 第一章（北岛香织身边的怪人）$http://audio.xmcdn.com/group25/M09/80/54/wKgJNlh4ZjSgh34TAB-JvndAGH0273.m4a\r\n七、目标小A 第二章（碰到手生的变态？）$http://audio.xmcdn.com/group22/M01/80/25/wKgJM1h4ZkrxqCGEADAL5xQuVrk878.m4a\r\n七、目标小A 第三章 1（曾经的你）$http://audio.xmcdn.com/group21/M0A/7F/93/wKgJKFh4ZlfgZs-9ACarD4oJMdY070.m4a\r\n七、目标小A 第三章 2（相遇和偶遇）$http://audio.xmcdn.com/group21/M0A/7F/52/wKgJLVh4ZmWDwwfqACPaAX3CkFU985.m4a\r\n七、目标小A 第三章 3（我的证词是他的致命伤？）$http://audio.xmcdn.com/group21/M0A/7F/97/wKgJKFh4ZnXzzwplADIMY_TAO8I459.m4a\r\n七、目标小A 第四章 1（分手后的约会）$http://audio.xmcdn.com/group25/M01/80/55/wKgJNlh4ZpHzAlMNAB6EXAmcfQg400.m4a\r\n七、目标小A 第四章 2（为何你俩只议案情不诉衷肠。。。）$http://audio.xmcdn.com/group25/M01/80/32/wKgJMVh4ZqrQoOC0ACeEVh18OmY136.m4a\r\n七、目标小A 第四章 3（你们竟然都来了！）$http://audio.xmcdn.com/group23/M09/80/85/wKgJNFh4Zu3B-9y9ADzAepoe3hE216.m4a\r\n七、目标小A 第五章（再见，温暖的手掌。。。）（完结）$http://audio.xmcdn.com/group23/M09/80/DB/wKgJL1h4ZvfS233mACnUHPnlu4k106.m4a\r\n（Yah Yah Yah）感谢您的聆听与陪伴。$http://audio.xmcdn.com/group24/M05/80/5C/wKgJNVh4ZxXBlXVXACSpDTSKoNs921.m4a', 'xml_8023', '4739', '', 'D', '', '1.0', 9, 0, 0, 0, 'dongyeguiwumeiguiyubishouwanjienayouliangbendoukouhe', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(169, 15, '《钓王》三生小懒播讲', '', '未知', '', '', '', '想知道为什么三叔得重启里面总是提到，福建，雨村，死水龙王。。。。铁三角当年在福建到底发生了什么？一切尽在三生小懒播讲得《钓王》。欢迎订阅收听，关注点赞，给点赞助也成。哈哈关注了钓王可以再去听我得盗墓笔记重启之极海听雷。。。。咱这为了粉丝都得做全套得。。。哈哈我点上一根烟，看着窗外划过的风景。胖子识趣的把我这边的车窗打开一条缝隙，让我的烟气被气流吸出车内。他开的很慢，闷油瓶坐在后座，和年货挤在一起，这一趟来拜访的人很多，我准备了很多特产。车子的车斗装不下。这是一辆尼桑的二手皮卡，远没有我的金杯实用，但我在镇上，短时间也只能买到这样的车。虽然车主一直保证发动机保养的很好没有被打开过，但是油门的感觉还是让人难受。就像踩在棉花上一样。如果从镇子出去盘山到市里，市里就能上同三高速，开个十几个小时，从苍南的分水关到浙江去杭州过年。我原来也是这么打算的，但最终还是决定留在这里。因为小花他们说想来南方看看，福建在他们心中应该是个温暖的地方吧。呵呵，来了就知道了。我心说，开在了回村的县道上，盘山而走，路很多地方只有一个车道宽，车窗外就是万丈悬崖，很是刺激。这一年很冷，在山上看到泉水都冻成了冰膜，覆盖在山坡溪道上。抽烟的时候手挂过车玻璃，能明显的感觉到来自外面的低温刺痛。“说起来，你今年三十几了？”胖子忽然问我道。我没有回答，拧开一只矿泉水的瓶子当烟灰缸，抬手看我的手指，我夹烟的手指部位，被烟火熏成了黑黄色，那是抽劣质烟导致的，在山里下地的时候，带几条烟都是不够的，只能带着烟草自己卷。烟草不能用纯的，要在路边找一种豆叶，晒干了和烟草卷在一起。这样能够抽很长一段时间。味道不怎么样就是了，但比强制戒烟要好受多了。是得戒烟了，我心里说，闷油瓶从山里出来的那几天，是福建最冷的时候，我看着他用冷水直接在院子里冲头，我和胖子都觉得脑仁疼。我们都已经畏首畏脚，感觉到了身体的衰弱，他却还是那个样子。三十几了，忘记自己的年纪吧，这也许是唯一的方法。正想着，车子猛的减速，慢了下来，我抬头看前面路上的车子已经排起了长龙，堵车了。能看到前边一辆大集装箱车歪在路边，有一只轮子已经出了路腾空在悬崖上，整个车子重心倒向悬崖，感觉踹一脚就能翻下去。大车走这条路大部分是为了省高速费，这种路开的多了也不会当心，遇上冰冻天气容易出事。胖子开窗探头出去，冷风灌进车里，闷油瓶也醒了，缩回来的时候胖子已经在骂街：“他娘的，又堵上了，这一路八百回了，我说骑摩托好吧，骑摩托我们就从这群龟孙边上蹂过去。”车子停在了队尾，很多司机都已经下车在边上做广播体操，有农民阿姨把自己车上的货物直接摆摊就开始卖起来，说明堵了不是一时半会儿了。我打开车门下去，把烟头丢进瓶子里。冰凉的空气让我昏昏的脑袋越来越清醒。路的一边是山，一遍是悬崖，上下面是稀稀落落的树，能看到山后是一片一片的丘陵，大概半里之外的有村庄在山坳中若隐若现。都是黄水泥暗淡的黑瓦房。应该是比较穷的村子。我伸着懒腰，打开手机看微信，一边顺着路边往前走去。小花他们已经从北京出发了，他们第一站是杭州看望我的父母和二叔，之后他们会包车往我这儿来。我操，我心想我爹妈会和我说什么我倒是不怕，二叔也要来，想必是担心我。秀秀微信朋友圈发了年关前准备出手的新货，发了二十多条，我忍住把她拉黑的冲动，去点了几个赞。几年前还没有微信这个东西，如今却也用的离不开了。走了五六分钟就到了大卡车边上，问在车头边上扎堆抽烟的司机怎么回事？司机是个东北人，在广州和福建跑运输，车是自己的，一脸懊丧说撞了只鸟，吓了一哆嗦车就崴出去了。这下这年也过不舒心了。这大车卡在这里，估计没六七个小时搞不定，最近的救援到这里也困难，只能安慰了几句。回到车边上，我就让胖子把车靠边停了，没戏了，当脚夫吧，把东西扛上，翻山到附近的村子里找摩托车党给运货，贵点就贵点呗。否则爹妈到了我们都还没到呢。三个人下将车来，将年货一点，全部搬走是不可能了，挑了重要的，每人三十公斤上身，如果不是之前习惯了，这估计是最辛苦的一次过年。我们走出马路，顺着山就往下淌，走入了稀疏的丘陵矮林之中。朝着那个村子走去。目测距离大概需要一个小时能走到，实际走了一个半小时，上山下山，浑身虚汗我们走上了村间小土道，小道边种着大豆，被我们踩坏了不少。准备进村子问问村民赔点钱。但我们真的走近村子的时候，却有些慌了起来，因为经过村子外延的土房，我们看到土房的门都已经腐烂倒塌了。门前，都放着压着红纸的贡品和香炉。也年代久远，贡品中所有该腐烂的都已经腐烂的看不见了，只剩下一些不知道是什么的覆盖着灰尘。红纸褪色之后的水像血一样顺着地面蔓延。如果只有一间有也就罢了，每一间都有，有点骇人。我看了一眼闷油瓶，他脸色镇定，显然也觉得有些异样，但并不感兴趣。三个人闷头往村里走去，我一遍祈祷这不是一个荒村一边祈祷村子里有人有摩托车。走进村子到了有水泥房子的区域，我看到了第一个小卖部，才松了口气。胖子立即上去，看铺子的是个小媳妇抱着个娃，穿着紫色的羽绒服在看电视，胖子上去就敲柜台玻璃，“大妹子，打听个事儿。”小媳妇转头过来，看到我们满身的负重，满头大汗的看着他，露出了害怕的表情。开始用当地话大叫起来，很快从里屋出来一个老婆子，应该是她妈妈，胖子忙堆起个憨厚的笑脸，继续问道：“我们爬山走不动了，找摩托车把我们运出去，我们给钱，找摩托车。”“摩托车？”小媳妇面无表情的看着我们，脸色惨白，我立即也装出特别憨厚的表情，对着老婆子放电。小媳妇没有更多的反应，老婆子用当地话问小媳妇，两个人对话了一阵子，老婆子显然知道了怎么回事。就指了指另外一边，小媳妇说道：“我妈说那边那个弄堂里有拖拉机，他拉货的。”我们立即点头道谢，逃往小卖部边上进去的那个弄堂，胖子搽了搽冷汗道：“我靠，那小姑娘怎么像个鬼一样，一点人气都没有？”', 'http://imagev2.xmcdn.com/group32/M09/7A/CA/wKgJS1n1uNCy47ztAAGIXGOuBWQ116.jpg', '', 1530072261, 5, 0, 0, 0, 0, 1, 1, 7, 10, 'ting', '', '钓王1（为什么重启里面总提到，福建，雨村，死水龙王。。。听这个就明白）$http://audio.xmcdn.com/group32/M02/01/4D/wKgJUFnz5Xyw0ou0AGUrEy_189A871.m4a\r\n钓王2钓叟（新开的支持一下。。。还不是为了你们）$http://audio.xmcdn.com/group32/M06/03/D7/wKgJUFnz_BuQfBztADc46gWLp3c534.m4a\r\n钓王3八钩子（新开的支持一下，我亲爱的小伙伴们）$http://audio.xmcdn.com/group32/M00/76/07/wKgJS1n1lnnh4c0EADdU0Dqr6j4071.m4a\r\n钓王4$http://audio.xmcdn.com/group32/M01/49/B7/wKgJUFn2t56Abjs_ADwEhP_9-eY429.m4a\r\n钓王5（啊~~~~~五环，点个赞咋这么难。。。）$http://audio.xmcdn.com/group32/M0A/B6/5C/wKgJS1n4DpTxXUOlADTWCd-VtTM143.m4a\r\n钓王6留骨地（关注订阅加评论）$http://audio.xmcdn.com/group32/M04/DD/BE/wKgJS1n5hZzTbp1aADzSGFdaLLo359.m4a\r\n钓王7过年（来点评论，闷油瓶已经去杀鸡了，一会开饭）$http://audio.xmcdn.com/group32/M06/B9/13/wKgJUFn61UjS6RkNADloYjbhlZA325.m4a\r\n钓王8流水账（过年了配乐风格变换一下哈哈）$http://audio.xmcdn.com/group32/M09/D6/99/wKgJUFn78XXS6F62ADcl1NV3I8E990.m4a\r\n钓王9流水账2（附送五环之歌。。。哈哈）$http://audio.xmcdn.com/group33/M0B/06/4F/wKgJUVn9TtqzaEr5ADn8snmbBl0524.m4a\r\n钓王10（这老头肯定有事没告诉我们。。。是的我也这么认为）$http://audio.xmcdn.com/group33/M02/2B/BF/wKgJUVn-ktKhePQnADrpHBSSEk8996.m4a\r\n钓王11（喜欢就关注一下给点动力。。。）$http://audio.xmcdn.com/group33/M00/54/CA/wKgJUVoABg_A7ASDADeyysh-jvo945.m4a\r\n钓王12（鱼头豆腐汤。。。）$http://audio.xmcdn.com/group33/M0A/75/F7/wKgJUVoBQSTgt7XuAEbNLDTpa_4588.m4a\r\n钓王13鱼胆（闷油瓶是窜天猴。。。哈哈）$http://audio.xmcdn.com/group33/M04/99/09/wKgJUVoChVmxyB09ADJRZYBETyI574.m4a\r\n钓王14鱼道（胖子这白话功力可以。。。鱼能运石头）$http://audio.xmcdn.com/group33/M07/BE/96/wKgJUVoD5VrDXB_QADN6B4vM-KU456.m4a\r\n钓王15盐（要真糊一脸，这十年的交情就完蛋了哈哈）$http://audio.xmcdn.com/group33/M08/2A/0C/wKgJTFoFMtiwy_BQADlrUQBjPoc466.m4a\r\n钓王16瀑布（哎也没说内急到底解决没。。。无邪真能憋）$http://audio.xmcdn.com/group31/M00/67/CC/wKgJSVoGhDaTdRzQADl-Zx0qLEk364.m4a\r\n钓王17盐源（我要去做垄断全国得大事了。。。哈哈）$http://audio.xmcdn.com/group34/M07/13/B2/wKgJYFoJM7iDS43nADdyLyz6rOw127.m4a\r\n钓王18咸（这无邪都憋了三集了还不拉。。。。哈哈）$http://audio.xmcdn.com/group33/M00/F6/44/wKgJUVoJM9qgcylAADsZkZE7moo548.m4a\r\n钓王19和竿和钢筋（我首选咖喱葬，陪葬品有土豆葱姜蒜。。。哈哈）$http://audio.xmcdn.com/group35/M0A/22/AC/wKgJnVoKd6Tx3hDWAETPo8Qg1nM716.m4a\r\n钓王20（这老刘。。。打雷下雨都听不到。。我一说话就刺耳。。哎我也表示很无奈啊。。$http://audio.xmcdn.com/group35/M01/6C/BD/wKgJnFoKd8PSTjGxADngy4cuYb8305.m4a\r\n钓王21雨村钓王（大鱼要出来了。。。。）$http://audio.xmcdn.com/group35/M06/49/4D/wKgJnVoLyfmStV5JADgfdjq6zr8679.m4a\r\n钓王22（奔波霸回去报信了。。。。哈哈）$http://audio.xmcdn.com/group35/M09/78/BB/wKgJnVoNYTqgkQhZAD0tJ2_fna0954.m4a\r\n钓王23死水龙王（胖子属于本色出演。。。哈哈）$http://audio.xmcdn.com/group35/M03/E4/C9/wKgJnFoOh9HB6MJ-ADllc8NABW0056.m4a\r\n钓王24黄河钓尸人（胖子真是个吃货啊。。。）$http://audio.xmcdn.com/group35/M0A/06/05/wKgJnFoPw8-jPoGVAEinfQccr0k546.m4a\r\n钓王25一步之遥（这里面肯定还有事。。。）$http://audio.xmcdn.com/group35/M05/2A/F5/wKgJnFoRBhGzSjXpAFDMqp_IdQU193.m4a\r\n钓王26（死水龙王即将现身）$http://audio.xmcdn.com/group35/M06/0C/20/wKgJnVoSY9_jAZTTACvkv9Msze8256.m4a\r\n钓王27打屎棍（这要是拉的太稀可咋整。。。）$http://audio.xmcdn.com/group35/M06/8B/02/wKgJnFoT3c-jxWFvAC37RBYtzqg684.m4a\r\n钓王终章（喜欢的给点支持吧。。。还想听什么给我留言）$http://audio.xmcdn.com/group35/M05/8B/18/wKgJnFoT3lfxR5VCALC9sQ_zDZY777.m4a', 'xml_8023', '4735', '', '0', '', '1.0', 8, 0, 0, 0, 'diaowangsanshengxiaolanbojiang', ''),
(170, 15, '[完本]鬼案法医', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group24/M09/86/77/wKgJMFh5UeCyDPfEAAMiXZ3l7lA179.jpg', '', 1530072261, 8, 0, 0, 0, 0, 1, 1, 1, 8, 'ting', '', '174 大结局（再开探案新书）$http://audio.xmcdn.com/group24/M05/DC/B9/wKgJNViEmJSAHKCMAH7n8i_a5h4489.m4a\r\n173 养蛇佬$http://audio.xmcdn.com/group22/M08/DC/1E/wKgJM1iEmG6SNfbcAHo-Gf4dLSI437.m4a\r\n172 最后的任务$http://audio.xmcdn.com/group23/M02/DC/B7/wKgJL1iEmDSyO0ksAEUddfBfC9I032.m4a\r\n171 解毒（有改编太啰嗦）$http://audio.xmcdn.com/group25/M02/DC/68/wKgJNliEmBLCXzMpACAGwk0UqQ4040.m4a\r\n170 黑阎王（求推荐好书）$http://audio.xmcdn.com/group22/M0B/DC/12/wKgJM1iEl8fSYY8gAFDD2W_eLpg186.m4a\r\n169 找解药$http://audio.xmcdn.com/group24/M02/DC/75/wKgJMFiEl6CyDwEzAEzmIU9Ovmk423.m4a\r\n168 雨婷中毒$http://audio.xmcdn.com/group24/M02/DC/B1/wKgJNViEl4ijRcfRADTb7Nr1Iig094.m4a\r\n167 这难道就是真相$http://audio.xmcdn.com/group23/M07/DC/AE/wKgJL1iEl2aDb-YNAEtbHmGBZcY995.m4a\r\n166 赶尸人的事（明儿）$http://audio.xmcdn.com/group24/M05/CE/E4/wKgJNViDLnSRwOVOAEVGlHDW7PI933.m4a\r\n165 女人的手$http://audio.xmcdn.com/group24/M01/CC/1D/wKgJMFiC74_xIDmhADQLZDKR_UQ013.m4a\r\n164 唤鬼锣$http://audio.xmcdn.com/group24/M01/CC/19/wKgJMFiC73qB6z0WACgIfh4evq8577.m4a\r\n163 赶尸人$http://audio.xmcdn.com/group23/M05/CC/1F/wKgJNFiC72uS2qpHACU_v7DK_5Y138.m4a\r\n162 索命阎罗$http://audio.xmcdn.com/group23/M05/CC/1D/wKgJNFiC717hyeEmACnHzJhwhlI532.m4a\r\n161 消失的村寨$http://audio.xmcdn.com/group22/M00/CB/CC/wKgJM1iC70mw-0VgACc8Ui3vjbw664.m4a\r\n160 恐吓信$http://audio.xmcdn.com/group25/M08/CA/FC/wKgJMViC1krhg9FLADTj35xMjkE047.m4a\r\n159 遗像$http://audio.xmcdn.com/group23/M04/CB/7E/wKgJL1iC1jLSVHOIAD879aEQavM401.m4a\r\n158 疑云再现$http://audio.xmcdn.com/group24/M08/CB/39/wKgJMFiC1h7wqHSVADcJ7UDtVGw621.m4a\r\n157 门后有符$http://audio.xmcdn.com/group24/M08/CB/74/wKgJNViC1g_y2x6gAEKbv20lW08758.m4a\r\n156 一意孤行$http://audio.xmcdn.com/group24/M08/CB/32/wKgJMFiC1fqAZe0jADCb0NGI5E8838.m4a\r\n155 蛇群来袭（即将完本求好书）$http://audio.xmcdn.com/group21/M00/C8/C8/wKgJLViCpECSWFt6ADuq8fqmx90981.m4a\r\n154 打草惊蛇（求推荐好书）$http://audio.xmcdn.com/group22/M0B/C9/67/wKgJM1iCpAWz1JEeADufN914F4w106.m4a\r\n153 控制局面（有好书吗）$http://audio.xmcdn.com/group25/M07/C9/97/wKgJNliCo-KQwNkYAEOeZkvq0v0805.m4a\r\n152 黑大个$http://audio.xmcdn.com/group24/M06/C9/A4/wKgJMFiCo8DDxpeTAETlp4P55mA620.m4a\r\n151 养尸池$http://audio.xmcdn.com/group22/M0B/C9/99/wKgJLliCo6qRY-ltACz3Zn5imNA435.m4a\r\n150 施木寨主（求推荐好书）$http://audio.xmcdn.com/group22/M00/C9/63/wKgJM1iCo5OzHg_VAEJCHGDwGRw654.m4a\r\n149 入寨门（掐闲篇捞干的）$http://audio.xmcdn.com/group21/M06/C8/EE/wKgJKFiCo3CTxtc9AC8yksdW11U923.m4a\r\n148 幻术（太扯拉低姐的智商明儿吧）$http://audio.xmcdn.com/group25/M07/C4/66/wKgJNliB-PeRBHv5AEyp7XeOJOI011.m4a\r\n147 哈大巫师（扯）$http://audio.xmcdn.com/group22/M00/C4/90/wKgJLliB-M2g58zzADtyblZVJIM838.m4a\r\n146 吃人（作者开始胡扯了）$http://audio.xmcdn.com/group24/M08/C4/7D/wKgJMFiB-KWhX_ZLACotNsAU878675.m4a\r\n145 无灯村$http://audio.xmcdn.com/group24/M05/C4/5F/wKgJNViB7zfyC_JQAEhynl2SF3s419.m4a\r\n144 黑马寨（我又掐了打情骂俏的没深度）$http://audio.xmcdn.com/group21/M02/C3/36/wKgJLViB7xiR72GqACde2osCGKM341.m4a\r\n143 地下车库$http://audio.xmcdn.com/group21/M02/C3/62/wKgJKFiB7waSU1MSADwHd1RKBI8561.m4a\r\n142 越来越复杂$http://audio.xmcdn.com/group25/M07/C3/E7/wKgJMViB7vfzXT3mAEJR2Deu83I014.m4a\r\n141 祖师爷显灵$http://audio.xmcdn.com/group25/M07/C3/E2/wKgJMViB7uHTiq-AAEqR8GXpBKg251.m4a\r\n140 新线索$http://audio.xmcdn.com/group21/M05/C2/B7/wKgJLViB4I-D6DO0ACWL3vaUWJk340.m4a\r\n139 招了$http://audio.xmcdn.com/group24/M05/C3/9C/wKgJMFiB4HvhapW1ABLtkNIeY5M998.m4a\r\n138 地窖里的尸体$http://audio.xmcdn.com/group25/M00/C3/92/wKgJNliB4HLyftq-AEnpE2vzawQ616.m4a\r\n137 恨亲毒$http://audio.xmcdn.com/group23/M09/C3/EC/wKgJL1iB4EajvfbHADOWB03OLRw343.m4a\r\n136 老人的哭声$http://audio.xmcdn.com/group22/M07/C3/B4/wKgJLliB4CvhEBbjAEIdedjr9hI543.m4a\r\n135 物归原主$http://audio.xmcdn.com/group25/M0B/C2/C0/wKgJMViBzZ2AzILvAEGNkLDqPHQ943.m4a\r\n134 混混所长$http://audio.xmcdn.com/group22/M02/C3/0A/wKgJLliBzYyAJ8A3AEE4V45CdIc712.m4a\r\n133 安平镇派出所（我又掐了）$http://audio.xmcdn.com/group25/M09/C2/E0/wKgJNliBzW3zVGzcADU7XIkPoWY551.m4a\r\n132 无能为力（逗贫处我掐了）$http://audio.xmcdn.com/group24/M09/C3/21/wKgJNViBzUyTO7PxADQLZIuDXX8667.m4a\r\n131 问魂$http://audio.xmcdn.com/group25/M08/C2/B8/wKgJMViBzTLB3_mjABT1yfLgbuI614.m4a\r\n130 吴局长$http://audio.xmcdn.com/group22/M01/C2/58/wKgJLliBuzjCyyEbAEp6dNbCueU548.m4a\r\n129 半张脸$http://audio.xmcdn.com/group25/M07/C2/14/wKgJMViBuyPitIUhAFBbl7MtaoQ859.m4a\r\n128 缴猫$http://audio.xmcdn.com/group23/M0B/C2/84/wKgJL1iBuwjB3jv5ADzb1siHxjs908.m4a\r\n127 巫婆婆$http://audio.xmcdn.com/group24/M00/C2/35/wKgJMFiBuveSzCJaAD3ekQ7Gm1M502.m4a\r\n126 诡异的猫叫$http://audio.xmcdn.com/group22/M05/C2/27/wKgJM1iBuuOATQsHAE_qhCFHhqQ384.m4a\r\n125 平静的死亡$http://audio.xmcdn.com/group22/M02/C1/8A/wKgJM1iBqQyDfKk1ACrrSYjEWOU853.m4a\r\n124 破案$http://audio.xmcdn.com/group21/M05/C0/E4/wKgJKFiBqPbSf-x4AEf-nCrM3yI242.m4a\r\n123 二娃子（我去误删俩晨练下午吧）$http://audio.xmcdn.com/group21/M07/BD/35/wKgJLViBQPGBdkYyAE4QN8vaNIQ048.m4a\r\n122 针弩$http://audio.xmcdn.com/group25/M06/BD/F5/wKgJMViBQMShKG1FAE72xFAvSQc324.m4a\r\n121 玲儿的秘密$http://audio.xmcdn.com/group22/M09/BE/2F/wKgJLliBQLTCKGTUAEvbx5sEpx4107.m4a\r\n120 女尸（不来了怕怕明儿吧）$http://audio.xmcdn.com/group24/M01/B8/77/wKgJMFiAoOeg0-SDAE9DH3tgVNs220.m4a\r\n119 出乎意料$http://audio.xmcdn.com/group21/M04/B7/DA/wKgJKFiAoMCg9ev1AEBNAd09KrY163.m4a\r\n118 大案小办$http://audio.xmcdn.com/group21/M04/B7/D9/wKgJKFiAoLqCjIWAAE_TCFL-xqs214.m4a\r\n117 大战僵尸$http://audio.xmcdn.com/group23/M01/B8/E9/wKgJL1iAoJbAr49PAFPLL5fzf00991.m4a\r\n116 惊天秘密$http://audio.xmcdn.com/group25/M04/B8/6B/wKgJNliAoH6jicQZADCGQ9Kz5JI349.m4a\r\n115 蒋疯子（晨练先五）$http://audio.xmcdn.com/group25/M00/B2/6A/wKgJNlh_7SKhj2zlAEzF0zp3dII590.m4a\r\n114 神秘的白影$http://audio.xmcdn.com/group24/M01/B2/62/wKgJMFh_7O-wajfJAEzBaSeDXDs094.m4a\r\n113 白三爷$http://audio.xmcdn.com/group23/M04/B2/DE/wKgJL1h_7NWySDV9AFBrvktZqag522.m4a\r\n112 大闹鬼市$http://audio.xmcdn.com/group25/M0B/B2/39/wKgJMVh_7L3RTztkADo56p8ZOI4738.m4a\r\n111 尸体爆炸案$http://audio.xmcdn.com/group23/M04/B2/89/wKgJNFh_7LLQEcQUAE19XxkluTM815.m4a\r\n110 这就是结局（歇了明儿）$http://audio.xmcdn.com/group25/M03/AE/FF/wKgJNlh_WXzQVAekAFVqv3yskPg893.m4a\r\n109 追铺$http://audio.xmcdn.com/group21/M03/AE/2A/wKgJKFh_WWHBah4xAFHjqyXEUa0840.m4a\r\n108 中计$http://audio.xmcdn.com/group22/M08/AE/91/wKgJM1h_WTSho8qiADxxIemL4qE889.m4a\r\n107 杀回赌场$http://audio.xmcdn.com/group24/M08/AE/D3/wKgJMFh_WRqCunADAFLnknaibJQ137.m4a\r\n106 生死决战（下）$http://audio.xmcdn.com/group24/M08/AF/1B/wKgJNVh_WQTyMyeUAFMccAYsFio285.m4a\r\n105 生死决战（中）$http://audio.xmcdn.com/group25/M06/AE/FA/wKgJNlh_WM2j7R_hAET738uCLi4475.m4a\r\n104 生死决战（上）$http://audio.xmcdn.com/group24/M00/AF/16/wKgJNVh_WJuThxYSADGHym1BgOc874.m4a\r\n103 婴公追来$http://audio.xmcdn.com/group23/M0B/AF/28/wKgJL1h_WIrRw2DdAFYCAV5jv8Q301.m4a\r\n102 小红蛇$http://audio.xmcdn.com/group23/M06/AF/27/wKgJL1h_WFrB4E_7AFLmGirfrhk392.m4a\r\n101 鬼赌场的掌舵人（婴公）$http://audio.xmcdn.com/group21/M0B/AD/E1/wKgJLVh_WEXT6VKXAFOCxi5pCGs252.m4a\r\n100 婴母$http://audio.xmcdn.com/group21/M0B/AE/1D/wKgJKFh_WDDhkddlABXaisu3Zfg395.m4a\r\n099 夺魁（下）$http://audio.xmcdn.com/group23/M02/AA/3B/wKgJL1h-sPKCtxrKAFFymD0aHJU468.m4a\r\n098 夺魁（中）$http://audio.xmcdn.com/group24/M0B/AA/41/wKgJNVh-sNXRuyXqACGAwsDqp3A074.m4a\r\n097 夺魁（上）$http://audio.xmcdn.com/group24/M0B/A9/F6/wKgJMFh-sMzQgyNUAD0gCyrEMtA109.m4a\r\n096 鬼魁花$http://audio.xmcdn.com/group24/M0B/AA/3E/wKgJNVh-sLbhH63AAEWtXsqE5JM540.m4a\r\n095 局里有内奸$http://audio.xmcdn.com/group21/M00/A9/4C/wKgJKFh-sKqhCDkcAEPEYr8zBLE802.m4a\r\n094 古佛寺$http://audio.xmcdn.com/group21/M00/A9/08/wKgJLVh-sJLx99xVAC090izOvEI997.m4a\r\n093 失踪的尸体$http://audio.xmcdn.com/group21/M00/A9/47/wKgJKFh-sIPgKaIzAD0FZclgSaY326.m4a\r\n092 诡异的女护士$http://audio.xmcdn.com/group22/M03/A9/D5/wKgJLlh-sHqjceltAEabQPzhaNQ869.m4a\r\n091 停尸房$http://audio.xmcdn.com/group22/M03/A9/A6/wKgJM1h-sGLQdb2QAEdl5itrazg020.m4a\r\n090 黑鬼$http://audio.xmcdn.com/group25/M03/A9/F4/wKgJMVh-sDiRB8hCAENITcmif6E166.m4a\r\n089 医院（有鬼明儿吧）$http://audio.xmcdn.com/group25/M08/A5/CB/wKgJNlh-AyHz9fIoAD_yZvXnBQg459.m4a\r\n088 奖金没了$http://audio.xmcdn.com/group24/M0A/A5/A0/wKgJMFh-AuzDvM2qAEMIbF9-ERE183.m4a\r\n087 离奇死亡$http://audio.xmcdn.com/group24/M0A/A5/DC/wKgJNVh-Atvg8cB8ADyisHzswy0447.m4a\r\n086 病房里的审讯$http://audio.xmcdn.com/group24/M0A/A5/DC/wKgJNVh-AtiCDcgyAEaGs91FPr0099.m4a\r\n085 土崩瓦解$http://audio.xmcdn.com/group22/M05/A5/90/wKgJLlh-ArOxY-7WADuvlkDtdto076.m4a\r\n084 被围$http://audio.xmcdn.com/group23/M0B/A5/F2/wKgJL1h-AqLDVPHLAEUddejc3T0664.m4a\r\n083 吊眼老鬼$http://audio.xmcdn.com/group23/M0B/A5/9E/wKgJNFh-ApvAl4wvADH5SXzdnhY729.m4a\r\n082 进墓$http://audio.xmcdn.com/group24/M03/A5/D8/wKgJNVh-AnbA3d02AEY9R4eziA4769.m4a\r\n081 古墓逃生（没鬼了不好玩上班去）$http://audio.xmcdn.com/group24/M04/A0/E1/wKgJNVh9UsvD4VfiAESzvFwppVw690.m4a\r\n080 白玉棺材$http://audio.xmcdn.com/group21/M05/9F/E4/wKgJKFh9Urqj_gyDAEkbf4MEdJc372.m4a\r\n079 守墓人$http://audio.xmcdn.com/group22/M08/A0/93/wKgJLlh9UqbTH89nAFKQ8nXM3QY892.m4a\r\n078 棺材里有洞$http://audio.xmcdn.com/group23/M09/A0/9C/wKgJNFh9UpDwwRnTAEMG9Ky-LoA426.m4a\r\n077 困鬼棺$http://audio.xmcdn.com/group25/M06/A0/AA/wKgJMVh9UnCRaIU_AEYCijE03YI998.m4a\r\n076 木盒子$http://audio.xmcdn.com/group23/M0B/A0/EA/wKgJL1h9Ul2y3KlwADLPQQqCewo185.m4a\r\n075 命悬一线$http://audio.xmcdn.com/group21/M09/9F/8F/wKgJLVh9UkvDrd31AEFp67sr1uo044.m4a\r\n074 黑狗$http://audio.xmcdn.com/group21/M0B/9F/E0/wKgJKFh9UjmA67sfAEiV3m5YaFw639.m4a\r\n073 小鬼带路$http://audio.xmcdn.com/group25/M04/A0/C7/wKgJNlh9UiuAif6WAEcyf9r2v5k230.m4a\r\n072 黑狗山$http://audio.xmcdn.com/group24/M09/A0/DF/wKgJNVh9UfuCkV1aAEb6tQQUu5Q192.m4a\r\n071 老坟冒青烟$http://audio.xmcdn.com/group24/M09/A0/9C/wKgJMFh9UefhMp3mAEa0OMa8KPs959.m4a\r\n070 扎针（翻了翻还有十章也见不到潘道士天黑了明儿吧）$http://audio.xmcdn.com/group24/M0B/9B/5B/wKgJMFh8gn-CMyPuACcokjnZDf0952.m4a\r\n069 奇怪的条件$http://audio.xmcdn.com/group24/M0B/9B/97/wKgJNVh8gnWzP7z_ADOmYKe2vys674.m4a\r\n068 开锁$http://audio.xmcdn.com/group24/M0B/9B/5A/wKgJMFh8gmHAQrMHAC1eevoGMI0062.m4a\r\n067 杨二娃$http://audio.xmcdn.com/group25/M02/9B/90/wKgJNlh8gk-CR12qAEr-nHVSBuM636.m4a\r\n066 真相$http://audio.xmcdn.com/group25/M02/9B/8D/wKgJNlh8gj7jg0dJAETqErkzJj4376.m4a\r\n065 虐鬼$http://audio.xmcdn.com/group22/M0A/9B/4A/wKgJLlh8giyyy_6qAD-7kE_C1UA603.m4a\r\n064 控鬼人$http://audio.xmcdn.com/group23/M02/9B/73/wKgJNFh8giKzwtbsADslRPIEA3Y790.m4a\r\n063 地下老巢$http://audio.xmcdn.com/group23/M01/9B/C4/wKgJL1h8ggiAPEy6AD4KiK77sc8623.m4a\r\n062 青花瓷瓶$http://audio.xmcdn.com/group21/M08/9A/94/wKgJKFh8gfOQYM6PAEXKvFn9lO8079.m4a\r\n061 鬼敲棺$http://audio.xmcdn.com/group21/M08/9A/92/wKgJKFh8gd-ibl95AESjldObbAE559.m4a\r\n060 牛角村$http://audio.xmcdn.com/group21/M08/9A/8F/wKgJKFh8gcyyGOL2AENsR6qnroQ969.m4a\r\n059 落网$http://audio.xmcdn.com/group22/M04/99/61/wKgJM1h8SEzwwnIBAELE3mvreEQ313.m4a\r\n058 尖头小鬼$http://audio.xmcdn.com/group24/M03/99/DC/wKgJNVh8SCbDctTcAEQX2rJsG7M065.m4a\r\n057 祖传玉镯$http://audio.xmcdn.com/group24/M03/99/A3/wKgJMFh8SCDiUK6uAEcJZHVu1S4401.m4a\r\n056 天阳水库$http://audio.xmcdn.com/group21/M0B/98/DD/wKgJKFh8SAODu_JIAEThQXJigzk487.m4a\r\n055 段王孙$http://audio.xmcdn.com/group21/M0B/98/D9/wKgJKFh8R-iCLPO2AEgBi76pZ-0896.m4a\r\n054 深山里的鬼市$http://audio.xmcdn.com/group22/M06/99/5D/wKgJM1h8R8_TbtxhAEPezsW9vxA499.m4a\r\n053 鬼赌场$http://audio.xmcdn.com/group25/M05/99/A7/wKgJMVh8R7zDOlUwAEaJolOJ_xE788.m4a\r\n052 三日之期$http://audio.xmcdn.com/group23/M07/99/B9/wKgJNFh8R6ay7JwhAESt2vHCRRI950.m4a\r\n051 熊瞎子$http://audio.xmcdn.com/group21/M08/98/87/wKgJLVh8R4_yNpFnAEhp0VNwnzM291.m4a\r\n050 叫花道（今歇了明继续）$http://audio.xmcdn.com/group21/M02/92/47/wKgJLVh7SXTRtZ94AB1_TzWdzGg543.m4a\r\n049 一针破鬼$http://audio.xmcdn.com/group21/M02/92/44/wKgJLVh7SV6B6yB_AC8hLb4PboM344.m4a\r\n048 纸灰人$http://audio.xmcdn.com/group22/M0B/93/14/wKgJM1h7SU7jrErmADvjRASL2Wo555.m4a\r\n047 鬼叫花$http://audio.xmcdn.com/group22/M0B/93/52/wKgJLlh7ST2RumgEACqAEZuWAMA836.m4a\r\n046 地下室$http://audio.xmcdn.com/group25/M08/93/82/wKgJNlh7SSnikLVLADre_H7_cXo307.m4a\r\n045 开锁$http://audio.xmcdn.com/group21/M03/91/0F/wKgJLVh7HR3zIQjzAEM18Sfo9gs682.m4a\r\n044 小白楼$http://audio.xmcdn.com/group23/M02/92/1D/wKgJNFh7HQ-wHQYkAED3yUgrR5s030.m4a\r\n043 金店失窃$http://audio.xmcdn.com/group22/M07/92/1C/wKgJLlh7HQGzPElZAEQ4YGGrMdw513.m4a\r\n042 人赃并获$http://audio.xmcdn.com/group21/M05/90/DB/wKgJLVh7FFCxdBnZAEG4ovgdkO8571.m4a\r\n041 林东村$http://audio.xmcdn.com/group21/M05/91/2D/wKgJKFh7FDyjYH0LAEGiHYQHIqw039.m4a\r\n040 杨瘸子$http://audio.xmcdn.com/group21/M05/91/2B/wKgJKFh7FCzwOkFEAEeDRD8ZBnY460.m4a\r\n039 花瓶上的符纸$http://audio.xmcdn.com/group22/M02/91/9D/wKgJM1h7FBLippeLAENDKOvHIP0591.m4a\r\n038 鬼窃案$http://audio.xmcdn.com/group25/M02/91/E9/wKgJMVh7E_nDB9OPAEQTdhMK-dc361.m4a\r\n037 重见天日（丢尸案结束）$http://audio.xmcdn.com/group22/M03/91/35/wKgJLlh6-9jAE6cKADo79bCeKh0914.m4a\r\n036 古墓藏尸$http://audio.xmcdn.com/group21/M04/90/24/wKgJLVh6-6yAwbIrADBAxfdmNYc554.m4a\r\n035 停止的脚步声$http://audio.xmcdn.com/group22/M02/90/EA/wKgJLlh68XzRmW4wADYV_uoN9ZE366.m4a\r\n034 招了$http://audio.xmcdn.com/group21/M04/8F/DB/wKgJLVh68WTDvi7aAEBBsIeDumA293.m4a\r\n033 钱爷$http://audio.xmcdn.com/group21/M04/90/34/wKgJKFh68VmwEB2kAEY17UnRecg132.m4a\r\n032 鬼婴再现$http://audio.xmcdn.com/group25/M06/91/1A/wKgJNlh68ULgamalAEbTDnU6Vgg264.m4a\r\n031 月榕山庄（少儿不宜的请原谅我掐了）$http://audio.xmcdn.com/group25/M06/91/17/wKgJNlh68S3icxM8AD67GJGfYwc462.m4a\r\n030 孙超落网$http://audio.xmcdn.com/group21/M08/8E/11/wKgJLVh6qWbQvj35AEn6shN0OAY240.m4a\r\n029 茅大师$http://audio.xmcdn.com/group23/M03/8F/26/wKgJNFh6qUvBzHAEAEn0z2oitcQ306.m4a\r\n028 女鬼索账$http://audio.xmcdn.com/group22/M03/8F/25/wKgJLlh6qT3yVzqbAEe8irfOKRk532.m4a\r\n027 搜尸$http://audio.xmcdn.com/group24/M06/8F/16/wKgJMFh6qSnRVtXdAEZBrrM4_g4856.m4a\r\n026 九溪村（不好玩的地方我语速快点）$http://audio.xmcdn.com/group24/M06/8F/46/wKgJNVh6qQ-z4kWsAD_L-UbnBtU284.m4a\r\n025 江东殡仪馆$http://audio.xmcdn.com/group21/M09/8E/63/wKgJKFh6qPzCDnktAES_jTUI7jI761.m4a\r\n024 龙凤合玉$http://audio.xmcdn.com/group21/M09/8E/0D/wKgJLVh6qOiAv6lpAEdJ_-l1NHk638.m4a\r\n023 破案（晚上不说鬼明天继续我也怕怕）$http://audio.xmcdn.com/group21/M0B/89/DF/wKgJKFh57x-i1JxOAEsdcjY7G34960.m4a\r\n022 山神庙$http://audio.xmcdn.com/group22/M03/8A/91/wKgJLlh57m6SiwzoADLuVuVlUoM879.m4a\r\n021 M烟窃婴$http://audio.xmcdn.com/group22/M02/8A/28/wKgJM1h56TzjUJIhAEkOR-pfSyQ335.m4a\r\n20 火纸人$http://audio.xmcdn.com/group23/M01/8A/94/wKgJNFh56P3TmwOAADJYpnjCR1U169.m4a\r\n019 坟飘$http://audio.xmcdn.com/group24/M03/8A/A6/wKgJNVh56OiBJRI4AEUwU5_LG_Q624.m4a\r\n018 沙坝村$http://audio.xmcdn.com/group24/M03/8A/A3/wKgJNVh56NCjh3p3AEZBrnweoXg626.m4a\r\n017 黑猫盗坟$http://audio.xmcdn.com/group25/M01/8A/64/wKgJMVh56LyyK4E_AEkYjPZ9TMo250.m4a\r\n016 熊岩坡$http://audio.xmcdn.com/group21/M03/89/AB/wKgJKFh56H3wH9ZLAEn3w4n2LBk065.m4a\r\n015 曹斌死了$http://audio.xmcdn.com/group24/M03/89/7C/wKgJNVh5v9eA4NeKAC5mgGcVNZg837.m4a\r\n014 白衣人$http://audio.xmcdn.com/group22/M02/89/5B/wKgJLlh5v8fxzyPEAEHOANesWPw334.m4a\r\n013 结案$http://audio.xmcdn.com/group22/M02/89/0F/wKgJM1h5v7Kg9ql1AEQebHsPZ1s330.m4a\r\n012 鬼婴$http://audio.xmcdn.com/group25/M0A/89/69/wKgJNlh5v5rj5QGKADIlPg10-OU950.m4a\r\n011 夺命水塔$http://audio.xmcdn.com/group21/M02/88/8C/wKgJKFh5v37y0mVjAEmFOE0tRZ8359.m4a\r\n010 专案组$http://audio.xmcdn.com/group24/M09/88/DA/wKgJNVh5qbDRLcQuAD7aVReTySI538.m4a\r\n009 鬼婴案$http://audio.xmcdn.com/group25/M0A/88/98/wKgJMVh5qZ6j-2p_AD_why254JU983.m4a\r\n008 小纸人$http://audio.xmcdn.com/group23/M02/89/1E/wKgJL1h5qYmhWMKVAEsF8kJANWw338.m4a\r\n007 红衣女鬼$http://audio.xmcdn.com/group21/M08/87/E7/wKgJKFh5qXWhE7lHAEO5fSJWLPA495.m4a\r\n006 尸臭$http://audio.xmcdn.com/group25/M02/88/C6/wKgJNlh5qV2yhiqfAEljcwme6X8188.m4a\r\n005 棺材$http://audio.xmcdn.com/group24/M07/86/BA/wKgJMFh5YIWjrn-4ABMjcEI67J4225.m4a\r\n004 杨四娘$http://audio.xmcdn.com/group24/M07/86/B9/wKgJMFh5YHvzegzzABL4F_Ss2kE755.m4a\r\n003 血脚印$http://audio.xmcdn.com/group24/M07/86/B8/wKgJMFh5YG-hj9ruABKM3mhEsm8994.m4a\r\n002 夜探坟头$http://audio.xmcdn.com/group22/M05/86/A5/wKgJLlh5VjrgQQ09ABJvSVhX6Eo572.m4a\r\n001 黄老头 冬柳_26 2017年1月14日 06:16$http://audio.xmcdn.com/group23/M00/86/B4/wKgJNFh5ViajVG4FABIAkjDG98E441.m4a', 'xml_8023', '4733', '', '[', '', '1.0', 4, 0, 0, 0, 'wanbenguianfayi', ''),
(171, 15, '鬼夫大人你有毒[云半月播讲]', '', '未知', '', '', '', '我叫秦瑶，根红苗正的玄门鬼医传人，只是我发梦也没想到，有一日，我会被阴间的一纸公文，给放发配到古代去做——走阴使，好吧，走阴使就走阴使，但是为什么还要塞给我这么个男鬼，此男鬼作呀，他除了干那事的时候，很乖很听话，平时分分秒都是要上天的节奏。    “阿瑶，我突然发现，我俩简直就是女菜男貌，你有病，我有药，你没胸，我有料，天造地设的一对，不结合，都是要遭天谴的！”    “……公子，你千万不要放弃治疗呀！”', 'http://imagev2.xmcdn.com/group39/M07/AC/20/wKgJnlpogbTB96L0AABUrSUegZU102.jpg', '', 1530072261, 1, 0, 0, 0, 0, 1, 1, 1, 4, 'ting', '', '第1集 走马上任$http://audio.xmcdn.com/group38/M04/BD/1B/wKgJolppWX2SW25sAFgbcg47XuA294.m4a\r\n第2集 通灵人$http://audio.xmcdn.com/group39/M0A/E0/42/wKgJn1pqyefyuhFcAErs-jhCiJw938.m4a\r\n第3集 鬼缠$http://audio.xmcdn.com/group40/M05/37/13/wKgJT1qxwnfgLb7VAEr6MkSXaYU934.m4a\r\n第4集 你到底是个神马$http://audio.xmcdn.com/group40/M0A/0D/FD/wKgJVFrMfi_ziNKzAEyPfWNVWKk718.m4a\r\n第5集 被鬼坑了$http://audio.xmcdn.com/group42/M02/53/81/wKgJ9FrMxgHS5jsNAE5bG9fiEDs106.m4a\r\n第6集 哪来的妖孽$http://audio.xmcdn.com/group40/M09/5E/FD/wKgJT1rQmbXyCRlwAE9WNduSLQI413.m4a\r\n第7集 纸钱（做后期时居然把自己吓到了，囧~）$http://audio.xmcdn.com/group41/M09/9C/AA/wKgJ8lrQsRjQvwSxAF6xNnAsJ8c420.m4a', 'xml_8023', '4730', '', 'G', '', '1.0', 6, 0, 0, 0, 'guifudarenniyouduyunbanyuebojiang', ''),
(172, 15, '缠中说禅之教你打坐', '', '未知', '', '', '', '缠中说禅，当代奇人，新浪名博 《 全球第一博客---缠中说禅 》 博主，2006年2月1日在新浪开篇写博，2008年10月10日病重停博，留下宝贵文章1130篇，内容分类为 缠中说禅 、 诗词曲赋 、 音乐艺术 、 文史哲学（《论语》详解） 、 时政经济（缠中说禅经济学） 、 数理科技（缠中说禅医学理科技（缠中说禅医学） 、 白话杂文 、 流行娱乐 及网络小说《 那一夜，他的体液喷了我一身 》，加之之前以不同身份在天涯和强国论坛发的帖子，约为1848篇，旨在进行文化的总构建，成为众多缠迷的思想导师，称其为缠师，并将时政经济中的《教你炒股票》系列，称为《缠论》。《论语》详解、《教你炒股票》、《教你打坐》等几个系列语音版，由美女优雅利用自己的职业专长朗读录制，声情并茂，偶然见之，欣喜若狂，放在这里，与有缘人分享，感恩缠师，感谢优雅老师！', 'http://imagev2.xmcdn.com/group31/M04/B9/83/wKgJSVmSPgmRyk6zAAJqo54_jCE810.jpg', '', 1530072261, 9, 0, 0, 0, 0, 1, 1, 4, 5, 'ting', '', '（静心引入）00罄声（谁在听声音？反闻闻自性）$http://audio.xmcdn.com/group31/M00/B8/85/wKgJSVmSOhWib7ugABOfzWdoyoY468.m4a\r\n教你打坐2$http://audio.xmcdn.com/group11/M05/7B/1F/wKgDa1dVTE2wOHFtADyxywpRfSo355.m4a\r\n教你打坐3$http://audio.xmcdn.com/group11/M05/7B/20/wKgDa1dVTFTDi39kACbMygtetaI237.m4a\r\n教你打坐4$http://audio.xmcdn.com/group9/M0A/88/FB/wKgDYldVTGPCyMcLACjNQsVUQ00397.m4a\r\n教你打坐5$http://audio.xmcdn.com/group16/M04/89/1A/wKgDaldVTHrTmj_YADPFDHoFo-g924.m4a\r\n教你打坐6$http://audio.xmcdn.com/group9/M0A/89/35/wKgDZldVTJ7ik2mfAEz8Jh_95JQ633.m4a\r\n教你打坐7$http://audio.xmcdn.com/group9/M07/88/FC/wKgDYldVTNjyshiOAH0X6r9yaFM234.m4a\r\n教你打坐8$http://audio.xmcdn.com/group10/M07/84/6E/wKgDZ1dVTR-Cd69OAECQ_ti47Co847.m4a\r\n教你打坐9$http://audio.xmcdn.com/group35/M06/03/D9/wKgJnVoSHG3w21uPADu5oJ6FIqc886.m4a\r\n教你打坐10$http://audio.xmcdn.com/group9/M02/88/FD/wKgDYldVTUPC8lX3AFTE0byy_Zs258.m4a\r\n教你打坐11$http://audio.xmcdn.com/group8/M0B/88/B4/wKgDYVdVTV6xBu2KAEwMzHgAwy0348.m4a\r\n教你打坐12$http://audio.xmcdn.com/group8/M0B/88/B5/wKgDYVdVTXTBqbhmADpGHmjLrVc009.m4a\r\n教你打坐13$http://audio.xmcdn.com/group8/M0B/88/CF/wKgDYFdVTXmBM4JdAB89Y9Spb-k348.m4a\r\n教你打坐14$http://audio.xmcdn.com/group7/M08/89/43/wKgDX1dVTYbCQF8wACAclqg6c5I372.m4a\r\n教你打坐15$http://audio.xmcdn.com/group7/M09/89/A3/wKgDWldVTb_R41jaAGcv9q-7LBQ252.m4a\r\n教你打坐16$http://audio.xmcdn.com/group14/M05/8A/1F/wKgDZFdVTcmQUzNnADM38b3JMWc070.m4a\r\n教你打坐17$http://audio.xmcdn.com/group16/M08/89/1C/wKgDaldVTd_TwwgfADdR4Rx2OhQ228.m4a\r\n教你打坐18$http://audio.xmcdn.com/group14/M05/8A/1F/wKgDZFdVTf2Ai-tPAEI2bDlcnH4626.m4a\r\n教你打坐19$http://audio.xmcdn.com/group15/M00/87/C8/wKgDZVdVThijPVQuAFJsOh7z3Nk726.m4a\r\n教你打坐20$http://audio.xmcdn.com/group15/M00/87/C8/wKgDZVdVThqyXCPGAC2evrgSzuo035.m4a\r\n教你打坐21$http://audio.xmcdn.com/group15/M00/88/02/wKgDaFdVTiCBkOwlACMvrTxexkI595.m4a\r\n教你打坐22$http://audio.xmcdn.com/group6/M02/92/66/wKgDhFdVTjGD86-LADDSInnAaQs828.m4a\r\n教你打坐23$http://audio.xmcdn.com/group6/M02/92/66/wKgDhFdVTjOhdi1VACLI4q8RKak456.m4a\r\n教你打坐24$http://audio.xmcdn.com/group6/M02/92/67/wKgDhFdVTjrRrAQJAB4h-Jmne54248.m4a\r\n教你打坐25$http://audio.xmcdn.com/group6/M09/96/6A/wKgDg1dVTlDRdPD6ADTNPH4ur9I286.m4a\r\n教你打坐26$http://audio.xmcdn.com/group11/M04/94/0A/wKgDbVdVTmGgf_smAEiRwQf-Rbs624.m4a\r\n教你打坐27$http://audio.xmcdn.com/group11/M04/94/09/wKgDbVdVTlyTbqJLABq4QjxnIgc482.m4a\r\n教你打坐28$http://audio.xmcdn.com/group11/M04/7B/21/wKgDa1dVTmfij4PUACBeqQaoqo4073.m4a\r\n教你打坐29$http://audio.xmcdn.com/group11/M04/94/0A/wKgDbVdVTnHibm_CACjvCzCrLyE568.m4a\r\n教你打坐30$http://audio.xmcdn.com/group14/M03/8A/36/wKgDY1dVTrPgVpVFAJz94Ma3HS0320.m4a\r\n人之残酷$http://audio.xmcdn.com/group14/M03/8A/35/wKgDY1dVTqfBz8ASADFfZIOcJ0U617.m4a', 'xml_8023', '4727', '', 'C', '', '1.0', 8, 0, 0, 0, 'chanzhongshuochanzhijiaonidazuo', ''),
(173, 15, '卫斯理系列之尸变[粤语]', '', '未知', '', '', '', '', 'http://imagev2.xmcdn.com/group41/M0A/90/17/wKgJ8lqzfqbjlalBAABKk6O9QAI005.jpg', '', 1530072261, 3, 0, 0, 0, 0, 1, 1, 7, 3, 'ting', '', '卫斯理~《尸变》粤语 014$http://audio.xmcdn.com/group40/M06/08/80/wKgJT1q-aCWQ2yqVAL-LuR8nDKY719.m4a\r\n卫斯理~《尸变》粤语 013$http://audio.xmcdn.com/group42/M0B/35/43/wKgJ9Fq94eGgn2WUAFbA5-PbAIM496.m4a\r\n卫斯理~《尸变》粤语 012$http://audio.xmcdn.com/group40/M03/F4/EE/wKgJVFq9H0_Bik4wAFcnsYeMiyo215.m4a\r\n卫斯理~《尸变》粤语 011$http://audio.xmcdn.com/group40/M04/F3/B9/wKgJT1q9FvqRIyhjAHWCpe1jgEo621.m4a\r\n卫斯理~《尸变》粤语 010$http://audio.xmcdn.com/group41/M09/16/84/wKgJ8Vq7zWzj5TsSAG5ul0_XZgU190.m4a\r\n卫斯理~《尸变》粤语 009$http://audio.xmcdn.com/group42/M07/F5/C2/wKgJ81q58lmzM571AK8IHTAHez4246.m4a\r\n卫斯理~《尸变》粤语 008$http://audio.xmcdn.com/group40/M03/B5/B8/wKgJVFq5H4fgrcmlAHcGTlsrEGM195.m4a\r\n卫斯理~《尸变》粤语 007$http://audio.xmcdn.com/group40/M06/A6/88/wKgJVFq4ipPxERpfAINZ-VmRaE4060.m4a\r\n卫斯理~《尸变》粤语 006$http://audio.xmcdn.com/group41/M04/D7/15/wKgJ8Vq3ziOjO4PdAJMaTdU8TtQ746.m4a\r\n卫斯理~《尸变》粤语 005$http://audio.xmcdn.com/group42/M04/C2/0E/wKgJ81q2fbTjav6PAHNF9fRqM-I178.m4a\r\n卫斯理~《尸变》粤语 004$http://audio.xmcdn.com/group40/M02/75/B4/wKgJVFq1M6PTquYhAFp__2kmUxA444.m4a\r\n卫斯理~《尸变》粤语 003$http://audio.xmcdn.com/group40/M03/69/4E/wKgJT1q0tGuzj0SIAGCFpH8o1Ik615.m4a\r\n卫斯理~《尸变》粤语 002$http://audio.xmcdn.com/group42/M00/99/25/wKgJ81qz0juR2CUTAGZMXL4JZ_E592.m4a\r\n卫斯理~《尸变》粤语 001$http://audio.xmcdn.com/group41/M06/8D/C3/wKgJ8lqzWz7RfE0lAG7bQzT7ILg172.m4a', 'xml_8023', '4725', '', 'W', '', '1.0', 2, 0, 0, 0, 'weisilixiliezhishibianyueyu', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(174, 15, '地狱杂货铺', '', '未知', '', '', '', '粉丝群公众号：六音阁如果喜欢记得点订阅！更新就自动有提示！每集听完记得动动手指点个赞！有礼物走一个也是极好的！各位书友要是觉得还不错的话请不要忘记向您QQ群和微博里的朋友推荐哦！纵然时间流逝，我们依然年轻。如果你愿意分享你自己的故事，我们将录制制关于你的故事，给更多人分享不一样的生活感悟。赶紧私信我们吧，接下来一起来听听我为你们分享小说吧！支持我们请多：打赏，点赞，评论，分享，订阅我们噢！支持我们请多：打赏，点赞，评论，分享，订阅我们噢！支持我们请多：打赏，点赞，评论，分享，订阅我们噢！', 'http://imagev2.xmcdn.com/group41/M01/13/75/wKgJ8VrJzmbzX9-zAADvjIN3XT4093.png', '', 1530072261, 6, 0, 0, 0, 0, 1, 1, 6, 10, 'ting', '', '001支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M07/34/D4/wKgJVFrOMbORHcxTALGo2XOc3dQ637.m4a\r\n002支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/6E/04/wKgJ8VrOMgCBzO3kAKOQQIMUB4s719.m4a\r\n003支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/6A/D6/wKgJ81rOMk-wd5qUAKPI7oLAM0s623.m4a\r\n004支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M05/34/E4/wKgJVFrOMqKzRCKpAKPdADCsAWo272.m4a\r\n005支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/6E/16/wKgJ8lrOMvazylMUAKPb6d6Baeg654.m4a\r\n006支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/6F/D1/wKgJ9FrOM0jCVOY0AKO3KtyKqM8182.m4a\r\n007支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/6A/EA/wKgJ81rOM7Wws7sbAKPT1QuixyM074.m4a\r\n008支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M02/34/FC/wKgJVFrONAnTY51zAKPXi1lTOR4617.m4a\r\n009支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/6E/29/wKgJ8VrONGLS3TC7AKOxSphMUBA596.m4a\r\n010支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/6A/FA/wKgJ81rONLSzw2gVAKPUrbGbEuo818.m4a\r\n011支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/6E/34/wKgJ8VrONQzy1z32AKOlF5iAAIo797.m4a\r\n012支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0B/34/33/wKgJT1rONWOTS_dcAKO1qWWMSzc909.m4a\r\n013支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/6E/42/wKgJ8VrONcfT3Fn7AKOeEO3ASEg820.m4a\r\n014支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/6F/F4/wKgJ9FrONgrQZgWXAKOc4frqpP8024.m4a\r\n015支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0A/34/3E/wKgJT1rONknA8kMRAKOyyCvJPW8563.m4a\r\n016支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/6B/13/wKgJ81rONn6B6q2vAKPKflFcvic639.m4a\r\n017支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/6F/FE/wKgJ9FrONo_T5IvfAKPS2xhNqNQ553.m4a\r\n018支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/6E/4A/wKgJ8lrONp7y_T5qAKNBo5hQv9E786.m4a\r\n019支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/6B/19/wKgJ81rONvSzLVFmAKPXd8y3pKw581.m4a\r\n020支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M07/35/24/wKgJVFrONzjwNX4NAKOyfsnRL2I660.m4a\r\n021支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/6B/22/wKgJ81rON5fAvQC-AKPKcLNxZ1M134.m4a\r\n022支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M06/35/2E/wKgJVFrON-zhA5CoAKPUrEg_HSQ374.m4a\r\n023支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M06/35/31/wKgJVFrON_zTvTU4AKj57rkAB_4462.m4a\r\n024支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/70/0F/wKgJ9FrOOAuQT-UQAKOmxC0RyTc818.m4a\r\n025支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/70/11/wKgJ9FrOOBagsywlAKPDECK_Vio688.m4a\r\n026支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/6E/61/wKgJ8VrOOD3ytGmVAKOoFyEr9NY724.m4a\r\n027支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/6E/E3/wKgJ8VrORUHBjU_uAKOcUxvcaFs256.m4a\r\n028支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M00/34/DB/wKgJT1rORVOQfvQLAKNpS_FQ2tk334.m4a\r\n029支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M00/34/DD/wKgJT1rORWPihp5QAKPYqsc0t-Q659.m4a\r\n030支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/70/9B/wKgJ9FrORXShUQYfAKLw3x1IwX0886.m4a\r\n031支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/70/9D/wKgJ9FrORYWQrEPCAKO-BITGz-o749.m4a\r\n032支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/6E/E5/wKgJ8VrORayQjYyfAKO-S_tlaMA407.m4a\r\n033支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M01/34/DD/wKgJT1rORbvT7zDYAKQWVtTOl7A844.m4a\r\n034支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M01/34/DD/wKgJT1rORbyB66BsAKM_WqxBO-8409.m4a\r\n035支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M01/35/C1/wKgJVFrORcyQXlpdAKPpA-FTgFc649.m4a\r\n036支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M01/34/E0/wKgJT1rORdmSvSy1AKN0_fbnoUY374.m4a\r\n037支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/70/A0/wKgJ9FrORe6Qd0jjAKOj7zcC3Ng954.m4a\r\n038支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M01/34/E0/wKgJT1rORdzCRbqLAD3Bo1gffDo713.m4a\r\n039支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/70/A2/wKgJ9FrORgHTO87xAKObssOy7tU830.m4a\r\n040支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/6E/E9/wKgJ8VrORh7z3UikAKO7bleT-WY482.m4a\r\n041支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/6E/E9/wKgJ8VrORiLgZA8jAKPHZ7eGCOc125.m4a\r\n042支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M03/35/C3/wKgJVFrORjPwGUqaAKP04cPCDew505.m4a\r\n043支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M03/35/C4/wKgJVFrORkKBkrlaAKPh0aTbDGc585.m4a\r\n044支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M03/34/E3/wKgJT1rORlLATdEZAKOCClxy4Lc591.m4a\r\n045支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/6E/EC/wKgJ8VrORmHQf7UUAKPBKvtQiF8237.m4a\r\n046支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/6B/BB/wKgJ81rORnCQ9VKLAKP6b6HHIf4298.m4a\r\n047支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/6B/BD/wKgJ81rORoLAFg-bAKOnG_3WOKo323.m4a\r\n048支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M09/35/C8/wKgJVFrORpiT4pCnAKN9nL2GpEg381.m4a\r\n049支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M09/34/E6/wKgJT1rORp2iTp4TAKMG25CzO08052.m4a\r\n050支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M09/34/E8/wKgJT1rORrGgDJOmAKOlkE0-li0061.m4a\r\n051支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/6B/C3/wKgJ81rORz7AnefeAKNB44b_AnM949.m4a\r\n052支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M05/35/D1/wKgJVFrOR2rwEm72AKPBYwUl_LQ058.m4a\r\n053支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M05/34/ED/wKgJT1rOR22yLd3yAKL3wzhJlI0765.m4a\r\n054支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M05/34/EF/wKgJT1rOR32wj58zAKPEggvXgW4940.m4a\r\n055支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/6E/F2/wKgJ8VrOR4uwU2jnAKKRfMXXiAA670.m4a\r\n056支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/6E/F5/wKgJ8lrOR6DDqhj1AKNUMMI0Hgk580.m4a\r\n057支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/70/AF/wKgJ9FrOR7WAyZ9oAKO174_zmsk428.m4a\r\n058支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/70/B0/wKgJ9FrOR8KQ3bgiAKPzMQtvNz8415.m4a\r\n059支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M07/34/F0/wKgJT1rOR9mBihqBAKQCQ0rA55I953.m4a\r\n060支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M07/35/D5/wKgJVFrOR-igkoOTAKPlgHbxql0652.m4a\r\n061支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M07/34/F2/wKgJT1rOR--Tlg9wAHtY3gunYAc584.m4a\r\n062支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/70/B2/wKgJ9FrOSBrw1PoeAKNHDzXkY_o384.m4a\r\n063支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/6B/CA/wKgJ81rOSB2g1wRPAKMbHaFpI8c268.m4a\r\n064支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/6E/F8/wKgJ8VrOSCvi5OtgAKO9btV7Q1s202.m4a\r\n065支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/6B/CB/wKgJ81rOSFDxrEWHAKM4rNcdyFk001.m4a\r\n066支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/6E/FB/wKgJ8lrOSE3Bv4NWAKOQDOyG1FM154.m4a\r\n067支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/6B/CB/wKgJ81rOSF2QlPl0AKPXnIzi9kQ866.m4a\r\n068支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M02/35/D7/wKgJVFrOSGrTSsQrAKOJNC2ljHk502.m4a\r\n069支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/6E/FC/wKgJ8VrOSIqw96svAKPV8-vZCY0703.m4a\r\n070支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0A/35/D8/wKgJVFrOSI2AEKz7AKN2hWSnQ5A971.m4a\r\n071支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0A/34/F6/wKgJT1rOSKKy97HiAKNrEojV9Y8855.m4a\r\n072支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/70/B6/wKgJ9FrOSLDBcmNCAKO2ZxIDFVo175.m4a\r\n073支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/6B/CD/wKgJ81rOSMORDx9NAKPIqyUf7t0757.m4a\r\n074支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/6B/CF/wKgJ81rOSNWBczyeAKPhPuv20OA677.m4a\r\n075支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/6E/FE/wKgJ8lrOSObhYuX8AKOfmwqkMeo481.m4a\r\n076支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/6E/FF/wKgJ8lrOSPaDtzw5AKPruE-9-Pg982.m4a\r\n077支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M00/35/DC/wKgJVFrOSRaQeD8aAKO_vpvLIlw241.m4a\r\n078支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M00/35/DC/wKgJVFrOSRqxmwd0AKOOqPY7_Ws497.m4a\r\n079支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/70/B9/wKgJ9FrOSSfyqxpkAKNBkaUAHNg938.m4a\r\n080支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/6B/D1/wKgJ81rOSTiwLz_2AKOcclXP9y4856.m4a\r\n081支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/6F/00/wKgJ8VrOSV7hAzZyAKPeC4O0ack418.m4a\r\n082支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/6F/01/wKgJ8lrOSVmAQjzOAKNxBseI4RA126.m4a\r\n083支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/6F/01/wKgJ8VrOSWix331UAKPXc-uOnCU893.m4a\r\n084支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M08/34/FA/wKgJT1rOSX6ixLlbAKPS1gIufQQ263.m4a\r\n085支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M08/34/FC/wKgJT1rOSZGjjTj3AKKkMxCUMpE518.m4a\r\n086支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M08/34/FD/wKgJT1rOSZ7AJK1uAKPQZG6kIA8450.m4a\r\n087支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/70/BD/wKgJ9FrOSbTBTn4oAKM0So-EJoM141.m4a\r\n088支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/70/BF/wKgJ9FrOScbTyJLGAKOTzdgOF0o715.m4a\r\n089支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0B/34/FE/wKgJT1rOSdnhhCBUAKN2-NgXqis841.m4a\r\n090支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/6F/04/wKgJ8VrOSeqDDaV8AKOlXH3oSsA377.m4a\r\n091支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M06/34/FF/wKgJT1rOSfyjh6fSAKPEia1reVQ681.m4a\r\n092支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M06/35/00/wKgJT1rOSgjArfX7AKOG1meYv_Q182.m4a\r\n093支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/6F/05/wKgJ8VrOSheB9VPPAKPtbkyEn1o585.m4a\r\n094支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/6F/07/wKgJ8lrOSiiRjbQ6AKPaWFuZB40558.m4a\r\n095支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/6B/D6/wKgJ81rOSjfBL1nKAKOPmwyub5o135.m4a\r\n096支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/70/C1/wKgJ9FrOSk2CCYUKAKPrUMMgk1M311.m4a\r\n097支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/6B/D9/wKgJ81rOSlazyFcUAKMSa3k96Xs075.m4a\r\n098支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/6F/08/wKgJ8lrOSmbTYIFZAKPgADpKRUE114.m4a\r\n099支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M02/35/01/wKgJT1rOSniT1FyqAKPHIfEA7PQ416.m4a\r\n100支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M02/35/E5/wKgJVFrOSoazyO92AKO0Wa86fvU766.m4a\r\n101支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M05/35/D0/wKgJVFrOR1nSl84lAKPBTgeEUWo843.m4a\r\n102支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/70/AF/wKgJ9FrOR7qCkwGNAKQH6VDC1Wc502.m4a\r\n103支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/6B/C9/wKgJ81rOSBrBdkrHAKOzpmpyS5g060.m4a\r\n104支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M02/34/F4/wKgJT1rOSG2QnEA1AKPGkYYDfpo928.m4a\r\n105支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/70/B8/wKgJ9FrOSM7Qe6T_AKPwzdQo1yY965.m4a\r\n106支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/6B/D0/wKgJ81rOSS6ybMx4AKPwX6-sw60371.m4a\r\n107支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M08/34/FC/wKgJT1rOSY2zNvRMAKPQvc-xZWo884.m4a\r\n108支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/6F/03/wKgJ8VrOSeLD5iHVAKO1t2tu1AM892.m4a\r\n109支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/6B/D6/wKgJ81rOSjnCY8B3AKOJjYvd66Y604.m4a\r\n110支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/6F/0A/wKgJ8lrOSpXDeyCRAKPTcReSoJY865.m4a\r\n111支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M04/35/06/wKgJT1rOSu7zP0e_AKPS_SJ2KZc339.m4a\r\n112支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/6F/0D/wKgJ8lrOS0bDAzQyAKQAdZHDtBM229.m4a\r\n113支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/70/CA/wKgJ9FrOS5yyQPTJAKPsucMjHgc783.m4a\r\n114支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M01/35/F0/wKgJVFrOS_TSXIH7AKNOn8Vnt0w563.m4a\r\n115支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0A/35/0F/wKgJT1rOTF3A8Q1bAKN5kK3fO8E898.m4a\r\n116支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/6F/15/wKgJ8lrOTKbDKkRXAKQJQsyZmes390.m4a\r\n117支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/6B/E9/wKgJ81rOTPzhsV2uAKPrN__JEWM194.m4a\r\n118支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M02/35/17/wKgJT1rOTVTRdhuRAKPS1usbO_8525.m4a\r\n119支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/6F/1C/wKgJ8VrOTanDVAL8AKNHSqcY8TA494.m4a\r\n120支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/6B/EF/wKgJ81rOTf_xvYb1AKOyjhLs4b0233.m4a\r\n121支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M07/35/FE/wKgJVFrOTmyy3pCDAKMTDhc-sXg976.m4a\r\n122支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/6B/F0/wKgJ81rOTq_ytLCMAKPORmBj2wA424.m4a\r\n123支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/6F/22/wKgJ8lrOTwbDz2cLAKPddUQg2Bs683.m4a\r\n124支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/70/DD/wKgJ9FrOTzjwD9OsAKK_6-HCfrk451.m4a\r\n125支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/70/DF/wKgJ9FrOT0yRRPQ1AKPRFZEvYw4482.m4a\r\n126支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/6F/24/wKgJ8lrOT1nhJQFMAKOt7FK2dJs280.m4a\r\n127支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M03/35/22/wKgJT1rOT2bC6h_IAKMe8Low8uU025.m4a\r\n128支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/6F/25/wKgJ8VrOT4XQYwBAAKPGML-XsmM917.m4a\r\n129支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/6F/26/wKgJ8lrOT4XhePSDAKOh4al1Euw979.m4a\r\n130支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M06/35/23/wKgJT1rOT5bitGtpAKPQT8LNP_Q468.m4a\r\n131支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M06/36/06/wKgJVFrOT6TzmDG7AKQCkw40hhQ484.m4a\r\n132支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M06/35/25/wKgJT1rOT7PwJwjrAKQDpFZG-1o461.m4a\r\n133支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/70/E1/wKgJ9FrOT9TSVJqYAKPaJCBDV8M969.m4a\r\n134支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/70/E2/wKgJ9FrOT-LDZC91AKN8itsuCbU560.m4a\r\n135支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/6F/26/wKgJ8VrOT_ChETgqAKPuCFM39p8450.m4a\r\n136支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M01/36/07/wKgJVFrOUAvTbV1MAKPZIK1Y5AU754.m4a\r\n137支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M01/36/09/wKgJVFrOUC2ibyd6AKOZg9orFYU950.m4a\r\n138支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/70/E4/wKgJ9FrOUEni7b8SAKPUP8gBkFk010.m4a\r\n139支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/6F/2A/wKgJ8lrOUGigGvK2AKPhD9cSyeI814.m4a\r\n140支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0B/35/29/wKgJT1rOUKKDTK3fAKPdYOTMDOY374.m4a\r\n141支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0B/35/2A/wKgJT1rOUN7z-qtLAKQTnSr1ZM8328.m4a\r\n142支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M08/36/0E/wKgJVFrOUUTBW-PyAKPFypcUOSM650.m4a\r\n143支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/6C/03/wKgJ81rOUcDAMPSXAKPo0U9P0N4648.m4a\r\n144支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/6F/36/wKgJ8lrOUkvRW32nAKNjMOaA9Lo710.m4a\r\n145支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M03/36/15/wKgJVFrOUtTwONS7AKPgADXny8A379.m4a\r\n146支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/70/F3/wKgJ9FrOU3_iJrlcAKP3gPPItuY711.m4a\r\n147支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M00/36/1C/wKgJVFrOVCCBY9xhAKODuACc22w877.m4a\r\n148支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M04/35/3D/wKgJT1rOVL-BU-dtAKN9ps2x5FA522.m4a\r\n149支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M09/35/40/wKgJT1rOVT6C09-oAKN9nP6MtQw580.m4a\r\n150支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/6F/48/wKgJ8VrOVdPiJ7qsAKO3DX9wqV8981.m4a\r\n151支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/6E/F2/wKgJ8VrOR4eC4iP0AKPbmfdyUCU195.m4a\r\n152支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/6E/F6/wKgJ8lrOR9WgEEaHAKPNICbXAuk438.m4a\r\n153支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/6E/F9/wKgJ8lrOSDOya9LIAKOmujfqzRg681.m4a\r\n154支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0A/34/F6/wKgJT1rOSKHRKryrAKQavKh8Gds512.m4a\r\n155支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/6E/FE/wKgJ8lrOSOvhvhLcAKOf1WsPFME265.m4a\r\n156支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/6B/D1/wKgJ81rOSUXgvmqCAKPr9gKIXt8326.m4a\r\n157支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/6B/D3/wKgJ81rOSZ_AZZNzAKP6b_AiuzY635.m4a\r\n158支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M06/35/E2/wKgJVFrOSgzwt9TSAKQKlvxcRAY199.m4a\r\n159支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/6B/D9/wKgJ81rOSlSjVrJQAKO-ceD2e40665.m4a\r\n160支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/70/C3/wKgJ9FrOSq2zDPUQAKPdEXkz0fE650.m4a\r\n161支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/6B/DC/wKgJ81rOSwqSOdkKAKO24XN-jGU682.m4a\r\n162支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M03/35/EC/wKgJVFrOS27TLks2AKOZgzSrlmc841.m4a\r\n163支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/6F/10/wKgJ8lrOS8KwG8pMAKNaXzgJxHw384.m4a\r\n164支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/70/CD/wKgJ9FrOTA3zQkJmAKP2CJHnOD8561.m4a\r\n165支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0A/35/10/wKgJT1rOTGfwfu0lAKPS_pm7z7A468.m4a\r\n166支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M08/35/F3/wKgJVFrOTMPCxKZzAKPkZtCaXlQ804.m4a\r\n167支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0B/35/F7/wKgJVFrOTRWCVWZ5AKOJXK8GwUA060.m4a\r\n168支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/6F/1A/wKgJ8VrOTWuTonAIAKP2rBH3-tI724.m4a\r\n169支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M05/35/FA/wKgJVFrOTcGxjRbYAKPSyGSVLk0912.m4a\r\n170支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/6F/1F/wKgJ8lrOThezbFj_AKODfgcRNCk706.m4a\r\n171支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M07/35/1E/wKgJT1rOToLglGv1AKPV59JkcjY053.m4a\r\n172支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M09/36/01/wKgJVFrOTsWQi9W1AKPkZs9iX80727.m4a\r\n173支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/6B/F2/wKgJ81rOTxzyH2AeAKM6cDqSW1c211.m4a\r\n174支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M03/35/22/wKgJT1rOT2zRCEENAKLWNyb5bVw549.m4a\r\n175支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/70/DF/wKgJ9FrOT8OyEBjRAKLzlcOqnHY115.m4a\r\n176支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/6B/FA/wKgJ81rOUDXh7IdZAKMYSXTj2Cw544.m4a\r\n177支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/6F/2D/wKgJ8lrOULPBd0drAKNV-a88R4c865.m4a\r\n178支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/6F/2F/wKgJ8VrOUWSDk07_AKNHStK7lAY548.m4a\r\n179支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/6F/35/wKgJ8lrOUiWzdUPhAKMkCWcGFU0652.m4a\r\n180支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M03/35/36/wKgJT1rOUv3jjXPwAKMOO9KQ4aU039.m4a\r\n181支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/70/F4/wKgJ9FrOU-LiKoslAKM13WbT79c067.m4a\r\n182支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M04/36/20/wKgJVFrOVM3wTSm0AKNTBgaJsrU088.m4a\r\n183支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/6F/49/wKgJ8lrOVanAWlmxAKNpDwIk9tk125.m4a\r\n184支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/6C/18/wKgJ81rOVnDT5BTpAKNEVwI6oHo270.m4a\r\n185支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/6C/19/wKgJ81rOVvvyiJoWAKM4mm0Ls80160.m4a\r\n186支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M02/36/2B/wKgJVFrOV1KSm2H5AKModDH6cxc255.m4a\r\n187支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/6F/52/wKgJ8lrOV6rwpv0SAKNHSrWsmJI825.m4a\r\n188支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/6C/20/wKgJ81rOWBSCAIJMAKNRjvArX2k877.m4a\r\n189支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/6F/56/wKgJ8lrOWGWC7igAAKM9AQKvHaY084.m4a\r\n190支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/71/0B/wKgJ9FrOWMahpdM5AKMfo7qwB4Y266.m4a\r\n191支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/71/0D/wKgJ9FrOWSmSgPGKAKPzd4G5rUU946.m4a\r\n192支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/6F/58/wKgJ8VrOWVvwR_vKAKONw85JZIg423.m4a\r\n193支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M06/35/55/wKgJT1rOWWyjdv4sAKOmup7_oYs892.m4a\r\n194支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M06/35/56/wKgJT1rOWXzAlUPyAKQATR9K8Fw387.m4a\r\n195支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M06/35/57/wKgJT1rOWYzw36NfAKO24bq1vsA381.m4a\r\n196支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/71/11/wKgJ9FrOWajTNXHfAKNnl2A3UK0740.m4a\r\n197支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/6F/5C/wKgJ8lrOWcTCddgKAKO16IqELII334.m4a\r\n198支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0A/36/37/wKgJVFrOWerR6j-wAKOjyyJAXjw433.m4a\r\n199支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0A/35/58/wKgJT1rOWfviGQftAKPoBOUEPUk562.m4a\r\n200支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0B/36/3A/wKgJVFrOWifxTGr-AKOccic1irc917.m4a\r\n201支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/6E/F3/wKgJ8lrOR4ewPx-eAKNYN2ic2OE601.m4a\r\n202支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M07/34/F1/wKgJT1rOR-fBmM9kAKNAWRihAOk138.m4a\r\n203支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/6E/FA/wKgJ8lrOSETjs10CAKMyuAWLyl8972.m4a\r\n204支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0A/35/D9/wKgJVFrOSKDAwHqdAKLDIRkY5nI807.m4a\r\n205支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/6E/FF/wKgJ8VrOSP-yhVM1AKLEmMgEyWY297.m4a\r\n206支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/6F/02/wKgJ8VrOSWuiIAoWAKNmIGGLvHA843.m4a\r\n207支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/70/BE/wKgJ9FrOScHRaz_6AKNaXzfcHac085.m4a\r\n208支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/6F/05/wKgJ8VrOShniD3P0AKLWN8cxRok186.m4a\r\n209支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/6F/09/wKgJ8lrOSnHCiLsqAKNmIPVAfpE475.m4a\r\n210支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/70/C5/wKgJ9FrOSsyTcpCHAKNiBPzywjg267.m4a\r\n211支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/6B/DD/wKgJ81rOSyHR6CusAKNpF09lvNU145.m4a\r\n212支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M03/35/EC/wKgJVFrOS3mC5_5QAKNBaD3sxKc874.m4a\r\n213支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/6F/11/wKgJ8lrOS8-ys3rNAKMSb1sxOTA172.m4a\r\n214支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0A/35/0D/wKgJT1rOTCjimgKuAKNQyObLgrA011.m4a\r\n215支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/6F/13/wKgJ8VrOTHyhCeUsAKNIwQwTgBk984.m4a\r\n216支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M08/35/12/wKgJT1rOTNaQM-pOAKNnl9Pnlb4356.m4a\r\n217支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/6F/18/wKgJ8VrOTSnjUPRiAKNtl3xoplo971.m4a\r\n218支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/70/D4/wKgJ9FrOTX_i-Jk6AKNY6KoS94o488.m4a\r\n219支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/6B/EC/wKgJ81rOTdewKbn-AKMfo8Ty_8Y825.m4a\r\n220支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M00/35/1A/wKgJT1rOTi3ysZjvAKLtt7VkZek030.m4a\r\n221支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M07/36/00/wKgJVFrOTobDyz2vAKOPPjf0EIA608.m4a\r\n222支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M09/36/02/wKgJVFrOTuSghxCDAKNO2ignaVw142.m4a\r\n223支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/6B/F3/wKgJ81rOTzKjgo1RAKL8ZuDaZA8658.m4a\r\n224支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/6F/26/wKgJ8lrOT4KhN0BAAKNzjf5Zdbg191.m4a\r\n225支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/6F/26/wKgJ8VrOT-aT36qGAKMYYtzelII663.m4a\r\n226支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/70/E4/wKgJ9FrOUEuCgZ8kAKPUP3EkeUg317.m4a\r\n227支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M0B/36/0B/wKgJVFrOUNST7sZsAKNaXzlYDlE574.m4a\r\n228支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/6F/31/wKgJ8lrOUYvRaWycAKOMSzd04g8055.m4a\r\n229支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/6F/35/wKgJ8VrOUlrDL89cAKPi76Y3Rxs605.m4a\r\n230支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/6F/3C/wKgJ8lrOUzrSMY8GAKPHTfNoqDU302.m4a\r\n231支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group40/M00/35/3A/wKgJT1rOVB-Qj0jzAKOuXsGZZFc902.m4a\r\n232支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/6C/12/wKgJ81rOVPjTGW2CAKOJXGuCk_E310.m4a\r\n233支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/6F/4B/wKgJ8lrOVduQw_RQAKO4wvEYE1g992.m4a\r\n234支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/71/01/wKgJ9FrOVqnDKPG3AKPUP_QdYy4053.m4a\r\n235支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/6C/1A/wKgJ81rOVxKTjFknAKNqhrUShOw640.m4a', 'xml_8023', '4726', '', 'D', '', '1.0', 3, 0, 0, 0, 'diyuzahuopu', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(175, 15, '亡灵鬼屋[鬼故事]', '', '未知', '', '', '', '群：689283820                                 喜欢请点赞、评论、赞助感谢您的支持 ~ ~如果喜欢记得点订阅！更新就自动有提示！                  支持我们请多：打赏，点赞，评论，分享，订阅我们噢！每集听完记得动动手指点个赞！有礼物走一个也是极好的！各位书友要是觉得还不错的话请不要忘记向您QQ群和微博里的朋友推荐哦！如果你愿意分享你自己的故事，我们将录制关于你的故事，给更多人分享不一样的生活感悟。赶紧私信我们更多人分享不一样的生活感悟。赶紧私信我们吧，接下来一起来听听我为你们分享小说吧！', 'http://imagev2.xmcdn.com/group39/M00/E6/13/wKgJn1p_JCrA9MbnAAEm1t3PS2c876.jpg', '', 1530072261, 0, 0, 0, 0, 0, 1, 1, 5, 4, 'ting', '', '001 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E6/20/wKgJn1p_JNbQ-rGXAJzHir6KFmw944.m4a\r\n002 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E5/34/wKgJo1p_JOXwaoMWAJwFtlzNAWg643.m4a\r\n003 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E4/F5/wKgJolp_JQWSDSpTAJvVQumJaxU551.m4a\r\n004 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E4/F6/wKgJolp_JQrDqZNsAJvMcJ60Mqg039.m4a\r\n005 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/AE/wKgJnlp_JS_SuPRZAJvj8RFyEps605.m4a\r\n006 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/3F/wKgJo1p_JW3zGCsQAJvYMdA7sQw211.m4a\r\n007 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/44/wKgJo1p_JZTipFq9AJt4wOzNZAU126.m4a\r\n008 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/BC/wKgJnlp_JefxNPD2AJuDBfdbLc4168.m4a\r\n009 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/4D/wKgJo1p_JkmALhQiAJuAFRxQzuE844.m4a\r\n010 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/CE/wKgJnlp_Jr7g0ps3AJujUh-SmP8341.m4a\r\n011 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/44/wKgJn1p_Jx_AATXbAJvQ2wqoI7M880.m4a\r\n012 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/1A/wKgJolp_J4iBsUwKAJvN6EacScA996.m4a\r\n013 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/64/wKgJo1p_J_DhHfFZAJujUoCX4Aw260.m4a\r\n014 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/E3/wKgJnlp_KFWzWtXvAJtJv1Rx46I077.m4a\r\n015 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/2D/wKgJolp_KLvAy2HiAJukzXTztNA762.m4a\r\n016 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/77/wKgJo1p_KSnRyAMWAJutm8Zloi0429.m4a\r\n017 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/6B/wKgJn1p_KYuC1OafAJx_ls6yRJM405.m4a\r\n018 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/84/wKgJo1p_KfrAzysNAJue67lPV1E605.m4a\r\n019 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/04/wKgJnlp_KkWRQLLKAJrSzveyqOA650.m4a\r\n020 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E7/07/wKgJnlp_KqnSSLBxAJQbRZpjQ2g205.m4a\r\n021 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/11/wKgJnlp_KvWxPkLXAJtPoTzevsw423.m4a\r\n022 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/8A/wKgJn1p_K2mDXpaNAJrdFzWpLWE475.m4a\r\n023 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/17/wKgJnlp_K8XwiDx5AJvSU9vJq_s646.m4a\r\n024 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E5/62/wKgJolp_LDvwSwmqAJvFGz76Syk055.m4a\r\n025 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/B3/wKgJo1p_LNeAY8E9AJutm_I-j3o448.m4a\r\n026 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E5/75/wKgJolp_LXbBc9NrAJuddEYpUT4474.m4a\r\n027 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/3B/wKgJnlp_LjvhZZG5AJtMshIQ_Ow695.m4a\r\n028 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/49/wKgJnlp_LxbSyMAjAJfP46lvp7g737.m4a\r\n029 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/93/wKgJolp_L7LSVvWNAJrwLWgaY1Q921.m4a\r\n030 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/CA/wKgJn1p_MFLSJwepAJro18nqQqc227.m4a\r\n031 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E6/D1/wKgJn1p_MPPwOC2rAJo9BwBqAx0074.m4a\r\n032 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/AC/wKgJolp_MZLSyZGmAJxjs39i3v4288.m4a\r\n033 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E6/E2/wKgJn1p_MlviWVpfAJuahS772X8959.m4a\r\n034 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E6/03/wKgJo1p_MvvSwtLSAJuUo42new4910.m4a\r\n035 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/82/wKgJnlp_M8HxXY6IAJqpsKlgAQw876.m4a\r\n036 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/CD/wKgJolp_NGmBuNiTAJveD7dWxNM913.m4a\r\n037 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E6/1A/wKgJo1p_NR_iA5UZAJxjs7SU038279.m4a\r\n038 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/DD/wKgJolp_NdqR4IRDAJvm4O0ewRY325.m4a\r\n039 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/9E/wKgJnlp_NonwKjkRAJsJJBV7eB0409.m4a\r\n040 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/34/wKgJo1p_NzLT1pQ1AJpQHYdSuMQ337.m4a\r\n041 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E6/3D/wKgJo1p_N-qjcMAQAJvJge9IPmE458.m4a\r\n042 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/B5/wKgJnlp_OKOhvmAfAJos4cBbtvM969.m4a\r\n043 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/2B/wKgJn1p_OTWhTdVoAJrFl22gIns806.m4a\r\n044 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/C4/wKgJnlp_Oe_j2liIAJuDBczd9Gs012.m4a\r\n045 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E6/5B/wKgJo1p_OoTDP71NAJsn-pMed60772.m4a\r\n046 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E6/63/wKgJo1p_O1HAhi-SAJr9ZALWoEA396.m4a\r\n047 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/49/wKgJn1p_PBXhdX4jAJonAtmxJi0313.m4a\r\n048 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/E0/wKgJnlp_PLmDs3EVAJqrK_bwaxs299.m4a\r\n049 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E6/7A/wKgJo1p_PU_h1JolAJnjdVkDV1s113.m4a\r\n050 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/5A/wKgJn1p_PfPzZgGVAJvTymUYWxo487.m4a\r\n051 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E5/36/wKgJo1p_JPjQRc4dAJzqyw7L7FE909.m4a\r\n052 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E4/F7/wKgJolp_JQ-xq5ZcAJnO51ytE-4299.m4a\r\n053 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E4/FA/wKgJolp_JSmRxVpFAJuBje6RBnA184.m4a\r\n054 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/40/wKgJo1p_JXeiyCoFAJtbYd4Ci6g088.m4a\r\n055 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E6/B9/wKgJnlp_Jc2SAS3fAJrqTzVe-is061.m4a\r\n056 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/4B/wKgJo1p_JjvCxZSIAJu8St8F-TY540.m4a\r\n057 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/0E/wKgJolp_JpST7izFAJu9wRWCSaw072.m4a\r\n058 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E5/15/wKgJolp_Jv_RaMuwAJw0spJP4ks973.m4a\r\n059 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E6/D9/wKgJnlp_J26AXBIJAJuBjUt025g333.m4a\r\n060 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E6/DD/wKgJnlp_J9jzUskTAJoGsbJerPc792.m4a\r\n061 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/E1/wKgJnlp_KDnRGrt3AJoimFWgJcM697.m4a\r\n062 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/5F/wKgJn1p_KJSxbUDeAJk0tifrY84340.m4a\r\n063 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E6/63/wKgJn1p_KP2jsCm6AJntvV-1hSk718.m4a\r\n064 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/68/wKgJn1p_KXCQSq3zAJwNDx5UKJE662.m4a\r\n065 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E5/81/wKgJo1p_KduT6J1LAJsWXNcmlgk845.m4a\r\n066 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E6/77/wKgJn1p_KjvxGlDuAJuEfJGImII725.m4a\r\n067 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E7/07/wKgJnlp_KqXQqLiXAJpRlQtqKJ8802.m4a\r\n068 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/94/wKgJo1p_KwyjmDOEAJutm86I4KI029.m4a\r\n069 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/8B/wKgJn1p_K3LDseQbAJuHb4bOeDM092.m4a\r\n070 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/8E/wKgJn1p_K92j8PtNAJqCDbdeZ9k906.m4a\r\n071 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/24/wKgJnlp_LIbT2TF6AJo7kPiotII158.m4a\r\n072 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E6/9F/wKgJn1p_LQ2wwQx3AJvMtHfbPW8277.m4a\r\n073 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E6/AA/wKgJn1p_LbaQIvzyAJqg4xsIOb4618.m4a\r\n074 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/B2/wKgJn1p_Ll-SscS1AJtkL1dsEFI164.m4a\r\n075 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/BB/wKgJn1p_LwvgVvkNAJxKu5-14P8977.m4a\r\n076 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/50/wKgJnlp_L77Qem9bAJtfyEY5N5Y465.m4a\r\n077 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/E2/wKgJo1p_MGuwwqAEAJwaR_0ff9o480.m4a\r\n078 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/D3/wKgJn1p_MSSxmO8HAJu2bNbg3vw518.m4a\r\n079 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/B0/wKgJolp_MdySz3WnAJt7rx3CzBU224.m4a\r\n080 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/72/wKgJnlp_MnPDAKs5AJpwbpA64rA924.m4a\r\n081 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/78/wKgJnlp_MwriMLbiAJp3xDpKHuw338.m4a\r\n082 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/81/wKgJnlp_M7WiVfJnAJpb3T_yhhY458.m4a\r\n083 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/89/wKgJnlp_NFbTCmuOAJqWmqCzpBg024.m4a\r\n084 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/02/wKgJn1p_NP2hhC4aAJukzdNq5eU309.m4a\r\n085 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/0A/wKgJn1p_Na7ws-zwAJveD1LN0w8499.m4a\r\n086 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/E4/wKgJolp_NlWjrUaVAJt1zdpjaiY899.m4a\r\n087 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/EB/wKgJolp_Nv3iKp7oAJu8Ssm5Cx4768.m4a\r\n088 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/F7/wKgJolp_N6fQgimBAJvQ2z72DXA531.m4a\r\n089 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/FD/wKgJolp_OErCco-lAJphv3hRrlw798.m4a\r\n090 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E6/46/wKgJo1p_ONnT2hpBAJuddJbAFME339.m4a\r\n091 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E6/0C/wKgJolp_OYiiEcrTAJwbv-yCuVc541.m4a\r\n092 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E6/58/wKgJo1p_OkDw1bRgAJpF2M6B5O0245.m4a\r\n093 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/CB/wKgJnlp_OtSyUw7OAJtOKosoyDs212.m4a\r\n094 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E7/D5/wKgJnlp_O5ii2K_IAJuBjUE1h8I294.m4a\r\n095 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E6/6F/wKgJo1p_PDDAuxMsAJukzbY4roo427.m4a\r\n096 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E6/76/wKgJo1p_PP-T0AW2AJqYEQVHgM4913.m4a\r\n097 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E6/38/wKgJolp_PZ-QIwtpAJvZqCzZltM377.m4a\r\n098 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E6/3F/wKgJolp_PlrCylQqAJsmg5XDf6A136.m4a\r\n099 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E6/8C/wKgJo1p_PtuRukYeAJuddE8K5xg342.m4a\r\n100 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E6/8F/wKgJo1p_P2DRaOXMAJst2DJaVQ0327.m4a\r\n101 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E5/39/wKgJo1p_JQvDLRLKAJq4X7q4Ync958.m4a\r\n102 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E5/3C/wKgJo1p_JSHDZwD8AJukzdL0JD0620.m4a\r\n103 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/3F/wKgJo1p_JW7zxQftAJpjNzzY254966.m4a\r\n104 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/02/wKgJolp_JaDxF_t9AJwaR_mVMPY386.m4a\r\n105 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/03/wKgJolp_JhLwN_SWAJt4wNFxpOw859.m4a\r\n106 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/C6/wKgJnlp_JnnS_-W8AJs5mVngz_M441.m4a\r\n107 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E5/54/wKgJo1p_JtzDcKqrAJsAUxLiucQ347.m4a\r\n108 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E6/D4/wKgJnlp_J0CQncBWAJxd0Xc__-0660.m4a\r\n109 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/61/wKgJo1p_J6jQrHaXAJs7ECF3GhI017.m4a\r\n110 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/24/wKgJolp_KBDwGDYGAJsQeirIff8660.m4a\r\n111 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/E9/wKgJnlp_KIDRea6CAJq_uJOo9j4744.m4a\r\n112 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/31/wKgJolp_KOjx_2REAJtxZvUXvgE222.m4a\r\n113 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/39/wKgJolp_KVKRETgYAJrIii4dJ3k586.m4a\r\n114 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/FC/wKgJnlp_Kb2g6UsHAJuL1vMPN3Q986.m4a\r\n115 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/01/wKgJnlp_KjDTPunQAJ4KmYxyyUo312.m4a\r\n116 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E6/79/wKgJn1p_KpXRiztzAJwKHB0juJM945.m4a\r\n117 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E6/86/wKgJn1p_KvnhB6o5AJuTK2VBsi0735.m4a\r\n118 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/12/wKgJnlp_K02ClCm8AJvsvlQ9rjw062.m4a\r\n119 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/5E/wKgJolp_K7ORFi8fAJqpsCSIPE4834.m4a\r\n120 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/1F/wKgJnlp_LA7BOOpwAJphv8wuMzM883.m4a\r\n121 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/AE/wKgJo1p_LKvwBESnAJvoVz1I4v0078.m4a\r\n122 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E6/A6/wKgJn1p_LVGDJYGPAJ4GMkSJRsA414.m4a\r\n123 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/80/wKgJolp_LgiDKMvcAJvsvtREIF8745.m4a\r\n124 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E7/41/wKgJnlp_LsqQsvctAJm6VpVwccs911.m4a\r\n125 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E6/BF/wKgJn1p_L4XS9q_CAJz8afLb3fs265.m4a\r\n126 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/DE/wKgJo1p_MBvhrmpKAJqbAHtfnKw597.m4a\r\n127 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/A1/wKgJolp_MMHjHTQ6AJwhnUFwUfw692.m4a\r\n128 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/EE/wKgJo1p_MW3jU58iAJwNDw-4NOE554.m4a\r\n129 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/DB/wKgJn1p_MhKjHAPnAJoimNaSdTo450.m4a\r\n130 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/B9/wKgJolp_MqygJbMFAJxJREDrWxM961.m4a\r\n131 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E6/09/wKgJo1p_M2PDeg-ZAJuDBdV-aoI215.m4a\r\n132 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E6/11/wKgJo1p_NCyTzh_aAJuOxaW2cLs239.m4a\r\n133 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/00/wKgJn1p_NOKyNdbvAJrejsKKe64537.m4a\r\n134 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/97/wKgJnlp_NYCAWrnHAJvpzzBVMyk115.m4a\r\n135 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/9B/wKgJnlp_NhWw-LWGAJxJRCQWC5Q938.m4a\r\n136 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E7/A5/wKgJnlp_Nt_xzpWVAJs1MqncQ1U211.m4a\r\n137 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E6/3A/wKgJo1p_N5iyV1OuAJrHDty3o9Y251.m4a\r\n138 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E6/42/wKgJo1p_OE6DWMijAJro191xDFQ581.m4a\r\n139 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E6/03/wKgJolp_OOqxmt1IAJPgiI9iTaA150.m4a\r\n140 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/31/wKgJn1p_OcSjd2ZHAJtnHgko3tA322.m4a\r\n141 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/38/wKgJn1p_Olmz0JhLAJzsQmdewFQ211.m4a\r\n142 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/41/wKgJn1p_OxHiQcGWAJwtXYS5n5s859.m4a\r\n143 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/24/wKgJolp_O7zRTAZaAJsJJE3PS-E072.m4a\r\n144 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/4B/wKgJn1p_PHmgwhqMAJv1j7O6c6I665.m4a\r\n145 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/E1/wKgJnlp_PRXgndjIAJx_lsdqlV8629.m4a\r\n146 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E6/39/wKgJolp_PaaRGoheAJrP30ISLak066.m4a\r\n147 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E6/86/wKgJo1p_PmaxmyOgAJxPIol2meA906.m4a\r\n148 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/F3/wKgJnlp_PxDx78kuAJvAsMDpV-w814.m4a\r\n149 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/F9/wKgJnlp_P7aRyyytAJr2DxV_pFI635.m4a\r\n150 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/FE/wKgJnlp_QELyt7UMAJv59htKkU8222.m4a\r\n151 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E4/F9/wKgJolp_JSeyFLMYAJvbIG2XgYE846.m4a\r\n152 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/B2/wKgJnlp_JU-h3BuJAJtkL0Yqm3M727.m4a\r\n153 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/43/wKgJo1p_JY6RSHBBAJuzfYPozKQ642.m4a\r\n154 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/BB/wKgJnlp_Jd7ycbITAJ0_95MVOEY622.m4a\r\n155 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/4C/wKgJo1p_JkCiKkC9AJu2bJGC8BE576.m4a\r\n156 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/41/wKgJn1p_Jr3SxwNzAJtSkK2-Nok951.m4a\r\n157 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/CF/wKgJnlp_JxXikaiPAJsGNf3qCGo004.m4a\r\n158 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/19/wKgJolp_J4LzK5_1AJs5mULtrMc260.m4a\r\n159 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/64/wKgJo1p_J_yT-LshAJvyoKyOv0s825.m4a\r\n160 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/56/wKgJn1p_KEKyGkDFAJugY_63TUk571.m4a\r\n161 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/6D/wKgJo1p_KKiDuXMSAJqNzXyWrHE017.m4a\r\n162 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E6/EF/wKgJnlp_KQGCoE1pAJtqEUhWmIk505.m4a\r\n163 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/69/wKgJn1p_KX-Tq0cYAJuQPOMdb4A034.m4a\r\n164 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/82/wKgJo1p_KerCIcYxAJumReI04N4927.m4a\r\n165 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E5/46/wKgJolp_KlHyCB-6AJtUCC41HZ0604.m4a\r\n166 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E6/7E/wKgJn1p_KriSKwPOAJqrK95Sc-o746.m4a\r\n167 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/97/wKgJo1p_KyTzCQk4AJqxCdKefBU137.m4a\r\n168 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/9E/wKgJo1p_K42SzE_KAJrFl0RDZNw114.m4a\r\n169 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/1D/wKgJnlp_K_zhol_8AJvhAjajW6o438.m4a\r\n170 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E6/97/wKgJn1p_LHnjBeZMAJm6VpuRAWs585.m4a\r\n171 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E6/A2/wKgJn1p_LSSThr5rAJoFOc38bMA492.m4a\r\n172 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/7A/wKgJolp_LdHBc2UpAJmlyUUNQb4378.m4a\r\n173 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/B4/wKgJn1p_LnTD4Kn8AJrCpzvlVKM022.m4a\r\n174 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/BC/wKgJn1p_LxfjZngCAJj1kh2viUA092.m4a\r\n175 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/D9/wKgJo1p_L7DivoBQAJwersLwHc8415.m4a\r\n176 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/56/wKgJnlp_MEHxs-83AJhfy4v33mA398.m4a\r\n177 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/A4/wKgJolp_MNmRuDYnAJuKXt7OAtI518.m4a\r\n178 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/EF/wKgJo1p_MXiw5pB3AJo3KQ-W4w0520.m4a\r\n179 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/B4/wKgJolp_MgixR-7UAJqpsEcUpco518.m4a\r\n180 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/B9/wKgJolp_Mq3T81xlAJsgpT3ym8M236.m4a\r\n181 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E6/08/wKgJo1p_M13S56GfAJs8iA_MQbI967.m4a\r\n182 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E6/0E/wKgJo1p_NBOT-AlwAJq_uOyK6hU389.m4a\r\n183 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/8C/wKgJnlp_NLuCvuctAJj0G8FNoUo570.m4a\r\n184 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/96/wKgJnlp_NXXBUFzsAJwbv7G3nHI741.m4a\r\n185 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/9B/wKgJnlp_Nhuyj_5EAJs2qmfnrNc970.m4a\r\n186 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E7/13/wKgJn1p_NsfADWUJAJp9on53wD8850.m4a\r\n187 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E6/35/wKgJo1p_N2uQjo-JAJo1soWBgAs329.m4a\r\n188 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E6/3F/wKgJo1p_OCqQvF0CAJuqrCXKMvg614.m4a\r\n189 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/B8/wKgJnlp_OM6RjcbGAJxKu9SFrY8945.m4a\r\n190 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E6/4F/wKgJo1p_OXCDe5cCAJ0FOq30K9s183.m4a\r\n191 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E6/56/wKgJo1p_Oh7iMfK8AJwqbll4Fiw410.m4a\r\n192 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/3B/wKgJn1p_OtDzjmzAAJteUcMynHA810.m4a\r\n193 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E7/44/wKgJn1p_O46BmJR4AJuRtApnVFM008.m4a\r\n194 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E6/2B/wKgJolp_PDbj4eiOAJv1jwFVW1g700.m4a\r\n195 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E6/30/wKgJolp_POrRqD_EAJqMUXPofko118.m4a\r\n196 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E6/38/wKgJolp_PZOQklk9AJwaR-iGM3s983.m4a\r\n197 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E6/85/wKgJo1p_PmGwnG7SAJpzXdhhzz4777.m4a\r\n198 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/F2/wKgJnlp_PvuRAXPWAJs-A4EBGfY345.m4a\r\n199 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E6/4D/wKgJolp_P6bxpENfAJqoOHxyj2w634.m4a\r\n200 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E6/9A/wKgJo1p_QBrCV3TbAJtJvyek5CA098.m4a\r\n201 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/B1/wKgJnlp_JUOi9bc7AJt-ngqxUR4689.m4a\r\n202 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/41/wKgJo1p_JX2x-zgJAJsGNbpfdog509.m4a\r\n203 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/B9/wKgJnlp_JdSyvWzOAJv0F_QGBXM966.m4a\r\n204 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/0B/wKgJolp_Jk_xY2-SAJwo9hlpgMc104.m4a\r\n205 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/3F/wKgJn1p_JqTQ8h8wAJwUZRQcFtQ126.m4a\r\n206 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E5/58/wKgJo1p_JvzRY__SAJsaw37NGz0853.m4a\r\n207 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E6/D7/wKgJnlp_J1rwaTXpAJusIyhVOH0049.m4a\r\n208 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E6/DB/wKgJnlp_J8PzIhUgAJuTKzlIPVY607.m4a\r\n209 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/69/wKgJo1p_KBziTU4zAJugY50TmLA097.m4a\r\n210 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/E8/wKgJnlp_KHvD6Ek_AJv4ftTFvGk206.m4a\r\n211 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/73/wKgJo1p_KNqyhR0HAJv7bbmaC3w011.m4a\r\n212 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/37/wKgJolp_KUOCYyMLAJvsvqSPS3o173.m4a\r\n213 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/6E/wKgJn1p_KaaTyl4PAJvuORfrXms790.m4a\r\n214 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/42/wKgJolp_KgexMQQwAJpUiE-52F4855.m4a\r\n215 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/4A/wKgJolp_KnXw8FXzAJwKHAbpcjk960.m4a\r\n216 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E5/92/wKgJo1p_KvyguqX2AJqz-C4aWN0579.m4a\r\n217 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/13/wKgJnlp_K1aAlVKZAJue65y4B0Y918.m4a\r\n218 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/A4/wKgJo1p_K72T13DjAJtJv0ZZV5M360.m4a\r\n219 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/61/wKgJolp_LDXSlLRcAJuwih2jLC4393.m4a\r\n220 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/B0/wKgJo1p_LMTBfU2cAJSPR25PL50835.m4a\r\n221 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E5/75/wKgJolp_LXbRff9fAJsDRqDw0dU448.m4a\r\n222 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E6/AD/wKgJn1p_Lh6i5ZPSAJsyQ7Z08iQ200.m4a\r\n223 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/B8/wKgJn1p_Lt_hdJ8pAJyYjsGsUrU455.m4a\r\n224 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/D7/wKgJo1p_L3Pz_5N1AJv_2Pz1JVw573.m4a\r\n225 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/E0/wKgJo1p_MC3gWPhLAJyCiaqFeBU187.m4a\r\n226 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/E9/wKgJo1p_MOHy497PAJthQJU4gWY418.m4a\r\n227 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/AB/wKgJolp_MYCjC_qXAJuyATLESrM648.m4a\r\n228 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E7/69/wKgJnlp_MiSDo3DZAJxrCbaL7Cg425.m4a\r\n229 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E6/E6/wKgJn1p_MtWSPRd3AJuh2kJx8OU858.m4a\r\n230 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E6/0B/wKgJo1p_M3nxY6b2AJvoV6RsEkE701.m4a\r\n231 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/85/wKgJnlp_NDKAf6yhAJuyAQZPAs0494.m4a\r\n232 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/8E/wKgJnlp_NNbQSfz-AJvrRvyvcdc630.m4a\r\n233 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/06/wKgJn1p_NXmyxrJhAJv_2OxULtc623.m4a\r\n234 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E6/27/wKgJo1p_NgfQH_ZaAJslC_kOQRM152.m4a\r\n235 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/11/wKgJn1p_NrPjjmewAJuzff8D2Q4717.m4a\r\n236 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E7/AA/wKgJnlp_N2ehQyofAJywDtxNmh8919.m4a\r\n237 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/B0/wKgJnlp_OAii4T7SAJoeMYhrF3E106.m4a\r\n238 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/26/wKgJn1p_OJfSvnPqAJvrRg46QLI208.m4a\r\n239 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E6/4E/wKgJo1p_OVqDpFPrAJttABomiQY976.m4a\r\n240 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E6/0F/wKgJolp_OgnAK4OAAJuNTf8EyOE827.m4a\r\n241 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/3B/wKgJn1p_OsaghmmtAJvyoNq9GvM603.m4a\r\n242 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E7/D3/wKgJnlp_O3qBBIrXAJub_L25Za8430.m4a\r\n243 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E6/6C/wKgJo1p_PBiDB-HnAJtCavohaSE575.m4a\r\n244 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E6/2F/wKgJolp_PNeiMiSXAJvyoF-nY0Q474.m4a\r\n245 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E7/56/wKgJn1p_PW3CGSMnAJtbYRNR-uQ398.m4a\r\n246 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/EB/wKgJnlp_PgixR-mcAJveD0QE6EQ965.m4a\r\n247 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/61/wKgJn1p_PqihbXm9AJusIwaGrU4536.m4a\r\n248 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/68/wKgJn1p_P1ehRJZxAJwIpZj1v-4255.m4a\r\n249 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E6/4E/wKgJolp_P-Kw__YtAJuvEqMU6oc935.m4a\r\n250 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E6/53/wKgJolp_QI_BZfTWAJtfyOQ9ZpA147.m4a\r\n251 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/27/wKgJn1p_JU_woOpsAJt3RPZYYr4505.m4a\r\n252 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E4/FF/wKgJolp_JYvBy_TjAJvoV_CclH8533.m4a\r\n253 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/BB/wKgJnlp_JeLyytayAJtSkN4HmEE147.m4a\r\n254 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/4D/wKgJo1p_JknDdSYJAJvK-SSzpxE229.m4a\r\n255 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/3F/wKgJn1p_JqXxwwdnAJvPYA_sjvY609.m4a\r\n256 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E5/16/wKgJolp_JwSjvud6AJwP_tq7fVw892.m4a\r\n257 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E6/D7/wKgJnlp_J1rR5OoUAJnNbKYC6AU323.m4a\r\n258 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E6/DB/wKgJnlp_J8Py7FJiAJwRdhtbHR8304.m4a\r\n259 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/27/wKgJolp_KCDi3voGAJtnHlzppAg110.m4a\r\n260 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/6D/wKgJo1p_KKmAQihsAJslC4pBn5E315.m4a\r\n261 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E6/63/wKgJn1p_KQLQKVvXAJtkL8N1lCU957.m4a\r\n262 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/7D/wKgJo1p_KVLzRndJAJoQ-t9zKgk707.m4a\r\n263 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/FD/wKgJnlp_KcWBHle0AJvTyvwR2Dg657.m4a\r\n264 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/03/wKgJnlp_KjzwMA4QAJpOpZm3iJA617.m4a\r\n265 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E6/7A/wKgJn1p_KpyTJyHSAJtitwC1HFM637.m4a\r\n266 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E5/4E/wKgJolp_Kv7BzJ72AJyG7x72Opw266.m4a\r\n267 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/8A/wKgJn1p_K2izOchoAJtud1Lw2nY198.m4a\r\n268 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/8E/wKgJn1p_K-KzZmzvAJnk7N2HZF0847.m4a\r\n269 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E5/66/wKgJolp_LFix9PlOAJwLmKjw3Sg134.m4a\r\n270 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/2B/wKgJnlp_LQuxfjZHAJwCx11xBIU500.m4a\r\n271 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E6/AA/wKgJn1p_LbfSexZnAJtud7u12o4020.m4a\r\n272 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/B3/wKgJn1p_Lm6DidvoAJvbIBhnaR0903.m4a\r\n273 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E5/8D/wKgJolp_L0Oiw-6RAJv7bThXyNI382.m4a\r\n274 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/54/wKgJnlp_L-DRwGBBAJuddKIL3-Q076.m4a\r\n275 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/5B/wKgJnlp_MI2DF6V8AJuh2oh4Elg952.m4a\r\n276 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/A6/wKgJolp_MVCTCpaJAJv0F92IGRY426.m4a\r\n277 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/F8/wKgJo1p_MfOTJ9JYAJvN6ASU5Cs237.m4a\r\n278 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/B7/wKgJolp_MpPRbb0_AJwBT-g-vRQ788.m4a\r\n279 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E6/05/wKgJo1p_MzfQs5qpAJvsvjeSe9Y146.m4a\r\n280 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/F3/wKgJn1p_M8Og_D0qAJvyoPuXTIM064.m4a\r\n281 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/CC/wKgJolp_NGOQJ0dZAJntvTleXgU701.m4a\r\n282 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/D5/wKgJolp_NR2Sn1_FAJvj8Uzqfso996.m4a\r\n283 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/DE/wKgJolp_NefQ34BoAJov0G-tQtE913.m4a\r\n284 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/0F/wKgJn1p_NonSfdmjAJvxKHk1IBI224.m4a\r\n285 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/33/wKgJo1p_NyjSFuEtAJuI55Du9EE266.m4a\r\n286 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/AC/wKgJnlp_N9KQQrGHAJvTyiU1yr0694.m4a\r\n287 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/B5/wKgJnlp_OKPQNUpfAJuddHZpJzo836.m4a\r\n288 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E6/09/wKgJolp_OVeDf8g8AJsQelsLiu4230.m4a\r\n289 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/33/wKgJn1p_OdyS9visAJvhAmCXtEg083.m4a\r\n290 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E6/15/wKgJolp_Onqwv9SHAJsHrfUnAaw483.m4a\r\n291 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/42/wKgJn1p_Ox-j3GVPAJvWuRefe8Q882.m4a\r\n292 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/25/wKgJolp_O8-AypPXAJv3B45YgSY274.m4a\r\n293 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/49/wKgJn1p_PGmRVbspAJtYbhVxQWA857.m4a\r\n294 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E6/34/wKgJolp_PRCxZmKsAJsDRoqTqrw876.m4a\r\n295 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E6/3A/wKgJolp_PbPi0LSJAJu_OU_GbGk968.m4a\r\n296 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E6/83/wKgJo1p_PkSjd0pFAJsjlIyeHfo652.m4a\r\n297 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E6/8D/wKgJo1p_PubAVn6dAJvuORxnC9s343.m4a\r\n298 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E6/91/wKgJo1p_P3aDfzrwAJvMcPwv3gc038.m4a\r\n299 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E6/51/wKgJolp_QAeCdAZoAJvm4A5aFm0601.m4a\r\n300 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E6/9C/wKgJo1p_QKDwQMLOAJuahbiSI04989.m4a\r\n301 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E4/FC/wKgJolp_JW7AeKKSAJveD5dtiLc449.m4a\r\n302 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E6/B5/wKgJnlp_Ja2SL_qKAJrgBgGK3nU570.m4a\r\n303 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/47/wKgJo1p_JhXghNQkAJs8iN5Oj3M743.m4a\r\n304 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/C6/wKgJnlp_JnPw4rHMAJtbYei2mcE817.m4a\r\n305 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E5/54/wKgJo1p_Jtqj90u6AJrgBojnByo158.m4a\r\n306 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/5B/wKgJo1p_J0iQJRc4AJvrRml0LhA198.m4a\r\n307 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/5F/wKgJo1p_J5fxkGlMAJw5HdDebGU738.m4a\r\n308 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/22/wKgJolp_KAKRdYLGAJvZqKrlm2E978.m4a\r\n309 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/59/wKgJn1p_KF_zS4cXAJvFG0CJbuc289.m4a\r\n310 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/2D/wKgJolp_KMHTGq_5AJv4fjdzhR0383.m4a\r\n311 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/79/wKgJo1p_KTOD5S3aAJvrRpfnZg0933.m4a\r\n312 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/6B/wKgJn1p_KY3imumIAJrejo-hmxg521.m4a\r\n313 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/85/wKgJo1p_KgCgC0BVAJvfisAIkqI595.m4a\r\n314 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/46/wKgJolp_Klvhd_acAJsgpS6IFno836.m4a\r\n315 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/0B/wKgJnlp_KsLw9dYPAJv59gnsH1A631.m4a\r\n316 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/97/wKgJo1p_Kyqihs0gAJvfihy0rxQ801.m4a\r\n317 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/5B/wKgJolp_K5yg8mMqAJvj8ZY7gu8397.m4a\r\n318 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/94/wKgJn1p_LAzisxXLAJvICvX5D2o778.m4a\r\n319 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/26/wKgJnlp_LJeDik2GAJveD8ApPNA508.m4a\r\n320 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E6/A5/wKgJn1p_LUTzCzVMAJrutYuVdss267.m4a\r\n321 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/BE/wKgJo1p_LdHSTz02AJoyv0Hskos380.m4a\r\n322 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/CA/wKgJo1p_LprTkOPWAJvYMfh_Rzg568.m4a\r\n323 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/D2/wKgJo1p_L0aT106kAJveDyJmals934.m4a\r\n324 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/97/wKgJolp_MAfAy9_4AJvPYD_VFRo375.m4a\r\n325 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/A0/wKgJolp_MLmRb8xBAJvxKB447fs256.m4a\r\n326 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/A8/wKgJolp_MWCjsKjbAJtJv3CbnyI809.m4a\r\n327 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/F8/wKgJo1p_MgHwHlVaAJvbIBkWVv0426.m4a\r\n328 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E6/00/wKgJo1p_MrXAi4G9AJscOtISVAU194.m4a\r\n329 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E6/09/wKgJo1p_M2XiSjhyAJuvEmKzAC0109.m4a\r\n330 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/CB/wKgJolp_NCnQbDf6AJkqbdcx47U227.m4a\r\n331 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/8C/wKgJnlp_NMThBk2WAJujUgqefAY648.m4a\r\n332 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/05/wKgJn1p_NWih5uBPAJsmgwe_x_k286.m4a\r\n333 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/0C/wKgJn1p_NhnzCoOsAJuF9LC8_rE928.m4a\r\n334 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E7/A1/wKgJnlp_NrTivsYRAJrEH82oDA0012.m4a\r\n335 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/F3/wKgJolp_N3Ojvx0gAJvfihBsxFA481.m4a\r\n336 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/FC/wKgJolp_OD2BeFG2AJuBjbfpnw4880.m4a\r\n337 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E6/47/wKgJo1p_OOGxvs0IAJvm4K8BYM4137.m4a\r\n338 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/BC/wKgJnlp_OZGzZAscAJvN6KlMYPQ720.m4a\r\n339 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/38/wKgJn1p_OmHj879GAJvfillMpnc790.m4a\r\n340 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/CD/wKgJnlp_OunQcpiMAJslC_F9gds412.m4a\r\n341 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E7/45/wKgJn1p_O57BkmKBAJrSzrYcFqg786.m4a\r\n342 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E6/2B/wKgJolp_PDDj5pwRAJvm4BLkVv0420.m4a\r\n343 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E6/2F/wKgJolp_PNvQslTSAJvrRp5p6U8605.m4a\r\n344 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E7/E6/wKgJnlp_PXHSmbTGAJvbIBm64Xg088.m4a\r\n345 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/5C/wKgJn1p_PhijTwceAJtJv4uA9ow561.m4a\r\n346 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E6/8B/wKgJo1p_PseCWgNBAJsEvlo3BIQ237.m4a\r\n347 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E6/91/wKgJo1p_P3uiU1JDAJvZqM3egB0399.m4a\r\n348 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/FE/wKgJnlp_QEGgzuD7AJoimD69EOY404.m4a\r\n349 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E6/A0/wKgJo1p_QNKh75BvAJu9wVrflFE081.m4a\r\n350 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/5D/wKgJolp_QT2z8tk7AJvfiilHt4U030.m4a\r\n351 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E4/FE/wKgJolp_JX-CWsc7AJw3pQKthd4880.m4a\r\n352 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/BB/wKgJnlp_Jd7j2hEpAJwLmFgiJHA140.m4a\r\n353 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/4B/wKgJo1p_JjyxpCKBAJwBT6dWjPo909.m4a\r\n354 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/CC/wKgJnlp_Jq6jGWPyAJvAsFxua8Y647.m4a\r\n355 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/D0/wKgJnlp_JxzTbUmNAJtxZt8ZHKk898.m4a\r\n356 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/5D/wKgJo1p_J4qAkHEYAJsfKf4Dsis460.m4a\r\n357 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E6/53/wKgJn1p_J-nwxvFOAJvieQgMeJs768.m4a\r\n358 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/58/wKgJn1p_KFOSnWHIAJvK-anAR4Q162.m4a\r\n359 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/2D/wKgJolp_KMLzE5MHAJsn-iry0ik839.m4a\r\n360 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/78/wKgJo1p_KSyDBPj4AJv1j62hpY0854.m4a\r\n361 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/F8/wKgJnlp_KZjxLAYZAJub_HUxZWA604.m4a\r\n362 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/42/wKgJolp_KgeyXISFAJthQFgLCts625.m4a\r\n363 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/47/wKgJolp_KmCzON0jAJuh2jLgjqQ862.m4a\r\n364 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E6/80/wKgJn1p_Ks2A-8PrAJtv7745_rk430.m4a\r\n365 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E5/56/wKgJolp_Kzyilf9sAJugY7GRZHQ056.m4a\r\n366 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/A0/wKgJo1p_K6bTjIg2AJv4ftPkrFw779.m4a\r\n367 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/93/wKgJn1p_LAWhpP9LAJvieQLpPe8345.m4a\r\n368 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E6/96/wKgJn1p_LHKQjAzaAJvbIP05EvQ600.m4a\r\n369 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/2C/wKgJnlp_LRjhR_4VAJuRtLO9Nek716.m4a\r\n370 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/7B/wKgJolp_Ld_DCUq6AJtOKluiM9o698.m4a\r\n371 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E5/85/wKgJolp_LpiDZ3ARAJs_e9f-2sg475.m4a\r\n372 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/4B/wKgJnlp_LzOy8v9RAJvxKHgbSok791.m4a\r\n373 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E6/C5/wKgJn1p_L8ahyg8DAJs1MnWtgzI075.m4a\r\n374 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/59/wKgJnlp_MHfgZIBfAJtnHkTCPBU987.m4a\r\n375 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/64/wKgJnlp_MUSQNrKkAJs_e3G93aQ487.m4a\r\n376 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/F8/wKgJo1p_MfTBts_dAJvPYGg94Ks721.m4a\r\n377 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/B7/wKgJolp_MpvThw3wAJq1cDBBubI943.m4a\r\n378 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/C0/wKgJolp_M0HDJ42-AJt3RIfEdwc148.m4a\r\n379 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/83/wKgJnlp_M9HytFXDAJvICpMcNU8573.m4a\r\n380 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E6/FA/wKgJn1p_NLCjoOtZAJv4fsyW7VQ702.m4a\r\n381 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E5/D9/wKgJolp_NUrwcDjLAJvZqNM1Qf0400.m4a\r\n382 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/DD/wKgJolp_NeGgN8KNAJrxpNEAUbc835.m4a\r\n383 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/9F/wKgJnlp_NpiiOWwtAJt0VWEiMWE971.m4a\r\n384 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/34/wKgJo1p_Ny6hSibIAJwjFE7ma_Q078.m4a\r\n385 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/1C/wKgJn1p_N8OjNGjIAJvoV9U4Thw593.m4a\r\n386 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/B2/wKgJnlp_OHSjB8m5AJwFtmx2lOE991.m4a\r\n387 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E6/4B/wKgJo1p_ORTSEg2IAJt9JusK8O4187.m4a\r\n388 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/C2/wKgJnlp_OdOi90kOAJpXd__cDRU584.m4a\r\n389 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E6/5C/wKgJo1p_OonhsBFNAJszurnVpwo028.m4a\r\n390 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E6/1E/wKgJolp_O1OiXC9vAJqoOCD4zr4089.m4a\r\n391 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/D8/wKgJnlp_PAeibfwYAJu09FKEAS0169.m4a\r\n392 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/4D/wKgJn1p_PJvBOUz2AJvhAtQztuE367.m4a\r\n393 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/54/wKgJn1p_PTmxAw_MAJvfioxyUrw488.m4a\r\n394 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/E9/wKgJnlp_PeqAtKABAJvrRoswI7c508.m4a\r\n395 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E6/40/wKgJolp_PmnjHKmrAJu_Oc602Jo090.m4a\r\n396 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/62/wKgJn1p_PvzShDgaAJumRSUJHK8688.m4a\r\n397 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E6/4D/wKgJolp_P6bTXvnTAJvYMc8L0HY566.m4a\r\n398 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/6C/wKgJn1p_QCXBSZ-hAJt6N8uWIq4444.m4a\r\n399 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E6/55/wKgJolp_QKmRy8BxAJvlaECMQ2Q175.m4a\r\n400 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/5C/wKgJolp_QSqTu2-qAJnqyjiZ1Do200.m4a\r\n401 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/46/wKgJo1p_JaCyBRPbAJo6GMHGL30635.m4a\r\n402 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/BE/wKgJnlp_JfKAVfmnAJoimHSF1lg554.m4a\r\n403 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/38/wKgJn1p_JmWSx-hUAJvTyhG-VkE040.m4a\r\n404 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/52/wKgJo1p_Js_y06XGAJvJgeXnRis122.m4a\r\n405 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/17/wKgJolp_J0bhDraBAJv4fuz5hPY311.m4a\r\n406 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/60/wKgJo1p_J6WikuVIAJuBjZOsd4I907.m4a\r\n407 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/27/wKgJolp_KCKCSKwIAJviedxfiIs815.m4a\r\n408 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/EB/wKgJnlp_KI6Ds8-gAJvm4B1BVXU403.m4a\r\n409 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/75/wKgJo1p_KOWBAS4bAJsX1DugH-A965.m4a\r\n410 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/7C/wKgJo1p_KUuT4NQSAJvxKMdfn7M842.m4a\r\n411 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/6D/wKgJn1p_KaGDmmSIAJnh_SUhQDE793.m4a\r\n412 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/40/wKgJolp_KfbxhgX0AJr4_qmXJIA941.m4a\r\n413 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/8D/wKgJo1p_KmfSGStpAJtUCM11WNg407.m4a\r\n414 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E6/81/wKgJn1p_KtbgWG2wAJuI58cIXFE622.m4a\r\n415 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/9B/wKgJo1p_K0PTtruXAJk5HFzgEsg354.m4a\r\n416 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/A1/wKgJo1p_K63TcaGrAJvWuXBGIkA319.m4a\r\n417 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/94/wKgJn1p_LA3hIwNpAJvGkmQk8Vw513.m4a\r\n418 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E6/9B/wKgJn1p_LJzgeeb9AJuOxfw8bdY322.m4a\r\n419 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E5/B5/wKgJo1p_LVSR7x1eAJnJBRNsCCk802.m4a\r\n420 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/C1/wKgJo1p_LeyzY77TAJoScRROD40936.m4a\r\n421 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E5/85/wKgJolp_Lpby6A4WAJtA8pZ0jgs724.m4a\r\n422 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E5/D1/wKgJo1p_LzmjCL1UAJuzfVvHjo0532.m4a\r\n423 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/54/wKgJnlp_L-DBxvGmAJuddBFSORw285.m4a\r\n424 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/CE/wKgJn1p_MIqB5d67AJnDJ-B_Aig287.m4a\r\n425 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/63/wKgJnlp_MULQWZlmAJrgBl6mI_I339.m4a\r\n426 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/F6/wKgJo1p_MeTyn5keAJv4ftb9tHQ221.m4a\r\n427 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/B6/wKgJolp_Moij7dadAJxt-KrZQbI771.m4a\r\n428 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E6/EB/wKgJn1p_Mx_iuc1CAJu_OYG__s0076.m4a\r\n429 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/F2/wKgJn1p_M7-BnYGyAJmSr1ONlco314.m4a\r\n430 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/8A/wKgJnlp_NFuh7MfYAJsDRuND7mc086.m4a\r\n431 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/04/wKgJn1p_NQ6zz8jdAJvMcDcVbdI670.m4a\r\n432 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/98/wKgJnlp_NZ7BOH4IAJuBjS_Pmos298.m4a\r\n433 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/E6/wKgJolp_Nm_y30kQAJyG7zTjLLA853.m4a\r\n434 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/31/wKgJo1p_NxDjIK13AJm172OCcYc773.m4a\r\n435 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/F7/wKgJolp_N6_D_urJAJvieQCjQ_I171.m4a\r\n436 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E6/41/wKgJo1p_OEigeJYMAJuKXnBjuEU225.m4a\r\n437 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E6/04/wKgJolp_OPej06rgAJuL1rfWavQ045.m4a\r\n438 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/2E/wKgJn1p_OajClRklAJt0VV4f_Mk925.m4a\r\n439 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/C6/wKgJnlp_OlLAtaCCAJrl6A2BrYw034.m4a\r\n440 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/3E/wKgJn1p_OvShSEytAJrnX1-3U1U427.m4a\r\n441 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E6/67/wKgJo1p_O6qAZmc3AJsNi9MBAtY242.m4a\r\n442 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E6/71/wKgJo1p_PFSjq-GPAJuQPDgp3so335.m4a\r\n443 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E6/33/wKgJolp_PQTASq1gAJujUldwO5Y974.m4a\r\n444 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E6/37/wKgJolp_PZDjFO-ZAJuzfdcdqyo865.m4a\r\n445 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/ED/wKgJnlp_PjLR40bsAJuI59A2QL0149.m4a\r\n446 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E6/8D/wKgJo1p_PufhgsNlAJqNzf5JJuI166.m4a\r\n447 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E6/90/wKgJo1p_P2qhxgmTAJtD4QdLOGc072.m4a\r\n448 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/FC/wKgJnlp_QC2zKGljAJsTbU27t9I620.m4a\r\n449 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E6/9B/wKgJo1p_QJzSZkaaAJtCaoSVx7k863.m4a\r\n450 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/5B/wKgJolp_QRjCTFGiAJsX1GHp24Q443.m4a\r\n451 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E6/2B/wKgJn1p_JbrwazoPAJlfTOVX4aU750.m4a\r\n452 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/07/wKgJolp_JjKx46xlAJfhgZ40V38024.m4a\r\n453 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/3E/wKgJn1p_JprhRsnVAJq1cMxe0L0090.m4a\r\n454 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/CF/wKgJnlp_JxHyzxwlAJoQ-h0JSDU565.m4a\r\n455 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/5C/wKgJo1p_J3_jU2WmAJlplO7dzvY241.m4a\r\n456 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/64/wKgJo1p_J_SjcHjAAJrSzsEPgXo980.m4a\r\n457 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/E2/wKgJnlp_KEvDoZyDAJlmoVkVZjs927.m4a\r\n458 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/70/wKgJo1p_KMLzGWSFAJrOaCsgTRM883.m4a\r\n459 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E6/66/wKgJn1p_KRay3DTVAJs4Ies0ajs350.m4a\r\n460 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/F5/wKgJnlp_KXuxVjElAJnzm-h_cxQ171.m4a\r\n461 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/82/wKgJo1p_KejxWY8HAJoQ-o_PyKE177.m4a\r\n462 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E5/8A/wKgJo1p_Kk3SoXrOAJpHUPy-OgM876.m4a\r\n463 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E7/07/wKgJnlp_KqqBFoXQAJsHrYSpGrU424.m4a\r\n464 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/95/wKgJo1p_KxTwnuAOAJi9xUPC0sI238.m4a\r\n465 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/14/wKgJnlp_K2fSpmz6AJsME8qx63Q845.m4a\r\n466 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/8D/wKgJn1p_K8_ToOnSAJuKXqGNUF8318.m4a\r\n467 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E5/64/wKgJolp_LEmQeipTAJmRN8LM0do665.m4a\r\n468 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/71/wKgJolp_LOjDyk-cAJolhzXQqic076.m4a\r\n469 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E5/BB/wKgJo1p_LYqhj1N4AJjqBvgYRjQ421.m4a\r\n470 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/39/wKgJnlp_LimgmuibAJtSkEw2wB4222.m4a\r\n471 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E7/43/wKgJnlp_LuGgwpt6AJsiTlPtTgk779.m4a\r\n472 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E6/C0/wKgJn1p_L4mwMczHAJpu801Hf1A914.m4a\r\n473 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/55/wKgJnlp_MDfwqAj6AJooes8SL2g131.m4a\r\n474 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/A5/wKgJolp_MOCiZjAKAJraKJSZdSQ964.m4a\r\n475 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/F1/wKgJo1p_MY3RShe-AJpkru_GQR4680.m4a\r\n476 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E6/E2/wKgJn1p_MmGiZ_BLAJmSr0gSmIs268.m4a\r\n477 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E6/EA/wKgJn1p_MxKBFBVkAJkxx4EV5Y8874.m4a\r\n478 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/82/wKgJnlp_M8ihs4pwAJsME5-v498965.m4a\r\n479 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/CC/wKgJolp_NGCDSeXSAJqbACRltuc807.m4a\r\n480 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/93/wKgJnlp_NQmhNqyfAJuqrE71-Js551.m4a\r\n481 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/DC/wKgJolp_NdXzRR3QAJtriP1eQD4556.m4a\r\n482 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E6/2C/wKgJo1p_NnTQ39JEAJuBjU70gtE290.m4a\r\n483 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/31/wKgJo1p_NxiBT8CZAJp6s1ItX9g472.m4a\r\n484 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/F6/wKgJolp_N6GwyM49AJqpsJL4HQ4320.m4a\r\n485 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E6/41/wKgJo1p_OELwDU-hAJs2qpiywR0299.m4a\r\n486 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E6/01/wKgJolp_ONOz1y-AAJl4RNEZdsU844.m4a\r\n487 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E6/4F/wKgJo1p_OXDwALGUAJmnQN5ROqo181.m4a\r\n488 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E6/13/wKgJolp_OkKDVlNGAJub_ERxeKc680.m4a\r\n489 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/3D/wKgJn1p_Ot_Tab4gAJmc-KTBj6I539.m4a\r\n490 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E7/D4/wKgJnlp_O4uDrRRmAJl4RDrT_Uo498.m4a\r\n491 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E6/28/wKgJolp_PBqiUaymAJpBbp3Tu-I432.m4a\r\n492 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/E0/wKgJnlp_PMXxy4kiAJpRlRoAjQ8500.m4a\r\n493 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E7/55/wKgJn1p_PWSy7baIAJkKICtJ0i8054.m4a\r\n494 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E6/80/wKgJo1p_PfyCY7I2AJqVIvAnAv4668.m4a\r\n495 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/60/wKgJn1p_PpCSg0X3AJmnQP5xAmQ284.m4a\r\n496 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/66/wKgJn1p_PzWS5YPuAJt9Jn3oJHo442.m4a\r\n497 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E6/97/wKgJo1p_P-zBIxaGAJqGc8jneO8676.m4a\r\n498 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E6/9C/wKgJo1p_QKrwhI-NAJo4oWq-B4Q610.m4a\r\n499 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/5B/wKgJolp_QRihmhEoAJpUiMVi83A106.m4a\r\n500 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/7A/wKgJn1p_QW_zg0ptAJr4_qMOJfw605.m4a\r\n501 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/2F/wKgJn1p_Jd3Bfjc-AJov4LDO9dI061.m4a\r\n502 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/0C/wKgJolp_JlWyH7pAAJnUxRyo_pI026.m4a\r\n503 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/CD/wKgJnlp_JrqA95DCAJtjAlZNtyo463.m4a\r\n504 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/44/wKgJn1p_JxmABmimAJqH6-X5npA568.m4a\r\n505 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/5C/wKgJo1p_J4SgJ6VPAJk5HNUwxG8262.m4a\r\n506 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E6/53/wKgJn1p_J-bgHdKdAJq7Urgn6fQ002.m4a\r\n507 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/56/wKgJn1p_KEODUfhiAJqK2pmkjFY564.m4a\r\n508 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/60/wKgJn1p_KJvyTsbuAJppFRtfn5k738.m4a\r\n509 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E6/F0/wKgJnlp_KQfwuVBLAJsR9uXWjiE411.m4a\r\n510 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/6B/wKgJn1p_KYmB_LJAAJthQBGdWf8931.m4a\r\n511 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/83/wKgJo1p_KezSx9m7AJpb3UW0dQE347.m4a\r\n512 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/8B/wKgJo1p_KlvSDHNjAJqd9BE_iRc019.m4a\r\n513 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E6/7D/wKgJn1p_Kq-jR01gAJmFeyTiQHw707.m4a\r\n514 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/94/wKgJo1p_Kwrx_KIoAJllKidhzVY040.m4a\r\n515 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/8B/wKgJn1p_K3DyU09uAJsGNaUzgDY225.m4a\r\n516 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/18/wKgJnlp_K8qgT6pjAJlTjK9ohus658.m4a\r\n517 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/A8/wKgJo1p_LErQPxFoAJq52vrIG-4958.m4a\r\n518 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E6/9C/wKgJn1p_LOuChDfQAJqTq2AN4rI919.m4a\r\n519 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E5/BC/wKgJo1p_LY7TEAahAJs7EDpMWmI207.m4a\r\n520 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E6/B0/wKgJn1p_LjzAJfh9AJo6GHKsb74630.m4a\r\n521 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/B9/wKgJn1p_LuySjzzLAJohIC_ifNw141.m4a\r\n522 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E7/4E/wKgJnlp_L6CRU5icAJvDo3o-1JM061.m4a\r\n523 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/57/wKgJnlp_ME-Tp82oAJppFeLBEls470.m4a\r\n524 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/5E/wKgJnlp_MPTz4BOYAJtPoe3A73E609.m4a\r\n525 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/66/wKgJnlp_MavjsIiwAJtc2QrT8WA810.m4a\r\n526 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/6F/wKgJnlp_MkmzIB8KAJsWXESl8XE780.m4a\r\n527 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/78/wKgJnlp_Mwuy8ayzAJs5mQqCggk340.m4a\r\n528 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/F1/wKgJn1p_M6-zxjTyAJjK_CjOjE4233.m4a\r\n529 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/F9/wKgJn1p_NFWARvrSAJvrRs-HSDs973.m4a\r\n530 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/D4/wKgJolp_NROj_N8RAJsR9kWP5fY513.m4a\r\n531 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/0A/wKgJn1p_NbGwC9rMAJqYEV82pnU687.m4a\r\n532 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E6/2C/wKgJo1p_NnjiXkZvAJmulrLr8TI845.m4a\r\n533 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/32/wKgJo1p_NyWhDzKkAJmtHjUA1bA147.m4a\r\n534 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/1C/wKgJn1p_N8bQvlsaAJm7zn5Nk84929.m4a\r\n535 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/22/wKgJn1p_OG2jwj4dAJqH6y2jDBw248.m4a\r\n536 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/29/wKgJn1p_ORqB1558AJyqLLwKi1I702.m4a\r\n537 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/31/wKgJn1p_OcSR8Ou-AJpkrj_NvXE611.m4a\r\n538 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/C7/wKgJnlp_OlzxPHM7AJuEfIGltzE564.m4a\r\n539 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/40/wKgJn1p_Ow_j53zhAJrOaI4tsUc648.m4a\r\n540 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/24/wKgJolp_O8CDJsiuAJqWmgywV0I043.m4a\r\n541 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/DA/wKgJnlp_PGahhz7GAJunvDi12gY213.m4a\r\n542 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/52/wKgJn1p_PR_w5oi3AJwBT8u3ZW8500.m4a\r\n543 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/58/wKgJn1p_PdmDb4xFAJpb3aiIcAs068.m4a\r\n544 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/EF/wKgJnlp_PorB5UrAAJsiHPxLfdI718.m4a\r\n545 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/F4/wKgJnlp_PxmRJ_H3AJsU5bMaE-o821.m4a\r\n546 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/68/wKgJn1p_P6vgOEQ-AJvuOXYt9JU736.m4a\r\n547 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/6E/wKgJn1p_QD3jniiWAJsAU-RG_AQ236.m4a\r\n548 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/76/wKgJn1p_QOeBCX2uAJu2bC-YfIc410.m4a\r\n549 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/7A/wKgJn1p_QW6hUCC9AJuh2mm1vp0581.m4a\r\n550 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E8/0C/wKgJnlp_QZCBxEB0AJtG0LPqp98376.m4a\r\n551 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/32/wKgJn1p_JfHhiUimAJttACLvlUc293.m4a\r\n552 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/0B/wKgJolp_JlHiuiqNAJvrRlkJk7w755.m4a\r\n553 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/40/wKgJn1p_JrTjqKL4AJu2bPBCBh0838.m4a\r\n554 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/45/wKgJn1p_JyigBwVHAJnfDpIC8pI777.m4a\r\n555 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/5D/wKgJo1p_J43BlsVBAJhIS6_EdlE929.m4a\r\n556 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/22/wKgJolp_J_rQCVbSAJoLHAb6mGg611.m4a\r\n557 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/E5/wKgJnlp_KF7gcIxSAJoYUxq8SDI742.m4a\r\n558 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/2D/wKgJolp_KLvAGxtjAJtVf3iyuOI200.m4a\r\n559 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/77/wKgJo1p_KSLyDEV1AJs8iINb1to586.m4a\r\n560 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/6B/wKgJn1p_KY6wog5rAJs8iDE45Gc402.m4a\r\n561 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/41/wKgJolp_Kfyiv2q-AJrejgkJMuk213.m4a\r\n562 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/48/wKgJolp_KmfyOTwKAJqZiRXfBLI343.m4a\r\n563 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/0C/wKgJnlp_KsqCqIWNAJl-Iu7dLH4885.m4a\r\n564 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E5/55/wKgJolp_KzKj3rhQAJnjdXPJj44113.m4a\r\n565 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/5B/wKgJolp_K5ix1QU1AJvvsSXtXhk539.m4a\r\n566 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/93/wKgJn1p_LAnzGDuTAJtit23S-_Q999.m4a\r\n567 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E6/9B/wKgJn1p_LJ6QokajAJv86ZbXHiU108.m4a\r\n568 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E6/A5/wKgJn1p_LUniUoeFAJv59pLlB1s008.m4a\r\n569 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/C0/wKgJo1p_LeWwdaWrAJub_P7pk3Q322.m4a\r\n570 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E5/85/wKgJolp_LpLBsaAIAJnWPRruxWA451.m4a\r\n571 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/4B/wKgJnlp_LzKRhLclAJqg44Oh4_Y910.m4a\r\n572 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/54/wKgJnlp_L97RxriWAJsyQ_Jv9u0631.m4a\r\n573 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/CE/wKgJn1p_MIqxyJ7uAJs_e62MUas823.m4a\r\n574 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/EB/wKgJo1p_MVHgndOkAJvrRnJT9YQ879.m4a\r\n575 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/F8/wKgJo1p_MfOxGJFAAJsR9phLEDE281.m4a\r\n576 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/B7/wKgJolp_MpSS1rfCAJvsvglYYpY781.m4a\r\n577 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E6/04/wKgJo1p_MzOhrw0kAJpte0wreZY532.m4a\r\n578 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E6/0B/wKgJo1p_M-bipt7FAJtolR9mia8533.m4a\r\n579 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E6/FA/wKgJn1p_NKuwVCuuAJt3RKno4hY556.m4a\r\n580 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/94/wKgJnlp_NWOhmjvcAJswy8oD40w144.m4a\r\n581 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/E0/wKgJolp_Nf_zA7POAJoJpHw1dnE278.m4a\r\n582 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/A0/wKgJnlp_NqWwmAOgAJpzXQteSQ4962.m4a\r\n583 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E7/A8/wKgJnlp_N0eTD5YLAJpb3TKeBZc394.m4a\r\n584 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/AE/wKgJnlp_N_HCnbHLAJu346HdaD4783.m4a\r\n585 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E6/00/wKgJolp_OJugQqJ1AJq8yUKV89E539.m4a\r\n586 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E6/09/wKgJolp_OVfCG0PlAJst2OC93KA449.m4a\r\n587 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/54/wKgJo1p_OgWyJDu-AJsfKXHc-uY404.m4a\r\n588 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/3B/wKgJn1p_OsPgdB58AJtxZrPKzik607.m4a\r\n589 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E6/64/wKgJo1p_O1SzpZsQAJu8SmbJ5eg610.m4a\r\n590 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/D9/wKgJnlp_PA-hE6fuAJrbn0HJv-c717.m4a\r\n591 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/DF/wKgJnlp_PKnwTeFBAJpV_7_ygIs718.m4a\r\n592 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E7/E4/wKgJnlp_PVzCDGomAJsWXEZW3Nc388.m4a\r\n593 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E6/3B/wKgJolp_PgDjCFOTAJsq6TlW10E155.m4a\r\n594 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/F0/wKgJnlp_PpuCQn2_AJqd9ILF-RU459.m4a\r\n595 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/67/wKgJn1p_P0iyU2UqAJsU5XBu5tE221.m4a\r\n596 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E6/97/wKgJo1p_P_TAeXglAJuL1mBVMps215.m4a\r\n597 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E6/54/wKgJolp_QJ2yceYIAJsAU_9s2_M781.m4a\r\n598 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/A1/wKgJo1p_QRWgMBl6AJuahWlCwT8490.m4a\r\n599 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E8/0A/wKgJnlp_QW7QsqwbAJs_e5lO1Zc117.m4a\r\n600 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E8/0C/wKgJnlp_QZSgp_jeAJuh2sR0nio224.m4a\r\n601 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/C1/wKgJnlp_JgeymAxRAJuZDdsMGeg895.m4a\r\n602 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/C6/wKgJnlp_Jnfgj6nWAJwBT8jKkK8028.m4a\r\n603 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E5/10/wKgJolp_JtPQeLaOAJtUCEPJlsU684.m4a\r\n604 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/48/wKgJn1p_Jz7zmnzsAJq1cJKYD4I302.m4a\r\n605 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/1F/wKgJolp_J7PB_IBaAJrkbG-D148141.m4a\r\n606 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/68/wKgJo1p_KBfSTt63AJsR9jMFEvM646.m4a\r\n607 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/5E/wKgJn1p_KIjisQApAJu342n_sjY708.m4a\r\n608 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E6/EE/wKgJnlp_KPfzpQGOAJvFG1tD-AY236.m4a\r\n609 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/39/wKgJolp_KU7Q6yFbAJukzWlPD3c088.m4a\r\n610 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/FA/wKgJnlp_Kanw-wzIAJsiHBSSVF4019.m4a\r\n611 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/87/wKgJo1p_Kg7BsTBkAJuL1qBRg2I900.m4a\r\n612 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/4B/wKgJolp_KnyjxQw1AJvfilnh-4I857.m4a\r\n613 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E6/86/wKgJn1p_KvvBs6RgAJuF9Lj4YkE184.m4a\r\n614 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/57/wKgJolp_K3nTQ1WlAJsvVPxsbGc381.m4a\r\n615 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/90/wKgJn1p_K-rymoOfAJvVQrYjSXM915.m4a\r\n616 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E5/67/wKgJolp_LF7wG0eNAJuUo0N7QRg302.m4a\r\n617 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/29/wKgJnlp_LP-R5UGyAJvTyohPtd4043.m4a\r\n618 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/35/wKgJnlp_LbfQD1L7AJuTK88gUsI271.m4a\r\n619 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/B3/wKgJn1p_LmqzxhuZAJv3B9ZCGVw470.m4a\r\n620 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/49/wKgJnlp_LxPgQRUbAJrLeTAYyJU269.m4a\r\n621 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/D9/wKgJo1p_L7XTdEpMAJsmg7AAkms672.m4a\r\n622 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/9E/wKgJolp_MG2Byur6AJwqbjfuJ4s385.m4a\r\n623 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/5C/wKgJnlp_MOyAZMirAJvSUyPGg6g639.m4a\r\n624 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/AC/wKgJolp_MZCgoK5zAJub_P5kUNI214.m4a\r\n625 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/70/wKgJnlp_MlaghkXrAJqH62UZYIs248.m4a\r\n626 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E5/BD/wKgJolp_MwHiAah5AJvZqPuYU1c145.m4a\r\n627 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/F0/wKgJn1p_M6vDsq01AJslCzrlRao044.m4a\r\n628 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/85/wKgJnlp_NDKzlHLbAJuBjesjP7Y417.m4a\r\n629 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E6/FE/wKgJn1p_NNWDLlApAJrBMGEEi0I938.m4a\r\n630 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/07/wKgJn1p_NYKyw9RdAJuZDQFurGw241.m4a\r\n631 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/E3/wKgJolp_NkKw5Na5AJwND2v1wXw377.m4a\r\n632 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/EB/wKgJolp_NvjSBYp7AJsR9lU9SVk831.m4a\r\n633 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/F7/wKgJolp_N6nTW1WjAJvclzXW0zI435.m4a\r\n634 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/FD/wKgJolp_OETxMXEeAJuddJxIG-k443.m4a\r\n635 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E6/49/wKgJo1p_OPXgzf0uAJv-YN4Yycg117.m4a\r\n636 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/BD/wKgJnlp_OZugXPHAAJx4QOU3Vwo487.m4a\r\n637 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E6/58/wKgJo1p_OjHAOUNOAJssYWkR4-s366.m4a\r\n638 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/3C/wKgJn1p_Otijw3XSAJt-nrZaJ1w396.m4a\r\n639 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E7/44/wKgJn1p_O4bx5e1MAJtRGbd0TXc906.m4a\r\n640 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/D8/wKgJnlp_PA6zkyRkAJr4_utPxh4338.m4a\r\n641 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/4C/wKgJn1p_PJaTJ2TAAJvZqMDE7mg802.m4a\r\n642 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/E3/wKgJnlp_PTWhV2xKAJyUJzHyGG4467.m4a\r\n643 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/E7/wKgJnlp_PdCDbu-bAJtA8pPWXbI654.m4a\r\n644 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E6/87/wKgJo1p_PnqyBiUlAJveD48OZx8174.m4a\r\n645 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/63/wKgJn1p_Pw7AMAdhAJt7r8TUm6M406.m4a\r\n646 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E6/94/wKgJo1p_P6SQtEYuAJvrRva47ws957.m4a\r\n647 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/6D/wKgJn1p_QC_zWq7eAJtkLyGu9xw964.m4a\r\n648 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E6/58/wKgJolp_QMngte9AAJvMcIHkRdY067.m4a\r\n649 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/5C/wKgJolp_QTvzp9WVAJtA8tD7wgY158.m4a\r\n650 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E6/5E/wKgJolp_QYWQeoJXAJg1NYCZ1JE907.m4a\r\n651 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/04/wKgJolp_JhyyyCA_AJu34_-fLq8261.m4a\r\n652 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/C5/wKgJnlp_Jm_AWiesAJsZS5hqzVs163.m4a\r\n653 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/51/wKgJo1p_JsaToDOrAJyi1s47yuI063.m4a\r\n654 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/44/wKgJn1p_JxyAiu-ZAJuKXkEbato283.m4a\r\n655 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/5D/wKgJo1p_J42QsDycAJt7r84xB2c282.m4a\r\n656 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/64/wKgJo1p_J_zB5GkLAJvlaBKJjVw872.m4a\r\n657 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/57/wKgJn1p_KE-wD9dqAJtFWRyJQHs964.m4a\r\n658 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/71/wKgJo1p_KMvx9WvPAJtbYTcQ4aU858.m4a\r\n659 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/79/wKgJo1p_KTSR0-FrAJu_OTh2NgU585.m4a\r\n660 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/6B/wKgJn1p_KYzDpzMgAJtbYcO8p5g362.m4a\r\n661 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/40/wKgJolp_KfKRSQNkAJu5W3TRIAk923.m4a\r\n662 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E5/8A/wKgJo1p_Kk_xWqI_AJvvsegUiFg592.m4a\r\n663 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E6/7D/wKgJn1p_KrbSYl1lAJtD4QxkvZY054.m4a\r\n664 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E5/50/wKgJolp_KxLAe2sNAJvbIKcRm24776.m4a\r\n665 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/9C/wKgJo1p_K3qhA3xGAJyotK9aYcs666.m4a\r\n666 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/8B/wKgJn1p_K7-zrDUfAJtc2eYBE_o556.m4a\r\n667 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E5/62/wKgJolp_LD2hunKHAJvsvj_GPtA099.m4a\r\n668 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/6D/wKgJolp_LMGQsTu5AJvxKDLMViU874.m4a\r\n669 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E5/B7/wKgJo1p_LWmw9M8lAJtc2X58rOk661.m4a\r\n670 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/C6/wKgJo1p_LhXjo1iWAJue65amPfQ187.m4a\r\n671 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M03/E6/B6/wKgJn1p_LtOhlzXWAJri9Y-Utzo838.m4a\r\n672 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/D8/wKgJo1p_L3yhZ7CBAJrEH1JHWg4518.m4a\r\n673 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/E0/wKgJo1p_MDCBOChdAJszuqYG2VY988.m4a\r\n674 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/E6/wKgJo1p_MMzTSU6ZAJtv73jl4eo930.m4a\r\n675 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/EC/wKgJo1p_MVeSOj3iAJsNi8tIfqc517.m4a\r\n676 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/B0/wKgJolp_MeGAjJF3AJvrRtP2kpo481.m4a\r\n677 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E6/E4/wKgJn1p_Mnqg60YBAJuUo_vf2mM372.m4a\r\n678 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/79/wKgJnlp_MxayGU1LAJty3kP9nHc905.m4a\r\n679 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/83/wKgJnlp_M8mRpSg4AJv3B_PzSZ0995.m4a\r\n680 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E6/14/wKgJo1p_NH2AbX0XAJtkL9XqU7U189.m4a\r\n681 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E5/D8/wKgJolp_NUDCGHe-AJtkL_VQvEc788.m4a\r\n682 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/DE/wKgJolp_NeXBc_i6AJtv7zP1toM017.m4a\r\n683 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/9F/wKgJnlp_NozTorDaAJu34yM4eTs268.m4a\r\n684 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/32/wKgJo1p_Nx-QewanAJue63zKHcQ614.m4a\r\n685 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/1D/wKgJn1p_N9SBwEioAJvxKL6c7Ak965.m4a\r\n686 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/B4/wKgJnlp_OJDyIrjoAJtJv1VBUiA969.m4a\r\n687 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E7/2B/wKgJn1p_OTzz70JaAJtISCHto8A215.m4a\r\n688 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E7/34/wKgJn1p_OenT22zYAJuzfZ2UnHM297.m4a\r\n689 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E6/5C/wKgJo1p_OomSWzJGAJujUnFNSTg928.m4a\r\n690 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/61/wKgJo1p_OzPj8ybRAJr2DxM08K8365.m4a\r\n691 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/D8/wKgJnlp_PAOiUsP9AJvbIP0AGbo603.m4a\r\n692 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/DF/wKgJnlp_PKXg3Ca0AJst2Asfwfk325.m4a\r\n693 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E7/53/wKgJn1p_PSqxC6E4AJvQ24jcXAg350.m4a\r\n694 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E6/7F/wKgJo1p_PcDQb-CpAJkqbaBCU_w338.m4a\r\n695 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E6/40/wKgJolp_PmmiRQvSAJoW2KKnP8o351.m4a\r\n696 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E7/F3/wKgJnlp_Pwew8bInAJwaR6WvvtE717.m4a\r\n697 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/68/wKgJn1p_P6zChny5AJs8iGZ1t00123.m4a\r\n698 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/6D/wKgJn1p_QDLA9b0iAJsiHPnAZ2g151.m4a\r\n699 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M06/E6/57/wKgJolp_QLuBVN_dAJpTEJVVO_A005.m4a\r\n700 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/5D/wKgJolp_QT-SxE_yAJqPRKhnvVo509.m4a\r\n701 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/08/wKgJolp_JjnwD_2qAJsKnFjXk2U774.m4a\r\n702 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E6/CA/wKgJnlp_Jp-wlGOXAJuKXtNCCaI502.m4a\r\n703 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E6/44/wKgJn1p_JxfRPrHtAJuqrJVKzG4306.m4a\r\n704 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/5C/wKgJo1p_J4DS35ueAJsyQ7QhGUA543.m4a\r\n705 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E6/51/wKgJn1p_J9mxuAtxAJvcl5X5EEw083.m4a\r\n706 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0B/E6/E7/wKgJnlp_KGrRzX_kAJpEYU5zd4s919.m4a\r\n707 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/30/wKgJolp_KNzSSJ-yAJscOg5ATLA426.m4a\r\n708 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/7C/wKgJo1p_KUixqfHEAJvQ2wwLi6E736.m4a\r\n709 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M05/E6/6E/wKgJn1p_KazA2c2EAJvFGzy3CSw803.m4a\r\n710 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/44/wKgJolp_KhWRSwSrAJxQmZsesQY606.m4a\r\n711 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E5/4B/wKgJolp_KoGAT_oXAJvN6HytOjg825.m4a\r\n712 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M0A/E6/83/wKgJn1p_KuDzHGh8AJtPoaFXcr4655.m4a\r\n713 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M02/E7/15/wKgJnlp_K2qyCXL6AJv4fpYJyEc855.m4a\r\n714 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E6/8D/wKgJn1p_K9Hz3ALRAJt0VdEq_bE476.m4a\r\n715 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M08/E7/21/wKgJnlp_LCXxQ-IcAJuddG7TNvE064.m4a\r\n716 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E5/6D/wKgJolp_LL2wjZb0AJvMcCwBSFY022.m4a\r\n717 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E5/73/wKgJolp_LWqih13eAJpF2HvRzXI378.m4a\r\n718 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/C5/wKgJo1p_LhKCYlM5AJnGFv8T8kM703.m4a\r\n719 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M04/E5/CC/wKgJo1p_LrDjAd_sAJsn-oFLEc0145.m4a\r\n720 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M02/E5/90/wKgJolp_L2DQ15QnAJrCp7JtAEE742.m4a\r\n721 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M05/E5/99/wKgJolp_MBqy96rdAJwOhxHclmo907.m4a\r\n722 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E5/A2/wKgJolp_MM7C-oFcAJvhApK9e4w130.m4a\r\n723 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0B/E5/ED/wKgJo1p_MV_BxoJJAJvxKLlJwN0244.m4a\r\n724 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/F7/wKgJo1p_Me_QhGFLAJqPRLMZDoo037.m4a\r\n725 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M08/E5/FE/wKgJo1p_MqPiPGrhAJq-QUqSvrg085.m4a\r\n726 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M00/E6/08/wKgJo1p_M1_DMqrcAJvZqCuglpA866.m4a\r\n727 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M07/E6/0F/wKgJo1p_NBWRnKusAJrHDp762kA833.m4a\r\n728 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M01/E6/FE/wKgJn1p_NNGTfVu_AJqGcw0xEJQ738.m4a\r\n729 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/96/wKgJnlp_NXayvsWQAJusI0c30Gs712.m4a\r\n730 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/0C/wKgJn1p_NiDgWcKYAJs8iMfwt3Y403.m4a\r\n731 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M09/E7/A3/wKgJnlp_Ns6DOQLWAJsn-rOWghI326.m4a\r\n732 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M01/E5/F4/wKgJolp_N4WwOBpQAJvrRp-5WxQ560.m4a\r\n733 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M0A/E5/FC/wKgJolp_OELQwzdkAJn8bAdUuKU698.m4a\r\n734 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M09/E6/49/wKgJo1p_OP2gx1WEAJvGkli9vpI553.m4a\r\n735 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M07/E7/31/wKgJn1p_Ob_BueXYAJz68TzZKL8486.m4a\r\n736 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M00/E7/3A/wKgJn1p_Om3AFks0AJuL1srXCmg193.m4a\r\n737 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M06/E7/42/wKgJn1p_Ox6TE4MkAJt3RBwAqUc082.m4a\r\n738 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group38/M03/E6/6B/wKgJo1p_O96iRthQAJnh_XE1Qb4650.m4a\r\n739 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group39/M04/E7/DA/wKgJnlp_PG-TEs4IAGnfMQQnQZk656.m4a', 'xml_8023', '4720', '', 'W', '', '1.0', 8, 0, 0, 0, 'wanglingguiwuguigushi', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(176, 15, '诡行记[奈小兔演播]', '', '未知', '', '', '', '《诡行记》原著：玉柒     播讲人：奈小兔          三百六十行中骇人听闻的诡秘传说，避讳如深的帮派秘闻，滇南马帮、四川袍哥、黄河排教、古道盐帮，江河漕帮等等神秘帮派的恩怨情仇，还原一个乱世中的江湖，揭秘一个隐藏在你我身边不我身边不为人知的世界。', 'http://imagev2.xmcdn.com/group35/M0B/07/9C/wKgJnVoYM5qhxIcnAAEA7INx9xo059.jpg', '', 1530072261, 2, 0, 0, 0, 0, 1, 1, 7, 8, 'ting', '', '【诡行记】 第一章 捕鳝人 奈小兔演播$http://audio.xmcdn.com/group35/M04/07/E3/wKgJnVoYNL3gJwiVAFmtzg8qyRw392.m4a\r\n【诡行记】 第二章 变蛇 奈小兔演播$http://audio.xmcdn.com/group35/M01/88/F4/wKgJnFoZjcCRxlI-AF26gu1R98U118.m4a\r\n【诡行记】 第三章 鳞 奈小兔演播$http://audio.xmcdn.com/group35/M03/7A/0F/wKgJnVobexCTsH7AAFt5aw65siI096.m4a\r\n【诡行记】 第四章 白狗青牛 奈小兔演播$http://audio.xmcdn.com/group35/M04/7A/16/wKgJnVobezmhOTgMAFjevioNY3s126.m4a\r\n【诡行记】 第五章 雾中幻境 奈小兔演播$http://audio.xmcdn.com/group30/M00/11/2C/wKgJWloc99DgBq-6AFg6R-DBOSU095.m4a\r\n【诡行记】 第六章 暗夜访客 奈小兔演播$http://audio.xmcdn.com/group34/M09/14/AD/wKgJYFoc-A3TZ_jDAF3oCBwh0HQ229.m4a\r\n【诡行记】 第七章 李四奶奶 奈小兔演播$http://audio.xmcdn.com/group32/M03/59/C0/wKgJS1oeIBSwkhnVAFu1oPx8M0g356.m4a\r\n【诡行记】 第八章 柳老大 奈小兔演播$http://audio.xmcdn.com/group34/M04/1C/35/wKgJYFoeH9uAESLuAF1-TiXm09I474.m4a\r\n【诡行记】 第九章 辗转藏身 奈小兔演播$http://audio.xmcdn.com/group32/M08/63/0D/wKgJS1ofnxyDr2JKAFysUxfp1OU391.m4a\r\n【诡行记】 第十章 亦敌亦友 奈小兔演播$http://audio.xmcdn.com/group31/M03/88/E2/wKgJSVofn26zNIpuAFcBgsNA34Q150.m4a\r\n【诡行记】 第十一章 胳膊肘往外拐 奈小兔演播$http://audio.xmcdn.com/group34/M08/2C/D0/wKgJYFog0xawePCTAFrMJB6FqRw573.m4a\r\n【诡行记】 第十二章 姜是老的辣 奈小兔演播$http://audio.xmcdn.com/group32/M05/22/7D/wKgJUFog0vHjzVwMAF7qe5hEWKU249.m4a\r\n【诡行记】 第十三章 万人坑 奈小兔演播$http://audio.xmcdn.com/group35/M00/CC/89/wKgJnVohaiTiL5B3AFvmFHWMspg412.m4a\r\n【诡行记】 第十四章 以身镇坑 奈小兔演播$http://audio.xmcdn.com/group32/M05/70/C7/wKgJS1ohak-jheBPAGQ7uUNq7y0567.m4a\r\n【诡行记】 第十五章 一丝希望 奈小兔演播$http://audio.xmcdn.com/group30/M0B/39/38/wKgJWloinc-DtK4DAF49NPNaXEs637.m4a\r\n【诡行记】 第十六章 天亟木 奈小兔演播$http://audio.xmcdn.com/group31/M08/0D/24/wKgJX1ok0QqzYILfAF6eIBb0WII805.m4a\r\n【诡行记】 第十七章 集体死亡 奈小兔演播$http://audio.xmcdn.com/group21/M08/F5/11/wKgJLVok0SOSnHWSAGG88iGii1w907.m4a\r\n【诡行记】 第十八章 人海孤鸿 奈小兔演播【嗓子不舒服，哎】】$http://audio.xmcdn.com/group32/M09/3F/F6/wKgJUFoniseD21tJAGBg7Hrk2mY481.m4a\r\n【诡行记】 第十九章 山涧水魅 奈小兔演播【声音因为嗓子缘故有些低哑了，见谅】$http://audio.xmcdn.com/group22/M06/FE/44/wKgJLlonitWC0BWLAGBg7Pw5DX8432.m4a\r\n【诡行记】 第二十章 恩同再造 奈小兔演播$http://audio.xmcdn.com/group36/M00/9A/72/wKgJUlopMSii9y_aAF3oCPOYnwM596.m4a\r\n【诡行记】 第二十一章 奇人汇聚 奈小兔演播$http://audio.xmcdn.com/group36/M03/9A/13/wKgJUlopMLeg00eZAF5nyqONj-Y148.m4a\r\n【诡行记】 第二十二章 盗墓贼 奈小兔演播$http://audio.xmcdn.com/group24/M0B/06/32/wKgJMFpZ3BuRtFKdAF2BPZkfyC8582.m4a\r\n【诡行记】 第二十三章 奇兽幽啼 奈小兔演播$http://audio.xmcdn.com/group38/M03/32/17/wKgJolpjgw_jwEkeAFysU-IHXEU953.m4a', 'xml_8023', '4722', '', 'G', '', '1.0', 10, 0, 0, 0, 'guixingjinaixiaotuyanbo', ''),
(177, 15, '墓邪[7.11下架]', '', '未知', '', '', '', '和尚、道士和尼姑，同时被三个邪魔附身的下场，就是要不断地盗取世间最难盗取的古墓，找寻可以破解这一诅咒的神器。正家三代致力于此，到了正南这一代，不知等待在前方的，是吉，还是凶？', 'http://imagev2.xmcdn.com/group25/M02/B8/9F/wKgJMVhPdZKQwgIpAABy8SacR60716.jpg', '', 1530072261, 9, 0, 0, 0, 0, 1, 1, 7, 4, 'ting', '', '墓邪 (1)$http://audio.xmcdn.com/group21/M08/CF/88/wKgJLVhVZPLwbO-fAG0nIo4SXS4336.m4a\r\n墓邪 (2)$http://audio.xmcdn.com/group25/M07/CF/C6/wKgJNlhVZoCDGVXfAGrFvXazSVg008.m4a\r\n墓邪 (3)$http://audio.xmcdn.com/group24/M03/CF/DD/wKgJMFhVZ-7A_dDOAGima9zJ1us551.m4a\r\n墓邪 (4)$http://audio.xmcdn.com/group21/M03/CF/90/wKgJLVhVaSSDLDEiAGaFnYIQDvs545.m4a\r\n墓邪 (5)$http://audio.xmcdn.com/group21/M00/CF/7A/wKgJKFhValqC-U5XAGMql2OVzQ8359.m4a\r\n墓邪 (6)$http://audio.xmcdn.com/group22/M08/D0/27/wKgJM1hVa3yB9S6ZAGehCR0I4bo960.m4a\r\n墓邪 (7)$http://audio.xmcdn.com/group25/M0B/CF/8B/wKgJMVhVbI_D7fpWAFzp_69Z3sc093.m4a\r\n墓邪 (8)$http://audio.xmcdn.com/group23/M05/D0/68/wKgJL1hVbeHy9DOnAG0Z6sWe2SY319.m4a\r\n墓邪 (9)$http://audio.xmcdn.com/group24/M03/D0/0C/wKgJNVhVb0HjxmpgAHeQWe86Uvw891.m4a\r\n墓邪 (10)$http://audio.xmcdn.com/group22/M04/D0/30/wKgJM1hVcGew57R6AGi5gWpqhnE876.m4a\r\n墓邪 (11)$http://audio.xmcdn.com/group24/M06/CF/EE/wKgJMFhVcZaAK7iZAGU_oAN8VMk766.m4a\r\n墓邪 (12)$http://audio.xmcdn.com/group23/M09/D0/6F/wKgJL1hVcpOSoQZsAFzs7nxmpns355.m4a\r\n墓邪 (13)$http://audio.xmcdn.com/group22/M09/D0/34/wKgJM1hVc9PxNsV7AGnU6C9I0_k959.m4a\r\n墓邪 (14)$http://audio.xmcdn.com/group22/M07/D0/8E/wKgJLlhVdOOAdlyYAFwB-1lZTic614.m4a\r\n墓邪 (15)$http://audio.xmcdn.com/group24/M0A/D0/17/wKgJNVhVdgWgDPL8AGGeHC52T0M392.m4a\r\n墓邪 (16)$http://audio.xmcdn.com/group24/M05/CF/F5/wKgJMFhVdzSzlw5xAGgPKaLyEso657.m4a\r\n墓邪 (17)$http://audio.xmcdn.com/group23/M00/D0/77/wKgJL1hVeGHwF2KdAGXv1hfJx3Q290.m4a\r\n墓邪 (18)$http://audio.xmcdn.com/group22/M01/D0/3C/wKgJM1hVeXjAjVIhAGBj3wdmCns667.m4a\r\n墓邪 (19)$http://audio.xmcdn.com/group21/M0A/CF/99/wKgJKFhVet2hnn3-AHf_8TYU_ng085.m4a\r\n墓邪 (20)$http://audio.xmcdn.com/group22/M00/D0/9A/wKgJLlhVfEHxbcvEAHrQ8YVGhXc785.m4a\r\n墓邪 (21)$http://audio.xmcdn.com/group21/M03/CF/9D/wKgJKFhVfVbhR12OAF-cKdty_RA410.m4a\r\n墓邪 (22)$http://audio.xmcdn.com/group23/M0A/D0/3C/wKgJNFhVfregAmfdAHtjyUfCovY083.m4a\r\n墓邪 (23)$http://audio.xmcdn.com/group22/M07/D0/9E/wKgJLlhVgAOjXnXIAG_vVUMV0W8998.m4a\r\n墓邪 (24)$http://audio.xmcdn.com/group22/M0B/D0/A0/wKgJLlhVgQ7S7qWiAF23k3KsTy0081.m4a\r\n墓邪 (25)$http://audio.xmcdn.com/group25/M04/CF/AD/wKgJMVhVgkijwwkVAGt19M4XMHI709.m4a\r\n墓邪 (26)$http://audio.xmcdn.com/group21/M02/CF/A4/wKgJKFhVg2KAVfzHAF7wWfL6bTo511.m4a\r\n墓邪 (27)$http://audio.xmcdn.com/group23/M07/D0/42/wKgJNFhVhG3BGVThAFv9lCzVWyg644.m4a\r\n墓邪 (28)$http://audio.xmcdn.com/group24/M02/D0/2C/wKgJNVhVhXmhRIhvAFww93_AdgY950.m4a\r\n墓邪 (29)$http://audio.xmcdn.com/group23/M06/D0/46/wKgJNFhVhoiBF998AGJ72KNN4oE134.m4a\r\n墓邪 (30)$http://audio.xmcdn.com/group22/M05/D0/A7/wKgJLlhVh6ODSQXhAGDgrkwpo0M555.m4a\r\n墓邪 (31)$http://audio.xmcdn.com/group23/M00/D0/89/wKgJL1hViLuB_P11AHvmelvwKms910.m4a\r\n墓邪 (32)$http://audio.xmcdn.com/group21/M01/CF/C3/wKgJLVhViYah4ZueAF38mdHiydc129.m4a\r\n墓邪 (33)$http://audio.xmcdn.com/group25/M0B/CF/B4/wKgJMVhVimrwo-GKAGppOPgAM1A303.m4a\r\n墓邪 (34)$http://audio.xmcdn.com/group22/M00/D0/AB/wKgJLlhVizjiBjpZAGCS3K5xCrw627.m4a\r\n墓邪 (35)$http://audio.xmcdn.com/group22/M0B/D0/52/wKgJM1hVjAfTovBcAF3TepEJMpg552.m4a\r\n墓邪 (36)$http://audio.xmcdn.com/group24/M0B/D0/33/wKgJNVhVjNKw0PrcAF_rcxNCcAk538.m4a\r\n墓邪 (37)$http://audio.xmcdn.com/group23/M07/D0/4C/wKgJNFhVjZTg8lF2AFt_SWeqXg8530.m4a\r\n墓邪 (38)$http://audio.xmcdn.com/group22/M0A/D0/AE/wKgJLlhVjmyBXsQLAGWZM-6jK6g702.m4a\r\n墓邪 (39)$http://audio.xmcdn.com/group24/M05/D0/13/wKgJMFhVj13Rr8EXAHInm8pMXmg802.m4a\r\n墓邪 (40)$http://audio.xmcdn.com/group23/M00/D0/90/wKgJL1hVj-yCu9RNAFwmszu7w-A636.m4a\r\n墓邪 (41)$http://audio.xmcdn.com/group21/M08/CF/C9/wKgJLVhVkH6zuvKDAF0za5bZXBg145.m4a\r\n墓邪 (42)$http://audio.xmcdn.com/group24/M02/D0/37/wKgJNVhVkROAzKXjAGK4DMFJnwg418.m4a\r\n墓邪 (43)$http://audio.xmcdn.com/group22/M08/D0/57/wKgJM1hVkb-Dt6u3AGeSWYjOgjg562.m4a\r\n墓邪 (44)$http://audio.xmcdn.com/group25/M00/CF/BC/wKgJMVhVklGSlCh6AGZd-vlzBrU655.m4a\r\n墓邪 (45)$http://audio.xmcdn.com/group24/M08/D0/16/wKgJMFhVkt6yuCm8AGEkPFx-f-0671.m4a\r\n墓邪 (46)$http://audio.xmcdn.com/group25/M0B/CF/BC/wKgJMVhVk4HyIEcqAGCHHAQDwjs932.m4a\r\n墓邪 (47)$http://audio.xmcdn.com/group22/M04/D0/B3/wKgJLlhVlBLD6tncAGVaECKiwPg167.m4a\r\n墓邪 (48)$http://audio.xmcdn.com/group22/M07/D0/B3/wKgJLlhVlKbwOBgSAF4eXmiKAEs361.m4a\r\n墓邪 (49)$http://audio.xmcdn.com/group25/M0A/D0/05/wKgJNlhVlVWS_Aq7AHU2SoeKgdE407.m4a\r\n墓邪 (50)$http://audio.xmcdn.com/group25/M05/D0/06/wKgJNlhVlgHwQ0b4AG54364dCwM482.m4a\r\n墓邪 (51)$http://audio.xmcdn.com/group23/M01/D1/21/wKgJL1hV7mPR20YXAG4QnXRlpZM685.m4a\r\n墓邪 (52)$http://audio.xmcdn.com/group23/M07/D0/E5/wKgJNFhV7r6QHGe8AHecFQL5ToU148.m4a\r\n墓邪 (53)$http://audio.xmcdn.com/group25/M05/D0/92/wKgJNlhV7w_hXV6wAHQ2xqF8RJI948.m4a\r\n墓邪 (54)$http://audio.xmcdn.com/group21/M03/D0/35/wKgJKFhV73PQPjdPAHjXzv3zB2A454.m4a\r\n墓邪 (55)$http://audio.xmcdn.com/group24/M08/D0/9F/wKgJMFhV792Tr_EVAIWWqnXPEOk950.m4a\r\n墓邪 (56)$http://audio.xmcdn.com/group23/M0A/D0/E8/wKgJNFhV8CzwX0UaAGMRn1GN4Sw273.m4a\r\n墓邪 (57)$http://audio.xmcdn.com/group22/M09/D1/48/wKgJLlhV8GeShOqEAF5h7OiJt7M251.m4a\r\n墓邪 (58)$http://audio.xmcdn.com/group25/M06/D0/56/wKgJMVhV8M3jyBprAG5Ia4Rcfso181.m4a\r\n墓邪 (59)$http://audio.xmcdn.com/group24/M04/D0/A3/wKgJMFhV8RmDH6EyAHdnO628XEI621.m4a\r\n墓邪 (60)$http://audio.xmcdn.com/group23/M07/D0/ED/wKgJNFhV8WfyGEl0AHB8SvNabLo507.m4a\r\n墓邪 (61)$http://audio.xmcdn.com/group23/M01/D0/F0/wKgJNFhV8cLjpzdpAHS_VT1wXQY038.m4a\r\n墓邪 (62)$http://audio.xmcdn.com/group22/M0B/D1/4C/wKgJLlhV8g-hbnTcAGbAWgJHU_A794.m4a\r\n墓邪 (63)$http://audio.xmcdn.com/group21/M01/D0/3D/wKgJKFhV8lqQEFuuAGHqd6ysEJs588.m4a\r\n墓邪 (64)$http://audio.xmcdn.com/group25/M02/D0/9E/wKgJNlhV8qjSrEWpAGLp_AWmONQ329.m4a\r\n墓邪 (65)$http://audio.xmcdn.com/group23/M05/D1/32/wKgJL1hV8vvT6GbEAGhRPyJkwYE726.m4a\r\n墓邪 (66)$http://audio.xmcdn.com/group24/M07/D0/AB/wKgJMFhV81nR-SrCAGo0XcdtVfo990.m4a\r\n墓邪 (67)$http://audio.xmcdn.com/group25/M03/D0/A1/wKgJNlhV86vC5o8hAGvv1JihsuU300.m4a\r\n墓邪 (68)$http://audio.xmcdn.com/group24/M03/D0/CD/wKgJNVhV8_eh0TwRAGNGfkBEY0g720.m4a\r\n墓邪 (69)$http://audio.xmcdn.com/group22/M03/D0/F9/wKgJM1hV9FSi99nHAHDdN6WF7uc845.m4a\r\n墓邪 (70)$http://audio.xmcdn.com/group21/M06/D0/45/wKgJKFhV9KaSMUAZAGFZF8LD4NQ571.m4a\r\n墓邪 (71)$http://audio.xmcdn.com/group25/M04/D0/65/wKgJMVhV9O_DU4EyAGGMfqW19Jk963.m4a\r\n墓邪 (72)$http://audio.xmcdn.com/group23/M07/D0/FC/wKgJNFhV9WLgsj9yAHxKVfYQ9GU274.m4a\r\n墓邪 (73)$http://audio.xmcdn.com/group25/M01/D0/67/wKgJMVhV9ZyhcjlyAGPU785eCeU636.m4a\r\n墓邪 (74)$http://audio.xmcdn.com/group22/M00/D1/01/wKgJM1hV9fnx9-tGAHTSb2xFARk566.m4a\r\n墓邪 (75)$http://audio.xmcdn.com/group23/M0A/D0/FE/wKgJNFhV9kzzGMltAG2ZrCwSH_U274.m4a\r\n墓邪 (76)$http://audio.xmcdn.com/group24/M01/D0/B6/wKgJMFhV9pjABZhTAGbPCRC_bgs971.m4a\r\n墓邪 (77)$http://audio.xmcdn.com/group25/M06/D0/6E/wKgJMVhV9uHR2B6BAGA039pnC00071.m4a\r\n墓邪 (78)$http://audio.xmcdn.com/group23/M04/D1/40/wKgJL1hV90LSDh40AGvILQJ69ws365.m4a\r\n墓邪 (79)$http://audio.xmcdn.com/group21/M09/D0/4F/wKgJKFhV94LBvhJ0AGKvP4pIwbU235.m4a\r\n墓邪 (80)$http://audio.xmcdn.com/group24/M00/D0/DC/wKgJNVhV99vSa2OYAGeFIk0WlJE479.m4a\r\n墓邪 (81)$http://audio.xmcdn.com/group24/M08/D0/DE/wKgJNVhV-BuwOZWbAGA30ojuNHk245.m4a\r\n墓邪 (82)$http://audio.xmcdn.com/group23/M06/D1/43/wKgJL1hV-HHQw5IyAG03SO07lS8344.m4a\r\n墓邪 (83)$http://audio.xmcdn.com/group21/M0B/D0/6E/wKgJLVhV-N3B3-SpAHuSxeQuQgQ123.m4a\r\n墓邪 (84)$http://audio.xmcdn.com/group24/M07/D0/E4/wKgJNVhV-T2gSVH-AHJ26Zt_nHs969.m4a\r\n墓邪 (85)$http://audio.xmcdn.com/group25/M02/D0/B8/wKgJNlhV-XDAyg72AGSN8jJ2hec796.m4a\r\n墓邪 (86)$http://audio.xmcdn.com/group21/M08/D0/5A/wKgJKFhV-cTRHJf0AGwzXntU6J4663.m4a\r\n墓邪 (87)$http://audio.xmcdn.com/group25/M03/D0/BB/wKgJNlhV-hrxKw0lAHG4A0cGu8M308.m4a\r\n墓邪 (88)$http://audio.xmcdn.com/group24/M02/D0/E7/wKgJNVhV-mXRAr7UAGfu27jb_FU797.m4a\r\n墓邪 (89)$http://audio.xmcdn.com/group21/M02/D0/75/wKgJLVhV-qyTtnCFAF10BV_n6LM811.m4a\r\n墓邪 (90)$http://audio.xmcdn.com/group23/M02/D1/4C/wKgJL1hV-wWCpgb-AGCo4YapPnQ348.m4a\r\n墓邪 (91)$http://audio.xmcdn.com/group25/M0B/D0/C0/wKgJNlhV-1TC20AtAG8NLwjtKwo959.m4a\r\n墓邪 (92)$http://audio.xmcdn.com/group24/M01/D0/EA/wKgJNVhV-5jADyIuAF0tjdhJoGg706.m4a\r\n墓邪 (93)$http://audio.xmcdn.com/group21/M00/D0/79/wKgJLVhV--Gjvhg8AF-AQmLXrho283.m4a\r\n墓邪 (94)$http://audio.xmcdn.com/group22/M07/D1/18/wKgJM1hV_CewBNXiAFoaduoWlXA332.m4a\r\n墓邪 (95)$http://audio.xmcdn.com/group25/M01/D0/81/wKgJMVhV_H_hhDDFAGNYHHJox_c297.m4a\r\n墓邪 (96)$http://audio.xmcdn.com/group24/M03/D0/D2/wKgJMFhV_MCDHZKJAGUgyrY4o-c270.m4a\r\n墓邪 (97)$http://audio.xmcdn.com/group22/M03/D1/1E/wKgJM1hV_RSAj7BbAGgZcdXATsM489.m4a\r\n墓邪 (98)$http://audio.xmcdn.com/group24/M0B/D0/D3/wKgJMFhV_WqCCezXAHEw517aPiU666.m4a\r\n墓邪 (99)$http://audio.xmcdn.com/group21/M0A/D0/7F/wKgJLVhV_cCwyg9sAGnAW6vcQHI629.m4a\r\n墓邪 (100)$http://audio.xmcdn.com/group22/M09/D1/21/wKgJM1hV_gDgTeqzAF030d-Ta4g577.m4a\r\n墓邪 (101)$http://audio.xmcdn.com/group23/M08/D1/B0/wKgJL1hWF1qjq2oTAGigifXoCyo187.m4a\r\n墓邪 (102)$http://audio.xmcdn.com/group25/M07/D1/26/wKgJNlhWF-Xip3bYAGHXYpWbCH0957.m4a\r\n墓邪 (103)$http://audio.xmcdn.com/group23/M04/D1/76/wKgJNFhWGGzSvihiAFjdRsotHAc511.m4a\r\n墓邪 (104)$http://audio.xmcdn.com/group21/M09/D0/DB/wKgJLVhWGPrxFuIXAF0za6OSFAM051.m4a\r\n墓邪 (105)$http://audio.xmcdn.com/group21/M08/D0/C5/wKgJKFhWGY7DlkLBAGFmT3XNqAI115.m4a\r\n墓邪 (106)$http://audio.xmcdn.com/group23/M00/D1/B8/wKgJL1hWGkqA_TvcAFrEzu6F4b0662.m4a\r\n墓邪 (107)$http://audio.xmcdn.com/group24/M09/D1/55/wKgJNVhWGyWRnsQ3AGGcpX9Khjs188.m4a\r\n墓邪 (108)$http://audio.xmcdn.com/group24/M02/D1/3F/wKgJMFhWHA3QFai0AGU4Sz7Fq4M804.m4a\r\n墓邪 (109)$http://audio.xmcdn.com/group22/M04/D1/84/wKgJM1hWHKqwDJFbAFrZXIiJ4W0287.m4a\r\n墓邪 (110)$http://audio.xmcdn.com/group21/M00/D0/D2/wKgJKFhWHYCD6t9fAFyQbLSS-6w052.m4a\r\n墓邪 (111)$http://audio.xmcdn.com/group24/M06/D1/60/wKgJNVhWHkfgf_KdAF3joYC8X_I305.m4a\r\n墓邪 (112)$http://audio.xmcdn.com/group21/M01/D0/EF/wKgJLVhWHyqQdlCTAGHFw36yTQs424.m4a\r\n墓邪 (113)$http://audio.xmcdn.com/group22/M0B/D1/E5/wKgJLlhWIAWA0o0aAGUE46snAks236.m4a\r\n墓邪 (114)$http://audio.xmcdn.com/group21/M09/D0/F5/wKgJLVhWIPLjEsxvAGo3TFyuem8582.m4a\r\n墓邪 (115)$http://audio.xmcdn.com/group21/M08/D0/F7/wKgJLVhWIeCAsqhaAGfQBQwzFq4080.m4a\r\n墓邪 (116)$http://audio.xmcdn.com/group21/M06/D0/F8/wKgJLVhWIrbSdWIkAFn7oKOOfW0611.m4a\r\n墓邪 (117)$http://audio.xmcdn.com/group21/M03/D0/E5/wKgJKFhWI4aDoA5CAFyMBcM4nZ8514.m4a\r\n墓邪 (118)$http://audio.xmcdn.com/group24/M09/D1/60/wKgJMFhWJRag1oJSAFuvwprrOw4499.m4a\r\n墓邪 (119)$http://audio.xmcdn.com/group25/M0A/D1/5A/wKgJNlhWJ2Lwu0xJAGDHt27vgyg295.m4a\r\n墓邪 (120)$http://audio.xmcdn.com/group24/M02/D1/86/wKgJNVhWKcLAeN5UAGr3qbDn1G8966.m4a\r\n墓邪 (121)$http://audio.xmcdn.com/group21/M00/D0/FB/wKgJKFhWKrqx5kayAGJCk6Itsas609.m4a\r\n墓邪 (122)$http://audio.xmcdn.com/group21/M08/D1/02/wKgJKFhWLI2wYfF3AF-zqRzzvLk899.m4a\r\n墓邪 (123)$http://audio.xmcdn.com/group22/M01/D1/BE/wKgJM1hWLnDjZ47yAGOtSNOM8RI874.m4a\r\n墓邪 (124)$http://audio.xmcdn.com/group21/M02/D1/10/wKgJKFhWMMzA_6QRAGnn_qKR4Yo578.m4a\r\n墓邪 (125)$http://audio.xmcdn.com/group22/M08/D2/23/wKgJLlhWMbaSR2eqAGc-pUe2FNM772.m4a\r\n墓邪 (126)$http://audio.xmcdn.com/group25/M01/D1/3E/wKgJMVhWMpSDyyJJAGFUsf_PWAY451.m4a\r\n墓邪 (127)$http://audio.xmcdn.com/group22/M0A/D1/D1/wKgJM1hWM3-xzQNZAGpEhDHb10w317.m4a\r\n墓邪 (128)$http://audio.xmcdn.com/group21/M0A/D1/1E/wKgJKFhWNGWwPP6DAGSeGZj_klU592.m4a\r\n墓邪 (129)$http://audio.xmcdn.com/group23/M0B/D1/DC/wKgJNFhWNUGx1AR_AF8GYhrtGSE718.m4a\r\n墓邪 (130)$http://audio.xmcdn.com/group25/M07/D1/4F/wKgJMVhWNmKCVcm0AG4JRGQzeuc074.m4a\r\n墓邪 (131)$http://audio.xmcdn.com/group24/M07/D1/A3/wKgJMFhWNxTSDv1KAGNxFAFIwkM898.m4a\r\n墓邪 (132)$http://audio.xmcdn.com/group24/M01/D1/BE/wKgJNVhWOBGwnpW7AGx52p7Pr7Q924.m4a\r\n墓邪 (133)$http://audio.xmcdn.com/group24/M05/D1/A9/wKgJMFhWOOSyXIw7AGXLIz-F3Yk727.m4a\r\n墓邪 (134)$http://audio.xmcdn.com/group23/M08/D2/2B/wKgJL1hWOc3gC1yPAGUiQjnyfb0914.m4a\r\n墓邪 (135)$http://audio.xmcdn.com/group22/M04/D1/F0/wKgJM1hWOsayYiRfAG9E_HPTR38491.m4a\r\n墓邪 (136)$http://audio.xmcdn.com/group25/M02/D1/A8/wKgJNlhWO8CywcM6AGj-hj1dNLs971.m4a\r\n墓邪 (137)$http://audio.xmcdn.com/group24/M02/D1/D1/wKgJNVhWPIHTzpAdAF_MnZaUg6A828.m4a\r\n墓邪 (138)$http://audio.xmcdn.com/group21/M0B/D1/3C/wKgJKFhWPVXTisW8AGDPEGScAgo209.m4a\r\n墓邪 (139)$http://audio.xmcdn.com/group24/M08/D1/D6/wKgJNVhWPlPA_bnSAHJlRlvAq4s160.m4a\r\n墓邪 (140)$http://audio.xmcdn.com/group22/M0A/D2/59/wKgJLlhWPzSR7aLtAGf_AlHvyUI503.m4a', 'xml_8023', '4717', '', 'M', '', '1.0', 6, 0, 0, 0, 'muxie711xiajia', ''),
(178, 15, '早年鬼事', '', '未知', '', '', '', '我’在初中时代和爷爷在各个村庄间帮助大家消除恶鬼的神奇事件，文中包含着道家、佛家相关知识，也写出了鬼并不全都是恶，体现了人性，流言对人心的破坏性等。。。。。。                  我’在初中时代和爷爷在各个村庄间帮助大家消除恶鬼的神奇事件，文中包含着道家、佛家相关知识，也写出了鬼并不全都是恶全都是恶，体现了人性，流言对人心的破坏性等。。。。。。       我’在初中时代和爷爷在各个村庄间帮助大家消除恶鬼的神奇事件，文中包含着道家、佛家相关知识，也写出了鬼并不全都是恶，体现了人性，流言对人心的破坏性等。。。。。。                  我’在初中时代和爷爷在各个村庄间帮助大家消除恶鬼的神奇事件，文中包含着道家、佛家相关知识，也写出了鬼并不全都是恶，体现了人性，流言对人心的破坏性等。。。。。。       我’在初中时代和爷爷在各个村庄间帮助大家消除恶鬼的神奇事件，文中包含着道家、佛家相关知识，也写出了鬼并不全都是恶，体现了人性，流言对人心的破坏性等。。。。。。                  我’在初中时代和爷爷在各个村庄间帮助大家消除恶鬼的神奇事件，文中包含着道家、佛家相关知识，也写出了鬼并不全都是恶，体现了人性，流言对人心的破坏性等。。。。。。', 'http://imagev2.xmcdn.com/group42/M05/B0/60/wKgJ9Fq1nDuCUgiqAABtH1GIIUo259.jpg', '', 1530072261, 0, 0, 0, 0, 0, 1, 1, 2, 6, 'ting', '', '001 早年鬼事$http://audio.xmcdn.com/group40/M04/7B/11/wKgJVFq1z4jDcE43AJQSeLC54uw863.m4a\r\n002 早年鬼事$http://audio.xmcdn.com/group40/M08/7A/26/wKgJT1q10iPAaduGAJmXUDDYOjM813.m4a\r\n003 早年鬼事$http://audio.xmcdn.com/group41/M05/B5/72/wKgJ8lq11BHguBLYAJl_mSMpmSE164.m4a\r\n004 早年鬼事$http://audio.xmcdn.com/group41/M0B/B5/8F/wKgJ8lq11c3wlcnQAJcc83HVKfg936.m4a\r\n005 早年鬼事$http://audio.xmcdn.com/group40/M05/7B/8B/wKgJVFq118jjX6WFAJr9ZJU2MZo162.m4a\r\n006 早年鬼事$http://audio.xmcdn.com/group42/M07/B4/17/wKgJ9Fq12kHzn_lzAJxKu2Ag2PU705.m4a\r\n007 早年鬼事$http://audio.xmcdn.com/group42/M04/B4/5F/wKgJ81q13HfjGhK0AJtYbjoZbCg835.m4a\r\n008 早年鬼事$http://audio.xmcdn.com/group41/M09/B3/90/wKgJ8Vq13nfy_1ZIAJx_ljxkf0E594.m4a\r\n009 早年鬼事$http://audio.xmcdn.com/group40/M01/7B/0D/wKgJT1q14BuxKHvzAJ0Pf3fh7eE870.m4a\r\n010 早年鬼事$http://audio.xmcdn.com/group42/M0B/B4/95/wKgJ9Fq14eHAPU3uAJ0Q9ogmy84539.m4a\r\n011 早年鬼事$http://audio.xmcdn.com/group41/M04/B6/75/wKgJ8lq1487Q1cPGAJ9HyT-BpKc285.m4a\r\n012 早年鬼事$http://audio.xmcdn.com/group42/M01/B4/D9/wKgJ9Fq15ZfxbwIAAJsJJIYyxok185.m4a\r\n013 早年鬼事$http://audio.xmcdn.com/group41/M0B/B6/B0/wKgJ8lq15zaC1U6JAJu8SiHHeH8792.m4a\r\n014 早年鬼事$http://audio.xmcdn.com/group40/M00/7C/A6/wKgJVFq16NKwpIn-AJmwDSt0v58849.m4a\r\n015 早年鬼事$http://audio.xmcdn.com/group40/M0A/7C/C2/wKgJVFq16qWTyKiqAJfNKoYSVJY532.m4a\r\n016 早年鬼事$http://audio.xmcdn.com/group40/M09/7B/D7/wKgJT1q17KCRwDpJAJ_ttlqoY74810.m4a\r\n017 早年鬼事$http://audio.xmcdn.com/group42/M04/C3/C9/wKgJ9Fq24SzQtVZUAJV9KU33d5g469.m4a\r\n018 早年鬼事$http://audio.xmcdn.com/group41/M01/C2/EE/wKgJ8Vq24WDwVwvhAJzXsRHzMyc341.m4a\r\n019 早年鬼事$http://audio.xmcdn.com/group42/M02/C3/CC/wKgJ9Fq24XnS5dyqAJc1sUKU_sA809.m4a\r\n020 早年鬼事$http://audio.xmcdn.com/group40/M03/8B/6B/wKgJVFq24c7Co7XUAJvxKFCvbQo603.m4a\r\n021 早年鬼事$http://audio.xmcdn.com/group42/M07/C3/E0/wKgJ81q24jqAlGnRAJRksWeqULo302.m4a\r\n022 早年鬼事$http://audio.xmcdn.com/group42/M01/C3/DA/wKgJ9Fq24qjRYX9QAJvyoMbh09A574.m4a\r\n023 早年鬼事$http://audio.xmcdn.com/group41/M05/C2/FD/wKgJ8Vq24wuTQDWUAJdOqUEIVkY198.m4a\r\n024 早年鬼事$http://audio.xmcdn.com/group41/M09/C5/8A/wKgJ8lq243bDRbKLAJ0BBqBh2ns530.m4a\r\n025 早年鬼事$http://audio.xmcdn.com/group40/M0A/8A/85/wKgJT1q25AzgZ0t5AJuL1ndmv8s745.m4a\r\n026 早年鬼事$http://audio.xmcdn.com/group40/M05/8B/88/wKgJVFq25HPRLISXAJndloDxDYk504.m4a\r\n027 早年鬼事$http://audio.xmcdn.com/group41/M09/C5/A1/wKgJ8lq25OGB7PAFAJq-QQmk9eo171.m4a\r\n028 早年鬼事$http://audio.xmcdn.com/group40/M0B/8A/98/wKgJT1q25UeTE0WZAJ8gIjPf2EM164.m4a\r\n029 早年鬼事$http://audio.xmcdn.com/group41/M00/C5/A5/wKgJ8lq25ZyhBuqTAJzpU3lT_G4899.m4a\r\n030 早年鬼事$http://audio.xmcdn.com/group41/M03/C3/1E/wKgJ8Vq25gzBsNJrAJj_1-uIgQA527.m4a\r\n031 早年鬼事$http://audio.xmcdn.com/group41/M0B/C3/27/wKgJ8Vq25nLTcDrMAJeiXSaCj94830.m4a\r\n032 早年鬼事$http://audio.xmcdn.com/group41/M0B/C3/2B/wKgJ8Vq25pDxKf01AKJ4PYCvsFw769.m4a\r\n033 早年鬼事$http://audio.xmcdn.com/group42/M08/C4/09/wKgJ9Fq25rKjX6kkAJrFl-Rdo8U605.m4a\r\n034 早年鬼事$http://audio.xmcdn.com/group40/M03/8A/A9/wKgJT1q25tmz0UOjAJY6l4t-zf0551.m4a\r\n035 早年鬼事$http://audio.xmcdn.com/group42/M05/C4/0C/wKgJ9Fq25v6gfB2xAJjZrKbhUI4370.m4a\r\n036 早年鬼事$http://audio.xmcdn.com/group41/M04/C5/BA/wKgJ8lq25yXjGfZUAJVqFKszyeA007.m4a\r\n037 早年鬼事$http://audio.xmcdn.com/group42/M07/C4/0F/wKgJ9Fq2503B39N6AJvbIPeqr7s346.m4a\r\n038 早年鬼事$http://audio.xmcdn.com/group40/M02/8B/AB/wKgJVFq253awsIHXAKDwKlGzCzQ582.m4a\r\n039 早年鬼事$http://audio.xmcdn.com/group40/M02/8B/B1/wKgJVFq255SxfzwpAJyJ3he5I9M950.m4a\r\n040 早年鬼事$http://audio.xmcdn.com/group42/M0B/C4/1E/wKgJ81q258mwJf1nAJl5u08ZguU586.m4a\r\n041 早年鬼事$http://audio.xmcdn.com/group42/M09/C4/19/wKgJ9Fq259_C4BCAAJs4IYvaQZU858.m4a\r\n042 早年鬼事$http://audio.xmcdn.com/group40/M08/8A/BB/wKgJT1q26ASSz8NUAJwaRwL6_U0652.m4a\r\n043 早年鬼事$http://audio.xmcdn.com/group41/M03/C3/39/wKgJ8Vq26CfhbgdIAJq52ldTGO4336.m4a\r\n044 早年鬼事$http://audio.xmcdn.com/group41/M0A/C3/3F/wKgJ8Vq26FCQJ6enAJ5JwHwPHao100.m4a\r\n045 早年鬼事$http://audio.xmcdn.com/group42/M03/C4/24/wKgJ81q26HqTdIG-AJiqr7hXhac739.m4a\r\n046 早年鬼事$http://audio.xmcdn.com/group40/M06/8A/C0/wKgJT1q26KKQB8kdAJ4dsqy1emk179.m4a\r\n047 早年鬼事$http://audio.xmcdn.com/group40/M06/8B/C3/wKgJVFq26MbC191gAJwV3CS9P9M027.m4a\r\n048 早年鬼事$http://audio.xmcdn.com/group42/M05/C4/2E/wKgJ81q26O6R4knrAJ3hfg0DDmo652.m4a\r\n049 早年鬼事$http://audio.xmcdn.com/group41/M02/C5/D6/wKgJ8lq26RvBCgAmAKL8ZjU5Ib8221.m4a\r\n050 早年鬼事$http://audio.xmcdn.com/group42/M02/C4/31/wKgJ81q26TuCt3hEAJjbWRNwET8801.m4a\r\n051 早年鬼事$http://audio.xmcdn.com/group41/M0B/F3/0F/wKgJ8lq5oL-ycdqsAJcGtH0ZT9Q181.m4a\r\n052 早年鬼事$http://audio.xmcdn.com/group41/M09/F0/9F/wKgJ8Vq5ofTw4Jh-AKMiki9rIyU042.m4a\r\n053 早年鬼事$http://audio.xmcdn.com/group40/M08/B8/F9/wKgJVFq5ozqxM9MbAJv1j4dHzTo209.m4a\r\n054 早年鬼事$http://audio.xmcdn.com/group41/M0A/F0/BB/wKgJ8Vq5pHrjHM1TAJjqCHwhPRE048.m4a\r\n055 早年鬼事$http://audio.xmcdn.com/group41/M01/F3/50/wKgJ8lq5peDiQspmAJoFOcytX1w825.m4a\r\n056 早年鬼事$http://audio.xmcdn.com/group40/M06/B8/2F/wKgJT1q5psTiETkwAJkS8VE9ha0349.m4a\r\n057 早年鬼事$http://audio.xmcdn.com/group42/M05/F1/E3/wKgJ81q5p1KjH9lNAJZYLJgq31Y956.m4a\r\n058 早年鬼事$http://audio.xmcdn.com/group41/M06/F3/6B/wKgJ8lq5p-ziGEiTAJOnQ84SBOw883.m4a\r\n059 早年鬼事$http://audio.xmcdn.com/group42/M03/F1/B7/wKgJ9Fq5qDbS3O8lAJe52tzjO-E094.m4a\r\n060 早年鬼事$http://audio.xmcdn.com/group41/M0B/F3/78/wKgJ8lq5qLajdvPzAJmepdJxOUs327.m4a\r\n061 早年鬼事$http://audio.xmcdn.com/group41/M0A/03/AD/wKgJ8Vq60mzRrQUPAJ2hFfF6iFE425.m4a\r\n062 早年鬼事$http://audio.xmcdn.com/group41/M01/03/B9/wKgJ8Vq602vRrMa1AJQ__VVxe28880.m4a\r\n063 早年鬼事$http://audio.xmcdn.com/group41/M06/06/4B/wKgJ8lq61GDhUX1rAJJYdWkf6wU684.m4a\r\n064 早年鬼事$http://audio.xmcdn.com/group42/M05/04/E8/wKgJ81q61T6TREmYAJdnoY5s6X4177.m4a\r\n065 早年鬼事$http://audio.xmcdn.com/group42/M0B/04/B6/wKgJ9Fq61iyymi1hAJnHjhSfhhs433.m4a\r\n066 早年鬼事$http://audio.xmcdn.com/group40/M04/CB/3C/wKgJT1q61zPAYzUsAJgTbORNE6g740.m4a\r\n067 早年鬼事$http://audio.xmcdn.com/group42/M08/05/08/wKgJ81q62DCTFAuIAJY3qLgTVmo595.m4a\r\n068 早年鬼事$http://audio.xmcdn.com/group42/M07/05/12/wKgJ81q62TGj6Z-wAJaf6ma7k0Y778.m4a\r\n069 早年鬼事$http://audio.xmcdn.com/group40/M06/CB/5C/wKgJT1q62jKhHiceAJcPhubjIxU676.m4a\r\n070 早年鬼事$http://audio.xmcdn.com/group41/M04/06/94/wKgJ8lq62zawrHt_AJl5u1_he1c910.m4a\r\n071 早年鬼事$http://audio.xmcdn.com/group42/M0A/18/C2/wKgJ9Fq8Im-i8DFmAJZa5Q4Rir0741.m4a\r\n072 早年鬼事$http://audio.xmcdn.com/group42/M01/19/20/wKgJ81q8I32AxsojAJ0p7thQWqg843.m4a\r\n073 早年鬼事$http://audio.xmcdn.com/group42/M03/19/2C/wKgJ81q8JBzizSxEAJ1KOy_wytw367.m4a\r\n074 早年鬼事$http://audio.xmcdn.com/group42/M06/18/DF/wKgJ9Fq8JKuyj8DnAJbWQMF8UIc801.m4a\r\n075 早年鬼事$http://audio.xmcdn.com/group42/M00/19/34/wKgJ81q8JQTgdGzdAJOnQ-TM1Kw353.m4a\r\n076 早年鬼事$http://audio.xmcdn.com/group40/M02/DF/76/wKgJT1q8JV2gzhbPAI_fkNmdsg8993.m4a\r\n077 早年鬼事$http://audio.xmcdn.com/group41/M02/1A/B7/wKgJ8lq8JbzwOEbCAJDfFIYAFhA268.m4a\r\n078 早年鬼事$http://audio.xmcdn.com/group41/M05/18/35/wKgJ8Vq8Jibi7SOcAJUQgRMLc-E668.m4a\r\n079 早年鬼事$http://audio.xmcdn.com/group42/M02/18/F3/wKgJ9Fq8JouCIpKyAJKMEu4Tr-8985.m4a\r\n080 早年鬼事$http://audio.xmcdn.com/group40/M07/E0/76/wKgJVFq8Ju3C5EPTAJS4ZpLjyFE244.m4a\r\n081 早年鬼事$http://audio.xmcdn.com/group41/M0B/1A/C8/wKgJ8lq8J2HQhhChAJBoI0VsFtQ219.m4a\r\n082 早年鬼事$http://audio.xmcdn.com/group40/M08/E0/80/wKgJVFq8J8egMZZEAJMjGqLqAdo321.m4a\r\n083 早年鬼事$http://audio.xmcdn.com/group40/M0A/DF/97/wKgJT1q8KDCiFzzQAJKtoQ7TzTU182.m4a\r\n084 早年鬼事$http://audio.xmcdn.com/group42/M03/19/5E/wKgJ81q8KJiiRxdCAJW5XrUson0454.m4a\r\n085 早年鬼事$http://audio.xmcdn.com/group41/M08/18/53/wKgJ8Vq8KQaw6nZSAJSspsOz1dE424.m4a\r\n086 早年鬼事$http://audio.xmcdn.com/group41/M01/18/56/wKgJ8Vq8KXKyNWxWAJRF22yXfuw762.m4a\r\n087 早年鬼事$http://audio.xmcdn.com/group42/M00/19/14/wKgJ9Fq8Kcnwh-9wAJJbnknigz0750.m4a\r\n088 早年鬼事$http://audio.xmcdn.com/group40/M05/E0/9C/wKgJVFq8KifjRHM5AJCXIIEAoTc950.m4a\r\n089 早年鬼事$http://audio.xmcdn.com/group42/M01/19/70/wKgJ81q8KqexPgzgAJ5A76RYnCU163.m4a\r\n090 早年鬼事$http://audio.xmcdn.com/group42/M08/19/1F/wKgJ9Fq8KwDCc7ofAJJlrPTptm8698.m4a\r\n091 早年鬼事$http://audio.xmcdn.com/group41/M07/18/71/wKgJ8Vq8K6XxhOfPAJZz3U7OxYM102.m4a\r\n092 早年鬼事$http://audio.xmcdn.com/group42/M0A/19/85/wKgJ81q8LOaghLPqAJH0nWLVgWE207.m4a\r\n093 早年鬼事$http://audio.xmcdn.com/group41/M01/1B/11/wKgJ8lq8LfuCz22OAJiF9_iaY_A706.m4a\r\n094 早年鬼事$http://audio.xmcdn.com/group42/M03/19/96/wKgJ81q8Lumz92zfAI59rHtfAu4062.m4a\r\n095 早年鬼事$http://audio.xmcdn.com/group40/M05/DF/E6/wKgJT1q8L_Ky_QXmAJgWYMXvmYg357.m4a\r\n096 早年鬼事$http://audio.xmcdn.com/group41/M08/18/A8/wKgJ8Vq8MLmj5v98AJWQQyAYEbI874.m4a\r\n097 早年鬼事$http://audio.xmcdn.com/group42/M0B/19/AD/wKgJ81q8MZHAFBcsAJrl6DDIU-I779.m4a\r\n098 早年鬼事$http://audio.xmcdn.com/group41/M06/18/B6/wKgJ8Vq8MhfB_FWiAJQeNHsVZiA022.m4a\r\n099 早年鬼事$http://audio.xmcdn.com/group42/M04/19/B9/wKgJ81q8MoKDYwzOAJQMltBynl4831.m4a\r\n100 早年鬼事$http://audio.xmcdn.com/group41/M09/1B/43/wKgJ8lq8MuTzIJgAAJiTL0czE9w499.m4a\r\n101 早年鬼事$http://audio.xmcdn.com/group40/M00/E0/0C/wKgJT1q8M0XDVllLAJR6uqlPG_Q399.m4a\r\n102 早年鬼事$http://audio.xmcdn.com/group42/M09/19/C3/wKgJ81q8M6XBAE9xAJGd-nZokvM858.m4a\r\n103 早年鬼事$http://audio.xmcdn.com/group41/M0A/1B/52/wKgJ8lq8NAzix5xWAJaOTJ0QpWA527.m4a\r\n104 早年鬼事$http://audio.xmcdn.com/group40/M08/E0/12/wKgJT1q8NG2AOUGzAI6bQJpBKb4748.m4a\r\n105 早年鬼事$http://audio.xmcdn.com/group41/M01/18/D6/wKgJ8Vq8NRij-HIoAJLoXs5SMvs371.m4a\r\n106 早年鬼事$http://audio.xmcdn.com/group40/M0B/E1/1B/wKgJVFq8NlLB0FJZAJJhRoD4F1Y168.m4a\r\n107 早年鬼事$http://audio.xmcdn.com/group40/M0A/E0/32/wKgJT1q8N3Wg0F6nAJLFISrn1_c175.m4a\r\n108 早年鬼事$http://audio.xmcdn.com/group40/M01/E1/2E/wKgJVFq8OJfQiGZeAJHM9oAK9iY569.m4a\r\n109 早年鬼事$http://audio.xmcdn.com/group40/M06/E0/4A/wKgJT1q8OYSC9AG_AJFx7DkR_yA328.m4a\r\n110 早年鬼事$http://audio.xmcdn.com/group41/M05/1B/92/wKgJ8lq8OhrB7jmOAJQZzgFiJQg622.m4a\r\n111 早年鬼事$http://audio.xmcdn.com/group42/M03/1A/13/wKgJ81q8OrOSMVoYAI8MU3XzEBY232.m4a\r\n112 早年鬼事$http://audio.xmcdn.com/group42/M06/1A/18/wKgJ81q8O0nTV5xMAI-DDqMgA9k616.m4a\r\n113 早年鬼事$http://audio.xmcdn.com/group40/M0A/E0/68/wKgJT1q8O53R8KxbAI_uP9Y6ueY908.m4a\r\n114 早年鬼事$http://audio.xmcdn.com/group41/M05/1B/AA/wKgJ8lq8PAqiVgthAIwpf-k9Dzs776.m4a\r\n115 早年鬼事$http://audio.xmcdn.com/group40/M02/E1/5F/wKgJVFq8PF-CfB0tAI9f0gWpNi4992.m4a\r\n116 早年鬼事$http://audio.xmcdn.com/group41/M0A/1B/B1/wKgJ8lq8PMCgirtBAJGQwgV5LUY179.m4a\r\n117 早年鬼事$http://audio.xmcdn.com/group41/M00/19/35/wKgJ8Vq8PSzzWjF4AJIMGkh3S2k895.m4a\r\n118 早年鬼事$http://audio.xmcdn.com/group40/M09/E1/70/wKgJVFq8PZbRizd9AJTHFXd63Wg343.m4a\r\n119 早年鬼事$http://audio.xmcdn.com/group41/M09/1B/BF/wKgJ8lq8PfqCLaz_AJGAm6e9L4g021.m4a\r\n120 早年鬼事$http://audio.xmcdn.com/group42/M05/19/F1/wKgJ9Fq8Pl2zgFgLAJR6uvIkbMM763.m4a\r\n121 早年鬼事$http://audio.xmcdn.com/group41/M07/19/47/wKgJ8Vq8PsmSh2pYAJ2QuN3T-Wk298.m4a\r\n122 早年鬼事$http://audio.xmcdn.com/group40/M05/E0/96/wKgJT1q8PyvRQbnhAJJOME18ypk537.m4a\r\n123 早年鬼事$http://audio.xmcdn.com/group42/M0B/1A/52/wKgJ81q8P43D1KKLAJE6HibdguU471.m4a\r\n124 早年鬼事$http://audio.xmcdn.com/group42/M03/1A/54/wKgJ81q8P_fRAylDAJVtA79B5mI407.m4a\r\n125 早年鬼事$http://audio.xmcdn.com/group42/M0B/1A/5F/wKgJ81q8QFvgLOpRAJU2rKJ2VMU780.m4a\r\n126 早年鬼事$http://audio.xmcdn.com/group41/M01/19/5F/wKgJ8Vq8QMPTYrlIAJagIKV5lI0263.m4a\r\n127 早年鬼事$http://audio.xmcdn.com/group42/M06/1A/65/wKgJ81q8QSaRTb5LAJHnZtFI4Ss296.m4a\r\n128 早年鬼事$http://audio.xmcdn.com/group41/M05/1B/EF/wKgJ8lq8QYqAjTCZAJT5AUgao-g507.m4a\r\n129 早年鬼事$http://audio.xmcdn.com/group42/M05/1A/29/wKgJ9Fq8Qr_Ckh3yAJLeGXIMwjQ108.m4a\r\n130 早年鬼事$http://audio.xmcdn.com/group41/M0B/19/89/wKgJ8Vq8Q-_BjKFcAI-TNRhSG4M781.m4a\r\n131 早年鬼事$http://audio.xmcdn.com/group42/M01/2F/15/wKgJ9Fq9dsCjNL-mAJMaTbFNyxM858.m4a\r\n132 早年鬼事$http://audio.xmcdn.com/group42/M09/2F/4A/wKgJ81q9d0-y0on-AJkV4LPgZe4701.m4a\r\n133 早年鬼事$http://audio.xmcdn.com/group40/M06/F6/A1/wKgJVFq9d-PBPyW4AJJLQQiqdXk130.m4a\r\n134 早年鬼事$http://audio.xmcdn.com/group41/M01/2E/5F/wKgJ8Vq9eH7i9_HDAJAet0xCB3w737.m4a\r\n135 早年鬼事$http://audio.xmcdn.com/group42/M0B/2F/64/wKgJ81q9eQLx7BQiAI8mjJdnyVg070.m4a\r\n136 早年鬼事$http://audio.xmcdn.com/group40/M0A/F6/B7/wKgJVFq9ebyhlKu5AJtCaprABKw968.m4a\r\n137 早年鬼事$http://audio.xmcdn.com/group42/M00/2F/50/wKgJ9Fq9ew2BOjIUAJEv1q7nQNg025.m4a\r\n138 早年鬼事$http://audio.xmcdn.com/group42/M01/2F/64/wKgJ9Fq9fKKQ4BzjAJ4cO6o_TP0915.m4a\r\n139 早年鬼事$http://audio.xmcdn.com/group42/M05/2F/A2/wKgJ81q9fkbh4YbmAJG54cLmaKQ519.m4a\r\n140 早年鬼事$http://audio.xmcdn.com/group42/M0A/2F/8D/wKgJ9Fq9f7SwX9_HAI85okQUfw0033.m4a\r\n141 早年鬼事$http://audio.xmcdn.com/group40/M07/00/0E/wKgJT1q-Hgmgysn9AJKHdYGjy1c645.m4a\r\n142 早年鬼事$http://audio.xmcdn.com/group40/M06/01/02/wKgJVFq-HvrQF-7-AJchWvW-HK4282.m4a\r\n143 早年鬼事$http://audio.xmcdn.com/group41/M02/38/CF/wKgJ8Vq-H3rh8SLHAJHhhBdLebo795.m4a\r\n144 早年鬼事$http://audio.xmcdn.com/group40/M03/01/18/wKgJVFq-H9rBZ564AJQSeBk3wQw133.m4a\r\n145 早年鬼事$http://audio.xmcdn.com/group41/M0B/38/E8/wKgJ8Vq-IGmQIdUVAJmYkSUWAds108.m4a\r\n146 早年鬼事$http://audio.xmcdn.com/group40/M04/01/74/wKgJVFq-IzGCa4cbAJC3bbuzY2k184.m4a\r\n147 早年鬼事$http://audio.xmcdn.com/group42/M0A/3A/35/wKgJ9Fq-JR2w7v0DAI_v7e4wnio296.m4a\r\n148 早年鬼事$http://audio.xmcdn.com/group40/M03/00/D5/wKgJT1q-JZKx3H6gAJhMsm0nAaE912.m4a\r\n149 早年鬼事$http://audio.xmcdn.com/group40/M08/01/C1/wKgJVFq-JgKRDpr9AJn2wB71J28339.m4a\r\n150 早年鬼事$http://audio.xmcdn.com/group42/M01/3A/56/wKgJ9Fq-JnHhVnU1AJq-Qd79iW4891.m4a\r\n151 早年鬼事$http://audio.xmcdn.com/group40/M01/01/D8/wKgJVFq-JtziJxtkAJdEYDm5Lbk740.m4a\r\n152 早年鬼事$http://audio.xmcdn.com/group41/M0B/3C/24/wKgJ8lq-J0TBiuyHAJScf-Eye1E867.m4a\r\n153 早年鬼事$http://audio.xmcdn.com/group40/M02/01/41/wKgJT1q-KUmwU8BLAI6MW8tqkc0318.m4a\r\n154 早年鬼事$http://audio.xmcdn.com/group42/M00/3A/EE/wKgJ81q-KbzR9IwkAJVc3AcXH5w291.m4a\r\n155 早年鬼事$http://audio.xmcdn.com/group40/M03/01/61/wKgJT1q-Ki7gsyjhAJJ-pBURUaI204.m4a\r\n156 早年鬼事$http://audio.xmcdn.com/group42/M04/3B/07/wKgJ81q-KqTyvpTrAJfwZlF0r9I638.m4a\r\n157 早年鬼事$http://audio.xmcdn.com/group40/M0A/01/90/wKgJT1q-K9KzD65MAJmM0Tcb0E4078.m4a\r\n158 早年鬼事$http://audio.xmcdn.com/group40/M01/01/CE/wKgJT1q-LYfS5sEfAIqIc28BUZA513.m4a\r\n159 早年鬼事$http://audio.xmcdn.com/group40/M00/02/CE/wKgJVFq-Ltey7xaSAJL5_GvPksA939.m4a\r\n160 早年鬼事$http://audio.xmcdn.com/group41/M08/3D/1D/wKgJ8lq-L0fzZua2AJVLPp3yNPk514.m4a\r\n161 早年鬼事$http://audio.xmcdn.com/group41/M00/3D/23/wKgJ8lq-L7Tyg_o8AJO18hzo2T8416.m4a\r\n162 早年鬼事$http://audio.xmcdn.com/group40/M03/02/1C/wKgJT1q-MBjQtXaeAI7r0M2dLjs597.m4a\r\n163 早年鬼事$http://audio.xmcdn.com/group40/M09/03/15/wKgJVFq-MIOgv-RaAJMetHM2ZGo849.m4a\r\n164 早年鬼事$http://audio.xmcdn.com/group41/M04/3A/D4/wKgJ8Vq-MPOxSucsAJKF_lu_lpk124.m4a\r\n165 早年鬼事$http://audio.xmcdn.com/group41/M08/3D/8A/wKgJ8lq-MkyTtjPgAJNVCke8SA8376.m4a\r\n166 早年鬼事$http://audio.xmcdn.com/group40/M01/02/A3/wKgJT1q-NAKTjJ-BAIxhSR0FUBQ966.m4a\r\n167 早年鬼事$http://audio.xmcdn.com/group41/M05/3D/D0/wKgJ8lq-NGvCHASqAIoby3gdLlk174.m4a\r\n168 早年鬼事$http://audio.xmcdn.com/group41/M07/3D/E2/wKgJ8lq-NRDTY96jAJK932nI2J8280.m4a\r\n169 早年鬼事$http://audio.xmcdn.com/group42/M07/3C/8B/wKgJ81q-NUuDCq_pAJVqFDAHm90148.m4a\r\n170 早年鬼事$http://audio.xmcdn.com/group41/M0B/3B/8A/wKgJ8Vq-Nbqy7mqsAJm6XxPD4Co544.m4a\r\n171 早年鬼事$http://audio.xmcdn.com/group40/M0A/03/E8/wKgJVFq-NiXR6Ek_AJHBNtEVvn0773.m4a\r\n172 早年鬼事$http://audio.xmcdn.com/group42/M0A/3C/B6/wKgJ81q-NpryiJpzAItzZ6EoiYA459.m4a\r\n173 早年鬼事$http://audio.xmcdn.com/group41/M02/3E/2F/wKgJ8lq-NwSjqv-xAJH2FfPM1po458.m4a\r\n174 早年鬼事$http://audio.xmcdn.com/group42/M03/3C/E8/wKgJ81q-N3nhSTWKAJMaTWeVpWg644.m4a\r\n175 早年鬼事$http://audio.xmcdn.com/group41/M04/3B/D0/wKgJ8Vq-N-OT3kCdAJB20pAuo1A853.m4a\r\n176 早年鬼事$http://audio.xmcdn.com/group40/M02/03/55/wKgJT1q-OEzxRsnTAJEp-CeCl0Y718.m4a\r\n177 早年鬼事$http://audio.xmcdn.com/group41/M0A/3E/75/wKgJ8lq-OMTBJF9cAJhRHDvx8X0453.m4a\r\n178 早年鬼事$http://audio.xmcdn.com/group42/M02/3C/EE/wKgJ9Fq-OTOThom1AJJA-EwrgKc322.m4a\r\n179 早年鬼事$http://audio.xmcdn.com/group40/M00/04/63/wKgJVFq-OaHQNd5JAI7emNc3hkc811.m4a\r\n180 早年鬼事$http://audio.xmcdn.com/group40/M07/04/89/wKgJVFq-OfXSkci2AIuVZWqG_zs448.m4a\r\n181 早年鬼事$http://audio.xmcdn.com/group42/M09/3D/0F/wKgJ9Fq-Ok-Qp_7WAJRsQW-9sJI937.m4a\r\n182 早年鬼事$http://audio.xmcdn.com/group42/M00/3D/56/wKgJ81q-OoeA3TszAJ4q6jwdQag096.m4a\r\n183 早年鬼事$http://audio.xmcdn.com/group41/M02/3C/3A/wKgJ8Vq-OrTTnzhqAJCOT52DYE4944.m4a\r\n184 早年鬼事$http://audio.xmcdn.com/group41/M05/3C/4E/wKgJ8Vq-OuKz14rSAJKDGipCh0c323.m4a\r\n185 早年鬼事$http://audio.xmcdn.com/group40/M09/03/BA/wKgJT1q-OxbykxVYAJh9KtFMWSk285.m4a\r\n186 早年鬼事$http://audio.xmcdn.com/group40/M09/04/A7/wKgJVFq-O0vwdbwHAJ608QO2I9E336.m4a\r\n187 早年鬼事$http://audio.xmcdn.com/group42/M04/3D/48/wKgJ9Fq-O3XjHBUhAJSj1D52yiQ110.m4a\r\n188 早年鬼事$http://audio.xmcdn.com/group41/M08/3C/66/wKgJ8Vq-O6qjNE6FAKFA6wLdfoQ538.m4a\r\n189 早年鬼事$http://audio.xmcdn.com/group42/M04/3D/87/wKgJ81q-O9aBlg7eAJI4J78qBbU737.m4a\r\n190 早年鬼事$http://audio.xmcdn.com/group41/M03/3C/75/wKgJ8Vq-PAiSyKYsAJWAMY8dH6g821.m4a\r\n191 早年鬼事$http://audio.xmcdn.com/group40/M05/03/AF/wKgJT1q-OpbCBUSwAJEW4nEiCBM618.m4a\r\n192 早年鬼事$http://audio.xmcdn.com/group41/M05/3C/5C/wKgJ8Vq-OwChCdDGAI8X3V9eFrw399.m4a\r\n193 早年鬼事$http://audio.xmcdn.com/group40/M09/03/C5/wKgJT1q-O0WgLqlKAGgTluavdTg857.m4a', 'xml_8023', '4719', '', 'Z', '', '1.0', 4, 0, 0, 0, 'zaonianguishi', ''),
(179, 15, '中医世家亲历不思议事件 全集', '', '未知', '', '', '', '如果说这个世界上真的有鬼神，恐怕中医大夫是最能接近到鬼神的职业之一了。古代的“医”字，有一种写法下半部分就是“巫”。一位中医世家的后人在翻看曾祖和祖父留下的记录时发现的不可思议的事情。', 'http://imagev2.xmcdn.com/group18/M01/2B/60/wKgJJVfl3DrDldKKAABGIxtf1uQ909.jpg', '', 1530072261, 0, 0, 0, 0, 0, 1, 1, 4, 8, 'ting', '', '001鬼门贺$http://audio.xmcdn.com/group19/M0B/2B/DC/wKgJK1fl3JWBmx94AENAObcZNvA739.m4a\r\n002太素脉$http://audio.xmcdn.com/group19/M0B/2B/DC/wKgJK1fl3JPBheKeACZr3noxGB8923.m4a\r\n003祝由十三科$http://audio.xmcdn.com/group19/M0B/2B/DC/wKgJK1fl3JuDutkYAD4vlhcSPHU152.m4a\r\n004人参精$http://audio.xmcdn.com/group20/M04/2C/2F/wKgJJ1fl3KShMsCbAFDA6jiYQpM701.m4a\r\n005业障病$http://audio.xmcdn.com/group20/M04/2C/2F/wKgJJ1fl3KmhElJSAEFVwsX_aIM883.m4a\r\n006神鬼病$http://audio.xmcdn.com/group17/M08/2B/CC/wKgJJFfl3LrBfmiDAFOATPncqxI085.m4a\r\n007摇铃医$http://audio.xmcdn.com/group17/M08/2B/CC/wKgJJFfl3LuCbziQAFBXMOBUYkc254.m4a\r\n008不死人$http://audio.xmcdn.com/group17/M08/2C/1E/wKgJKVfl3L7hfIrWAEKxyBXo970877.m4a\r\n009医患缘$http://audio.xmcdn.com/group17/M08/2B/CD/wKgJJFfl3M6g7yTfAEV-Ye3aCh4777.m4a\r\n010谓之神$http://audio.xmcdn.com/group17/M08/2B/CD/wKgJJFfl3M3yFkqBAD0ECGU9SXo059.m4a', 'xml_8023', '4714', '', 'Z', '', '1.0', 3, 0, 0, 0, 'zhongyishijiaqinlibusiyishijianquanji', ''),
(180, 15, '《杀人之门》东野圭吾[完本]', '', '未知', '', '', '', '一位饱受校园霸凌欺辱的男孩，成长为冷酷杀人犯的心路历程。本书过于黑暗，请谨慎收听', 'http://imagev2.xmcdn.com/group27/M07/91/C2/wKgJR1kC7Euhrr-NAAAe7mUyTV4540.jpg', '', 1530072261, 6, 0, 0, 0, 0, 1, 1, 7, 5, 'ting', '', '杀人之门01（文石听友群；160066051）$http://audio.xmcdn.com/group27/M03/91/D9/wKgJW1kC7rLyihzHAI1a62yCZ2A833.m4a\r\n杀人之门02（文石听友群；160066051）$http://audio.xmcdn.com/group27/M08/91/E2/wKgJR1kC7rzQxsNFAIttiI0bOSE330.m4a\r\n杀人之门03（文石听友群；160066051）$http://audio.xmcdn.com/group27/M0B/CF/78/wKgJR1kICbKSt8r3AJHWWMegk3k539.m4a\r\n杀人之门04（文石听友群；160066051）$http://audio.xmcdn.com/group27/M0B/CF/79/wKgJR1kICb7yPExXAJ9gwXMtqpU289.m4a\r\n杀人之门05（文石听友群；160066051）$http://audio.xmcdn.com/group26/M01/D6/24/wKgJWFkINsuhflb3AHlntxU07RQ444.m4a\r\n杀人之门06（文石听友群；160066051）$http://audio.xmcdn.com/group26/M01/D5/A7/wKgJRlkINtKxu69KAHdG7WMJDdg729.m4a\r\n杀人之门07（文石听友群；160066051）$http://audio.xmcdn.com/group26/M08/F7/B3/wKgJWFkKgJ-wRRy6AIC39pYZCu4616.m4a\r\n杀人之门08（文石听友群；160066051）$http://audio.xmcdn.com/group27/M04/F3/94/wKgJW1kKgLizI07nAIGgqBC1hUY332.m4a\r\n杀人之门09（文石听友群；160066051）$http://audio.xmcdn.com/group27/M07/F3/52/wKgJR1kKgNijyOcaALt0u-76Wi4373.m4a\r\n杀人之门10（文石听友群；160066051）$http://audio.xmcdn.com/group26/M02/54/44/wKgJWFkRF6Gj0VlsAJCc_tR6Osc469.m4a\r\n杀人之门11（文石听友群；160066051）$http://audio.xmcdn.com/group26/M08/53/56/wKgJRlkRE9ejUv9cAJByaOuBJZo687.m4a\r\n杀人之门12（文石听友群；160066051）$http://audio.xmcdn.com/group26/M07/54/19/wKgJWFkRE_agPRSxAIo6oYhrwfs902.m4a\r\n杀人之门13（文石听友群；160066051）$http://audio.xmcdn.com/group26/M09/53/5B/wKgJRlkRFASCT5N3AGwY8tS_-tk599.m4a\r\n杀人之门14（文石听友群；160066051）$http://audio.xmcdn.com/group27/M00/4F/EB/wKgJR1kRFBrhBQ7KAFf-EwUrILU244.m4a\r\n杀人之门15（文石听友群；160066051）$http://audio.xmcdn.com/group27/M00/4F/F0/wKgJR1kRFEXC0hdMAHHA0F1mSBU274.m4a\r\n杀人之门16（文石听友群；160066051）$http://audio.xmcdn.com/group26/M05/53/63/wKgJRlkRFHOzPQImAGKD37udHvc185.m4a\r\n杀人之门17（文石听友群；160066051）$http://audio.xmcdn.com/group27/M05/50/18/wKgJW1kRFKix2g0jAHbNCWXUg8k602.m4a\r\n杀人之门18（文石听友群；160066051）$http://audio.xmcdn.com/group26/M0B/54/23/wKgJWFkRFNHAQpnvAGq1k756uPA859.m4a\r\n杀人之门19（文石听友群；160066051）$http://audio.xmcdn.com/group27/M0A/4F/F8/wKgJR1kRFPSAVn3uAGD5phJdb3s270.m4a\r\n杀人之门20（文石听友群；160066051）$http://audio.xmcdn.com/group27/M03/50/1E/wKgJW1kRFSORcKNyAFJKdUE0P3w838.m4a\r\n杀人之门21（文石听友群；160066051）$http://audio.xmcdn.com/group27/M09/50/24/wKgJW1kRFYmS1BxYAIczqVkxbhc252.m4a\r\n杀人之门22（文石听友群；160066051）$http://audio.xmcdn.com/group27/M04/50/21/wKgJW1kRFXKgRdg6AGy-4FvL4ew975.m4a\r\n杀人之门23（文石听友群；160066051）$http://audio.xmcdn.com/group27/M09/50/04/wKgJR1kRFZriFuCZAHV25VTvoN0905.m4a\r\n杀人之门24（文石听友群；160066051）$http://audio.xmcdn.com/group27/M08/66/35/wKgJR1kSqXSRBgkIAFrGwiSN254262.m4a\r\n杀人之门25$http://audio.xmcdn.com/group26/M07/6A/27/wKgJWFkSqYnDxWiCAHAG1ooCcTg337.m4a\r\n杀人之门26$http://audio.xmcdn.com/group26/M09/69/5F/wKgJRlkSqYnADJfuAEtN5vk6baE177.m4a\r\n杀人之门27$http://audio.xmcdn.com/group26/M09/69/60/wKgJRlkSqZDhk91lAGRUrTBrkio274.m4a\r\n杀人之门28$http://audio.xmcdn.com/group26/M09/69/60/wKgJRlkSqZbSKH2gAFNeh0ddrdE550.m4a\r\n杀人之门29$http://audio.xmcdn.com/group27/M02/66/37/wKgJR1kSqbWQp8nvAJYdOUPkwwk503.m4a\r\n杀人之门30$http://audio.xmcdn.com/group26/M08/6A/2B/wKgJWFkSqcbxWCNnAJMLnieZoQI424.m4a\r\n杀人之门31$http://audio.xmcdn.com/group27/M02/66/45/wKgJW1kSqb2ziZnzAEpEHkZHTEQ350.m4a\r\n杀人之门32$http://audio.xmcdn.com/group26/M08/6A/2B/wKgJWFkSqcfgFFyPAFYNvtcLk_0633.m4a\r\n杀人之门33$http://audio.xmcdn.com/group27/M06/66/46/wKgJW1kSqdLgE8JkAEfCdB6vvOw844.m4a\r\n杀人之门34$http://audio.xmcdn.com/group27/M06/66/46/wKgJW1kSqdyAo0anAFiwJF19_gc044.m4a\r\n杀人之门35$http://audio.xmcdn.com/group27/M06/66/3C/wKgJR1kSqfvDY7JXAGxg5znx6rs573.m4a\r\n杀人之门36（文石听友群；160066051）$http://audio.xmcdn.com/group26/M00/8D/0F/wKgJWFkVIbagD5t1AGkuA4yv5sQ326.m4a\r\n杀人之门37（文石听友群；160066051）$http://audio.xmcdn.com/group26/M00/8C/41/wKgJRlkVIc7yGNiTAE4Ed1tHXOE545.m4a\r\n杀人之门38（文石听友群；160066051）$http://audio.xmcdn.com/group27/M04/89/56/wKgJW1kVIeyDAnVOAE8y-NitJJs238.m4a\r\n杀人之门39（文石听友群；160066051）$http://audio.xmcdn.com/group27/M04/89/47/wKgJR1kVIhjyMqIJAF75KsyGRRE918.m4a\r\n杀人之门40（文石听友群；160066051）$http://audio.xmcdn.com/group27/M08/89/49/wKgJR1kVIlbwjiaEAF2FqD8XSBo703.m4a\r\n杀人之门41（文石听友群；160066051）$http://audio.xmcdn.com/group27/M08/89/4D/wKgJR1kVIn2gi07_AEh7b8I-A38756.m4a\r\n杀人之门42（文石听友群；160066051）$http://audio.xmcdn.com/group26/M08/8C/4D/wKgJRlkVIrLATUM-AGQnKKvIxfU537.m4a\r\n杀人之门43（文石听友群；160066051）$http://audio.xmcdn.com/group26/M04/8C/53/wKgJRlkVIw_xriybAGe7y2N5Ppw097.m4a\r\n杀人之门44（文石听友群；160066051）$http://audio.xmcdn.com/group26/M06/8C/5A/wKgJRlkVI1ChxNyYAFDGyKmg1Vc531.m4a\r\n杀人之门45（文石听友群；160066051）$http://audio.xmcdn.com/group27/M09/89/5C/wKgJR1kVI7ShkcXAAGWWREzdIOQ188.m4a\r\n杀人之门46$http://audio.xmcdn.com/group26/M07/8F/89/wKgJWFkVSq2AEoMFAHaPXYdMLzQ309.m4a\r\n杀人之门47$http://audio.xmcdn.com/group26/M07/8F/88/wKgJWFkVSqmgc9xhAF-1IQ60PMI914.m4a\r\n杀人之门48（文石听友群；160066051）$http://audio.xmcdn.com/group29/M00/FE/15/wKgJXVkmWeygwIBwAAFNvHoZyU8768.m4a', 'xml_8023', '4715', '', '0', '', '1.0', 1, 0, 0, 0, 'sharenzhimendongyeguiwuwanben', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(181, 15, '驱邪之恶灵猎人[1，2部合集]', '', '未知', '', '', '', '驱邪之恶灵猎人1有声小说介绍: 我叫冯喆，性别男，年龄26，苏州人。职业么，从表面上看，是开首饰店的。但我其实还有另外一个隐藏的职业，就，就是“中间人”。也就说通常说的是“捉鬼人”或者说是“懂方术的”。', 'http://imagev2.xmcdn.com/group40/M04/55/0B/wKgJVFrC7OTy-WgNAADPVlCpFBc135.bmp', '', 1530072261, 10, 0, 0, 0, 0, 1, 1, 3, 3, 'ting', '', '26730_1_0$http://audio.xmcdn.com/group41/M02/2A/3B/wKgJ8VrLCZOg92M9AHEHzehAvVw392.m4a\r\n26730_1_1$http://audio.xmcdn.com/group41/M02/2C/C2/wKgJ8lrLCZSD6EoHAHAqEUK7lak651.m4a\r\n26730_1_2$http://audio.xmcdn.com/group41/M02/2C/C5/wKgJ8lrLCaDAHI2EAG9fbGBo47c051.m4a\r\n26730_1_3$http://audio.xmcdn.com/group41/M02/2A/3D/wKgJ8VrLCZvDxAVnAG8TEcdc2vY308.m4a\r\n26730_1_4$http://audio.xmcdn.com/group41/M02/2A/3E/wKgJ8VrLCaCxXvbrAHALNwdaQKM686.m4a\r\n26730_1_5$http://audio.xmcdn.com/group41/M02/2A/3F/wKgJ8VrLCaagoogAAG_-BE0r_Pw424.m4a\r\n26730_1_6$http://audio.xmcdn.com/group41/M02/2A/40/wKgJ8VrLCaqSoInFAG9z-Yi59rQ090.m4a\r\n26730_1_7$http://audio.xmcdn.com/group40/M04/F2/38/wKgJVFrLCa-xn1GUAG7yv1qgoxE470.m4a\r\n26730_1_8$http://audio.xmcdn.com/group40/M04/F2/39/wKgJVFrLCbHDcqTxAG9YSFWORi4112.m4a\r\n26730_1_9$http://audio.xmcdn.com/group40/M04/F1/67/wKgJT1rLCbzQMAEOAG98yj1pWv0346.m4a\r\n26730_1_10$http://audio.xmcdn.com/group40/M04/F1/6A/wKgJT1rLCcrSFU7fAHAxZ8FhQD8005.m4a\r\n26730_1_11$http://audio.xmcdn.com/group42/M09/28/85/wKgJ81rLCeDjt3QfAG-URlHzwuM967.m4a\r\n26730_1_12$http://audio.xmcdn.com/group40/M04/F2/3E/wKgJVFrLCcySnWcrAG_zu-Q7p8w231.m4a\r\n26730_1_13$http://audio.xmcdn.com/group40/M04/F1/6A/wKgJT1rLCdHTHunxAHHhHgDChAg393.m4a\r\n26730_1_14$http://audio.xmcdn.com/group42/M09/28/84/wKgJ81rLCdagukTBAHAZ568ela0447.m4a\r\n26730_1_15$http://audio.xmcdn.com/group40/M05/F2/3F/wKgJVFrLCeGijLw6AG8XdyaKAsE051.m4a\r\n26730_1_16$http://audio.xmcdn.com/group40/M05/F1/6B/wKgJT1rLCeTjelslAG9TrMVJpL8765.m4a\r\n26730_1_17$http://audio.xmcdn.com/group40/M05/F1/6C/wKgJT1rLCeuws5ThAHBHcCzark4130.m4a\r\n26730_1_18$http://audio.xmcdn.com/group40/M05/F2/41/wKgJVFrLCe-hLEXBAG9GdH3VjHI257.m4a\r\n26730_1_19$http://audio.xmcdn.com/group40/M05/F1/6E/wKgJT1rLCfXRoS-qAHHs3hWcN4s213.m4a\r\n26730_1_20$http://audio.xmcdn.com/group40/M05/F2/43/wKgJVFrLCfqzHqa9AG94YJPgIpM228.m4a\r\n26730_1_21$http://audio.xmcdn.com/group40/M05/F2/44/wKgJVFrLCgDQ6JTNAHAhQC72qJ4269.m4a\r\n26730_1_22$http://audio.xmcdn.com/group40/M05/F1/70/wKgJT1rLCgTSrxo1AG8cFPXNEFA752.m4a\r\n26730_1_23$http://audio.xmcdn.com/group40/M05/F2/46/wKgJVFrLCgiCJ3OBAG-BMXjaxog051.m4a\r\n26730_1_24$http://audio.xmcdn.com/group40/M05/F2/46/wKgJVFrLCgyA9wDgAG8hwIqLMMA106.m4a\r\n26730_1_25$http://audio.xmcdn.com/group41/M0B/2A/43/wKgJ8VrLChnAkUeQAG6znDECO18564.m4a\r\n26730_1_26$http://audio.xmcdn.com/group41/M0B/2C/C9/wKgJ8lrLChaR0oQlAG_2qpuc5dQ316.m4a\r\n26730_1_27$http://audio.xmcdn.com/group41/M0B/2A/45/wKgJ8VrLCiPh1dt9AHAfyXzws9w799.m4a\r\n26730_1_28$http://audio.xmcdn.com/group41/M0B/2C/CB/wKgJ8lrLCiCCJiK4AG8x58UkxUs694.m4a\r\n26730_1_29$http://audio.xmcdn.com/group41/M0B/2A/45/wKgJ8VrLCiXSs8gKAG_SLAUAe3E298.m4a\r\n26730_1_30$http://audio.xmcdn.com/group42/M0A/28/86/wKgJ81rLCiqA6HtzAHC_2DDl5cw096.m4a\r\n26730_1_31$http://audio.xmcdn.com/group42/M0A/28/87/wKgJ81rLCi2DA9B_AG85PDgMAyY566.m4a\r\n26730_1_32$http://audio.xmcdn.com/group42/M0A/28/89/wKgJ81rLCjqhh3leAG6TT5FbBhg975.m4a\r\n26730_1_33$http://audio.xmcdn.com/group42/M0A/2D/61/wKgJ9FrLCjigzprIAG9SNBpaipI445.m4a\r\n26730_1_34$http://audio.xmcdn.com/group41/M0B/2A/46/wKgJ8VrLCj2ww8N-AG926G37ClQ688.m4a\r\n26730_1_35$http://audio.xmcdn.com/group41/M0B/2A/47/wKgJ8VrLCkPzt5iLAG9AljJ5ASU137.m4a\r\n26730_1_36$http://audio.xmcdn.com/group41/M0B/2A/47/wKgJ8VrLCkWj6AilAG_H5NWlumw403.m4a\r\n26730_1_37$http://audio.xmcdn.com/group41/M0B/2C/D1/wKgJ8lrLClngFifWAG9ZirL7DAY453.m4a\r\n26730_1_38$http://audio.xmcdn.com/group41/M0B/2A/4C/wKgJ8VrLCl3AFhVsAG__e7vMlUk075.m4a\r\n26730_1_39$http://audio.xmcdn.com/group42/M0B/2D/66/wKgJ9FrLCnTic-Z8AG-nYPkzRg4756.m4a\r\n26730_1_40$http://audio.xmcdn.com/group42/M00/2D/66/wKgJ9FrLCoaj8oSgAG-CqGDeTd4764.m4a\r\n26730_1_41$http://audio.xmcdn.com/group40/M02/F1/74/wKgJT1rLCpWB9pPfAG_-BOM_giE634.m4a\r\n26730_1_42$http://audio.xmcdn.com/group40/M02/F1/76/wKgJT1rLCqLjS3hTAG_aw7Mc4ks112.m4a\r\n26730_1_43$http://audio.xmcdn.com/group40/M02/F1/79/wKgJT1rLCriQ1rUNAG9E_OvkqlA306.m4a\r\n26730_1_44$http://audio.xmcdn.com/group42/M03/2D/8A/wKgJ9FrLDPiB0fNdAG8pFfO0egg371.m4a\r\n26730_1_45$http://audio.xmcdn.com/group42/M03/2D/8B/wKgJ9FrLDP6CvE1kAG9Alt4ihTY790.m4a\r\n26730_1_46$http://audio.xmcdn.com/group42/M03/28/B2/wKgJ81rLDQOxcZUSAHAYbzr0bxs560.m4a\r\n26730_1_47$http://audio.xmcdn.com/group42/M03/2D/8C/wKgJ9FrLDQbwP_feAG_4WABw8n4486.m4a\r\n26730_1_48$http://audio.xmcdn.com/group41/M05/2C/F5/wKgJ8lrLDRKyeUCBAG952wF1dTU097.m4a\r\n26730_1_49$http://audio.xmcdn.com/group41/M05/2C/F5/wKgJ8lrLDQ6yr3l3AG8ezWgF6_M180.m4a\r\n26730_1_50$http://audio.xmcdn.com/group41/M05/2A/71/wKgJ8VrLDRGi3_KbAG_xAggsJ38803.m4a\r\n26730_1_51$http://audio.xmcdn.com/group41/M05/2A/73/wKgJ8VrLDSGjNgRVAHCvsiGylXg360.m4a\r\n26730_1_52$http://audio.xmcdn.com/group41/M05/2C/F8/wKgJ8lrLDR3S8GEPAG_iHVZtFoQ576.m4a\r\n26730_1_53$http://audio.xmcdn.com/group41/M05/2C/FC/wKgJ8lrLDTDgUr02AHBZDsUXv6A606.m4a\r\n26730_1_54$http://audio.xmcdn.com/group41/M05/2A/74/wKgJ8VrLDSThIx5QAHB2omE9RSk105.m4a\r\n26730_1_55$http://audio.xmcdn.com/group41/M05/2A/75/wKgJ8VrLDSuhkERBAG-wLa7Zw44387.m4a\r\n26730_1_56$http://audio.xmcdn.com/group42/M05/2D/8D/wKgJ9FrLDTbQ3w9GAG8Y7_pujsQ455.m4a\r\n26730_1_57$http://audio.xmcdn.com/group42/M05/2D/8D/wKgJ9FrLDTShOC6zAG9s2eQksyI169.m4a\r\n26730_1_58$http://audio.xmcdn.com/group42/M05/2D/8E/wKgJ9FrLDTmCedVxAG_jyhkSDGc040.m4a\r\n26730_1_59$http://audio.xmcdn.com/group42/M05/2D/8F/wKgJ9FrLDT3y669WAHBahWbhI8Y470.m4a\r\n26730_1_60$http://audio.xmcdn.com/group42/M05/28/B7/wKgJ81rLDUCwyO-VAG-zHEm6Zt0117.m4a\r\n26730_1_61$http://audio.xmcdn.com/group40/M06/F2/6F/wKgJVFrLDUnxNmmlAHF17QkXRCE225.m4a\r\n26730_1_62$http://audio.xmcdn.com/group40/M06/F1/99/wKgJT1rLDUygJdhHAHAurueVJsU144.m4a\r\n26730_1_63$http://audio.xmcdn.com/group40/M06/F2/70/wKgJVFrLDVHz7iW7AG9Du8yrN9k282.m4a\r\n26730_1_64$http://audio.xmcdn.com/group40/M06/F2/71/wKgJVFrLDVWymKzfAHBF9ELzr5U376.m4a\r\n26730_1_65$http://audio.xmcdn.com/group42/M05/28/B8/wKgJ81rLDVvyQ07rAHCvsufb2uI439.m4a\r\n26730_1_66$http://audio.xmcdn.com/group42/M07/2D/93/wKgJ9FrLDV2CTqr6AHCbIH_fKHk701.m4a\r\n26730_1_67$http://audio.xmcdn.com/group42/M05/28/B9/wKgJ81rLDWKjBouKAG-gBzf-cfY349.m4a\r\n26730_1_68$http://audio.xmcdn.com/group40/M08/F1/9B/wKgJT1rLDWWyTmOoAHASxwlsyNM580.m4a\r\n26730_1_69$http://audio.xmcdn.com/group40/M08/F2/72/wKgJVFrLDWmyLS15AHABKftl7Pc772.m4a\r\n26730_1_70$http://audio.xmcdn.com/group40/M08/F1/9E/wKgJT1rLDXahiDSEAG-URvatZQI914.m4a\r\n26730_1_71$http://audio.xmcdn.com/group40/M08/F1/9E/wKgJT1rLDXWTYPSYAG_vVQ5cvbo865.m4a\r\n26730_1_72$http://audio.xmcdn.com/group40/M08/F2/74/wKgJVFrLDXeCvyWvAG9VIyzRVt4310.m4a\r\n26730_1_73$http://audio.xmcdn.com/group40/M08/F1/A1/wKgJT1rLDYPzrQDBAHAPohhwcMg365.m4a\r\n26730_1_74$http://audio.xmcdn.com/group40/M08/F1/A0/wKgJT1rLDX-SzAWMAHEMM4grfz8635.m4a\r\n26730_1_75$http://audio.xmcdn.com/group40/M08/F2/77/wKgJVFrLDYSQ1IM7AG_Ev_HyJjw087.m4a\r\n26730_1_76$http://audio.xmcdn.com/group40/M08/F2/78/wKgJVFrLDYmgGjhTAG8dVR0n3rc481.m4a\r\n26730_1_77$http://audio.xmcdn.com/group40/M08/F2/79/wKgJVFrLDYqAthqGAG-hfqfqLQk932.m4a\r\n26730_1_78$http://audio.xmcdn.com/group40/M08/F1/A3/wKgJT1rLDZDjh7LyAG-BZ61ZPwE304.m4a\r\n26730_1_79$http://audio.xmcdn.com/group42/M01/2D/96/wKgJ9FrLDaHTJDIVAG9z-ZORFtA057.m4a\r\n26730_1_80$http://audio.xmcdn.com/group42/M01/2D/95/wKgJ9FrLDZnj0RyYAG8Y7z6OHMI430.m4a\r\n26730_1_81$http://audio.xmcdn.com/group42/M01/2D/95/wKgJ9FrLDZzzXpbbAG9uG0wOWVc092.m4a\r\n26730_1_82$http://audio.xmcdn.com/group42/M01/2D/96/wKgJ9FrLDZ_xg7xaAG-_Ej-70Y0940.m4a\r\n26730_1_83$http://audio.xmcdn.com/group41/M00/2A/77/wKgJ8VrLDaPiKlmaAG-wLWCMzdY257.m4a\r\n26730_1_84$http://audio.xmcdn.com/group41/M00/2A/78/wKgJ8VrLDarC3_ORAG_n-xM-8i8887.m4a\r\n26730_1_85$http://audio.xmcdn.com/group41/M09/2A/79/wKgJ8VrLDcChREfmAG_cO4Ojmzc104.m4a\r\n26730_1_86$http://audio.xmcdn.com/group42/M02/28/BD/wKgJ81rLDbDTLiGMAHASkaRLJVk812.m4a\r\n26730_1_87$http://audio.xmcdn.com/group42/M01/2D/98/wKgJ9FrLDbSSYXT8AG-VvocWUgo454.m4a\r\n26730_1_88$http://audio.xmcdn.com/group40/M00/F2/7F/wKgJVFrLDgWzs61MAG9_uQT0NCc986.m4a\r\n26730_1_89$http://audio.xmcdn.com/group40/M00/F1/AB/wKgJT1rLDgrisJyHAG9_ue2taYg180.m4a\r\n26730_1_90$http://audio.xmcdn.com/group42/M04/2D/9E/wKgJ9FrLDiHyRd0dALKZehComeQ266.m4a\r\n26731_1_0$http://audio.xmcdn.com/group42/M04/2D/9B/wKgJ9FrLDhTB_P5wAG7MlDiNnWQ676.m4a\r\n26731_1_1$http://audio.xmcdn.com/group42/M04/2D/A1/wKgJ9FrLDi3RrxDFAME-YrTCZ-Q277.m4a\r\n26731_1_2$http://audio.xmcdn.com/group42/M04/2D/9E/wKgJ9FrLDiHxad-aAHI3wUpOTI4323.m4a\r\n26731_1_3$http://audio.xmcdn.com/group42/M04/2D/A1/wKgJ9FrLDi7QDd2NAG9MUsfSDQA600.m4a\r\n26731_1_4$http://audio.xmcdn.com/group42/M04/2D/A1/wKgJ9FrLDi7zhWJsAG-wLZYweN4750.m4a\r\n26731_1_5$http://audio.xmcdn.com/group42/M09/28/C7/wKgJ81rLDjCAMqNKAHM-m0mjh1c847.m4a\r\n26731_1_6$http://audio.xmcdn.com/group42/M09/28/C8/wKgJ81rLDjXD5A36AG-qT2E0Ky4016.m4a\r\n26731_1_7$http://audio.xmcdn.com/group41/M07/2A/80/wKgJ8VrLDjqQSmjJAG7-f53Kj-4353.m4a\r\n26731_1_8$http://audio.xmcdn.com/group41/M07/2D/07/wKgJ8lrLDj3RV1KSAHOFTnmLYlg827.m4a\r\n26731_1_9$http://audio.xmcdn.com/group41/M07/2D/08/wKgJ8lrLDkPxu9iMAHC-YfmTXwk231.m4a\r\n26731_1_10$http://audio.xmcdn.com/group41/M07/2A/85/wKgJ8VrLDlHSs-pmAHITDR2khOY945.m4a\r\n26731_1_11$http://audio.xmcdn.com/group41/M07/2D/09/wKgJ8lrLDkzTM6zWAG8C5rc17xM526.m4a\r\n26731_1_12$http://audio.xmcdn.com/group41/M07/2D/0B/wKgJ8lrLDlrgLnNWAG6sRkrqMos366.m4a\r\n26731_1_13$http://audio.xmcdn.com/group40/M03/F1/AC/wKgJT1rLDmGgEWOHAG7hIW1c_TU670.m4a\r\n26731_1_14$http://audio.xmcdn.com/group40/M03/F2/82/wKgJVFrLDm3zNAKnAHTZ--iZ5F8843.m4a\r\n26731_1_15$http://audio.xmcdn.com/group40/M03/F1/AF/wKgJT1rLDneCYV9pAGyaKMwI1jY336.m4a\r\n26731_1_16$http://audio.xmcdn.com/group40/M03/F2/84/wKgJVFrLDnjQjyc7AG8qw3xK5xU658.m4a\r\n26731_1_17$http://audio.xmcdn.com/group40/M03/F1/B1/wKgJT1rLDoDC7KTpAHhoM0D4Bb4628.m4a\r\n26731_1_18$http://audio.xmcdn.com/group40/M03/F1/B1/wKgJT1rLDoHwKzEKAG-wLaW3Stk620.m4a\r\n26731_1_19$http://audio.xmcdn.com/group42/M0B/28/CD/wKgJ81rLDpXTp12RAHE_lgsyqJE209.m4a\r\n26731_1_20$http://audio.xmcdn.com/group42/M00/2D/A9/wKgJ9FrLDpuzjM3QAG_zu-c6E8U084.m4a\r\n26731_1_21$http://audio.xmcdn.com/group42/M0B/28/D0/wKgJ81rLDqWioyFKAG-P4Jiaq6s405.m4a\r\n26731_1_22$http://audio.xmcdn.com/group40/M09/F1/B2/wKgJT1rLDrLzUdk4AG82TeeJFD0518.m4a\r\n26731_1_23$http://audio.xmcdn.com/group41/M08/2A/87/wKgJ8VrLDsDQm6XqAHXiFoMg-6A149.m4a\r\n26731_1_24$http://audio.xmcdn.com/group41/M08/2A/87/wKgJ8VrLDr-hAuprAHJyfhxrCDY730.m4a\r\n26731_1_25$http://audio.xmcdn.com/group41/M08/2D/0E/wKgJ8lrLDseC-s_EAHJPQrO059o722.m4a\r\n26731_1_26$http://audio.xmcdn.com/group41/M08/2D/0D/wKgJ8lrLDsKSCSNhAG3QAt0Hh0s312.m4a\r\n26731_1_27$http://audio.xmcdn.com/group41/M08/2A/89/wKgJ8VrLDsegIW1wAHD-_KpI8SM319.m4a\r\n26731_1_28$http://audio.xmcdn.com/group41/M08/2D/10/wKgJ8lrLDtLT6HDRAHHSbsXvKPk071.m4a\r\n26731_1_29$http://audio.xmcdn.com/group40/M09/F2/89/wKgJVFrLDtfw2U-HAG-boIU0UkY065.m4a\r\n26731_1_30$http://audio.xmcdn.com/group40/M09/F1/B4/wKgJT1rLDtmBn92_AHHQ90vgbA4943.m4a\r\n26731_1_31$http://audio.xmcdn.com/group40/M09/F1/B6/wKgJT1rLDuGyJV5BAHHliCLXyY4459.m4a\r\n26731_1_32$http://audio.xmcdn.com/group40/M09/F1/B8/wKgJT1rLDuii0YbxAG3xxyzQkrk474.m4a\r\n26731_1_33$http://audio.xmcdn.com/group40/M09/F2/8E/wKgJVFrLDuqAtgQJAG_mgwySQIY053.m4a\r\n26731_1_34$http://audio.xmcdn.com/group40/M09/F2/8F/wKgJVFrLDu_hctlBAHE1UjKKQ1g670.m4a\r\n26731_1_35$http://audio.xmcdn.com/group40/M09/F1/BA/wKgJT1rLDvSBoOwhAG8nnrOq-Rk527.m4a\r\n26731_1_36$http://audio.xmcdn.com/group41/M0A/2D/12/wKgJ8lrLDwzT8aCyAKs3zqrXy2Y931.m4a\r\n26731_1_37$http://audio.xmcdn.com/group42/M06/28/D6/wKgJ81rLDxzjOGZPAJ-Sv1ZQU4U887.m4a\r\n26731_1_38$http://audio.xmcdn.com/group41/M0A/2D/12/wKgJ8lrLDwzwn1OwAHKnXYYS14g416.m4a\r\n26731_1_39$http://audio.xmcdn.com/group41/M0A/2A/8D/wKgJ8VrLDxDiFayiAHAqR1fJiD8340.m4a\r\n26731_1_40$http://audio.xmcdn.com/group42/M0A/2D/AF/wKgJ9FrLDxXjPlZgAG-RjVbNTFc918.m4a\r\n26731_1_41$http://audio.xmcdn.com/group41/M03/2D/16/wKgJ8lrLDzeDDHbNAHKSz7YTRhI946.m4a\r\n26731_1_42$http://audio.xmcdn.com/group41/M03/2A/92/wKgJ8VrLDz7iOQrTAG-URumgZwU228.m4a\r\n26731_1_43$http://audio.xmcdn.com/group41/M03/2A/93/wKgJ8VrLD0LhGuYUAHIIyzaKNK0237.m4a\r\n26731_1_44$http://audio.xmcdn.com/group41/M03/2A/94/wKgJ8VrLD0eDODEGAHI8LALeAJ4718.m4a\r\n26731_1_45$http://audio.xmcdn.com/group40/M07/F2/92/wKgJVFrLD1SjVCkbAHIUhbXdD2w088.m4a\r\n26731_1_46$http://audio.xmcdn.com/group40/M07/F1/BC/wKgJT1rLD1TzsZ0PAHFFeSpC70g122.m4a\r\n26731_1_47$http://audio.xmcdn.com/group40/M07/F1/BD/wKgJT1rLD1vjKDYpAHK0lNz_SA0183.m4a\r\n26731_1_48$http://audio.xmcdn.com/group40/M07/F2/93/wKgJVFrLD1-Q195mAHC0GM8hndM749.m4a\r\n26731_1_49$http://audio.xmcdn.com/group40/M07/F2/94/wKgJVFrLD2WjoXBrAHF17W4Xx9Y752.m4a\r\n26731_1_50$http://audio.xmcdn.com/group40/M07/F1/C0/wKgJT1rLD2rjCVosAHDtXV1MIZw926.m4a\r\n26731_1_51$http://audio.xmcdn.com/group40/M07/F2/96/wKgJVFrLD3Dgl8vjAHGfC9gqmsg965.m4a\r\n26731_1_52$http://audio.xmcdn.com/group42/M02/2D/B3/wKgJ9FrLD3OhPGy1AG70bfWYWpA393.m4a\r\n26731_1_53$http://audio.xmcdn.com/group42/M03/28/DC/wKgJ81rLD4Xzvi4RAG_aw2_Tos0356.m4a\r\n26731_1_54$http://audio.xmcdn.com/group42/M02/2D/B5/wKgJ9FrLD4Dx8yedAHQcV88l5Oc187.m4a\r\n26731_1_55$http://audio.xmcdn.com/group42/M02/2D/B6/wKgJ9FrLD4TBjXjaAHDV3SDRWvc976.m4a\r\n26731_1_56$http://audio.xmcdn.com/group42/M02/2D/B8/wKgJ9FrLD5KBGHzzAHDNEGilkFI563.m4a\r\n26731_1_57$http://audio.xmcdn.com/group42/M03/28/DD/wKgJ81rLD46CAR5_AHEJRBBYYJM156.m4a\r\n26731_1_58$http://audio.xmcdn.com/group41/M00/2D/1D/wKgJ8lrLD6jiB75gAG9fbLZiaXc847.m4a\r\n26731_1_59$http://audio.xmcdn.com/group42/M03/28/DF/wKgJ81rLD5jBRMgbAG9MUriNRRw560.m4a\r\n26731_1_60$http://audio.xmcdn.com/group41/M00/2A/96/wKgJ8VrLD6HCeCYEAHP06ix2OxU778.m4a\r\n26731_1_61$http://audio.xmcdn.com/group41/M00/2A/97/wKgJ8VrLD6azaOO1AHEAqY-Rf68970.m4a\r\n26731_1_62$http://audio.xmcdn.com/group41/M00/2D/1D/wKgJ8lrLD63ys68yAG4ZbrIFjNY670.m4a\r\n26731_1_63$http://audio.xmcdn.com/group41/M00/2A/9A/wKgJ8VrLD7aTQsa1AHPV3twqT40578.m4a\r\n26731_1_64$http://audio.xmcdn.com/group41/M00/2D/20/wKgJ8lrLD72B-BOGAHCYMW7YWcg519.m4a\r\n26731_1_65$http://audio.xmcdn.com/group40/M04/F2/96/wKgJVFrLD8eTwvSaAHDFtj5XLyU281.m4a\r\n26731_1_66$http://audio.xmcdn.com/group40/M04/F2/97/wKgJVFrLD8_CfRi3AHAPokfVBrY360.m4a\r\n26731_1_67$http://audio.xmcdn.com/group41/M00/2D/20/wKgJ8lrLD72CWRhlABKb5uPdaK4785.m4a\r\n26731_1_68$http://audio.xmcdn.com/group40/M04/F2/98/wKgJVFrLD9Wj4wlUAHA0VqqGUYM690.m4a\r\n26731_1_69$http://audio.xmcdn.com/group40/M04/F1/C5/wKgJT1rLD9zxXMenAHGk6clrngk687.m4a\r\n26731_1_70$http://audio.xmcdn.com/group40/M04/F1/C6/wKgJT1rLD-CgrONSAG64At6Rgmg665.m4a\r\n26731_1_71$http://audio.xmcdn.com/group40/M04/F2/9A/wKgJVFrLD-TBMtRTAG-C3hubbBI262.m4a\r\n26731_1_72$http://audio.xmcdn.com/group42/M06/2D/BB/wKgJ9FrLD-uDpSmdAHJ52C2DCk4302.m4a\r\n26731_1_73$http://audio.xmcdn.com/group42/M06/2D/BD/wKgJ9FrLD_WCONNnAG7yv7_VUWg960.m4a\r\n26731_1_74$http://audio.xmcdn.com/group42/M06/2D/BC/wKgJ9FrLD_Si3O58AGyaKKYn95Q172.m4a\r\n26731_1_75$http://audio.xmcdn.com/group42/M06/28/E3/wKgJ81rLD_ji7mnYAG5xigVfONs497.m4a\r\n26731_1_76$http://audio.xmcdn.com/group42/M06/2D/BE/wKgJ9FrLD_6zSJacAG7kEDZ6emM932.m4a\r\n26731_1_77$http://audio.xmcdn.com/group42/M06/2D/BF/wKgJ9FrLEADjNLoDAG06bZzzvBU102.m4a\r\n26731_1_78$http://audio.xmcdn.com/group42/M06/2D/C0/wKgJ9FrLEAjyOJ--AG5PwTwqLTg530.m4a\r\n26731_1_79$http://audio.xmcdn.com/group42/M07/28/E7/wKgJ81rLEA6gYEPkAG82TQvi4hk568.m4a\r\n26731_1_80$http://audio.xmcdn.com/group41/M06/2D/22/wKgJ8lrLEBqx8h6FAG-6dp9oLgg794.m4a\r\n26731_1_81$http://audio.xmcdn.com/group42/M06/2D/C2/wKgJ9FrLEBTCh4eaAHFuzS0yMlc624.m4a\r\n26731_1_82$http://audio.xmcdn.com/group41/M06/2A/9C/wKgJ8VrLEBqQUynyAHFwD8KCGxU259.m4a\r\n26731_1_83$http://audio.xmcdn.com/group41/M06/2D/23/wKgJ8lrLEB_CefgqAHGZLfX3aPI202.m4a\r\n26731_1_84$http://audio.xmcdn.com/group41/M06/2D/23/wKgJ8lrLECTQOP9BAHGWOtWoqcc527.m4a\r\n26731_1_85$http://audio.xmcdn.com/group40/M06/F1/C9/wKgJT1rLEEuAET1RAHFROfQ5-Qc566.m4a\r\n26731_1_86$http://audio.xmcdn.com/group40/M06/F1/C9/wKgJT1rLEE_x9zSrAG_KnauiRpw493.m4a\r\n26731_1_87$http://audio.xmcdn.com/group40/M06/F2/9F/wKgJVFrLEFOADjEIAG9oOb4PZqk736.m4a\r\n26731_1_88$http://audio.xmcdn.com/group40/M06/F2/A0/wKgJVFrLEFrC1GMGAG9_ue30Qys965.m4a\r\n26731_1_89$http://audio.xmcdn.com/group40/M06/F2/A1/wKgJVFrLEF_xjuvCAG-wLTaiBe8026.m4a\r\n26731_1_90$http://audio.xmcdn.com/group41/M08/2A/A2/wKgJ8VrLEGWizy8YAHAfyYo_tGg657.m4a\r\n26731_1_91$http://audio.xmcdn.com/group41/M08/2D/2C/wKgJ8lrLEHrixg4MAHAW-NiPIxM836.m4a\r\n26731_1_92$http://audio.xmcdn.com/group41/M08/2A/A4/wKgJ8VrLEG-D9s-mAHB9-G2iQSw508.m4a\r\n26731_1_93$http://audio.xmcdn.com/group41/M08/2D/2A/wKgJ8lrLEHGBOdM1AG9mwbIidQg341.m4a\r\n26731_1_94$http://audio.xmcdn.com/group41/M08/2D/2C/wKgJ8lrLEHixastoAG3HMadiLDA753.m4a\r\n26731_1_95$http://audio.xmcdn.com/group42/M01/28/E9/wKgJ81rLEH3AeWRgAG3QAg1TZk4599.m4a\r\n26731_1_96$http://audio.xmcdn.com/group42/M01/28/EA/wKgJ81rLEIPT61D1AG65evUgN0A313.m4a\r\n26731_1_97$http://audio.xmcdn.com/group42/M01/2D/C5/wKgJ9FrLEIezYWG7AG5qMDIUP-0326.m4a\r\n26731_1_98$http://audio.xmcdn.com/group40/M0B/F2/A2/wKgJVFrLEJPSVxEwAG2vsaJqoDU685.m4a\r\n26731_1_99$http://audio.xmcdn.com/group40/M0B/F1/D0/wKgJT1rLEJ3RrwUvAGykcSBOVbw065.m4a\r\n26731_1_100$http://audio.xmcdn.com/group40/M0B/F1/CF/wKgJT1rLEJqQBCiHAG3jTs64UsE271.m4a\r\n26731_1_101$http://audio.xmcdn.com/group42/M01/28/EB/wKgJ81rLEJ-Db9dnAG64AhEeMv4648.m4a\r\n26731_1_102$http://audio.xmcdn.com/group42/M08/2D/C8/wKgJ9FrLEKajxb3qAG0FXSc6p0A512.m4a\r\n26731_1_103$http://audio.xmcdn.com/group42/M01/28/ED/wKgJ81rLEKqSctvAAG3UaRcCcLc524.m4a\r\n26731_1_104$http://audio.xmcdn.com/group41/M04/2D/2D/wKgJ8lrLELCxNaWTAHEa4_ezSHk545.m4a\r\n26731_1_105$http://audio.xmcdn.com/group41/M01/2A/A8/wKgJ8VrLELLjknsqAG-gBxg52hk078.m4a\r\n26731_1_106$http://audio.xmcdn.com/group41/M04/2D/2E/wKgJ8lrLELWj-ab0AG1_PZFq2DE066.m4a\r\n26731_1_107$http://audio.xmcdn.com/group42/M08/2D/C9/wKgJ9FrLELqz2qQbAG6h_pSqk6k065.m4a\r\n26731_1_108$http://audio.xmcdn.com/group42/M09/28/EF/wKgJ81rLEMCCWAX2AG7tF1YfNtk730.m4a\r\n26731_1_109$http://audio.xmcdn.com/group40/M02/F1/D1/wKgJT1rLEMyh-DspAG6ghmk89aM079.m4a\r\n26731_1_110$http://audio.xmcdn.com/group42/M09/28/F0/wKgJ81rLEMihfetcAG7G6KNbAjY136.m4a\r\n26731_1_111$http://audio.xmcdn.com/group40/M02/F1/D0/wKgJT1rLEMyzk8gGAG2Q2_9CPa4049.m4a\r\n26731_1_112$http://audio.xmcdn.com/group40/M02/F2/A5/wKgJVFrLENDAsvCxAG2p0071kFw194.m4a\r\n26731_1_113$http://audio.xmcdn.com/group41/M02/2A/A9/wKgJ8VrLEN_zDmh3AG4DZrDxWf4815.m4a\r\n26731_1_114$http://audio.xmcdn.com/group41/M02/2A/A8/wKgJ8VrLENzQKsRQAG6En5SLwtY868.m4a\r\n26731_1_115$http://audio.xmcdn.com/group41/M04/2D/2F/wKgJ8lrLEODBpxFqAG1vFhlS0Is247.m4a\r\n26731_1_116$http://audio.xmcdn.com/group42/M0B/28/F2/wKgJ81rLEPfScd2kAG4t_J5o8o0224.m4a\r\n26731_1_117$http://audio.xmcdn.com/group41/M02/2A/AB/wKgJ8VrLEOrwVIpPAG3u2Duvz7c612.m4a\r\n26731_1_118$http://audio.xmcdn.com/group41/M04/2D/32/wKgJ8lrLEO_j0refAG2IDmrNVTQ450.m4a\r\n26731_1_119$http://audio.xmcdn.com/group42/M0B/28/F1/wKgJ81rLEPKwdsbHAGxGrQIVloU573.m4a\r\n26731_1_120$http://audio.xmcdn.com/group42/M0B/28/F2/wKgJ81rLEPjQoWdyAG-gB_Uj39A938.m4a\r\n26731_1_121$http://audio.xmcdn.com/group42/M0A/2D/CE/wKgJ9FrLEP7A_9EAAHCisEbPqVU153.m4a\r\n26731_1_122$http://audio.xmcdn.com/group42/M0B/28/F3/wKgJ81rLEQHRcFSBAG8QHnrD8fY261.m4a\r\n26731_1_123$http://audio.xmcdn.com/group42/M0B/28/F4/wKgJ81rLEQbiZJ5AAGsj7HwY2vc446.m4a\r\n26731_1_124$http://audio.xmcdn.com/group40/M05/F1/D5/wKgJT1rLERPho4BjAG8qjfZYecs737.m4a\r\n26731_1_125$http://audio.xmcdn.com/group40/M05/F2/A9/wKgJVFrLEQ_T1QN5AG8qjfKpEPw118.m4a\r\n26731_1_126$http://audio.xmcdn.com/group40/M05/F2/AA/wKgJVFrLERWB0jFzAHA0Viri2oA263.m4a\r\n26731_1_127$http://audio.xmcdn.com/group41/M04/2A/AD/wKgJ8VrLERrAp4rIAHGBrSo8WUE634.m4a\r\n26731_1_128$http://audio.xmcdn.com/group41/M04/2A/AD/wKgJ8VrLERzxY9o7AG_By2nXEY8285.m4a\r\n26731_1_129$http://audio.xmcdn.com/group40/M05/F1/D8/wKgJT1rLETyApyBEAG8OpsimEHY616.m4a\r\n26731_1_130$http://audio.xmcdn.com/group40/M05/F2/AC/wKgJVFrLETqAJkcDAG6yJL-t0Hs224.m4a\r\n26731_1_131$http://audio.xmcdn.com/group40/M05/F2/AD/wKgJVFrLEUDg3whnAG4vc0CBre0515.m4a\r\n26731_1_132$http://audio.xmcdn.com/group42/M0B/28/F5/wKgJ81rLEVWDuJdtAG5tH2QiSKQ457.m4a\r\n26731_1_133$http://audio.xmcdn.com/group40/M05/F2/AF/wKgJVFrLEUvhTJ7iAG2m5EKk_AU079.m4a\r\n26731_1_134$http://audio.xmcdn.com/group42/M0B/28/F5/wKgJ81rLEVegUbqTAG6sRnGe9z0792.m4a\r\n26731_1_135$http://audio.xmcdn.com/group42/M0B/28/F5/wKgJ81rLEVnABAUgAG-CqF3C-6s231.m4a\r\n26731_1_136$http://audio.xmcdn.com/group42/M0B/28/F5/wKgJ81rLEVqDJw7nAGzZhWgeI5Q728.m4a\r\n26731_1_137$http://audio.xmcdn.com/group41/M02/2D/37/wKgJ8lrLEWvAvqupAJtSkH44sW8573.m4a', 'xml_8023', '4710', '', 'Q', '', '1.0', 9, 0, 0, 0, 'quxiezhielinglieren12buheji', ''),
(182, 15, '有点吓人的小说《蚀骨药香》', '', '未知', '', '', '', '这些年，总有人质疑中医的真实性。楼主在中药店呆了好几年了，接下来就说说见过的诡异、神奇甚至恐怖的事。你们真以为，药材就是些虫壳、草根么？你们真的以为，中医就是把脉，问诊啥的就行了么？你们真的以为，中药都是给活人用的？', 'http://imagev2.xmcdn.com/group37/M07/58/95/wKgJoVo-dHOSVFzpAAHLFdSJ9uE926.png', '', 1530072261, 6, 0, 0, 0, 0, 1, 1, 7, 3, 'ting', '', '第1章 奇怪的药铺“药香”（求评论）$http://audio.xmcdn.com/group37/M0B/59/22/wKgJoFo-eASCriCmAI_syJrRqcs399.m4a\r\n第2章 诡异的张坤$http://audio.xmcdn.com/group36/M04/65/FE/wKgJUlo-eDnheFvRAI0mEKPEc_o529.m4a\r\n第3章 索命男孩$http://audio.xmcdn.com/group36/M09/80/64/wKgJUlo_MG3SBdE-AJPBspepK2g053.m4a\r\n第4章 师姐许诺$http://audio.xmcdn.com/group36/M03/99/7E/wKgJUlo_nFSx4ekQAJN5vpxH6Ec691.m4a\r\n第5章 张家祠堂$http://audio.xmcdn.com/group37/M00/72/D4/wKgJoVo_nKngLv_ZAJJ6PiVzEi4186.m4a\r\n第6章 沉重棺木$http://audio.xmcdn.com/group37/M02/72/D7/wKgJoVo_nMagCP5yAI_uP9T2EUQ110.m4a\r\n第7章 室友二胖$http://audio.xmcdn.com/group37/M02/72/E2/wKgJoFo_nOShRvdbAJOlzJYitqY889.m4a\r\n第8章 道士离奇死亡$http://audio.xmcdn.com/group37/M00/8A/10/wKgJoVpA0CmxGcX2AJDTVIz9JWA937.m4a\r\n第9章 诈骗水鬼$http://audio.xmcdn.com/group36/M02/0A/E6/wKgJTVpA0EDjhfa_AJKNU36Jjuc484.m4a\r\n第10章 亡道士不是王道士$http://audio.xmcdn.com/group37/M08/8A/16/wKgJoVpA0E_QkR-0AJJeVw4hC9w776.m4a\r\n第11章 奇怪的瞎眼老太太$http://audio.xmcdn.com/group36/M00/DC/AB/wKgJUlpCOfjwmwMnAJOIbVZ05zQ457.m4a\r\n第12章 大难不死还有下回$http://audio.xmcdn.com/group37/M03/A9/92/wKgJoVpCOgrCCvVsAJIw0mB8aM4450.m4a\r\n第13章 好戏临门$http://audio.xmcdn.com/group36/M08/DF/32/wKgJUlpCRcySAGJDAJGyhz3b4Xw393.m4a\r\n第14章 喜帖丧帖$http://audio.xmcdn.com/group37/M01/AC/11/wKgJoVpCRe7ji1stAJHxqsC8yps294.m4a\r\n第15章 杨家大宅$http://audio.xmcdn.com/group36/M0A/FB/82/wKgJUlpDiLvBAC8YAJRUisZHYEg374.m4a\r\n第16章 奔波寻鬼$http://audio.xmcdn.com/group37/M06/C8/21/wKgJoVpDiNPyzmF3AJNMOY_WaZI362.m4a\r\n第17章 王蒙卒$http://audio.xmcdn.com/group36/M0B/FB/89/wKgJUlpDiPnz4AgBAJEA2dyWXCg312.m4a\r\n第18章 谁是厉鬼$http://audio.xmcdn.com/group37/M07/C8/45/wKgJoVpDicOy1f3SAJOou8H681k679.m4a\r\n第19章 飞舞的木蝴蝶$http://audio.xmcdn.com/group37/M02/E1/B3/wKgJoFpEwY-CbdoiAI_YOut-pzY551.m4a\r\n第20章 安钱子引路$http://audio.xmcdn.com/group37/M05/E1/BD/wKgJoFpEwcjBRrYJAIz6Ay6Z7Vc182.m4a\r\n第21章 符文斗鬼$http://audio.xmcdn.com/group36/M0A/15/3A/wKgJUlpEwpTAyl4TAJG-R8lCH5I103.m4a\r\n第22章 杨府阴婚$http://audio.xmcdn.com/group37/M04/E1/CE/wKgJoVpEwrHhJ6lkAJH78z9CgZc709.m4a\r\n第23章 不识好人心$http://audio.xmcdn.com/group36/M0B/83/D3/wKgJTVpGPdHwwrwSAJPNc-jWqOE517.m4a\r\n第24章 苗疆蛊虫$http://audio.xmcdn.com/group36/M0B/83/D5/wKgJTVpGPdmz0sipAJOtJbFLmG8371.m4a\r\n第25章 我不是吃货$http://audio.xmcdn.com/group36/M0B/36/11/wKgJUlpGPfOSJWpXAJHP5RDecx8490.m4a\r\n第26章 棺材再现$http://audio.xmcdn.com/group36/M0B/36/15/wKgJUlpGPgKBSXlGAJD1GbHxox0943.m4a\r\n第27章 棺材的秘密$http://audio.xmcdn.com/group36/M0A/61/C5/wKgJUlpIhwmgTmrAAJF_JKGxlBw663.m4a\r\n第28章 云归索命$http://audio.xmcdn.com/group36/M08/AF/91/wKgJTVpIhxSiqx2TAJMCzdGue48125.m4a\r\n第29章 七叶回魂花$http://audio.xmcdn.com/group36/M00/61/C9/wKgJUlpIhx6jDXd0AJEbSUAR8sk433.m4a\r\n第30章 十三尸咒$http://audio.xmcdn.com/group36/M08/AF/95/wKgJTVpIhyjRS1YIAJN-JapDleM693.m4a\r\n第31章 药香师$http://audio.xmcdn.com/group37/M09/2E/02/wKgJoFpIh3WSn_6RAJNpl1cUjOo841.m4a\r\n第32章 血魂痴咒$http://audio.xmcdn.com/group37/M02/2E/07/wKgJoVpIh8GzhlbkAJEW4kS7lNs071.m4a\r\n第33章 无头道士$http://audio.xmcdn.com/group36/M06/AF/A8/wKgJTVpIiBjAlYavAI49Ea9jm9U788.m4a\r\n第34章 前因后果$http://audio.xmcdn.com/group37/M00/2E/0E/wKgJoVpIiEqwJMrPAJCIcWbuZl4010.m4a\r\n第35章 杨民杨$http://audio.xmcdn.com/group41/M0A/B7/FF/wKgJ8lqadauzGmnnAIpTzy1eaG8362.m4a\r\n第36章 回归药香铺$http://audio.xmcdn.com/group41/M05/B8/06/wKgJ8lqadfGRvyTZAJOXHD3cmTo132.m4a\r\n第37章 蛊铃清脆$http://audio.xmcdn.com/group41/M06/B4/C2/wKgJ8Vqadi3COcHAAIvOcVWgrz4845.m4a\r\n第38章 吓跑酒鬼$http://audio.xmcdn.com/group41/M0B/B8/14/wKgJ8lqadnHyPpNJAJPEoaydvFU373.m4a\r\n第39章 四点了$http://audio.xmcdn.com/group42/M03/B5/6B/wKgJ9FqadsKhwQFsAJNa6GC-rKg646.m4a\r\n第40章 转世投胎$http://audio.xmcdn.com/group41/M0A/B8/29/wKgJ8lqadw3jPs-MAI3oG9qkHyA926.m4a\r\n第41章 第十三只鬼又回来了$http://audio.xmcdn.com/group42/M09/B5/81/wKgJ9Fqad3DzL5wlAJMu20oZy3M958.m4a\r\n第42章 线索出现$http://audio.xmcdn.com/group42/M0A/B6/8C/wKgJ81qad6vxTENaAJNSF7qQMas461.m4a\r\n第43章 人鬼难分$http://audio.xmcdn.com/group36/M01/2C/42/wKgJTVpN-P2zAuCRAIqLYiy-Nh8022.m4a\r\n第44章 无辜之说$http://audio.xmcdn.com/group37/M01/AA/9A/wKgJoVpN-ReBxXNtAJMFvHWsMZ8519.m4a\r\n第45章 鬼村$http://audio.xmcdn.com/group37/M01/AA/9D/wKgJoVpN-SOxVUC_AJLJiJ8-5cw289.m4a\r\n第46章 初次对话$http://audio.xmcdn.com/group37/M01/AA/9E/wKgJoVpN-SXjQbnvAJJy5FSy-4Y483.m4a\r\n第47章 师哥师姐$http://audio.xmcdn.com/group36/M0B/DE/AF/wKgJUlpN-1Kjxe0yAJJZ8NSwKPo136.m4a\r\n第48章 尸王$http://audio.xmcdn.com/group36/M0B/DE/B1/wKgJUlpN-1-BjslcAI58NKs_QXs781.m4a\r\n第49章 百年冤案$http://audio.xmcdn.com/group37/M02/AA/DC/wKgJoVpN-2zBsD9GAJM8EoSDD1Q624.m4a\r\n第50章 化解误会$http://audio.xmcdn.com/group37/M02/AA/DE/wKgJoVpN-3Pi_aXPAJHqVQDlOUo331.m4a\r\n第51章 棺材中人$http://audio.xmcdn.com/group36/M01/00/48/wKgJUlpPca_iNQ4tAI-_QuB7iKA366.m4a\r\n第52章 僵尸李董$http://audio.xmcdn.com/group37/M02/CC/5C/wKgJoFpPccWAPHz4AJOwFPyk0WA134.m4a\r\n第53章 大清密文$http://audio.xmcdn.com/group37/M02/CC/5E/wKgJoFpPccnil5QHAJHhhIzfoWA734.m4a\r\n第54章 生死一线$http://audio.xmcdn.com/group37/M02/CC/5E/wKgJoFpPccvB_QcfAJK_P8yde94550.m4a\r\n第55章 归来吧$http://audio.xmcdn.com/group36/M05/22/7C/wKgJUlpQ29-h3hQoAJCM1-FW3H0433.m4a\r\n第56章 尸王复苏$http://audio.xmcdn.com/group36/M06/22/89/wKgJUlpQ3AOAhVdMAJE4p-SYtZs925.m4a\r\n第57章 当心身边人$http://audio.xmcdn.com/group36/M06/22/89/wKgJUlpQ3AOSlmH1AJKI7X9vWxY714.m4a\r\n第58章 四分之三$http://audio.xmcdn.com/group37/M04/EE/B5/wKgJoVpQ3B7yNzOOAJKKZLEr3vg277.m4a\r\n第59章 蜡烛熄灭$http://audio.xmcdn.com/group37/M01/0B/4B/wKgJoVpSFMXTYxXOAI-wk2CHx6Q992.m4a\r\n第60章 谜团解开$http://audio.xmcdn.com/group37/M01/0B/1C/wKgJoFpSFNWBpVeNAJRQJNMHPLY691.m4a\r\n第61章 缝尸$http://audio.xmcdn.com/group36/M09/3F/34/wKgJUlpSFPuS8kG9AJHl7oGKKxE730.m4a\r\n第62章 推心置腹$http://audio.xmcdn.com/group36/M01/3F/3A/wKgJUlpSFQ6ixObDAJIPCQmaSmg380.m4a\r\n第63章 诡异的人头$http://audio.xmcdn.com/group37/M01/26/0F/wKgJoFpTVrjijesJAJHtRP_Spbw662.m4a\r\n第64章 车祸现场$http://audio.xmcdn.com/group36/M0A/A7/9F/wKgJTVpTVsWgqilVAJRBdYLbUOk285.m4a\r\n第65章 秘密处理$http://audio.xmcdn.com/group37/M09/26/18/wKgJoFpTVuigEO58AI4ioo-hRN0025.m4a\r\n第66章 回药香铺$http://audio.xmcdn.com/group37/M02/26/77/wKgJoVpTVvuBCJfAAJGJaEZdz10189.m4a\r\n第67章 谁更不正常$http://audio.xmcdn.com/group36/M07/7B/24/wKgJUlpUvvKT3rPkAJFqkxwcOUI920.m4a\r\n第68章 降头术$http://audio.xmcdn.com/group37/M0A/47/6E/wKgJoFpUvwDQHzrTAJO-wz4UAmE436.m4a\r\n第69章 许诺收鬼$http://audio.xmcdn.com/group37/M00/47/88/wKgJoFpUv4eQBiySAJI2sDK0KQY793.m4a\r\n第70章 幻鬼上门$http://audio.xmcdn.com/group37/M00/47/94/wKgJoFpUv6XBxy5VAJMaTdYYE2Y545.m4a\r\n第71章 炼鬼阵$http://audio.xmcdn.com/group17/M0A/E0/4E/wKgJKVpV8Jqxcc95AJNt_q6MYeg271.m4a\r\n第72章 误会$http://audio.xmcdn.com/group17/M0A/DF/FB/wKgJJFpV8KTxAwJ5AJLsyEUAUjA026.m4a\r\n第73章 熬人头$http://audio.xmcdn.com/group31/M08/AF/F1/wKgJSVpV8OCD0GcjAJN2z1HeY7Q841.m4a\r\n第74章 重大变故$http://audio.xmcdn.com/group20/M07/DF/C7/wKgJJ1pV8P2TP0UcAJO18lbyp0M129.m4a\r\n第75章 二楼有鬼$http://audio.xmcdn.com/group25/M02/F7/EC/wKgJMVpXOjCzCKqdAJK2ct7TNmE750.m4a\r\n第76章 屋里屋外$http://audio.xmcdn.com/group36/M00/84/9D/wKgJUlpXOj6yHpN_AJNDaMEoDYw427.m4a\r\n第77章 镇宅符$http://audio.xmcdn.com/group24/M0B/01/3F/wKgJNVpXOzbTI58YAJDk8nEHn70813.m4a\r\n第78章 镇宅符很难$http://audio.xmcdn.com/group34/M09/4F/2E/wKgJYFpXO0HiJm5jAJC71JQUoYc316.m4a\r\n第79章 三百年前$http://audio.xmcdn.com/group33/M09/7D/65/wKgJTFpYiHyj-ReEAJP_XtJYMtc877.m4a\r\n第80章 小黄书$http://audio.xmcdn.com/group21/M08/03/02/wKgJKFpYiInzoCRuAJQSeHB0jLc363.m4a\r\n第81章 连环梦$http://audio.xmcdn.com/group21/M08/03/08/wKgJKFpYiKbT9779AJFOrPmifGs017.m4a\r\n第82章 梦照进现实$http://audio.xmcdn.com/group21/M08/03/0B/wKgJKFpYiLCDohMAAJJivZWgIRA987.m4a\r\n第83章 尸王再现$http://audio.xmcdn.com/group22/M05/08/C0/wKgJLlpaCPTi-VchAJJhRocwuxo549.m4a\r\n第84章 记者柳清雪$http://audio.xmcdn.com/group22/M05/08/C3/wKgJLlpaCPzQ5O4dAJI1OJKZ2aA020.m4a\r\n第85章 扬北古镇$http://audio.xmcdn.com/group36/M03/D8/06/wKgJTVpaCSXidZXUAJHObltQ30Q871.m4a\r\n第86章 天下第一客栈$http://audio.xmcdn.com/group36/M03/D8/09/wKgJTVpaCS6CraBOAJJtBpb4d9I845.m4a\r\n第87章 客栈惊魂$http://audio.xmcdn.com/group24/M01/09/DC/wKgJNVpbZbyC1zeFAJNJSsGiFJ0110.m4a\r\n第88章 花中门$http://audio.xmcdn.com/group35/M06/3A/C0/wKgJnFpbZe2CsErfAJJ-pMmniwY262.m4a\r\n第89章 地骨皮的作用$http://audio.xmcdn.com/group26/M02/14/68/wKgJWFpbZeWBLy-8AJKjXN63WVI359.m4a\r\n第90章 柳香楼$http://audio.xmcdn.com/group26/M02/13/97/wKgJRlpbZeOAADIOAJIfM0-oj04315.m4a\r\n第91章 婉柔欺人$http://audio.xmcdn.com/group19/M05/EF/F4/wKgJJlpd8mOjCWJFAIu4bKes7Ck060.m4a\r\n第92章 天尸骨琴$http://audio.xmcdn.com/group25/M03/1B/2E/wKgJNlpd8oDRqShWAJKqsiV0Pw8713.m4a\r\n第93章 谎鬼说谎$http://audio.xmcdn.com/group24/M0A/0E/DA/wKgJNVpd8pey8HSwAJOnQ_3E2S8676.m4a\r\n第94章 客栈火起$http://audio.xmcdn.com/group26/M01/18/AA/wKgJRlpd8qGCY6SsAJEPiP9f4pk499.m4a\r\n第95章 生辰八字$http://audio.xmcdn.com/group36/M0A/E2/73/wKgJTVpfMwKhXdaZAJMnhY7p3MI415.m4a\r\n第96章 上茅山$http://audio.xmcdn.com/group32/M07/9C/74/wKgJS1pfMxKTe6GyAJLxL-haYcI828.m4a\r\n第97章 山神庙$http://audio.xmcdn.com/group17/M0A/F2/E0/wKgJKVpfM67jf_OtAJKQQmcC0k8728.m4a\r\n第98章 血雨腥风$http://audio.xmcdn.com/group31/M01/C2/8A/wKgJSVpfM77jqYPyAJLxL17IIys644.m4a\r\n第99章 无头乌鸦$http://audio.xmcdn.com/group20/M04/F3/73/wKgJLFpghKjQ8ZYWAJQljgf8PNY844.m4a\r\n第100章 无字灵牌$http://audio.xmcdn.com/group28/M07/93/C0/wKgJXFpghLeiC5GVAJP8b6t6Sxk403.m4a\r\n第101章 无头僵尸$http://audio.xmcdn.com/group19/M08/F5/47/wKgJJlpghMfxkVpqAJKwkI9B3WU296.m4a\r\n第102章 骗术$http://audio.xmcdn.com/group28/M0B/93/C2/wKgJXFpghNGhOFhZAJPwr1CmLD8528.m4a\r\n第103章 许诺死了？$http://audio.xmcdn.com/group38/M07/07/93/wKgJo1ph063hxKM3AJQCTRlRkBI962.m4a\r\n第104章 厉鬼墓大门$http://audio.xmcdn.com/group38/M08/07/9C/wKgJolph07fh6K2fAJAXXvQyQIE703.m4a\r\n第105章 两个电话$http://audio.xmcdn.com/group39/M0B/07/BC/wKgJnlph09bhCcp4AJIDTR257do641.m4a\r\n第106章 是人是鬼$http://audio.xmcdn.com/group39/M0B/07/98/wKgJn1ph0-qRdP47AJQcvS38PRg926.m4a\r\n第107章 穿墙长舌鬼$http://audio.xmcdn.com/group39/M06/2D/06/wKgJnlpjUALAmukBAJJ0XKC59L0441.m4a\r\n第108章 林颖要心$http://audio.xmcdn.com/group39/M0A/2C/FC/wKgJn1pjUITSyV0EAJOwFNyukYQ292.m4a\r\n第109章 奇异小蛇$http://audio.xmcdn.com/group38/M0A/2C/D8/wKgJolpjUDnQxI_FAJRC7Crqiis062.m4a\r\n第110章 真假师姐$http://audio.xmcdn.com/group38/M0A/2C/E0/wKgJolpjUFDxCGgIAJPk7-oZEY0458.m4a\r\n第111章 金丝楠木门$http://audio.xmcdn.com/group41/M03/A6/BF/wKgJ8lrd-Mmje4A-AJPTUT3ejIQ300.m4a\r\n第112章 医院走廊$http://audio.xmcdn.com/group41/M03/A6/B8/wKgJ8lrd-LnRjoq-AJDL-5U7mqQ195.m4a\r\n第113章 原来如此$http://audio.xmcdn.com/group39/M02/84/43/wKgJn1pnCqOQl_91AJNmqL_uhaY956.m4a\r\n第114章 三百年前$http://audio.xmcdn.com/group38/M03/84/29/wKgJolpnCwOTZrRhAJJW_XJQhzY692.m4a\r\n第115章 杨民杨？$http://audio.xmcdn.com/group38/M05/84/AB/wKgJolpnDnSBXIUhAIxIVUDYYO4846.m4a\r\n第116章 六口棺材$http://audio.xmcdn.com/group39/M08/84/D8/wKgJn1pnDt3BOV7aAJJZ8AGC3jo726.m4a\r\n第117章 白易阳尸体$http://audio.xmcdn.com/group38/M04/AB/BA/wKgJo1pogBmhzD81AJIiIt3-r_0905.m4a\r\n第118章 成婚$http://audio.xmcdn.com/group39/M04/AB/BF/wKgJn1pogCSA8PWsAJHdHUK7cVY745.m4a\r\n第119章 拜堂$http://audio.xmcdn.com/group38/M05/CD/A2/wKgJolpp3vjgrCohAJB-KD9gTlU692.m4a\r\n第120章 阴婚成$http://audio.xmcdn.com/group39/M00/CD/E1/wKgJn1pp3wrCsHH1AJNVCr3IaVw214.m4a\r\n第121章 婉柔怀孕$http://audio.xmcdn.com/group38/M00/CD/FC/wKgJolpp4N_wY-OuAJIU67Fzm_g958.m4a\r\n第122章 三件事$http://audio.xmcdn.com/group38/M04/CE/2A/wKgJo1pp4PfQ5US9AJLQ4Yxmm_0000.m4a\r\n第123章 怨气报复$http://audio.xmcdn.com/group39/M00/E8/48/wKgJn1prFY6TEQRdAJGz_xBAjMw081.m4a\r\n第124章 劝解怨气$http://audio.xmcdn.com/group39/M00/E8/5B/wKgJnlprFZnBgQ0uAJMOjWafk9U124.m4a\r\n第125章 叶城死于厉鬼墓$http://audio.xmcdn.com/group39/M00/E8/63/wKgJnlprFbrDpXn8AJBNtADvquU727.m4a\r\n第126章 安魂铃$http://audio.xmcdn.com/group38/M09/E8/07/wKgJolprFcfSd0vnAJDyKnoPd7I974.m4a\r\n第127章 又见红疤男$http://audio.xmcdn.com/group38/M00/05/1E/wKgJolpsaEyzkP0DAJHo3Z2_FpA503.m4a\r\n第128章 如此李伟$http://audio.xmcdn.com/group38/M00/05/20/wKgJolpsaFTxwQZCAJMHNFSfOnc397.m4a\r\n第129章 九爷胤禟$http://audio.xmcdn.com/group39/M06/05/7E/wKgJnlpsaHKSZwuTAJAS9zJk6tE751.m4a\r\n第130章 白逸才的人头$http://audio.xmcdn.com/group39/M06/05/6C/wKgJn1psaHjA4u8GAJNw8Z3T3o4286.m4a\r\n第131章 九死一生$http://audio.xmcdn.com/group39/M04/23/75/wKgJn1ptpGij1CTxAJA2NDAkXXg876.m4a\r\n第132章 师姐何在$http://audio.xmcdn.com/group39/M04/23/78/wKgJn1ptpHaRVHqmAJFBdDKhzLs945.m4a\r\n第133章 善恶二魂斗$http://audio.xmcdn.com/group39/M0B/23/F1/wKgJnlptpfmCyaLmAJIq8JBsXjM964.m4a\r\n第134章 茅山弟子显踪迹$http://audio.xmcdn.com/group38/M02/23/7E/wKgJo1ptpgHjxDFSAJEDyLwt0RE327.m4a\r\n第135章 和谐号$http://audio.xmcdn.com/group38/M01/53/24/wKgJolpvMy2xwrsXAJJOMA8duEM040.m4a\r\n第136章 车上有鬼$http://audio.xmcdn.com/group38/M02/53/4B/wKgJo1pvMzahF_c2AJQMlhMG6sw462.m4a\r\n第137章 碎尸$http://audio.xmcdn.com/group38/M02/53/41/wKgJo1pvMxqhwTQ2AJRdW6pdafI098.m4a\r\n第138章 降伏女鬼$http://audio.xmcdn.com/group38/M01/53/21/wKgJolpvMyOBoGnTAJNAeeaH_mI465.m4a\r\n第139章 三年$http://audio.xmcdn.com/group38/M05/6F/38/wKgJo1pwaWzxsOl3AIj2G-fxTQE285.m4a\r\n第140章 叶家$http://audio.xmcdn.com/group38/M05/6F/42/wKgJo1pwaYOyea13AJEfrzAed9c940.m4a\r\n第141章 七脉回魂针$http://audio.xmcdn.com/group38/M02/6F/4F/wKgJo1pwaaLDOVHuAJQnBfsDsw8148.m4a\r\n第142章 夜半哭声$http://audio.xmcdn.com/group38/M02/6F/54/wKgJo1pwabGDJDx9AJPq0YaNZM0708.m4a\r\n第143章 白衣女鬼再现身$http://audio.xmcdn.com/group38/M0A/94/7B/wKgJolpx1BShCQGWAJGFAm82ZWQ813.m4a\r\n第144章 姚雨其人$http://audio.xmcdn.com/group38/M0A/94/A9/wKgJo1px1Crg5jFWAJN7Nlo2miA338.m4a\r\n第145章 女鬼来历$http://audio.xmcdn.com/group39/M06/94/FB/wKgJn1px1FSy-RKIAJEFQLMPQhw683.m4a\r\n第146章 寻魂草 痴魂蝶$http://audio.xmcdn.com/group38/M01/94/82/wKgJolpx1F-g_f_NAJPk75dAsY4083.m4a\r\n第147章 叶城身世$http://audio.xmcdn.com/group38/M05/B5/04/wKgJo1pzKh_g8YuNAJQGuL-MYuw886.m4a\r\n第148章 深夜斗法$http://audio.xmcdn.com/group39/M0B/B5/8F/wKgJnlpzKiPAhdRHAJKHdecGl4c631.m4a\r\n第149章 蛇头是谁$http://audio.xmcdn.com/group39/M06/B5/AB/wKgJnlpzKsbCQjqkAJGg6c5nMEs479.m4a\r\n第150章 蛇头是他$http://audio.xmcdn.com/group39/M06/B5/A8/wKgJnlpzKrqRjGG0AJJ4xqmXwr8760.m4a\r\n第151章 叶城百鬼斗叶斌$http://audio.xmcdn.com/group39/M07/CE/C0/wKgJnlp0WQDAdvhdAJQofVzjtK4150.m4a\r\n第152章 万寿宫$http://audio.xmcdn.com/group39/M07/CE/7C/wKgJn1p0WQbAS0I1AIz88h2pZt0270.m4a\r\n第153章 全真道士$http://audio.xmcdn.com/group39/M03/CF/40/wKgJn1p0XT2QRInVAJIfMyhnYBI934.m4a\r\n第154章 炼化魂魄$http://audio.xmcdn.com/group38/M09/CE/CB/wKgJo1p0XW_RF6ALAJKTMZ0DvmE770.m4a\r\n第155章 分手陈景浩$http://audio.xmcdn.com/group39/M04/F6/F1/wKgJn1p10s2AoviaAJJ6Pt_23q4855.m4a\r\n第156章 雅布刚$http://audio.xmcdn.com/group39/M04/F7/44/wKgJnlp10tbRZRAeAJJ3TxinYqM366.m4a\r\n第157章 辟邪剑$http://audio.xmcdn.com/group39/M08/F7/43/wKgJn1p11TbDwCo4AJH6e1kjdiE751.m4a\r\n第158章 机场见闻$http://audio.xmcdn.com/group39/M08/F7/44/wKgJn1p11TyTEItyAJG4aSI8q7c542.m4a\r\n第159章 重刑犯$http://audio.xmcdn.com/group38/M06/18/89/wKgJo1p3JHSRXaEPAJPBsuRTlfs530.m4a\r\n第160章 生死两不知$http://audio.xmcdn.com/group38/M06/18/89/wKgJo1p3JHKw0ElCAIqxkqAtcMI568.m4a\r\n第161章 会合$http://audio.xmcdn.com/group39/M08/18/FC/wKgJn1p3JJ2QQCn3AJD4CBatBds490.m4a\r\n第162章 弯的否？$http://audio.xmcdn.com/group39/M08/19/60/wKgJnlp3JKTAuhLhAJDn4VSreSo989.m4a\r\n第163章 赶尸道人$http://audio.xmcdn.com/group39/M06/C3/A4/wKgJnlp9tMKgMBmQAJH0nRpiVLs354.m4a\r\n第164章 柳清雪来了$http://audio.xmcdn.com/group39/M06/C3/A6/wKgJnlp9tMzCVf7cAI3gjygefLo272.m4a\r\n第165章 又一张照片$http://audio.xmcdn.com/group39/M07/DE/9F/wKgJn1p-7bWjUNoLAI7HGDdqQ44104.m4a\r\n第166章 仙鹤道人$http://audio.xmcdn.com/group39/M07/DE/A2/wKgJn1p-7b6wEWfdAJCedQY7WE0024.m4a\r\n第167章 药香与茅山$http://audio.xmcdn.com/group38/M05/FC/B6/wKgJo1qAJKiRWeasAJAOkWMeIzs247.m4a\r\n第168章 陈景浩的小秘密$http://audio.xmcdn.com/group39/M00/FE/1F/wKgJnlqAJOqxpBuBAJDXu2B7-tg384.m4a\r\n第169章 尸毒$http://audio.xmcdn.com/group38/M0B/BC/A6/wKgJo1qShx_wmdiIAJOhZYuDrqQ802.m4a\r\n第170章 奇怪的小女孩$http://audio.xmcdn.com/group24/M09/28/7C/wKgJNVqShybxfxW4AJC3bYIvZtU545.m4a\r\n第171章 槐怀苑$http://audio.xmcdn.com/group42/M08/12/15/wKgJ81qUCVSzNyx2AJEv1vEs6Fc926.m4a\r\n第172章 溥仁$http://audio.xmcdn.com/group42/M00/12/2B/wKgJ81qUCc_RTOUqAJKQQt56cUI931.m4a\r\n第173章 还有这回事$http://audio.xmcdn.com/group42/M06/32/FE/wKgJ9FqVX4KBDA8cAJDDLcOzF1E080.m4a\r\n第174章 故宫难离$http://audio.xmcdn.com/group42/M06/33/93/wKgJ81qVX3WgHMnRAJRBdbLHDo8628.m4a\r\n第175章 生死符咒$http://audio.xmcdn.com/group42/M02/FB/A6/wKgJ9FqdQKmhXM5bAJKyC4j_LB0407.m4a\r\n第176章 药香铺斗法$http://audio.xmcdn.com/group41/M06/FB/59/wKgJ8VqdQLbxNnacAJJbaMRBsXc395.m4a\r\n第177章 红济堂$http://audio.xmcdn.com/group42/M00/1B/EB/wKgJ9FqelaTDNlUMAJNTk_iQP0I014.m4a\r\n第178章 火焚子弹蚁$http://audio.xmcdn.com/group42/M0B/1B/FF/wKgJ9Fqeld_yc2SMAJFe0rd0wPY091.m4a\r\n第179章 治病救人$http://audio.xmcdn.com/group41/M04/38/08/wKgJ8VqftgqC8276AJLlb0rzSqM799.m4a\r\n第180章 吴言身世$http://audio.xmcdn.com/group40/M00/05/C3/wKgJVFqf4A_hPaxiAJMbxQjt5gQ519.m4a\r\n第181章 吴言的回忆$http://audio.xmcdn.com/group41/M09/4F/54/wKgJ8VqhDw3CXDKGAJLDqhE41_c907.m4a\r\n第182章 白薇儿$http://audio.xmcdn.com/group40/M04/17/74/wKgJVFqhD0nBWWwfAJRBdYHTIYo110.m4a\r\n第183章 鬼蛊$http://audio.xmcdn.com/group40/M02/17/8E/wKgJVFqhECKil4ZCAJLZrsZDsyY709.m4a\r\n第184章 黑裙苗女$http://audio.xmcdn.com/group41/M02/4F/71/wKgJ8VqhEGeA3r3iAJO-w4KfvlI993.m4a\r\n第185章 郁桐现身$http://audio.xmcdn.com/group40/M03/2B/C4/wKgJT1qiYATgR5lRAJBKxWFrIr0227.m4a\r\n第186章 生死一线$http://audio.xmcdn.com/group42/M0B/64/A3/wKgJ9FqiYESxSfx-AJNSTZ0ydvU176.m4a\r\n第187章 原来如此$http://audio.xmcdn.com/group40/M00/2B/CF/wKgJT1qiYMOyYnH4AJIlEqu2kY8480.m4a\r\n第188章 七符六诏$http://audio.xmcdn.com/group42/M02/64/B3/wKgJ9FqiYSyRyJ3RAJKvGGCaOsM191.m4a\r\n第189章 痛饮无忌$http://audio.xmcdn.com/group41/M06/7D/C7/wKgJ8Vqj2PWAwEHmAJN1V69ZwGg387.m4a\r\n第190章 三里屯$http://audio.xmcdn.com/group41/M08/80/BC/wKgJ8lqj2bqTRnXdAJLrTTnIo08769.m4a\r\n第191章 又回酒吧$http://audio.xmcdn.com/group41/M06/80/A4/wKgJ8lqj2QbBggqJAJLuQMGFxqY642.m4a\r\n第192章 陈凡师兄$http://audio.xmcdn.com/group42/M04/7E/4F/wKgJ9Fqj2diQsDFlAJQofRfxgp0996.m4a\r\n第193章 白夜婆婆$http://audio.xmcdn.com/group42/M03/8D/5E/wKgJ9Fqk0diTMAMWAJOlzF_obLs477.m4a\r\n第194章 鬼门关$http://audio.xmcdn.com/group40/M04/54/4F/wKgJT1qk0jTT52M9AJAet_A7z3g589.m4a\r\n第195章 钓鱼$http://audio.xmcdn.com/group42/M09/8E/5B/wKgJ81qk1FPyWl3pAJO71N4XCmc146.m4a\r\n第196章 白夜和白易阳$http://audio.xmcdn.com/group42/M04/8E/60/wKgJ81qk1Mag6KT3AJQLHsX3nAY425.m4a\r\n第197章 珊瑚留字$http://audio.xmcdn.com/group41/M09/A8/F6/wKgJ8lqmUWGAIRd3AJQxTm_ojk8336.m4a\r\n第198章 跑跑跑$http://audio.xmcdn.com/group42/M09/A7/7E/wKgJ81qmUdLiG2MDAJLlbxifnbU773.m4a\r\n第199章 死胖子言同尘$http://audio.xmcdn.com/group41/M02/A8/F7/wKgJ8lqmUWXwdm6KAJFRnzoO5So766.m4a\r\n第200章 侗鱼族$http://audio.xmcdn.com/group42/M0B/A7/7E/wKgJ81qmUdSwMcpTAJIR_GZs_kM056.m4a\r\n第201章 穿越时空$http://audio.xmcdn.com/group41/M05/BF/0C/wKgJ8lqnnfDxgaekAJLSWQnsnyk282.m4a\r\n第202章 密诏现身$http://audio.xmcdn.com/group41/M01/BC/65/wKgJ8VqnnmPCrLEmAJR9qRFnsPw742.m4a\r\n第203章 真假陈景皓$http://audio.xmcdn.com/group40/M02/84/F0/wKgJVFqnoJPAz1FDAJPWQE6mFbo015.m4a\r\n第204章 戏耍鱼人$http://audio.xmcdn.com/group40/M07/84/FA/wKgJVFqnoT2TXmvUAJPQmJwZ1vY022.m4a\r\n第205章 许诺怎么了？$http://audio.xmcdn.com/group41/M01/D3/82/wKgJ8Vqo_LjTlUa5AJEOEZVhA2M942.m4a\r\n第206章 回归$http://audio.xmcdn.com/group40/M09/9A/CC/wKgJT1qo_TWwfuZ6AJQ1tHGuaxo486.m4a\r\n第207章 珍妃井$http://audio.xmcdn.com/group42/M05/D5/F4/wKgJ9FqpCg2SKuGBAJRC7FCdf1k695.m4a\r\n第208章 又见十三尸咒$http://audio.xmcdn.com/group40/M06/9C/33/wKgJT1qpCZmz6_VmAJNJgPLeC_U568.m4a\r\n第209章 宁寿宫$http://audio.xmcdn.com/group40/M07/B3/E7/wKgJT1qqXSSQdkR3AJE7lhDzEhg983.m4a\r\n第210章 斗珍妃$http://audio.xmcdn.com/group41/M05/EF/3B/wKgJ8lqqXNHxOoWjAJKOy5MbOiU943.m4a\r\n第211章 死光光$http://audio.xmcdn.com/group42/M02/EE/13/wKgJ9FqqYaWDldCYAI6MW19K6VU785.m4a\r\n第212章 光绪皇帝$http://audio.xmcdn.com/group40/M0A/B4/99/wKgJT1qqYSvhYSjxAJN7bF0LhW8250.m4a\r\n第213章 老太婆$http://audio.xmcdn.com/group41/M06/03/A1/wKgJ8Vqrtc2g5rLWAJMY1mw3dqg337.m4a\r\n第214章 乌雅氏$http://audio.xmcdn.com/group42/M0A/04/54/wKgJ9FqrtVrQvAhXAJPz1Gj-r-g393.m4a\r\n第215章 佛禅$http://audio.xmcdn.com/group41/M05/03/D5/wKgJ8VqrtzjAIlpzAJOULfKJP4Q998.m4a\r\n第216章 鬼胎$http://audio.xmcdn.com/group40/M00/CC/17/wKgJVFqrtsOAmcugAJNd13LzOIE791.m4a\r\n第217章 安魂铃丢了$http://audio.xmcdn.com/group40/M00/FA/69/wKgJT1quVsvi7Ia_AJQuW74_Tqs921.m4a\r\n第218章 龌龊的全真道士$http://audio.xmcdn.com/group41/M01/33/29/wKgJ8VquVoKzmRKCAJJW_aen1fY998.m4a\r\n第219章 房间有鬼$http://audio.xmcdn.com/group42/M09/4D/CA/wKgJ9FqvsTfCi582AIobyw72QSU528.m4a\r\n第220章 猫灵$http://audio.xmcdn.com/group42/M05/4D/CD/wKgJ81qvsK2jOwpdAJRBdYTWm1M223.m4a\r\n第221章 同学陈亮$http://audio.xmcdn.com/group41/M02/54/16/wKgJ8lqvy8jRE4RmAJLfxjS74NY828.m4a\r\n第222章 又见无头乌鸦$http://audio.xmcdn.com/group40/M0A/19/AC/wKgJVFqvy4eicF_0AJBPYb68JN8364.m4a\r\n第223章 白逸才的人头$http://audio.xmcdn.com/group42/M01/69/A1/wKgJ9FqxHCfT_GygAJFktXkuNa0063.m4a\r\n第224章 三个秘密$http://audio.xmcdn.com/group42/M00/69/BD/wKgJ81qxG26T-6nxAJQv1gblRiI388.m4a\r\n第225章 招魂坛$http://audio.xmcdn.com/group41/M01/90/79/wKgJ8lqzgwXR3ov1AJMbxeElUuE854.m4a\r\n第226章 怨灵$http://audio.xmcdn.com/group41/M08/8D/C0/wKgJ8VqzgqHj62XEAJQnBTGbnrg303.m4a\r\n第227章 我和我$http://audio.xmcdn.com/group41/M08/41/E6/wKgJ8lq-UTLQY0onAJIw0qjaXtA301.m4a\r\n第228章 钓猫$http://audio.xmcdn.com/group40/M0B/07/AE/wKgJVFq-UQ2BYu1kAJNrD1lsI4I272.m4a\r\n第229章 纱笼$http://audio.xmcdn.com/group41/M00/85/AB/wKgJ8lrCL1vCVdqcAJN-JbOSNxk087.m4a\r\n第230章 猫灵谈判$http://audio.xmcdn.com/group42/M07/81/98/wKgJ81rCLtTDZ9AJAJKHdZY3Mwg370.m4a\r\n第231章 奇怪的病症$http://audio.xmcdn.com/group40/M09/A6/D9/wKgJT1rHC6fAYRGgAJOJ5fmnYII736.m4a\r\n第232章 百年前$http://audio.xmcdn.com/group41/M07/DF/70/wKgJ8VrHDACjV6pUAJOi3XmwZyE725.m4a\r\n第233章 到底谁是谁$http://audio.xmcdn.com/group40/M0A/C9/BB/wKgJT1rItpSBUxvTAJQJpzzd-60198.m4a\r\n第234章 不一样的师姐$http://audio.xmcdn.com/group41/M08/05/04/wKgJ8lrItv7gfopsAJMFvGb4P0A141.m4a\r\n第235章 小红护主$http://audio.xmcdn.com/group40/M00/E0/B3/wKgJT1rKB03j8_xIAJPrBz3YPrU658.m4a\r\n第236章 景阳宫$http://audio.xmcdn.com/group40/M09/E1/82/wKgJVFrKB6ziyEWDAJFNaputIwE297.m4a\r\n第237章 吴叔来电$http://audio.xmcdn.com/group40/M06/10/D2/wKgJVFrMm3zQ30QgAJQPhY3AiXk795.m4a\r\n第238章 灵异小说作家$http://audio.xmcdn.com/group41/M07/B4/42/wKgJ8lrR6q_DLq1tAJPDKs1mjl8326.m4a\r\n第239章 净身$http://audio.xmcdn.com/group42/M05/D2/E1/wKgJ9FrTRW3hqFe8AI_xMik7iEo133.m4a\r\n第240章 阿鲁特氏$http://audio.xmcdn.com/group41/M0A/02/6C/wKgJ8VrV0ejAFEFcAJRkseAJ9xY821.m4a\r\n第241章 智激女鬼$http://audio.xmcdn.com/group41/M0B/1A/FF/wKgJ8lrXFkGRzZxnAJQW313LrPA303.m4a\r\n第242章 一番苦斗$http://audio.xmcdn.com/group40/M04/06/B1/wKgJVFrYsAjw63fuAJDyKjpXhlU085.m4a', 'xml_8023', '4711', '', 'Y', '', '1.0', 1, 0, 0, 0, 'youdianxiarendexiaoshuoshiguyaoxiang', '');
INSERT INTO `gxl_ting` (`ting_id`, `ting_cid`, `ting_name`, `ting_title`, `ting_keywords`, `ting_color`, `ting_anchor`, `ting_author`, `ting_content`, `ting_pic`, `ting_language`, `ting_addtime`, `ting_hits`, `ting_hits_day`, `ting_hits_week`, `ting_hits_month`, `ting_hits_lasttime`, `ting_stars`, `ting_status`, `ting_up`, `ting_down`, `ting_play`, `ting_server`, `ting_url`, `ting_inputer`, `ting_reurl`, `ting_jumpurl`, `ting_letter`, `ting_skin`, `ting_gold`, `ting_golder`, `ting_length`, `reid`, `HasGetComment`, `ting_letters`, `ting_total`) VALUES
(183, 15, '步入恐惧', '', '未知', '', '', '', '催更粉丝交流群：689283820                                 喜欢请点赞、评论、赞助感谢您的支持 ~ ~如果喜欢记得点订阅！更新就自动有提示！                  支持我们请多：打赏，点赞，评论，分享，订阅我们噢！每集听完记得动动手指点个赞！有礼物走一个也是极好的！各位书友要是觉得还不错的话请不要忘记向您QQ群和微博里的朋友推荐哦！如果你愿意分享你自己的故事，我们将录制关于你的故事，给更多人分享不一样的生活感悟。赶紧私信我们吧，接下来一起来听听我为你们分享小说吧！听我为你们分享小说吧！', 'http://imagev2.xmcdn.com/group42/M00/F0/7E/wKgJ81qc6QuDz6ebAACHg0OV8iM933.jpg', '', 1530072261, 4, 0, 0, 0, 0, 1, 1, 6, 7, 'ting', '', '001 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F3/1E/wKgJ8lqc9q3ymmiDAG_Hrv352Jg735.m4a\r\n002 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F0/1A/wKgJ8Vqc9rbx4DyLAGKZNqzXPEk322.m4a\r\n003 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F0/91/wKgJ9Fqc9sPwxcPLAGKvP6ttaGk654.m4a\r\n004 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F0/1C/wKgJ8Vqc9ufB59faAGRaj0Fvx5k351.m4a\r\n005 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F0/1C/wKgJ8Vqc9ueS9FGBAGRgbUrssng267.m4a\r\n006 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/BC/wKgJ81qc9wTDPOZtAFy2l-7Lau0597.m4a\r\n007 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F0/23/wKgJ8Vqc9yexUegRAFyfG58y8hc293.m4a\r\n008 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F0/A2/wKgJ9Fqc91jDTZnwAF4FZgOzpOk615.m4a\r\n009 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F0/A5/wKgJ9Fqc947h_KJKAGRHdRxEgII816.m4a\r\n010 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/D1/wKgJ81qc98iiidNQAGYhxgfRJuw333.m4a\r\n011 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F1/D5/wKgJ81qc-ACw84P3AGXPiaBvsLY450.m4a\r\n012 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F0/B5/wKgJ9Fqc-DaA8VGgAGLPjCteC6o706.m4a\r\n013 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F1/DF/wKgJ81qc-HGDBElDAGP1PCk9Si8988.m4a\r\n014 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F3/4C/wKgJ8lqc-JaiwXeQAF4qHroCvPI480.m4a\r\n015 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/51/wKgJ8Vqc-NjyKoDYAF4qHkZa0jc113.m4a\r\n016 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F1/EF/wKgJ81qc-RzgVDzuAGHNGWU7rzo951.m4a\r\n017 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F1/F8/wKgJ81qc-XChvbeCAGyLeXC4PBY542.m4a\r\n018 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F4/74/wKgJ8lqdBATQ4_fYAGk9quL_HXY337.m4a\r\n019 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/6A/wKgJ8Vqc-f7C8F28AGDPEAIKtZc879.m4a\r\n020 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F0/E3/wKgJ9Fqc-lWCbK-AAGTwVorEZPY336.m4a\r\n021 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F0/EB/wKgJ9Fqc-qDB7V6EAGcW_kdlMJc076.m4a\r\n022 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F2/17/wKgJ81qc-v6hpsSVAGU-KXhh_Vo976.m4a\r\n023 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F0/8A/wKgJ8Vqc-1bjjE22AF4i-lrb6IE485.m4a\r\n024 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F3/A0/wKgJ8lqc-6PCX5ZyAF91-cTX28U385.m4a\r\n025 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F2/34/wKgJ81qc-_KwVEzEAGDfN3YxtSA432.m4a\r\n026 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F1/16/wKgJ9Fqc_DjzBjnlAGp0-Hsoy5Y081.m4a\r\n027 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F0/AE/wKgJ8Vqc_IuB5YjeAGb8k5UdhoQ688.m4a\r\n028 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F0/BC/wKgJ8Vqc_POiaPopAGaXQLnte9U712.m4a\r\n029 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F2/54/wKgJ81qc_TugVPyJAGaXdoR4ZT4903.m4a\r\n030 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F0/C6/wKgJ8Vqc_YijO_NTAGnEwbFBRm4170.m4a\r\n031 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F2/63/wKgJ81qc_dmTmUD-AGFQSj8Pf2w836.m4a\r\n032 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F0/DC/wKgJ8Vqc_ijTyPkzAGU_oFe-4Xg625.m4a\r\n033 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F1/4D/wKgJ9Fqc_nriSp8-AGC6f5TGAyc890.m4a\r\n034 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F2/78/wKgJ81qc_sGAl400AGKGV_W46fU410.m4a\r\n035 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F3/FC/wKgJ8lqc_xGgQqQyAF7Itn_dUkI027.m4a\r\n036 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F0/FA/wKgJ8Vqc_1aRDONiAGC-6nbKq8I488.m4a\r\n037 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F2/91/wKgJ81qc_7fgllr7AGiKhETljdQ647.m4a\r\n038 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F4/12/wKgJ8lqdAAnSAZ4KAF6GoJaXNwA649.m4a\r\n039 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F2/A1/wKgJ81qdAEGyZgwlAF6GoKQWkho809.m4a\r\n040 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F1/1B/wKgJ8VqdAI7Qf-H3AFx0hSw2IvY812.m4a\r\n041 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/8A/wKgJ9FqdAPSz_TwXAGlm_o1oaiU578.m4a\r\n042 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F4/2F/wKgJ8lqdAUCBRiq4AGCLgqp-XA8957.m4a\r\n043 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F1/91/wKgJ9FqdAYvwHNQgAGGSXOROquU259.m4a\r\n044 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F1/3E/wKgJ8VqdAeaSCBl4AGIZdCMYi5s841.m4a\r\n045 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F2/CB/wKgJ81qdAhzDUIZFAFyNfXLvck0659.m4a\r\n046 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F4/4A/wKgJ8lqdAmPiKo4HAGeolMsUgzo968.m4a\r\n047 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F1/4A/wKgJ8VqdApug1FYpAGBg7A5AQYc477.m4a\r\n048 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F2/E0/wKgJ81qdAtSTu5mxAGeoXhB3Ml0642.m4a\r\n049 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F4/5D/wKgJ8lqdAwejy7pDAGCLgteAH3E911.m4a\r\n050 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F1/B7/wKgJ9FqdAy7BJVHMAFy1ILtIcIA957.m4a\r\n051 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F3/1F/wKgJ8lqc9rng0EqmAFu3F6TpyXQ980.m4a\r\n052 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F0/92/wKgJ9Fqc9smAPyXPAF90greG7-g319.m4a\r\n053 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F0/96/wKgJ9Fqc9trCPzb9AF-sT5tZHkY481.m4a\r\n054 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F0/95/wKgJ9Fqc9tjRAosUAF5jY-sWfPM646.m4a\r\n055 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F0/1F/wKgJ8Vqc9vaTvB0sAGI5xkWV-RI912.m4a\r\n056 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/C0/wKgJ81qc9xqgDDy4AGORYWV9USI072.m4a\r\n057 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/C4/wKgJ81qc90uitXr5AGKcJb9WFKM173.m4a\r\n058 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F0/A6/wKgJ9Fqc95SgorTAAGKcJdeXP8Y094.m4a\r\n059 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F0/A8/wKgJ9Fqc97LyGcoqAFyq29uey1M501.m4a\r\n060 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F0/38/wKgJ8Vqc9_CxMvfBAGyXOaY2nC4592.m4a\r\n061 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F0/3B/wKgJ8Vqc-BrhlCqpAFaGKhc3HE8691.m4a\r\n062 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F0/B6/wKgJ9Fqc-EHSt9I0AE53AonQQvY662.m4a\r\n063 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F0/B8/wKgJ9Fqc-Gvz6vopAFOvfoGqXxc958.m4a\r\n064 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F0/4A/wKgJ8Vqc-J2RjwCDAFgZ-q0pd40461.m4a\r\n065 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F3/50/wKgJ8lqc-MPjwHlPAE8jB5M8VNw369.m4a\r\n066 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F0/C6/wKgJ9Fqc-PPxErNKAE37qliScs4433.m4a\r\n067 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F1/F1/wKgJ81qc-TDguVmuAFULTrotfWY482.m4a\r\n068 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/63/wKgJ8lqc-Yej_ST1AFbIPYpQRcw852.m4a\r\n069 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/66/wKgJ8Vqc-cnR6QSpAFRxHYPYWcg165.m4a\r\n070 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F0/DB/wKgJ9Fqc-hGi5pB0AFLV8_AkVww910.m4a\r\n071 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F0/72/wKgJ8Vqc-myjCZlhAFSEbJ1QIFI593.m4a\r\n072 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F0/ED/wKgJ9Fqc-sXxifTrAFyZOVsg3-I043.m4a\r\n073 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F0/F4/wKgJ9Fqc-w2SA1s0AFcyLHjamdI411.m4a\r\n074 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F0/8A/wKgJ8Vqc-1ejKFe6AFRWrYgd_rc942.m4a\r\n075 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F0/FE/wKgJ9Fqc-63T7Y5OAFeOsizmVuw112.m4a\r\n076 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/0D/wKgJ9Fqc-_GAnR41AFeOskLEJv4157.m4a\r\n077 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F2/3E/wKgJ81qc_DrBj-jzAFQtk7WZrs4641.m4a\r\n078 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F2/45/wKgJ81qc_HzT-tohAFJZWrZaKgs690.m4a\r\n079 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F3/C1/wKgJ8lqc_O3x1CLHAFWMiMBfiI4893.m4a\r\n080 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/29/wKgJ9Fqc_S_BFJoKAFWMiOycoFQ074.m4a\r\n081 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F2/59/wKgJ81qc_VzyBhySAFHGTKg9DGc265.m4a\r\n082 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F3/D0/wKgJ8lqc_ZbApX2TAFB49SjvyVc701.m4a\r\n083 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F1/38/wKgJ9Fqc_cyQiC30AFB49cTQm5Q886.m4a\r\n084 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F0/D7/wKgJ8Vqc_hSA_QzwAFNXLV_Xu5U013.m4a\r\n085 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F2/70/wKgJ81qc_lqScqbCAFNXLRXNWAA160.m4a\r\n086 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/E3/wKgJ8Vqc_onjhMpzAFBHClolG64596.m4a\r\n087 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F2/78/wKgJ81qc_sDjTkeOAFBHCvuc-qk562.m4a\r\n088 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F3/FA/wKgJ8lqc_wrDTCt5AFDkJh544Bk726.m4a\r\n089 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F0/FA/wKgJ8Vqc_1GjVRajAFd82cDKiUs214.m4a\r\n090 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F0/FE/wKgJ8Vqc_4-DK4MkAFRxHe01gSM868.m4a\r\n091 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F1/04/wKgJ8Vqc_8yiI6ZkAFBIt_IhhNY072.m4a\r\n092 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F4/11/wKgJ8lqdAAfTOdyWAEx67EtpRMA645.m4a\r\n093 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F1/12/wKgJ8VqdAFGT4KKxAEw3YtZXR04046.m4a\r\n094 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F4/1F/wKgJ8lqdAImDVORGAFE9uTDE77w617.m4a\r\n095 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F4/26/wKgJ8lqdAMnxcOrJAFE9uZ-q-ug216.m4a\r\n096 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F1/26/wKgJ8VqdAQTB-AW0AFRDmKltY9o091.m4a\r\n097 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F1/34/wKgJ8VqdAXCSwqBJAFLmGgDKG-w147.m4a\r\n098 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F2/BF/wKgJ81qdAavxoHP5AFTGf8J0LrY445.m4a\r\n099 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F4/47/wKgJ8lqdAffQEwpKAFO22Nc1WfQ494.m4a\r\n100 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F2/CE/wKgJ81qdAi-y7xEXAFTGf-MjfbM486.m4a\r\n101 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F0/91/wKgJ9Fqc9sPTQHclAFf-E1QQ7kk633.m4a\r\n102 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F0/94/wKgJ9Fqc9tHjHoFtAFQjSqex-MM761.m4a\r\n103 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F0/1D/wKgJ8Vqc9unz8NLLAFeFq-jx6B8570.m4a\r\n104 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F0/21/wKgJ8Vqc9v_hpQBqAE9cFwSVNGA509.m4a\r\n105 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F0/23/wKgJ8Vqc9yXjncveAFHGTKiM4ns710.m4a\r\n106 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F0/A2/wKgJ9Fqc91jBepV8AE-ocv0Ezz4032.m4a\r\n107 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F0/A3/wKgJ9Fqc94DyHJKzAFFPW6dw6pg561.m4a\r\n108 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F3/34/wKgJ8lqc96ODQ0KcAFFPW-uptcQ481.m4a\r\n109 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F0/31/wKgJ8Vqc99KQnkykAFFPW0qS5nM876.m4a\r\n110 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F0/AF/wKgJ9Fqc9_aSwnPrAFFPWx5o23E943.m4a\r\n111 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F0/3C/wKgJ8Vqc-CHCa0xRAFTGSaSRghE399.m4a\r\n112 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/40/wKgJ8Vqc-FPCoi0YAFJwoLu3nOA533.m4a\r\n113 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F0/BB/wKgJ9Fqc-H7xToK-AFZdDBaQaBA334.m4a\r\n114 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F0/BE/wKgJ9Fqc-KrwYhUgAFOyN4gVVFc864.m4a\r\n115 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/51/wKgJ8Vqc-Nvxfog6AFHE1SqyomY532.m4a\r\n116 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F1/EE/wKgJ81qc-RnR5UN9AFKxP-Z0R9I775.m4a\r\n117 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F0/CE/wKgJ9Fqc-V2TLnN2AFhZHSsrkTE543.m4a\r\n118 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F4/7D/wKgJ8lqdBFSCsEBGAFhZHce6-hA949.m4a\r\n119 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/6A/wKgJ8Vqc-gCRdRvTAFLpDQ9bna0236.m4a\r\n120 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F0/6E/wKgJ8Vqc-izCn4bcAEWmBL1LYQs996.m4a\r\n121 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F0/71/wKgJ8Vqc-mjwIruFAE9O37-9AEA160.m4a\r\n122 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F0/EB/wKgJ9Fqc-righay7AFEWFq_lZDk605.m4a\r\n123 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F3/88/wKgJ8lqc-vDjEkHaAE6wRykIi5c095.m4a\r\n124 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F2/1E/wKgJ81qc-zngWLBbAFBkaCf7VcQ148.m4a\r\n125 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F3/9C/wKgJ8lqc-4-zLSsEAFSr2VfzE3k499.m4a\r\n126 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/07/wKgJ9Fqc-9PzCvDoAFOHoWrvcpY179.m4a\r\n127 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F3/AA/wKgJ8lqc_CCT9xIHAFOH140FcZA473.m4a\r\n128 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F2/43/wKgJ81qc_HSxkwz1AFOHoUNFYZ4511.m4a\r\n129 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F1/23/wKgJ9Fqc_LTBIjPbAE8wCXVz-bE229.m4a\r\n130 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/25/wKgJ9Fqc_Rjgv11xAE8wCbNWhfs367.m4a\r\n131 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F2/59/wKgJ81qc_V2hgJoSAFRxHQJUquM497.m4a\r\n132 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F3/D3/wKgJ8lqc_aOgsutYAE-kC8z4Cfc157.m4a\r\n133 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F1/3B/wKgJ9Fqc_d2h8deMAE-kC0rWf5I850.m4a\r\n134 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/E1/wKgJ8lqc_h7DnW-5AFK_72-rZ8k898.m4a\r\n135 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F2/6E/wKgJ81qc_lHwefJcAFBf_sCajn8858.m4a\r\n136 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/E7/wKgJ8Vqc_p_hOKCWAFBf_nq3vHk737.m4a\r\n137 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F2/7D/wKgJ81qc_t-QkGEDAE5m2wbeck8302.m4a\r\n138 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/F5/wKgJ8Vqc_xryrIe-AE_zVX0Y494446.m4a\r\n139 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F4/05/wKgJ8lqc_1-RScxvAE_zVSKMY8s754.m4a\r\n140 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F4/0A/wKgJ8lqc_5vykmOBAFKAx-RYzys879.m4a\r\n141 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F4/0F/wKgJ8lqc_9uCnJVxAFBJ-Z-F14g682.m4a\r\n142 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F2/9E/wKgJ81qdADKzaR9oAFBJ-XWTamY515.m4a\r\n143 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F1/7B/wKgJ9FqdAG3QlMjQAFBJ-RWlqyo611.m4a\r\n144 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F1/20/wKgJ8VqdAMWgesMUAFBJ-Zz3_wc473.m4a\r\n145 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F4/2A/wKgJ8lqdAQKCoy4LAFOq4jc_xGw757.m4a\r\n146 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F1/31/wKgJ8VqdAWPRtC-9AE7t85WyTp4032.m4a\r\n147 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F2/BF/wKgJ81qdAajz8ue-AE9k5KfsNJM738.m4a\r\n148 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F4/46/wKgJ8lqdAfSSWMEaAFQHYwapWyc988.m4a\r\n149 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F1/A3/wKgJ9FqdAiih8BO8AE6HKNkKsBA556.m4a\r\n150 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F4/4B/wKgJ8lqdAmaQ76lpAFMrHy79hUo592.m4a\r\n151 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F1/B8/wKgJ81qc9s-TkuEQAEzHS4lZ22Y937.m4a\r\n152 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F3/21/wKgJ8lqc9uqzzR4HAFd-UdGD_oM206.m4a\r\n153 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F0/1F/wKgJ8Vqc9vfjSzOEAFAoNK7JS18465.m4a\r\n154 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F0/22/wKgJ8Vqc9yCTgeq4AFMpqKVWn-c072.m4a\r\n155 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F0/9D/wKgJ9Fqc90GTazQpAFUZ_Z9Deqc701.m4a\r\n156 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F3/2F/wKgJ8lqc922ya8JWAFQNQYRW-nI339.m4a\r\n157 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F3/32/wKgJ8lqc95nwS48iAFHfQBp7Mgg071.m4a\r\n158 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F0/AB/wKgJ9Fqc98TzP-vlAFDeSJ5IddY056.m4a\r\n159 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F3/3B/wKgJ8lqc9-SjRrHQAEmPgTrVuWc663.m4a\r\n160 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F3/40/wKgJ8lqc-BvSv9UjAFPxXzXdrO4428.m4a\r\n161 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F0/B6/wKgJ9Fqc-ECTP3LJAE_3vJbTXlc786.m4a\r\n162 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F1/DE/wKgJ81qc-GqxST6LAE_3vCrnLNg694.m4a\r\n163 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F0/48/wKgJ8Vqc-JXBb7MOAFCiFL87M14908.m4a\r\n164 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F1/E8/wKgJ81qc-L3TOrxjAFG0rmkakj0422.m4a\r\n165 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F1/EC/wKgJ81qc-PKxYwD-AE8YidafpIA472.m4a\r\n166 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F0/CA/wKgJ9Fqc-SXQAoVwAFFMaNhJL9c784.m4a\r\n167 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F0/5D/wKgJ8Vqc-XnTHn0JAFGl_-tcdXI180.m4a\r\n168 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F3/67/wKgJ8lqc-b-jlKbeAE_trZEtt3c071.m4a\r\n169 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F0/6B/wKgJ8Vqc-gSweFjSAE_td6sQVFw298.m4a\r\n170 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F0/E4/wKgJ9Fqc-legCFrFAE7X7mNFxzY525.m4a\r\n171 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F0/7D/wKgJ8Vqc-rXjTlvIAE9pTjpYbCI726.m4a\r\n172 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F3/86/wKgJ8lqc-urxEDSmAFCz6HAVCvg293.m4a\r\n173 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F2/1C/wKgJ81qc-zKTxuniAFlCmWCzCqA988.m4a\r\n174 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F0/93/wKgJ8Vqc-3vR3GYNAFHfdkx0nt4361.m4a\r\n175 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F2/2B/wKgJ81qc-8qznYnsAFJmXD_BmNw919.m4a\r\n176 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F0/A2/wKgJ8Vqc_BjAfOyuAE7jqjH7-TE039.m4a\r\n177 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F3/AE/wKgJ8lqc_FCSptT5AFGKGADY0HM055.m4a\r\n178 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F2/48/wKgJ81qc_Kaj33nbAFOsWcBu_Bw613.m4a\r\n179 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F3/C0/wKgJ8lqc_ObSs89rAFQXivgGKn8345.m4a\r\n180 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/27/wKgJ9Fqc_SKyB9eNAFXOmga0weI842.m4a\r\n181 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F0/C7/wKgJ8Vqc_Y2yynlVAFdPVNNzPGg299.m4a\r\n182 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F1/37/wKgJ9Fqc_cmSj_bNAFQ5TyVKRsI199.m4a\r\n183 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/DD/wKgJ8lqc_gzQF5H7AFQ5T1y9-BY900.m4a\r\n184 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F2/70/wKgJ81qc_l2Tnv2LAFQ5T3un4uE756.m4a\r\n185 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F3/EE/wKgJ8lqc_pTSwfEkAFQ5T3TSFjU444.m4a\r\n186 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F1/54/wKgJ9Fqc_tniJACRAFCdrTa1xB0782.m4a\r\n187 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/F4/wKgJ8Vqc_xizzJc-AFDA6ung0Sw378.m4a\r\n188 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F2/87/wKgJ81qc_1CyeZLNAFEdbEgllLA411.m4a\r\n189 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F0/FE/wKgJ8Vqc_47gARcVAFKcrgVKNw0038.m4a\r\n190 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F1/6D/wKgJ9Fqc_8fjHjJbAFKcrt7hSFM924.m4a\r\n191 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F2/96/wKgJ81qc__CgJcSKADnGAQXJ_0c853.m4a\r\n192 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F2/95/wKgJ81qc_-yRWTlgAAPgFs4oS2U624.m4a\r\n193 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F2/97/wKgJ81qc__jRF86aAAjfLy4SndU248.m4a\r\n194 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F1/13/wKgJ8VqdAFPgIfOxAFUZ_TPKI08514.m4a\r\n195 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F1/1C/wKgJ8VqdAJOy89OdAFTdyV4eTew938.m4a\r\n196 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F1/1F/wKgJ8VqdAMCA0u3JAC4-CeUgYSM905.m4a\r\n197 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F2/B3/wKgJ81qdARKwYiKsAFN6aXGOl48565.m4a\r\n198 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F4/31/wKgJ8lqdAU_S7BtMAFItF4Vr-Lc378.m4a\r\n199 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F2/BA/wKgJ81qdAZDD2Re0AFOyNzGQ0ok567.m4a\r\n200 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F4/40/wKgJ8lqdAdmTJLHyAFUrnNjIbyU503.m4a\r\n201 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F1/BB/wKgJ81qc9t_TfOTrAD92XJcfm8E741.m4a\r\n202 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F0/95/wKgJ9Fqc9tWi3FMIAAKqHXZguB0398.m4a\r\n203 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F0/98/wKgJ9Fqc9wWyBy10AFTt8CCUfiA831.m4a\r\n204 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F3/28/wKgJ8lqc9yrR8EWqAFYydmHCm2U328.m4a\r\n205 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/26/wKgJ8Vqc9zaBrvsWACsturqWhxg625.m4a\r\n206 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F0/9E/wKgJ9Fqc90ayPKAbABZVGOgYH2M026.m4a\r\n207 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/C8/wKgJ81qc94OAEbmrAFN3eo1MHes556.m4a\r\n208 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/C8/wKgJ81qc94fReaevABbFCWAMJ28197.m4a\r\n209 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F0/2F/wKgJ8Vqc96KhUlQGAC7S9iLE1go739.m4a\r\n210 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F3/35/wKgJ8lqc96eReHfNABJvYqyR2cU370.m4a\r\n211 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F3/3A/wKgJ8lqc9-DTTyHZAFKhGYZTdHc405.m4a\r\n212 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F1/D6/wKgJ81qc-APh1PUMAFIVllQ5BJM068.m4a\r\n213 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/3D/wKgJ8Vqc-CzgeD5VAFIVllHaCRA210.m4a\r\n214 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F0/44/wKgJ8Vqc-GijrKffAGFGAfCygDQ384.m4a\r\n215 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F3/4D/wKgJ8lqc-JjjE6X6AFj62mN8RkI639.m4a\r\n216 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F1/E8/wKgJ81qc-L3Ch_8cAEyik2DMcgw326.m4a\r\n217 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F1/EC/wKgJ81qc-PjBIxbfAFFbF8TmELU187.m4a\r\n218 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F1/F1/wKgJ81qc-S_DA_mAAFFbTdTl_v4747.m4a\r\n219 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F0/5D/wKgJ8Vqc-XfyP2yaAFDqCAu3Zww860.m4a\r\n220 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/66/wKgJ8Vqc-cfCM-crAFDqCJzXGEo278.m4a\r\n221 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/6A/wKgJ8Vqc-gHiNW47AE86ThVW1i4799.m4a\r\n222 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F2/07/wKgJ81qc-kSw5nDFAEyp7ZU_2J4116.m4a\r\n223 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F2/0D/wKgJ81qc-ojg6IsEAEyp7dMx1Zg357.m4a\r\n224 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F0/F0/wKgJ9Fqc-tWDx4X7AFAyeIobHUY216.m4a\r\n225 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F0/87/wKgJ8Vqc-yOiRIfHAE1l39n0mBE633.m4a\r\n226 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F3/93/wKgJ8lqc-2jRvjDoAFKcroj8UYo634.m4a\r\n227 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F0/FF/wKgJ9Fqc-7DSfbJYAFKcrhi2Ymk546.m4a\r\n228 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F2/39/wKgJ81qc_AaB_8JWAFKcrsCIIm4779.m4a\r\n229 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F3/AC/wKgJ8lqc_EXi7HE1AFFZoNPzzQs832.m4a\r\n230 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F2/46/wKgJ81qc_ICzYxoTAE_6q1-hYy0097.m4a\r\n231 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F3/BE/wKgJ8lqc_N-Agr0NAEyLF8IwzbQ676.m4a\r\n232 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/29/wKgJ9Fqc_S7BukDgAE5-Wy1TTJs365.m4a\r\n233 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F0/C6/wKgJ8Vqc_YXD9oC2AFKlf5dYcWY597.m4a\r\n234 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F1/38/wKgJ9Fqc_c2QjgKWAFDIP0ROMgc954.m4a\r\n235 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/DF/wKgJ8lqc_hSAC_UKAFDIP2tOgfA256.m4a\r\n236 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F2/6D/wKgJ81qc_kuwxGZCAFDIdRnMaXA805.m4a\r\n237 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F3/F3/wKgJ8lqc_qejGTHPAE8qJ5WzVE4396.m4a\r\n238 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F2/7E/wKgJ81qc_uLCyFblAE8qJ0RS-cg620.m4a\r\n239 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F2/83/wKgJ81qc_zWSx_SAAE1XMICvMD8177.m4a\r\n240 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F2/88/wKgJ81qc_2yimv1nAE1XMMO12io164.m4a\r\n241 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F2/8F/wKgJ81qc_6bDyTRmAE1XMLrXJhA712.m4a\r\n242 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F1/6E/wKgJ9Fqc_--S7nPVAE1XMLhL0GQ995.m4a\r\n243 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F1/75/wKgJ9FqdADGBfTCUAFKvyMgd9F4812.m4a\r\n244 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F1/7C/wKgJ9FqdAHWD9fbdAE1wKF-JfjQ899.m4a\r\n245 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F2/A8/wKgJ81qdAKuh1x8kAFLHRNxlZFI571.m4a\r\n246 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/89/wKgJ9FqdAOuiLnsgAFLHRPhO7ns452.m4a\r\n247 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F2/B5/wKgJ81qdASDBaUJQAE-csZNIekQ014.m4a\r\n248 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F1/33/wKgJ8VqdAW3ygxbTAE5lY84nLV8864.m4a\r\n249 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F2/C0/wKgJ81qdAbGxmfZNAE5lY1s-q7Y114.m4a\r\n250 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/A2/wKgJ9FqdAh_BsC5WAE8ChBDKNGw088.m4a\r\n251 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F0/1E/wKgJ8Vqc9vDzTTv9AE3y2eGFI5k049.m4a\r\n252 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F0/9B/wKgJ9Fqc9xjya3j_AFIVluQ7qls066.m4a\r\n253 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/C2/wKgJ81qc90WR5GgOAFCsXbVL4f8941.m4a\r\n254 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/C7/wKgJ81qc936Ab1MvAFYToPsqF0o491.m4a\r\n255 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F3/34/wKgJ8lqc96SAYcGbAFS9eBCYtts233.m4a\r\n256 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F0/AD/wKgJ9Fqc982wEjyRAFS9eC72O48502.m4a\r\n257 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F0/B2/wKgJ9Fqc-ASg71wrAFd82WgQ1NE497.m4a\r\n258 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F3/43/wKgJ8lqc-C3BeZe9AFUUGyyc4iE110.m4a\r\n259 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/41/wKgJ8Vqc-FeT72mhAFUUG3YVPns933.m4a\r\n260 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F1/E2/wKgJ81qc-IHCtM3pAFSXTCkq8As580.m4a\r\n261 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F0/BD/wKgJ9Fqc-KmDvy8eAE-p6eOb6Js360.m4a\r\n262 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F3/51/wKgJ8lqc-Mrilj9PAE-p6S-mTf0578.m4a\r\n263 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F1/ED/wKgJ81qc-PugUotaAE6khxHmbV4426.m4a\r\n264 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F0/59/wKgJ8Vqc-UWC80OXAFGxuz5KKU0361.m4a\r\n265 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/64/wKgJ8lqc-ZGBWFsrAFGxu6cS1bo927.m4a\r\n266 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F1/FF/wKgJ81qc-eKT3jv7AFGxu40IKe4143.m4a\r\n267 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F3/74/wKgJ8lqc-jTyjX-6AEzr__DYclk357.m4a\r\n268 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F0/77/wKgJ8Vqc-n-izJxsAEzr_30TejI263.m4a\r\n269 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F2/13/wKgJ81qc-sjAmk5HAFHjqwof4x8298.m4a\r\n270 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F0/F6/wKgJ9Fqc-xXQmeNlAFHjq6Cf8rE437.m4a\r\n271 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F3/90/wKgJ8lqc-1mShPBUAFUIX0UV2JA611.m4a\r\n272 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F3/9E/wKgJ8lqc-5uSpGMCAFUIlZlm3Wc483.m4a\r\n273 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/0C/wKgJ9Fqc--bxM9dCAFc6x3dNZoM822.m4a\r\n274 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F3/AB/wKgJ8lqc_CjQGa6xAFc6_Xj1M3s222.m4a\r\n275 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F1/1C/wKgJ9Fqc_HWx5A0PAFLBZmyQhJ4858.m4a\r\n276 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F3/BB/wKgJ8lqc_MyCa3c6AFLBnNb2VN4535.m4a\r\n277 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/25/wKgJ9Fqc_RjRM-v-AFLBZqSJd9Q725.m4a\r\n278 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F0/C1/wKgJ8Vqc_U_DLOyXAFQgW6BO0YE600.m4a\r\n279 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F0/CC/wKgJ8Vqc_avx4XpoAFHoRzlvxLI033.m4a\r\n280 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F2/67/wKgJ81qc_fCDl6M3AE3y2RoB8Js627.m4a\r\n281 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F0/E0/wKgJ8Vqc_jzDvmzCAFDirwQvCuo144.m4a\r\n282 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/E3/wKgJ8Vqc_oriKgyCAFQx-WVTdSQ104.m4a\r\n283 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F1/53/wKgJ9Fqc_suSu5v0AFKs1WmPh4M691.m4a\r\n284 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/F1/wKgJ8Vqc_wuwZIFFAD26HIT52Jw438.m4a\r\n285 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F1/5D/wKgJ9Fqc_0GyBdp8AFKs1Y2gJko319.m4a\r\n286 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F1/67/wKgJ9Fqc_4qx0ctbAFTlVVACKls208.m4a\r\n287 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F4/0C/wKgJ8lqc_83RbpQTAFTlHz8CRZk338.m4a\r\n288 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F2/99/wKgJ81qdAADxTaEGAFCt1MbBhlA563.m4a\r\n289 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F2/A0/wKgJ81qdADqBeRYfAFELzWrTCdc651.m4a\r\n290 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F4/1F/wKgJ8lqdAInwkjtUAFU40yEatK0881.m4a\r\n291 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F4/24/wKgJ8lqdAMHgP2cCAFb3ORR61Jc027.m4a\r\n292 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F2/B4/wKgJ81qdARXiPK8lAFSbs9Pvefw217.m4a\r\n293 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F4/32/wKgJ8lqdAVOx2tzWAFFGik54j3Y169.m4a\r\n294 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F2/BF/wKgJ81qdAayxJp8LAFFGiqR7b_Q343.m4a\r\n295 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F4/41/wKgJ8lqdAeCTifMRAE9O3xMxGfA724.m4a\r\n296 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F1/A3/wKgJ9FqdAiWw2SZJAE9O38wNXCQ141.m4a\r\n297 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F1/A7/wKgJ9FqdAkWyC2d-AE9O33pQDYQ576.m4a\r\n298 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F2/D6/wKgJ81qdAoLznAEBAE9O3047gkg004.m4a\r\n299 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F4/53/wKgJ8lqdAq3DDfuJAFPVrjiw8rk101.m4a\r\n300 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F1/4F/wKgJ8VqdAtmTHA4QAE8UItg6VRw226.m4a\r\n301 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F0/20/wKgJ8Vqc9v7DQVceAEaGs2poxRI373.m4a\r\n302 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F0/9A/wKgJ9Fqc9xXw8yCBAEdLrRyeFog213.m4a\r\n303 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/26/wKgJ8Vqc9zaCM0gPAEYaB-KB_e0281.m4a\r\n304 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/28/wKgJ8Vqc92DRIxbuAEwUIl8k_LA588.m4a\r\n305 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/C7/wKgJ81qc93-Q_zeVAEoiyfRYv5c234.m4a\r\n306 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F3/33/wKgJ8lqc952inSC7ADKMV0FgPpQ909.m4a\r\n307 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F3/37/wKgJ8lqc99WR5tVbAEzdULvdozk755.m4a\r\n308 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F1/D3/wKgJ81qc9_fgt8OtAEur4PftfDo788.m4a\r\n309 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/3D/wKgJ8Vqc-CiDprUmAFGOf6muf8o582.m4a\r\n310 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/3F/wKgJ8Vqc-FGwDLB7AFEjhD6ATfg449.m4a\r\n311 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F0/BC/wKgJ9Fqc-IGQB6NhAFLqhV3ijuY211.m4a\r\n312 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F1/E5/wKgJ81qc-LGwn5jCAFLDFPmG2TU011.m4a\r\n313 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F3/54/wKgJ8lqc-N6C1WEyAFMyeVl4e0Y835.m4a\r\n314 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/55/wKgJ8Vqc-QiDcfjBAFJAYoGqNVw490.m4a\r\n315 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F0/59/wKgJ8Vqc-UXgQhlEAE4079bVi5k636.m4a\r\n316 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/63/wKgJ8lqc-YnQe3l3AE4JHgD8V-s690.m4a\r\n317 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/66/wKgJ8Vqc-ciy0SuGAE2ztvOq2LY742.m4a\r\n318 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F0/DB/wKgJ9Fqc-hKRLaCnAFEQNGHiCGM242.m4a\r\n319 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F0/E6/wKgJ9Fqc-mSi9GPUAFGOf9CXyW4942.m4a\r\n320 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F3/7E/wKgJ8lqc-qKCVhQCAFD1ydD_5Ao024.m4a\r\n321 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F3/88/wKgJ8lqc-vWTxQx5AFKVWB8qGjQ554.m4a\r\n322 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F2/1D/wKgJ81qc-zTRUSAQAFItF2jhZrs783.m4a\r\n323 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F0/97/wKgJ8Vqc-5Sz9fTTAE7Tg6eurqI056.m4a\r\n324 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/09/wKgJ9Fqc-9qjnJyzAE9Rzn1LBGw974.m4a\r\n325 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F3/A9/wKgJ8lqc_BvzVWFiAE9KdBVLf24434.m4a\r\n326 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F1/19/wKgJ9Fqc_GiSJYWgAFGOfzg3qm0527.m4a\r\n327 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F2/48/wKgJ81qc_KOD5Ay8AEZk6ibA8XU115.m4a\r\n328 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F0/BA/wKgJ8Vqc_OehukueAE-7h9PWGjU296.m4a\r\n329 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/28/wKgJ9Fqc_SnzY487AFCR7TsW3RA576.m4a\r\n330 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F2/5D/wKgJ81qc_WyQfw6wAFM8vnBfPeI476.m4a\r\n331 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F3/D3/wKgJ8lqc_aeze00OAFCyOwoMb54304.m4a\r\n332 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F1/3C/wKgJ9Fqc_eWBFLpOAFKLRsWjqog267.m4a\r\n333 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F0/DD/wKgJ8Vqc_izChRSnAEnNLHe_6wY290.m4a\r\n334 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/E3/wKgJ8Vqc_omR2YuuAFIizq_EcfM929.m4a\r\n335 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F3/F5/wKgJ8lqc_q_i6MyuAFH_kdrlPs4443.m4a\r\n336 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/EE/wKgJ8Vqc_v6iUqbbAFI7xnSXd4g379.m4a\r\n337 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F1/5D/wKgJ9Fqc_z7jJX9BAFSENiCDv8Y125.m4a\r\n338 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F1/64/wKgJ9Fqc_3mS8icNAE6ndmY4ouw007.m4a\r\n339 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F1/6C/wKgJ9Fqc_8LS5Ek3AE24HObEA48013.m4a\r\n340 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F1/71/wKgJ9FqdAAHxJIu-AEym-sIe6Ug203.m4a\r\n341 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F1/78/wKgJ9FqdADvj6HFdAFWYRB3XTps156.m4a\r\n342 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F1/7D/wKgJ9FqdAHuAuy-5AFj2PgYXQo0235.m4a\r\n343 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F4/24/wKgJ8lqdALzBJ26xAFTGf6cLj1M573.m4a\r\n344 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F2/B2/wKgJ81qdAPXjYfgpAFTGSVhY1b4058.m4a\r\n345 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F1/29/wKgJ8VqdATaShjnRAFGNPXVglLc168.m4a\r\n346 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F1/91/wKgJ9FqdAYqD5CoAAFODO7xVblo893.m4a\r\n347 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F1/39/wKgJ8VqdAcbSejLbAFLKM02YI5k381.m4a\r\n348 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/9F/wKgJ9FqdAhOAfEBtAFR2_0s-RvI447.m4a\r\n349 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F1/A8/wKgJ9FqdAk2jDk3fAFR2_7nYG_o086.m4a\r\n350 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F2/D6/wKgJ81qdAobDlDovAFaglrSY2ZM345.m4a\r\n351 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/BF/wKgJ81qc9xigKpyRAFcsTiRMBPs650.m4a\r\n352 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F0/9C/wKgJ9Fqc90DitwtuAFcsGPuOK54419.m4a\r\n353 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F0/2B/wKgJ8Vqc93KTFdkOAFww96q1HFI676.m4a\r\n354 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F3/34/wKgJ8lqc96DwaA-fAFcmNsjiAzU384.m4a\r\n355 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F0/AE/wKgJ9Fqc99DjNs_fAFOQcrS3cZo320.m4a\r\n356 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F0/AF/wKgJ9Fqc9_rSMo6sAFGNPXlQYxw791.m4a\r\n357 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F0/B5/wKgJ9Fqc-DfCKcQ5AFXIvFHBt24711.m4a\r\n358 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/46/wKgJ8lqc-F2Q45e9AFP9G1KsSDM285.m4a\r\n359 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F0/BC/wKgJ9Fqc-ISC24_6AFKIIflVe4g192.m4a\r\n360 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F0/BE/wKgJ9Fqc-Kqxwh4kAFReB6a-BYc904.m4a\r\n361 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F1/EA/wKgJ81qc-OXTnvPZAFReB_o0xAg562.m4a\r\n362 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F0/CA/wKgJ9Fqc-SewVL5tAFH7J27ExFU082.m4a\r\n363 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F0/D0/wKgJ9Fqc-WPQBID6AFGNB6pMAgc817.m4a\r\n365 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F2/01/wKgJ81qc-e2iCn1lAFX2QXTtW28082.m4a\r\n366 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F3/74/wKgJ8lqc-jawyypGAFq5DuXyioU706.m4a\r\n367 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F3/7C/wKgJ8lqc-n-waa5IAFGNB3HpRKg705.m4a\r\n368 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F0/EC/wKgJ9Fqc-sCS97XEAFNrus0RFfA019.m4a\r\n369 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F2/18/wKgJ81qc-wTDiIugAFY_rbHQfBI351.m4a\r\n370 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F0/8A/wKgJ8Vqc-1WTe3hEAFY_rXYg88I188.m4a\r\n371 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F0/96/wKgJ8Vqc-47QS7BVAFD6L4t98Sc501.m4a\r\n372 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F1/04/wKgJ9Fqc-8rQ9YJNAFD6L5amftE121.m4a\r\n373 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F0/A1/wKgJ8Vqc_BfDqoG8AFOzr_GiXwo654.m4a\r\n374 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F3/AE/wKgJ8lqc_FKgjxgLAFcvB8WSW8Q084.m4a\r\n375 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F1/20/wKgJ9Fqc_KXjfDwlAFGNBz6gytw991.m4a\r\n376 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F3/C3/wKgJ8lqc_PeCLc6XAFZCnJnXPEI555.m4a\r\n377 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/2F/wKgJ9Fqc_U2xrFDZAFj3tYhI4bA352.m4a\r\n378 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F3/CF/wKgJ8lqc_Y2ACTYVAFReBz0tKqY725.m4a\r\n379 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F1/38/wKgJ9Fqc_dCDF1iLAE-FMdPqhLQ369.m4a\r\n380 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/E1/wKgJ8lqc_iDgu1wqAFTd_8BgKIo451.m4a\r\n381 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F1/4E/wKgJ9Fqc_njxKFYvAFL3vAFpYyA948.m4a\r\n382 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F2/76/wKgJ81qc_reB3zZ2AFTB4mlUvCM565.m4a\r\n383 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F3/FD/wKgJ8lqc_xfR3YX6AFj3tWeEvU8893.m4a\r\n384 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F4/03/wKgJ8lqc_1HzEZ5TAFRyyr7cmh8687.m4a\r\n385 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F4/08/wKgJ8lqc_5SDMnLDAFRylLoIvMA347.m4a\r\n386 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F4/0D/wKgJ8lqc_9XTRj4KAFGOfyu3fXo870.m4a\r\n387 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F1/0F/wKgJ8VqdABzBqAPpAFGOtaGUWKk561.m4a\r\n388 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F1/7A/wKgJ9FqdAGXA8ntnAFGOfxA1KTU454.m4a\r\n389 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F1/7F/wKgJ9FqdAKKxrYILAFGOf-aoHec624.m4a\r\n390 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/87/wKgJ9FqdAOHAUtygAFGOtVLfoR8326.m4a\r\n391 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F2/B8/wKgJ81qdAS6h4xoYAFGOf37JwAY925.m4a\r\n392 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F1/33/wKgJ8VqdAWqjyRslAFGOtZ1ZUjc546.m4a\r\n393 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F1/95/wKgJ9FqdAaWAvx0hAFGOfy1ilWY339.m4a\r\n394 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F1/3B/wKgJ8VqdAdOS9SRiAFGOf4BbTKw894.m4a\r\n395 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/A2/wKgJ9FqdAiDTahTFAFGOf-xWIU8544.m4a\r\n396 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F1/A9/wKgJ9FqdAk_Akm7bAFGOf4krZYg854.m4a\r\n397 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F1/AC/wKgJ9FqdAoTiO98UAFIXDmajJ-E647.m4a\r\n398 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F1/B3/wKgJ9FqdAsiREljqAFVh8nqAYBA865.m4a\r\n399 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F4/5B/wKgJ8lqdAvryowh3AFVh8q6Lbb0276.m4a\r\n400 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F1/5C/wKgJ8VqdAxihzlNfAE7-Ga3tqu8744.m4a\r\n401 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F3/27/wKgJ8lqc9yPwiBdXAFQHY0Got3c555.m4a\r\n402 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F0/A2/wKgJ9Fqc91iBWXCVAFQHY0BXb0E346.m4a\r\n403 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/C7/wKgJ81qc932BqicwAE_mHfgGlAk969.m4a\r\n404 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F3/35/wKgJ8lqc96ezcKBCAE_mHcVELEg783.m4a\r\n405 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/D2/wKgJ81qc99HjZ1_gAE_mHcg0BOA419.m4a\r\n406 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F1/D2/wKgJ81qc9_ShPHBiAE_mHVjyymA596.m4a\r\n407 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F0/3A/wKgJ8Vqc-BeCepL2AE8aNteb0OU395.m4a\r\n408 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F0/B7/wKgJ9Fqc-EOi_c61AFAE8-Ah4RQ227.m4a\r\n409 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F1/DF/wKgJ81qc-HHi45ZgAFAE8yASPFk654.m4a\r\n410 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F3/4E/wKgJ8lqc-J7jl2MBAFRrP6wxxxA118.m4a\r\n411 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F3/53/wKgJ8lqc-NKxa-QKAE_r_H5Y6iY238.m4a\r\n412 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F3/57/wKgJ8lqc-QrA0Br2AE_jLtl5j5Q431.m4a\r\n413 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F0/5B/wKgJ8Vqc-VKyaGvGAFNP1_0RDYA669.m4a\r\n414 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/65/wKgJ8lqc-ZOx5fFOAE222_ALTBY113.m4a\r\n415 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F2/00/wKgJ81qc-enD1fVMAE22pXXUXsw921.m4a\r\n416 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F3/73/wKgJ8lqc-jPiUOxsAFGOf8UJEq4830.m4a\r\n417 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F3/77/wKgJ8lqc-muyoiPEAFRQz6c-UUQ157.m4a\r\n418 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F3/81/wKgJ8lqc-q-xe-2QAFJa0vWS97k586.m4a\r\n419 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F0/82/wKgJ8Vqc-uzwCc0PAFJa0sPcgb4804.m4a\r\n420 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F0/89/wKgJ8Vqc-y7TjpNQAFGOf1OajOE874.m4a\r\n421 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F3/96/wKgJ8lqc-3aATV4TAFEwhVjb7qI551.m4a\r\n422 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F1/02/wKgJ9Fqc-76giufkAFRPWDdUFC4681.m4a\r\n423 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F0/9F/wKgJ8Vqc_BDinZ_tAE7X7hXcy_E295.m4a\r\n424 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/A9/wKgJ8Vqc_FnTG5xxAEwwPs89SRk818.m4a\r\n425 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F2/49/wKgJ81qc_K3h7ueMAFI7xhZv-vU068.m4a\r\n426 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F3/C0/wKgJ8lqc_OiiGLFAAE5FFnWC59U391.m4a\r\n427 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F2/51/wKgJ81qc_S_xO3O-AEolfoT4V_Y140.m4a\r\n428 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F3/CD/wKgJ8lqc_YXhKoczAE0E91GnfFA081.m4a\r\n429 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F2/60/wKgJ81qc_c3CpIbgAFMWkkV9z1E946.m4a\r\n430 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/DC/wKgJ8lqc_gSSsMG5AFMWkvTMqdE788.m4a\r\n431 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F1/48/wKgJ9Fqc_lyCW60pAFMWkqodxJ8433.m4a\r\n432 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/EA/wKgJ8Vqc_q2yO83BAFMWkgOrou4425.m4a\r\n433 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F1/58/wKgJ9Fqc_uqBaSOhAE2Xz3RbyB8518.m4a\r\n434 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/F4/wKgJ8Vqc_xjwQD8xAEwwCMuOLbs333.m4a\r\n435 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F1/62/wKgJ9Fqc_23CtilOAE13gWoQWVo812.m4a\r\n436 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F1/05/wKgJ8Vqc_9LxD9HTAE4pZZa1pCY244.m4a\r\n437 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F2/9C/wKgJ81qdACaymAx1AE8Vmv2YseY133.m4a\r\n438 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F1/7B/wKgJ9FqdAG2wFDCtAE4pL8Q-WxI342.m4a\r\n439 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F2/A8/wKgJ81qdAKnA0ssxAE2EuQnFfOo352.m4a\r\n440 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F2/B1/wKgJ81qdAPHAmUJYAFDYamcJrUQ336.m4a\r\n441 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F1/29/wKgJ8VqdATazoqrpAFN6adHJ704736.m4a\r\n442 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F2/B9/wKgJ81qdAYfCxN9-AFAviXEYKn4230.m4a\r\n443 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F1/99/wKgJ9FqdAbWwgZi6AFAvib5rFH8481.m4a\r\n444 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F1/41/wKgJ8VqdAfHSTMNNAE8VmofK588961.m4a\r\n445 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M05/F1/A4/wKgJ9FqdAiuhKdVjAFGOfxZD7IA224.m4a\r\n446 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F2/D4/wKgJ81qdAlqjNOYRAE60re8Lmyo245.m4a\r\n447 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F1/AC/wKgJ9FqdAobio1LGAFQ318qjnOc198.m4a\r\n448 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F4/53/wKgJ8lqdAq6AuUcNAFNruok8i44811.m4a\r\n449 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F4/58/wKgJ8lqdAubT-SlRAE87xfdzhYY238.m4a\r\n450 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F4/5F/wKgJ8lqdAxTQAnROAFS3msAmsg4674.m4a\r\n451 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F0/A1/wKgJ9Fqc91PSg6k2AFbuoop0ZVI594.m4a\r\n452 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F0/2C/wKgJ8Vqc93WTXLXUAE65GFAlJkg483.m4a\r\n453 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F0/2D/wKgJ8Vqc95ix6__RAE65GOfYQKg428.m4a\r\n454 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/CF/wKgJ81qc98HR1lA2AE0xBHBOOpc094.m4a\r\n455 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F0/38/wKgJ8Vqc9-zjWRPCAE-_7nXrt8U064.m4a\r\n456 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F0/3B/wKgJ8Vqc-B3jhn2WAFU7wo1Rv-Q534.m4a\r\n457 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F1/DB/wKgJ81qc-D7xojmXAFGOfzQnbiI150.m4a\r\n458 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/47/wKgJ8lqc-GOwkKTHAFIdJpNsUGk558.m4a\r\n459 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F3/4C/wKgJ8lqc-JSjknj_AFLHRO4d0N8616.m4a\r\n460 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F0/C1/wKgJ9Fqc-LqQAqpMAFRPWMPPpqY477.m4a\r\n461 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F3/54/wKgJ8lqc-NzSbePBAFKm9-2djVQ673.m4a\r\n462 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F0/C9/wKgJ9Fqc-SGQON_RAFvknC_ea6s925.m4a\r\n463 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F0/5F/wKgJ8Vqc-YHCrUooAFGOf6z1Dqc649.m4a\r\n464 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F0/D6/wKgJ9Fqc-a2TY-hmAFGOtWSSP3o182.m4a\r\n465 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/69/wKgJ8Vqc-fviEymQAFQRrPtZDWY315.m4a\r\n466 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F3/76/wKgJ8lqc-j_BlH8hAFGOfwE3Lts561.m4a\r\n467 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F2/0D/wKgJ81qc-oiiE_G_AFBIgRzCL-E720.m4a\r\n468 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F2/13/wKgJ81qc-sywd6h5AE3Z4bWbtDk021.m4a\r\n469 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F0/86/wKgJ8Vqc-yDzjVoBAFGOte9L7qU033.m4a\r\n470 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F3/90/wKgJ8lqc-1vybTJ1AE3Z4Uw-I64556.m4a\r\n471 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F1/01/wKgJ9Fqc-7vQjmbSAE3Z4cBCZuw795.m4a\r\n472 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F0/9E/wKgJ8Vqc_A2jIABkAEzhtsGXCpo618.m4a\r\n473 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/A6/wKgJ8Vqc_EihF0i3AEt-W6bRmg0521.m4a\r\n474 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F2/45/wKgJ81qc_H2jrCUcAEt-W5RKjeI922.m4a\r\n475 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F0/B8/wKgJ8Vqc_OCTZY3ZAE8nOMTbIgc973.m4a\r\n476 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/26/wKgJ9Fqc_R2DcGQTAE8nOMorkFY586.m4a\r\n477 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/33/wKgJ9Fqc_WfBrKPjAFGOf2ofUwM082.m4a\r\n478 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F0/CC/wKgJ8Vqc_ajC3F9sAFBIgUuUxFc445.m4a\r\n479 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F1/3E/wKgJ9Fqc_e-Cbx7GAFBIgc8L4Pk256.m4a\r\n480 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/E6/wKgJ8lqc_jPC4S0IAEu0sQb3h9Q037.m4a\r\n481 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/E1/wKgJ8Vqc_n2ArM7_AE65GAl7mFU292.m4a\r\n482 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F3/F6/wKgJ8lqc_rXxQfZ9AFGOfxOEGTE469.m4a\r\n483 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F1/59/wKgJ9Fqc_u-SJqE4AFGOf9JAa0o479.m4a\r\n484 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F2/83/wKgJ81qc_zWzJ_s7AE8Vmml3G3c367.m4a\r\n485 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F1/63/wKgJ9Fqc_3bDnlyaAFRj5bXraGg290.m4a\r\n486 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F2/92/wKgJ81qc_7zwIxgEAE3Z4T3OcRo328.m4a\r\n487 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F2/96/wKgJ81qc__KgNeeWAFGOfzn4S5s671.m4a\r\n488 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F2/A1/wKgJ81qdAECzwPmEAFGOf4HxgFo306.m4a\r\n489 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F2/A6/wKgJ81qdAKGDSxxHAFT8n865PGw047.m4a\r\n490 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F2/AD/wKgJ81qdANnhIVzpAFT81R-oUpQ768.m4a\r\n491 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F2/B6/wKgJ81qdASXByXxsAFYmtRc8ePA586.m4a\r\n492 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F4/37/wKgJ8lqdAXCQ-tCYAFYmtT9p4Fw673.m4a\r\n493 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F1/9B/wKgJ9FqdAcCio-9GAFYmtVzXt_w195.m4a\r\n494 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/9D/wKgJ9FqdAgGD1cWUAFj3tRZbnJs861.m4a\r\n495 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F4/48/wKgJ8lqdAj6y8F5WAFYmtWGEa2M593.m4a\r\n496 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F4/4D/wKgJ8lqdAnKxeL7fAFJNZB1JsaM253.m4a\r\n497 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F4/53/wKgJ8lqdAqzQyRIQAEyctcG9kmc719.m4a\r\n498 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F4/55/wKgJ8lqdAt-j7r71AE8kSWLjeIE819.m4a\r\n499 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M06/F4/5D/wKgJ8lqdAwLBPchYAE8kSQgbizc097.m4a\r\n500 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F1/5F/wKgJ8VqdAyWQNZDEAE8kSQYBCEg244.m4a\r\n501 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F3/29/wKgJ8lqc9y7y28e_AFaKx-aq8XQ015.m4a\r\n502 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F0/A2/wKgJ9Fqc91bTMeMvAFSNBOuG4_4809.m4a\r\n503 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F0/A4/wKgJ9Fqc94SQjoKZAFB-08_aDis128.m4a\r\n504 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/CD/wKgJ81qc97XARix5AFB-09zj8ao603.m4a\r\n505 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F0/33/wKgJ8Vqc99yDqC-LAFB-07OMiL4035.m4a\r\n506 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F1/D5/wKgJ81qc-AHBtKz_AFB_CQ-UhQ0404.m4a\r\n507 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F3/42/wKgJ8lqc-CfT2CZpAFB_CTA7Iu4449.m4a\r\n508 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/45/wKgJ8lqc-FWRR3LjAFM3FiUnjQE358.m4a\r\n509 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F0/BD/wKgJ9Fqc-ISzR5e-AFgJ0yycyz8523.m4a\r\n510 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F0/C2/wKgJ9Fqc-L3Dj0KYAFqqX7TdevY730.m4a\r\n511 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F0/C5/wKgJ9Fqc-O7yUVK7AFj3tZtJkl0961.m4a\r\n512 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F1/F2/wKgJ81qc-TXBOXMRAE_pDE1vcOU768.m4a\r\n513 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/61/wKgJ8lqc-YDiocDMAFMz8Y43XRM819.m4a\r\n514 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/65/wKgJ8Vqc-cWywEqaAE815-ny3SY746.m4a\r\n515 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/69/wKgJ8Vqc-f2A0fEUAE8150OP-FY371.m4a\r\n516 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F3/75/wKgJ8lqc-j_SpqVkAE81559lz0Q479.m4a\r\n517 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F0/78/wKgJ8Vqc-oTxOFYsAE36MlKaGK8917.m4a\r\n518 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F2/11/wKgJ81qc-sDDKEBiAFDUNrXWi0E354.m4a\r\n519 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F2/1A/wKgJ81qc-w3yfdVlAE5uMdf9T9Q698.m4a\r\n520 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F2/1E/wKgJ81qc-z7gEzOWAE5uMWgF9l8987.m4a\r\n521 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M02/F0/97/wKgJ8Vqc-5Ghd6ikAE_QGd0htWo773.m4a\r\n522 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F2/33/wKgJ81qc--Wxu6YzAFGOf3FTWY8999.m4a\r\n523 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F1/13/wKgJ9Fqc_CyhRsdJAFV5bhgu_oA391.m4a\r\n524 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F1/1D/wKgJ9Fqc_Hyg4FoKAFMuDgdGJGU865.m4a\r\n525 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F1/23/wKgJ9Fqc_LbQ5lvAAFMuDrThPps729.m4a\r\n526 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F3/C8/wKgJ8lqc_RDQA6QaAE7AbiPgrj4624.m4a\r\n527 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0B/F1/34/wKgJ9Fqc_WnQBOyNAE7Abk_kgLk844.m4a\r\n528 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F0/D1/wKgJ8Vqc_buBUwSwAFXhsOq0Q_k602.m4a\r\n529 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M07/F1/3C/wKgJ9Fqc_eKByGIgAFNzFAbhY3E001.m4a\r\n530 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/E1/wKgJ8lqc_h3gPt_zAFNzFBsSkvw178.m4a\r\n531 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F1/46/wKgJ9Fqc_kyQo0TGAFC2oZjmga0980.m4a\r\n532 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M01/F0/E9/wKgJ8Vqc_qeSJe6sAFT8n5yPQHE030.m4a\r\n533 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F1/57/wKgJ9Fqc_uPhSr2bAFNBKJL3hQw280.m4a\r\n534 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/F6/wKgJ8Vqc_x_hpD9BAFNBKNzLSxU277.m4a\r\n535 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F2/8E/wKgJ81qc_4mRbjkQAFNBKNHWFDw790.m4a\r\n536 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F2/93/wKgJ81qc_8HRXZIYAE1EGrhDsDk166.m4a\r\n537 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M02/F2/98/wKgJ81qc__3CIQxLAFBf_kc3Sag704.m4a\r\n538 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M04/F2/9C/wKgJ81qdACrT0PHyAFKm92B8UhM609.m4a\r\n539 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M03/F1/17/wKgJ8VqdAH7QtvUwAFKm9wQaYCI827.m4a\r\n540 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F2/A7/wKgJ81qdAKewLnJeAE-eKXHHwIk826.m4a\r\n541 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F2/B1/wKgJ81qdAO-wS7UlAE3rgycROhc797.m4a\r\n542 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M00/F1/8D/wKgJ9FqdASDAPaRmAFK-d1W1IaM423.m4a\r\n543 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0B/F4/33/wKgJ8lqdAVnhwuQMAFD4uMse1CM611.m4a\r\n544 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M08/F1/98/wKgJ9FqdAbOT6pneAE14-QB8n34324.m4a\r\n545 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M07/F4/47/wKgJ8lqdAfqRtb3LAFMMSuu-55M129.m4a\r\n546 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F2/D2/wKgJ81qdAkyyRAQpAFMMSm4tUus963.m4a\r\n547 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M06/F1/AE/wKgJ9FqdApbRvBh-AFGOf1cqFDw301.m4a\r\n548 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M01/F1/B2/wKgJ9FqdAsWh3yknAFGOf32OhIc863.m4a\r\n549 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F4/5A/wKgJ8lqdAu_i1oAcAFGOtccpato760.m4a\r\n550 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M0A/F1/5D/wKgJ8VqdAx7iupGsAFGOtWcNdhQ216.m4a\r\n551 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M08/F0/28/wKgJ8Vqc912gNmOuAFSjDIt6Ra0656.m4a\r\n552 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F0/A4/wKgJ9Fqc94PDLxAMAFGOfzc09Fw907.m4a\r\n553 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M0A/F1/CC/wKgJ81qc97Ogb4NeAFGOfyJs3Tc618.m4a\r\n554 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M05/F3/39/wKgJ8lqc99vjbz89AE7X7mi_FXU785.m4a\r\n555 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M09/F0/3A/wKgJ8Vqc-BOCC0ciAEr4ujUoiW8839.m4a\r\n556 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M09/F0/B5/wKgJ9Fqc-DXzHz-uAE0SLpQGFBA527.m4a\r\n557 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M00/F3/49/wKgJ8lqc-GjQL_H_AE34tzSCIy8363.m4a\r\n558 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group41/M04/F0/47/wKgJ8Vqc-JCjQYeSAEx_V-F0B6E000.m4a\r\n559 支持我们请多：打赏，点赞，评论，分享，订阅我们噢！$http://audio.xmcdn.com/group42/M03/F1/E8