<?php  if(!defined('DEDEINC')) exit('jumingkeji');
/**
 * CookieС
 *
 * @version        $Id: file.helper.php 1 13:58 201075Z tianya $
 * @package        DedeCMS.Helpers
 * @copyright      Copyright (c) 2007 - 2010, DesDev, Inc.
 * @license        http://help.jumingkeji.com/usersguide/license.html
 * @link           http://www.jumingkeji.com
 */

/**
 *  Cookie¼
 *
 * @param     string  $key    
 * @param     string  $value  ֵ
 * @param     string  $kptime  ʱ
 * @param     string  $pa     ·
 * @return    void
 */
if ( ! function_exists('PutCookie'))
{
    function PutCookie($key, $value, $kptime=0, $pa="/")
    {
        global $cfg_cookie_encode,$cfg_domain_cookie;
        setcookie($key, $value, time()+$kptime, $pa,$cfg_domain_cookie);
        setcookie($key.'__ckMd5', substr(md5($cfg_cookie_encode.$value),0,16), time()+$kptime, $pa,$cfg_domain_cookie);
    }
}


/**
 *  Cookie¼
 *
 * @param     $key   
 * @return    void
 */
if ( ! function_exists('DropCookie'))
{
    function DropCookie($key)
    {
        global $cfg_domain_cookie;
        setcookie($key, '', time()-360000, "/",$cfg_domain_cookie);
        setcookie($key.'__ckMd5', '', time()-360000, "/",$cfg_domain_cookie);
    }
}

/**
 *  ȡCookie¼
 *
 * @param     $key   
 * @return    string
 */
if ( ! function_exists('GetCookie'))
{
    function GetCookie($key)
    {
        global $cfg_cookie_encode;
        if( !isset($_COOKIE[$key]) || !isset($_COOKIE[$key.'__ckMd5']) )
        {
            return '';
        }
        else
        {
            if($_COOKIE[$key.'__ckMd5']!=substr(md5($cfg_cookie_encode.$_COOKIE[$key]),0,16))
            {
                return '';
            }
            else
            {
                return $_COOKIE[$key];
            }
        }
    }
}


