<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Gifts extends CI_Controller {

	function __construct(){
		    parent::__construct();
        	$this->load->helper('url');
        	$this->load->helper('form');
            $this->load->library('session'); //加载session
		    $this->load->model('CsdjDB');
		    $this->load->model('CsdjAdmin');
		    $this->load->model('CsdjSkins');
	        $this->CsdjAdmin->Admin_Login();
	}

	public function index()
	{
 	        $sid = intval($this->input->get('sid'));
 	        $user = $this->input->get_post('user');
 	        $page = $this->input->get('page');
            if(empty($page)) $page=1;

	        $sql_string = "SELECT * FROM ".CS_SqlPrefix."gifts where 1=1";
			if($sid>0){
      			$sql_string.=" and cs_sid=".$sid."";
			}
			if(!empty($user)){
				$uid=$this->CsdjSkins->getziduan('user','cs_id',$user,'cs_name');
				if(intval($uid)>0){
	                $sql_string.= " and CS_UID=".$uid."";
				}
			}
			$sql_string.=" order by CS_AddTime desc";
            
	        $query = $this->db->query($sql_string); 
	        $total = $query->num_rows();

            $base_url = site_url('admin/gifts').'?sid='.$sid.'&user='.$user;
	        $per_page = 20; 
            $totalPages = ceil($total / $per_page); // 总页数
	        $data['nums'] = $total;
            if($total<$per_page){
               $per_page=$total;
            }
            $sql_string.=' limit '. $per_page*($page-1) .','. $per_page;
	        $query = $this->db->query($sql_string);

	        $data['gifts'] = $query->result();
	        $data['pages'] = $this->CsdjAdmin->get_page($base_url,$totalPages,$page,10); //获取分页类

            $this->load->view('admin/gifts',$data);
	}

	public function lists()
	{
 	        $sid = intval($this->input->get('sid'));
 	        $page = $this->input->get('page');
            if(empty($page)) $page=1;

	        $sql_string = "SELECT * FROM ".CS_SqlPrefix."gifts_list where 1=1";
			if($sid==1){
      			$sql_string.=" and cs_cid=1";
			}
			if($sid==2){
      			$sql_string.=" and cs_cid=2";
			}
			$sql_string.=" order by CS_ID desc";
            
	        $query = $this->db->query($sql_string); 
	        $total = $query->num_rows();

            $base_url = site_url('admin/gifts/lists').'?sid='.$sid;
	        $per_page = 20; 
            $totalPages = ceil($total / $per_page); // 总页数
	        $data['nums'] = $total;
            if($total<$per_page){
               $per_page=$total;
            }
            $sql_string.=' limit '. $per_page*($page-1) .','. $per_page;
	        $query = $this->db->query($sql_string);

	        $data['gifts'] = $query->result();
	        $data['pages'] = $this->CsdjAdmin->get_page($base_url,$totalPages,$page,10); //获取分页类

            $this->load->view('admin/gifts_list',$data);
	}

	public function add()
	{
            $data['title']="新增";
            $data['CS_ID']=0;
            $data['CS_Name']="";
            $data['CS_CID']=1;
            $data['CS_Pic']="";
            $data['CS_Nums']=0;
            $data['CS_Cion']=0;
            $data['CS_TID']=0;
            $data['CS_Js']='';
            $data['CS_SID']=0;
            $this->load->view('admin/gifts_edit',$data);
	}

	public function edit()
	{
	        $id = $this->uri->segment(4);
            if(empty($id)) $this->CsdjAdmin->Admin_Url('<font color=red>参数错误，ID为空！</font>',site_url('admin/gifts/lists'));
            $data['title']="修改";
            $sql="SELECT * FROM ".CS_SqlPrefix."gifts_list where cs_id=".$id."";
	        $row=$this->CsdjDB->get_all($sql);

            $data['CS_ID']=$row[0]->CS_ID;
            $data['CS_Name']=$row[0]->CS_Name;
            $data['CS_CID']=$row[0]->CS_CID;
            $data['CS_Pic']=$row[0]->CS_Pic;
            $data['CS_Nums']=$row[0]->CS_Nums;
            $data['CS_Cion']=$row[0]->CS_Cion;
            $data['CS_TID']=$row[0]->CS_TID;
            $data['CS_Js']=$row[0]->CS_Js;
            $data['CS_SID']=$row[0]->CS_SID;

            $this->load->view('admin/gifts_edit',$data);
	}

	public function save()
	{
            $id=intval($this->input->post('CS_ID', TRUE));

            $data['CS_Name']=$this->input->post('CS_Name', TRUE);
            $data['CS_CID']=intval($this->input->post('CS_CID', TRUE));
            $data['CS_Pic']=$this->input->post('CS_Pic', TRUE);
            $data['CS_Nums']=intval($this->input->post('CS_Nums', TRUE));
            $data['CS_Cion']=intval($this->input->post('CS_Cion', TRUE));
            $data['CS_TID']=intval($this->input->post('CS_TID', TRUE));
            $data['CS_Js']=$this->input->post('CS_Js', TRUE);
            $data['CS_SID']=intval($this->input->post('CS_SID', TRUE));

			if(empty($data['CS_Name']) || $data['CS_CID']==0 || empty($data['CS_Pic']) || empty($data['CS_Js']) || $data['CS_Cion']==0){
                 $this->CsdjAdmin->Admin_Url('<font color=red>数据不完整！</font>','javascript:history.back();');
			}

            if($id==0){
                 $this->CsdjDB->get_insert('gifts_list',$data);
            }else{
                 $this->CsdjDB->get_update('gifts_list',$id,$data);
            }
            $this->CsdjAdmin->Admin_Url('<font color=#0000ff>恭喜您，操作成功！</font>',site_url('admin/gifts/lists'),'ok');
	}

	public function fh_save()
	{
	        $id = $this->uri->segment(4);
            $sid= $this->input->get_post('sid');

			if($sid==1){  //发货

				 $msg['cs_name']='您兑换的礼品已经发货，请注意接收';

                 //修改账单状态
				 $this->db->query("update ".CS_SqlPrefix."gifts set CS_SID=2 where cs_id=".$id."");

			}elseif($sid==2){  //成功

				 $msg['cs_name']='您兑换的礼品已经成功完成，请查收';

                 //修改账单状态
				 $this->db->query("update ".CS_SqlPrefix."gifts set CS_SID=4 where cs_id=".$id."");

			}else{   //失败

				 $msg['cs_name']='抱歉，您兑换的礼品未能完成';

				 //退还积分
				 $row=$this->db->query("SELECT CS_UID,CS_Cion FROM ".CS_SqlPrefix."gifts where cs_id=".$id."")->row();
				 $this->db->query("update ".CS_SqlPrefix."user set CS_Cion=CS_Cion+".$row->CS_Cion." where cs_id=".$row->CS_UID."");

                 //修改账单状态
				 $this->db->query("update ".CS_SqlPrefix."gifts set CS_SID=3 where cs_id=".$id."");
			}

			//发送通知
			$msg['cs_type']='account';
			$msg['cs_usera']=$this->session->userdata('cs_name');
			$msg['cs_userb']='系统提示';
			$msg['cs_addtime']=date('Y-m-d H:i:s');
		    $this->CsdjDB->get_insert ('msg',$msg);

			$this->CsdjAdmin->Admin_Url('<font color=#0000ff>恭喜您，操作成功！</font>',site_url('admin/gifts'),'ok');
	}

	public function del()
	{

	        $ids=$this->input->post('CS_ID');
            if(empty($ids)) $this->CsdjAdmin->Admin_Url('<font color=red>参数错误，ID为空！</font>','javascript:history.back();');
            $id=implode(',', $ids);
            $this->db->query("delete from ".CS_SqlPrefix."gifts where CS_ID in (".$id.")");
            $this->CsdjAdmin->Admin_Url('<font color=#0000ff>恭喜您，删除成功！</font>',$_SERVER['HTTP_REFERER'],'ok');
	}
}