<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * @Cscms 3.5 open source management system
 * @copyright 2009-2013 chshcms.com. All rights reserved.
 * @Author:Cheng Jie
 * @Dtime:2013-04-27
 */
class CI_Model {

    /**
     * Constructor
     *
     * @access public
     */
    function __construct()
    {
        $reflector = new ReflectionClass($this);
        $class_name = $reflector->getName();

        $CI =& get_instance();
        if (!empty($CI->load->_ci_module_models[$class_name]))
        {
            $this->_ci_module_class = $CI->load->_ci_module_models[$class_name];
        }

        log_message('debug', "CI_Model Class Initialized");
    }

    /**
     * __get
     *
     * Allows models to access CI's loaded classes using the same
     * syntax as controllers.
     *
     * @param   string
     * @access private
     */
    function __get($key)
    {
        $CI =& get_instance();

        // ģҵ key ֱӷ key
        // Ϊ˺ȫֿ룬ģҲͲȫ
        if (!empty($this->_ci_module_class))
        {
            $module_class_name = $this->_ci_module_class;
            return $CI->$module_class_name->$key;
        }
        return $CI->$key;
    }
}
// END Model Class

/* End of file Model.php */
/* Location: ./application/core/Model.php */

