<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * @Cscms 3.5 open source management system
 * @copyright 2009-2013 chshcms.com. All rights reserved.
 * @Author:Cheng Jie
 * @Dtime:2013-04-27
 */
class CI_Module {

	/**
	 * Constructor
	 *
	 * @access public
	 */
	function __construct()
	{
		// ʵԼ Loader 
		$CI =& get_instance();
		$this->load = clone $CI->load;

		// CI ϵͳôݵķʽֱӸֵ Module
		// ȻҲԲ clone ķʽҪݲͬĿȨ⡣
		foreach ($CI->load->get_base_classes() as $var => $class)
		{
			// ų Loader ࣬ΪѾ clone 
			if ($var == 'loader')
			{
				continue;
			}
			// ֵ Module
			$this->$var =& load_class($class);
		}
		// Զװصģ
		$autoload = array_merge($CI->load->_ci_autoload_libraries, $CI->load->_ci_autoload_models);
		foreach ($autoload as $item)
		{
			if (!empty($item) and isset($CI->$item))
			{
				$this->$item =& $CI->$item;
			}
		}
		// ݿ
		if (isset($CI->db))
		{
			$this->db =& $CI->db;
		}

		//  PHP5 ķƣ̬ȷ Module ·
		$reflector = new ReflectionClass($this);

		$path = substr(dirname($reflector->getFileName()), strlen(realpath('plugins').DIRECTORY_SEPARATOR));
		$class_path = implode('/', array_slice(explode(DIRECTORY_SEPARATOR, $path), 0, -1));
		$class_name = $reflector->getName();

		// ֪ͨ Loader ࣬Module 
		$this->load->_ci_module_ready($class_path, $class_name);

		// Լŵȫֳ
		$CI->$class_name = $this;

		log_message('debug', "$class_name Module Class Initialized");
	}
}

// END Module Class

/* End of file Module.php */
/* Location: ./application/core/Module.php */

