<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP 4.3.2 or newer
 *
 * @package		CodeIgniter
 * @author		ExpressionEngine Dev Team
 * @copyright	Copyright (c) 2008 - 2009, EllisLab, Inc.
 * @license		http://codeigniter.com/user_guide/license.html
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * Native Session Class
 *
 * @package		CodeIgniter
 * @subpackage	Libraries
 * @category	Sessions
 * @author		ExpressionEngine Dev Team
 * @link		http://codeigniter.com/user_guide/libraries/sessions.html
 * 				http://codeigniter.org.cn
 */
class Session {

	var $flash_key = 'flash'; // prefix for "flash" variables (eg. flash:new:message)

	function __construct()
	{
		$this->object =& get_instance();
		log_message('debug', "Native Session Class Initialized");
		$this->cookie_domain = ( ! defined('CS_Cookie_Domain'))?$this->Host_Ym():CS_Cookie_Domain;
		$this->cookie_path = '/';
		$this->cookie_prefix= 'cscms_';
		$this->cookie_time = 86400;
	}

    //ȡcookie
	function userdata($item)
	{
		if( ! isset($_COOKIE[$item])){
		        return false;
                }else{
                     $COOKIE=$this->encrypt($_COOKIE[$item],'D',CS_Encryption_Key.$item);
		     return $COOKIE;
                }
	}

    //дcookie
	function set_userdata($newdata = array(), $newval = '')
	{
		if (is_string($newdata))
		{
			$newdata = array($newdata => $newval);
		}

		if (count($newdata) > 0)
		{
			foreach ($newdata as $key => $val)
			{
				setcookie($key,$this->encrypt($val,'E',CS_Encryption_Key.$key),time()+$this->cookie_time,$this->cookie_path,$this->cookie_domain);
			}
		}
	}

    //ɾcookie
	function unset_userdata($newdata = array())
	{
		if (is_string($newdata))
		{
			$newdata = array($newdata => '');
		}

		if (count($newdata) > 0)
		{
			foreach ($newdata as $key => $val)
			{
				setcookie($key,$val,time()-4200,$this->cookie_path,$this->cookie_domain);
			}
		}
	}

    //cookieӽ
	function encrypt($string,$operation,$key=''){
		if(empty($string)){
             return'';
		}
               $key=md5($key);
               $key_length=strlen($key);
               $string=$operation=='D'?base64_decode($string):substr(md5($string.$key),0,8).$string;
               $string_length=strlen($string);
               $rndkey=$box=array();
               $result='';
               for($i=0;$i<=255;$i++)
               {
                   $rndkey[$i]=ord($key[$i%$key_length]);
                   $box[$i]=$i;
               }
               for($j=$i=0;$i<256;$i++)
               {
                   $j=($j+$box[$i]+$rndkey[$i])%256;
                   $tmp=$box[$i];
                   $box[$i]=$box[$j];
                   $box[$j]=$tmp;
               }
               for($a=$j=$i=0;$i<$string_length;$i++)
               {
                   $a=($a+1)%256;
                   $j=($j+$box[$a])%256;
                   $tmp=$box[$a];
                   $box[$a]=$box[$j];
                   $box[$j]=$tmp;
                   $result.=chr(ord($string[$i])^($box[($box[$a]+$box[$j])%256]));
               }
               if($operation=='D')
               {
                   if(substr($result,0,8)==substr(md5(substr($result,8).$key),0,8))
                   {
                       return substr($result,8);
                   }
                   else
                   {
                       return'';
                   }
               }
               else
               {
                   return str_replace('=','',base64_encode($result));
               }
	}

	//ȡ
	function Host_Ym() {
    	    if($_SERVER['HTTP_HOST']=="127.0.0.1" || $_SERVER['HTTP_HOST']=="localhost"){
           	return "";
    	    }else{
      		preg_match('/[\w][\w-]*\.(?:com\.cn|com|cn|co|net|org|gov|cc|so|name|dj|biz|info|pw|dj|pro|wang|hk|tk|gov\.cn|org\.cn|tm|in|asia|mobi|us|net\.cn|pro|me|eu|es|ws|tv|club|la)(\/|$)/isU',  $_SERVER['HTTP_HOST'], $domain);
       		return '.'.rtrim(@$domain[0], '/');
    	    }
	}
}
// END Native Session Class

/* End of file Session.php */
/* Location: ./system/application/libraries/Session.php */
