function AJAXRequest(init) {
        var objPool = [],
        AJAX = this,
        _pool = AJAXRequest.__pool__ || (AJAXRequest.__pool__ = []); (function(obj) {
                var emptyFun = function() {};
                obj = obj ? obj: {};
                var prop = ['url', 'content', 'method', 'async', 'encode', 'timeout', 'ontimeout', 'onrequeststart', 'onrequestend', 'oncomplete', 'onexception'];
                var defs = ['', '', 'GET', true, _GEC('UTF-8'), 3600000, emptyFun, emptyFun, emptyFun, emptyFun, emptyFun];  //UTF-8ΪGB2312
                var pc = prop.length;
                while (pc--) {
                        AJAX[prop[pc]] = getp(obj[prop[pc]], defs[pc])
                }
                if (!getXHR()) {
                        return false
                }
        })(init);
        function getp(p, d) {
                return p != undefined ? p: d
        }
        function getXHR() {
                var xhr, _vers = [window.XMLHttpRequest, "MSXML2.XMLHTTP", "Microsoft.XMLHTTP"];
                var i;
                for (i = 0; i < _pool.length; i += 1) {
                        if (_pool[i].readyState === 0 || _pool[i].readyState === 4) {
                                return _pool[i]
                        }
                }
                for (i = 0; i < _vers.length; i += 1) {
                        try {
                                xhr = (_vers[i] && typeof(_vers[i]) == "function" ? new _vers[i] : new ActiveXObject(_vers[i]));
                                break
                        } catch(e) {
                                xhr = false;
                                continue
                        }
                }
                if (!xhr) {
                        throw 'Cannot init XMLHttpRequest object!';
                } else {
                        _pool[_pool.length] = xhr;
                        return xhr
                }
        }
        function $(id) {
                return document.getElementById(id)
        }
        function _N(d) {
                var n = d * 1;
                return (isNaN(n) ? 0 : n)
        }
        function _VO(v) {
                return (typeof(v) == "string" ? (v = $(v)) ? v: false: v)
        }
        function _GID() {
                return ((new Date) * 1)
        }
        function _SOP(id, ct) {
                objPool[id + ""] = ct
        }
        function _LOP(id) {
                return (objPool[id + ""])
        }
        function _SRP(pre, reps, ps) {
                return (function rep(str) {
                        str = pre(str);
                        for (var i = 0,
                        n = reps.length; i < n; i += 1) {
                                str = str.replace(reps[i], ps[i])
                        }
                        return (str)
                })
        }
        function _GEC(cs) {
                if (cs.toUpperCase() == "UTF-8") {
                        return (encodeURIComponent)
                } else {
                        return (_SRP(escape, [/\+/g], ["%2B"]))
                }
        }
        function _ST(obj, txt) {
                if (!obj.nodeName) {
                        return
                }
                var nn = "|" + obj.nodeName.toUpperCase() + "|";
                if ("|INPUT|TEXTAREA|OPTION|".indexOf(nn) > -1) {
                        obj.value = txt
                } else {
                        try {
                                obj.innerHTML = txt
                        } catch(e) {}
                }
        }
        function _CB(cb) {
                if (typeof(cb) == "function") {
                        return cb
                } else {
                        cb = _VO(cb);
                        if (cb) {
                                return (function(obj) {
                                        _ST(cb, obj.responseText)
                                })
                        } else {
                                return AJAX.oncomplete
                        }
                }
        }
        function $GP(v, d, f) {
                var i = 0,
                p = [];
                while (i < v.length) {
                        p[i] = v[i] ? (f[i] ? f[i](v[i]) : v[i]) : d[i];
                        i += 1
                }
                while (i < d.length) {
                        p[i] = d[i];
                        i += 1
                }
                return p
        }
        function send() {
                var ct, ctf = false,
                xhr = getXHR();
                var p = $GP(arguments, [AJAX.url, AJAX.content, AJAX.oncomplete, AJAX.method, AJAX.async, null], [null, null, _CB, null, null, null]);
                var url = p[0],
                content = p[1],
                callback = p[2],
                method = p[3],
                async = p[4],
                extra = p[5];
                var isPost = method.toUpperCase() == "POST" ? true: false;
                if (!url) {
                        throw 'url is null';
                }
                var ev = {
                        url: encodeURI(url),
                        content: content,
                        method: method,
                        params: extra
                };
                if (!isPost) {
                        url += (url.indexOf("?") > -1 ? "&": "?") + "timestamp=" + _GID()
                }
                xhr.open(method, url, async);
                AJAX.onrequeststart(ev);
                if (isPost) {
                        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded")
                }
                xhr.setRequestHeader("X-Request-With", "XMLHttpRequest");
                ct = setTimeout(function() {
                        ctf = true;
                        xhr.abort()
                },
                AJAX.timeout);
                var rc = function() {
                        if (ctf) {
                                AJAX.ontimeout(ev);
                                AJAX.onrequestend(ev)
                        } else if (xhr.readyState == 4) {
                                clearTimeout(ct);
                                ev.status = xhr.status;
                                try {
                                        if (xhr.status == 200) {
                                                setTimeout(function() {
                                                        callback(xhr, extra)
                                                },
                                                0)
                                        } else {
                                                AJAX.onexception(ev)
                                        }
                                } catch(e) {
                                        AJAX.onexception(ev)
                                }
                                AJAX.onrequestend(ev)
                        }
                };
                xhr.onreadystatechange = rc;
                if (isPost) {
                        xhr.send(content)
                } else {
                        xhr.send("")
                }
                if (async === false) {
                        rc()
                }
                return true
        }
        this.setcharset = function(cs) {
                AJAX.encode = _GEC(cs)
        };
        this.get = function(url, callback, extra) {
                return send(url, '', callback, 'GET', AJAX.async, extra)
        };
        this.update = function(callback, url, interval, times, extra) {
                interval = _N(interval);
                times = _N(times);
                if (interval < 1) {
                        times = 1
                } else if (times < 1) {
                        times = Number.POSITIVE_INFINITY
                }
                var sendfoo = function() {
                        send(url, "", callback, "GET", AJAX.async, extra)
                };
                var updateid = _GID();
                var updatefoo = function(updateCount) {
                        sendfoo();
                        updateCount--;
                        if (updateCount > 0) {
                                _SOP(updateid, setTimeout(function() {
                                        updatefoo(updateCount)
                                },
                                interval))
                        }
                };
                updatefoo(times);
                return updateid
        };
        this.stopupdate = function(id) {
                clearTimeout(_LOP(id))
        };
        this.post = function(url, content, callback, extra) {
                return send(url, content, callback, "POST", AJAX.async, extra)
        };
        this.postf = function(formObj, callback, extra) {
                var p = [],
                vaf,
                pcbf,
                purl,
                pc,
                pm,
                ac = arguments.length,
                av = arguments;
                formObj = formObj ? _VO(formObj) : false;
                if (!formObj || formObj.nodeName != "FORM") {
                        return false
                }
                validfoo = formObj.getAttribute("onvalidate");
                validfoo = validfoo ? (typeof(validfoo) == "string" ? new Function(validfoo) : validfoo) : null;
                if (validfoo && !validfoo()) {
                        return false
                }
                var url = formObj.getAttribute("action"),
                method = formObj.getAttribute("method");
                var content = AJAX.formToStr(formObj);
                if (content.length === 0) {
                        return false
                }
                if (method.toUpperCase() == "POST") {
                        return send(url, content, callback, "POST", true, extra)
                } else {
                        url += (url.indexOf("?") > -1 ? "&": "?") + content;
                        return send(url, "", callback, "GET", true, extra)
                }
        };
        this.formToStr = function(formObj) {
                var qstr = "",
                and = "",
                elems = formObj.elements,
                elem, value;
                for (var i = 0; i < elems.length; ++i) {
                        elem = elems[i];
                        if (elem.name !== '') {
                                value = undefined;
                                switch (elem.type) {
                                case "select-one":
                                        if (elem.selectedIndex > -1) {
                                                value = elem.options[elem.selectedIndex].value
                                        } else {
                                                value = ""
                                        }
                                        break;
                                case "select-multiple":
                                        var opts = elem.options;
                                        for (var j = 0; j < opts.length; ++j) {
                                                if (opts[j].selected) {
                                                        qstr += and + elem.name + "=" + AJAX.encode(opts[j].value);
                                                        and = "&"
                                                }
                                        }
                                        break;
                                case "checkbox":
                                case "radio":
                                        if (elem.checked) {
                                                value = elem.value
                                        }
                                        break;
                                default:
                                        value = elem.value;
                                        break
                                }
                                if (value != undefined) {
                                        value = AJAX.encode(value);
                                        qstr += and + elem.name + "=" + value;
                                        and = "&"
                                }
                        }
                }
                return qstr
        }
}