<?php
// +-------------------------------------------------------------+
// | Copyright (c) 2014-2015 JYmusic音乐管理系统                 |
// +-------------------------------------------------------------
// | Author: 战神~~巴蒂 <378020023@qq.com> <http://www.jyuu.cn>  |
// +-------------------------------------------------------------+
namespace Addons\Email\Controller;
use Home\Controller\AddonsController;
use Think;
class EmailController extends AddonsController{
    /**
     * 后台首页-邮件配置
     * @param string $id
     */
    public function saveConfig(){
        if($_POST['config'] && is_array($_POST['config'])){
            $Config = M('Config');
            foreach ($_POST['config'] as $name => $value) {
                $map = array('name' => $name);
                $Config->where($map)->setField('value', $value);
            }
        }
        S('DB_CONFIG_DATA',null);
        $this->success('编辑成功。');
    }
    /**
     * 发送测试邮件
     */
    public function sendTestMail(){
        $map=array('name' => array('in', array(  0 => 'MAIL_SMTP_CE')));
        $db=M('config');
        $config=$db->where($map)->field('value')->select();
        //发送邮件
        $res=  $this->send_mail($config[0]['value'],'我','邮件标题','邮件正文');
        if ($res) {
            $this->success('发送测试邮件成功');
        } else {
            $this->error('发送失败');
        }
    }
   /**
    * 发送激活邮件
    */
	public function sendActivate($uid){  
		$db=M('ucenterMember');
		$user =$db->where(array('id'=>$uid))->field('username,password,email')->find();   	    	     	     	     	
     	$hash   =  $this->create_rand(48); //生成48位激活码
     	$data['cdkey'] = $hash;
     	$data['last_login_time'] = time();
     	M('Member')->where(array('uid'=>$uid))->save($data);  	
     	$url = 'http://'.$_SERVER['HTTP_HOST'].U('Member/activate',array("hash"=>$hash)); 
     	$mail = M('MailHistory')->where('id=1')->field('body,title,from')->find();	
     	$content = str_replace(array('http://{$activate_link}','{$username}','{$webname}'), array($url,$user['username'],C('WEB_SITE_NAME')),$mail['body']);
     	$res=  $this->send_mail($user['email'],'新用户',$mail['title'],$content);
     	if($res){
			$email = $this->getEmail($user['email']);
			$email = !$email ? U('Index/index') : $email;
			$this->success('注册成功,请登录邮箱激活!',$email);
        }else{        	
        	$this->success('邮件发送失败，请联系管理员！',U('Index/index'));
        }         
	}
    /**
     * 发送注册邮件
     */
    public function sendRegister($uid){
        $db=M('ucenterMember');
        $user =$db->where(array('id'=>$uid))->field('username,password,email')->find();
        $mail = M('MailHistory')->where('id=2')->field('body,title,from')->find();	
        $content = str_replace(array('{$hostlink}','{$username}','{$webname}'), array($_SERVER ['HTTP_HOST'],$user['username'],C('WEB_SITE_NAME')),$mail['body']);
        $res=  $this->send_mail($user['email'],'新用户',$mail['title'],$content);
    }
    /**
     * 发送找回密码邮件
     */
    public function renPassword($email){
    	$pwd = $this->create_rand(8);
    	$password = $this->think_ucenter_md5($pwd, UC_AUTH_KEY);
    	$db=M('ucenterMember');
        $user =$db->where(array('email'=>$email))->setField('password',$password);
    	$url = U('Member/login',"", "", true);      
   		$mail = M('MailHistory')->where('id=3')->field('body,title,from')->find();	
        $content = str_replace(array('http://{$loginlink}','{$pwd}','{$webname}'), array($url,$pwd,C('WEB_SITE_NAME')),$mail['body']);
        $res=  $this->send_mail($email,'我',$mail['title'],$content);
    	if($res){
			$email = $this->getEmail($email);
			$email = !$email ? U('Index/index') : $email;
			$this->success('新密码已发送至你的邮箱',$email);
        }else{        	
        	$this->success('邮件发送失败，请联系管理员！',U('Index/index'));
        } 
    }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
    /**
     * 文章推送邮件
     */
    Public function ressDocument() {
        $ids = I('request.ids');
        if (IS_POST) {
            if (empty($ids)) {
                $this->error('请选择要操作的数据');
            }
            foreach ($ids as $val) {
                $this->success('正在跳转...', U('/Addons/execute/_addons/Email/_controller/Email/_action/ressDocument/', array('ids' => $val)));
            }
            
        } else {
            $id = I('request.ids');
            $map = array('status' => 1);
            $mailList = D('MailList')->where($map)->select();
            foreach ($mailList as $k => $v) {
                $address[$v['id']] = $v['address'];
            }
            $data['address'] = implode('; ', $address);
            /* 获取详细信息 */
            $Document = D('Document');
            $info = $Document->detail($id);
            $this->assign('mailList', $data);
            $this->assign('info', $info);
            $this->display(T('Addons://Email@Email/sendEmail'));
        }
    }

    /**
     * 邮箱列表
     * @param string $address
     */
    public function mailList(){
        $address =I('address');
        $map = array('status' => 1);
        if ($address != '')
            $map['address'] = array('like', '%' . $address . '%');
        $mailList = D('MailList')->where($map)->select();
        $this->meta_title = "邮箱列表";
        $this->assign('mailList', $mailList);
        $this->assign('current','list');
        $this->display(T('Addons://Email@Email/mailList'));
    }
    public function setStatus(){
        $ids = I('ids');
        $status = I('get.status');
        $res = D('MailHistory')->where(array('id' => array('in', $ids)))->setField('status', $status);
        if ($res) {
            $this->success('删除成功');
        } else {
            $this->error('删除失败');
        }

    }
    /**
     * 添加邮箱
     * @param string $address
     */
    public function addEmail(){
        $address = I('address');
        if (IS_POST) {
            $check =  D('MailList')->where(array('address'=>$address))->find();
            if($check){
                if($check['status']){
                    $this->error('该邮箱已经存在');
                }
                else{
                   $res = D('MailList')->where(array('address'=>$address))->setField('status', 1);
                }
            }else{
                $res = D('MailList')->add(array('address' => $address, 'status' => 1, 'create_time' => time()));
           }
            if ($res) {
                $this->success('添加成功。');
            } else {
                $this->error('添加失败。');
            }
        } else {
            $this->display(T('Addons://Email@Email/addEmail'));
        }
    }

    /**删除邮箱
     * @param $ids
     */
    public function delEmail(){
        $ids = I('ids');
        $res = D('MailList')->where(array('id' => array('in', $ids)))->setField('status', 0);
        if ($res) {
            $this->success('删除成功');
        } else {
            $this->error('删除失败');
        }
    }
    /**
     * 发送邮件页面
     * @param string $ids
     */
    public function sendEmail(){
        $ids = I('ids');
        if(!empty($ids)){
	        $list = D('MailList')->where(array('id' => array('in', $ids)))->select();
	        foreach ($list as $k => $v) {
	            $address[$v['id']] = $v['address'];
	        }
	        $data['address'] = implode('; ', $address);
	        $this->assign($data);
    	}
    	$this->meta_title = "发送邮件";
        $this->display(T('Addons://Email@Email/sendEmail'));
    }
    
    /**
     * 执行发送邮件操作
     * @param $address 地址列表
     * @param string $title 邮件标题
     * @param string $body 邮件正文
     */
    public function doSendEmail(){
        $address = I('post.address');
        $title =I('post.title');
        $body = I('post.body');
       	$type = I('post.type'); //空新增  redro 重复发送
        $server_host = "http://" . $_SERVER ['HTTP_HOST'];
        if ($title == '' || $body == '') {
            $this->error('请填写完整信息！');
        }
        //获取邮件地址配置信息
        $address = explode('; ', $address);
        if ($type  != 'redro' ){
	        //将邮件内容写入数据库
	        $data = D('MailHistory')->create();
	        $data['create_time'] = time();
	        $data['from'] = C('WEB_SITE_NAME');
	        $data['body'] = preg_replace("/\s+/",' ',$data['body']); 
	        $history = D('MailHistory')->add($data);
	    }
        //匹配图片地址
        preg_match_all('/src="([^http].*?)"/', $body, $out);
        $body = str_replace($out[1][0], $server_host . $out[1][0], $body);
        $res=false;
        if ($address[0] == '') {
            $address = D('MailList')->where(array('status' => 1))->field('address')->select();
            foreach ($address as $k => &$v) {
                $v = $v['address']; 
            }
        }
        foreach ($address as $k => $v) {
            if ($token_data = D('MailToken')->where(array('email' => $v))->select()) {
                $token = $token_data[0]['token'];
            } else {
                $token = $this->create_rand(10);
                $data_token['token'] = $token;
                $data_token['email'] = $v;
                D('MailToken')->add($data_token);
            }
            $url = $server_host .addons_url('Email://Email/unsubscribe', array('token' => $token));
            //发送邮件
            $body1 = $body . '<hr/><div style="float:right;margin-right: 20px;"><a href="' . $url . '">取消订阅</a></div>';
           	$status=$this->send_mail($v,'ss',$title,$body1);
            //将发送情况和状态写入数据库
            $data_link['status'] = $status;
            $data_link['mail_id'] = $history;
            $data_link['to'] = $v;
            $link = D('MailHistoryLink')->add($data_link);
            if($status){
                $res=true;
            }
        }
        if($res){
        	$this->success('邮件发送成功', addons_url('Email://Email/mailList'));
        }
    }
    /**
     * 邮件订阅
     */
    public function subscribe(){
        $email_address = I('email_address');
        $match = preg_match("/^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+$/", $email_address);

        if( $email_address =='' || !$match){
            $this->error('邮箱格式不正确');
        }

        $check = D('MailList')->where(array('address' => $email_address))->find();
        if ($check) {
             if($check['status']){
                    $this->error('该邮箱已经存在');
                }
                else{
                    $res = D('MailList')->where(array('address'=>$email_address))->setField('status', 1);
                }

        } else {
            $res = D('MailList')->add(array('address' => $email_address, 'status' => 1, 'create_time' => time()));

        }
        if ($res) {
            $this->success('订阅成功.');
        } else {
            $this->error(' 订阅失败');
        }
    }
    /**
     * 邮件取消订阅
     * @param string $title
     */
    public function unsubscribe(){
        $token = I('token');
        if ($token) {
            $arr = D('MailToken')->where(array('token' => $token))->find();
            $res = D('MailList')->where(array('address' => $arr['email']))->setField('status', 0);
            D('MailToken')->where(array('token' => $token))->delete();
            if ($res) {
                $this->success('取消订阅成功',  "Home");
            } else {
                $this->error('取消订阅失败', "Home");
            }
        }
    }

    /**
     * 邮件记录
     * @param string $title
     */
    public function lists(){    	
        $title = I('title');
        $model = I('model');
        $model = isset($model)? $model : 0;  
        $map = array('status' => 1,'model'=>$model);
        if ($title != '')
            $map['title'] = array('like', '%' . $title . '%');
        	$mailList = D('MailHistory')->where($map)->field('body',true)->order('id desc')->select();
        foreach ($mailList as $k => &$v) {
            $v['title'] = $this->getShortSp($v['title'],80);
        }
        $this->assign('mailList',$mailList);
       $this->display(T('Addons://Email@Email/lists'));
    }
    /**
     * 字符串截取
     * @param string $title
     * @param string $lenth
     */
    public function getShortSp($title,$lenth=20){
        $str=  substr($title, 0,$lenth);
        if (mb_detect_encoding($str) == 'UTF-8') {//判断内容编码是否为UTF-8
            $str = $str;
        } else {
            $str = iconv('GB2312', 'UTF-8', $str);
        }
        return $str; 
    }
   	
    /**
     * 邮件详情
     * @param string $id
     */
    public function mailDetail(){    	
    	if(IS_POST){
            $Mail= D('MailHistory');
            $data = $Mail->create();
			dump($data);
            $Mail->body = $data['body']; 
            if($data){
                if($Mail->save()!== false){
                    $this->success('更新成功',Cookie('__forward__'));
                } else {
                    $this->error('更新失败');
                }
            } else {
                $this->error($Artisttype->getError());
            }
        }else{
	        $id = I('id');
	        Cookie('__forward__',$_SERVER['REQUEST_URI']);
	        $history = D('MailHistory')->where(array('id' => $id))->find();
	        //$link = D('MailHistoryLink')->where(array('mail_id' => $id))->select();
	        $this->assign('dak', $history);
	        //$this->assign('link', $link);
    	}
        $this->display(T('Addons://Email@Email/mailDetail'));
    }
    /**
     * 系统邮件发送函数
     * @param string $to    接收邮件者邮箱
     * @param string $name  接收邮件者名称
     * @param string $subject 邮件主题 
     * @param string $body    邮件内容
     * @param string $attachment 附件列表
     * @return boolean 
     */
    function send_mail($to, $name, $subject = '', $body = '', $attachment = null){
        $map=array('name' => array('in', array( 1 => 'MAIL_SMTP_HOST', 2 => 'MAIL_SMTP_PORT', 3 => 'MAIL_SMTP_USER', 4 => 'MAIL_SMTP_PASS', 5 => 'MAIL_SMTP_CE', 6 => 'FROM_EMAIL')));
        $db=M('config');
        $conf=$db->where($map)->field('value,name')->select();
        $config='';
        foreach ($conf as $k=>$v){
            $config[$v['name']]=$v['value'];
        }
        vendor('PHPMailer.PHPMailerAutoload'); //从PHPMailer目录导class.phpmailer.php类文件
        $mail             = new \PHPMailer(); //PHPMailer对象
        $mail->CharSet    = 'UTF-8'; //设定邮件编码，默认ISO-8859-1，如果发中文此项必须设置，否则乱码
        $mail->IsSMTP();  // 设定使用SMTP服务
        $mail->SMTPDebug  = 0;                     // 关闭SMTP调试功能
                                                   // 1 = errors and messages
                                                   // 2 = messages only
        $mail->SMTPAuth   = true;                  // 启用 SMTP 验证功能
        $mail->SMTPSecure = 'ssl';                 // 使用安全协议
        $mail->Host       = $config['MAIL_SMTP_HOST'];  // SMTP 服务器
        $mail->Port       = $config['MAIL_SMTP_PORT'];  // SMTP服务器的端口号
        $mail->Username   = $config['MAIL_SMTP_USER'];  // SMTP服务器用户名
        $mail->Password   = $config['MAIL_SMTP_PASS'];  // SMTP服务器密码
        $from=$config['FROM_EMAIL']?$config['FROM_EMAIL']:C('WEB_SITE_NAME');
        $mail->SetFrom($config['MAIL_SMTP_USER'],$from );
        $replyEmail       = $config['REPLY_EMAIL']?$config['REPLY_EMAIL']:$config['FROM_EMAIL'];
        $replyName        = $config['REPLY_NAME']?$config['REPLY_NAME']:$config['FROM_NAME'];
        $mail->AddReplyTo($replyEmail, $replyName);
        $mail->Subject    = $subject;
        $mail->MsgHTML($body);
        $mail->AddAddress($to, $name);
        if(is_array($attachment)){ // 添加附件
            foreach ($attachment as $file){
                is_file($file) && $mail->AddAttachment($file);
            }
        }
        return $mail->Send() ? true : $mail->ErrorInfo;
    }
    
    
    /**
     * 随机生成字符串
     * @param int $length
     * @return string
     */
    private function create_rand($length = 8){
        $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $password = '';
        for ($i = 0; $i < $length; $i++) {
            $password .= $chars[mt_rand(0, strlen($chars) - 1)];
        }
        return $password;
    } 
    
    private function think_ucenter_md5($str, $key = 'ThinkUCenter'){
		return '' === $str ? '' : md5(sha1($str) . $key);
	}
    
   /**
     * 根据邮箱获取邮箱网址
     * @param $email
     * @return bool|string
     */
    public static function getEmail($email){
        $data = array('163.com' => 'mail.163.com','vip.163.com' => 'vip.163.com','126.com' => 'mail.126.com','qq.com' => 'mail.qq.com','vip.qq.com' => 'mail.qq.com','foxmail.com' => 'mail.qq.com','gmail.com' => 'mail.google.com','sohu.com' => 'mail.sohu.com','tom.com' => 'mail.tom.com','vip.sina.com' => 'vip.sina.com','sina.com.cn' => 'mail.sina.com.cn','sina.com' => 'mail.sina.com.cn','yahoo.com.cn' => 'mail.cn.yahoo.com','yahoo.cn' => 'mail.cn.yahoo.com','yeah.net' => 'www.yeah.net','21cn.com' => 'mail.21cn.com','hotmail.com' => 'www.hotmail.com','sogou.com' => 'mail.sogou.com','188.com' => 'www.188.com','139.com' => 'mail.10086.cn','189.cn' => 'webmail15.189.cn/webmail',); 
        $email_url = substr($email, strpos($email, "@") + 1);
        $email_url = strtolower($email_url);
        if (isset($data[$email_url])) {
            $email_url = $data[$email_url];
        } else {
            $email_url = false;
        }
        return 'http://'.$email_url;
    }
	
}
