DROP TABLE IF EXISTS m_cache;
CREATE TABLE m_cache (
  cachekey varchar(255) NOT NULL DEFAULT '',
  cachevalue mediumtext NOT NULL,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (cachekey)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_manager;
CREATE TABLE IF NOT EXISTS m_manager (
  m_id int(11) NOT NULL auto_increment,
  m_username varchar(64) NOT NULL,
  m_pwd varchar(64) NOT NULL,
  m_state int(11) NOT NULL default '1',
  m_logintime int(10) NOT NULL default '0',
  m_loginip varchar(128) default NULL,
  m_level int(11) default '0',
  m_random varchar(128) NOT NULL,
  PRIMARY KEY  (m_id)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_slide;
CREATE TABLE IF NOT EXISTS m_slide (
  m_id int(11) NOT NULL auto_increment,
  m_name varchar(255) default NULL,
  m_pic varchar(255) default NULL,
  m_url varchar(255) default NULL,
  m_des text,
  m_sort int(11) NOT NULL default '0',
  PRIMARY KEY  (m_id)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

INSERT INTO m_slide VALUES('1','1','1.jpg','http://www.djcms.net','0','0');
INSERT INTO m_slide VALUES('2','2','2.jpg','http://www.sina.com','0','0');
INSERT INTO m_slide VALUES('3','3','3.jpg','http://sohu.com','0','0');

DROP TABLE IF EXISTS m_type;
CREATE TABLE IF NOT EXISTS m_type (
  m_id mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  m_name char(30) NOT NULL DEFAULT '',
  m_enname char(60) NOT NULL DEFAULT '',
  m_sort int(11) NOT NULL DEFAULT '0',
  m_upid tinyint(6) unsigned NOT NULL default '0',
  m_hide smallint(6) NOT NULL default '0',
  m_template char(50) NOT NULL DEFAULT '',
  m_subtemplate char(50) NOT NULL DEFAULT '',
  m_unionid char(60) NOT NULL DEFAULT '',
  m_keyword mediumtext,
  m_description mediumtext,
  m_type mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY  (m_id),
  KEY m_name (m_name)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_info;
CREATE TABLE IF NOT EXISTS m_info (
  m_id mediumint(8) unsigned NOT NULL auto_increment,
  m_author char(80) NOT NULL default '',
  m_title char(255) NOT NULL default '',
  m_type char(20) NOT NULL default '',
  m_videoid mediumint(8) unsigned NOT NULL default '0',
  m_content mediumtext,
  m_ip char(20) NOT NULL default '',
  m_addtime int(10) unsigned NOT NULL default '0',
  m_color char(20) NOT NULL default '',
  m_hit mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (m_id),
  KEY `m_videoid` (m_videoid,m_hit),
  KEY `m_addtime` (m_addtime)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_leaveword;
CREATE TABLE IF NOT EXISTS m_leaveword (
  `m_id` mediumint(8) unsigned NOT NULL auto_increment,
  `m_replyid` mediumint(8) unsigned NOT NULL default '0',
  `m_author` char(255) NOT NULL default '',
  `m_qq` char(20) NOT NULL default '',
  `m_mail` char(50) NOT NULL default '',
  `m_content` mediumtext,
  `m_ip` char(20) NOT NULL default '',
  `m_addtime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`m_id`),
  KEY `m_replyid` (`m_replyid`),
  KEY `m_addtime` (`m_addtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_data;
CREATE TABLE IF NOT EXISTS m_data (
  `m_id` mediumint(8) unsigned NOT NULL auto_increment,
  `m_name` char(60) NOT NULL default '',
  `m_type` smallint(8) unsigned NOT NULL default '0',
  `m_state` int(10) unsigned NOT NULL default '0',
  `m_pic` char(100) NOT NULL default '',
  `m_hit` mediumint(8) unsigned NOT NULL default '0',
  `m_digg` smallint(6) NOT NULL default '0',
  `m_tread` smallint(6) NOT NULL default '0',
  `m_count` smallint(6) NOT NULL default '0',
  `m_tood` varchar(50) default NULL,
  `m_nameme` varchar(255) default NULL,
  `m_actor` varchar(255) default NULL,
  `m_note` mediumtext,
  `m_des` mediumtext,
  `m_topic` mediumint(8) unsigned NOT NULL default '0',
  `m_color` char(7) NOT NULL default '',
  `m_commend` smallint(6) NOT NULL default '0',
  `m_wrong` smallint(8) unsigned NOT NULL default '0',
  `m_addtime` int(10) unsigned NOT NULL default '0',
  `m_publishyear` int(10) NOT NULL default '0',
  `m_publisharea` char(20) NOT NULL default '',
  `m_playdata` mediumtext,
  `m_downdata` mediumtext,
  `m_isunion` smallint(6) NOT NULL default '0',
  `m_letter` char(3) NOT NULL default '',
  `m_keyword` varchar(50) default NULL,
  `m_director` varchar(30) default NULL,
  `m_lang` varchar(120) default NULL,
  `m_dayhit` mediumint(8) unsigned NOT NULL default '0',
  `m_weekhit` mediumint(8) unsigned NOT NULL default '0',
  `m_monthhit` mediumint(8) unsigned NOT NULL default '0',
  `m_enname` varchar(120) default NULL,
  `m_datetime` int(10) unsigned NOT NULL default '0',
  `m_recycle` mediumint(8) unsigned NOT NULL default '0',
  `m_score` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`m_id`),
  KEY m_type (m_type)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_news;
CREATE TABLE IF NOT EXISTS m_news (
  `m_id` mediumint(8) unsigned NOT NULL auto_increment,
  `m_type` smallint(8) unsigned NOT NULL default '0',
  `m_vid` smallint(8) unsigned NOT NULL default '0',
  `m_title` char(100) NOT NULL default '',
  `m_author` char(80) NOT NULL default '',
  `m_color` char(20) NOT NULL default '',
  `m_pic` char(200) NOT NULL default '',
  `m_from` char(50) NOT NULL default '',
  `m_keyword` mediumtext,
  `m_outline` mediumtext,
  `m_content` mediumtext,
  `m_commend` mediumint(8) unsigned NOT NULL default '0',
  `m_hit` mediumint(8) unsigned NOT NULL default '0',
  `m_dayhit` mediumint(8) unsigned NOT NULL default '0',
  `m_weekhit` mediumint(8) unsigned NOT NULL default '0',
  `m_monthhit` mediumint(8) unsigned NOT NULL default '0',
  `m_note` mediumint(8) unsigned NOT NULL default '0',
  `m_topic` mediumint(8) unsigned NOT NULL default '0',
  `m_digg` mediumint(8) unsigned NOT NULL default '0',
  `m_tread` mediumint(8) unsigned NOT NULL default '0',
  `m_entitle` char(120) NOT NULL default '',
  `m_letter` char(1) NOT NULL default '',
  `m_addtime` int(10) unsigned NOT NULL default '0',
  `m_datetime` int(10) unsigned NOT NULL default '0',
  `m_recycle` mediumint(8) unsigned NOT NULL default '0',
  `m_score` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`m_id`),
  KEY m_type (m_type)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_review;
CREATE TABLE IF NOT EXISTS m_review (
  `m_id` smallint(6) unsigned NOT NULL auto_increment,
  `m_author` char(80) NOT NULL default '',
  `m_type` smallint(8) unsigned NOT NULL default '0',
  `m_videoid` smallint(8) unsigned NOT NULL default '0',
  `m_content` mediumtext,
  `m_ip` char(20) NOT NULL default '',
  `m_addtime` int(10) unsigned NOT NULL default '0',
  `m_reply` smallint(8) unsigned NOT NULL default '0',
  `m_agree` smallint(8) unsigned NOT NULL default '0',
  `m_anti` smallint(8) unsigned NOT NULL default '0',
  `m_pic` mediumtext,
  `m_vote` smallint(8) unsigned NOT NULL default '0',
  `m_check` smallint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`m_id`),
  KEY `m_type` (`m_type`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_topic;
CREATE TABLE IF NOT EXISTS m_topic (
  `m_id` smallint(6) unsigned NOT NULL auto_increment,
  `m_name` char(30) NOT NULL default '',
  `m_enname` char(60) NOT NULL default '',
  `m_sort` int(11) NOT NULL default '0',
  `m_template` char(50) NOT NULL default '',
  `m_pic` char(80) NOT NULL default '',
  `m_des` text,
  PRIMARY KEY  (`m_id`),
  KEY `m_sort` (`m_sort`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_link;
CREATE TABLE IF NOT EXISTS m_link (
  `m_id` smallint(5) unsigned NOT NULL auto_increment,
  `m_type` char(10) NOT NULL default '',
  `m_name` char(100) NOT NULL default '',
  `m_pic` char(200) NOT NULL default '',
  `m_url` char(200) NOT NULL default '',
  `m_des` char(255) NOT NULL default '',
  `m_sort` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`m_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

INSERT INTO `m_link` VALUES('7','font','ſ','','http://www.youku.com','','1');
INSERT INTO `m_link` VALUES('12','font','','','http://www.tudou.com','','2');
INSERT INTO `m_link` VALUES('13','font','Դ֮','','http://www.mycodes.net','','3');

DROP TABLE IF EXISTS m_ads;
CREATE TABLE IF NOT EXISTS m_ads (
  `m_id` mediumint(8) unsigned NOT NULL auto_increment,
  `m_name` varchar(100) NOT NULL default '',
  `m_enname` varchar(60) NOT NULL default '',
  `m_des` char(255) NOT NULL default '',
  `m_content` text,
  `m_addtime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`m_id`),
  KEY `m_addtime` (`m_addtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

INSERT INTO `m_ads` VALUES('1','ҳмλ','index-top-middle','460,60','document.writeln(&quot;&lt;a href=\\&quot;http:\\/\\/bbs.tfdj.com\\&quot; target=\\&quot;_blank\\&quot; class=\\&quot;imgflaot\\&quot;&gt;&lt;img src=\\&quot;/&quot;+sitePath+&quot;template/default/images\\/460-60.jpg\\&quot; \\/&gt;&lt;\\/a&gt;&quot;)','1280249729');
INSERT INTO `m_ads` VALUES('2','ҳͨλ','index-nav-banner','950,90','/*ҳ·λ´뻻Ĺ뼴*/\r\ndocument.writeln(&quot;&lt;a href=\\&quot;http:\\/\\/bbs.tfdj.com\\&quot; target=\\&quot;_blank\\&quot;&gt;&lt;img src=\\&quot;/&quot;+sitePath+&quot;template/default/images\\/950-90c1.jpg\\&quot; \\/&gt;&lt;\\/a&gt;&quot;)','1280249724');
INSERT INTO `m_ads` VALUES('3','ҳҲλ','index-top-right','285,60','document.writeln(&quot;&lt;a href=\\&quot;http:\\/\\/bbs.tfdj.com\\/forumdisplay.php?fid=97\\&quot; target=\\&quot;_blank\\&quot; class=\\&quot;imgfloat\\&quot;&gt;&lt;img src=\\&quot;/&quot;+sitePath+&quot;template/default/images\\/285-60.jpg\\&quot; \\/&gt;&lt;\\/a&gt;&quot;)','1280249719');
INSERT INTO `m_ads` VALUES('4','ҳͨλ','index-bottom','950,90','document.writeln(&quot;&lt;a href=\\&quot;http:\\/\\/bbs.tfdj.com\\&quot; target=\\&quot;_blank\\&quot;&gt;&lt;img src=\\&quot;/&quot;+sitePath+&quot;template/default/images\\/adindextop_02.jpg\\&quot; \\/&gt;&lt;\\/a&gt;&quot;)','1280249685');
INSERT INTO `m_ads` VALUES('5','Ƶҳͨλ','channel-nav-banner','950,90','/*Ƶҳ·λ´뻻Ĺ뼴*/\r\ndocument.writeln(&quot;&lt;a href=\\&quot;http:\\/\\/bbs.tfdj.com\\&quot; target=\\&quot;_blank\\&quot;&gt;&lt;img src=\\&quot;/&quot;+sitePath+&quot;template/default/images\\/950-90c1.jpg\\&quot; \\/&gt;&lt;\\/a&gt;&quot;)','1280249680');
INSERT INTO `m_ads` VALUES('6','ҳͨλ','content-nav-banner','950,90','/*ҳͨλ´뻻Ĺ뼴*/\r\ndocument.writeln(&quot;&lt;a href=\\&quot;http:\\/\\/bbs.tfdj.com\\&quot; target=\\&quot;_blank\\&quot;&gt;&lt;img src=\\&quot;/&quot;+sitePath+&quot;template/default/images\\/950-90c1.jpg\\&quot; \\/&gt;&lt;\\/a&gt;&quot;)','1280249675');
INSERT INTO `m_ads` VALUES('7','ҳҲͨλ','content-intro-banner','465,60','/*ҳҲͨλ´뻻Ĺ뼴*/\r\ndocument.writeln(&quot;&lt;a href=\\&quot;http:\\/\\/bbs.tfdj.com\\/forumdisplay.php?fid=97\\&quot; target=\\&quot;_blank\\&quot;&gt;&lt;img src=\\&quot;/&quot;+sitePath+&quot;template/default/images\\/465-60.jpg\\&quot;\\/&gt;&lt;\\/a&gt;&quot;)','1280249669');
INSERT INTO `m_ads` VALUES('8','ҳͨλ','search-nav-banner','950,90','/*ҳͨλ´뻻Ĺ뼴*/\r\ndocument.writeln(&quot;&lt;a href=\\&quot;http:\\/\\/bbs.tfdj.com\\&quot; target=\\&quot;_blank\\&quot;&gt;&lt;img src=\\&quot;/&quot;+sitePath+&quot;template/default/images\\/950-90c1.jpg\\&quot; \\/&gt;&lt;\\/a&gt;&quot;)','1280249663');
INSERT INTO `m_ads` VALUES('9','ҳҲλ','play-right','215185','/*ҳҲλ,´뻻Ĺ뼴*/\r\ndocument.writeln(&quot;&lt;a href=\\&quot;http:\\/\\/bbs.tfdj.com\\&quot; target=\\&quot;_blank\\&quot;&gt;&lt;img src=\\&quot;/&quot;+sitePath+&quot;template/default/images\\/215-185.jpg\\&quot;&gt;&lt;\\/a&gt;&quot;)','1280249658');
INSERT INTO `m_ads` VALUES('10','бҳͨλ','newsindex-nav-banner','950,90','/*бҳ·λ´뻻Ĺ뼴*/\r\ndocument.writeln(&quot;&lt;a href=\\&quot;http:\\/\\/www.tfdj.com\\&quot; target=\\&quot;_blank\\&quot;&gt;&lt;img src=\\&quot;/&quot;+sitePath+&quot;template/default/images\\/950-90c1.jpg\\&quot; \\/&gt;&lt;\\/a&gt;&quot;)','1280249653');
INSERT INTO `m_ads` VALUES('11','רбҳͨλ','topicindex-top','950,90','/*רҳ·λ´뻻Ĺ뼴*/\r\ndocument.writeln(&quot;&lt;a href=\\&quot;http:\\/\\/bbs.tfdj.com\\&quot; target=\\&quot;_blank\\&quot;&gt;&lt;img src=\\&quot;/&quot;+sitePath+&quot;template/default/images\\/950-90c1.jpg\\&quot; \\/&gt;&lt;\\/a&gt;&quot;)','1280249647');

DROP TABLE IF EXISTS m_selflabel;
CREATE TABLE IF NOT EXISTS m_selflabel (
  `m_id` mediumint(8) unsigned NOT NULL auto_increment,
  `m_name` varchar(40) NOT NULL default '',
  `m_content` text,
  `m_des` varchar(50) NOT NULL default '0',
  `m_addtime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`m_id`),
  KEY `m_addtime` (`m_addtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

INSERT INTO `m_selflabel` VALUES('1','areasearch','&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=2&searchword=½&apos; target=&quot;_blank&quot;&gt;½&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=2&searchword=&apos;target=&quot;_blank&quot;&gt;&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=2&searchword=̨&apos;target=&quot;_blank&quot;&gt;̨&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=2&searchword=ձ&apos; target=&quot;_blank&quot;&gt;ձ&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=2&searchword=&apos; target=&quot;_blank&quot;&gt;&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=2&searchword=ŷ&apos; target=&quot;_blank&quot;&gt;ŷ&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=2&searchword=&apos; target=&quot;_blank&quot;&gt;&lt;/a&gt;','','1245922775');
INSERT INTO `m_selflabel` VALUES('2','yearsearch','&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=3&searchword=2009&apos; target=&quot;_blank&quot;&gt;2009&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=3&searchword=2008&apos;target=&quot;_blank&quot;&gt;2008&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=3&searchword=2007&apos; target=&quot;_blank&quot;&gt;2007&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=3&searchword=2006&apos; target=&quot;_blank&quot;&gt;2006&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=3&searchword=2005&apos; target=&quot;_blank&quot;&gt;2005&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=3&searchword=2004&apos; target=&quot;_blank&quot;&gt;2004&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=3&searchword=2003&apos; target=&quot;_blank&quot;&gt;2003&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=3&searchword=2002&apos; target=&quot;_blank&quot;&gt;2002&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=3&searchword=2001&apos; target=&quot;_blank&quot;&gt;2001&lt;/a&gt;','ݲ鿴Ӱ','1245541360');
INSERT INTO `m_selflabel` VALUES('3','actorsearch','&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=1&searchword=Աɽ&apos; target=&quot;_blank&quot;&gt;Աɽ&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=1&searchword=С&apos; target=&quot;_blank&quot;&gt;С&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=1&searchword=ǫ&apos;target=&quot;_blank&quot;&gt;ǫ&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=1&searchword=&apos; target=&quot;_blank&quot;&gt;&lt;/a&gt; \r\n&lt;a href=&apos;/{djcms:sitepath}search.php?searchtype=1&searchword=ܽ&apos; target=&quot;_blank&quot;&gt;ܽ&lt;/a&gt; \r\n','Ա','1260761469');
INSERT INTO `m_selflabel` VALUES('4','nav_bottom_banner','aaaaaaaaaaaaaaaaaaaaaa\r\n$$$\r\nbbbbbbbbbbbbbbbbbbbbbb\r\n$$$\r\neeeeeeeeeeeeeeeeeeeeee','·ͨ','1246189814');

DROP TABLE IF EXISTS m_temp;
CREATE TABLE IF NOT EXISTS m_temp (
  `m_id` mediumint(8) unsigned NOT NULL auto_increment,
  `m_name` char(60) NOT NULL default '',
  `m_type` smallint(8) unsigned NOT NULL default '0',
  `m_state` int(10) unsigned NOT NULL default '0',
  `m_pic` char(100) NOT NULL default '',
  `m_actor` varchar(200) default NULL,
  `m_des` mediumtext,
  `m_addtime` int(10) unsigned NOT NULL default '0',
  `m_playdata` mediumtext,
  `m_publishyear` int(10) NOT NULL default '0',
  `m_publisharea` char(20) NOT NULL default '',
  `m_director` varchar(50) default NULL,
  `m_lang` varchar(30) default NULL,
  PRIMARY KEY  (`m_id`),
  KEY `m_type` (`m_type`),
  KEY `m_addtime` (`m_addtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_collect;
CREATE TABLE IF NOT EXISTS m_collect (
  `id` int(11) NOT NULL auto_increment,
  `itemname` char(50) NOT NULL default '',
  `siteurl` char(200) NOT NULL default '',
  `charset` char(50) NOT NULL default '',
  `playfrom` char(50) NOT NULL default '',
  `enable` int(11) default '0',
  `intoa` int(11) default '0',
  `autocls` int(11) default '0',
  `classid` int(11) default '0',
  `isupdate` int(11) default '0',
  `getherday` int(11) default '0',
  `inithit` int(11) default '0',
  `pageset` int(11) default '0',
  `pageurl0` char(200) NOT NULL default '',
  `pageurl1` char(200) NOT NULL default '',
  `pageurl2` char(200) NOT NULL default '',
  `istart` int(11) default '0',
  `iend` int(11) default '0',
  `reverse` int(11) default '0',
  `removecode` mediumtext,
  `des` mediumtext,
  `publi` int(10) NOT NULL default '0',
  `CollectTime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_cls;
CREATE TABLE IF NOT EXISTS m_cls (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `clsname` varchar(50) NOT NULL default '',
  `sysclsid` smallint(5) unsigned NOT NULL default '0',
  `publi` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `sysclsid` (`sysclsid`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_cregion;
CREATE TABLE IF NOT EXISTS m_cregion (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `clsname` varchar(50) NOT NULL default '',
  `syscls` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_tempdata;
CREATE TABLE IF NOT EXISTS m_tempdata (
  `m_id` mediumint(8) unsigned NOT NULL auto_increment,
  `m_name` char(60) NOT NULL default '',
  `m_type` smallint(8) unsigned NOT NULL default '0',
  `m_state` int(10) unsigned NOT NULL default '0',
  `m_pic` char(100) NOT NULL default '',
  `m_hit` mediumint(8) unsigned NOT NULL default '0',
  `m_digg` smallint(6) NOT NULL default '0',
  `m_tread` smallint(6) NOT NULL default '0',
  `m_count` smallint(6) NOT NULL default '0',
  `m_tood` varchar(50) default NULL,
  `m_nameme` varchar(255) default NULL,
  `m_actor` varchar(255) default NULL,
  `m_note` mediumtext,
  `m_des` mediumtext,
  `m_topic` mediumint(8) unsigned NOT NULL default '0',
  `m_color` char(7) NOT NULL default '',
  `m_commend` smallint(6) NOT NULL default '0',
  `m_wrong` smallint(8) unsigned NOT NULL default '0',
  `m_addtime` int(10) unsigned NOT NULL default '0',
  `m_publishyear` int(10) NOT NULL default '0',
  `m_publisharea` char(20) NOT NULL default '',
  `m_playdata` mediumtext,
  `m_downdata` mediumtext,
  `m_isunion` smallint(6) NOT NULL default '0',
  `m_letter` char(3) NOT NULL default '',
  `m_keyword` varchar(50) default NULL,
  `m_typename` varchar(50) default NULL,
  `m_fromurl` varchar(255) default NULL,
  `m_inbase` mediumint(8) unsigned NOT NULL default '0',
  `m_director` varchar(30) default NULL,
  `m_lang` varchar(120) default NULL,
  `m_dayhit` mediumint(8) unsigned NOT NULL default '0',
  `m_weekhit` mediumint(8) unsigned NOT NULL default '0',
  `m_monthhit` mediumint(8) unsigned NOT NULL default '0',
  `m_enname` varchar(120) default NULL,
  `m_datetime` int(10) unsigned NOT NULL default '0',
  `m_recycle` mediumint(8) unsigned NOT NULL default '0',
  `m_score` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`m_id`),
  KEY m_type (m_type)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_tempnews;
CREATE TABLE IF NOT EXISTS m_tempnews (
  `m_id` mediumint(8) unsigned NOT NULL auto_increment,
  `m_type` smallint(8) unsigned NOT NULL default '0',
  `m_vid` smallint(8) unsigned NOT NULL default '0',
  `m_title` char(100) NOT NULL default '',
  `m_author` char(80) NOT NULL default '',
  `m_color` char(20) NOT NULL default '',
  `m_pic` char(200) NOT NULL default '',
  `m_from` char(50) NOT NULL default '',
  `m_keyword` mediumtext,
  `m_outline` mediumtext,
  `m_content` mediumtext,
  `m_commend` mediumint(8) unsigned NOT NULL default '0',
  `m_hit` mediumint(8) unsigned NOT NULL default '0',
  `m_dayhit` mediumint(8) unsigned NOT NULL default '0',
  `m_weekhit` mediumint(8) unsigned NOT NULL default '0',
  `m_monthhit` mediumint(8) unsigned NOT NULL default '0',
  `m_note` mediumint(8) unsigned NOT NULL default '0',
  `m_topic` mediumint(8) unsigned NOT NULL default '0',
  `m_digg` mediumint(8) unsigned NOT NULL default '0',
  `m_tread` mediumint(8) unsigned NOT NULL default '0',
  `m_entitle` char(120) NOT NULL default '',
  `m_letter` char(1) NOT NULL default '',
  `m_addtime` int(10) unsigned NOT NULL default '0',
  `m_datetime` int(10) unsigned NOT NULL default '0',
  `m_recycle` mediumint(8) unsigned NOT NULL default '0',
  `m_score` mediumint(8) unsigned NOT NULL default '0',
  `m_inbase` mediumint(8) unsigned NOT NULL default '0',
  `m_typename` varchar(50) default NULL,
  `m_fromurl` varchar(255) default NULL,
  PRIMARY KEY  (`m_id`),
  KEY m_type (m_type)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS m_fword;
CREATE TABLE IF NOT EXISTS m_fword (
  `m_id` mediumint(8) unsigned NOT NULL auto_increment,
  `m_name` char(60) NOT NULL default '',
  `m_rcolumn` smallint(8) unsigned NOT NULL default '0',
  `m_uesmode` smallint(8) unsigned NOT NULL default '0',
  `m_sfind` char(100) NOT NULL default '',
  `m_sstart` mediumtext,
  `m_send` mediumtext,
  `m_sreplace` mediumtext,
  `m_flag` smallint(6) NOT NULL default '0',
  `m_ison` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`m_id`),
  KEY `m_name` (`m_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `m_crons`;
CREATE TABLE `m_crons` (
  `cronid` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `available` tinyint(1) NOT NULL DEFAULT '0',
  `type` enum('user','system') NOT NULL DEFAULT 'user',
  `name` char(50) NOT NULL DEFAULT '',
  `filename` char(50) NOT NULL DEFAULT '',
  `lastrun` int(10) unsigned NOT NULL DEFAULT '0',
  `nextrun` int(10) unsigned NOT NULL DEFAULT '0',
  `months` char(36) NOT NULL DEFAULT '',
  `days` char(85) NOT NULL DEFAULT '',
  `hours` char(65) NOT NULL DEFAULT '',
  `minutes` char(175) NOT NULL DEFAULT '',
  `paramets` char(255) NOT NULL DEFAULT '',
  `des` mediumtext,
  PRIMARY KEY (`cronid`),
  KEY `nextrun` (`available`,`nextrun`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=1 ;