<?php
class cache {
    
	//禁止实例化
	private function __construct() {}

	public static function get($key) {
		static $data = null;
		if(!isset($data[$key])) {
			$cache = DB::fetch_first("SELECT * FROM ".DB::table('cache')." WHERE cachekey='$key'");
			if(!$cache) {
				return false;
			}
			$data[$key] = unserialize($cache['cachevalue']);
			if($cache['life'] && ($cache['dateline'] < time() - $data[$key]['life'])) {
				return false;
			}
		}
		return $data[$key]['data'];
	}

	public static function set($key, $value, $life) {
		$data = array(
			'cachekey' => $key,
			'cachevalue' => addslashes(serialize(array('data' => $value, 'life' => $life))),
			'dateline' => time(),
		);
		return DB::insert('cache', $data);
	}

	public static function delete($key) {
		return DB::delete('cache', array('cachekey' => $key));
	}
	
	/**
	 * 清除所有数据
	 */
	public static function flush() {
		return DB::delete('cache');
	}
}