<?php
///////////////////////////////////////////////////////////////////
// Author:dahong | E-mail: dahongy@gmail.com
// Copyright (c) Http://www.phpstcms.cn
// This is not a free software, please to pay for more functions
// $Id: 2009-08-18 version V3.0beta $
///////////////////////////////////////////////////////////////////

function updateCache($type, $data)
{
	if($type)
	{
		$cachePath = CACHE_PATH.strtolower(str_replace('_','',$type)).".cache.php";
		if(data)
		{
			$content = "<?php\n// cache file for PHPSTCMS.CN\n// please not to edit this file!\n\${$type}_CACHE = {$data};\ndefine('{$type}_UPDATE_DATE','".NOW."');\n?>";
			writeFile($cachePath, $content,"w+");
		}
	}
}
function initSetting()
{
	global $mysql;
	$settings = $mysql->select("setting","name,value");
	if($settings)
	{
		foreach($settings as $temp)
		{
			$SETTING[$temp['name']] = $temp['value'];
		}
	}
	$data = var_export((array)$SETTING, true);
	updateCache('SETTING',$data);
}
function initTableStruct()
{
	global $mysql;
	$tableStructPath = CACHE_PATH."table.cache.php";
	$tables = $mysql->fetchAll("SHOW TABLE STATUS LIKE '{$CONFIG['dbPrefix']}%'");
	foreach($tables as $temp)
	{
		$fields = $mysql->fetchAll("SHOW FIELDS FROM `{$temp['Name']}`");
		foreach($fields as $t)
		{
			$tmp[] = $t['Field'];
		}
		$TABLE[$temp['Name']] = $tmp;
		unset($tmp);
	}
	updateCache('TABLE_STRUCT',var_export((array)$TABLE, true));
}
function initHit()
{
	global $mysql;
	$HIT_CACHE = importCache('HIT');
	$hit_now = strtotime(NOW);
	foreach($HIT_CACHE as $key => $value)
	{
		$hit_time[$key] = strtotime($value);
	}
	if($hit_now - $hit_time['today_hit']>3600*24)
	{
		initTodayMusic();
		initTodaySpecial();
		initHotArtist();
		initWeekMusic();
		initWeekSpecial();
		initMonthMusic();
		initMonthSpecial();
		$mysql->update("music",array('today_hit'=>0));
		$mysql->update("special",array('today_hit'=>0));
		$mysql->update("artist",array('today_hit'=>0));
		$data=array();
		$data['today_hit'] = NOW;
		$data['week_hit'] = $HIT_CACHE['week_hit'];
		$data['month_hit'] = $HIT_CACHE['month_hit'];
		$data = var_export((array)$data, true);
		updateCache('HIT', $data);
	}
	if($hit_now-$hit_time['week_hit']>3600*24*7)
	{
		initWeekMusic();
		initWeekSpecial();
		initNSMusic();
		$mysql->update("music",array('week_hit'=>0));
		$mysql->update("special",array('week_hit'=>0));
		$mysql->update("artist",array('week_hit'=>0));
		$data=array();
		$data['today_hit'] = $HIT_CACHE['today_hit'];
		$data['week_hit'] = NOW;
		$data['month_hit'] = $HIT_CACHE['month_hit'];
		$data = var_export((array)$data, true);
		updateCache('HIT', $data);
	}
	if($hit_now-$hit_time['month_hit']>3600*24*30)
	{
		initMonthMusic();
		initMonthSpecial();
		$mysql->update("music",array('month_hit'=>0));
		$mysql->update("special",array('month_hit'=>0));
		$mysql->update("artist",array('month_hit'=>0));
		$data=array();
		$data['today_hit'] = $HIT_CACHE['today_hit'];
		$data['week_hit'] = $HIT_CACHE['week_hit'];
		$data['month_hit'] = NOW;
		$data = var_export((array)$data, true);
		updateCache('HIT', $data);
	}
}
function initWebMenu()
{
	global $mysql;
	$channels = $mysql->select("channel","id,name,url,type",array('display'=>'1'),array('`order` ASC'));
	$data = var_export((array)$channels,true);
	updateCache('WEB_MENU',$data);
}
function initCategory()
{
	global $mysql;
	$categorys = $mysql->select("category","*",false,array('`order` ASC'));
	$data = var_export((array)$categorys,true);
	updateCache('CATEGORY',$data);
}
function initCatMusic()
{
	global $mysql;
	$categorys = importCache('CATEGORY');
	if($categorys)
	{
		foreach($categorys as $temp)
		{
			$musics = $mysql->fetchAll("SELECT m.id AS id, m.specialid, m.categoryid, m.name AS name, m.artist AS artist, c.name AS category FROM ".DB_PREFIX."music m, ".DB_PREFIX."category c WHERE  m.categoryid = c.id AND c.id='{$temp['id']}' ORDER BY m.id DESC LIMIT 0,40");
			$CAT_MUSIC[$temp['id']] = $musics;
		}
		$data = var_export((array)$CAT_MUSIC,true);
		updateCache('CAT_MUSIC',$data);
	}
}
function initCatSpecial()
{
	global $mysql;
	$categorys = importCache('CATEGORY');
	if($categorys)
	{
		foreach($categorys as $temp)
		{
			$specials = $mysql->fetchAll("SELECT s.id, s.name, s.artist, s.company, s.categoryid, s.picture, s.pubtime, s.time, c.name AS category FROM ".DB_PREFIX."special s, ".DB_PREFIX."category c WHERE s.categoryid = c.id AND c.id={$temp['id']} ORDER BY s.id DESC LIMIT 0,8");
			$CAT_SPECIAL[$temp['id']] = $specials;
		}
		$data = var_export((array)$CAT_SPECIAL,true);
		updateCache('CAT_SPECIAL',$data);
	}
}
function initNewMusic()
{
	global $mysql;
	$musics = $mysql->fetchAll("SELECT m.id AS id, m.specialid, m.categoryid, m.name AS name, m.artist AS artist, c.name AS category FROM ".DB_PREFIX."music m, ".DB_PREFIX."category c WHERE  m.categoryid = c.id ORDER BY m.id DESC LIMIT 0,10");
	$data = var_export((array)$musics,true);
	updateCache('NEW_MUSIC',$data);
}
function initHitMusic()
{
	global $mysql;
	$musics = $mysql->fetchAll("SELECT m.id AS id, m.specialid, m.categoryid, m.name AS name, m.artist AS artist, m.hit, c.name AS category FROM ".DB_PREFIX."music m, ".DB_PREFIX."category c WHERE  m.categoryid = c.id ORDER BY m.hit DESC, m.id DESC LIMIT 0,10");
	$data = var_export((array)$musics,true);
	updateCache('HIT_MUSIC',$data);
}
function initTodayMusic()
{
	global $mysql;
	$musics = $mysql->fetchAll("SELECT m.id AS id, m.specialid, m.categoryid, m.name AS name, m.artist AS artist, m.today_hit, c.name AS category FROM ".DB_PREFIX."music m, ".DB_PREFIX."category c WHERE  m.categoryid = c.id ORDER BY m.today_hit DESC, m.id DESC LIMIT 0,10");
	$data = var_export((array)$musics,true);
	updateCache('TODAY_MUSIC',$data);
}

function initWeekMusic()
{
	global $mysql;
	$musics = $mysql->fetchAll("SELECT m.id AS id, m.specialid, m.categoryid, m.name AS name, m.artist AS artist, m.week_hit, c.name AS category FROM ".DB_PREFIX."music m, ".DB_PREFIX."category c WHERE  m.categoryid = c.id ORDER BY m.week_hit DESC, m.id DESC LIMIT 0,10");
	$data = var_export((array)$musics,true);
	updateCache('WEEK_MUSIC',$data);
}
function initMonthMusic()
{
	global $mysql;
	$musics = $mysql->fetchAll("SELECT m.id AS id, m.specialid, m.categoryid, m.name AS name, m.artist AS artist, m.month_hit, c.name AS category FROM ".DB_PREFIX."music m, ".DB_PREFIX."category c WHERE  m.categoryid = c.id ORDER BY m.month_hit DESC, m.id DESC LIMIT 0,10");
	$data = var_export((array)$musics,true);
	updateCache('MONTH_MUSIC',$data);
}
function initHitSpecial()
{
	global $mysql;
	$specials = $mysql->fetchAll("SELECT s.id, s.name, s.artist, s.company, s.categoryid, s.picture, s.pubtime, s.time, c.name AS category FROM ".DB_PREFIX."special s, ".DB_PREFIX."category c WHERE s.categoryid = c.id ORDER BY s.hit DESC, s.id DESC LIMIT 0,8");
	$data = var_export((array)$specials,true);
	updateCache('HIT_SPECIAL',$data);
}
function initTodaySpecial()
{
	global $mysql;
	$specials = $mysql->fetchAll("SELECT s.id, s.name, s.artist, s.company, s.categoryid, s.picture, s.pubtime, s.time, c.name AS category FROM ".DB_PREFIX."special s, ".DB_PREFIX."category c WHERE s.categoryid = c.id ORDER BY s.today_hit DESC, s.id DESC LIMIT 0,11");
	$data = var_export((array)$specials,true);
	updateCache('TODAY_SPECIAL',$data);
}
function initWeekSpecial()
{
	global $mysql;
	$specials = $mysql->fetchAll("SELECT s.id, s.name, s.artist, s.company, s.categoryid, s.picture, s.pubtime, s.time, c.name AS category FROM ".DB_PREFIX."special s, ".DB_PREFIX."category c WHERE s.categoryid = c.id ORDER BY s.week_hit DESC, s.id DESC LIMIT 0,11");
	$data = var_export((array)$specials,true);
	updateCache('WEEK_SPECIAL',$data);
}
function initMonthSpecial()
{
	global $mysql;
	$specials = $mysql->fetchAll("SELECT s.id, s.name, s.artist, s.company, s.categoryid, s.picture, s.pubtime, s.time, c.name AS category FROM ".DB_PREFIX."special s, ".DB_PREFIX."category c WHERE s.categoryid = c.id ORDER BY s.month_hit DESC, s.id DESC LIMIT 0,11");
	$data = var_export((array)$specials,true);
	updateCache('MONTH_SPECIAL',$data);
}
function initNewSpecial()
{
	global $mysql;
	$specials = $mysql->fetchAll("SELECT s.id, s.name, s.artist, s.company, s.categoryid, s.picture, s.pubtime, s.time, c.name AS category FROM ".DB_PREFIX."special s, ".DB_PREFIX."category c WHERE s.categoryid = c.id ORDER BY s.id DESC LIMIT 0,6");
	$data = var_export((array)$specials,true);
	updateCache('NEW_SPECIAL',$data);
}
function initNRMusic()
{
	global $mysql;
	$musics = $mysql->fetchAll("SELECT m.id AS id, m.specialid, m.categoryid, m.name AS name, m.artist AS artist, c.name AS category FROM ".DB_PREFIX."music m, ".DB_PREFIX."category c WHERE  m.categoryid = c.id AND m.recommend='1' ORDER BY m.id DESC LIMIT 0,10");
	$data = var_export((array)$musics,true);
	updateCache('NR_MUSIC',$data);
}
function initNRSpecial()
{
	global $mysql;
	$specials = $mysql->fetchAll("SELECT s.id, s.name, s.artist, s.company, s.categoryid, s.picture, s.pubtime, s.time, c.name AS category FROM ".DB_PREFIX."special s, ".DB_PREFIX."category c WHERE s.categoryid = c.id AND s.recommend='1' ORDER BY s.id DESC LIMIT 0,6");
	$data = var_export((array)$specials,true);
	updateCache('NR_SPECIAL',$data);
}
function initNewComment()
{
	global $mysql;
	$comments = $mysql->select('comment','id,guest,content,typeid,type',false,'id DESC',array('0','8'));
	$data = var_export((array)$comments,true);
	updateCache('NEW_COMMENT',$data);
}
function initNewPic()
{
	global $mysql;
	$files = $mysql->select("upload","*","ext IN ('jpg','bmp','gif','png')","id DESC",array('0','5'));
	if($files)
	{
		foreach($files as $temp)
		{
			$obj['pic'][] = $temp['url'];
			$page = $mysql->selectOne("channel","id,name","page LIKE '%".$temp[url]."%'");
			if($page)
			{
				$obj['link'][] = WEB_URL."page?id={$page['id']}";
				$obj['text'][] = $page['name'];
			}
			elseif($special = $mysql->selectOne("special","id,name",array("picture"=>$temp['url'])))
			{
				$obj['link'][] = WEB_URL."special.php?id={$special['id']}";
				$obj['text'][] = $special['name'];
			}
			elseif($user=$mysql->selectOne('member', 'id,name', array('picture'=>$temp['url'])))
			{
				$obj['link'][] = WEB_URL."member/u.php?uid={$user['id']}";
				$obj['text'][] = $user['name'];
			}
			else
			{
				$artist = $mysql->selectOne("artist","id,name",array('picture'=>$temp['url']));
				$obj['link'][] = $artist ? WEB_URL."artist.php?id={$artist['id']}" : $temp['url'];
				$obj['text'][] = $artist ? $artist['name'] : $temp['name'];
			}
		}
	}
	$data = var_export( (array)$obj, true);
	updateCache('NEW_PIC', $data);
}
function initHotArtist()
{
	global $mysql;
	//$start = microtime();
	//$topArtist = $mysql->fetch($mysql->query("SELECT a.id, a.name, a.picture, s.id AS sid, s.name AS sname, m.id AS mid, m.name AS mname FROM ".DB_PREFIX."artist a, ".DB_PREFIX."special s, ".DB_PREFIX."music m WHERE s.artist=a.name AND m.artist=a.name ORDER BY a.month_hit DESC, s.hit DESC, m.hit DESC"));
	$topArtist = $mysql->selectOne('artist', 'id, name, picture', false, 'month_hit DESC');
	$topArtistMusic = $mysql->selectOne('music', 'id, name', array('artist'=>$topArtist['name']), 'id DESC', array('0','1'));
	$topArtistSpecail = $mysql->selectOne('special', 'id, name', array('artist'=>$topArtist['name']), 'id DESC', array('0','1'));
	$topArtist['sname'] = $topArtistSpecail['name']; $topArtist['sid'] = $topArtistSpecail['id'];
	$topArtist['mid'] = $topArtistMusic['id']; $topArtist['mname'] = $topArtistMusic['name'];
	$artists = $mysql->select("artist", 'id, name', "name != '{$topArtist['name']}'", array('month_hit DESC'), array('0','20'));
	$data = array('top'=>$topArtist, 'other'=>$artists); unset($topArtist, $artists);
	//print_r($hotArtist); exit;
	$data = var_export((array)$data, true);
	//echo microtime()-$start; exit;
	updateCache('HOT_ARTIST', $data);
}
function initNSMusic()
{
	global $mysql;
	$musics = $mysql->select('music', 'id, name, artist', "specialid='0'", array('id DESC', 'week_hit DESC'), array('0','10'));
	$data = var_export((array)$musics, true);
	updateCache('NS_MUSIC', $data);
}
function initNews()
{
	global $mysql;
	$news = $mysql->select('channel', 'id, name, url, type, time', array('display'=>'0'), array('id DESC'), array('0','8'));
	$data = var_export((array)$news, true);
	updateCache('NEWS', $data);
}
function initNUMusic()
{
	global $mysql;
	$musics = $mysql->fetchAll("SELECT m.id , m.uid, m.name, m.artist, u.name as uName FROM ".DB_PREFIX."member_upload m, ".DB_PREFIX."member u WHERE  m.uid = u.id ORDER BY m.id DESC LIMIT 0,40");
	$data = var_export((array)$musics, true);
	updateCache('NU_MUSIC', $data);
}
function initNewMember()
{
	global $mysql;
	$members = $mysql->select("member", 'id,name,picture,time,money,provience,city', false, array("id DESC"), array('0','8'));
	$data = var_export((array)$members, true);
	updateCache('NEW_MEMBER', $data);
}
function initRankMember()
{
	global $mysql;
	$members = $mysql->select("member", 'id,name,time,money', false, array("money DESC", "id DESC"), array('0','10'));
	$data = var_export((array)$members, true);
	updateCache('RANK_MEMBER', $data);
}
function initMemberInfo()
{
	global $mysql;
	$mNum = $mysql->numTable('member');
	$mNew = $mysql->select('member', 'id, name, picture', false, array("id DESC"), array('0','1'));
	$mInfo['num'] = $mNum;
	$mInfo['new'] = $mNew[0];
	$data = var_export((array)$mInfo, true);
	updateCache('MEMBER_INFO', $data);
}
?>