<?php
///////////////////////////////////////////////////////////////////
// Author:dahong | E-mail: dahongy@gmail.com
// Copyright (c) Http://www.phpstcms.cn
// This is not a free software, please to pay for more functions
// $Id: 2009-08-18 version V3.0beta $
///////////////////////////////////////////////////////////////////
require("common.inc.php");
$action = $action ? $action : "view";
if(!in_array($action,array("view","new","rank","recommend","hot","nospecial")))
{
	msg("参数错误！"); addLog("前台参数错误，可能影响网站安全！");exit;
}
$categoryWhere = $category;
$specialWhere = $special;
$artistWhere = trim($artist);
switch($action)
{
	case "view":
		if(empty($id) || !$music=$mysql->selectOne("music","*",array('id'=>$id)))
		{
			msg("对不起，该音乐不存在！");exit;
		}
		$special = $mysql->selectOne("special","*",array('id'=>$music['specialid']));
		$category = $mysql->selectOne("category","*",array('id'=>$music['categoryid']));
		$mysql->update("music","hit=hit+1,week_hit=week_hit+1,month_hit=month_hit+1,today_hit=today_hit+1",array('id'=>intval($id)));
		$music['specialName'] = $special['name'] ? $special['name'] : '单曲';
		$music['categoryName'] = $category['name'];
		
		$rmdMusic = importCache('NR_MUSIC');
		$topMusic = importCache('HIT_MUSIC');
	
		$smarty->assign("music",$music);
		$smarty->assign("topMusic",$topMusic);
		$smarty->assign("rmdMusic",$rmdMusic);
		$smarty->assign("webTitle",'歌曲 '.$music['name']."试听 {$music['name']}MP3 {$music['name']}下载 {$music['artist']} < ".$music['specialName']);
		$smarty->display("music.html");
		exit;
	break;
	case "new":
		if($categoryWhere)
		{
			$where['categoryid'] = intval($categoryWhere);
			$cat = $mysql->selectOne("category","name",array('id'=>intval($categoryWhere)));
			$webTitle = "最新音乐列表 < {$cat['name']} ";
		}
		else
		{
			$webTitle = "最新音乐列表 ";
		}
		if($artistWhere)
		{
			$where['artist'] = $artistWhere;
		}
		$order = array("id DESC");
	break;
	case "recommend":
		if($categoryWhere)
		{
			$where['categoryid'] = intval($categoryWhere);
			$cat = $mysql->selectOne("category","name",array('id'=>intval($categoryWhere)));
			$webTitle = "推荐音乐列表 < {$cat['name']} ";
		}
		else
		{
			$webTitle = "推荐音乐列表 ";
		}
		$order = array("id DESC");
		if($artistWhere)
		{
			$where['artist'] = $artistWhere;
		}
		$where['recommend'] = '1';
		$order = array("id DESC");
	break;
	case "rank":
		if($categoryWhere)
		{
			$where['categoryid'] = intval($categoryWhere);
			$cat = $mysql->selectOne("category","name",array('id'=>intval($categoryWhere)));
			$webTitle = "音乐排行 < {$cat['name']} ";
		}
		else
		{
			$webTitle = "音乐排行";
		}
		if($artistWhere)
		{
			$where['artist'] = $artistWhere;
		}
		if(empty($rank_type))
		{
			$rank_type = "hit";
		}
		if(!in_array($rank_type,array('hit','today_hit','month_hit','week_hit')))
		{
			msg("排行参数错误！");exit;
		}
		if(empty($rank_type))
		{
			$order = "`hit` DESC,`id` DESC";
		}
		else
		{
			$order = "`$rank_type` DESC,`id` DESC";
		}
	break;
	case "nospecial":
		if($categoryWhere)
		{
			$where['categoryid'] = intval($categoryWhere);
			$webTitle = "最新音乐列表";
		}
		else
		{
			$webTitle = "最新单曲";
		}
		if($artistWhere)
		{
			$where['artist'] = $artistWhere;
		}
		$where['specialid'] = '0';
		$order = array("id DESC");
		
	break;
}
$totalNum = $mysql->numTable("music",$where);
$pageNum = 40;
$totalPage = intval($totalNum/$pageNum) == $totalNum/$pageNum ? $totalNum/$pageNum : intval($totalNum/$pageNum)+1;
$page = $page ? $page : 1;
$page = $page>$totalPage ? $totalPage : $page;
$page = $page<1 ? 1 : $page;
$music = $mysql->select("music","*",$where,$order,array(($page-1)*$pageNum,$pageNum));
require(INCLUDE_PATH."page.class.php");
$url = WEB_URL."music.php?action={$action}".($categoryWhere ? "&category=".intval($categoryWhere) : "").($rank_type ? "&rank_type={$rank_type}" : "").($where['artist'] ? "&artist=".urlencode($where['artist']) : "");
$pageClass = new page($page,$totalNum,$pageNum,$url,true);
$pageCode = $pageClass->getCode();
$urlStr = ($where['categoryid'] ? "&category=".$where['categoryid'] : "").($where['artist'] ? "&artist=".urlencode($where['artist']) : "");
$tags[] = array('url'=>WEB_URL.'music.php?action=new'.$urlStr, 'name'=>'全部歌曲');
$tags[] = array('url'=>WEB_URL.'music.php?action=recommend'.$urlStr, 'name'=>'推荐歌曲');
$tags[] = array('url'=>WEB_URL.'music.php?action=rank&rank_type=hit'.$urlStr, 'name'=>'歌曲总排行');
$tags[] = array('url'=>WEB_URL.'music.php?action=rank&rank_type=today_hit'.$urlStr, 'name'=>'日歌曲排行');
$tags[] = array('url'=>WEB_URL.'music.php?action=rank&rank_type=week_hit'.$urlStr, 'name'=>'周歌曲排行');
$tags[] = array('url'=>WEB_URL.'music.php?action=rank&rank_type=month_hit'.$urlStr, 'name'=>'月歌曲排行');
$smarty->assign("pageCode",$pageCode);
$smarty->assign("webTitle",$webTitle);
$smarty->assign("music",$music);
$smarty->assign('tags', $tags);
$smarty->display("music_list.html");
?>