<?php
/*
	[NetMao!] (C)2001-2008 NetMao.com
	This is NOT a freeware, use is subject to license terms

	For further information go to http://www.netmao.com
*/
if(!defined('IN_NetMao') || !isset($PHP_SELF) || !preg_match("/[\/\\\\]nmadmin\.php$/", $PHP_SELF)) exit('Access Denied');

switch($action){
    case 'database_export':
        if(!$exportsubmit){
            $sqlcharsets = "<input class=\"radio\" type=\"radio\" name=\"sqlcharset\" value=\"\" checked>".$cplang['default'].
            ($dbcharset ? " &nbsp; <input class=\"radio\" type=\"radio\" name=\"sqlcharset\" value=\"$dbcharset\"> ".strtoupper($dbcharset) : '').
            ($db->version() > '4.1' && $dbcharset != 'utf8' ? " &nbsp; <input class=\"radio\" type=\"radio\" name=\"sqlcharset\" value='utf8'> UTF-8</option>" : '');
            $tables = $tablelist = '';
		    $query = $db->query("SHOW TABLE STATUS LIKE '$tablepre%'");
		    while($tab = $db->fetch_array($query)) {
		    	$tabs[] = $tab[Name];
		    }
            nmcptpl('database');
        }else{
            if(!$filename || preg_match("/(\.)(exe|jsp|asp|aspx|cgi|fcgi|pl)(\.|$)/i", $filename)) {
                nmsg('database_export_filename_invalid','','back');
            }
            $method = 'multivol';
            $time = gmdate("Y-n-j H:i", $timestamp + 8 * 3600);

            if($type == 'netmao') {
		        $query = $db->query("SHOW TABLE STATUS LIKE '$tablepre%'");
		        while($table = $db->fetch_array($query)) {
		    	    $tables[] = $table[Name];
		        }
            } elseif($type == 'custom') {
			    $tables = array();
			    if(empty($setup)) {
				    $query = $db->query("SELECT value FROM {$tablepre}settings WHERE variable='custombackup'");
				    if($tables = $db->fetch_array($query)) {
					    $tables = unserialize($tables['value']);
				    }
			    } else {
			    	$customtables= empty($customtables) ? array() : $customtables;
				    $customtablesnew = empty($customtables)? '' : addslashes(serialize($customtables));
				    $db->query("REPLACE INTO {$tablepre}settings (variable, value) VALUES ('custombackup', '$customtablesnew')");
				    $tables = & $customtables;
			    }
			    if( !is_array($tables) || empty($tables)) {
				    nmsg('database_export_custom_invalid');
			    }
            }

            $volume = intval($volume) + 1;
            $idstring = '# Identify: '.base64_encode("$timestamp,$version,$type,$method,$volume")."\n";
            $dumpcharset = $sqlcharset ? $sqlcharset : str_replace('-', '', $GLOBALS['charset']);
            $setnames = $addsetnames || ($db->version() > '4.1' && (!$sqlcompat || $sqlcompat == 'MYSQL41')) ? "SET NAMES '$dumpcharset';\n\n" : '';
            if($db->version() > '4.1') {
                if($sqlcharset) {
                    $db->query("SET NAMES '".$sqlcharset."';\n\n");
                }
                if($sqlcompat == 'MYSQL40') {
                    $db->query("SET SQL_MODE='MYSQL40'");
                }
            }

            $sqldump = '';
            $tableid = $tableid ? $tableid - 1 : 0;
            $startfrom = intval($startfrom);
            for($i = $tableid; $i < count($tables) && strlen($sqldump) < $sizelimit * 1000; $i++) {
                $sqldump .= sqldumptable($tables[$i], $startfrom, strlen($sqldump));
                $startfrom = 0;
            }

            $tableid = $i;
            $dumpfile = substr($filename, 0, strrpos($filename, '.'))."-%s".strrchr($filename, '.');
            if(trim($sqldump)) {
                $sqldump = "$idstring".
				"# NetMao Multi-Volume Data Dump Vol.$volume\n".
				"# Version: NetMao Movie $version\n".
				"# Time: $time\n".
				"# Type: $type\n".
				"# Table Prefix: $tablepre\n".
				"#\n".
				"# NetMao Home: http://www.netmao.com\n".
				"# Please visit our website for newest infomation about NetMao\n".
				"# --------------------------------------------------------\n\n\n".
				"$setnames".
                $sqldump;
                @$fp = fopen(sprintf($dumpfile, $volume), 'wb');
                @flock($fp, 2);
                if(@!fwrite($fp, $sqldump)) {
                    @fclose($fp);
				    nmsg('database_export_file_invalid');
			    } else {
				    nmsg('database_export_multivol_redirect', "nmadmin.php?action=database_export&type=".rawurlencode($type)."&saveto=".rawurlencode(server)."&filename=".rawurlencode($filename)."&method=multivol&sizelimit=".rawurlencode($sizelimit)."&volume=".rawurlencode($volume)."&tableid=".rawurlencode($tableid)."&startfrom=".rawurlencode($startrow)."&extendins=".rawurlencode($extendins)."&sqlcharset=".rawurlencode($sqlcharset)."&sqlcompat=".rawurlencode($sqlcompat)."&exportsubmit=yes&usehex=$usehex");
			    }
            } else {
			    $volume--;
			    $filelist = '<ul>';
			    for($i = 1; $i <= $volume; $i++) {
				    $filename = sprintf($dumpfile, $i);
				    $filelist .= "<li><a href=\"$filename\">$filename\n";
			    }
			    nmsg('database_export_multivol_succeed');
		    }
	    }
    break;

    case 'database_import' :
        if(!$importsubmit && !$deletesubmit) {
	 	    $exportlog = array();
	     	if(is_dir(NetMao_ROOT.'./mdata')) {
	     		$dir = dir(NetMao_ROOT.'./mdata');
			    while($entry = $dir->read()) {
			    	$entry = "./mdata/$entry";
			    	if(is_file($entry) && preg_match("/\.sql/i", $entry)) {
					    $filesize = filesize($entry);
					    $fp = fopen($entry, 'rb');
					    $identify = explode(',', base64_decode(preg_replace("/^# Identify:\s*(\w+).*/s", "\\1", fgets($fp, 256))));
				    	fclose ($fp);
					    $exportlog[$identify[0]] = array(	'version' => $identify[1],
										'type' => $identify[2],
										'method' => $identify[3],
										'volume' => $identify[4],
										'filename' => $entry,
										'size' => $filesize);
				    }
		    	}
		    	$dir->close();
	    	} else {
			    cpmsg('database_export_dest_invalid');
		    }
		    krsort($exportlog);
	    	reset($exportlog);
	    	$exportinfo = '';
	    	foreach($exportlog as $dateline => $info) {
			    $info['dateline'] = is_int($dateline) ? gmdate("Y-n-j H:i", $dateline + 8 * 3600) : $cplang[unknown];
			    switch($info['type']) {
			    	case 'netmao':
					    $info['type'] = $cplang[database_export_full];
				   	break;
				    case 'custom':
					    $info['type'] = $cplang[database_export_custom];
					break;
			    }
		    	$info['size'] = sizecount($info['size']);
			    $info['volume'] = $info['method'] == 'multivol' ? $info['volume'] : $cplang[unknown];
			    $info['method'] = $info['method'] == 'multivol' ? $cplang[database_multivol] : $cplang[unknown];
			    $exportinfo .= "<tr><td class=\"tablerow\"><input type=\"checkbox\" name=\"delete[]\" value=\"$info[filename]\"></td>\n".
			    	"<td class=\"tablerow\"><a href=\"$info[filename]\">".substr(strrchr($info['filename'], "/"), 1)."</td></a>\n".
			    	"<td class=\"tablerow\">$info[version]</td>\n".
			    	"<td class=\"tablerow\">$info[dateline]</td>\n".
			    	"<td class=\"tablerow\">$info[type]</td>\n".
			    	"<td class=\"tablerow\">$info[size]</td>\n".
			    	"<td class=\"tablerow\">$info[method]</td>\n".
			    	"<td class=\"tablerow\">$info[volume]</td>\n".
			    	"<td class=\"tablerow\"><a href=\"nmadmin.php?action=database_import&from=server&datafile_server=$info[filename]&importsubmit=1\"".
			    	($info['version'] != $version ? " onclick=\"return confirm('$cplang[database_import_confirm]');\"" : '').">[$cplang[import]]</a></td>\n";     }
		    	nmcptpl('database');
            } elseif($importsubmit) {
		        $readerror = 0;
		    if($from == 'server') {
			    $datafile = addslashes(NetMao_ROOT).'/'.$datafile_server;
		    }
		    if(@$fp = fopen($datafile, 'rb')) {
			    $sqldump = fgets($fp, 256);
			    $identify = explode(',', base64_decode(preg_replace("/^# Identify:\s*(\w+).*/s", "\\1", $sqldump)));
		    	$dumpinfo = array('method' => $identify[3], 'volume' => intval($identify[4]));
		    	if($dumpinfo['method'] == 'multivol') {
				    $sqldump .= fread($fp, 8388607);
		    	}
			    fclose($fp);
	    	} else {
			    if($autoimport) {
				    updatecache();
				    nmsg('database_import_multivol_succeed');
		    	} else {
			    	nmsg('database_import_file_illegal');
		    	}
		    }
		    if($dumpinfo['method'] == 'multivol') {
		    	$sqlquery = splitsql($sqldump);
	    		unset($sqldump);
		    	foreach($sqlquery as $sql) {
				    if(trim($sql) != '') {
					    $db->query($sql, 'SILENT');
				    	if(($sqlerror = $db->error()) && $db->errno() != 1062) {
					    	$db->halt('MySQL Query Error', $sql);
				    	}
			    	}
			    }
		    	$datafile_next = preg_replace("/-($dumpinfo[volume])(\..+)$/", "-".($dumpinfo['volume'] + 1)."\\2", $datafile_server);
		    	if($dumpinfo['volume'] == 1) {
				    nmsg('database_import_multivol_prompt',"nmadmin.php?action=database_import&from=server&datafile_server=$datafile_next&autoimport=yes&importsubmit=yes",'form');
			    } elseif($autoimport) {
			    	nmsg('database_import_multivol_redirect', "nmadmin.php?action=database_import&from=server&datafile_server=$datafile_next&autoimport=yes&importsubmit=yes");
		    	} else {
				    nmsg('database_import_multivol_prompt');
		    	}
		    }
        } elseif($deletesubmit) {
		    if(is_array($delete)) {
			    foreach($delete as $filename) {
			    	@unlink($filename);
		    	}
			    nmsg('database_file_operate_succeed');
		    } else {
			    nmsg('database_file_delete_invalid','','back');
    		}
    	 }
    break;

    case 'database_runquery' :
        if(!$sqlsubmit) {
	        nmcptpl('database');
	     }else{
	    	$sqlquery = splitsql(str_replace(' nm_', ' '.$tablepre, $queries));
		    foreach($sqlquery as $sql) {
			    if(trim($sql) != '') {
				    $db->query(stripslashes($sql), 'SILENT');
				    if($sqlerror = $db->error()) {
					    break;
				    }
			    }
		    }
			updatecache();
		    nmsg($sqlerror ? 'database_run_query_invalid' : 'database_run_query_succeed');
	     }
    break;

    case 'database_optimize' :
	    $optimizetable = '';
	    $totalsize = 0;
	    if(!$optimizesubmit) {
		    $query = $db->query("SHOW TABLE STATUS LIKE '$tablepre%'");
		    while($tab = $db->fetch_array($query)) {
			    $tab[checked] = $tab['Type'] == 'MyISAM' || $tab['Engine'] == 'MyISAM' ? 'checked' : 'disabled';
			    $totalsize += $tab['Data_length'] + $tab['Index_length'];
		    	$tabs[] = $tab;
		    }
		    nmcptpl('database');
	    } else {
	    	$query = $db->query("SHOW TABLE STATUS LIKE '$tablepre%'");
	    	while($tab = $db->fetch_array($query)) {
			    if(is_array($optimizetables) && in_array($tab['Name'], $optimizetables)) {
				    $tab[optimized] = $cplang[yes];
				    $db->query("OPTIMIZE TABLE $tab[Name]");
			    } else {
				    $tab[optimized] = '<b>'.$cplang[yes].'</b>';
			    }
			    $totalsize += $tab['Data_length'] + $tab['Index_length'];
			    $optabs[] = $tab;
		    }
		    nmcptpl('database');
	    }
    break;

    case 'database_getfields' :
        $fields = '';
        if($tablename){
		    $query = "SHOW COLUMNS FROM $tablename";
		    $result = $db->query($query);
		    while($fil = $db->fetch_array($result)){
			    $fields.= $fil['Field'].',';
		    }
		    $fields = substr($fields,0,-1);
	    }
	    echo $fields;
    break;

    case 'database_replace' :
        if(!$rpsubmit) {
		    $query = $db->query("SHOW TABLE STATUS LIKE '$tablepre%'");
		    while($tab = $db->fetch_array($query)) {
		    	$tablopt.= "<option value='$tab[Name]'>$tab[Name]</option>";
		    }
		    nmcptpl('database');
       }else{
	        $type = isset($type) ? intval($type) : 1;
            if($fromtable==''){nmsg('database_replace_table_invalid','','back');}
            if($fromfield==''){nmsg('database_replace_field_invalid','','back');}
            $rst = $db->query("SHOW COLUMNS FROM $fromtable");
            while($p = $db->fetch_array($rst)){
                if($p['Key'] == 'PRI'){ $priid = $p['Field']; break;}
            }
            if(!$priid){nmsg('database_replace_primary_invalid','','back');}
            $condition = $condition ? 'where '.stripslashes($condition) : '';
            if($type==1){		
			    if($search==''){
				    nmsg('database_replace_content_invalid','','back');
			    }
                $query = "select $fromfield,$priid from $fromtable $condition ";
                $result = $db->query($query);
                while($r = $db->fetch_array($result)){
				    $r[$fromfield] = str_replace($search,$replace,$r[$fromfield]);
				    $r[$fromfield] = addslashes($r[$fromfield]);
				    $db->query("update $fromtable set $fromfield='".$r[$fromfield]."' where $priid='".$r[$priid]."'");
			    }
			    nmsg('operate_succeed','?action=database_replace');
		    }elseif($type==2){
    			if($addstr==''){
				    nmsg('database_replace_prefix_invalid','','back');
			    }
			    $query = "select $fromfield,$priid from $fromtable $condition ";
			    $result = $db->query($query);
			    while($r = $db->fetch_array($result)){
				    $r[$fromfield] = $addstr.$r[$fromfield];
				    $r[$fromfield] = addslashes($r[$fromfield]);
				    $db->query("update $fromtable set $fromfield='".$r[$fromfield]."' where $priid='".$r[$priid]."'");
			    }
			    nmsg('operate_succeed','?action=database_replace');
		    }elseif($type==3){
			    if($addstr==''){
				    nmsg('database_replace_prefix_invalid','','back');
			    }
			    $query = "select $fromfield,$priid from $fromtable $condition ";
			    $result = $db->query($query);
			    while($r = $db->fetch_array($result)){
				    $r[$fromfield] = $r[$fromfield].$addstr;
				    $r[$fromfield] = addslashes($r[$fromfield]);
				    $db->query("update $fromtable set $fromfield='".$r[$fromfield]."' where $priid='".$r[$priid]."'");
			    }
			    nmsg('operate_succeed','?action=database_replace');
		    }
       }
    break;
}
?>
