<?php
/*
	[NetMao!] (C)2001-2008 NetMao.com
	This is NOT a freeware, use is subject to license terms

	For further information go to http://www.netmao.com
*/
if(!defined('IN_NetMao') || !isset($PHP_SELF) || !preg_match("/[\/\\\\]nmadmin\.php$/", $PHP_SELF)) exit('Access Denied');

if($action == 'styles' && $export) {
	$query = $db->query("SELECT s.name, s.templateid, t.name AS tplname, t.directory, t.copyright FROM {$tablepre}styles s LEFT JOIN {$tablepre}templates t ON t.templateid=s.templateid WHERE styleid='$export'");
	if(!$stylearray = $db->fetch_array($query)) {
		nmsg('styles_export_invalid','','back');
	}

	$stylearray['version'] = strip_tags($version);

	$query = $db->query("SELECT * FROM {$tablepre}stylevars WHERE styleid='$export'");
	while($style = $db->fetch_array($query)) {
		$stylearray['style'][$style['variable']] = $style['substitute'];
	}
	
	$site_name = $_NCACHE[settings][sitename];

	$style_export = "# NetMao Style Dump\n".
			"# Version: NetMao $version\n".
			"# Time: ".date("M j, Y, G:i")."\n".
			"# From: $site_name ($site_domain)\n".
			"#\n".
			"# This file was BASE64 encoded\n".
			"#\n".
			"# NetMao Home: http://www.netmao.com\n".
			"# Please visit our website for latest news about NetMao\n".
			"# --------------------------------------------------------\n\n\n".
			wordwrap(base64_encode(serialize($stylearray)), 50, "\n", 1);

	ob_end_clean();
	header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
	header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
	header('Cache-Control: no-cache, must-revalidate');
	header('Pragma: no-cache');
	header('Content-Encoding: none');
	header('Content-Length: '.strlen($style_export));
	header('Content-Disposition: attachment; filename=netmao_style_'.$stylearray['name'].'.txt');
	header('Content-Type: '.(strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') ? 'application/octetstream' : 'application/octet-stream'));
	echo $style_export;
	exit();
}

if($action == 'styles' && !$export) {
	$predefinedvars = array('imglogo', 'imgdir');
	if(!$stylesubmit && !$importsubmit && !$edit && !$export) {
	    $defaultstyleid = $db->result($db->query("SELECT value FROM {$tablepre}settings WHERE variable='styleid'"), 0);
		$styles = '';
		$query = $db->query("SELECT s.styleid, s.name, t.name AS tplname, t.copyright FROM {$tablepre}styles s LEFT JOIN {$tablepre}templates t ON t.templateid=s.templateid");
		while($style = $db->fetch_array($query)) {
			$styles[] = $style;
		}
		nmcptpl('styles');
	} elseif($stylesubmit) {
		if($updatecsscache) {
			updatecache('styles');
			nmsg('styles_csscache_update', '?action=styles');
		} else {
			if(is_array($namenew)) {
				foreach($namenew as $id => $val) {
					$db->query("UPDATE {$tablepre}styles SET name='$namenew[$id]' WHERE styleid='$id'");
				}
			}

			if($delete && in_array('1',$delete)) {
				nmsg('styles_delete_invalid','','back');
			}

			if($ids = implodeids($delete)) {
				$query = $db->query("SELECT COUNT(*) FROM {$tablepre}settings WHERE variable='styleid' AND value IN ($ids)");
				if($db->result($query, 0)) {
					nmsg('styles_delete_invalid','','back');
				}

				$db->query("DELETE FROM {$tablepre}styles WHERE styleid IN ($ids)");
				$db->query("DELETE FROM {$tablepre}stylevars WHERE styleid IN ($ids)");
			}

			if($newname) {
				$db->query("INSERT INTO {$tablepre}styles (name, templateid) VALUES ('$newname', '1')");
				$styleidnew = $db->insert_id();
				foreach($predefinedvars as $variable) {
					$db->query("INSERT INTO {$tablepre}stylevars (styleid, variable)
						VALUES ('$styleidnew', '$variable')");
				}
			}

			updatecache('settings');
			updatecache('styles');
			nmsg('styles_edit_succeed', '?action=styles');
		}
	} elseif($importsubmit) {
		$styledata = preg_replace("/(#.*\s+)*/", '', $styledata);
		$stylearray = naddslashes(unserialize(base64_decode($styledata)), 1);
		if(!is_array($stylearray)) {
			nmsg('styles_import_data_invalid','','back');
		}
		if(empty($ignoreversion) && strip_tags($stylearray['version']) != strip_tags($version)) {
			nmsg('styles_import_version_invalid','','back');
		}
		$renamed = 0;
		if($stylearray['templateid'] != 1) {
			$templatedir = NetMao_ROOT.'./'.$stylearray['directory'];
			if(!is_dir($templatedir)) {
				if(!@mkdir($templatedir, 0777)) {
					$basedir = dirname($stylearray['directory']);
					nmsg('styles_import_directory_invalid','','back');
				}
			}
			foreach($stylearray['template'] as $name => $file) {
				$name = $templatedir.'/'.str_replace('_DOT_', '.', $name);
				if(file_exists($name)) {
					nmsg('styles_import_filename_invalid','','back');
				}
				if(!@$fp = fopen($name, 'wb')) {
					nmsg('styles_import_file_invalid','','back');
				}
				flock($fp, 2);
				fwrite($fp, $file);
				fclose($fp);
			}
			$renameinfo = '';
			$query = $db->query("SELECT COUNT(*) FROM {$tablepre}templates WHERE name='$stylearray[tplname]'");
			if($db->result($query, 0)) {
				$stylearray['tplname'] .= '_'.random(4);
				$renamed = 1;
			}
			$db->query("INSERT INTO {$tablepre}templates (name, directory, copyright)
				VALUES ('$stylearray[tplname]', '$stylearray[directory]', '$stylearray[copyright]')");
			$templateid = $db->insert_id();
		} else {
			$templateid = 1;
		}
		$query = $db->query("SELECT COUNT(*) FROM {$tablepre}styles WHERE name='$stylearray[name]'");
		if($db->result($query, 0)) {
			$stylearray['name'] .= '_'.random(4);
			$renamed = 1;
		}
		$db->query("INSERT INTO {$tablepre}styles (name, templateid)
			VALUES ('$stylearray[name]', '$templateid')");
		$styleid = $db->insert_id();
		foreach($stylearray['style'] as $variable => $substitute) {
			$db->query("INSERT INTO {$tablepre}stylevars (styleid, variable, substitute)
				VALUES ('$styleid', '$variable', '$substitute')");
		}
		updatecache('styles');
		nmsg($renamed ? 'styles_import_succeed_renamed' : 'styles_import_succeed', '?action=styles');
	} elseif($edit) {
		if(!$editsubmit) {
			$query = $db->query("SELECT name, templateid FROM {$tablepre}styles WHERE styleid='$edit'");
			if(!$style = $db->fetch_array($query)) {
				nmsg('undefined_action','','back');
			}
			$stylecustom = '';
			$stylestuff = array();
			$query = $db->query("SELECT * FROM {$tablepre}stylevars WHERE styleid='$edit'");
			while($stylevar = $db->fetch_array($query)) {
				if(in_array($stylevar['variable'], $predefinedvars)) {
					$stylestuff[$stylevar['variable']] = array('id' => $stylevar['stylevarid'], 'subst' => $stylevar['substitute']);
				} else {
				    $stylevars[] = $stylevar;
				}
			}
			$tplselect = "<select name=\"templateidnew\" style=\"width: 55%\">\n";
			$query = $db->query("SELECT templateid, name FROM {$tablepre}templates");
			while($template = $db->fetch_array($query)) {
				$tplselect .= "<option value=\"$template[templateid]\"".
					($style['templateid'] == $template['templateid'] ? 'selected="selected"' : NULL).
					">$template[name]</option>\n";
			}
			$tplselect .= '</select>';
			nmcptpl('styles');
		} else {
			if($newcvar && $newcsubst) {
				$query = $db->query("SELECT COUNT(*) FROM {$tablepre}stylevars WHERE variable='$newcvar' AND styleid='$edit'");
				if($db->result($query, 0)) {
					nmsg('styles_edit_variable_duplicate','','back');
				} elseif(!preg_match("/[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*/", $newcvar)) {
					nmsg('styles_edit_variable_illegal','','back');
				}
				$newcvar = strtolower($newcvar);
				$db->query("INSERT INTO {$tablepre}stylevars (styleid, variable, substitute)
					VALUES ('$edit', '$newcvar', '$newcsubst')");
			}

			$db->query("UPDATE {$tablepre}styles SET name='$namenew', templateid='$templateidnew' WHERE styleid='$edit'");
			foreach($stylevar as $id => $substitute) {
				$substitute = @htmlspecialchars($substitute);
				$db->query("UPDATE {$tablepre}stylevars SET substitute='$substitute' WHERE stylevarid='$id' AND styleid='$edit'");
			}

			if($ids = implodeids($delete)) {
				$db->query("DELETE FROM {$tablepre}stylevars WHERE stylevarid IN ($ids) AND styleid='$edit'");
			}
			updatecache('styles');
			nmsg('styles_edit_succeed', '?action=styles'.($newcvar && $newcsubst ? '&edit='.$edit : ''));
		}
	}
}

?>