<?php
/*
	[NetMao!] (C)2001-2008 NetMao.com
	This is NOT a freeware, use is subject to license terms

	For further information go to http://www.netmao.com
*/
if(!defined('IN_NetMao')) exit('Access Denied');

function updatecache($cachename = '') {
	global $db, $bbname, $tablepre, $en_movie, $cplang, $_NCACHE;

	static $cachescript = array
		(
		'announces' => array('announces'),
		'friendlinks' => array('friendlinks'),
		'plugins'   => array('plugins'),
		'categorys' => array('categorys'),
		'players'	=> array('players'),
		'servers'	=> array('servers'),
		'settings'	=> array('settings'),
		);

	$updatelist = empty($cachename) ? array_values($cachescript) : (is_array($cachename) ? array('0' => $cachename) : array(array('0' => $cachename)));

	$updated = array();

	foreach($updatelist as $value) {
		foreach($value as $cname) {
			if(empty($updated) || !in_array($cname, $updated)) {
				$updated[] = $cname;
				getcachearray($cname);
			}
		}
	}

	foreach($cachescript as $script => $cachenames) {
		if(empty($cachename) || (!is_array($cachename) && in_array($cachename, $cachenames)) || (is_array($cachename) && array_intersect($cachename, $cachenames))) {
			$cachedata = '';
			$query = $db->query("SELECT data FROM {$tablepre}caches WHERE cachename in(".implodeids($cachenames).")");
			while($data = $db->fetch_array($query)) {
				$cachedata .= $data['data'];
			}
			writetocache($script, $cachenames, $cachedata);
		}
	}

	if(!$cachename || $cachename == 'styles') {
		$stylevars = array();
		$defaultstyleid = $_NCACHE['settings']['styleid'] ? $_NCACHE['settings']['styleid'] : $GLOBALS['styleid'];
		$query = $db->query("SELECT sv.* FROM {$tablepre}stylevars sv LEFT JOIN {$tablepre}styles s ON s.styleid = sv.styleid AND s.styleid='$defaultstyleid'");
		while($var = $db->fetch_array($query)) {
			$stylevars[$var['styleid']][$var['variable']] = $var['substitute'];
		}
		$query = $db->query("SELECT s.*, t.directory AS tpldir FROM {$tablepre}styles s LEFT JOIN {$tablepre}templates t ON s.templateid=t.templateid WHERE s.styleid='$defaultstyleid'");
		while($data = $db->fetch_array($query)) {
			$data = array_merge($data, $stylevars[$data['styleid']]);
			$data['imgdir'] = ROOTDIR.'/'.$data['imgdir'];
			if(strstr($data['imglogo'], ',')) {
				$flash = explode(",", $data['imglogo']);
				$flash[0] = trim($flash[0]);
				$flash[0] = preg_match('/^http:\/\//i', $flash[0]) ? $flash[0] : $data['imgdir'].'/'.$flash[0];
				$data['imglogo'] = "<embed src=\"".$flash[0]."\" width=\"".trim($flash[1])."\" height=\"".trim($flash[2])."\" type=\"application/x-shockwave-flash\"></embed>";
			} else {
				$data['imglogo'] = preg_match('/^http:\/\//i', $data['imglogo']) ? $data['imglogo'] : $data['imgdir'].'/'.$data['imglogo'];
				$site_name = $_NCACHE[settings][sitename];
				$data['imglogo'] = "<img src=\"$data[imglogo]\" alt=\"$site_name\" border=\"0\" />";
			}
			writetocache($data['styleid'], '', getcachevars($data, 'CONST'), 'style_');
			writetocsscache($data);
		}
	}

	if(!$cachename || $cachename == 'config') {
	    $data = "var ROOTDIR = '".ROOTDIR."'";
		writetoconfigcache($data);
	}

	if($cachename == 'files') {
		if($en_movie && $en_movie[mid] > 0){
		    $i=0;
            $result=$db->query("select mid, fid, name, content, server, player from {$tablepre}files where mid='$en_movie[mid]' order by server ASC, fid ASC");
            while($file=$db->fetch_array($result)){
			    $i=$i+1;
			    $file['name'] = empty($file['name']) ? str_replace("i",$i,$cplang[file_name]) : $file['name'];
			    $file['server'] = empty($file['server']) ? 'abs' : $file['server'];
				$en_file = array(
				    'mid' => $file['mid'],
				    'fid' => $file['fid'],
				    'server' => $file['server'],
			        );
				$file['nm'] = netmao_playcode($en_file);
				$data[$file['server']][$file['fid']] = array_merge($en_movie,$file);
            }
			writetomoviecache($data);
		}
	}
}

function getcachevars($data, $type = 'VAR') {
	$evaluate = '';
	foreach($data as $key => $val) {
		if(is_array($val)) {
			$evaluate .= "\$$key = ".arrayeval($val).";\n";
		} else {
			$val = addcslashes($val, '\'\\');
			$evaluate .= $type == 'VAR' ? "\$$key = '$val';\n" : "define('".strtoupper($key)."', '$val');\n";
		}
	}
	return $evaluate;
}

function arrayeval($array, $level = 0) {
	if(!is_array($array)) {
		return "'".$array."'";
	}
	if(is_array($array) && function_exists('var_export')) {
		return var_export($array, true);
	}

	$space = '';
	for($i = 0; $i <= $level; $i++) {
		$space .= "\t";
	}
	$evaluate = "Array\n$space(\n";
	$comma = $space;
	if(is_array($array)) {
		foreach($array as $key => $val) {
			$key = is_string($key) ? '\''.addcslashes($key, '\'\\').'\'' : $key;
			$val = !is_array($val) && (!preg_match("/^\-?[1-9]\d*$/", $val) || strlen($val) > 12) ? '\''.addcslashes($val, '\'\\').'\'' : $val;
			if(is_array($val)) {
				$evaluate .= "$comma$key => ".arrayeval($val, $level + 1);
			} else {
				$evaluate .= "$comma$key => $val";
			}
			$comma = ",\n$space";
		}
	}
	$evaluate .= "\n$space)";
	return $evaluate;
}

function getcachearray($cachename, $script = '') {
	global $db, $tablepre, $timestamp;

	$cols = '*';
	$conditions = '';

	switch($cachename) {
        case 'announces':
			$table = 'announces';
			$cols = 'id, name ,content, displayorder';
			$conditions = "order by displayorder asc";
		break;
        case 'friendlinks':
			$table = 'friendlinks';
			$cols = 'id, displayorder, name, url, description,logo';
			$conditions = "order by displayorder asc";
		break;
        case 'plugins':
			$table = 'plugins';
			$cols = 'pluginid, name, content, keyword, displayorder';
			$conditions = 'order by displayorder asc';
		break;	
        case 'categorys':
			$table = 'categorys';
			$cols = 'cid, name, identifier, content, keyword, displayorder';
			$conditions = 'order by displayorder asc';
		break;
        case 'players':
			$table = 'players';
			$cols = 'playid, name, identifier, content, displayorder';
			$conditions = 'order by displayorder asc';
		break;
        case 'servers':
			$table = 'servers';
			$cols = 'servid, name, identifier, content, description, displayorder';
			$conditions = 'order by displayorder asc';
		break;
        case 'settings':
			$table = 'settings';
			$cols = 'variable, value';
		break;
	}

	$data = array();

	if(empty($table) || empty($cols)) return '';
	$query = $db->query("SELECT $cols FROM {$tablepre}$table $conditions");

	switch($cachename) {
		case 'announces':
			while($announce = $db->fetch_array($query)) {
				$data[]=$announce;
			}
		break;
		case 'friendlinks':
			while($flink=$db->fetch_array($query)){
			    $type=(!$flink['description'] && !$flink['logo']) ? 1 : ((!$flink['description'] && $flink['logo']) ? 2 : 3);
				$data[$type][]=$flink;
			}
		break;
		case 'plugins':
			while($plugin = $db->fetch_array($query)) {
				$data[$plugin['pluginid']]['pluginid'] = $plugin['pluginid'];
				$data[$plugin['pluginid']]['name'] = $plugin['name'];
				$data[$plugin['pluginid']]['content'] = $plugin['content'];
				$data[$plugin['pluginid']]['keyword'] = $plugin['keyword'];
				$data[$plugin['pluginid']]['displayorder'] = $plugin['displayorder'];
			}
		break;
		case 'categorys':
			while($category = $db->fetch_array($query)) {
				$data[$category['identifier']]['cid'] = $category['cid'];
				$data[$category['identifier']]['name'] = $category['name'];
				$data[$category['identifier']]['identifier'] = $category['identifier'];
				$data[$category['identifier']]['content'] = $category['content'];
				$data[$category['identifier']]['keyword'] = $category['keyword'];
				$data[$category['identifier']]['displayorder'] = $category['displayorder'];
			}
		break;
		case 'players':
			while($player = $db->fetch_array($query)) {
				$data[$player['identifier']]['playid'] = $player['playid'];
				$data[$player['identifier']]['name'] = $player['name'];
				$data[$player['identifier']]['identifier'] = $player['identifier'];
				$data[$player['identifier']]['content'] = $player['content'];
				$data[$player['identifier']]['displayorder'] = $player['displayorder'];
			}
		break;
		case 'servers':
			while($server = $db->fetch_array($query)) {
				$data[$server['identifier']]['servid'] = $server['servid'];
				$data[$server['identifier']]['name'] = $server['name'];
				$data[$server['identifier']]['description'] = $server['description'];
				$data[$server['identifier']]['identifier'] = $server['identifier'];
				$s = explode("|",trim($server['content']));
				$data[$server['identifier']]['content'] = $s[0];
				$data[$server['identifier']]['player'] = $s[1];
			}
		break;
		case 'settings':
			while($setting = $db->fetch_array($query)) {
			    if(in_array($setting['variable'], array('m_areas', 'm_languages', 'm_actors', 'm_directors'))) {
				    $data[$setting['variable']] = serialize(explode("|",$setting['value']));
				}elseif(in_array($setting['variable'], array('sitename','siteurl','styleid','spiderfile','uploadsize','uploadext','d_actor','d_director','d_hits','d_picture','d_keyword','d_description','d_content','d_extensions','d_from','d_to','d_file'))) {
				    $data[$setting['variable']] = $setting['value'];
				}elseif($setting['variable']=='m_nmcodes'){
				    preg_match_all("/<nm:([^>]+)>([\s\S]*?)<\/nm>/",$setting['value'],$matchs);
				    for($i=0;$i<count($matchs[1]);$i++){
				        $labels[$matchs[1][$i]]=$matchs[2][$i];
				    }
					unset($matchs);
					$nmcodes[name]=naddslashes($labels[name]);
					$nmcodes[actor]=naddslashes($labels[actor]);
					$nmcodes[director]=naddslashes($labels[director]);
					$nmcodes[picture]=naddslashes($labels[picture]);
					$nmcodes[content]=@htmlspecialchars(naddslashes(trim($labels[content])));
					$nmcodes[hits]=intval($labels[hits]);
					$nmcodes[isindex]=intval($labels[isindex]);
					$nmcodes[ismlist]=intval($labels[ismlist]);
					$nmcodes[isshow]=intval($labels[isshow]);
					$nmcodes[isrun]=intval($labels[isrun]);
					$nmcodes[pfocname]=intval($labels[pfocname]);
					$nmcodes[pfile]=naddslashes($labels[pfile]);
					$nmcodes[pextend]=naddslashes($labels[pextend]);
					$nmcodes[pfrom]=intval($labels[pfrom]);
					$nmcodes[pto]=intval($labels[pto]);
					$nmcodes[reauthor]=intval($labels[reauthor]);
					$nmcodes[readdtime]=intval($labels[readdtime]);
					$data[$setting['variable']]=serialize($nmcodes);					
				}
			}
		break;
		default:
			while($datarow = $db->fetch_array($query)) {
				$data[] = $datarow;
			}
		break;
	}

	$dbcachename = $cachename;
	$curdata = "\$_NCACHE['$cachename'] = ".arrayeval($data).";\n\n";
	$db->query("REPLACE INTO {$tablepre}caches (cachename, type, dateline, data) VALUES ('$dbcachename', '1', '$timestamp', '".addslashes($curdata)."')");
	return $curdata;
}

function writetocache($script, $cachenames, $cachedata = '', $prefix = 'cache_') {
	if(is_array($cachenames) && !$cachedata) {
		foreach($cachenames as $name) {
			$cachedata .= getcachearray($name, $script);
		}
	}
	$dir = NetMao_ROOT.'./mdata/cache/';
	if(!is_dir($dir)) {
		@mkdir($dir, 0777);
	}
	if($fp = @fopen("$dir$prefix$script.php", 'wb')) {
		fwrite($fp, "<?php\n//NetMao cache file, DO NOT modify me!".
			"\n//Created: ".date("M j, Y, G:i").
			"\n//Identify: ".md5($prefix.$script.'.php'.$cachedata.NetMao_AuthKey)."\n\n$cachedata?>");
		fclose($fp);
	} else {
		exit('Can not write to cache files, please check directory ./mdata/ and ./mdata/cache/ .');
	}
}

function writetocsscache($data) {
	$csstemplates = array('css');
	$styleid = $data['styleid'];
	include_once NetMao_ROOT.'./mdata/cache/style_'.$styleid.'.php';
	$cachedir = NetMao_ROOT.'./mdata/cache/';
	foreach($csstemplates as $css) {
		$cssfile = template($css, $styleid, $data['tpldir']);
		$cssfile = !file_exists($cssfile) ? template($css, 1, './templates/default/') : $cssfile;
		$fp = fopen($cssfile, 'r');
		$cssdata = fread($fp, filesize($cssfile));
		fclose($fp);
		$cssdata = preg_replace("/<\?=([A-Z0-9]+)\?>/e", '\$data[strtolower(\'\1\')]', $cssdata);
		$cssdata = preg_replace("/<\?.+?\?>\s*/", '', $cssdata);
		$extra = substr($css, 3);
		if(@$fp = fopen($cachedir.'style_'.$styleid.$extra.'.css', 'w')) {
			fwrite($fp, $cssdata);
			fclose($fp);
		} else {
			exit('Can not write to cache files, please check directory ./mdata/ and ./mdata/cache/ .');
		}
	}
}

function writetoconfigcache($data) {
	$dir = NetMao_ROOT.'./';
    $cachedir = NetMao_ROOT.'./mdata/cache/';
	if(@$fp = fopen($cachedir.'config.js', 'w')) {
		fwrite($fp, $data);
		fclose($fp);
	} else {
		exit('Can not write to cache files, please check directory ./mdata/ and ./mdata/cache/ .');
	}
}

function writetomoviecache($data) {
	global $en_movie;
	$dir = NetMao_ROOT.'./';
	$movieurl = movieurl($en_movie[mid]);
	$curdata = "\$_NM['files'] = ".arrayeval($data).";\n\n";
	if($fp = @fopen("$dir$movieurl.php", 'wb')) {
		fwrite($fp, "<?php\n//NetMao cache file, DO NOT modify me!".
			"\n//Created: ".date("M j, Y, G:i").
			"\n//Identify: ".md5($movieurl.'.php'.$curdata.NetMao_AuthKey)."\n\n$curdata?>");
		fclose($fp);
	} else {
		exit("Can not write to cache files, please check directory $movieurl .");
	}
}
?>