<?php
/*
	[NetMao!] (C)2001-2008 NetMao.com
	This is NOT a freeware, use is subject to license terms

	For further information go to http://www.netmao.com
*/
error_reporting(E_ERROR | E_WARNING | E_PARSE);

@set_time_limit(1000);
set_magic_quotes_runtime(0);
define('IN_NetMao', TRUE);
define('NetMao_ROOT', '../');

if(PHP_VERSION < '4.2.0') {
	$_GET = &$HTTP_GET_VARS;
	$_POST = &$HTTP_POST_VARS;
}

$action = $_POST['action'] ? $_POST['action'] : $_GET['action'];

@include NetMao_ROOT.'./config.php';
$languagefile = NetMao_ROOT.'./install/chinese.lang.php';
$sqlfile = NetMao_ROOT.'./install/netmao.sql';

if(!is_readable($languagefile) || !is_readable($sqlfile)) {
    exit('Please upload ./install and all its files completely.');
}

require_once $languagefile;

$lockfile = NetMao_ROOT.'./mdata/install.lock';
if(file_exists($lockfile)) {
    exit($lang['lock_exists']);
}

$fp = fopen($sqlfile, 'rb');
$sql = fread($fp, 2048000);
fclose($fp);

header('Content-Type: text/html; charset='.$charset);
$version = '5.1.0';

?>

<html>
<head>
<title>NetMao Movie Installation Wizard</title>
<style>
A:visited	{COLOR: #2E8D59; TEXT-DECORATION: none}
A:link		{COLOR: #2E8D59; TEXT-DECORATION: none}
A:hover		{COLOR: #2E8D59; TEXT-DECORATION: underline}
p		{TEXT-INDENT : 15px}
body,table,td	{COLOR: #2E8D59; FONT-FAMILY: "Tahoma", "Verdana", "Arial"; FONT-SIZE: 12px; LINE-HEIGHT: 20px; scrollbar-base-color: #E1F4EB; scrollbar-arrow-color: #5C5C8D}
input		{COLOR: #429625; FONT-FAMILY: "Tahoma", "Verdana", "Arial"; FONT-SIZE: 12px; background-color: #2E8D59; color: #FFFFFF; scrollbar-base-color: #E1F4EB; scrollbar-arrow-color: #5C5C8D}
.install	{FONT-FAMILY: Arial, Verdana; FONT-SIZE: 20px; FONT-WEIGHT: bold; COLOR: #2E8D59}
</style>
</head>
<body bgcolor="#2E8D59" text="#2E8D59">
<table width="780" border="0" cellspacing="0" cellpadding="0" bgcolor="#FFFFFF" align="center">
  <tr>
    <td> <table width="98%" border="0" cellspacing="0" cellpadding="0" align="center">
        <tr> 
          <td class="install" height="30" valign="bottom"><font color="#FF0000">&gt;&gt;</font> 
            <?=$lang['install_wizard']?>
          </td>
        </tr>
        <tr> 
          <td> <hr noshade align="center" width="100%" size="1"> </td>
        </tr>
        <tr> 
          <td> <b> 
            <?=$lang['welcome']?>
            </b> </td>
        </tr>
        <tr> 
          <td> <hr noshade align="center" width="100%" size="1"> </td>
        </tr>
<?
if(!$action) {
$netmao_license = str_replace('  ', '&nbsp; ', $lang['license']);
?>
        <tr> 
          <td><b>
            <?=$lang['current_process']?>
            </b><font color="#0000EE">
            <?=$lang['show_license']?>
            </font></td>
        </tr>
        <tr> 
          <td> <hr noshade align="center" width="100%" size="1"> </td>
        </tr>
        <tr> 
          <td><b><font color="#FF0000">&gt;</font><font color="#2E8D59"> 
            <?=$lang['agreement']?>
            </font></b></td>
        </tr>
        <tr> 
          <td><br> <table width="90%" cellspacing="1" bgcolor="#2E8D59" border="0" align="center">
              <tr> 
                <td bgcolor="#E1F4EB"> <table width="99%" cellspacing="1" border="0" align="center">
                    <tr> 
                      <td> 
                        <?=$netmao_license?>
                      </td>
                    </tr>
                  </table></td>
              </tr>
            </table></td>
        </tr>
        <tr> 
          <td align="center"> <br> <form method="post" action="index.php">
              <input name="action" type="hidden" id="action" value="config">
              <input type="submit" name="submit" value="<?=$lang['agreement_yes']?>" style="height: 25">
              &nbsp; 
              <input type="button" name="exit" value="<?=$lang['agreement_no']?>" style="height: 25" onClick="javascript: window.close();">
            </form></td>
        </tr>
<?
} elseif($action == 'config') {
	$exist_error = FALSE;
	$write_error = FALSE;
	if(file_exists(NetMao_ROOT.'./config.php')) {
		$fileexists = result(1, 0);
	} else {
		$fileexists = result(0, 0);
		$exist_error = TRUE;
		$config_info = $lang['config_nonexistence'];
	}
	if(is_writeable(NetMao_ROOT.'./config.php')) {
		$filewriteable = result(1, 0);
		$config_info = $lang['config_comment'];
	} else {
		$filewriteable = result(0, 0);
		$write_error = TRUE;
		$config_info = $lang['config_unwriteable'];
	}
?>
        <tr> 
          <td><b>
            <?=$lang['current_process']?>
            </b><font color="#0000EE">
            <?=$lang['configure']?>
            </font></td>
        </tr>
        <tr> 
          <td> <hr noshade align="center" width="100%" size="1"> </td>
        </tr>
        <tr> 
          <td><b><font color="#FF0000">&gt;</font><font color="#2E8D59"> 
            <?=$lang['check_config']?>
            </font></b></td>
        </tr>
        <tr> 
          <td>config.php 
            <?=$lang['check_existence']?>
            <?=$fileexists?>
          </td>
        </tr>
        <tr> 
          <td>config.php 
            <?=$lang['check_writeable']?>
            <?=$filewriteable?>
          </td>
        </tr>
        <tr> 
          <td> <hr noshade align="center" width="100%" size="1"> </td>
        </tr>
        <tr> 
          <td><b><font color="#FF0000">&gt;</font><font color="#2E8D59"> 
            <?=$lang['edit_config']?>
            </font></b></td>
        </tr>
        <tr> 
          <td align="center"><br>
            <?=$config_info?>
          </td>
        </tr>
<?
	if(!$exist_error) {
		if(!$write_error) {
			$dbhost = 'localhost';
			$dbuser = 'dbuser';
			$dbpw = 'dbpw';
			$dbname = 'dbname';
			$tablepre = 'nm_';
		   @include NetMao_ROOT.'./config.php';
?>
        <tr> 
          <td align="center"> <br> <form method="post" action="index.php">
              <table width="650" cellspacing="1" bgcolor="#2E8D59" border="0" align="center">
                <tr bgcolor="#2E8D59"> 
                  <td align="center" width="20%" style="color: #FFFFFF">
                    <?=$lang['variable']?>
                  </td>
                  <td align="center" width="30%" style="color: #FFFFFF">
                    <?=$lang['value']?>
                  </td>
                  <td align="center" width="50%" style="color: #FFFFFF">
                    <?=$lang['comment']?>
                  </td>
                </tr>
                <tr> 
                  <td bgcolor="#E1F4EB" style="color: #FF0000">&nbsp;
                    <?=$lang['dbhost']?>
                  </td>
                  <td bgcolor="#E1F4EB" align="center"><input type="text" name="dbhost" value="<?=$dbhost?>" size="30"></td>
                  <td bgcolor="#E1F4EB">&nbsp;
                    <?=$lang['dbhost_comment']?>
                  </td>
                </tr>
                <tr> 
                  <td bgcolor="#E1F4EB">&nbsp;
                    <?=$lang['dbuser']?>
                  </td>
                  <td bgcolor="#E1F4EB" align="center"><input type="text" name="dbuser" value="<?=$dbuser?>" size="30"></td>
                  <td bgcolor="#E1F4EB">&nbsp;
                    <?=$lang['dbuser_comment']?>
                  </td>
                </tr>
                <tr> 
                  <td bgcolor="#E1F4EB">&nbsp;
                    <?=$lang['dbpw']?>
                  </td>
                  <td bgcolor="#E1F4EB" align="center"><input type="password" name="dbpw" value="<?=$dbpw?>" size="30"></td>
                  <td bgcolor="#E1F4EB">&nbsp;
                    <?=$lang['dbpw_comment']?>
                  </td>
                </tr>
                <tr> 
                  <td bgcolor="#E1F4EB" style="color: #FF0000">&nbsp;
                    <?=$lang['tablepre']?>
                  </td>
                  <td bgcolor="#E1F4EB" align="center"><input type="text" name="tablepre" value="<?=$tablepre?>" size="30" onClick="javascript: alert('<?=$lang['install_note']?>:\n\n<?=$lang['tablepre_prompt']?>');"></td>
                  <td bgcolor="#E1F4EB">&nbsp;
                    <?=$lang['tablepre_comment']?>
                  </td>
                </tr>
              </table>
              <br>
              <input name="action" type="hidden" id="action" value="dbselect">
              <input name="saveconfig" type="hidden" id="saveconfig" value="1">
              <input type="submit" name="submit" value="<?=$lang['save_config']?>" style="height: 25">
              <input type="button" name="exit" value="<?=$lang['exit']?>" style="height: 25" onClick="javascript: window.close();">
            </form></td>
        </tr>
<?
} else {
			@include NetMao_ROOT.'./config.php';
?>
        <tr> 
          <td> <br> <table width="60%" cellspacing="1" bgcolor="#2E8D59" border="0" align="center">
              <tr bgcolor="#2E8D59"> 
                <td align="center" style="color: #FFFFFF">
                  <?=$lang['variable']?>
                </td>
                <td align="center" style="color: #FFFFFF">
                  <?=$lang['value']?>
                </td>
                <td align="center" style="color: #FFFFFF">
                  <?=$lang['comment']?>
                </td>
              </tr>
              <tr> 
                <td bgcolor="#E1F4EB" align="center">$dbhost</td>
                <td bgcolor="#E1F4EB" align="center">
                  <?=$dbhost?>
                </td>
                <td bgcolor="#E1F4EB" align="center">
                  <?=$lang['dbhost_comment']?>
                </td>
              </tr>
              <tr> 
                <td bgcolor="#E1F4EB" align="center">$dbuser</td>
                <td bgcolor="#E1F4EB" align="center">
                  <?=$dbuser?>
                </td>
                <td bgcolor="#E1F4EB" align="center">
                  <?=$lang['dbuser_comment']?>
                </td>
              </tr>
              <tr> 
                <td bgcolor="#E1F4EB" align="center">$dbpw</td>
                <td bgcolor="#E1F4EB" align="center"> 
                  <?=$dbpw?>
                </td>
                <td bgcolor="#E1F4EB" align="center">
                  <?=$lang['dbpw_comment']?>
                </td>
              </tr>
              <tr> 
                <td bgcolor="#E1F4EB" align="center">$dbname</td>
                <td bgcolor="#E1F4EB" align="center">
                  <?=$dbname?>
                </td>
                <td bgcolor="#E1F4EB" align="center">
                  <?=$lang['dbname_comment']?>
                </td>
              </tr>
              <tr> 
                <td bgcolor="#E1F4EB" align="center">$tablepre</td>
                <td bgcolor="#E1F4EB" align="center">
                  <?=$tablepre?>
                </td>
                <td bgcolor="#E1F4EB" align="center">
                  <?=$lang['tablepre_comment']?>
                </td>
              </tr>
            </table>
            <br> </td>
        </tr>
        <tr> 
          <td align="center"> <form method="post" action="index.php?language=<?=$language?>">
              <input type="hidden" name="action" value="environment">
              <input type="submit" name="submit" value="<?=$lang['confirm_config']?>" style="height: 25">
              <input type="button" name="exit" value="<?=$lang['refresh_config']?>" style="height: 25" onClick="javascript: window.location=('?language=<?=$language?>&action=config');">
            </form></td>
        </tr>
<?
		}
	} else {
?>
        <tr> 
          <td align="center"> <br> <form method="post" action="index.php?language=<?=$language?>">
              <input type="hidden" name="action" value="config">
              <input type="submit" name="submit" value="<?=$lang['recheck_config']?>" style="height: 25">
              <input type="button" name="exit" value="<?=$lang['exit']?>" style="height: 25" onClick="javascript: window.close();">
            </form></td>
        </tr>
        <?
	}
} elseif($action == 'dbselect') {
	$exist_error = FALSE;
	$write_error = FALSE;
	if(file_exists(NetMao_ROOT.'./config.php')) {
		$fileexists = result(1, 0);
	} else {
		$fileexists = result(0, 0);
		$exist_error = TRUE;
		$config_info = $lang['config_nonexistence'];
	}
	if(is_writeable(NetMao_ROOT.'./config.php')) {
		$filewriteable = result(1, 0);
		$config_info = $lang['choice_or_new_db'];
	} else {
		$filewriteable = result(0, 0);
		$write_error = TRUE;
		$config_info = $lang['config_unwriteable'];
	}
?>
        <tr> 
          <td><b>
            <?=$lang['current_process']?>
            </b><font color="#0000EE">
            <?=$lang['netmao_db_conf']?>
            </font></td>
        </tr>
        <tr> 
          <td> <hr noshade align="center" width="100%" size="1"> </td>
        </tr>
        <tr> 
          <td><b><font color="#FF0000">&gt;</font><font color="#2E8D59"> 
            <?=$lang['check_config']?>
            </font></b></td>
        </tr>
        <tr> 
          <td>config.php 
            <?=$lang['check_existence']?>
            <?=$fileexists?>
          </td>
        </tr>
        <tr> 
          <td>config.php 
            <?=$lang['check_writeable']?>
            <?=$filewriteable?>
          </td>
        </tr>
        <tr> 
          <td> <hr noshade align="center" width="100%" size="1"> </td>
        </tr>
        <tr> 
          <td><b><font color="#FF0000">&gt;</font><font color="#2E8D59">
            <?=$lang['show_and_edit_db_conf']?>
            </font></b></td>
        </tr>
        <tr> 
          <td align="center"><br>
            <?=$config_info?>
          </td>
        </tr>
        <tr> 
          <td align="center"> <br> <form method="post" action="index.php">
              <table width="40%" cellspacing="1" bgcolor="#2E8D59" border="0" align="center">
                <tr bgcolor="#2E8D59"> 
                  <td align="center" colspan="3" style="color: #FFFFFF">
                    <?=$lang['db_set']?>
                  </td>
                </tr>
<?
	if(!$exist_error) {
		if(!$write_error) {
			if($_POST['saveconfig'] && is_writeable(NetMao_ROOT.'./config.php')) {
				$dbhost = setconfig($_POST['dbhost']);
				$dbuser = setconfig($_POST['dbuser']);
				$dbpw = setconfig($_POST['dbpw']);
				$tablepre = setconfig($_POST['tablepre']);
				$fp = fopen(NetMao_ROOT.'./config.php', 'r');
				$configfile = fread($fp, filesize(NetMao_ROOT.'./config.php'));
				fclose($fp);
				$configfile = preg_replace("/[$]dbhost\s*\=\s*[\"'].*?[\"'];/is", "\$dbhost = '$dbhost';", $configfile);
				$configfile = preg_replace("/[$]dbuser\s*\=\s*[\"'].*?[\"'];/is", "\$dbuser = '$dbuser';", $configfile);
				$configfile = preg_replace("/[$]dbpw\s*\=\s*[\"'].*?[\"'];/is", "\$dbpw = '$dbpw';", $configfile);
				$configfile = preg_replace("/[$]tablepre\s*\=\s*[\"'].*?[\"'];/is", "\$tablepre = '$tablepre';", $configfile);
				$fp = fopen(NetMao_ROOT.'./config.php', 'w');
				fwrite($fp, trim($configfile));
				fclose($fp);
			}
			include NetMao_ROOT.'./config.php';
			include NetMao_ROOT.'./inc/db_mysql.php';
			$db = new db;
			$db->connect($dbhost, $dbuser, $dbpw, $dbname, $pconnect);
			$query = $db->query("CREATE DATABASE nm_temp", 'SILENT');
			if($db->error()) {
				$createerror = TRUE;
			} else {
				$query = $db->query("DROP DATABASE nm_temp", 'SILENT');
				$createerror = FALSE;
			}
			$query = $db->query("SHOW DATABASES", 'SILENT');
			$option = '';
			if($query) {
				while($database = $db->fetch_array($query)) {
					if($database['Database'] != 'mysql') {
						$option .= '<option value="'.$database['Database'].'"' .($dbname == $database['Database'] ? ' selected' : '') . '>'.$database['Database']."</option>";
					}
				}
			}
			if(!empty($option)) {
?>
                <tr> 
                  <td bgcolor="#E1F4EB">&nbsp; <input name="type" type="radio" value="2" checked style="background-color:#E1F4EB"> 
                    <?=$lang['db_use_existence']?>
                    : </td>
                  <td bgcolor="#E1F4EB">&nbsp; <select name="dbnameselect" style="width:200px">
                      <?=$option?>
                    </select> </td>
                </tr>
<?
			}
			if(!$createerror) {
?>
                <tr> 
                  <td bgcolor="#E1F4EB">&nbsp; <input name="type" type="radio" value="1" style="background-color:#E1F4EB"<?=((empty($option)) ? ' checked' : '')?>> 
                    <?=$lang['db_create_new']?>
                    : </td>
                  <td bgcolor="#E1F4EB">&nbsp; <input type="text" name="dbname" value="<?=$dbname?>" style="width:200px"> 
                  </td>
                </tr>
                <?
			}
			if($createerror && empty($option)) {
?>
                <tr> 
                  <td bgcolor="#E1F4EB">&nbsp; 
                    <?=$lang['choice_one_db']?>
                    : </td>
                  <td bgcolor="#E1F4EB">&nbsp; <input type="text" name="dbname" value="<?=$dbname?>" style="width:200px"> 
                  </td>
                </tr>
<?
			}
?>
              </table>
            </tr>
<?
		} else {
				@include NetMao_ROOT.'./config.php';
?>
        <tr> 
          <td bgcolor="#E1F4EB">&nbsp; 
            <?=$lang['db']?>
            : </td>
          <td bgcolor="#E1F4EB">&nbsp; <input type="hidden" name="dbname" value="<?=$dbname?>">
            <?=$dbname?>
          </td>
        </tr>
      </table></td>
         </tr>
<?
		}
?>
         <tr>
	   <td align="center">
	     <br>
	     <input type="hidden" name="action" value="environment">
      <input name="saveconfig" type="hidden" id="saveconfig" value="1"> 
      <input type="submit" name="submit" value="<?=$lang['save_config']?>" style="height: 25">
	     <input type="button" name="exit" value="<?=$lang['exit']?>" style="height: 25" onclick="javascript: window.close();">
	   </td>
	 </tr>
	 </form>
<?
	}
	if($exist_error) {
?>
        <tr>
          <td align="center">
            <br>
            <form method="post" action="index.php?language=<?=$language?>">
              <input type="hidden" name="action" value="config">
              <input type="submit" name="submit" value="<?=$lang['recheck_config']?>" style="height: 25">
              <input type="button" name="exit" value="<?=$lang['exit']?>" style="height: 25" onclick="javascript: window.close();">
            </form>
          </td>
        </tr>
<?
	}
} elseif($action == 'environment') {

	if($_POST['saveconfig'] && is_writeable(NetMao_ROOT.'./config.php')) {

		$dbname = ($_POST['type'] == 1) ? $_POST['dbname'] : $_POST['dbnameselect'];
		$dbname = setconfig($dbname);

		$fp = fopen(NetMao_ROOT.'./config.php', 'r');
		$configfile = fread($fp, filesize(NetMao_ROOT.'./config.php'));
		fclose($fp);

		$configfile = preg_replace("/[$]dbname\s*\=\s*[\"'].*?[\"'];/is", "\$dbname = '$dbname';", $configfile);

		$fp = fopen(NetMao_ROOT.'./config.php', 'w');
		fwrite($fp, trim($configfile));
		fclose($fp);
	}
	include NetMao_ROOT.'./config.php';
	include NetMao_ROOT.'./inc/db_mysql.php';
	$db = new db;
	$db->connect($dbhost, $dbuser, $dbpw, $dbname, $pconnect);
	$msg = '';
	$quit = FALSE;
	$curr_os = PHP_OS;
	$curr_php_version = PHP_VERSION;
	if($curr_php_version < '4.0.6') {
		$msg .= "<font color=\"#FF0000\">$lang[php_version_406]</font>\t";
		$quit = TRUE;
	}
	if(@ini_get(file_uploads)) {
		$max_size = @ini_get(upload_max_filesize);
		$curr_upload_status = $lang['attach_enabled'].$max_size;
		$msg .= $lang['attach_enabled_info'].$max_size."\t";
	} else {
		$curr_upload_status = $lang['attach_disabled'];
		$msg .= "<font color=\"#FF0000\">$lang[attach_disabled_info]</font>\t";
	}
	$query = $db->query("SELECT VERSION()");
	$curr_mysql_version = $db->result($query, 0);
	if($curr_mysql_version < '3.23') {
		$msg .= "<font color=\"#FF0000\">$lang[mysql_version_323]</font>\t";
		$quit = TRUE;
	}
	$curr_disk_space = intval(diskfreespace('.') / (1024 * 1024)).'M';
	if(dir_writeable(NetMao_ROOT.'./mdata')) {
		$curr_mdata_writeable = $lang['writeable'];
	} else {
		$curr_mdata_writeable = $lang['unwriteable'];
		$msg .= "<font color=\"#FF0000\">$lang[unwriteable_mdata]</font>\t";
	}
	if(dir_writeable(NetMao_ROOT.'./mlist')) {
		$curr_mlist_writeable = $lang['writeable'];
	} else {
		$curr_mlist_writeable = $lang['unwriteable'];
		$msg .= "<font color=\"#FF0000\">$lang[unwriteable_mlist]</font>\t";
	}
	if(dir_writeable(NetMao_ROOT.'./upfiles')) {
		$curr_upfiles_writeable = $lang['writeable'];
	} else {
		$curr_upfiles_writeable = $lang['unwriteable'];
		$msg .= "<font color=\"#FF0000\">$lang[unwriteable_upfiles]</font>\t";
	}
	if(strstr($tablepre, '.')) {
		$msg .= "<font color=\"#FF0000\">$lang[tablepre_invalid]</font>\t";
		$quit = TRUE;
	}
	$db->select_db($dbname);
	if($db->error()) {
		if($db->version() > '4.1') {
			$db->query("CREATE DATABASE IF NOT EXISTS $dbname DEFAULT CHARACTER SET $dbcharset");
		} else {
			$db->query("CREATE DATABASE IF NOT EXISTS $dbname");
		}
		if($db->error()) {
			$msg .= "<font color=\"#FF0000\">$lang[db_invalid]</font>\t";
			$quit = TRUE;
		} else {
			$db->select_db($dbname);
			$msg .= "$lang[db_auto_created]\t";
		}
	}
//**************************************
	$query = $db->query("CREATE TABLE nm_test (test TINYINT (3) UNSIGNED)", 'SILENT');
	if($db->error()) {
		$dbpriv_createtable = '<font color="#FF0000">'.$lang['no'].'</font>';
		$quit = TRUE;
	} else {
		$dbpriv_createtable = $lang['yes'];
	}
	$query = $db->query("INSERT INTO nm_test (test) VALUES (1)", 'SILENT');
	if($db->error()) {
		$dbpriv_insert = '<font color="#FF0000">'.$lang['no'].'</font>';
		$quit = TRUE;
	} else {
		$dbpriv_insert = $lang['yes'];
	}
	$query = $db->query("SELECT * FROM nm_test", 'SILENT');
	if($db->error()) {
		$dbpriv_select = '<font color="#FF0000">'.$lang['no'].'</font>';
		$quit = TRUE;
	} else {
		$dbpriv_select = $lang['yes'];
	}
	$query = $db->query("UPDATE nm_test SET test='2' WHERE test='1'", 'SILENT');
	if($db->error()) {
		$dbpriv_update = '<font color="#FF0000">'.$lang['no'].'</font>';
		$quit = TRUE;
	} else {
		$dbpriv_update = $lang['yes'];
	}
	$query = $db->query("DELETE FROM nm_test WHERE test='2'", 'SILENT');
	if($db->error()) {
		$dbpriv_delete = '<font color="#FF0000">'.$lang['no'].'</font>';
		$quit = TRUE;
	} else {
		$dbpriv_delete = $lang['yes'];
	}
	$query = $db->query("DROP TABLE nm_test", 'SILENT');
	if($db->error()) {
		$dbpriv_droptable = '<font color="#FF0000">'.$lang['no'].'</font>';
		$quit = TRUE;
	} else {
		$dbpriv_droptable = $lang['yes'];
	}
	$query - $db->query("SELECT COUNT(*) FROM $tablepre"."settings", 'SILENT');
	if(!$db->error()) {
		$msg .= "<font color=\"#FF0000\">$lang[db_not_null]</font>\t";
		$alert = " onSubmit=\"return confirm('$lang[db_drop_table_confirm]');\"";
	} else {
		$alert = '';
	}
//***************************************************************
	if($quit) {
		$msg .= "<font color=\"#FF0000\">$lang[install_abort]</font>";
	} else {
		$msg .= $lang['install_process'];
	}
?>
        <tr>
          <td><b><?=$lang['current_process']?> </b><font color="#0000EE"><?=$lang['check_env']?></font></td>
        </tr>
        <tr>
          <td>
            <hr noshade align="center" width="100%" size="1">
          </td>
        </tr>
        <tr>
          <td><b><font color="#FF0000">&gt;</font><font color="#2E8D59"> <?=$lang['check_user_and_pass']?></font></b></td>
        </tr>
        <tr>
          <td>
            <br>
            <table width="50%" cellspacing="1" bgcolor="#2E8D59" border="0" align="center">
              <tr bgcolor="#2E8D59">
                <td align="center" style="color: #FFFFFF"><?=$lang['permission']?></td>
                <td align="center" style="color: #FFFFFF"><?=$lang['status']?></td>
              </tr>
              <tr>
                <td bgcolor="#E1F4EB" align="center">CREATE TABLE</td>
                <td bgcolor="#E1F4EB" align="center"><?=$dbpriv_createtable?></td>
              </tr>
              <tr>
                <td bgcolor="#E1F4EB" align="center">INSERT</td>
                <td bgcolor="#E1F4EB" align="center"><?=$dbpriv_insert?></td>
              </tr>
              <tr>
                <td bgcolor="#E1F4EB" align="center">SELECT</td>
                <td bgcolor="#E1F4EB" align="center"><?=$dbpriv_select?></td>
              </tr>
              <tr>
                <td bgcolor="#E1F4EB" align="center">UPDATE</td>
                <td bgcolor="#E1F4EB" align="center"><?=$dbpriv_update?></td>
              </tr>
              <tr>
                <td bgcolor="#E1F4EB" align="center">DELETE</td>
                <td bgcolor="#E1F4EB" align="center"><?=$dbpriv_delete?></td>
              </tr>
              <tr>
                <td bgcolor="#E1F4EB" align="center">DROP TABLE</td>
                <td bgcolor="#E1F4EB" align="center"><?=$dbpriv_droptable?></td>
              </tr>
            </table>
            <br>
          </td>
        </tr>
        <tr>
          <td>
            <hr noshade align="center" width="100%" size="1">
          </td>
        </tr>
        <tr>
          <td><b><font color="#FF0000">&gt;</font><font color="#2E8D59"> <?=$lang['compare_env']?></font></b></td>
        </tr>
        <tr>
          <td>
            <br>
            <table width="80%" cellspacing="1" bgcolor="#2E8D59" border="0" align="center">
        <tr bgcolor="#2E8D59"> 
          <td align="center"></td>
          <td align="center" style="color: #FFFFFF"> 
            <?=$lang['env_required']?>
          </td>
          <td align="center" style="color: #FFFFFF"> 
            <?=$lang['env_best']?>
          </td>
          <td align="center" style="color: #FFFFFF"> 
            <?=$lang['env_current']?>
          </td>
        </tr>
        <tr> 
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$lang['env_os']?>
          </td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$lang['unlimited']?>
          </td>
          <td bgcolor="#E1F4EB" align="center">UNIX/Linux/FreeBSD</td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$curr_os?>
          </td>
        </tr>
        <tr> 
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$lang['env_php']?>
          </td>
          <td bgcolor="#E1F4EB" align="center">4.0.6+</td>
          <td bgcolor="#E1F4EB" align="center">4.3.5+</td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$curr_php_version?>
          </td>
        </tr>
        <tr> 
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$lang['env_attach']?>
          </td>
          <td bgcolor="#E1F4EB" align="center"3> 
            <?=$lang['unlimited']?>
          </td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$lang['enabled']?>
          </td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$curr_upload_status?>
          </td>
        </tr>
        <tr> 
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$lang['env_mysql']?>
          </td>
          <td bgcolor="#E1F4EB" align="center">3.23+</td>
          <td bgcolor="#E1F4EB" align="center">4.0.18</td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$curr_mysql_version?>
          </td>
        </tr>
        <tr> 
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$lang['env_diskspace']?>
          </td>
          <td bgcolor="#E1F4EB" align="center">2M+</td>
          <td bgcolor="#E1F4EB" align="center">50M+</td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$curr_disk_space?>
          </td>
        </tr>
        <tr> 
          <td bgcolor="#E1F4EB" align="center">./mdata 
            <?=$lang['env_dir_writeable']?>
          </td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$lang['unlimited']?>
          </td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$lang['writeable']?>
          </td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$curr_mdata_writeable?>
          </td>
        </tr>
        <tr> 
          <td bgcolor="#E1F4EB" align="center">./mlist 
            <?=$lang['env_dir_writeable']?>
          </td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$lang['unlimited']?>
          </td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$lang['writeable']?>
          </td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$curr_mlist_writeable?>
          </td>
        </tr>
        <tr> 
          <td bgcolor="#E1F4EB" align="center">./upfiles 
            <?=$lang['env_dir_writeable']?>
          </td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$lang['unlimited']?>
          </td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$lang['writeable']?>
          </td>
          <td bgcolor="#E1F4EB" align="center"> 
            <?=$curr_upfiles_writeable?>
          </td>
        </tr>
      </table>
            <br>
          </td>
        </tr>
        <tr>
          <td>
            <hr noshade align="center" width="100%" size="1">
          </td>
        </tr>
        <tr>
          <td><b><font color="#FF0000">&gt;</font><font color="#2E8D59"> <?=$lang['confirm_preparation']?></font></b></td>
        </tr>
        <tr>
          <td>
            <br>
            <ol><?=$lang['preparation']?></ol>
          </td>
        </tr>
        <tr>
          <td>
            <hr noshade align="center" width="100%" size="1">
          </td>
        </tr>
        <tr>
          <td><b><font color="#FF0000">&gt;</font><font color="#2E8D59"> <?=$lang['install_note']?></font></b></td>
        </tr>
        <tr>
          <td>
            <br>
            <ol>
<?

	foreach(explode("\t", $msg) as $message) {
		echo "              <li>$message</li>\n";
	}
	echo"            </ol>\n";

	if($quit) {

?>
            <center>
            <input type="button" name="refresh" value="<?=$lang['recheck_config']?>" style="height: 25" onclick="javascript: window.location=('?language=<?=$language?>&action=environment');">&nbsp;
            <input type="button" name="exit" value="<?=$lang['exit']?>" style="height: 25" onclick="javascript: window.close();">
            </center>
<?

	} else {

?>
        <form method="post" action="index.php" <?=$alert?>>

        <tr>
          <td>
            <hr noshade align="center" width="100%" size="1">
          </td>
        </tr>
        <tr>
          <td><b><font color="#FF0000">&gt;</font><font color="#2E8D59"> <?=$lang['add_admin']?></font></b></td>
        </tr>
        <tr>
          <td align="center">
            <br>
            <table width="350" cellspacing="1" bgcolor="#2E8D59" border="0" align="center">
                <tr> 
                  <td bgcolor="#E1F4EB" width="40%">&nbsp;
                    <?=$lang['username']?>
                  </td>
                  <td bgcolor="#E1F4EB" width="60%"><input type="text" name="username" value="admin" size="30"></td>
                </tr>
                <tr> 
                  <td bgcolor="#E1F4EB" width="40%">&nbsp;
                    <?=$lang['password']?>
                  </td>
                  <td bgcolor="#E1F4EB" width="60%"><input type="password" name="password1" size="30"></td>
                </tr>
                <tr> 
                  <td bgcolor="#E1F4EB" width="40%">&nbsp;
                    <?=$lang['repeat_password']?>
                  </td>
                  <td bgcolor="#E1F4EB" width="60%"><input type="password" name="password2" size="30"></td>
                </tr>
              </table>
            <br>
            <input type="hidden" name="action" value="install">
            <input type="submit" name="submit" value="<?=$lang['start_install']?>" style="height: 25" >&nbsp;
            <input type="button" name="exit" value="<?=$lang['exit']?>" style="height: 25" onclick="javascript: window.close();">
          </td>
        </tr>

        </form>
<?

	}
} elseif($action == 'install') {

	$username = $_POST['username'];
	$password1 = $_POST['password1'];
	$password2 = $_POST['password2'];

?>
        <tr>
          <td><b><?=$lang['current_process']?> </b><font color="#0000EE"> <?=$lang['installing']?></font></td>
        </tr>
        <tr>
          <td>
            <hr noshade align="center" width="100%" size="1">
          </td>
        </tr>
        <tr>
          <td><b><font color="#FF0000">&gt;</font><font color="#2E8D59"> <?=$lang['check_admin']?></font></b></td>
        </tr>
        <tr>
          <td><?=$lang['check_admin_validity']?>
<?
	$msg = '';
	if($username && $password1 && $password2) {
		if($password1 != $password2) {
			$msg = $lang['admin_password_invalid'];
		} elseif(strlen($username) > 15 || preg_match("/^$|^c:\\con\\con$||[,\"\s\t\<\>&]|^ο|^Guest/is", $username)) {
			$msg = $lang['admin_username_invalid'];
		}
	} else {
		$msg = $lang['admin_invalid'];
	}
	if($msg) {
?>
            ... <font color="#FF0000"><?=$lang['fail_reason']?> <?=$msg?></font></td>
        </tr>
        <tr>
          <td align="center">
            <br>
            <input type="button" name="back" value="<?=$lang['go_back']?>" onclick="javascript: history.go(-1);">
          </td>
        </tr>
        <tr>
          <td>
            <hr noshade align="center" width="100%" size="1">
          </td>
        </tr>
        <tr>
          <td align="center">
            <b style="font-size: 11px">Powered by <a href="http://bbs.netmao.com" target="_blank">NetMao <?=$version?></a> , &nbsp; Copyright &copy; <a href="http://www.netmao.com" target=\"_blank\">NetMao Home</a>, 2001-2008</b>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<br>
</body>
</html>

<?
		exit();
	} else {
		echo result(1, 0)."</td>\n";
		echo"        </tr>\n";
	}
?>
        <tr>
          <td>
            <hr noshade align="center" width="100%" size="1">
          </td>
        </tr>
        <tr>
          <td><b><font color="#FF0000">&gt;</font><font color="#2E8D59"> <?=$lang['select_db']?></font></b></td>
        </tr>
<?
	include NetMao_ROOT.'./config.php';

	if(empty($dbcharset) && ($charset == 'gbk')) {
		$dbcharset = $charset;
	}

	include NetMao_ROOT.'./inc/db_mysql.php';
	$db = new db;
	$db->connect($dbhost, $dbuser, $dbpw, $dbname, $pconnect);
	$db->select_db($dbname);

echo"        <tr>\n";
echo"          <td>$lang[select_db] $dbname ".result(1, 0)."</td>\n";
echo"        </tr>\n";
echo"        <tr>\n";
echo"          <td>\n";
echo"            <hr noshade align=\"center\" width=\"100%\" size=\"1\">\n";
echo"          </td>\n";
echo"        </tr>\n";
echo"        <tr>\n";
echo"          <td><b><font color=\"#FF0000\">&gt;</font><font color=\"#2E8D59\"> $lang[create_table]</font></b></td>\n";
echo"        </tr>\n";
echo"        <tr>\n";
echo"          <td>\n";

runquery($sql);
$password = md5($password1);
$db->query("INSERT INTO {$tablepre}admins (id, user, pwd, priv) VALUES (1, '$username', '$password', '3')");

$filename=NetMao_ROOT.'./index.htm';
$content=$lang[index_content];
file_write($filename,$content);
touch($lockfile);

echo"          </td>\n";
echo"        </tr>\n";
echo"        <tr>\n";
echo"          <td>\n";
echo"            <hr noshade align=\"center\" width=\"100%\" size=\"1\">\n";
echo"          </td>\n";
echo"        </tr>\n";
echo"          <td>\n";
?>
          </td>
        </tr>
        <tr>
          <td align="center">
            <font color="#FF0000"><b><?=$lang['install_succeed']?></font><br>
            <?=$lang['username']?></b> <?=$username?><b> &nbsp; <?=$lang['password']?></b> <?=$password1?><br><br>
            <a href="../nmadmin.php" target="_blank"><?=$lang['goto_manage']?></a>
          </td>
        </tr>
<?
}
?>
        <tr>
          <td>
            <hr noshade align="center" width="100%" size="1">
          </td>
        </tr>
        <tr>
          <td align="center">
            <b style="font-size: 11px">Powered by <a href="http://www.netmao.com/bbs/" target="_blank">NetMao <?=$version?></a> , &nbsp; Copyright &copy; <a href="http://www.netmao.com" target=\"_blank\">NetMao Home</a>, 2001-2008</b>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<br>
</body>
</html>
<?
function runquery($sql) {
	global $lang, $dbcharset, $tablepre, $db;

	$sql = str_replace("\r", "\n", str_replace(' nm_', ' '.$tablepre, $sql));
	$ret = array();
	$num = 0;
	foreach(explode(";\n", trim($sql)) as $query) {
		$queries = explode("\n", trim($query));
		foreach($queries as $query) {
			$ret[$num] .= $query[0] == '#' || $query[0].$query[1] == '--' ? '' : $query;
		}
		$num++;
	}
	unset($sql);

	foreach($ret as $query) {
		$query = trim($query);
		if($query) {
			if(substr($query, 0, 12) == 'CREATE TABLE') {
				$name = preg_replace("/CREATE TABLE ([a-z0-9_]+) .*/is", "\\1", $query);
				echo $lang['create_table'].' '.$name.' ... <font color="#0000EE">'.$lang['succeed'].'</font><br>';
				$db->query(createtable($query, $dbcharset));
			} else {
				$db->query($query);
			}
		}
	}
}

function result($result = 1, $output = 1) {
	global $lang;

	if($result) {
		$text = '... <font color="#0000EE">'.$lang['succeed'].'</font><br>';
		if(!$output) {
			return $text;
		}
		echo $text;
	} else {
		$text = '... <font color="#FF0000">'.$lang['fail'].'</font><br>';
		if(!$output) {
			return $text;
		}
		echo $text;
	}
}

function dir_writeable($dir) {
	if(!is_dir($dir)) {
		@mkdir($dir, 0777);
	}
	if(is_dir($dir)) {
		if($fp = @fopen("$dir/test.test", 'w')) {
			@fclose($fp);
			@unlink("$dir/test.test");
			$writeable = 1;
		} else {
			$writeable = 0;
		}
	}
	return $writeable;
}

function random($length) {
	$hash = '';
	$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz';
	$max = strlen($chars) - 1;
	mt_srand((double)microtime() * 1000000);
	for($i = 0; $i < $length; $i++) {
		$hash .= $chars[mt_rand(0, $max)];
	}
	return $hash;
}

function createtable($sql, $dbcharset) {
	$type = strtoupper(preg_replace("/^\s*CREATE TABLE\s+.+\s+\(.+?\).*(ENGINE|TYPE)\s*=\s*([a-z]+?).*$/isU", "\\2", $sql));
	$type = in_array($type, array('MYISAM', 'HEAP')) ? $type : 'MYISAM';
	return preg_replace("/^\s*(CREATE TABLE\s+.+\s+\(.+?\)).*$/isU", "\\1", $sql).
		(mysql_get_server_info() > '4.1' ? " ENGINE=$type DEFAULT CHARSET=$dbcharset" : " TYPE=$type");
}

function file_write($filename,$content){
        if($file_name=fopen($filename,"w")){
               flock($file_name,LOCK_EX);
               $file_content=fwrite($file_name,$content);
               fclose($file_name);
               return 1 ;
         }else{
               return 0 ;
         }
}

function setconfig($string) {
	if(!get_magic_quotes_gpc()) {
		$string = str_replace('\'', '', $string);
	} else {
		$string = str_replace("\\'", '', $string);
	}
	return $string;
}
?>