DROP TABLE IF EXISTS nm_admins;
CREATE TABLE nm_admins (
  id int(8) NOT NULL auto_increment,
  user varchar(15) NOT NULL default '',
  pwd varchar(32) NOT NULL default '',
  priv tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id),
  UNIQUE KEY user (user)
) TYPE=MyISAM ;

DROP TABLE IF EXISTS nm_announces;
CREATE TABLE nm_announces (
  id smallint(6) unsigned NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  content text NOT NULL,
  displayorder smallint(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

INSERT INTO nm_announces VALUES ('1','NetMao ','ѰһɫӰվԭвƷ޷ӦĲվΪĲظͣͲǰNetMao ΪṩһոµĻѡ񣬷ǳлڶѡNetMaoףʹ죡','1');

DROP TABLE IF EXISTS nm_friendlinks;
CREATE TABLE nm_friendlinks (
  id smallint(6) unsigned NOT NULL auto_increment,
  displayorder tinyint(3) NOT NULL default '0',
  name varchar(100) NOT NULL default '',
  url varchar(100) NOT NULL default '',
  description mediumtext NOT NULL,
  logo varchar(100) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

INSERT INTO nm_friendlinks VALUES ('1','1','NetMao','http://www.netmao.com','','');

DROP TABLE IF EXISTS nm_players;
CREATE TABLE nm_players (
  playid smallint(6) unsigned NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  identifier varchar(40) NOT NULL default '',
  content varchar(255) NOT NULL default '',
  description varchar(255) NOT NULL default '',
  displayorder smallint(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (playid),
  UNIQUE KEY identifier (identifier)
) TYPE=MyISAM ;

INSERT INTO nm_players VALUES ('1','ݴģ','abs','player_abs','ϵͳݴ','1');
INSERT INTO nm_players VALUES ('2','๦ܲ','auto','player_auto','Բyouku,tudou,...Դ','2');
INSERT INTO nm_players VALUES ('3','Qvodרò','qvod','player_qvod','Qvodרòͬķöɵô˲','3');
INSERT INTO nm_players VALUES ('4','Boboרò','bobo','player_bobo','Boboרò֧boboиʽĵַ','4');

DROP TABLE IF EXISTS nm_servers;
CREATE TABLE nm_servers (
  servid smallint(6) unsigned NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  identifier varchar(40) NOT NULL default '',
  content text NOT NULL,
  description varchar(255) NOT NULL default '',
  displayorder smallint(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (servid),
  UNIQUE KEY identifier (identifier)
) TYPE=MyISAM ;

INSERT INTO nm_servers VALUES ('1','ݴ','abs','|abs','ϵͳݴ','1');
INSERT INTO nm_servers VALUES ('2','youku','youku','|auto','Դyouku','2');
INSERT INTO nm_servers VALUES ('3','tudou','tudou','|auto','Դtudou','3');
INSERT INTO nm_servers VALUES ('4','sina','iask','|auto','Դiask','4');
INSERT INTO nm_servers VALUES ('5','ouou','ouou','|auto','Դouou','5');
INSERT INTO nm_servers VALUES ('6','56','56','|auto','Դ56','6');
INSERT INTO nm_servers VALUES ('7','6rooms','6rooms','|auto','Դ6rooms','7');
INSERT INTO nm_servers VALUES ('8','tvix','tvix','|auto','Դtvix','8');
INSERT INTO nm_servers VALUES ('9','flv','flv','|auto','Դflv','9');
INSERT INTO nm_servers VALUES ('10','real','real','|auto','Դreal','10');
INSERT INTO nm_servers VALUES ('11','media','media','|auto','Դmedia','11');
INSERT INTO nm_servers VALUES ('12','qvod','qvod','|qvod','Դqvod','12');
INSERT INTO nm_servers VALUES ('13','bobo','bobo','|bobo','Դbobo','13');
INSERT INTO nm_servers VALUES ('14','xunlei','xunlei','|auto','Դxunlei','14');
INSERT INTO nm_servers VALUES ('15','xunlei2','xunlei2','|auto','Դxunlei2','15');


DROP TABLE IF EXISTS nm_plugins;
CREATE TABLE nm_plugins (
  pluginid smallint(6) unsigned NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  content varchar(255) NOT NULL default '',
  keyword varchar(255) NOT NULL default '',
  displayorder smallint(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (pluginid)
) TYPE=MyISAM ;

INSERT INTO nm_plugins VALUES ('1','ҳ','index','ҳ','1');
INSERT INTO nm_plugins VALUES ('2','ȫӰƬ','all','ȫӰƬ','2');
INSERT INTO nm_plugins VALUES ('3','վ','announce','վ','3');

DROP TABLE IF EXISTS nm_categorys;
CREATE TABLE nm_categorys (
  cid smallint(6) unsigned NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  identifier varchar(40) NOT NULL default '',
  content varchar(255) NOT NULL default '',
  keyword varchar(255) NOT NULL default '',
  displayorder smallint(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (cid)
) TYPE=MyISAM ;

INSERT INTO nm_categorys VALUES ('1','Ƭ','dzp','dongzuo','','1');
INSERT INTO nm_categorys VALUES ('2','ϲƬ','xjp','xiju','','2');
INSERT INTO nm_categorys VALUES ('3','Ƭ','aqp','aiqing','','3');
INSERT INTO nm_categorys VALUES ('4','ƻƬ','khp','kehuan','','4');
INSERT INTO nm_categorys VALUES ('5','ֲƬ','kbp','kongbu','','5');
INSERT INTO nm_categorys VALUES ('6','Ƭ','jqp','juqing','','6');
INSERT INTO nm_categorys VALUES ('7','Ƭ','dhp','donghua','','7');
INSERT INTO nm_categorys VALUES ('8','Ƭ','zyp','zongyi','','8');
INSERT INTO nm_categorys VALUES ('9','','gcj','guochan','','9');
INSERT INTO nm_categorys VALUES ('10','̨','gtj','gangtai','','10');
INSERT INTO nm_categorys VALUES ('11','ŷ','omj','omei','','11');
INSERT INTO nm_categorys VALUES ('12','պ','rhj','rihan','','12');

DROP TABLE IF EXISTS nm_movies;
CREATE TABLE nm_movies (
  mid mediumint(8) unsigned NOT NULL auto_increment,
  cat varchar(40) NOT NULL default '',
  name varchar(50) NOT NULL default '',
  language varchar(50) NOT NULL default '',
  area varchar(50) NOT NULL default '',
  actor varchar(255) NOT NULL default '',
  director varchar(255) NOT NULL default '',
  picture varchar(255) NOT NULL default '',
  keyword varchar(255) NOT NULL default '',
  description varchar(255) NOT NULL default '',
  adsense text NOT NULL,
  content text NOT NULL,
  author varchar(15) NOT NULL default '',
  addtime int(10) unsigned NOT NULL default '0',
  isrun smallint(6) NOT NULL default '0',
  isshow tinyint(1) NOT NULL default '0',
  isindex tinyint(1) NOT NULL default '0',
  ismlist tinyint(1) NOT NULL default '0',
  hits mediumint(8) NOT NULL default '0',
  PRIMARY KEY  (mid)
) TYPE=MyISAM ;

DROP TABLE IF EXISTS nm_files;
CREATE TABLE nm_files (
  fid int(10) unsigned NOT NULL auto_increment,
  mid mediumint(8) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  content varchar(255) NOT NULL default '',
  server varchar(50) NOT NULL default '',
  player varchar(50) NOT NULL default '',
  error smallint(6) NOT NULL default '0',
  PRIMARY KEY  (fid)
) TYPE=MyISAM ;

DROP TABLE IF EXISTS nm_settings;
CREATE TABLE nm_settings (
  variable varchar(32) NOT NULL default '',
  value text NOT NULL,
  PRIMARY KEY  (variable)
) TYPE=MyISAM ;

INSERT INTO nm_settings VALUES ('sitename','èӰ');
INSERT INTO nm_settings VALUES ('siteurl','http://www.netmao.com');
INSERT INTO nm_settings VALUES ('styleid','1');
INSERT INTO nm_settings VALUES ('uploadsize','102400');
INSERT INTO nm_settings VALUES ('uploadext','gif|jpg');
INSERT INTO nm_settings VALUES ('spiderfile','');
INSERT INTO nm_settings VALUES ('m_areas','½||̨||ձ|ŷ|');
INSERT INTO nm_settings VALUES ('m_languages','||||Ӣ|');
INSERT INTO nm_settings VALUES ('m_actors', 'ǳ|||»|||Ź|ΰ|Ź|||ƹǿ|С|һ|||쾲');
INSERT INTO nm_settings VALUES ('m_directors', 'ı||¿|С|ƽ');
INSERT INTO nm_settings VALUES ('m_nmcodes', '<nm:name></nm>\r\n<nm:actor></nm>\r\n<nm:director>δ֪</nm>\r\n<nm:picture>images/default/nopic.gif</nm>\r\n<nm:content>ޡ</nm>\r\n<nm:isshow>1</nm>\r\n<nm:isindex>0</nm>\r\n<nm:ismlist>0</nm>\r\n<nm:isrun>0</nm>\r\n<nm:hits>0</nm>\r\n<nm:pfile></nm>\r\n<nm:pextend>.rmvb</nm>\r\n<nm:pfocname>0</nm>\r\n<nm:pfrom>1</nm>\r\n<nm:pto>1</nm>\r\n<nm:reauthor>0</nm>\r\n<nm:readdtime>1</nm>');
INSERT INTO nm_settings VALUES('custombackup', '');

DROP TABLE IF EXISTS nm_templates;
CREATE TABLE nm_templates (
  templateid smallint(6) unsigned NOT NULL auto_increment,
  name varchar(30) NOT NULL default '',
  directory varchar(100) NOT NULL default '',
  copyright varchar(100) NOT NULL default '',
  PRIMARY KEY  (templateid)
) TYPE=MyISAM ;

INSERT INTO nm_templates VALUES ('1','Ĭģ','./templates/default','Powered by ');
INSERT INTO nm_templates VALUES ('2','js','./templates/js','Powered by Netmao');

DROP TABLE IF EXISTS nm_styles;
CREATE TABLE nm_styles (
  styleid smallint(6) unsigned NOT NULL auto_increment,
  name varchar(20) NOT NULL default '',
  templateid smallint(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (styleid),
  KEY themename (name)
) TYPE=MyISAM ;

INSERT INTO nm_styles VALUES ('1','ϵͳĬϷ','1');

DROP TABLE IF EXISTS nm_stylevars;
CREATE TABLE nm_stylevars (
  stylevarid smallint(6) unsigned NOT NULL auto_increment,
  styleid smallint(6) unsigned NOT NULL default '0',
  variable text NOT NULL,
  substitute text NOT NULL,
  PRIMARY KEY  (stylevarid),
  KEY styleid (styleid)
) TYPE=MyISAM ;

INSERT INTO nm_stylevars VALUES ('1','1','imglogo','logo.gif');
INSERT INTO nm_stylevars VALUES ('2','1','imgdir','images/default');

DROP TABLE IF EXISTS nm_caches;
CREATE TABLE nm_caches (
  cachename varchar(32) NOT NULL default '',
  type tinyint(3) unsigned NOT NULL default '0',
  dateline int(10) unsigned NOT NULL default '0',
  expiration int(10) unsigned NOT NULL default '0',
  data text NOT NULL,
  PRIMARY KEY  (cachename),
  KEY expiration (type,expiration)
) TYPE=MyISAM;

DROP TABLE IF EXISTS nm_codes;
CREATE TABLE nm_codes (
  urlid mediumint(8) NOT NULL auto_increment,
  url varchar(255) NOT NULL default '',
  code text NOT NULL,
  isok tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (urlid)
) TYPE=MyISAM ;