DROP TABLE IF EXISTS mm_ad;
CREATE TABLE mm_ad (
  aid mediumint(8) unsigned NOT NULL auto_increment,
  type enum('default','top','main','right','bottom','index_main','index_right','index_bottom','list_main','list_right','list_bottom','view_main','view_bottom') NOT NULL default 'default',
  subject varchar(80) NOT NULL,
  startdate int(10) unsigned NOT NULL default '0',
  endate int(10) unsigned NOT NULL default '0',
  postime int(10) unsigned NOT NULL default '0',
  ordermode tinyint(3) unsigned NOT NULL default '0',
  width varchar(80) NOT NULL,
  height varchar(80) NOT NULL,
  viewmode tinyint(1) unsigned NOT NULL default '0',
  viewcode mediumtext NOT NULL,
  adtext varchar(80) NOT NULL,
  adtexturl varchar(80) NOT NULL,
  adpic varchar(80) NOT NULL,
  adpicurl varchar(80) NOT NULL,
  target varchar(20) NOT NULL,
  adendmode tinyint(1) unsigned NOT NULL default '0',
  adendcode mediumtext NOT NULL,
  adendtext varchar(80) NOT NULL,
  adendtexturl varchar(80) NOT NULL,
  adendpic varchar(80) NOT NULL,
  adendpicurl varchar(80) NOT NULL,
  endtarget varchar(20) NOT NULL,
  PRIMARY KEY  (aid),
  KEY sartdate (startdate,endate,postime,ordermode),
  KEY type (type),
  KEY postime (postime),
  KEY ordermode (ordermode),
  KEY typeorder (type,ordermode)
) ENGINE=MyISAM AUTO_INCREMENT=5 ;

INSERT INTO mm_ad VALUES ('1','top','全站顶部广告','0','0','1208228652','0','0','0','0','<script type=\"text/javascript\"><!--\r\ngoogle_ad_client = \"pub-1863015706712727\";\r\n/* 468x60, 创建于 08-9-16 */\r\ngoogle_ad_slot = \"5260013135\";\r\ngoogle_ad_width = 468;\r\ngoogle_ad_height = 60;\r\n//-->\r\n</script>\r\n<script type=\"text/javascript\"\r\nsrc=\"http://pagead2.googlesyndication.com/pagead/show_ads.js\">\r\n</script>','','http://','','http://','_blank','0','','','http://','','http://','_blank');
INSERT INTO mm_ad VALUES ('2','main','全站中部广告','0','0','1208228659','0','','','0','<script type=\"text/javascript\"><!--\r\ngoogle_ad_client = \"pub-1863015706712727\";\r\n/* 728x90, 创建于 08-9-16 */\r\ngoogle_ad_slot = \"8012367545\";\r\ngoogle_ad_width = 728;\r\ngoogle_ad_height = 90;\r\n//-->\r\n</script>\r\n<script type=\"text/javascript\"\r\nsrc=\"http://pagead2.googlesyndication.com/pagead/show_ads.js\">\r\n</script>','','http://','','http://','_blank','0','','','http://','','http://','_blank');
INSERT INTO mm_ad VALUES ('3','right','图片页右边广告','0','0','1208228664','0','0','0','0','<iframe width=\"130\" height=\"310\" src=\"http://www.qling.com/code/130x310_2.html?aid=8187\" frameborder=\"0\" scrolling=\"no\"></iframe>','','http://','','http://','_blank','0','','','http://','','http://','_blank');
INSERT INTO mm_ad VALUES ('4','bottom','全站底部广告','0','0','1208228671','0','0','0','0','<script type=\"text/javascript\"><!--\r\ngoogle_ad_client = \"pub-1863015706712727\";\r\n/* 728x90, 创建于 08-9-16 */\r\ngoogle_ad_slot = \"8012367545\";\r\ngoogle_ad_width = 728;\r\ngoogle_ad_height = 90;\r\n//-->\r\n</script>\r\n<script type=\"text/javascript\"\r\nsrc=\"http://pagead2.googlesyndication.com/pagead/show_ads.js\">\r\n</script>','','http://','','http://','_blank','0','','','http://','','http://','_blank');

DROP TABLE IF EXISTS mm_admingroups;
CREATE TABLE mm_admingroups (
  adminid mediumint(8) unsigned NOT NULL auto_increment,
  grouptitle varchar(60) NOT NULL,
  allowedmode mediumtext NOT NULL,
  about varchar(80) NOT NULL,
  PRIMARY KEY  (adminid)
) ENGINE=MyISAM AUTO_INCREMENT=3 ;


INSERT INTO mm_admingroups (adminid, grouptitle, allowedmode, about) VALUES (1, '系统管理员', '', '系统超级管理员');
INSERT INTO mm_admingroups (adminid, grouptitle, allowedmode, about) VALUES (2, '录入员', '', '权限只能录入数据，不能参与系统设置');


DROP TABLE IF EXISTS mm_adrequest;
CREATE TABLE mm_adrequest (
  rid mediumint(8) unsigned NOT NULL auto_increment,
  type varchar(80) NOT NULL,
  aid mediumint(8) unsigned NOT NULL default '0',
  adurl varchar(80) NOT NULL,
  adpic varchar(80) NOT NULL,
  username varchar(16) NOT NULL default '',
  company varchar(80) NOT NULL default '',
  subject varchar(80) NOT NULL default '',
  address varchar(60) NOT NULL default '',
  postcode varchar(8) NOT NULL default '',
  postime int(10) unsigned NOT NULL default '0',
  replaytime int(10) unsigned NOT NULL default '0',
  postip varchar(15) NOT NULL default '',
  email varchar(80) NOT NULL default '',
  oicq varchar(80) NOT NULL default '',
  phone varchar(50) NOT NULL default '',
  mobile varchar(50) NOT NULL,
  connact varchar(50) NOT NULL default '',
  msg mediumtext NOT NULL,
  replay mediumtext NOT NULL,
  PRIMARY KEY  (rid),
  KEY postime (postime),
  KEY postip (postip),
  KEY replaytime (replaytime)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS mm_banned;
CREATE TABLE mm_banned (
  id smallint(6) unsigned NOT NULL auto_increment,
  ip1 smallint(3) NOT NULL default '0',
  ip2 smallint(3) NOT NULL default '0',
  ip3 smallint(3) NOT NULL default '0',
  ip4 smallint(3) NOT NULL default '0',
  admin varchar(15) NOT NULL,
  dateline int(10) unsigned NOT NULL default '0',
  expiration int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS mm_guestbook;
CREATE TABLE mm_guestbook (
  gid mediumint(8) unsigned NOT NULL auto_increment,
  username varchar(16) NOT NULL default '',
  company varchar(80) NOT NULL default '',
  subject varchar(80) NOT NULL default '',
  address varchar(60) NOT NULL default '',
  postcode varchar(8) NOT NULL default '',
  postime int(10) unsigned NOT NULL default '0',
  replaytime int(10) unsigned NOT NULL default '0',
  postip varchar(15) NOT NULL default '',
  email varchar(80) NOT NULL default '',
  oicq varchar(80) NOT NULL default '',
  phone varchar(50) NOT NULL default '',
  mobile varchar(15) NOT NULL,
  connact varchar(50) NOT NULL default '',
  msg mediumtext NOT NULL,
  replay mediumtext NOT NULL,
  PRIMARY KEY  (gid),
  KEY postime (postime),
  KEY postip (postip),
  KEY replaytime (replaytime)
) ENGINE=MyISAM ;


DROP TABLE IF EXISTS mm_import;
CREATE TABLE mm_import (
  fid mediumint(8) unsigned NOT NULL auto_increment,
  isim tinyint(1) unsigned NOT NULL default '0',
  pname varchar(80) NOT NULL,
  folder varchar(200) NOT NULL,
  images mediumtext NOT NULL,
  PRIMARY KEY  (fid)
) ENGINE=MyISAM;

-- 
-- 导出表中的数据 mm_import
-- 


-- --------------------------------------------------------

-- 
-- 表的结构 mm_links
-- 

DROP TABLE IF EXISTS mm_links;
CREATE TABLE mm_links (
  lid mediumint(8) unsigned NOT NULL auto_increment,
  type tinyint(1) unsigned NOT NULL default '0',
  linksite varchar(40) NOT NULL,
  linkurl varchar(80) NOT NULL,
  linknote varchar(80) NOT NULL,
  logo varchar(80) NOT NULL,
  ordermode tinyint(3) unsigned NOT NULL default '0',
  postime int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (lid),
  KEY type (type,ordermode,postime)
) ENGINE=MyISAM AUTO_INCREMENT=3 ;

INSERT INTO mm_links VALUES ('1','1','图片论坛','http://pic.71116.com/bbs','图片论坛','','0','1224772925');
INSERT INTO mm_links VALUES ('2','1','自动链接站','http://www.autochain.cn/','自动链接站','','0','1224772958');

DROP TABLE IF EXISTS mm_members;
CREATE TABLE mm_members (
  mid mediumint(8) unsigned NOT NULL auto_increment,
  username varchar(16) NOT NULL default '',
  password varchar(32) NOT NULL default '',
  adminid smallint(6) unsigned NOT NULL default '0',
  groupid smallint(6) unsigned NOT NULL default '0',
  gender tinyint(1) unsigned NOT NULL default '0',
  regtime int(10) unsigned NOT NULL default '0',
  email varchar(50) NOT NULL default '',
  pageviews int(10) unsigned NOT NULL default '0',
  invisible int(10) unsigned NOT NULL default '0',
  lastip varchar(15) NOT NULL default '',
  lastvisit int(10) unsigned NOT NULL default '0',
  lastactivity int(10) unsigned NOT NULL default '0',
  allowedmode mediumtext NOT NULL,
  authstr mediumtext NOT NULL,
  PRIMARY KEY  (mid),
  KEY regtime (regtime),
  KEY username (username,password),
  KEY groupid (groupid)
) ENGINE=MyISAM ;

DROP TABLE IF EXISTS mm_onlinetime;
CREATE TABLE mm_onlinetime (
  mid mediumint(8) unsigned NOT NULL default '0',
  thismonth smallint(6) unsigned NOT NULL default '0',
  total mediumint(8) unsigned NOT NULL default '0',
  lastupdate int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (mid)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS mm_pic;
CREATE TABLE mm_pic (
  pid mediumint(8) unsigned NOT NULL auto_increment,
  id mediumint(8) unsigned NOT NULL default '0',
  pname varchar(80) NOT NULL default '',
  face varchar(80) NOT NULL default '',
  ismake tinyint(1) unsigned NOT NULL default '0',
  views int(10) unsigned NOT NULL default '0',
  digest tinyint(1) NOT NULL default '0',
  postime int(10) unsigned NOT NULL default '0',
  attachment mediumtext NOT NULL,
  about mediumtext NOT NULL,
  ding  mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (pid),
  KEY postime (postime),
  KEY id (id),
  KEY views (views),
  KEY digest (digest,postime)
) ENGINE=MyISAM ;


-- 
-- 表的结构 mm_picsort
-- 

DROP TABLE IF EXISTS mm_picsort;
CREATE TABLE mm_picsort (
  id smallint(6) unsigned NOT NULL auto_increment,
  upid smallint(6) unsigned NOT NULL default '0',
  sortname char(80) NOT NULL,
  folders char(80) NOT NULL,
  folderdir char(100) NOT NULL,
  ordermode tinyint(3) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY upid (upid),
  KEY ordermode (ordermode)
) ENGINE=MyISAM ;



DROP TABLE IF EXISTS mm_sessions;
CREATE TABLE mm_sessions (
  sid char(6) character set gbk collate gbk_bin NOT NULL,
  ip1 tinyint(3) unsigned NOT NULL default '0',
  ip2 tinyint(3) unsigned NOT NULL default '0',
  ip3 tinyint(3) unsigned NOT NULL default '0',
  ip4 tinyint(3) unsigned NOT NULL default '0',
  mid mediumint(8) unsigned NOT NULL default '0',
  username char(15) NOT NULL default '',
  adminid smallint(6) unsigned NOT NULL default '0',
  groupid smallint(6) unsigned NOT NULL default '0',
  invisible tinyint(1) NOT NULL default '0',
  action tinyint(1) unsigned NOT NULL default '0',
  lastactivity int(10) unsigned NOT NULL default '0',
  lastolupdate int(10) unsigned NOT NULL default '0',
  pageviews smallint(6) unsigned NOT NULL default '0',
  seccode smallint(6) unsigned NOT NULL default '0',
  fid smallint(6) unsigned NOT NULL default '0',
  tid mediumint(8) unsigned NOT NULL default '0',
  UNIQUE KEY sid (sid),
  KEY uid (mid),
  KEY adminid (adminid)
) ENGINE=MEMORY ;


-- --------------------------------------------------------

-- 
-- 表的结构 mm_settings
-- 

DROP TABLE IF EXISTS mm_settings;
CREATE TABLE mm_settings (
  variable varchar(20) NOT NULL default '',
  value mediumtext NOT NULL,
  KEY variable (variable)
) ENGINE=MyISAM;


INSERT INTO mm_settings VALUES ('aboutsite','美图天下图片站提供美女图片，美男写真，非主流图片,明星图库,QQ图片等。');
INSERT INTO mm_settings VALUES ('dateformat','Y-n-j');
INSERT INTO mm_settings VALUES ('gzip','1');
INSERT INTO mm_settings VALUES ('loglines','3');
INSERT INTO mm_settings VALUES ('sitename','美图天下图片站');
INSERT INTO mm_settings VALUES ('siteurl','http://pic.71116.com');
INSERT INTO mm_settings VALUES ('timeformat','H:i');
INSERT INTO mm_settings VALUES ('timeoffset','8');
INSERT INTO mm_settings VALUES ('transsidstatus','1');
INSERT INTO mm_settings VALUES ('useseccode','1');
INSERT INTO mm_settings VALUES ('authkey','p53OO9NQnzSjj5E');
INSERT INTO mm_settings VALUES ('sppicw','120');
INSERT INTO mm_settings VALUES ('sppich','160');
INSERT INTO mm_settings VALUES ('ppich','200');
INSERT INTO mm_settings VALUES ('ppicw','390');
INSERT INTO mm_settings VALUES ('sshowpicw','220');
INSERT INTO mm_settings VALUES ('sshowpich','165');
INSERT INTO mm_settings VALUES ('showpicw','600');
INSERT INTO mm_settings VALUES ('showpich','480');
INSERT INTO mm_settings VALUES ('wartermark','day_20080818/20080818_d781fc21ee1268027657de3987sgCAjf.gif');
INSERT INTO mm_settings VALUES ('mark','off');
INSERT INTO mm_settings VALUES ('markview','100');
INSERT INTO mm_settings VALUES ('pagelistnum','18');


DROP TABLE IF EXISTS mm_uploads;
CREATE TABLE mm_uploads (
  uid mediumint(8) unsigned NOT NULL auto_increment,
  pid mediumint(8) unsigned NOT NULL default '0',
  mid mediumint(8) unsigned NOT NULL default '0',
  type char(20) NOT NULL default '',
  filename char(60) NOT NULL default '',
  filesize mediumint(8) unsigned NOT NULL default '0',
  filetype char(40) NOT NULL default '',
  face varchar(80) NOT NULL,
  refile char(80) NOT NULL,
  attachment char(80) NOT NULL default '',
  description char(250) NOT NULL default '',
  uptime int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (uid),
  KEY mid (mid,type,uptime),
  KEY pid (pid)
) ENGINE=MyISAM ;


DROP TABLE IF EXISTS mm_usergroups;
CREATE TABLE mm_usergroups (
  groupid smallint(6) unsigned NOT NULL auto_increment,
  type enum('system','member') NOT NULL default 'member',
  grouptitle varchar(60) NOT NULL default '',
  allowedvisit tinyint(1) unsigned NOT NULL default '0',
  upbizinfo tinyint(1) unsigned NOT NULL default '0',
  allowdownload tinyint(1) unsigned NOT NULL default '0',
  about varchar(80) NOT NULL default '',
  PRIMARY KEY  (groupid)
) ENGINE=MyISAM AUTO_INCREMENT=7 ;



INSERT INTO mm_usergroups (groupid, type, grouptitle, allowedvisit, upbizinfo, allowdownload, about) VALUES (1, 'system', '管理员', 1, 0, 0, '管理员');
INSERT INTO mm_usergroups (groupid, type, grouptitle, allowedvisit, upbizinfo, allowdownload, about) VALUES (2, 'system', '录入员', 1, 1, 1, '数据录入员');
INSERT INTO mm_usergroups (groupid, type, grouptitle, allowedvisit, upbizinfo, allowdownload, about) VALUES (3, 'system', '注册用户', 1, 1, 1, '注册用户');
INSERT INTO mm_usergroups (groupid, type, grouptitle, allowedvisit, upbizinfo, allowdownload, about) VALUES (4, 'system', '禁止访问', 0, 0, 0, '禁止浏览任何页面');
INSERT INTO mm_usergroups (groupid, type, grouptitle, allowedvisit, upbizinfo, allowdownload, about) VALUES (5, 'system', '游客', 0, 0, 0, '游客');
INSERT INTO mm_usergroups (groupid, type, grouptitle, allowedvisit, upbizinfo, allowdownload, about) VALUES (6, 'system', '等待验证用户', 0, 0, 0, '等待验证用户');

DROP TABLE IF EXISTS mm_caiji;
CREATE TABLE mm_caiji (
  id mediumint(8) NOT NULL auto_increment,
  name varchar(20) NOT NULL default '',
  time date NOT NULL default '0000-00-00',
  url varchar(100) NOT NULL default '',
  urlq text NOT NULL,
  urlq2 text NOT NULL,
  title varchar(100) NOT NULL default '',
  title2 varchar(100) NOT NULL default '',
  key1 varchar(100) NOT NULL default '',
  key2 varchar(100) NOT NULL default '',
  dis varchar(100) NOT NULL default '',
  dis2 varchar(100) NOT NULL default '',
  z11 varchar(250) NOT NULL default '',
  z12 varchar(250) NOT NULL default '',
  z21 varchar(250) NOT NULL default '',
  z22 varchar(250) NOT NULL default '',
  z31 varchar(250) NOT NULL default '',
  z32 varchar(250) NOT NULL default '',
  class varchar(20) NOT NULL default '',
  message varchar(100) NOT NULL default '',
  message2 varchar(100) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=6;

INSERT INTO mm_caiji VALUES ('1','美女贴图','2008-10-22','http://www.mntt.com/Archiver.asp?ForumID=8','<ul class=\'ThreadList\'><ol start=\'1\'>','</ol></ul></div>','<title>','_亚洲美女_美女贴图','<title>','_亚洲美女_美女贴图','<title>','_亚洲美女_美女贴图','?ThreadID,UpFile/','http://www.mntt.com/Archiver.asp?ThreadID,http://www.mntt.com/UpFile/','','','','','13','<div class=PostBody>','</div>');
INSERT INTO mm_caiji VALUES ('2','明星图片','2008-09-17','http://ent.163.com/special/00032G5M/starlist0425.html','<div class=\"mainContent\">','<div class=\"pageNum\">','<title>','_网易娱乐</title>','<title>','_网易娱乐</title>','<title>','_网易娱乐</title>','','','','','','','2','<div id=\"endText\">','本文来源：');
INSERT INTO mm_caiji VALUES ('3','美女选美','2008-09-17','http://sexy.163.com/special/00032G5M/misslist0425.html','<div class=\"mainContent\">','<div class=\"pageNum\">','<title>','_网易娱乐</title>','<title>','_网易娱乐</title>','<title>','_网易娱乐</title>','','','','','','','6','<div id=\"endText\">','本文来源：');
INSERT INTO mm_caiji VALUES ('4','MM自拍','2008-10-21','http://photo.poco.cn/vision.htx&p=1&order=lately_date&tid=-1&gid=9&lid=-1','<div class=\"list_box_container\">','<td align=\"left\" class=\"back\" width=\"430\">','<title>','</title>','<title>','</title>','<title>','</title>','/lastphoto-,.jpg\',[\'bimg\'] = \',http://my.poco.cn/','http://photo.poco.cn/lastphoto-,.jpg\'>,<img  src=\',','','','','','7','photoImgArr = ','getImgTableString');
INSERT INTO mm_caiji VALUES ('5','名车世界','2008-10-23','http://www.iecool.com/photo/2/1543_0.htm','<table width=\"98%\"  border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\">','</table>','<title>','图片素材','<title>','图片素材','<title>','图片素材','<a href=\"../,<input onClick=\"PicSMS(\',\')\"','<a href=\"http://www.iecool.com/photo/,<img src=\",\"','<img src=../../uppic/*>','','','','26','<table width=96%  border=0 align=center cellpadding=0 cellspacing=0>','<table width=100%  border=0 cellpadding=0 cellspacing=0 bgcolor=#FFFFFF>');


DROP TABLE IF EXISTS mm_geturl;
CREATE TABLE mm_geturl (
  id mediumint(8) NOT NULL auto_increment,
  cid smallint(3) NOT NULL default '0',
  `time` date NOT NULL default '0000-00-00',
  url varchar(100) NOT NULL default '',
  sid smallint(3) NOT NULL default '0',
  cok smallint(3) NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS mm_ping;
CREATE TABLE mm_ping (
  id mediumint(8) NOT NULL auto_increment,
  pid smallint(3) NOT NULL default '0',
  uid smallint(3) NOT NULL default '0',
  uname varchar(20) NOT NULL default '',
  uip varchar(20) NOT NULL default '',
  uding smallint(3) NOT NULL default '0',
  face varchar(100) NOT NULL default '',
  pingl mediumtext NOT NULL,
  `time` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (id)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS mm_tags;
CREATE TABLE mm_tags (
  id mediumint(8) NOT NULL auto_increment,
  keyword varchar(100) NOT NULL default '',
  tags varchar(100) NOT NULL default '',
  count smallint(3) NOT NULL default '0',
  weekct smallint(3) NOT NULL default '0',
  weekup date NOT NULL default '0000-00-00',
  monthct smallint(3) NOT NULL default '0',
  monthup date NOT NULL default '0000-00-00',
  result smallint(3) NOT NULL default '0',
  sotime date NOT NULL default '0000-00-00',
  PRIMARY KEY  (id)
) TYPE=MyISAM;