/**
 *  Form Module handles form events
 *  Based on jQuery
 */
var wumii;
if (!wumii) {
	wumii = {};
} else if (typeof wumii != "object") {
	throw new Error("wumii already exists and is not an object");
}

if (!wumii.Form) {
	wumii.Form = function(id, imageDir, useUrl) {
		var that = this;
		var DEFAULT_IMAGE_PATH = "http://www.wumii.com/resources/images/" + (imageDir || ""),
			FORM_ITEM_SELECTOR = "div.form-item";

		var $form = $("#" + id),
			$formItems = $form.find(FORM_ITEM_SELECTOR);

		var isPlaceholderSupported = "placeholder" in document.createElement("input");

		var $formResult = $("<div></div>").attr("id", "formResult").addClass("form-result");
		$form.find(".form").append($formResult);

		function registerUploadItem(uploadItems) {
			$.each(uploadItems, function(i, uploadItem) {
				var $formItem = $(uploadItem);
				$formItem.find("a[action-type=default]").click(function() {
					var imageName = "default_" + $(this).attr("action-data") + ".png",
						imageSrc = DEFAULT_IMAGE_PATH + imageName;

					if (useUrl) {
						imageName = imageSrc;
					}

					$formItem.find("div.img-clip").html("<img src='" + imageSrc + "'/>");
					$formItem.find("input").val(imageName);
				});
			});
		}

		function validateNotEmptyInput() {
			var hasEmptyInput = false;
			$formItems.find(":input[not-empty]").each(function() {
				var $input = $(this);
				if ($input.val() == "") {
					$(this).parent().addClass("form-error-item");

					if (!hasEmptyInput) {
						$input.focus();
					}
					hasEmptyInput = true;
				}
			});

			return hasEmptyInput;
		}

		function registerSubmit() {
			$form.submit(function() {
				if (validateNotEmptyInput()) {
					return false;
				}

				var ajaxOptions = that.ajaxOptions;
				if (ajaxOptions) {
					var ajaxCallback = ajaxOptions.callback;
					var params = getFormObjects(),
						$submit = $(this).find(".btn");

					if ($submit.length == 0) {
						$submit = $(this).find("input[type=submit]");
					}
					
					$.ajax({
						"url": $form.attr("action"),
						"type": "POST",
						"data": params,
						"beforeSend": function() {
							if (ajaxOptions.onRequest) {
								return false;
							}
							ajaxOptions.onRequest = true;

							showFormResult();
							if (ajaxCallback && ajaxCallback.beforeSend) {
								ajaxCallback.beforeSend($submit);
							}
						},
						"complete": function() {
							ajaxOptions.onRequest = false;

							if (ajaxCallback && ajaxCallback.complete) {
								ajaxCallback.complete($submit);
							}
						},
						"success": function(data) {
							if (ajaxCallback && ajaxCallback.success) {
								ajaxCallback.success(data, $submit);
							}
						},
						"error": function(err) {
							if (ajaxCallback && ajaxCallback.error) {
								ajaxCallback.error($submit);
							}
						}
					});
					return false;
				}
			});
		}

		function showFormResult(text, type) {
			if (text) {
				$formResult.html(text).show();
				if (type == "error") {
					$formResult.addClass("form-errors").removeClass("form-success");
				} else {
					$formResult.addClass("form-success").removeClass("form-errors");
				}
			} else {
				$formResult.hide();
			}
		}

		function getOrGenerateId($input) {
			var id = $input.attr('id');
			if (!id) {
				id = $input.attr('name') + '_' + new Date().getTime();
				$input.attr('id', id);
			}
			return id;
		}

		function updatePlaceholder($input, inputLabel) {
			var label = inputLabel || $input.attr("label");
			if (!label) {
				return;
			}
			$input.removeAttr("label");

			if (isPlaceholderSupported) {
				$input.attr("placeholder", label);
			} else {
				var inputId = getOrGenerateId($input);
				var $formItem = $input.parents(FORM_ITEM_SELECTOR);
				if (inputLabel) {
					$input.val("");
					$formItem.find("label[for=" + inputId + "]").text(inputLabel);
				} else {
					var $label = $("<label class='placeholder' for='" + inputId + "'></label>").text(label);
					$formItem.prepend($label);

					if ($input.val() != "") {
						$label.hide();
					}

					$input.focus(function() {
						$(this).parents(FORM_ITEM_SELECTOR).find("label").hide();
					}).blur(function() {
						if ($(this).val() == "") {
							$(this).parents(FORM_ITEM_SELECTOR).find("label").show();
						}
					});
				}
			}
		}

		function getFormObjects() {
			var object = {};
			$form.find(":input[name]").each(function() {
				var $input = $(this),
					k = $input.attr("name"),
					v = $input.attr("value");
				if (v != "") {
					object[k] = v;
				}
			});

			return object;
		}

		that.onAjaxMethod = false;
		that.elem = $form;
		that.register = function() {
			var arr_uploadItems = [];

			$formItems.each(function() {
				var type = $(this).attr("input-type");
				if (type == "upload") {
					arr_uploadItems.push($(this));
				}

				updatePlaceholder($(this).find(":input"));
			});

			registerUploadItem(arr_uploadItems);
			registerSubmit();
		};

		that.updatePlaceholder = updatePlaceholder;

		that.ajaxOptions = null;
		that.setAjaxPost = function(callback) {
			var ajaxOptions = {},
				ajaxCallback = {};
			ajaxOptions.onRequest = false;

			if (callback instanceof Function) {
				ajaxCallback.success = callback;
			} else {
				ajaxCallback = callback;
			}

			ajaxOptions.callback = ajaxCallback;
			that.ajaxOptions = ajaxOptions;
		};

		that.showFormResult = showFormResult;
	};

	window.Form = wumii.Form;
}