<?php
error_reporting(E_ERROR | E_WARNING | E_PARSE);

//Timer start
$mtime=explode(' ',microtime());
$dp_starttime=$mtime[1]+$mtime[0];

define('PATH_PRE',str_replace('\\','/',dirname(__FILE__)).'/');

if (PHP_VERSION<'4.1.0') {
	$_GET=&$HTTP_GET_VARS;
	$_POST=&$HTTP_POST_VARS;
	$_COOKIE=&$HTTP_COOKIE_VARS;
	$_SERVER=&$HTTP_SERVER_VARS;
	$_ENV=&$HTTP_ENV_VARS;
	$_FILES=&$HTTP_POST_FILES;
}

if (!@include PATH_PRE.'dpmain/version.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to read version information.<br />File: ./dpmain/version.php');

if (!@include PATH_PRE.'dpmain/kernel/func.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate kernel functions.<br />File: ./dpmain/kernel/func.php');
if (!@include PATH_PRE.'dpmain/kernel/db.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate database functions.<br />File: ./dpmain/kernel/db.php');
if (!@include PATH_PRE.'dpmain/kernel/secure_getpost.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate security module.<br />File: ./dpmain/kernel/secure_getpost.php');
if (!@include PATH_PRE.'dpmain/kernel/pagecache.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate cache functions.<br />File: ./dpmain/kernel/pagecache.php');

if (!@include PATH_PRE.'dpdata/basicset.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to fetch basic settings.<br />File: ./dpdata/basicset.php');

//Initiate language characters : errors
if (!@include PATH_PRE.'dpmain/lang/'.$d_basicset['langpak'].'/error.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate language characters of error messages.<br />File: ./dpmain/lang/'.$d_basicset['langpak'].'/error.php');

//Fetch data
$d_mainset=dpfetchdata('mainset');
if (trim($d_mainset)=='') dperror($l_error['cant_fetchdata'],'mainset',true);
$sessionarray=dpfetchdata('adminsession');
if (trim($sessionarray)=='') dperror($l_error['cant_fetchdata'],'adminsession',true);

//Initiate language: charset
$incfile=PATH_PRE.'dpmain/lang/'.$d_basicset['langpak'].'/index.php';
if (!@include $incfile) dperror($l_error['adminlang'],$incfile,true);
$charset=$intro_lang['charset'];
if ($d_basicset['headercharset']) @header('Content-Type: text/html; charset='.$charset);

//Initiate language characters : fore
$incfile=PATH_PRE.'dpmain/lang/'.$d_basicset['langpak'].'/fore.php';
if (!@include $incfile) dperror($l_error['adminlang'],$incfile,true);

//Set time zone
$timeoffset=intval($d_mainset['timezone']);
if (PHP_VERSION>'5.1') @date_default_timezone_set('Etc/GMT'.($timeoffset > 0 ? '-' : '+').(abs($timeoffset)));

if ($_GET['genhtml']) {
	if (!is_writable(PATH_PRE.$d_basicset['indexfn']) or !is_writable(PATH_PRE.$d_basicset['htmldir'])) exit();
	if ($_GET['foregen']) {
		if (!$d_basicset['autogenhtml']) exit();
		if ($d_basicset['autogenhtml_time']) {
			$hours=explode(',',$d_basicset['autogenhtml_time']);
			if (!in_array(date('G'),$hours)) exit();
		}
	}

	$foresession=dpfetchdata('foresession');
	if (trim($foresession)=='') dperror($l_error['cant_fetchdata'],'foresession',true);

	$shead='<html><head><meta http-equiv="Content-Type" content="text/html; charset='.$charset.'" /></head><body style="font-family: Tahoma, Arial, Verdana, sans-serif;font-size: 14px;color: #38548D;margin: 0;">';
	$sfoot='</body></html>';
	if ($_GET['foregen'] or $_GET['onlyuri']) {
		if (!(is_array($foresession['to_gen_arr']) and count($foresession['to_gen_arr'])>0)) {
			clear_expired_html(PATH_PRE.$d_basicset['htmldir'],$foresession['gen_start']);
			$foresession['gen_start']=mktime();
			$foresession['to_gen_arr']=array('');
		}
	}
	if (is_array($foresession['to_gen_arr']) and count($foresession['to_gen_arr'])>0) {
		$_SERVER['QUERY_STRING']=$foresession['to_gen_arr'][0];
	}else{
		$delcount=0;
		$delsize=0;
		clear_expired_html(PATH_PRE.$d_basicset['htmldir'],$foresession['gen_start']);
		echo $shead.sprintf($l_fore['gen_html_finished'],$delcount,simple_size($delsize)).$sfoot;
		exit();
	}
}

//==========================> Exit Here <==========================

if ($_GET['onlyuri']) $_SERVER['QUERY_STRING']=$_GET['onlyuri'];
if (trim($_SERVER['QUERY_STRING'])!='') {
	$_SERVER['QUERY_STRING']=str_replace('.html','',$_SERVER['QUERY_STRING']);
	if (substr($_SERVER['QUERY_STRING'],0,9)=='pagetype-') {
		if (strstr($_SERVER['QUERY_STRING'],'-and-')) $_SERVER['QUERY_STRING']=str_replace('-and-','-a-',$_SERVER['QUERY_STRING']);
		$parts=explode('-a-',$_SERVER['QUERY_STRING']);
		foreach ($parts as $thispart) {
			$temp=explode('-',$thispart);
			$_GET[$temp[0]]=$temp[1];
		}
	}elseif (substr($_SERVER['QUERY_STRING'],0,3)=='dp-') {
		$_SERVER['QUERY_STRING']=str_replace('dp-','',$_SERVER['QUERY_STRING']);
		$parts=explode('-',$_SERVER['QUERY_STRING']);
		$_GET['pagetype']=$parts[0];
		@include PATH_PRE.'dpmain/pagetype/'.$_GET['pagetype'].'_url.php';
		for ($i=0;$i<count($urlvars);$i++) {
			$_GET[$urlvars[$i]]=$parts[$i+1];
		}
	}
}
if (!$_GET['pagetype']) $_GET['pagetype']='homepage';

//Connect Database
if (db_connect(ur1decode($d_basicset['dbhost']),ur1decode($d_basicset['dbuser']),ur1decode($d_basicset['dbpassword']),$d_basicset['dbcharset'])==false) dperror($l_error['dbconnect'],db_errno().' '.db_error(),true);
if (db_selectdb(ur1decode($d_basicset['dbname']))==false) dperror($l_error['dbselect'],db_errno().' '.db_error(),true);

//Prepare template variables and functions
if (b64($d_mainset['sitename'])=='')
$d_mainset['sitename']=b64($l_fore['default_sitename'],true);
if (b64($d_mainset['maintitle'])=='') $d_mainset['maintitle']=b64($l_fore['default_maintitle'],true);
if (b64($d_mainset['titleextra'])=='') $d_mainset['titleextra']=b64($l_fore['default_titleextra'],true);
if (b64($d_mainset['keywords'])=='') $d_mainset['keywords']=b64($l_fore['default_keywords'],true);
if (b64($d_mainset['description'])=='') $d_mainset['description']=b64($l_fore['default_description'],true);

$baseurl='http://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
$titlemain='';
@include PATH_PRE.'dpmain/pagetype/'.$_GET['pagetype'].'_title.php';
$maintitle=b64($d_mainset['maintitle']);
$titleextra=trim(b64($d_mainset['titleextra']))!='' ? ' - '.b64($d_mainset['titleextra']) : '';
$pagetitle=$titlemain.b64($d_mainset['maintitle']).(trim(b64($d_mainset['titleextra']))!='' ? ' - '.b64($d_mainset['titleextra']) : '');
$sitename=b64($d_mainset['sitename']);
$keywords=trim($titlemain)!='' ? str_replace(' - ','' ,$titlemain) : b64($d_mainset['keywords']);
$description=trim($titlemain)!='' ? str_replace(' - ','. ',$pagetitle) : b64($d_mainset['description']);
$generator='DiY-Page '.DP_VERSION.' RLC '.DP_RELEASE;
$copyrightcode=dplicenser();
$spidercode='<img border="0" width="1" height="1" src="dpspider.php" /> <script type="text/JavaScript" src="dpindex.php?genhtml=1&foregen=1"></script>';

$incfile=PATH_PRE.'dpmain/kernel/tpl.php';
if (!@include $incfile) dperror($l_error['cant_include'],$incfile,true);

//Page Body
$pagebody='';
@include PATH_PRE.'dpmain/pagetype/'.$_GET['pagetype'].'_tpl.php';
$newpt=$d_mainset['tpl_setting'][$_GET['pagetype']][$_GET[$pagetype_idvar]];
if (trim($newpt)!='') $_GET['pagetype']=$newpt;
$tplfile=PATH_PRE.'dpstyle/'.$d_mainset['curstyle'].'/'.$_GET['pagetype'].'.tpl.php';
if (file_exists($tplfile)) {
	@ob_start();
	$incfile=dp_tpl($tplfile);
	if (!@include $incfile) dperror($l_error['cant_include'],$incfile,true);
	$pagebody.=@ob_get_contents();
	@ob_end_clean();
}

//Generate Page
$totaloutput=$pagebody;
$totaloutput=preg_replace('/ dpid=".*?"/is','',$totaloutput);
$totaloutput=preg_replace('/\<\!--(begin|end)\:obj(\:[0-9]{1,}){0,1}--\>/','',$totaloutput);
$totaloutput=str_replace(array("\t","\r"),'',$totaloutput);

if (!$_GET['genhtml']) {
	if ($_GET['pagetype']!='homepage' and $d_basicset['cachevalidtime']>0) @cache_clear_expired(PATH_PRE.'dpcache',($d_basicset['cachevalidtime'])*10);

	if ($d_basicset['gzip']) @ob_start("ob_gzhandler");
	echo $totaloutput;

	$mtime=explode(' ',microtime());
	$dp_runtime=number_format(($mtime[1]+$mtime[0]-$dp_starttime),6);
	echo '<!--Processed in '.$dp_runtime.' second(s), '.intval($_SERVER['db_qnum']).' database queries-->';
}else{
	if ($_GET['foregen']) @ob_start();
	echo $shead;
	if ($_SERVER['QUERY_STRING']=='' or $_SERVER['QUERY_STRING']=='homepage') {
		$htmlfile=PATH_PRE.$d_basicset['indexfn'];
	}else{
		$tmpa=explode('-',$_SERVER['QUERY_STRING']);
		$pagetype=$tmpa[0];
		array_shift($tmpa);
		$vars=implode('-',$tmpa);
		$htmlfile=PATH_PRE.gethtmfn($d_basicset['htmldir'],$pagetype,$vars);
	}
	if (@filemtime($htmlfile)<$foresession['gen_start'] or $_GET['onlyuri']) {
		if (!$_GET['onlyuri']) {
			$pattern='/[\?]{0,1}dp-([a-z0-9\-]{1,})\.html/i';
			preg_match_all($pattern,$totaloutput,$matches);
			foreach ($matches[0] as $cur) {
				$cur=str_replace('?','',$cur);
				if (!in_array($cur,$foresession['to_gen_arr'])) $foresession['to_gen_arr'][]=$cur;
			}
		}

		$pattern='/[\?]{0,1}dp-([a-z0-9]{1,})-([a-z0-9\-]{1,})\.html/ie';
		$tostr='gethtmfn("'.$d_basicset['htmldir'].'","\\1","\\2");';
		$totaloutput=preg_replace($pattern,$tostr,$totaloutput);

		$mtime=explode(' ',microtime());
		$dp_runtime=number_format(($mtime[1]+$mtime[0]-$dp_starttime),6);
		$totaloutput.='<!--Generated at '.date('Y-n-j H:i:s').', Processed in '.$dp_runtime.' second(s), '.intval($_SERVER['db_qnum']).' database queries-->';

		file_write($htmlfile,$totaloutput);
		echo sprintf($l_fore['gen_html_file_generated'],$htmlfile);
	}
	if (!$_GET['onlyuri']) {
		array_shift($foresession['to_gen_arr']);
		echo sprintf($l_fore['gen_html_file_remaining'],count($foresession['to_gen_arr']));
		if (!dpwritedata('foresession',$foresession)) dperror($l_error['cant_writedata'],'foresession',true);
		echo '<script type="text/JavaScript">setTimeout("window.location=\'dpindex.php?genhtml=1&ptime='.intval($_GET['ptime']).'\';",'.intval($_GET['ptime']).');</script>';
	}else{
		echo sprintf($l_fore['gen_html_finished'],0,simple_size(0));
	}
	echo $sfoot;
	if ($_GET['foregen']) @ob_end_clean();
}

function gethtmfn($htmldir,$pagetype,$vars) {
	global $d_basicset,$d_mainset;
	$childdir='';
	@include PATH_PRE.'dpmain/pagetype/'.$pagetype.'_html.php';
	$pagetypeurl=str_replace($d_basicset['urlptnames_from'],$d_basicset['urlptnames_to'],$pagetype);
	$ext= trim($d_basicset['html_file_ext'])!='' ? $d_basicset['html_file_ext'] : 'htm';
	if ($childdir) {
		@mkdir(PATH_PRE.$htmldir.'/'.$childdir);
		return $htmldir.'/'.$childdir.'/'.$pagetypeurl.'-'.$vars.'.'.$ext;
	}else{
		return $htmldir.'/'.$pagetypeurl.'-'.$vars.'.'.$ext;
	}
}

function clear_expired_html($curdir,$expire) {
	global $delcount,$delsize;
	$dir=opendir($curdir);
	while (false!==($curfile=readdir($dir))) {
		if ($curfile!='.' and $curfile!='..') {
			$thisfile=$curdir.'/'.$curfile;
			if (is_dir($thisfile)) {
				clear_expired_html($thisfile,$expire);
			}else{
				if (@filemtime($thisfile)<$expire) {
					$tmpsize=filesize($thisfile);
					if (@unlink($thisfile)) {
						$delcount++;
						$delsize+=$tmpsize;
					}
				}
			}
		}
	}
}
?>