<?php
error_reporting(E_ERROR | E_WARNING | E_PARSE);

define('PATH_PRE',str_replace('\\','/',dirname(__FILE__)).'/');

if (PHP_VERSION<'4.1.0') {
	$_GET=&$HTTP_GET_VARS;
	$_POST=&$HTTP_POST_VARS;
	$_COOKIE=&$HTTP_COOKIE_VARS;
	$_SERVER=&$HTTP_SERVER_VARS;
	$_ENV=&$HTTP_ENV_VARS;
	$_FILES=&$HTTP_POST_FILES;
}

if (!@include PATH_PRE.'dpmain/version.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to read version information.<br />File: ./dpmain/version.php');
if (!@include PATH_PRE.'dpmain/kernel/func.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate kernel functions.<br />File: ./dpmain/kernel/func.php');
if (!@include PATH_PRE.'dpmain/kernel/db.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate database functions.<br />File: ./dpmain/kernel/db.php');
if (!@include PATH_PRE.'dpmain/kernel/secure_getpost.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate security module.<br />File: ./dpmain/kernel/secure_getpost.php');

if (!@include PATH_PRE.'dpdata/basicset.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to fetch basic settings.<br />File: ./dpdata/basicset.php');

if (!@include PATH_PRE.'dpmain/lang/'.$d_basicset['langpak'].'/error.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate language characters of error messages.<br />File: ./dpmain/lang/'.$d_basicset['langpak'].'/error.php');

//Initiate language: charset
$incfile=PATH_PRE.'dpmain/lang/'.$d_basicset['langpak'].'/index.php';
if (!@include $incfile) dperror($l_error['adminlang'],$incfile,true);
$charset=$intro_lang['charset'];
if ($d_basicset['headercharset']) @header('Content-Type: text/html; charset='.$charset);

if (!@include PATH_PRE.'dpmain/kernel/pagecache.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate cache functions.<br />File: ./dpmain/kernel/pagecache.php');
$cachedir=PATH_PRE.'dpcache';
$cacheid=$_SERVER['QUERY_STRING'];
if (cache_isvalid($cacheid,$d_basicset['cachevalidtime'])) {
	$totaloutput=cache_fetch($cacheid);
	if ($d_basicset['gzip']) @ob_start("ob_gzhandler");
	echo $totaloutput;
	exit();
}

$sessionarray=dpfetchdata('adminsession');
if (trim($sessionarray)=='') dperror($l_error['cant_fetchdata'],'adminsession',true);

$d_mainset=dpfetchdata('mainset');
if (trim($d_mainset)=='') dperror($l_error['cant_fetchdata'],'mainset',true);

$timeoffset=intval($d_mainset['timezone']);
if (PHP_VERSION>'5.1') @date_default_timezone_set('Etc/GMT'.($timeoffset > 0 ? '-' : '+').(abs($timeoffset)));

if (db_connect(ur1decode($d_basicset['dbhost']),ur1decode($d_basicset['dbuser']),ur1decode($d_basicset['dbpassword']),$d_basicset['dbcharset'])==false) dperror($l_error['dbconnect'],db_errno().' '.db_error(),true);
if (db_selectdb(ur1decode($d_basicset['dbname']))==false) dperror($l_error['dbselect'],db_errno().' '.db_error(),true);

@ob_start();

$incfile=PATH_PRE.'dpmain/module/'.$_GET['mod'].'/js/'.$_GET['name'].'.php';
if (!@include $incfile) dperror($l_error['cant_include'],$incfile,true);

$totaloutput=@ob_get_contents();
@ob_end_clean();
if ($totaloutput) {
	if ($d_basicset['cachevalidtime']>0) {
		if (!cache_write($cacheid,$totaloutput)) dperror($l_error['cant_writedata'],$cacheid,true);
	}
	if ($d_basicset['gzip']) @ob_start("ob_gzhandler");
	echo $totaloutput;
}
?>