<?php
function cache_isvalid($cacheid,$expire=300,$realpath=false) {
	if (!$realpath) {
		$cacheid=md5($cacheid);
		$dirname='cache_'.substr($cacheid,0,2);
		$realdir=PATH_PRE.'dpcache/'.$dirname;
		$cacheid=$realdir.'/'.$cacheid.'.htm';
	}
	@clearstatcache();
	if (!@file_exists($cacheid)) return false;
	if (!($mtime=@filemtime($cacheid))) return false;
	$nowtime=mktime();
	if (($mtime+$expire)<$nowtime) {
		return false;
	}else{
		return true;
	}
}

function cache_exists($cacheid) {
	$cacheid=md5($cacheid);
	$dirname='cache_'.substr($cacheid,0,2);
	$realdir=PATH_PRE.'dpcache/'.$dirname;
	$cacheid=$realdir.'/'.$cacheid.'.htm';
	return file_exists($cacheid);
}

function cache_fetch($cacheid) {
	$cacheid=md5($cacheid);
	$dirname='cache_'.substr($cacheid,0,2);
	$realdir=PATH_PRE.'dpcache/'.$dirname;
	$cacheid=$realdir.'/'.$cacheid.'.htm';
	return file_fetch($cacheid);
}

function cache_write($cacheid,$cachecontent) {
	$cacheid=md5($cacheid);
	$dirname='cache_'.substr($cacheid,0,2);
	$realdir=PATH_PRE.'dpcache/'.$dirname;
	if (!is_dir($realdir)) @mkdir($realdir,0777);
	if (!is_writable($realdir)) return false;
	$cacheid=$realdir.'/'.$cacheid.'.htm';
	return file_write($cacheid,$cachecontent);
}

function cache_clear_expired($cachedirname,$expire=300) {
	$delcount=0;
	$delsize=0;
	$filecount=0;
	$cachedir=@opendir($cachedirname);
	while (false!==($cachefile=@readdir($cachedir))) {
		if ($cachefile!='.' and $cachefile!='..' and substr($cachefile,0,6)=='cache_') {
			$thisdir=$cachedirname.'/'.$cachefile;
			$cache2dir=@opendir($thisdir);
			while (false!==($cache2file=@readdir($cache2dir))) {
				if ($cache2file!='.' and $cache2file!='..') {
					$filecount++;
					if (!defined('INADM')) {
						if ($filecount>100) return '';
					}else{
						if ($filecount>10000) return array('delcount'=>$delcount,'delsize'=>$delsize);
					}
					$cache2_id=$thisdir.'/'.$cache2file;
					$cachesize=@filesize($cache2_id);
					if (!cache_isvalid($cache2_id,$expire,true)) {
						if (@unlink($cache2_id)) {
							$delcount++;
							$delsize+=$cachesize;
						}
					}
				}
			}
			@closedir($cache2dir);
			@rmdir($thisdir);
		}
	}
	@closedir($cachedir);
	return array('delcount'=>$delcount,'delsize'=>$delsize);
}

?>