<?php
function dp_tpl($tplfile) {
	global $sessionarray;

	$objfile=PATH_PRE.'dpcache/'.md5($tplfile).'.tpl.php';
	if (filemtime($tplfile)!=$sessionarray['tplmtime'][md5($tplfile)]) {
		$sessionarray['tplmtime'][md5($tplfile)]=filemtime($tplfile);
		if (!dpwritedata('adminsession',$sessionarray)) dperror($l_error['cant_writedata'],'adminsession',true);
	}else if (file_exists($objfile)) {
		return $objfile;
	}

	$tpl=file_fetch($tplfile);
	if (!$tpl) dperror($l_error['cant_fetchdata'],$tplfile,true);

	$tpl=dp_tpl_parse($tpl);
	$tpl=str_replace('exit("STOP");','',$tpl);

	if (!file_write($objfile,$tpl)) dperror($l_error['cant_writedata'],$objfile,true);

	return $objfile;
}

function dp_tpl_parse($tpl) {
	global $d_mainset;

	$tpl=preg_replace("/\<\!\-\-\{(.+?)\}\-\-\>/s","{\\1}",$tpl);

	$tpl=preg_replace('/\{obj\:(.*?)\:(.*?)\:(.*?)\:(.*?)\}/ies',"get_objfunc_code('\\1','\\2','\\3','\\4')",$tpl);
	$tpl=str_replace('{/obj}','<?php $output=@ob_get_contents(); @ob_end_clean(); echo $output; if (!$_GET["genhtml"] and $d_basicset["cachevalidtime"]) { if (!cache_write($cacheid,$output)) { dperror($l_error["cant_writedata"],$cacheid,true); }else{ $_SERVER["gencount"]++; } } } ?><!--end:obj-->',$tpl);

	$tpl=preg_replace('/\{loop\:(.*?)\}/ies','get_loop_code("\\1")',$tpl);
	$tpl=str_replace('{/loop}','<?php } } ?>',$tpl);
	$tpl=preg_replace('/\{if\:(.*?)\}/is','<?php if (\\1) { ?>',$tpl);
	$tpl=preg_replace('/\{elseif\:(.*?)\}/is','<?php }elseif (\\1) { ?>',$tpl);
	$tpl=str_replace('{else}','<?php }else{ ?>',$tpl);
	$tpl=str_replace('{/if}','<?php } ?>',$tpl);
	$tpl=preg_replace('/\{v\:(.*?)\}/is','<?php echo $\\1; ?>',$tpl);
	$tpl=preg_replace('/\{lv\:(.*?)\}/is','<?php echo $curval["\\1"]; ?>',$tpl);
	$tpl=preg_replace('/\{\-php\:(.*?)\-\}/is','<?php \\1 ?>',$tpl);

	$tpl=preg_replace('/\{tpl\:(.*?)\}/is','<?php if (!defined("INADM")) { @include dp_tpl(PATH_PRE."dpstyle/'.$d_mainset['curstyle'].'/\\1.tpl.php"); }else{ echo "{tpl:\\1}"; } ?>',$tpl);

	$tpl=preg_replace('/\{l\:(.*?)\:(.*?)\}/ies','get_l_code("\\1","\\2")',$tpl);

	$tpl=preg_replace('/\?\>[\n\r]*\<\?php/is',' ',$tpl);
	return $tpl;
}

function get_objfunc_code($id,$mod,$obj,$config) {
	global $d_basicset,$sessionarray;
	$langfile=PATH_PRE.'dpmain/lang/'.$d_basicset['langpak'].'/'.$mod.'_fore.php';
	$funcfile=PATH_PRE.'dpmain/module/'.$mod.'/objfunc/'.$obj.'.php';
	return '<!--begin:obj:'.$id.'-->'."<?php\r\n".'$cacheid="'.(defined('INADM') ? $sessionarray['pagetypeid'] : $_GET['pagetype']).'".$_SERVER["QUERY_STRING"]."'.$id.$mod.$obj.$config.'"; if (!$_GET["genhtml"] and (cache_isvalid($cacheid,$d_basicset["cachevalidtime"]) or ($_SERVER["gencount"]>=1 and cache_exists($cacheid)))) { echo cache_fetch($cacheid); }else{ @ob_start(); '."\r\n".'include_once "'.$langfile.'";'."\r\n".'$paras=array('.$config.');'."\r\n".'include "'.$funcfile.'";'."\r\n?>";
}

function get_l_code($mod,$val) {
	return '<?php echo $l'.($mod ? '_'.$mod : '').'_fore["'.$val.'"]; ?>';
}

function get_loop_code($str) {
    $tmp=explode(':',$str);
    $loop='<?php $i=0; if (is_array($'.stripslashes($tmp[0]).')) { foreach($'.stripslashes($tmp[0]);
    $loop.= count($tmp)==1 ? ' as $curval)' : '';
    $loop.= count($tmp)==2 ? ' as $'.stripslashes($tmp[1]).')' : '';
    $loop.= count($tmp)==3 ? ' as $'.stripslashes($tmp[1]).' => $'.stripslashes($tmp[2]).')' : '';
    return $loop.' { $i++; ?>';

}
?>