<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include APP_PATH.'control/caiji_common_control.class.php';

class auto_control extends caiji_common_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked['auto'] = 'active';

	}
	public function on_index(){
		$this->_title[]='自动采集';
		$this->_title[]=$this->conf['app_name'];
		$task_list=$this->caiji_auto->index_fetch(array(),array('id'=>-1),0,100);
		foreach($task_list as &$task){
			$this->caiji_auto->format($task);
		}

		$this->view->assign('task_list',$task_list);
		$this->view->display('auto_index.htm');
	}
	public function on_add(){
		$id=intval(core::gpc('id'));
		$task=$this->caiji_auto->read($id);
		if($this->form_submit()){
			
			$name=core::gpc('auto_name','P');
			$name=misc::safe_str($name);
			!$name && $this->message('请填写任务名称',0);
			$time=intval(core::gpc('auto_time','P'));
			
			$group=(array)core::gpc('node_list','P');
			if($id){
				$task['name']=$name;
				$task['septime']=$time;
				$task['groups']=core::json_encode($group);
				$this->caiji_auto->update($task);
			}else{
				$arr=array('name'=>$name,'septime'=>$time,'groups'=>core::json_encode($group));
				
				$this->caiji_auto->create($arr);
			}
			
			$this->message('添加成功');
		}
		
		$task && $this->caiji_auto->format($task);
		
		$nodelist=$this->caiji_group->get_list();
		$nodelist=misc::arrlist_key_values($nodelist, 'gid', 'name');
		
		$this->view->assign('id',$id);
		$this->view->assign('task',$task);
		$this->view->assign('nodelist',$nodelist);
		$this->view->display('auto_add_ajax.htm');	
	}
	public function on_del(){
		$ids=(array)core::gpc('ids','R');
		foreach($ids as $id){
		  $id=intval($id);	
		  $this->caiji_auto->delete($id);
		}
		$this->message('删除成功',1,'?auto-index.htm');
		
	}
	public function on_log(){
		$id=intval(core::gpc('id'));
		$rs=$this->caiji_auto->read($id);
		!$rs && $this->message('任务不存在',0);
        $logarr=core::json_decode($rs['runlog']);
		$this->view->assign('data',$rs);
		$this->view->assign('logarr',$logarr);
		$this->view->display('auto_log.htm');
	}
	
}

?>