<?php

/*
 * Copyright (C) xgcms.com
 */

// 调试模式: 1 打开，0 关闭, SAE 环境，必须为 2，否则会去加载 tmp/_runtime.php
define('DEBUG', class_exists('SaeKV') ? 2 : 2);

// 站点根目录
define('ROOT_PATH', str_replace('\\', '/', substr(dirname(__FILE__), 0, -13)));

//include ROOT_PATH.'install/function.php';

// 框架的物理路径
$conf = include ROOT_PATH.'conf/conf.php';
$conf += include ROOT_PATH.'caiji/conf/conf.php';
if(empty($conf)) {
	message('<h3>读取配置文件失败，请检查配置文件是否存在并且有可读权限：'.ROOT_PATH.'conf/conf.php'.'</h3>');
}

// PHP 版本判断
if(version_compare(PHP_VERSION, '5.0.0') == -1) {
	message('<h3>非常抱歉，您的PHP版本太低 ('.PHP_VERSION.')，达不到最低安装要求 (5.0.0)</h3>');
}

define('FRAMEWORK_PATH', ROOT_PATH.'core/xiunophp/');
define('FRAMEWORK_TMP_PATH', $conf['tmp_path']);
define('FRAMEWORK_LOG_PATH', $conf['log_path']);
include FRAMEWORK_PATH.'core.php';
core::init();

IN_SAE && $conf['upload_path'] = 'saestor://upload/';

//include ROOT_PATH.'core/model/menu.class.php';
//include ROOT_PATH.'core/model/runtime.class.php';

$step = isset($_GET['step']) ? $_GET['step'] : '';

if(empty($step) || $step == 'checkdb') {

	include './header.inc.php';	
	include './step1.inc.php';	
	include './footer.inc.php';
	exit;
	
} elseif($step == 'complete') {
	$menu=core::model($conf,'menu');
	$db = $menu->db;
	//数据表
	$s = file_get_contents(ROOT_PATH.'caiji/install/mysql.sql');
	$s = str_replace("\r\n", "\n", $s);
	$s = preg_replace('#\n\#[^\n]*?\n#is', "\n", $s);	// 去掉注释行
	$sqlarr = explode(";\n", $s);
	$tablepre = $db->tablepre;
	foreach($sqlarr as $sql) {
		if(trim($sql)) {
			$sql = str_replace('xc_', $tablepre, $sql);
			try {
				$db->query($sql);
			} catch (Exception $e) {
				$error = $e->getMessage();
				break;
			}
		}
	}
	//建立菜单
	$appurl=$conf['cms_url'].'caiji/';
	$arr=array();
				$arr['pid']=0;
				$arr['name']='采集';
				$arr['ajax']=0;
				$arr['rank']=300;
				$arr['appid']='cms_admin';
				$arr['type']='back';
				$arr['flag']='index_url';
				$arr['control']='index';
				$arr['action']='url';
				$arr['param']='url='.$conf['cms_url'].'caiji/';
				$mid=$menu->create($arr);
	//应用中心
		$app_maxid=$db->index_maxid('framework_apps-id');
			$app=array('id'=>$app_maxid+1,'name'=>'采集','app_type'=>'xgcms','model_name'=>'caiji','brief'=>$conf['app_name'],'admin_url'=>$appurl,'app_url'=>$appurl,'isxgcms'=>1,'ismenu'=>1,'installed'=>1,'charset'=>'utf-8');
			$db->set('framework_apps-id-'.($app_maxid+1),$app);
					
	// 设置 cookie
	header('Content-Type: text/html; charset=UTF-8');
	include './header.inc.php';	
	include './step4.inc.php';	
	include './footer.inc.php';
	exit;
}

?>