<?php

/*
 * Copyright (C) xgcms.com
 */

class caiji_images extends base_model {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'caiji_images';
		$this->primarykey = array('id');
		$this->maxcol = 'id';
	}
	
	
	public function get_one($map) {
		$rs = $this->index_fetch($map,array('id'=>1),0,1);
		return $rs=$rs?array_pop($rs):false;
	}
	public function get_list($map=array(),$start=0,$limit=100,$order=array('id'=>-1)){
		$list = $this->index_fetch($map,$order,$start,$limit);
		return $list;
	
	}
	public function delete_by_nid($nid){
		$db = $this->db;
		$tablepre = $db->tablepre;
		$db->query("DELETE FROM {$tablepre}caiji_images WHERE `nid`=$nid;");
	}
	public function xdelete($id){
		$rs=$this->read($id);
		if($rs['status']==2){
			$file=$rs['local_image'];
			if(is_file($file)) unlink($file); 
		}
		$this->delete($id);
	}
	// 用来显示给用户
	public function format(&$img) {
		// format data here.
		$rs=$this->caiji_content->get_one(array('id'=>$img['tid']));
		$img['title']=utf8::substr($rs['title'],0,10);
		$img['thumb']=$img['isthumb']==1?'是':'否';
		switch($img['status']){
			case '1':
			   $img['status_fmt']='未下载';
			   break;
			   case '2':
			   $img['status_fmt']='<span class="green">已下载</span>';
			   
			   break;
			   case '3':
			   $img['status_fmt']='<span class="grey">下载失败</span>';
			   
			   break;
		}
	}
	public function download($img,$path){
		 if(empty($img)) return;
		 
		 				$img['status']=4;//先更新状态避免多窗口执行任务重复下载；
						$this->update($img);
						
		            include_once APP_PATH.'lib/getimage.class.php';
					
						$dir1 = date('Y/').ceil($img['tid'] / 10000);
		                $dir2 = ceil($img['tid'] % 10000 / 1000);
		 
		                $dir = $path.$dir1.'/'.$dir2.'/'.$img['tid'].'/';


	                if(!file_exists($dir)) {
			            mkdir($dir, 0777, true);
	              	}
		 			$att=getimage::get($img['image'],$dir);
					if(!empty($att)&&$att!='error'){

						$img['local_image']=$att;
						$img['status']=2;
						
						$this->update($img);

						$topic=$this->caiji_content->read($img['tid']);

						if($img['isthumb']==1){
							$topic['img']=$att;
						}else{
							
							$watermark_img=APP_PATH.'upload/water.png';
							if(is_file($watermark_img)){
								 include_once(APP_PATH.'lib/water.class.php');
								 $image=new water();
								 $randarr=array(1=>1,2=>3,3=>7,4=>9);
								 $randnum=4;
								 $watermark_pos=$randarr[$randnum];
								 $image->watermark($att, '', $watermark_pos, $watermark_img, '', 5, '#ff0000');	
							}
							$topic['content']=str_replace($img['image'],$att,$topic['content']);
							$topic['reply'] && $topic['reply']=str_replace($img['image'],$att,$topic['reply']);
							$topic['data'] && $topic['data']=str_replace($img['image'],$att,$topic['data']);
							
						}
						$this->caiji_content->update($topic);
						
						return $att;
					}else{
						$img['status']=3;
						
						$this->update($img);
					}
		            return '';
		
		
	}
}
?>