<?php

/*
 * Copyright (C) xgcms.com
 */

class caiji_node extends base_model {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'caiji_node';
		$this->primarykey = array('nid');
		$this->maxcol = 'nid';
		
		// hook caiji_node_construct_end.php
	}
	public function cache_update_node($nid){
		$rs=$this->xget($nid);
		$this->kv->set('node_'.$nid,$rs);
		return $rs;
	}
	// 取得采集规则的nid, 和0
	public function get_list($con=array(),$start=0,$limit=100) {
		$node_list = $this->index_fetch($con, array('nid'=>-1), $start, $limit);
		misc::arrlist_change_key($node_list, 'nid');
		return $node_list;
	}
	
	public function groupid_to_name($groupid) {
		$group = $this->read($groupid);
		return $group['name'];
	}

	// 获取 groupid=>name
	/*public function get_group_kv() {
		$group_kv = $this->kv->get('group_kv');
		if(empty($group_kv)) {
			$group_kv = misc::arrlist_key_values();
			$this->kv->set('group_kv', core::json_encode($group_kv));
		}
		return $group_kv;
	}*/
	public function xget($nid){
		$rs=$this->read($nid);
		$rs2=$this->caiji_newfield->get_list_by_nid($nid);
		
		misc::arrlist_change_key($rs2,'name_en');
		
		$rs['newfield']=$rs2;
		
		return $rs;
		
		
	}
	public function xcreate($data){
		
		$newfield=$data['newfield'];
		
		unset($data['nid'],$data['newfield']);
		$data['lastdate']=$_SERVER['time'];
		$nid=$this->caiji_node->create($data);
		
		if(!empty($newfield))foreach($newfield as $new){
			
			$new['nid']=$nid;
			
			if(isset($new['id'])) unset($new['id']);
			
			$this->caiji_newfield->create($new);
		}
		return $nid;
		
	}
	public function xdelete($nid) {
		
		$rs=$this->read($nid);
		
		if(empty($rs)) return;
		
		$db = $this->db;
		$tablepre = $db->tablepre;
		$db->query("DELETE FROM {$tablepre}caiji_urls WHERE `nid`=$nid;");
		$db->query("DELETE FROM {$tablepre}caiji_content WHERE `nid`=$nid;");
		$db->query("DELETE FROM {$tablepre}caiji_newfield WHERE `nid`=$nid;");

		$this->delete($nid);
		
	}
	
	public function check_name(&$name) {
		if(empty($name)) {
			return '任务名称不能为空。';
		}
		return '';
	}
	
	
	
	// 用来显示给用户
	public function format(&$node) {
		$node['groupname']=$this->caiji_group->groupid_to_name($node['gid']);
		$node['lastdate_fmt']=date('m-d H:i',$node['lastdate']);
		$node['lastdate']-$_SERVER['time_today']>0 && $node['lastdate_fmt']='<span class="red">'.$node['lastdate_fmt'].'</span>';
		// format data here.
	}
}
?>