<?php header('<?xml version="1.0" encoding="utf-8"?>'); ?>
<?php
error_reporting(0);
include_once(dirname(__FILE__)."/config.php");

//数据采集，doGET,doPOST
class Http
{//类定义开始
//通过get方式获取数据
static public function doGet($url,$timeout=5)
{
$code=self::getSupport();
switch($code)
{
case 1:return self::curl($url,'',$timeout);break;
case 2:return self::socketGet($url,$timeout);break;
case 3:return @file_get_contents($url);break;
default:return false; 
}
}
//通过POST方式发送数据
static public function doPost($url,$data,$timeout=5)
{
$code=self::getSupport();
switch($code)
{
case 1:return self::curl($url,$data,$timeout);break;
case 2:return self::socketPost($url,$data,$timeout);break;
default:return false; 
}
} 

//获取支持读取远程文件的方式
static public function getSupport()
{ 
if(function_exists('curl_init'))//curl方式
{
return 1;
}
else if(function_exists('fsockopen'))//socket
{
return 2;
}
else if(function_exists('file_get_contents'))//php系统函数file_get_contents
{
return 3;
}
else if(ini_get('allow_url_fopen')&&function_exists('fopen'))//php系统函数fopen
{
return 4;
}
else
{
return 0;
} 
}
static public function GetHttpContent($fsock=null) {
$out = null;
while($buff = @fgets($fsock, 2048)){
$out .= $buff;
}
fclose($fsock);
$pos = strpos($out, "\r\n\r\n");
$head = substr($out, 0, $pos); //http head
$status = substr($head, 0, strpos($head, "\r\n")); //http status line
$body = substr($out, $pos + 4, strlen($out) - ($pos + 4));//page body
if(preg_match("/^HTTP\/\d\.\d\s([\d]+)\s.*$/", $status, $matches)){
if(intval($matches[1]) / 100 == 2){
return $body; 
}else{
return false;
}
}else{
return false;
}
}
static public function socketGet($url,$timeout=5){
$url2 = parse_url($url);
$url2["path"] = isset($url2["path"])? $url2["path"]: "/" ;
$url2["port"] = isset($url2["port"])? $url2["port"] : 80;
$url2["query"] = isset($url2["query"])? "?".$url2["query"] : "";
$host_ip = @gethostbyname($url2["host"]);
$fsock_timeout = $timeout; //超时时间
if(($fsock = fsockopen($host_ip, $url2['port'], $errno, $errstr, $fsock_timeout)) < 0){
return false;
}
$request = $url2["path"] .$url2["query"];
$in = "GET " . $request . " HTTP/1.1\r\n";
$in .= "Accept: */*\r\n";
// $in .= "User-Agent: Payb-Agent\r\n";
$in .= "Host: " . $url2["host"] . "\r\n";
$in .= "Connection: Close\r\n\r\n";
if(!@fwrite($fsock, $in, strlen($in))){
@fclose($fsock);
return false;
}
return self::GetHttpContent($fsock);
}

static public function socketPost($url,$post_data=array(),$timeout=5){
$url2 = parse_url($url);
$url2["path"] = ($url2["path"] == "" ? "/" : $url2["path"]);
$url2["port"] = ($url2["port"] == "" ? 80 : $url2["port"]);
$host_ip = @gethostbyname($url2["host"]);
$fsock_timeout = $timeout; //超时时间
if(($fsock = fsockopen($host_ip, $url2['port'], $errno, $errstr, $fsock_timeout)) < 0){
return false;
}
$request = $url2["path"].($url2["query"] ? "?" . $url2["query"] : "");
$post_data2 = http_build_query($post_data);
$in = "POST " . $request . " HTTP/1.1\r\n";
$in .= "Accept: */*\r\n";
$in .= "Host: " . $url2["host"] . "\r\n";
// $in .= "User-Agent: Lowell-Agent\r\n";
$in .= "Content-type: application/x-www-form-urlencoded\r\n";
$in .= "Content-Length: " . strlen($post_data2) . "\r\n";
$in .= "Connection: Close\r\n\r\n";
$in .= $post_data2 . "\r\n\r\n";
unset($post_data2);
if(!@fwrite($fsock, $in, strlen($in))){
@fclose($fsock);
return false;
}
return self::GetHttpContent($fsock);
}

static public function curl($url, $data=array(), $timeout=5) 
{
$ch = curl_init();
if (is_array($data) && $data) 
{
$formdata = http_build_query($data);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $formdata);
}
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
$result = curl_exec($ch);
curl_close($ch);
return $result;
}

}//类定义结束

class SubPages{  
     
   private  $each_disNums;//每页显示的条目数  
  private  $nums;//总条目数  
  private  $current_page;//当前被选中的页  
  private  $sub_pages;//每次显示的页数  
  private  $pageNums;//总页数  
  private  $page_array = array();//用来构造分页的数组  
  private  $subPage_link;//每个分页的链接  
  private  $subPage_type;//显示分页的类型  
   /* 
   __construct是SubPages的构造函数，用来在创建类的时候自动运行. 
   @$each_disNums   每页显示的条目数 
   @nums     总条目数 
   @current_num     当前被选中的页 
   @sub_pages       每次显示的页数 
   @subPage_link    每个分页的链接 
   @subPage_type    显示分页的类型 
    
   当@subPage_type=1的时候为普通分页模式 
         example：   共4523条记录,每页显示10条,当前第1/453页 [首页] [上页] [下页] [尾页] 
         当@subPage_type=2的时候为经典分页样式 
         example：   当前第1/453页 [首页] [上页] 1 2 3 4 5 6 7 8 9 10 [下页] [尾页] 
   */ 
  function __construct($each_disNums,$nums,$current_page,$sub_pages,$subPage_link,$subPage_type){  
   $this->each_disNums=intval($each_disNums);  
   $this->nums=intval($nums);  
    if(!$current_page){  
    $this->current_page=1;  
    }else{  
    $this->current_page=intval($current_page);  
    }  
   $this->sub_pages=intval($sub_pages);  
   $this->pageNums=ceil($nums/$each_disNums);  
   $this->subPage_link=$subPage_link;   
   $this->show_SubPages($subPage_type);   
   //echo $this->pageNums."--".$this->sub_pages;  
  }  
     
     
  /* 
    __destruct析构函数，当类不在使用的时候调用，该函数用来释放资源。 
   */ 
  function __destruct(){  
    unset($each_disNums);  
    unset($nums);  
    unset($current_page);  
    unset($sub_pages);  
    unset($pageNums);  
    unset($page_array);  
    unset($subPage_link);  
    unset($subPage_type);  
   }  
     
  /* 
    show_SubPages函数用在构造函数里面。而且用来判断显示什么样子的分页   
   */ 
  function show_SubPages($subPage_type){  
    if($subPage_type == 1){  
    $this->subPageCss1();  
    }elseif ($subPage_type == 2){  
    $this->subPageCss2();  
    }  
   }  
     
     
  /* 
    用来给建立分页的数组初始化的函数。 
   */ 
  function initArray(){  
    for($i=0;$i<$this->sub_pages;$i++){  
    $this->page_array[$i]=$i;  
    }  
    return $this->page_array;  
   }  
     
     
  /* 
    construct_num_Page该函数使用来构造显示的条目 
    即使：[1][2][3][4][5][6][7][8][9][10] 
   */ 
  function construct_num_Page(){  
    if($this->pageNums < $this->sub_pages){  
    $current_array=array();  
     for($i=0;$i<$this->pageNums;$i++){   
     $current_array[$i]=$i+1;  
     }  
    }else{  
    $current_array=$this->initArray();  
     if($this->current_page <= 3){  
      for($i=0;$i<count($current_array);$i++){  
      $current_array[$i]=$i+1;  
      }  
     }elseif ($this->current_page <= $this->pageNums && $this->current_page > $this->pageNums - $this->sub_pages + 1 ){  
      for($i=0;$i<count($current_array);$i++){  
      $current_array[$i]=($this->pageNums)-($this->sub_pages)+1+$i;  
      }  
     }else{  
      for($i=0;$i<count($current_array);$i++){  
      $current_array[$i]=$this->current_page-2+$i;  
      }  
     }  
    }  
      
    return $current_array;  
   }  
     
  /* 
   构造普通模式的分页 
   共4523条记录,每页显示10条,当前第1/453页 [首页] [上页] [下页] [尾页] 
   */ 
  function subPageCss1(){  
   $subPageCss1Str="";  
   $subPageCss1Str.="<div class=\"list_info\">共".$this->nums."个章节</div>";
   $subPageCss1Str.="<div class=\"list_info\">当前第".$this->current_page."/".$this->pageNums."页</div><div class=\"lpg\">";  
    if($this->current_page > 1){  
    $firstPageUrl=$this->subPage_link."1";  
    $prewPageUrl=$this->subPage_link.($this->current_page-1);  
    $subPageCss1Str.="<li><a href='$firstPageUrl'>首页</a></li>";  
    $subPageCss1Str.="<li><a href='$prewPageUrl'>上一页</a></li>";  
    }else {  
    $subPageCss1Str.="<li>首页</li>";  
    $subPageCss1Str.="<li>上一页</li>";  
    }  
      
    if($this->current_page < $this->pageNums){  
    $lastPageUrl=$this->subPage_link.$this->pageNums;  
    $nextPageUrl=$this->subPage_link.($this->current_page+1);  
    $subPageCss1Str.="<li><a href='$nextPageUrl'>下一页</a></li>";  
    $subPageCss1Str.="<li><a href='$lastPageUrl'>尾页</a></li></div>";  
    }else {  
    $subPageCss1Str.="<li>下一页</li>";  
    $subPageCss1Str.="<li>尾页</li></div>";  
    }  
      
    echo $subPageCss1Str;  
      
   }  
     
     
  /* 
   构造经典模式的分页 
   当前第1/453页 [首页] [上页] 1 2 3 4 5 6 7 8 9 10 [下页] [尾页] 
   */ 
  function subPageCss2(){  
   $subPageCss2Str="";  
   $subPageCss2Str.="当前第".$this->current_page."/".$this->pageNums."页 ";  
      
      
    if($this->current_page > 1){  
    $firstPageUrl=$this->subPage_link."1";  
    $prewPageUrl=$this->subPage_link.($this->current_page-1);  
    $subPageCss2Str.="[<a href='$firstPageUrl'>首页</a>] ";  
    $subPageCss2Str.="[<a href='$prewPageUrl'>上一页</a>] ";  
    }else {  
    $subPageCss2Str.="[首页] ";  
    $subPageCss2Str.="[上一页] ";  
    }  
      
   $a=$this->construct_num_Page();  
    for($i=0;$i<count($a);$i++){  
    $s=$a[$i];  
     if($s == $this->current_page ){  
     $subPageCss2Str.="[<span style='color:red;font-weight:bold;'>".$s."</span>]";  
     }else{  
     $url=$this->subPage_link.$s;  
     $subPageCss2Str.="[<a href='$url'>".$s."</a>]";  
     }  
    }  
      
    if($this->current_page < $this->pageNums){  
    $lastPageUrl=$this->subPage_link.$this->pageNums;  
    $nextPageUrl=$this->subPage_link.($this->current_page+1);  
    $subPageCss2Str.=" [<a href='$nextPageUrl'>下一页</a>] ";  
    $subPageCss2Str.="[<a href='$lastPageUrl'>尾页</a>] ";  
    }else {  
    $subPageCss2Str.="[下一页] ";  
    $subPageCss2Str.="[尾页] ";  
    }  
    echo $subPageCss2Str;  
   }  
}  
$t = $_GET['t'];
$str = iconv("gbk","utf-8",Http::doGet('http://www.qududu.com'.$t));
$preg = '#<div class="chapter_list_chapter"><a href="(.*?)">(.*?)</a></div>#is';
preg_match_all($preg, $str, $con);
$href = $con[1];
$name = $con[2];
$a = array();
foreach ($name as $key => $value) {
	$a[$key]['name'] = $value;
	$a[$key]['href'] = $href[$key];
}

//每页显示的条数  
$page_size=20;  
//总条目数  
$nums=count($a);  
//每次显示的页数  
 $sub_pages=10;  
//得到当前是第几页  
$pageCurrent=$_GET["p"];  
//if(!$pageCurrent) $pageCurrent=1;
$u = $_GET['t'];
$ul = explode("/", $u);
$m = "/book/".$ul[2]."/".$ul[3]."/";
?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title><?php echo $web_name; ?></title>
<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=UTF-8" />
<meta http-equiv="Cache-Control" content="no-cache" />
<script src="http://libs.baidu.com/jquery/1.9.0/jquery.js"></script>
<script>
$(document).ready(function(){
	var i = $("body").width();
	var wf = (i / 4)-1;
	$(".lpg li").css("width", wf+"px");
});
</script>
</head>
<style>
	*{
		margin: 0px;
		padding: 0px;
	}
	.clearfloat{clear:both}
	body{
		width: 100%;
		height: auto;
		background-color: #F0F1F1;
		color: green;
		border-bottom: dashed 1px #fff;
	}
	.logo{
		background-color: green;
		width: 100%;
		height: 40px;
		line-height: 40px;
		text-align: center;
		border-bottom: dashed 1px #fff; 
	}
	.logo a{
		text-decoration: none;
		color: #fff;
	}
	.tit{
		width: 100%;
		height: 40px;
		line-height: 40px;
		border-left: 5px solid green;
		color: green;
		background-color: #fff;
		padding-left: 5px;
	}
	.list{
		width: 100%;
		height: auto;
		float: left;
	}
	.list li{
		width: 100%;
		height: 25px;
		line-height: 25px;
		float: left;
		background-color: #F0F1F1;
		list-style-type: none;
	}
	.list a{
		text-decoration: none;
		color: green;
	}
	.list_info{
		width: 100%;
		height: 40px;
		line-height: 40px;
		border-top: dashed 1px #fff; 
		color: #fff;
		background-color: green;
	}
	.lpg{
		width: 100%;
		height: 40px;
		border-top: dashed 1px #fff; 
		background-color: green;
		float: left;
		color: #fff;
	}
	.lpg li{
		height: 40px;
		line-height: 40px;
		float: left;
		text-align: center;
		list-style-type: none;
	}
	.lpg li a{
		text-decoration: none;
		color: #fff;
	}
	.footer{
		width: 100%;
		height: 40px;
		line-height: 40px;
		text-align: center;
		border-top: dashed 1px #fff; 
		background-color: green;
	}
	.footer a{
		text-decoration: none;
		color: #fff;
	}
</style>
<body>
	<div class="logo"><a href="index.php"><?php echo $web_name; ?></a></div>
	<div class="clearfloat"></div>
	<div class="tit">章节列表</div>
	<div class="list">
		<u>
			<?php
				$page = $_GET['p'];
				$num = ($page-1)*20;
				for ($i=0; $i < 20; $i++) { 
					echo "<li><a href=\"read.php?t=".$m.$a[$num+$i]['href']."\">".$a[$num+$i]['name']."</a></li>";
				}
			?>
		</u>
	</div>
	<div class="clearfloat"></div>
	<?php
		$subPages=new SubPages($page_size,$nums,$pageCurrent,$sub_pages,"zlist.php?t=".$t."&p=",1);  
	?>
	<div class="clearfloat"></div>
	<div class="footer">
		<p><a href="index.php"><?php echo $web_name; ?></a></p>
	</div>
  <?php echo $tongji; ?>
</body>
</html>