SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- 数据库: `cms`
--

-- --------------------------------------------------------

--
-- 表的结构 `xgcms_apps`
--

DROP TABLE IF EXISTS `xgcms_apps`;
CREATE TABLE IF NOT EXISTS `xgcms_apps` (
  `id` smallint(5) NOT NULL auto_increment,
  `name` varchar(30) NOT NULL,
  `model_name` char(20) NOT NULL,
  `brief` char(255) NOT NULL,
  `admin_url` varchar(120) NOT NULL,
  `app_url` varchar(120) NOT NULL,
  `isxgcms` tinyint(1) NOT NULL default '0',
  `ismenu` tinyint(1) NOT NULL default '0',
  `installed` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

--
-- 转存表中的数据 `xgcms_apps`
--

INSERT INTO `xgcms_apps` (`id`, `name`, `model_name`, `brief`, `admin_url`, `app_url`, `isxgcms`, `ismenu`, `installed`) VALUES
(5, '采集', 'caiji', 'XGCMS采集系统', 'http://yourdomain/caiji/', 'http://yourdomain/caiji/', 1, 1, 0),
(10, '数据库', 'mysql', '数据库管理', 'http://yourdomain/mysql/', 'http://yourdomain/mysql/', 1, 1, 0),
(1, '资源中心', 'resources', 'XGCMS资源中心为您提供各种网站资源，包括采集系统的采集规则、发布接口、插件应用，还有其他优秀的站长资源等。', 'http://www.xgcms.com/?list-index-catid-ziyuan.htm', 'http://www.xgcms.com/?list-index-catid-ziyuan.htm', 1, 0, 1),
(2, '用户交流', 'say', '', 'http://post.xgcms.com/xcenter-topic.htm', 'http://post.xgcms.com/xcenter-topic.htm', 1, 0, 1),
(11, 'XGCMS', 'xgcms', 'XGCMS内容管理系统', 'http://yourdomain/xgcms/admin/', 'http://yourdomain/', 1, 1, 1);

-- --------------------------------------------------------

--
-- 表的结构 `xgcms_framework_count`
--

DROP TABLE IF EXISTS `xgcms_framework_count`;
CREATE TABLE IF NOT EXISTS `xgcms_framework_count` (
  `name` char(32) NOT NULL default '',
  `count` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `xgcms_framework_count`
--

INSERT INTO `xgcms_framework_count` (`name`, `count`) VALUES
('xgcms_category', 0),
('xgcms_user', 7),
('xgcms_news', 0),
('xgcms_model', 1),
('xgcms_model_field', 16),
('xgcms_search', 0),
('group', 12),
('user', 2),
('xgcms_attach', 0),
('xgcms_type', 0),
('xgcms_views', 1),
('xgcms_pos', 0),
('xgcms_pos_data', 50);

-- --------------------------------------------------------

--
-- 表的结构 `xgcms_framework_maxid`
--

DROP TABLE IF EXISTS `xgcms_framework_maxid`;
CREATE TABLE IF NOT EXISTS `xgcms_framework_maxid` (
  `name` char(32) NOT NULL default '',
  `maxid` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `xgcms_framework_maxid`
--

INSERT INTO `xgcms_framework_maxid` (`name`, `maxid`) VALUES
('xgcms_category', 0),
('xgcms_user', 8),
('xgcms_news', 0),
('xgcms_model', 25),
('xgcms_search', 0),
('group', 15),
('user', 2),
('xgcms_attach', 0),
('xgcms_model_field', 288),
('xgcms_type', 0),
('xgcms_pos', 16),
('xgcms_pos_data', 345);

-- --------------------------------------------------------

--
-- 表的结构 `xgcms_group`
--

DROP TABLE IF EXISTS `xgcms_group`;
CREATE TABLE IF NOT EXISTS `xgcms_group` (
  `groupid` smallint(6) unsigned NOT NULL,
  `name` char(20) NOT NULL default '',
  `creditsfrom` int(10) NOT NULL default '0',
  `creditsto` int(10) NOT NULL default '0',
  `maxcredits` int(10) NOT NULL default '0',
  `maxgolds` int(10) NOT NULL default '0',
  `allowread` int(10) NOT NULL default '0',
  `allowthread` int(10) NOT NULL default '0',
  `allowpost` int(10) NOT NULL default '0',
  `allowreply` int(10) NOT NULL default '0',
  `allowattach` int(10) NOT NULL default '0',
  `allowdown` int(10) NOT NULL default '0',
  `allowtop` int(10) NOT NULL default '0',
  `allowdigest` int(10) NOT NULL default '0',
  `allowupdate` int(10) NOT NULL default '0',
  `allowdelete` int(10) NOT NULL default '0',
  `allowmove` int(10) NOT NULL default '0',
  `allowbanuser` int(10) NOT NULL default '0',
  `allowdeleteuser` int(10) NOT NULL default '0',
  `allowviewip` int(10) NOT NULL default '0',
  PRIMARY KEY  (`groupid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `xgcms_group`
--

INSERT INTO `xgcms_group` (`groupid`, `name`, `creditsfrom`, `creditsto`, `maxcredits`, `maxgolds`, `allowread`, `allowthread`, `allowpost`, `allowreply`, `allowattach`, `allowdown`, `allowtop`, `allowdigest`, `allowupdate`, `allowdelete`, `allowmove`, `allowbanuser`, `allowdeleteuser`, `allowviewip`) VALUES
(0, '游客组', 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0),
(1, '超级管理员', 0, 0, 10000, 10000, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
(2, '二级管理员', 0, 0, 200, 200, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
(4, '三级管理员', 0, 0, 50, 50, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1),
(5, '四级管理员', 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0),
(6, '待验证用户组', 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(7, '禁止用户组', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(11, '一级用户组', 0, 50, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0),
(12, '二级用户组', 50, 200, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0),
(13, '三级用户组', 200, 1000, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0),
(14, '四级用户组', 1000, 10000, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0),
(15, '五级用户组', 10000, 10000000, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- 表的结构 `xgcms_kv`
--

DROP TABLE IF EXISTS `xgcms_kv`;
CREATE TABLE IF NOT EXISTS `xgcms_kv` (
  `k` char(32) NOT NULL default '',
  `v` text NOT NULL,
  `expiry` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`k`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `xgcms_kv`
--

INSERT INTO `xgcms_kv` (`k`, `v`, `expiry`) VALUES
('conf_ext', '{"image_water_on":0,"image_water_pos":0,"reg_email_on":0,"reg_init_golds":0,"resetpw_on":0}', 0),
('conf', '{"app_name":"XGCMS","timeoffset":"+8","forum_index_pagesize":20,"cookie_keeptime":86400,"site_pv":100000,"site_runlevel":0,"threadlist_hotviews":200,"seo_title":"\\u4e16\\u754c\\u9886\\u5148\\u7684\\u5185\\u5bb9\\u7ba1\\u7406\\u7cfb\\u7edf","seo_keywords":"XGCMS","seo_description":"XGCMS","search_type":"title","china_icp":"\\u4eacICP100110","app_copyright":"2008-2013 XGCMS.COM","footer_js":"","iptable_on":0,"badword_on":0,"online_hold_time":1800,"html_cache":0,"cache_list_time":3600,"cache_show_time":8640000,"reg_on":1,"view_path":["E:\\/phpnow\\/htdocs\\/cms\\/xcenter\\/..\\/plugin\\/view_xgcms\\/"]}', 0),
('mail_conf', '{"sendtype":1,"smtplist":[]}', 0),
('last_version', '1376028291', 0),
('cache_category_arr_', '[]', 0);

-- --------------------------------------------------------

--
-- 表的结构 `xgcms_runtime`
--

DROP TABLE IF EXISTS `xgcms_runtime`;
CREATE TABLE IF NOT EXISTS `xgcms_runtime` (
  `k` char(32) NOT NULL default '',
  `v` text NOT NULL,
  `expiry` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`k`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `xgcms_runtime`
--

INSERT INTO `xgcms_runtime` (`k`, `v`, `expiry`) VALUES
('runtime', '{"app_name":"XGCMS","timeoffset":"+8","forum_index_pagesize":20,"cookie_keeptime":86400,"site_pv":100000,"site_runlevel":0,"threadlist_hotviews":200,"seo_title":"\\u4e16\\u754c\\u9886\\u5148\\u7684\\u5185\\u5bb9\\u7ba1\\u7406\\u7cfb\\u7edf","seo_keywords":"XGCMS","seo_description":"XGCMS","search_type":"title","china_icp":"\\u4eacICP100110","app_copyright":"2008-2013 XGCMS.COM","footer_js":"","iptable_on":0,"badword_on":0,"online_hold_time":1800,"html_cache":0,"cache_list_time":3600,"cache_show_time":8640000,"reg_on":1,"view_path":["E:\\/phpnow\\/htdocs\\/cms\\/xcenter\\/..\\/plugin\\/view_xgcms\\/"],"users":2,"cron_1_next_time":0,"cron_2_next_time":0,"grouparr":{"0":"\\u6e38\\u5ba2\\u7ec4","1":"\\u8d85\\u7ea7\\u7ba1\\u7406\\u5458","2":"\\u4e8c\\u7ea7\\u7ba1\\u7406\\u5458","4":"\\u4e09\\u7ea7\\u7ba1\\u7406\\u5458","5":"\\u56db\\u7ea7\\u7ba1\\u7406\\u5458","6":"\\u5f85\\u9a8c\\u8bc1\\u7528\\u6237\\u7ec4","7":"\\u7981\\u6b62\\u7528\\u6237\\u7ec4","11":"\\u4e00\\u7ea7\\u7528\\u6237\\u7ec4","12":"\\u4e8c\\u7ea7\\u7528\\u6237\\u7ec4","13":"\\u4e09\\u7ea7\\u7528\\u6237\\u7ec4","14":"\\u56db\\u7ea7\\u7528\\u6237\\u7ec4","15":"\\u4e94\\u7ea7\\u7528\\u6237\\u7ec4"},"menuarr":[]}', 0);

-- --------------------------------------------------------

--
-- 表的结构 `xgcms_user`
--

DROP TABLE IF EXISTS `xgcms_user`;
CREATE TABLE IF NOT EXISTS `xgcms_user` (
  `uid` int(11) unsigned NOT NULL auto_increment,
  `regip` int(11) NOT NULL default '0',
  `regdate` int(11) unsigned NOT NULL default '0',
  `username` char(16) NOT NULL default '',
  `password` char(32) NOT NULL default '',
  `salt` char(8) NOT NULL default '',
  `email` char(40) NOT NULL default '',
  `groupid` tinyint(3) unsigned NOT NULL default '0',
  `avatar` int(11) unsigned NOT NULL default '0',
  `credits` int(11) unsigned NOT NULL default '0',
  `golds` int(11) unsigned NOT NULL default '0',
  `accesson` tinyint(1) NOT NULL default '0',
  `onlinetime` int(1) NOT NULL default '0',
  `lastactive` int(1) NOT NULL default '0',
  PRIMARY KEY  (`uid`),
  UNIQUE KEY `username` (`username`),
  KEY `email` (`email`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- 转存表中的数据 `xgcms_user`
--

INSERT INTO `xgcms_user` (`uid`, `regip`, `regdate`, `username`, `password`, `salt`, `email`, `groupid`, `avatar`, `credits`, `golds`, `accesson`, `onlinetime`, `lastactive`) VALUES
(1, 12345554, 1371819093, 'admin', '1fc4fa5af88098ba73e60ac54fd85dd1', '705154', 'admin@admin.com', 1, 0, 10000, 10000, 0, 5400, 1372326953),
(2, 12345554, 1371819093, '系统', '040c1cfa2dcbac5bda9605b6d2d1d18c', '705154', 'system@admin.com', 11, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_attach`
--

DROP TABLE IF EXISTS `xgcms_xgcms_attach`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_attach` (
  `catid` smallint(6) unsigned NOT NULL default '0',
  `aid` int(10) unsigned NOT NULL auto_increment,
  `tid` int(11) NOT NULL default '0',
  `pid` int(11) NOT NULL default '0',
  `uid` int(10) NOT NULL default '0',
  `filesize` int(8) unsigned NOT NULL default '0',
  `width` mediumint(8) unsigned NOT NULL default '0',
  `height` mediumint(8) unsigned NOT NULL default '0',
  `filename` char(120) NOT NULL default '',
  `orgfilename` char(120) NOT NULL default '',
  `filetype` char(7) NOT NULL default '',
  `dateline` int(10) unsigned NOT NULL default '0',
  `comment` char(100) NOT NULL default '',
  `downloads` int(10) NOT NULL default '0',
  `isimage` tinyint(1) NOT NULL default '0',
  `golds` int(10) NOT NULL default '0',
  PRIMARY KEY  (`catid`,`aid`),
  KEY `fidtid` (`catid`,`tid`),
  KEY `fidpid` (`catid`,`pid`),
  KEY `uid` (`uid`,`isimage`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `xgcms_xgcms_attach`
--


-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_cache`
--

DROP TABLE IF EXISTS `xgcms_xgcms_cache`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_cache` (
  `cacheid` char(32) NOT NULL,
  `id` int(10) NOT NULL default '0',
  `catid` mediumint(8) NOT NULL default '0',
  `modelid` smallint(3) NOT NULL default '0',
  `thumb` tinyint(1) NOT NULL default '0',
  `inputtime` int(10) NOT NULL default '0',
  `updatetime` int(10) NOT NULL default '0',
  `data` text NOT NULL,
  PRIMARY KEY  (`cacheid`),
  KEY `catid` (`catid`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `xgcms_xgcms_cache`
--


-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_category`
--

DROP TABLE IF EXISTS `xgcms_xgcms_category`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_category` (
  `catid` smallint(5) unsigned NOT NULL auto_increment,
  `siteid` smallint(5) unsigned NOT NULL default '0',
  `module` varchar(15) NOT NULL,
  `type` tinyint(1) unsigned NOT NULL default '0',
  `modelid` smallint(5) unsigned NOT NULL default '0',
  `parentid` smallint(5) unsigned NOT NULL default '0',
  `arrparentid` varchar(255) NOT NULL,
  `child` tinyint(1) unsigned NOT NULL default '0',
  `arrchildid` mediumtext NOT NULL,
  `catname` varchar(30) NOT NULL,
  `style` varchar(5) NOT NULL,
  `image` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  `parentdir` varchar(100) NOT NULL,
  `catdir` varchar(30) NOT NULL,
  `url` varchar(100) NOT NULL,
  `items` mediumint(8) unsigned NOT NULL default '0',
  `hits` int(10) unsigned NOT NULL default '0',
  `setting` mediumtext NOT NULL,
  `listorder` smallint(5) unsigned NOT NULL default '0',
  `ismenu` tinyint(1) unsigned NOT NULL default '1',
  `accesson` tinyint(1) NOT NULL default '0',
  `sethtml` tinyint(1) unsigned NOT NULL default '0',
  `letter` varchar(30) NOT NULL,
  `usable_type` varchar(255) NOT NULL,
  `additional` text NOT NULL,
  `commenttypeid` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`catid`),
  KEY `module` (`module`,`parentid`,`listorder`,`catid`),
  KEY `siteid` (`siteid`,`type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=79 ;

--
-- 转存表中的数据 `xgcms_xgcms_category`
--


-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_category_accesson`
--

DROP TABLE IF EXISTS `xgcms_xgcms_category_accesson`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_category_accesson` (
  `catid` int(11) unsigned NOT NULL default '0',
  `groupid` int(11) unsigned NOT NULL default '0',
  `allowread` tinyint(1) unsigned NOT NULL default '0',
  `allowthread` tinyint(1) unsigned NOT NULL default '0',
  `allowpost` tinyint(1) unsigned NOT NULL default '0',
  `allowreply` tinyint(1) unsigned NOT NULL default '0',
  `allowattach` tinyint(1) unsigned NOT NULL default '0',
  `allowdown` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`catid`,`groupid`),
  KEY `fid` (`catid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `xgcms_xgcms_category_accesson`
--


-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_category_page`
--

DROP TABLE IF EXISTS `xgcms_xgcms_category_page`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_category_page` (
  `catid` smallint(5) unsigned NOT NULL default '0',
  `title` varchar(160) NOT NULL,
  `style` varchar(24) NOT NULL,
  `keywords` varchar(40) NOT NULL,
  `content` text NOT NULL,
  `template` varchar(30) NOT NULL,
  `updatetime` int(10) unsigned NOT NULL default '0',
  KEY `catid` (`catid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `xgcms_xgcms_category_page`
--


-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_charge`
--

DROP TABLE IF EXISTS `xgcms_xgcms_charge`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_charge` (
  `catid` int(10) unsigned NOT NULL default '0',
  `id` int(10) unsigned NOT NULL default '0',
  `uid` int(10) NOT NULL default '0',
  `dateline` int(10) unsigned NOT NULL default '0',
  `golds` int(10) NOT NULL default '0',
  `credits` int(8) NOT NULL default '0',
  PRIMARY KEY  (`uid`,`catid`,`id`),
  KEY `uploaduid` (`dateline`),
  KEY `fid` (`catid`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `xgcms_xgcms_charge`
--


-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_model`
--

DROP TABLE IF EXISTS `xgcms_xgcms_model`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_model` (
  `modelid` smallint(5) unsigned NOT NULL auto_increment,
  `siteid` smallint(5) unsigned NOT NULL default '0',
  `name` char(30) NOT NULL,
  `description` char(100) NOT NULL,
  `tablename` char(20) NOT NULL,
  `setting` text NOT NULL,
  `addtime` int(10) unsigned NOT NULL default '0',
  `items` smallint(5) unsigned NOT NULL default '0',
  `enablesearch` tinyint(1) unsigned NOT NULL default '1',
  `disabled` tinyint(1) unsigned NOT NULL default '0',
  `default_style` char(30) NOT NULL,
  `category_template` char(30) NOT NULL,
  `list_template` char(30) NOT NULL,
  `show_template` char(30) NOT NULL,
  `js_template` varchar(30) NOT NULL,
  `admin_list_template` char(30) NOT NULL,
  `member_add_template` varchar(30) NOT NULL,
  `member_list_template` varchar(30) NOT NULL,
  `sort` tinyint(3) NOT NULL,
  `type` tinyint(1) NOT NULL,
  PRIMARY KEY  (`modelid`),
  KEY `type` (`type`,`siteid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=29 ;

--
-- 转存表中的数据 `xgcms_xgcms_model`
--

INSERT INTO `xgcms_xgcms_model` (`modelid`, `siteid`, `name`, `description`, `tablename`, `setting`, `addtime`, `items`, `enablesearch`, `disabled`, `default_style`, `category_template`, `list_template`, `show_template`, `js_template`, `admin_list_template`, `member_add_template`, `member_list_template`, `sort`, `type`) VALUES
(25, 0, '文章模型', '文章、资讯', 'xgcms_news', '', 0, 0, 1, 0, '', 'category.htm', 'list.htm', 'show.htm', '', '', '', '', 0, 0);

-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_model_field`
--

DROP TABLE IF EXISTS `xgcms_xgcms_model_field`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_model_field` (
  `fieldid` mediumint(8) unsigned NOT NULL auto_increment,
  `modelid` smallint(5) unsigned NOT NULL default '0',
  `siteid` smallint(5) unsigned NOT NULL default '0',
  `field` varchar(20) NOT NULL,
  `name` varchar(30) NOT NULL,
  `tips` text NOT NULL,
  `css` varchar(30) NOT NULL,
  `minlength` int(10) unsigned NOT NULL default '0',
  `maxlength` int(10) unsigned NOT NULL default '0',
  `pattern` varchar(255) NOT NULL,
  `errortips` varchar(255) NOT NULL,
  `formtype` varchar(20) NOT NULL,
  `setting` mediumtext NOT NULL,
  `formattribute` varchar(255) NOT NULL,
  `unsetgroupids` varchar(255) NOT NULL,
  `unsetroleids` varchar(255) NOT NULL,
  `iscore` tinyint(1) unsigned NOT NULL default '0',
  `issystem` tinyint(1) unsigned NOT NULL default '0',
  `isunique` tinyint(1) unsigned NOT NULL default '0',
  `isbase` tinyint(1) unsigned NOT NULL default '0',
  `issearch` tinyint(1) unsigned NOT NULL default '0',
  `isadd` tinyint(1) unsigned NOT NULL default '0',
  `isfulltext` tinyint(1) unsigned NOT NULL default '0',
  `isposition` tinyint(1) unsigned NOT NULL default '0',
  `listorder` mediumint(8) unsigned NOT NULL default '0',
  `disabled` tinyint(1) unsigned NOT NULL default '0',
  `isomnipotent` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`fieldid`),
  KEY `modelid` (`modelid`,`disabled`),
  KEY `field` (`field`,`modelid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=382 ;

--
-- 转存表中的数据 `xgcms_xgcms_model_field`
--

INSERT INTO `xgcms_xgcms_model_field` (`fieldid`, `modelid`, `siteid`, `field`, `name`, `tips`, `css`, `minlength`, `maxlength`, `pattern`, `errortips`, `formtype`, `setting`, `formattribute`, `unsetgroupids`, `unsetroleids`, `iscore`, `issystem`, `isunique`, `isbase`, `issearch`, `isadd`, `isfulltext`, `isposition`, `listorder`, `disabled`, `isomnipotent`) VALUES
(246, 25, 1, 'catid', '栏目', '', '', 1, 6, '/^[0-9]{1,6}$/', '请选择栏目', 'catid', 'array (\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0),
(247, 25, 1, 'typeid', '类别', '', '', 0, 0, '', '', 'typeid', 'array (\n  ''minnumber'' => '''',\n  ''defaultvalue'' => '''',\n)', '', '', '', 0, 1, 0, 1, 1, 1, 0, 0, 2, 0, 0),
(248, 25, 1, 'title', '标题', '', 'inputtitle', 1, 80, '', '请输入标题', 'title', 'null', '', '', '', 0, 1, 0, 1, 1, 1, 1, 1, 4, 0, 0),
(249, 25, 1, 'keywords', '关键词', '多关键词之间用空格或者“,”隔开', '', 0, 100, '', '', 'keyword', 'null', '', '-99', '-99', 0, 1, 0, 1, 1, 1, 1, 0, 7, 0, 0),
(250, 25, 1, 'description', '摘要', '', '', 0, 255, '', '摘要不得多于255个字符', 'textarea', '{"width":"80","height":"80","defaultvalue":"","enablehtml":"0"}', '', '', '', 0, 1, 0, 1, 0, 1, 1, 1, 10, 0, 0),
(251, 25, 1, 'updatetime', '更新时间', '', '', 0, 0, '', '', 'datetime', 'array (\r\n  ''dateformat'' => ''int'',\r\n  ''format'' => ''Y-m-d H:i:s'',\r\n  ''defaulttype'' => ''1'',\r\n  ''defaultvalue'' => '''',\r\n)', '', '', '', 1, 1, 0, 1, 0, 0, 0, 0, 12, 0, 0),
(252, 25, 1, 'content', '内容', '', '', 1, 999999, '', '内容不能为空', 'editor', '{"toolbar":"full","defaultvalue":"","enablekeylink":"0","replacenum":"","link_mode":"0","enablesaveimage":"0","height":"480","disabled_page":"0"}', '', '', '', 0, 0, 0, 1, 0, 1, 1, 0, 11, 0, 0),
(253, 25, 1, 'thumb', '缩略图', '', '', 0, 100, '', '', 'image', '{"size":"100","defaultvalue":"","show_type":"0","upload_maxsize":"","upload_allowext":"","watermark":"0","isselectimage":"0","images_width":"","images_height":""}', '', '', '', 0, 1, 0, 1, 0, 1, 0, 1, 8, 0, 0),
(256, 25, 1, 'inputtime', '发布时间', '', '', 0, 0, '', '', 'datetime', 'array (\n  ''fieldtype'' => ''int'',\n  ''format'' => ''Y-m-d H:i:s'',\n  ''defaulttype'' => ''0'',\n)', '', '', '', 0, 1, 0, 0, 0, 0, 0, 1, 17, 0, 0),
(257, 25, 1, 'posids', '推荐位', '', '', 0, 0, '', '', 'posid', '{"width":"","defaultvalue":""}', '', '', '', 0, 1, 0, 1, 0, 0, 0, 0, 18, 0, 0),
(259, 25, 1, 'url', 'URL', '', '', 0, 100, '', '', 'text', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 0, 50, 0, 0),
(260, 25, 1, 'listorder', '排序', '', '', 0, 6, '', '', 'number', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 0, 51, 0, 0),
(261, 25, 1, 'template', '内容页模板', '', '', 0, 30, '', '', 'template', 'array (\n  ''size'' => '''',\n  ''defaultvalue'' => '''',\n)', '', '-99', '-99', 0, 0, 0, 0, 0, 0, 0, 0, 53, 0, 0),
(263, 25, 1, 'status', '状态', '', '', 0, 2, '', '', 'box', '{"boxtype":"radio"}', '', '', '', 1, 1, 0, 1, 0, 0, 0, 0, 55, 0, 0),
(265, 25, 1, 'username', '用户名', '', '', 0, 20, '', '', 'text', '', '', '', '', 1, 1, 0, 1, 0, 0, 0, 0, 98, 0, 0),
(288, 25, 1, 'readpoint', '阅读收费', '', '', 0, 0, '', '', 'readpoint', 'array (\r\n  ''minnumber'' => ''1'',\r\n  ''maxnumber'' => ''99999'',\r\n  ''decimaldigits'' => ''0'',\r\n  ''defaultvalue'' => '''',\r\n)', '', '-99', '-99', 0, 0, 0, 1, 0, 0, 0, 0, 55, 0, 0);

-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_news`
--

DROP TABLE IF EXISTS `xgcms_xgcms_news`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_news` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `catid` int(10) unsigned NOT NULL default '0',
  `typeid` smallint(5) unsigned NOT NULL default '0',
  `title` char(80) NOT NULL default '',
  `style` char(24) NOT NULL default '',
  `thumb` char(100) NOT NULL default '',
  `keywords` char(100) NOT NULL default '',
  `description` mediumtext NOT NULL,
  `posids` tinyint(3) unsigned NOT NULL default '0',
  `pagenum` tinyint(2) unsigned NOT NULL default '1',
  `url` char(100) NOT NULL,
  `listorder` tinyint(3) unsigned NOT NULL default '0',
  `status` tinyint(2) unsigned NOT NULL default '1',
  `sysadd` tinyint(1) unsigned NOT NULL default '0',
  `username` char(20) NOT NULL default '',
  `inputtime` int(10) unsigned NOT NULL default '0',
  `updatetime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `status` (`status`,`listorder`,`id`),
  KEY `listorder` (`catid`,`status`,`listorder`,`id`),
  KEY `id` (`id`,`catid`),
  KEY `catid` (`catid`,`status`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `xgcms_xgcms_news`
--


-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_news_data`
--

DROP TABLE IF EXISTS `xgcms_xgcms_news_data`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_news_data` (
  `id` mediumint(8) unsigned default '0',
  `content` mediumtext NOT NULL,
  `paginationtype` tinyint(1) NOT NULL,
  `maxcharperpage` mediumint(6) NOT NULL,
  `template` varchar(30) NOT NULL,
  `paytype` tinyint(1) unsigned NOT NULL default '0',
  `voteid` mediumint(8) unsigned NOT NULL default '0',
  `copyfrom` varchar(100) NOT NULL default '',
  `readpoint` smallint(5) unsigned NOT NULL default '0',
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `xgcms_xgcms_news_data`
--


-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_pos`
--

DROP TABLE IF EXISTS `xgcms_xgcms_pos`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_pos` (
  `posid` smallint(5) unsigned NOT NULL auto_increment,
  `modelid` smallint(5) unsigned default '0',
  `catid` smallint(5) unsigned default '0',
  `name` char(30) NOT NULL default '',
  `maxnum` smallint(5) NOT NULL default '20',
  `extention` char(100) default NULL,
  `listorder` smallint(5) unsigned NOT NULL default '0',
  `thumb` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`posid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=18 ;

--
-- 转存表中的数据 `xgcms_xgcms_pos`
--

INSERT INTO `xgcms_xgcms_pos` (`posid`, `modelid`, `catid`, `name`, `maxnum`, `extention`, `listorder`, `thumb`) VALUES
(1, 0, 0, '首页焦点图推荐', 20, '', 100, ''),
(9, 0, 0, '首页右侧推荐', 20, '', 90, ''),
(10, 0, 0, '栏目封面右侧推荐', 20, '', 60, ''),
(12, 0, 0, '内容页右侧推荐', 20, '', 50, ''),
(15, 25, 0, '栏目列表右侧推荐', 260, '', 50, '');

-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_pos_data`
--

DROP TABLE IF EXISTS `xgcms_xgcms_pos_data`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_pos_data` (
  `pid` mediumint(8) NOT NULL auto_increment,
  `id` mediumint(8) unsigned NOT NULL default '0',
  `catid` smallint(5) unsigned NOT NULL default '0',
  `posid` smallint(5) unsigned NOT NULL default '0',
  `module` char(20) default NULL,
  `modelid` smallint(6) unsigned default '0',
  `thumb` tinyint(1) NOT NULL default '0',
  `data` mediumtext,
  `listorder` mediumint(8) default '0',
  `expiration` int(10) NOT NULL,
  `extention` char(30) default NULL,
  `synedit` tinyint(1) default '0',
  PRIMARY KEY  (`pid`),
  KEY `posid` (`posid`),
  KEY `listorder` (`listorder`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `xgcms_xgcms_pos_data`
--


-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_search`
--

DROP TABLE IF EXISTS `xgcms_xgcms_search`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_search` (
  `searchid` int(10) unsigned NOT NULL auto_increment,
  `typeid` smallint(5) unsigned NOT NULL default '0',
  `modelid` smallint(3) NOT NULL default '0',
  `catid` mediumint(8) NOT NULL default '0',
  `id` mediumint(8) unsigned NOT NULL default '0',
  `adddate` int(10) unsigned NOT NULL,
  `data` text NOT NULL,
  `siteid` smallint(5) unsigned NOT NULL default '1',
  PRIMARY KEY  (`searchid`),
  KEY `typeid` (`typeid`,`id`),
  KEY `siteid` (`siteid`),
  KEY `catid` (`catid`,`id`),
  KEY `adddate` (`adddate`),
  FULLTEXT KEY `data` (`data`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `xgcms_xgcms_search`
--


-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_search_keyword`
--

DROP TABLE IF EXISTS `xgcms_xgcms_search_keyword`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_search_keyword` (
  `keyword` char(20) NOT NULL,
  `searchnum` int(10) NOT NULL,
  `data` text NOT NULL,
  `expiry` int(10) NOT NULL default '0',
  UNIQUE KEY `keyword` (`keyword`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `xgcms_xgcms_search_keyword`
--


-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_type`
--

DROP TABLE IF EXISTS `xgcms_xgcms_type`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_type` (
  `typeid` smallint(5) unsigned NOT NULL auto_increment,
  `siteid` smallint(5) unsigned NOT NULL default '0',
  `module` char(15) NOT NULL,
  `modelid` smallint(5) unsigned NOT NULL default '0',
  `name` char(30) NOT NULL,
  `parentid` smallint(5) unsigned NOT NULL default '0',
  `typedir` char(20) NOT NULL,
  `url` char(100) NOT NULL,
  `template` char(30) NOT NULL,
  `listorder` smallint(5) unsigned NOT NULL default '0',
  `description` varchar(255) NOT NULL,
  PRIMARY KEY  (`typeid`),
  KEY `module` (`module`,`parentid`,`siteid`,`listorder`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `xgcms_xgcms_type`
--


-- --------------------------------------------------------

--
-- 表的结构 `xgcms_xgcms_views`
--

DROP TABLE IF EXISTS `xgcms_xgcms_views`;
CREATE TABLE IF NOT EXISTS `xgcms_xgcms_views` (
  `viewsid` char(30) NOT NULL,
  `catid` smallint(5) unsigned NOT NULL default '0',
  `views` int(10) unsigned NOT NULL default '0',
  `yesterdayviews` int(10) unsigned NOT NULL default '0',
  `dayviews` int(10) unsigned NOT NULL default '0',
  `weekviews` int(10) unsigned NOT NULL default '0',
  `monthviews` int(10) unsigned NOT NULL default '0',
  `updatetime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`viewsid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `xgcms_xgcms_views`
--

