<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

class common_control extends base_control {
	
	// 为了避免与 model 冲突，加下划线分开
	public $_sid = '';		// session id
	public $_user = array();	// 全局 user
	public $_group = array();	// 全局 group, 包含用户权限
	
	// header 相关
	public $_title = array();	// header.htm title
	public $_nav = array();		// header.htm 导航
	public $_seo_keywords = '';	// header.htm keywords
	public $_seo_description = '';	// header.htm description
	public $_checked = array();	// 选中状态
	
	// 计划任务
	protected $_cron_1_run = 0;	// 计划任务1 是否被激活, 15 分钟执行一次
	protected $_cron_2_run = 0;	// 计划任务2 是否被激活, 每天0点执行一次
	
	// hook common_control_before.php
	
	// 初始化 _sid, _user, _title, _nav
	function __construct(&$conf) {
		// hook common_control_construct_before.php
		parent::__construct($conf);
		// hook common_control_construct_after.php
		
		$this->init_conf();
		$this->init_ip();
		$this->init_timezone();
		$this->init_view();
		$this->init_sid();
		$this->init_user();
		$this->init_group();
		$this->check_domain();
		//$this->init_cron();
		
		// hook common_control_init_after.php
	}
	
	// PHP 规定析构函数中不能抛出异常！保证此函数高度可用！这个析构函数最先执行，这里 db 未释放。
	function __destruct() {
		// $db 有可能比这两个 model 实例更早析构！
		if(isset($this->runtime)) {
			$this->runtime->save_changed();
		}
		if(isset($this->kv)) {
			$this->kv->save_changed();
		}
		
		if(DEBUG > 1 && !empty($_SERVER['trace'])) {
			//restore_exception_handler();
			//restore_error_handler();
			log::trace_save();
		}
	}
	
	private function init_conf() {
		$runtime = $this->runtime->xget();
		$this->conf += $runtime; // view_path 占位，保留了 conf.view_path
		
		// 优先扫描 runtime 中的 view_path
		isset($runtime['view_path']) && $this->conf['view_path'] = array_merge($runtime['view_path'], $this->conf['view_path']);

		// hook common_control_init_runtime_after.php
	}
	
	private function init_ip() {
		// 通过代理发送的头获取用户真实IP
		if(!empty($this->conf['cdn_ip']) && in_array($_SERVER['ip'], $this->conf['cdn_ip'])) {
			$realip = core::gpc('HTTP_X_FORWARDED_FOR', 'S');
			empty($realip) && $realip = core::gpc('HTTP_CLIENT_IP', 'S');
			if(preg_match('#^\d+(\.\d+){3}$#', $realip)) {
				$_SERVER['ip'] = $realip;
			}
		}
		
		// hook common_control_init_ip_after.php
	}
	
	private function init_timezone() {
		
		// 第一次访问，默认为系统所在时区。以后为用户所在时区。
		if(!isset($_COOKIE['timeoffset'])) {
			$timeoffset = $this->conf['timeoffset'];
		} else {
			$timeoffset = misc::mid(intval($_COOKIE['timeoffset']), -12, 12);
			$timeoffset = sprintf('%+d', $timeoffset);
		}
		$timeoffset2 = $timeoffset;
		$timeoffset2[0] = $timeoffset[0] == '+' ? '-' : '+';
		date_default_timezone_set('Etc/GMT'.$timeoffset2);	// 覆盖掉框架设置的默认值
		$_SERVER['timeoffset'] = $timeoffset;
		
		// 今日凌晨0点的开始时间！
		$_SERVER['time_fmt'] = date('Y-n-d H:i', $_SERVER['time']);			// +8 hours
		$arr = explode(' ', $_SERVER['time_fmt']);
		list($y, $n, $d) = explode('-', $arr[0]);
		$_SERVER['time_today'] = mktime(0, 0, 0, $n, $d, $y);	// -8 hours
		// hook common_control_init_timezone_after.php
	}
	
	private function init_view() {
		$fid = intval(core::gpc('fid'));
		$this->_checked['forum_'.$fid] = ' class="checked"';
		$this->view->assign('conf', $this->conf);
		$this->view->assign('_title', $this->_title);
		$this->view->assign('_nav', $this->_nav);
		$this->view->assign('_seo_keywords', $this->_seo_keywords);
		$this->view->assign('_seo_description', $this->_seo_description);
		$this->view->assign('_checked', $this->_checked);
		$this->view->assign('_cron_1_run', $this->_cron_1_run);
		
		// hook common_control_init_view_after.php
	}
	
	// 初始化 sid
	private function init_sid() {
		$key = $this->conf['cookie_pre'].'sid';
		$sid = core::gpc($key, 'R');
		if(!$sid) {
			$sid = substr(md5($_SERVER['REMOTE_ADDR'].rand(1, 2147483647)), 0, 16); // 兼容32,64位
			misc::setcookie($key, $sid, $_SERVER['time'] + 86400 * 30, $this->conf['cookie_path'], $this->conf['cookie_domain']);
		}
		$this->_sid = $sid;
		$this->view->assign('_sid', $this->_sid);
		
		define('FORM_HASH', misc::form_hash($this->conf['auth_key']));
		
		// hook common_control_init_sid_after.php
	}
	
	// 初始化 _user, 解密 cookie
	private function init_user() {
		$auth = core::gpc($this->conf['cookie_pre'].'auth', 'R');
		$this->view->assign('_auth', $auth);
		
		$this->_user = $this->user->decrypt_auth($auth);

		$this->view->assign('_user', $this->_user);
		
		$this->_group = $this->group->read($this->_user['groupid']);
		$this->view->assign('_group', $this->_group);
		
		// 如果管理员超出一天，IP地址发生变化，则提示重新登录，每天必须强行登陆一次。
		if($this->_user['groupid'] == 1 && $_SERVER['time'] - $this->_user['cookietime'] > 86400 && !$this->_user['ip_right']) {
			misc::setcookie($this->conf['cookie_pre'].'auth', '', 0, $this->conf['cookie_path'], $this->conf['cookie_domain']);
			$this->message('尊敬的管理员，系统检测到您的IP发生变化，为了您的安全，请重新登录。<script>setTimeout("window.location.reload()", 2000);</script>', 0);
		}
		$this->_user['groupname'] = $this->_group['name'];
		
		// hook common_control_init_user_after.php
	}

	// 初始化用户组相关数据
	private function init_group() {
	
		//$groupid = $this->_user['groupid'];
		// hook common_control_init_group_after.php
	}
	
	// 检查域名，如果不在安装域名下，跳转到安装域名。
	private function check_domain() {
		$appurl = $this->conf['app_url'];
		preg_match('#^https?://([^/]+)/#', $appurl, $m);
		$installhost = $m[1];
		$host = core::gpc('HTTP_HOST', 'S');
		if($host != $m[1]) {
			$currurl = misc::get_script_uri();
			$newurl = preg_replace('#^https?://([^/]+)/#', "http://$installhost/", $currurl);
			header("Location: $newurl");
			exit;
		}
		
		/* 
			/bbs/index.php?user-login.htm
			/bbs/index.php?
			/bbs/index.php
			/index.php
			/
			/?
		 */
		// 兼容 iis
		$pos = strrpos($_SERVER['REQUEST_URI'], '/');
		if(substr($_SERVER['REQUEST_URI'], $pos + 1, 9) == 'index.php') {
			$_SERVER['REQUEST_URI'] = substr_replace($_SERVER['REQUEST_URI'], '', $pos + 1, 9);
		}
		
		// 判断是否开启了 urlrewrite
		if($this->conf['urlrewrite']) {
			// 查找最后一个 /
			if(substr($_SERVER['REQUEST_URI'], $pos + 1, 1) == '?') {
				// 去掉 ?
				$_SERVER['REQUEST_URI'] = substr($_SERVER['REQUEST_URI'], 0, $pos + 1).substr($_SERVER['REQUEST_URI'], $pos + 2);
				$newurl = misc::get_script_uri();
				header("Location: $newurl");
				exit;
			}
		} else {
			// 垃圾的 iis 某些情况下, 居然在请求 / 时候，REQUEST_URI 为 /Index.php，第一个字母还大写！iis, go to hell!
			/*
			if($pos + 1 != strlen($_SERVER['REQUEST_URI']) && substr($_SERVER['REQUEST_URI'], $pos + 1, 1) != '?' && strtolower(substr($_SERVER['REQUEST_URI'], -10)) != '/index.php') {
				// 加上 ?
				$_SERVER['REQUEST_URI'] = substr($_SERVER['REQUEST_URI'], 0, $pos + 1).'?'.substr($_SERVER['REQUEST_URI'], $pos + 1);
				$newurl = misc::get_script_uri();
				header("Location: $newurl");
				exit;
			}
			*/
		}
	}
	
	public function check_ip() {
		$ip = $_SERVER['ip'];
		if(($this->_user['groupid'] == 0 || $this->_user['groupid'] > 4) && $this->conf['iptable_on']) {
			if($this->banip->is_banip($ip)) {
				$this->message("您的IP $ip 已经被禁止，如果有疑问，请联系管理员。", 0);
			}
		}
	}
	
	/*
	 * 功  能：
	 * 	提示单条信息
	 *  
	 * 用  法：
		 $this->message('站点维护中，请稍后访问！');
		$this->message('提交成功！', TRUE, '?forum-index-123.htm');
		$this->message('校验错误！', FALSE);
	 */
	public function message($message, $status = 1, $goto = '') {
		
		// hook common_control_message_before.php
		
		if(core::gpc('ajax', 'R')) {
			// 可能为窗口，也可能不为。
			$json = array('servererror'=>'', 'status'=>$status, 'message'=>$message);
			echo core::json_encode($json);
			exit;
		} else {
			$this->view->assign('message', $message);
			$this->view->assign('status', $status);
			$this->view->assign('goto', $goto);
			$this->view->display('message.htm');
			exit;
		}
	}
	
	// relocation
	public function url($url) {
		$url[0] == '?' && $url = substr($url, 1);
		return $this->conf['app_url'].($this->conf['urlrewrite'] ? '' : '?').$url;
	}
	
	// relocation
	public function location($url) {
		header("Location: ".$url);
		exit;
	}
	
	public function form_submit() {
		// hook form_submit_after.php
		// hook common_form_hash.php
		return misc::form_submit($this->conf['auth_key']);
	}
	
	protected function clear_tmp($pre = '') {
		$len = strlen($pre);
		$dh = opendir($this->conf['tmp_path']);
		while(($file = readdir($dh)) !== FALSE ) {
			if($file != "." && $file != ".." && $file[0] != '.') {
				if(empty($pre) || substr($file, 0, $len) == $pre) {
					$filename = $this->conf['tmp_path']."$file";
					is_file($filename) && unlink($filename);
				}
			}
		}
		closedir($dh);
	}
	
	
}

// hook common_control_after.php

?>