<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include APP_PATH.'control/admin_common_control.class.php';

class category_control extends admin_common_control{
    
    
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked['category']='active';
		$this->_title[]=$conf['app_name'];   
	}
	
	public function on_index(){
		$this->_checked['category_list']='active';
		$error=array();
		if($this->form_submit()) {
			// 修改
			$orderarr = core::gpc('listorder', 'P');
			//hook admin_category_index_gpc_after.php
			foreach($orderarr as $cid=>$val) {
				$cid = intval($cid);
				$cate=$this->xgcms_category->read($cid);
				$cate['listorder']=$val;
				$this->xgcms_category->update($cate);
			}
			
		}

       $list=$this->xgcms_category->get_tree_category();
	   foreach($list as &$v){
             $this->xgcms_category->format($v);

	   }
	   //hook admin_category_index_view_before.php
	   $this->view->assign('list',$list);
	   $this->view->assign('error',$error);
	   $this->view->display('category.htm');
	}
	public function on_cache(){
		$this->update_cate_cache();
		$this->mcache->clear('menu');
		$this->runtime->xupdate('catearr');
		
		//hook admin_category_cache_update_after.php
		
		$this->message('栏目缓存更新成功！');
	}
	public function on_add(){
		
        $catid=intval(core::gpc('catid','G'));
		$this->_checked['category_add']='active';
		if($this->form_submit()){
            
			$infos=$this->xgcms_content_data->new_html_special_chars(core::gpc('info','P'));
            $setting=$this->xgcms_content_data->new_html_special_chars(core::gpc('setting','P'));
			
			//hook admin_category_add_gpc_after.php
			
			$infos=$this->xgcms_category->category_fields($infos);
			$setting=$this->xgcms_category->category_fields($setting);
			
			//hook admin_category_add_fields_after.php
			
			$infos['accesson']=intval(core::gpc('accesson','P'));
			
            $error=array();
            $error['catname']=$this->xgcms_category->check_name($infos['catname']);
            $infos['type']!=2 && $error['catdir']=$this->xgcms_category->check_catdir($infos['catdir']);
            if(!array_filter($error)){
                
                $infos['setting']=core::json_encode($setting);
                $infos['module']='content';
                
                if($infos['parentid']>0){
                    $infos['arrparentid']=$this->get_arrparentid($infos['parentid']);
                }
                if($catid){
                   $infos['catid']=$catid;
                   $this->xgcms_category->update($infos); 
				   if($infos['accesson']){
					    $this->accesson($catid);
				   }
				   $this->mcache->clear('cate',$catid);
                }elseif(stripos($infos['catname'],'||')!==false){
                    $catnames=explode('||',$infos['catname']);
                    $catdirs=explode('||',$infos['catdir']);
                    
                    foreach($catnames as $k=>$name){
                        if(empty($name)) continue;
                        $infos['catname']=$name;
                        $infos['catdir']=$catdirs[$k];
						
						//hook admin_category_add_batch_create_before.php
						
                        $id=$this->xgcms_category->create($infos);
						if($id){
							$cate=$this->xgcms_category->read($id);
							$cate['url']=str_replace(array('[catid]','[catdir]'),array($id,$infos['catdir']),$cate['url']);
							$this->xgcms_category->update($cate);
							if($infos['accesson']){
					             $this->accesson($id);
				            }
						}
						
						//hook admin_category_add_batch_create_after.php
						
                    }
                }else{
					
					//hook admin_category_add_single_create_before.php
					
                    $id=$this->xgcms_category->create($infos);  
					if($id){
						$cate=$this->xgcms_category->read($id);
						$cate['url']=str_replace(array('[catid]','[catdir]'),array($id,$infos['catdir']),$cate['url']);
						$this->xgcms_category->update($cate);	
						if($infos['accesson']){
					         $this->accesson($id);
				        }
					}
					//hook admin_category_add_single_create_after.php
                }
                
                if($infos['parentid']>0){
                    $parent=$this->xgcms_category->read($infos['parentid']);
                    $parent['child']=1;
                    $parent['arrchildid']=$this->get_arrchildid($parent['catid']);
                    $this->xgcms_category->update($parent);
                }
                
                $this->update_cate_cache();
                //hook admin_category_add_after.php
            }
            $this->message($error);
		}
        $models=$this->xgcms_model->get_list(array('type'=>0));
        
        $models=misc::arrlist_key_values($models,'modelid','name');
        
		$input=array();
        
        if($catid){
            $data=$this->xgcms_category->read($catid);
            $this->xgcms_category->format($data);
        }else{
			$data=$this->xgcms_category->category_fields();
		}
		$input['catname'] = form::get_text('info[catname]',htmlspecialchars($data['catname']), 300);
		$input['type']=form::get_radio('info[type]',array('0'=>'内容','1'=>'单页面','2'=>'外链'),$data['type']);
        $input['url'] = form::get_text('info[url]', $data['url'], 500);
		$input['catdir'] = form::get_text('info[catdir]', $data['catdir'], 300);
        $input['ismenu'] = form::get_radio_yes_no('info[ismenu]',$data['ismenu']);
        $input['modelid'] = form::get_select('info[modelid]',$models,$data['modelid']);
		
        $input['ishtml'] = form::get_radio_yes_no('setting[ishtml]',$data['ishtml']);
		$input['content_ishtml'] = form::get_radio_yes_no('setting[content_ishtml]',$data['content_ishtml']);
		
        $input['url_list'] = form::get_text('setting[url_list]',isset($data['url_list'])?$data['url_list']:'', 500);
        $input['url_show'] = form::get_text('setting[url_show]', isset($data['url_show'])?$data['url_show']:'', 500);
	    $input['meta_title'] = form::get_text('setting[meta_title]', isset($data['meta_title'])?htmlspecialchars($data['meta_title']):'', 400);
	    $input['meta_keywords'] = form::get_text('setting[meta_keywords]',isset($data['meta_keywords'])?htmlspecialchars($data['meta_keywords']):'',400);
	    $input['meta_description'] = form::get_text('setting[meta_description]',isset($data['meta_description'])?htmlspecialchars($data['meta_description']):'',400);
        $input['paytype']=form::get_radio('setting[paytype]',array('0'=>'积分','1'=>'金币'),$data['paytype']);
        $cat_list=$this->xgcms_category->get_tree_category();
        $cat_list=misc::arrlist_key_values($cat_list,'catid','catname');
        $cat_list[0]='作为一级栏目';
        $input['parentid'] = form::get_select('info[parentid]', $cat_list,$data['parentid']);
		
		//模板
		 $path=APP_PATH.'../view/';
		 $category_templates=$list_templates=$show_templates=array('0'=>'模型默认');
		 foreach((array)glob($path."list*.htm") as $file) {
			$file=substr($file,strripos($file,'list'));
			$list_templates[$file]=$file;
		 }
		 foreach((array)glob($path."category*.htm") as $file) {
			$file=substr($file,strripos($file,'category'));
			$category_templates[$file]=$file;
		 }
		 foreach((array)glob($path."show*.htm") as $file) {
			$file=substr($file,strripos($file,'show'));
			$show_templates[$file]=$file;
		 }
		 $input['category_tem']=form::get_select('setting[category_template]',$category_templates,$data['category_template']);
		 $input['list_tem']=form::get_select('setting[list_template]',$list_templates,$data['list_template']);
		 $input['show_tem']=form::get_select('setting[show_template]',$show_templates,$data['show_template']);
		
		$accesson=array();
		if($catid) $accesson=$this->xgcms_category_accesson->get_by_catid($catid);
		
		//hook admin_category_index_view_before.php
	   
        $this->view->assign('input',$input);
        $this->view->assign('catid',$catid);
		$this->view->assign('cate',$data);
		$this->view->assign('accesson',$accesson);
		$this->view->display('category_add.htm');
	}
    public function on_delete(){
        $catid=intval(core::gpc('catid','G'));
        $cat=$this->xgcms_category->read($catid);
        if($cat['child']) $this->message('请先删除子栏目');
       
        $this->xgcms_category->xdelete($catid);
        $cat['type']==1 && $this->xgcms_category_page->delete($catid);
		
		$this->runtime->xupdate('catearr');
		
        $this->update_cate_cache();
		
        //hook admin_category_delete_after.php
		
        $this->message('栏目删除成功！',1,'?category.htm');   
    }
    private function accesson($catid){
		$groupids=core::gpc('groupids','P');
		$allowread=core::gpc('allowread','P');
		$allowpost=core::gpc('allowpost','P');
		
		//hook admin_category_accesson_gpc_after.php
		
		$this->xgcms_category_accesson->delete_by_catid($catid);
		
		foreach((array)$groupids as $gid){
			$arr=array(
			   'catid'=>$catid,
			   'groupid'=>intval($gid),
			   'allowread'=>isset($allowread[$gid])?intval($allowread[$gid]):0,
			   'allowpost'=>isset($allowpost[$gid])?intval($allowpost[$gid]):0,
			);
			
			//hook admin_category_accesson_create_before.php
			
			$this->xgcms_category_accesson->create($arr);
		}	
		//hook admin_category_accesson_after.php
		
	}
	
	//hook admin_category_control_after.php
}


?>