<?php

/*
* Copyright (C) xgcms.com
*/

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include APP_PATH . 'control/admin_common_control.class.php';

class content_control extends admin_common_control
{
    function __construct(&$conf)
    {
        parent::__construct($conf);
        $this->_checked['content'] = 'active';
        $this->_title[] = $conf['app_name'];
    }
    public function on_index()
    {
		//hook admin_content_index_before.php
        $catid = intval(core::gpc('catid', 'G'));
        $page = misc::page();
		$pagesize = 20;
        $start = ($page - 1) * $pagesize;
		$status=intval(core::gpc('status','G'));
        if ($catid) {
            $cate = $this->xgcms_category->read($catid);
			empty($cate) && $this->message('栏目不存在',0);
			
			//hook admin_content_index_cate_after.php
			
			if($cate['type']==1){
				$this->location('?content-page-catid-'.$catid.'.htm');
			}elseif($cate['type']==2){
				$this->location($cate['url']);
			}
            $model = $this->xgcms_model->read($cate['modelid']);
            $this->xgcms_content->table = $model['tablename'];
            $map = array('catid' => $catid);
			$count =$cate['items'];
			if($status){
			    $map['status']=$status;
				$count=intval(core::gpc('count','G'));
				empty($count) && $count=$this->xgcms_content->index_count($map);
			}
            $list = $this->xgcms_content->get_list($map, $start, $pagesize, array('id' =>-1));
			$pages = misc::pages("?content-index-catid-$catid-count-$count-status-$status.htm", $count, $page,$pagesize);
        }else{
			$cate=0;
			$list = $this->xgcms_cache->get_list('', $start, $pagesize, array('id' =>-1));
			$count=count($list);
			$pages = misc::simple_pages("?content-index-catid-$catid.htm", $count, $page,$pagesize);
		}
		foreach ($list as &$v) {
            $this->xgcms_content->format($v);
        }
		$categorys = $this->xgcms_category->get_tree_category();
		
		//hook admin_content_index_view_before.php
		
		$this->view->assign('list', $list);
        $this->view->assign('pages', $pages);
        $this->view->assign('count', $count);
        $this->view->assign('cate', $cate);
		$this->view->assign('catid', $catid);
		$this->view->assign('status', $status);
        $this->view->assign('categorys', $categorys);
        $this->view->display('content_list.htm');
    }
    
    public function on_add(){
        $this->_checked['content_add']='active';
        
        if($this->form_submit()){
            $infos=core::gpc('info','P');
            $catid=intval($infos['catid']);
            if($catid<1) $this->message('请选择栏目');
			
            //hook admin_content_add_gpc_after.php
			
            $cate=$this->mcache->read('cate',$infos['catid']);
            $this->xgcms_content->set_model($cate['modelid']);
            $infos['username']=$this->_user['username'];
            $id=$this->xgcms_content->add_content($infos,$cate);
            if(is_numeric($id)){
				//hook admin_content_add_success_after.php
                $this->message('内容添加成功！',1,'?content-add-catid-'.$infos['catid'].'.htm');
            }else{
				//hook admin_content_add_error_after.php
                $this->message('添加失败：'.$id);
            }
    
        }
        $catid=intval(core::gpc('catid','G'));
        $cate=$this->xgcms_category->read($catid);
		
		$categorys = $this->xgcms_category->get_tree_category();

		if(empty($cate)){
			$this->view->assign('categorys', $categorys);
			$this->view->display('content_add_catid.htm');
			exit;
		}
        $modelid=$cate['modelid'];
        
        $this->xgcms_content->set_model($modelid);
		$data=array();
        
        $cate_con=$this->xgcms_category->get_list(array('type'=>0));
        $type_data=$this->xgcms_type->get_list(array('module'=>'content'));
        
        $fields=$this->xgcms_model_field->get_list(array('modelid'=>$modelid));
        misc::arrlist_change_key($fields,'field');
        
        require MODEL_LIB_PATH.'xgform.class.php';
        require MODEL_LIB_PATH.'content_form.class.php';
		
		$poss=$this->xgcms_pos->get_list();
		foreach($poss as $pk=>$pv){
			if(($pv['modelid']>0&&$pv['modelid']!=$modelid)||($pv['catid']>0&&$pv['catid']!=$catid)) unset($poss[$pk]);
		}
		$poss=misc::arrlist_key_values($poss,'posid','name');
		
		$content_form = new content_form($modelid,$catid,$cate_con,$fields,$type_data,$poss);
		$forminfos = $content_form->get($data);    

        //hook admin_content_add_view_before.php

        $this->view->assign('categorys', $categorys);
        $this->view->assign('cate', $cate);
        $this->view->assign('catid', $catid);
        $this->view->assign('forminfos', $forminfos);
        $this->view->display('content_add.htm');  
    }
	public function on_edit(){
		$this->_checked['content_add']='active';
        $id=intval(core::gpc('id','G'));
        if($this->form_submit()){
            $infos=core::gpc('info','P');
            $catid=intval($infos['catid']);
            if($catid<1) $this->message('请选择栏目');
			
            //hook admin_content_edit_gpc_after.php
			
            $cate=$this->mcache->read('cate',$infos['catid']);
            
            $this->xgcms_content->set_model($cate['modelid']);
            $rs=$this->xgcms_content->edit_content($id,$infos,$cate);
            if($rs===true){
				
				//hook admin_content_edit_success_after.php
				
                $this->message('内容编辑成功！',1,'?content-index-catid-'.$infos['catid'].'.htm');
            }else{
				
				//hook admin_content_edit_error_after.php
				
                $this->message('内容编辑失败：'.$rs);
            }
    
        }
        $catid=intval(core::gpc('catid','G'));
		
        $cate=$this->mcache->read('cate',$catid);
		
        $modelid=$cate['modelid'];

        $this->xgcms_content->set_model($modelid);
        $data=$this->xgcms_content->xread($catid,$id);
        
        $categorys = $this->xgcms_category->get_tree_category();
        $cate_con=$this->xgcms_category->get_list(array('type'=>0));
        $type_data=$this->xgcms_type->get_list(array('module'=>'content'));
        
        $fields=$this->xgcms_model_field->get_list(array('modelid'=>$modelid));
        misc::arrlist_change_key($fields,'field');
        
        require MODEL_LIB_PATH.'xgform.class.php';
        require MODEL_LIB_PATH.'content_form.class.php';
		$poss=$this->xgcms_pos->get_list();
		foreach($poss as $pk=>$pv){
			if(($pv['modelid']>0&&$pv['modelid']!=$modelid)||($pv['catid']>0&&$pv['catid']!=$catid)) unset($poss[$pk]);
		}
		$poss=misc::arrlist_key_values($poss,'posid','name');
		$content_form = new content_form($modelid,$catid,$cate_con,$fields,$type_data,$poss);
		if($data['posids']){
			$data['posids']=$this->xgcms_pos_data->get_posid_by_id($data['id']);	
			$data['posids']=implode(',',$data['posids']);
		}
		$forminfos = $content_form->get($data);         
        
		//hook admin_content_edit_view_before.php
		
        $this->view->assign('categorys', $categorys);
        $this->view->assign('cate', $cate);
        $this->view->assign('catid', $catid);
		$this->view->assign('id', $id);
        $this->view->assign('forminfos', $forminfos);
        $this->view->display('content_edit.htm'); 
	}
	public function on_page(){
		$catid=intval(core::gpc('catid','G'));
		
		//hook admin_content_page_gpc_after.php
		
		$cate=$this->mcache->read('cate',$catid);
		$cate_data=$this->xgcms_category_page->read($catid);
		
		if($this->form_submit()){
			$content=core::gpc('content','P');
			//hook admin_content_page_submit_gpc_after.php
			$content=$this->xgcms_content->html_safe($content);
            if($cate_data){
				$cate_data['content']=$content;
				
				//hook admin_content_page_data_update_before.php
				
				$this->xgcms_category_page->update($cate_data);
			}else{
				$data=array('catid'=>$catid,
				             'content'=>$content,
							 'updatetime'=>$_SERVER['time'],
				
				);
				
				//hook admin_content_page_data_create_before.php
				
				$this->xgcms_category_page->create($data);
			}
			$this->message('更新成功！');
		}
		$cate_data && $cate=array_merge($cate,$cate_data);
		$categorys = $this->xgcms_category->get_tree_category();
		
		//hook admin_content_page_view_before.php
		
		$this->view->assign('categorys', $categorys);
		$this->view->assign('cate',$cate);
		$this->view->assign('catid',$catid);
		$this->view->display('content_page.htm');
	}
	
    public function on_delete()
    {
        $ids=core::gpc('ids','P');
        foreach((array)$ids as $catidid){
             list($catid,$id)=explode('-',$catidid);
             $catid=intval($catid);
			 $id=intval($id);
             $cate=$this->xgcms_category->read($catid);
             if(!$cate) continue;
             $this->xgcms_content->set_model($cate['modelid']);
			 
			 //hook admin_content_delete_before.php
			 
             $this->xgcms_content->xdelete($cate,$id);
			
        }
		
		//hook admin_content_delete_after.php
		
        $this->message('删除成功！',1,'?content-index-catid-'.$catid.'.htm');
    }
    public function on_audit(){
		//hook admin_content_audit_before.php
		$ids=core::gpc('ids','P');
		$status=intval(core::gpc('status','G'));
		foreach((array)$ids as $cid){
			list($catid,$id)=explode('-',$cid);
            $catid=intval($catid);
			$id=intval($id);
            $cate=$this->mcache->read('cate',$catid);
            if(!$cate) continue;
            $this->xgcms_content->set_model($cate['modelid']);
			$info=$this->xgcms_content->read($catid,$id);
			$info['status']=$status;
			$this->xgcms_content->update($info);
			if($status==2){
				$this->xgcms_html->delete_show_html($id,$cate,$info['inputtime'],$info['pagenum']);
			}elseif($status==99){
				 $info['modelid']=$cate['modelid'];
                 $this->xgcms_search->add_index($info);
                 $this->xgcms_cache->xupdate($info);
				 if($cate['content_ishtml']) $this->xgcms_html->build_show_html_by_url($id,$cate,$info['inputtime'],$info['pagenum']);
			}
		}
		//hook admin_content_audit_after.php
		$this->message('操作成功',1,'?content-index-catid-'.$catid.'.htm');
	}
	public function on_pos(){
		//hook admin_content_pos_before.php
		$this->_checked['content_pos']=1;
		
		$list=$this->xgcms_pos->get_list();
		
		if($this->form_submit()){
		// 修改
			$orderarr = core::gpc('listorder', 'P');
			foreach($orderarr as $posid=>$val) {
				$posid = intval($posid);
				if($list[$posid]){
				    $list[$posid]['listorder']=$val;
				    $this->xgcms_pos->update($list[$posid]);
				}
			}
		}
		
		foreach($list as  &$pos){
			$this->xgcms_pos->format($pos);
			
		}
		$categorys = $this->xgcms_category->get_tree_category();
		
		//hook admin_content_pos_after.php
		
		$this->view->assign('categorys', $categorys);
		$this->view->assign('list',$list);
		$this->view->display('content_pos.htm');
		
	}
	public function on_pos_manage(){
		$a=core::gpc('a','G');
		$posid=intval(core::gpc('posid','G'));
	    $pos=$this->xgcms_pos->read($posid);
		
		//hook admin_content_pos_manage_switch_before.php
		
		switch($a){
			case 'add':
			     //hook admin_content_pos_manage_add_before.php
				 $input=array();
				 $models=$this->xgcms_model->get_list(array('type'=>0));
                 $models=misc::arrlist_key_values($models,'modelid','name');
				 $models[0]='全部模型';
				 $cat_list=$this->xgcms_category->get_tree_category();
				 $cat_list=misc::arrlist_key_values($cat_list,'catid','catname');
				 $cat_list[0]='所有栏目';
				 
				 $input['catid'] = form::get_select('info[catid]', $cat_list,isset($pos['catid'])?$pos['catid']:0);
				 $input['modelid'] = form::get_select('info[modelid]',$models,isset($pos['modelid'])?$pos['modelid']:0);
				 //hook admin_content_pos_manage_add_view_before.php
				 $this->view->assign('pos',$pos);
				 $this->view->assign('input',$input);
			     $this->view->display('content_pos_add_ajax.htm');
			break;
			case 'add_submit':
			     if($this->form_submit()){
					 //hook admin_content_pos_manage_add_submit_before.php
					 $error=array();
					 $infos=core::gpc('info','P');
					 $infos=$this->xgcms_content_data->new_html_special_chars($infos);
					 $arr=array(
					     'name'=>$infos['name'],
						 'modelid'=>intval($infos['modelid']),
						 'catid'=>intval($infos['catid']),
						 'maxnum'=>intval($infos['maxnum']),
						 'listorder'=>intval($infos['listorder'])
					 );
					 if($pos){
					    $pos=array_merge($pos,$arr);
					    $this->xgcms_pos->update($pos);
					 }else{
						 $this->xgcms_pos->create($arr);
					 }
					 //hook admin_content_pos_manage_add_submit_after.php
					 $this->message('操作成功！');
				 }
			
			break;
			case 'delete':
			    //hook admin_content_pos_manage_delete_before.php
			    empty($pos) && $this->message('出错了！');
			    $this->xgcms_pos->xdelete($posid);
				$this->location('?content-pos.htm');
			break;
			case 'infos':
			   $this->_checked['content_pos']=1;
			   empty($pos) && $this->message('出错了！');
			   
               //hook admin_content_pos_manage_infos_before.php
			   
			   if($this->form_submit()){
				// 修改
					$orderarr = core::gpc('listorder', 'P');
					foreach($orderarr as $pid=>$val) {
						$pid = intval($pid);
						$rs=$this->xgcms_pos_data->read($pid);
						if($rs){
							$rs['listorder']=$val;
							$this->xgcms_pos_data->update($rs);
						}
					}
				}
			   $page=misc::page();
			   $start=($page-1)*20;
			   $list=$this->xgcms_pos_data->get_list(array('posid'=>$posid),$start,20,array('listorder'=>-1,'id'=>-1));
			   foreach($list as &$v){
				   $this->xgcms_content->format($v);
			   }
			   $pages=misc::simple_pages('?content-pos_manage-a-infos-posid-'.$posid.'.htm',count($list),$page,20);
			   
			   $categorys = $this->xgcms_category->get_tree_category();
			   
			   //hook admin_content_pos_manage_infos_view_before.php
			   
		       $this->view->assign('categorys', $categorys);
			   $this->view->assign('page',$page);
			   $this->view->assign('pages',$pages);
			   $this->view->assign('list',$list);
			   $this->view->assign('pos',$pos);
			   $this->view->display('content_pos_infos.htm');
			
			break;
			case 'add_info':
			   $tidarr = $this->get_tidarr();
			   if(!$this->form_submit()) {
				   
				    //hook admin_content_pos_manage_add_info_nosubmit_before.php
					
					$poss=$this->xgcms_pos->get_list();
					$this->view->assign('poss',$poss);
					$this->view->display('content_pos_add_info_ajax.htm');
			   }else{
				   $posids=core::gpc('posids','P');
				    //hook admin_content_pos_manage_add_info_submit_before.php
				   foreach((array)$posids as $posid){
					   $pos=$this->xgcms_pos->read(intval($posid));
					   if($pos){
						   foreach($tidarr as $t){
							   list($catid,$id)=explode('-',$t);
							   $catid=intval($catid);
							   $id=intval($id);
							   $cate=$this->mcache->read('cate',$catid);
							   if($cate){
								   if(($pos['modelid']&&$pos['modeid']!=$cate['modelid'])||($pos['catid']&&$pos['catid']!=$cate['catid'])) continue;
								   $this->xgcms_content->set_model($cate['modelid']);
							       $data=$this->xgcms_content->read($catid,$id);
								   if($data){
									    $this->xgcms_pos_data->xcreate($data,$posid,$cate['modelid'],$pos['maxnum']);
										$data['posids']++;
										$this->xgcms_content->update($data);
								   }
							   }
						   }   
					   }	   
				   }
				   //hook admin_content_pos_manage_add_info_submit_after.php
				   $this->message('推送成功');
			   }
			
			break;
			case 'infos_delete':
			     //hook admin_content_pos_manage_infos_delete_before.php
			     $ids=core::gpc('ids','P');
				 foreach((array)$ids as $id){
					 $rs=$this->xgcms_pos_data->read(intval($id));
					 if($rs){
						  $cate=$this->mcache->read('cate',$rs['catid']);
						  if($cate){
							  $this->xgcms_content->set_model($cate['modelid']);
							  $data=$this->xgcms_content->read($cate['catid'],$rs['id']);
							  if($data){
								  $data['posids']--;
								  $data['posids']=max(0,$data['posids']);
								  $this->xgcms_content->update($data);
							  } 
							  $this->xgcms_pos_data->delete($id);
						  }
					 }
			     }
				 //hook admin_content_pos_manage_infos_delete_after.php
				 $this->location('?content-pos_manage-a-infos-posid-'.$posid.'.htm');
			break;
		}
		
		
	}
	// 传递 tid
	private function get_tidarr() {
		$tidarr = (array)core::gpc('tidarr');
		$tidsurl = '';
		foreach($tidarr as $fid_tid) {$tidsurl .= '&tidarr[]='.$fid_tid;}
		$threads = count($tidarr);
		$this->view->assign('tidsurl', $tidsurl);
		$this->view->assign('threads', $threads);
		return $tidarr;
	}
    public function on_check_title(){
		$catid=intval(core::gpc('catid','G'));
		$cate=$this->mcache->read('cate',$catid);
		empty($cate) && $this->message('栏目不存在',0);
		
		
		$title=core::gpc('title','P');
		$len=intval(core::gpc('len','P'));
		if(utf8::strlen($title)>$len){
			$this->message('<span class="red">标题长度不得超过'.$len.'个字符</span>',0);	
		}
		$title=misc::safe_str($title);
		$rs=$this->xgcms_search->get_one(array('data'=>array('LIKE'=>$title)));
		if($rs){
			$this->xgcms_content->set_model($rs['modelid']);
			$data=$this->xgcms_content->read($rs['catid'],$rs['id']);
			$this->message('近似文章：<a href="'.$data['url'].'" target="_blank" class="red">'.$data['title'].'</a>',0);
		}else{
			$this->message('标题通过检测');
		}
	}
	//hook admin_content_control_after.php
}


?>