<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include APP_PATH.'control/admin_common_control.class.php';

class html_control extends admin_common_control{
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked['html']='active';
		$this->_title[]=$conf['app_name'];   
	}
	public function on_index(){
		//hook admin_html_index_before.php
        $this->_checked['html_index']=1;
        $categorys = $this->xgcms_category->get_tree_category();
		
        $last_list=$this->runtime->get('html_list');
		if($last_list&&core::gpc('continue','G')=='list'){
			$gourl=$this->conf['cms_url'].'?html_list-create.'.'htm';
			$this->view->assign('gourl',$gourl);
			$this->view->display('html_run.htm');
		}
		$last_show=$this->runtime->get('html_show');
		if($last_show&&core::gpc('continue','G')=='show'){
			$gourl=$this->conf['cms_url'].'?html_show-create.'.'htm';
			$this->view->assign('gourl',$gourl);
			$this->view->display('html_run.htm');
		}
		
        if($this->form_submit()){
            $type=core::gpc('type','G');
            if(!in_array($type,array('list','show'))) $this->message('出错了！');
            
            $catids=core::gpc('catids','P');
            $startid=intval(core::gpc('startid','P'));
            $endid=intval(core::gpc('endid','P'));
            $pernum=min(1000,intval(core::gpc('pernum','P')));
			$lastnum=intval(core::gpc('lastnum','P'));
			$method=core::gpc('method','P');
			$method && !in_array($method,array('all','last','id')) && $this->message('出错了！');
			
            if(empty($catids)){
                $this->message('请选择栏目！'); 
            }elseif(in_array('all',$catids)){
                $catarr=array();
                foreach($categorys as $c){
					$this->xgcms_category->format($c);
					if($type=='list'){
                       if($c['type']<2&&$c['ishtml'])  $catarr[$c['catid']]=$c['catid'];
					} else{
					   if($c['type']<2&&$c['content_ishtml'])  $catarr[$c['catid']]=$c['catid'];
					}
                }
            }else{
                $catarr=$catids;
            }
            $catid=array_pop($catarr);
            $this->runtime->set('html_'.$type,array('catarr'=>$catarr,'startid'=>$startid,'endid'=>$endid,'pernum'=>$pernum,'lastnum'=>$lastnum,'method'=>$method,'current'=>$catid,'page'=>1));
			$gourl=$this->conf['cms_url'].'?html_'.$type.'-create-catid-'.$catid.'.'.'htm';
			$this->view->assign('gourl',$gourl);
			$this->view->display('html_run.htm');
   
        }
        foreach($categorys as &$cat){
			$this->xgcms_category->format($cat);
		}
		
		//hook admin_html_index_view_before.php
		
		$this->view->assign('last_list',$last_list);
		$this->view->assign('last_show',$last_show);
        $this->view->assign('categorys', $categorys);
        $this->view->display('html_index.htm'); 
    }
    public function on_updateurl(){
		
		//hook admin_html_updateurl_before.php
		
        $this->_checked['updateurl']=1;
        $categorys = $this->xgcms_category->get_tree_category();
        $last=$this->runtime->get('updateurl');
		if($last&&core::gpc('continue','G')){
			$gourl='?html-updateurl_run.htm';
			
			//hook admin_html_continue_run_before.php
			
			$this->view->assign('gourl',$gourl);
			$this->view->display('html_run.htm');
		}
        if($this->form_submit()){
            $catids=core::gpc('catids','P');
            $startid=intval(core::gpc('startid','P'));
            $endid=intval(core::gpc('endid','P'));
            $pernum=intval(core::gpc('pernum','P'));
			
			//hook admin_html_updateurl_gpc_after.php
			
            if(empty($catids)){
                $this->message('请选择栏目！'); 
            }elseif(in_array('all',$catids)){
                $catarr=array();
                foreach($categorys as $c){
                    if($c['type']>0) continue;
                    $catarr[]=$c['catid'];
                }
            }else{
                $catarr=$catids;
            }
            $catid=array_pop($catarr);
            $this->runtime->set('updateurl',array('catarr'=>$catarr,'startid'=>$startid,'endid'=>$endid,'pernum'=>$pernum,'current'=>$catid,'page'=>1));
			$gourl='?html-updateurl_run-catid-'.$catid.'.htm';
			
			//hook admin_html_updateurl_gorun_before.php
			
			$this->view->assign('gourl',$gourl);
			$this->view->display('html_run.htm');
   
        }
		
		//hook admin_html_updateurl_view_before.php
		
        $this->view->assign('last',$last);
        $this->view->assign('categorys', $categorys);
        $this->view->display('html_updateurl.htm');
    }
    public function on_updateurl_run(){
       // $catid=core::gpc('catid','G');
        $info=$this->runtime->get('updateurl');
        empty($info) && $this->message('请选择需要更新的栏目！');
	    $catid=$info['current'];
        $startid=$info['startid'];
        $endid=$info['endid'];
        $pernum=$info['pernum'];
        $page=$info['page'];
		
		//hook admin_html_updateurl_run_info_after.php
		
        $cate=$this->mcache->read('cate',$catid);
            $this->xgcms_content->set_model($cate['modelid']);
            $map = array('catid' => $catid,'id'=>array('>'=>$startid));
            $count =$cate['items'];
            
            $start = ($page - 1) * $pernum;

            $list = $this->xgcms_content->get_list($map, $start, $pernum, array('id' =>1));
            $next=0;
            empty($list) && $next=1;
            foreach ($list as $v) {
                if($endid&&$v['id']>$endid){
                    $next=1;
                    break; 
                }
                $v['url']=$this->xgcms_content->get_url($v['id'],$cate);
                $this->xgcms_content->update($v);
            }
			$page++;
            if($next){
                if(empty($info['catarr'])){ 
                    $this->runtime->delete('updateurl');
                    $this->message('更新完成',1,'?html-updateurl.htm');
                }
                $catid=array_pop($info['catarr']);
                $cate=$this->mcache->read('cate',$catid);
                $info['current']=$catid;
                $page=$start=1;
            }
			$info['page']=$page;
			
			//hook admin_html_updateurl_run_setinfo_before.php
			
            $this->runtime->set('updateurl',$info);
            $this->message('正在更新【'.$cate['catname'].'】:'.$start.'-'.($start+$pernum),0.01,'?html-updateurl_run.htm');
   
    }
	public function on_updateindex(){
		
		//hook admin_html_updateindex_before.php
		
        $url_md5=md5($this->conf['cms_url']).'.html';
        $path=$this->conf['html_cache_path'].'index/index/';
        $dir1=utf8::substr($url_md5,0,2);
        $dir2=utf8::substr($url_md5,2,2);
        $dir = $path.$dir1.'/'.$dir2.'/';
        $file=$dir.$url_md5;
        is_file($file) && unlink($file); 
		
		//hook admin_html_updateindex_after.php
		
        $this->message('首页更新成功');
    }
    public function on_clearcache(){
		
		//hook admin_html_clearcache_before.php
		
        $dirs=$this->conf['html_cache_modules'];
        foreach($dirs as $dir){
            misc::rmdir($this->conf['html_cache_path'].$dir.'/');
        }
		
		//hook admin_html_updateindex_after.php
		
        $this->message('静态缓存已全部清空！');
    }
	public function on_newscache(){
		
		//hook admin_html_newcache_before.php
		
		$this->_checked['html'] = 'active';
        $this->_checked['newscache']=1;
		if($this->form_submit()){
            $pernum=core::gpc('pernum','P');
			$cats=$this->xgcms_category->get_list();
			$catarr=array();
            foreach($cats as $c){
                if($c['type']>0) continue;
                $catarr[]=$c['catid'];
            }
            $catid=array_pop($catarr);
            !$catid && $this->message('没有需要更新的栏目！');
			$this->xgcms_cache->truncate();
            $this->runtime->set('html_newscache',array('cats'=>$catarr,'pernum'=>$pernum));
            $gourl='?html-newscache_run-catid-'.$catid.'.htm';
			
			//hook admin_html_newcache_gorun_before.php
			
            $this->view->assign('gourl',$gourl);
            $this->view->display('html_run.htm');
		}
		//hook admin_html_newcache_view_before.php
		$this->view->display('html_newscache.htm');
	}
	public function on_newscache_run(){
		$total=$this->conf['pagesize']*$this->conf['cache_page'];
		$page=misc::page();
		$num=intval(core::gpc('num','G'));
		$catid=core::gpc('catid','G');
        $info=$this->runtime->get('html_newscache');
        empty($info) && $this->message('请选择需要更新的栏目！');
		
        //hook admin_html_newcache_run_info_after.php
		
        $pernum=$info['pernum'];
		$cate=$this->mcache->read('cate',$catid);
        $this->xgcms_content->set_model($cate['modelid']);
		
        $next=0;
		
        $start = ($page - 1) * $pernum;
        $list = $this->xgcms_content->get_list(array('catid'=>$catid,'status'=>99), $start, $pernum, array('id' =>-1));
        
        empty($list) && $next=1;
        foreach($list as $v){
             $this->xgcms_cache->xcreate($v,$cate);
			 $num++;
			 if($num>=$total) {
				 $next=1;
				 $num=0;
				 break;
			 }
        }
        if($next){
			if(empty($info['cats'])){ 
				$this->runtime->delete('html_newscache');
				$this->message('更新完成',1,'?html-newscache.htm');
			}
			$catid=array_pop($info['cats']);
			$cate=$this->xgcms_category->read($catid);
			$this->runtime->set('html_newscache',$info);
			$page=$start=0;
		}
		$page++;
		$this->message('正在更新【'.$cate['catname'].'】:'.$start.'-'.($start+$pernum),0.01,'?html-newscache_run-catid-'.$catid.'-num-'.$num.'-page-'.$page.'.htm');
	}
	//hook admin_html_control_after.php
}
?>