<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include APP_PATH.'control/admin_common_control.class.php';

class index_control extends admin_common_control{
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked['setting']='active';
		$this->_title[]=$conf['app_name'];
	}
	public function on_index(){
		
		//hook admin_index_index_before.php
		
		$this->_checked['system']=1;
		$info = array();
		$info['disable_functions'] = ini_get('disable_functions');
		$info['allow_url_fopen'] = ini_get('allow_url_fopen') ? '是' : '否';
		$info['safe_mode'] = ini_get('safe_mode') ? '是' : '否';
		empty($info['disable_functions']) && $info['disable_functions'] = '无';
		$info['upload_max_filesize'] = ini_get('upload_max_filesize');
		$info['post_max_size'] = ini_get('post_max_size');
		$info['memory_limit'] = ini_get('memory_limit');
		$info['max_execution_time'] = ini_get('max_execution_time');
		$info['dbversion'] = $this->user->db->version();
		$info['SERVER_SOFTWARE'] = core::gpc('SERVER_SOFTWARE', 'S');
		$lastversion = $this->get_last_version();
		
		// 潜在错误检测，目录可写检测，避免搬家导致的问题。
		$check = array();
		$upload_tmp_dir = ini_get('upload_tmp_dir');
		if(!empty($upload_tmp_dir)) {
			$check['upload_path_check'] = !misc::is_writable($upload_tmp_dir) ? "<span class\"red\">$upload_tmp_dir 不可写</span>，上传功能会受到影响。" : "<span class=\"green\">$upload_tmp_dir 可写</span>";
		} else {
			$check['upload_path_check'] = "<span class=\"red\">php.ini 中未设置 upload_tmp_dir，可能会导致上传失败 </span>";
		}
		
		$check['php_ini'] = ini_get('upload_tmp_dir');
		
		//hook admin_index_view_before.php
		
		$this->view->assign('info', $info);
		$this->view->assign('stat', $stat);
		$this->view->assign('check', $check);
		$this->view->assign('lastversion', $lastversion);
		$this->view->display('index.htm');
	}
	public function on_conf(){
	   $this->_checked['site_info']=1;
	   $conf = $this->conf;
	   
	   $kvconf = $this->kv->xget('conf')+ $this->kv->xget('conf_ext');
	   
	   //hook admin_index_conf_kvconf_after.php
	   
	   $input=$post=$error=array();
	   if($this->form_submit()) {
			$post['app_name'] = core::gpc('app_name', 'P');
			
			$post['app_copyright'] = core::gpc('app_copyright', 'P');
			$post['seo_title'] = core::gpc('seo_title', 'P');
			$post['seo_keywords'] = core::gpc('seo_keywords', 'P');
			$post['seo_description'] = core::gpc('seo_description', 'P');
			
			$post['china_icp'] = core::gpc('china_icp', 'P');
			$post['footer_js'] = core::gpc('footer_js', 'P');
			$post['html_cache'] = intval(core::gpc('html_cache', 'P'));
			$post['cache_list_time'] = intval(core::gpc('cache_list_time', 'P'));
			$post['cache_show_time'] = intval(core::gpc('cache_show_time', 'P'));
			$post['image_water_on'] = intval(core::gpc('image_water_on', 'P'));
			$post['image_water_pos'] = min(9,intval(core::gpc('image_water_pos', 'P')));
			$post['reg_email_on'] = intval(core::gpc('reg_email_on', 'P'));
			$post['reg_init_golds'] = intval(core::gpc('reg_init_golds', 'P'));
			$post['resetpw_on'] = intval(core::gpc('resetpw_on', 'P'));
			$post['reg_on'] = intval(core::gpc('reg_on', 'P'));
			
			//hook admin_index_conf_gpc_after.php
			
		    $error['app_name'] = $this->check_app_name($post['app_name']);
			
			if(!array_filter($error)) {
				$error = array();
				
				// 全局的，加载合并到 runtime, 每次请求都从 runtime 加载。
				foreach(array('app_name', 'app_copyright', 'seo_title', 'seo_keywords', 'seo_description','china_icp', 'footer_js'
					,'html_cache','cache_list_time','cache_show_time','reg_on',) as $k) {
					$this->runtime->xset($k, $post[$k], 'runtime');
					$this->kv->xset($k, $post[$k], 'conf');
				}
				// 局部的，按需加载 conf_ext
				foreach(array('image_water_on','image_water_pos','reg_email_on', 'reg_init_golds', 'resetpw_on',
					) as $k) {
					$this->kv->xset($k,$post[$k], 'conf_ext');
				}
				// $this->kv->xsave();
				
                //hook admin_index_conf_set_after.php
			}
	
	   }
	   $kvconf = array_merge($kvconf, $post);
	   $input['app_name'] = form::get_text('app_name', htmlspecialchars($kvconf['app_name']), 300);
	   $input['app_copyright'] = form::get_text('app_copyright', htmlspecialchars($kvconf['app_copyright']), 300);
	   
	   $input['seo_title'] = form::get_text('seo_title', htmlspecialchars($kvconf['seo_title']), 300);
	   $input['seo_keywords'] = form::get_text('seo_keywords', htmlspecialchars($kvconf['seo_keywords']), 300);
	   $input['seo_description'] = form::get_text('seo_description', htmlspecialchars($kvconf['seo_description']), 300);
	   
	   $input['china_icp'] = form::get_text('china_icp', htmlspecialchars($kvconf['china_icp']), 150);
	   $input['footer_js'] = form::get_text('footer_js', htmlspecialchars($kvconf['footer_js']), 300);
	   
	   $input['html_cache']=form::get_radio_yes_no('html_cache',$kvconf['html_cache']);
	   $input['cache_list_time'] = form::get_text('cache_list_time', $kvconf['cache_list_time'], 60);
	   $input['cache_show_time'] = form::get_text('cache_show_time', $kvconf['cache_show_time'], 60);
	   
	   $input['image_water_on']=form::get_radio_yes_no('image_water_on',$kvconf['image_water_on']);
	   $input['image_water_pos']=form::get_text('image_water_pos',$kvconf['image_water_pos'],60);
	   
	   $input['reg_on'] = form::get_radio_yes_no('reg_on', $kvconf['reg_on']);
		$input['reg_email_on'] = form::get_radio_yes_no('reg_email_on', $kvconf['reg_email_on']);
		$input['reg_init_golds'] = form::get_text('reg_init_golds', $kvconf['reg_init_golds'], 50);
		$input['resetpw_on'] = form::get_radio_yes_no('resetpw_on', $kvconf['resetpw_on']);
	   
	   //hook admin_index_conf_view_before.php
	   
	   $this->view->assign('input', $input);
	   $this->view->assign('kvconf', $kvconf);
	   $this->view->assign('error', $error);
	   $this->view->display('index_conf.htm');
		
		
	}
		// 设置 SMTP 账号
	public function on_mail() {
		$this->_checked['mail']=1;
		$error = array();
		
		$mailconf = $this->kv->get('mail_conf');
		
		$sendtype = &$mailconf['sendtype'];
		$smtplist = &$mailconf['smtplist'];
		if($this->form_submit()) {
			$email = (array)core::gpc('email', 'P');
			$host = (array)core::gpc('host', 'P');
			$port = (array)core::gpc('port', 'P');
			$user = (array)core::gpc('user', 'P');
			$pass = (array)core::gpc('pass', 'P');
			$delete = (array)core::gpc('delete', 'P');
			$sendtype = intval(core::gpc('sendtype', 'P'));
			$smtplist = array();
			foreach($email as $k=>$v) {
				empty($port[$k]) && $port[$k] = 25;
				if(in_array($k, $delete)) continue;
				if(empty($email[$k]) || empty($host[$k]) || empty($user[$k])) continue;
				$smtplist[$k] = array('email'=>$email[$k], 'host'=>$host[$k], 'port'=>$port[$k], 'user'=>$user[$k], 'pass'=>$pass[$k]);
			}
			
			$this->kv->set('mail_conf', $mailconf);
			
			$mail_smtplist = $smtplist;
			
			// hook admin_conf_mail_view_before.php
			
		}
		
		$input = array();
		$input['sendtype'] = form::get_radio('sendtype', array(0=>'PHP内置mail函数 ', 1=>'SMTP 方式'), $sendtype);
		
		$this->view->assign('error', $error);
		$this->view->assign('smtplist', $smtplist);
		$this->view->assign('input', $input);
		
		// hook admin_conf_mail_view_before.php
		
		$this->view->display('index_mail.htm');
	}
	
	public function on_clear_cache(){
		$this->clear_tmp();
		$this->runtime->truncate();
        
		$maxs = array(
				'group'=>'groupid',
				'user'=>'uid',
				'xgcms_attach'=>'aid',
				'xgcms_category'=>'catid',
				'xgcms_model'=>'modelid',
				'xgcms_model_field'=>'fieldid',
				'xgcms_search'=>'searchid',
				'xgcms_type'=>'typeid',
		);
		$models=$this->xgcms_model->get_list();
		
		$contents=array();
		foreach($models as $m){
			$contents[$m['modelid']]='id';
		}
		foreach($contents as $modelid=>$maxcol){
			$this->xgcms_content->set_model($modelid);
			$m = $this->xgcms_content->index_maxid();
			$this->xgcms_content->maxid($m);
			$n = $this->xgcms_content->index_count();
			$this->xgcms_content->count($n);
		}
		foreach($maxs as $table=>$maxcol) {
				if(isset($this->$table->maxcol)) {
						$m = $this->$table->index_maxid();
						$this->$table->maxid($m);
				}
				
				$n = $this->$table->index_count();
				$this->$table->count($n);
		}
        
        $this->update_cate_cache();
		
		//hook admin_index_clear_cache_after.php
		
		$this->message('缓存更新成功！',1,'?index.htm');
	}
	private function check_app_name(&$app_name) {
		if(utf8::strlen($app_name) > 32||empty($app_name)) {
			return '站点名称不能为空或者超过32个字符: '.$app_name.'<br />';
		}
		return '';
	}
	private function get_last_version(){
		$last_version = $this->kv->get('last_version');
		if($_SERVER['time'] - $last_version > 8640) {
			$this->kv->set('last_version', $_SERVER['time']);
			$sitename = urlencode($this->conf['app_name']);
			$sitedomain = urlencode($this->conf['app_url']);
			$siteurl=parse_url($this->conf['app_url']);
			$version = urlencode($this->conf['version']);
			$users = $this->xgcms_user->count();
			
			return '<'.'sc'.'ri'.'pt src="htt'.'p:'.'/'.'/w'.'w'.'w'.'.x'.'gc'.'ms.'.'co'.'m/index-version-'.'domain-'.$siteurl['host'].'-cms-xgcms-version-'.$version.'-sitename-'.$sitename.'-remark-'.$users.'.htm">'.'<'.'/s'.'cr'.'ip'.'t>';
			
		} else {
			return '';
		}
	}
	//hook admin_index_control_after.php
	
}


?>