<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');


include APP_PATH.'control/admin_common_control.class.php';

class model_control extends admin_common_control{
    
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked['category']='active';
		$this->_title[]=$conf['app_name']; 
		define('MODEL_FIELDS_PATH',MODEL_LIB_PATH.'fields/');   
	}
	public function on_index(){
		
	  $this->_checked['model_list']='active';

       $list=$this->xgcms_model->get_list(array('type'=>0));
	   foreach($list as &$v){
		     $this->xgcms_content->set_model($v['modelid']);
	         $v['items']=$this->xgcms_content->count();
             $this->xgcms_model->format($v);

	   }
	   //hook admin_model_index_view_before.php
	   $this->view->assign('list',$list);
	   $this->view->display('model.htm');
	}
	public function on_manage(){
	   $a=core::gpc('a','G');
	   $modelid=intval(core::gpc('modelid','G'));
       $model=$this->xgcms_model->read($modelid);
	   //hook admin_model_manage_switch_before.php
       switch($a){
           case 'disabled':
               $model['disabled']=$model['disabled']==1?0:1;
       
               $this->xgcms_model->update($model);
               //hook admin_model_manage_disabled_after.php
               $this->message('操作成功！',1,'?model.htm');
           
           break;
           
           case 'delete':
           $model=$this->xgcms_model->read($modelid);
           $db=$this->xgcms_model->db;
           $tablepre = $db->tablepre;
           $tablename=$tablepre.$model['tablename'];
           $tablename_data=$tablename.'_data';
           $sql1="DROP TABLE `$tablename`";
           $sql2="DROP TABLE `$tablename_data`";
           
		   //hook admin_model_manage_delete_query_before.php
		   
           $db->query($sql1);
           $db->query($sql2);
           
           $this->xgcms_model->delete($modelid);
           $list=$this->xgcms_model_field->get_list(array('modelid'=>$modelid));
           foreach($list as $id){
               $this->xgcms_model_field->delete($id['fieldid']);
           }
		   //hook admin_model_manage_delete_after.php
		   $m = $this->xgcms_model_field->index_maxid();
		   $this->xgcms_model_field->maxid($m);
           $this->message('模型删除成功！',1,'?model.htm');
           break;
           
           case 'add':
             $path=APP_PATH.'../view/';
             $category_templates=$list_templates=$show_templates=array();
             foreach((array)glob($path."list*.htm") as $file) {
                $file=substr($file,strripos($file,'list'));
                $list_templates[$file]=$file;
             }
             foreach((array)glob($path."category*.htm") as $file) {
                $file=substr($file,strripos($file,'category'));
                $category_templates[$file]=$file;
             }
             foreach((array)glob($path."show*.htm") as $file) {
                $file=substr($file,strripos($file,'show'));
                $show_templates[$file]=$file;
             }
             $input=array();
             $input['category_tem']=form::get_select('info[category_template]',$category_templates);
             $input['list_tem']=form::get_select('info[list_template]',$list_templates);
             $input['show_tem']=form::get_select('info[show_template]',$show_templates);
			 
             //hook admin_model_manage_add_view_before.php
			 
             $this->view->assign('input',$input);
             $this->view->display('model_add_ajax.htm');
           
           break;
           
           case 'add_submit':
                $infos=core::gpc('info','P');
                $error=array();
               
                if(empty($infos['name'])||empty($infos['tablename'])) $this->message('请填写模型名称和数据表',0);
               
                $modelid=$this->xgcms_model->create($infos);
                $model_sql = file_get_contents(MODEL_FIELDS_PATH.'model.sql');
				$db=$this->xgcms_model->db;
				$tablepre = $db->tablepre;
				$tablename = $infos['tablename'];
				
				$model_sql = str_replace('$basic_table', $tablepre.$tablename, $model_sql);
				$model_sql = str_replace('$table_data',$tablepre.$tablename.'_data', $model_sql);
				$model_sql = str_replace('$table_model_field',$tablepre.'xgcms_model_field', $model_sql);
				$model_sql = str_replace('$modelid',$modelid,$model_sql);
				$model_sql = str_replace('$siteid',1,$model_sql);
				
				$model_sql = str_replace("\r\n", "\n", $model_sql);
				$model_sql = preg_replace('#\n\#[^\n]*?\n#is', "\n", $model_sql);	// 去掉注释行
				$sqlarr = explode(";\n", $model_sql);

				foreach($sqlarr as $sql) {
					if(trim($sql)) {
					//	$sql = str_replace('bbs_', $tablepre, $sql);
						try {
							$db->query($sql);
							
						} catch (Exception $e) {
							$error = $e->getMessage();
							break;
						}
					}
				}
                //hook admin_model_manage_add_submit_after.php
				$m = $this->xgcms_model_field->index_maxid();
				$this->xgcms_model_field->maxid($m);
				
                $this->message('模型建立成功！'); 
           
           break;
           case 'edit':
           
               $model=$this->xgcms_model->read($modelid);
              
               $path=APP_PATH.'../view/';
			   $category_templates=$list_templates=$show_templates=array();
			   foreach((array)glob($path."list*.htm") as $file) {
				  $file=substr($file,strripos($file,'list'));
				  $list_templates[$file]=$file;
			   }
			   foreach((array)glob($path."category*.htm") as $file) {
				  $file=substr($file,strripos($file,'category'));
				  $category_templates[$file]=$file;
			   }
			   foreach((array)glob($path."show*.htm") as $file) {
				  $file=substr($file,strripos($file,'show'));
				  $show_templates[$file]=$file;
			   }
			   $input=array();
			   $input['category_tem']=form::get_select('info[category_template]',$category_templates,$model['category_template']);
			   $input['list_tem']=form::get_select('info[list_template]',$list_templates,$model['list_template']);
			   $input['show_tem']=form::get_select('info[show_template]',$show_templates,$model['show_template']);
			   
			   //hook admin_model_manage_edit_view_before.php
			   
			   $this->view->assign('input',$input);
			   $this->view->assign('model',$model);
			   $this->view->assign('modelid',$modelid);
               $this->view->display('model_edit_ajax.htm');
           
           break;
           case 'edit_submit':
				$infos=core::gpc('info','P');
				if(empty($infos['name'])) $this->message('请填写模型名称！',0);
				//hook admin_model_manage_edit_submit_update_before.php
				$infos['modelid']=$modelid;
				$this->xgcms_model->update($infos);
				
				//hook admin_model_manage_edit_submit_after.php
				
				$this->message('更新成功！');
			 
           
           break;
       }
      
       
	}
    public function on_field(){
        $this->_checked['model_list']='active';
        $modelid=intval(core::gpc('modelid','G'));
        if($this->form_submit()) {
            // 修改
			$orderarr = core::gpc('listorder', 'P');
			foreach($orderarr as $fid=>$val) {
				$fid = intval($fid);
				$field=$this->xgcms_model_field->read($fid);
				$field['listorder']=$val;
				$this->xgcms_model_field->update($field);
			}
        }
        $model=$this->xgcms_model->read($modelid);
        $list=$this->xgcms_model_field->get_list(array('modelid'=>$modelid));
        
        $arr=$this->xgcms_model_field->field_inc();
        
        foreach($list as &$v){
             $v['forbid_delete']=in_array($v['field'],$arr['forbid_delete'])?1:0;
             $v['forbid_fields']=in_array($v['field'],$arr['forbid_fields'])?1:0;
            
        }
        
       $error=array(); 
	   
	   //hook admin_model_field_view_before.php
	   
       $this->view->assign('list',$list);
       $this->view->assign('model',$model);
       $this->view->assign('error',$error);
	   $this->view->display('model_field.htm');
        
    }
    public function on_field_do(){
       $fieldid=intval(core::gpc('fieldid','G'));
       $modelid=intval(core::gpc('modelid','G'));
       $a=core::gpc('a','G');
       $this->_checked['model_list']='active';
	   
	   //hook admin_model_field_do_switch_before.php
	   
       switch($a){
           case 'disabled':
               $field=$this->xgcms_model_field->read($fieldid); 
       
               $field['disabled']=$field['disabled']==1?0:1;
       
               $this->xgcms_model_field->update($field);
       
               $msg=array('success'=>'操作成功','msg'=>$field['disabled']==1?'<span class="red">启用</span>':'禁用');
			   
			   //hook admin_model_field_do_disabled_after.php
			   
               $this->message($msg);
           break;
           
           case 'delete':
              $rs=$this->xgcms_model_field->read($fieldid);
              $model=$this->xgcms_model->read($rs['modelid']);
              $model_table=$model['tablename'];
              $table_pre=$this->xgcms_model->db->tablepre;
              $tablename=$rs['issystem']?$table_pre.$model_table:$table_pre.$model_table.'_data';
              $field=$rs['field'];
              $sql="ALTER TABLE `$tablename` DROP `$field`";
              $this->xgcms_model->db->query($sql);
              $this->xgcms_model_field->delete($fieldid);
			  
			  //hook admin_model_field_do_delete_after.php
			  
              $this->message('删除成功！',1,'?model-field-modelid-'.$modelid.'.htm');
           
           break;
           
           case 'edit':
               
               $field=$this->xgcms_model_field->read($fieldid);
               $model=$this->xgcms_model->read($field['modelid']);
               
               $arr=$this->xgcms_model_field->field_inc();
               
   	           require MODEL_FIELDS_PATH.$field['formtype'].'/config.inc.php';
               $input=array();
               $input['formtype']=form::get_select('info[formtype]',$arr['fields'],$field['formtype'],true,true);
               $input['isunique']=form::get_radio_yes_no('info[isunique]',$field['isunique'],$field_allow_isunique);
               $input['isbase']=form::get_radio_yes_no('info[isbase]',$field['isbase']);
               $input['issearch']=form::get_radio_yes_no('info[issearch]',$field['issearch'],$field_allow_search);
               $input['isadd']=form::get_radio_yes_no('info[isadd]',$field['isadd']);
               $input['isfulltext']=form::get_radio_yes_no('info[isfulltext]',$field['isfulltext'],$field_allow_fulltext);
               $input['field']=form::get_text('info[field]',$field['field'],100,in_array($field['field'],$arr['forbid_delete'])?'disabled':'');
               
               $setting = core::json_decode($field['setting']);
   	           ob_start();
			   require MODEL_FIELDS_PATH.$field['formtype'].'/field_edit_form.inc.php';
	    	   $form_data = ob_get_contents();
			   ob_end_clean();
			   
               //hook admin_model_field_do_edit_view_before.php
			   
               $this->view->assign('input',$input);
               $this->view->assign('form_data',$form_data);
               $this->view->assign('field',$field);
               $this->view->assign('model',$model);
               $this->view->display('model_field_edit.htm');
           
           break;
           case 'edit_submit':
           
              if($this->form_submit()){
                $infos=core::gpc('info','P');
                $setting=core::gpc('setting','P');
                $model_cache = $this->xgcms_model->read($modelid);
		    	$model_table = $model_cache['tablename'];
                
			    $rs=$this->xgcms_model_field->read($fieldid);
				
                $oldfield=$rs['field'];
                $issystem=$rs['issystem'];
		   	    $tablename = $rs['issystem'] ? $this->xgcms_model->db->tablepre.$model_table : $this->xgcms_model->db->tablepre.$model_table.'_data';

                $field = isset($infos['field'])&&!empty($infos['field'])?$infos['field']:$rs['field'];
		    	$minlength = $infos['minlength'] ? $infos['minlength'] : 0;
		    	$maxlength = $infos['maxlength'] ? $infos['maxlength'] : 0;
                
			    $field_type = $rs['formtype'];
			
                require MODEL_FIELDS_PATH.$field_type.'/config.inc.php';
			
		    	if(isset($setting['fieldtype'])) {
			     	$field_type = $setting['fieldtype'];
		    	}

		    	require MODEL_FIELDS_PATH.'edit.sql.php';
			    //附加属性值
		    	$infos['setting'] = core::json_encode($setting);
                
                
                $infos=array_merge($rs,$infos);
				
                //hook admin_model_field_do_edit_submit_update_before.php
				
		    	$this->xgcms_model_field->update($infos);
				
                //hook admin_model_field_do_edit_submit_after.php
				
                $this->message('字段修改成功！',1,'?model-field-modelid-'.$modelid.'.htm');
                
              }
              
           break;
           case 'add':
          
			  $f_datas = $this->xgcms_model_field->get_list(array('modelid'=>$modelid));
  
			  foreach($f_datas as $_k=>$_v) {
				  $exists_field[] = $_v['field'];
			  }
			  $arr=$this->xgcms_model_field->field_inc();
			  $fields=$arr['fields'];
			  $not_allow_fields=$arr['not_allow_fields'];
			  $unique_fields=$arr['unique_fields'];
			  $all_field = array();
			  foreach($fields as $_k=>$_v) {
				  if(in_array($_k,$not_allow_fields) || in_array($_k,$exists_field) && in_array($_k,$unique_fields)) continue;
				  $all_field[$_k] = $_v;
			  }
            
              $model=$this->xgcms_model->read($modelid);
             
              //hook admin_model_field_do_add_view_before.php
			  
              $this->view->assign('fieldinc',$all_field);
              $this->view->assign('model',$model);
              $this->view->display('model_field_add.htm');
           break;
           case 'add_submit':
              if($this->form_submit()){
                $infos=core::gpc('info','P');
                $setting=core::gpc('setting','P');
                
                $model_cache = $this->xgcms_model->read($modelid);
		    	$model_table = $model_cache['tablename'];
   
                $issystem=core::gpc('issystem','P');
                
		   	    $tablename = $issystem ? $this->xgcms_model->db->tablepre.$model_table : $this->xgcms_model->db->tablepre.$model_table.'_data';
                 
                $error['field']=$this->xgcms_model_field->get_one(array('field'=>$infos['field']));
                if(!empty($error['field'])) $this->message('字段名已经存在！',0);
                $field = $infos['field'];
                
		    	$minlength = $infos['minlength'] ? $infos['minlength'] : 0;
		    	$maxlength = $infos['maxlength'] ? $infos['maxlength'] : 0;
                
			    $field_type = $infos['formtype'];
			
                require MODEL_FIELDS_PATH.$field_type.'/config.inc.php';
			
		    	if(isset($setting['fieldtype'])) {
			     	$field_type = $setting['fieldtype'];
		    	}

		    	require MODEL_FIELDS_PATH.'add.sql.php';
			    //附加属性值
		    	$infos['setting'] = core::json_encode($setting);
                

                $infos['modelid']=$modelid;
				
		    	$this->xgcms_model_field->create($infos);
                //hook admin_model_field_do_add_submit_after.php
				
                $this->message('字段添加成功！',1,'?model-field-modelid-'.$modelid.'.htm');
              }
           
           break;
       }
       
    }
	public function on_type(){
		$this->_checked['model_type']='active';
		$list=$this->xgcms_type->get_list(array('module'=>'content'));
		
		//hook admin_model_type_view_before.php
		
		$this->view->assign('list',$list);
		$this->view->display('model_type.htm');
	}
	public function on_type_do(){
		$a=core::gpc('a','G');
		//hook admin_model_type_do_switch_before.php
		switch($a){
			case 'listorder':
			      $orders=core::gpc('listorder','P');
				  foreach((array)$orders as $k=>$v){
					  $type=$this->xgcms_type->read($k);
					  $type['listorder']=$v;
					  $this->xgcms_type->update($type);
				  }
				  
				  //hook admin_model_type_do_listorder_after.php
				  
				  $this->message('操作成功！',1,'?model-type.htm');
			break;
			case 'add':
			     if($this->form_submit()){
					 $names=core::gpc('names','P');
					 $cates=core::gpc('cates','P');
					 $description=htmlspecialchars(core::gpc('description','P'));
					 $namearr = explode("\n", $names);
					 
					 $catearr=explode(',',$cates);
					 foreach((array)$namearr as $name){
						 if(empty($name))  continue;
						 $info=array('siteid'=>1,
						              'module'=>'content',
									  'name'=>$name,
									  'description'=>$description);
						 $typeid=$this->xgcms_type->create($info);
						 
						 foreach($catearr as $c){
							 if(intval($c)>0){
								 $cate=$this->xgcms_category->read($c);
								 empty($cate['usable_type']) && $cate['usable_type']=',';
								 $cate['usable_type'].=$typeid.',';
								 $this->xgcms_category->update($cate);
							 } 
					     }
					 }
					
					 //hook admin_model_type_do_add_after.php
					 $this->message('类别添加成功！');
					  
				 }
			     $category=$this->xgcms_category->get_tree_category();
				 $this->view->assign('category',$category);
			     $this->view->display('model_type_add_ajax.htm');
			break;
			case 'delete':
			     $typeid=intval(core::gpc('typeid','G'));
				 
				 
				 
                 $this->xgcms_type->delete($typeid);
				 //hook admin_model_type_do_delete_after.php
				 $this->message('类别删除成功！',1,'?model-type.htm');		
			break;
			
			case 'edit':
			     $typeid=intval(core::gpc('typeid','G'));
				 $type=$this->xgcms_type->read($typeid);
				 
				 if($this->form_submit()){
					 $name=htmlspecialchars(core::gpc('name','P'));
					 $cates=core::gpc('cates','P');
					 $description=htmlspecialchars(core::gpc('description','P'));
					 
					 $info=array('typeid'=>$typeid,
								 'name'=>$name,
							     'description'=>$description);
								 
					 $type=array_merge($type,$info);
					 $this->xgcms_type->update($type);
						 
					 $tablename=$this->xgcms_category->db->tablepre.'xgcms_category';
				     $sql="update `$tablename` set `usable_type`=replace(usable_type,',$typeid,',',');";
				     $this->xgcms_type->db->query($sql);
					 $catearr=explode(',',$cates);
					 foreach($catearr as $c){
							 if(intval($c)>0){
								 $cate=$this->xgcms_category->read($c);
								 empty($cate['usable_type']) && $cate['usable_type']=',';
								 $cate['usable_type'].=$typeid.',';
								 
								 //hook admin_model_type_do_edit_update_before.php
								 
								 $this->xgcms_category->update($cate);
							 } 
					     }
					  //hook admin_model_type_do_edit_update_after.php
					 $this->message('编辑成功！');
				 }
				 $category=$this->xgcms_category->get_tree_category();
				 
				 $str='<select name= "catids" id="catids" multiple="multiple" style="width:280px;height:100px;padding:2px;"><option>选择栏目</option>';
				 foreach($category as $c){
					 if($c['type']>0) continue;
					 $selected='';
					 $typearr=explode(',',$c['usable_type']);
					 if(in_array($typeid,$typearr))  $selected=' selected="selected"';
/*					 if(stripos($c['usable_type'],','.$typeid.',')){
						
					 }*/
					 if($c['child']) $selected.=' disabled';
					 $str.='<option value="'.$c['catid'].'" '.$selected.'>'.$c['catname'].'</option>';
				 }
				 $str.='</select>';
				 
				 //hook admin_model_type_do_edit_view_before.php
				 
				 $this->view->assign('category',$str);
				 $this->view->assign('typeid',$typeid);
				 $this->view->assign('type',$type);
			     $this->view->display('model_type_edit_ajax.htm');
			break;
		}
	}
    /**
	 * 字段属性设置
	 */
	public function on_public_field_setting() {
		$fieldtype = core::gpc('fieldtype','G');
        require MODEL_FIELDS_PATH.$fieldtype.'/config.inc.php';
        
        ob_start();
        require MODEL_FIELDS_PATH.$fieldtype.'/field_add_form.inc.php';
        $data_setting = ob_get_contents();
		//$data_setting = iconv('gbk','utf-8',$data_setting);
		ob_end_clean();
		$settings = array('field_basic_table'=>$field_basic_table,'field_minlength'=>$field_minlength,'field_maxlength'=>$field_maxlength,'field_allow_search'=>$field_allow_search,'field_allow_fulltext'=>$field_allow_fulltext,'field_allow_isunique'=>$field_allow_isunique,'setting'=>$data_setting);
		echo json_encode($settings);
 
		return true;

	}
    //hook admin_model_control_after.php
}

?>