<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include APP_PATH.'control/xgcms_common_control.class.php';

class attach_control extends xgcms_common_control{
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->check_admin_group();
		$this->conf+=$this->kv->get('conf_ext');
	}
	// 接受所有文件 swfupload post ajax
	public function on_uploadimage() {
		$catid = intval(core::gpc('catid'));
		$id = intval(core::gpc('id'));
		$uid = $this->_user['uid'];
		
		//$this->check_forbidden_group();
		
		$cate = $this->mcache->read('cate',$catid);
		$user = $this->user->read($uid);
		
		$this->check_cate_exists($cate);
		$this->check_access($cate, 'attach');
		
		// hook attach_uploadimage_before.php

		//  && is_file($_FILES['Filedata']['tmp_name'])
		$dir=core::gpc('dir','G');
				
		if($dir=='file'){
			$this->on_uploadfile();
			
		}elseif($dir=='image'){
		
			if(!empty($_FILES['Filedata']['tmp_name'])) {
				
				// 对付一些变态的 iis 环境， is_file() 无法检测无权限的目录。
				$tmpfile = FRAMEWORK_TMP_TMP_PATH.md5(rand(0, 1000000000).$_SERVER['time'].$_SERVER['ip']).'.tmp';
				$succeed = IN_SAE ? copy($_FILES['Filedata']['tmp_name'], $tmpfile) : move_uploaded_file($_FILES['Filedata']['tmp_name'], $tmpfile);
				if(!$succeed) {
					$msg='{"error":1,"message":"移动临时文件错误，请检查临时目录的可写权限。"}';
					exit($msg);
				}
				
				$file = $_FILES['Filedata'];
				$file['tmp_name'] = $tmpfile;
				core::htmlspecialchars($file['name']);
				$filetype = $this->xgcms_attach->get_filetype($file['name']);
				if($filetype != 'image') {
					$allowtypes = $this->xgcms_attach->get_allow_filetypes();
					$msg='{"error":1,"message":"请选择图片格式的文件，后缀名为：.gif, .jpg, .png, .bmp！"}';
					exit($msg);
					
				}
				
				if(!$this->xgcms_attach->is_safe_image($file['tmp_name'])) {
					$msg='{"error":1,"message":"系统检测到图片('.$file['name'].')不是安全的，请更换其他图片试试。"}';
					exit($msg);
				}
				
				$arr = array (
					'catid'=>$catid,
					'tid'=>$id,
					'pid'=>0,
					'filesize'=>0,
					'width'=>0,
					'height'=>0,
					'filename'=>'',
					'orgfilename'=>$file['name'],
					'filetype'=>$filetype,
					'dateline'=>$_SERVER['time'],
					'comment'=>'',
					'downloads'=>0,
					'isimage'=>1,
					'golds'=>0,
					'uid'=>$this->_user['uid'],
				);
				$aid = $this->xgcms_attach->create($arr);
				$this->xgcms_attach->save_aid_to_tmp($catid, $aid, $uid);
				
				$uploadpath = $this->conf['upload_path'].'attach/';
				$uploadurl = $this->conf['upload_url'].'attach/';
				
				// 处理文件
				$imginfo = getimagesize($file['tmp_name']);
				
				// 如果为 GIF, 直接 copy
				// 判断文件类型，如果为图片文件，缩略，否则直接保存。
				if($imginfo[2] == 1) {
					$md5name = md5(rand(0, 1000000000).$_SERVER['time'].$_SERVER['ip']);
					$fileurl = image::set_dir($aid, $uploadpath).'/'.$md5name.'.gif';
					$thumbfile = $uploadpath.$fileurl;
					copy($file['tmp_name'], $thumbfile);
					$r['filesize'] = filesize($file['tmp_name']);
					$r['width'] = $imginfo[0];
					$r['height'] = $imginfo[1];
					$r['fileurl'] = $fileurl;
				} else {
					$r = image::safe_thumb($file['tmp_name'], $aid, '.jpg', $uploadpath, $this->conf['upload_image_max_width'], 240000, 1);	// 1210 800
					
								
					$thumbfile = $uploadpath.image::thumb_name($r['fileurl']);
					image::thumb($file['tmp_name'], $thumbfile, $this->conf['thread_icon_middle'], 2256);
					image::clip($thumbfile, $thumbfile, 0, 0, $this->conf['thread_icon_middle'], $this->conf['thread_icon_middle']);	// 对付金箍棒图片
					$watermark_img=ROOT_PATH.'static/images/water.png';
					if($this->conf['image_water_on']&&is_file($watermark_img)){
	
						 if($this->conf['image_water_pos']){
							 $watermark_pos=$this->conf['image_water_pos'];
						 }else{
							 $randarr=array(1=>1,2=>3,3=>7,4=>9);
							 $randnum=rand(1,4);
							 $watermark_pos=$randarr[$randnum];
						 }
						 $this->water->watermark($uploadpath.$r['fileurl'], '', $watermark_pos, $watermark_img, '', 5, '#ff0000');	
					}
				}
				
				$arr['aid'] = $aid;
				$arr['catid'] = $catid;
				$arr['filesize'] = $r['filesize'];
				$arr['width'] = $r['width'];
				$arr['height'] = $r['height'];
				$arr['filename'] = $r['fileurl'];
				$this->xgcms_attach->update($arr);
				
				is_file($file['tmp_name']) && unlink($file['tmp_name']);
				
				// hook attach_uploadimage_after.php
				$msg='{"error":0,"url":"'.$uploadurl.$r['fileurl'].'"}';
				exit($msg);
				//$this->message('<img src="'.$uploadurl.$r['fileurl'].'" width="'.$arr['width'].'" height="'.$arr['height'].'"/>');
				
			} else {
				if($_FILES['Filedata']['error'] == 1) {
					$msg='{"error":1,"message":"上传文件( '.htmlspecialchars($_FILES['Filedata']['name']).' )太大，超出了 php.ini 的设置：'.ini_get('upload_max_filesize').'"}';
					exit($msg);
				} else {
					$msg='{"error":1,"message":"上传文件失败，错误编码：'.$_FILES['Filedata']['error'].', FILES: '.print_r($_FILES, 1).', is_file: '.is_file($_FILES['Filedata']['tmp_name']).', file_exists: '.file_exists($_FILES['Filedata']['tmp_name']).'"}';
					exit($msg);
				}
			}
		}else{
			 $msg='{"error":1,"message":"不支持上传"}';
		     exit($msg);
			
		}
	}
	
	// 接受所有文件 swfupload post ajax
	public function on_uploadfile() {
		$catid = intval(core::gpc('catid'));
		$id = intval(core::gpc('id'));	// 如果新发帖子，那么 pid 为 0
		$uid = $this->_user['uid'];
		
		//$this->check_forbidden_group();
		
		$cate = $this->mcache->read('cate',$catid);
		$user = $this->user->read($uid);
		
		$this->check_cate_exists($cate);
		$this->check_access($cate, 'attach');

		// hook attach_uploadfile_before.php
		
		if(!empty($_FILES['Filedata']['tmp_name'])) {
			// 对付一些变态的 iis 环境， is_file() 无法检测无权限的目录。
			$tmpfile = FRAMEWORK_TMP_TMP_PATH.md5(rand(0, 1000000000).$_SERVER['time'].$_SERVER['ip']).'.tmp';
			$succeed = IN_SAE ? copy($_FILES['Filedata']['tmp_name'], $tmpfile) : move_uploaded_file($_FILES['Filedata']['tmp_name'], $tmpfile);
			if(!$succeed) {
				$msg='{"error":1,"message":"移动临时文件错误，请检查临时目录的可写权限。"}';
		        exit($msg);
			}
			
			$file = $_FILES['Filedata'];
			$file['tmp_name'] = $tmpfile;
			$file['name'] = htmlspecialchars($file['name']);
			$filetype = $this->xgcms_attach->get_filetype($file['name']);
			// 多后缀名以最后一个 . 为准。文件名舍弃，避免非法文件名。
			$ext = strrchr($file['name'], '.');
			if($filetype == 'unknown') {
				$ext = $this->xgcms_attach->safe_ext($ext);
			}
			
			$arr = array (
				'catid'=>$catid,
				'tid'=>$id,
				'pid'=>0,
				'filesize'=>0,
				'width'=>0,
				'height'=>0,
				'filename'=>'',
				'orgfilename'=>$file['name'],
				'filetype'=>$filetype,
				'dateline'=>$_SERVER['time'],
				'comment'=>'',
				'downloads'=>0,
				'isimage'=>0,
				'golds'=>0,
				'uid'=>$uid,
			);
			$aid = $this->xgcms_attach->create($arr);
			
			// $aid 保存到临时文件，每个用户一个文件，里面记录 aid。在读取后删除该文件。
			// 如果tmp为内存，则在用户未完成期间，可能会导致垃圾数据产生。可以通过 uid=123 and pid=0，来判断附件归属，不过这个查询未建立索引，可以定期清理，一般不需要。
			$this->xgcms_attach->save_aid_to_tmp($catid, $aid, $uid);
			
			$uploadpath = $this->conf['upload_path'].'attach/';
			$uploadurl = $this->conf['upload_url'].'attach/';
			
			// 处理文件
			$pathadd = image::set_dir($aid, $uploadpath);
			$filename = md5($aid.'_'.$this->conf['auth_key']).$ext;
			$destfile = $uploadpath.$pathadd.'/'.$filename;
			$desturl = $uploadurl.$pathadd.'/'.$filename;

			$arr['catid'] = $catid;
			$arr['aid'] = $aid;
			$arr['filename'] = $pathadd.'/'.$filename;
			$arr['filesize'] = filesize($file['tmp_name']);
			$this->xgcms_attach->update($arr);
			
			if(copy($file['tmp_name'], $destfile)) {
				
				// hook attach_uploadfile_after.php
				$arr['desturl'] = $desturl;
				
				is_file($file['tmp_name']) && unlink($file['tmp_name']);
				
				$msg='{"error":0,"url":"'.$desturl.'"}';
		        exit($msg);
			} else {
				// 回滚
				$this->xgcms_attach->delete($catid, $aid);
				$msg='{"error":1,"message":"保存失败"}';
		        exit($msg);
			}
			
		} else {
			$msg='{"error":1,"message":"上传文件失败，可能文件太大。"}';
		    exit($msg);
		}
	}
	
	// hook attach_control_after.php
	
}


?>