<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include APP_PATH.'control/xgcms_common_control.class.php';

class show_control extends xgcms_common_control{
	
	function __construct(&$conf) {
		parent::__construct($conf);
	}
	public function on_index(){
		//hook show_index_before.php
	    $id=intval(core::gpc('id','G'));
	    $catid=htmlspecialchars(core::gpc('catid','G'));
	    $cate='';
	    if(intval($catid)){
		   $cate=$this->mcache->read('cate',$catid);
	    }elseif($catid){
		   $cate=$this->mcache->read('cate_dir',$catid);
	    }
	    $this->check_cate_exists($cate);
		$this->check_access($cate, 'read');
		$this->conf['html_cache'] && $this->html_cache();
		
	    $catid=$cate['catid'];
	    if($cate['type']>0) $this->message('栏目错误！');
	   
	    $model=$this->xgcms_model->read($cate['modelid']);
	    $this->xgcms_content->set_model($cate['modelid']);
		
		//hook show_index_get_data_before.php
		
	    $data=$this->xgcms_content->xread($catid,$id);
        if(empty($data)||($data['status']!=99&&$this->_group['groupid'] != 1)) $this->message('内容不存在！');
		$this->xgcms_content->format($data);
	    
		$data['ispay']=$this->check_pay($cate,$data);
		
		//hook show_index_get_data_after.php
		
		//分页
		$page=misc::page();
		$pages='';
		if($data['pagenum']>1){
			//hook show_index_pagenum_beforeafter.php
			$arr=explode('[\page]',$data['content']);
			$data['content']=$arr[$page-1];
			if($page>1&&utf8::substr($data['content'],0,1)=='#'){
				$data['content']=utf8::substr($data['content'],1,10000);
				$pos=stripos($data['content'],'#');
				if($pos && $pos<200){
				    $data['title']=strip_tags(substr($data['content'],0,$pos));
					$data['content']=substr($data['content'],$pos+1);
				}
			}else{
				$page>1 && $data['title']=$data['title'].'('.$page.')';
			}
			$url=$this->xgcms_content->get_url($id,$cate,$data['inputtime'],0);
			$pages=$this->pages($data['pagenum'], $page, 1, $url);
			//hook show_index_pagenum_after.php
		}
	    $cate['arrparent']=explode(',',$cate['arrparentid']);//导航选择
	    $catpost=$this->catpos($catid);
	    $this->_title[]=$data['title'];
		$this->_title[]=$cate['catname'];
		$this->_seo_keywords=$data['keywords']?htmlspecialchars($data['keywords']):$data['title'];
		$this->_seo_description=$data['description']?htmlspecialchars($data['description']):$data['title'];
		
		// 点击数服务器 seo notfollow
		$viewsid=$catid.'_'.$id;
		$click_server = $this->conf['click_server'].'?db=tid&w='.$viewsid.'&r='.$viewsid;
		
		$template=$cate['show_template']?$cate['show_template']:$model['show_template'];
		
		//hook show_index_after.php
		
	    $this->build_html_start($data);
		$this->view->assign('click_server', $click_server);
	    $this->view->assign('catpos',$catpost);
		$this->view->assign('catid',$catid);
		$this->view->assign('viewsid',$viewsid);
		$this->view->assign('cate',$cate);
		$this->view->assign('data',$data);
		$this->view->assign('pages',$pages);
		$this->view->assign('page',$page);
		$this->view->display($template);
		$this->build_html_end();	
	}
	private function check_pay($cate,$data){
		
		//hook show_check_pay_before.php
		
		if($data['readpoint']||$cate['defaultchargepoint']){
			$uid=$this->_user['uid'];
			if($this->_group['groupid'] == 1&&core::gpc(0,'G')!='html_show') return true;
			if($uid){
				$rs=$this->xgcms_charge->read($cate['catid'],$data['id'],$uid);
				if($rs){
					return true;
				}elseif(core::gpc('pay','G')){
					$user=$this->xgcms_user->read($uid);
					$this->check_user_exists($user);
					$paytype=$data['readpoint']?($data['paytype']?'golds':'credits'):($cate['paytype']?'golds':'credits');
					$amount=$data['readpoint']?$data['readpoint']:$cate['defaultchargepoint'];
					if($user[$paytype]<$amount) $this->message('您的账户余额不足');
					$user[$paytype]=$user[$paytype]-$amount;
					$this->xgcms_user->update($user);
					$this->xgcms_charge->create(array('catid'=>$cate['catid'],'id'=>$data['id'],'uid'=>$uid,$paytype=>$amount,'dateline'=>$_SERVER['time']));
					return true;
				}else{
					return false;
				}
			}elseif(core::gpc('pay','G')){
				$this->message('您还有登陆');
			}
			return false;
		}else{
			return true;
		}	
	}
	//hook show_control_after.php
}

?>