<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

class xgcms_common_control extends base_control {
		
	// 为了避免与 model 冲突，加下划线分开
	public $_sid = '';		// session id
	public $_user = array();	// 全局 user
	public $_group = array();	// 全局 group, 包含用户权限
	
	// header 相关
	public $_title = array();	// header.htm title
	public $_nav = array();		// header.htm 导航
	public $_seo_keywords = '';	// header.htm keywords
	public $_seo_description = '';	// header.htm description
	public $_checked = array();	// 选中状态
	
	// 计划任务
	protected $_cron_1_run = 0;	// 计划任务1 是否被激活, 15 分钟执行一次
	protected $_cron_2_run = 0;	// 计划任务2 是否被激活, 每天0点执行一次
	
	// hook xgcms_common_control_before.php
	
	// 初始化 _sid, _user, _title, _nav
	function __construct(&$conf) {
		// hook xgcms_common_control_construct_before.php
		parent::__construct($conf);
		// hook xgcms_common_control_construct_after.php
		
		$this->init_conf();
		$this->init_ip();
		$this->init_timezone();
		$this->init_view();
		$this->init_sid();
		$this->init_user();
		//$this->init_group();
		$this->check_domain();
		//$this->init_cron();
		
		// hook xgcms_common_control_init_after.php
		
	}
	
	// PHP 规定析构函数中不能抛出异常！保证此函数高度可用！这个析构函数最先执行，这里 db 未释放。
	function __destruct() {
		// $db 有可能比这两个 model 实例更早析构！
		if(isset($this->runtime)) {
			$this->runtime->save_changed();
		}
		if(isset($this->kv)) {
			$this->kv->save_changed();
		}
		
		if(DEBUG > 1 && !empty($_SERVER['trace'])) {
			//restore_exception_handler();
			//restore_error_handler();
			log::trace_save();
		}
	}
	
	private function init_conf() {
		$runtime = $this->runtime->xget();
		$this->conf += $runtime; // view_path 占位，保留了 conf.view_path
		
		// 优先扫描 runtime 中的 view_path
		isset($runtime['view_path']) && $this->conf['view_path'] = array_merge($runtime['view_path'], $this->conf['view_path']);
		
		// hook xgcms_common_control_init_runtime_after.php
	}
	
	private function init_ip() {
		// 通过代理发送的头获取用户真实IP
		if(!empty($this->conf['cdn_ip']) && in_array($_SERVER['ip'], $this->conf['cdn_ip'])) {
			$realip = core::gpc('HTTP_X_FORWARDED_FOR', 'S');
			empty($realip) && $realip = core::gpc('HTTP_CLIENT_IP', 'S');
			if(preg_match('#^\d+(\.\d+){3}$#', $realip)) {
				$_SERVER['ip'] = $realip;
			}
		}
		
		// hook xgcms_common_control_init_ip_after.php
	}
	
	private function init_timezone() {
		
		// 第一次访问，默认为系统所在时区。以后为用户所在时区。
		if(!isset($_COOKIE['timeoffset'])) {
			$timeoffset = $this->conf['timeoffset'];
		} else {
			$timeoffset = misc::mid(intval($_COOKIE['timeoffset']), -12, 12);
			$timeoffset = sprintf('%+d', $timeoffset);
		}
		$timeoffset2 = $timeoffset;
		$timeoffset2[0] = $timeoffset[0] == '+' ? '-' : '+';
		date_default_timezone_set('Etc/GMT'.$timeoffset2);	// 覆盖掉框架设置的默认值
		$_SERVER['timeoffset'] = $timeoffset;
		
		// 今日凌晨0点的开始时间！
		$_SERVER['time_fmt'] = date('Y-n-d H:i', $_SERVER['time']);			// +8 hours
		$arr = explode(' ', $_SERVER['time_fmt']);
		list($y, $n, $d) = explode('-', $arr[0]);
		$_SERVER['time_today'] = mktime(0, 0, 0, $n, $d, $y);	// -8 hours
		// hook xgcms_common_control_init_timezone_after.php
	}
	
	private function init_view() {
		$fid = intval(core::gpc('fid'));
		$this->_checked['forum_'.$fid] = ' class="checked"';
		$this->view->assign('conf', $this->conf);
		$this->view->assign('_title', $this->_title);
		$this->view->assign('_nav', $this->_nav);
		$this->view->assign('_seo_keywords', $this->_seo_keywords);
		$this->view->assign('_seo_description', $this->_seo_description);
		$this->view->assign('_checked', $this->_checked);
		$this->view->assign('_cron_1_run', $this->_cron_1_run);
		
		// hook xgcms_common_control_init_view_after.php
	}
	
	// 初始化 sid
	private function init_sid() {
		$key = $this->conf['cookie_pre'].'sid';
		$sid = core::gpc($key, 'R');
		if(!$sid) {
			$sid = substr(md5($_SERVER['REMOTE_ADDR'].rand(1, 2147483647)), 0, 16); // 兼容32,64位
			misc::setcookie($key, $sid, $_SERVER['time'] + 86400 * 30, $this->conf['cookie_path'], $this->conf['cookie_domain']);
		}
		$this->_sid = $sid;
		$this->view->assign('_sid', $this->_sid);
		
		define('FORM_HASH', misc::form_hash($this->conf['auth_key']));
		
		// hook xgcms_common_control_init_sid_after.php
	}
	
	// 初始化 _user, 解密 cookie
	private function init_user() {
		$auth = core::gpc($this->conf['cookie_pre'].'auth', 'R');
		$this->view->assign('_auth', $auth);
		
		$this->_user = $this->user->decrypt_auth($auth);

		$this->view->assign('_user', $this->_user);
		
		$this->_group = $this->group->read($this->_user['groupid']);
		$this->view->assign('_group', $this->_group);
		
		// 如果管理员超出一天，IP地址发生变化，则提示重新登录，每天必须强行登陆一次。
		if($this->_user['groupid'] == 1 && $_SERVER['time'] - $this->_user['cookietime'] > 86400 && !$this->_user['ip_right']) {
			misc::setcookie($this->conf['cookie_pre'].'auth', '', 0, $this->conf['cookie_path'], $this->conf['cookie_domain']);
			$this->message('尊敬的管理员，系统检测到您的IP发生变化，为了您的安全，请重新登录。<script>setTimeout("window.location.reload()", 2000);</script>', 0);
		}
		$this->_user['groupname'] = $this->_group['name'];
		$pr='Po'.'wer'.'ed b'.'y <a href="htt'.'p://w'.'ww.x'.'gc'.'ms.co'.'m" target="_blank" class="pr">x'.'gc'.'ms v'.$this->conf['version'].'</a>';
		$this->conf['footer_js']=$pr.' '.$this->conf['footer_js'];
		// hook xgcms_common_control_init_user_after.php
	}

	// 初始化用户组相关数据
	private function init_group() {
	
		$groupid = $this->_user['groupid'];
		
		// hook xgcms_common_control_init_group_after.php
	}
	
	// 检查域名，如果不在安装域名下，跳转到安装域名。
	private function check_domain() {
		$appurl = $this->conf['app_url'];
		preg_match('#^https?://([^/]+)/#', $appurl, $m);
		$installhost = $m[1];
		$host = core::gpc('HTTP_HOST', 'S');
		if($host != $m[1]) {
			$currurl = misc::get_script_uri();
			$newurl = preg_replace('#^https?://([^/]+)/#', "http://$installhost/", $currurl);
			header("Location: $newurl");
			exit;
		}
		
		/* 
			/bbs/index.php?user-login.htm
			/bbs/index.php?
			/bbs/index.php
			/index.php
			/
			/?
		 */
		// 兼容 iis
		$pos = strrpos($_SERVER['REQUEST_URI'], '/');
		if(substr($_SERVER['REQUEST_URI'], $pos + 1, 9) == 'index.php') {
			$_SERVER['REQUEST_URI'] = substr_replace($_SERVER['REQUEST_URI'], '', $pos + 1, 9);
		}
		
		// 判断是否开启了 urlrewrite
		if($this->conf['urlrewrite']) {
			// 查找最后一个 /
			if(substr($_SERVER['REQUEST_URI'], $pos + 1, 1) == '?') {
				// 去掉 ?
				$_SERVER['REQUEST_URI'] = substr($_SERVER['REQUEST_URI'], 0, $pos + 1).substr($_SERVER['REQUEST_URI'], $pos + 2);
				$newurl = misc::get_script_uri();
				header("Location: $newurl");
				exit;
			}
		} else {
			// 垃圾的 iis 某些情况下, 居然在请求 / 时候，REQUEST_URI 为 /Index.php，第一个字母还大写！iis, go to hell!
			/*
			if($pos + 1 != strlen($_SERVER['REQUEST_URI']) && substr($_SERVER['REQUEST_URI'], $pos + 1, 1) != '?' && strtolower(substr($_SERVER['REQUEST_URI'], -10)) != '/index.php') {
				// 加上 ?
				$_SERVER['REQUEST_URI'] = substr($_SERVER['REQUEST_URI'], 0, $pos + 1).'?'.substr($_SERVER['REQUEST_URI'], $pos + 1);
				$newurl = misc::get_script_uri();
				header("Location: $newurl");
				exit;
			}
			*/
		}
	}
	
	public function check_ip() {
		$ip = $_SERVER['ip'];
		if(($this->_user['groupid'] == 0 || $this->_user['groupid'] > 4) && $this->conf['iptable_on']) {
			if($this->banip->is_banip($ip)) {
				$this->message("您的IP $ip 已经被禁止，如果有疑问，请联系管理员。", 0);
			}
		}
	}
	// 检查是否登录
	public function check_login() {
		if(empty($this->_user['uid'])) {
			$this->message('您还没有登录，请先登录。', -1); // .print_r($_COOKIE, 1)
		}
	}
	
	protected function check_user_exists($user) {
		if(empty($user)) {
			$this->message('用户不存在！可能已经被删除。', 0);
		}
	}
		// 检测用户权限，主要为全局禁止，优先级:1, $expiry 为解除禁止权限的时间。
	protected function check_user_access($user, $action = 'post', &$message) {
		$uid = $user['uid'];
		$actiontext = array('read'=>'访问栏目', 'post'=>'投稿', 'attach'=>'上传附件', 'down'=>'下载附件');
		
		// hook xgcms_common_control_check_user_access_actiontext_after.php
		
		// 跳过检测
		if(!isset($actiontext[$action])) return TRUE;
		if($user['groupid'] == 1) return TRUE;
		
		if(!isset($user['accesson'])) {
			$user = $this->user->read($user['uid']);
		}
		
		if($user['accesson']) {
			$access = $this->user_access->read($uid);
			// 如果用户被删除
			if(empty($access)) {
				$user = $this->user->read($uid);
				if(empty($user)) {
					$message = '您的账户可能已经被删除。';
					return FALSE;
				}
			}
			// 判断过期时间，如果已经过期，则恢复权限。
			if($access['expiry'] < $_SERVER['time']) {
				$this->user_access->reset($uid);
				return TRUE;
			}
			if($access['allow'.$action]) {
				return TRUE;
			} else {
				$expiry = date('Y-n-j', $access['expiry']);
				$message = '您没有['.$actiontext[$action].']的权限，该限制会在['.$expiry.']解除。如果您有疑问，请联系管理员！';
				return FALSE;
			}
		} else {
			return TRUE;
		}
	}
	
	// 检测用户组权限，优先级:2
	protected function check_group_access($group, $action, &$message) {
		$actiontext = array('read'=>'访问栏目', 'post'=>'投稿', 'attach'=>'上传附件', 'down'=>'下载附件');
		
		// hook xgcms_common_control_check_group_access_actiontext_after.php
		
		if(empty($group['allow'.$action])) {
			$message = '您所在的用户组('.$this->_group['name'].')没有('.$actiontext[$action].')的权限。如果您有疑问，请联系管理员！';
			return FALSE;
		} else {
			return TRUE;
		}
	}
	
	// 检测版块权限，优先级:3
	protected function check_cate_access($cate, $action = 'post', &$message) {
		$actiontext = array('read'=>'访问栏目', 'post'=>'投稿', 'attach'=>'上传附件', 'down'=>'下载附件');
		
		// hook xgcms_common_control_check_forum_access_actiontext_after.php
		
		// 跳过检测
		if(!isset($actiontext[$action])) return TRUE;
		
		// 如果没有权限限制，默认是允许
		if(!$cate['accesson']) return TRUE;
		
		$access = $this->xgcms_category_accesson->read($cate['catid'], $this->_user['groupid']);
		if(empty($access)) return TRUE;
		
		if($access['allow'.$action]) {
			return TRUE;
		} else {
			$loginadd = empty($this->_user['uid']) ? ' <a href="?user-login-ajax-1.htm" class="ajaxdialog" onclick="return false" rel="nofollow">点击登录</a>' : '';
			$message =  '您没有对该栏目的(<b>'.$actiontext[$action].'</b>)权限！'.$loginadd;
			return FALSE;
		}
	}
	
	// 综合权限检测：非版主权限的操作。
	protected function check_access($cate, $action) {
		$user = $this->_user;
		$group = $this->_group;
	
		$adminaction = array('update'=>'编辑内容', 'delete'=>'删除内容', 'banuser'=>'禁止用户', 'deleteuser'=>'删除用户');
		
		// hook xgcms_common_control_check_access_adminaction_after.php
		
		if(!isset($adminaction[$action])) {
			// 判断该用户是否已经被禁止该权限。
			if(!$this->check_user_access($user, $action, $message)) {
				$this->message($message, 0);
			}
			
			// 用户组如果不允许发帖，则不允许
			if(!$this->check_group_access($group, $action, $message)) {
				$this->message($message, 0);
			} else {
				// 如果版块设置了权限，那么还有最后一线希望，看版块是否允许这个用户组的操作
				if(!empty($cate['accesson'])) {
					
					// 如果版块也没有允许此用户组的权限，则提示错误，中断操作！
					if(!$this->check_cate_access($cate, $action, $message)) {
						$this->message($message, 0);
					} 
				}
			}
		} else {
			if(!$this->check_group_access($group, $action, $message)) {
				$this->message("对不起，($group[name])没有在($cate[name])的({$adminaction[$action]})权限。", 0);
			}
			if(!$this->is_mod($cate, $user)) {
				$this->message("对不起，($group[name])没有权限管理($cate[catname])。", 0);
			}
		}
	}
	/*
	 * 功  能：
	 * 	提示单条信息
	 *  
	 * 用  法：
		 $this->message('站点维护中，请稍后访问！');
		$this->message('提交成功！', TRUE, '?forum-index-123.htm');
		$this->message('校验错误！', FALSE);
	 */
	public function message($message, $status = 1, $goto = '') {
		
		// hook xgcms_common_control_message_before.php
		
		if(core::gpc('ajax', 'R')) {
			// 可能为窗口，也可能不为。
			$json = array('servererror'=>'', 'status'=>$status, 'message'=>$message);
			echo core::json_encode($json);
			exit;
		} else {
			$this->view->assign('message', $message);
			$this->view->assign('status', $status);
			$this->view->assign('goto', $goto);
			$this->view->display('message.htm');
			exit;
		}
	}
	
	// relocation
	public function url($url) {
		$url[0] == '?' && $url = substr($url, 1);
		return $this->conf['app_url'].($this->conf['urlrewrite'] ? '' : '?').$url;
	}
	
	// relocation
	public function location($url) {
		header("Location: ".$url);
		exit;
	}
	
	public function form_submit() {
		// hook form_submit_after.php
		// hook xgcms_common_form_hash.php
		return misc::form_submit($this->conf['auth_key']);
	}
	
	protected function clear_tmp($pre = '') {
		$len = strlen($pre);
		$dh = opendir($this->conf['tmp_path']);
		while(($file = readdir($dh)) !== FALSE ) {
			if($file != "." && $file != ".." && $file[0] != '.') {
				if(empty($pre) || substr($file, 0, $len) == $pre) {
					$filename = $this->conf['tmp_path']."$file";
					is_file($filename) && unlink($filename);
				}
			}
		}
		closedir($dh);
	}

	protected function html_cache(){
		if($this->htmlcache_modules()){
			$file=$this->get_cache_file();
			if($_GET[0]=='list'){
				$cache=$this->conf['cache_list_time'];
			}elseif($_GET[0]=='show'){
				$cache=$this->conf['cache_show_time'];	
			}else{
				$cache=8640000;
			}
			if(is_file($file)&&($_SERVER['time']-filemtime($file))<$cache){
				include $file;
				if(!core::gpc('ajax','G')&&DEBUG) echo "<script>$('#runtime').html('".(number_format(microtime(1) - $_SERVER['starttime'],4))."');</script>";
				exit;
			}	
		}
	}
	protected function htmlcache_modules(){
	    return in_array($_GET[0],$this->conf['html_cache_modules']);
    }
	protected function build_html_start($data=''){
		if($data&&core::gpc('ajax')){
			$body = core::json_encode($data);
			if($this->conf['html_cache']){
				ob_start();
				echo $body;
				$body = ob_get_contents();
				ob_end_clean();
				$file=$this->get_cache_file();
				file_put_contents($file,$body);
			}
			echo $body;
			exit;
		}elseif($this->conf['html_cache']){
			ob_start();
		}
	}
	protected function build_html_end(){
		if($this->conf['html_cache']){  
			$body = ob_get_contents();
			ob_end_clean();
			$file=$this->get_cache_file();
			file_put_contents($file,$body);
			echo $body;
		}
	}
	protected function get_cache_file(){
		$url=misc::get_script_uri();
		$url_md5=md5($url).'.html';

		$path=$this->conf['html_cache_path'].$_GET[0].'/'.$_GET[1].'/';
		$dir1=utf8::substr($url_md5,0,2);
		$dir2=utf8::substr($url_md5,2,2);
		$dir = $path.$dir1.'/'.$dir2.'/';
		
		if(in_array($_GET[0],array('list','index','show'))){
			if(!file_exists($dir)) {
				mkdir($dir, 0777, true);
			}
		}
		return $file=$dir.$url_md5;
	}
	protected function check_cate_exists($cate){
		if(empty($cate)) {
			$this->message('栏目不存在！可能被设置了隐藏。', 0);
		}
	}
	protected function catpos($catid, $symbol='<i>&gt;</i>'){
		$category_arr = $this->mcache->read('category_arr');
		if(!isset($category_arr[$catid])) return '';
		$pos = '';
		$arrparentid = array_filter(explode(',', $category_arr[$catid]['arrparentid'].','.$catid));
		
		foreach($arrparentid as $catid) {
			$url = $category_arr[$catid]['url'];
			$pos .= '<a href="'.$url.'">'.$category_arr[$catid]['catname'].'</a>'.$symbol;
		}
		return $pos;
	}

	protected function pages($num, $curr_page, $perpage = 20, $urlrule = '', $array = array(),$setpages = 6) {
		  $multipage = '';
		  if($num > $perpage) {
			  $page = $setpages+1;
			  $offset = ceil($setpages/2-1);
			  $pages = ceil($num / $perpage);
			  $from = $curr_page - $offset;
			  $to = $curr_page + $offset;
			  $more = 0;
			  if($page >= $pages) {
				  $from = 2;
				  $to = $pages-1;
			  } else {
				  if($from <= 1) {
					  $to = $page-1;
					  $from = 2;
				  }  elseif($to >= $pages) {
					  $from = $pages-($page-2);
					  $to = $pages-1;
				  }
				  $more = 1;
			  }
			  $multipage .= '<a class="a1">总数:'.$num.'</a>';
			  if($curr_page>0) {
				  $curr_page>1 && $multipage .= ' <a href="'.$this->pageurl($urlrule, $curr_page-1, $array).'" class="a1">上一页</a>';
				  if($curr_page==1) {
					  $multipage .= ' <span>1</span>';
				  } elseif($curr_page>6 && $more) {
					  $multipage .= ' <a href="'.$this->pageurl($urlrule, 1, $array).'">1</a>..';
				  } else {
					  $multipage .= ' <a href="'.$this->pageurl($urlrule, 1, $array).'">1</a>';
				  }
			  }
			  for($i = $from; $i <= $to; $i++) {
				  if($i != $curr_page) {
					  $multipage .= ' <a href="'.$this->pageurl($urlrule, $i, $array).'">'.$i.'</a>';
				  } else {
					  $multipage .= ' <span>'.$i.'</span>';
				  }
			  }
			  if($curr_page<$pages) {
				  if($curr_page<$pages-5 && $more) {
					  $multipage .= ' ..<a href="'.$this->pageurl($urlrule, $pages, $array).'">'.$pages.'</a> <a href="'.$this->pageurl($urlrule, $curr_page+1, $array).'" class="a1">下一页</a>';
				  } else {
					  $multipage .= ' <a href="'.$this->pageurl($urlrule, $pages, $array).'">'.$pages.'</a> <a href="'.$this->pageurl($urlrule, $curr_page+1, $array).'" class="a1">下一页</a>';
				  }
			  } elseif($curr_page==$pages) {
				  $multipage .= ' <span>'.$pages.'</span> <a href="'.$this->pageurl($urlrule, $curr_page, $array).'" class="a1">下一页</a>';
			  } else {
				  $multipage .= ' <a href="'.$this->pageurl($urlrule, $pages, $array).'">'.$pages.'</a> <a href="'.$this->pageurl($urlrule, $curr_page+1, $array).'" class="a1">下一页</a>';
			  }
		  }
		  return $multipage;
     }
	 private function pageurl($urlrule, $page, $array = array()) {
		  if(strpos($urlrule, '~')) {
			  $urlrules = explode('~', $urlrule);
			  $urlrule = $page < 2 ? $urlrules[0] : $urlrules[1];
		  }
		  $findme = array('[page]');
		  $replaceme = array($page);
		  if (is_array($array)) foreach ($array as $k=>$v) {
			  $findme[] = '['.$k.']';
			  $replaceme[] = $v;
		  }
		  $url = str_replace($findme, $replaceme, $urlrule);
		  $url = str_replace(array('http://','//','~'), array('~','/','http://'), $url);
		  return $url;
	  }
	  
	  /**
	   * URL路径解析，pages 函数的辅助函数
	   *
	   * @param $par 传入需要解析的变量 默认为，page={$page}
	   * @param $url URL地址
	   * @return URL
	   */
	  private function url_par($par, $url = '') {
		  $pos = strpos($url, '?');
		  if($pos === false) {
			  $url .= '?'.$par;
		  } else {
			  $querystring = substr(strstr($url, '?'), 1);
			  parse_str($querystring, $pars);
			  $query_array = array();
			  foreach($pars as $k=>$v) {
				  if($k != 'page') $query_array[$k] = $v;
			  }
			  $querystring = http_build_query($query_array).'&'.$par;
			  $url = substr($url, 0, $pos).'?'.$querystring;
		  }
		  return $url;
	  }
	// 是否为最高级别的管理员
	protected function check_admin_group() {
		if($this->_group['groupid'] != 1) {
			$this->message('对不起，您不是管理员，无权访问。', 0);
		}
	}
}
?>