<?php
/**
 * 返回经addslashes处理过的字符串或数组
 * @param $string 需要处理的字符串或数组
 * @return mixed
 */
function new_addslashes($string){
	if(!is_array($string)) return addslashes($string);
	foreach($string as $key => $val) $string[$key] = new_addslashes($val);
	return $string;
}

/**
 * 返回经stripslashes处理过的字符串或数组
 * @param $string 需要处理的字符串或数组
 * @return mixed
 */
function new_stripslashes($string) {
	if(!is_array($string)) return stripslashes($string);
	foreach($string as $key => $val) $string[$key] = new_stripslashes($val);
	return $string;
}
/**
* 将字符串转换为数组
*
* @param	string	$data	字符串
* @return	array	返回数组格式，如果，data为空，则返回空数组
*/
function string2array($data) {
	if($data == '') return array();
	if(substr($data,0,2)=='{"') return core::json_decode($data);
	@eval("\$array = $data;");
	return $array;
}
/**
* 将数组转换为字符串
*
* @param	array	$data		数组
* @param	bool	$isformdata	如果为0，则不使用new_stripslashes处理，可选参数，默认为1
* @return	string	返回字符串，如果，data为空，则返回空
*/
function array2string($data, $isformdata = 1) {
	if($data == '') return '';
	if($isformdata) $data = new_stripslashes($data);
	return addslashes(var_export($data, TRUE));
}


class content_form {
	var $modelid;
	var $fields;
	var $id;
	var $formValidator;

    function __construct($modelid,$catid = 0,$categorys = array(),$fields=array(),$type_data=array(),$poss=array()) {
		$this->modelid = $modelid;
		$this->catid = $catid;
		$this->categorys = $categorys;
		$this->fields = $fields;
		$this->siteid = 1;
		$this->type_data = $type_data;
		$this->poss=$poss;
    }

	function get($data = array()) {
		$_groupid =0;// param::get_cookie('_groupid');
		$this->data = $data;
		if(isset($data['id'])) $this->id = $data['id'];
		$info = array();
		$this->content_url = $data['url'];
		
		foreach($this->fields as $field=>$v) {
			
			if(defined('IN_ADMIN')) {
				if($v['iscore']||$v['disabled']) continue;
			} else {
				if($v['iscore'] || !$v['isadd']) continue;
			}
			$func = $v['formtype'];
			$value = isset($data[$field]) ? htmlspecialchars($data[$field], ENT_QUOTES) : '';
			if($func=='pages' && isset($data['maxcharperpage'])) {
				$value = $data['paginationtype'].'|'.$data['maxcharperpage'];
			}
			if(!method_exists($this, $func)) continue;
			$form = $this->$func($field, $value, $v);

			if($form !== false) {
				if(defined('IN_ADMIN')) {
					if($v['isbase']) {
						$star = $v['minlength'] || $v['pattern'] ? 1 : 0;
						$info['base'][$field] = array('name'=>$v['name'], 'tips'=>$v['tips'], 'form'=>$form, 'star'=>$star,'isomnipotent'=>$v['isomnipotent'],'formtype'=>$v['formtype']);
					} else {
						$star = $v['minlength'] || $v['pattern'] ? 1 : 0;
						$info['senior'][$field] = array('name'=>$v['name'], 'tips'=>$v['tips'], 'form'=>$form, 'star'=>$star,'isomnipotent'=>$v['isomnipotent'],'formtype'=>$v['formtype']);
					}
				} else {
					$star = $v['minlength'] || $v['pattern'] ? 1 : 0;
					$info[$field] = array('name'=>$v['name'], 'tips'=>$v['tips'], 'form'=>$form, 'star'=>$star,'isomnipotent'=>$v['isomnipotent'],'formtype'=>$v['formtype']);
				}
			}
		}
		return $info;
	}
	function text($field, $value, $fieldinfo) {
		extract($fieldinfo);
		$setting = string2array($setting);
		$size = $setting['size'];
		if(!$value) $value = isset($defaultvalue)?$defaultvalue:'';
		$type = $ispassword ? 'password' : 'text';
		$errortips = $this->fields[$field]['errortips'];
		if($errortips || $minlength) $this->formValidator .= '$("#'.$field.'").formValidator({onshow:"",onfocus:"'.$errortips.'"}).inputValidator({min:1,onerror:"'.$errortips.'"});';
		return '<input type="text" name="info['.$field.']" id="'.$field.'" size="'.$size.'" value="'.$value.'" class="input-text" '.$formattribute.' '.$css.'>';
	}
	function textarea($field, $value, $fieldinfo) {
		extract($fieldinfo);
		$setting = string2array($setting);
		extract($setting);
		if(!$value) $value = isset($defaultvalue)?$defaultvalue:'';
		$allow_empty = 'empty:true,';
		if($minlength || $pattern) $allow_empty = '';
		if($errortips) $this->formValidator .= '$("#'.$field.'").formValidator({'.$allow_empty.'onshow:"'.$errortips.'",onfocus:"'.$errortips.'"}).inputValidator({min:1,onerror:"'.$errortips.'"});';
		$value = empty($value) ? $setting['defaultvalue'] : $value;
		$str = "<textarea name='info[{$field}]' id='$field' style='width:{$width}%;height:{$height}px;' $formattribute $css";
		if($maxlength) $str .= " onkeyup=\"strlen_verify(this, '{$field}_len', {$maxlength})\"";
		$str .= ">{$value}</textarea>";
		if($maxlength) $str .= '可以输入<B><span id="'.$field.'_len">'.$maxlength.'</span></B> 个字符';
		return $str;
	}
	function editor($field, $value, $fieldinfo) {
		extract($fieldinfo);
		extract(string2array($setting));
		$disabled_page = isset($disabled_page) ? $disabled_page : 0;
		if(!isset($height)) $height = 300;
		$allowupload = defined('IN_ADMIN') ? 1 :  0;
		if(!$value) $value = isset($defaultvalue)?$defaultvalue:'';
		if($minlength || $pattern) $allow_empty = '';
		return "<div id='{$field}_tip'></div>".'<textarea name="info['.$field.']" id="'.$field.'" boxid="'.$field.'" style="height:'.$height.'px">'.$value.'</textarea>'.xgform::editor($field,$toolbar,'content',$this->catid,'',$allowupload,1,'',$height,$disabled_page);
	}
	function catid($field, $value, $fieldinfo) {
		if(!$value) $value = $this->catid;
	
		return '<input type="hidden" name="info['.$field.']" value="'.$value.'">'.$this->categorys[$value]['catname'];
	}
	function title($field, $value, $fieldinfo) {
		
		extract($fieldinfo);
		$style_arr = explode(';',$this->data['style']);
		$style_color = $style_arr[0];
		$style_font_weight = isset($style_arr[1]) ? $style_arr[1] : '';

		$style = 'color:'.$this->data['style'];
		if(!$value) $value = isset($defaultvalue)?$defaultvalue:'';
		$errortips = $this->fields[$field]['errortips'];
		$errortips_max = '标题为空';
		if($errortips) $this->formValidator .= '$("#'.$field.'").formValidator({onshow:"",onfocus:"'.$errortips.'"}).inputValidator({min:'.$minlength.',max:'.$maxlength.',onerror:"'.$errortips_max.'"});';
		//$str = '<input type="text" style="width:400px;'.($style_color ? 'color:'.$style_color.';' : '').($style_font_weight ? 'font-weight:'.$style_font_weight.';' : '').'" name="info['.$field.']" id="'.$field.'" value="'.$value.'" style="'.$style.'" class="measure-input " onBlur="$.post(\'api.php?op=get_keywords&number=3&sid=\'+Math.random()*5, {data:$(\'#title\').val()}, function(data){if(data && $(\'#keywords\').val()==\'\') $(\'#keywords\').val(data); })" onkeyup="strlen_verify(this, \'title_len\', '.$maxlength.');"/>';
		$str = '<input type="text" style="width:400px;'.($style_color ? 'color:'.$style_color.';' : '').($style_font_weight ? 'font-weight:'.$style_font_weight.';' : '').'" name="info['.$field.']" id="'.$field.'" value="'.$value.'" style="'.$style.'" class="measure-input " onBlur="check_title('.$maxlength.');" /><br /><span id="title_notice"></span>';
		return $str;
	}
	function box($field, $value, $fieldinfo) {

		$setting = string2array($fieldinfo['setting']);
		if($value=='') $value = isset($this->fields[$field]['defaultvalue'])?$this->fields[$field]['defaultvalue']:'';
		$options=isset($this->fields[$field]['options'])?$this->fields[$field]['options']:'';
		$options = explode("\n",$options);
		foreach((array)$options as $_k) {
			if(empty($_k)) continue;
			$v = explode("|",$_k);
			$k = trim($v[1]);
			$option[$k] = $v[0];
		}
		$values = explode(',',$value);
		$value = array();
		foreach($values as $_k) {

			if($_k != '') $value[] = $_k;
		}
		$value = implode(',',$value);
		
		switch($this->fields[$field]['boxtype']) {
			case 'radio':
				$string = xgform::radio($option,$value,"name='info[$field]' $fieldinfo[formattribute]",$setting['width'],$field);
			break;

			case 'checkbox':
				$string = xgform::checkbox($option,$value,"name='info[$field][]' $fieldinfo[formattribute]",1,$setting['width'],$field);
			break;

			case 'select':
				$string = xgform::select($option,$value,"name='info[$field]' id='$field' $fieldinfo[formattribute]");
			break;

			case 'multiple':
				$string = xgform::select($option,$value,"name='info[$field][]' id='$field ' size=2 multiple='multiple' style='height:60px;' $fieldinfo[formattribute]");
			break;
		}
		return $string;
	}
	function image($field, $value, $fieldinfo) {
		$setting = string2array($fieldinfo['setting']);
		extract($setting);
		
		$str="<script>
			KindEditor.ready(function(K) {
				var editor = K.editor({
					uploadJson:upload_url,
					filePostName :'Filedata',
					allowFileManager : true
				});
				K('#".$field."_btn').click(function() {
					editor.loadPlugin('image', function() {
						editor.plugin.imageDialog({
							imageUrl : K('#".$field."').val(),
							clickFn : function(url, title, width, height, border, align) {
								K('#".$field."').val(url);
								editor.hideDialog();
							}
						});
					});
				});
				});
		</script>
		";
		$str.="<input type='text' name='info[$field]' id='$field' value='$value' size='$size' class='input-text' /> ";
		
		$str.='<a type="button" id="'.$field.'_btn" class="button smallblue"><span>选择图片</span></a>';
		
		return $str;
	}
	function images($field, $value, $fieldinfo) {
	    return '';
	}
	function datetime($field, $value, $fieldinfo) {
		extract(string2array($fieldinfo['setting']));
		$isdatetime = 0;
		$timesystem = 0;
		if($fieldtype=='int') {
			if(!$value) $value = $_SERVER['time'];
			$format_txt = $format == 'm-d' ? 'm-d' : $format;
			if($format == 'Y-m-d Ah:i:s') $format_txt = 'Y-m-d h:i:s';
			$value = date($format_txt,$value);
			
			$isdatetime = strlen($format) > 6 ? 1 : 0;
			if($format == 'Y-m-d Ah:i:s') {
				
				$timesystem = 0;
			} else {
				$timesystem = 1;
			}			
		} elseif($fieldtype=='datetime') {
			$isdatetime = 1;
			$timesystem = 1;
		} elseif($fieldtype=='datetime_a') {
			$isdatetime = 1;
			$timesystem = 0;
		}
		return xgform::date("info[$field]",$value,$isdatetime,1,'true',$timesystem);
	}
	function posid($field, $value, $fieldinfo) {
		$poss=$this->poss;
		//$value = implode(',',$value);
		$string = xgform::checkbox($poss,$value,"name='info[$field][]' $fieldinfo[formattribute]",1,80,$field);
		return $string;
	}
	function keyword($field, $value, $fieldinfo) {
		extract($fieldinfo);
		if(!$value) $value = isset($defaultvalue)?$defaultvalue:'';
		return "<input type='text' name='info[$field]' id='$field' value='$value' style='width:280px' {$formattribute} {$css} class='input-text'>";
	}
	function author($field, $value, $fieldinfo) {
		return '<input type="text" name="info['.$field.']" value="'.$value.'" size="30">';
	}
	function copyfrom($field, $value, $fieldinfo) {
		$value_data = '';
		if($value && strpos($value,'|')!==false) {
			$arr = explode('|',$value);
			$value = $arr[0];
			$value_data = $arr[1];
		}
		$copyfrom_array = getcache('copyfrom','admin');
		$copyfrom_datas = array(L('copyfrom_tips'));
		if(!empty($copyfrom_array)) {
			foreach($copyfrom_array as $_k=>$_v) {
				if($this->siteid==$_v['siteid']) $copyfrom_datas[$_k] = $_v['sitename'];
			}
		}
		return "<input type='text' name='info[$field]' value='$value' style='width: 400px;' class='input-text'>".xgform::select($copyfrom_datas,$value_data,"name='{$field}_data' ");
	}
	function groupid($field, $value, $fieldinfo) {
		
		return '';
	}
	function islink($field, $value, $fieldinfo) {
		if($value) {
			$url = $this->data['url'];
			$checked = 'checked';
			$_GET['islink'] = 1;
		} else {
			$disabled = 'disabled';
			$url = $checked = '';
			$_GET['islink'] = 0;
		}
		$size = isset($fieldinfo['size']) ? $fieldinfo['size'] : 25;
		return '<input type="hidden" name="info[islink]" value="0"><input type="text" name="linkurl" id="linkurl" value="'.$url.'" size="'.$size.'" maxlength="255" '.$disabled.' class="input-text"> <input name="info[islink]" type="checkbox" id="islink" value="1" onclick="ruselinkurl();" '.$checked.'> <font color="red">是否链接</font>';
	}
	function template($field, $value, $fieldinfo) {
		return '';
	}
	function pages($field, $value, $fieldinfo) {
		return '';
	}
	function typeid($field, $value, $fieldinfo) {

		extract($fieldinfo);
		$setting = string2array($setting);
		if(!$value) $value = $setting['defaultvalue'];
		if($errortips) {
			$errortips = $this->fields[$field]['errortips'];
			$this->formValidator .= '$("#'.$field.'").formValidator({onshow:"",onfocus:"'.$errortips.'"}).inputValidator({min:1,onerror:"'.$errortips.'"});';
		}
		$usable_type = $this->categorys[$this->catid]['usable_type'];
		$usable_array = array();
		if($usable_type) $usable_array = explode(',',$usable_type);
		

			$siteid = $this->siteid;

		$type_data = $this->type_data;
		$data=array();
		if($type_data) {
			foreach($type_data as $_key=>$_value) {
				if(in_array($_key,$usable_array)) $data[$_key] = $_value['name'];
			}
		}
		return xgform::select($data,$value,'name="info['.$field.']" id="'.$field.'" '.$formattribute.' '.$css);
	}
	function readpoint($field, $value, $fieldinfo) {
		$paytype = $this->data['paytype'];
		if($paytype) {
			$checked1 = '';
			$checked2 = 'checked';
		} else {
			$checked1 = 'checked';
			$checked2 = '';
		}
		return '<input type="text" name="info['.$field.']" value="'.$value.'" size="5"><input type="radio" name="info[paytype]" value="0" '.$checked1.'> 积分 <input type="radio" name="info[paytype]" value="1" '.$checked2.'>资金';
	}
	function linkage($field, $value, $fieldinfo) {
		$setting = string2array($fieldinfo['setting']);
		$linkageid = $setting['linkageid'];
		return menu_linkage($linkageid,$field,$value);
	}
	function downfile($field, $value, $fieldinfo) {
		$list_str = $str = '';
		extract(string2array($fieldinfo['setting']));
		if($value){
			$value_arr = explode('|',$value);
			$value = $value_arr['0'];
			$sel_server = $value_arr['1'] ? explode(',',$value_arr['1']) : '';
			$edit = 1;
		} else {
			$edit = 0;
		}
		$server_list = getcache('downservers','commons');
		if(is_array($server_list)) {
			foreach($server_list as $_k=>$_v) {
				if (in_array($_v['siteid'],array(0,$fieldinfo['siteid']))) {
					$checked = $edit ? ((is_array($sel_server) && in_array($_k,$sel_server)) ? ' checked' : '') : ' checked';
					$list_str .= "<lable id='downfile{$_k}' class='ib lh24' style='width:25%'><input type='checkbox' value='{$_k}' name='{$field}_servers[]' {$checked}>  {$_v['sitename']}</lable>";
				}
			}
		}
	
		$string = '
		<fieldset class="blue pad-10">
        <legend>'.L('mirror_server_list').'</legend>';
		$string .= $list_str;
		$string .= '</fieldset>
		<div class="bk10"></div>
		';	
		if(!defined('IMAGES_INIT')) {
			$str = '<script type="text/javascript" src="'.JS_PATH.'swfupload/swf2ckeditor.js"></script>';
			define('IMAGES_INIT', 1);
		}	
		$authkey = upload_key("$upload_number,$upload_allowext,$isselectimage");	
		$string .= $str."<input type='text' name='info[$field]' id='$field' value='$value' class='input-text' style='width:80%'/>  <input type='button' class='button' onclick=\"javascript:flashupload('{$field}_downfield', '".L('attachment_upload')."','{$field}',submit_files,'{$upload_number},{$upload_allowext},{$isselectimage}','content','$this->catid','{$authkey}')\"/ value='".L('upload_soft')."'>";
		return $string;
	}
	function downfiles($field, $value, $fieldinfo) {
		extract(string2array($fieldinfo['setting']));
		$list_str = '';
		if($value) {
			$value = string2array(html_entity_decode($value,ENT_QUOTES));
			if(is_array($value)) {
				foreach($value as $_k=>$_v) {
				$list_str .= "<div id='multifile{$_k}'><input type='text' name='{$field}_fileurl[]' value='{$_v[fileurl]}' style='width:310px;' class='input-text'> <input type='text' name='{$field}_filename[]' value='{$_v[filename]}' style='width:160px;' class='input-text'> <a href=\"javascript:remove_div('multifile{$_k}')\">".L('remove_out')."</a></div>";
				}
			}
		}
		$string = '<input name="info['.$field.']" type="hidden" value="1">
		<fieldset class="blue pad-10">
        <legend>'.L('file_list').'</legend>';
		$string .= $list_str;
		$string .= '<ul id="'.$field.'" class="picList"></ul>
		</fieldset>
		<div class="bk10"></div>
		';
		
		if(!defined('IMAGES_INIT')) {
			$str = '<script type="text/javascript" src="'.JS_PATH.'swfupload/swf2ckeditor.js"></script>';
			define('IMAGES_INIT', 1);
		}
		$authkey = upload_key("$upload_number,$upload_allowext,$isselectimage");
		$string .= $str."<input type=\"button\"  class=\"button\" value=\"".L('multiple_file_list')."\" onclick=\"javascript:flashupload('{$field}_multifile', '".L('attachment_upload')."','{$field}',change_multifile,'{$upload_number},{$upload_allowext},{$isselectimage}','content','$this->catid','{$authkey}')\"/>    <input type=\"button\" class=\"button\" value=\"".L('add_remote_url')."\" onclick=\"add_multifile('{$field}')\">";
		return $string;
	}
	function map($field, $value, $fieldinfo) {
		extract($fieldinfo);
		$setting = string2array($setting);
		$size = $setting['size'];
		$errortips = $this->fields[$field]['errortips'];
		$modelid = $this->fields[$field]['modelid'];
		$tips = $value ? L('editmark','','map') : L('addmark','','map');
		return '<input type="button" name="'.$field.'_mark" id="'.$field.'_mark" value="'.$tips.'" class="button" onclick="omnipotent(\'selectid\',\''.APP_PATH.'api.php?op=map&field='.$field.'&modelid='.$modelid.'\',\''.L('mapmark','','map').'\',1,700,420)"><input type="hidden" name="info['.$field.']" value="'.$value.'" id="'.$field.'" >';
	}
	function omnipotent($field, $value, $fieldinfo) {
		return '';
	}

	function video($field, $value, $fieldinfo) {
		$value_data = '';
		//获取flash上传属性
		pc_base::load_app_class('ku6api', 'video', 0);
		$setting = getcache('video', 'video');
		if(empty($setting)) return L('please_input_video_setting');
		$ku6api = new ku6api($setting['sn'], $setting['skey']);
		$flash_info = $ku6api->flashuploadparam();
		
		//获取上传的视频
		$key = 0;
		$list_str = "<div style='padding:1px'><ul class=\"tbsa\" id=\"video_{$field}_list\">";
		if($value) {
			$video_content_db = pc_base::load_model('video_content_model');
			$video_store_db = pc_base::load_model('video_store_model');
			$videos = $video_content_db->select(array('contentid'=>$this->id), 'videoid, listorder', '', '`listorder` ASC', '', 'videoid');
			if (!empty($videos)) {
				$videoids = '';
				foreach ($videos as $v) {
					$videoids .= $v['videoid'].',';
				}
				$videoids = substr($videoids, 0, -1);
				$result = $video_store_db->select("`videoid` IN($videoids)", '`videoid`, `title`, `picpath`', '', '', '', 'videoid');
				if (is_array($result)) {
					//首先对$result按照$videos的videoid排序
					foreach ($videos as $_vid => $v) {
						$new_result[] = $result[$_vid];
					}
					unset($result, $_vid, $v);
					foreach ($new_result as $_k => $r) {
						$key = $_k+1;
						$picpath = $r['picpath'] ? $r['picpath'] : IMG_PATH.'nopic.gif';
						$list_str .= "<li class=\"ac\" id=\"video_{$field}_{$key}\"><div class=\"r1\"><img src=\"{$r['picpath']}\" onerror=\"".IMG_PATH."nopic.jpg\" width=\"132\" height=\"75\"><input type='text' name='{$field}_video[{$key}][title]' value='".$r['title']."' class=\"input-text ipt_box\"><input type='hidden' name='{$field}_video[{$key}][videoid]' value='{$r[videoid]}'><div class=\"r2\"><span class=\"l\"><label>".L('listorder')."</label><input type='text' name='{$field}_video[$key][listorder]' value='".$videos[$r['videoid']]['listorder']."' class=\"input-text\"></span><span class=\"r\"> <a href=\"javascript:remove_div('video_{$field}_{$key}')\">".L('delete')."</a></span></li>";
					}
				}
			}
		}
		$list_str .= "</ul></div>";
		$data = '';
		if (!defined('SWFOBJECT_INIT')) {
			$data .= '<script type="text/javascript" src="'.JS_PATH.'video/swfobject2.js"></script>';
			$data .= '<script type="text/javascript" src="'.JS_PATH.'video/vod2ckedit.js"></script>';
			define('SWFOBJECT_INIT', 1);
			$data .= '<SCRIPT LANGUAGE="JavaScript">

<!--

var js4swf = {

    onInit: function(list)

    {

        // 初始化时调用, 若 list.length > 0 代表有可续传文件

        // [{file}, {file}]

if(list.length > 0) {

    var length = list.length-1;

$("#list_name").html("'.L('file', '', 'video').'"+list[length].name+"'.L('failed_uplaod_choose_again', '', 'video').'");

}

        this.showMessage("init", list);

    },

    onSelect: function(files)

    {

        // 选中文件后调用, 返回文件列表

        // [{file}, {file}]

        this.showMessage("select", files);

    },

    onSid: function(evt)

    {

        // 获得 sid 后返回, 更新 sid 用 (key, sid, name, type, size)

$("#video_title").val(evt.name);
		var ku6vid = evt.vid;
		$.get(\'index.php\', {m:\'video\', c:\'vid\', a:\'check\', vid:ku6vid});
        this.showMessage("sid", evt);

    },

    onStart: function()

    {

        // 开始上传 (选择文件后自动开始)

        this.showMessage("start");

    },

    onCancel: function()

    {

        // 上传取消事件



        this.showMessage("cancel");

    },

    onProgress: function(evt)

    {

        // 上传进度事件 (bytesLoaded, bytesTotal, speed) m=1 时没有这事件

        this.showMessage("progress", evt);

    },

    onComplete: function(evt)

    {

        // 上传完成事件 (包含文件信息和完成后返回数据(data))
$("#vid").val(evt.vid);
var video_num = parseInt($("#key").val()) + 1;
var title = $("#video_title").val();
var vid = $("#vid").val();
var html = "<li id=\"video_'.$field.'_"+video_num+"\"><div class=\"r1\"><img src=\"'.IMG_PATH.'nopic.jpg\" width=\"132\" height=\"75\"><input type=\"text\" name=\"'.$field.'_video["+video_num+"][title]\" value=\""+title+"\" class=\"input-text\"><input type=\"hidden\" name=\"'.$field.'_video["+video_num+"][vid]\" value=\""+vid+"\"><div class=\"r2\"><span class=\"l\"><label>'.L('listorder').'</label><input type=\"text\" class=\"input-text\" name=\"'.$field.'_video["+video_num+"][listorder]\" value=\""+video_num+"\" ></span><span class=\"r\"> <a href=\"javascript:remove_div(\'video_'.$field.'_"+video_num+"\')\">'.L('delete').'</a></span></li>";

$("#video_'.$field.'_list").append(html);
$("#key").val(video_num);
$("#video_title").val("");

swfobject.embedSWF("'.$flash_info['flashurl'].'", "ku6uploader", "450", "45", "10.0.0", null, flashvars, params, attributes);


//document.getElementById("frm").submit();

        this.showMessage("complete", evt);

        

    },

    onWarn: function(evt)

    {

        // 报错事件 (key, message)

        //this.showMessage("warn", evt);

alert(evt.msg);

    },

    showMessage: function()

    {

        console.log(arguments);

    }

};

//-->

</SCRIPT>
<script type="text/javascript">
var flashvars = { m: "1", u: "'.$flash_info['userid'].'", ctime: "'.$flash_info['passport_ctime'].'", sig:"'.$flash_info['passport_sig'].'", c: "vms", t: "1", n: "js4swf", k: "190000" ,ms:"39",s: "8000000"};
var params = { allowScriptAccess: "always" , wmode: "transparent"};
var attributes = { };
//swfobject.embedSWF("http://player.ku6cdn.com/default/podcast/upload/201104261840/ku6uploader.swf", "ku6uploader", "450", "45", "10.0.0", null, flashvars, params, attributes);
swfobject.embedSWF("'.$flash_info['flashurl'].'", "ku6uploader", "450", "45", "10.0.0", null, flashvars, params, attributes);
</script>';
		}
		$authkey = upload_key("$upload_number,$upload_allowext,$isselectimage");
		$video_store_sel = defined('IN_ADMIN') ? '<div class="picBut cu video_btn" style="float:right; margin-top:10px;"><a herf="javascript:void(0);" onclick="javascript:video_store_select(\''.$field.'_videoes\', \''.L('choose_videoes').'\',\'video_'.$field.'_list\',change_videoes, \''.$_GET['pc_hash'].'\')"> '.L('videoes_store').' </a></div>' : '';
		$vms_str = $flash_info['allow_upload_to_vms'] ? '<label class="ib cu" style="width:125px"><input type="radio" name="channelid" value="2">'. L('upload_to_ku6vms', '', 'video').' </label>' : '';
		return $data.'<input name="info['.$field.']" type="hidden" value="1"><input type="hidden" id="key" value="'.$key.'"><fieldset class="blue pad-10">
        <legend>'.L('videoes_lists').'</legend><center><div class="onShow" id="nameTip">'.L('videoes_num').'</center><div id="videoes" class="picList">'.$list_str.'</div>
		</fieldset>
		
		<table width="100%" border="0" cellspacing="1" class="tbb">
    <tbody><tr>
      <td width="15%" height="40">'.L('select_upload_channel', '', 'video').'</td>
      <td height="40"><label class="ib cu" style="width:125px"><input type="radio" name="channelid" value="1" checked> '.L('upload_to_ku6').' </label>'.$vms_str.'
	  </td>
    </tr>
	<tr>
      <td width="15%" height="40"><div align="right" ><input class="input_style" type="text" value="'.L('video_title', '', 'video').'" name="video_title" id="video_title" size="10"></div></td>
      <td height="40">
	  '.$video_store_sel.'
	  <div id="ku6uploader"></div><BR><span id="list_name" style="color:red"></span></td><input type="hidden" id="vid" name="vid" value="">
    </tr>
  </tbody></table>';
	}
 } 
?>