<?php

/*
 * Copyright (C) xgcms.com
 */

class xgcms_cache extends base_model {
	private $num=0;
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'xgcms_cache';
		$this->primarykey = array('cacheid');
	}
	
	public function get_one($map) {
		$rs = $this->index_fetch($map,array('id'=>1),0,1);
		return $rs=$rs?array_pop($rs):false;
	}
	public function get_list($map=array(),$start=0,$limit=100,$order=array('id'=>-1)){
		$list = $this->index_fetch($map,$order,$start,$limit);
		$newlist=array();
		foreach($list as $v){
			$data=core::json_decode($v['data']);
			$data && $v=array_merge($v,$data);
            $newlist[$v['id']]=$v;
		}
		return $newlist;
	}
	public function xcreate($v,$cate){
		$total=$this->conf['pagesize']*$this->conf['cache_page'];
		//empty($total) && $total=100;
		$map=array('catid'=>$cate['catid']);
		empty($this->num) && $this->num=$this->index_count($map);
		$arr=array(
			     'cacheid'=>$v['catid'].'_'.$v['id'],
                 'modelid'=>$cate['modelid'],
                 'catid'=>$v['catid'],
                 'id'=>$v['id'],
				 'thumb'=>$v['thumb']?1:0,
				 'inputtime'=>$v['inputtime'],
				 'updatetime'=>$v['updatetime'],
				 'data'=>core::json_encode($v),
                );
		// hook xgcms_cache_model_xcreate_creat_before.php
		$this->create($arr);
		
		$this->num++;
		if($this->num>$total){
			$list=$this->index_fetch($map,array('id'=>-1),$total,1000);
			foreach($list as $c){
				$this->delete($c['cacheid']);
			}
		}
		// hook xgcms_cache_model_xcreate_end.php
	}
	public function xupdate($v){
		$rs=$this->read($v['catid'].'_'.$v['id']);
		if($rs){
			$rs['data']=core::json_encode($v);
			$this->update($rs);
		}	
		// hook xgcms_cache_model_xupdate_end.php
	}
	public function xdelete($cacheid,$cate){
		$map=array('catid'=>$cate['catid']);
		empty($this->num) && $this->num=$this->index_count($map);
		
		
	}
	// hook xgcms_cache_model_end.php
}

?>