<?php

/*
 * Copyright (C) xgcms.com
 */

class xgcms_category extends base_model {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'xgcms_category';
		$this->primarykey = array('catid');
		$this->maxcol = 'catid';
	}

	public function get_one($map) {
		$rs = $this->index_fetch($map,array('catid'=>1),0,1);
		return $rs=$rs?array_pop($rs):false;
	}
	public function get_list($map=array(),$start=0,$limit=200,$order=array('listorder'=>1)){
		$list = $this->index_fetch($map,$order,$start,$limit);
        misc::arrlist_change_key($list, 'catid');
		return $list;
	}
    public function xdelete($catid){
	   $cate=$this->read($catid);
	   $model=$this->xgcms_model->read($cate['modelid']);
	   $this->xgcms_content->set_model($cate['modelid']);
	   $this->xgcms_content->delete_by_catid($catid);
       $this->delete($catid);
	   $this->mcache->clear('cate',$catid);
    }
	public function xupdate($new){
		$this->update($new);
		$this->mcache->clear('cate',$new['catid']);
		// hook xgcms_category_model_xupdate_end.php
	}
	public function get_cate_by_catdir($catdir){
		$rs = $this->index_fetch(array('catdir'=>$catdir),array('catid'=>1),0,1);
		return $rs=$rs?array_pop($rs):false;
	}
	public function get_tree_category(){
		$newarr=array();
        $topcat=$this->get_list(array('module'=>'content','parentid'=>0));
        foreach($topcat as &$top){
              $newarr[]=$top;
              if($top['child']){
                  $newarr=$this->get_tree_son_category($newarr,$top['catid'],1);

              }
        }
        return $newarr;
	}
	
	private function get_tree_son_category($newarr=array(),$parentid,$deep=1){

		  $icon = array('│ ','├─ ','└─ ');

		  $nbsp = '&nbsp;&nbsp;&nbsp;';
		  for($i=1;$i<$deep;$i++){
                $nbsp.=$nbsp;
		  }

          $list= $this->get_list(array('module'=>'content','parentid'=>$parentid)); 
          
          $count=count($list);

          $cat_last=array_pop($list);
          $cat_last['catname']=$nbsp.$icon[2].$cat_last['catname'];
          
          if($count>1){
			  $deep++;
	          foreach($list as $v){
	              $icon_this= $count==1?$icon[2]:$icon[1];
	              $v['catname']=$nbsp.$icon_this.$v['catname'];  
	              $newarr[]=$v;
	              if($v['child']){
	                    $newarr=$this->get_tree_son_category($newarr,$v['catid'],$deep);   
	              }
	          }
         }
	 	  $newarr[]=$cat_last;
	      if($cat_last['child']){
	           $deep++;
	           $newarr=$this->get_tree_son_category($newarr,$cat_last['catid'],$deep);      
	      }
         return $newarr;
	}
	
	public function check_name(&$name){
	   if(empty($name)){
	       return '栏目名称不能为空';
	   }
       return ''; 
	}
	public function check_catdir(&$catdir){
	   if(empty($catdir)){
	       return '栏目英文目录不能为空';
	   }
       return ''; 
	}
	// 用来显示给用户
	public function format(&$v) {
		switch($v['type']){
		    case 0:
			    $v['type_fmt']='内部栏目';
				break;
				
			case 1:
			    $v['type_fmt']='<span class="green">单网页</span>';
				break;	
			case 2:
			    $v['type_fmt']='<span class="red">外部链接</span>';
				break;
			
		}
        if($v['setting']){
            $setting=core::json_decode($v['setting']);
            foreach($setting as $key=>$val){
                $v[$key]=$val;
            }
        }
        $v['modelname']='';
        if($v['type']==0&&$v['modelid']>0){
           $m=$this->xgcms_model->read($v['modelid']);  
           $m && $v['modelname']=$m['name'];
        }
		// hook xgcms_category_model_format_end.php
		// format data here.
	}
	public function category_fields($infos=array()){
		 $data=array('catname'=>'',
		            'type'=>0,
					'modelid'=>1,
					'url'=>$this->conf['cms_url'].'?list-index-catid-[catid].'.''.'htm',
					'catdir'=>'',
					'ismenu'=>0,
					'type'=>'',
					'ishtml'=>0,
					'content_ishtml'=>0,
					'url_list'=>$this->conf['cms_url'].'?list-index-catid-[catid]-page-[page].'.''.'htm',
					'url_show'=>$this->conf['cms_url'].'?show-index-catid-[catid]-id-[id]-page-[page].'.''.'htm',
					'meta_title'=>'',
                    'meta_keywords'=>'',
					'meta_description'=>'',
					'parentid'=>0,
					'accesson'=>0,
					'presentpoint'=>1,
					'defaultchargepoint'=>0,
					'paytype'=>0,
					'category_template'=>'0',
					'list_template'=>'0',
					'show_template'=>'0');
		// hook xgcms_category_model_category_fields_before.php
		if(empty($infos)) return $data;
		
		$newinfos=array();			
	    foreach($infos as $k=>$v){
			if(isset($data[$k])) $newinfos[$k]=$v; 
		}
		// hook xgcms_category_model_category_fields_end.php
		return $newinfos;
	}
    // hook xgcms_category_model_end.php
}
?>