<?php

/*
 * Copyright (C) xgcms.com
 */

class xgcms_content extends base_model {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->primarykey = array('catid','id');
		$this->maxcol = 'id';
	}
	
	public function get_one($map) {
		$rs = $this->index_fetch($map,array('id'=>1),0,1);
		return $rs=$rs?array_pop($rs):false;
	}
	public function get_list($map=array(),$start=0,$limit=100,$order=array('id'=>-1)){
		$list = $this->index_fetch($map,$order,$start,$limit);
        misc::arrlist_change_key($list, 'id');
		return $list;
	
	}
    public function xread($catid,$id){
        $info=$this->read($catid,$id);
        $data=$this->xgcms_content_data->read($id);
		$data && $info=array_merge($info,$data); 
        return   $info;
    }
    public function set_model($modelid){
		if(isset($this->modelid)&&$this->modelid==$modelid) return;
        $this->modelid=$modelid;
        $model = $this->xgcms_model->read($modelid);
        $this->xgcms_content->table = $model['tablename'];
        $this->xgcms_content_data->table=$this->table.'_data';
		// hook xgcms_content_model_set_model_end.php
    }
    public function add_content($data,$cate,$isimport=0){
		// hook xgcms_content_model_add_content_before.php
		
        $modelid = $this->modelid;
		require_once MODEL_LIB_PATH.'content_input.class.php';
       // require_once MODEL_LIB_PATH.'content_update.class.php';
        $fields=$this->xgcms_model_field->get_field_by_modelid($modelid);
		$content_input = new content_input($modelid,$fields,$this);
		$inputinfo = $content_input->get($data,$isimport);
        if(!is_array($inputinfo)) return $inputinfo;
		$systeminfo = $inputinfo['system'];
		$modelinfo = $inputinfo['model'];
        
        if(isset($data['inputtime']) && !is_numeric($data['inputtime'])) {
			$systeminfo['inputtime'] = strtotime($data['inputtime']);
		} elseif(!isset($data['inputtime'])) {
			$systeminfo['inputtime'] = $_SERVER['time'];
		} else {
			$systeminfo['inputtime'] = $data['inputtime'];
		}
        $systeminfo['updatetime'] = $_SERVER['time'];
        $systeminfo['status']=defined('IN_ADMIN')||$isimport?99:1;
        $systeminfo['sysadd']=defined('IN_ADMIN')?1:0;
        empty($systeminfo['description']) && $systeminfo['description']=utf8::substr(strip_tags($modelinfo['content']),0,200);
		
		// hook xgcms_content_model_add_content_create_before.php
		
        $id=$systeminfo['id']=$this->create($systeminfo);
        if($id){
			
			// hook xgcms_content_model_add_content_data_create_before.php
            $modelinfo['id']=$id;
            $this->xgcms_content_data->create($modelinfo);
			
			$systeminfo=$this->read($cate['catid'],$id);

			//推荐位
			if($data['posids']){
				$systeminfo['posids']=0;
				foreach($data['posids'] as $posid){
					$pos=$this->xgcms_pos->read(intval($posid));
					if($pos){
						$this->xgcms_pos_data->xcreate($systeminfo,$posid,$modelid,$pos['maxnum']);
						$systeminfo['posids']++;
					}
				}
			}
			$systeminfo['url']=$this->get_url($id,$cate,$data['inputtime']);
            $this->update($systeminfo);
			if($systeminfo['status']==99){
				  $systeminfo['modelid']=$modelid;
				  $this->xgcms_search->add_index($systeminfo);
				  $this->xgcms_cache->xcreate($systeminfo,$cate);
				  //生成静态
				  if($cate['content_ishtml']){
					  $this->xgcms_html->build_show_html_by_url($id,$cate,$systeminfo['inputtime'],$systeminfo['pagenum']);
				  }
			}
			$cate=$this->xgcms_category->read($cate['catid']);
			$cate['items']++;
			$this->xgcms_category->xupdate($cate);
			// hook xgcms_content_model_add_content_end.php
        }
        return $id;   
    }
	public function edit_content($id,$data,$cate,$isimport=0){
		// hook xgcms_content_model_edit_content_before.php
        $modelid = $this->modelid;
		require_once MODEL_LIB_PATH.'content_input.class.php';
        $fields=$this->xgcms_model_field->get_field_by_modelid($modelid);
		$content_input = new content_input($modelid,$fields,$this);
		$inputinfo = $content_input->get($data,$isimport);
        if(!is_array($inputinfo)) return $inputinfo;
		
		$systeminfo = $inputinfo['system'];
		$modelinfo = $inputinfo['model'];
        $oldinfo=$this->read($cate['catid'],$id);
		
		$systeminfo['updatetime'] = $_SERVER['time'];
        $systeminfo=array_merge($oldinfo,$systeminfo);
		$systeminfo['url']=$this->get_url($id,$cate,$systeminfo['inputtime']);
		
        //推荐位
		if($data['posids']){
			$this->xgcms_pos_data->delete_by_id($id);
			$systeminfo['posids']=0;
			foreach($data['posids'] as $posid){
				$pos=$this->xgcms_pos->read(intval($posid));
				if($pos){
					$this->xgcms_pos_data->xcreate($systeminfo,$posid,$modelid,$pos['maxnum']);
					$systeminfo['posids']++;
				}
			}
		}
		
		// hook xgcms_content_model_edit_content_update_before.php
		
        $this->update($systeminfo);
            
        $modelinfo['id']=$id;

        $rs=$this->xgcms_content_data->update($modelinfo);
		$systeminfo=$this->read($cate['catid'],$id);
		if($systeminfo['status']==99){
			  $systeminfo['modelid']=$modelid;
			  $this->xgcms_search->add_index($systeminfo);
			  $this->xgcms_cache->xupdate($systeminfo);
			  
			  $this->conf['html_cache'] && $this->clear_cache($systeminfo['url']);
			  
			  if($cate['content_ishtml']){
					 $this->xgcms_html->build_show_html_by_url($id,$cate,$systeminfo['inputtime'],$systeminfo['pagenum']);
			  }
			  // hook xgcms_content_model_edit_content_end.php
		}
        return  $rs;   
    }
    public function get_url($id,$cate,$time='',$page=1){
        global $conf;
        $urlrule=$cate['url_show'];
        if(empty($urlrule)){
            $url=$conf['cms_url'].'?show-index-catid-'.$cate['catid'].'-id-'.$id.'-page-'.$page.'.htm';
        }else{
			empty($time) && $time=$_SERVER['time'];
			$year=date('Y',$time);
			$month=date('m',$time);
			$day=date('d',$time);
			if($page){
                $url=str_replace(array('[catdir]','[catid]','[id]','[page]','[year]','[month]','[day]'),array($cate['catdir'],$cate['catid'],$id,$page,$year,$month,$day),$urlrule);
			}else{
				$url=str_replace(array('[catdir]','[catid]','[id]','[year]','[month]','[day]'),array($cate['catdir'],$cate['catid'],$id,$year,$month,$day),$urlrule);
			}
 
        }
		// hook xgcms_content_model_get_url_end.php
        return $url;
        
    }
	public function delete_by_catid($catid){
		// hook xgcms_content_model_delete_by_catid_before.php
		$db = $this->db;
		$tablepre = $db->tablepre;
		$table = $tablepre.$this->table;
		$table_data=$tablepre.$this->xgcms_content_data->table;
		$db->query("DELETE $table,$table_data FROM $table LEFT JOIN $table_data on $table.id=$table_data.id WHERE $table.catid=$catid;");
	}
	public function xdelete($cate,$id){
		// hook xgcms_content_model_xdelete_before.php
		$this->xgcms_category->format($cate);
		if($cate['content_ishtml']){
                $data=$this->xgcms_content->read($cate['catid'],$id);
				$this->xgcms_html->delete_show_html($id,$cate,$data['inputtime'],$data['pagenum']);
		}
		$this->delete($cate['catid'],$id);
		$this->xgcms_content_data->delete($id);
		$search=$this->xgcms_search->get_one(array('catid'=>$cate['catid'],'id'=>$id));
		if($search){
			$this->xgcms_search->delete($search['searchid']);
		}
		$this->xgcms_cache->delete($cate['catid'].'_'.$id);
		// hook xgcms_content_model_xdelete_end.php
	}
    public function html_safe($doc) {
		return xn_html_safe::filter($doc);
	}
        
	// 用来显示给用
	public function format(&$v,$cate='') {
	   empty($cate) && $cate=$this->mcache->read('cate',$v['catid']);
       $v['catname']=$cate['catname'];
	   $v['caturl']=$cate['url'];
       $v['updatetime_fmt']=date('Y-m-d H:i',$v['updatetime']);
	   $v['inputtime_fmt']=date('Y-m-d H:i',$v['inputtime']);
	   $v['status_fmt']=$v['status']==99?'<span class="green">已审核</span>':($v['status']==1?'未审核':'<span class="red">已退稿</span>');
	   empty($v['copyfrom']) && $v['copyfrom']=$this->conf['app_name'];
	   $v['status']!=99 && $v['url']=$this->conf['cms_url'].'?show-index-catid-'.$v['catid'].'-id-'.$v['id'].'.'.'htm';
	  // empty($v['thumb']) && $v['thumb']=$this->conf['static_url'].'images/cms/nopic.gif';
	   // hook xgcms_content_model_format_end.php
	}
	private function clear_cache($url){
		$url_md5=md5($url).'.html';
		$path=$this->conf['html_cache_path'].'show/index/';
		$dir1=utf8::substr($url_md5,0,2);
		$dir2=utf8::substr($url_md5,2,2);
		$dir = $path.$dir1.'/'.$dir2.'/';
		$file=$dir.$url_md5;
		is_file($file) && unlink($file);
		// hook xgcms_content_model_clear_cache_end.php
	}
    // hook xgcms_content_model_end.php
}
?>